// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.selection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('org_analyzer.view.geo');
goog.require('org_analyzer.view.dom');
org_analyzer.view.selection.empty_rectangle_selection_state = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$mousedown_QMARK_,false,cljs.core.cst$kw$start_DASH_pos,null,cljs.core.cst$kw$current_DASH_pos,null,cljs.core.cst$kw$offset,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null),cljs.core.cst$kw$relative_DASH_bounds,org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$0(),cljs.core.cst$kw$global_DASH_bounds,org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$0()], null);
org_analyzer.view.selection.make_rectangle = (function org_analyzer$view$selection$make_rectangle(var_args){
var G__19165 = arguments.length;
switch (G__19165) {
case 4:
return org_analyzer.view.selection.make_rectangle.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return org_analyzer.view.selection.make_rectangle.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

org_analyzer.view.selection.make_rectangle.cljs$core$IFn$_invoke$arity$4 = (function (x1,y1,x2,y2){
return org_analyzer.view.selection.make_rectangle.cljs$core$IFn$_invoke$arity$6(x1,y1,x2,y2,(0),(0));
});

org_analyzer.view.selection.make_rectangle.cljs$core$IFn$_invoke$arity$6 = (function (x1,y1,x2,y2,offset_x,offset_y){
var left = (function (){var x__4222__auto__ = x1;
var y__4223__auto__ = x2;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})();
var top = (function (){var x__4222__auto__ = y1;
var y__4223__auto__ = y2;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})();
var right = (function (){var x__4219__auto__ = x1;
var y__4220__auto__ = x2;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var bottom = (function (){var x__4219__auto__ = y1;
var y__4220__auto__ = y2;
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var w = (right - left);
var h = (bottom - top);
return org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$4((left - offset_x),(top - offset_y),w,h);
});

org_analyzer.view.selection.make_rectangle.cljs$lang$maxFixedArity = 6;

org_analyzer.view.selection.with_selection_bounds = (function org_analyzer$view$selection$with_selection_bounds(selection_state){
var map__19167 = selection_state;
var map__19167__$1 = (((((!((map__19167 == null))))?(((((map__19167.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19167.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19167):map__19167);
var vec__19168 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19167__$1,cljs.core.cst$kw$start_DASH_pos);
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19168,(0),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19168,(1),null);
var vec__19171 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19167__$1,cljs.core.cst$kw$current_DASH_pos);
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19171,(0),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19171,(1),null);
var vec__19174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19167__$1,cljs.core.cst$kw$offset);
var o_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19174,(0),null);
var o_y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19174,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(selection_state,cljs.core.cst$kw$global_DASH_bounds,org_analyzer.view.selection.make_rectangle.cljs$core$IFn$_invoke$arity$4(x1,y1,x2,y2),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$relative_DASH_bounds,org_analyzer.view.selection.make_rectangle.cljs$core$IFn$_invoke$arity$6(x1,y1,x2,y2,o_x,o_y)], 0));
});
org_analyzer.view.selection.on_mouse_down_track_drag = (function org_analyzer$view$selection$on_mouse_down_track_drag(state,evt){
var pos = org_analyzer.view.dom.mouse_position(evt);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (pos){
return (function (p1__19178_SHARP_){
return org_analyzer.view.selection.with_selection_bounds(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__19178_SHARP_,cljs.core.cst$kw$mousedown_QMARK_,true,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$start_DASH_pos,pos,cljs.core.cst$kw$current_DASH_pos,pos], 0)));
});})(pos))
);
});
org_analyzer.view.selection.on_mouse_up_track_drag = (function org_analyzer$view$selection$on_mouse_up_track_drag(state,evt){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$mousedown_QMARK_,false);
});
org_analyzer.view.selection.on_mouse_move_track_drag = (function org_analyzer$view$selection$on_mouse_move_track_drag(state,evt){
var map__19180 = cljs.core.deref(state);
var map__19180__$1 = (((((!((map__19180 == null))))?(((((map__19180.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19180.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19180):map__19180);
var mousedown_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19180__$1,cljs.core.cst$kw$mousedown_QMARK_);
if(cljs.core.truth_(mousedown_QMARK_)){
var pos = org_analyzer.view.dom.mouse_position(evt);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (pos,map__19180,map__19180__$1,mousedown_QMARK_){
return (function (p1__19179_SHARP_){
return org_analyzer.view.selection.with_selection_bounds(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__19179_SHARP_,cljs.core.cst$kw$current_DASH_pos,pos));
});})(pos,map__19180,map__19180__$1,mousedown_QMARK_))
);
} else {
return null;
}
});
org_analyzer.view.selection.drag_mouse_handlers = (function org_analyzer$view$selection$drag_mouse_handlers(var_args){
var args__4736__auto__ = [];
var len__4730__auto___19193 = arguments.length;
var i__4731__auto___19194 = (0);
while(true){
if((i__4731__auto___19194 < len__4730__auto___19193)){
args__4736__auto__.push((arguments[i__4731__auto___19194]));

var G__19195 = (i__4731__auto___19194 + (1));
i__4731__auto___19194 = G__19195;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return org_analyzer.view.selection.drag_mouse_handlers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

org_analyzer.view.selection.drag_mouse_handlers.cljs$core$IFn$_invoke$arity$variadic = (function (state,p__19187){
var map__19188 = p__19187;
var map__19188__$1 = (((((!((map__19188 == null))))?(((((map__19188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19188.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19188):map__19188);
var on_selection_start = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19188__$1,cljs.core.cst$kw$on_DASH_selection_DASH_start);
var on_selection_end = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19188__$1,cljs.core.cst$kw$on_DASH_selection_DASH_end);
var on_selection_change = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19188__$1,cljs.core.cst$kw$on_DASH_selection_DASH_change);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$ref,((function (map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change){
return (function (el){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$offset,(cljs.core.truth_(el)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [el.offsetLeft,el.offsetTop], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null)));
});})(map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change))
,cljs.core.cst$kw$on_DASH_mouse_DASH_down,((function (map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change){
return (function (p1__19182_SHARP_){
org_analyzer.view.selection.on_mouse_down_track_drag(state,p1__19182_SHARP_);

if(cljs.core.fn_QMARK_(on_selection_start)){
var G__19190 = cljs.core.deref(state);
return (on_selection_start.cljs$core$IFn$_invoke$arity$1 ? on_selection_start.cljs$core$IFn$_invoke$arity$1(G__19190) : on_selection_start.call(null,G__19190));
} else {
return null;
}
});})(map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change))
,cljs.core.cst$kw$on_DASH_mouse_DASH_up,((function (map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change){
return (function (p1__19183_SHARP_){
org_analyzer.view.selection.on_mouse_up_track_drag(state,p1__19183_SHARP_);

if(cljs.core.fn_QMARK_(on_selection_end)){
var G__19191 = cljs.core.deref(state);
return (on_selection_end.cljs$core$IFn$_invoke$arity$1 ? on_selection_end.cljs$core$IFn$_invoke$arity$1(G__19191) : on_selection_end.call(null,G__19191));
} else {
return null;
}
});})(map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change))
,cljs.core.cst$kw$on_DASH_mouse_DASH_move,((function (map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change){
return (function (p1__19184_SHARP_){
org_analyzer.view.selection.on_mouse_move_track_drag(state,p1__19184_SHARP_);

if(cljs.core.fn_QMARK_(on_selection_change)){
var G__19192 = cljs.core.deref(state);
return (on_selection_change.cljs$core$IFn$_invoke$arity$1 ? on_selection_change.cljs$core$IFn$_invoke$arity$1(G__19192) : on_selection_change.call(null,G__19192));
} else {
return null;
}
});})(map__19188,map__19188__$1,on_selection_start,on_selection_end,on_selection_change))
], null);
});

org_analyzer.view.selection.drag_mouse_handlers.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
org_analyzer.view.selection.drag_mouse_handlers.cljs$lang$applyTo = (function (seq19185){
var G__19186 = cljs.core.first(seq19185);
var seq19185__$1 = cljs.core.next(seq19185);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__19186,seq19185__$1);
});

