// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.geo');
goog.require('cljs.core');
goog.require('cljs.core.constants');
org_analyzer.view.geo.pos_PLUS_ = (function org_analyzer$view$geo$pos_PLUS_(p__13233,p__13234){
var vec__13235 = p__13233;
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13235,(0),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13235,(1),null);
var vec__13238 = p__13234;
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13238,(0),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13238,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x1 + x2),(y1 + y2)], null);
});
org_analyzer.view.geo.pos_ = (function org_analyzer$view$geo$pos_(p__13241,p__13242){
var vec__13243 = p__13241;
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13243,(0),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13243,(1),null);
var vec__13246 = p__13242;
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13246,(0),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13246,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x1 - x2),(y1 - y2)], null);
});
org_analyzer.view.geo.valid_rect_QMARK_ = (function org_analyzer$view$geo$valid_rect_QMARK_(p__13249){
var vec__13250 = p__13249;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13250,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13250,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13250,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13250,(3),null);
return (((w >= (0))) && ((h >= (0))));
});
org_analyzer.view.geo.rect = (function org_analyzer$view$geo$rect(var_args){
var G__13254 = arguments.length;
switch (G__13254) {
case 0:
return org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$0();

break;
case 2:
return org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$0 = (function (){
return org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$4((0),(0),(0),(0));
});

org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$2 = (function (w,h){
return org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$4((0),(0),w,h);
});

org_analyzer.view.geo.rect.cljs$core$IFn$_invoke$arity$4 = (function (x,y,w,h){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y,w,h], null);
});

org_analyzer.view.geo.rect.cljs$lang$maxFixedArity = 4;

org_analyzer.view.geo.contains_point_QMARK_ = (function org_analyzer$view$geo$contains_point_QMARK_(p__13256,p__13257){
var vec__13258 = p__13256;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13258,(3),null);
var vec__13261 = p__13257;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13261,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13261,(1),null);
return (((((x < px)) && ((px < (x + w))))) && ((((y < py)) && ((py < (y + h))))));
});
/**
 * does rect-1 (first arg) fully contain rect-2 (second arg)?
 */
org_analyzer.view.geo.contains_rect_QMARK_ = (function org_analyzer$view$geo$contains_rect_QMARK_(p__13264,p__13265){
var vec__13266 = p__13264;
var l1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13266,(0),null);
var t1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13266,(1),null);
var w1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13266,(2),null);
var h1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13266,(3),null);
var vec__13269 = p__13265;
var l2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13269,(0),null);
var t2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13269,(1),null);
var w2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13269,(2),null);
var h2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13269,(3),null);
var r1 = (l1 + w1);
var b1 = (t1 + h1);
var r2 = (l2 + w2);
var b2 = (t2 + h2);
return (((l1 <= l2)) && ((t1 <= t2)) && ((r2 <= r1)) && ((b2 <= b1)));
});
org_analyzer.view.geo.translate = (function org_analyzer$view$geo$translate(p__13272,p__13273){
var vec__13274 = p__13272;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13274,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13274,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13274,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13274,(3),null);
var vec__13277 = p__13273;
var px = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13277,(0),null);
var py = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13277,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x + px),(y + py),w,h], null);
});
org_analyzer.view.geo.align = (function org_analyzer$view$geo$align(rect,p1,p2){
return org_analyzer.view.geo.translate(rect,org_analyzer.view.geo.pos_(p2,p1));
});
org_analyzer.view.geo.translate_to_fit_in = (function org_analyzer$view$geo$translate_to_fit_in(p__13280,p__13281){
var vec__13282 = p__13280;
var x1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13282,(0),null);
var y1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13282,(1),null);
var w1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13282,(2),null);
var h1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13282,(3),null);
var smaller_rect = vec__13282;
var vec__13285 = p__13281;
var x2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13285,(0),null);
var y2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13285,(1),null);
var w2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13285,(2),null);
var h2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13285,(3),null);
var larger_rect = vec__13285;
var r1 = (x1 + w1);
var b1 = (y1 + h1);
var r2 = (x2 + w2);
var b2 = (y2 + h2);
var x1__$1 = (((x1 < x2))?x2:(((r1 > r2))?(x1 - (r1 - r2)):x1
));
var y1__$1 = (((y1 < y2))?y2:(((b1 > b2))?(y1 - (b1 - b2)):y1
));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [x1__$1,y1__$1,w1,h1], null);
});
org_analyzer.view.geo.top = (function org_analyzer$view$geo$top(p__13288){
var vec__13289 = p__13288;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13289,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13289,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13289,(2),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13289,(3),null);
return y;
});
org_analyzer.view.geo.left = (function org_analyzer$view$geo$left(p__13292){
var vec__13293 = p__13292;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(2),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13293,(3),null);
return x;
});
org_analyzer.view.geo.right = (function org_analyzer$view$geo$right(p__13296){
var vec__13297 = p__13296;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13297,(3),null);
return (x + w);
});
org_analyzer.view.geo.bottom = (function org_analyzer$view$geo$bottom(p__13300){
var vec__13301 = p__13300;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13301,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13301,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13301,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13301,(3),null);
return (y + h);
});
org_analyzer.view.geo.center = (function org_analyzer$view$geo$center(p__13304){
var vec__13305 = p__13304;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13305,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13305,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13305,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13305,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x + (w / (2))),(y + (h / (2)))], null);
});
org_analyzer.view.geo.top_left = (function org_analyzer$view$geo$top_left(r){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.left(r),org_analyzer.view.geo.top(r)], null);
});
org_analyzer.view.geo.left_center = (function org_analyzer$view$geo$left_center(p__13308){
var vec__13309 = p__13308;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13309,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13309,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13309,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13309,(3),null);
var r = vec__13309;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.left(r),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(y + (h / (2)))], null)], null);
});
org_analyzer.view.geo.bottom_left = (function org_analyzer$view$geo$bottom_left(r){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.left(r),org_analyzer.view.geo.bottom(r)], null);
});
org_analyzer.view.geo.top_center = (function org_analyzer$view$geo$top_center(p__13312){
var vec__13313 = p__13312;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13313,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13313,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13313,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13313,(3),null);
var r = vec__13313;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x + (w / (2))),org_analyzer.view.geo.top(r)], null);
});
org_analyzer.view.geo.top_right = (function org_analyzer$view$geo$top_right(r){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.right(r),org_analyzer.view.geo.top(r)], null);
});
org_analyzer.view.geo.right_center = (function org_analyzer$view$geo$right_center(p__13316){
var vec__13317 = p__13316;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13317,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13317,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13317,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13317,(3),null);
var r = vec__13317;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.right(r),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(y + (h / (2)))], null)], null);
});
org_analyzer.view.geo.bottom_right = (function org_analyzer$view$geo$bottom_right(r){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.right(r),org_analyzer.view.geo.bottom(r)], null);
});
org_analyzer.view.geo.bottom_center = (function org_analyzer$view$geo$bottom_center(p__13320){
var vec__13321 = p__13320;
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13321,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13321,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13321,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13321,(3),null);
var r = vec__13321;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x + (w / (2))),org_analyzer.view.geo.bottom(r)], null);
});
org_analyzer.view.geo.area = (function org_analyzer$view$geo$area(p__13324){
var vec__13325 = p__13324;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13325,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13325,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13325,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13325,(3),null);
return (w * h);
});
