// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.dom');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('org_analyzer.view.geo');
org_analyzer.view.dom.scrolled_window_bounds = (function org_analyzer$view$dom$scrolled_window_bounds(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [document.documentElement.scrollLeft,document.documentElement.scrollTop,document.documentElement.clientWidth,document.documentElement.clientHeight], null);
});
org_analyzer.view.dom.screen_relative_bounds = (function org_analyzer$view$dom$screen_relative_bounds(el){
var b_rect = el.getBoundingClientRect();
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [b_rect.left,b_rect.top,b_rect.width,b_rect.height], null);
});
org_analyzer.view.dom.global_bounds = (function org_analyzer$view$dom$global_bounds(el){
return org_analyzer.view.geo.translate(org_analyzer.view.dom.screen_relative_bounds(el),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [window.scrollX,window.scrollY], null));
});
org_analyzer.view.dom.mouse_position = (function org_analyzer$view$dom$mouse_position(var_args){
var args__4736__auto__ = [];
var len__4730__auto___13338 = arguments.length;
var i__4731__auto___13339 = (0);
while(true){
if((i__4731__auto___13339 < len__4730__auto___13338)){
args__4736__auto__.push((arguments[i__4731__auto___13339]));

var G__13340 = (i__4731__auto___13339 + (1));
i__4731__auto___13339 = G__13340;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return org_analyzer.view.dom.mouse_position.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

org_analyzer.view.dom.mouse_position.cljs$core$IFn$_invoke$arity$variadic = (function (event,p__13332){
var map__13333 = p__13332;
var map__13333__$1 = (((((!((map__13333 == null))))?(((((map__13333.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13333.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__13333):map__13333);
var relative_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__13333__$1,cljs.core.cst$kw$relative_QMARK_);
var client_x = event.clientX;
var client_y = event.clientY;
if(cljs.core.truth_(client_x)){
var target = event.target;
var doc = (function (){var or__4131__auto__ = (function (){var and__4120__auto__ = target;
if(cljs.core.truth_(and__4120__auto__)){
return target.ownerDocument;
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return document;
}
})();
var doc_el = (function (){var and__4120__auto__ = doc;
if(cljs.core.truth_(and__4120__auto__)){
return doc.documentElement;
} else {
return and__4120__auto__;
}
})();
var body = doc.body;
var scroll_left = (function (){var or__4131__auto__ = doc_el.scrollLeft;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = body.scrollLeft;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (0);
}
}
})();
var scroll_top = (function (){var or__4131__auto__ = doc_el.scrollTop;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = body.scrollTop;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (0);
}
}
})();
var client_left = (function (){var or__4131__auto__ = doc_el.clientLeft;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = body.clientLeft;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (0);
}
}
})();
var client_top = (function (){var or__4131__auto__ = doc_el.clientTop;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
var or__4131__auto____$1 = body.clientTop;
if(cljs.core.truth_(or__4131__auto____$1)){
return or__4131__auto____$1;
} else {
return (0);
}
}
})();
var vec__13335 = ((cljs.core.not(relative_QMARK_))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null):(function (){var target__$1 = target;
var offset_x = (0);
var offset_y = (0);
while(true){
if(cljs.core.not(target__$1)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(- offset_x),(- offset_y)], null);
} else {
var G__13341 = target__$1.offsetParent;
var G__13342 = (offset_x + target__$1.offsetLeft);
var G__13343 = (offset_y + target__$1.offsetTop);
target__$1 = G__13341;
offset_x = G__13342;
offset_y = G__13343;
continue;
}
break;
}
})());
var offset_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13335,(0),null);
var offset_y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13335,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [((client_x + scroll_left) + offset_x),((client_y + scroll_top) + offset_y)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
}
});

org_analyzer.view.dom.mouse_position.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
org_analyzer.view.dom.mouse_position.cljs$lang$applyTo = (function (seq13330){
var G__13331 = cljs.core.first(seq13330);
var seq13330__$1 = cljs.core.next(seq13330);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13331,seq13330__$1);
});

org_analyzer.view.dom.align_element_BANG_ = (function org_analyzer$view$dom$align_element_BANG_(var_args){
var G__13345 = arguments.length;
switch (G__13345) {
case 3:
return org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (how,el,to_point){
return org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$4(how,el,to_point,(0));
});

org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (how,el,to_point,offset){
return org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$5(how,el,to_point,offset,true);
});

org_analyzer.view.dom.align_element_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (how,el,to_point,offset,keep_inside_view_bounds_QMARK_){
var vec__13346 = (function (){var G__13355 = how;
var G__13355__$1 = (((G__13355 instanceof cljs.core.Keyword))?G__13355.fqn:null);
switch (G__13355__$1) {
case "top":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.bottom_center,(0),(- offset)], null);

break;
case "bottom":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.top_center,(0),offset], null);

break;
case "left":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.right_center,(- offset),(0)], null);

break;
case "right":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.geo.left_center,offset,(0)], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13355__$1)].join('')));

}
})();
var rect_point_fn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13346,(0),null);
var o_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13346,(1),null);
var o_y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13346,(2),null);
var bounds = org_analyzer.view.dom.screen_relative_bounds(el);
var vec__13349 = org_analyzer.view.geo.align(bounds,(rect_point_fn.cljs$core$IFn$_invoke$arity$1 ? rect_point_fn.cljs$core$IFn$_invoke$arity$1(bounds) : rect_point_fn.call(null,bounds)),to_point);
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13349,(3),null);
var x__$1 = (o_x + x);
var y__$1 = (o_y + y);
var vec__13352 = (cljs.core.truth_(keep_inside_view_bounds_QMARK_)?(function (){var vec__13356 = (cljs.core.truth_(keep_inside_view_bounds_QMARK_)?org_analyzer.view.dom.scrolled_window_bounds():null);
var win_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(0),null);
var win_y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(1),null);
var win_w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(2),null);
var win_h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13356,(3),null);
var screen_window_bounds = vec__13356;
var r = (x__$1 + w);
var b = (y__$1 + h);
var win_r = (win_x + win_w);
var win_b = (win_y + win_h);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((x__$1 < (0)))?(0):(((r > win_r))?(x__$1 - (r - win_r)):x__$1
)),(((y__$1 < (0)))?(0):(((b > win_b))?(y__$1 - (b - win_b)):y__$1
))], null);
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x__$1,y__$1], null));
var x__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13352,(0),null);
var y__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13352,(1),null);
el.style.left = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$2),"px"].join('');

return el.style.top = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(y__$2),"px"].join('');
});

org_analyzer.view.dom.align_element_BANG_.cljs$lang$maxFixedArity = 5;

org_analyzer.view.dom.select_element = (function org_analyzer$view$dom$select_element(el){
document.getSelection().empty();

var r = document.createRange();
r.selectNode(el);

return document.getSelection().addRange(r);
});
