// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.clock_list');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('org_analyzer.view.util');
goog.require('org_analyzer.view.timeline');
goog.require('org_analyzer.view.dom');
goog.require('cljs.pprint');
goog.require('reagent.core');
goog.require('reagent.ratom');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('cljs_http.client');
org_analyzer.view.clock_list.open_org_file = (function org_analyzer$view$clock_list$open_org_file(org_file,heading){
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic("/open-org-file",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$file,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([org_file], 0)),cljs.core.cst$kw$heading,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([heading], 0))], null)], null)], 0));
});
org_analyzer.view.clock_list.analyze_clocks = (function org_analyzer$view$clock_list$analyze_clocks(days,clocks_by_day){
var clocks_avg = (function org_analyzer$view$clock_list$analyze_clocks_$_clocks_avg(clocks_by_sth){
return org_analyzer.view.util.print_duration_mins(cljs.core.quot(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.sum_clocks_mins,cljs.core.second),clocks_by_sth)),cljs.core.count(clocks_by_sth)));
});
var weeks = cljs.core.group_by((function (p1__19736_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$year.cljs$core$IFn$_invoke$arity$1(p1__19736_SHARP_)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$week.cljs$core$IFn$_invoke$arity$1(p1__19736_SHARP_))].join('');
}),days);
var clocks_by_week = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4523__auto__ = ((function (weeks){
return (function org_analyzer$view$clock_list$analyze_clocks_$_iter__19738(s__19739){
return (new cljs.core.LazySeq(null,((function (weeks){
return (function (){
var s__19739__$1 = s__19739;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19739__$1);
if(temp__5457__auto__){
var s__19739__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19739__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19739__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19741 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19740 = (0);
while(true){
if((i__19740 < size__4522__auto__)){
var vec__19742 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19740);
var week_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19742,(0),null);
var days__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19742,(1),null);
var clocks = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__19740,vec__19742,week_id,days__$1,c__4521__auto__,size__4522__auto__,b__19741,s__19739__$2,temp__5457__auto__,weeks){
return (function (p1__19737_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(clocks_by_day,cljs.core.cst$kw$date.cljs$core$IFn$_invoke$arity$1(p1__19737_SHARP_));
});})(i__19740,vec__19742,week_id,days__$1,c__4521__auto__,size__4522__auto__,b__19741,s__19739__$2,temp__5457__auto__,weeks))
,days__$1));
cljs.core.chunk_append(b__19741,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [week_id,clocks], null));

var G__19748 = (i__19740 + (1));
i__19740 = G__19748;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19741),org_analyzer$view$clock_list$analyze_clocks_$_iter__19738(cljs.core.chunk_rest(s__19739__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19741),null);
}
} else {
var vec__19745 = cljs.core.first(s__19739__$2);
var week_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19745,(0),null);
var days__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19745,(1),null);
var clocks = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__19745,week_id,days__$1,s__19739__$2,temp__5457__auto__,weeks){
return (function (p1__19737_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(clocks_by_day,cljs.core.cst$kw$date.cljs$core$IFn$_invoke$arity$1(p1__19737_SHARP_));
});})(vec__19745,week_id,days__$1,s__19739__$2,temp__5457__auto__,weeks))
,days__$1));
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [week_id,clocks], null),org_analyzer$view$clock_list$analyze_clocks_$_iter__19738(cljs.core.rest(s__19739__$2)));
}
} else {
return null;
}
break;
}
});})(weeks))
,null,null));
});})(weeks))
;
return iter__4523__auto__(weeks);
})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$average_DASH_day_DASH_duration,clocks_avg(clocks_by_day),cljs.core.cst$kw$average_DASH_week_DASH_duration,clocks_avg(clocks_by_week),cljs.core.cst$kw$n_DASH_weeks,cljs.core.count(weeks)], null);
});
org_analyzer.view.clock_list.clock_list = (function org_analyzer$view$clock_list$clock_list(clocks_with_id_and_duration,highlighted_entries){
var current_highlighted_entries = cljs.core.deref(highlighted_entries);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$clock_DASH_list,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody,cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__4523__auto__ = ((function (current_highlighted_entries){
return (function org_analyzer$view$clock_list$clock_list_$_iter__19750(s__19751){
return (new cljs.core.LazySeq(null,((function (current_highlighted_entries){
return (function (){
var s__19751__$1 = s__19751;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19751__$1);
if(temp__5457__auto__){
var s__19751__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19751__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19751__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19753 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19752 = (0);
while(true){
if((i__19752 < size__4522__auto__)){
var map__19754 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19752);
var map__19754__$1 = (((((!((map__19754 == null))))?(((((map__19754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19754):map__19754);
var vec__19755 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19754__$1,cljs.core.cst$kw$clocks);
var map__19758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19755,(0),null);
var map__19758__$1 = (((((!((map__19758 == null))))?(((((map__19758.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19758.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19758):map__19758);
var clock = map__19758__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19758__$1,cljs.core.cst$kw$name);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19758__$1,cljs.core.cst$kw$tags);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19758__$1,cljs.core.cst$kw$path);
var org_file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19758__$1,cljs.core.cst$kw$org_DASH_file);
var location = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19754__$1,cljs.core.cst$kw$location);
var duration = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19754__$1,cljs.core.cst$kw$duration);
var highlighted_QMARK_ = (current_highlighted_entries.cljs$core$IFn$_invoke$arity$1 ? current_highlighted_entries.cljs$core$IFn$_invoke$arity$1(location) : current_highlighted_entries.call(null,location));
var on_mouse_over = ((function (i__19752,highlighted_QMARK_,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
return cljs.core.reset_BANG_(highlighted_entries,cljs.core.PersistentHashSet.createAsIfByAssoc([location]));
});})(i__19752,highlighted_QMARK_,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
;
var on_mouse_out = ((function (i__19752,highlighted_QMARK_,on_mouse_over,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
return cljs.core.reset_BANG_(highlighted_entries,cljs.core.PersistentHashSet.EMPTY);
});})(i__19752,highlighted_QMARK_,on_mouse_over,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
;
var attrs = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$on_DASH_mouse_DASH_over,on_mouse_over,cljs.core.cst$kw$on_DASH_mouse_DASH_out,on_mouse_out,cljs.core.cst$kw$class,(cljs.core.truth_(highlighted_QMARK_)?"highlighted":"")], null);
cljs.core.chunk_append(b__19753,cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$name,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([attrs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (i__19752,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
return org_analyzer.view.clock_list.open_org_file(org_file,name);
});})(i__19752,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
], null)], 0)),org_analyzer.view.util.parse_all_org_links(name)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$duration,attrs,org_analyzer.view.util.print_duration_mins(duration)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$path,attrs,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(" > ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.parse_all_org_links,clojure.string.trim),path))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$tags$md_DASH_chips,attrs,(function (){var iter__4523__auto__ = ((function (i__19752,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function org_analyzer$view$clock_list$clock_list_$_iter__19750_$_iter__19761(s__19762){
return (new cljs.core.LazySeq(null,((function (i__19752,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
var s__19762__$1 = s__19762;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__19762__$1);
if(temp__5457__auto____$1){
var s__19762__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__19762__$2)){
var c__4521__auto____$1 = cljs.core.chunk_first(s__19762__$2);
var size__4522__auto____$1 = cljs.core.count(c__4521__auto____$1);
var b__19764 = cljs.core.chunk_buffer(size__4522__auto____$1);
if((function (){var i__19763 = (0);
while(true){
if((i__19763 < size__4522__auto____$1)){
var tag = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto____$1,i__19763);
cljs.core.chunk_append(b__19764,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tag$md_DASH_chip$md_DASH_chip_DASH_raised,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (i__19763,i__19752,tag,c__4521__auto____$1,size__4522__auto____$1,b__19764,s__19762__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (p1__19749_SHARP_){
return org_analyzer.view.dom.select_element(p1__19749_SHARP_.target);
});})(i__19763,i__19752,tag,c__4521__auto____$1,size__4522__auto____$1,b__19764,s__19762__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
], null),tag], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag)].join('')], null)));

var G__19776 = (i__19763 + (1));
i__19763 = G__19776;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19764),org_analyzer$view$clock_list$clock_list_$_iter__19750_$_iter__19761(cljs.core.chunk_rest(s__19762__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19764),null);
}
} else {
var tag = cljs.core.first(s__19762__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tag$md_DASH_chip$md_DASH_chip_DASH_raised,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (i__19752,tag,s__19762__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (p1__19749_SHARP_){
return org_analyzer.view.dom.select_element(p1__19749_SHARP_.target);
});})(i__19752,tag,s__19762__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
], null),tag], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag)].join('')], null)),org_analyzer$view$clock_list$clock_list_$_iter__19750_$_iter__19761(cljs.core.rest(s__19762__$2)));
}
} else {
return null;
}
break;
}
});})(i__19752,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
,null,null));
});})(i__19752,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19754,map__19754__$1,vec__19755,map__19758,map__19758__$1,clock,name,tags,path,org_file,location,duration,c__4521__auto__,size__4522__auto__,b__19753,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
;
return iter__4523__auto__(tags);
})()], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location),"-name"].join('')], null)));

var G__19777 = (i__19752 + (1));
i__19752 = G__19777;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19753),org_analyzer$view$clock_list$clock_list_$_iter__19750(cljs.core.chunk_rest(s__19751__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19753),null);
}
} else {
var map__19765 = cljs.core.first(s__19751__$2);
var map__19765__$1 = (((((!((map__19765 == null))))?(((((map__19765.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19765.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19765):map__19765);
var vec__19766 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19765__$1,cljs.core.cst$kw$clocks);
var map__19769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19766,(0),null);
var map__19769__$1 = (((((!((map__19769 == null))))?(((((map__19769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19769):map__19769);
var clock = map__19769__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19769__$1,cljs.core.cst$kw$name);
var tags = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19769__$1,cljs.core.cst$kw$tags);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19769__$1,cljs.core.cst$kw$path);
var org_file = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19769__$1,cljs.core.cst$kw$org_DASH_file);
var location = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19765__$1,cljs.core.cst$kw$location);
var duration = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19765__$1,cljs.core.cst$kw$duration);
var highlighted_QMARK_ = (current_highlighted_entries.cljs$core$IFn$_invoke$arity$1 ? current_highlighted_entries.cljs$core$IFn$_invoke$arity$1(location) : current_highlighted_entries.call(null,location));
var on_mouse_over = ((function (highlighted_QMARK_,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
return cljs.core.reset_BANG_(highlighted_entries,cljs.core.PersistentHashSet.createAsIfByAssoc([location]));
});})(highlighted_QMARK_,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
;
var on_mouse_out = ((function (highlighted_QMARK_,on_mouse_over,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
return cljs.core.reset_BANG_(highlighted_entries,cljs.core.PersistentHashSet.EMPTY);
});})(highlighted_QMARK_,on_mouse_over,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
;
var attrs = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$on_DASH_mouse_DASH_over,on_mouse_over,cljs.core.cst$kw$on_DASH_mouse_DASH_out,on_mouse_out,cljs.core.cst$kw$class,(cljs.core.truth_(highlighted_QMARK_)?"highlighted":"")], null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$name,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([attrs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
return org_analyzer.view.clock_list.open_org_file(org_file,name);
});})(highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
], null)], 0)),org_analyzer.view.util.parse_all_org_links(name)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$duration,attrs,org_analyzer.view.util.print_duration_mins(duration)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$path,attrs,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(" > ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.parse_all_org_links,clojure.string.trim),path))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$tags$md_DASH_chips,attrs,(function (){var iter__4523__auto__ = ((function (highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function org_analyzer$view$clock_list$clock_list_$_iter__19750_$_iter__19772(s__19773){
return (new cljs.core.LazySeq(null,((function (highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (){
var s__19773__$1 = s__19773;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__19773__$1);
if(temp__5457__auto____$1){
var s__19773__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__19773__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19773__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19775 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19774 = (0);
while(true){
if((i__19774 < size__4522__auto__)){
var tag = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19774);
cljs.core.chunk_append(b__19775,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tag$md_DASH_chip$md_DASH_chip_DASH_raised,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (i__19774,tag,c__4521__auto__,size__4522__auto__,b__19775,s__19773__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (p1__19749_SHARP_){
return org_analyzer.view.dom.select_element(p1__19749_SHARP_.target);
});})(i__19774,tag,c__4521__auto__,size__4522__auto__,b__19775,s__19773__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
], null),tag], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag)].join('')], null)));

var G__19778 = (i__19774 + (1));
i__19774 = G__19778;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19775),org_analyzer$view$clock_list$clock_list_$_iter__19750_$_iter__19772(cljs.core.chunk_rest(s__19773__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19775),null);
}
} else {
var tag = cljs.core.first(s__19773__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$tag$md_DASH_chip$md_DASH_chip_DASH_raised,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (tag,s__19773__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries){
return (function (p1__19749_SHARP_){
return org_analyzer.view.dom.select_element(p1__19749_SHARP_.target);
});})(tag,s__19773__$2,temp__5457__auto____$1,highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
], null),tag], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag)].join('')], null)),org_analyzer$view$clock_list$clock_list_$_iter__19750_$_iter__19772(cljs.core.rest(s__19773__$2)));
}
} else {
return null;
}
break;
}
});})(highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
,null,null));
});})(highlighted_QMARK_,on_mouse_over,on_mouse_out,attrs,map__19765,map__19765__$1,vec__19766,map__19769,map__19769__$1,clock,name,tags,path,org_file,location,duration,s__19751__$2,temp__5457__auto__,current_highlighted_entries))
;
return iter__4523__auto__(tags);
})()], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(location),"-name"].join('')], null)),org_analyzer$view$clock_list$clock_list_$_iter__19750(cljs.core.rest(s__19751__$2)));
}
} else {
return null;
}
break;
}
});})(current_highlighted_entries))
,null,null));
});})(current_highlighted_entries))
;
return iter__4523__auto__(clocks_with_id_and_duration);
})())], null)], null);
});
org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration = (function org_analyzer$view$clock_list$group_clocks_same_activity_and_sort_by_duration(clocks){
return cljs.core.reverse(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$duration,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__19779){
var vec__19780 = p__19779;
var location = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19780,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19780,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$location,location,cljs.core.cst$kw$clocks,clocks__$1,cljs.core.cst$kw$duration,org_analyzer.view.util.sum_clocks_mins(clocks__$1)], null);
}),cljs.core.group_by(cljs.core.cst$kw$location,clocks))));
});
org_analyzer.view.clock_list.clock_list_view = (function org_analyzer$view$clock_list$clock_list_view(days,clocks_by_day,calendar,highlighted_entries,clock_list_group){
var n = cljs.core.count(days);
var dates = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$date,days);
var clocks_by_day__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by(cljs.core._LT_),cljs.core.select_keys(clocks_by_day,dates));
var clocks = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.vals(clocks_by_day__$1));
var clocks_with_id_and_duration = org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration(clocks);
var duration = org_analyzer.view.util.sum_clocks_mins(clocks);
var days__$1 = cljs.core.vals(cljs.core.select_keys(calendar,dates));
var map__19783 = org_analyzer.view.clock_list.analyze_clocks(days__$1,clocks_by_day__$1);
var map__19783__$1 = (((((!((map__19783 == null))))?(((((map__19783.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19783.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19783):map__19783);
var average_day_duration = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19783__$1,cljs.core.cst$kw$average_DASH_day_DASH_duration);
var average_week_duration = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19783__$1,cljs.core.cst$kw$average_DASH_week_DASH_duration);
var n_weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19783__$1,cljs.core.cst$kw$n_DASH_weeks);
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$day_DASH_detail,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$select_DASH_wrapper$clock_DASH_list_DASH_grouper,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_change,((function (n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function (evt){
return cljs.core.reset_BANG_(clock_list_group,(function (){var val = evt.target.value;
if(cljs.core.empty_QMARK_(val)){
return null;
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(val);
}
})());
});})(n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
,cljs.core.cst$kw$value,(function (){var or__4131__auto__ = cljs.core.deref(clock_list_group);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})()], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,""], null),"not grouped"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"day"], null),"group by day"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"week"], null),"group by week"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,"month"], null),"group by month"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$date,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),n))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(dates))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dow_DASH_name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(days__$1)))].join(''):cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~d days over ~d week~:*~P selected",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.count(dates),n_weeks], 0)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$hours,["Clocked time: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(org_analyzer.view.util.print_duration_mins(duration))].join('')], null),(((n > (1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$avg_DASH_per_DASH_day,["Average time per day: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(average_day_duration)].join('')], null):null),(((n > (1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$avg_DASH_per_DASH_week,["Average time per week: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(average_week_duration)].join('')], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$activity_DASH_count,cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~d activit~:*~[ies~;y~:;ies~]",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.count(clocks_with_id_and_duration)], 0))], null),(function (){var G__19785 = cljs.core.deref(clock_list_group);
var G__19785__$1 = (((G__19785 instanceof cljs.core.Keyword))?G__19785.fqn:null);
switch (G__19785__$1) {
case "day":
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__4523__auto__ = ((function (G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function org_analyzer$view$clock_list$clock_list_view_$_iter__19786(s__19787){
return (new cljs.core.LazySeq(null,((function (G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function (){
var s__19787__$1 = s__19787;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19787__$1);
if(temp__5457__auto__){
var s__19787__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19787__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19787__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19789 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19788 = (0);
while(true){
if((i__19788 < size__4522__auto__)){
var vec__19790 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19788);
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19790,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19790,(1),null);
if(cljs.core.truth_(cljs.core.not_empty(clocks__$1))){
var clocks_with_id_and_duration__$1 = org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration(clocks__$1);
cljs.core.chunk_append(b__19789,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,day,org_analyzer.view.clock_list.clock_list(clocks_with_id_and_duration__$1,highlighted_entries)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,day], null)));

var G__19825 = (i__19788 + (1));
i__19788 = G__19825;
continue;
} else {
var G__19826 = (i__19788 + (1));
i__19788 = G__19826;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19789),org_analyzer$view$clock_list$clock_list_view_$_iter__19786(cljs.core.chunk_rest(s__19787__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19789),null);
}
} else {
var vec__19793 = cljs.core.first(s__19787__$2);
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19793,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19793,(1),null);
if(cljs.core.truth_(cljs.core.not_empty(clocks__$1))){
var clocks_with_id_and_duration__$1 = org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration(clocks__$1);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,day,org_analyzer.view.clock_list.clock_list(clocks_with_id_and_duration__$1,highlighted_entries)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,day], null)),org_analyzer$view$clock_list$clock_list_view_$_iter__19786(cljs.core.rest(s__19787__$2)));
} else {
var G__19827 = cljs.core.rest(s__19787__$2);
s__19787__$1 = G__19827;
continue;
}
}
} else {
return null;
}
break;
}
});})(G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
,null,null));
});})(G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
;
return iter__4523__auto__(clocks_by_day__$1);
})());

break;
case "week":
var clocks_by_week = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function (by_week,p__19796){
var vec__19797 = p__19796;
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19797,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19797,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(by_week,["Week ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$week.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(calendar,day)))].join(''),cljs.core.concat,clocks__$1);
});})(G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
,cljs.core.PersistentArrayMap.EMPTY,clocks_by_day__$1));
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__4523__auto__ = ((function (clocks_by_week,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function org_analyzer$view$clock_list$clock_list_view_$_iter__19800(s__19801){
return (new cljs.core.LazySeq(null,((function (clocks_by_week,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function (){
var s__19801__$1 = s__19801;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19801__$1);
if(temp__5457__auto__){
var s__19801__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19801__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19801__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19803 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19802 = (0);
while(true){
if((i__19802 < size__4522__auto__)){
var vec__19804 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19802);
var week = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19804,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19804,(1),null);
if(cljs.core.truth_(cljs.core.not_empty(clocks__$1))){
var clocks_with_id_and_duration__$1 = org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration(clocks__$1);
cljs.core.chunk_append(b__19803,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,week,org_analyzer.view.clock_list.clock_list(clocks_with_id_and_duration__$1,highlighted_entries)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,week], null)));

var G__19828 = (i__19802 + (1));
i__19802 = G__19828;
continue;
} else {
var G__19829 = (i__19802 + (1));
i__19802 = G__19829;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19803),org_analyzer$view$clock_list$clock_list_view_$_iter__19800(cljs.core.chunk_rest(s__19801__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19803),null);
}
} else {
var vec__19807 = cljs.core.first(s__19801__$2);
var week = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19807,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19807,(1),null);
if(cljs.core.truth_(cljs.core.not_empty(clocks__$1))){
var clocks_with_id_and_duration__$1 = org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration(clocks__$1);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,week,org_analyzer.view.clock_list.clock_list(clocks_with_id_and_duration__$1,highlighted_entries)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,week], null)),org_analyzer$view$clock_list$clock_list_view_$_iter__19800(cljs.core.rest(s__19801__$2)));
} else {
var G__19830 = cljs.core.rest(s__19801__$2);
s__19801__$1 = G__19830;
continue;
}
}
} else {
return null;
}
break;
}
});})(clocks_by_week,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
,null,null));
});})(clocks_by_week,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
;
return iter__4523__auto__(clocks_by_week);
})());

break;
case "month":
var clocks_by_month = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function (by_week,p__19810){
var vec__19811 = p__19810;
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19811,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19811,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(by_week,cljs.core.cst$kw$month.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(calendar,day)),cljs.core.concat,clocks__$1);
});})(G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
,cljs.core.PersistentArrayMap.EMPTY,clocks_by_day__$1));
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((function (){var iter__4523__auto__ = ((function (clocks_by_month,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function org_analyzer$view$clock_list$clock_list_view_$_iter__19814(s__19815){
return (new cljs.core.LazySeq(null,((function (clocks_by_month,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks){
return (function (){
var s__19815__$1 = s__19815;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19815__$1);
if(temp__5457__auto__){
var s__19815__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19815__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19815__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19817 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19816 = (0);
while(true){
if((i__19816 < size__4522__auto__)){
var vec__19818 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19816);
var month = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19818,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19818,(1),null);
if(cljs.core.truth_(cljs.core.not_empty(clocks__$1))){
var clocks_with_id_and_duration__$1 = org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration(clocks__$1);
cljs.core.chunk_append(b__19817,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,month,org_analyzer.view.clock_list.clock_list(clocks_with_id_and_duration__$1,highlighted_entries)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,month], null)));

var G__19831 = (i__19816 + (1));
i__19816 = G__19831;
continue;
} else {
var G__19832 = (i__19816 + (1));
i__19816 = G__19832;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19817),org_analyzer$view$clock_list$clock_list_view_$_iter__19814(cljs.core.chunk_rest(s__19815__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19817),null);
}
} else {
var vec__19821 = cljs.core.first(s__19815__$2);
var month = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19821,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19821,(1),null);
if(cljs.core.truth_(cljs.core.not_empty(clocks__$1))){
var clocks_with_id_and_duration__$1 = org_analyzer.view.clock_list.group_clocks_same_activity_and_sort_by_duration(clocks__$1);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,month,org_analyzer.view.clock_list.clock_list(clocks_with_id_and_duration__$1,highlighted_entries)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,month], null)),org_analyzer$view$clock_list$clock_list_view_$_iter__19814(cljs.core.rest(s__19815__$2)));
} else {
var G__19833 = cljs.core.rest(s__19815__$2);
s__19815__$1 = G__19833;
continue;
}
}
} else {
return null;
}
break;
}
});})(clocks_by_month,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
,null,null));
});})(clocks_by_month,G__19785,G__19785__$1,n,dates,clocks_by_day__$1,clocks,clocks_with_id_and_duration,duration,days__$1,map__19783,map__19783__$1,average_day_duration,average_week_duration,n_weeks))
;
return iter__4523__auto__(clocks_by_month);
})());

break;
default:
return org_analyzer.view.clock_list.clock_list(clocks_with_id_and_duration,highlighted_entries);

}
})()], null);
});
