// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.calendar');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('org_analyzer.view.util');
goog.require('org_analyzer.view.dom');
goog.require('org_analyzer.view.selection');
goog.require('org_analyzer.view.geo');
goog.require('clojure.string');
goog.require('reagent.core');
goog.require('reagent.ratom');
goog.require('clojure.set');
org_analyzer.view.calendar.event_handlers = (function org_analyzer$view$calendar$event_handlers(app_state,dom_state){
var add_selection_QMARK_ = (function org_analyzer$view$calendar$event_handlers_$_add_selection_QMARK_(){
return cljs.core.cst$kw$shift_DASH_down_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$keys.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(dom_state)));
});
var remove_from_selection_QMARK_ = (function org_analyzer$view$calendar$event_handlers_$_remove_from_selection_QMARK_(){
return cljs.core.cst$kw$alt_DASH_down_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$keys.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(dom_state)));
});
var on_click_month = (function org_analyzer$view$calendar$event_handlers_$_on_click_month(_evt,days){
var dates = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$date,days));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.update,cljs.core.cst$kw$selected_DASH_days,((function (dates){
return (function (p1__19198_SHARP_){
if(cljs.core.truth_(add_selection_QMARK_())){
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(p1__19198_SHARP_,dates);
} else {
if(cljs.core.truth_(remove_from_selection_QMARK_())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(p1__19198_SHARP_,dates);
} else {
return dates;

}
}
});})(dates))
);
});
var on_click_week = (function org_analyzer$view$calendar$event_handlers_$_on_click_week(_evt,_week_no,days){
var dates = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$date,days));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.update,cljs.core.cst$kw$selected_DASH_days,((function (dates){
return (function (p1__19199_SHARP_){
if(cljs.core.truth_(add_selection_QMARK_())){
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(p1__19199_SHARP_,dates);
} else {
if(cljs.core.truth_(remove_from_selection_QMARK_())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(p1__19199_SHARP_,dates);
} else {
return dates;

}
}
});})(dates))
);
});
var on_mouse_over_day = (function org_analyzer$view$calendar$event_handlers_$_on_mouse_over_day(date){
if(cljs.core.not(cljs.core.cst$kw$selecting_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)))){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$hovered_DASH_over_DASH_date,date);
} else {
return null;
}
});
var on_mouse_out_day = (function org_analyzer$view$calendar$event_handlers_$_on_mouse_out_day(){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$hovered_DASH_over_DASH_date,null);
});
var on_click_day = (function org_analyzer$view$calendar$event_handlers_$_on_click_day(_evt,date){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.update,cljs.core.cst$kw$selected_DASH_days,(function (p1__19200_SHARP_){
if(cljs.core.truth_(add_selection_QMARK_())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__19200_SHARP_,date);
} else {
if(cljs.core.truth_(remove_from_selection_QMARK_())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(p1__19200_SHARP_,cljs.core.PersistentHashSet.createAsIfByAssoc([date]));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__19200_SHARP_,cljs.core.PersistentHashSet.createAsIfByAssoc([date]))){
return cljs.core.PersistentHashSet.EMPTY;
} else {
return cljs.core.PersistentHashSet.createAsIfByAssoc([date]);

}
}
}
}));
});
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$on_DASH_click_DASH_month,on_click_month,cljs.core.cst$kw$on_DASH_click_DASH_week,on_click_week,cljs.core.cst$kw$on_DASH_mouse_DASH_over_DASH_day,on_mouse_over_day,cljs.core.cst$kw$on_DASH_mouse_DASH_out_DASH_day,on_mouse_out_day,cljs.core.cst$kw$on_DASH_click_DASH_day,on_click_day], null);
});
org_analyzer.view.calendar.mark_days_as_potentially_selected = (function org_analyzer$view$calendar$mark_days_as_potentially_selected(app_state,dom_state,sel_state){
var sel_bounds = cljs.core.cst$kw$global_DASH_bounds.cljs$core$IFn$_invoke$arity$1(sel_state);
var contained = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,(function (){var iter__4523__auto__ = ((function (sel_bounds){
return (function org_analyzer$view$calendar$mark_days_as_potentially_selected_$_iter__19201(s__19202){
return (new cljs.core.LazySeq(null,((function (sel_bounds){
return (function (){
var s__19202__$1 = s__19202;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19202__$1);
if(temp__5457__auto__){
var s__19202__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19202__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19202__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19204 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19203 = (0);
while(true){
if((i__19203 < size__4522__auto__)){
var vec__19205 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19203);
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19205,(0),null);
var day_bounds = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19205,(1),null);
if(org_analyzer.view.geo.contains_rect_QMARK_(sel_bounds,day_bounds)){
cljs.core.chunk_append(b__19204,day);

var G__19211 = (i__19203 + (1));
i__19203 = G__19211;
continue;
} else {
var G__19212 = (i__19203 + (1));
i__19203 = G__19212;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19204),org_analyzer$view$calendar$mark_days_as_potentially_selected_$_iter__19201(cljs.core.chunk_rest(s__19202__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19204),null);
}
} else {
var vec__19208 = cljs.core.first(s__19202__$2);
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19208,(0),null);
var day_bounds = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19208,(1),null);
if(org_analyzer.view.geo.contains_rect_QMARK_(sel_bounds,day_bounds)){
return cljs.core.cons(day,org_analyzer$view$calendar$mark_days_as_potentially_selected_$_iter__19201(cljs.core.rest(s__19202__$2)));
} else {
var G__19213 = cljs.core.rest(s__19202__$2);
s__19202__$1 = G__19213;
continue;
}
}
} else {
return null;
}
break;
}
});})(sel_bounds))
,null,null));
});})(sel_bounds))
;
return iter__4523__auto__(cljs.core.cst$kw$day_DASH_bounding_DASH_boxes.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(dom_state)));
})());
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$selected_DASH_days_DASH_preview,contained);
});
org_analyzer.view.calendar.commit_potentially_selected_BANG_ = (function org_analyzer$view$calendar$commit_potentially_selected_BANG_(selected_days,selected_days_preview,valid_selection_QMARK_,dom_state){
var add_selection_QMARK_ = cljs.core.cst$kw$shift_DASH_down_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$keys.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(dom_state)));
var remove_from_selection_QMARK_ = cljs.core.cst$kw$alt_DASH_down_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$keys.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(dom_state)));
var selected = (cljs.core.truth_(remove_from_selection_QMARK_)?clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(selected_days),cljs.core.deref(selected_days_preview)):(cljs.core.truth_(add_selection_QMARK_)?clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(selected_days_preview),cljs.core.deref(selected_days)):cljs.core.deref(selected_days_preview)
));
cljs.core.reset_BANG_(selected_days_preview,cljs.core.PersistentHashSet.EMPTY);

if(cljs.core.truth_(valid_selection_QMARK_)){
return cljs.core.reset_BANG_(selected_days,selected);
} else {
return null;
}
});
org_analyzer.view.calendar.emph_css_class = (function org_analyzer$view$calendar$emph_css_class(count,max_count){
var G__19215 = Math.round(((count / max_count) * (10)));
var fexpr__19214 = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.str,"emph-");
return (fexpr__19214.cljs$core$IFn$_invoke$arity$1 ? fexpr__19214.cljs$core$IFn$_invoke$arity$1(G__19215) : fexpr__19214.call(null,G__19215));
});
org_analyzer.view.calendar.day_view = (function org_analyzer$view$calendar$day_view(dom_state,event_handlers,p__19218,p__19219,highlighted_days){
var map__19220 = p__19218;
var map__19220__$1 = (((((!((map__19220 == null))))?(((((map__19220.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19220.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19220):map__19220);
var _day = map__19220__$1;
var date = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19220__$1,cljs.core.cst$kw$date);
var map__19221 = p__19219;
var map__19221__$1 = (((((!((map__19221 == null))))?(((((map__19221.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19221.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19221):map__19221);
var _calendar_state = map__19221__$1;
var clocks_by_day = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19221__$1,cljs.core.cst$kw$clocks_DASH_by_DASH_day);
var selected_days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19221__$1,cljs.core.cst$kw$selected_DASH_days);
var max_weight = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19221__$1,cljs.core.cst$kw$max_DASH_weight);
var clocks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(clocks_by_day),date);
var selected_QMARK_ = (function (){var fexpr__19224 = cljs.core.deref(selected_days);
return (fexpr__19224.cljs$core$IFn$_invoke$arity$1 ? fexpr__19224.cljs$core$IFn$_invoke$arity$1(date) : fexpr__19224.call(null,date));
})();
var highlighted_QMARK_ = (function (){var fexpr__19225 = cljs.core.deref(highlighted_days);
return (fexpr__19225.cljs$core$IFn$_invoke$arity$1 ? fexpr__19225.cljs$core$IFn$_invoke$arity$1(date) : fexpr__19225.call(null,date));
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$day,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$key,date,cljs.core.cst$kw$id,date,cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.calendar.emph_css_class(org_analyzer.view.util.sum_clocks_mins(clocks),cljs.core.deref(max_weight)),(cljs.core.truth_(selected_QMARK_)?"selected":null),(cljs.core.truth_(highlighted_QMARK_)?"highlighted":null)], null),cljs.core.cst$kw$ref,((function (clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight){
return (function (el){
if(cljs.core.truth_(el)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dom_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$day_DASH_bounding_DASH_boxes,date], null),org_analyzer.view.dom.global_bounds(el));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dom_state,cljs.core.update,cljs.core.cst$kw$day_DASH_bounding_DASH_boxes,((function (clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight){
return (function (p1__19216_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__19216_SHARP_,date);
});})(clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight))
);
}
});})(clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight))
,cljs.core.cst$kw$on_DASH_mouse_DASH_over,((function (clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight){
return (function (){
var fexpr__19226 = cljs.core.cst$kw$on_DASH_mouse_DASH_over_DASH_day.cljs$core$IFn$_invoke$arity$1(event_handlers);
return (fexpr__19226.cljs$core$IFn$_invoke$arity$1 ? fexpr__19226.cljs$core$IFn$_invoke$arity$1(date) : fexpr__19226.call(null,date));
});})(clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight))
,cljs.core.cst$kw$on_DASH_mouse_DASH_out,((function (clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight){
return (function (){
var fexpr__19227 = cljs.core.cst$kw$on_DASH_mouse_DASH_out_DASH_day.cljs$core$IFn$_invoke$arity$1(event_handlers);
return (fexpr__19227.cljs$core$IFn$_invoke$arity$0 ? fexpr__19227.cljs$core$IFn$_invoke$arity$0() : fexpr__19227.call(null));
});})(clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight))
,cljs.core.cst$kw$on_DASH_click,((function (clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight){
return (function (p1__19217_SHARP_){
var fexpr__19228 = cljs.core.cst$kw$on_DASH_click_DASH_day.cljs$core$IFn$_invoke$arity$1(event_handlers);
return (fexpr__19228.cljs$core$IFn$_invoke$arity$2 ? fexpr__19228.cljs$core$IFn$_invoke$arity$2(p1__19217_SHARP_,date) : fexpr__19228.call(null,p1__19217_SHARP_,date));
});})(clocks,selected_QMARK_,highlighted_QMARK_,map__19220,map__19220__$1,_day,date,map__19221,map__19221__$1,_calendar_state,clocks_by_day,selected_days,max_weight))
], null)], null);
});
org_analyzer.view.calendar.week_view = (function org_analyzer$view$calendar$week_view(dom_state,event_handlers,week,calendar_state,highlighted_days){
var vec__19231 = week;
var map__19234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19231,(0),null);
var map__19234__$1 = (((((!((map__19234 == null))))?(((((map__19234.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19234.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19234):map__19234);
var week_date = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19234__$1,cljs.core.cst$kw$date);
var week_no = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19234__$1,cljs.core.cst$kw$week);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$week,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,week_date], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$week_DASH_no,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (vec__19231,map__19234,map__19234__$1,week_date,week_no){
return (function (p1__19229_SHARP_){
var fexpr__19236 = cljs.core.cst$kw$on_DASH_click_DASH_week.cljs$core$IFn$_invoke$arity$1(event_handlers);
return (fexpr__19236.cljs$core$IFn$_invoke$arity$3 ? fexpr__19236.cljs$core$IFn$_invoke$arity$3(p1__19229_SHARP_,week_no,week) : fexpr__19236.call(null,p1__19229_SHARP_,week_no,week));
});})(vec__19231,map__19234,map__19234__$1,week_date,week_no))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,week_no], null)], null),cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__19231,map__19234,map__19234__$1,week_date,week_no){
return (function (p1__19230_SHARP_){
return org_analyzer.view.calendar.day_view(dom_state,event_handlers,p1__19230_SHARP_,calendar_state,highlighted_days);
});})(vec__19231,map__19234,map__19234__$1,week_date,week_no))
,week))], null);
});
org_analyzer.view.calendar.month_view = (function org_analyzer$view$calendar$month_view(dom_state,event_handlers,p__19239,calendar_state,highlighted_days){
var vec__19240 = p__19239;
var date = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19240,(0),null);
var days_in_month = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19240,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$month,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$key,date,cljs.core.cst$kw$class,clojure.string.lower_case(cljs.core.cst$kw$month.cljs$core$IFn$_invoke$arity$1(cljs.core.first(days_in_month)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$month_DASH_date,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (vec__19240,date,days_in_month){
return (function (p1__19237_SHARP_){
var fexpr__19243 = cljs.core.cst$kw$on_DASH_click_DASH_month.cljs$core$IFn$_invoke$arity$1(event_handlers);
return (fexpr__19243.cljs$core$IFn$_invoke$arity$2 ? fexpr__19243.cljs$core$IFn$_invoke$arity$2(p1__19237_SHARP_,days_in_month) : fexpr__19243.call(null,p1__19237_SHARP_,days_in_month));
});})(vec__19240,date,days_in_month))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,date], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$weeks,cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__19240,date,days_in_month){
return (function (p1__19238_SHARP_){
return org_analyzer.view.calendar.week_view(dom_state,event_handlers,p1__19238_SHARP_,calendar_state,highlighted_days);
});})(vec__19240,date,days_in_month))
,org_analyzer.view.util.weeks(days_in_month)))], null)], null);
});
/**
 * Return the by-month sorted dates map without leading and trailing month for which no clock exists.
 */
org_analyzer.view.calendar.by_month_excluding_empty_start_and_end_month = (function org_analyzer$view$calendar$by_month_excluding_empty_start_and_end_month(by_month,clocks_by_day){
var non_empty_days = cljs.core.set(cljs.core.keys(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.not_empty,cljs.core.val),clocks_by_day)));
var not_empty_month_QMARK_ = ((function (non_empty_days){
return (function (month_string){
return cljs.core.not_any_QMARK_(non_empty_days,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$date,cljs.core.get.cljs$core$IFn$_invoke$arity$2(by_month,month_string)));
});})(non_empty_days))
;
var month_strings = cljs.core.set(cljs.core.keys(by_month));
var empty_start_month = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(not_empty_month_QMARK_,month_strings);
var empty_end_month = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(not_empty_month_QMARK_,cljs.core.reverse(month_strings));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by(cljs.core._LT_),cljs.core.select_keys(by_month,clojure.set.difference.cljs$core$IFn$_invoke$arity$variadic(month_strings,empty_start_month,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([empty_end_month], 0))));
});
org_analyzer.view.calendar.calendar_view = (function org_analyzer$view$calendar$calendar_view(app_state,dom_state,event_handlers){
var clocks_by_day = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$clocks_DASH_by_DASH_day_DASH_filtered], null));
var calendar_state = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$max_DASH_weight,reagent.ratom.make_reaction(((function (clocks_by_day){
return (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.sum_clocks_mins,cljs.core.second),cljs.core.deref(clocks_by_day)));
});})(clocks_by_day))
),cljs.core.cst$kw$clocks_DASH_by_DASH_day,clocks_by_day,cljs.core.cst$kw$selected_DASH_days,reagent.ratom.make_reaction(((function (clocks_by_day){
return (function (){
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$selected_DASH_days.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)),cljs.core.cst$kw$selected_DASH_days_DASH_preview.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)));
});})(clocks_by_day))
)], null);
var selecting_QMARK_ = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selecting_QMARK_], null));
var selected_days = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_days], null));
var selected_days_preview = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$selected_DASH_days_DASH_preview], null));
var by_month = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by(cljs.core._LT_),cljs.core.group_by(((function (clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview){
return (function (p1__19244_SHARP_){
return clojure.string.replace(cljs.core.cst$kw$date.cljs$core$IFn$_invoke$arity$1(p1__19244_SHARP_),/^([0-9]+-[0-9]+).*/,"$1");
});})(clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview))
,cljs.core.flatten(cljs.core.vals(cljs.core.cst$kw$calendar.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state))))));
var by_month__$1 = (cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.not_empty(cljs.core.cst$kw$search_DASH_input.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$print_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state));
}
})())?org_analyzer.view.calendar.by_month_excluding_empty_start_and_end_month(by_month,cljs.core.deref(clocks_by_day)):by_month);
var highlighted_days = reagent.ratom.make_reaction(((function (clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1){
return (function (){
return cljs.core.set((function (){var highlighted_locations = cljs.core.cst$kw$highlighted_DASH_entries.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state));
var iter__4523__auto__ = ((function (highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1){
return (function org_analyzer$view$calendar$calendar_view_$_iter__19249(s__19250){
return (new cljs.core.LazySeq(null,((function (highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1){
return (function (){
var s__19250__$1 = s__19250;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19250__$1);
if(temp__5457__auto__){
var s__19250__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19250__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19250__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19252 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19251 = (0);
while(true){
if((i__19251 < size__4522__auto__)){
var vec__19253 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19251);
var date = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19253,(0),null);
var clocks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19253,(1),null);
if(cljs.core.truth_(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (i__19251,s__19250__$1,vec__19253,date,clocks,c__4521__auto__,size__4522__auto__,b__19252,s__19250__$2,temp__5457__auto__,highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1){
return (function (p1__19245_SHARP_){
var G__19256 = cljs.core.cst$kw$location.cljs$core$IFn$_invoke$arity$1(p1__19245_SHARP_);
return (highlighted_locations.cljs$core$IFn$_invoke$arity$1 ? highlighted_locations.cljs$core$IFn$_invoke$arity$1(G__19256) : highlighted_locations.call(null,G__19256));
});})(i__19251,s__19250__$1,vec__19253,date,clocks,c__4521__auto__,size__4522__auto__,b__19252,s__19250__$2,temp__5457__auto__,highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1))
,clocks)))){
cljs.core.chunk_append(b__19252,date);

var G__19264 = (i__19251 + (1));
i__19251 = G__19264;
continue;
} else {
var G__19265 = (i__19251 + (1));
i__19251 = G__19265;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19252),org_analyzer$view$calendar$calendar_view_$_iter__19249(cljs.core.chunk_rest(s__19250__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19252),null);
}
} else {
var vec__19257 = cljs.core.first(s__19250__$2);
var date = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19257,(0),null);
var clocks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19257,(1),null);
if(cljs.core.truth_(cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (s__19250__$1,vec__19257,date,clocks,s__19250__$2,temp__5457__auto__,highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1){
return (function (p1__19245_SHARP_){
var G__19260 = cljs.core.cst$kw$location.cljs$core$IFn$_invoke$arity$1(p1__19245_SHARP_);
return (highlighted_locations.cljs$core$IFn$_invoke$arity$1 ? highlighted_locations.cljs$core$IFn$_invoke$arity$1(G__19260) : highlighted_locations.call(null,G__19260));
});})(s__19250__$1,vec__19257,date,clocks,s__19250__$2,temp__5457__auto__,highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1))
,clocks)))){
return cljs.core.cons(date,org_analyzer$view$calendar$calendar_view_$_iter__19249(cljs.core.rest(s__19250__$2)));
} else {
var G__19266 = cljs.core.rest(s__19250__$2);
s__19250__$1 = G__19266;
continue;
}
}
} else {
return null;
}
break;
}
});})(highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1))
,null,null));
});})(highlighted_locations,clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1))
;
return iter__4523__auto__(cljs.core.cst$kw$clocks_DASH_by_DASH_day.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)));
})());
});})(clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1))
);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$calendar_DASH_selection$noselect,org_analyzer.view.selection.drag_mouse_handlers.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$sel_DASH_rect.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(dom_state)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$on_DASH_selection_DASH_start,((function (clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days){
return (function (){
return cljs.core.reset_BANG_(selecting_QMARK_,true);
});})(clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days))
,cljs.core.cst$kw$on_DASH_selection_DASH_end,((function (clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days){
return (function (p1__19246_SHARP_){
cljs.core.reset_BANG_(selecting_QMARK_,false);

var valid_selection_QMARK_ = (org_analyzer.view.geo.area(cljs.core.cst$kw$global_DASH_bounds.cljs$core$IFn$_invoke$arity$1(p1__19246_SHARP_)) > (25));
return org_analyzer.view.calendar.commit_potentially_selected_BANG_(selected_days,selected_days_preview,valid_selection_QMARK_,dom_state);
});})(clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days))
,cljs.core.cst$kw$on_DASH_selection_DASH_change,((function (clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days){
return (function (p1__19247_SHARP_){
if(cljs.core.truth_(cljs.core.deref(selecting_QMARK_))){
return org_analyzer.view.calendar.mark_days_as_potentially_selected(app_state,dom_state,p1__19247_SHARP_);
} else {
return null;
}
});})(clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days))
], 0)),(cljs.core.truth_(cljs.core.deref(selecting_QMARK_))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$selection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,(function (){var vec__19261 = cljs.core.cst$kw$relative_DASH_bounds.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$sel_DASH_rect.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(dom_state))));
var x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19261,(0),null);
var y = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19261,(1),null);
var w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19261,(2),null);
var h = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19261,(3),null);
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$left,x,cljs.core.cst$kw$top,y,cljs.core.cst$kw$width,w,cljs.core.cst$kw$height,h], null);
})()], null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$calendar,cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days){
return (function (p1__19248_SHARP_){
return org_analyzer.view.calendar.month_view(dom_state,event_handlers,p1__19248_SHARP_,calendar_state,highlighted_days);
});})(clocks_by_day,calendar_state,selecting_QMARK_,selected_days,selected_days_preview,by_month,by_month__$1,highlighted_days))
,by_month__$1))], null)], null);
});
