// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.bar_chart');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('org_analyzer.view.util');
goog.require('clojure.string');
goog.require('cljs.pprint');
goog.require('org_analyzer.view.dom');
goog.require('org_analyzer.view.geo');
org_analyzer.view.bar_chart.bar_chart = (function org_analyzer$view$bar_chart$bar_chart(app_state,selected_days,tooltip,highlighted_entries){
var clocks_by_day = cljs.core.cst$kw$clocks_DASH_by_DASH_day_DASH_filtered.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state));
var calendar = cljs.core.cst$kw$calendar.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state));
var clocks_by_day__$1 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (clocks_by_day,calendar){
return (function (p1__19857_SHARP_){
return cljs.core.find(clocks_by_day,cljs.core.cst$kw$date.cljs$core$IFn$_invoke$arity$1(p1__19857_SHARP_));
});})(clocks_by_day,calendar))
,selected_days));
var mins_by_day = cljs.core.map.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.sum_clocks_mins,cljs.core.vals(clocks_by_day__$1));
var hours_shown = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (clocks_by_day,calendar,clocks_by_day__$1,mins_by_day){
return (function (p1__19858_SHARP_){
var or__4131__auto__ = cljs.core.first(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(((function (clocks_by_day,calendar,clocks_by_day__$1,mins_by_day){
return (function (hours){
return (p1__19858_SHARP_ > ((60) * hours));
});})(clocks_by_day,calendar,clocks_by_day__$1,mins_by_day))
,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(5),(10),(16)], null)));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (24);
}
});})(clocks_by_day,calendar,clocks_by_day__$1,mins_by_day))
,mins_by_day));
var label_height = (50);
var padding_left = (50);
var padding_right = (50);
var padding_top = (20);
var min_day_width = (3);
var max_day_width = (100);
var n_clocks = cljs.core.count(clocks_by_day__$1);
var min_width = ((padding_left + padding_right) + (n_clocks * min_day_width));
var max_width = ((padding_left + padding_right) + (n_clocks * max_day_width));
var w = (function (){var x__4222__auto__ = max_width;
var y__4223__auto__ = (function (){var x__4219__auto__ = min_width;
var y__4220__auto__ = (document.documentElement.clientWidth - (50));
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})();
var h = (300);
var day_width = (function (){var x__4219__auto__ = min_day_width;
var y__4220__auto__ = (((w - padding_right) - padding_left) / n_clocks);
return ((x__4219__auto__ > y__4220__auto__) ? x__4219__auto__ : y__4220__auto__);
})();
var max_bar_h = ((h - padding_top) - label_height);
var hour_height = (max_bar_h / hours_shown);
var bounds_by_day = (function (){var iter__4523__auto__ = ((function (clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height){
return (function org_analyzer$view$bar_chart$bar_chart_$_iter__19860(s__19861){
return (new cljs.core.LazySeq(null,((function (clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height){
return (function (){
var s__19861__$1 = s__19861;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19861__$1);
if(temp__5457__auto__){
var s__19861__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__19861__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19861__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19863 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19862 = (0);
while(true){
if((i__19862 < size__4522__auto__)){
var vec__19864 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19862);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19864,(0),null);
var vec__19867 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19864,(1),null);
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19867,(0),null);
var clocks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19867,(1),null);
var mins = org_analyzer.view.util.sum_clocks_mins(clocks);
var mins_shown = (function (){var or__4131__auto__ = cljs.core.first(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(((function (i__19862,mins,vec__19864,i,vec__19867,day,clocks,c__4521__auto__,size__4522__auto__,b__19863,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height){
return (function (p1__19859_SHARP_){
return (mins > p1__19859_SHARP_);
});})(i__19862,mins,vec__19864,i,vec__19867,day,clocks,c__4521__auto__,size__4522__auto__,b__19863,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height))
,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((60) * (2)),((60) * (5)),((60) * (10))], null)));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ((60) * (24));
}
})();
var h__$1 = ((max_bar_h / ((60) * hours_shown)) * mins);
var x = (padding_left + (i * day_width));
var y = (padding_top + (max_bar_h - h__$1));
var activities_by_effort = cljs.core.reverse(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$minutes,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__19862,mins,mins_shown,h__$1,x,y,vec__19864,i,vec__19867,day,clocks,c__4521__auto__,size__4522__auto__,b__19863,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height){
return (function (p__19870){
var vec__19871 = p__19870;
var location = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19871,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19871,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$location,location,cljs.core.cst$kw$clocks,clocks__$1,cljs.core.cst$kw$minutes,org_analyzer.view.util.sum_clocks_mins(clocks__$1)], null);
});})(i__19862,mins,mins_shown,h__$1,x,y,vec__19864,i,vec__19867,day,clocks,c__4521__auto__,size__4522__auto__,b__19863,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height))
,cljs.core.group_by(cljs.core.cst$kw$location,clocks))));
var activities_by_effort__$1 = (function (){var G__19878 = activities_by_effort;
var vec__19879 = G__19878;
var seq__19880 = cljs.core.seq(vec__19879);
var first__19881 = cljs.core.first(seq__19880);
var seq__19880__$1 = cljs.core.next(seq__19880);
var map__19882 = first__19881;
var map__19882__$1 = (((((!((map__19882 == null))))?(((((map__19882.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19882.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19882):map__19882);
var location = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19882__$1,cljs.core.cst$kw$location);
var clocks__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19882__$1,cljs.core.cst$kw$clocks);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19882__$1,cljs.core.cst$kw$minutes);
var rest = seq__19880__$1;
var i__$1 = (0);
var bottom = (padding_top + max_bar_h);
var result = cljs.core.PersistentVector.EMPTY;
var G__19878__$1 = G__19878;
var i__$2 = i__$1;
var bottom__$1 = bottom;
var result__$1 = result;
while(true){
var vec__19889 = G__19878__$1;
var seq__19890 = cljs.core.seq(vec__19889);
var first__19891 = cljs.core.first(seq__19890);
var seq__19890__$1 = cljs.core.next(seq__19890);
var map__19892 = first__19891;
var map__19892__$1 = (((((!((map__19892 == null))))?(((((map__19892.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19892.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19892):map__19892);
var location__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19892__$1,cljs.core.cst$kw$location);
var clocks__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19892__$1,cljs.core.cst$kw$clocks);
var minutes__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19892__$1,cljs.core.cst$kw$minutes);
var rest__$1 = seq__19890__$1;
var i__$3 = i__$2;
var bottom__$2 = bottom__$1;
var result__$2 = result__$1;
var h__$2 = ((max_bar_h / ((60) * hours_shown)) * minutes__$1);
var top = (bottom__$2 - h__$2);
var result__$3 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$i,i__$3,cljs.core.cst$kw$location,location__$1,cljs.core.cst$kw$clocks,clocks__$2,cljs.core.cst$kw$minutes,minutes__$1,cljs.core.cst$kw$bounds,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,top,day_width,h__$2], null),cljs.core.cst$kw$day,day], null));
if(rest__$1){
var G__20104 = rest__$1;
var G__20105 = (i__$3 + (1));
var G__20106 = top;
var G__20107 = result__$3;
G__19878__$1 = G__20104;
i__$2 = G__20105;
bottom__$1 = G__20106;
result__$1 = G__20107;
continue;
} else {
return result__$3;
}
break;
}
})();
cljs.core.chunk_append(b__19863,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [day,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$i,i,cljs.core.cst$kw$minutes,mins,cljs.core.cst$kw$minutes_DASH_shown,mins_shown,cljs.core.cst$kw$bounds,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y,day_width,h__$1], null),cljs.core.cst$kw$activities_DASH_by_DASH_effort,activities_by_effort__$1,cljs.core.cst$kw$clocks,clocks], null)], null));

var G__20108 = (i__19862 + (1));
i__19862 = G__20108;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19863),org_analyzer$view$bar_chart$bar_chart_$_iter__19860(cljs.core.chunk_rest(s__19861__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19863),null);
}
} else {
var vec__19894 = cljs.core.first(s__19861__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19894,(0),null);
var vec__19897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19894,(1),null);
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19897,(0),null);
var clocks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19897,(1),null);
var mins = org_analyzer.view.util.sum_clocks_mins(clocks);
var mins_shown = (function (){var or__4131__auto__ = cljs.core.first(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(((function (mins,vec__19894,i,vec__19897,day,clocks,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height){
return (function (p1__19859_SHARP_){
return (mins > p1__19859_SHARP_);
});})(mins,vec__19894,i,vec__19897,day,clocks,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height))
,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [((60) * (2)),((60) * (5)),((60) * (10))], null)));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return ((60) * (24));
}
})();
var h__$1 = ((max_bar_h / ((60) * hours_shown)) * mins);
var x = (padding_left + (i * day_width));
var y = (padding_top + (max_bar_h - h__$1));
var activities_by_effort = cljs.core.reverse(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$minutes,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (mins,mins_shown,h__$1,x,y,vec__19894,i,vec__19897,day,clocks,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height){
return (function (p__19900){
var vec__19901 = p__19900;
var location = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19901,(0),null);
var clocks__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19901,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$location,location,cljs.core.cst$kw$clocks,clocks__$1,cljs.core.cst$kw$minutes,org_analyzer.view.util.sum_clocks_mins(clocks__$1)], null);
});})(mins,mins_shown,h__$1,x,y,vec__19894,i,vec__19897,day,clocks,s__19861__$2,temp__5457__auto__,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height))
,cljs.core.group_by(cljs.core.cst$kw$location,clocks))));
var activities_by_effort__$1 = (function (){var G__19908 = activities_by_effort;
var vec__19909 = G__19908;
var seq__19910 = cljs.core.seq(vec__19909);
var first__19911 = cljs.core.first(seq__19910);
var seq__19910__$1 = cljs.core.next(seq__19910);
var map__19912 = first__19911;
var map__19912__$1 = (((((!((map__19912 == null))))?(((((map__19912.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19912.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19912):map__19912);
var location = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19912__$1,cljs.core.cst$kw$location);
var clocks__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19912__$1,cljs.core.cst$kw$clocks);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19912__$1,cljs.core.cst$kw$minutes);
var rest = seq__19910__$1;
var i__$1 = (0);
var bottom = (padding_top + max_bar_h);
var result = cljs.core.PersistentVector.EMPTY;
var G__19908__$1 = G__19908;
var i__$2 = i__$1;
var bottom__$1 = bottom;
var result__$1 = result;
while(true){
var vec__19919 = G__19908__$1;
var seq__19920 = cljs.core.seq(vec__19919);
var first__19921 = cljs.core.first(seq__19920);
var seq__19920__$1 = cljs.core.next(seq__19920);
var map__19922 = first__19921;
var map__19922__$1 = (((((!((map__19922 == null))))?(((((map__19922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19922.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19922):map__19922);
var location__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19922__$1,cljs.core.cst$kw$location);
var clocks__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19922__$1,cljs.core.cst$kw$clocks);
var minutes__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19922__$1,cljs.core.cst$kw$minutes);
var rest__$1 = seq__19920__$1;
var i__$3 = i__$2;
var bottom__$2 = bottom__$1;
var result__$2 = result__$1;
var h__$2 = ((max_bar_h / ((60) * hours_shown)) * minutes__$1);
var top = (bottom__$2 - h__$2);
var result__$3 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$i,i__$3,cljs.core.cst$kw$location,location__$1,cljs.core.cst$kw$clocks,clocks__$2,cljs.core.cst$kw$minutes,minutes__$1,cljs.core.cst$kw$bounds,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,top,day_width,h__$2], null),cljs.core.cst$kw$day,day], null));
if(rest__$1){
var G__20109 = rest__$1;
var G__20110 = (i__$3 + (1));
var G__20111 = top;
var G__20112 = result__$3;
G__19908__$1 = G__20109;
i__$2 = G__20110;
bottom__$1 = G__20111;
result__$1 = G__20112;
continue;
} else {
return result__$3;
}
break;
}
})();
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [day,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$i,i,cljs.core.cst$kw$minutes,mins,cljs.core.cst$kw$minutes_DASH_shown,mins_shown,cljs.core.cst$kw$bounds,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,y,day_width,h__$1], null),cljs.core.cst$kw$activities_DASH_by_DASH_effort,activities_by_effort__$1,cljs.core.cst$kw$clocks,clocks], null)], null),org_analyzer$view$bar_chart$bar_chart_$_iter__19860(cljs.core.rest(s__19861__$2)));
}
} else {
return null;
}
break;
}
});})(clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height))
,null,null));
});})(clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height))
;
return iter__4523__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,clocks_by_day__$1));
})();
var clock_colors = cljs.core.cycle(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, ["#E5FFEF","#CCFFE0","#B2FFD0","#99FFC1","#7FFFB1","#66FFA2","#33FF83"], null));
var selected_locations = cljs.core.deref(highlighted_entries);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$bar_DASH_chart_DASH_container,(((n_clocks > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$canvas$bar_DASH_chart,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(w),"px"].join('')], null),cljs.core.cst$kw$width,w,cljs.core.cst$kw$height,h,cljs.core.cst$kw$on_DASH_mouse_DASH_move,((function (clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations){
return (function (evt){
var p = org_analyzer.view.dom.mouse_position.cljs$core$IFn$_invoke$arity$variadic(evt,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$relative_QMARK_,true], 0));
var activity = cljs.core.first((function (){var iter__4523__auto__ = ((function (p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations){
return (function org_analyzer$view$bar_chart$bar_chart_$_iter__19924(s__19925){
return (new cljs.core.LazySeq(null,((function (p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations){
return (function (){
var s__19925__$1 = s__19925;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__19925__$1);
if(temp__5457__auto__){
var xs__6012__auto__ = temp__5457__auto__;
var vec__19930 = cljs.core.first(xs__6012__auto__);
var day = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19930,(0),null);
var map__19933 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19930,(1),null);
var map__19933__$1 = (((((!((map__19933 == null))))?(((((map__19933.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19933.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19933):map__19933);
var clocks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19933__$1,cljs.core.cst$kw$clocks);
var activities_by_effort = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19933__$1,cljs.core.cst$kw$activities_DASH_by_DASH_effort);
var iterys__4519__auto__ = ((function (s__19925__$1,vec__19930,day,map__19933,map__19933__$1,clocks,activities_by_effort,xs__6012__auto__,temp__5457__auto__,p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations){
return (function org_analyzer$view$bar_chart$bar_chart_$_iter__19924_$_iter__19926(s__19927){
return (new cljs.core.LazySeq(null,((function (s__19925__$1,vec__19930,day,map__19933,map__19933__$1,clocks,activities_by_effort,xs__6012__auto__,temp__5457__auto__,p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations){
return (function (){
var s__19927__$1 = s__19927;
while(true){
var temp__5457__auto____$1 = cljs.core.seq(s__19927__$1);
if(temp__5457__auto____$1){
var s__19927__$2 = temp__5457__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__19927__$2)){
var c__4521__auto__ = cljs.core.chunk_first(s__19927__$2);
var size__4522__auto__ = cljs.core.count(c__4521__auto__);
var b__19929 = cljs.core.chunk_buffer(size__4522__auto__);
if((function (){var i__19928 = (0);
while(true){
if((i__19928 < size__4522__auto__)){
var activity = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4521__auto__,i__19928);
if(org_analyzer.view.geo.contains_point_QMARK_(cljs.core.cst$kw$bounds.cljs$core$IFn$_invoke$arity$1(activity),p)){
cljs.core.chunk_append(b__19929,activity);

var G__20113 = (i__19928 + (1));
i__19928 = G__20113;
continue;
} else {
var G__20114 = (i__19928 + (1));
i__19928 = G__20114;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__19929),org_analyzer$view$bar_chart$bar_chart_$_iter__19924_$_iter__19926(cljs.core.chunk_rest(s__19927__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__19929),null);
}
} else {
var activity = cljs.core.first(s__19927__$2);
if(org_analyzer.view.geo.contains_point_QMARK_(cljs.core.cst$kw$bounds.cljs$core$IFn$_invoke$arity$1(activity),p)){
return cljs.core.cons(activity,org_analyzer$view$bar_chart$bar_chart_$_iter__19924_$_iter__19926(cljs.core.rest(s__19927__$2)));
} else {
var G__20115 = cljs.core.rest(s__19927__$2);
s__19927__$1 = G__20115;
continue;
}
}
} else {
return null;
}
break;
}
});})(s__19925__$1,vec__19930,day,map__19933,map__19933__$1,clocks,activities_by_effort,xs__6012__auto__,temp__5457__auto__,p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations))
,null,null));
});})(s__19925__$1,vec__19930,day,map__19933,map__19933__$1,clocks,activities_by_effort,xs__6012__auto__,temp__5457__auto__,p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations))
;
var fs__4520__auto__ = cljs.core.seq(iterys__4519__auto__(activities_by_effort));
if(fs__4520__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4520__auto__,org_analyzer$view$bar_chart$bar_chart_$_iter__19924(cljs.core.rest(s__19925__$1)));
} else {
var G__20116 = cljs.core.rest(s__19925__$1);
s__19925__$1 = G__20116;
continue;
}
} else {
return null;
}
break;
}
});})(p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations))
,null,null));
});})(p,clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations))
;
return iter__4523__auto__(bounds_by_day);
})());
if(cljs.core.truth_(tooltip)){
cljs.core.reset_BANG_(tooltip,(cljs.core.truth_(activity)?(function (){var map__19935 = activity;
var map__19935__$1 = (((((!((map__19935 == null))))?(((((map__19935.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19935.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19935):map__19935);
var clocks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19935__$1,cljs.core.cst$kw$clocks);
var minutes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19935__$1,cljs.core.cst$kw$minutes);
var day = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19935__$1,cljs.core.cst$kw$day);
var vec__19936 = clocks;
var map__19939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19936,(0),null);
var map__19939__$1 = (((((!((map__19939 == null))))?(((((map__19939.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19939.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19939):map__19939);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19939__$1,cljs.core.cst$kw$path);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19939__$1,cljs.core.cst$kw$name);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(day)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$dow_DASH_name.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(calendar,day))),", ",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(org_analyzer.view.util.print_duration_mins(minutes)),"h"].join('')].join('')], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,"[",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(" > ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(org_analyzer.view.util.parse_all_org_links,clojure.string.trim),path)),"]",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$name,org_analyzer.view.util.parse_all_org_links(name)], null)], null)], null);
})():null));
} else {
}

return cljs.core.reset_BANG_(highlighted_entries,(cljs.core.truth_(activity)?cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core.cst$kw$location.cljs$core$IFn$_invoke$arity$1(activity)]):cljs.core.PersistentHashSet.EMPTY));
});})(clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations))
,cljs.core.cst$kw$ref,((function (clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations){
return (function (canvas){
if(cljs.core.truth_(canvas)){
var ctx = canvas.getContext("2d");
var G__19942_20117 = ctx;
G__19942_20117.clearRect((0),(0),w,h);

G__19942_20117.save();


ctx.lineWidth = (1);

ctx.textBaseline = "middle";

ctx.textAlign = "center";

ctx.font = "10px sans-serif";

ctx.fillStyle = "black";

ctx.strokeStyle = "#EEE";

var n__4607__auto___20118 = hours_shown;
var h_20119__$1 = (0);
while(true){
if((h_20119__$1 < n__4607__auto___20118)){
if((((hours_shown < (10))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),cljs.core.mod(h_20119__$1,(3)))))){
var x_20120 = padding_left;
var y_20121 = (padding_top + (max_bar_h - (hour_height * h_20119__$1)));
var G__19943_20122 = ctx;
G__19943_20122.fillText([cljs.core.str.cljs$core$IFn$_invoke$arity$1(h_20119__$1),"h"].join(''),(x_20120 - (20)),y_20121);

G__19943_20122.beginPath();

G__19943_20122.moveTo(x_20120,y_20121);

G__19943_20122.lineTo((w - padding_right),y_20121);

G__19943_20122.closePath();

G__19943_20122.stroke();

} else {
}

var G__20123 = (h_20119__$1 + (1));
h_20119__$1 = G__20123;
continue;
} else {
}
break;
}

ctx.strokeStyle = "#333";

var seq__19944_20124 = cljs.core.seq(bounds_by_day);
var chunk__19945_20125 = null;
var count__19946_20126 = (0);
var i__19947_20127 = (0);
while(true){
if((i__19947_20127 < count__19946_20126)){
var vec__20026_20128 = chunk__19945_20125.cljs$core$IIndexed$_nth$arity$2(null,i__19947_20127);
var day_20129 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20026_20128,(0),null);
var map__20029_20130 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20026_20128,(1),null);
var map__20029_20131__$1 = (((((!((map__20029_20130 == null))))?(((((map__20029_20130.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20029_20130.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20029_20130):map__20029_20130);
var vec__20030_20132 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20029_20131__$1,cljs.core.cst$kw$bounds);
var x_20133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20030_20132,(0),null);
var y_20134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20030_20132,(1),null);
var day_width_20135__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20030_20132,(2),null);
var day_height_20136 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20030_20132,(3),null);
var i_20137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20029_20131__$1,cljs.core.cst$kw$i);
var minutes_20138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20029_20131__$1,cljs.core.cst$kw$minutes);
var minutes_shown_20139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20029_20131__$1,cljs.core.cst$kw$minutes_DASH_shown);
var clocks_20140 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20029_20131__$1,cljs.core.cst$kw$clocks);
var activities_by_effort_20141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20029_20131__$1,cljs.core.cst$kw$activities_DASH_by_DASH_effort);
ctx.strokeStyle = "#AAA";

ctx.lineWidth = .5;

ctx.beginPath();

var seq__20034_20142 = cljs.core.seq(activities_by_effort_20141);
var chunk__20036_20143 = null;
var count__20037_20144 = (0);
var i__20038_20145 = (0);
while(true){
if((i__20038_20145 < count__20037_20144)){
var map__20052_20146 = chunk__20036_20143.cljs$core$IIndexed$_nth$arity$2(null,i__20038_20145);
var map__20052_20147__$1 = (((((!((map__20052_20146 == null))))?(((((map__20052_20146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20052_20146.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20052_20146):map__20052_20146);
var vec__20053_20148 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20052_20147__$1,cljs.core.cst$kw$bounds);
var x_20149__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20053_20148,(0),null);
var y_20150__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20053_20148,(1),null);
var w_20151__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20053_20148,(2),null);
var h_20152__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20053_20148,(3),null);
var i_20153__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20052_20147__$1,cljs.core.cst$kw$i);
var location_20154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20052_20147__$1,cljs.core.cst$kw$location);
var color_20155 = (cljs.core.truth_((selected_locations.cljs$core$IFn$_invoke$arity$1 ? selected_locations.cljs$core$IFn$_invoke$arity$1(location_20154) : selected_locations.call(null,location_20154)))?"salmon":cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clock_colors,i_20153__$1));
ctx.fillStyle = color_20155;

ctx.fillRect(x_20149__$1,y_20150__$1,w_20151__$1,h_20152__$1);

var G__20057_20156 = ctx;
G__20057_20156.moveTo(x_20149__$1,y_20150__$1);

G__20057_20156.lineTo((x_20149__$1 + w_20151__$1),y_20150__$1);



var G__20157 = seq__20034_20142;
var G__20158 = chunk__20036_20143;
var G__20159 = count__20037_20144;
var G__20160 = (i__20038_20145 + (1));
seq__20034_20142 = G__20157;
chunk__20036_20143 = G__20158;
count__20037_20144 = G__20159;
i__20038_20145 = G__20160;
continue;
} else {
var temp__5457__auto___20161 = cljs.core.seq(seq__20034_20142);
if(temp__5457__auto___20161){
var seq__20034_20162__$1 = temp__5457__auto___20161;
if(cljs.core.chunked_seq_QMARK_(seq__20034_20162__$1)){
var c__4550__auto___20163 = cljs.core.chunk_first(seq__20034_20162__$1);
var G__20164 = cljs.core.chunk_rest(seq__20034_20162__$1);
var G__20165 = c__4550__auto___20163;
var G__20166 = cljs.core.count(c__4550__auto___20163);
var G__20167 = (0);
seq__20034_20142 = G__20164;
chunk__20036_20143 = G__20165;
count__20037_20144 = G__20166;
i__20038_20145 = G__20167;
continue;
} else {
var map__20058_20168 = cljs.core.first(seq__20034_20162__$1);
var map__20058_20169__$1 = (((((!((map__20058_20168 == null))))?(((((map__20058_20168.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20058_20168.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20058_20168):map__20058_20168);
var vec__20059_20170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20058_20169__$1,cljs.core.cst$kw$bounds);
var x_20171__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20059_20170,(0),null);
var y_20172__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20059_20170,(1),null);
var w_20173__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20059_20170,(2),null);
var h_20174__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20059_20170,(3),null);
var i_20175__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20058_20169__$1,cljs.core.cst$kw$i);
var location_20176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20058_20169__$1,cljs.core.cst$kw$location);
var color_20177 = (cljs.core.truth_((selected_locations.cljs$core$IFn$_invoke$arity$1 ? selected_locations.cljs$core$IFn$_invoke$arity$1(location_20176) : selected_locations.call(null,location_20176)))?"salmon":cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clock_colors,i_20175__$1));
ctx.fillStyle = color_20177;

ctx.fillRect(x_20171__$1,y_20172__$1,w_20173__$1,h_20174__$1);

var G__20063_20178 = ctx;
G__20063_20178.moveTo(x_20171__$1,y_20172__$1);

G__20063_20178.lineTo((x_20171__$1 + w_20173__$1),y_20172__$1);



var G__20179 = cljs.core.next(seq__20034_20162__$1);
var G__20180 = null;
var G__20181 = (0);
var G__20182 = (0);
seq__20034_20142 = G__20179;
chunk__20036_20143 = G__20180;
count__20037_20144 = G__20181;
i__20038_20145 = G__20182;
continue;
}
} else {
}
}
break;
}

var G__20064_20183 = ctx;
G__20064_20183.closePath();

G__20064_20183.stroke();


ctx.fillStyle = "white";

ctx.strokeRect(x_20133,y_20134,day_width_20135__$1,day_height_20136);

ctx.fillStyle = "black";

if((day_width_20135__$1 > (15))){
var rotated_QMARK__20184 = (day_width_20135__$1 < (50));
ctx.textBaseline = "top";

ctx.textAlign = "center";

ctx.translate((x_20133 + (day_width_20135__$1 / (2))),(padding_top + ((5) + max_bar_h)));

if(rotated_QMARK__20184){
ctx.rotate(((45) * (Math.PI / (180))));
} else {
}

ctx.fillText(clojure.string.replace(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(day_20129,(5)),"-","/"),((rotated_QMARK__20184)?(10):(0)),(0));

ctx.setTransform((1),(0),(0),(1),(0),(0));

if((((minutes_20138 > (0))) && ((day_width_20135__$1 > (20))))){
ctx.fillText([cljs.core.str.cljs$core$IFn$_invoke$arity$1(org_analyzer.view.util.print_duration_mins(minutes_20138)),"h"].join(''),(x_20133 + (day_width_20135__$1 / (2))),(y_20134 - (10)));
} else {
}

} else {
}


var G__20185 = seq__19944_20124;
var G__20186 = chunk__19945_20125;
var G__20187 = count__19946_20126;
var G__20188 = (i__19947_20127 + (1));
seq__19944_20124 = G__20185;
chunk__19945_20125 = G__20186;
count__19946_20126 = G__20187;
i__19947_20127 = G__20188;
continue;
} else {
var temp__5457__auto___20189 = cljs.core.seq(seq__19944_20124);
if(temp__5457__auto___20189){
var seq__19944_20190__$1 = temp__5457__auto___20189;
if(cljs.core.chunked_seq_QMARK_(seq__19944_20190__$1)){
var c__4550__auto___20191 = cljs.core.chunk_first(seq__19944_20190__$1);
var G__20192 = cljs.core.chunk_rest(seq__19944_20190__$1);
var G__20193 = c__4550__auto___20191;
var G__20194 = cljs.core.count(c__4550__auto___20191);
var G__20195 = (0);
seq__19944_20124 = G__20192;
chunk__19945_20125 = G__20193;
count__19946_20126 = G__20194;
i__19947_20127 = G__20195;
continue;
} else {
var vec__20065_20196 = cljs.core.first(seq__19944_20190__$1);
var day_20197 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20065_20196,(0),null);
var map__20068_20198 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20065_20196,(1),null);
var map__20068_20199__$1 = (((((!((map__20068_20198 == null))))?(((((map__20068_20198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20068_20198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20068_20198):map__20068_20198);
var vec__20069_20200 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068_20199__$1,cljs.core.cst$kw$bounds);
var x_20201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20069_20200,(0),null);
var y_20202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20069_20200,(1),null);
var day_width_20203__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20069_20200,(2),null);
var day_height_20204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20069_20200,(3),null);
var i_20205 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068_20199__$1,cljs.core.cst$kw$i);
var minutes_20206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068_20199__$1,cljs.core.cst$kw$minutes);
var minutes_shown_20207 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068_20199__$1,cljs.core.cst$kw$minutes_DASH_shown);
var clocks_20208 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068_20199__$1,cljs.core.cst$kw$clocks);
var activities_by_effort_20209 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20068_20199__$1,cljs.core.cst$kw$activities_DASH_by_DASH_effort);
ctx.strokeStyle = "#AAA";

ctx.lineWidth = .5;

ctx.beginPath();

var seq__20073_20210 = cljs.core.seq(activities_by_effort_20209);
var chunk__20075_20211 = null;
var count__20076_20212 = (0);
var i__20077_20213 = (0);
while(true){
if((i__20077_20213 < count__20076_20212)){
var map__20091_20214 = chunk__20075_20211.cljs$core$IIndexed$_nth$arity$2(null,i__20077_20213);
var map__20091_20215__$1 = (((((!((map__20091_20214 == null))))?(((((map__20091_20214.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20091_20214.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20091_20214):map__20091_20214);
var vec__20092_20216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20091_20215__$1,cljs.core.cst$kw$bounds);
var x_20217__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20092_20216,(0),null);
var y_20218__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20092_20216,(1),null);
var w_20219__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20092_20216,(2),null);
var h_20220__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20092_20216,(3),null);
var i_20221__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20091_20215__$1,cljs.core.cst$kw$i);
var location_20222 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20091_20215__$1,cljs.core.cst$kw$location);
var color_20223 = (cljs.core.truth_((selected_locations.cljs$core$IFn$_invoke$arity$1 ? selected_locations.cljs$core$IFn$_invoke$arity$1(location_20222) : selected_locations.call(null,location_20222)))?"salmon":cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clock_colors,i_20221__$1));
ctx.fillStyle = color_20223;

ctx.fillRect(x_20217__$1,y_20218__$1,w_20219__$1,h_20220__$1);

var G__20096_20224 = ctx;
G__20096_20224.moveTo(x_20217__$1,y_20218__$1);

G__20096_20224.lineTo((x_20217__$1 + w_20219__$1),y_20218__$1);



var G__20225 = seq__20073_20210;
var G__20226 = chunk__20075_20211;
var G__20227 = count__20076_20212;
var G__20228 = (i__20077_20213 + (1));
seq__20073_20210 = G__20225;
chunk__20075_20211 = G__20226;
count__20076_20212 = G__20227;
i__20077_20213 = G__20228;
continue;
} else {
var temp__5457__auto___20229__$1 = cljs.core.seq(seq__20073_20210);
if(temp__5457__auto___20229__$1){
var seq__20073_20230__$1 = temp__5457__auto___20229__$1;
if(cljs.core.chunked_seq_QMARK_(seq__20073_20230__$1)){
var c__4550__auto___20231 = cljs.core.chunk_first(seq__20073_20230__$1);
var G__20232 = cljs.core.chunk_rest(seq__20073_20230__$1);
var G__20233 = c__4550__auto___20231;
var G__20234 = cljs.core.count(c__4550__auto___20231);
var G__20235 = (0);
seq__20073_20210 = G__20232;
chunk__20075_20211 = G__20233;
count__20076_20212 = G__20234;
i__20077_20213 = G__20235;
continue;
} else {
var map__20097_20236 = cljs.core.first(seq__20073_20230__$1);
var map__20097_20237__$1 = (((((!((map__20097_20236 == null))))?(((((map__20097_20236.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20097_20236.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20097_20236):map__20097_20236);
var vec__20098_20238 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20097_20237__$1,cljs.core.cst$kw$bounds);
var x_20239__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20098_20238,(0),null);
var y_20240__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20098_20238,(1),null);
var w_20241__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20098_20238,(2),null);
var h_20242__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20098_20238,(3),null);
var i_20243__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20097_20237__$1,cljs.core.cst$kw$i);
var location_20244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20097_20237__$1,cljs.core.cst$kw$location);
var color_20245 = (cljs.core.truth_((selected_locations.cljs$core$IFn$_invoke$arity$1 ? selected_locations.cljs$core$IFn$_invoke$arity$1(location_20244) : selected_locations.call(null,location_20244)))?"salmon":cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clock_colors,i_20243__$1));
ctx.fillStyle = color_20245;

ctx.fillRect(x_20239__$1,y_20240__$1,w_20241__$1,h_20242__$1);

var G__20102_20246 = ctx;
G__20102_20246.moveTo(x_20239__$1,y_20240__$1);

G__20102_20246.lineTo((x_20239__$1 + w_20241__$1),y_20240__$1);



var G__20247 = cljs.core.next(seq__20073_20230__$1);
var G__20248 = null;
var G__20249 = (0);
var G__20250 = (0);
seq__20073_20210 = G__20247;
chunk__20075_20211 = G__20248;
count__20076_20212 = G__20249;
i__20077_20213 = G__20250;
continue;
}
} else {
}
}
break;
}

var G__20103_20251 = ctx;
G__20103_20251.closePath();

G__20103_20251.stroke();


ctx.fillStyle = "white";

ctx.strokeRect(x_20201,y_20202,day_width_20203__$1,day_height_20204);

ctx.fillStyle = "black";

if((day_width_20203__$1 > (15))){
var rotated_QMARK__20252 = (day_width_20203__$1 < (50));
ctx.textBaseline = "top";

ctx.textAlign = "center";

ctx.translate((x_20201 + (day_width_20203__$1 / (2))),(padding_top + ((5) + max_bar_h)));

if(rotated_QMARK__20252){
ctx.rotate(((45) * (Math.PI / (180))));
} else {
}

ctx.fillText(clojure.string.replace(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(day_20197,(5)),"-","/"),((rotated_QMARK__20252)?(10):(0)),(0));

ctx.setTransform((1),(0),(0),(1),(0),(0));

if((((minutes_20206 > (0))) && ((day_width_20203__$1 > (20))))){
ctx.fillText([cljs.core.str.cljs$core$IFn$_invoke$arity$1(org_analyzer.view.util.print_duration_mins(minutes_20206)),"h"].join(''),(x_20201 + (day_width_20203__$1 / (2))),(y_20202 - (10)));
} else {
}

} else {
}


var G__20253 = cljs.core.next(seq__19944_20190__$1);
var G__20254 = null;
var G__20255 = (0);
var G__20256 = (0);
seq__19944_20124 = G__20253;
chunk__19945_20125 = G__20254;
count__19946_20126 = G__20255;
i__19947_20127 = G__20256;
continue;
}
} else {
}
}
break;
}

return ctx.restore();
} else {
return null;
}
});})(clocks_by_day,calendar,clocks_by_day__$1,mins_by_day,hours_shown,label_height,padding_left,padding_right,padding_top,min_day_width,max_day_width,n_clocks,min_width,max_width,w,h,day_width,max_bar_h,hour_height,bounds_by_day,clock_colors,selected_locations))
], null)], null):null)], null);
});
