// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('org_analyzer.view.app');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('reagent.core');
goog.require('reagent.ratom');
goog.require('cljs_http.client');
goog.require('cljs.core.async');
goog.require('org_analyzer.view.info');
goog.require('org_analyzer.view.file_chooser');
goog.require('org_analyzer.view.calendar');
goog.require('org_analyzer.view.util');
goog.require('org_analyzer.view.clock_list');
goog.require('org_analyzer.view.selection');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('org_analyzer.view.tooltip');
goog.require('org_analyzer.view.search_view');
goog.require('cljs.reader');
goog.require('org_analyzer.view.help_view');
goog.require('cljs.pprint');
goog.require('org_analyzer.view.bar_chart');
org_analyzer.view.app.empty_app_state = (function org_analyzer$view$app$empty_app_state(var_args){
var G__20373 = arguments.length;
switch (G__20373) {
case 0:
return org_analyzer.view.app.empty_app_state.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return org_analyzer.view.app.empty_app_state.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

org_analyzer.view.app.empty_app_state.cljs$core$IFn$_invoke$arity$0 = (function (){
return org_analyzer.view.app.empty_app_state.cljs$core$IFn$_invoke$arity$1(null);
});

org_analyzer.view.app.empty_app_state.cljs$core$IFn$_invoke$arity$1 = (function (stored_known_org_files){
return reagent.ratom.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$time_DASH_line_DASH_tooltip,cljs.core.cst$kw$highlighted_DASH_entries,cljs.core.cst$kw$server_DASH_error,cljs.core.cst$kw$loading_QMARK_,cljs.core.cst$kw$clock_DASH_minute_DASH_intervals_DASH_by_DASH_day,cljs.core.cst$kw$clocks_DASH_by_DASH_day_DASH_filtered,cljs.core.cst$kw$selected_DASH_days,cljs.core.cst$kw$bar_DASH_chart_DASH_collapsed_QMARK_,cljs.core.cst$kw$hovered_DASH_over_DASH_date,cljs.core.cst$kw$search_DASH_input,cljs.core.cst$kw$stored_DASH_known_DASH_org_DASH_files,cljs.core.cst$kw$print_QMARK_,cljs.core.cst$kw$selected_DASH_days_DASH_preview,cljs.core.cst$kw$force_DASH_choosing_DASH_files,cljs.core.cst$kw$search_DASH_focused_QMARK_,cljs.core.cst$kw$clocks_DASH_collapsed_QMARK_,cljs.core.cst$kw$by_DASH_minute_DASH_collapsed_QMARK_,cljs.core.cst$kw$non_DASH_existing_DASH_org_DASH_files,cljs.core.cst$kw$selecting_QMARK_,cljs.core.cst$kw$calendar,cljs.core.cst$kw$highlighted_DASH_calendar_DASH_dates,cljs.core.cst$kw$info,cljs.core.cst$kw$clocks_DASH_by_DASH_day,cljs.core.cst$kw$known_DASH_org_DASH_files,cljs.core.cst$kw$clock_DASH_details_DASH_collapsed_QMARK_,cljs.core.cst$kw$show_DASH_help_QMARK_,cljs.core.cst$kw$calendar_DASH_collapsed_QMARK_,cljs.core.cst$kw$clock_DASH_list_DASH_group,cljs.core.cst$kw$bar_DASH_chart_DASH_tooltip],[null,cljs.core.PersistentHashSet.EMPTY,null,true,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentHashSet.EMPTY,false,null,"",stored_known_org_files,false,cljs.core.PersistentHashSet.EMPTY,false,false,false,false,null,false,null,cljs.core.PersistentHashSet.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$clock_DASH_count,(0),cljs.core.cst$kw$org_DASH_files,cljs.core.PersistentVector.EMPTY], null),cljs.core.PersistentArrayMap.EMPTY,null,false,false,false,null,null]));
});

org_analyzer.view.app.empty_app_state.cljs$lang$maxFixedArity = 1;

org_analyzer.view.app.empty_dom_state = (function org_analyzer$view$app$empty_dom_state(){
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$sel_DASH_rect,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(org_analyzer.view.selection.empty_rectangle_selection_state),cljs.core.cst$kw$keys,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$shift_DASH_down_QMARK_,false,cljs.core.cst$kw$alt_DASH_down_QMARK_,false], null),cljs.core.cst$kw$day_DASH_bounding_DASH_boxes,cljs.core.PersistentArrayMap.EMPTY], null));
});
org_analyzer.view.app.fetch_org_files_BANG_ = (function org_analyzer$view$app$fetch_org_files_BANG_(result_atom){
var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__){
return (function (state_20405){
var state_val_20406 = (state_20405[(1)]);
if((state_val_20406 === (7))){
var state_20405__$1 = state_20405;
var statearr_20407_20424 = state_20405__$1;
(statearr_20407_20424[(1)] = (9));



return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (1))){
var inst_20375 = [cljs.core.cst$kw$headers];
var inst_20376 = ["Cache-Control"];
var inst_20377 = ["no-cache"];
var inst_20378 = cljs.core.PersistentHashMap.fromArrays(inst_20376,inst_20377);
var inst_20379 = [inst_20378];
var inst_20380 = cljs.core.PersistentHashMap.fromArrays(inst_20375,inst_20379);
var inst_20381 = cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic("/known-org-files",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20380], 0));
var state_20405__$1 = state_20405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20405__$1,(2),inst_20381);
} else {
if((state_val_20406 === (4))){
var inst_20385 = (state_20405[(7)]);
var inst_20389 = typeof inst_20385 === 'string';
var state_20405__$1 = state_20405;
if(cljs.core.truth_(inst_20389)){
var statearr_20409_20425 = state_20405__$1;
(statearr_20409_20425[(1)] = (6));

} else {
var statearr_20410_20426 = state_20405__$1;
(statearr_20410_20426[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (6))){
var inst_20385 = (state_20405[(7)]);
var inst_20391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20392 = [inst_20385];
var inst_20393 = (new cljs.core.PersistentVector(null,1,(5),inst_20391,inst_20392,null));
var state_20405__$1 = state_20405;
var statearr_20411_20427 = state_20405__$1;
(statearr_20411_20427[(2)] = inst_20393);

(statearr_20411_20427[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (3))){
var state_20405__$1 = state_20405;
var statearr_20412_20428 = state_20405__$1;
(statearr_20412_20428[(2)] = null);

(statearr_20412_20428[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (2))){
var inst_20385 = (state_20405[(7)]);
var inst_20383 = (state_20405[(2)]);
var inst_20384 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_20383);
var inst_20385__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_20384);
var inst_20386 = cljs.core.empty_QMARK_(inst_20385__$1);
var state_20405__$1 = (function (){var statearr_20413 = state_20405;
(statearr_20413[(7)] = inst_20385__$1);

return statearr_20413;
})();
if(inst_20386){
var statearr_20414_20429 = state_20405__$1;
(statearr_20414_20429[(1)] = (3));

} else {
var statearr_20415_20430 = state_20405__$1;
(statearr_20415_20430[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (11))){
var inst_20398 = (state_20405[(2)]);
var state_20405__$1 = state_20405;
var statearr_20416_20431 = state_20405__$1;
(statearr_20416_20431[(2)] = inst_20398);

(statearr_20416_20431[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (9))){
var inst_20385 = (state_20405[(7)]);
var state_20405__$1 = state_20405;
var statearr_20417_20432 = state_20405__$1;
(statearr_20417_20432[(2)] = inst_20385);

(statearr_20417_20432[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (5))){
var inst_20402 = (state_20405[(2)]);
var inst_20403 = cljs.core.reset_BANG_(result_atom,inst_20402);
var state_20405__$1 = state_20405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20405__$1,inst_20403);
} else {
if((state_val_20406 === (10))){
var state_20405__$1 = state_20405;
var statearr_20418_20433 = state_20405__$1;
(statearr_20418_20433[(2)] = null);

(statearr_20418_20433[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20406 === (8))){
var inst_20400 = (state_20405[(2)]);
var state_20405__$1 = state_20405;
var statearr_20419_20434 = state_20405__$1;
(statearr_20419_20434[(2)] = inst_20400);

(statearr_20419_20434[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto__))
;
return ((function (switch__17043__auto__,c__17150__auto__){
return (function() {
var org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto__ = null;
var org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto____0 = (function (){
var statearr_20420 = [null,null,null,null,null,null,null,null];
(statearr_20420[(0)] = org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto__);

(statearr_20420[(1)] = (1));

return statearr_20420;
});
var org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto____1 = (function (state_20405){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_20405);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e20421){if((e20421 instanceof Object)){
var ex__17047__auto__ = e20421;
var statearr_20422_20435 = state_20405;
(statearr_20422_20435[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20405);

return cljs.core.cst$kw$recur;
} else {
throw e20421;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__20436 = state_20405;
state_20405 = G__20436;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto__ = function(state_20405){
switch(arguments.length){
case 0:
return org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto____0.call(this);
case 1:
return org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto____1.call(this,state_20405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto____0;
org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto____1;
return org_analyzer$view$app$fetch_org_files_BANG__$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__))
})();
var state__17152__auto__ = (function (){var statearr_20423 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_20423[(6)] = c__17150__auto__);

return statearr_20423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__))
);

return c__17150__auto__;
});
org_analyzer.view.app.post_org_files = (function org_analyzer$view$app$post_org_files(org_files_and_dirs){
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$form_DASH_params,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$files,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([org_files_and_dirs], 0))], null)], null)], 0));

var c__17150__auto___20458 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___20458,result_chan){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___20458,result_chan){
return (function (state_20452){
var state_val_20453 = (state_20452[(1)]);
if((state_val_20453 === (1))){
var inst_20437 = [cljs.core.cst$kw$form_DASH_params];
var inst_20438 = [cljs.core.cst$kw$files];
var inst_20439 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([org_files_and_dirs], 0));
var inst_20440 = [inst_20439];
var inst_20441 = cljs.core.PersistentHashMap.fromArrays(inst_20438,inst_20440);
var inst_20442 = [inst_20441];
var inst_20443 = cljs.core.PersistentHashMap.fromArrays(inst_20437,inst_20442);
var inst_20444 = cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic("/known-org-files",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20443], 0));
var state_20452__$1 = state_20452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20452__$1,(2),inst_20444);
} else {
if((state_val_20453 === (2))){
var inst_20446 = (state_20452[(2)]);
var inst_20447 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_20446);
var inst_20448 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_20447);
var state_20452__$1 = state_20452;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20452__$1,(3),result_chan,inst_20448);
} else {
if((state_val_20453 === (3))){
var inst_20450 = (state_20452[(2)]);
var state_20452__$1 = state_20452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20452__$1,inst_20450);
} else {
return null;
}
}
}
});})(c__17150__auto___20458,result_chan))
;
return ((function (switch__17043__auto__,c__17150__auto___20458,result_chan){
return (function() {
var org_analyzer$view$app$post_org_files_$_state_machine__17044__auto__ = null;
var org_analyzer$view$app$post_org_files_$_state_machine__17044__auto____0 = (function (){
var statearr_20454 = [null,null,null,null,null,null,null];
(statearr_20454[(0)] = org_analyzer$view$app$post_org_files_$_state_machine__17044__auto__);

(statearr_20454[(1)] = (1));

return statearr_20454;
});
var org_analyzer$view$app$post_org_files_$_state_machine__17044__auto____1 = (function (state_20452){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_20452);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e20455){if((e20455 instanceof Object)){
var ex__17047__auto__ = e20455;
var statearr_20456_20459 = state_20452;
(statearr_20456_20459[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20452);

return cljs.core.cst$kw$recur;
} else {
throw e20455;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__20460 = state_20452;
state_20452 = G__20460;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
org_analyzer$view$app$post_org_files_$_state_machine__17044__auto__ = function(state_20452){
switch(arguments.length){
case 0:
return org_analyzer$view$app$post_org_files_$_state_machine__17044__auto____0.call(this);
case 1:
return org_analyzer$view$app$post_org_files_$_state_machine__17044__auto____1.call(this,state_20452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org_analyzer$view$app$post_org_files_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = org_analyzer$view$app$post_org_files_$_state_machine__17044__auto____0;
org_analyzer$view$app$post_org_files_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = org_analyzer$view$app$post_org_files_$_state_machine__17044__auto____1;
return org_analyzer$view$app$post_org_files_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___20458,result_chan))
})();
var state__17152__auto__ = (function (){var statearr_20457 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_20457[(6)] = c__17150__auto___20458);

return statearr_20457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___20458,result_chan))
);


return result_chan;
});
org_analyzer.view.app.prepare_fetched_clocks = (function org_analyzer$view$app$prepare_fetched_clocks(info,clocks,calendar){
var clocks_by_day = cljs.core.group_by((function (p1__20461_SHARP_){
return cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(p1__20461_SHARP_),/ /));
}),clocks);
var clocks_by_day__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by(cljs.core._LT_),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (clocks_by_day){
return (function (p1__20462_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__20462_SHARP_,cljs.core.PersistentVector.EMPTY],null));
});})(clocks_by_day))
,clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(calendar)),cljs.core.set(cljs.core.keys(clocks_by_day))))),clocks_by_day], 0));
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$calendar,calendar,cljs.core.cst$kw$info,info,cljs.core.cst$kw$clocks_DASH_by_DASH_day,clocks_by_day__$1,cljs.core.cst$kw$clock_DASH_minute_DASH_intervals_DASH_by_DASH_day,org_analyzer.view.util.clock_minute_intervals_by_day(clocks_by_day__$1),cljs.core.cst$kw$clocks_DASH_by_DASH_day_DASH_filtered,clocks_by_day__$1,cljs.core.cst$kw$clock_DASH_minute_DASH_intervals_DASH_by_DASH_day_DASH_filtered,org_analyzer.view.util.clock_minute_intervals_by_day(clocks_by_day__$1)], null);
});
org_analyzer.view.app.fetch_clocks = (function org_analyzer$view$app$fetch_clocks(var_args){
var args__4736__auto__ = [];
var len__4730__auto___20601 = arguments.length;
var i__4731__auto___20602 = (0);
while(true){
if((i__4731__auto___20602 < len__4730__auto___20601)){
args__4736__auto__.push((arguments[i__4731__auto___20602]));

var G__20603 = (i__4731__auto___20602 + (1));
i__4731__auto___20602 = G__20603;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return org_analyzer.view.app.fetch_clocks.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

org_analyzer.view.app.fetch_clocks.cljs$core$IFn$_invoke$arity$variadic = (function (p__20464){
var map__20465 = p__20464;
var map__20465__$1 = (((((!((map__20465 == null))))?(((((map__20465.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20465.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20465):map__20465);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20465__$1,cljs.core.cst$kw$from,(new Date("1900-01-01")));
var to = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__20465__$1,cljs.core.cst$kw$to,(new Date()));
var result_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var from__$1 = org_analyzer.view.util.format_date_time(from);
var to__$1 = org_analyzer.view.util.format_date_time(to);
var c__17150__auto___20604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___20604,result_chan,from__$1,to__$1,map__20465,map__20465__$1,from,to){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___20604,result_chan,from__$1,to__$1,map__20465,map__20465__$1,from,to){
return (function (state_20559){
var state_val_20560 = (state_20559[(1)]);
if((state_val_20560 === (7))){
var inst_20479 = (state_20559[(7)]);
var inst_20495 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_20479);
var inst_20496 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_20495);
var state_20559__$1 = state_20559;
var statearr_20561_20605 = state_20559__$1;
(statearr_20561_20605[(2)] = inst_20496);

(statearr_20561_20605[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (20))){
var inst_20492 = (state_20559[(8)]);
var inst_20525 = (state_20559[(2)]);
var inst_20526 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20525], 0));
var state_20559__$1 = (function (){var statearr_20562 = state_20559;
(statearr_20562[(9)] = inst_20526);

return statearr_20562;
})();
if(cljs.core.truth_(inst_20492)){
var statearr_20563_20606 = state_20559__$1;
(statearr_20563_20606[(1)] = (21));

} else {
var statearr_20564_20607 = state_20559__$1;
(statearr_20564_20607[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (1))){
var inst_20468 = [cljs.core.cst$kw$query_DASH_params,cljs.core.cst$kw$headers];
var inst_20469 = [cljs.core.cst$kw$from,cljs.core.cst$kw$to,cljs.core.cst$kw$by_DASH_day_QMARK_];
var inst_20470 = [from__$1,to__$1,true];
var inst_20471 = cljs.core.PersistentHashMap.fromArrays(inst_20469,inst_20470);
var inst_20472 = ["Cache-Control"];
var inst_20473 = ["no-cache"];
var inst_20474 = cljs.core.PersistentHashMap.fromArrays(inst_20472,inst_20473);
var inst_20475 = [inst_20471,inst_20474];
var inst_20476 = cljs.core.PersistentHashMap.fromArrays(inst_20468,inst_20475);
var inst_20477 = cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic("/clocks",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20476], 0));
var state_20559__$1 = state_20559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20559__$1,(2),inst_20477);
} else {
if((state_val_20560 === (24))){
var inst_20529 = (state_20559[(2)]);
var inst_20530 = cljs.core.async.close_BANG_(result_chan);
var state_20559__$1 = (function (){var statearr_20565 = state_20559;
(statearr_20565[(10)] = inst_20529);

return statearr_20565;
})();
var statearr_20566_20608 = state_20559__$1;
(statearr_20566_20608[(2)] = inst_20530);

(statearr_20566_20608[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (4))){
var inst_20479 = (state_20559[(7)]);
var inst_20483 = [cljs.core.cst$kw$error];
var inst_20484 = [cljs.core.cst$kw$description,cljs.core.cst$kw$short];
var inst_20485 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_20479);
var inst_20486 = cljs.core.cst$kw$error_DASH_text.cljs$core$IFn$_invoke$arity$1(inst_20479);
var inst_20487 = [inst_20485,inst_20486];
var inst_20488 = cljs.core.PersistentHashMap.fromArrays(inst_20484,inst_20487);
var inst_20489 = [inst_20488];
var inst_20490 = cljs.core.PersistentHashMap.fromArrays(inst_20483,inst_20489);
var state_20559__$1 = state_20559;
var statearr_20567_20609 = state_20559__$1;
(statearr_20567_20609[(2)] = inst_20490);

(statearr_20567_20609[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (15))){
var inst_20498 = (state_20559[(11)]);
var inst_20516 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20498);
var state_20559__$1 = state_20559;
var statearr_20568_20610 = state_20559__$1;
(statearr_20568_20610[(2)] = inst_20516);

(statearr_20568_20610[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (21))){
var inst_20492 = (state_20559[(8)]);
var state_20559__$1 = state_20559;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20559__$1,(24),result_chan,inst_20492);
} else {
if((state_val_20560 === (13))){
var state_20559__$1 = state_20559;
var statearr_20569_20611 = state_20559__$1;
(statearr_20569_20611[(2)] = false);

(statearr_20569_20611[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (22))){
var inst_20520 = (state_20559[(12)]);
var inst_20532 = cljs.core.first(inst_20520);
var inst_20533 = cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(inst_20532);
var inst_20534 = cljs.core.last(inst_20520);
var inst_20535 = cljs.core.cst$kw$end.cljs$core$IFn$_invoke$arity$1(inst_20534);
var inst_20536 = [cljs.core.cst$kw$query_DASH_params];
var inst_20537 = [cljs.core.cst$kw$from,cljs.core.cst$kw$to];
var inst_20538 = [inst_20533,inst_20535];
var inst_20539 = cljs.core.PersistentHashMap.fromArrays(inst_20537,inst_20538);
var inst_20540 = [inst_20539];
var inst_20541 = cljs.core.PersistentHashMap.fromArrays(inst_20536,inst_20540);
var inst_20542 = cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic("/calendar",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20541], 0));
var state_20559__$1 = state_20559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20559__$1,(25),inst_20542);
} else {
if((state_val_20560 === (6))){
var state_20559__$1 = state_20559;
var statearr_20570_20612 = state_20559__$1;
(statearr_20570_20612[(2)] = null);

(statearr_20570_20612[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (25))){
var inst_20520 = (state_20559[(12)]);
var inst_20521 = (state_20559[(13)]);
var inst_20544 = (state_20559[(2)]);
var inst_20545 = cljs.core.sorted_map_by(cljs.core._LT_);
var inst_20546 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$date,cljs.core.identity);
var inst_20547 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_20544);
var inst_20548 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_20547);
var inst_20549 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20546,inst_20548);
var inst_20550 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20545,inst_20549);
var inst_20551 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["got calendar"], 0));
var inst_20552 = org_analyzer.view.app.prepare_fetched_clocks(inst_20521,inst_20520,inst_20550);
var state_20559__$1 = (function (){var statearr_20571 = state_20559;
(statearr_20571[(14)] = inst_20551);

return statearr_20571;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_20559__$1,(26),result_chan,inst_20552);
} else {
if((state_val_20560 === (17))){
var inst_20492 = (state_20559[(8)]);
var inst_20519 = (state_20559[(2)]);
var inst_20520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20519,cljs.core.cst$kw$clocks);
var inst_20521 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20519,cljs.core.cst$kw$info);
var state_20559__$1 = (function (){var statearr_20572 = state_20559;
(statearr_20572[(12)] = inst_20520);

(statearr_20572[(13)] = inst_20521);

return statearr_20572;
})();
if(cljs.core.truth_(inst_20492)){
var statearr_20573_20613 = state_20559__$1;
(statearr_20573_20613[(1)] = (18));

} else {
var statearr_20574_20614 = state_20559__$1;
(statearr_20574_20614[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (3))){
var state_20559__$1 = state_20559;
var statearr_20575_20615 = state_20559__$1;
(statearr_20575_20615[(2)] = null);

(statearr_20575_20615[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (12))){
var state_20559__$1 = state_20559;
var statearr_20576_20616 = state_20559__$1;
(statearr_20576_20616[(2)] = true);

(statearr_20576_20616[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (2))){
var inst_20479 = (state_20559[(7)]);
var inst_20479__$1 = (state_20559[(2)]);
var inst_20480 = cljs.core.cst$kw$success.cljs$core$IFn$_invoke$arity$1(inst_20479__$1);
var state_20559__$1 = (function (){var statearr_20577 = state_20559;
(statearr_20577[(7)] = inst_20479__$1);

return statearr_20577;
})();
if(cljs.core.truth_(inst_20480)){
var statearr_20578_20617 = state_20559__$1;
(statearr_20578_20617[(1)] = (3));

} else {
var statearr_20579_20618 = state_20559__$1;
(statearr_20579_20618[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (23))){
var inst_20557 = (state_20559[(2)]);
var state_20559__$1 = state_20559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20559__$1,inst_20557);
} else {
if((state_val_20560 === (19))){
var state_20559__$1 = state_20559;
var statearr_20580_20619 = state_20559__$1;
(statearr_20580_20619[(2)] = "got clocks");

(statearr_20580_20619[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (11))){
var inst_20514 = (state_20559[(2)]);
var state_20559__$1 = state_20559;
if(cljs.core.truth_(inst_20514)){
var statearr_20581_20620 = state_20559__$1;
(statearr_20581_20620[(1)] = (15));

} else {
var statearr_20582_20621 = state_20559__$1;
(statearr_20582_20621[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (9))){
var inst_20498 = (state_20559[(11)]);
var inst_20503 = inst_20498.cljs$lang$protocol_mask$partition0$;
var inst_20504 = (inst_20503 & (64));
var inst_20505 = inst_20498.cljs$core$ISeq$;
var inst_20506 = (cljs.core.PROTOCOL_SENTINEL === inst_20505);
var inst_20507 = ((inst_20504) || (inst_20506));
var state_20559__$1 = state_20559;
if(cljs.core.truth_(inst_20507)){
var statearr_20583_20622 = state_20559__$1;
(statearr_20583_20622[(1)] = (12));

} else {
var statearr_20584_20623 = state_20559__$1;
(statearr_20584_20623[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (5))){
var inst_20492 = (state_20559[(8)]);
var inst_20492__$1 = (state_20559[(2)]);
var state_20559__$1 = (function (){var statearr_20585 = state_20559;
(statearr_20585[(8)] = inst_20492__$1);

return statearr_20585;
})();
if(cljs.core.truth_(inst_20492__$1)){
var statearr_20586_20624 = state_20559__$1;
(statearr_20586_20624[(1)] = (6));

} else {
var statearr_20587_20625 = state_20559__$1;
(statearr_20587_20625[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (14))){
var inst_20511 = (state_20559[(2)]);
var state_20559__$1 = state_20559;
var statearr_20588_20626 = state_20559__$1;
(statearr_20588_20626[(2)] = inst_20511);

(statearr_20588_20626[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (26))){
var inst_20554 = (state_20559[(2)]);
var inst_20555 = cljs.core.async.close_BANG_(result_chan);
var state_20559__$1 = (function (){var statearr_20589 = state_20559;
(statearr_20589[(15)] = inst_20554);

return statearr_20589;
})();
var statearr_20590_20627 = state_20559__$1;
(statearr_20590_20627[(2)] = inst_20555);

(statearr_20590_20627[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (16))){
var inst_20498 = (state_20559[(11)]);
var state_20559__$1 = state_20559;
var statearr_20591_20628 = state_20559__$1;
(statearr_20591_20628[(2)] = inst_20498);

(statearr_20591_20628[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (10))){
var state_20559__$1 = state_20559;
var statearr_20592_20629 = state_20559__$1;
(statearr_20592_20629[(2)] = false);

(statearr_20592_20629[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (18))){
var state_20559__$1 = state_20559;
var statearr_20593_20630 = state_20559__$1;
(statearr_20593_20630[(2)] = "error fetching clocks");

(statearr_20593_20630[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20560 === (8))){
var inst_20498 = (state_20559[(11)]);
var inst_20498__$1 = (state_20559[(2)]);
var inst_20500 = (inst_20498__$1 == null);
var inst_20501 = cljs.core.not(inst_20500);
var state_20559__$1 = (function (){var statearr_20594 = state_20559;
(statearr_20594[(11)] = inst_20498__$1);

return statearr_20594;
})();
if(inst_20501){
var statearr_20595_20631 = state_20559__$1;
(statearr_20595_20631[(1)] = (9));

} else {
var statearr_20596_20632 = state_20559__$1;
(statearr_20596_20632[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___20604,result_chan,from__$1,to__$1,map__20465,map__20465__$1,from,to))
;
return ((function (switch__17043__auto__,c__17150__auto___20604,result_chan,from__$1,to__$1,map__20465,map__20465__$1,from,to){
return (function() {
var org_analyzer$view$app$state_machine__17044__auto__ = null;
var org_analyzer$view$app$state_machine__17044__auto____0 = (function (){
var statearr_20597 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20597[(0)] = org_analyzer$view$app$state_machine__17044__auto__);

(statearr_20597[(1)] = (1));

return statearr_20597;
});
var org_analyzer$view$app$state_machine__17044__auto____1 = (function (state_20559){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_20559);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e20598){if((e20598 instanceof Object)){
var ex__17047__auto__ = e20598;
var statearr_20599_20633 = state_20559;
(statearr_20599_20633[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20559);

return cljs.core.cst$kw$recur;
} else {
throw e20598;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__20634 = state_20559;
state_20559 = G__20634;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
org_analyzer$view$app$state_machine__17044__auto__ = function(state_20559){
switch(arguments.length){
case 0:
return org_analyzer$view$app$state_machine__17044__auto____0.call(this);
case 1:
return org_analyzer$view$app$state_machine__17044__auto____1.call(this,state_20559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org_analyzer$view$app$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = org_analyzer$view$app$state_machine__17044__auto____0;
org_analyzer$view$app$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = org_analyzer$view$app$state_machine__17044__auto____1;
return org_analyzer$view$app$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___20604,result_chan,from__$1,to__$1,map__20465,map__20465__$1,from,to))
})();
var state__17152__auto__ = (function (){var statearr_20600 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_20600[(6)] = c__17150__auto___20604);

return statearr_20600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___20604,result_chan,from__$1,to__$1,map__20465,map__20465__$1,from,to))
);


return result_chan;
});

org_analyzer.view.app.fetch_clocks.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
org_analyzer.view.app.fetch_clocks.cljs$lang$applyTo = (function (seq20463){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq20463));
});

org_analyzer.view.app.fetch_and_update_BANG_ = (function org_analyzer$view$app$fetch_and_update_BANG_(app_state){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$loading_QMARK_,true);

var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__){
return (function (state_20643){
var state_val_20644 = (state_20643[(1)]);
if((state_val_20644 === (1))){
var inst_20635 = org_analyzer.view.app.fetch_clocks();
var state_20643__$1 = state_20643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20643__$1,(2),inst_20635);
} else {
if((state_val_20644 === (2))){
var inst_20637 = (state_20643[(2)]);
var inst_20638 = [cljs.core.cst$kw$loading_QMARK_];
var inst_20639 = [false];
var inst_20640 = cljs.core.PersistentHashMap.fromArrays(inst_20638,inst_20639);
var inst_20641 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.merge,inst_20637,inst_20640);
var state_20643__$1 = state_20643;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20643__$1,inst_20641);
} else {
return null;
}
}
});})(c__17150__auto__))
;
return ((function (switch__17043__auto__,c__17150__auto__){
return (function() {
var org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto__ = null;
var org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto____0 = (function (){
var statearr_20645 = [null,null,null,null,null,null,null];
(statearr_20645[(0)] = org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto__);

(statearr_20645[(1)] = (1));

return statearr_20645;
});
var org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto____1 = (function (state_20643){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_20643);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e20646){if((e20646 instanceof Object)){
var ex__17047__auto__ = e20646;
var statearr_20647_20649 = state_20643;
(statearr_20647_20649[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20643);

return cljs.core.cst$kw$recur;
} else {
throw e20646;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__20650 = state_20643;
state_20643 = G__20650;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto__ = function(state_20643){
switch(arguments.length){
case 0:
return org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto____0.call(this);
case 1:
return org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto____1.call(this,state_20643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto____0;
org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto____1;
return org_analyzer$view$app$fetch_and_update_BANG__$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__))
})();
var state__17152__auto__ = (function (){var statearr_20648 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_20648[(6)] = c__17150__auto__);

return statearr_20648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__))
);

return c__17150__auto__;
});
org_analyzer.view.app.send_cancel_kill_server_request_BANG_ = (function org_analyzer$view$app$send_cancel_kill_server_request_BANG_(){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["sending server cancel kill request"], 0));

return cljs_http.client.post("/cancel-kill");
});
org_analyzer.view.app.send_kill_server_request_BANG_ = (function org_analyzer$view$app$send_kill_server_request_BANG_(){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["sending server kill request"], 0));

return cljs_http.client.post("/kill");
});
org_analyzer.view.app.event_handlers = (function org_analyzer$view$app$event_handlers(app_state,dom_state){
var set_key_down_BANG_ = (function org_analyzer$view$app$event_handlers_$_set_key_down_BANG_(evt,key,field,down_QMARK_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,evt.key)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dom_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$keys,field], null),down_QMARK_);
} else {
return null;
}
});
var on_key_down_global = (function org_analyzer$view$app$event_handlers_$_on_key_down_global(evt){
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("a",evt.key);
if(and__4120__auto__){
return evt.ctrlKey;
} else {
return and__4120__auto__;
}
})())){
var all_days_20652 = cljs.core.set(cljs.core.keys(cljs.core.cst$kw$calendar.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state))));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.update,cljs.core.cst$kw$selected_DASH_days,((function (all_days_20652){
return (function (p1__20651_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__20651_SHARP_,all_days_20652)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
return all_days_20652;
}
});})(all_days_20652))
);

evt.preventDefault();
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("s",evt.key);
if(and__4120__auto__){
return evt.ctrlKey;
} else {
return and__4120__auto__;
}
})())){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$search_DASH_focused_QMARK_,true);

evt.preventDefault();
} else {
}
}

set_key_down_BANG_(evt,"Alt",cljs.core.cst$kw$alt_DASH_down_QMARK_,true);

return set_key_down_BANG_(evt,"Shift",cljs.core.cst$kw$shift_DASH_down_QMARK_,true);
});
var on_key_up_global = (function org_analyzer$view$app$event_handlers_$_on_key_up_global(evt){
set_key_down_BANG_(evt,"Alt",cljs.core.cst$kw$alt_DASH_down_QMARK_,false);

return set_key_down_BANG_(evt,"Shift",cljs.core.cst$kw$shift_DASH_down_QMARK_,false);
});
var on_document_mouseout = (function org_analyzer$view$app$event_handlers_$_on_document_mouseout(evt){
var from = (function (){var or__4131__auto__ = evt.toElement;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return evt.relatedTarget;
}
})();
var out_of_window_QMARK_ = ((cljs.core.not(from)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("HTML",from.nodeName)));
if(out_of_window_QMARK_){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dom_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$keys,cljs.core.cst$kw$alt_DASH_down_QMARK_], null),false);

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(dom_state,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$keys,cljs.core.cst$kw$shift_DASH_down_QMARK_], null),false);
} else {
return null;
}
});
var on_window_resize = (function org_analyzer$view$app$event_handlers_$_on_window_resize(_evt){
return null;
});
var on_exit = (function org_analyzer$view$app$event_handlers_$_on_exit(_evt){
org_analyzer.view.app.send_kill_server_request_BANG_();

return null;
});
var on_before_print = (function org_analyzer$view$app$event_handlers_$_on_before_print(_evt){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$print_QMARK_,true);
});
var on_after_print = (function org_analyzer$view$app$event_handlers_$_on_after_print(_evt){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$print_QMARK_,false);
});
window.onbeforeunload = on_exit;

document.addEventListener("keydown",on_key_down_global);

document.addEventListener("keyup",on_key_up_global);

document.addEventListener("mouseout",on_document_mouseout);

window.addEventListener("resize",on_window_resize);

window.addEventListener("beforeprint",on_before_print);

window.addEventListener("afterprint",on_after_print);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["global event handlers registered"], 0));

return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([org_analyzer.view.calendar.event_handlers(app_state,dom_state),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$on_DASH_key_DASH_down_DASH_global,on_key_down_global,cljs.core.cst$kw$on_DASH_key_DASH_up_DASH_global,on_key_up_global,cljs.core.cst$kw$on_DASH_window_DASH_resize,on_window_resize], null)], 0));
});
org_analyzer.view.app.controls = (function org_analyzer$view$app$controls(app_state){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$controls,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$material_DASH_button,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$force_DASH_choosing_DASH_files,true);
}),cljs.core.cst$kw$title,"select org files"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$material_DASH_icons,"insert_drive_file"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$material_DASH_button,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,(function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$print_QMARK_,true);

return setTimeout((function (){
return window.print();
}),(100));
}),cljs.core.cst$kw$title,"print / save as pdf"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$material_DASH_icons,"print"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$material_DASH_button,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$show_DASH_info_QMARK_,true);
}),cljs.core.cst$kw$title,cljs.pprint.cl_format.cljs$core$IFn$_invoke$arity$variadic(null,"~a clock~:*~P",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$clock_DASH_count.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)))], 0))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$material_DASH_icons,"info"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$material_DASH_button,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$on_DASH_click,(function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$show_DASH_help_QMARK_,true);
}),cljs.core.cst$kw$title,"show help"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$material_DASH_icons,"help"], null)], null)], null);
});
org_analyzer.view.app.collapsible_STAR_ = (function org_analyzer$view$app$collapsible_STAR_(title,_key,collapsed_atom,comp_fn){
var collapsed_QMARK_ = cljs.core.deref(collapsed_atom);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$elev_DASH_2,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [["panel-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.lower_case(title))].join(''),(cljs.core.truth_(collapsed_QMARK_)?"collapsed":"")], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$material_DASH_button,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (collapsed_QMARK_){
return (function (){
return cljs.core.reset_BANG_(collapsed_atom,cljs.core.not(collapsed_QMARK_));
});})(collapsed_QMARK_))
], null),title,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$material_DASH_icons,(cljs.core.truth_(collapsed_QMARK_)?"expand_less":"expand_more")], null)], null),(cljs.core.truth_(collapsed_QMARK_)?null:(comp_fn.cljs$core$IFn$_invoke$arity$0 ? comp_fn.cljs$core$IFn$_invoke$arity$0() : comp_fn.call(null)))], null);
});
org_analyzer.view.app.app = (function org_analyzer$view$app$app(app_state,dom_state,event_handlers){
if(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.empty_QMARK_(cljs.core.cst$kw$known_DASH_org_DASH_files.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)));
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$force_DASH_choosing_DASH_files.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state));
}
})())){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.file_chooser.file_chooser,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text_DASH_align,"center"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,((cljs.core.empty_QMARK_(cljs.core.cst$kw$known_DASH_org_DASH_files.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state))))?"Currently no org files or directories are known.":"")], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$br], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,"Please add or remove org files and directories below, then click the confirm button."], null)], null),cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20653_SHARP_){
return clojure.string.replace(p1__20653_SHARP_,/\/$/,"");
}),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$known_DASH_org_DASH_files.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)),cljs.core.cst$kw$stored_DASH_known_DASH_org_DASH_files.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state))))),cljs.core.cst$kw$non_DASH_existing_DASH_org_DASH_files.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)),(function (files){
var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__){
return (function (state_20694){
var state_val_20695 = (state_20694[(1)]);
if((state_val_20695 === (7))){
var state_20694__$1 = state_20694;
var statearr_20696_20721 = state_20694__$1;
(statearr_20696_20721[(2)] = false);

(statearr_20696_20721[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (1))){
var inst_20656 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(files);
var inst_20657 = org_analyzer.view.app.post_org_files(inst_20656);
var state_20694__$1 = state_20694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20694__$1,(2),inst_20657);
} else {
if((state_val_20695 === (4))){
var state_20694__$1 = state_20694;
var statearr_20697_20722 = state_20694__$1;
(statearr_20697_20722[(2)] = false);

(statearr_20697_20722[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (13))){
var state_20694__$1 = state_20694;
var statearr_20698_20723 = state_20694__$1;
(statearr_20698_20723[(2)] = null);

(statearr_20698_20723[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (6))){
var state_20694__$1 = state_20694;
var statearr_20699_20724 = state_20694__$1;
(statearr_20699_20724[(2)] = true);

(statearr_20699_20724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (3))){
var inst_20659 = (state_20694[(7)]);
var inst_20664 = inst_20659.cljs$lang$protocol_mask$partition0$;
var inst_20665 = (inst_20664 & (64));
var inst_20666 = inst_20659.cljs$core$ISeq$;
var inst_20667 = (cljs.core.PROTOCOL_SENTINEL === inst_20666);
var inst_20668 = ((inst_20665) || (inst_20667));
var state_20694__$1 = state_20694;
if(cljs.core.truth_(inst_20668)){
var statearr_20700_20725 = state_20694__$1;
(statearr_20700_20725[(1)] = (6));

} else {
var statearr_20701_20726 = state_20694__$1;
(statearr_20701_20726[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (12))){
var inst_20681 = (state_20694[(8)]);
var inst_20686 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_20681], 0));
var inst_20687 = localStorage.setItem("org-analyzer-files",inst_20686);
var inst_20688 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.assoc,cljs.core.cst$kw$force_DASH_choosing_DASH_files,false,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$stored_DASH_known_DASH_org_DASH_files,null], 0));
var inst_20689 = org_analyzer.view.app.fetch_and_update_BANG_(app_state);
var state_20694__$1 = (function (){var statearr_20702 = state_20694;
(statearr_20702[(9)] = inst_20688);

(statearr_20702[(10)] = inst_20687);

return statearr_20702;
})();
var statearr_20703_20727 = state_20694__$1;
(statearr_20703_20727[(2)] = inst_20689);

(statearr_20703_20727[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (2))){
var inst_20659 = (state_20694[(7)]);
var inst_20659__$1 = (state_20694[(2)]);
var inst_20661 = (inst_20659__$1 == null);
var inst_20662 = cljs.core.not(inst_20661);
var state_20694__$1 = (function (){var statearr_20704 = state_20694;
(statearr_20704[(7)] = inst_20659__$1);

return statearr_20704;
})();
if(inst_20662){
var statearr_20705_20728 = state_20694__$1;
(statearr_20705_20728[(1)] = (3));

} else {
var statearr_20706_20729 = state_20694__$1;
(statearr_20706_20729[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (11))){
var inst_20681 = (state_20694[(8)]);
var inst_20680 = (state_20694[(2)]);
var inst_20681__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20680,cljs.core.cst$kw$existing);
var inst_20682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20680,cljs.core.cst$kw$non_DASH_existing);
var inst_20683 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(app_state,cljs.core.assoc,cljs.core.cst$kw$known_DASH_org_DASH_files,inst_20681__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$non_DASH_existing_DASH_org_DASH_files,inst_20682], 0));
var inst_20684 = cljs.core.not_empty(inst_20681__$1);
var state_20694__$1 = (function (){var statearr_20707 = state_20694;
(statearr_20707[(8)] = inst_20681__$1);

(statearr_20707[(11)] = inst_20683);

return statearr_20707;
})();
if(cljs.core.truth_(inst_20684)){
var statearr_20708_20730 = state_20694__$1;
(statearr_20708_20730[(1)] = (12));

} else {
var statearr_20709_20731 = state_20694__$1;
(statearr_20709_20731[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (9))){
var inst_20659 = (state_20694[(7)]);
var inst_20677 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_20659);
var state_20694__$1 = state_20694;
var statearr_20710_20732 = state_20694__$1;
(statearr_20710_20732[(2)] = inst_20677);

(statearr_20710_20732[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (5))){
var inst_20675 = (state_20694[(2)]);
var state_20694__$1 = state_20694;
if(cljs.core.truth_(inst_20675)){
var statearr_20711_20733 = state_20694__$1;
(statearr_20711_20733[(1)] = (9));

} else {
var statearr_20712_20734 = state_20694__$1;
(statearr_20712_20734[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (14))){
var inst_20692 = (state_20694[(2)]);
var state_20694__$1 = state_20694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20694__$1,inst_20692);
} else {
if((state_val_20695 === (10))){
var inst_20659 = (state_20694[(7)]);
var state_20694__$1 = state_20694;
var statearr_20713_20735 = state_20694__$1;
(statearr_20713_20735[(2)] = inst_20659);

(statearr_20713_20735[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_20695 === (8))){
var inst_20672 = (state_20694[(2)]);
var state_20694__$1 = state_20694;
var statearr_20714_20736 = state_20694__$1;
(statearr_20714_20736[(2)] = inst_20672);

(statearr_20714_20736[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto__))
;
return ((function (switch__17043__auto__,c__17150__auto__){
return (function() {
var org_analyzer$view$app$app_$_state_machine__17044__auto__ = null;
var org_analyzer$view$app$app_$_state_machine__17044__auto____0 = (function (){
var statearr_20715 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20715[(0)] = org_analyzer$view$app$app_$_state_machine__17044__auto__);

(statearr_20715[(1)] = (1));

return statearr_20715;
});
var org_analyzer$view$app$app_$_state_machine__17044__auto____1 = (function (state_20694){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_20694);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e20716){if((e20716 instanceof Object)){
var ex__17047__auto__ = e20716;
var statearr_20717_20737 = state_20694;
(statearr_20717_20737[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_20694);

return cljs.core.cst$kw$recur;
} else {
throw e20716;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__20738 = state_20694;
state_20694 = G__20738;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
org_analyzer$view$app$app_$_state_machine__17044__auto__ = function(state_20694){
switch(arguments.length){
case 0:
return org_analyzer$view$app$app_$_state_machine__17044__auto____0.call(this);
case 1:
return org_analyzer$view$app$app_$_state_machine__17044__auto____1.call(this,state_20694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org_analyzer$view$app$app_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = org_analyzer$view$app$app_$_state_machine__17044__auto____0;
org_analyzer$view$app$app_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = org_analyzer$view$app$app_$_state_machine__17044__auto____1;
return org_analyzer$view$app$app_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__))
})();
var state__17152__auto__ = (function (){var statearr_20718 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_20718[(6)] = c__17150__auto__);

return statearr_20718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__))
);

return c__17150__auto__;
})], null);
} else {
if(cljs.core.truth_(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$error,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$ref,(function (p1__20654_SHARP_){
if(cljs.core.truth_(p1__20654_SHARP_)){
return p1__20654_SHARP_.innerHTML = cljs.core.cst$kw$description.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)));
} else {
return null;
}
})], null)], null)], null);
} else {
var map__20719 = cljs.core.deref(app_state);
var map__20719__$1 = (((((!((map__20719 == null))))?(((((map__20719.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20719.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__20719):map__20719);
var hovered_over_date = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20719__$1,cljs.core.cst$kw$hovered_DASH_over_DASH_date);
var selected_days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20719__$1,cljs.core.cst$kw$selected_DASH_days);
var clocks_by_day_filtered = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20719__$1,cljs.core.cst$kw$clocks_DASH_by_DASH_day_DASH_filtered);
var clock_minute_intervals_by_day_filtered = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20719__$1,cljs.core.cst$kw$clock_DASH_minute_DASH_intervals_DASH_by_DASH_day_DASH_filtered);
var calendar = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20719__$1,cljs.core.cst$kw$calendar);
var n_selected = cljs.core.count(selected_days);
var selected_days__$1 = (((n_selected > (0)))?cljs.core.vals(cljs.core.select_keys(calendar,selected_days)):(cljs.core.truth_(hovered_over_date)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(calendar,hovered_over_date)], null):null
));
var highlighted_entries_cursor = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$highlighted_DASH_entries], null));
var clock_list_group = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$clock_DASH_list_DASH_group], null));
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$app,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_((function (){var or__4131__auto__ = true;
if(or__4131__auto__){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$print_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state));
}
})())?"print":"")], null),(cljs.core.truth_(cljs.core.cst$kw$loading_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$loading_DASH_indicator,new cljs.core.PersistentVector(null, 13, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$loading_DASH_spinner,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null)], null)], null):null),(cljs.core.truth_(cljs.core.cst$kw$show_DASH_help_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.help_view.help_view,((function (map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$show_DASH_help_QMARK_,false);
});})(map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group))
], null):null),(cljs.core.truth_(cljs.core.cst$kw$show_DASH_info_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.info.info_view,app_state,((function (map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(app_state,cljs.core.assoc,cljs.core.cst$kw$show_DASH_info_QMARK_,false);
});})(map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group))
], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.app.controls,app_state], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.search_view.search_bar,app_state], null),org_analyzer.view.app.collapsible_STAR_("Calendar",cljs.core.cst$kw$calendar_DASH_collapsed_QMARK_,reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$calendar_DASH_collapsed_QMARK_], null)),((function (map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.calendar.calendar_view,app_state,dom_state,event_handlers], null);
});})(map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group))
),org_analyzer.view.app.collapsible_STAR_("Clocks",cljs.core.cst$kw$clocks_DASH_collapsed_QMARK_,reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$clocks_DASH_collapsed_QMARK_], null)),((function (map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group){
return (function (){
if(cljs.core.truth_(selected_days__$1)){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.clock_list.clock_list_view,selected_days__$1,clocks_by_day_filtered,calendar,highlighted_entries_cursor,clock_list_group], null);
} else {
return null;
}
});})(map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group))
),(function (){var tooltip = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$bar_DASH_chart_DASH_tooltip], null));
return org_analyzer.view.app.collapsible_STAR_("clocks-by-day",cljs.core.cst$kw$bar_DASH_chart_DASH_collapsed_QMARK_,reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$bar_DASH_chart_DASH_collapsed_QMARK_], null)),((function (tooltip,map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.tooltip.tooltip_following_mouse,tooltip,cljs.core.PersistentArrayMap.EMPTY,org_analyzer.view.bar_chart.bar_chart(app_state,selected_days__$1,tooltip,highlighted_entries_cursor)], null);
});})(tooltip,map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group))
);
})(),(function (){var tooltip = reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$time_DASH_line_DASH_tooltip], null));
return org_analyzer.view.app.collapsible_STAR_("timeline",cljs.core.cst$kw$by_DASH_minute_DASH_collapsed_QMARK_,reagent.core.cursor(app_state,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$by_DASH_minute_DASH_collapsed_QMARK_], null)),((function (tooltip,map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.tooltip.tooltip_following_mouse,tooltip,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$by_DASH_minute,(function (){var dates = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$date,selected_days__$1);
var clock_minute_intervals_by_day_filtered__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.sorted_map_by(cljs.core._LT_),cljs.core.select_keys(clock_minute_intervals_by_day_filtered,dates));
if((cljs.core.count(dates) > (0))){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [org_analyzer.view.timeline.activities_by_minute_view,clock_minute_intervals_by_day_filtered__$1,highlighted_entries_cursor,tooltip,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,(document.documentElement.clientWidth - (cljs.core.truth_(cljs.core.cst$kw$print_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(app_state)))?(160):(60)))], null)], null);
} else {
return null;
}
})()], null)], null);
});})(tooltip,map__20719,map__20719__$1,hovered_over_date,selected_days,clocks_by_day_filtered,clock_minute_intervals_by_day_filtered,calendar,n_selected,selected_days__$1,highlighted_entries_cursor,clock_list_group))
);
})()], null);

}
}
});
