// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
goog.require('goog.net.XhrIo');
goog.require('goog.net.Jsonp');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('clojure.string');
cljs_http.core.pending_requests = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
/**
 * Attempt to close the given channel and abort the pending HTTP request
 *   with which it is associated.
 */
cljs_http.core.abort_BANG_ = (function cljs_http$core$abort_BANG_(channel){
var temp__5457__auto__ = (function (){var fexpr__19096 = cljs.core.deref(cljs_http.core.pending_requests);
return (fexpr__19096.cljs$core$IFn$_invoke$arity$1 ? fexpr__19096.cljs$core$IFn$_invoke$arity$1(channel) : fexpr__19096.call(null,channel));
})();
if(cljs.core.truth_(temp__5457__auto__)){
var req = temp__5457__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

cljs.core.async.close_BANG_(channel);

if(cljs.core.truth_(req.hasOwnProperty("abort"))){
return req.abort();
} else {
return cljs.core.cst$kw$jsonp.cljs$core$IFn$_invoke$arity$1(req).cancel(cljs.core.cst$kw$request.cljs$core$IFn$_invoke$arity$1(req));
}
} else {
return null;
}
});
cljs_http.core.aborted_QMARK_ = (function cljs_http$core$aborted_QMARK_(xhr){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(xhr.getLastErrorCode(),goog.net.ErrorCode.ABORT);
});
/**
 * Takes an XhrIo object and applies the default-headers to it.
 */
cljs_http.core.apply_default_headers_BANG_ = (function cljs_http$core$apply_default_headers_BANG_(xhr,headers){
var formatted_h = cljs.core.zipmap(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.util.camelize,cljs.core.keys(headers)),cljs.core.vals(headers));
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (formatted_h){
return (function (p__19097){
var vec__19098 = p__19097;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19098,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19098,(1),null);
return xhr.headers.set(k,v);
});})(formatted_h))
,formatted_h));
});
/**
 * Takes an XhrIo object and sets response-type if not nil.
 */
cljs_http.core.apply_response_type_BANG_ = (function cljs_http$core$apply_response_type_BANG_(xhr,response_type){
return xhr.setResponseType((function (){var G__19101 = response_type;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$array_DASH_buffer,G__19101)){
return goog.net.XhrIo.ResponseType.ARRAY_BUFFER;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$blob,G__19101)){
return goog.net.XhrIo.ResponseType.BLOB;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$document,G__19101)){
return goog.net.XhrIo.ResponseType.DOCUMENT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$text,G__19101)){
return goog.net.XhrIo.ResponseType.TEXT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$default,G__19101)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,G__19101)){
return goog.net.XhrIo.ResponseType.DEFAULT;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__19101)].join('')));

}
}
}
}
}
}
})());
});
/**
 * Builds an XhrIo object from the request parameters.
 */
cljs_http.core.build_xhr = (function cljs_http$core$build_xhr(p__19102){
var map__19103 = p__19102;
var map__19103__$1 = (((((!((map__19103 == null))))?(((((map__19103.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19103.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19103):map__19103);
var request = map__19103__$1;
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19103__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var default_headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19103__$1,cljs.core.cst$kw$default_DASH_headers);
var response_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19103__$1,cljs.core.cst$kw$response_DASH_type);
var timeout = (function (){var or__4131__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})();
var send_credentials = (((with_credentials_QMARK_ == null))?true:with_credentials_QMARK_);
var G__19105 = (new goog.net.XhrIo());
cljs_http.core.apply_default_headers_BANG_(G__19105,default_headers);

cljs_http.core.apply_response_type_BANG_(G__19105,response_type);

G__19105.setTimeoutInterval(timeout);

G__19105.setWithCredentials(send_credentials);

return G__19105;
});
cljs_http.core.error_kw = cljs.core.PersistentHashMap.fromArrays([(0),(7),(1),(4),(6),(3),(2),(9),(5),(8)],[cljs.core.cst$kw$no_DASH_error,cljs.core.cst$kw$abort,cljs.core.cst$kw$access_DASH_denied,cljs.core.cst$kw$custom_DASH_error,cljs.core.cst$kw$http_DASH_error,cljs.core.cst$kw$ff_DASH_silent_DASH_error,cljs.core.cst$kw$file_DASH_not_DASH_found,cljs.core.cst$kw$offline,cljs.core.cst$kw$exception,cljs.core.cst$kw$timeout]);
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.xhr = (function cljs_http$core$xhr(p__19106){
var map__19107 = p__19106;
var map__19107__$1 = (((((!((map__19107 == null))))?(((((map__19107.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19107.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19107):map__19107);
var request = map__19107__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19107__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19107__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19107__$1,cljs.core.cst$kw$body);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19107__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19107__$1,cljs.core.cst$kw$cancel);
var progress = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19107__$1,cljs.core.cst$kw$progress);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var request_url = cljs_http.util.build_url(request);
var method = cljs.core.name((function (){var or__4131__auto__ = request_method;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.cst$kw$get;
}
})());
var headers__$1 = cljs_http.util.build_headers(headers);
var xhr = cljs_http.core.build_xhr(request);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,xhr);

xhr.listen(goog.net.EventType.COMPLETE,((function (channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (evt){
var target = evt.target;
var response = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$status,target.getStatus(),cljs.core.cst$kw$success,target.isSuccess(),cljs.core.cst$kw$body,target.getResponse(),cljs.core.cst$kw$headers,cljs_http.util.parse_headers(target.getAllResponseHeaders()),cljs.core.cst$kw$trace_DASH_redirects,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [request_url,target.getLastUri()], null),cljs.core.cst$kw$error_DASH_code,(function (){var G__19109 = target.getLastErrorCode();
return (cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1 ? cljs_http.core.error_kw.cljs$core$IFn$_invoke$arity$1(G__19109) : cljs_http.core.error_kw.call(null,G__19109));
})(),cljs.core.cst$kw$error_DASH_text,target.getLastError()], null);
if((!(cljs_http.core.aborted_QMARK_(xhr)))){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

if(cljs.core.truth_(progress)){
var listener_19132 = ((function (channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (direction,evt){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(progress,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$direction,direction,cljs.core.cst$kw$loaded,evt.loaded], null),(cljs.core.truth_(evt.lengthComputable)?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,evt.total], null):null)], 0)));
});})(channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
var G__19110_19133 = xhr;
G__19110_19133.setProgressEventsEnabled(true);

G__19110_19133.listen(goog.net.EventType.UPLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_19132,cljs.core.cst$kw$upload));

G__19110_19133.listen(goog.net.EventType.DOWNLOAD_PROGRESS,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(listener_19132,cljs.core.cst$kw$download));

} else {
}

xhr.send(request_url,method,body,headers__$1);

if(cljs.core.truth_(cancel)){
var c__17150__auto___19134 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___19134,channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___19134,channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function (state_19121){
var state_val_19122 = (state_19121[(1)]);
if((state_val_19122 === (1))){
var state_19121__$1 = state_19121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19121__$1,(2),cancel);
} else {
if((state_val_19122 === (2))){
var inst_19112 = (state_19121[(2)]);
var inst_19113 = xhr.isComplete();
var inst_19114 = cljs.core.not(inst_19113);
var state_19121__$1 = (function (){var statearr_19123 = state_19121;
(statearr_19123[(7)] = inst_19112);

return statearr_19123;
})();
if(inst_19114){
var statearr_19124_19135 = state_19121__$1;
(statearr_19124_19135[(1)] = (3));

} else {
var statearr_19125_19136 = state_19121__$1;
(statearr_19125_19136[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19122 === (3))){
var inst_19116 = xhr.abort();
var state_19121__$1 = state_19121;
var statearr_19126_19137 = state_19121__$1;
(statearr_19126_19137[(2)] = inst_19116);

(statearr_19126_19137[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19122 === (4))){
var state_19121__$1 = state_19121;
var statearr_19127_19138 = state_19121__$1;
(statearr_19127_19138[(2)] = null);

(statearr_19127_19138[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19122 === (5))){
var inst_19119 = (state_19121[(2)]);
var state_19121__$1 = state_19121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19121__$1,inst_19119);
} else {
return null;
}
}
}
}
}
});})(c__17150__auto___19134,channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
;
return ((function (switch__17043__auto__,c__17150__auto___19134,channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress){
return (function() {
var cljs_http$core$xhr_$_state_machine__17044__auto__ = null;
var cljs_http$core$xhr_$_state_machine__17044__auto____0 = (function (){
var statearr_19128 = [null,null,null,null,null,null,null,null];
(statearr_19128[(0)] = cljs_http$core$xhr_$_state_machine__17044__auto__);

(statearr_19128[(1)] = (1));

return statearr_19128;
});
var cljs_http$core$xhr_$_state_machine__17044__auto____1 = (function (state_19121){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_19121);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e19129){if((e19129 instanceof Object)){
var ex__17047__auto__ = e19129;
var statearr_19130_19139 = state_19121;
(statearr_19130_19139[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19121);

return cljs.core.cst$kw$recur;
} else {
throw e19129;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__19140 = state_19121;
state_19121 = G__19140;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs_http$core$xhr_$_state_machine__17044__auto__ = function(state_19121){
switch(arguments.length){
case 0:
return cljs_http$core$xhr_$_state_machine__17044__auto____0.call(this);
case 1:
return cljs_http$core$xhr_$_state_machine__17044__auto____1.call(this,state_19121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$xhr_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$xhr_$_state_machine__17044__auto____0;
cljs_http$core$xhr_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$xhr_$_state_machine__17044__auto____1;
return cljs_http$core$xhr_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___19134,channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
})();
var state__17152__auto__ = (function (){var statearr_19131 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_19131[(6)] = c__17150__auto___19134);

return statearr_19131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___19134,channel,request_url,method,headers__$1,xhr,map__19107,map__19107__$1,request,request_method,headers,body,with_credentials_QMARK_,cancel,progress))
);

} else {
}

return channel;
});
/**
 * Execute the JSONP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.jsonp = (function cljs_http$core$jsonp(p__19141){
var map__19142 = p__19141;
var map__19142__$1 = (((((!((map__19142 == null))))?(((((map__19142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19142.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19142):map__19142);
var request = map__19142__$1;
var timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19142__$1,cljs.core.cst$kw$timeout);
var callback_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19142__$1,cljs.core.cst$kw$callback_DASH_name);
var cancel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19142__$1,cljs.core.cst$kw$cancel);
var keywordize_keys_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19142__$1,cljs.core.cst$kw$keywordize_DASH_keys_QMARK_,true);
var channel = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var jsonp = (new goog.net.Jsonp(cljs_http.util.build_url(request),callback_name));
jsonp.setRequestTimeout(timeout);

var req_19155 = jsonp.send(null,((function (channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_success_callback(data){
var response = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(200),cljs.core.cst$kw$success,true,cljs.core.cst$kw$body,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(data,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,keywordize_keys_QMARK_], 0))], null);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(channel,response);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
,((function (channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function cljs_http$core$jsonp_$_error_callback(){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cljs_http.core.pending_requests,cljs.core.dissoc,channel);

if(cljs.core.truth_(cancel)){
cljs.core.async.close_BANG_(cancel);
} else {
}

return cljs.core.async.close_BANG_(channel);
});})(channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs_http.core.pending_requests,cljs.core.assoc,channel,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$jsonp,jsonp,cljs.core.cst$kw$request,req_19155], null));

if(cljs.core.truth_(cancel)){
var c__17150__auto___19156 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___19156,req_19155,channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___19156,req_19155,channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function (state_19148){
var state_val_19149 = (state_19148[(1)]);
if((state_val_19149 === (1))){
var state_19148__$1 = state_19148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19148__$1,(2),cancel);
} else {
if((state_val_19149 === (2))){
var inst_19145 = (state_19148[(2)]);
var inst_19146 = jsonp.cancel(req_19155);
var state_19148__$1 = (function (){var statearr_19150 = state_19148;
(statearr_19150[(7)] = inst_19145);

return statearr_19150;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_19148__$1,inst_19146);
} else {
return null;
}
}
});})(c__17150__auto___19156,req_19155,channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
;
return ((function (switch__17043__auto__,c__17150__auto___19156,req_19155,channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_){
return (function() {
var cljs_http$core$jsonp_$_state_machine__17044__auto__ = null;
var cljs_http$core$jsonp_$_state_machine__17044__auto____0 = (function (){
var statearr_19151 = [null,null,null,null,null,null,null,null];
(statearr_19151[(0)] = cljs_http$core$jsonp_$_state_machine__17044__auto__);

(statearr_19151[(1)] = (1));

return statearr_19151;
});
var cljs_http$core$jsonp_$_state_machine__17044__auto____1 = (function (state_19148){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_19148);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e19152){if((e19152 instanceof Object)){
var ex__17047__auto__ = e19152;
var statearr_19153_19157 = state_19148;
(statearr_19153_19157[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19148);

return cljs.core.cst$kw$recur;
} else {
throw e19152;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__19158 = state_19148;
state_19148 = G__19158;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs_http$core$jsonp_$_state_machine__17044__auto__ = function(state_19148){
switch(arguments.length){
case 0:
return cljs_http$core$jsonp_$_state_machine__17044__auto____0.call(this);
case 1:
return cljs_http$core$jsonp_$_state_machine__17044__auto____1.call(this,state_19148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs_http$core$jsonp_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs_http$core$jsonp_$_state_machine__17044__auto____0;
cljs_http$core$jsonp_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs_http$core$jsonp_$_state_machine__17044__auto____1;
return cljs_http$core$jsonp_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___19156,req_19155,channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
})();
var state__17152__auto__ = (function (){var statearr_19154 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_19154[(6)] = c__17150__auto___19156);

return statearr_19154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___19156,req_19155,channel,jsonp,map__19142,map__19142__$1,request,timeout,callback_name,cancel,keywordize_keys_QMARK_))
);

} else {
}

return channel;
});
/**
 * Execute the HTTP request corresponding to the given Ring request
 *   map and return a core.async channel.
 */
cljs_http.core.request = (function cljs_http$core$request(p__19159){
var map__19160 = p__19159;
var map__19160__$1 = (((((!((map__19160 == null))))?(((((map__19160.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__19160.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__19160):map__19160);
var request = map__19160__$1;
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19160__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(request_method,cljs.core.cst$kw$jsonp)){
return cljs_http.core.jsonp(request);
} else {
return cljs_http.core.xhr(request);
}
});
