// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__17210 = arguments.length;
switch (G__17210) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17211 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17211 = (function (f,blockable,meta17212){
this.f = f;
this.blockable = blockable;
this.meta17212 = meta17212;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17211.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17213,meta17212__$1){
var self__ = this;
var _17213__$1 = this;
return (new cljs.core.async.t_cljs$core$async17211(self__.f,self__.blockable,meta17212__$1));
});

cljs.core.async.t_cljs$core$async17211.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17213){
var self__ = this;
var _17213__$1 = this;
return self__.meta17212;
});

cljs.core.async.t_cljs$core$async17211.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17211.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17211.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async17211.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async17211.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta17212], null);
});

cljs.core.async.t_cljs$core$async17211.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17211.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17211";

cljs.core.async.t_cljs$core$async17211.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async17211");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17211.
 */
cljs.core.async.__GT_t_cljs$core$async17211 = (function cljs$core$async$__GT_t_cljs$core$async17211(f__$1,blockable__$1,meta17212){
return (new cljs.core.async.t_cljs$core$async17211(f__$1,blockable__$1,meta17212));
});

}

return (new cljs.core.async.t_cljs$core$async17211(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__17217 = arguments.length;
switch (G__17217) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__17220 = arguments.length;
switch (G__17220) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__17223 = arguments.length;
switch (G__17223) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_17225 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17225) : fn1.call(null,val_17225));
} else {
cljs.core.async.impl.dispatch.run(((function (val_17225,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_17225) : fn1.call(null,val_17225));
});})(val_17225,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__17227 = arguments.length;
switch (G__17227) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__5455__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___17229 = n;
var x_17230 = (0);
while(true){
if((x_17230 < n__4607__auto___17229)){
(a[x_17230] = (0));

var G__17231 = (x_17230 + (1));
x_17230 = G__17231;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__17232 = (i + (1));
i = G__17232;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17233 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17233 = (function (flag,meta17234){
this.flag = flag;
this.meta17234 = meta17234;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_17235,meta17234__$1){
var self__ = this;
var _17235__$1 = this;
return (new cljs.core.async.t_cljs$core$async17233(self__.flag,meta17234__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_17235){
var self__ = this;
var _17235__$1 = this;
return self__.meta17234;
});})(flag))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17233.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async17233.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta17234], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async17233.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17233.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17233";

cljs.core.async.t_cljs$core$async17233.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async17233");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17233.
 */
cljs.core.async.__GT_t_cljs$core$async17233 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async17233(flag__$1,meta17234){
return (new cljs.core.async.t_cljs$core$async17233(flag__$1,meta17234));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async17233(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17236 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17236 = (function (flag,cb,meta17237){
this.flag = flag;
this.cb = cb;
this.meta17237 = meta17237;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17236.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17238,meta17237__$1){
var self__ = this;
var _17238__$1 = this;
return (new cljs.core.async.t_cljs$core$async17236(self__.flag,self__.cb,meta17237__$1));
});

cljs.core.async.t_cljs$core$async17236.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17238){
var self__ = this;
var _17238__$1 = this;
return self__.meta17237;
});

cljs.core.async.t_cljs$core$async17236.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17236.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async17236.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async17236.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async17236.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta17237], null);
});

cljs.core.async.t_cljs$core$async17236.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17236.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17236";

cljs.core.async.t_cljs$core$async17236.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async17236");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17236.
 */
cljs.core.async.__GT_t_cljs$core$async17236 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async17236(flag__$1,cb__$1,meta17237){
return (new cljs.core.async.t_cljs$core$async17236(flag__$1,cb__$1,meta17237));
});

}

return (new cljs.core.async.t_cljs$core$async17236(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17239_SHARP_){
var G__17241 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17239_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17241) : fret.call(null,G__17241));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__17240_SHARP_){
var G__17242 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__17240_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__17242) : fret.call(null,G__17242));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__17243 = (i + (1));
i = G__17243;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5457__auto__ = (function (){var and__4120__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4120__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___17249 = arguments.length;
var i__4731__auto___17250 = (0);
while(true){
if((i__4731__auto___17250 < len__4730__auto___17249)){
args__4736__auto__.push((arguments[i__4731__auto___17250]));

var G__17251 = (i__4731__auto___17250 + (1));
i__4731__auto___17250 = G__17251;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__17246){
var map__17247 = p__17246;
var map__17247__$1 = (((((!((map__17247 == null))))?(((((map__17247.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17247.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__17247):map__17247);
var opts = map__17247__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq17244){
var G__17245 = cljs.core.first(seq17244);
var seq17244__$1 = cljs.core.next(seq17244);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17245,seq17244__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__17253 = arguments.length;
switch (G__17253) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__17150__auto___17299 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___17299){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___17299){
return (function (state_17277){
var state_val_17278 = (state_17277[(1)]);
if((state_val_17278 === (7))){
var inst_17273 = (state_17277[(2)]);
var state_17277__$1 = state_17277;
var statearr_17279_17300 = state_17277__$1;
(statearr_17279_17300[(2)] = inst_17273);

(statearr_17279_17300[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (1))){
var state_17277__$1 = state_17277;
var statearr_17280_17301 = state_17277__$1;
(statearr_17280_17301[(2)] = null);

(statearr_17280_17301[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (4))){
var inst_17256 = (state_17277[(7)]);
var inst_17256__$1 = (state_17277[(2)]);
var inst_17257 = (inst_17256__$1 == null);
var state_17277__$1 = (function (){var statearr_17281 = state_17277;
(statearr_17281[(7)] = inst_17256__$1);

return statearr_17281;
})();
if(cljs.core.truth_(inst_17257)){
var statearr_17282_17302 = state_17277__$1;
(statearr_17282_17302[(1)] = (5));

} else {
var statearr_17283_17303 = state_17277__$1;
(statearr_17283_17303[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (13))){
var state_17277__$1 = state_17277;
var statearr_17284_17304 = state_17277__$1;
(statearr_17284_17304[(2)] = null);

(statearr_17284_17304[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (6))){
var inst_17256 = (state_17277[(7)]);
var state_17277__$1 = state_17277;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17277__$1,(11),to,inst_17256);
} else {
if((state_val_17278 === (3))){
var inst_17275 = (state_17277[(2)]);
var state_17277__$1 = state_17277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17277__$1,inst_17275);
} else {
if((state_val_17278 === (12))){
var state_17277__$1 = state_17277;
var statearr_17285_17305 = state_17277__$1;
(statearr_17285_17305[(2)] = null);

(statearr_17285_17305[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (2))){
var state_17277__$1 = state_17277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17277__$1,(4),from);
} else {
if((state_val_17278 === (11))){
var inst_17266 = (state_17277[(2)]);
var state_17277__$1 = state_17277;
if(cljs.core.truth_(inst_17266)){
var statearr_17286_17306 = state_17277__$1;
(statearr_17286_17306[(1)] = (12));

} else {
var statearr_17287_17307 = state_17277__$1;
(statearr_17287_17307[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (9))){
var state_17277__$1 = state_17277;
var statearr_17288_17308 = state_17277__$1;
(statearr_17288_17308[(2)] = null);

(statearr_17288_17308[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (5))){
var state_17277__$1 = state_17277;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17289_17309 = state_17277__$1;
(statearr_17289_17309[(1)] = (8));

} else {
var statearr_17290_17310 = state_17277__$1;
(statearr_17290_17310[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (14))){
var inst_17271 = (state_17277[(2)]);
var state_17277__$1 = state_17277;
var statearr_17291_17311 = state_17277__$1;
(statearr_17291_17311[(2)] = inst_17271);

(statearr_17291_17311[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (10))){
var inst_17263 = (state_17277[(2)]);
var state_17277__$1 = state_17277;
var statearr_17292_17312 = state_17277__$1;
(statearr_17292_17312[(2)] = inst_17263);

(statearr_17292_17312[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17278 === (8))){
var inst_17260 = cljs.core.async.close_BANG_(to);
var state_17277__$1 = state_17277;
var statearr_17293_17313 = state_17277__$1;
(statearr_17293_17313[(2)] = inst_17260);

(statearr_17293_17313[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___17299))
;
return ((function (switch__17043__auto__,c__17150__auto___17299){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_17294 = [null,null,null,null,null,null,null,null];
(statearr_17294[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_17294[(1)] = (1));

return statearr_17294;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_17277){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17277);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17295){if((e17295 instanceof Object)){
var ex__17047__auto__ = e17295;
var statearr_17296_17314 = state_17277;
(statearr_17296_17314[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17277);

return cljs.core.cst$kw$recur;
} else {
throw e17295;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17315 = state_17277;
state_17277 = G__17315;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_17277){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_17277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___17299))
})();
var state__17152__auto__ = (function (){var statearr_17297 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17297[(6)] = c__17150__auto___17299);

return statearr_17297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___17299))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__17316){
var vec__17317 = p__17316;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17317,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17317,(1),null);
var job = vec__17317;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__17150__auto___17488 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___17488,res,vec__17317,v,p,job,jobs,results){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___17488,res,vec__17317,v,p,job,jobs,results){
return (function (state_17324){
var state_val_17325 = (state_17324[(1)]);
if((state_val_17325 === (1))){
var state_17324__$1 = state_17324;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17324__$1,(2),res,v);
} else {
if((state_val_17325 === (2))){
var inst_17321 = (state_17324[(2)]);
var inst_17322 = cljs.core.async.close_BANG_(res);
var state_17324__$1 = (function (){var statearr_17326 = state_17324;
(statearr_17326[(7)] = inst_17321);

return statearr_17326;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17324__$1,inst_17322);
} else {
return null;
}
}
});})(c__17150__auto___17488,res,vec__17317,v,p,job,jobs,results))
;
return ((function (switch__17043__auto__,c__17150__auto___17488,res,vec__17317,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0 = (function (){
var statearr_17327 = [null,null,null,null,null,null,null,null];
(statearr_17327[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__);

(statearr_17327[(1)] = (1));

return statearr_17327;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1 = (function (state_17324){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17324);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17328){if((e17328 instanceof Object)){
var ex__17047__auto__ = e17328;
var statearr_17329_17489 = state_17324;
(statearr_17329_17489[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17324);

return cljs.core.cst$kw$recur;
} else {
throw e17328;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17490 = state_17324;
state_17324 = G__17490;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = function(state_17324){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1.call(this,state_17324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___17488,res,vec__17317,v,p,job,jobs,results))
})();
var state__17152__auto__ = (function (){var statearr_17330 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17330[(6)] = c__17150__auto___17488);

return statearr_17330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___17488,res,vec__17317,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__17331){
var vec__17332 = p__17331;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17332,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17332,(1),null);
var job = vec__17332;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___17491 = n;
var __17492 = (0);
while(true){
if((__17492 < n__4607__auto___17491)){
var G__17335_17493 = type;
var G__17335_17494__$1 = (((G__17335_17493 instanceof cljs.core.Keyword))?G__17335_17493.fqn:null);
switch (G__17335_17494__$1) {
case "compute":
var c__17150__auto___17496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17492,c__17150__auto___17496,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (__17492,c__17150__auto___17496,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async){
return (function (state_17348){
var state_val_17349 = (state_17348[(1)]);
if((state_val_17349 === (1))){
var state_17348__$1 = state_17348;
var statearr_17350_17497 = state_17348__$1;
(statearr_17350_17497[(2)] = null);

(statearr_17350_17497[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17349 === (2))){
var state_17348__$1 = state_17348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17348__$1,(4),jobs);
} else {
if((state_val_17349 === (3))){
var inst_17346 = (state_17348[(2)]);
var state_17348__$1 = state_17348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17348__$1,inst_17346);
} else {
if((state_val_17349 === (4))){
var inst_17338 = (state_17348[(2)]);
var inst_17339 = process(inst_17338);
var state_17348__$1 = state_17348;
if(cljs.core.truth_(inst_17339)){
var statearr_17351_17498 = state_17348__$1;
(statearr_17351_17498[(1)] = (5));

} else {
var statearr_17352_17499 = state_17348__$1;
(statearr_17352_17499[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17349 === (5))){
var state_17348__$1 = state_17348;
var statearr_17353_17500 = state_17348__$1;
(statearr_17353_17500[(2)] = null);

(statearr_17353_17500[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17349 === (6))){
var state_17348__$1 = state_17348;
var statearr_17354_17501 = state_17348__$1;
(statearr_17354_17501[(2)] = null);

(statearr_17354_17501[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17349 === (7))){
var inst_17344 = (state_17348[(2)]);
var state_17348__$1 = state_17348;
var statearr_17355_17502 = state_17348__$1;
(statearr_17355_17502[(2)] = inst_17344);

(statearr_17355_17502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17492,c__17150__auto___17496,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async))
;
return ((function (__17492,switch__17043__auto__,c__17150__auto___17496,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0 = (function (){
var statearr_17356 = [null,null,null,null,null,null,null];
(statearr_17356[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__);

(statearr_17356[(1)] = (1));

return statearr_17356;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1 = (function (state_17348){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17348);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17357){if((e17357 instanceof Object)){
var ex__17047__auto__ = e17357;
var statearr_17358_17503 = state_17348;
(statearr_17358_17503[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17348);

return cljs.core.cst$kw$recur;
} else {
throw e17357;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17504 = state_17348;
state_17348 = G__17504;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = function(state_17348){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1.call(this,state_17348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__;
})()
;})(__17492,switch__17043__auto__,c__17150__auto___17496,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async))
})();
var state__17152__auto__ = (function (){var statearr_17359 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17359[(6)] = c__17150__auto___17496);

return statearr_17359;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(__17492,c__17150__auto___17496,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async))
);


break;
case "async":
var c__17150__auto___17505 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__17492,c__17150__auto___17505,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (__17492,c__17150__auto___17505,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async){
return (function (state_17372){
var state_val_17373 = (state_17372[(1)]);
if((state_val_17373 === (1))){
var state_17372__$1 = state_17372;
var statearr_17374_17506 = state_17372__$1;
(statearr_17374_17506[(2)] = null);

(statearr_17374_17506[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17373 === (2))){
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17372__$1,(4),jobs);
} else {
if((state_val_17373 === (3))){
var inst_17370 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17372__$1,inst_17370);
} else {
if((state_val_17373 === (4))){
var inst_17362 = (state_17372[(2)]);
var inst_17363 = async(inst_17362);
var state_17372__$1 = state_17372;
if(cljs.core.truth_(inst_17363)){
var statearr_17375_17507 = state_17372__$1;
(statearr_17375_17507[(1)] = (5));

} else {
var statearr_17376_17508 = state_17372__$1;
(statearr_17376_17508[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17373 === (5))){
var state_17372__$1 = state_17372;
var statearr_17377_17509 = state_17372__$1;
(statearr_17377_17509[(2)] = null);

(statearr_17377_17509[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17373 === (6))){
var state_17372__$1 = state_17372;
var statearr_17378_17510 = state_17372__$1;
(statearr_17378_17510[(2)] = null);

(statearr_17378_17510[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17373 === (7))){
var inst_17368 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17379_17511 = state_17372__$1;
(statearr_17379_17511[(2)] = inst_17368);

(statearr_17379_17511[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__17492,c__17150__auto___17505,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async))
;
return ((function (__17492,switch__17043__auto__,c__17150__auto___17505,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0 = (function (){
var statearr_17380 = [null,null,null,null,null,null,null];
(statearr_17380[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__);

(statearr_17380[(1)] = (1));

return statearr_17380;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1 = (function (state_17372){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17372);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17381){if((e17381 instanceof Object)){
var ex__17047__auto__ = e17381;
var statearr_17382_17512 = state_17372;
(statearr_17382_17512[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17372);

return cljs.core.cst$kw$recur;
} else {
throw e17381;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17513 = state_17372;
state_17372 = G__17513;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = function(state_17372){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1.call(this,state_17372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__;
})()
;})(__17492,switch__17043__auto__,c__17150__auto___17505,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async))
})();
var state__17152__auto__ = (function (){var statearr_17383 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17383[(6)] = c__17150__auto___17505);

return statearr_17383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(__17492,c__17150__auto___17505,G__17335_17493,G__17335_17494__$1,n__4607__auto___17491,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__17335_17494__$1)].join('')));

}

var G__17514 = (__17492 + (1));
__17492 = G__17514;
continue;
} else {
}
break;
}

var c__17150__auto___17515 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___17515,jobs,results,process,async){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___17515,jobs,results,process,async){
return (function (state_17405){
var state_val_17406 = (state_17405[(1)]);
if((state_val_17406 === (1))){
var state_17405__$1 = state_17405;
var statearr_17407_17516 = state_17405__$1;
(statearr_17407_17516[(2)] = null);

(statearr_17407_17516[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17406 === (2))){
var state_17405__$1 = state_17405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17405__$1,(4),from);
} else {
if((state_val_17406 === (3))){
var inst_17403 = (state_17405[(2)]);
var state_17405__$1 = state_17405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17405__$1,inst_17403);
} else {
if((state_val_17406 === (4))){
var inst_17386 = (state_17405[(7)]);
var inst_17386__$1 = (state_17405[(2)]);
var inst_17387 = (inst_17386__$1 == null);
var state_17405__$1 = (function (){var statearr_17408 = state_17405;
(statearr_17408[(7)] = inst_17386__$1);

return statearr_17408;
})();
if(cljs.core.truth_(inst_17387)){
var statearr_17409_17517 = state_17405__$1;
(statearr_17409_17517[(1)] = (5));

} else {
var statearr_17410_17518 = state_17405__$1;
(statearr_17410_17518[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17406 === (5))){
var inst_17389 = cljs.core.async.close_BANG_(jobs);
var state_17405__$1 = state_17405;
var statearr_17411_17519 = state_17405__$1;
(statearr_17411_17519[(2)] = inst_17389);

(statearr_17411_17519[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17406 === (6))){
var inst_17386 = (state_17405[(7)]);
var inst_17391 = (state_17405[(8)]);
var inst_17391__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_17392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17393 = [inst_17386,inst_17391__$1];
var inst_17394 = (new cljs.core.PersistentVector(null,2,(5),inst_17392,inst_17393,null));
var state_17405__$1 = (function (){var statearr_17412 = state_17405;
(statearr_17412[(8)] = inst_17391__$1);

return statearr_17412;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17405__$1,(8),jobs,inst_17394);
} else {
if((state_val_17406 === (7))){
var inst_17401 = (state_17405[(2)]);
var state_17405__$1 = state_17405;
var statearr_17413_17520 = state_17405__$1;
(statearr_17413_17520[(2)] = inst_17401);

(statearr_17413_17520[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17406 === (8))){
var inst_17391 = (state_17405[(8)]);
var inst_17396 = (state_17405[(2)]);
var state_17405__$1 = (function (){var statearr_17414 = state_17405;
(statearr_17414[(9)] = inst_17396);

return statearr_17414;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17405__$1,(9),results,inst_17391);
} else {
if((state_val_17406 === (9))){
var inst_17398 = (state_17405[(2)]);
var state_17405__$1 = (function (){var statearr_17415 = state_17405;
(statearr_17415[(10)] = inst_17398);

return statearr_17415;
})();
var statearr_17416_17521 = state_17405__$1;
(statearr_17416_17521[(2)] = null);

(statearr_17416_17521[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___17515,jobs,results,process,async))
;
return ((function (switch__17043__auto__,c__17150__auto___17515,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0 = (function (){
var statearr_17417 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17417[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__);

(statearr_17417[(1)] = (1));

return statearr_17417;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1 = (function (state_17405){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17405);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17418){if((e17418 instanceof Object)){
var ex__17047__auto__ = e17418;
var statearr_17419_17522 = state_17405;
(statearr_17419_17522[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17405);

return cljs.core.cst$kw$recur;
} else {
throw e17418;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17523 = state_17405;
state_17405 = G__17523;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = function(state_17405){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1.call(this,state_17405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___17515,jobs,results,process,async))
})();
var state__17152__auto__ = (function (){var statearr_17420 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17420[(6)] = c__17150__auto___17515);

return statearr_17420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___17515,jobs,results,process,async))
);


var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__,jobs,results,process,async){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__,jobs,results,process,async){
return (function (state_17458){
var state_val_17459 = (state_17458[(1)]);
if((state_val_17459 === (7))){
var inst_17454 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
var statearr_17460_17524 = state_17458__$1;
(statearr_17460_17524[(2)] = inst_17454);

(statearr_17460_17524[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (20))){
var state_17458__$1 = state_17458;
var statearr_17461_17525 = state_17458__$1;
(statearr_17461_17525[(2)] = null);

(statearr_17461_17525[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (1))){
var state_17458__$1 = state_17458;
var statearr_17462_17526 = state_17458__$1;
(statearr_17462_17526[(2)] = null);

(statearr_17462_17526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (4))){
var inst_17423 = (state_17458[(7)]);
var inst_17423__$1 = (state_17458[(2)]);
var inst_17424 = (inst_17423__$1 == null);
var state_17458__$1 = (function (){var statearr_17463 = state_17458;
(statearr_17463[(7)] = inst_17423__$1);

return statearr_17463;
})();
if(cljs.core.truth_(inst_17424)){
var statearr_17464_17527 = state_17458__$1;
(statearr_17464_17527[(1)] = (5));

} else {
var statearr_17465_17528 = state_17458__$1;
(statearr_17465_17528[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (15))){
var inst_17436 = (state_17458[(8)]);
var state_17458__$1 = state_17458;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17458__$1,(18),to,inst_17436);
} else {
if((state_val_17459 === (21))){
var inst_17449 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
var statearr_17466_17529 = state_17458__$1;
(statearr_17466_17529[(2)] = inst_17449);

(statearr_17466_17529[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (13))){
var inst_17451 = (state_17458[(2)]);
var state_17458__$1 = (function (){var statearr_17467 = state_17458;
(statearr_17467[(9)] = inst_17451);

return statearr_17467;
})();
var statearr_17468_17530 = state_17458__$1;
(statearr_17468_17530[(2)] = null);

(statearr_17468_17530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (6))){
var inst_17423 = (state_17458[(7)]);
var state_17458__$1 = state_17458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17458__$1,(11),inst_17423);
} else {
if((state_val_17459 === (17))){
var inst_17444 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
if(cljs.core.truth_(inst_17444)){
var statearr_17469_17531 = state_17458__$1;
(statearr_17469_17531[(1)] = (19));

} else {
var statearr_17470_17532 = state_17458__$1;
(statearr_17470_17532[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (3))){
var inst_17456 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17458__$1,inst_17456);
} else {
if((state_val_17459 === (12))){
var inst_17433 = (state_17458[(10)]);
var state_17458__$1 = state_17458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17458__$1,(14),inst_17433);
} else {
if((state_val_17459 === (2))){
var state_17458__$1 = state_17458;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17458__$1,(4),results);
} else {
if((state_val_17459 === (19))){
var state_17458__$1 = state_17458;
var statearr_17471_17533 = state_17458__$1;
(statearr_17471_17533[(2)] = null);

(statearr_17471_17533[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (11))){
var inst_17433 = (state_17458[(2)]);
var state_17458__$1 = (function (){var statearr_17472 = state_17458;
(statearr_17472[(10)] = inst_17433);

return statearr_17472;
})();
var statearr_17473_17534 = state_17458__$1;
(statearr_17473_17534[(2)] = null);

(statearr_17473_17534[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (9))){
var state_17458__$1 = state_17458;
var statearr_17474_17535 = state_17458__$1;
(statearr_17474_17535[(2)] = null);

(statearr_17474_17535[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (5))){
var state_17458__$1 = state_17458;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17475_17536 = state_17458__$1;
(statearr_17475_17536[(1)] = (8));

} else {
var statearr_17476_17537 = state_17458__$1;
(statearr_17476_17537[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (14))){
var inst_17438 = (state_17458[(11)]);
var inst_17436 = (state_17458[(8)]);
var inst_17436__$1 = (state_17458[(2)]);
var inst_17437 = (inst_17436__$1 == null);
var inst_17438__$1 = cljs.core.not(inst_17437);
var state_17458__$1 = (function (){var statearr_17477 = state_17458;
(statearr_17477[(11)] = inst_17438__$1);

(statearr_17477[(8)] = inst_17436__$1);

return statearr_17477;
})();
if(inst_17438__$1){
var statearr_17478_17538 = state_17458__$1;
(statearr_17478_17538[(1)] = (15));

} else {
var statearr_17479_17539 = state_17458__$1;
(statearr_17479_17539[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (16))){
var inst_17438 = (state_17458[(11)]);
var state_17458__$1 = state_17458;
var statearr_17480_17540 = state_17458__$1;
(statearr_17480_17540[(2)] = inst_17438);

(statearr_17480_17540[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (10))){
var inst_17430 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
var statearr_17481_17541 = state_17458__$1;
(statearr_17481_17541[(2)] = inst_17430);

(statearr_17481_17541[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (18))){
var inst_17441 = (state_17458[(2)]);
var state_17458__$1 = state_17458;
var statearr_17482_17542 = state_17458__$1;
(statearr_17482_17542[(2)] = inst_17441);

(statearr_17482_17542[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17459 === (8))){
var inst_17427 = cljs.core.async.close_BANG_(to);
var state_17458__$1 = state_17458;
var statearr_17483_17543 = state_17458__$1;
(statearr_17483_17543[(2)] = inst_17427);

(statearr_17483_17543[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto__,jobs,results,process,async))
;
return ((function (switch__17043__auto__,c__17150__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0 = (function (){
var statearr_17484 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17484[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__);

(statearr_17484[(1)] = (1));

return statearr_17484;
});
var cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1 = (function (state_17458){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17458);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17485){if((e17485 instanceof Object)){
var ex__17047__auto__ = e17485;
var statearr_17486_17544 = state_17458;
(statearr_17486_17544[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17458);

return cljs.core.cst$kw$recur;
} else {
throw e17485;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17545 = state_17458;
state_17458 = G__17545;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__ = function(state_17458){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1.call(this,state_17458);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__17044__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__,jobs,results,process,async))
})();
var state__17152__auto__ = (function (){var statearr_17487 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17487[(6)] = c__17150__auto__);

return statearr_17487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__,jobs,results,process,async))
);

return c__17150__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__17547 = arguments.length;
switch (G__17547) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__17550 = arguments.length;
switch (G__17550) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__17553 = arguments.length;
switch (G__17553) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__17150__auto___17602 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___17602,tc,fc){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___17602,tc,fc){
return (function (state_17579){
var state_val_17580 = (state_17579[(1)]);
if((state_val_17580 === (7))){
var inst_17575 = (state_17579[(2)]);
var state_17579__$1 = state_17579;
var statearr_17581_17603 = state_17579__$1;
(statearr_17581_17603[(2)] = inst_17575);

(statearr_17581_17603[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (1))){
var state_17579__$1 = state_17579;
var statearr_17582_17604 = state_17579__$1;
(statearr_17582_17604[(2)] = null);

(statearr_17582_17604[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (4))){
var inst_17556 = (state_17579[(7)]);
var inst_17556__$1 = (state_17579[(2)]);
var inst_17557 = (inst_17556__$1 == null);
var state_17579__$1 = (function (){var statearr_17583 = state_17579;
(statearr_17583[(7)] = inst_17556__$1);

return statearr_17583;
})();
if(cljs.core.truth_(inst_17557)){
var statearr_17584_17605 = state_17579__$1;
(statearr_17584_17605[(1)] = (5));

} else {
var statearr_17585_17606 = state_17579__$1;
(statearr_17585_17606[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (13))){
var state_17579__$1 = state_17579;
var statearr_17586_17607 = state_17579__$1;
(statearr_17586_17607[(2)] = null);

(statearr_17586_17607[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (6))){
var inst_17556 = (state_17579[(7)]);
var inst_17562 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17556) : p.call(null,inst_17556));
var state_17579__$1 = state_17579;
if(cljs.core.truth_(inst_17562)){
var statearr_17587_17608 = state_17579__$1;
(statearr_17587_17608[(1)] = (9));

} else {
var statearr_17588_17609 = state_17579__$1;
(statearr_17588_17609[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (3))){
var inst_17577 = (state_17579[(2)]);
var state_17579__$1 = state_17579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17579__$1,inst_17577);
} else {
if((state_val_17580 === (12))){
var state_17579__$1 = state_17579;
var statearr_17589_17610 = state_17579__$1;
(statearr_17589_17610[(2)] = null);

(statearr_17589_17610[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (2))){
var state_17579__$1 = state_17579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17579__$1,(4),ch);
} else {
if((state_val_17580 === (11))){
var inst_17556 = (state_17579[(7)]);
var inst_17566 = (state_17579[(2)]);
var state_17579__$1 = state_17579;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17579__$1,(8),inst_17566,inst_17556);
} else {
if((state_val_17580 === (9))){
var state_17579__$1 = state_17579;
var statearr_17590_17611 = state_17579__$1;
(statearr_17590_17611[(2)] = tc);

(statearr_17590_17611[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (5))){
var inst_17559 = cljs.core.async.close_BANG_(tc);
var inst_17560 = cljs.core.async.close_BANG_(fc);
var state_17579__$1 = (function (){var statearr_17591 = state_17579;
(statearr_17591[(8)] = inst_17559);

return statearr_17591;
})();
var statearr_17592_17612 = state_17579__$1;
(statearr_17592_17612[(2)] = inst_17560);

(statearr_17592_17612[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (14))){
var inst_17573 = (state_17579[(2)]);
var state_17579__$1 = state_17579;
var statearr_17593_17613 = state_17579__$1;
(statearr_17593_17613[(2)] = inst_17573);

(statearr_17593_17613[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (10))){
var state_17579__$1 = state_17579;
var statearr_17594_17614 = state_17579__$1;
(statearr_17594_17614[(2)] = fc);

(statearr_17594_17614[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17580 === (8))){
var inst_17568 = (state_17579[(2)]);
var state_17579__$1 = state_17579;
if(cljs.core.truth_(inst_17568)){
var statearr_17595_17615 = state_17579__$1;
(statearr_17595_17615[(1)] = (12));

} else {
var statearr_17596_17616 = state_17579__$1;
(statearr_17596_17616[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___17602,tc,fc))
;
return ((function (switch__17043__auto__,c__17150__auto___17602,tc,fc){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_17597 = [null,null,null,null,null,null,null,null,null];
(statearr_17597[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_17597[(1)] = (1));

return statearr_17597;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_17579){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17579);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17598){if((e17598 instanceof Object)){
var ex__17047__auto__ = e17598;
var statearr_17599_17617 = state_17579;
(statearr_17599_17617[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17579);

return cljs.core.cst$kw$recur;
} else {
throw e17598;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17618 = state_17579;
state_17579 = G__17618;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_17579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_17579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___17602,tc,fc))
})();
var state__17152__auto__ = (function (){var statearr_17600 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17600[(6)] = c__17150__auto___17602);

return statearr_17600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___17602,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__){
return (function (state_17639){
var state_val_17640 = (state_17639[(1)]);
if((state_val_17640 === (7))){
var inst_17635 = (state_17639[(2)]);
var state_17639__$1 = state_17639;
var statearr_17641_17659 = state_17639__$1;
(statearr_17641_17659[(2)] = inst_17635);

(statearr_17641_17659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17640 === (1))){
var inst_17619 = init;
var state_17639__$1 = (function (){var statearr_17642 = state_17639;
(statearr_17642[(7)] = inst_17619);

return statearr_17642;
})();
var statearr_17643_17660 = state_17639__$1;
(statearr_17643_17660[(2)] = null);

(statearr_17643_17660[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17640 === (4))){
var inst_17622 = (state_17639[(8)]);
var inst_17622__$1 = (state_17639[(2)]);
var inst_17623 = (inst_17622__$1 == null);
var state_17639__$1 = (function (){var statearr_17644 = state_17639;
(statearr_17644[(8)] = inst_17622__$1);

return statearr_17644;
})();
if(cljs.core.truth_(inst_17623)){
var statearr_17645_17661 = state_17639__$1;
(statearr_17645_17661[(1)] = (5));

} else {
var statearr_17646_17662 = state_17639__$1;
(statearr_17646_17662[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17640 === (6))){
var inst_17626 = (state_17639[(9)]);
var inst_17619 = (state_17639[(7)]);
var inst_17622 = (state_17639[(8)]);
var inst_17626__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_17619,inst_17622) : f.call(null,inst_17619,inst_17622));
var inst_17627 = cljs.core.reduced_QMARK_(inst_17626__$1);
var state_17639__$1 = (function (){var statearr_17647 = state_17639;
(statearr_17647[(9)] = inst_17626__$1);

return statearr_17647;
})();
if(inst_17627){
var statearr_17648_17663 = state_17639__$1;
(statearr_17648_17663[(1)] = (8));

} else {
var statearr_17649_17664 = state_17639__$1;
(statearr_17649_17664[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17640 === (3))){
var inst_17637 = (state_17639[(2)]);
var state_17639__$1 = state_17639;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17639__$1,inst_17637);
} else {
if((state_val_17640 === (2))){
var state_17639__$1 = state_17639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17639__$1,(4),ch);
} else {
if((state_val_17640 === (9))){
var inst_17626 = (state_17639[(9)]);
var inst_17619 = inst_17626;
var state_17639__$1 = (function (){var statearr_17650 = state_17639;
(statearr_17650[(7)] = inst_17619);

return statearr_17650;
})();
var statearr_17651_17665 = state_17639__$1;
(statearr_17651_17665[(2)] = null);

(statearr_17651_17665[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17640 === (5))){
var inst_17619 = (state_17639[(7)]);
var state_17639__$1 = state_17639;
var statearr_17652_17666 = state_17639__$1;
(statearr_17652_17666[(2)] = inst_17619);

(statearr_17652_17666[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17640 === (10))){
var inst_17633 = (state_17639[(2)]);
var state_17639__$1 = state_17639;
var statearr_17653_17667 = state_17639__$1;
(statearr_17653_17667[(2)] = inst_17633);

(statearr_17653_17667[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17640 === (8))){
var inst_17626 = (state_17639[(9)]);
var inst_17629 = cljs.core.deref(inst_17626);
var state_17639__$1 = state_17639;
var statearr_17654_17668 = state_17639__$1;
(statearr_17654_17668[(2)] = inst_17629);

(statearr_17654_17668[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto__))
;
return ((function (switch__17043__auto__,c__17150__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__17044__auto__ = null;
var cljs$core$async$reduce_$_state_machine__17044__auto____0 = (function (){
var statearr_17655 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17655[(0)] = cljs$core$async$reduce_$_state_machine__17044__auto__);

(statearr_17655[(1)] = (1));

return statearr_17655;
});
var cljs$core$async$reduce_$_state_machine__17044__auto____1 = (function (state_17639){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17639);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17656){if((e17656 instanceof Object)){
var ex__17047__auto__ = e17656;
var statearr_17657_17669 = state_17639;
(statearr_17657_17669[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17639);

return cljs.core.cst$kw$recur;
} else {
throw e17656;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17670 = state_17639;
state_17639 = G__17670;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__17044__auto__ = function(state_17639){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__17044__auto____1.call(this,state_17639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__17044__auto____0;
cljs$core$async$reduce_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__17044__auto____1;
return cljs$core$async$reduce_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__))
})();
var state__17152__auto__ = (function (){var statearr_17658 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17658[(6)] = c__17150__auto__);

return statearr_17658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__))
);

return c__17150__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__,f__$1){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__,f__$1){
return (function (state_17676){
var state_val_17677 = (state_17676[(1)]);
if((state_val_17677 === (1))){
var inst_17671 = cljs.core.async.reduce(f__$1,init,ch);
var state_17676__$1 = state_17676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17676__$1,(2),inst_17671);
} else {
if((state_val_17677 === (2))){
var inst_17673 = (state_17676[(2)]);
var inst_17674 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_17673) : f__$1.call(null,inst_17673));
var state_17676__$1 = state_17676;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17676__$1,inst_17674);
} else {
return null;
}
}
});})(c__17150__auto__,f__$1))
;
return ((function (switch__17043__auto__,c__17150__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__17044__auto__ = null;
var cljs$core$async$transduce_$_state_machine__17044__auto____0 = (function (){
var statearr_17678 = [null,null,null,null,null,null,null];
(statearr_17678[(0)] = cljs$core$async$transduce_$_state_machine__17044__auto__);

(statearr_17678[(1)] = (1));

return statearr_17678;
});
var cljs$core$async$transduce_$_state_machine__17044__auto____1 = (function (state_17676){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17676);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17679){if((e17679 instanceof Object)){
var ex__17047__auto__ = e17679;
var statearr_17680_17682 = state_17676;
(statearr_17680_17682[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17676);

return cljs.core.cst$kw$recur;
} else {
throw e17679;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17683 = state_17676;
state_17676 = G__17683;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__17044__auto__ = function(state_17676){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__17044__auto____1.call(this,state_17676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__17044__auto____0;
cljs$core$async$transduce_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__17044__auto____1;
return cljs$core$async$transduce_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__,f__$1))
})();
var state__17152__auto__ = (function (){var statearr_17681 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17681[(6)] = c__17150__auto__);

return statearr_17681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__,f__$1))
);

return c__17150__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__17685 = arguments.length;
switch (G__17685) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__){
return (function (state_17710){
var state_val_17711 = (state_17710[(1)]);
if((state_val_17711 === (7))){
var inst_17692 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
var statearr_17712_17733 = state_17710__$1;
(statearr_17712_17733[(2)] = inst_17692);

(statearr_17712_17733[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (1))){
var inst_17686 = cljs.core.seq(coll);
var inst_17687 = inst_17686;
var state_17710__$1 = (function (){var statearr_17713 = state_17710;
(statearr_17713[(7)] = inst_17687);

return statearr_17713;
})();
var statearr_17714_17734 = state_17710__$1;
(statearr_17714_17734[(2)] = null);

(statearr_17714_17734[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (4))){
var inst_17687 = (state_17710[(7)]);
var inst_17690 = cljs.core.first(inst_17687);
var state_17710__$1 = state_17710;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17710__$1,(7),ch,inst_17690);
} else {
if((state_val_17711 === (13))){
var inst_17704 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
var statearr_17715_17735 = state_17710__$1;
(statearr_17715_17735[(2)] = inst_17704);

(statearr_17715_17735[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (6))){
var inst_17695 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
if(cljs.core.truth_(inst_17695)){
var statearr_17716_17736 = state_17710__$1;
(statearr_17716_17736[(1)] = (8));

} else {
var statearr_17717_17737 = state_17710__$1;
(statearr_17717_17737[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (3))){
var inst_17708 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17710__$1,inst_17708);
} else {
if((state_val_17711 === (12))){
var state_17710__$1 = state_17710;
var statearr_17718_17738 = state_17710__$1;
(statearr_17718_17738[(2)] = null);

(statearr_17718_17738[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (2))){
var inst_17687 = (state_17710[(7)]);
var state_17710__$1 = state_17710;
if(cljs.core.truth_(inst_17687)){
var statearr_17719_17739 = state_17710__$1;
(statearr_17719_17739[(1)] = (4));

} else {
var statearr_17720_17740 = state_17710__$1;
(statearr_17720_17740[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (11))){
var inst_17701 = cljs.core.async.close_BANG_(ch);
var state_17710__$1 = state_17710;
var statearr_17721_17741 = state_17710__$1;
(statearr_17721_17741[(2)] = inst_17701);

(statearr_17721_17741[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (9))){
var state_17710__$1 = state_17710;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17722_17742 = state_17710__$1;
(statearr_17722_17742[(1)] = (11));

} else {
var statearr_17723_17743 = state_17710__$1;
(statearr_17723_17743[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (5))){
var inst_17687 = (state_17710[(7)]);
var state_17710__$1 = state_17710;
var statearr_17724_17744 = state_17710__$1;
(statearr_17724_17744[(2)] = inst_17687);

(statearr_17724_17744[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (10))){
var inst_17706 = (state_17710[(2)]);
var state_17710__$1 = state_17710;
var statearr_17725_17745 = state_17710__$1;
(statearr_17725_17745[(2)] = inst_17706);

(statearr_17725_17745[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17711 === (8))){
var inst_17687 = (state_17710[(7)]);
var inst_17697 = cljs.core.next(inst_17687);
var inst_17687__$1 = inst_17697;
var state_17710__$1 = (function (){var statearr_17726 = state_17710;
(statearr_17726[(7)] = inst_17687__$1);

return statearr_17726;
})();
var statearr_17727_17746 = state_17710__$1;
(statearr_17727_17746[(2)] = null);

(statearr_17727_17746[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto__))
;
return ((function (switch__17043__auto__,c__17150__auto__){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_17728 = [null,null,null,null,null,null,null,null];
(statearr_17728[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_17728[(1)] = (1));

return statearr_17728;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_17710){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17710);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17729){if((e17729 instanceof Object)){
var ex__17047__auto__ = e17729;
var statearr_17730_17747 = state_17710;
(statearr_17730_17747[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17710);

return cljs.core.cst$kw$recur;
} else {
throw e17729;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__17748 = state_17710;
state_17710 = G__17748;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_17710){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_17710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__))
})();
var state__17152__auto__ = (function (){var statearr_17731 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17731[(6)] = c__17150__auto__);

return statearr_17731;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__))
);

return c__17150__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4434__auto__.call(null,_));
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4431__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4434__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4431__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async17749 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17749 = (function (ch,cs,meta17750){
this.ch = ch;
this.cs = cs;
this.meta17750 = meta17750;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17751,meta17750__$1){
var self__ = this;
var _17751__$1 = this;
return (new cljs.core.async.t_cljs$core$async17749(self__.ch,self__.cs,meta17750__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17751){
var self__ = this;
var _17751__$1 = this;
return self__.meta17750;
});})(cs))
;

cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17749.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17749.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta17750], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17749.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17749.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17749";

cljs.core.async.t_cljs$core$async17749.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async17749");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async17749.
 */
cljs.core.async.__GT_t_cljs$core$async17749 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17749(ch__$1,cs__$1,meta17750){
return (new cljs.core.async.t_cljs$core$async17749(ch__$1,cs__$1,meta17750));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17749(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__17150__auto___17971 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___17971,cs,m,dchan,dctr,done){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___17971,cs,m,dchan,dctr,done){
return (function (state_17886){
var state_val_17887 = (state_17886[(1)]);
if((state_val_17887 === (7))){
var inst_17882 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17888_17972 = state_17886__$1;
(statearr_17888_17972[(2)] = inst_17882);

(statearr_17888_17972[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (20))){
var inst_17785 = (state_17886[(7)]);
var inst_17797 = cljs.core.first(inst_17785);
var inst_17798 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17797,(0),null);
var inst_17799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17797,(1),null);
var state_17886__$1 = (function (){var statearr_17889 = state_17886;
(statearr_17889[(8)] = inst_17798);

return statearr_17889;
})();
if(cljs.core.truth_(inst_17799)){
var statearr_17890_17973 = state_17886__$1;
(statearr_17890_17973[(1)] = (22));

} else {
var statearr_17891_17974 = state_17886__$1;
(statearr_17891_17974[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (27))){
var inst_17834 = (state_17886[(9)]);
var inst_17829 = (state_17886[(10)]);
var inst_17754 = (state_17886[(11)]);
var inst_17827 = (state_17886[(12)]);
var inst_17834__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17827,inst_17829);
var inst_17835 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17834__$1,inst_17754,done);
var state_17886__$1 = (function (){var statearr_17892 = state_17886;
(statearr_17892[(9)] = inst_17834__$1);

return statearr_17892;
})();
if(cljs.core.truth_(inst_17835)){
var statearr_17893_17975 = state_17886__$1;
(statearr_17893_17975[(1)] = (30));

} else {
var statearr_17894_17976 = state_17886__$1;
(statearr_17894_17976[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (1))){
var state_17886__$1 = state_17886;
var statearr_17895_17977 = state_17886__$1;
(statearr_17895_17977[(2)] = null);

(statearr_17895_17977[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (24))){
var inst_17785 = (state_17886[(7)]);
var inst_17804 = (state_17886[(2)]);
var inst_17805 = cljs.core.next(inst_17785);
var inst_17763 = inst_17805;
var inst_17764 = null;
var inst_17765 = (0);
var inst_17766 = (0);
var state_17886__$1 = (function (){var statearr_17896 = state_17886;
(statearr_17896[(13)] = inst_17804);

(statearr_17896[(14)] = inst_17766);

(statearr_17896[(15)] = inst_17763);

(statearr_17896[(16)] = inst_17764);

(statearr_17896[(17)] = inst_17765);

return statearr_17896;
})();
var statearr_17897_17978 = state_17886__$1;
(statearr_17897_17978[(2)] = null);

(statearr_17897_17978[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (39))){
var state_17886__$1 = state_17886;
var statearr_17901_17979 = state_17886__$1;
(statearr_17901_17979[(2)] = null);

(statearr_17901_17979[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (4))){
var inst_17754 = (state_17886[(11)]);
var inst_17754__$1 = (state_17886[(2)]);
var inst_17755 = (inst_17754__$1 == null);
var state_17886__$1 = (function (){var statearr_17902 = state_17886;
(statearr_17902[(11)] = inst_17754__$1);

return statearr_17902;
})();
if(cljs.core.truth_(inst_17755)){
var statearr_17903_17980 = state_17886__$1;
(statearr_17903_17980[(1)] = (5));

} else {
var statearr_17904_17981 = state_17886__$1;
(statearr_17904_17981[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (15))){
var inst_17766 = (state_17886[(14)]);
var inst_17763 = (state_17886[(15)]);
var inst_17764 = (state_17886[(16)]);
var inst_17765 = (state_17886[(17)]);
var inst_17781 = (state_17886[(2)]);
var inst_17782 = (inst_17766 + (1));
var tmp17898 = inst_17763;
var tmp17899 = inst_17764;
var tmp17900 = inst_17765;
var inst_17763__$1 = tmp17898;
var inst_17764__$1 = tmp17899;
var inst_17765__$1 = tmp17900;
var inst_17766__$1 = inst_17782;
var state_17886__$1 = (function (){var statearr_17905 = state_17886;
(statearr_17905[(14)] = inst_17766__$1);

(statearr_17905[(15)] = inst_17763__$1);

(statearr_17905[(16)] = inst_17764__$1);

(statearr_17905[(18)] = inst_17781);

(statearr_17905[(17)] = inst_17765__$1);

return statearr_17905;
})();
var statearr_17906_17982 = state_17886__$1;
(statearr_17906_17982[(2)] = null);

(statearr_17906_17982[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (21))){
var inst_17808 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17910_17983 = state_17886__$1;
(statearr_17910_17983[(2)] = inst_17808);

(statearr_17910_17983[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (31))){
var inst_17834 = (state_17886[(9)]);
var inst_17838 = done(null);
var inst_17839 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17834);
var state_17886__$1 = (function (){var statearr_17911 = state_17886;
(statearr_17911[(19)] = inst_17838);

return statearr_17911;
})();
var statearr_17912_17984 = state_17886__$1;
(statearr_17912_17984[(2)] = inst_17839);

(statearr_17912_17984[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (32))){
var inst_17829 = (state_17886[(10)]);
var inst_17828 = (state_17886[(20)]);
var inst_17826 = (state_17886[(21)]);
var inst_17827 = (state_17886[(12)]);
var inst_17841 = (state_17886[(2)]);
var inst_17842 = (inst_17829 + (1));
var tmp17907 = inst_17828;
var tmp17908 = inst_17826;
var tmp17909 = inst_17827;
var inst_17826__$1 = tmp17908;
var inst_17827__$1 = tmp17909;
var inst_17828__$1 = tmp17907;
var inst_17829__$1 = inst_17842;
var state_17886__$1 = (function (){var statearr_17913 = state_17886;
(statearr_17913[(10)] = inst_17829__$1);

(statearr_17913[(20)] = inst_17828__$1);

(statearr_17913[(21)] = inst_17826__$1);

(statearr_17913[(22)] = inst_17841);

(statearr_17913[(12)] = inst_17827__$1);

return statearr_17913;
})();
var statearr_17914_17985 = state_17886__$1;
(statearr_17914_17985[(2)] = null);

(statearr_17914_17985[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (40))){
var inst_17854 = (state_17886[(23)]);
var inst_17858 = done(null);
var inst_17859 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_17854);
var state_17886__$1 = (function (){var statearr_17915 = state_17886;
(statearr_17915[(24)] = inst_17858);

return statearr_17915;
})();
var statearr_17916_17986 = state_17886__$1;
(statearr_17916_17986[(2)] = inst_17859);

(statearr_17916_17986[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (33))){
var inst_17845 = (state_17886[(25)]);
var inst_17847 = cljs.core.chunked_seq_QMARK_(inst_17845);
var state_17886__$1 = state_17886;
if(inst_17847){
var statearr_17917_17987 = state_17886__$1;
(statearr_17917_17987[(1)] = (36));

} else {
var statearr_17918_17988 = state_17886__$1;
(statearr_17918_17988[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (13))){
var inst_17775 = (state_17886[(26)]);
var inst_17778 = cljs.core.async.close_BANG_(inst_17775);
var state_17886__$1 = state_17886;
var statearr_17919_17989 = state_17886__$1;
(statearr_17919_17989[(2)] = inst_17778);

(statearr_17919_17989[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (22))){
var inst_17798 = (state_17886[(8)]);
var inst_17801 = cljs.core.async.close_BANG_(inst_17798);
var state_17886__$1 = state_17886;
var statearr_17920_17990 = state_17886__$1;
(statearr_17920_17990[(2)] = inst_17801);

(statearr_17920_17990[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (36))){
var inst_17845 = (state_17886[(25)]);
var inst_17849 = cljs.core.chunk_first(inst_17845);
var inst_17850 = cljs.core.chunk_rest(inst_17845);
var inst_17851 = cljs.core.count(inst_17849);
var inst_17826 = inst_17850;
var inst_17827 = inst_17849;
var inst_17828 = inst_17851;
var inst_17829 = (0);
var state_17886__$1 = (function (){var statearr_17921 = state_17886;
(statearr_17921[(10)] = inst_17829);

(statearr_17921[(20)] = inst_17828);

(statearr_17921[(21)] = inst_17826);

(statearr_17921[(12)] = inst_17827);

return statearr_17921;
})();
var statearr_17922_17991 = state_17886__$1;
(statearr_17922_17991[(2)] = null);

(statearr_17922_17991[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (41))){
var inst_17845 = (state_17886[(25)]);
var inst_17861 = (state_17886[(2)]);
var inst_17862 = cljs.core.next(inst_17845);
var inst_17826 = inst_17862;
var inst_17827 = null;
var inst_17828 = (0);
var inst_17829 = (0);
var state_17886__$1 = (function (){var statearr_17923 = state_17886;
(statearr_17923[(10)] = inst_17829);

(statearr_17923[(20)] = inst_17828);

(statearr_17923[(21)] = inst_17826);

(statearr_17923[(27)] = inst_17861);

(statearr_17923[(12)] = inst_17827);

return statearr_17923;
})();
var statearr_17924_17992 = state_17886__$1;
(statearr_17924_17992[(2)] = null);

(statearr_17924_17992[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (43))){
var state_17886__$1 = state_17886;
var statearr_17925_17993 = state_17886__$1;
(statearr_17925_17993[(2)] = null);

(statearr_17925_17993[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (29))){
var inst_17870 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17926_17994 = state_17886__$1;
(statearr_17926_17994[(2)] = inst_17870);

(statearr_17926_17994[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (44))){
var inst_17879 = (state_17886[(2)]);
var state_17886__$1 = (function (){var statearr_17927 = state_17886;
(statearr_17927[(28)] = inst_17879);

return statearr_17927;
})();
var statearr_17928_17995 = state_17886__$1;
(statearr_17928_17995[(2)] = null);

(statearr_17928_17995[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (6))){
var inst_17818 = (state_17886[(29)]);
var inst_17817 = cljs.core.deref(cs);
var inst_17818__$1 = cljs.core.keys(inst_17817);
var inst_17819 = cljs.core.count(inst_17818__$1);
var inst_17820 = cljs.core.reset_BANG_(dctr,inst_17819);
var inst_17825 = cljs.core.seq(inst_17818__$1);
var inst_17826 = inst_17825;
var inst_17827 = null;
var inst_17828 = (0);
var inst_17829 = (0);
var state_17886__$1 = (function (){var statearr_17929 = state_17886;
(statearr_17929[(10)] = inst_17829);

(statearr_17929[(20)] = inst_17828);

(statearr_17929[(30)] = inst_17820);

(statearr_17929[(21)] = inst_17826);

(statearr_17929[(29)] = inst_17818__$1);

(statearr_17929[(12)] = inst_17827);

return statearr_17929;
})();
var statearr_17930_17996 = state_17886__$1;
(statearr_17930_17996[(2)] = null);

(statearr_17930_17996[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (28))){
var inst_17826 = (state_17886[(21)]);
var inst_17845 = (state_17886[(25)]);
var inst_17845__$1 = cljs.core.seq(inst_17826);
var state_17886__$1 = (function (){var statearr_17931 = state_17886;
(statearr_17931[(25)] = inst_17845__$1);

return statearr_17931;
})();
if(inst_17845__$1){
var statearr_17932_17997 = state_17886__$1;
(statearr_17932_17997[(1)] = (33));

} else {
var statearr_17933_17998 = state_17886__$1;
(statearr_17933_17998[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (25))){
var inst_17829 = (state_17886[(10)]);
var inst_17828 = (state_17886[(20)]);
var inst_17831 = (inst_17829 < inst_17828);
var inst_17832 = inst_17831;
var state_17886__$1 = state_17886;
if(cljs.core.truth_(inst_17832)){
var statearr_17934_17999 = state_17886__$1;
(statearr_17934_17999[(1)] = (27));

} else {
var statearr_17935_18000 = state_17886__$1;
(statearr_17935_18000[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (34))){
var state_17886__$1 = state_17886;
var statearr_17936_18001 = state_17886__$1;
(statearr_17936_18001[(2)] = null);

(statearr_17936_18001[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (17))){
var state_17886__$1 = state_17886;
var statearr_17937_18002 = state_17886__$1;
(statearr_17937_18002[(2)] = null);

(statearr_17937_18002[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (3))){
var inst_17884 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17886__$1,inst_17884);
} else {
if((state_val_17887 === (12))){
var inst_17813 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17938_18003 = state_17886__$1;
(statearr_17938_18003[(2)] = inst_17813);

(statearr_17938_18003[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (2))){
var state_17886__$1 = state_17886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17886__$1,(4),ch);
} else {
if((state_val_17887 === (23))){
var state_17886__$1 = state_17886;
var statearr_17939_18004 = state_17886__$1;
(statearr_17939_18004[(2)] = null);

(statearr_17939_18004[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (35))){
var inst_17868 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17940_18005 = state_17886__$1;
(statearr_17940_18005[(2)] = inst_17868);

(statearr_17940_18005[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (19))){
var inst_17785 = (state_17886[(7)]);
var inst_17789 = cljs.core.chunk_first(inst_17785);
var inst_17790 = cljs.core.chunk_rest(inst_17785);
var inst_17791 = cljs.core.count(inst_17789);
var inst_17763 = inst_17790;
var inst_17764 = inst_17789;
var inst_17765 = inst_17791;
var inst_17766 = (0);
var state_17886__$1 = (function (){var statearr_17941 = state_17886;
(statearr_17941[(14)] = inst_17766);

(statearr_17941[(15)] = inst_17763);

(statearr_17941[(16)] = inst_17764);

(statearr_17941[(17)] = inst_17765);

return statearr_17941;
})();
var statearr_17942_18006 = state_17886__$1;
(statearr_17942_18006[(2)] = null);

(statearr_17942_18006[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (11))){
var inst_17785 = (state_17886[(7)]);
var inst_17763 = (state_17886[(15)]);
var inst_17785__$1 = cljs.core.seq(inst_17763);
var state_17886__$1 = (function (){var statearr_17943 = state_17886;
(statearr_17943[(7)] = inst_17785__$1);

return statearr_17943;
})();
if(inst_17785__$1){
var statearr_17944_18007 = state_17886__$1;
(statearr_17944_18007[(1)] = (16));

} else {
var statearr_17945_18008 = state_17886__$1;
(statearr_17945_18008[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (9))){
var inst_17815 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17946_18009 = state_17886__$1;
(statearr_17946_18009[(2)] = inst_17815);

(statearr_17946_18009[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (5))){
var inst_17761 = cljs.core.deref(cs);
var inst_17762 = cljs.core.seq(inst_17761);
var inst_17763 = inst_17762;
var inst_17764 = null;
var inst_17765 = (0);
var inst_17766 = (0);
var state_17886__$1 = (function (){var statearr_17947 = state_17886;
(statearr_17947[(14)] = inst_17766);

(statearr_17947[(15)] = inst_17763);

(statearr_17947[(16)] = inst_17764);

(statearr_17947[(17)] = inst_17765);

return statearr_17947;
})();
var statearr_17948_18010 = state_17886__$1;
(statearr_17948_18010[(2)] = null);

(statearr_17948_18010[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (14))){
var state_17886__$1 = state_17886;
var statearr_17949_18011 = state_17886__$1;
(statearr_17949_18011[(2)] = null);

(statearr_17949_18011[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (45))){
var inst_17876 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17950_18012 = state_17886__$1;
(statearr_17950_18012[(2)] = inst_17876);

(statearr_17950_18012[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (26))){
var inst_17818 = (state_17886[(29)]);
var inst_17872 = (state_17886[(2)]);
var inst_17873 = cljs.core.seq(inst_17818);
var state_17886__$1 = (function (){var statearr_17951 = state_17886;
(statearr_17951[(31)] = inst_17872);

return statearr_17951;
})();
if(inst_17873){
var statearr_17952_18013 = state_17886__$1;
(statearr_17952_18013[(1)] = (42));

} else {
var statearr_17953_18014 = state_17886__$1;
(statearr_17953_18014[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (16))){
var inst_17785 = (state_17886[(7)]);
var inst_17787 = cljs.core.chunked_seq_QMARK_(inst_17785);
var state_17886__$1 = state_17886;
if(inst_17787){
var statearr_17954_18015 = state_17886__$1;
(statearr_17954_18015[(1)] = (19));

} else {
var statearr_17955_18016 = state_17886__$1;
(statearr_17955_18016[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (38))){
var inst_17865 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17956_18017 = state_17886__$1;
(statearr_17956_18017[(2)] = inst_17865);

(statearr_17956_18017[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (30))){
var state_17886__$1 = state_17886;
var statearr_17957_18018 = state_17886__$1;
(statearr_17957_18018[(2)] = null);

(statearr_17957_18018[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (10))){
var inst_17766 = (state_17886[(14)]);
var inst_17764 = (state_17886[(16)]);
var inst_17774 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17764,inst_17766);
var inst_17775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17774,(0),null);
var inst_17776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17774,(1),null);
var state_17886__$1 = (function (){var statearr_17958 = state_17886;
(statearr_17958[(26)] = inst_17775);

return statearr_17958;
})();
if(cljs.core.truth_(inst_17776)){
var statearr_17959_18019 = state_17886__$1;
(statearr_17959_18019[(1)] = (13));

} else {
var statearr_17960_18020 = state_17886__$1;
(statearr_17960_18020[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (18))){
var inst_17811 = (state_17886[(2)]);
var state_17886__$1 = state_17886;
var statearr_17961_18021 = state_17886__$1;
(statearr_17961_18021[(2)] = inst_17811);

(statearr_17961_18021[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (42))){
var state_17886__$1 = state_17886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17886__$1,(45),dchan);
} else {
if((state_val_17887 === (37))){
var inst_17854 = (state_17886[(23)]);
var inst_17754 = (state_17886[(11)]);
var inst_17845 = (state_17886[(25)]);
var inst_17854__$1 = cljs.core.first(inst_17845);
var inst_17855 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_17854__$1,inst_17754,done);
var state_17886__$1 = (function (){var statearr_17962 = state_17886;
(statearr_17962[(23)] = inst_17854__$1);

return statearr_17962;
})();
if(cljs.core.truth_(inst_17855)){
var statearr_17963_18022 = state_17886__$1;
(statearr_17963_18022[(1)] = (39));

} else {
var statearr_17964_18023 = state_17886__$1;
(statearr_17964_18023[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17887 === (8))){
var inst_17766 = (state_17886[(14)]);
var inst_17765 = (state_17886[(17)]);
var inst_17768 = (inst_17766 < inst_17765);
var inst_17769 = inst_17768;
var state_17886__$1 = state_17886;
if(cljs.core.truth_(inst_17769)){
var statearr_17965_18024 = state_17886__$1;
(statearr_17965_18024[(1)] = (10));

} else {
var statearr_17966_18025 = state_17886__$1;
(statearr_17966_18025[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___17971,cs,m,dchan,dctr,done))
;
return ((function (switch__17043__auto__,c__17150__auto___17971,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__17044__auto__ = null;
var cljs$core$async$mult_$_state_machine__17044__auto____0 = (function (){
var statearr_17967 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17967[(0)] = cljs$core$async$mult_$_state_machine__17044__auto__);

(statearr_17967[(1)] = (1));

return statearr_17967;
});
var cljs$core$async$mult_$_state_machine__17044__auto____1 = (function (state_17886){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_17886);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e17968){if((e17968 instanceof Object)){
var ex__17047__auto__ = e17968;
var statearr_17969_18026 = state_17886;
(statearr_17969_18026[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17886);

return cljs.core.cst$kw$recur;
} else {
throw e17968;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18027 = state_17886;
state_17886 = G__18027;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__17044__auto__ = function(state_17886){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__17044__auto____1.call(this,state_17886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__17044__auto____0;
cljs$core$async$mult_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__17044__auto____1;
return cljs$core$async$mult_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___17971,cs,m,dchan,dctr,done))
})();
var state__17152__auto__ = (function (){var statearr_17970 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_17970[(6)] = c__17150__auto___17971);

return statearr_17970;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___17971,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__18029 = arguments.length;
switch (G__18029) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4434__auto__.call(null,m,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4431__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4434__auto__.call(null,m));
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4431__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4434__auto__.call(null,m,state_map));
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4431__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4434__auto__.call(null,m,mode));
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4431__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___18041 = arguments.length;
var i__4731__auto___18042 = (0);
while(true){
if((i__4731__auto___18042 < len__4730__auto___18041)){
args__4736__auto__.push((arguments[i__4731__auto___18042]));

var G__18043 = (i__4731__auto___18042 + (1));
i__4731__auto___18042 = G__18043;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__18035){
var map__18036 = p__18035;
var map__18036__$1 = (((((!((map__18036 == null))))?(((((map__18036.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__18036.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__18036):map__18036);
var opts = map__18036__$1;
var statearr_18038_18044 = state;
(statearr_18038_18044[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts(((function (map__18036,map__18036__$1,opts){
return (function (val){
var statearr_18039_18045 = state;
(statearr_18039_18045[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__18036,map__18036__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_18040_18046 = state;
(statearr_18040_18046[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq18031){
var G__18032 = cljs.core.first(seq18031);
var seq18031__$1 = cljs.core.next(seq18031);
var G__18033 = cljs.core.first(seq18031__$1);
var seq18031__$2 = cljs.core.next(seq18031__$1);
var G__18034 = cljs.core.first(seq18031__$2);
var seq18031__$3 = cljs.core.next(seq18031__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18032,G__18033,G__18034,seq18031__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18047 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18047 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta18048){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta18048 = meta18048;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18049,meta18048__$1){
var self__ = this;
var _18049__$1 = this;
return (new cljs.core.async.t_cljs$core$async18047(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta18048__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18049){
var self__ = this;
var _18049__$1 = this;
return self__.meta18048;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta18048], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18047.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18047.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18047";

cljs.core.async.t_cljs$core$async18047.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async18047");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18047.
 */
cljs.core.async.__GT_t_cljs$core$async18047 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18047(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta18048){
return (new cljs.core.async.t_cljs$core$async18047(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta18048));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18047(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17150__auto___18211 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18211,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18211,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18151){
var state_val_18152 = (state_18151[(1)]);
if((state_val_18152 === (7))){
var inst_18066 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
var statearr_18153_18212 = state_18151__$1;
(statearr_18153_18212[(2)] = inst_18066);

(statearr_18153_18212[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (20))){
var inst_18078 = (state_18151[(7)]);
var state_18151__$1 = state_18151;
var statearr_18154_18213 = state_18151__$1;
(statearr_18154_18213[(2)] = inst_18078);

(statearr_18154_18213[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (27))){
var state_18151__$1 = state_18151;
var statearr_18155_18214 = state_18151__$1;
(statearr_18155_18214[(2)] = null);

(statearr_18155_18214[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (1))){
var inst_18053 = (state_18151[(8)]);
var inst_18053__$1 = calc_state();
var inst_18055 = (inst_18053__$1 == null);
var inst_18056 = cljs.core.not(inst_18055);
var state_18151__$1 = (function (){var statearr_18156 = state_18151;
(statearr_18156[(8)] = inst_18053__$1);

return statearr_18156;
})();
if(inst_18056){
var statearr_18157_18215 = state_18151__$1;
(statearr_18157_18215[(1)] = (2));

} else {
var statearr_18158_18216 = state_18151__$1;
(statearr_18158_18216[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (24))){
var inst_18125 = (state_18151[(9)]);
var inst_18111 = (state_18151[(10)]);
var inst_18102 = (state_18151[(11)]);
var inst_18125__$1 = (inst_18102.cljs$core$IFn$_invoke$arity$1 ? inst_18102.cljs$core$IFn$_invoke$arity$1(inst_18111) : inst_18102.call(null,inst_18111));
var state_18151__$1 = (function (){var statearr_18159 = state_18151;
(statearr_18159[(9)] = inst_18125__$1);

return statearr_18159;
})();
if(cljs.core.truth_(inst_18125__$1)){
var statearr_18160_18217 = state_18151__$1;
(statearr_18160_18217[(1)] = (29));

} else {
var statearr_18161_18218 = state_18151__$1;
(statearr_18161_18218[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (4))){
var inst_18069 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
if(cljs.core.truth_(inst_18069)){
var statearr_18162_18219 = state_18151__$1;
(statearr_18162_18219[(1)] = (8));

} else {
var statearr_18163_18220 = state_18151__$1;
(statearr_18163_18220[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (15))){
var inst_18096 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
if(cljs.core.truth_(inst_18096)){
var statearr_18164_18221 = state_18151__$1;
(statearr_18164_18221[(1)] = (19));

} else {
var statearr_18165_18222 = state_18151__$1;
(statearr_18165_18222[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (21))){
var inst_18101 = (state_18151[(12)]);
var inst_18101__$1 = (state_18151[(2)]);
var inst_18102 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18101__$1,cljs.core.cst$kw$solos);
var inst_18103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18101__$1,cljs.core.cst$kw$mutes);
var inst_18104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18101__$1,cljs.core.cst$kw$reads);
var state_18151__$1 = (function (){var statearr_18166 = state_18151;
(statearr_18166[(12)] = inst_18101__$1);

(statearr_18166[(11)] = inst_18102);

(statearr_18166[(13)] = inst_18103);

return statearr_18166;
})();
return cljs.core.async.ioc_alts_BANG_(state_18151__$1,(22),inst_18104);
} else {
if((state_val_18152 === (31))){
var inst_18133 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
if(cljs.core.truth_(inst_18133)){
var statearr_18167_18223 = state_18151__$1;
(statearr_18167_18223[(1)] = (32));

} else {
var statearr_18168_18224 = state_18151__$1;
(statearr_18168_18224[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (32))){
var inst_18110 = (state_18151[(14)]);
var state_18151__$1 = state_18151;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18151__$1,(35),out,inst_18110);
} else {
if((state_val_18152 === (33))){
var inst_18101 = (state_18151[(12)]);
var inst_18078 = inst_18101;
var state_18151__$1 = (function (){var statearr_18169 = state_18151;
(statearr_18169[(7)] = inst_18078);

return statearr_18169;
})();
var statearr_18170_18225 = state_18151__$1;
(statearr_18170_18225[(2)] = null);

(statearr_18170_18225[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (13))){
var inst_18078 = (state_18151[(7)]);
var inst_18085 = inst_18078.cljs$lang$protocol_mask$partition0$;
var inst_18086 = (inst_18085 & (64));
var inst_18087 = inst_18078.cljs$core$ISeq$;
var inst_18088 = (cljs.core.PROTOCOL_SENTINEL === inst_18087);
var inst_18089 = ((inst_18086) || (inst_18088));
var state_18151__$1 = state_18151;
if(cljs.core.truth_(inst_18089)){
var statearr_18171_18226 = state_18151__$1;
(statearr_18171_18226[(1)] = (16));

} else {
var statearr_18172_18227 = state_18151__$1;
(statearr_18172_18227[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (22))){
var inst_18110 = (state_18151[(14)]);
var inst_18111 = (state_18151[(10)]);
var inst_18109 = (state_18151[(2)]);
var inst_18110__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18109,(0),null);
var inst_18111__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18109,(1),null);
var inst_18112 = (inst_18110__$1 == null);
var inst_18113 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18111__$1,change);
var inst_18114 = ((inst_18112) || (inst_18113));
var state_18151__$1 = (function (){var statearr_18173 = state_18151;
(statearr_18173[(14)] = inst_18110__$1);

(statearr_18173[(10)] = inst_18111__$1);

return statearr_18173;
})();
if(cljs.core.truth_(inst_18114)){
var statearr_18174_18228 = state_18151__$1;
(statearr_18174_18228[(1)] = (23));

} else {
var statearr_18175_18229 = state_18151__$1;
(statearr_18175_18229[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (36))){
var inst_18101 = (state_18151[(12)]);
var inst_18078 = inst_18101;
var state_18151__$1 = (function (){var statearr_18176 = state_18151;
(statearr_18176[(7)] = inst_18078);

return statearr_18176;
})();
var statearr_18177_18230 = state_18151__$1;
(statearr_18177_18230[(2)] = null);

(statearr_18177_18230[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (29))){
var inst_18125 = (state_18151[(9)]);
var state_18151__$1 = state_18151;
var statearr_18178_18231 = state_18151__$1;
(statearr_18178_18231[(2)] = inst_18125);

(statearr_18178_18231[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (6))){
var state_18151__$1 = state_18151;
var statearr_18179_18232 = state_18151__$1;
(statearr_18179_18232[(2)] = false);

(statearr_18179_18232[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (28))){
var inst_18121 = (state_18151[(2)]);
var inst_18122 = calc_state();
var inst_18078 = inst_18122;
var state_18151__$1 = (function (){var statearr_18180 = state_18151;
(statearr_18180[(7)] = inst_18078);

(statearr_18180[(15)] = inst_18121);

return statearr_18180;
})();
var statearr_18181_18233 = state_18151__$1;
(statearr_18181_18233[(2)] = null);

(statearr_18181_18233[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (25))){
var inst_18147 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
var statearr_18182_18234 = state_18151__$1;
(statearr_18182_18234[(2)] = inst_18147);

(statearr_18182_18234[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (34))){
var inst_18145 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
var statearr_18183_18235 = state_18151__$1;
(statearr_18183_18235[(2)] = inst_18145);

(statearr_18183_18235[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (17))){
var state_18151__$1 = state_18151;
var statearr_18184_18236 = state_18151__$1;
(statearr_18184_18236[(2)] = false);

(statearr_18184_18236[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (3))){
var state_18151__$1 = state_18151;
var statearr_18185_18237 = state_18151__$1;
(statearr_18185_18237[(2)] = false);

(statearr_18185_18237[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (12))){
var inst_18149 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18151__$1,inst_18149);
} else {
if((state_val_18152 === (2))){
var inst_18053 = (state_18151[(8)]);
var inst_18058 = inst_18053.cljs$lang$protocol_mask$partition0$;
var inst_18059 = (inst_18058 & (64));
var inst_18060 = inst_18053.cljs$core$ISeq$;
var inst_18061 = (cljs.core.PROTOCOL_SENTINEL === inst_18060);
var inst_18062 = ((inst_18059) || (inst_18061));
var state_18151__$1 = state_18151;
if(cljs.core.truth_(inst_18062)){
var statearr_18186_18238 = state_18151__$1;
(statearr_18186_18238[(1)] = (5));

} else {
var statearr_18187_18239 = state_18151__$1;
(statearr_18187_18239[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (23))){
var inst_18110 = (state_18151[(14)]);
var inst_18116 = (inst_18110 == null);
var state_18151__$1 = state_18151;
if(cljs.core.truth_(inst_18116)){
var statearr_18188_18240 = state_18151__$1;
(statearr_18188_18240[(1)] = (26));

} else {
var statearr_18189_18241 = state_18151__$1;
(statearr_18189_18241[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (35))){
var inst_18136 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
if(cljs.core.truth_(inst_18136)){
var statearr_18190_18242 = state_18151__$1;
(statearr_18190_18242[(1)] = (36));

} else {
var statearr_18191_18243 = state_18151__$1;
(statearr_18191_18243[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (19))){
var inst_18078 = (state_18151[(7)]);
var inst_18098 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18078);
var state_18151__$1 = state_18151;
var statearr_18192_18244 = state_18151__$1;
(statearr_18192_18244[(2)] = inst_18098);

(statearr_18192_18244[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (11))){
var inst_18078 = (state_18151[(7)]);
var inst_18082 = (inst_18078 == null);
var inst_18083 = cljs.core.not(inst_18082);
var state_18151__$1 = state_18151;
if(inst_18083){
var statearr_18193_18245 = state_18151__$1;
(statearr_18193_18245[(1)] = (13));

} else {
var statearr_18194_18246 = state_18151__$1;
(statearr_18194_18246[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (9))){
var inst_18053 = (state_18151[(8)]);
var state_18151__$1 = state_18151;
var statearr_18195_18247 = state_18151__$1;
(statearr_18195_18247[(2)] = inst_18053);

(statearr_18195_18247[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (5))){
var state_18151__$1 = state_18151;
var statearr_18196_18248 = state_18151__$1;
(statearr_18196_18248[(2)] = true);

(statearr_18196_18248[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (14))){
var state_18151__$1 = state_18151;
var statearr_18197_18249 = state_18151__$1;
(statearr_18197_18249[(2)] = false);

(statearr_18197_18249[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (26))){
var inst_18111 = (state_18151[(10)]);
var inst_18118 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_18111);
var state_18151__$1 = state_18151;
var statearr_18198_18250 = state_18151__$1;
(statearr_18198_18250[(2)] = inst_18118);

(statearr_18198_18250[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (16))){
var state_18151__$1 = state_18151;
var statearr_18199_18251 = state_18151__$1;
(statearr_18199_18251[(2)] = true);

(statearr_18199_18251[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (38))){
var inst_18141 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
var statearr_18200_18252 = state_18151__$1;
(statearr_18200_18252[(2)] = inst_18141);

(statearr_18200_18252[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (30))){
var inst_18111 = (state_18151[(10)]);
var inst_18102 = (state_18151[(11)]);
var inst_18103 = (state_18151[(13)]);
var inst_18128 = cljs.core.empty_QMARK_(inst_18102);
var inst_18129 = (inst_18103.cljs$core$IFn$_invoke$arity$1 ? inst_18103.cljs$core$IFn$_invoke$arity$1(inst_18111) : inst_18103.call(null,inst_18111));
var inst_18130 = cljs.core.not(inst_18129);
var inst_18131 = ((inst_18128) && (inst_18130));
var state_18151__$1 = state_18151;
var statearr_18201_18253 = state_18151__$1;
(statearr_18201_18253[(2)] = inst_18131);

(statearr_18201_18253[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (10))){
var inst_18053 = (state_18151[(8)]);
var inst_18074 = (state_18151[(2)]);
var inst_18075 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18074,cljs.core.cst$kw$solos);
var inst_18076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18074,cljs.core.cst$kw$mutes);
var inst_18077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18074,cljs.core.cst$kw$reads);
var inst_18078 = inst_18053;
var state_18151__$1 = (function (){var statearr_18202 = state_18151;
(statearr_18202[(16)] = inst_18076);

(statearr_18202[(17)] = inst_18075);

(statearr_18202[(7)] = inst_18078);

(statearr_18202[(18)] = inst_18077);

return statearr_18202;
})();
var statearr_18203_18254 = state_18151__$1;
(statearr_18203_18254[(2)] = null);

(statearr_18203_18254[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (18))){
var inst_18093 = (state_18151[(2)]);
var state_18151__$1 = state_18151;
var statearr_18204_18255 = state_18151__$1;
(statearr_18204_18255[(2)] = inst_18093);

(statearr_18204_18255[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (37))){
var state_18151__$1 = state_18151;
var statearr_18205_18256 = state_18151__$1;
(statearr_18205_18256[(2)] = null);

(statearr_18205_18256[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18152 === (8))){
var inst_18053 = (state_18151[(8)]);
var inst_18071 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_18053);
var state_18151__$1 = state_18151;
var statearr_18206_18257 = state_18151__$1;
(statearr_18206_18257[(2)] = inst_18071);

(statearr_18206_18257[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18211,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__17043__auto__,c__17150__auto___18211,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__17044__auto__ = null;
var cljs$core$async$mix_$_state_machine__17044__auto____0 = (function (){
var statearr_18207 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18207[(0)] = cljs$core$async$mix_$_state_machine__17044__auto__);

(statearr_18207[(1)] = (1));

return statearr_18207;
});
var cljs$core$async$mix_$_state_machine__17044__auto____1 = (function (state_18151){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18151);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18208){if((e18208 instanceof Object)){
var ex__17047__auto__ = e18208;
var statearr_18209_18258 = state_18151;
(statearr_18209_18258[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18151);

return cljs.core.cst$kw$recur;
} else {
throw e18208;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18259 = state_18151;
state_18151 = G__18259;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__17044__auto__ = function(state_18151){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__17044__auto____1.call(this,state_18151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__17044__auto____0;
cljs$core$async$mix_$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__17044__auto____1;
return cljs$core$async$mix_$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18211,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__17152__auto__ = (function (){var statearr_18210 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18210[(6)] = c__17150__auto___18211);

return statearr_18210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18211,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4434__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4431__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4434__auto__.call(null,p,v,ch));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4431__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__18261 = arguments.length;
switch (G__18261) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4434__auto__.call(null,p));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4431__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return (m__4434__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4434__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4434__auto__.call(null,p,v));
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return (m__4431__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4431__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4431__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__18265 = arguments.length;
switch (G__18265) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__4131__auto__,mults){
return (function (p1__18263_SHARP_){
if(cljs.core.truth_((p1__18263_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__18263_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__18263_SHARP_.call(null,topic)))){
return p1__18263_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__18263_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18266 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18266 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18267){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18267 = meta18267;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18268,meta18267__$1){
var self__ = this;
var _18268__$1 = this;
return (new cljs.core.async.t_cljs$core$async18266(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18267__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18268){
var self__ = this;
var _18268__$1 = this;
return self__.meta18267;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta18267], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18266.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18266.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18266";

cljs.core.async.t_cljs$core$async18266.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async18266");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18266.
 */
cljs.core.async.__GT_t_cljs$core$async18266 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18266(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18267){
return (new cljs.core.async.t_cljs$core$async18266(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18267));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18266(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__17150__auto___18386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18386,mults,ensure_mult,p){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18386,mults,ensure_mult,p){
return (function (state_18340){
var state_val_18341 = (state_18340[(1)]);
if((state_val_18341 === (7))){
var inst_18336 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
var statearr_18342_18387 = state_18340__$1;
(statearr_18342_18387[(2)] = inst_18336);

(statearr_18342_18387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (20))){
var state_18340__$1 = state_18340;
var statearr_18343_18388 = state_18340__$1;
(statearr_18343_18388[(2)] = null);

(statearr_18343_18388[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (1))){
var state_18340__$1 = state_18340;
var statearr_18344_18389 = state_18340__$1;
(statearr_18344_18389[(2)] = null);

(statearr_18344_18389[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (24))){
var inst_18319 = (state_18340[(7)]);
var inst_18328 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_18319);
var state_18340__$1 = state_18340;
var statearr_18345_18390 = state_18340__$1;
(statearr_18345_18390[(2)] = inst_18328);

(statearr_18345_18390[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (4))){
var inst_18271 = (state_18340[(8)]);
var inst_18271__$1 = (state_18340[(2)]);
var inst_18272 = (inst_18271__$1 == null);
var state_18340__$1 = (function (){var statearr_18346 = state_18340;
(statearr_18346[(8)] = inst_18271__$1);

return statearr_18346;
})();
if(cljs.core.truth_(inst_18272)){
var statearr_18347_18391 = state_18340__$1;
(statearr_18347_18391[(1)] = (5));

} else {
var statearr_18348_18392 = state_18340__$1;
(statearr_18348_18392[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (15))){
var inst_18313 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
var statearr_18349_18393 = state_18340__$1;
(statearr_18349_18393[(2)] = inst_18313);

(statearr_18349_18393[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (21))){
var inst_18333 = (state_18340[(2)]);
var state_18340__$1 = (function (){var statearr_18350 = state_18340;
(statearr_18350[(9)] = inst_18333);

return statearr_18350;
})();
var statearr_18351_18394 = state_18340__$1;
(statearr_18351_18394[(2)] = null);

(statearr_18351_18394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (13))){
var inst_18295 = (state_18340[(10)]);
var inst_18297 = cljs.core.chunked_seq_QMARK_(inst_18295);
var state_18340__$1 = state_18340;
if(inst_18297){
var statearr_18352_18395 = state_18340__$1;
(statearr_18352_18395[(1)] = (16));

} else {
var statearr_18353_18396 = state_18340__$1;
(statearr_18353_18396[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (22))){
var inst_18325 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
if(cljs.core.truth_(inst_18325)){
var statearr_18354_18397 = state_18340__$1;
(statearr_18354_18397[(1)] = (23));

} else {
var statearr_18355_18398 = state_18340__$1;
(statearr_18355_18398[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (6))){
var inst_18321 = (state_18340[(11)]);
var inst_18319 = (state_18340[(7)]);
var inst_18271 = (state_18340[(8)]);
var inst_18319__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_18271) : topic_fn.call(null,inst_18271));
var inst_18320 = cljs.core.deref(mults);
var inst_18321__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18320,inst_18319__$1);
var state_18340__$1 = (function (){var statearr_18356 = state_18340;
(statearr_18356[(11)] = inst_18321__$1);

(statearr_18356[(7)] = inst_18319__$1);

return statearr_18356;
})();
if(cljs.core.truth_(inst_18321__$1)){
var statearr_18357_18399 = state_18340__$1;
(statearr_18357_18399[(1)] = (19));

} else {
var statearr_18358_18400 = state_18340__$1;
(statearr_18358_18400[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (25))){
var inst_18330 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
var statearr_18359_18401 = state_18340__$1;
(statearr_18359_18401[(2)] = inst_18330);

(statearr_18359_18401[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (17))){
var inst_18295 = (state_18340[(10)]);
var inst_18304 = cljs.core.first(inst_18295);
var inst_18305 = cljs.core.async.muxch_STAR_(inst_18304);
var inst_18306 = cljs.core.async.close_BANG_(inst_18305);
var inst_18307 = cljs.core.next(inst_18295);
var inst_18281 = inst_18307;
var inst_18282 = null;
var inst_18283 = (0);
var inst_18284 = (0);
var state_18340__$1 = (function (){var statearr_18360 = state_18340;
(statearr_18360[(12)] = inst_18306);

(statearr_18360[(13)] = inst_18281);

(statearr_18360[(14)] = inst_18283);

(statearr_18360[(15)] = inst_18284);

(statearr_18360[(16)] = inst_18282);

return statearr_18360;
})();
var statearr_18361_18402 = state_18340__$1;
(statearr_18361_18402[(2)] = null);

(statearr_18361_18402[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (3))){
var inst_18338 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18340__$1,inst_18338);
} else {
if((state_val_18341 === (12))){
var inst_18315 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
var statearr_18362_18403 = state_18340__$1;
(statearr_18362_18403[(2)] = inst_18315);

(statearr_18362_18403[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (2))){
var state_18340__$1 = state_18340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18340__$1,(4),ch);
} else {
if((state_val_18341 === (23))){
var state_18340__$1 = state_18340;
var statearr_18363_18404 = state_18340__$1;
(statearr_18363_18404[(2)] = null);

(statearr_18363_18404[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (19))){
var inst_18321 = (state_18340[(11)]);
var inst_18271 = (state_18340[(8)]);
var inst_18323 = cljs.core.async.muxch_STAR_(inst_18321);
var state_18340__$1 = state_18340;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18340__$1,(22),inst_18323,inst_18271);
} else {
if((state_val_18341 === (11))){
var inst_18281 = (state_18340[(13)]);
var inst_18295 = (state_18340[(10)]);
var inst_18295__$1 = cljs.core.seq(inst_18281);
var state_18340__$1 = (function (){var statearr_18364 = state_18340;
(statearr_18364[(10)] = inst_18295__$1);

return statearr_18364;
})();
if(inst_18295__$1){
var statearr_18365_18405 = state_18340__$1;
(statearr_18365_18405[(1)] = (13));

} else {
var statearr_18366_18406 = state_18340__$1;
(statearr_18366_18406[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (9))){
var inst_18317 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
var statearr_18367_18407 = state_18340__$1;
(statearr_18367_18407[(2)] = inst_18317);

(statearr_18367_18407[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (5))){
var inst_18278 = cljs.core.deref(mults);
var inst_18279 = cljs.core.vals(inst_18278);
var inst_18280 = cljs.core.seq(inst_18279);
var inst_18281 = inst_18280;
var inst_18282 = null;
var inst_18283 = (0);
var inst_18284 = (0);
var state_18340__$1 = (function (){var statearr_18368 = state_18340;
(statearr_18368[(13)] = inst_18281);

(statearr_18368[(14)] = inst_18283);

(statearr_18368[(15)] = inst_18284);

(statearr_18368[(16)] = inst_18282);

return statearr_18368;
})();
var statearr_18369_18408 = state_18340__$1;
(statearr_18369_18408[(2)] = null);

(statearr_18369_18408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (14))){
var state_18340__$1 = state_18340;
var statearr_18373_18409 = state_18340__$1;
(statearr_18373_18409[(2)] = null);

(statearr_18373_18409[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (16))){
var inst_18295 = (state_18340[(10)]);
var inst_18299 = cljs.core.chunk_first(inst_18295);
var inst_18300 = cljs.core.chunk_rest(inst_18295);
var inst_18301 = cljs.core.count(inst_18299);
var inst_18281 = inst_18300;
var inst_18282 = inst_18299;
var inst_18283 = inst_18301;
var inst_18284 = (0);
var state_18340__$1 = (function (){var statearr_18374 = state_18340;
(statearr_18374[(13)] = inst_18281);

(statearr_18374[(14)] = inst_18283);

(statearr_18374[(15)] = inst_18284);

(statearr_18374[(16)] = inst_18282);

return statearr_18374;
})();
var statearr_18375_18410 = state_18340__$1;
(statearr_18375_18410[(2)] = null);

(statearr_18375_18410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (10))){
var inst_18281 = (state_18340[(13)]);
var inst_18283 = (state_18340[(14)]);
var inst_18284 = (state_18340[(15)]);
var inst_18282 = (state_18340[(16)]);
var inst_18289 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18282,inst_18284);
var inst_18290 = cljs.core.async.muxch_STAR_(inst_18289);
var inst_18291 = cljs.core.async.close_BANG_(inst_18290);
var inst_18292 = (inst_18284 + (1));
var tmp18370 = inst_18281;
var tmp18371 = inst_18283;
var tmp18372 = inst_18282;
var inst_18281__$1 = tmp18370;
var inst_18282__$1 = tmp18372;
var inst_18283__$1 = tmp18371;
var inst_18284__$1 = inst_18292;
var state_18340__$1 = (function (){var statearr_18376 = state_18340;
(statearr_18376[(13)] = inst_18281__$1);

(statearr_18376[(14)] = inst_18283__$1);

(statearr_18376[(15)] = inst_18284__$1);

(statearr_18376[(17)] = inst_18291);

(statearr_18376[(16)] = inst_18282__$1);

return statearr_18376;
})();
var statearr_18377_18411 = state_18340__$1;
(statearr_18377_18411[(2)] = null);

(statearr_18377_18411[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (18))){
var inst_18310 = (state_18340[(2)]);
var state_18340__$1 = state_18340;
var statearr_18378_18412 = state_18340__$1;
(statearr_18378_18412[(2)] = inst_18310);

(statearr_18378_18412[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18341 === (8))){
var inst_18283 = (state_18340[(14)]);
var inst_18284 = (state_18340[(15)]);
var inst_18286 = (inst_18284 < inst_18283);
var inst_18287 = inst_18286;
var state_18340__$1 = state_18340;
if(cljs.core.truth_(inst_18287)){
var statearr_18379_18413 = state_18340__$1;
(statearr_18379_18413[(1)] = (10));

} else {
var statearr_18380_18414 = state_18340__$1;
(statearr_18380_18414[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18386,mults,ensure_mult,p))
;
return ((function (switch__17043__auto__,c__17150__auto___18386,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_18381 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18381[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_18381[(1)] = (1));

return statearr_18381;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_18340){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18340);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18382){if((e18382 instanceof Object)){
var ex__17047__auto__ = e18382;
var statearr_18383_18415 = state_18340;
(statearr_18383_18415[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18340);

return cljs.core.cst$kw$recur;
} else {
throw e18382;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18416 = state_18340;
state_18340 = G__18416;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_18340){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_18340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18386,mults,ensure_mult,p))
})();
var state__17152__auto__ = (function (){var statearr_18384 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18384[(6)] = c__17150__auto___18386);

return statearr_18384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18386,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__18418 = arguments.length;
switch (G__18418) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__18421 = arguments.length;
switch (G__18421) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__18424 = arguments.length;
switch (G__18424) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__17150__auto___18491 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18491,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18491,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18463){
var state_val_18464 = (state_18463[(1)]);
if((state_val_18464 === (7))){
var state_18463__$1 = state_18463;
var statearr_18465_18492 = state_18463__$1;
(statearr_18465_18492[(2)] = null);

(statearr_18465_18492[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (1))){
var state_18463__$1 = state_18463;
var statearr_18466_18493 = state_18463__$1;
(statearr_18466_18493[(2)] = null);

(statearr_18466_18493[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (4))){
var inst_18427 = (state_18463[(7)]);
var inst_18429 = (inst_18427 < cnt);
var state_18463__$1 = state_18463;
if(cljs.core.truth_(inst_18429)){
var statearr_18467_18494 = state_18463__$1;
(statearr_18467_18494[(1)] = (6));

} else {
var statearr_18468_18495 = state_18463__$1;
(statearr_18468_18495[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (15))){
var inst_18459 = (state_18463[(2)]);
var state_18463__$1 = state_18463;
var statearr_18469_18496 = state_18463__$1;
(statearr_18469_18496[(2)] = inst_18459);

(statearr_18469_18496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (13))){
var inst_18452 = cljs.core.async.close_BANG_(out);
var state_18463__$1 = state_18463;
var statearr_18470_18497 = state_18463__$1;
(statearr_18470_18497[(2)] = inst_18452);

(statearr_18470_18497[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (6))){
var state_18463__$1 = state_18463;
var statearr_18471_18498 = state_18463__$1;
(statearr_18471_18498[(2)] = null);

(statearr_18471_18498[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (3))){
var inst_18461 = (state_18463[(2)]);
var state_18463__$1 = state_18463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18463__$1,inst_18461);
} else {
if((state_val_18464 === (12))){
var inst_18449 = (state_18463[(8)]);
var inst_18449__$1 = (state_18463[(2)]);
var inst_18450 = cljs.core.some(cljs.core.nil_QMARK_,inst_18449__$1);
var state_18463__$1 = (function (){var statearr_18472 = state_18463;
(statearr_18472[(8)] = inst_18449__$1);

return statearr_18472;
})();
if(cljs.core.truth_(inst_18450)){
var statearr_18473_18499 = state_18463__$1;
(statearr_18473_18499[(1)] = (13));

} else {
var statearr_18474_18500 = state_18463__$1;
(statearr_18474_18500[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (2))){
var inst_18426 = cljs.core.reset_BANG_(dctr,cnt);
var inst_18427 = (0);
var state_18463__$1 = (function (){var statearr_18475 = state_18463;
(statearr_18475[(9)] = inst_18426);

(statearr_18475[(7)] = inst_18427);

return statearr_18475;
})();
var statearr_18476_18501 = state_18463__$1;
(statearr_18476_18501[(2)] = null);

(statearr_18476_18501[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (11))){
var inst_18427 = (state_18463[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_18463,(10),Object,null,(9));
var inst_18436 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_18427) : chs__$1.call(null,inst_18427));
var inst_18437 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_18427) : done.call(null,inst_18427));
var inst_18438 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18436,inst_18437);
var state_18463__$1 = state_18463;
var statearr_18477_18502 = state_18463__$1;
(statearr_18477_18502[(2)] = inst_18438);


cljs.core.async.impl.ioc_helpers.process_exception(state_18463__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (9))){
var inst_18427 = (state_18463[(7)]);
var inst_18440 = (state_18463[(2)]);
var inst_18441 = (inst_18427 + (1));
var inst_18427__$1 = inst_18441;
var state_18463__$1 = (function (){var statearr_18478 = state_18463;
(statearr_18478[(10)] = inst_18440);

(statearr_18478[(7)] = inst_18427__$1);

return statearr_18478;
})();
var statearr_18479_18503 = state_18463__$1;
(statearr_18479_18503[(2)] = null);

(statearr_18479_18503[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (5))){
var inst_18447 = (state_18463[(2)]);
var state_18463__$1 = (function (){var statearr_18480 = state_18463;
(statearr_18480[(11)] = inst_18447);

return statearr_18480;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18463__$1,(12),dchan);
} else {
if((state_val_18464 === (14))){
var inst_18449 = (state_18463[(8)]);
var inst_18454 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_18449);
var state_18463__$1 = state_18463;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18463__$1,(16),out,inst_18454);
} else {
if((state_val_18464 === (16))){
var inst_18456 = (state_18463[(2)]);
var state_18463__$1 = (function (){var statearr_18481 = state_18463;
(statearr_18481[(12)] = inst_18456);

return statearr_18481;
})();
var statearr_18482_18504 = state_18463__$1;
(statearr_18482_18504[(2)] = null);

(statearr_18482_18504[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (10))){
var inst_18431 = (state_18463[(2)]);
var inst_18432 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_18463__$1 = (function (){var statearr_18483 = state_18463;
(statearr_18483[(13)] = inst_18431);

return statearr_18483;
})();
var statearr_18484_18505 = state_18463__$1;
(statearr_18484_18505[(2)] = inst_18432);


cljs.core.async.impl.ioc_helpers.process_exception(state_18463__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_18464 === (8))){
var inst_18445 = (state_18463[(2)]);
var state_18463__$1 = state_18463;
var statearr_18485_18506 = state_18463__$1;
(statearr_18485_18506[(2)] = inst_18445);

(statearr_18485_18506[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18491,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__17043__auto__,c__17150__auto___18491,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_18486 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18486[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_18486[(1)] = (1));

return statearr_18486;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_18463){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18463);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18487){if((e18487 instanceof Object)){
var ex__17047__auto__ = e18487;
var statearr_18488_18507 = state_18463;
(statearr_18488_18507[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18463);

return cljs.core.cst$kw$recur;
} else {
throw e18487;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18508 = state_18463;
state_18463 = G__18508;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_18463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_18463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18491,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__17152__auto__ = (function (){var statearr_18489 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18489[(6)] = c__17150__auto___18491);

return statearr_18489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18491,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__18511 = arguments.length;
switch (G__18511) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17150__auto___18565 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18565,out){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18565,out){
return (function (state_18543){
var state_val_18544 = (state_18543[(1)]);
if((state_val_18544 === (7))){
var inst_18523 = (state_18543[(7)]);
var inst_18522 = (state_18543[(8)]);
var inst_18522__$1 = (state_18543[(2)]);
var inst_18523__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18522__$1,(0),null);
var inst_18524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18522__$1,(1),null);
var inst_18525 = (inst_18523__$1 == null);
var state_18543__$1 = (function (){var statearr_18545 = state_18543;
(statearr_18545[(7)] = inst_18523__$1);

(statearr_18545[(8)] = inst_18522__$1);

(statearr_18545[(9)] = inst_18524);

return statearr_18545;
})();
if(cljs.core.truth_(inst_18525)){
var statearr_18546_18566 = state_18543__$1;
(statearr_18546_18566[(1)] = (8));

} else {
var statearr_18547_18567 = state_18543__$1;
(statearr_18547_18567[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18544 === (1))){
var inst_18512 = cljs.core.vec(chs);
var inst_18513 = inst_18512;
var state_18543__$1 = (function (){var statearr_18548 = state_18543;
(statearr_18548[(10)] = inst_18513);

return statearr_18548;
})();
var statearr_18549_18568 = state_18543__$1;
(statearr_18549_18568[(2)] = null);

(statearr_18549_18568[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18544 === (4))){
var inst_18513 = (state_18543[(10)]);
var state_18543__$1 = state_18543;
return cljs.core.async.ioc_alts_BANG_(state_18543__$1,(7),inst_18513);
} else {
if((state_val_18544 === (6))){
var inst_18539 = (state_18543[(2)]);
var state_18543__$1 = state_18543;
var statearr_18550_18569 = state_18543__$1;
(statearr_18550_18569[(2)] = inst_18539);

(statearr_18550_18569[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18544 === (3))){
var inst_18541 = (state_18543[(2)]);
var state_18543__$1 = state_18543;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18543__$1,inst_18541);
} else {
if((state_val_18544 === (2))){
var inst_18513 = (state_18543[(10)]);
var inst_18515 = cljs.core.count(inst_18513);
var inst_18516 = (inst_18515 > (0));
var state_18543__$1 = state_18543;
if(cljs.core.truth_(inst_18516)){
var statearr_18552_18570 = state_18543__$1;
(statearr_18552_18570[(1)] = (4));

} else {
var statearr_18553_18571 = state_18543__$1;
(statearr_18553_18571[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18544 === (11))){
var inst_18513 = (state_18543[(10)]);
var inst_18532 = (state_18543[(2)]);
var tmp18551 = inst_18513;
var inst_18513__$1 = tmp18551;
var state_18543__$1 = (function (){var statearr_18554 = state_18543;
(statearr_18554[(10)] = inst_18513__$1);

(statearr_18554[(11)] = inst_18532);

return statearr_18554;
})();
var statearr_18555_18572 = state_18543__$1;
(statearr_18555_18572[(2)] = null);

(statearr_18555_18572[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18544 === (9))){
var inst_18523 = (state_18543[(7)]);
var state_18543__$1 = state_18543;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18543__$1,(11),out,inst_18523);
} else {
if((state_val_18544 === (5))){
var inst_18537 = cljs.core.async.close_BANG_(out);
var state_18543__$1 = state_18543;
var statearr_18556_18573 = state_18543__$1;
(statearr_18556_18573[(2)] = inst_18537);

(statearr_18556_18573[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18544 === (10))){
var inst_18535 = (state_18543[(2)]);
var state_18543__$1 = state_18543;
var statearr_18557_18574 = state_18543__$1;
(statearr_18557_18574[(2)] = inst_18535);

(statearr_18557_18574[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18544 === (8))){
var inst_18523 = (state_18543[(7)]);
var inst_18513 = (state_18543[(10)]);
var inst_18522 = (state_18543[(8)]);
var inst_18524 = (state_18543[(9)]);
var inst_18527 = (function (){var cs = inst_18513;
var vec__18518 = inst_18522;
var v = inst_18523;
var c = inst_18524;
return ((function (cs,vec__18518,v,c,inst_18523,inst_18513,inst_18522,inst_18524,state_val_18544,c__17150__auto___18565,out){
return (function (p1__18509_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__18509_SHARP_);
});
;})(cs,vec__18518,v,c,inst_18523,inst_18513,inst_18522,inst_18524,state_val_18544,c__17150__auto___18565,out))
})();
var inst_18528 = cljs.core.filterv(inst_18527,inst_18513);
var inst_18513__$1 = inst_18528;
var state_18543__$1 = (function (){var statearr_18558 = state_18543;
(statearr_18558[(10)] = inst_18513__$1);

return statearr_18558;
})();
var statearr_18559_18575 = state_18543__$1;
(statearr_18559_18575[(2)] = null);

(statearr_18559_18575[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18565,out))
;
return ((function (switch__17043__auto__,c__17150__auto___18565,out){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_18560 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18560[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_18560[(1)] = (1));

return statearr_18560;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_18543){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18543);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18561){if((e18561 instanceof Object)){
var ex__17047__auto__ = e18561;
var statearr_18562_18576 = state_18543;
(statearr_18562_18576[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18543);

return cljs.core.cst$kw$recur;
} else {
throw e18561;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18577 = state_18543;
state_18543 = G__18577;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_18543){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_18543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18565,out))
})();
var state__17152__auto__ = (function (){var statearr_18563 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18563[(6)] = c__17150__auto___18565);

return statearr_18563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18565,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__18579 = arguments.length;
switch (G__18579) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17150__auto___18624 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18624,out){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18624,out){
return (function (state_18603){
var state_val_18604 = (state_18603[(1)]);
if((state_val_18604 === (7))){
var inst_18585 = (state_18603[(7)]);
var inst_18585__$1 = (state_18603[(2)]);
var inst_18586 = (inst_18585__$1 == null);
var inst_18587 = cljs.core.not(inst_18586);
var state_18603__$1 = (function (){var statearr_18605 = state_18603;
(statearr_18605[(7)] = inst_18585__$1);

return statearr_18605;
})();
if(inst_18587){
var statearr_18606_18625 = state_18603__$1;
(statearr_18606_18625[(1)] = (8));

} else {
var statearr_18607_18626 = state_18603__$1;
(statearr_18607_18626[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (1))){
var inst_18580 = (0);
var state_18603__$1 = (function (){var statearr_18608 = state_18603;
(statearr_18608[(8)] = inst_18580);

return statearr_18608;
})();
var statearr_18609_18627 = state_18603__$1;
(statearr_18609_18627[(2)] = null);

(statearr_18609_18627[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (4))){
var state_18603__$1 = state_18603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18603__$1,(7),ch);
} else {
if((state_val_18604 === (6))){
var inst_18598 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18610_18628 = state_18603__$1;
(statearr_18610_18628[(2)] = inst_18598);

(statearr_18610_18628[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (3))){
var inst_18600 = (state_18603[(2)]);
var inst_18601 = cljs.core.async.close_BANG_(out);
var state_18603__$1 = (function (){var statearr_18611 = state_18603;
(statearr_18611[(9)] = inst_18600);

return statearr_18611;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18603__$1,inst_18601);
} else {
if((state_val_18604 === (2))){
var inst_18580 = (state_18603[(8)]);
var inst_18582 = (inst_18580 < n);
var state_18603__$1 = state_18603;
if(cljs.core.truth_(inst_18582)){
var statearr_18612_18629 = state_18603__$1;
(statearr_18612_18629[(1)] = (4));

} else {
var statearr_18613_18630 = state_18603__$1;
(statearr_18613_18630[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (11))){
var inst_18580 = (state_18603[(8)]);
var inst_18590 = (state_18603[(2)]);
var inst_18591 = (inst_18580 + (1));
var inst_18580__$1 = inst_18591;
var state_18603__$1 = (function (){var statearr_18614 = state_18603;
(statearr_18614[(8)] = inst_18580__$1);

(statearr_18614[(10)] = inst_18590);

return statearr_18614;
})();
var statearr_18615_18631 = state_18603__$1;
(statearr_18615_18631[(2)] = null);

(statearr_18615_18631[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (9))){
var state_18603__$1 = state_18603;
var statearr_18616_18632 = state_18603__$1;
(statearr_18616_18632[(2)] = null);

(statearr_18616_18632[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (5))){
var state_18603__$1 = state_18603;
var statearr_18617_18633 = state_18603__$1;
(statearr_18617_18633[(2)] = null);

(statearr_18617_18633[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (10))){
var inst_18595 = (state_18603[(2)]);
var state_18603__$1 = state_18603;
var statearr_18618_18634 = state_18603__$1;
(statearr_18618_18634[(2)] = inst_18595);

(statearr_18618_18634[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18604 === (8))){
var inst_18585 = (state_18603[(7)]);
var state_18603__$1 = state_18603;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18603__$1,(11),out,inst_18585);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18624,out))
;
return ((function (switch__17043__auto__,c__17150__auto___18624,out){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_18619 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18619[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_18619[(1)] = (1));

return statearr_18619;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_18603){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18603);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18620){if((e18620 instanceof Object)){
var ex__17047__auto__ = e18620;
var statearr_18621_18635 = state_18603;
(statearr_18621_18635[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18603);

return cljs.core.cst$kw$recur;
} else {
throw e18620;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18636 = state_18603;
state_18603 = G__18636;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_18603){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_18603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18624,out))
})();
var state__17152__auto__ = (function (){var statearr_18622 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18622[(6)] = c__17150__auto___18624);

return statearr_18622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18624,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18638 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18638 = (function (f,ch,meta18639){
this.f = f;
this.ch = ch;
this.meta18639 = meta18639;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18640,meta18639__$1){
var self__ = this;
var _18640__$1 = this;
return (new cljs.core.async.t_cljs$core$async18638(self__.f,self__.ch,meta18639__$1));
});

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18640){
var self__ = this;
var _18640__$1 = this;
return self__.meta18639;
});

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18641 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18641 = (function (f,ch,meta18639,_,fn1,meta18642){
this.f = f;
this.ch = ch;
this.meta18639 = meta18639;
this._ = _;
this.fn1 = fn1;
this.meta18642 = meta18642;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18641.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18643,meta18642__$1){
var self__ = this;
var _18643__$1 = this;
return (new cljs.core.async.t_cljs$core$async18641(self__.f,self__.ch,self__.meta18639,self__._,self__.fn1,meta18642__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18641.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18643){
var self__ = this;
var _18643__$1 = this;
return self__.meta18642;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18641.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18641.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18641.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18641.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18637_SHARP_){
var G__18644 = (((p1__18637_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__18637_SHARP_) : self__.f.call(null,p1__18637_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__18644) : f1.call(null,G__18644));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18641.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18639,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async18638], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta18642], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18641.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18641.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18641";

cljs.core.async.t_cljs$core$async18641.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async18641");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18641.
 */
cljs.core.async.__GT_t_cljs$core$async18641 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18641(f__$1,ch__$1,meta18639__$1,___$2,fn1__$1,meta18642){
return (new cljs.core.async.t_cljs$core$async18641(f__$1,ch__$1,meta18639__$1,___$2,fn1__$1,meta18642));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18641(self__.f,self__.ch,self__.meta18639,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__18645 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__18645) : self__.f.call(null,G__18645));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18638.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18638.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18639], null);
});

cljs.core.async.t_cljs$core$async18638.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18638.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18638";

cljs.core.async.t_cljs$core$async18638.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async18638");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18638.
 */
cljs.core.async.__GT_t_cljs$core$async18638 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18638(f__$1,ch__$1,meta18639){
return (new cljs.core.async.t_cljs$core$async18638(f__$1,ch__$1,meta18639));
});

}

return (new cljs.core.async.t_cljs$core$async18638(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18646 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18646 = (function (f,ch,meta18647){
this.f = f;
this.ch = ch;
this.meta18647 = meta18647;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18648,meta18647__$1){
var self__ = this;
var _18648__$1 = this;
return (new cljs.core.async.t_cljs$core$async18646(self__.f,self__.ch,meta18647__$1));
});

cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18648){
var self__ = this;
var _18648__$1 = this;
return self__.meta18647;
});

cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18646.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async18646.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18647], null);
});

cljs.core.async.t_cljs$core$async18646.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18646.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18646";

cljs.core.async.t_cljs$core$async18646.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async18646");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18646.
 */
cljs.core.async.__GT_t_cljs$core$async18646 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18646(f__$1,ch__$1,meta18647){
return (new cljs.core.async.t_cljs$core$async18646(f__$1,ch__$1,meta18647));
});

}

return (new cljs.core.async.t_cljs$core$async18646(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async18649 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18649 = (function (p,ch,meta18650){
this.p = p;
this.ch = ch;
this.meta18650 = meta18650;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18651,meta18650__$1){
var self__ = this;
var _18651__$1 = this;
return (new cljs.core.async.t_cljs$core$async18649(self__.p,self__.ch,meta18650__$1));
});

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18651){
var self__ = this;
var _18651__$1 = this;
return self__.meta18650;
});

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async18649.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18649.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta18650], null);
});

cljs.core.async.t_cljs$core$async18649.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18649.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18649";

cljs.core.async.t_cljs$core$async18649.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write(writer__4375__auto__,"cljs.core.async/t_cljs$core$async18649");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async18649.
 */
cljs.core.async.__GT_t_cljs$core$async18649 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18649(p__$1,ch__$1,meta18650){
return (new cljs.core.async.t_cljs$core$async18649(p__$1,ch__$1,meta18650));
});

}

return (new cljs.core.async.t_cljs$core$async18649(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__18653 = arguments.length;
switch (G__18653) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17150__auto___18693 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18693,out){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18693,out){
return (function (state_18674){
var state_val_18675 = (state_18674[(1)]);
if((state_val_18675 === (7))){
var inst_18670 = (state_18674[(2)]);
var state_18674__$1 = state_18674;
var statearr_18676_18694 = state_18674__$1;
(statearr_18676_18694[(2)] = inst_18670);

(statearr_18676_18694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (1))){
var state_18674__$1 = state_18674;
var statearr_18677_18695 = state_18674__$1;
(statearr_18677_18695[(2)] = null);

(statearr_18677_18695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (4))){
var inst_18656 = (state_18674[(7)]);
var inst_18656__$1 = (state_18674[(2)]);
var inst_18657 = (inst_18656__$1 == null);
var state_18674__$1 = (function (){var statearr_18678 = state_18674;
(statearr_18678[(7)] = inst_18656__$1);

return statearr_18678;
})();
if(cljs.core.truth_(inst_18657)){
var statearr_18679_18696 = state_18674__$1;
(statearr_18679_18696[(1)] = (5));

} else {
var statearr_18680_18697 = state_18674__$1;
(statearr_18680_18697[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (6))){
var inst_18656 = (state_18674[(7)]);
var inst_18661 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_18656) : p.call(null,inst_18656));
var state_18674__$1 = state_18674;
if(cljs.core.truth_(inst_18661)){
var statearr_18681_18698 = state_18674__$1;
(statearr_18681_18698[(1)] = (8));

} else {
var statearr_18682_18699 = state_18674__$1;
(statearr_18682_18699[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (3))){
var inst_18672 = (state_18674[(2)]);
var state_18674__$1 = state_18674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18674__$1,inst_18672);
} else {
if((state_val_18675 === (2))){
var state_18674__$1 = state_18674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18674__$1,(4),ch);
} else {
if((state_val_18675 === (11))){
var inst_18664 = (state_18674[(2)]);
var state_18674__$1 = state_18674;
var statearr_18683_18700 = state_18674__$1;
(statearr_18683_18700[(2)] = inst_18664);

(statearr_18683_18700[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (9))){
var state_18674__$1 = state_18674;
var statearr_18684_18701 = state_18674__$1;
(statearr_18684_18701[(2)] = null);

(statearr_18684_18701[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (5))){
var inst_18659 = cljs.core.async.close_BANG_(out);
var state_18674__$1 = state_18674;
var statearr_18685_18702 = state_18674__$1;
(statearr_18685_18702[(2)] = inst_18659);

(statearr_18685_18702[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (10))){
var inst_18667 = (state_18674[(2)]);
var state_18674__$1 = (function (){var statearr_18686 = state_18674;
(statearr_18686[(8)] = inst_18667);

return statearr_18686;
})();
var statearr_18687_18703 = state_18674__$1;
(statearr_18687_18703[(2)] = null);

(statearr_18687_18703[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18675 === (8))){
var inst_18656 = (state_18674[(7)]);
var state_18674__$1 = state_18674;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18674__$1,(11),out,inst_18656);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18693,out))
;
return ((function (switch__17043__auto__,c__17150__auto___18693,out){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_18688 = [null,null,null,null,null,null,null,null,null];
(statearr_18688[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_18688[(1)] = (1));

return statearr_18688;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_18674){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18674);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18689){if((e18689 instanceof Object)){
var ex__17047__auto__ = e18689;
var statearr_18690_18704 = state_18674;
(statearr_18690_18704[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18674);

return cljs.core.cst$kw$recur;
} else {
throw e18689;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18705 = state_18674;
state_18674 = G__18705;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_18674){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_18674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18693,out))
})();
var state__17152__auto__ = (function (){var statearr_18691 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18691[(6)] = c__17150__auto___18693);

return statearr_18691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18693,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__18707 = arguments.length;
switch (G__18707) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__17150__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto__){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto__){
return (function (state_18770){
var state_val_18771 = (state_18770[(1)]);
if((state_val_18771 === (7))){
var inst_18766 = (state_18770[(2)]);
var state_18770__$1 = state_18770;
var statearr_18772_18810 = state_18770__$1;
(statearr_18772_18810[(2)] = inst_18766);

(statearr_18772_18810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (20))){
var inst_18736 = (state_18770[(7)]);
var inst_18747 = (state_18770[(2)]);
var inst_18748 = cljs.core.next(inst_18736);
var inst_18722 = inst_18748;
var inst_18723 = null;
var inst_18724 = (0);
var inst_18725 = (0);
var state_18770__$1 = (function (){var statearr_18773 = state_18770;
(statearr_18773[(8)] = inst_18722);

(statearr_18773[(9)] = inst_18723);

(statearr_18773[(10)] = inst_18747);

(statearr_18773[(11)] = inst_18724);

(statearr_18773[(12)] = inst_18725);

return statearr_18773;
})();
var statearr_18774_18811 = state_18770__$1;
(statearr_18774_18811[(2)] = null);

(statearr_18774_18811[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (1))){
var state_18770__$1 = state_18770;
var statearr_18775_18812 = state_18770__$1;
(statearr_18775_18812[(2)] = null);

(statearr_18775_18812[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (4))){
var inst_18711 = (state_18770[(13)]);
var inst_18711__$1 = (state_18770[(2)]);
var inst_18712 = (inst_18711__$1 == null);
var state_18770__$1 = (function (){var statearr_18776 = state_18770;
(statearr_18776[(13)] = inst_18711__$1);

return statearr_18776;
})();
if(cljs.core.truth_(inst_18712)){
var statearr_18777_18813 = state_18770__$1;
(statearr_18777_18813[(1)] = (5));

} else {
var statearr_18778_18814 = state_18770__$1;
(statearr_18778_18814[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (15))){
var state_18770__$1 = state_18770;
var statearr_18782_18815 = state_18770__$1;
(statearr_18782_18815[(2)] = null);

(statearr_18782_18815[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (21))){
var state_18770__$1 = state_18770;
var statearr_18783_18816 = state_18770__$1;
(statearr_18783_18816[(2)] = null);

(statearr_18783_18816[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (13))){
var inst_18722 = (state_18770[(8)]);
var inst_18723 = (state_18770[(9)]);
var inst_18724 = (state_18770[(11)]);
var inst_18725 = (state_18770[(12)]);
var inst_18732 = (state_18770[(2)]);
var inst_18733 = (inst_18725 + (1));
var tmp18779 = inst_18722;
var tmp18780 = inst_18723;
var tmp18781 = inst_18724;
var inst_18722__$1 = tmp18779;
var inst_18723__$1 = tmp18780;
var inst_18724__$1 = tmp18781;
var inst_18725__$1 = inst_18733;
var state_18770__$1 = (function (){var statearr_18784 = state_18770;
(statearr_18784[(8)] = inst_18722__$1);

(statearr_18784[(9)] = inst_18723__$1);

(statearr_18784[(14)] = inst_18732);

(statearr_18784[(11)] = inst_18724__$1);

(statearr_18784[(12)] = inst_18725__$1);

return statearr_18784;
})();
var statearr_18785_18817 = state_18770__$1;
(statearr_18785_18817[(2)] = null);

(statearr_18785_18817[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (22))){
var state_18770__$1 = state_18770;
var statearr_18786_18818 = state_18770__$1;
(statearr_18786_18818[(2)] = null);

(statearr_18786_18818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (6))){
var inst_18711 = (state_18770[(13)]);
var inst_18720 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18711) : f.call(null,inst_18711));
var inst_18721 = cljs.core.seq(inst_18720);
var inst_18722 = inst_18721;
var inst_18723 = null;
var inst_18724 = (0);
var inst_18725 = (0);
var state_18770__$1 = (function (){var statearr_18787 = state_18770;
(statearr_18787[(8)] = inst_18722);

(statearr_18787[(9)] = inst_18723);

(statearr_18787[(11)] = inst_18724);

(statearr_18787[(12)] = inst_18725);

return statearr_18787;
})();
var statearr_18788_18819 = state_18770__$1;
(statearr_18788_18819[(2)] = null);

(statearr_18788_18819[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (17))){
var inst_18736 = (state_18770[(7)]);
var inst_18740 = cljs.core.chunk_first(inst_18736);
var inst_18741 = cljs.core.chunk_rest(inst_18736);
var inst_18742 = cljs.core.count(inst_18740);
var inst_18722 = inst_18741;
var inst_18723 = inst_18740;
var inst_18724 = inst_18742;
var inst_18725 = (0);
var state_18770__$1 = (function (){var statearr_18789 = state_18770;
(statearr_18789[(8)] = inst_18722);

(statearr_18789[(9)] = inst_18723);

(statearr_18789[(11)] = inst_18724);

(statearr_18789[(12)] = inst_18725);

return statearr_18789;
})();
var statearr_18790_18820 = state_18770__$1;
(statearr_18790_18820[(2)] = null);

(statearr_18790_18820[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (3))){
var inst_18768 = (state_18770[(2)]);
var state_18770__$1 = state_18770;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18770__$1,inst_18768);
} else {
if((state_val_18771 === (12))){
var inst_18756 = (state_18770[(2)]);
var state_18770__$1 = state_18770;
var statearr_18791_18821 = state_18770__$1;
(statearr_18791_18821[(2)] = inst_18756);

(statearr_18791_18821[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (2))){
var state_18770__$1 = state_18770;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18770__$1,(4),in$);
} else {
if((state_val_18771 === (23))){
var inst_18764 = (state_18770[(2)]);
var state_18770__$1 = state_18770;
var statearr_18792_18822 = state_18770__$1;
(statearr_18792_18822[(2)] = inst_18764);

(statearr_18792_18822[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (19))){
var inst_18751 = (state_18770[(2)]);
var state_18770__$1 = state_18770;
var statearr_18793_18823 = state_18770__$1;
(statearr_18793_18823[(2)] = inst_18751);

(statearr_18793_18823[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (11))){
var inst_18722 = (state_18770[(8)]);
var inst_18736 = (state_18770[(7)]);
var inst_18736__$1 = cljs.core.seq(inst_18722);
var state_18770__$1 = (function (){var statearr_18794 = state_18770;
(statearr_18794[(7)] = inst_18736__$1);

return statearr_18794;
})();
if(inst_18736__$1){
var statearr_18795_18824 = state_18770__$1;
(statearr_18795_18824[(1)] = (14));

} else {
var statearr_18796_18825 = state_18770__$1;
(statearr_18796_18825[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (9))){
var inst_18758 = (state_18770[(2)]);
var inst_18759 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_18770__$1 = (function (){var statearr_18797 = state_18770;
(statearr_18797[(15)] = inst_18758);

return statearr_18797;
})();
if(cljs.core.truth_(inst_18759)){
var statearr_18798_18826 = state_18770__$1;
(statearr_18798_18826[(1)] = (21));

} else {
var statearr_18799_18827 = state_18770__$1;
(statearr_18799_18827[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (5))){
var inst_18714 = cljs.core.async.close_BANG_(out);
var state_18770__$1 = state_18770;
var statearr_18800_18828 = state_18770__$1;
(statearr_18800_18828[(2)] = inst_18714);

(statearr_18800_18828[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (14))){
var inst_18736 = (state_18770[(7)]);
var inst_18738 = cljs.core.chunked_seq_QMARK_(inst_18736);
var state_18770__$1 = state_18770;
if(inst_18738){
var statearr_18801_18829 = state_18770__$1;
(statearr_18801_18829[(1)] = (17));

} else {
var statearr_18802_18830 = state_18770__$1;
(statearr_18802_18830[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (16))){
var inst_18754 = (state_18770[(2)]);
var state_18770__$1 = state_18770;
var statearr_18803_18831 = state_18770__$1;
(statearr_18803_18831[(2)] = inst_18754);

(statearr_18803_18831[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18771 === (10))){
var inst_18723 = (state_18770[(9)]);
var inst_18725 = (state_18770[(12)]);
var inst_18730 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_18723,inst_18725);
var state_18770__$1 = state_18770;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18770__$1,(13),out,inst_18730);
} else {
if((state_val_18771 === (18))){
var inst_18736 = (state_18770[(7)]);
var inst_18745 = cljs.core.first(inst_18736);
var state_18770__$1 = state_18770;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18770__$1,(20),out,inst_18745);
} else {
if((state_val_18771 === (8))){
var inst_18724 = (state_18770[(11)]);
var inst_18725 = (state_18770[(12)]);
var inst_18727 = (inst_18725 < inst_18724);
var inst_18728 = inst_18727;
var state_18770__$1 = state_18770;
if(cljs.core.truth_(inst_18728)){
var statearr_18804_18832 = state_18770__$1;
(statearr_18804_18832[(1)] = (10));

} else {
var statearr_18805_18833 = state_18770__$1;
(statearr_18805_18833[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto__))
;
return ((function (switch__17043__auto__,c__17150__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__17044__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__17044__auto____0 = (function (){
var statearr_18806 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18806[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__17044__auto__);

(statearr_18806[(1)] = (1));

return statearr_18806;
});
var cljs$core$async$mapcat_STAR__$_state_machine__17044__auto____1 = (function (state_18770){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18770);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18807){if((e18807 instanceof Object)){
var ex__17047__auto__ = e18807;
var statearr_18808_18834 = state_18770;
(statearr_18808_18834[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18770);

return cljs.core.cst$kw$recur;
} else {
throw e18807;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18835 = state_18770;
state_18770 = G__18835;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__17044__auto__ = function(state_18770){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__17044__auto____1.call(this,state_18770);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__17044__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__17044__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto__))
})();
var state__17152__auto__ = (function (){var statearr_18809 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18809[(6)] = c__17150__auto__);

return statearr_18809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto__))
);

return c__17150__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__18837 = arguments.length;
switch (G__18837) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__18840 = arguments.length;
switch (G__18840) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__18843 = arguments.length;
switch (G__18843) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17150__auto___18890 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18890,out){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18890,out){
return (function (state_18867){
var state_val_18868 = (state_18867[(1)]);
if((state_val_18868 === (7))){
var inst_18862 = (state_18867[(2)]);
var state_18867__$1 = state_18867;
var statearr_18869_18891 = state_18867__$1;
(statearr_18869_18891[(2)] = inst_18862);

(statearr_18869_18891[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18868 === (1))){
var inst_18844 = null;
var state_18867__$1 = (function (){var statearr_18870 = state_18867;
(statearr_18870[(7)] = inst_18844);

return statearr_18870;
})();
var statearr_18871_18892 = state_18867__$1;
(statearr_18871_18892[(2)] = null);

(statearr_18871_18892[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18868 === (4))){
var inst_18847 = (state_18867[(8)]);
var inst_18847__$1 = (state_18867[(2)]);
var inst_18848 = (inst_18847__$1 == null);
var inst_18849 = cljs.core.not(inst_18848);
var state_18867__$1 = (function (){var statearr_18872 = state_18867;
(statearr_18872[(8)] = inst_18847__$1);

return statearr_18872;
})();
if(inst_18849){
var statearr_18873_18893 = state_18867__$1;
(statearr_18873_18893[(1)] = (5));

} else {
var statearr_18874_18894 = state_18867__$1;
(statearr_18874_18894[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18868 === (6))){
var state_18867__$1 = state_18867;
var statearr_18875_18895 = state_18867__$1;
(statearr_18875_18895[(2)] = null);

(statearr_18875_18895[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18868 === (3))){
var inst_18864 = (state_18867[(2)]);
var inst_18865 = cljs.core.async.close_BANG_(out);
var state_18867__$1 = (function (){var statearr_18876 = state_18867;
(statearr_18876[(9)] = inst_18864);

return statearr_18876;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_18867__$1,inst_18865);
} else {
if((state_val_18868 === (2))){
var state_18867__$1 = state_18867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18867__$1,(4),ch);
} else {
if((state_val_18868 === (11))){
var inst_18847 = (state_18867[(8)]);
var inst_18856 = (state_18867[(2)]);
var inst_18844 = inst_18847;
var state_18867__$1 = (function (){var statearr_18877 = state_18867;
(statearr_18877[(10)] = inst_18856);

(statearr_18877[(7)] = inst_18844);

return statearr_18877;
})();
var statearr_18878_18896 = state_18867__$1;
(statearr_18878_18896[(2)] = null);

(statearr_18878_18896[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18868 === (9))){
var inst_18847 = (state_18867[(8)]);
var state_18867__$1 = state_18867;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18867__$1,(11),out,inst_18847);
} else {
if((state_val_18868 === (5))){
var inst_18844 = (state_18867[(7)]);
var inst_18847 = (state_18867[(8)]);
var inst_18851 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18847,inst_18844);
var state_18867__$1 = state_18867;
if(inst_18851){
var statearr_18880_18897 = state_18867__$1;
(statearr_18880_18897[(1)] = (8));

} else {
var statearr_18881_18898 = state_18867__$1;
(statearr_18881_18898[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18868 === (10))){
var inst_18859 = (state_18867[(2)]);
var state_18867__$1 = state_18867;
var statearr_18882_18899 = state_18867__$1;
(statearr_18882_18899[(2)] = inst_18859);

(statearr_18882_18899[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18868 === (8))){
var inst_18844 = (state_18867[(7)]);
var tmp18879 = inst_18844;
var inst_18844__$1 = tmp18879;
var state_18867__$1 = (function (){var statearr_18883 = state_18867;
(statearr_18883[(7)] = inst_18844__$1);

return statearr_18883;
})();
var statearr_18884_18900 = state_18867__$1;
(statearr_18884_18900[(2)] = null);

(statearr_18884_18900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18890,out))
;
return ((function (switch__17043__auto__,c__17150__auto___18890,out){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_18885 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18885[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_18885[(1)] = (1));

return statearr_18885;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_18867){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18867);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18886){if((e18886 instanceof Object)){
var ex__17047__auto__ = e18886;
var statearr_18887_18901 = state_18867;
(statearr_18887_18901[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18867);

return cljs.core.cst$kw$recur;
} else {
throw e18886;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18902 = state_18867;
state_18867 = G__18902;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_18867){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_18867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18890,out))
})();
var state__17152__auto__ = (function (){var statearr_18888 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18888[(6)] = c__17150__auto___18890);

return statearr_18888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18890,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__18904 = arguments.length;
switch (G__18904) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17150__auto___18970 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___18970,out){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___18970,out){
return (function (state_18942){
var state_val_18943 = (state_18942[(1)]);
if((state_val_18943 === (7))){
var inst_18938 = (state_18942[(2)]);
var state_18942__$1 = state_18942;
var statearr_18944_18971 = state_18942__$1;
(statearr_18944_18971[(2)] = inst_18938);

(statearr_18944_18971[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (1))){
var inst_18905 = (new Array(n));
var inst_18906 = inst_18905;
var inst_18907 = (0);
var state_18942__$1 = (function (){var statearr_18945 = state_18942;
(statearr_18945[(7)] = inst_18906);

(statearr_18945[(8)] = inst_18907);

return statearr_18945;
})();
var statearr_18946_18972 = state_18942__$1;
(statearr_18946_18972[(2)] = null);

(statearr_18946_18972[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (4))){
var inst_18910 = (state_18942[(9)]);
var inst_18910__$1 = (state_18942[(2)]);
var inst_18911 = (inst_18910__$1 == null);
var inst_18912 = cljs.core.not(inst_18911);
var state_18942__$1 = (function (){var statearr_18947 = state_18942;
(statearr_18947[(9)] = inst_18910__$1);

return statearr_18947;
})();
if(inst_18912){
var statearr_18948_18973 = state_18942__$1;
(statearr_18948_18973[(1)] = (5));

} else {
var statearr_18949_18974 = state_18942__$1;
(statearr_18949_18974[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (15))){
var inst_18932 = (state_18942[(2)]);
var state_18942__$1 = state_18942;
var statearr_18950_18975 = state_18942__$1;
(statearr_18950_18975[(2)] = inst_18932);

(statearr_18950_18975[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (13))){
var state_18942__$1 = state_18942;
var statearr_18951_18976 = state_18942__$1;
(statearr_18951_18976[(2)] = null);

(statearr_18951_18976[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (6))){
var inst_18907 = (state_18942[(8)]);
var inst_18928 = (inst_18907 > (0));
var state_18942__$1 = state_18942;
if(cljs.core.truth_(inst_18928)){
var statearr_18952_18977 = state_18942__$1;
(statearr_18952_18977[(1)] = (12));

} else {
var statearr_18953_18978 = state_18942__$1;
(statearr_18953_18978[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (3))){
var inst_18940 = (state_18942[(2)]);
var state_18942__$1 = state_18942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18942__$1,inst_18940);
} else {
if((state_val_18943 === (12))){
var inst_18906 = (state_18942[(7)]);
var inst_18930 = cljs.core.vec(inst_18906);
var state_18942__$1 = state_18942;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18942__$1,(15),out,inst_18930);
} else {
if((state_val_18943 === (2))){
var state_18942__$1 = state_18942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18942__$1,(4),ch);
} else {
if((state_val_18943 === (11))){
var inst_18922 = (state_18942[(2)]);
var inst_18923 = (new Array(n));
var inst_18906 = inst_18923;
var inst_18907 = (0);
var state_18942__$1 = (function (){var statearr_18954 = state_18942;
(statearr_18954[(7)] = inst_18906);

(statearr_18954[(10)] = inst_18922);

(statearr_18954[(8)] = inst_18907);

return statearr_18954;
})();
var statearr_18955_18979 = state_18942__$1;
(statearr_18955_18979[(2)] = null);

(statearr_18955_18979[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (9))){
var inst_18906 = (state_18942[(7)]);
var inst_18920 = cljs.core.vec(inst_18906);
var state_18942__$1 = state_18942;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_18942__$1,(11),out,inst_18920);
} else {
if((state_val_18943 === (5))){
var inst_18915 = (state_18942[(11)]);
var inst_18906 = (state_18942[(7)]);
var inst_18910 = (state_18942[(9)]);
var inst_18907 = (state_18942[(8)]);
var inst_18914 = (inst_18906[inst_18907] = inst_18910);
var inst_18915__$1 = (inst_18907 + (1));
var inst_18916 = (inst_18915__$1 < n);
var state_18942__$1 = (function (){var statearr_18956 = state_18942;
(statearr_18956[(11)] = inst_18915__$1);

(statearr_18956[(12)] = inst_18914);

return statearr_18956;
})();
if(cljs.core.truth_(inst_18916)){
var statearr_18957_18980 = state_18942__$1;
(statearr_18957_18980[(1)] = (8));

} else {
var statearr_18958_18981 = state_18942__$1;
(statearr_18958_18981[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (14))){
var inst_18935 = (state_18942[(2)]);
var inst_18936 = cljs.core.async.close_BANG_(out);
var state_18942__$1 = (function (){var statearr_18960 = state_18942;
(statearr_18960[(13)] = inst_18935);

return statearr_18960;
})();
var statearr_18961_18982 = state_18942__$1;
(statearr_18961_18982[(2)] = inst_18936);

(statearr_18961_18982[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (10))){
var inst_18926 = (state_18942[(2)]);
var state_18942__$1 = state_18942;
var statearr_18962_18983 = state_18942__$1;
(statearr_18962_18983[(2)] = inst_18926);

(statearr_18962_18983[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_18943 === (8))){
var inst_18915 = (state_18942[(11)]);
var inst_18906 = (state_18942[(7)]);
var tmp18959 = inst_18906;
var inst_18906__$1 = tmp18959;
var inst_18907 = inst_18915;
var state_18942__$1 = (function (){var statearr_18963 = state_18942;
(statearr_18963[(7)] = inst_18906__$1);

(statearr_18963[(8)] = inst_18907);

return statearr_18963;
})();
var statearr_18964_18984 = state_18942__$1;
(statearr_18964_18984[(2)] = null);

(statearr_18964_18984[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___18970,out))
;
return ((function (switch__17043__auto__,c__17150__auto___18970,out){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_18965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18965[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_18965[(1)] = (1));

return statearr_18965;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_18942){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_18942);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e18966){if((e18966 instanceof Object)){
var ex__17047__auto__ = e18966;
var statearr_18967_18985 = state_18942;
(statearr_18967_18985[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_18942);

return cljs.core.cst$kw$recur;
} else {
throw e18966;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__18986 = state_18942;
state_18942 = G__18986;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_18942){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_18942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___18970,out))
})();
var state__17152__auto__ = (function (){var statearr_18968 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_18968[(6)] = c__17150__auto___18970);

return statearr_18968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___18970,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__18988 = arguments.length;
switch (G__18988) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__17150__auto___19058 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__17150__auto___19058,out){
return (function (){
var f__17151__auto__ = (function (){var switch__17043__auto__ = ((function (c__17150__auto___19058,out){
return (function (state_19030){
var state_val_19031 = (state_19030[(1)]);
if((state_val_19031 === (7))){
var inst_19026 = (state_19030[(2)]);
var state_19030__$1 = state_19030;
var statearr_19032_19059 = state_19030__$1;
(statearr_19032_19059[(2)] = inst_19026);

(statearr_19032_19059[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (1))){
var inst_18989 = [];
var inst_18990 = inst_18989;
var inst_18991 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_19030__$1 = (function (){var statearr_19033 = state_19030;
(statearr_19033[(7)] = inst_18990);

(statearr_19033[(8)] = inst_18991);

return statearr_19033;
})();
var statearr_19034_19060 = state_19030__$1;
(statearr_19034_19060[(2)] = null);

(statearr_19034_19060[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (4))){
var inst_18994 = (state_19030[(9)]);
var inst_18994__$1 = (state_19030[(2)]);
var inst_18995 = (inst_18994__$1 == null);
var inst_18996 = cljs.core.not(inst_18995);
var state_19030__$1 = (function (){var statearr_19035 = state_19030;
(statearr_19035[(9)] = inst_18994__$1);

return statearr_19035;
})();
if(inst_18996){
var statearr_19036_19061 = state_19030__$1;
(statearr_19036_19061[(1)] = (5));

} else {
var statearr_19037_19062 = state_19030__$1;
(statearr_19037_19062[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (15))){
var inst_19020 = (state_19030[(2)]);
var state_19030__$1 = state_19030;
var statearr_19038_19063 = state_19030__$1;
(statearr_19038_19063[(2)] = inst_19020);

(statearr_19038_19063[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (13))){
var state_19030__$1 = state_19030;
var statearr_19039_19064 = state_19030__$1;
(statearr_19039_19064[(2)] = null);

(statearr_19039_19064[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (6))){
var inst_18990 = (state_19030[(7)]);
var inst_19015 = inst_18990.length;
var inst_19016 = (inst_19015 > (0));
var state_19030__$1 = state_19030;
if(cljs.core.truth_(inst_19016)){
var statearr_19040_19065 = state_19030__$1;
(statearr_19040_19065[(1)] = (12));

} else {
var statearr_19041_19066 = state_19030__$1;
(statearr_19041_19066[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (3))){
var inst_19028 = (state_19030[(2)]);
var state_19030__$1 = state_19030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19030__$1,inst_19028);
} else {
if((state_val_19031 === (12))){
var inst_18990 = (state_19030[(7)]);
var inst_19018 = cljs.core.vec(inst_18990);
var state_19030__$1 = state_19030;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19030__$1,(15),out,inst_19018);
} else {
if((state_val_19031 === (2))){
var state_19030__$1 = state_19030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19030__$1,(4),ch);
} else {
if((state_val_19031 === (11))){
var inst_18998 = (state_19030[(10)]);
var inst_18994 = (state_19030[(9)]);
var inst_19008 = (state_19030[(2)]);
var inst_19009 = [];
var inst_19010 = inst_19009.push(inst_18994);
var inst_18990 = inst_19009;
var inst_18991 = inst_18998;
var state_19030__$1 = (function (){var statearr_19042 = state_19030;
(statearr_19042[(7)] = inst_18990);

(statearr_19042[(11)] = inst_19008);

(statearr_19042[(8)] = inst_18991);

(statearr_19042[(12)] = inst_19010);

return statearr_19042;
})();
var statearr_19043_19067 = state_19030__$1;
(statearr_19043_19067[(2)] = null);

(statearr_19043_19067[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (9))){
var inst_18990 = (state_19030[(7)]);
var inst_19006 = cljs.core.vec(inst_18990);
var state_19030__$1 = state_19030;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_19030__$1,(11),out,inst_19006);
} else {
if((state_val_19031 === (5))){
var inst_18991 = (state_19030[(8)]);
var inst_18998 = (state_19030[(10)]);
var inst_18994 = (state_19030[(9)]);
var inst_18998__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_18994) : f.call(null,inst_18994));
var inst_18999 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_18998__$1,inst_18991);
var inst_19000 = cljs.core.keyword_identical_QMARK_(inst_18991,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_19001 = ((inst_18999) || (inst_19000));
var state_19030__$1 = (function (){var statearr_19044 = state_19030;
(statearr_19044[(10)] = inst_18998__$1);

return statearr_19044;
})();
if(cljs.core.truth_(inst_19001)){
var statearr_19045_19068 = state_19030__$1;
(statearr_19045_19068[(1)] = (8));

} else {
var statearr_19046_19069 = state_19030__$1;
(statearr_19046_19069[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (14))){
var inst_19023 = (state_19030[(2)]);
var inst_19024 = cljs.core.async.close_BANG_(out);
var state_19030__$1 = (function (){var statearr_19048 = state_19030;
(statearr_19048[(13)] = inst_19023);

return statearr_19048;
})();
var statearr_19049_19070 = state_19030__$1;
(statearr_19049_19070[(2)] = inst_19024);

(statearr_19049_19070[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (10))){
var inst_19013 = (state_19030[(2)]);
var state_19030__$1 = state_19030;
var statearr_19050_19071 = state_19030__$1;
(statearr_19050_19071[(2)] = inst_19013);

(statearr_19050_19071[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_19031 === (8))){
var inst_18990 = (state_19030[(7)]);
var inst_18998 = (state_19030[(10)]);
var inst_18994 = (state_19030[(9)]);
var inst_19003 = inst_18990.push(inst_18994);
var tmp19047 = inst_18990;
var inst_18990__$1 = tmp19047;
var inst_18991 = inst_18998;
var state_19030__$1 = (function (){var statearr_19051 = state_19030;
(statearr_19051[(14)] = inst_19003);

(statearr_19051[(7)] = inst_18990__$1);

(statearr_19051[(8)] = inst_18991);

return statearr_19051;
})();
var statearr_19052_19072 = state_19030__$1;
(statearr_19052_19072[(2)] = null);

(statearr_19052_19072[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__17150__auto___19058,out))
;
return ((function (switch__17043__auto__,c__17150__auto___19058,out){
return (function() {
var cljs$core$async$state_machine__17044__auto__ = null;
var cljs$core$async$state_machine__17044__auto____0 = (function (){
var statearr_19053 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19053[(0)] = cljs$core$async$state_machine__17044__auto__);

(statearr_19053[(1)] = (1));

return statearr_19053;
});
var cljs$core$async$state_machine__17044__auto____1 = (function (state_19030){
while(true){
var ret_value__17045__auto__ = (function (){try{while(true){
var result__17046__auto__ = switch__17043__auto__(state_19030);
if(cljs.core.keyword_identical_QMARK_(result__17046__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__17046__auto__;
}
break;
}
}catch (e19054){if((e19054 instanceof Object)){
var ex__17047__auto__ = e19054;
var statearr_19055_19073 = state_19030;
(statearr_19055_19073[(5)] = ex__17047__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_19030);

return cljs.core.cst$kw$recur;
} else {
throw e19054;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__17045__auto__,cljs.core.cst$kw$recur)){
var G__19074 = state_19030;
state_19030 = G__19074;
continue;
} else {
return ret_value__17045__auto__;
}
break;
}
});
cljs$core$async$state_machine__17044__auto__ = function(state_19030){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__17044__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__17044__auto____1.call(this,state_19030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__17044__auto____0;
cljs$core$async$state_machine__17044__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__17044__auto____1;
return cljs$core$async$state_machine__17044__auto__;
})()
;})(switch__17043__auto__,c__17150__auto___19058,out))
})();
var state__17152__auto__ = (function (){var statearr_19056 = (f__17151__auto__.cljs$core$IFn$_invoke$arity$0 ? f__17151__auto__.cljs$core$IFn$_invoke$arity$0() : f__17151__auto__.call(null));
(statearr_19056[(6)] = c__17150__auto___19058);

return statearr_19056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__17152__auto__);
});})(c__17150__auto___19058,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

