(ns org-analyzer.view.scratch
  (:require [cljs.pprint :refer [pprint]]
            [clojure.string :refer [split]]))

(comment

  (def clocks  (-> @org-analyzer.view.main/app-state :clocks-by-day (get "2019-08-19")))

  (pprint (->> clocks (map (juxt :duration (comp parse-duration :duration) (juxt :start :end)))))

  (defn parse-duration [duration]
    (let [[hours mins] (map #(js/Number. %) (split duration ":"))
          result (+ (* 60 hours) mins)]
      (if (js/isNaN result) 0 result)))

  (quot (org-analyzer.view.util/sum-clocks-mins clocks) 60)

  (["2:42" ["2019-08-19 00:00" "2019-08-19 02:42"]]
   ["2:42" ["2019-08-19 00:00" "2019-08-19 02:42"]]
   ["0:25" ["2019-08-19 02:50" "2019-08-19 03:15"]]
   ["0:25" ["2019-08-19 02:50" "2019-08-19 03:15"]]
   ["3:43" ["2019-08-19 03:38" "2019-08-19 07:21"]]
   ["3:43" ["2019-08-19 03:38" "2019-08-19 07:21"]]
   ["0:49" ["2019-08-19 15:18" "2019-08-19 16:07"]]
   ["0:49" ["2019-08-19 15:18" "2019-08-19 16:07"]]
   ["0:18" ["2019-08-19 16:17" "2019-08-19 16:35"]]
   ["0:18" ["2019-08-19 16:17" "2019-08-19 16:35"]]
   ["1:30" ["2019-08-19 16:43" "2019-08-19 18:13"]]
   ["1:30" ["2019-08-19 16:43" "2019-08-19 18:13"]]
   ["0:50" ["2019-08-19 18:35" "2019-08-19 19:25"]]
   ["0:50" ["2019-08-19 18:35" "2019-08-19 19:25"]]
   ["0:57" ["2019-08-19 19:36" "2019-08-19 20:33"]]
   ["0:57" ["2019-08-19 19:36" "2019-08-19 20:33"]]
   ["0:37" ["2019-08-19 23:23" "2019-08-20 00:00"]]
   ["0:37" ["2019-08-19 23:23" "2019-08-20 00:00"]]))

;; (sc.api/last-ep-id)

;; (sc.api/defsc [3 -6])

;; [3 -6]


;; calendar
;; (+ 1 2)
;; (. js/console)

;; (js/cognitect.transit)

;; (-> js/document .)

