(ns org-analyzer.view.collapsible)

(defmacro collapsible
  ""
  [title key collapsed-atom & body]
  `(collapsible* ~title ~key ~collapsed-atom (fn [] ~@body)))


(defn collapsible* [title key collapsed-atom comp-fn]
  (let [collapsed? @collapsed-atom]
    [:div.panel.elev-2
     [:button.material-button
      {:on-click #(reset! collapsed-atom (not collapsed?))}
      title
      [:i.material-icons (if collapsed? "expand_less" "expand_more")]]
     (when-not collapsed?
       (comp-fn))]))
