;;; nael-abbrev.el --- Abbrev for Nael  -*- lexical-binding: t; -*-

;; Copyright © 2025 Mekeor Melire

;; SPDX-License-Identifier: GPL-3.0-only

;; This is licensed under GNU General Public License (version 3 only),
;; see LICENSE.GPL3.

;;; Commentary:

;; This file has been generated by `build.el' by relying on data from
;; the official Lean plugin for another editor.  Please do not edit
;; this file directly; edit `build.el' instead!

;; This file defines Abbrev tables for conveniently inserting Unicode
;; characters that are common in Lean code.  For more information on
;; Emacs' Abbrev feature, consult the docstrings of `abbrev-mode' and
;; `local-abbrev-table' and the corresponding Info manual:
;;
;;   (info "(emacs) Abbrevs")

;; The abbreviations introduced here can be classified into two
;; disjunct sets:
;;
;;   1. /Singleton/ abbreviations expand to single strings.  During
;;      expansion, point is reserved at the end of expansion.
;;
;;   2. /Skeleton/ abbreviations expand to two strings with point
;;      being placed between the left and the right part.  The name is
;;      derived from `skeleton', a built-in Emacs package used to
;;      implement this class of abbreviations.
;;
;; As a consequence, this file defines three Abbrev tables.
;; `nael-abbrev-singleton-table' and `nael-abbrev-skeleton-table' have
;; self-explaining names.  The recommended Abbrev table for
;; `nael-mode' is `nael-abbrev-table' which inherits elements from
;; both aforementioned Abbrev tables.

;; One crucial challenge in the development of this file was that
;; `abbrev-mode' was originally designed for abbreviations that
;; exclusively consist of word-constituent characters.  Whereas in
;; Lean, we desire abbreviations like \f<<>>.  One measure we need to
;; take for this requirement is to specify `:regexp' properties for
;; our Abbrev tables; see (info "(elisp) Abbrev Table Properties").
;; This already works fine when calling `expand-abbrev' explicitly.
;; But at the time of writing (August 2025), `self-insert-command'
;; rules out automatic expansion of abbreviations that end in
;; non-word-constituent characters.  As a workaround, you can call
;; function `nael-abbrev-configure'.  It will add `nael-abbrev-expand'
;; to the `post-self-insert-hook' which considers expansion for a
;; suitably wider range of characters.

;;; Code:

(require 'abbrev)
(require 'cl-lib)

(require 'nael-skeleton)

(defgroup nael-abbrev nil
  "`abbrev-mode' configured for `nael-mode'."
  :group 'nael
  :group 'abbrev-mode
  :link '(emacs-library-link :tag "Source Lisp File" "nael-abbrev.el")
  :prefix "nael-abbrev-")

(defconst nael-abbrev-regexp "\\(\\\\[ -#&-+.-:<-?A-~-]+\\)")

(define-abbrev-table 'nael-abbrev-singleton-table
  '(("\\\\" "\\" nil :system t)
    ("\\a" "α" nil :system t)
    ("\\b" "β" nil :system t)
    ("\\c" "χ" nil :system t)
    ("\\d" "↓" nil :system t)
    ("\\e" "ε" nil :system t)
    ("\\g" "γ" nil :system t)
    ("\\i" "∩" nil :system t)
    ("\\m" "μ" nil :system t)
    ("\\n" "\\n" nil :system t)
    ("\\o" "∘" nil :system t)
    ("\\p" "Π" nil :system t)
    ("\\t" "▸" nil :system t)
    ("\\r" "→" nil :system t)
    ("\\u" "↑" nil :system t)
    ("\\v" "∨" nil :system t)
    ("\\x" "×" nil :system t)
    ("\\-" "⁻¹" nil :system t)
    ("\\~" "∼" nil :system t)
    ("\\." "·" nil :system t)
    ("\\*" "⋆" nil :system t)
    ("\\!" "¬" nil :system t)
    ("\\?" "¿" nil :system t)
    ("\\1" "₁" nil :system t)
    ("\\2" "₂" nil :system t)
    ("\\3" "₃" nil :system t)
    ("\\4" "₄" nil :system t)
    ("\\5" "₅" nil :system t)
    ("\\6" "₆" nil :system t)
    ("\\7" "₇" nil :system t)
    ("\\8" "₈" nil :system t)
    ("\\9" "₉" nil :system t)
    ("\\0" "₀" nil :system t)
    ("\\l" "←" nil :system t)
    ("\\<" "⟨" nil :system t)
    ("\\>" "⟩" nil :system t)
    ("\\O" "Ø" nil :system t)
    ("\\&" "⅋" nil :system t)
    ("\\A" "𝔸" nil :system t)
    ("\\C" "ℂ" nil :system t)
    ("\\D" "Δ" nil :system t)
    ("\\F" "𝔽" nil :system t)
    ("\\G" "Γ" nil :system t)
    ("\\H" "ℍ" nil :system t)
    ("\\I" "⋂" nil :system t)
    ("\\I0" "⋂₀" nil :system t)
    ("\\K" "𝕂" nil :system t)
    ("\\L" "Λ" nil :system t)
    ("\\N" "ℕ" nil :system t)
    ("\\P" "Π" nil :system t)
    ("\\Q" "ℚ" nil :system t)
    ("\\R" "ℝ" nil :system t)
    ("\\S" "Σ" nil :system t)
    ("\\U" "⋃" nil :system t)
    ("\\U0" "⋃₀" nil :system t)
    ("\\Z" "ℤ" nil :system t)
    ("\\#" "♯" nil :system t)
    ("\\:" "∶" nil :system t)
    ("\\|" "∣" nil :system t)
    ("\\rw" "▸" nil :system t)
    ("\\coe" "↑" nil :system t)
    ("\\be" "β" nil :system t)
    ("\\ga" "γ" nil :system t)
    ("\\de" "δ" nil :system t)
    ("\\ep" "ε" nil :system t)
    ("\\ze" "ζ" nil :system t)
    ("\\et" "η" nil :system t)
    ("\\th" "θ" nil :system t)
    ("\\io" "ι" nil :system t)
    ("\\ka" "κ" nil :system t)
    ("\\la" "λ" nil :system t)
    ("\\mu" "μ" nil :system t)
    ("\\nu" "ν" nil :system t)
    ("\\xi" "ξ" nil :system t)
    ("\\pi" "π" nil :system t)
    ("\\rh" "ρ" nil :system t)
    ("\\vsi" "ς" nil :system t)
    ("\\si" "σ" nil :system t)
    ("\\ta" "τ" nil :system t)
    ("\\ph" "φ" nil :system t)
    ("\\ch" "χ" nil :system t)
    ("\\ps" "ψ" nil :system t)
    ("\\om" "ω" nil :system t)
    ("\\`A" "À" nil :system t)
    ("\\'A" "Á" nil :system t)
    ("\\^{A}" "Â" nil :system t)
    ("\\~A" "Ã" nil :system t)
    ("\\\"A" "Ä" nil :system t)
    ("\\-{A}" "Ā" nil :system t)
    ("\\cC" "Ç" nil :system t)
    ("\\`E" "È" nil :system t)
    ("\\'E" "É" nil :system t)
    ("\\^{E}" "Ê" nil :system t)
    ("\\\"E" "Ë" nil :system t)
    ("\\-{E}" "Ē" nil :system t)
    ("\\`I" "Ì" nil :system t)
    ("\\'I" "Í" nil :system t)
    ("\\^{I}" "Î" nil :system t)
    ("\\\"I" "Ï" nil :system t)
    ("\\-{I}" "Ī" nil :system t)
    ("\\~N" "Ñ" nil :system t)
    ("\\`O" "Ò" nil :system t)
    ("\\'O" "Ó" nil :system t)
    ("\\^{O}" "Ô" nil :system t)
    ("\\~O" "Õ" nil :system t)
    ("\\\"O" "Ö" nil :system t)
    ("\\/O" "Ø" nil :system t)
    ("\\-{O}" "Ō" nil :system t)
    ("\\`U" "Ù" nil :system t)
    ("\\'U" "Ú" nil :system t)
    ("\\^{U}" "Û" nil :system t)
    ("\\\"U" "Ü" nil :system t)
    ("\\-{U}" "Ū" nil :system t)
    ("\\'Y" "Ý" nil :system t)
    ("\\`a" "à" nil :system t)
    ("\\'a" "á" nil :system t)
    ("\\^{a}" "â" nil :system t)
    ("\\~a" "ã" nil :system t)
    ("\\\"a" "ä" nil :system t)
    ("\\-{a}" "ā" nil :system t)
    ("\\cc" "ç" nil :system t)
    ("\\`e" "è" nil :system t)
    ("\\'e" "é" nil :system t)
    ("\\^{e}" "ê" nil :system t)
    ("\\\"e" "ë" nil :system t)
    ("\\-{e}" "ē" nil :system t)
    ("\\`i" "ì" nil :system t)
    ("\\'i" "í" nil :system t)
    ("\\^{i}" "î" nil :system t)
    ("\\\"i" "ï" nil :system t)
    ("\\-{i}" "ī" nil :system t)
    ("\\~{n}" "ñ" nil :system t)
    ("\\`o" "ò" nil :system t)
    ("\\'o" "ó" nil :system t)
    ("\\^{o}" "ô" nil :system t)
    ("\\~o" "õ" nil :system t)
    ("\\\"o" "ö" nil :system t)
    ("\\/o" "ø" nil :system t)
    ("\\-{o}" "ō" nil :system t)
    ("\\`u" "ù" nil :system t)
    ("\\'u" "ú" nil :system t)
    ("\\^{u}" "û" nil :system t)
    ("\\\"u" "ü" nil :system t)
    ("\\-{u}" "ū" nil :system t)
    ("\\'y" "ý" nil :system t)
    ("\\\"y" "ÿ" nil :system t)
    ("\\/L" "Ł" nil :system t)
    ("\\notin" "∉" nil :system t)
    ("\\note" "♩" nil :system t)
    ("\\not" "¬" nil :system t)
    ("\\nomisma" "𐆎" nil :system t)
    ("\\nin" "∉" nil :system t)
    ("\\nni" "∌" nil :system t)
    ("\\ni" "∋" nil :system t)
    ("\\nattrans" "⟹" nil :system t)
    ("\\nat_trans" "⟹" nil :system t)
    ("\\natural" "♮" nil :system t)
    ("\\nat" "ℕ" nil :system t)
    ("\\naira" "₦" nil :system t)
    ("\\nabla" "∇" nil :system t)
    ("\\napprox" "≉" nil :system t)
    ("\\numero" "№" nil :system t)
    ("\\nLeftarrow" "⇍" nil :system t)
    ("\\nLeftrightarrow" "⇎" nil :system t)
    ("\\nRightarrow" "⇏" nil :system t)
    ("\\nVDash" "⊯" nil :system t)
    ("\\nVdash" "⊮" nil :system t)
    ("\\ncong" "≇" nil :system t)
    ("\\nearrow" "↗" nil :system t)
    ("\\neg" "¬" nil :system t)
    ("\\nequiv" "≢" nil :system t)
    ("\\neq" "≠" nil :system t)
    ("\\nexists" "∄" nil :system t)
    ("\\ne" "≠" nil :system t)
    ("\\ngeqq" "≱" nil :system t)
    ("\\ngeqslant" "≱" nil :system t)
    ("\\ngeq" "≱" nil :system t)
    ("\\ngtr" "≯" nil :system t)
    ("\\nleftarrow" "↚" nil :system t)
    ("\\nleftrightarrow" "↮" nil :system t)
    ("\\nleqq" "≰" nil :system t)
    ("\\nleqslant" "≰" nil :system t)
    ("\\nleq" "≰" nil :system t)
    ("\\nless" "≮" nil :system t)
    ("\\nmid" "∤" nil :system t)
    ("\\nparallel" "∦" nil :system t)
    ("\\npreceq" "⋠" nil :system t)
    ("\\nprec" "⊀" nil :system t)
    ("\\nrightarrow" "↛" nil :system t)
    ("\\nshortmid" "∤" nil :system t)
    ("\\nsimeq" "≄" nil :system t)
    ("\\nsim" "≁" nil :system t)
    ("\\nsubseteqq" "⊈" nil :system t)
    ("\\nsubseteq" "⊈" nil :system t)
    ("\\nsubset" "⊄" nil :system t)
    ("\\nsucceq" "⋡" nil :system t)
    ("\\nsucc" "⊁" nil :system t)
    ("\\nsupseteqq" "⊉" nil :system t)
    ("\\nsupseteq" "⊉" nil :system t)
    ("\\nsupset" "⊅" nil :system t)
    ("\\ntrianglelefteq" "⋬" nil :system t)
    ("\\ntriangleleft" "⋪" nil :system t)
    ("\\ntrianglerighteq" "⋭" nil :system t)
    ("\\ntriangleright" "⋫" nil :system t)
    ("\\nvDash" "⊭" nil :system t)
    ("\\nvdash" "⊬" nil :system t)
    ("\\nwarrow" "↖" nil :system t)
    ("\\eqn" "≠" nil :system t)
    ("\\equiv" "≃" nil :system t)
    ("\\eqcirc" "≖" nil :system t)
    ("\\eqcolon" "≕" nil :system t)
    ("\\eqslantgtr" "⋝" nil :system t)
    ("\\eqslantless" "⋜" nil :system t)
    ("\\entails" "⊢" nil :system t)
    ("\\en" "–" nil :system t)
    ("\\exn" "∄" nil :system t)
    ("\\exists" "∃" nil :system t)
    ("\\ex" "∃" nil :system t)
    ("\\emptyset" "∅" nil :system t)
    ("\\empty" "∅" nil :system t)
    ("\\em" "—" nil :system t)
    ("\\epsilon" "ε" nil :system t)
    ("\\eps" "ε" nil :system t)
    ("\\euro" "€" nil :system t)
    ("\\eta" "η" nil :system t)
    ("\\ell" "ℓ" nil :system t)
    ("\\iso" "≅" nil :system t)
    ("\\in" "∈" nil :system t)
    ("\\inn" "∉" nil :system t)
    ("\\inter" "∩" nil :system t)
    ("\\intercal" "⊺" nil :system t)
    ("\\intersection" "∩" nil :system t)
    ("\\integral" "∫" nil :system t)
    ("\\integral-" "⨍" nil :system t)
    ("\\int" "ℤ" nil :system t)
    ("\\inv" "⁻¹" nil :system t)
    ("\\increment" "∆" nil :system t)
    ("\\inf" "⊓" nil :system t)
    ("\\infi" "⨅" nil :system t)
    ("\\infty" "∞" nil :system t)
    ("\\iff" "↔" nil :system t)
    ("\\imp" "→" nil :system t)
    ("\\imath" "ı" nil :system t)
    ("\\iota" "ι" nil :system t)
    ("\\=n" "≠" nil :system t)
    ("\\==n" "≢" nil :system t)
    ("\\===" "≣" nil :system t)
    ("\\==>" "⟹" nil :system t)
    ("\\==" "≡" nil :system t)
    ("\\=:" "≕" nil :system t)
    ("\\=o" "≗" nil :system t)
    ("\\=>n" "⇏" nil :system t)
    ("\\=>" "⇒" nil :system t)
    ("\\~n" "≁" nil :system t)
    ("\\~~n" "≉" nil :system t)
    ("\\~~~" "≋" nil :system t)
    ("\\~~-" "≊" nil :system t)
    ("\\~~" "≈" nil :system t)
    ("\\~-n" "≄" nil :system t)
    ("\\~-" "≃" nil :system t)
    ("\\~=n" "≇" nil :system t)
    ("\\~=" "≅" nil :system t)
    ("\\homotopy" "∼" nil :system t)
    ("\\hom" "⟶" nil :system t)
    ("\\hori" "ϩ" nil :system t)
    ("\\hookleftarrow" "↩" nil :system t)
    ("\\hookrightarrow" "↪" nil :system t)
    ("\\hryvnia" "₴" nil :system t)
    ("\\heta" "ͱ" nil :system t)
    ("\\heartsuit" "♥" nil :system t)
    ("\\hbar" "ℏ" nil :system t)
    ("\\:~" "∻" nil :system t)
    ("\\:=" "≔" nil :system t)
    ("\\::-" "∺" nil :system t)
    ("\\::" "∷" nil :system t)
    ("\\-~" "≂" nil :system t)
    ("\\-|" "⊣" nil :system t)
    ("\\-1" "⁻¹" nil :system t)
    ("\\^-1" "⁻¹" nil :system t)
    ("\\-2" "⁻²" nil :system t)
    ("\\-3" "⁻³" nil :system t)
    ("\\-:" "∹" nil :system t)
    ("\\->n" "↛" nil :system t)
    ("\\->" "→" nil :system t)
    ("\\-->" "⟶" nil :system t)
    ("\\---" "─" nil :system t)
    ("\\--=" "═" nil :system t)
    ("\\--_" "━" nil :system t)
    ("\\--." "╌" nil :system t)
    ("\\-o" "⊸" nil :system t)
    ("\\.=." "≑" nil :system t)
    ("\\.=" "≐" nil :system t)
    ("\\.+" "∔" nil :system t)
    ("\\.-" "∸" nil :system t)
    ("\\..." "⋯" nil :system t)
    ("\\(=" "≘" nil :system t)
    ("\\(b" "⟅" nil :system t)
    ("\\and=" "≙" nil :system t)
    ("\\and" "∧" nil :system t)
    ("\\an" "∧" nil :system t)
    ("\\angle" "∠" nil :system t)
    ("\\rightangle" "∟" nil :system t)
    ("\\angstrom" "Å" nil :system t)
    ("\\all" "∀" nil :system t)
    ("\\allf" "∀ᶠ" nil :system t)
    ("\\all^f" "∀ᶠ" nil :system t)
    ("\\allm" "∀ᵐ" nil :system t)
    ("\\all^m" "∀ᵐ" nil :system t)
    ("\\alpha" "α" nil :system t)
    ("\\aleph" "ℵ" nil :system t)
    ("\\aleph0" "ℵ₀" nil :system t)
    ("\\asterisk" "⁎" nil :system t)
    ("\\ast" "∗" nil :system t)
    ("\\asymp" "≍" nil :system t)
    ("\\apl" "⌶" nil :system t)
    ("\\approxeq" "≊" nil :system t)
    ("\\approx" "≈" nil :system t)
    ("\\aa" "å" nil :system t)
    ("\\ae" "æ" nil :system t)
    ("\\austral" "₳" nil :system t)
    ("\\afghani" "؋" nil :system t)
    ("\\amalg" "∐" nil :system t)
    ("\\average" "⨍" nil :system t)
    ("\\-int" "⨍" nil :system t)
    ("\\or=" "≚" nil :system t)
    ("\\ordfeminine" "ª" nil :system t)
    ("\\ordmasculine" "º" nil :system t)
    ("\\or" "∨" nil :system t)
    ("\\oplus" "⊕" nil :system t)
    ("\\od" "ᵒᵈ" nil :system t)
    ("\\orderdual" "ᵒᵈ" nil :system t)
    ("\\addopposite" "ᵃᵒᵖ" nil :system t)
    ("\\aop" "ᵃᵒᵖ" nil :system t)
    ("\\mulopposite" "ᵐᵒᵖ" nil :system t)
    ("\\mop" "ᵐᵒᵖ" nil :system t)
    ("\\opposite" "ᵒᵖ" nil :system t)
    ("\\op" "ᵒᵖ" nil :system t)
    ("\\o+" "⊕" nil :system t)
    ("\\o--" "⊖" nil :system t)
    ("\\o-" "⊝" nil :system t)
    ("\\ox" "⊗" nil :system t)
    ("\\o/" "⊘" nil :system t)
    ("\\o." "⊙" nil :system t)
    ("\\oo" "⊚" nil :system t)
    ("\\o*" "∘*" nil :system t)
    ("\\o=" "⊜" nil :system t)
    ("\\oe" "œ" nil :system t)
    ("\\octagonal" "🛑" nil :system t)
    ("\\ohm" "Ω" nil :system t)
    ("\\ounce" "℥" nil :system t)
    ("\\omega" "ω" nil :system t)
    ("\\omicron" "ο" nil :system t)
    ("\\ominus" "⊖" nil :system t)
    ("\\odot" "⊙" nil :system t)
    ("\\oint" "∮" nil :system t)
    ("\\oiint" "∯" nil :system t)
    ("\\oslash" "⊘" nil :system t)
    ("\\otimes" "⊗" nil :system t)
    ("\\tensorproduct" "⊗" nil :system t)
    ("\\pitensorproduct" "⨂" nil :system t)
    ("\\tensorpower" "⨂" nil :system t)
    ("\\pd" "∂" nil :system t)
    ("\\*=" "≛" nil :system t)
    ("\\t=" "≜" nil :system t)
    ("\\tint" "∯" nil :system t)
    ("\\transport" "▹" nil :system t)
    ("\\trans" "▹" nil :system t)
    ("\\triangledown" "▿" nil :system t)
    ("\\trianglelefteq" "⊴" nil :system t)
    ("\\triangleleft" "◃" nil :system t)
    ("\\triangleq" "≜" nil :system t)
    ("\\trianglerighteq" "⊵" nil :system t)
    ("\\triangleright" "▹" nil :system t)
    ("\\triangle" "▵" nil :system t)
    ("\\tr" "⬝" nil :system t)
    ("\\tb" "◂" nil :system t)
    ("\\twoheadleftarrow" "↞" nil :system t)
    ("\\twoheadrightarrow" "↠" nil :system t)
    ("\\tw" "◃" nil :system t)
    ("\\tie" "⁀" nil :system t)
    ("\\times" "×" nil :system t)
    ("\\theta" "θ" nil :system t)
    ("\\therefore" "∴" nil :system t)
    ("\\thickapprox" "≈" nil :system t)
    ("\\thicksim" "∼" nil :system t)
    ("\\telephone" "℡" nil :system t)
    ("\\tenge" "₸" nil :system t)
    ("\\textmusicalnote" "♪" nil :system t)
    ("\\textmu" "µ" nil :system t)
    ("\\textfractionsolidus" "⁄" nil :system t)
    ("\\textbaht" "฿" nil :system t)
    ("\\textdied" "✝" nil :system t)
    ("\\textdiscount" "⁒" nil :system t)
    ("\\textcolonmonetary" "₡" nil :system t)
    ("\\textcircledP" "℗" nil :system t)
    ("\\textwon" "₩" nil :system t)
    ("\\textnaira" "₦" nil :system t)
    ("\\textnumero" "№" nil :system t)
    ("\\textpeso" "₱" nil :system t)
    ("\\textpertenthousand" "‱" nil :system t)
    ("\\textlira" "₤" nil :system t)
    ("\\textlquill" "⁅" nil :system t)
    ("\\textrecipe" "℞" nil :system t)
    ("\\textreferencemark" "※" nil :system t)
    ("\\textrquill" "⁆" nil :system t)
    ("\\textinterrobang" "‽" nil :system t)
    ("\\textestimated" "℮" nil :system t)
    ("\\textopenbullet" "◦" nil :system t)
    ("\\tugrik" "₮" nil :system t)
    ("\\tau" "τ" nil :system t)
    ("\\top" "⊤" nil :system t)
    ("\\to" "→" nil :system t)
    ("\\to0" "→₀" nil :system t)
    ("\\r0" "→₀" nil :system t)
    ("\\to_0" "→₀" nil :system t)
    ("\\r_0" "→₀" nil :system t)
    ("\\finsupp" "→₀" nil :system t)
    ("\\to1" "→₁" nil :system t)
    ("\\r1" "→₁" nil :system t)
    ("\\to_1" "→₁" nil :system t)
    ("\\r_1" "→₁" nil :system t)
    ("\\l1" "→₁" nil :system t)
    ("\\to1s" "→₁ₛ" nil :system t)
    ("\\r1s" "→₁ₛ" nil :system t)
    ("\\to_1s" "→₁ₛ" nil :system t)
    ("\\r_1s" "→₁ₛ" nil :system t)
    ("\\l1simplefunc" "→₁ₛ" nil :system t)
    ("\\toa" "→ₐ" nil :system t)
    ("\\ra" "→ₐ" nil :system t)
    ("\\to_a" "→ₐ" nil :system t)
    ("\\r_a" "→ₐ" nil :system t)
    ("\\alghom" "→ₐ" nil :system t)
    ("\\tob" "→ᵇ" nil :system t)
    ("\\rb" "→ᵇ" nil :system t)
    ("\\to^b" "→ᵇ" nil :system t)
    ("\\r^b" "→ᵇ" nil :system t)
    ("\\boundedcontinuousfunction" "→ᵇ" nil :system t)
    ("\\tol" "→ₗ" nil :system t)
    ("\\rl" "→ₗ" nil :system t)
    ("\\to_l" "→ₗ" nil :system t)
    ("\\r_l" "→ₗ" nil :system t)
    ("\\linearmap" "→ₗ" nil :system t)
    ("\\tosl" "→ₛₗ" nil :system t)
    ("\\rsl" "→ₛₗ" nil :system t)
    ("\\to_sl" "→ₛₗ" nil :system t)
    ("\\r_sl" "→ₛₗ" nil :system t)
    ("\\semilinearmap" "→ₛₗ" nil :system t)
    ("\\tom" "→ₘ" nil :system t)
    ("\\rm" "→ₘ" nil :system t)
    ("\\to_m" "→ₘ" nil :system t)
    ("\\r_m" "→ₘ" nil :system t)
    ("\\aeeqfun" "→ₘ" nil :system t)
    ("\\rp" "→ₚ" nil :system t)
    ("\\to_p" "→ₚ" nil :system t)
    ("\\r_p" "→ₚ" nil :system t)
    ("\\dfinsupp" "→ₚ" nil :system t)
    ("\\tos" "→ₛ" nil :system t)
    ("\\rs" "→ₛ" nil :system t)
    ("\\to_s" "→ₛ" nil :system t)
    ("\\r_s" "→ₛ" nil :system t)
    ("\\simplefunc" "→ₛ" nil :system t)
    ("\\heyting" "⇨" nil :system t)
    ("\\himp" "⇨" nil :system t)
    ("\\hnot" "￢" nil :system t)
    ("\\covers" "⋖" nil :system t)
    ("\\covby" "⋖" nil :system t)
    ("\\wcovby" "⩿" nil :system t)
    ("\\wcovers" "⩿" nil :system t)
    ("\\def=" "≝" nil :system t)
    ("\\defs" "≙" nil :system t)
    ("\\degree" "°" nil :system t)
    ("\\dei" "ϯ" nil :system t)
    ("\\delta" "δ" nil :system t)
    ("\\doteqdot" "≑" nil :system t)
    ("\\doteq" "≐" nil :system t)
    ("\\dotplus" "∔" nil :system t)
    ("\\dotsquare" "⊡" nil :system t)
    ("\\dot" "·" nil :system t)
    ("\\dong" "₫" nil :system t)
    ("\\downarrow" "↓" nil :system t)
    ("\\downdownarrows" "⇊" nil :system t)
    ("\\downleftharpoon" "⇃" nil :system t)
    ("\\downrightharpoon" "⇂" nil :system t)
    ("\\dr-" "↘" nil :system t)
    ("\\dr=" "⇘" nil :system t)
    ("\\drachma" "₯" nil :system t)
    ("\\dr" "↘" nil :system t)
    ("\\dl-" "↙" nil :system t)
    ("\\dl=" "⇙" nil :system t)
    ("\\dl" "↙" nil :system t)
    ("\\d-2" "⇊" nil :system t)
    ("\\d-u-" "⇵" nil :system t)
    ("\\d-|" "↧" nil :system t)
    ("\\d-" "↓" nil :system t)
    ("\\d==" "⟱" nil :system t)
    ("\\d=" "⇓" nil :system t)
    ("\\dd-" "↡" nil :system t)
    ("\\ddagger" "‡" nil :system t)
    ("\\ddag" "‡" nil :system t)
    ("\\ddots" "⋱" nil :system t)
    ("\\dz" "↯" nil :system t)
    ("\\dib" "◆" nil :system t)
    ("\\diw" "◇" nil :system t)
    ("\\di." "◈" nil :system t)
    ("\\die" "⚀" nil :system t)
    ("\\division" "÷" nil :system t)
    ("\\divideontimes" "⋇" nil :system t)
    ("\\div" "÷" nil :system t)
    ("\\diameter" "⌀" nil :system t)
    ("\\diamondsuit" "♢" nil :system t)
    ("\\diamond" "⋄" nil :system t)
    ("\\digamma" "ϝ" nil :system t)
    ("\\di" "◆" nil :system t)
    ("\\dagger" "†" nil :system t)
    ("\\dag" "†" nil :system t)
    ("\\daleth" "ℸ" nil :system t)
    ("\\dashv" "⊣" nil :system t)
    ("\\dh" "ð" nil :system t)
    ("\\dvd" "∣" nil :system t)
    ("\\m=" "≞" nil :system t)
    ("\\meet" "⊓" nil :system t)
    ("\\member" "∈" nil :system t)
    ("\\mem" "∈" nil :system t)
    ("\\measuredangle" "∡" nil :system t)
    ("\\ma" "↦" nil :system t)
    ("\\mapsto" "↦" nil :system t)
    ("\\male" "♂" nil :system t)
    ("\\maltese" "✠" nil :system t)
    ("\\manat" "₼" nil :system t)
    ("\\mathscr{I}" "ℐ" nil :system t)
    ("\\minus" "−" nil :system t)
    ("\\mill" "₥" nil :system t)
    ("\\micro" "µ" nil :system t)
    ("\\mid" "∣" nil :system t)
    ("\\multiplication" "×" nil :system t)
    ("\\multimap" "⊸" nil :system t)
    ("\\mho" "℧" nil :system t)
    ("\\models" "⊧" nil :system t)
    ("\\mp" "∓" nil :system t)
    ("\\?=" "≟" nil :system t)
    ("\\??" "⁇" nil :system t)
    ("\\?!" "‽" nil :system t)
    ("\\prohibited" "🛇" nil :system t)
    ("\\prod" "∏" nil :system t)
    ("\\propto" "∝" nil :system t)
    ("\\precapprox" "≾" nil :system t)
    ("\\preceq" "≼" nil :system t)
    ("\\precnapprox" "⋨" nil :system t)
    ("\\precnsim" "⋨" nil :system t)
    ("\\precsim" "≾" nil :system t)
    ("\\prec" "≺" nil :system t)
    ("\\preim" "⁻¹'" nil :system t)
    ("\\preimage" "⁻¹'" nil :system t)
    ("\\prime" "′" nil :system t)
    ("\\pr" "↣" nil :system t)
    ("\\powerset" "𝒫" nil :system t)
    ("\\pounds" "£" nil :system t)
    ("\\pound" "£" nil :system t)
    ("\\pab" "▰" nil :system t)
    ("\\paw" "▱" nil :system t)
    ("\\partnership" "㉐" nil :system t)
    ("\\partial" "∂" nil :system t)
    ("\\paragraph" "¶" nil :system t)
    ("\\parallel" "∥" nil :system t)
    ("\\pa" "▰" nil :system t)
    ("\\pm" "±" nil :system t)
    ("\\perp" "⟂" nil :system t)
    ("\\^perp" "ᗮ" nil :system t)
    ("\\permil" "‰" nil :system t)
    ("\\per" "⅌" nil :system t)
    ("\\peso" "₱" nil :system t)
    ("\\peseta" "₧" nil :system t)
    ("\\pilcrow" "¶" nil :system t)
    ("\\pitchfork" "⋔" nil :system t)
    ("\\psi" "ψ" nil :system t)
    ("\\phi" "φ" nil :system t)
    ("\\leqn" "≰" nil :system t)
    ("\\leqq" "≦" nil :system t)
    ("\\leqslant" "≤" nil :system t)
    ("\\leq" "≤" nil :system t)
    ("\\len" "≰" nil :system t)
    ("\\leadsto" "↝" nil :system t)
    ("\\leftarrowtail" "↢" nil :system t)
    ("\\leftarrow" "←" nil :system t)
    ("\\leftharpoondown" "↽" nil :system t)
    ("\\leftharpoonup" "↼" nil :system t)
    ("\\leftleftarrows" "⇇" nil :system t)
    ("\\leftrightarrows" "⇆" nil :system t)
    ("\\leftrightarrow" "↔" nil :system t)
    ("\\leftrightharpoons" "⇋" nil :system t)
    ("\\leftrightsquigarrow" "↭" nil :system t)
    ("\\leftthreetimes" "⋋" nil :system t)
    ("\\lessapprox" "≲" nil :system t)
    ("\\lessdot" "⋖" nil :system t)
    ("\\lesseqgtr" "⋚" nil :system t)
    ("\\lesseqqgtr" "⋚" nil :system t)
    ("\\lessgtr" "≶" nil :system t)
    ("\\lesssim" "≲" nil :system t)
    ("\\le" "≤" nil :system t)
    ("\\lub" "⊔" nil :system t)
    ("\\lr--" "⟷" nil :system t)
    ("\\lr-n" "↮" nil :system t)
    ("\\lr-" "↔" nil :system t)
    ("\\lr=n" "⇎" nil :system t)
    ("\\lr=" "⇔" nil :system t)
    ("\\lr~" "↭" nil :system t)
    ("\\lrcorner" "⌟" nil :system t)
    ("\\lr" "↔" nil :system t)
    ("\\l-2" "⇇" nil :system t)
    ("\\l-r-" "⇆" nil :system t)
    ("\\l--" "⟵" nil :system t)
    ("\\l-n" "↚" nil :system t)
    ("\\l-|" "↤" nil :system t)
    ("\\l->" "↢" nil :system t)
    ("\\l-" "←" nil :system t)
    ("\\l==" "⇚" nil :system t)
    ("\\l=n" "⇍" nil :system t)
    ("\\l=" "⇐" nil :system t)
    ("\\l~" "↜" nil :system t)
    ("\\ll-" "↞" nil :system t)
    ("\\llcorner" "⌞" nil :system t)
    ("\\llbracket" "〚" nil :system t)
    ("\\ll" "≪" nil :system t)
    ("\\lbag" "⟅" nil :system t)
    ("\\lambda" "λ" nil :system t)
    ("\\lamda" "λ" nil :system t)
    ("\\lam" "λ" nil :system t)
    ("\\lari" "₾" nil :system t)
    ("\\langle" "⟨" nil :system t)
    ("\\lira" "₤" nil :system t)
    ("\\lceil" "⌈" nil :system t)
    ("\\ldots" "…" nil :system t)
    ("\\ldq" "“" nil :system t)
    ("\\ldata" "《" nil :system t)
    ("\\lfloor" "⌊" nil :system t)
    ("\\lf" "⧏" nil :system t)
    ("\\<|" "⧏" nil :system t)
    ("\\lhd" "◁" nil :system t)
    ("\\lnapprox" "⋦" nil :system t)
    ("\\lneqq" "≨" nil :system t)
    ("\\lneq" "≨" nil :system t)
    ("\\lnsim" "⋦" nil :system t)
    ("\\lnot" "¬" nil :system t)
    ("\\longleftarrow" "⟵" nil :system t)
    ("\\longleftrightarrow" "⟷" nil :system t)
    ("\\longrightarrow" "⟶" nil :system t)
    ("\\looparrowleft" "↫" nil :system t)
    ("\\looparrowright" "↬" nil :system t)
    ("\\lozenge" "✧" nil :system t)
    ("\\lq" "‘" nil :system t)
    ("\\ltimes" "⋉" nil :system t)
    ("\\lvertneqq" "≨" nil :system t)
    ("\\geqn" "≱" nil :system t)
    ("\\geqq" "≧" nil :system t)
    ("\\geqslant" "≥" nil :system t)
    ("\\geq" "≥" nil :system t)
    ("\\gen" "≱" nil :system t)
    ("\\gets" "←" nil :system t)
    ("\\ge" "≥" nil :system t)
    ("\\glb" "⊓" nil :system t)
    ("\\glqq" "„" nil :system t)
    ("\\glq" "‚" nil :system t)
    ("\\guarani" "₲" nil :system t)
    ("\\gangia" "ϫ" nil :system t)
    ("\\gamma" "γ" nil :system t)
    ("\\ggg" "⋙" nil :system t)
    ("\\gg" "≫" nil :system t)
    ("\\gimel" "ℷ" nil :system t)
    ("\\gnapprox" "⋧" nil :system t)
    ("\\gneqq" "≩" nil :system t)
    ("\\gneq" "≩" nil :system t)
    ("\\gnsim" "⋧" nil :system t)
    ("\\gtrapprox" "≳" nil :system t)
    ("\\gtrdot" "⋗" nil :system t)
    ("\\gtreqless" "⋛" nil :system t)
    ("\\gtreqqless" "⋛" nil :system t)
    ("\\gtrless" "≷" nil :system t)
    ("\\gtrsim" "≳" nil :system t)
    ("\\gvertneqq" "≩" nil :system t)
    ("\\grqq" "“" nil :system t)
    ("\\grq" "‘" nil :system t)
    ("\\<=n" "≰" nil :system t)
    ("\\<=>n" "⇎" nil :system t)
    ("\\<=>" "⇔" nil :system t)
    ("\\<=" "≤" nil :system t)
    ("\\<n" "≮" nil :system t)
    ("\\<~nn" "≴" nil :system t)
    ("\\<~n" "⋦" nil :system t)
    ("\\<~" "≲" nil :system t)
    ("\\<:" "⋖" nil :system t)
    ("\\:>" "⋗" nil :system t)
    ("\\<->n" "↮" nil :system t)
    ("\\<->" "↔" nil :system t)
    ("\\<-->" "⟷" nil :system t)
    ("\\<--" "⟵" nil :system t)
    ("\\<-n" "↚" nil :system t)
    ("\\<-" "←" nil :system t)
    ("\\<<" "⟪" nil :system t)
    ("\\>=n" "≱" nil :system t)
    ("\\>=" "≥" nil :system t)
    ("\\>n" "≯" nil :system t)
    ("\\>~nn" "≵" nil :system t)
    ("\\>~n" "⋧" nil :system t)
    ("\\>~" "≳" nil :system t)
    ("\\>>" "⟫" nil :system t)
    ("\\root" "√" nil :system t)
    ("\\scissor" "✂" nil :system t)
    ("\\ssubn" "⊄" nil :system t)
    ("\\ssub" "⊂" nil :system t)
    ("\\ssupn" "⊅" nil :system t)
    ("\\ssup" "⊃" nil :system t)
    ("\\ssqub" "⊏" nil :system t)
    ("\\ssqup" "⊐" nil :system t)
    ("\\ss" "⊆" nil :system t)
    ("\\subn" "⊈" nil :system t)
    ("\\subseteqq" "⊆" nil :system t)
    ("\\subseteq" "⊆" nil :system t)
    ("\\subsetneqq" "⊊" nil :system t)
    ("\\subsetneq" "⊊" nil :system t)
    ("\\subset" "⊆" nil :system t)
    ("\\ssubset" "⊂" nil :system t)
    ("\\sub" "⊆" nil :system t)
    ("\\supn" "⊉" nil :system t)
    ("\\supseteqq" "⊇" nil :system t)
    ("\\supseteq" "⊇" nil :system t)
    ("\\supsetneqq" "⊋" nil :system t)
    ("\\supsetneq" "⊋" nil :system t)
    ("\\supset" "⊇" nil :system t)
    ("\\ssupset" "⊃" nil :system t)
    ("\\sUnion" "⋃₀" nil :system t)
    ("\\sInter" "⋂₀" nil :system t)
    ("\\sup" "⊔" nil :system t)
    ("\\supr" "⨆" nil :system t)
    ("\\surd3" "∛" nil :system t)
    ("\\surd4" "∜" nil :system t)
    ("\\surd" "√" nil :system t)
    ("\\succapprox" "≿" nil :system t)
    ("\\succcurlyeq" "≽" nil :system t)
    ("\\succeq" "≽" nil :system t)
    ("\\succnapprox" "⋩" nil :system t)
    ("\\succnsim" "⋩" nil :system t)
    ("\\succsim" "≿" nil :system t)
    ("\\succ" "≻" nil :system t)
    ("\\sum" "∑" nil :system t)
    ("\\specializes" "⤳" nil :system t)
    ("\\~>" "⤳" nil :system t)
    ("\\squbn" "⋢" nil :system t)
    ("\\squb" "⊑" nil :system t)
    ("\\squpn" "⋣" nil :system t)
    ("\\squp" "⊒" nil :system t)
    ("\\square" "□" nil :system t)
    ("\\squigarrowright" "⇝" nil :system t)
    ("\\sqb" "■" nil :system t)
    ("\\sqw" "□" nil :system t)
    ("\\sq." "▣" nil :system t)
    ("\\sqo" "▢" nil :system t)
    ("\\sqcap" "⊓" nil :system t)
    ("\\sqcup" "⊔" nil :system t)
    ("\\sqrt" "√" nil :system t)
    ("\\sqsubseteq" "⊑" nil :system t)
    ("\\sqsubset" "⊏" nil :system t)
    ("\\sqsupseteq" "⊒" nil :system t)
    ("\\sqsupset" "⊐" nil :system t)
    ("\\sq" "◾" nil :system t)
    ("\\sy" "⁻¹" nil :system t)
    ("\\symmdiff" "∆" nil :system t)
    ("\\st4" "✦" nil :system t)
    ("\\st6" "✶" nil :system t)
    ("\\st8" "✴" nil :system t)
    ("\\st12" "✹" nil :system t)
    ("\\stigma" "ϛ" nil :system t)
    ("\\star" "⋆" nil :system t)
    ("\\straightphi" "φ" nil :system t)
    ("\\st" "⋆" nil :system t)
    ("\\spesmilo" "₷" nil :system t)
    ("\\span" "∙" nil :system t)
    ("\\spadesuit" "♠" nil :system t)
    ("\\sphericalangle" "∢" nil :system t)
    ("\\section" "§" nil :system t)
    ("\\searrow" "↘" nil :system t)
    ("\\setminus" "\\" nil :system t)
    ("\\san" "ϻ" nil :system t)
    ("\\sampi" "ϡ" nil :system t)
    ("\\shortmid" "∣" nil :system t)
    ("\\sho" "ϸ" nil :system t)
    ("\\shima" "ϭ" nil :system t)
    ("\\shei" "ϣ" nil :system t)
    ("\\sharp" "♯" nil :system t)
    ("\\sigma" "σ" nil :system t)
    ("\\simeq" "≃" nil :system t)
    ("\\sim" "∼" nil :system t)
    ("\\sbs" "﹨" nil :system t)
    ("\\smallamalg" "∐" nil :system t)
    ("\\smallsetminus" "∖" nil :system t)
    ("\\smallsmile" "⌣" nil :system t)
    ("\\smile" "⌣" nil :system t)
    ("\\smul" "•" nil :system t)
    ("\\swarrow" "↙" nil :system t)
    ("\\Tr" "◀" nil :system t)
    ("\\Tb" "◀" nil :system t)
    ("\\Tw" "◁" nil :system t)
    ("\\Tau" "Τ" nil :system t)
    ("\\Theta" "Θ" nil :system t)
    ("\\TH" "Þ" nil :system t)
    ("\\union" "∪" nil :system t)
    ("\\undertie" "‿" nil :system t)
    ("\\uncertainty" "⯑" nil :system t)
    ("\\un" "∪" nil :system t)
    ("\\u+" "⊎" nil :system t)
    ("\\u." "⊍" nil :system t)
    ("\\ud-|" "↨" nil :system t)
    ("\\ud-" "↕" nil :system t)
    ("\\ud=" "⇕" nil :system t)
    ("\\ud" "↕" nil :system t)
    ("\\ul-" "↖" nil :system t)
    ("\\ul=" "⇖" nil :system t)
    ("\\ulcorner" "⌜" nil :system t)
    ("\\ul" "↖" nil :system t)
    ("\\ur-" "↗" nil :system t)
    ("\\ur=" "⇗" nil :system t)
    ("\\urcorner" "⌝" nil :system t)
    ("\\ur" "↗" nil :system t)
    ("\\u-2" "⇈" nil :system t)
    ("\\u-d-" "⇅" nil :system t)
    ("\\u-|" "↥" nil :system t)
    ("\\u-" "↑" nil :system t)
    ("\\u==" "⟰" nil :system t)
    ("\\u=" "⇑" nil :system t)
    ("\\uu-" "↟" nil :system t)
    ("\\upsilon" "υ" nil :system t)
    ("\\uparrow" "↑" nil :system t)
    ("\\updownarrow" "↕" nil :system t)
    ("\\upleftharpoon" "↿" nil :system t)
    ("\\uplus" "⊎" nil :system t)
    ("\\uprightharpoon" "↾" nil :system t)
    ("\\upuparrows" "⇈" nil :system t)
    ("\\And" "⋀" nil :system t)
    ("\\AA" "Å" nil :system t)
    ("\\AE" "Æ" nil :system t)
    ("\\Alpha" "Α" nil :system t)
    ("\\Or" "⋁" nil :system t)
    ("\\O+" "⨁" nil :system t)
    ("\\directsum" "⨁" nil :system t)
    ("\\Ox" "⨂" nil :system t)
    ("\\O." "⨀" nil :system t)
    ("\\O*" "⍟" nil :system t)
    ("\\OE" "Œ" nil :system t)
    ("\\Omega" "Ω" nil :system t)
    ("\\Omicron" "Ο" nil :system t)
    ("\\Int" "ℤ" nil :system t)
    ("\\Inter" "⋂" nil :system t)
    ("\\bInter" "⋂" nil :system t)
    ("\\Iota" "Ι" nil :system t)
    ("\\Im" "ℑ" nil :system t)
    ("\\Un" "⋃" nil :system t)
    ("\\Union" "⋃" nil :system t)
    ("\\bUnion" "⋃" nil :system t)
    ("\\U+" "⨄" nil :system t)
    ("\\U." "⨃" nil :system t)
    ("\\Upsilon" "Υ" nil :system t)
    ("\\Uparrow" "⇑" nil :system t)
    ("\\Updownarrow" "⇕" nil :system t)
    ("\\Gl-" "ƛ" nil :system t)
    ("\\Gl" "λ" nil :system t)
    ("\\Gangia" "Ϫ" nil :system t)
    ("\\Gamma" "Γ" nil :system t)
    ("\\Glb" "⨅" nil :system t)
    ("\\Ga" "α" nil :system t)
    ("\\GA" "Α" nil :system t)
    ("\\Gb" "β" nil :system t)
    ("\\GB" "Β" nil :system t)
    ("\\Gg" "γ" nil :system t)
    ("\\GG" "Γ" nil :system t)
    ("\\Gd" "δ" nil :system t)
    ("\\GD" "Δ" nil :system t)
    ("\\Ge" "ε" nil :system t)
    ("\\GE" "Ε" nil :system t)
    ("\\Gz" "ζ" nil :system t)
    ("\\GZ" "Ζ" nil :system t)
    ("\\Gth" "θ" nil :system t)
    ("\\Gt" "τ" nil :system t)
    ("\\GTH" "Θ" nil :system t)
    ("\\GT" "Τ" nil :system t)
    ("\\Gi" "ι" nil :system t)
    ("\\GI" "Ι" nil :system t)
    ("\\Gk" "κ" nil :system t)
    ("\\GK" "Κ" nil :system t)
    ("\\GL" "Λ" nil :system t)
    ("\\Gm" "μ" nil :system t)
    ("\\GM" "Μ" nil :system t)
    ("\\Gn" "ν" nil :system t)
    ("\\GN" "Ν" nil :system t)
    ("\\Gx" "ξ" nil :system t)
    ("\\GX" "Ξ" nil :system t)
    ("\\Gr" "ρ" nil :system t)
    ("\\GR" "Ρ" nil :system t)
    ("\\Gs" "σ" nil :system t)
    ("\\GS" "Σ" nil :system t)
    ("\\Gu" "υ" nil :system t)
    ("\\GU" "Υ" nil :system t)
    ("\\Gf" "φ" nil :system t)
    ("\\GF" "Φ" nil :system t)
    ("\\Gc" "χ" nil :system t)
    ("\\GC" "Χ" nil :system t)
    ("\\Gp" "ψ" nil :system t)
    ("\\GP" "Ψ" nil :system t)
    ("\\Go" "ω" nil :system t)
    ("\\GO" "Ω" nil :system t)
    ("\\Inf" "⨅" nil :system t)
    ("\\Join" "⨆" nil :system t)
    ("\\Lub" "⨆" nil :system t)
    ("\\Lambda" "Λ" nil :system t)
    ("\\Lamda" "Λ" nil :system t)
    ("\\Leftarrow" "⇐" nil :system t)
    ("\\Leftrightarrow" "⇔" nil :system t)
    ("\\Letter" "✉" nil :system t)
    ("\\Lleftarrow" "⇚" nil :system t)
    ("\\Ll" "⋘" nil :system t)
    ("\\Longleftarrow" "⇐" nil :system t)
    ("\\Longleftrightarrow" "⇔" nil :system t)
    ("\\Longrightarrow" "⇒" nil :system t)
    ("\\Meet" "⨅" nil :system t)
    ("\\Sup" "⨆" nil :system t)
    ("\\Sqcap" "⨅" nil :system t)
    ("\\Sqcup" "⨆" nil :system t)
    ("\\Lsh" "↰" nil :system t)
    ("\\|-n" "⊬" nil :system t)
    ("\\|-" "⊢" nil :system t)
    ("\\|=n" "⊭" nil :system t)
    ("\\|=" "⊨" nil :system t)
    ("\\|->" "↦" nil :system t)
    ("\\|=>" "⇰" nil :system t)
    ("\\||-n" "⊮" nil :system t)
    ("\\||-" "⊩" nil :system t)
    ("\\||=n" "⊯" nil :system t)
    ("\\||=" "⊫" nil :system t)
    ("\\|||-" "⊪" nil :system t)
    ("\\||" "‖" nil :system t)
    ("\\fuzzy" "‖" nil :system t)
    ("\\|n" "∤" nil :system t)
    ("\\Com" "ℂ" nil :system t)
    ("\\Chi" "Χ" nil :system t)
    ("\\Cap" "⋒" nil :system t)
    ("\\Cup" "⋓" nil :system t)
    ("\\cul" "⌜" nil :system t)
    ("\\cuL" "⌈" nil :system t)
    ("\\currency" "¤" nil :system t)
    ("\\curlyeqprec" "⋞" nil :system t)
    ("\\curlyeqsucc" "⋟" nil :system t)
    ("\\curlypreceq" "≼" nil :system t)
    ("\\curlyvee" "⋎" nil :system t)
    ("\\curlywedge" "⋏" nil :system t)
    ("\\curvearrowleft" "↶" nil :system t)
    ("\\curvearrowright" "↷" nil :system t)
    ("\\cur" "⌝" nil :system t)
    ("\\cuR" "⌉" nil :system t)
    ("\\cup" "∪" nil :system t)
    ("\\cu" "⌜" nil :system t)
    ("\\cll" "⌞" nil :system t)
    ("\\clL" "⌊" nil :system t)
    ("\\clr" "⌟" nil :system t)
    ("\\clR" "⌋" nil :system t)
    ("\\clubsuit" "♣" nil :system t)
    ("\\cl" "⌞" nil :system t)
    ("\\construction" "🚧" nil :system t)
    ("\\cong" "≅" nil :system t)
    ("\\con" "⬝" nil :system t)
    ("\\compl" "ᶜ" nil :system t)
    ("\\complement" "ᶜ" nil :system t)
    ("\\complementprefix" "∁" nil :system t)
    ("\\Complement" "∁" nil :system t)
    ("\\comp" "∘" nil :system t)
    ("\\com" "ℂ" nil :system t)
    ("\\coloneq" "≔" nil :system t)
    ("\\colon" "₡" nil :system t)
    ("\\copyright" "©" nil :system t)
    ("\\cdots" "⋯" nil :system t)
    ("\\cdot" "·" nil :system t)
    ("\\cib" "●" nil :system t)
    ("\\ciw" "○" nil :system t)
    ("\\ci.." "◌" nil :system t)
    ("\\ci." "◎" nil :system t)
    ("\\ciO" "◯" nil :system t)
    ("\\circeq" "≗" nil :system t)
    ("\\circlearrowleft" "↺" nil :system t)
    ("\\circlearrowright" "↻" nil :system t)
    ("\\circledR" "®" nil :system t)
    ("\\circledS" "Ⓢ" nil :system t)
    ("\\circledast" "⊛" nil :system t)
    ("\\circledcirc" "⊚" nil :system t)
    ("\\circleddash" "⊝" nil :system t)
    ("\\circ" "∘" nil :system t)
    ("\\ci" "●" nil :system t)
    ("\\centerdot" "·" nil :system t)
    ("\\cent" "¢" nil :system t)
    ("\\cedi" "₵" nil :system t)
    ("\\celsius" "℃" nil :system t)
    ("\\ce" "ȩ" nil :system t)
    ("\\checkmark" "✓" nil :system t)
    ("\\chi" "χ" nil :system t)
    ("\\cruzeiro" "₢" nil :system t)
    ("\\caution" "☡" nil :system t)
    ("\\cap" "∩" nil :system t)
    ("\\qed" "∎" nil :system t)
    ("\\quad" " " nil :system t)
    ("\\quot" "⧸" nil :system t)
    ("\\bigsolidus" "⧸" nil :system t)
    ("\\/" "⧸" nil :system t)
    ("\\+ " "⊹" nil :system t)
    ("\\b+" "⊞" nil :system t)
    ("\\b-" "⊟" nil :system t)
    ("\\bx" "⊠" nil :system t)
    ("\\b." "⊡" nil :system t)
    ("\\bn" "ℕ" nil :system t)
    ("\\bz" "ℤ" nil :system t)
    ("\\bq" "ℚ" nil :system t)
    ("\\brokenbar" "¦" nil :system t)
    ("\\br" "ℝ" nil :system t)
    ("\\bc" "ℂ" nil :system t)
    ("\\bp" "ℙ" nil :system t)
    ("\\bb" "𝔹" nil :system t)
    ("\\bsum" "⅀" nil :system t)
    ("\\b0" "𝟘" nil :system t)
    ("\\b1" "𝟙" nil :system t)
    ("\\b2" "𝟚" nil :system t)
    ("\\b3" "𝟛" nil :system t)
    ("\\b4" "𝟜" nil :system t)
    ("\\b5" "𝟝" nil :system t)
    ("\\b6" "𝟞" nil :system t)
    ("\\b7" "𝟟" nil :system t)
    ("\\b8" "𝟠" nil :system t)
    ("\\b9" "𝟡" nil :system t)
    ("\\sb0" "𝟬" nil :system t)
    ("\\sb1" "𝟭" nil :system t)
    ("\\sb2" "𝟮" nil :system t)
    ("\\sb3" "𝟯" nil :system t)
    ("\\sb4" "𝟰" nil :system t)
    ("\\sb5" "𝟱" nil :system t)
    ("\\sb6" "𝟲" nil :system t)
    ("\\sb7" "𝟳" nil :system t)
    ("\\sb8" "𝟴" nil :system t)
    ("\\sb9" "𝟵" nil :system t)
    ("\\bub" "•" nil :system t)
    ("\\buw" "◦" nil :system t)
    ("\\but" "‣" nil :system t)
    ("\\bumpeq" "≏" nil :system t)
    ("\\bu" "•" nil :system t)
    ("\\biohazard" "☣" nil :system t)
    ("\\bihimp" "⇔" nil :system t)
    ("\\bigcap" "⋂" nil :system t)
    ("\\bigcirc" "◯" nil :system t)
    ("\\bigcoprod" "∐" nil :system t)
    ("\\bigcup" "⋃" nil :system t)
    ("\\bigglb" "⨅" nil :system t)
    ("\\biginf" "⨅" nil :system t)
    ("\\bigjoin" "⨆" nil :system t)
    ("\\biglub" "⨆" nil :system t)
    ("\\bigmeet" "⨅" nil :system t)
    ("\\bigsqcap" "⨅" nil :system t)
    ("\\bigsqcup" "⨆" nil :system t)
    ("\\bigstar" "★" nil :system t)
    ("\\bigsup" "⨆" nil :system t)
    ("\\bigtriangledown" "▽" nil :system t)
    ("\\bigtriangleup" "△" nil :system t)
    ("\\bigvee" "⋁" nil :system t)
    ("\\bigwedge" "⋀" nil :system t)
    ("\\beta" "β" nil :system t)
    ("\\beth" "ℶ" nil :system t)
    ("\\between" "≬" nil :system t)
    ("\\because" "∵" nil :system t)
    ("\\backcong" "≌" nil :system t)
    ("\\backepsilon" "∍" nil :system t)
    ("\\backprime" "‵" nil :system t)
    ("\\backsimeq" "⋍" nil :system t)
    ("\\backsim" "∽" nil :system t)
    ("\\barwedge" "⊼" nil :system t)
    ("\\blacklozenge" "✦" nil :system t)
    ("\\blacksquare" "▪" nil :system t)
    ("\\blacksmiley" "☻" nil :system t)
    ("\\blacktriangledown" "▾" nil :system t)
    ("\\blacktriangleleft" "◂" nil :system t)
    ("\\blacktriangleright" "▸" nil :system t)
    ("\\blacktriangle" "▴" nil :system t)
    ("\\bot" "⊥" nil :system t)
    ("\\^bot" "ᗮ" nil :system t)
    ("\\bowtie" "⋈" nil :system t)
    ("\\boxminus" "⊟" nil :system t)
    ("\\boxmid" "◫" nil :system t)
    ("\\hcomp" "◫" nil :system t)
    ("\\boxplus" "⊞" nil :system t)
    ("\\boxtimes" "⊠" nil :system t)
    ("\\join" "⊔" nil :system t)
    ("\\r-2" "⇉" nil :system t)
    ("\\r-3" "⇶" nil :system t)
    ("\\r-l-" "⇄" nil :system t)
    ("\\r--" "⟶" nil :system t)
    ("\\r-n" "↛" nil :system t)
    ("\\r-|" "↦" nil :system t)
    ("\\r->" "↣" nil :system t)
    ("\\r-o" "⊸" nil :system t)
    ("\\r-" "→" nil :system t)
    ("\\r==" "⇛" nil :system t)
    ("\\r=n" "⇏" nil :system t)
    ("\\r=" "⇒" nil :system t)
    ("\\r~" "↝" nil :system t)
    ("\\rr-" "↠" nil :system t)
    ("\\reb" "▬" nil :system t)
    ("\\rew" "▭" nil :system t)
    ("\\real" "ℝ" nil :system t)
    ("\\registered" "®" nil :system t)
    ("\\re" "▬" nil :system t)
    ("\\rbag" "⟆" nil :system t)
    ("\\rat" "ℚ" nil :system t)
    ("\\radioactive" "☢" nil :system t)
    ("\\rrbracket" "〛" nil :system t)
    ("\\rangle" "⟩" nil :system t)
    ("\\rq" "’" nil :system t)
    ("\\rightarrowtail" "↣" nil :system t)
    ("\\rightarrow" "→" nil :system t)
    ("\\rightharpoondown" "⇁" nil :system t)
    ("\\rightharpoonup" "⇀" nil :system t)
    ("\\rightleftarrows" "⇄" nil :system t)
    ("\\rightleftharpoons" "⇌" nil :system t)
    ("\\rightrightarrows" "⇉" nil :system t)
    ("\\rightthreetimes" "⋌" nil :system t)
    ("\\risingdotseq" "≓" nil :system t)
    ("\\ruble" "₽" nil :system t)
    ("\\rupee" "₨" nil :system t)
    ("\\rho" "ρ" nil :system t)
    ("\\rhd" "▷" nil :system t)
    ("\\rceil" "⌉" nil :system t)
    ("\\rfloor" "⌋" nil :system t)
    ("\\rtimes" "⋊" nil :system t)
    ("\\rdq" "”" nil :system t)
    ("\\rdata" "》" nil :system t)
    ("\\functor" "⥤" nil :system t)
    ("\\fun" "λ" nil :system t)
    ("\\f<<" "«" nil :system t)
    ("\\f>>" "»" nil :system t)
    ("\\f<" "‹" nil :system t)
    ("\\f>" "›" nil :system t)
    ("\\finprod" "∏ᶠ" nil :system t)
    ("\\finsum" "∑ᶠ" nil :system t)
    ("\\frac12" "½" nil :system t)
    ("\\frac13" "⅓" nil :system t)
    ("\\frac14" "¼" nil :system t)
    ("\\frac15" "⅕" nil :system t)
    ("\\frac16" "⅙" nil :system t)
    ("\\frac18" "⅛" nil :system t)
    ("\\frac1" "⅟" nil :system t)
    ("\\frac23" "⅔" nil :system t)
    ("\\frac25" "⅖" nil :system t)
    ("\\frac34" "¾" nil :system t)
    ("\\frac35" "⅗" nil :system t)
    ("\\frac38" "⅜" nil :system t)
    ("\\frac45" "⅘" nil :system t)
    ("\\frac56" "⅚" nil :system t)
    ("\\frac58" "⅝" nil :system t)
    ("\\frac78" "⅞" nil :system t)
    ("\\frac" "¼" nil :system t)
    ("\\frown" "⌢" nil :system t)
    ("\\frqq" "»" nil :system t)
    ("\\frq" "›" nil :system t)
    ("\\female" "♀" nil :system t)
    ("\\fei" "ϥ" nil :system t)
    ("\\facsimile" "℻" nil :system t)
    ("\\fallingdotseq" "≒" nil :system t)
    ("\\flat" "♭" nil :system t)
    ("\\flqq" "«" nil :system t)
    ("\\flq" "‹" nil :system t)
    ("\\forall" "∀" nil :system t)
    ("\\)b" "⟆" nil :system t)
    ("\\[[" "⟦" nil :system t)
    ("\\]]" "⟧" nil :system t)
    ("\\{{" "⦃" nil :system t)
    ("\\}}" "⦄" nil :system t)
    ("\\((" "⸨" nil :system t)
    ("\\))" "⸩" nil :system t)
    ("\\([" "⟮" nil :system t)
    ("\\])" "⟯" nil :system t)
    ("\\Xi" "Ξ" nil :system t)
    ("\\Nat" "ℕ" nil :system t)
    ("\\Nu" "Ν" nil :system t)
    ("\\Zeta" "Ζ" nil :system t)
    ("\\Rat" "ℚ" nil :system t)
    ("\\Real" "ℝ" nil :system t)
    ("\\Re" "ℜ" nil :system t)
    ("\\Rho" "Ρ" nil :system t)
    ("\\Rightarrow" "⇒" nil :system t)
    ("\\Rrightarrow" "⇛" nil :system t)
    ("\\Rsh" "↱" nil :system t)
    ("\\Fei" "Ϥ" nil :system t)
    ("\\Frowny" "☹" nil :system t)
    ("\\Hori" "Ϩ" nil :system t)
    ("\\Heta" "Ͱ" nil :system t)
    ("\\Khei" "Ϧ" nil :system t)
    ("\\Koppa" "Ϟ" nil :system t)
    ("\\Kappa" "Κ" nil :system t)
    ("\\^a" "ᵃ" nil :system t)
    ("\\^b" "ᵇ" nil :system t)
    ("\\^c" "ᶜ" nil :system t)
    ("\\^d" "ᵈ" nil :system t)
    ("\\^e" "ᵉ" nil :system t)
    ("\\^f" "ᶠ" nil :system t)
    ("\\^g" "ᵍ" nil :system t)
    ("\\^h" "ʰ" nil :system t)
    ("\\^i" "ⁱ" nil :system t)
    ("\\^j" "ʲ" nil :system t)
    ("\\^k" "ᵏ" nil :system t)
    ("\\^l" "ˡ" nil :system t)
    ("\\^m" "ᵐ" nil :system t)
    ("\\^n" "ⁿ" nil :system t)
    ("\\^o" "ᵒ" nil :system t)
    ("\\^p" "ᵖ" nil :system t)
    ("\\^r" "ʳ" nil :system t)
    ("\\^s" "ˢ" nil :system t)
    ("\\^t" "ᵗ" nil :system t)
    ("\\^u" "ᵘ" nil :system t)
    ("\\^v" "ᵛ" nil :system t)
    ("\\^w" "ʷ" nil :system t)
    ("\\^x" "ˣ" nil :system t)
    ("\\^y" "ʸ" nil :system t)
    ("\\^z" "ᶻ" nil :system t)
    ("\\^A" "ᴬ" nil :system t)
    ("\\^B" "ᴮ" nil :system t)
    ("\\^D" "ᴰ" nil :system t)
    ("\\^E" "ᴱ" nil :system t)
    ("\\^G" "ᴳ" nil :system t)
    ("\\^H" "ᴴ" nil :system t)
    ("\\^I" "ᴵ" nil :system t)
    ("\\^J" "ᴶ" nil :system t)
    ("\\^K" "ᴷ" nil :system t)
    ("\\^L" "ᴸ" nil :system t)
    ("\\^M" "ᴹ" nil :system t)
    ("\\^N" "ᴺ" nil :system t)
    ("\\^O" "ᴼ" nil :system t)
    ("\\^P" "ᴾ" nil :system t)
    ("\\^R" "ᴿ" nil :system t)
    ("\\^T" "ᵀ" nil :system t)
    ("\\^U" "ᵁ" nil :system t)
    ("\\^V" "ⱽ" nil :system t)
    ("\\^W" "ᵂ" nil :system t)
    ("\\^0" "⁰" nil :system t)
    ("\\^1" "¹" nil :system t)
    ("\\^2" "²" nil :system t)
    ("\\^3" "³" nil :system t)
    ("\\^4" "⁴" nil :system t)
    ("\\^5" "⁵" nil :system t)
    ("\\^6" "⁶" nil :system t)
    ("\\^7" "⁷" nil :system t)
    ("\\^8" "⁸" nil :system t)
    ("\\^9" "⁹" nil :system t)
    ("\\^)" "⁾" nil :system t)
    ("\\^(" "⁽" nil :system t)
    ("\\^=" "⁼" nil :system t)
    ("\\^+" "⁺" nil :system t)
    ("\\^o_" "º" nil :system t)
    ("\\^-" "⁻" nil :system t)
    ("\\^a_" "ª" nil :system t)
    ("\\^uhook" "ꭟ" nil :system t)
    ("\\^ubar" "ᶶ" nil :system t)
    ("\\^upsilon" "ᶷ" nil :system t)
    ("\\^ltilde" "ꭞ" nil :system t)
    ("\\^ls" "ꭝ" nil :system t)
    ("\\^lhook" "ᶪ" nil :system t)
    ("\\^lretroflexhook" "ᶩ" nil :system t)
    ("\\^oe" "ꟹ" nil :system t)
    ("\\^heng" "ꭜ" nil :system t)
    ("\\^hhook" "ʱ" nil :system t)
    ("\\^hwithhook" "ʱ" nil :system t)
    ("\\^Hstroke" "ꟸ" nil :system t)
    ("\\^theta" "ᶿ" nil :system t)
    ("\\^turnedv" "ᶺ" nil :system t)
    ("\\^turnedmleg" "ᶭ" nil :system t)
    ("\\^turnedm" "ᵚ" nil :system t)
    ("\\^turnedh" "ᶣ" nil :system t)
    ("\\^turnedalpha" "ᶛ" nil :system t)
    ("\\^turnedae" "ᵆ" nil :system t)
    ("\\^turneda" "ᵄ" nil :system t)
    ("\\^turnedi" "ᵎ" nil :system t)
    ("\\^turnede" "ᵌ" nil :system t)
    ("\\^turnedrhook" "ʵ" nil :system t)
    ("\\^turnedrwithhook" "ʵ" nil :system t)
    ("\\^turnedr" "ʴ" nil :system t)
    ("\\^twithpalatalhook" "ᶵ" nil :system t)
    ("\\^otop" "ᵔ" nil :system t)
    ("\\^ezh" "ᶾ" nil :system t)
    ("\\^esh" "ᶴ" nil :system t)
    ("\\^eth" "ᶞ" nil :system t)
    ("\\^eng" "ᵑ" nil :system t)
    ("\\^zcurl" "ᶽ" nil :system t)
    ("\\^zretroflexhook" "ᶼ" nil :system t)
    ("\\^vhook" "ᶹ" nil :system t)
    ("\\^Ismall" "ᶦ" nil :system t)
    ("\\^Lsmall" "ᶫ" nil :system t)
    ("\\^Nsmall" "ᶰ" nil :system t)
    ("\\^Usmall" "ᶸ" nil :system t)
    ("\\^Istroke" "ᶧ" nil :system t)
    ("\\^Rinverted" "ʶ" nil :system t)
    ("\\^ccurl" "ᶝ" nil :system t)
    ("\\^chi" "ᵡ" nil :system t)
    ("\\^shook" "ᶳ" nil :system t)
    ("\\^gscript" "ᶢ" nil :system t)
    ("\\^schwa" "ᵊ" nil :system t)
    ("\\^usideways" "ᵙ" nil :system t)
    ("\\^phi" "ᶲ" nil :system t)
    ("\\^obarred" "ᶱ" nil :system t)
    ("\\^beta" "ᵝ" nil :system t)
    ("\\^obottom" "ᵕ" nil :system t)
    ("\\^nretroflexhook" "ᶯ" nil :system t)
    ("\\^nlefthook" "ᶮ" nil :system t)
    ("\\^mhook" "ᶬ" nil :system t)
    ("\\^jtail" "ᶨ" nil :system t)
    ("\\^iota" "ᶥ" nil :system t)
    ("\\^istroke" "ᶤ" nil :system t)
    ("\\^ereversedopen" "ᶟ" nil :system t)
    ("\\^stop" "ˤ" nil :system t)
    ("\\^varphi" "ᵠ" nil :system t)
    ("\\^vargamma" "ᵞ" nil :system t)
    ("\\^gamma" "ˠ" nil :system t)
    ("\\^ain" "ᵜ" nil :system t)
    ("\\^alpha" "ᵅ" nil :system t)
    ("\\^oopen" "ᵓ" nil :system t)
    ("\\^eopen" "ᵋ" nil :system t)
    ("\\^Ou" "ᴽ" nil :system t)
    ("\\^Nreversed" "ᴻ" nil :system t)
    ("\\^Ereversed" "ᴲ" nil :system t)
    ("\\^Bbarred" "ᴯ" nil :system t)
    ("\\^Ae" "ᴭ" nil :system t)
    ("\\^SM" "℠" nil :system t)
    ("\\^TEL" "℡" nil :system t)
    ("\\^TM" "™" nil :system t)
    ("\\_a" "ₐ" nil :system t)
    ("\\_e" "ₑ" nil :system t)
    ("\\_h" "ₕ" nil :system t)
    ("\\_i" "ᵢ" nil :system t)
    ("\\_j" "ⱼ" nil :system t)
    ("\\_k" "ₖ" nil :system t)
    ("\\_l" "ₗ" nil :system t)
    ("\\_m" "ₘ" nil :system t)
    ("\\_n" "ₙ" nil :system t)
    ("\\_o" "ₒ" nil :system t)
    ("\\_p" "ₚ" nil :system t)
    ("\\_r" "ᵣ" nil :system t)
    ("\\_s" "ₛ" nil :system t)
    ("\\_t" "ₜ" nil :system t)
    ("\\_u" "ᵤ" nil :system t)
    ("\\_v" "ᵥ" nil :system t)
    ("\\_x" "ₓ" nil :system t)
    ("\\_0" "₀" nil :system t)
    ("\\_1" "₁" nil :system t)
    ("\\_2" "₂" nil :system t)
    ("\\_3" "₃" nil :system t)
    ("\\_4" "₄" nil :system t)
    ("\\_5" "₅" nil :system t)
    ("\\_6" "₆" nil :system t)
    ("\\_7" "₇" nil :system t)
    ("\\_8" "₈" nil :system t)
    ("\\_9" "₉" nil :system t)
    ("\\_)" "₎" nil :system t)
    ("\\_(" "₍" nil :system t)
    ("\\_=" "₌" nil :system t)
    ("\\_+" "₊" nil :system t)
    ("\\_--" "̲" nil :system t)
    ("\\_-" "₋" nil :system t)
    ("\\!!" "‼" nil :system t)
    ("\\!?" "⁉" nil :system t)
    ("\\San" "Ϻ" nil :system t)
    ("\\Sampi" "Ϡ" nil :system t)
    ("\\Sho" "Ϸ" nil :system t)
    ("\\Shima" "Ϭ" nil :system t)
    ("\\Shei" "Ϣ" nil :system t)
    ("\\Stigma" "Ϛ" nil :system t)
    ("\\Sigma" "Σ" nil :system t)
    ("\\Subset" "⋐" nil :system t)
    ("\\Supset" "⋑" nil :system t)
    ("\\Smiley" "☺" nil :system t)
    ("\\Psi" "Ψ" nil :system t)
    ("\\Phi" "Φ" nil :system t)
    ("\\Pi" "Π" nil :system t)
    ("\\Pi0" "Π₀" nil :system t)
    ("\\P0" "Π₀" nil :system t)
    ("\\Pi_0" "Π₀" nil :system t)
    ("\\P_0" "Π₀" nil :system t)
    ("\\bfA" "𝐀" nil :system t)
    ("\\bfB" "𝐁" nil :system t)
    ("\\bfC" "𝐂" nil :system t)
    ("\\bfD" "𝐃" nil :system t)
    ("\\bfE" "𝐄" nil :system t)
    ("\\bfF" "𝐅" nil :system t)
    ("\\bfG" "𝐆" nil :system t)
    ("\\bfH" "𝐇" nil :system t)
    ("\\bfI" "𝐈" nil :system t)
    ("\\bfJ" "𝐉" nil :system t)
    ("\\bfK" "𝐊" nil :system t)
    ("\\bfL" "𝐋" nil :system t)
    ("\\bfM" "𝐌" nil :system t)
    ("\\bfN" "𝐍" nil :system t)
    ("\\bfO" "𝐎" nil :system t)
    ("\\bfP" "𝐏" nil :system t)
    ("\\bfQ" "𝐐" nil :system t)
    ("\\bfR" "𝐑" nil :system t)
    ("\\bfS" "𝐒" nil :system t)
    ("\\bfT" "𝐓" nil :system t)
    ("\\bfU" "𝐔" nil :system t)
    ("\\bfV" "𝐕" nil :system t)
    ("\\bfW" "𝐖" nil :system t)
    ("\\bfX" "𝐗" nil :system t)
    ("\\bfY" "𝐘" nil :system t)
    ("\\bfZ" "𝐙" nil :system t)
    ("\\bfa" "𝐚" nil :system t)
    ("\\bfb" "𝐛" nil :system t)
    ("\\bfc" "𝐜" nil :system t)
    ("\\bfd" "𝐝" nil :system t)
    ("\\bfe" "𝐞" nil :system t)
    ("\\bff" "𝐟" nil :system t)
    ("\\bfg" "𝐠" nil :system t)
    ("\\bfh" "𝐡" nil :system t)
    ("\\bfi" "𝐢" nil :system t)
    ("\\bfj" "𝐣" nil :system t)
    ("\\bfk" "𝐤" nil :system t)
    ("\\bfl" "𝐥" nil :system t)
    ("\\bfm" "𝐦" nil :system t)
    ("\\bfn" "𝐧" nil :system t)
    ("\\bfo" "𝐨" nil :system t)
    ("\\bfp" "𝐩" nil :system t)
    ("\\bfq" "𝐪" nil :system t)
    ("\\bfr" "𝐫" nil :system t)
    ("\\bfs" "𝐬" nil :system t)
    ("\\bft" "𝐭" nil :system t)
    ("\\bfu" "𝐮" nil :system t)
    ("\\bfv" "𝐯" nil :system t)
    ("\\bfw" "𝐰" nil :system t)
    ("\\bfx" "𝐱" nil :system t)
    ("\\bfy" "𝐲" nil :system t)
    ("\\bfz" "𝐳" nil :system t)
    ("\\MiA" "𝐴" nil :system t)
    ("\\MiB" "𝐵" nil :system t)
    ("\\MiC" "𝐶" nil :system t)
    ("\\MiD" "𝐷" nil :system t)
    ("\\MiE" "𝐸" nil :system t)
    ("\\MiF" "𝐹" nil :system t)
    ("\\MiG" "𝐺" nil :system t)
    ("\\MiH" "𝐻" nil :system t)
    ("\\MiI" "𝐼" nil :system t)
    ("\\MiJ" "𝐽" nil :system t)
    ("\\MiK" "𝐾" nil :system t)
    ("\\MiL" "𝐿" nil :system t)
    ("\\MiM" "𝑀" nil :system t)
    ("\\MiN" "𝑁" nil :system t)
    ("\\MiO" "𝑂" nil :system t)
    ("\\MiP" "𝑃" nil :system t)
    ("\\MiQ" "𝑄" nil :system t)
    ("\\MiR" "𝑅" nil :system t)
    ("\\MiS" "𝑆" nil :system t)
    ("\\MiT" "𝑇" nil :system t)
    ("\\MiU" "𝑈" nil :system t)
    ("\\MiV" "𝑉" nil :system t)
    ("\\MiW" "𝑊" nil :system t)
    ("\\MiX" "𝑋" nil :system t)
    ("\\MiY" "𝑌" nil :system t)
    ("\\MiZ" "𝑍" nil :system t)
    ("\\Mia" "𝑎" nil :system t)
    ("\\Mib" "𝑏" nil :system t)
    ("\\Mic" "𝑐" nil :system t)
    ("\\Mid" "𝑑" nil :system t)
    ("\\Mie" "𝑒" nil :system t)
    ("\\Mif" "𝑓" nil :system t)
    ("\\Mig" "𝑔" nil :system t)
    ("\\Mii" "𝑖" nil :system t)
    ("\\Mij" "𝑗" nil :system t)
    ("\\Mik" "𝑘" nil :system t)
    ("\\Mil" "𝑙" nil :system t)
    ("\\Mim" "𝑚" nil :system t)
    ("\\Min" "𝑛" nil :system t)
    ("\\Mio" "𝑜" nil :system t)
    ("\\Mip" "𝑝" nil :system t)
    ("\\Miq" "𝑞" nil :system t)
    ("\\Mir" "𝑟" nil :system t)
    ("\\Mis" "𝑠" nil :system t)
    ("\\Mit" "𝑡" nil :system t)
    ("\\Miu" "𝑢" nil :system t)
    ("\\Miv" "𝑣" nil :system t)
    ("\\Miw" "𝑤" nil :system t)
    ("\\Mix" "𝑥" nil :system t)
    ("\\Miy" "𝑦" nil :system t)
    ("\\Miz" "𝑧" nil :system t)
    ("\\MIA" "𝑨" nil :system t)
    ("\\MIB" "𝑩" nil :system t)
    ("\\MIC" "𝑪" nil :system t)
    ("\\MID" "𝑫" nil :system t)
    ("\\MIE" "𝑬" nil :system t)
    ("\\MIF" "𝑭" nil :system t)
    ("\\MIG" "𝑮" nil :system t)
    ("\\MIH" "𝑯" nil :system t)
    ("\\MII" "𝑰" nil :system t)
    ("\\MIJ" "𝑱" nil :system t)
    ("\\MIK" "𝑲" nil :system t)
    ("\\MIL" "𝑳" nil :system t)
    ("\\MIM" "𝑴" nil :system t)
    ("\\MIN" "𝑵" nil :system t)
    ("\\MIO" "𝑶" nil :system t)
    ("\\MIP" "𝑷" nil :system t)
    ("\\MIQ" "𝑸" nil :system t)
    ("\\MIR" "𝑹" nil :system t)
    ("\\MIS" "𝑺" nil :system t)
    ("\\MIT" "𝑻" nil :system t)
    ("\\MIU" "𝑼" nil :system t)
    ("\\MIV" "𝑽" nil :system t)
    ("\\MIW" "𝑾" nil :system t)
    ("\\MIX" "𝑿" nil :system t)
    ("\\MIY" "𝒀" nil :system t)
    ("\\MIZ" "𝒁" nil :system t)
    ("\\MIa" "𝒂" nil :system t)
    ("\\MIb" "𝒃" nil :system t)
    ("\\MIc" "𝒄" nil :system t)
    ("\\MId" "𝒅" nil :system t)
    ("\\MIe" "𝒆" nil :system t)
    ("\\MIf" "𝒇" nil :system t)
    ("\\MIg" "𝒈" nil :system t)
    ("\\MIh" "𝒉" nil :system t)
    ("\\MIi" "𝒊" nil :system t)
    ("\\MIj" "𝒋" nil :system t)
    ("\\MIk" "𝒌" nil :system t)
    ("\\MIl" "𝒍" nil :system t)
    ("\\MIm" "𝒎" nil :system t)
    ("\\MIn" "𝒏" nil :system t)
    ("\\MIo" "𝒐" nil :system t)
    ("\\MIp" "𝒑" nil :system t)
    ("\\MIq" "𝒒" nil :system t)
    ("\\MIr" "𝒓" nil :system t)
    ("\\MIs" "𝒔" nil :system t)
    ("\\MIt" "𝒕" nil :system t)
    ("\\MIu" "𝒖" nil :system t)
    ("\\MIv" "𝒗" nil :system t)
    ("\\MIw" "𝒘" nil :system t)
    ("\\MIx" "𝒙" nil :system t)
    ("\\MIy" "𝒚" nil :system t)
    ("\\MIz" "𝒛" nil :system t)
    ("\\McA" "𝒜" nil :system t)
    ("\\McB" "ℬ" nil :system t)
    ("\\McC" "𝒞" nil :system t)
    ("\\McD" "𝒟" nil :system t)
    ("\\McE" "ℰ" nil :system t)
    ("\\McF" "ℱ" nil :system t)
    ("\\McG" "𝒢" nil :system t)
    ("\\McH" "ℋ" nil :system t)
    ("\\McI" "ℐ" nil :system t)
    ("\\McJ" "𝒥" nil :system t)
    ("\\McK" "𝒦" nil :system t)
    ("\\McL" "ℒ" nil :system t)
    ("\\McM" "ℳ" nil :system t)
    ("\\McN" "𝒩" nil :system t)
    ("\\McO" "𝒪" nil :system t)
    ("\\McP" "𝒫" nil :system t)
    ("\\McQ" "𝒬" nil :system t)
    ("\\McR" "ℛ" nil :system t)
    ("\\McS" "𝒮" nil :system t)
    ("\\McT" "𝒯" nil :system t)
    ("\\McU" "𝒰" nil :system t)
    ("\\McV" "𝒱" nil :system t)
    ("\\McW" "𝒲" nil :system t)
    ("\\McX" "𝒳" nil :system t)
    ("\\McY" "𝒴" nil :system t)
    ("\\McZ" "𝒵" nil :system t)
    ("\\Mca" "𝒶" nil :system t)
    ("\\Mcb" "𝒷" nil :system t)
    ("\\Mcc" "𝒸" nil :system t)
    ("\\Mcd" "𝒹" nil :system t)
    ("\\Mce" "ℯ" nil :system t)
    ("\\Mcf" "𝒻" nil :system t)
    ("\\Mcg" "ℊ" nil :system t)
    ("\\Mch" "𝒽" nil :system t)
    ("\\Mci" "𝒾" nil :system t)
    ("\\Mcj" "𝒿" nil :system t)
    ("\\Mck" "𝓀" nil :system t)
    ("\\Mcl" "𝓁" nil :system t)
    ("\\Mcm" "𝓂" nil :system t)
    ("\\Mcn" "𝓃" nil :system t)
    ("\\Mco" "ℴ" nil :system t)
    ("\\Mcp" "𝓅" nil :system t)
    ("\\Mcq" "𝓆" nil :system t)
    ("\\Mcr" "𝓇" nil :system t)
    ("\\Mcs" "𝓈" nil :system t)
    ("\\Mct" "𝓉" nil :system t)
    ("\\Mcu" "𝓊" nil :system t)
    ("\\Mcv" "𝓋" nil :system t)
    ("\\Mcw" "𝓌" nil :system t)
    ("\\Mcx" "𝓍" nil :system t)
    ("\\Mcy" "𝓎" nil :system t)
    ("\\Mcz" "𝓏" nil :system t)
    ("\\MCA" "𝓐" nil :system t)
    ("\\MCB" "𝓑" nil :system t)
    ("\\MCC" "𝓒" nil :system t)
    ("\\MCD" "𝓓" nil :system t)
    ("\\MCE" "𝓔" nil :system t)
    ("\\MCF" "𝓕" nil :system t)
    ("\\MCG" "𝓖" nil :system t)
    ("\\MCH" "𝓗" nil :system t)
    ("\\MCI" "𝓘" nil :system t)
    ("\\MCJ" "𝓙" nil :system t)
    ("\\MCK" "𝓚" nil :system t)
    ("\\MCL" "𝓛" nil :system t)
    ("\\MCM" "𝓜" nil :system t)
    ("\\MCN" "𝓝" nil :system t)
    ("\\MCO" "𝓞" nil :system t)
    ("\\MCP" "𝓟" nil :system t)
    ("\\MCQ" "𝓠" nil :system t)
    ("\\MCR" "𝓡" nil :system t)
    ("\\MCS" "𝓢" nil :system t)
    ("\\MCT" "𝓣" nil :system t)
    ("\\MCU" "𝓤" nil :system t)
    ("\\MCV" "𝓥" nil :system t)
    ("\\MCW" "𝓦" nil :system t)
    ("\\MCX" "𝓧" nil :system t)
    ("\\MCY" "𝓨" nil :system t)
    ("\\MCZ" "𝓩" nil :system t)
    ("\\MCa" "𝓪" nil :system t)
    ("\\MCb" "𝓫" nil :system t)
    ("\\MCc" "𝓬" nil :system t)
    ("\\MCd" "𝓭" nil :system t)
    ("\\MCe" "𝓮" nil :system t)
    ("\\MCf" "𝓯" nil :system t)
    ("\\MCg" "𝓰" nil :system t)
    ("\\MCh" "𝓱" nil :system t)
    ("\\MCi" "𝓲" nil :system t)
    ("\\MCj" "𝓳" nil :system t)
    ("\\MCk" "𝓴" nil :system t)
    ("\\MCl" "𝓵" nil :system t)
    ("\\MCm" "𝓶" nil :system t)
    ("\\MCn" "𝓷" nil :system t)
    ("\\MCo" "𝓸" nil :system t)
    ("\\MCp" "𝓹" nil :system t)
    ("\\MCq" "𝓺" nil :system t)
    ("\\MCr" "𝓻" nil :system t)
    ("\\MCs" "𝓼" nil :system t)
    ("\\MCt" "𝓽" nil :system t)
    ("\\MCu" "𝓾" nil :system t)
    ("\\MCv" "𝓿" nil :system t)
    ("\\MCw" "𝔀" nil :system t)
    ("\\MCx" "𝔁" nil :system t)
    ("\\MCy" "𝔂" nil :system t)
    ("\\MCz" "𝔃" nil :system t)
    ("\\MfA" "𝔄" nil :system t)
    ("\\MfB" "𝔅" nil :system t)
    ("\\MfC" "ℭ" nil :system t)
    ("\\MfD" "𝔇" nil :system t)
    ("\\MfE" "𝔈" nil :system t)
    ("\\MfF" "𝔉" nil :system t)
    ("\\MfG" "𝔊" nil :system t)
    ("\\MfH" "ℌ" nil :system t)
    ("\\MfI" "ℑ" nil :system t)
    ("\\MfJ" "𝔍" nil :system t)
    ("\\MfK" "𝔎" nil :system t)
    ("\\MfL" "𝔏" nil :system t)
    ("\\MfM" "𝔐" nil :system t)
    ("\\MfN" "𝔑" nil :system t)
    ("\\MfO" "𝔒" nil :system t)
    ("\\MfP" "𝔓" nil :system t)
    ("\\MfQ" "𝔔" nil :system t)
    ("\\MfR" "ℜ" nil :system t)
    ("\\MfS" "𝔖" nil :system t)
    ("\\MfT" "𝔗" nil :system t)
    ("\\MfU" "𝔘" nil :system t)
    ("\\MfV" "𝔙" nil :system t)
    ("\\MfW" "𝔚" nil :system t)
    ("\\MfX" "𝔛" nil :system t)
    ("\\MfY" "𝔜" nil :system t)
    ("\\MfZ" "ℨ" nil :system t)
    ("\\Mfa" "𝔞" nil :system t)
    ("\\Mfb" "𝔟" nil :system t)
    ("\\Mfc" "𝔠" nil :system t)
    ("\\Mfd" "𝔡" nil :system t)
    ("\\Mfe" "𝔢" nil :system t)
    ("\\Mff" "𝔣" nil :system t)
    ("\\Mfg" "𝔤" nil :system t)
    ("\\Mfh" "𝔥" nil :system t)
    ("\\Mfi" "𝔦" nil :system t)
    ("\\Mfj" "𝔧" nil :system t)
    ("\\Mfk" "𝔨" nil :system t)
    ("\\Mfl" "𝔩" nil :system t)
    ("\\Mfm" "𝔪" nil :system t)
    ("\\Mfn" "𝔫" nil :system t)
    ("\\Mfo" "𝔬" nil :system t)
    ("\\Mfp" "𝔭" nil :system t)
    ("\\Mfq" "𝔮" nil :system t)
    ("\\Mfr" "𝔯" nil :system t)
    ("\\Mfs" "𝔰" nil :system t)
    ("\\Mft" "𝔱" nil :system t)
    ("\\Mfu" "𝔲" nil :system t)
    ("\\Mfv" "𝔳" nil :system t)
    ("\\Mfw" "𝔴" nil :system t)
    ("\\Mfx" "𝔵" nil :system t)
    ("\\Mfy" "𝔶" nil :system t)
    ("\\Mfz" "𝔷" nil :system t)
    ("\\yen" "¥" nil :system t)
    ("\\varrho" "ϱ" nil :system t)
    ("\\varkappa" "ϰ" nil :system t)
    ("\\varkai" "ϗ" nil :system t)
    ("\\varnothing" "∅" nil :system t)
    ("\\varpi" "ϖ" nil :system t)
    ("\\varphi" "ϕ" nil :system t)
    ("\\varprime" "′" nil :system t)
    ("\\varpropto" "∝" nil :system t)
    ("\\vartheta" "ϑ" nil :system t)
    ("\\vartriangleleft" "⊲" nil :system t)
    ("\\vartriangleright" "⊳" nil :system t)
    ("\\varbeta" "ϐ" nil :system t)
    ("\\varsigma" "ς" nil :system t)
    ("\\veebar" "⊻" nil :system t)
    ("\\vee" "∨" nil :system t)
    ("\\ve" "ě" nil :system t)
    ("\\vE" "Ě" nil :system t)
    ("\\vdash" "⊢" nil :system t)
    ("\\vdots" "⋮" nil :system t)
    ("\\vd" "ď" nil :system t)
    ("\\vDash" "⊨" nil :system t)
    ("\\vD" "Ď" nil :system t)
    ("\\vc" "č" nil :system t)
    ("\\vC" "Č" nil :system t)
    ("\\koppa" "ϟ" nil :system t)
    ("\\kip" "₭" nil :system t)
    ("\\ki" "į" nil :system t)
    ("\\kI" "Į" nil :system t)
    ("\\kelvin" "K" nil :system t)
    ("\\kappa" "κ" nil :system t)
    ("\\khei" "ϧ" nil :system t)
    ("\\warning" "⚠" nil :system t)
    ("\\won" "₩" nil :system t)
    ("\\wedge" "∧" nil :system t)
    ("\\wp" "℘" nil :system t)
    ("\\wr" "≀" nil :system t)
    ("\\Dei" "Ϯ" nil :system t)
    ("\\Delta" "Δ" nil :system t)
    ("\\Digamma" "Ϝ" nil :system t)
    ("\\Diamond" "◇" nil :system t)
    ("\\Downarrow" "⇓" nil :system t)
    ("\\DH" "Ð" nil :system t)
    ("\\zeta" "ζ" nil :system t)
    ("\\Eta" "Η" nil :system t)
    ("\\Epsilon" "Ε" nil :system t)
    ("\\Beta" "Β" nil :system t)
    ("\\Box" "□" nil :system t)
    ("\\Bumpeq" "≎" nil :system t)
    ("\\bbA" "𝔸" nil :system t)
    ("\\bbB" "𝔹" nil :system t)
    ("\\bbC" "ℂ" nil :system t)
    ("\\bbD" "𝔻" nil :system t)
    ("\\bbE" "𝔼" nil :system t)
    ("\\bbF" "𝔽" nil :system t)
    ("\\bbG" "𝔾" nil :system t)
    ("\\bbH" "ℍ" nil :system t)
    ("\\bbI" "𝕀" nil :system t)
    ("\\bbJ" "𝕁" nil :system t)
    ("\\bbK" "𝕂" nil :system t)
    ("\\bbL" "𝕃" nil :system t)
    ("\\bbM" "𝕄" nil :system t)
    ("\\bbN" "ℕ" nil :system t)
    ("\\bbO" "𝕆" nil :system t)
    ("\\bbP" "ℙ" nil :system t)
    ("\\bbQ" "ℚ" nil :system t)
    ("\\bbR" "ℝ" nil :system t)
    ("\\bbS" "𝕊" nil :system t)
    ("\\bbT" "𝕋" nil :system t)
    ("\\bbU" "𝕌" nil :system t)
    ("\\bbV" "𝕍" nil :system t)
    ("\\bbW" "𝕎" nil :system t)
    ("\\bbX" "𝕏" nil :system t)
    ("\\bbY" "𝕐" nil :system t)
    ("\\bbZ" "ℤ" nil :system t)
    ("\\bba" "𝕒" nil :system t)
    ("\\bbb" "𝕓" nil :system t)
    ("\\bbc" "𝕔" nil :system t)
    ("\\bbd" "𝕕" nil :system t)
    ("\\bbe" "𝕖" nil :system t)
    ("\\bbf" "𝕗" nil :system t)
    ("\\bbg" "𝕘" nil :system t)
    ("\\bbh" "𝕙" nil :system t)
    ("\\bbi" "𝕚" nil :system t)
    ("\\bbj" "𝕛" nil :system t)
    ("\\bbk" "𝕜" nil :system t)
    ("\\bbl" "𝕝" nil :system t)
    ("\\bbm" "𝕞" nil :system t)
    ("\\bbn" "𝕟" nil :system t)
    ("\\bbo" "𝕠" nil :system t)
    ("\\bbp" "𝕡" nil :system t)
    ("\\bbq" "𝕢" nil :system t)
    ("\\bbr" "𝕣" nil :system t)
    ("\\bbs" "𝕤" nil :system t)
    ("\\bbt" "𝕥" nil :system t)
    ("\\bbu" "𝕦" nil :system t)
    ("\\bbv" "𝕧" nil :system t)
    ("\\bbw" "𝕨" nil :system t)
    ("\\bbx" "𝕩" nil :system t)
    ("\\bby" "𝕪" nil :system t)
    ("\\bbz" "𝕫" nil :system t)
    ("\\Rge0" "ℝ≥0" nil :system t)
    ("\\R>=0" "ℝ≥0" nil :system t)
    ("\\nnreal" "ℝ≥0" nil :system t)
    ("\\ennreal" "ℝ≥0∞" nil :system t)
    ("\\enat" "ℕ∞" nil :system t)
    ("\\Zsqrt" "ℤ√" nil :system t)
    ("\\zsqrtd" "ℤ√" nil :system t)
    ("\\liel" "⁅" nil :system t)
    ("\\bracketl" "⁅" nil :system t)
    ("\\lier" "⁆" nil :system t)
    ("\\[-" "⁅" nil :system t)
    ("\\-]" "⁆" nil :system t)
    ("\\lsimplex" "⦋" nil :system t)
    ("\\rsimplex" "⦌" nil :system t)
    ("\\bracketr" "⁆" nil :system t)
    ("\\nhds" "𝓝" nil :system t)
    ("\\nbhds" "𝓝" nil :system t)
    ("\\X" "⨯" nil :system t)
    ("\\vectorproduct" "⨯" nil :system t)
    ("\\crossproduct" "⨯" nil :system t)
    ("\\xs" "×ˢ" nil :system t)
    ("\\coprod" "⨿" nil :system t)
    ("\\sigmaobj" "∐" nil :system t)
    ("\\xf" "×ᶠ" nil :system t)
    ("\\exf" "∃ᶠ" nil :system t)
    ("\\c[" "⦃" nil :system t)
    ("\\c]" "⦄" nil :system t)
    ("\\Yot" "Ϳ" nil :system t)
    ("\\goal" "⊢" nil :system t)
    ("\\Vdash" "⊩" nil :system t)
    ("\\Vert" "‖" nil :system t)
    ("\\Vvdash" "⊪" nil :system t)
    ("\\tiny" "⧾" nil :system t)
    ("\\miny" "⧿" nil :system t)
    ("\\heq" "≍" nil :system t)
    ("\\r!" "¡" nil :system t))
  "Abbrev table with singleton abbreviations for `nael-mode'.

All abbreviations expand to single strings.  During expansion, point is
reserved at the end of expansion."
  :regexp nael-abbrev-regexp)

(define-abbrev-table 'nael-abbrev-skeleton-table
  '(("\\{}" "" nael-skeleton-7b7d :system t)
    ("\\{}_" "" nael-skeleton-7b7d5f :system t)
    ("\\{{}}" "" nael-skeleton-7b7b7d7d :system t)
    ("\\[]" "" nael-skeleton-5b5d :system t)
    ("\\[]_" "" nael-skeleton-5b5d5f :system t)
    ("\\[[]]" "" nael-skeleton-5b5b5d5d :system t)
    ("\\<>" "" nael-skeleton-3c3e :system t)
    ("\\()" "" nael-skeleton-2829 :system t)
    ("\\()_" "" nael-skeleton-28295f :system t)
    ("\\([])'" "" nael-skeleton-285b5d2927 :system t)
    ("\\(())" "" nael-skeleton-28282929 :system t)
    ("\\f<>" "" nael-skeleton-663c3e :system t)
    ("\\f<<>>" "" nael-skeleton-663c3c3e3e :system t)
    ("\\[--]" "" nael-skeleton-5b2d2d5d :system t)
    ("\\||||" "" nael-skeleton-7c7c7c7c :system t)
    ("\\nnnorm" "" nael-skeleton-6e6e6e6f726d :system t)
    ("\\norm" "" nael-skeleton-6e6f726d :system t)
    ("\\floor" "" nael-skeleton-666c6f6f72 :system t)
    ("\\ceil" "" nael-skeleton-6365696c :system t)
    ("\\nfloor" "" nael-skeleton-6e666c6f6f72 :system t)
    ("\\nceil" "" nael-skeleton-6e6365696c :system t)
    ("\\s[]" "" nael-skeleton-735b5d :system t)
    ("\\simplex" "" nael-skeleton-73696d706c6578 :system t))
  "Abbrev table with Skeleton abbreviations for `nael-mode'.

All abbreviations expand to two strings with point being placed between
the left and the right part.  The name is derived from `skeleton', a
built-in Emacs package used to implement this class of abbreviations."
  :regexp nael-abbrev-regexp)

(define-abbrev-table 'nael-abbrev-table
  nil
"Abbrev table for `nael-mode'.

It includes both singleton abbreviations that expand to single strings,
as well as Skeleton abbreviations that expand to two strings, with point
being placed between the left and the right part."
  :regexp nael-abbrev-regexp
  :parents (list nael-abbrev-singleton-table
                 nael-abbrev-skeleton-table))

(defcustom nael-abbrev-configure-table nael-abbrev-table
  "Abbrev table activated by `nael-abbrev-configure'.
When nil, no Abbrev table will be activated."
  :type '(choice (const :tag "Do not activate any Abbrev table" nil)
                 (sexp :tag "Activate an Abbrev table"))
  :options '( nael-abbrev-table
              nael-abbrev-singleton-table
              nael-abbrev-skeleton-table)
  :group 'nael-abbrev)

;;;; Completion at point function (CAPF):

(defcustom nael-abbrev-capf t
  "Whether to set up function `nael-abbrev-capf' as CAPF buffer-locally."
  :type 'boolean
  :group 'nael-abbrev)

(defun nael-abbrev-capf-exit (_string status)
  "Exit CAPF by expanding the abbrev unless completion might continue.

When STATUS is `exact', the user might continue the completion, so we
should not exit."
  (unless (eq status 'exact)
    (expand-abbrev)))

(defun nael-abbrev-capf-annotation (abbrev)
  "Annotate ABBREV with its expansion."
  (truncate-string-to-width (abbrev-expansion abbrev) 30 0 nil t))

(defvar nael-abbrev-capf-properties
  (list :annotation-function #'nael-abbrev-capf-annotation
        :category 'nael-abbrev
        :exclusive 'no
        :exit-function #'nael-abbrev-capf-exit)
  "Completion properties for function `nael-abbrev-capf'.

See `completion-at-point-functions'.")

(defvar nael-abbrev-capf-cache nil
  "Cache used to speed up function `nael-abbrev-capf'.")

(defun nael-abbrev-capf-reset ()
  "Wipe cache of function `nael-abbrev-capf'.

As a consequence, this forces recollection of abbreviations later on."
  (interactive)
  (setq nael-abbrev-capf-cache nil))

(defun nael-abbrev-table-ancestors (tables)
  "List of TABLES and their recursive ancestors."
  (when tables
    (let (ancestors)
      (while-let ((table (pop tables)))
        (dolist (parent (cons table
                              (abbrev-table-get table :parents)))
          (cl-pushnew parent ancestors)))
      ancestors)))

(defun nael-abbrev-capf-collect ()
  "From active Abbrev tables, collect all abbreviations.

Returns an obarray whose symbol names are abbreviations.

Since CAPFs should be cheap to compute, this uses a cache.  The keys is
just the list of active tables given per `abbrev--active-tables',
compared with `equal'.  This should be fine because Abbrev tables are
not expected to be modified frequently.  If needed, the cache can be
reset with `nael-abbrev-capf-reset'."
  (let ((tbls (abbrev--active-tables)))
    (or (alist-get tbls nael-abbrev-capf-cache nil nil #'equal)
        (setf (alist-get tbls nael-abbrev-capf-cache nil nil #'equal)
              (let ((abbrevs (obarray-make)))
                (dolist (tbl (nael-abbrev-table-ancestors tbls))
                  (mapatoms (lambda (abbrev)
                              (intern (symbol-name abbrev) abbrevs))
                            tbl))
                abbrevs)))))

(defun nael-abbrev-capf ()
  "Complete Nael abbreviation at point.

If the text before point matches `nael-abbrev-regexp', provide
completion at point."
  (save-match-data
    (when (looking-back nael-abbrev-regexp (line-beginning-position))
      (append (list (match-beginning 0)
                    (match-end 0)
                    (nael-abbrev-capf-collect))
              nael-abbrev-capf-properties))))

;;;; Help at point:

(defface nael-abbrev-help-point '((t :box 1))
  "Face of character where point would be positioned after expansion."
  :group 'nael-abbrev)

(defface nael-abbrev-help-abbrev '((t :inherit help-key-binding))
  "Face of abbreviation."
  :group 'nael-abbrev)

(defun nael-abbrev-help-lookup (tables query)
  "Accumulate pairs of abbrevs and expansions matching QUERY in TABLES."
  (let (matches)
    (dolist (table tables)
      (mapatoms
       (lambda (sym)
         (when-let*
             ((expansion
               (or (when-let* ((val (symbol-value sym))
                               ((equal query val)))
                     val)
                   (when-let* ((fun (symbol-function sym)))
                     (with-temp-buffer
                       (funcall fun)
                       (set-text-properties (point-min) (point-max)
                                            nil)
                       (when (member
                              query
                              (list (buffer-substring (point-min)
                                                      (point))
                                    (buffer-substring (point)
                                                      (point-max))
                                    (buffer-substring (point-min)
                                                      (point-max))))
                         (unless (eobp)
                           (put-text-property
                            (point) (1+ (point)) 'face
                            'nael-abbrev-help-point))
                         (buffer-substring (point-min)
                                           (point-max)))))))
              (abbrev (symbol-name sym))
              ((not (string-empty-p abbrev))))
           (push (cons (propertize abbrev
                                   'face 'nael-abbrev-help-abbrev)
                       expansion)
                 matches)))
       table))
    matches))

;;;###autoload
(defun nael-abbrev-help (&optional beg end)
  "Echo abbreviations for region (from BEG to END) or character at point.

When region is usable (`use-region-p'), act on string in region.  When
there is a character after point, act on in it as string.

Reverse lookup this query string in all active abbrev
tables (`abbrev--active-tables') and echo all abbreviations with a
matching expansion.  For abbrevs based on functions, e.g. Skeletons, the
function will be called before matching the query against the resulting
expansion to the left of point, to its right, or the whole expansion.

This command is inspired by `quail-show-key'."
  (interactive)
  (if-let* ((noregion (not (use-region-p))) ((eobp)))
      (message "No character after point and no usable region")
    (if noregion
        (setq beg (point) end (1+ (point)))
      ;; Because (interactive "r") fails when no mark has ever been
      ;; set in the current buffer, we set the region bounds manually.
      (setq beg (region-beginning) end (region-end)))
    (if-let* ((query (buffer-substring-no-properties beg end))
              (tables (nael-abbrev-table-ancestors
                       (abbrev--active-tables)))
              (pairs (nael-abbrev-help-lookup tables query))
              (max (apply #'max (mapcar (lambda (pair)
                                          (string-width (car pair)))
                                        pairs))))
        (message (string-join
                  (mapcar (lambda (pair)
                            (concat (string-pad (car pair) max)
                                    " abbreviates " (cdr pair)))
                          pairs)
                  "
"))
      (message "No abbreviation known for `%s'"
               ;; Avoid newlines in echo area, when either character
               ;; at point is newline or multi-line region is active.
               (string-replace "
" "\n" query)))))

;;;; Expansion and Configuration:

(defun nael-abbrev-expand ()
  "Expand symbol-including abbreviation before point."
  (and abbrev-mode
       (string-match-p "[^ -#&-+.-:<-?A-~-]"
                       (char-to-string last-command-event))
       (let ((pt (point))) (backward-char)
            (unless (expand-abbrev)
              (goto-char pt)))))

;;;###autoload
(defun nael-abbrev-configure ()
  "Configure `abbrev-mode' for `nael-mode'.

Buffer-locally sets `local-abbrev-table' to
`nael-abbrev-configure-table' and adds `nael-abbrev-expand' to
`post-self-insert-hook' so that symbol-including abbreviations are
expanded whenever suitable characters are inserted."
  (when nael-abbrev-table
    (setq-local local-abbrev-table nael-abbrev-table))
  (add-hook 'post-self-insert-hook
            #'nael-abbrev-expand nil 'local)
  (when nael-abbrev-capf
    (add-hook 'completion-at-point-functions
              #'nael-abbrev-capf nil 'local)))

(provide 'nael-abbrev)

;;; nael-abbrev.el ends here

;; Local Variables:
;; buffer-read-only: t
;; End:
