;;; fedi-iso.el --- ISO language code lists for fedi.el  -*- lexical-binding: t -*-

;; Copyright (C) 2022 Marty Hiatt
;; Author: Marty Hiatt <martianhiatus@riseup.net>
;; Homepage: https://codeberg.org/martianh/fedi.el

;; This file is not part of GNU Emacs.

;; This file is part of fedi.el.

;; fedi.el is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; fedi.el is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with fedi.el.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;;; Code:

;; via
;; https://github.com/VyrCossont/mastodon/blob/0836f4a656d5486784cadfd7d0cd717bb67ede4c/app/helpers/languages_helper.rb
;; and
;; https://github.com/Shinmera/language-codes/blob/master/data/iso-639-3.lisp

(defvar fedi-iso-639-1
  '(("Abkhazian" . "ab")
    ("Afar" . "aa")
    ("Afrikaans" . "af")
    ("Akan" . "ak")
    ("Albanian" . "sq")
    ("Amharic" . "am")
    ("Arabic" . "ar")
    ("Aragonese" . "an")
    ("Armenian" . "hy")
    ("Assamese" . "as")
    ("Avaric" . "av")
    ("Avestan" . "ae")
    ("Aymara" . "ay")
    ("Azerbaijani" . "az")
    ("Bambara" . "bm")
    ("Bashkir" . "ba")
    ("Basque" . "eu")
    ("Belarusian" . "be")
    ("Bengali" . "bn")
    ("Bihari languages" . "bh")
    ("Bislama" . "bi")
    ("Bosnian" . "bs")
    ("Breton" . "br")
    ("Bulgarian" . "bg")
    ("Burmese" . "my")
    ("Central Khmer" . "km")
    ("Chamorro" . "ch")
    ("Chechen" . "ce")
    ("Chinese" . "zh")
    ("Chuvash" . "cv")
    ("Cornish" . "kw")
    ("Corsican" . "co")
    ("Cree" . "cr")
    ("Croatian" . "hr")
    ("Czech" . "cs")
    ("Danish" . "da")
    ("Dzongkha" . "dz")
    ("English" . "en")
    ("Esperanto" . "eo")
    ("Estonian" . "et")
    ("Ewe" . "ee")
    ("Faroese" . "fo")
    ("Fijian" . "fj")
    ("Finnish" . "fi")
    ("Dutch" . "nl")
    ("French" . "fr")
    ("Fulah" . "ff")
    ("Galician" . "gl")
    ("Ganda" . "lg")
    ("Georgian" . "ka")
    ("German" . "de")
    ("Greek" . "el")
    ("Guarani" . "gn")
    ("Gujarati" . "gu")
    ("Haitian" . "ht")
    ("Hausa" . "ha")
    ("Hebrew" . "he")
    ("Herero" . "hz")
    ("Hindi" . "hi")
    ("Hiri Motu" . "ho")
    ("Hungarian" . "hu")
    ("Icelandic" . "is")
    ("Ido" . "io")
    ("Igbo" . "ig")
    ("Indonesian" . "id")
    ("Interlingua" . "ia")
    ("Inuktitut" . "iu")
    ("Inupiaq" . "ik")
    ("Irish" . "ga")
    ("Italian" . "it")
    ("Japanese" . "ja")
    ("Japanese" . "jp")
    ("Javanese" . "jv")
    ("Kalaallisut" . "kl")
    ("Kannada" . "kn")
    ("Kanuri" . "kr")
    ("Kashmiri" . "ks")
    ("Kazakh" . "kk")
    ("Kikuyu" . "ki")
    ("Kinyarwanda" . "rw")
    ("Komi" . "kv")
    ("Kongo" . "kg")
    ("Korean" . "ko")
    ("Kurdish" . "ku")
    ("Kuanyama" . "kj")
    ("Kirghiz" . "ky")
    ("Lao" . "lo")
    ("Latin" . "la")
    ("Latvian" . "lv")
    ("Limburgan" . "li")
    ("Lingala" . "ln")
    ("Lithuanian" . "lt")
    ("Luba-Katanga" . "lu")
    ("Luxembourgish" . "lb")
    ("Macedonian" . "mk")
    ("Malagasy" . "mg")
    ("Malay" . "ms")
    ("Malayalam" . "ml")
    ("Divehi" . "dv")
    ("Maltese" . "mt")
    ("Manx" . "gv")
    ("Maori" . "mi")
    ("Marathi" . "mr")
    ("Marshallese" . "mh")
    ("Mongolian" . "mn")
    ("Nauru" . "na")
    ("Navajo" . "nv")
    ("Ndonga" . "ng")
    ("Nepali" . "ne")
    ("Ndebele, North" . "nd")
    ("Northern Sami" . "se")
    ("Norwegian" . "no")
    ("Bokmål, Norwegian" . "nb")
    ("Chichewa" . "ny")
    ("Norwegian Nynorsk" . "nn")
    ("Interlingue" . "ie")
    ("Occitan" . "oc")
    ("Ojibwa" . "oj")
    ("Church Slavic" . "cu")
    ("Oriya" . "or")
    ("Oromo" . "om")
    ("Ossetian" . "os")
    ("Pali" . "pi")
    ("Persian" . "fa")
    ("Polish" . "pl")
    ("Portuguese" . "pt")
    ("Panjabi" . "pa")
    ("Pushto" . "ps")
    ("Quechua" . "qu")
    ("Romanian" . "ro")
    ("Romansh" . "rm")
    ("Rundi" . "rn")
    ("Russian" . "ru")
    ("Samoan" . "sm")
    ("Sango" . "sg")
    ("Sanskrit" . "sa")
    ("Sardinian" . "sc")
    ("Gaelic" . "gd")
    ("Serbian" . "sr")
    ("Shona" . "sn")
    ("Sichuan Yi" . "ii")
    ("Sindhi" . "sd")
    ("Sinhala" . "si")
    ("Slovak" . "sk")
    ("Slovenian" . "sl")
    ("Somali" . "so")
    ("Sotho, Southern" . "st")
    ("Ndebele, South" . "nr")
    ("Spanish" . "es")
    ("Sundanese" . "su")
    ("Swahili" . "sw")
    ("Swati" . "ss")
    ("Swedish" . "sv")
    ("Tagalog" . "tl")
    ("Tahitian" . "ty")
    ("Tajik" . "tg")
    ("Tamil" . "ta")
    ("Tatar" . "tt")
    ("Telugu" . "te")
    ("Thai" . "th")
    ("Tibetan" . "bo")
    ("Tigrinya" . "ti")
    ("Tonga (Tonga Islands)" . "to")
    ("Tsonga" . "ts")
    ("Tswana" . "tn")
    ("Turkish" . "tr")
    ("Turkmen" . "tk")
    ("Twi" . "tw")
    ("Ukrainian" . "uk")
    ("Urdu" . "ur")
    ("Uighur" . "ug")
    ("Uzbek" . "uz")
    ("Catalan" . "ca")
    ("Venda" . "ve")
    ("Vietnamese" . "vi")
    ("Volapük" . "vo")
    ("Walloon" . "wa")
    ("Welsh" . "cy")
    ("Western Frisian" . "fy")
    ("Wolof" . "wo")
    ("Xhosa" . "xh")
    ("Yiddish" . "yi")
    ("Yoruba" . "yo")
    ("Zhuang" . "za")
    ("Zulu" . "zu")))

;; web UI doesn't respect these for now
(defvar fedi-iso-639-regional
  '(("es-AR" "Español (Argentina)")
    ("es-MX" "Español (México)")
    ("pt-BR" "Português (Brasil)")
    ("pt-PT" "Português (Portugal)")
    ("sr-Latn" "Srpski (latinica)")
    ("zh-CN" "简体中文")
    ("zh-HK" "繁體中文（香港）")
    ("zh-TW" "繁體中文（臺灣）")))

(defvar fedi-iso-639-3
  '(("ast" "Asturian" "Asturianu")
    ("ckb" "Sorani (Kurdish)" "سۆرانی")
    ("jbo" "Lojban" "la .lojban.")
    ("kab" "Kabyle" "Taqbaylit")
    ("kmr" "Kurmanji (Kurdish)" "Kurmancî")
    ("ldn" "Láadan" "Láadan")
    ("lfn" "Lingua Franca Nova" "lingua franca nova")
    ("tok" "Toki Pona" "toki pona")
    ("zba" "Balaibalan" "باليبلن")
    ("zgh" "Standard Moroccan Tamazight" "ⵜⴰⵎⴰⵣⵉⵖⵜ")))

(provide 'fedi-iso)
;;; fedi-iso.el ends here
