;;; evil-collection-org-roam.el --- Bindings for `org-roam' -*- lexical-binding: t -*-

;; Copyright (C) 2022 James Nguyen

;; Author: James Nguyen <james@jojojames.com>
;; Maintainer: James Nguyen <james@jojojames.com>
;; URL: https://github.com/emacs-evil/evil-collection
;; Version: 0.0.2
;; Package-Requires: ((emacs "27.1"))
;; Keywords: evil, emacs, convenience, tools

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:
;;; Bindings for org-roam.

;;; Code:
(require 'evil-collection)
(require 'org-roam nil t)

(defvar org-roam-mode-map)
(defconst evil-collection-org-roam-maps '(org-roam-grep-map
                                          org-roam-mode-map
                                          org-roam-node-map
                                          org-roam-preview-map))

(defun evil-collection-org-roam-setup ()
  "Set up `evil' bindings for org-roam."
  (evil-collection-define-key 'normal 'org-roam-mode-map
    [C-return]  'org-roam-buffer-visit-thing
    (kbd "C-m") 'org-roam-buffer-visit-thing
    [remap revert-buffer] 'org-roam-buffer-refresh
    "gr" 'org-roam-buffer-refresh)

  (evil-collection-define-key 'normal 'org-roam-node-map
    [remap org-roam-buffer-visit-thing] 'org-roam-node-visit)

  (evil-collection-define-key 'normal 'org-roam-preview-map
    [remap org-roam-buffer-visit-thing] 'org-roam-preview-visit)

  (evil-collection-define-key 'normal 'org-roam-grep-map
    [remap org-roam-buffer-visit-thing] 'org-roam-grep-visit))

(provide 'evil-collection-org-roam)
;;; evil-collection-org-roam.el ends here
