;;; evil-digraphs.el --- Digraphs -*- lexical-binding: t -*-

;; Author: Vegard Øye <vegard_oye at hotmail.com>
;; Maintainer: Vegard Øye <vegard_oye at hotmail.com>


;;
;; This file is NOT part of GNU Emacs.

;;; License:

;; This file is part of Evil.
;;
;; Evil is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; Evil is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with Evil.  If not, see <http://www.gnu.org/licenses/>.

(require 'evil-vars)

;;; Code:

(defgroup evil-digraphs nil
  "Digraph support based on RFC 1345."
  :group 'evil
  :prefix "evil-digraph-")

(defcustom evil-digraphs-table-user nil
  "List of user-defined digraphs.
Entries have the form ((?CHAR1 ?CHAR2) . ?DIGRAPH).  That is,
a cons cell of the digraph and its character replacement,
where the digraph is a list of two characters.
See also `evil-digraphs-table'."
  :type '(alist :key-type (list character character)
                :value-type character)
  :require 'evil-digraphs
  :group 'evil-digraphs)

(defconst evil-digraphs-table
  '(((?N ?U) . ?\x00)
    ((?S ?H) . ?\x01)
    ((?S ?X) . ?\x02)
    ((?E ?X) . ?\x03)
    ((?E ?T) . ?\x04)
    ((?E ?Q) . ?\x05)
    ((?A ?K) . ?\x06)
    ((?B ?L) . ?\x07)
    ((?B ?S) . ?\x08)
    ((?H ?T) . ?\x09)
    ((?L ?F) . ?\x0a)
    ((?V ?T) . ?\x0b)
    ((?F ?F) . ?\x0c)
    ((?C ?R) . ?\x0d)
    ((?S ?O) . ?\x0e)
    ((?S ?I) . ?\x0f)
    ((?D ?L) . ?\x10)
    ((?D ?1) . ?\x11)
    ((?D ?2) . ?\x12)
    ((?D ?3) . ?\x13)
    ((?D ?4) . ?\x14)
    ((?N ?K) . ?\x15)
    ((?S ?Y) . ?\x16)
    ((?E ?B) . ?\x17)
    ((?C ?N) . ?\x18)
    ((?E ?M) . ?\x19)
    ((?S ?B) . ?\x1a)
    ((?E ?C) . ?\x1b)
    ((?F ?S) . ?\x1c)
    ((?G ?S) . ?\x1d)
    ((?R ?S) . ?\x1e)
    ((?U ?S) . ?\x1f)
    ((?S ?P) . ?\x20)
    ((?N ?b) . ?\x23)
    ((?D ?O) . ?\x24)
    ((?A ?t) . ?\x40)
    ((?< ?\() . ?\x5b)
    ((?/ ?/) . ?\x5c)
    ((?\) ?>) . ?\x5d)
    ((?' ?>) . ?\x5e)
    ((?' ?!) . ?\x60)
    ((?\( ?!) . ?\x7b)
    ((?! ?!) . ?\x7c)
    ((?! ?\)) . ?\x7d)
    ((?' ??) . ?\x7e)
    ((?D ?T) . ?\x7f)
    ((?P ?A) . ?\x80)
    ((?H ?O) . ?\x81)
    ((?B ?H) . ?\x82)
    ((?N ?H) . ?\x83)
    ((?I ?N) . ?\x84)
    ((?N ?L) . ?\x85)
    ((?S ?A) . ?\x86)
    ((?E ?S) . ?\x87)
    ((?H ?S) . ?\x88)
    ((?H ?J) . ?\x89)
    ((?V ?S) . ?\x8a)
    ((?P ?D) . ?\x8b)
    ((?P ?U) . ?\x8c)
    ((?R ?I) . ?\x8d)
    ((?S ?2) . ?\x8e)
    ((?S ?3) . ?\x8f)
    ((?D ?C) . ?\x90)
    ((?P ?1) . ?\x91)
    ((?P ?2) . ?\x92)
    ((?T ?S) . ?\x93)
    ((?C ?C) . ?\x94)
    ((?M ?W) . ?\x95)
    ((?S ?G) . ?\x96)
    ((?E ?G) . ?\x97)
    ((?S ?S) . ?\x98)
    ((?G ?C) . ?\x99)
    ((?S ?C) . ?\x9a)
    ((?C ?I) . ?\x9b)
    ((?S ?T) . ?\x9c)
    ((?O ?C) . ?\x9d)
    ((?P ?M) . ?\x9e)
    ((?A ?C) . ?\x9f)
    ((?N ?S) . ?\xa0)
    ((?! ?I) . ?\xa1)
    ((?C ?t) . ?\xa2)
    ((?P ?d) . ?\xa3)
    ((?C ?u) . ?\xa4)
    ((?Y ?e) . ?\xa5)
    ((?B ?B) . ?\xa6)
    ((?S ?E) . ?\xa7)
    ((?' ?:) . ?\xa8)
    ((?C ?o) . ?\xa9)
    ((?- ?a) . ?\xaa)
    ((?< ?<) . ?\xab)
    ((?N ?O) . ?\xac)
    ((?- ?-) . ?\xad)
    ((?R ?g) . ?\xae)
    ((?' ?m) . ?\xaf)
    ((?D ?G) . ?\xb0)
    ((?+ ?-) . ?\xb1)
    ((?2 ?S) . ?\xb2)
    ((?3 ?S) . ?\xb3)
    ((?' ?') . ?\xb4)
    ((?M ?y) . ?\xb5)
    ((?P ?I) . ?\xb6)
    ((?. ?M) . ?\xb7)
    ((?' ?,) . ?\xb8)
    ((?1 ?S) . ?\xb9)
    ((?- ?o) . ?\xba)
    ((?> ?>) . ?\xbb)
    ((?1 ?4) . ?\xbc)
    ((?1 ?2) . ?\xbd)
    ((?3 ?4) . ?\xbe)
    ((?? ?I) . ?\xbf)
    ((?A ?!) . ?\xc0)
    ((?A ?') . ?\xc1)
    ((?A ?>) . ?\xc2)
    ((?A ??) . ?\xc3)
    ((?A ?:) . ?\xc4)
    ((?A ?A) . ?\xc5)
    ((?A ?E) . ?\xc6)
    ((?C ?,) . ?\xc7)
    ((?E ?!) . ?\xc8)
    ((?E ?') . ?\xc9)
    ((?E ?>) . ?\xca)
    ((?E ?:) . ?\xcb)
    ((?I ?!) . ?\xcc)
    ((?I ?') . ?\xcd)
    ((?I ?>) . ?\xce)
    ((?I ?:) . ?\xcf)
    ((?D ?-) . ?\xd0)
    ((?N ??) . ?\xd1)
    ((?O ?!) . ?\xd2)
    ((?O ?') . ?\xd3)
    ((?O ?>) . ?\xd4)
    ((?O ??) . ?\xd5)
    ((?O ?:) . ?\xd6)
    ((?* ?X) . ?\xd7)
    ((?O ?/) . ?\xd8)
    ((?U ?!) . ?\xd9)
    ((?U ?') . ?\xda)
    ((?U ?>) . ?\xdb)
    ((?U ?:) . ?\xdc)
    ((?Y ?') . ?\xdd)
    ((?T ?H) . ?\xde)
    ((?s ?s) . ?\xdf)
    ((?a ?!) . ?\xe0)
    ((?a ?') . ?\xe1)
    ((?a ?>) . ?\xe2)
    ((?a ??) . ?\xe3)
    ((?a ?:) . ?\xe4)
    ((?a ?a) . ?\xe5)
    ((?a ?e) . ?\xe6)
    ((?c ?,) . ?\xe7)
    ((?e ?!) . ?\xe8)
    ((?e ?') . ?\xe9)
    ((?e ?>) . ?\xea)
    ((?e ?:) . ?\xeb)
    ((?i ?!) . ?\xec)
    ((?i ?') . ?\xed)
    ((?i ?>) . ?\xee)
    ((?i ?:) . ?\xef)
    ((?d ?-) . ?\xf0)
    ((?n ??) . ?\xf1)
    ((?o ?!) . ?\xf2)
    ((?o ?') . ?\xf3)
    ((?o ?>) . ?\xf4)
    ((?o ??) . ?\xf5)
    ((?o ?:) . ?\xf6)
    ((?- ?:) . ?\xf7)
    ((?o ?/) . ?\xf8)
    ((?u ?!) . ?\xf9)
    ((?u ?') . ?\xfa)
    ((?u ?>) . ?\xfb)
    ((?u ?:) . ?\xfc)
    ((?y ?') . ?\xfd)
    ((?t ?h) . ?\xfe)
    ((?y ?:) . ?\xff)
    ((?A ?-) . ?\x0100)
    ((?a ?-) . ?\x0101)
    ((?A ?\() . ?\x0102)
    ((?a ?\() . ?\x0103)
    ((?A ?\;) . ?\x0104)
    ((?a ?\;) . ?\x0105)
    ((?C ?') . ?\x0106)
    ((?c ?') . ?\x0107)
    ((?C ?>) . ?\x0108)
    ((?c ?>) . ?\x0109)
    ((?C ?.) . ?\x010a)
    ((?c ?.) . ?\x010b)
    ((?C ?<) . ?\x010c)
    ((?c ?<) . ?\x010d)
    ((?D ?<) . ?\x010e)
    ((?d ?<) . ?\x010f)
    ((?D ?/) . ?\x0110)
    ((?d ?/) . ?\x0111)
    ((?E ?-) . ?\x0112)
    ((?e ?-) . ?\x0113)
    ((?E ?\() . ?\x0114)
    ((?e ?\() . ?\x0115)
    ((?E ?.) . ?\x0116)
    ((?e ?.) . ?\x0117)
    ((?E ?\;) . ?\x0118)
    ((?e ?\;) . ?\x0119)
    ((?E ?<) . ?\x011a)
    ((?e ?<) . ?\x011b)
    ((?G ?>) . ?\x011c)
    ((?g ?>) . ?\x011d)
    ((?G ?\() . ?\x011e)
    ((?g ?\() . ?\x011f)
    ((?G ?.) . ?\x0120)
    ((?g ?.) . ?\x0121)
    ((?G ?,) . ?\x0122)
    ((?g ?,) . ?\x0123)
    ((?H ?>) . ?\x0124)
    ((?h ?>) . ?\x0125)
    ((?H ?/) . ?\x0126)
    ((?h ?/) . ?\x0127)
    ((?I ??) . ?\x0128)
    ((?i ??) . ?\x0129)
    ((?I ?-) . ?\x012a)
    ((?i ?-) . ?\x012b)
    ((?I ?\() . ?\x012c)
    ((?i ?\() . ?\x012d)
    ((?I ?\;) . ?\x012e)
    ((?i ?\;) . ?\x012f)
    ((?I ?.) . ?\x0130)
    ((?i ?.) . ?\x0131)
    ((?I ?J) . ?\x0132)
    ((?i ?j) . ?\x0133)
    ((?J ?>) . ?\x0134)
    ((?j ?>) . ?\x0135)
    ((?K ?,) . ?\x0136)
    ((?k ?,) . ?\x0137)
    ((?k ?k) . ?\x0138)
    ((?L ?') . ?\x0139)
    ((?l ?') . ?\x013a)
    ((?L ?,) . ?\x013b)
    ((?l ?,) . ?\x013c)
    ((?L ?<) . ?\x013d)
    ((?l ?<) . ?\x013e)
    ((?L ?.) . ?\x013f)
    ((?l ?.) . ?\x0140)
    ((?L ?/) . ?\x0141)
    ((?l ?/) . ?\x0142)
    ((?N ?') . ?\x0143)
    ((?n ?') . ?\x0144)
    ((?N ?,) . ?\x0145)
    ((?n ?,) . ?\x0146)
    ((?N ?<) . ?\x0147)
    ((?n ?<) . ?\x0148)
    ((?' ?n) . ?\x0149)
    ((?N ?G) . ?\x014a)
    ((?n ?g) . ?\x014b)
    ((?O ?-) . ?\x014c)
    ((?o ?-) . ?\x014d)
    ((?O ?\() . ?\x014e)
    ((?o ?\() . ?\x014f)
    ((?O ?\") . ?\x0150)
    ((?o ?\") . ?\x0151)
    ((?O ?E) . ?\x0152)
    ((?o ?e) . ?\x0153)
    ((?R ?') . ?\x0154)
    ((?r ?') . ?\x0155)
    ((?R ?,) . ?\x0156)
    ((?r ?,) . ?\x0157)
    ((?R ?<) . ?\x0158)
    ((?r ?<) . ?\x0159)
    ((?S ?') . ?\x015a)
    ((?s ?') . ?\x015b)
    ((?S ?>) . ?\x015c)
    ((?s ?>) . ?\x015d)
    ((?S ?,) . ?\x015e)
    ((?s ?,) . ?\x015f)
    ((?S ?<) . ?\x0160)
    ((?s ?<) . ?\x0161)
    ((?T ?,) . ?\x0162)
    ((?t ?,) . ?\x0163)
    ((?T ?<) . ?\x0164)
    ((?t ?<) . ?\x0165)
    ((?T ?/) . ?\x0166)
    ((?t ?/) . ?\x0167)
    ((?U ??) . ?\x0168)
    ((?u ??) . ?\x0169)
    ((?U ?-) . ?\x016a)
    ((?u ?-) . ?\x016b)
    ((?U ?\() . ?\x016c)
    ((?u ?\() . ?\x016d)
    ((?U ?0) . ?\x016e)
    ((?u ?0) . ?\x016f)
    ((?U ?\") . ?\x0170)
    ((?u ?\") . ?\x0171)
    ((?U ?\;) . ?\x0172)
    ((?u ?\;) . ?\x0173)
    ((?W ?>) . ?\x0174)
    ((?w ?>) . ?\x0175)
    ((?Y ?>) . ?\x0176)
    ((?y ?>) . ?\x0177)
    ((?Y ?:) . ?\x0178)
    ((?Z ?') . ?\x0179)
    ((?z ?') . ?\x017a)
    ((?Z ?.) . ?\x017b)
    ((?z ?.) . ?\x017c)
    ((?Z ?<) . ?\x017d)
    ((?z ?<) . ?\x017e)
    ((?O ?9) . ?\x01a0)
    ((?o ?9) . ?\x01a1)
    ((?O ?I) . ?\x01a2)
    ((?o ?i) . ?\x01a3)
    ((?y ?r) . ?\x01a6)
    ((?U ?9) . ?\x01af)
    ((?u ?9) . ?\x01b0)
    ((?Z ?/) . ?\x01b5)
    ((?z ?/) . ?\x01b6)
    ((?E ?D) . ?\x01b7)
    ((?A ?<) . ?\x01cd)
    ((?a ?<) . ?\x01ce)
    ((?I ?<) . ?\x01cf)
    ((?i ?<) . ?\x01d0)
    ((?O ?<) . ?\x01d1)
    ((?o ?<) . ?\x01d2)
    ((?U ?<) . ?\x01d3)
    ((?u ?<) . ?\x01d4)
    ((?A ?1) . ?\x01de)
    ((?a ?1) . ?\x01df)
    ((?A ?7) . ?\x01e0)
    ((?a ?7) . ?\x01e1)
    ((?A ?3) . ?\x01e2)
    ((?a ?3) . ?\x01e3)
    ((?G ?/) . ?\x01e4)
    ((?g ?/) . ?\x01e5)
    ((?G ?<) . ?\x01e6)
    ((?g ?<) . ?\x01e7)
    ((?K ?<) . ?\x01e8)
    ((?k ?<) . ?\x01e9)
    ((?O ?\;) . ?\x01ea)
    ((?o ?\;) . ?\x01eb)
    ((?O ?1) . ?\x01ec)
    ((?o ?1) . ?\x01ed)
    ((?E ?Z) . ?\x01ee)
    ((?e ?z) . ?\x01ef)
    ((?j ?<) . ?\x01f0)
    ((?G ?') . ?\x01f4)
    ((?g ?') . ?\x01f5)
    ((?\; ?S) . ?\x02bf)
    ((?' ?<) . ?\x02c7)
    ((?' ?\() . ?\x02d8)
    ((?' ?.) . ?\x02d9)
    ((?' ?0) . ?\x02da)
    ((?' ?\;) . ?\x02db)
    ((?' ?\") . ?\x02dd)
    ((?A ?%) . ?\x0386)
    ((?E ?%) . ?\x0388)
    ((?Y ?%) . ?\x0389)
    ((?I ?%) . ?\x038a)
    ((?O ?%) . ?\x038c)
    ((?U ?%) . ?\x038e)
    ((?W ?%) . ?\x038f)
    ((?i ?3) . ?\x0390)
    ((?A ?*) . ?\x0391)
    ((?B ?*) . ?\x0392)
    ((?G ?*) . ?\x0393)
    ((?D ?*) . ?\x0394)
    ((?E ?*) . ?\x0395)
    ((?Z ?*) . ?\x0396)
    ((?Y ?*) . ?\x0397)
    ((?H ?*) . ?\x0398)
    ((?I ?*) . ?\x0399)
    ((?K ?*) . ?\x039a)
    ((?L ?*) . ?\x039b)
    ((?M ?*) . ?\x039c)
    ((?N ?*) . ?\x039d)
    ((?C ?*) . ?\x039e)
    ((?O ?*) . ?\x039f)
    ((?P ?*) . ?\x03a0)
    ((?R ?*) . ?\x03a1)
    ((?S ?*) . ?\x03a3)
    ((?T ?*) . ?\x03a4)
    ((?U ?*) . ?\x03a5)
    ((?F ?*) . ?\x03a6)
    ((?X ?*) . ?\x03a7)
    ((?Q ?*) . ?\x03a8)
    ((?W ?*) . ?\x03a9)
    ((?J ?*) . ?\x03aa)
    ((?V ?*) . ?\x03ab)
    ((?a ?%) . ?\x03ac)
    ((?e ?%) . ?\x03ad)
    ((?y ?%) . ?\x03ae)
    ((?i ?%) . ?\x03af)
    ((?u ?3) . ?\x03b0)
    ((?a ?*) . ?\x03b1)
    ((?b ?*) . ?\x03b2)
    ((?g ?*) . ?\x03b3)
    ((?d ?*) . ?\x03b4)
    ((?e ?*) . ?\x03b5)
    ((?z ?*) . ?\x03b6)
    ((?y ?*) . ?\x03b7)
    ((?h ?*) . ?\x03b8)
    ((?i ?*) . ?\x03b9)
    ((?k ?*) . ?\x03ba)
    ((?l ?*) . ?\x03bb)
    ((?m ?*) . ?\x03bc)
    ((?n ?*) . ?\x03bd)
    ((?c ?*) . ?\x03be)
    ((?o ?*) . ?\x03bf)
    ((?p ?*) . ?\x03c0)
    ((?r ?*) . ?\x03c1)
    ((?* ?s) . ?\x03c2)
    ((?s ?*) . ?\x03c3)
    ((?t ?*) . ?\x03c4)
    ((?u ?*) . ?\x03c5)
    ((?f ?*) . ?\x03c6)
    ((?x ?*) . ?\x03c7)
    ((?q ?*) . ?\x03c8)
    ((?w ?*) . ?\x03c9)
    ((?j ?*) . ?\x03ca)
    ((?v ?*) . ?\x03cb)
    ((?o ?%) . ?\x03cc)
    ((?u ?%) . ?\x03cd)
    ((?w ?%) . ?\x03ce)
    ((?' ?G) . ?\x03d8)
    ((?, ?G) . ?\x03d9)
    ((?T ?3) . ?\x03da)
    ((?t ?3) . ?\x03db)
    ((?M ?3) . ?\x03dc)
    ((?m ?3) . ?\x03dd)
    ((?K ?3) . ?\x03de)
    ((?k ?3) . ?\x03df)
    ((?P ?3) . ?\x03e0)
    ((?p ?3) . ?\x03e1)
    ((?' ?%) . ?\x03f4)
    ((?j ?3) . ?\x03f5)
    ((?I ?O) . ?\x0401)
    ((?D ?%) . ?\x0402)
    ((?G ?%) . ?\x0403)
    ((?I ?E) . ?\x0404)
    ((?D ?S) . ?\x0405)
    ((?I ?I) . ?\x0406)
    ((?Y ?I) . ?\x0407)
    ((?J ?%) . ?\x0408)
    ((?L ?J) . ?\x0409)
    ((?N ?J) . ?\x040a)
    ((?T ?s) . ?\x040b)
    ((?K ?J) . ?\x040c)
    ((?V ?%) . ?\x040e)
    ((?D ?Z) . ?\x040f)
    ((?A ?=) . ?\x0410)
    ((?B ?=) . ?\x0411)
    ((?V ?=) . ?\x0412)
    ((?G ?=) . ?\x0413)
    ((?D ?=) . ?\x0414)
    ((?E ?=) . ?\x0415)
    ((?Z ?%) . ?\x0416)
    ((?Z ?=) . ?\x0417)
    ((?I ?=) . ?\x0418)
    ((?J ?=) . ?\x0419)
    ((?K ?=) . ?\x041a)
    ((?L ?=) . ?\x041b)
    ((?M ?=) . ?\x041c)
    ((?N ?=) . ?\x041d)
    ((?O ?=) . ?\x041e)
    ((?P ?=) . ?\x041f)
    ((?R ?=) . ?\x0420)
    ((?S ?=) . ?\x0421)
    ((?T ?=) . ?\x0422)
    ((?U ?=) . ?\x0423)
    ((?F ?=) . ?\x0424)
    ((?H ?=) . ?\x0425)
    ((?C ?=) . ?\x0426)
    ((?C ?%) . ?\x0427)
    ((?S ?%) . ?\x0428)
    ((?S ?c) . ?\x0429)
    ((?= ?\") . ?\x042a)
    ((?Y ?=) . ?\x042b)
    ((?% ?\") . ?\x042c)
    ((?J ?E) . ?\x042d)
    ((?J ?U) . ?\x042e)
    ((?J ?A) . ?\x042f)
    ((?a ?=) . ?\x0430)
    ((?b ?=) . ?\x0431)
    ((?v ?=) . ?\x0432)
    ((?g ?=) . ?\x0433)
    ((?d ?=) . ?\x0434)
    ((?e ?=) . ?\x0435)
    ((?z ?%) . ?\x0436)
    ((?z ?=) . ?\x0437)
    ((?i ?=) . ?\x0438)
    ((?j ?=) . ?\x0439)
    ((?k ?=) . ?\x043a)
    ((?l ?=) . ?\x043b)
    ((?m ?=) . ?\x043c)
    ((?n ?=) . ?\x043d)
    ((?o ?=) . ?\x043e)
    ((?p ?=) . ?\x043f)
    ((?r ?=) . ?\x0440)
    ((?s ?=) . ?\x0441)
    ((?t ?=) . ?\x0442)
    ((?u ?=) . ?\x0443)
    ((?f ?=) . ?\x0444)
    ((?h ?=) . ?\x0445)
    ((?c ?=) . ?\x0446)
    ((?c ?%) . ?\x0447)
    ((?s ?%) . ?\x0448)
    ((?s ?c) . ?\x0449)
    ((?= ?') . ?\x044a)
    ((?y ?=) . ?\x044b)
    ((?% ?') . ?\x044c)
    ((?j ?e) . ?\x044d)
    ((?j ?u) . ?\x044e)
    ((?j ?a) . ?\x044f)
    ((?i ?o) . ?\x0451)
    ((?d ?%) . ?\x0452)
    ((?g ?%) . ?\x0453)
    ((?i ?e) . ?\x0454)
    ((?d ?s) . ?\x0455)
    ((?i ?i) . ?\x0456)
    ((?y ?i) . ?\x0457)
    ((?j ?%) . ?\x0458)
    ((?l ?j) . ?\x0459)
    ((?n ?j) . ?\x045a)
    ((?t ?s) . ?\x045b)
    ((?k ?j) . ?\x045c)
    ((?v ?%) . ?\x045e)
    ((?d ?z) . ?\x045f)
    ((?Y ?3) . ?\x0462)
    ((?y ?3) . ?\x0463)
    ((?O ?3) . ?\x046a)
    ((?o ?3) . ?\x046b)
    ((?F ?3) . ?\x0472)
    ((?f ?3) . ?\x0473)
    ((?V ?3) . ?\x0474)
    ((?v ?3) . ?\x0475)
    ((?C ?3) . ?\x0480)
    ((?c ?3) . ?\x0481)
    ((?G ?3) . ?\x0490)
    ((?g ?3) . ?\x0491)
    ((?A ?+) . ?\x05d0)
    ((?B ?+) . ?\x05d1)
    ((?G ?+) . ?\x05d2)
    ((?D ?+) . ?\x05d3)
    ((?H ?+) . ?\x05d4)
    ((?W ?+) . ?\x05d5)
    ((?Z ?+) . ?\x05d6)
    ((?X ?+) . ?\x05d7)
    ((?T ?j) . ?\x05d8)
    ((?J ?+) . ?\x05d9)
    ((?K ?%) . ?\x05da)
    ((?K ?+) . ?\x05db)
    ((?L ?+) . ?\x05dc)
    ((?M ?%) . ?\x05dd)
    ((?M ?+) . ?\x05de)
    ((?N ?%) . ?\x05df)
    ((?N ?+) . ?\x05e0)
    ((?S ?+) . ?\x05e1)
    ((?E ?+) . ?\x05e2)
    ((?P ?%) . ?\x05e3)
    ((?P ?+) . ?\x05e4)
    ((?Z ?j) . ?\x05e5)
    ((?Z ?J) . ?\x05e6)
    ((?Q ?+) . ?\x05e7)
    ((?R ?+) . ?\x05e8)
    ((?S ?h) . ?\x05e9)
    ((?T ?+) . ?\x05ea)
    ((?, ?+) . ?\x060c)
    ((?\; ?+) . ?\x061b)
    ((?? ?+) . ?\x061f)
    ((?H ?') . ?\x0621)
    ((?a ?M) . ?\x0622)
    ((?a ?H) . ?\x0623)
    ((?w ?H) . ?\x0624)
    ((?a ?h) . ?\x0625)
    ((?y ?H) . ?\x0626)
    ((?a ?+) . ?\x0627)
    ((?b ?+) . ?\x0628)
    ((?t ?m) . ?\x0629)
    ((?t ?+) . ?\x062a)
    ((?t ?k) . ?\x062b)
    ((?g ?+) . ?\x062c)
    ((?h ?k) . ?\x062d)
    ((?x ?+) . ?\x062e)
    ((?d ?+) . ?\x062f)
    ((?d ?k) . ?\x0630)
    ((?r ?+) . ?\x0631)
    ((?z ?+) . ?\x0632)
    ((?s ?+) . ?\x0633)
    ((?s ?n) . ?\x0634)
    ((?c ?+) . ?\x0635)
    ((?d ?d) . ?\x0636)
    ((?t ?j) . ?\x0637)
    ((?z ?H) . ?\x0638)
    ((?e ?+) . ?\x0639)
    ((?i ?+) . ?\x063a)
    ((?+ ?+) . ?\x0640)
    ((?f ?+) . ?\x0641)
    ((?q ?+) . ?\x0642)
    ((?k ?+) . ?\x0643)
    ((?l ?+) . ?\x0644)
    ((?m ?+) . ?\x0645)
    ((?n ?+) . ?\x0646)
    ((?h ?+) . ?\x0647)
    ((?w ?+) . ?\x0648)
    ((?j ?+) . ?\x0649)
    ((?y ?+) . ?\x064a)
    ((?: ?+) . ?\x064b)
    ((?\" ?+) . ?\x064c)
    ((?= ?+) . ?\x064d)
    ((?/ ?+) . ?\x064e)
    ((?' ?+) . ?\x064f)
    ((?1 ?+) . ?\x0650)
    ((?3 ?+) . ?\x0651)
    ((?0 ?+) . ?\x0652)
    ((?a ?S) . ?\x0670)
    ((?p ?+) . ?\x067e)
    ((?v ?+) . ?\x06a4)
    ((?g ?f) . ?\x06af)
    ((?0 ?a) . ?\x06f0)
    ((?1 ?a) . ?\x06f1)
    ((?2 ?a) . ?\x06f2)
    ((?3 ?a) . ?\x06f3)
    ((?4 ?a) . ?\x06f4)
    ((?5 ?a) . ?\x06f5)
    ((?6 ?a) . ?\x06f6)
    ((?7 ?a) . ?\x06f7)
    ((?8 ?a) . ?\x06f8)
    ((?9 ?a) . ?\x06f9)
    ((?B ?.) . ?\x1e02)
    ((?b ?.) . ?\x1e03)
    ((?B ?_) . ?\x1e06)
    ((?b ?_) . ?\x1e07)
    ((?D ?.) . ?\x1e0a)
    ((?d ?.) . ?\x1e0b)
    ((?D ?_) . ?\x1e0e)
    ((?d ?_) . ?\x1e0f)
    ((?D ?,) . ?\x1e10)
    ((?d ?,) . ?\x1e11)
    ((?F ?.) . ?\x1e1e)
    ((?f ?.) . ?\x1e1f)
    ((?G ?-) . ?\x1e20)
    ((?g ?-) . ?\x1e21)
    ((?H ?.) . ?\x1e22)
    ((?h ?.) . ?\x1e23)
    ((?H ?:) . ?\x1e26)
    ((?h ?:) . ?\x1e27)
    ((?H ?,) . ?\x1e28)
    ((?h ?,) . ?\x1e29)
    ((?K ?') . ?\x1e30)
    ((?k ?') . ?\x1e31)
    ((?K ?_) . ?\x1e34)
    ((?k ?_) . ?\x1e35)
    ((?L ?_) . ?\x1e3a)
    ((?l ?_) . ?\x1e3b)
    ((?M ?') . ?\x1e3e)
    ((?m ?') . ?\x1e3f)
    ((?M ?.) . ?\x1e40)
    ((?m ?.) . ?\x1e41)
    ((?N ?.) . ?\x1e44)
    ((?n ?.) . ?\x1e45)
    ((?N ?_) . ?\x1e48)
    ((?n ?_) . ?\x1e49)
    ((?P ?') . ?\x1e54)
    ((?p ?') . ?\x1e55)
    ((?P ?.) . ?\x1e56)
    ((?p ?.) . ?\x1e57)
    ((?R ?.) . ?\x1e58)
    ((?r ?.) . ?\x1e59)
    ((?R ?_) . ?\x1e5e)
    ((?r ?_) . ?\x1e5f)
    ((?S ?.) . ?\x1e60)
    ((?s ?.) . ?\x1e61)
    ((?T ?.) . ?\x1e6a)
    ((?t ?.) . ?\x1e6b)
    ((?T ?_) . ?\x1e6e)
    ((?t ?_) . ?\x1e6f)
    ((?V ??) . ?\x1e7c)
    ((?v ??) . ?\x1e7d)
    ((?W ?!) . ?\x1e80)
    ((?w ?!) . ?\x1e81)
    ((?W ?') . ?\x1e82)
    ((?w ?') . ?\x1e83)
    ((?W ?:) . ?\x1e84)
    ((?w ?:) . ?\x1e85)
    ((?W ?.) . ?\x1e86)
    ((?w ?.) . ?\x1e87)
    ((?X ?.) . ?\x1e8a)
    ((?x ?.) . ?\x1e8b)
    ((?X ?:) . ?\x1e8c)
    ((?x ?:) . ?\x1e8d)
    ((?Y ?.) . ?\x1e8e)
    ((?y ?.) . ?\x1e8f)
    ((?Z ?>) . ?\x1e90)
    ((?z ?>) . ?\x1e91)
    ((?Z ?_) . ?\x1e94)
    ((?z ?_) . ?\x1e95)
    ((?h ?_) . ?\x1e96)
    ((?t ?:) . ?\x1e97)
    ((?w ?0) . ?\x1e98)
    ((?y ?0) . ?\x1e99)
    ((?A ?2) . ?\x1ea2)
    ((?a ?2) . ?\x1ea3)
    ((?E ?2) . ?\x1eba)
    ((?e ?2) . ?\x1ebb)
    ((?E ??) . ?\x1ebc)
    ((?e ??) . ?\x1ebd)
    ((?I ?2) . ?\x1ec8)
    ((?i ?2) . ?\x1ec9)
    ((?O ?2) . ?\x1ece)
    ((?o ?2) . ?\x1ecf)
    ((?U ?2) . ?\x1ee6)
    ((?u ?2) . ?\x1ee7)
    ((?Y ?!) . ?\x1ef2)
    ((?y ?!) . ?\x1ef3)
    ((?Y ?2) . ?\x1ef6)
    ((?y ?2) . ?\x1ef7)
    ((?Y ??) . ?\x1ef8)
    ((?y ??) . ?\x1ef9)
    ((?\; ?') . ?\x1f00)
    ((?, ?') . ?\x1f01)
    ((?\; ?!) . ?\x1f02)
    ((?, ?!) . ?\x1f03)
    ((?? ?\;) . ?\x1f04)
    ((?? ?,) . ?\x1f05)
    ((?! ?:) . ?\x1f06)
    ((?? ?:) . ?\x1f07)
    ((?1 ?N) . ?\x2002)
    ((?1 ?M) . ?\x2003)
    ((?3 ?M) . ?\x2004)
    ((?4 ?M) . ?\x2005)
    ((?6 ?M) . ?\x2006)
    ((?1 ?T) . ?\x2009)
    ((?1 ?H) . ?\x200a)
    ((?- ?1) . ?\x2010)
    ((?- ?N) . ?\x2013)
    ((?- ?M) . ?\x2014)
    ((?- ?3) . ?\x2015)
    ((?! ?2) . ?\x2016)
    ((?= ?2) . ?\x2017)
    ((?' ?6) . ?\x2018)
    ((?' ?9) . ?\x2019)
    ((?. ?9) . ?\x201a)
    ((?9 ?') . ?\x201b)
    ((?\" ?6) . ?\x201c)
    ((?\" ?9) . ?\x201d)
    ((?: ?9) . ?\x201e)
    ((?9 ?\") . ?\x201f)
    ((?/ ?-) . ?\x2020)
    ((?/ ?=) . ?\x2021)
    ((?. ?.) . ?\x2025)
    ((?% ?0) . ?\x2030)
    ((?1 ?') . ?\x2032)
    ((?2 ?') . ?\x2033)
    ((?3 ?') . ?\x2034)
    ((?1 ?\") . ?\x2035)
    ((?2 ?\") . ?\x2036)
    ((?3 ?\") . ?\x2037)
    ((?C ?a) . ?\x2038)
    ((?< ?1) . ?\x2039)
    ((?> ?1) . ?\x203a)
    ((?: ?X) . ?\x203b)
    ((?' ?-) . ?\x203e)
    ((?/ ?f) . ?\x2044)
    ((?0 ?S) . ?\x2070)
    ((?4 ?S) . ?\x2074)
    ((?5 ?S) . ?\x2075)
    ((?6 ?S) . ?\x2076)
    ((?7 ?S) . ?\x2077)
    ((?8 ?S) . ?\x2078)
    ((?9 ?S) . ?\x2079)
    ((?+ ?S) . ?\x207a)
    ((?- ?S) . ?\x207b)
    ((?= ?S) . ?\x207c)
    ((?\( ?S) . ?\x207d)
    ((?\) ?S) . ?\x207e)
    ((?n ?S) . ?\x207f)
    ((?0 ?s) . ?\x2080)
    ((?1 ?s) . ?\x2081)
    ((?2 ?s) . ?\x2082)
    ((?3 ?s) . ?\x2083)
    ((?4 ?s) . ?\x2084)
    ((?5 ?s) . ?\x2085)
    ((?6 ?s) . ?\x2086)
    ((?7 ?s) . ?\x2087)
    ((?8 ?s) . ?\x2088)
    ((?9 ?s) . ?\x2089)
    ((?+ ?s) . ?\x208a)
    ((?- ?s) . ?\x208b)
    ((?= ?s) . ?\x208c)
    ((?\( ?s) . ?\x208d)
    ((?\) ?s) . ?\x208e)
    ((?L ?i) . ?\x20a4)
    ((?P ?t) . ?\x20a7)
    ((?W ?=) . ?\x20a9)
    ((?= ?e) . ?\x20ac)
    ((?E ?u) . ?\x20ac)
    ((?o ?C) . ?\x2103)
    ((?c ?o) . ?\x2105)
    ((?o ?F) . ?\x2109)
    ((?N ?0) . ?\x2116)
    ((?P ?O) . ?\x2117)
    ((?R ?x) . ?\x211e)
    ((?S ?M) . ?\x2120)
    ((?T ?M) . ?\x2122)
    ((?O ?m) . ?\x2126)
    ((?A ?O) . ?\x212b)
    ((?1 ?3) . ?\x2153)
    ((?2 ?3) . ?\x2154)
    ((?1 ?5) . ?\x2155)
    ((?2 ?5) . ?\x2156)
    ((?3 ?5) . ?\x2157)
    ((?4 ?5) . ?\x2158)
    ((?1 ?6) . ?\x2159)
    ((?5 ?6) . ?\x215a)
    ((?1 ?8) . ?\x215b)
    ((?3 ?8) . ?\x215c)
    ((?5 ?8) . ?\x215d)
    ((?7 ?8) . ?\x215e)
    ((?1 ?R) . ?\x2160)
    ((?2 ?R) . ?\x2161)
    ((?3 ?R) . ?\x2162)
    ((?4 ?R) . ?\x2163)
    ((?5 ?R) . ?\x2164)
    ((?6 ?R) . ?\x2165)
    ((?7 ?R) . ?\x2166)
    ((?8 ?R) . ?\x2167)
    ((?9 ?R) . ?\x2168)
    ((?a ?R) . ?\x2169)
    ((?b ?R) . ?\x216a)
    ((?c ?R) . ?\x216b)
    ((?1 ?r) . ?\x2170)
    ((?2 ?r) . ?\x2171)
    ((?3 ?r) . ?\x2172)
    ((?4 ?r) . ?\x2173)
    ((?5 ?r) . ?\x2174)
    ((?6 ?r) . ?\x2175)
    ((?7 ?r) . ?\x2176)
    ((?8 ?r) . ?\x2177)
    ((?9 ?r) . ?\x2178)
    ((?a ?r) . ?\x2179)
    ((?b ?r) . ?\x217a)
    ((?c ?r) . ?\x217b)
    ((?< ?-) . ?\x2190)
    ((?- ?!) . ?\x2191)
    ((?- ?>) . ?\x2192)
    ((?- ?v) . ?\x2193)
    ((?< ?>) . ?\x2194)
    ((?U ?D) . ?\x2195)
    ((?< ?=) . ?\x21d0)
    ((?= ?>) . ?\x21d2)
    ((?= ?=) . ?\x21d4)
    ((?F ?A) . ?\x2200)
    ((?d ?P) . ?\x2202)
    ((?T ?E) . ?\x2203)
    ((?/ ?0) . ?\x2205)
    ((?D ?E) . ?\x2206)
    ((?N ?B) . ?\x2207)
    ((?\( ?-) . ?\x2208)
    ((?- ?\)) . ?\x220b)
    ((?* ?P) . ?\x220f)
    ((?+ ?Z) . ?\x2211)
    ((?- ?2) . ?\x2212)
    ((?- ?+) . ?\x2213)
    ((?* ?-) . ?\x2217)
    ((?O ?b) . ?\x2218)
    ((?S ?b) . ?\x2219)
    ((?R ?T) . ?\x221a)
    ((?0 ?\() . ?\x221d)
    ((?0 ?0) . ?\x221e)
    ((?- ?L) . ?\x221f)
    ((?- ?V) . ?\x2220)
    ((?P ?P) . ?\x2225)
    ((?A ?N) . ?\x2227)
    ((?O ?R) . ?\x2228)
    ((?\( ?U) . ?\x2229)
    ((?\) ?U) . ?\x222a)
    ((?I ?n) . ?\x222b)
    ((?D ?I) . ?\x222c)
    ((?I ?o) . ?\x222e)
    ((?. ?:) . ?\x2234)
    ((?: ?.) . ?\x2235)
    ((?: ?R) . ?\x2236)
    ((?: ?:) . ?\x2237)
    ((?? ?1) . ?\x223c)
    ((?C ?G) . ?\x223e)
    ((?? ?-) . ?\x2243)
    ((?? ?=) . ?\x2245)
    ((?? ?2) . ?\x2248)
    ((?= ??) . ?\x224c)
    ((?H ?I) . ?\x2253)
    ((?! ?=) . ?\x2260)
    ((?= ?3) . ?\x2261)
    ((?= ?<) . ?\x2264)
    ((?> ?=) . ?\x2265)
    ((?< ?*) . ?\x226a)
    ((?* ?>) . ?\x226b)
    ((?! ?<) . ?\x226e)
    ((?! ?>) . ?\x226f)
    ((?\( ?C) . ?\x2282)
    ((?\) ?C) . ?\x2283)
    ((?\( ?_) . ?\x2286)
    ((?\) ?_) . ?\x2287)
    ((?0 ?.) . ?\x2299)
    ((?0 ?2) . ?\x229a)
    ((?- ?T) . ?\x22a5)
    ((?. ?P) . ?\x22c5)
    ((?: ?3) . ?\x22ee)
    ((?. ?3) . ?\x22ef)
    ((?E ?h) . ?\x2302)
    ((?< ?7) . ?\x2308)
    ((?> ?7) . ?\x2309)
    ((?7 ?<) . ?\x230a)
    ((?7 ?>) . ?\x230b)
    ((?N ?I) . ?\x2310)
    ((?\( ?A) . ?\x2312)
    ((?T ?R) . ?\x2315)
    ((?I ?u) . ?\x2320)
    ((?I ?l) . ?\x2321)
    ((?< ?/) . ?\x2329)
    ((?/ ?>) . ?\x232a)
    ((?V ?s) . ?\x2423)
    ((?1 ?h) . ?\x2440)
    ((?3 ?h) . ?\x2441)
    ((?2 ?h) . ?\x2442)
    ((?4 ?h) . ?\x2443)
    ((?1 ?j) . ?\x2446)
    ((?2 ?j) . ?\x2447)
    ((?3 ?j) . ?\x2448)
    ((?4 ?j) . ?\x2449)
    ((?1 ?.) . ?\x2488)
    ((?2 ?.) . ?\x2489)
    ((?3 ?.) . ?\x248a)
    ((?4 ?.) . ?\x248b)
    ((?5 ?.) . ?\x248c)
    ((?6 ?.) . ?\x248d)
    ((?7 ?.) . ?\x248e)
    ((?8 ?.) . ?\x248f)
    ((?9 ?.) . ?\x2490)
    ((?h ?h) . ?\x2500)
    ((?H ?H) . ?\x2501)
    ((?v ?v) . ?\x2502)
    ((?V ?V) . ?\x2503)
    ((?3 ?-) . ?\x2504)
    ((?3 ?_) . ?\x2505)
    ((?3 ?!) . ?\x2506)
    ((?3 ?/) . ?\x2507)
    ((?4 ?-) . ?\x2508)
    ((?4 ?_) . ?\x2509)
    ((?4 ?!) . ?\x250a)
    ((?4 ?/) . ?\x250b)
    ((?d ?r) . ?\x250c)
    ((?d ?R) . ?\x250d)
    ((?D ?r) . ?\x250e)
    ((?D ?R) . ?\x250f)
    ((?d ?l) . ?\x2510)
    ((?d ?L) . ?\x2511)
    ((?D ?l) . ?\x2512)
    ((?L ?D) . ?\x2513)
    ((?u ?r) . ?\x2514)
    ((?u ?R) . ?\x2515)
    ((?U ?r) . ?\x2516)
    ((?U ?R) . ?\x2517)
    ((?u ?l) . ?\x2518)
    ((?u ?L) . ?\x2519)
    ((?U ?l) . ?\x251a)
    ((?U ?L) . ?\x251b)
    ((?v ?r) . ?\x251c)
    ((?v ?R) . ?\x251d)
    ((?V ?r) . ?\x2520)
    ((?V ?R) . ?\x2523)
    ((?v ?l) . ?\x2524)
    ((?v ?L) . ?\x2525)
    ((?V ?l) . ?\x2528)
    ((?V ?L) . ?\x252b)
    ((?d ?h) . ?\x252c)
    ((?d ?H) . ?\x252f)
    ((?D ?h) . ?\x2530)
    ((?D ?H) . ?\x2533)
    ((?u ?h) . ?\x2534)
    ((?u ?H) . ?\x2537)
    ((?U ?h) . ?\x2538)
    ((?U ?H) . ?\x253b)
    ((?v ?h) . ?\x253c)
    ((?v ?H) . ?\x253f)
    ((?V ?h) . ?\x2542)
    ((?V ?H) . ?\x254b)
    ((?F ?D) . ?\x2571)
    ((?B ?D) . ?\x2572)
    ((?T ?B) . ?\x2580)
    ((?L ?B) . ?\x2584)
    ((?F ?B) . ?\x2588)
    ((?l ?B) . ?\x258c)
    ((?R ?B) . ?\x2590)
    ((?. ?S) . ?\x2591)
    ((?: ?S) . ?\x2592)
    ((?? ?S) . ?\x2593)
    ((?f ?S) . ?\x25a0)
    ((?O ?S) . ?\x25a1)
    ((?R ?O) . ?\x25a2)
    ((?R ?r) . ?\x25a3)
    ((?R ?F) . ?\x25a4)
    ((?R ?Y) . ?\x25a5)
    ((?R ?H) . ?\x25a6)
    ((?R ?Z) . ?\x25a7)
    ((?R ?K) . ?\x25a8)
    ((?R ?X) . ?\x25a9)
    ((?s ?B) . ?\x25aa)
    ((?S ?R) . ?\x25ac)
    ((?O ?r) . ?\x25ad)
    ((?U ?T) . ?\x25b2)
    ((?u ?T) . ?\x25b3)
    ((?P ?R) . ?\x25b6)
    ((?T ?r) . ?\x25b7)
    ((?D ?t) . ?\x25bc)
    ((?d ?T) . ?\x25bd)
    ((?P ?L) . ?\x25c0)
    ((?T ?l) . ?\x25c1)
    ((?D ?b) . ?\x25c6)
    ((?D ?w) . ?\x25c7)
    ((?L ?Z) . ?\x25ca)
    ((?0 ?m) . ?\x25cb)
    ((?0 ?o) . ?\x25ce)
    ((?0 ?M) . ?\x25cf)
    ((?0 ?L) . ?\x25d0)
    ((?0 ?R) . ?\x25d1)
    ((?S ?n) . ?\x25d8)
    ((?I ?c) . ?\x25d9)
    ((?F ?d) . ?\x25e2)
    ((?B ?d) . ?\x25e3)
    ((?* ?2) . ?\x2605)
    ((?* ?1) . ?\x2606)
    ((?< ?H) . ?\x261c)
    ((?> ?H) . ?\x261e)
    ((?0 ?u) . ?\x263a)
    ((?0 ?U) . ?\x263b)
    ((?S ?U) . ?\x263c)
    ((?F ?m) . ?\x2640)
    ((?M ?l) . ?\x2642)
    ((?c ?S) . ?\x2660)
    ((?c ?H) . ?\x2661)
    ((?c ?D) . ?\x2662)
    ((?c ?C) . ?\x2663)
    ((?M ?d) . ?\x2669)
    ((?M ?8) . ?\x266a)
    ((?M ?2) . ?\x266b)
    ((?M ?b) . ?\x266d)
    ((?M ?x) . ?\x266e)
    ((?M ?X) . ?\x266f)
    ((?O ?K) . ?\x2713)
    ((?X ?X) . ?\x2717)
    ((?- ?X) . ?\x2720)
    ((?I ?S) . ?\x3000)
    ((?, ?_) . ?\x3001)
    ((?. ?_) . ?\x3002)
    ((?+ ?\") . ?\x3003)
    ((?+ ?_) . ?\x3004)
    ((?* ?_) . ?\x3005)
    ((?\; ?_) . ?\x3006)
    ((?0 ?_) . ?\x3007)
    ((?< ?+) . ?\x300a)
    ((?> ?+) . ?\x300b)
    ((?< ?') . ?\x300c)
    ((?> ?') . ?\x300d)
    ((?< ?\") . ?\x300e)
    ((?> ?\") . ?\x300f)
    ((?\( ?\") . ?\x3010)
    ((?\) ?\") . ?\x3011)
    ((?= ?T) . ?\x3012)
    ((?= ?_) . ?\x3013)
    ((?\( ?') . ?\x3014)
    ((?\) ?') . ?\x3015)
    ((?\( ?I) . ?\x3016)
    ((?\) ?I) . ?\x3017)
    ((?- ??) . ?\x301c)
    ((?A ?5) . ?\x3041)
    ((?a ?5) . ?\x3042)
    ((?I ?5) . ?\x3043)
    ((?i ?5) . ?\x3044)
    ((?U ?5) . ?\x3045)
    ((?u ?5) . ?\x3046)
    ((?E ?5) . ?\x3047)
    ((?e ?5) . ?\x3048)
    ((?O ?5) . ?\x3049)
    ((?o ?5) . ?\x304a)
    ((?k ?a) . ?\x304b)
    ((?g ?a) . ?\x304c)
    ((?k ?i) . ?\x304d)
    ((?g ?i) . ?\x304e)
    ((?k ?u) . ?\x304f)
    ((?g ?u) . ?\x3050)
    ((?k ?e) . ?\x3051)
    ((?g ?e) . ?\x3052)
    ((?k ?o) . ?\x3053)
    ((?g ?o) . ?\x3054)
    ((?s ?a) . ?\x3055)
    ((?z ?a) . ?\x3056)
    ((?s ?i) . ?\x3057)
    ((?z ?i) . ?\x3058)
    ((?s ?u) . ?\x3059)
    ((?z ?u) . ?\x305a)
    ((?s ?e) . ?\x305b)
    ((?z ?e) . ?\x305c)
    ((?s ?o) . ?\x305d)
    ((?z ?o) . ?\x305e)
    ((?t ?a) . ?\x305f)
    ((?d ?a) . ?\x3060)
    ((?t ?i) . ?\x3061)
    ((?d ?i) . ?\x3062)
    ((?t ?U) . ?\x3063)
    ((?t ?u) . ?\x3064)
    ((?d ?u) . ?\x3065)
    ((?t ?e) . ?\x3066)
    ((?d ?e) . ?\x3067)
    ((?t ?o) . ?\x3068)
    ((?d ?o) . ?\x3069)
    ((?n ?a) . ?\x306a)
    ((?n ?i) . ?\x306b)
    ((?n ?u) . ?\x306c)
    ((?n ?e) . ?\x306d)
    ((?n ?o) . ?\x306e)
    ((?h ?a) . ?\x306f)
    ((?b ?a) . ?\x3070)
    ((?p ?a) . ?\x3071)
    ((?h ?i) . ?\x3072)
    ((?b ?i) . ?\x3073)
    ((?p ?i) . ?\x3074)
    ((?h ?u) . ?\x3075)
    ((?b ?u) . ?\x3076)
    ((?p ?u) . ?\x3077)
    ((?h ?e) . ?\x3078)
    ((?b ?e) . ?\x3079)
    ((?p ?e) . ?\x307a)
    ((?h ?o) . ?\x307b)
    ((?b ?o) . ?\x307c)
    ((?p ?o) . ?\x307d)
    ((?m ?a) . ?\x307e)
    ((?m ?i) . ?\x307f)
    ((?m ?u) . ?\x3080)
    ((?m ?e) . ?\x3081)
    ((?m ?o) . ?\x3082)
    ((?y ?A) . ?\x3083)
    ((?y ?a) . ?\x3084)
    ((?y ?U) . ?\x3085)
    ((?y ?u) . ?\x3086)
    ((?y ?O) . ?\x3087)
    ((?y ?o) . ?\x3088)
    ((?r ?a) . ?\x3089)
    ((?r ?i) . ?\x308a)
    ((?r ?u) . ?\x308b)
    ((?r ?e) . ?\x308c)
    ((?r ?o) . ?\x308d)
    ((?w ?A) . ?\x308e)
    ((?w ?a) . ?\x308f)
    ((?w ?i) . ?\x3090)
    ((?w ?e) . ?\x3091)
    ((?w ?o) . ?\x3092)
    ((?n ?5) . ?\x3093)
    ((?v ?u) . ?\x3094)
    ((?\" ?5) . ?\x309b)
    ((?0 ?5) . ?\x309c)
    ((?* ?5) . ?\x309d)
    ((?+ ?5) . ?\x309e)
    ((?a ?6) . ?\x30a1)
    ((?A ?6) . ?\x30a2)
    ((?i ?6) . ?\x30a3)
    ((?I ?6) . ?\x30a4)
    ((?u ?6) . ?\x30a5)
    ((?U ?6) . ?\x30a6)
    ((?e ?6) . ?\x30a7)
    ((?E ?6) . ?\x30a8)
    ((?o ?6) . ?\x30a9)
    ((?O ?6) . ?\x30aa)
    ((?K ?a) . ?\x30ab)
    ((?G ?a) . ?\x30ac)
    ((?K ?i) . ?\x30ad)
    ((?G ?i) . ?\x30ae)
    ((?K ?u) . ?\x30af)
    ((?G ?u) . ?\x30b0)
    ((?K ?e) . ?\x30b1)
    ((?G ?e) . ?\x30b2)
    ((?K ?o) . ?\x30b3)
    ((?G ?o) . ?\x30b4)
    ((?S ?a) . ?\x30b5)
    ((?Z ?a) . ?\x30b6)
    ((?S ?i) . ?\x30b7)
    ((?Z ?i) . ?\x30b8)
    ((?S ?u) . ?\x30b9)
    ((?Z ?u) . ?\x30ba)
    ((?S ?e) . ?\x30bb)
    ((?Z ?e) . ?\x30bc)
    ((?S ?o) . ?\x30bd)
    ((?Z ?o) . ?\x30be)
    ((?T ?a) . ?\x30bf)
    ((?D ?a) . ?\x30c0)
    ((?T ?i) . ?\x30c1)
    ((?D ?i) . ?\x30c2)
    ((?T ?U) . ?\x30c3)
    ((?T ?u) . ?\x30c4)
    ((?D ?u) . ?\x30c5)
    ((?T ?e) . ?\x30c6)
    ((?D ?e) . ?\x30c7)
    ((?T ?o) . ?\x30c8)
    ((?D ?o) . ?\x30c9)
    ((?N ?a) . ?\x30ca)
    ((?N ?i) . ?\x30cb)
    ((?N ?u) . ?\x30cc)
    ((?N ?e) . ?\x30cd)
    ((?N ?o) . ?\x30ce)
    ((?H ?a) . ?\x30cf)
    ((?B ?a) . ?\x30d0)
    ((?P ?a) . ?\x30d1)
    ((?H ?i) . ?\x30d2)
    ((?B ?i) . ?\x30d3)
    ((?P ?i) . ?\x30d4)
    ((?H ?u) . ?\x30d5)
    ((?B ?u) . ?\x30d6)
    ((?P ?u) . ?\x30d7)
    ((?H ?e) . ?\x30d8)
    ((?B ?e) . ?\x30d9)
    ((?P ?e) . ?\x30da)
    ((?H ?o) . ?\x30db)
    ((?B ?o) . ?\x30dc)
    ((?P ?o) . ?\x30dd)
    ((?u ?R) . ?\x2515)
    ((?U ?r) . ?\x2516)
    ((?U ?R) . ?\x2517)
    ((?u ?l) . ?\x2518)
    ((?u ?L) . ?\x2519)
    ((?U ?l) . ?\x251a)
    ((?U ?L) . ?\x251b)
    ((?v ?r) . ?\x251c)
    ((?v ?R) . ?\x251d)
    ((?V ?r) . ?\x2520)
    ((?V ?R) . ?\x2523)
    ((?v ?l) . ?\x2524)
    ((?v ?L) . ?\x2525)
    ((?V ?l) . ?\x2528)
    ((?V ?L) . ?\x252b)
    ((?d ?h) . ?\x252c)
    ((?d ?H) . ?\x252f)
    ((?D ?h) . ?\x2530)
    ((?D ?H) . ?\x2533)
    ((?u ?h) . ?\x2534)
    ((?u ?H) . ?\x2537)
    ((?U ?h) . ?\x2538)
    ((?U ?H) . ?\x253b)
    ((?v ?h) . ?\x253c)
    ((?v ?H) . ?\x253f)
    ((?V ?h) . ?\x2542)
    ((?V ?H) . ?\x254b)
    ((?F ?D) . ?\x2571)
    ((?B ?D) . ?\x2572)
    ((?T ?B) . ?\x2580)
    ((?L ?B) . ?\x2584)
    ((?F ?B) . ?\x2588)
    ((?l ?B) . ?\x258c)
    ((?R ?B) . ?\x2590)
    ((?. ?S) . ?\x2591)
    ((?: ?S) . ?\x2592)
    ((?? ?S) . ?\x2593)
    ((?f ?S) . ?\x25a0)
    ((?O ?S) . ?\x25a1)
    ((?R ?O) . ?\x25a2)
    ((?R ?r) . ?\x25a3)
    ((?R ?F) . ?\x25a4)
    ((?R ?Y) . ?\x25a5)
    ((?R ?H) . ?\x25a6)
    ((?R ?Z) . ?\x25a7)
    ((?R ?K) . ?\x25a8)
    ((?R ?X) . ?\x25a9)
    ((?s ?B) . ?\x25aa)
    ((?S ?R) . ?\x25ac)
    ((?O ?r) . ?\x25ad)
    ((?U ?T) . ?\x25b2)
    ((?u ?T) . ?\x25b3)
    ((?P ?R) . ?\x25b6)
    ((?T ?r) . ?\x25b7)
    ((?D ?t) . ?\x25bc)
    ((?d ?T) . ?\x25bd)
    ((?P ?L) . ?\x25c0)
    ((?T ?l) . ?\x25c1)
    ((?D ?b) . ?\x25c6)
    ((?D ?w) . ?\x25c7)
    ((?L ?Z) . ?\x25ca)
    ((?0 ?m) . ?\x25cb)
    ((?0 ?o) . ?\x25ce)
    ((?0 ?M) . ?\x25cf)
    ((?0 ?L) . ?\x25d0)
    ((?0 ?R) . ?\x25d1)
    ((?S ?n) . ?\x25d8)
    ((?I ?c) . ?\x25d9)
    ((?F ?d) . ?\x25e2)
    ((?B ?d) . ?\x25e3)
    ((?* ?2) . ?\x2605)
    ((?* ?1) . ?\x2606)
    ((?< ?H) . ?\x261c)
    ((?> ?H) . ?\x261e)
    ((?0 ?u) . ?\x263a)
    ((?0 ?U) . ?\x263b)
    ((?S ?U) . ?\x263c)
    ((?F ?m) . ?\x2640)
    ((?M ?l) . ?\x2642)
    ((?c ?S) . ?\x2660)
    ((?c ?H) . ?\x2661)
    ((?c ?D) . ?\x2662)
    ((?c ?C) . ?\x2663)
    ((?M ?d) . ?\x2669)
    ((?M ?8) . ?\x266a)
    ((?M ?2) . ?\x266b)
    ((?M ?b) . ?\x266d)
    ((?M ?x) . ?\x266e)
    ((?M ?X) . ?\x266f)
    ((?O ?K) . ?\x2713)
    ((?X ?X) . ?\x2717)
    ((?- ?X) . ?\x2720)
    ((?I ?S) . ?\x3000)
    ((?, ?_) . ?\x3001)
    ((?. ?_) . ?\x3002)
    ((?+ ?\") . ?\x3003)
    ((?+ ?_) . ?\x3004)
    ((?* ?_) . ?\x3005)
    ((?\; ?_) . ?\x3006)
    ((?0 ?_) . ?\x3007)
    ((?< ?+) . ?\x300a)
    ((?> ?+) . ?\x300b)
    ((?< ?') . ?\x300c)
    ((?> ?') . ?\x300d)
    ((?< ?\") . ?\x300e)
    ((?> ?\") . ?\x300f)
    ((?\( ?\") . ?\x3010)
    ((?\) ?\") . ?\x3011)
    ((?= ?T) . ?\x3012)
    ((?= ?_) . ?\x3013)
    ((?\( ?') . ?\x3014)
    ((?\) ?') . ?\x3015)
    ((?\( ?I) . ?\x3016)
    ((?\) ?I) . ?\x3017)
    ((?- ??) . ?\x301c)
    ((?A ?5) . ?\x3041)
    ((?a ?5) . ?\x3042)
    ((?I ?5) . ?\x3043)
    ((?i ?5) . ?\x3044)
    ((?U ?5) . ?\x3045)
    ((?u ?5) . ?\x3046)
    ((?E ?5) . ?\x3047)
    ((?e ?5) . ?\x3048)
    ((?O ?5) . ?\x3049)
    ((?o ?5) . ?\x304a)
    ((?k ?a) . ?\x304b)
    ((?g ?a) . ?\x304c)
    ((?k ?i) . ?\x304d)
    ((?g ?i) . ?\x304e)
    ((?k ?u) . ?\x304f)
    ((?g ?u) . ?\x3050)
    ((?k ?e) . ?\x3051)
    ((?g ?e) . ?\x3052)
    ((?k ?o) . ?\x3053)
    ((?g ?o) . ?\x3054)
    ((?s ?a) . ?\x3055)
    ((?z ?a) . ?\x3056)
    ((?s ?i) . ?\x3057)
    ((?z ?i) . ?\x3058)
    ((?s ?u) . ?\x3059)
    ((?z ?u) . ?\x305a)
    ((?s ?e) . ?\x305b)
    ((?z ?e) . ?\x305c)
    ((?s ?o) . ?\x305d)
    ((?z ?o) . ?\x305e)
    ((?t ?a) . ?\x305f)
    ((?d ?a) . ?\x3060)
    ((?t ?i) . ?\x3061)
    ((?d ?i) . ?\x3062)
    ((?t ?U) . ?\x3063)
    ((?t ?u) . ?\x3064)
    ((?d ?u) . ?\x3065)
    ((?t ?e) . ?\x3066)
    ((?d ?e) . ?\x3067)
    ((?t ?o) . ?\x3068)
    ((?d ?o) . ?\x3069)
    ((?n ?a) . ?\x306a)
    ((?n ?i) . ?\x306b)
    ((?n ?u) . ?\x306c)
    ((?n ?e) . ?\x306d)
    ((?n ?o) . ?\x306e)
    ((?h ?a) . ?\x306f)
    ((?b ?a) . ?\x3070)
    ((?p ?a) . ?\x3071)
    ((?h ?i) . ?\x3072)
    ((?b ?i) . ?\x3073)
    ((?p ?i) . ?\x3074)
    ((?h ?u) . ?\x3075)
    ((?b ?u) . ?\x3076)
    ((?p ?u) . ?\x3077)
    ((?h ?e) . ?\x3078)
    ((?b ?e) . ?\x3079)
    ((?p ?e) . ?\x307a)
    ((?h ?o) . ?\x307b)
    ((?b ?o) . ?\x307c)
    ((?p ?o) . ?\x307d)
    ((?m ?a) . ?\x307e)
    ((?m ?i) . ?\x307f)
    ((?m ?u) . ?\x3080)
    ((?m ?e) . ?\x3081)
    ((?m ?o) . ?\x3082)
    ((?y ?A) . ?\x3083)
    ((?y ?a) . ?\x3084)
    ((?y ?U) . ?\x3085)
    ((?y ?u) . ?\x3086)
    ((?y ?O) . ?\x3087)
    ((?y ?o) . ?\x3088)
    ((?r ?a) . ?\x3089)
    ((?r ?i) . ?\x308a)
    ((?r ?u) . ?\x308b)
    ((?r ?e) . ?\x308c)
    ((?r ?o) . ?\x308d)
    ((?w ?A) . ?\x308e)
    ((?w ?a) . ?\x308f)
    ((?w ?i) . ?\x3090)
    ((?w ?e) . ?\x3091)
    ((?w ?o) . ?\x3092)
    ((?n ?5) . ?\x3093)
    ((?v ?u) . ?\x3094)
    ((?\" ?5) . ?\x309b)
    ((?0 ?5) . ?\x309c)
    ((?* ?5) . ?\x309d)
    ((?+ ?5) . ?\x309e)
    ((?a ?6) . ?\x30a1)
    ((?A ?6) . ?\x30a2)
    ((?i ?6) . ?\x30a3)
    ((?I ?6) . ?\x30a4)
    ((?u ?6) . ?\x30a5)
    ((?U ?6) . ?\x30a6)
    ((?e ?6) . ?\x30a7)
    ((?E ?6) . ?\x30a8)
    ((?o ?6) . ?\x30a9)
    ((?O ?6) . ?\x30aa)
    ((?K ?a) . ?\x30ab)
    ((?G ?a) . ?\x30ac)
    ((?K ?i) . ?\x30ad)
    ((?G ?i) . ?\x30ae)
    ((?K ?u) . ?\x30af)
    ((?G ?u) . ?\x30b0)
    ((?K ?e) . ?\x30b1)
    ((?G ?e) . ?\x30b2)
    ((?K ?o) . ?\x30b3)
    ((?G ?o) . ?\x30b4)
    ((?S ?a) . ?\x30b5)
    ((?Z ?a) . ?\x30b6)
    ((?S ?i) . ?\x30b7)
    ((?Z ?i) . ?\x30b8)
    ((?S ?u) . ?\x30b9)
    ((?Z ?u) . ?\x30ba)
    ((?S ?e) . ?\x30bb)
    ((?Z ?e) . ?\x30bc)
    ((?S ?o) . ?\x30bd)
    ((?Z ?o) . ?\x30be)
    ((?T ?a) . ?\x30bf)
    ((?D ?a) . ?\x30c0)
    ((?T ?i) . ?\x30c1)
    ((?D ?i) . ?\x30c2)
    ((?T ?U) . ?\x30c3)
    ((?T ?u) . ?\x30c4)
    ((?D ?u) . ?\x30c5)
    ((?T ?e) . ?\x30c6)
    ((?D ?e) . ?\x30c7)
    ((?T ?o) . ?\x30c8)
    ((?D ?o) . ?\x30c9)
    ((?N ?a) . ?\x30ca)
    ((?N ?i) . ?\x30cb)
    ((?N ?u) . ?\x30cc)
    ((?N ?e) . ?\x30cd)
    ((?N ?o) . ?\x30ce)
    ((?H ?a) . ?\x30cf)
    ((?B ?a) . ?\x30d0)
    ((?P ?a) . ?\x30d1)
    ((?H ?i) . ?\x30d2)
    ((?B ?i) . ?\x30d3)
    ((?P ?i) . ?\x30d4)
    ((?H ?u) . ?\x30d5)
    ((?B ?u) . ?\x30d6)
    ((?P ?u) . ?\x30d7)
    ((?H ?e) . ?\x30d8)
    ((?B ?e) . ?\x30d9)
    ((?P ?e) . ?\x30da)
    ((?H ?o) . ?\x30db)
    ((?B ?o) . ?\x30dc)
    ((?P ?o) . ?\x30dd)
    ((?M ?a) . ?\x30de)
    ((?M ?i) . ?\x30df)
    ((?M ?u) . ?\x30e0)
    ((?M ?e) . ?\x30e1)
    ((?M ?o) . ?\x30e2)
    ((?Y ?A) . ?\x30e3)
    ((?Y ?a) . ?\x30e4)
    ((?Y ?U) . ?\x30e5)
    ((?Y ?u) . ?\x30e6)
    ((?Y ?O) . ?\x30e7)
    ((?Y ?o) . ?\x30e8)
    ((?R ?a) . ?\x30e9)
    ((?R ?i) . ?\x30ea)
    ((?R ?u) . ?\x30eb)
    ((?R ?e) . ?\x30ec)
    ((?R ?o) . ?\x30ed)
    ((?W ?A) . ?\x30ee)
    ((?W ?a) . ?\x30ef)
    ((?W ?i) . ?\x30f0)
    ((?W ?e) . ?\x30f1)
    ((?W ?o) . ?\x30f2)
    ((?N ?6) . ?\x30f3)
    ((?V ?u) . ?\x30f4)
    ((?K ?A) . ?\x30f5)
    ((?K ?E) . ?\x30f6)
    ((?V ?a) . ?\x30f7)
    ((?V ?i) . ?\x30f8)
    ((?V ?e) . ?\x30f9)
    ((?V ?o) . ?\x30fa)
    ((?. ?6) . ?\x30fb)
    ((?- ?6) . ?\x30fc)
    ((?* ?6) . ?\x30fd)
    ((?+ ?6) . ?\x30fe)
    ((?b ?4) . ?\x3105)
    ((?p ?4) . ?\x3106)
    ((?m ?4) . ?\x3107)
    ((?f ?4) . ?\x3108)
    ((?d ?4) . ?\x3109)
    ((?t ?4) . ?\x310a)
    ((?n ?4) . ?\x310b)
    ((?l ?4) . ?\x310c)
    ((?g ?4) . ?\x310d)
    ((?k ?4) . ?\x310e)
    ((?h ?4) . ?\x310f)
    ((?j ?4) . ?\x3110)
    ((?q ?4) . ?\x3111)
    ((?x ?4) . ?\x3112)
    ((?z ?h) . ?\x3113)
    ((?c ?h) . ?\x3114)
    ((?s ?h) . ?\x3115)
    ((?r ?4) . ?\x3116)
    ((?z ?4) . ?\x3117)
    ((?c ?4) . ?\x3118)
    ((?s ?4) . ?\x3119)
    ((?a ?4) . ?\x311a)
    ((?o ?4) . ?\x311b)
    ((?e ?4) . ?\x311c)
    ((?a ?i) . ?\x311e)
    ((?e ?i) . ?\x311f)
    ((?a ?u) . ?\x3120)
    ((?o ?u) . ?\x3121)
    ((?a ?n) . ?\x3122)
    ((?e ?n) . ?\x3123)
    ((?a ?N) . ?\x3124)
    ((?e ?N) . ?\x3125)
    ((?e ?r) . ?\x3126)
    ((?i ?4) . ?\x3127)
    ((?u ?4) . ?\x3128)
    ((?i ?u) . ?\x3129)
    ((?v ?4) . ?\x312a)
    ((?n ?G) . ?\x312b)
    ((?g ?n) . ?\x312c)
    ((?1 ?c) . ?\x3220)
    ((?2 ?c) . ?\x3221)
    ((?3 ?c) . ?\x3222)
    ((?4 ?c) . ?\x3223)
    ((?5 ?c) . ?\x3224)
    ((?6 ?c) . ?\x3225)
    ((?7 ?c) . ?\x3226)
    ((?8 ?c) . ?\x3227)
    ((?9 ?c) . ?\x3228)
    ((?\s ?\s) . ?\xe000)
    ((?/ ?c) . ?\xe001)
    ((?U ?A) . ?\xe002)
    ((?U ?B) . ?\xe003)
    ((?\" ?3) . ?\xe004)
    ((?\" ?1) . ?\xe005)
    ((?\" ?!) . ?\xe006)
    ((?\" ?') . ?\xe007)
    ((?\" ?>) . ?\xe008)
    ((?\" ??) . ?\xe009)
    ((?\" ?-) . ?\xe00a)
    ((?\" ?\() . ?\xe00b)
    ((?\" ?.) . ?\xe00c)
    ((?\" ?:) . ?\xe00d)
    ((?\" ?0) . ?\xe00e)
    ((?\" ?\") . ?\xe00f)
    ((?\" ?<) . ?\xe010)
    ((?\" ?,) . ?\xe011)
    ((?\" ?\;) . ?\xe012)
    ((?\" ?_) . ?\xe013)
    ((?\" ?=) . ?\xe014)
    ((?\" ?/) . ?\xe015)
    ((?\" ?i) . ?\xe016)
    ((?\" ?d) . ?\xe017)
    ((?\" ?p) . ?\xe018)
    ((?\; ?\;) . ?\xe019)
    ((?, ?,) . ?\xe01a)
    ((?b ?3) . ?\xe01b)
    ((?C ?i) . ?\xe01c)
    ((?f ?\() . ?\xe01d)
    ((?e ?d) . ?\xe01e)
    ((?a ?m) . ?\xe01f)
    ((?p ?m) . ?\xe020)
    ((?F ?l) . ?\xe023)
    ((?G ?F) . ?\xe024)
    ((?> ?V) . ?\xe025)
    ((?! ?*) . ?\xe026)
    ((?? ?*) . ?\xe027)
    ((?J ?<) . ?\xe028)
    ((?f ?f) . ?\xfb00)
    ((?f ?i) . ?\xfb01)
    ((?f ?l) . ?\xfb02)
    ((?f ?t) . ?\xfb05)
    ((?s ?t) . ?\xfb06)
    ((?~ ?!) . ?\x00a1)
    ((?c ?|) . ?\x00a2)
    ((?$ ?$) . ?\x00a3)
    ((?o ?x) . ?\x00a4)
    ((?Y ?-) . ?\x00a5)
    ((?| ?|) . ?\x00a6)
    ((?c ?O) . ?\x00a9)
    ((?- ?,) . ?\x00ac)
    ((?- ?=) . ?\x00af)
    ((?~ ?o) . ?\x00b0)
    ((?2 ?2) . ?\x00b2)
    ((?3 ?3) . ?\x00b3)
    ((?p ?p) . ?\x00b6)
    ((?~ ?.) . ?\x00b7)
    ((?1 ?1) . ?\x00b9)
    ((?~ ??) . ?\x00bf)
    ((?A ?`) . ?\x00c0)
    ((?A ?^) . ?\x00c2)
    ((?A ?~) . ?\x00c3)
    ((?A ?\") . ?\x00c4)
    ((?A ?@) . ?\x00c5)
    ((?E ?`) . ?\x00c8)
    ((?E ?^) . ?\x00ca)
    ((?E ?\") . ?\x00cb)
    ((?I ?`) . ?\x00cc)
    ((?I ?^) . ?\x00ce)
    ((?I ?\") . ?\x00cf)
    ((?N ?~) . ?\x00d1)
    ((?O ?`) . ?\x00d2)
    ((?O ?^) . ?\x00d4)
    ((?O ?~) . ?\x00d5)
    ((?/ ?\\) . ?\x00d7)
    ((?U ?`) . ?\x00d9)
    ((?U ?^) . ?\x00db)
    ((?I ?p) . ?\x00de)
    ((?a ?`) . ?\x00e0)
    ((?a ?^) . ?\x00e2)
    ((?a ?~) . ?\x00e3)
    ((?a ?\") . ?\x00e4)
    ((?a ?@) . ?\x00e5)
    ((?e ?`) . ?\x00e8)
    ((?e ?^) . ?\x00ea)
    ((?e ?\") . ?\x00eb)
    ((?i ?`) . ?\x00ec)
    ((?i ?^) . ?\x00ee)
    ((?n ?~) . ?\x00f1)
    ((?o ?`) . ?\x00f2)
    ((?o ?^) . ?\x00f4)
    ((?o ?~) . ?\x00f5)
    ((?u ?`) . ?\x00f9)
    ((?u ?^) . ?\x00fb)
    ((?y ?\") . ?\x00ff))
  "Table of default digraphs.
This includes all digraphs defined in RFC 1345,
as well as miscellaneous digraphs for multi-byte characters.
See also `evil-digraphs-table-user'.")

(defun evil-digraph (digraph)
  "Convert DIGRAPH to character or list representation.
If DIGRAPH is a list (CHAR1 CHAR2), return the corresponding character;
if DIGRAPH is a character, return the corresponding list.
Searches in `evil-digraphs-table-user' and `evil-digraphs-table'."
  (if (listp digraph)
      (let* ((char1 (car digraph))
             (char2 (cadr digraph)))
        (or (cdr (assoc (list char1 char2) evil-digraphs-table-user))
            (cdr (assoc (list char1 char2) evil-digraphs-table))
            (unless (eq char1 char2)
              (or (cdr (assoc (list char2 char1) evil-digraphs-table-user))
                  (cdr (assoc (list char2 char1) evil-digraphs-table))))))
    (or (car (rassoc digraph evil-digraphs-table-user))
        (car (rassoc digraph evil-digraphs-table)))))

(provide 'evil-digraphs)

;;; evil-digraphs.el ends here
