;;; cyanometric-theme.el --- A Theme with overwhelming bias towards cyan

;; Copyright (c) 2022 Jason Milkins (GNU/GPL Licence)

;; Authors: Jason Milkins <jasonm23@gmail.com>
;; URL: http://github.com/emacsfodder/emacs-theme-cyanometric
;; Package-Version: 1.0.2
;; Package-Revision: 9b20e33a8cc2
;; Package-Requires: ((autothemer "0.2") (emacs "24"))

;;; License
;;
;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 51 Franklin Street, Fifth
;; Floor, Boston, MA 02110-1301, USA.

;;; Commentary:
;;  A Theme with overwhelming bias towards cyan.

;;; GUI Support only.

;;; Code:
(require 'autothemer)

(unless (>= emacs-major-version 24)
  (error "Requires Emacs 24 or later"))

(autothemer-deftheme  cyanometric
                      "A Theme with overwhelming bias towards cyan."
 ((((class color) (min-colors #xFFFFFF))) ;; GUI/24bit only

  (cyanometric-background-0-hard     "#000000")
  (cyanometric-background-0          "#001919")
  (cyanometric-background-0-soft     "#002020")
  (cyanometric-background-1          "#003030")
  (cyanometric-background-2          "#004040")
  (cyanometric-background-3          "#004747")
  (cyanometric-background-4          "#004F4F")

  (cyanometric-medium                "#00DDDD")

  (cyanometric-foreground-0-hard     "#FFFFFF")
  (cyanometric-foreground-0          "#C0FFFF")
  (cyanometric-foreground-0-soft     "#30FFFF")
  (cyanometric-foreground-1          "#10FFFF")
  (cyanometric-foreground-2          "#0FF0F0")
  (cyanometric-foreground-3          "#0FE0E0")
  (cyanometric-foreground-4          "#0FD0D0")

  (cyanometric-bright-red           "#FF0000")
  (cyanometric-bright-green         "#00FF00")
  (cyanometric-bright-yellow        "#FFFF00")
  (cyanometric-bright-blue          "#0000FF")
  (cyanometric-bright-purple        "#FF00FF")
  (cyanometric-bright-teal          "#008080")
  (cyanometric-bright-orange        "#FF8800")
  (cyanometric-bright-cyan          "#00FFFF")

  (cyanometric-neutral-red          "#00FFFF")
  (cyanometric-neutral-green        "#00FFFF")
  (cyanometric-neutral-yellow       "#02FFFF")
  (cyanometric-neutral-blue         "#40FFFF")
  (cyanometric-neutral-purple       "#40FFFF")
  (cyanometric-neutral-teal         "#50FFFF")
  (cyanometric-neutral-orange       "#00FFFF")
  (cyanometric-neutral-cyan         "#80FFFF")

  (cyanometric-faded-red            "#59FFFF")
  (cyanometric-faded-green          "#40B9B9")
  (cyanometric-faded-yellow         "#59FFFF")
  (cyanometric-faded-blue           "#37A0A0")
  (cyanometric-faded-purple         "#59FFFF")
  (cyanometric-faded-teal           "#329090")
  (cyanometric-faded-orange         "#41BABA")
  (cyanometric-faded-cyan           "#41BABA")

  (cyanometric-muted-red            "#BFFFFF")
  (cyanometric-muted-green          "#8AB9B9")
  (cyanometric-muted-yellow         "#BFFFFF")
  (cyanometric-muted-blue           "#78A0A0")
  (cyanometric-muted-purple         "#BFFFFF")
  (cyanometric-muted-teal           "#6C9090")
  (cyanometric-muted-orange         "#8BBABA")
  (cyanometric-muted-cyan           "#8BBABA")

  (cyanometric-background-red       "#011919")
  (cyanometric-background-green     "#132626")
  (cyanometric-background-yellow    "#012626")
  (cyanometric-background-blue      "#0C2626")
  (cyanometric-background-purple    "#192626")
  (cyanometric-background-teal      "#142626")
  (cyanometric-background-orange    "#002626")
  (cyanometric-background-cyan      "#1E2626")

  (cyanometric-mid-red              "#00BFBF")
  (cyanometric-mid-green            "#0E8989")
  (cyanometric-mid-yellow           "#00AFAF")
  (cyanometric-mid-blue             "#0F9393")
  (cyanometric-mid-purple           "#0FBFBF")
  (cyanometric-mid-teal             "#00B0B0")
  (cyanometric-mid-orange           "#00BFBF")
  (cyanometric-mid-cyan             "#00B2B2")

  (cyanometric-delimiter-1          "#00FFFF")
  (cyanometric-delimiter-2          "#00E1E1")
  (cyanometric-delimiter-3          "#00D0D0")
  (cyanometric-delimiter-4          "#00AAAA")

  (cyanometric-identifiers-1        "#00FFFF")
  (cyanometric-identifiers-2        "#00EDED")
  (cyanometric-identifiers-3        "#00D7D7")
  (cyanometric-identifiers-4        "#00C1C1")
  (cyanometric-identifiers-5        "#00BBBB")
  (cyanometric-identifiers-6        "#00FFFF")
  (cyanometric-identifiers-7        "#00EDED")
  (cyanometric-identifiers-8        "#00D7D7")
  (cyanometric-identifiers-9        "#00C1C1")
  (cyanometric-identifiers-10       "#00BBBB")
  (cyanometric-identifiers-11       "#00FFFF")
  (cyanometric-identifiers-12       "#00EDED")
  (cyanometric-identifiers-13       "#00D7D7")
  (cyanometric-identifiers-14       "#00C1C1")
  (cyanometric-identifiers-15       "#00BBBB")

  (cyanometric-white                "#FFFFFF")
  (cyanometric-black                "#000000")
  (cyanometric-accent-1             "#00FFFF")
  (cyanometric-accent-2             "#00FFFF")
  (cyanometric-accent-3             "#00FFFF")
  (cyanometric-accent-4             "#00FFFF")
  (cyanometric-accent-5             "#00FFFF")
  (cyanometric-accent-6             "#00F7F7")

  (cyanometric-dark-accent-1        "#009898")
  (cyanometric-dark-accent-2        "#008888")
  (cyanometric-dark-accent-3        "#007878")
  (cyanometric-dark-accent-4        "#006868")
  (cyanometric-dark-accent-5        "#005858")
  (cyanometric-dark-accent-6        "#004848"))

 ((Info-quoted                               (:inherit 'fixed-pitch-serif))
  (ac-candidate-face                         (:inherit 'popup-face))
  (ac-candidate-mouse-face                   (:inherit 'popup-menu-mouse-face))
  (ac-cider-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-cider-selection-face                   (:inherit 'ac-selection-face))
  (ac-completion-face                        (:underline t :foreground cyanometric-neutral-purple))
  (ac-dabbrev-menu-face                      (:inherit 'popup-face))
  (ac-dabbrev-selection-face                 (:inherit 'popup-menu-selection-face))
  (ac-emmet-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-emmet-selection-face                   (:inherit 'ac-selection-face))
  (ac-gtags-candidate-face                   (:foreground cyanometric-mid-cyan :inherit 'ac-candidate-face))
  (ac-gtags-selection-face                   (:background cyanometric-background-cyan :inherit 'ac-selection-face))
  (ac-nrepl-candidate-face                   (:inherit 'ac-candidate-face))
  (ac-nrepl-selection-face                   (:inherit 'ac-selection-face))
  (ac-selection-face                         (:inherit 'popup-menu-selection-face))
  (ac-yasnippet-candidate-face               (:foreground cyanometric-black :background cyanometric-foreground-3 :inherit 'ac-candidate-face))
  (ac-yasnippet-selection-face               (:background cyanometric-background-red :inherit 'ac-selection-face))
  (ag-hit-face                               (:foreground cyanometric-foreground-1))
  (ag-match-face                             (:foreground cyanometric-foreground-2))
  (ansible::section-face                     (:foreground cyanometric-neutral-red))
  (ansible::task-label-face                  (:foreground cyanometric-black))
  (anzu-match-1                              (:foreground cyanometric-foreground-0 :background cyanometric-dark-accent-3))
  (anzu-match-2                              (:foreground cyanometric-foreground-0 :background cyanometric-dark-accent-2))
  (anzu-match-3                              (:foreground cyanometric-foreground-0 :background cyanometric-dark-accent-1))
  (anzu-mode-line                            (:foreground cyanometric-foreground-0 :height 100 :background cyanometric-background-3))
  (anzu-mode-line-no-match                   (:inherit 'anzu-mode-line))
  (anzu-replace-highlight                    (:background cyanometric-background-4))
  (anzu-replace-to                           (:background cyanometric-background-3))
  (avy-background-face                       (:foreground cyanometric-background-4))
  (avy-goto-char-timer-face                  (:inherit 'highlight))
  (avy-lead-face                             (:foreground cyanometric-accent-3))
  (avy-lead-face-0                           (:foreground cyanometric-accent-4))
  (avy-lead-face-1                           (:foreground cyanometric-accent-1))
  (avy-lead-face-2                           (:foreground cyanometric-accent-2))
  (bold                                      (:weight 'bold))
  (bold-italic                               (:weight 'bold :slant 'italic))
  (border                                    (:background cyanometric-background-2))

  (buffer-menu-buffer                        (:weight 'bold))
  (button                                    (:inherit 'link))
  (c-annotation-face                         (:inherit 'font-lock-constant-face))
  (change-log-acknowledgment                 (:inherit 'font-lock-comment-face))
  (change-log-conditionals                   (:inherit 'font-lock-variable-name-face))
  (change-log-date                           (:inherit 'font-lock-string-face))
  (change-log-email                          (:inherit 'font-lock-variable-name-face))
  (change-log-file                           (:inherit 'font-lock-function-name-face))
  (change-log-function                       (:inherit 'font-lock-variable-name-face))
  (change-log-list                           (:inherit 'font-lock-keyword-face))
  (change-log-name                           (:inherit 'font-lock-constant-face))
  (col-highlight                             (:inherit 'vline))
  (column-enforce-face                       (:foreground cyanometric-background-4 :background cyanometric-background-red))
  (column-marker-1                           (:background cyanometric-faded-blue))
  (column-marker-2                           (:background cyanometric-faded-purple))

  (column-marker-3                           (:background cyanometric-faded-cyan))
  (comint-highlight-input                    (:weight 'bold))
  (comint-highlight-prompt                   (:inherit 'minibuffer-prompt))
  (company-echo                              (:inherit 'company-echo-common))
  (company-echo-common                       (:foreground cyanometric-bright-blue :background nil))
  (company-preview                           (:inherit 'company-preview-common))
  (company-preview-common                    (:inherit 'font-lock-comment-face))
  (company-preview-common                    (:underline cyanometric-foreground-1))
  (company-preview-search                    (:inherit 'company-preview-common))
  (company-scrollbar-bg                      (:foreground nil :background cyanometric-background-3))
  (company-scrollbar-fg                      (:foreground nil :background cyanometric-background-2))
  (company-template-field                    (:foreground cyanometric-bright-blue :background nil :underline cyanometric-background-blue))
  (company-tooltip                           (:foreground cyanometric-foreground-0-hard :background cyanometric-background-1))
  (company-tooltip-annotation                (:foreground cyanometric-foreground-0 :background cyanometric-background-1))
  (company-tooltip-common                    (:foreground cyanometric-foreground-0 :background cyanometric-background-1))
  (company-tooltip-common-selection          (:foreground cyanometric-foreground-0 :background cyanometric-background-2))
  (company-tooltip-mouse                     (:foreground cyanometric-foreground-0 :background cyanometric-background-3))
  (company-tooltip-selection                 (:foreground cyanometric-foreground-0 :background cyanometric-background-4))
  (compilation-column-number                 (:inherit 'font-lock-doc-face))
  (compilation-error                         (:inherit 'error))
  (compilation-info                          (:foreground cyanometric-neutral-green))
  (compilation-line-number                  (:inherit 'font-lock-keyword-face))
  (compilation-mode-line-exit               (:weight 'bold :foreground cyanometric-mid-teal :inherit 'compilation-info))
  (compilation-mode-line-fail                (:foreground cyanometric-neutral-red))
  (compilation-mode-line-run                (:inherit 'compilation-warning))
  (compilation-warning                      (:inherit 'warning))
  (completions-annotations                   (:inherit 'italic))
  (completions-common-part nil)
  (completions-first-difference              (:inherit 'bold))
  (cua-global-mark                           (:foreground cyanometric-white :background cyanometric-background-3))
  (cua-rectangle                             (:background cyanometric-background-2 :distant-foreground cyanometric-foreground-0))
  (cua-rectangle-noselect                    (:foreground cyanometric-white :background cyanometric-background-4 :inherit 'region))
  (cursor                                    (:background cyanometric-foreground-4))
  (custom-button                             (:box (:line-width 2 :style 'released-button) :foreground cyanometric-black :background cyanometric-identifiers-1))
  (custom-button-mouse                       (:box (:line-width 2 :style 'released-button) :foreground cyanometric-black :background cyanometric-identifiers-2))
  (custom-button-pressed                     (:box (:line-width 2 :style 'pressed-button) :foreground cyanometric-black :background cyanometric-identifiers-1))
  (custom-button-pressed-unraised            (:foreground cyanometric-identifiers-13 :inherit 'custom-button-unraised))
  (custom-button-unraised                    (:inherit 'underline))
  (custom-changed                            (:foreground cyanometric-white :background cyanometric-mid-cyan))
  (custom-comment                            (:background cyanometric-background-4))
  (custom-comment-tag                        (:foreground cyanometric-identifiers-4))
  (custom-documentation nil)
  (custom-face-tag                           (:inherit 'custom-variable-tag))
  (custom-group-subtitle                     (:weight 'bold))
  (custom-group-tag                          (:height 1.2 :weight 'bold :foreground cyanometric-identifiers-9 :inherit 'variable-pitch))
  (custom-group-tag-1                        (:height 1.2 :weight 'bold :foreground cyanometric-identifiers-15 :inherit 'variable-pitch))
  (custom-invalid                            (:foreground cyanometric-foreground-0-hard :background cyanometric-faded-red))
  (custom-link                               (:inherit 'link))
  (custom-modified                           (:foreground cyanometric-white :background cyanometric-mid-cyan))
  (custom-rogue                              (:foreground cyanometric-identifiers-15 :background cyanometric-black))
  (custom-saved                              (:underline t))
  (custom-set                                (:foreground cyanometric-mid-cyan :background cyanometric-white))
  (custom-state                              (:foreground cyanometric-mid-yellow))
  (custom-themed                             (:foreground cyanometric-white :background cyanometric-mid-cyan))
  (custom-variable-button                    (:weight 'bold :underline t))
  (custom-variable-tag                       (:weight 'bold :foreground cyanometric-identifiers-9))
  (custom-visibility                         (:height 0.8 :inherit 'link))
  (default                                   (:foreground cyanometric-foreground-0 :background cyanometric-background-0))
  (describe-variable-value                   (:foreground cyanometric-bright-orange))
  (diff-added                                (:foreground cyanometric-foreground-1 :background cyanometric-background-green))
  (diff-changed                              (:foreground cyanometric-foreground-1 :background cyanometric-background-purple)) (diff-context                              (:foreground cyanometric-identifiers-2)) (diff-file-header                          (:weight 'bold :background cyanometric-faded-purple))
  (diff-function                             (:inherit 'diff-header))
  (diff-header                               (:background cyanometric-background-4))
  (diff-hl-change                            (:inherit 'diff-changed))
  (diff-hl-delete                            (:inherit 'diff-removed)) (diff-hl-insert                            (:inherit 'diff-added)) (diff-hunk-header                          (:inherit 'diff-header)) (diff-index                                (:inherit 'diff-file-header)) (diff-indicator-added                      (:inherit 'diff-added))
  (diff-indicator-changed                    (:inherit 'diff-changed))
  (diff-indicator-removed                    (:inherit 'diff-removed))
  (diff-nonexistent                          (:inherit 'diff-file-header))
  (diff-refine-added                         (:background cyanometric-background-green :inherit 'diff-refine-change))
  (diff-refine-changed                       (:background cyanometric-background-blue))
  (diff-refine-removed                       (:background cyanometric-background-red :inherit 'diff-refine-change))
  (diff-removed                              (:foreground cyanometric-foreground-1 :background cyanometric-background-red))
  (dired-directory                           (:inherit 'font-lock-function-name-face))
  (dired-flagged                             (:inherit 'error))
  (dired-header                              (:inherit 'font-lock-type-face))
  (dired-ignored                             (:inherit 'shadow))
  (dired-mark                                (:inherit 'font-lock-constant-face))
  (dired-marked                              (:inherit 'warning))
  (dired-perm-write                          (:inherit 'font-lock-comment-delimiter-face))
  (dired-subtree-depth-1-face                (:background nil))
  (dired-subtree-depth-2-face                (:background nil))
  (dired-subtree-depth-3-face                (:background nil))
  (dired-subtree-depth-4-face                (:background nil))
  (dired-subtree-depth-5-face                (:background nil))
  (dired-subtree-depth-6-face                (:background nil))
  (dired-symlink                             (:inherit 'font-lock-keyword-face))
  (dired-warning                             (:inherit 'font-lock-warning-face))
  (diredfl-autofile-name                     (:foreground cyanometric-foreground-1))
  (diredfl-compressed-file-name              (:foreground cyanometric-foreground-1))
  (diredfl-compressed-file-suffix            (:foreground cyanometric-foreground-1))
  (diredfl-date-time                         (:foreground cyanometric-accent-5))
  (diredfl-deletion                          (:foreground cyanometric-faded-red))
  (diredfl-deletion-file-name                (:foreground cyanometric-faded-red))
  (diredfl-dir-heading                       (:foreground cyanometric-foreground-1))
  (diredfl-dir-name                          (:foreground cyanometric-bright-cyan))
  (diredfl-dir-priv                          (:foreground cyanometric-bright-cyan :background cyanometric-background-1))
  (diredfl-exec-priv                         (:foreground cyanometric-bright-orange :background cyanometric-background-1))
  (diredfl-executable-tag                    (:foreground cyanometric-bright-orange))
  (diredfl-file-name                         (:foreground cyanometric-faded-teal))
  (diredfl-file-suffix                       (:foreground cyanometric-faded-teal))
  (diredfl-flag-mark                         (:foreground cyanometric-bright-cyan))
  (diredfl-flag-mark-line                    (:foreground cyanometric-foreground-0 :background cyanometric-background-1))
  (diredfl-ignored-file-name                 (:foreground cyanometric-foreground-3))
  (diredfl-link-priv                         (:foreground cyanometric-bright-purple :background cyanometric-background-1))
  (diredfl-no-priv                           (:foreground cyanometric-foreground-4 :background cyanometric-background-1))
  (diredfl-number                            (:foreground cyanometric-foreground-2))
  (diredfl-other-priv                        (:background cyanometric-background-1))
  (diredfl-rare-priv                         (:background cyanometric-background-1))
  (diredfl-read-priv                         (:foreground cyanometric-bright-teal :background cyanometric-background-1))
  (diredfl-symlink                           (:foreground cyanometric-neutral-cyan))
  (diredfl-tagged-autofile-name              (:foreground cyanometric-foreground-1 :background cyanometric-background-1))
  (diredfl-write-priv                        (:foreground cyanometric-bright-green :background cyanometric-background-1))
  (diredp-autofile-name                      (:inherit 'diredfl-autofile-name))
  (diredp-compressed-file-name               (:inherit 'diredfl-compressed-file-name))
  (diredp-compressed-file-suffix             (:inherit 'diredfl-compressed-file-suffix))
  (diredp-date-time                          (:inherit 'diredfl-date-time))
  (diredp-deletion                           (:inherit 'diredfl-deletion))
  (diredp-deletion-file-name                 (:inherit 'diredfl-deletion-file-name))
  (diredp-dir-heading                        (:inherit 'diredfl-dir-heading))
  (diredp-dir-name                           (:inherit 'diredfl-dir-name))
  (diredp-dir-priv                           (:inherit 'diredfl-dir-priv))
  (diredp-exec-priv                          (:inherit 'diredfl-exec-priv))
  (diredp-executable-tag                     (:inherit 'diredfl-executable-tag))
  (diredp-file-name                          (:inherit 'diredfl-file-name))
  (diredp-file-suffix                        (:inherit 'diredfl-file-suffix))
  (diredp-flag-mark                          (:inherit 'diredfl-flag-mark))
  (diredp-flag-mark-line                     (:inherit 'diredfl-flag-mark-line))
  (diredp-ignored-file-name                  (:inherit 'diredfl-ignored-file-name))
  (diredp-link-priv                          (:inherit 'diredfl-link-priv))
  (diredp-no-priv                            (:inherit 'diredfl-no-priv))
  (diredp-number                             (:inherit 'diredfl-number))
  (diredp-other-priv                         (:inherit 'diredfl-other-priv))
  (diredp-rare-priv                          (:inherit 'diredfl-rare-priv))
  (diredp-read-priv                          (:inherit 'diredfl-read-priv))
  (diredp-symlink                            (:inherit 'diredfl-symlink))
  (diredp-tagged-autofile-name               (:inherit 'diredfl-tagged-autofile-name))
  (diredp-write-priv                         (:inherit 'diredfl-write-priv))
  (dropdown-list-face                        (:foreground cyanometric-black :background cyanometric-foreground-0-hard :inherit 'default))
  (dropdown-list-selection-face              (:background cyanometric-bright-purple :inherit 'dropdown-list))
  (el-search-match                           (:background cyanometric-background-cyan))
  (el-search-other-match                     (:background cyanometric-background-blue))
  (eldoc-highlight-function-argument         (:inherit 'bold))
  (elfeed-search-date-face                   (:foreground cyanometric-muted-cyan))
  (elfeed-search-feed-face                   (:foreground cyanometric-faded-cyan))
  (elfeed-search-tag-face                    (:foreground cyanometric-foreground-3))
  (elfeed-search-title-face                  (:foreground cyanometric-foreground-3 :bold nil))
  (elfeed-search-unread-title-face           (:foreground cyanometric-foreground-0-hard :bold nil))
  (elscreen-tab-background-face              (:background cyanometric-background-0 :box nil))
  (elscreen-tab-control-face                 (:foreground cyanometric-neutral-red :background cyanometric-background-2 :box nil :underline nil))
  (elscreen-tab-current-screen-face          (:foreground cyanometric-background-0 :background cyanometric-background-4 :box nil))
  (elscreen-tab-other-screen-face            (:foreground cyanometric-foreground-4 :background cyanometric-background-2 :box nil :underline nil))
  (embrace-help-key-face                     (:foreground   cyanometric-accent-3  :weight 'bold))
  (embrace-help-mark-func-face               (:foreground   cyanometric-accent-4))
  (embrace-help-pair-face                    (:foreground   cyanometric-accent-1))
  (embrace-help-separator-face               (:foreground   cyanometric-accent-2))
  (erc-action-face                           (:inherit 'erc-default-face))
  (erc-bold-face                             (:weight 'bold))
  (erc-button                                (:weight 'bold  :underline t))
  (erc-current-nick-face                     (:foreground cyanometric-accent-3 :weight 'bold))
  (erc-dangerous-host-face                   (:inherit 'font-lock-warning-face))
  (erc-default-face                          (:inherit 'default))
  (erc-direct-msg-face                       (:inherit 'erc-default-face))
  (erc-error-face                            (:inherit 'font-lock-warning-face))
  (erc-fool-face                             (:inherit 'erc-default-face))
  (erc-input-face                            (:foreground cyanometric-accent-3))
  (erc-keyword-face                          (:foreground cyanometric-bright-orange :weight 'bold))
  (erc-my-nick-face                          (:foreground cyanometric-accent-3 :weight 'bold))
  (erc-nick-default-face                     (:weight 'bold))
  (erc-nick-msg-face                         (:inherit 'erc-default-face))
  (erc-notice-face                           (:foreground cyanometric-background-4))
  (erc-pal-face                              (:foreground cyanometric-neutral-yellow :weight 'bold))
  (erc-prompt-face                           (:foreground cyanometric-accent-3 :weight 'bold))
  (erc-timestamp-face                        (:foreground cyanometric-neutral-green))
  (erc-underline-face                        (:underline t))
  (erefactor-highlight-face                  (:inherit 'match))
  (error                                     (:foreground cyanometric-bright-red :bold t))
  (escape-glyph                              (:foreground cyanometric-neutral-cyan))
  (eww-form-checkbox                         (:box (:line-width 2 :style 'released-button) :foreground cyanometric-black :background cyanometric-identifiers-1))
  (eww-form-file                             (:box (:line-width 2 :style 'released-button) :foreground cyanometric-black :background cyanometric-muted-purple))
  (eww-form-select                           (:box (:line-width 2 :style 'released-button) :foreground cyanometric-black :background cyanometric-identifiers-1))
  (eww-form-submit                           (:box (:line-width 2 :style 'released-button) :foreground cyanometric-black :background cyanometric-muted-purple))
  (eww-form-text                             (:box (:line-width 1) :foreground cyanometric-white :background cyanometric-background-2))
  (eww-form-textarea                         (:box (:line-width 1) :foreground cyanometric-black :background cyanometric-neutral-purple))
  (eww-invalid-certificate                   (:weight 'bold :foreground cyanometric-faded-red))
  (eww-valid-certificate                     (:weight 'bold :foreground cyanometric-mid-teal))
  (ffap                                      (:inherit 'highlight))
  (file-name-shadow                          (:inherit 'shadow))
  (fixed-pitch                               (:family "Monospace"))
  (fixed-pitch-serif                         (:family "Monospace Serif"))
  (flx-highlight-face                        (:weight 'bold :underline t :inherit 'font-lock-variable-name-face))
  (flycheck-error                            (:underline (:style 'wave :color cyanometric-faded-red)))
  (flycheck-error-list-checker-name          (:inherit 'font-lock-function-name-face))
  (flycheck-error-list-column-number         (:inherit 'font-lock-constant-face))
  (flycheck-error-list-error                 (:inherit 'error))
  (flycheck-error-list-highlight             (:inherit 'highlight))
  (flycheck-error-list-id                    (:inherit 'font-lock-type-face))
  (flycheck-error-list-id-with-explainer     (:box (:style 'released-button) :inherit 'flycheck-error-list-id))
  (flycheck-error-list-info                  (:inherit 'success))
  (flycheck-error-list-line-number           (:inherit 'font-lock-constant-face))
  (flycheck-error-list-warning               (:inherit 'warning))
  (flycheck-fringe-error                     (:inherit 'error))
  (flycheck-fringe-info                      (:inherit 'success))
  (flycheck-fringe-warning                   (:inherit 'warning))
  (flycheck-info                             (:underline (:style 'wave :color cyanometric-mid-teal)))
  (flycheck-warning                          (:underline (:style 'wave :color cyanometric-bright-red)))
  (flymake-errline                           (:underline (:style 'wave :color cyanometric-faded-red)))
  (flymake-warnline                          (:underline (:style 'wave :color cyanometric-bright-red)))
  (font-latex-math-face                      (:foreground cyanometric-accent-3))
  (font-latex-sectioning-5-face              (:foreground cyanometric-neutral-green))
  (font-latex-string-face                    (:inherit 'font-lock-string-face))
  (font-latex-warning-face                   (:inherit 'warning))
  (font-lock-builtin-face                           (:foreground cyanometric-foreground-3))
  (font-lock-comment-delimiter-face                 (:inherit 'font-lock-comment-face))
  (font-lock-comment-face                           (:foreground cyanometric-foreground-4))
  (font-lock-constant-face                          (:foreground cyanometric-accent-4))
  (font-lock-doc-face                               (:inherit 'font-lock-string-face))
  (font-lock-function-name-face                     (:foreground cyanometric-foreground-2))
  (font-lock-keyword-face                           (:foreground cyanometric-accent-1))
  (font-lock-negation-char-face                     (:foreground cyanometric-foreground-1))
  (font-lock-preprocessor-face                      (:inherit 'font-lock-builtin-face))
  (font-lock-regexp-grouping-backslash              (:inherit 'bold))
  (font-lock-regexp-grouping-construct              (:inherit 'bold))
  (font-lock-string-face                            (:foreground cyanometric-accent-2))
  (font-lock-type-face                              (:foreground cyanometric-accent-3))
  (font-lock-variable-name-face                     (:foreground cyanometric-accent-5))
  (font-lock-warning-face                           (:foreground cyanometric-bright-red :bold t))
  (fringe                                    (:background cyanometric-background-0))
  (git-commit-comment-action                 (:inherit 'git-commit-comment-branch))
  (git-commit-comment-branch                 (:inherit 'font-lock-variable-name-face))
  (git-commit-comment-detached               (:inherit 'git-commit-comment-branch))
  (git-commit-comment-file                   (:inherit 'git-commit-pseudo-header))
  (git-commit-comment-heading                (:inherit 'git-commit-known-pseudo-header))
  (git-commit-known-pseudo-header            (:inherit 'font-lock-keyword-face))
  (git-commit-nonempty-second-line           (:inherit 'font-lock-warning-face))
  (git-commit-note                           (:inherit 'font-lock-string-face))
  (git-commit-overlong-summary               (:inherit 'font-lock-warning-face))
  (git-commit-pseudo-header                  (:inherit 'font-lock-string-face))
  (git-commit-summary                        (:inherit 'font-lock-type-face))
  (git-gutter+-added                         (:foreground cyanometric-bright-green :background cyanometric-background-green))
  (git-gutter+-commit-header-face            (:inherit 'font-lock-comment-face))
  (git-gutter+-deleted                       (:foreground cyanometric-bright-red :background cyanometric-background-red))
  (git-gutter+-modified                      (:foreground cyanometric-bright-purple :background cyanometric-background-purple))
  (git-gutter+-separator                     (:foreground cyanometric-bright-cyan :background cyanometric-muted-cyan))
  (git-gutter+-unchanged                     (:foreground cyanometric-bright-yellow :background cyanometric-muted-yellow))
  (git-gutter-fr+-added                      (:inherit 'git-gutter+-added))
  (git-gutter-fr+-deleted                    (:inherit 'git-gutter+-deleted))
  (git-gutter-fr+-modified                   (:inherit 'git-gutter+-modified))
  (git-gutter-fr:added                       (:foreground cyanometric-bright-green :background cyanometric-background-green))
  (git-gutter-fr:deleted                     (:foreground cyanometric-bright-red :background cyanometric-background-red))
  (git-gutter-fr:modified                    (:foreground cyanometric-bright-purple :background cyanometric-background-purple))
  (git-gutter:added                          (:foreground cyanometric-bright-green :background cyanometric-background-green))
  (git-gutter:deleted                        (:foreground cyanometric-bright-red :background cyanometric-background-red))
  (git-gutter:modified                       (:foreground cyanometric-bright-purple :background cyanometric-background-purple))
  (git-gutter:separator                      (:foreground cyanometric-bright-cyan :background cyanometric-muted-cyan))
  (git-gutter:unchanged                      (:foreground cyanometric-bright-yellow :background cyanometric-muted-yellow))
  (glyphless-char                            (:height 0.6))
  (gnus-group-mail-1                         (:weight 'bold :foreground cyanometric-foreground-0-hard))
  (gnus-group-mail-1-empty                   (:foreground cyanometric-foreground-0-hard))
  (gnus-group-mail-2                         (:weight 'bold :foreground cyanometric-identifiers-4))
  (gnus-group-mail-2-empty                   (:foreground cyanometric-identifiers-4))
  (gnus-group-mail-3                         (:weight 'bold :foreground cyanometric-bright-orange))
  (gnus-group-mail-3-empty                   (:foreground cyanometric-bright-orange))
  (gnus-group-mail-low                       (:weight 'bold :foreground cyanometric-faded-orange))
  (gnus-group-mail-low-empty                 (:foreground cyanometric-faded-orange))
  (gnus-group-news-1                         (:weight 'bold :foreground cyanometric-identifiers-7))
  (gnus-group-news-1-empty                   (:foreground cyanometric-identifiers-7))
  (gnus-group-news-2                         (:weight 'bold :foreground cyanometric-bright-cyan))
  (gnus-group-news-2-empty                   (:foreground cyanometric-bright-cyan))
  (gnus-group-news-3                         (:weight 'bold))
  (gnus-group-news-3-empty nil)
  (gnus-group-news-4                         (:weight 'bold))
  (gnus-group-news-4-empty nil)
  (gnus-group-news-5                         (:weight 'bold))
  (gnus-group-news-5-empty nil)
  (gnus-group-news-6                         (:weight 'bold))
  (gnus-group-news-6-empty nil)
  (gnus-group-news-low                       (:weight 'bold :foreground cyanometric-neutral-cyan))
  (gnus-group-news-low-empty                 (:foreground cyanometric-neutral-cyan))
  (gnus-splash                               (:foreground cyanometric-identifiers-4))
  (gnus-summary-cancelled                    (:foreground cyanometric-foreground-0-hard :background cyanometric-black))
  (gnus-summary-high-ancient                 (:weight 'bold :foreground cyanometric-bright-green))
  (gnus-summary-high-read                    (:weight 'bold :foreground cyanometric-neutral-yellow))
  (gnus-summary-high-ticked                  (:weight 'bold :foreground cyanometric-identifiers-15))
  (gnus-summary-high-undownloaded            (:weight 'bold :foreground cyanometric-identifiers-1))
  (gnus-summary-high-unread                  (:weight 'bold))
  (gnus-summary-low-ancient                  (:slant 'italic :foreground cyanometric-bright-green))
  (gnus-summary-low-read                     (:slant 'italic :foreground cyanometric-neutral-yellow))
  (gnus-summary-low-ticked                   (:slant 'italic :foreground cyanometric-identifiers-15))
  (gnus-summary-low-undownloaded             (:weight 'normal :slant 'italic :foreground cyanometric-faded-cyan))
  (gnus-summary-low-unread                   (:slant 'italic))
  (gnus-summary-normal-ancient               (:foreground cyanometric-bright-green))
  (gnus-summary-normal-read                  (:foreground cyanometric-neutral-yellow))
  (gnus-summary-normal-ticked                (:foreground cyanometric-identifiers-15))
  (gnus-summary-normal-undownloaded          (:weight 'normal :foreground cyanometric-faded-cyan))
  (gnus-summary-normal-unread nil)
  (gnus-summary-selected                     (:underline t))
  (haskell-constructor-face                  (:foreground cyanometric-neutral-teal :background nil))
  (haskell-debug-heading-face                (:inherit ('quote 'font-lock-keyword-face)))
  (haskell-debug-keybinding-face             (:weight 'bold :inherit ('quote 'font-lock-type-face)))
  (haskell-debug-muted-face                  (:foreground cyanometric-muted-purple))
  (haskell-debug-newline-face                (:weight 'bold :background cyanometric-white))
  (haskell-debug-trace-number-face           (:weight 'bold :background cyanometric-white))
  (haskell-debug-warning-face                (:inherit ('quote 'compilation-warning)))
  (haskell-error-face                        (:underline (:style 'wave :color cyanometric-bright-red)))
  (haskell-hole-face                         (:underline (:style 'wave :color cyanometric-muted-green)))
  (haskell-interactive-face-compile-error    (:underline (:color cyanometric-bright-red :style 'wave)))
  (haskell-interactive-face-compile-warning  (:underline (:color cyanometric-bright-yellow :style 'wave)))
  (haskell-interactive-face-garbage          (:foreground cyanometric-background-4 :background nil))
  (haskell-interactive-face-prompt           (:foreground cyanometric-foreground-0 :background nil))
  (haskell-interactive-face-prompt2          (:inherit 'font-lock-keyword-face))
  (haskell-interactive-face-result           (:foreground cyanometric-foreground-3 :background nil))
  (haskell-keyword-face                      (:inherit 'font-lock-keyword-face))
  (haskell-liquid-haskell-annotation-face    (:inherit 'haskell-pragma-face))
  (haskell-literate-comment-face             (:foreground cyanometric-foreground-0 :background nil))
  (haskell-operator-face                     (:inherit 'font-lock-variable-name-face))
  (haskell-pragma-face                       (:foreground cyanometric-medium :background nil))
  (haskell-type-face                         (:inherit 'font-lock-type-face))
  (haskell-warning-face                      (:underline (:style 'wave :color cyanometric-medium)))
  (header-line                               (:foreground cyanometric-accent-6 :background cyanometric-background-0 :bold nil))
  (helm-M-x-key                              (:foreground cyanometric-neutral-orange))
  (helm-action                               (:foreground cyanometric-white :underline t))
  (helm-bookmark-addressbook                 (:foreground cyanometric-neutral-red))
  (helm-bookmark-directory                   (:foreground cyanometric-bright-purple))
  (helm-bookmark-file                        (:foreground cyanometric-faded-blue))
  (helm-bookmark-gnus                        (:foreground cyanometric-faded-purple))
  (helm-bookmark-info                        (:foreground cyanometric-accent-6))
  (helm-bookmark-man                         (:foreground cyanometric-accent-1))
  (helm-bookmark-w3m                         (:foreground cyanometric-neutral-yellow))
  (helm-buffer-directory                     (:foreground cyanometric-white :background cyanometric-bright-blue))
  (helm-buffer-not-saved                     (:foreground cyanometric-faded-red))
  (helm-buffer-process                       (:foreground cyanometric-accent-4))
  (helm-buffer-saved-out                     (:foreground cyanometric-bright-red))
  (helm-buffer-size                          (:foreground cyanometric-bright-purple))
  (helm-candidate-number                     (:foreground cyanometric-neutral-green))
  (helm-ff-directory                         (:foreground cyanometric-neutral-purple))
  (helm-ff-executable                        (:foreground cyanometric-accent-6))
  (helm-ff-file                              (:foreground cyanometric-accent-1))
  (helm-ff-invalid-symlink                   (:foreground cyanometric-white :background cyanometric-bright-red))
  (helm-ff-prefix                            (:foreground cyanometric-black :background cyanometric-neutral-yellow))
  (helm-ff-symlink                           (:foreground cyanometric-neutral-orange))
  (helm-grep-cmd-line                        (:foreground cyanometric-neutral-green))
  (helm-grep-file                            (:foreground cyanometric-faded-purple))
  (helm-grep-finish                          (:foreground cyanometric-accent-6))
  (helm-grep-lineno                          (:foreground cyanometric-neutral-orange))
  (helm-grep-match                           (:foreground cyanometric-neutral-yellow))
  (helm-grep-running                         (:foreground cyanometric-neutral-red))
  (helm-header                               (:foreground cyanometric-accent-5))
  (helm-helper                               (:foreground cyanometric-accent-5))
  (helm-history-deleted                      (:foreground cyanometric-black :background cyanometric-bright-red))
  (helm-history-remote                       (:foreground cyanometric-faded-red))
  (helm-lisp-completion-info                 (:foreground cyanometric-faded-orange))
  (helm-lisp-show-completion                 (:foreground cyanometric-bright-red))
  (helm-locate-finish                        (:foreground cyanometric-white :background cyanometric-accent-5))
  (helm-match                                (:foreground cyanometric-neutral-orange))
  (helm-moccur-buffer                        (:foreground cyanometric-bright-teal :underline t))
  (helm-prefarg                              (:foreground cyanometric-accent-6))
  (helm-selection                            (:foreground cyanometric-white :background cyanometric-background-2))
  (helm-selection-line                       (:foreground cyanometric-white :background cyanometric-background-2))
  (helm-separator                            (:foreground cyanometric-faded-red))
  (helm-source-header                        (:foreground cyanometric-foreground-2 :background cyanometric-background-1))
  (helm-visible-mark                         (:foreground cyanometric-black :background cyanometric-foreground-3))
  (help-argument-name                        (:inherit 'italic))
  (hi-black-b                                (:foreground cyanometric-bright-orange :background cyanometric-background-0-hard :bold t))
  (hi-black-hb                               (:foreground cyanometric-bright-cyan :background cyanometric-background-0-hard :bold t))
  (hi-blue                                   (:foreground cyanometric-background-0-hard :background cyanometric-bright-blue))
  (hi-blue-b                                 (:foreground cyanometric-bright-blue :bold t))
  (hi-green                                  (:foreground cyanometric-background-0-hard :background cyanometric-bright-green))
  (hi-green-b                                (:foreground cyanometric-bright-green :bold t))
  (hi-pink                                   (:foreground cyanometric-background-0-hard :background cyanometric-bright-purple))
  (hi-red-b                                  (:foreground cyanometric-bright-red :bold t))
  (hi-yellow                                 (:foreground cyanometric-background-0-hard :background cyanometric-bright-yellow))
  (highlight                                 (:foreground cyanometric-foreground-0-hard :background cyanometric-background-3))
  (highlight-indentation-current-column-face (:background cyanometric-background-4))
  (highlight-indentation-face                (:background cyanometric-background-1))
  (highlight-numbers-number                  (:foreground cyanometric-foreground-1 :bold t))
  (highlight-symbol-face                     (:foreground cyanometric-neutral-purple))
  (hl-line                                   (:background cyanometric-background-1))
  (hl-spotlight                              (:inherit 'highlight))
  (hydra-face-amaranth                       (:foreground cyanometric-accent-4))
  (hydra-face-blue                           (:foreground cyanometric-accent-2))
  (hydra-face-pink                           (:foreground cyanometric-accent-3))
  (hydra-face-red                            (:foreground cyanometric-accent-1))
  (hydra-face-teal                           (:foreground cyanometric-accent-5))
  (ido-first-match                           (:foreground cyanometric-faded-cyan :background cyanometric-background-0-hard))
  (ido-incomplete-regexp                     (:inherit 'font-lock-warning-face))
  (ido-indicator                             (:background cyanometric-bright-red :foreground cyanometric-bright-yellow))
  (ido-only-match                            (:foreground cyanometric-accent-2))
  (ido-subdir                                (:foreground cyanometric-foreground-3))
  (ido-vertical-first-match-face             (:foreground cyanometric-faded-cyan :background cyanometric-background-blue))
  (ido-vertical-match-face                   (:bold t))
  (ido-vertical-only-match-face              (:foreground cyanometric-faded-cyan))
  (ido-virtual                               (:inherit 'font-lock-builtin-face))
  (iedit-occurrence                          (:inherit 'highlight))
  (iedit-read-only-occurrence                (:inherit 'region))
  (info-header-node                          (:inherit 'info-node))
  (info-header-xref                          (:inherit 'info-xref))
  (info-index-match                          (:inherit 'match))
  (info-menu-header                          (:weight 'bold :inherit 'variable-pitch))
  (info-menu-star                            (:foreground cyanometric-faded-red))
  (info-node                                 (:weight 'bold :slant 'italic :foreground cyanometric-white))
  (info-title-1                              (:height 1.2 :inherit 'info-title-2))
  (info-title-2                              (:height 1.2 :inherit 'info-title-3))
  (info-title-3                              (:height 1.2 :inherit 'info-title-4))
  (info-title-4                              (:weight 'bold :inherit 'variable-pitch))
  (info-xref                                 (:inherit 'link))
  (info-xref-visited                         (:inherit ('link-visited 'info-xref)))
  (isearch                                   (:foreground cyanometric-foreground-0-hard :background cyanometric-background-2))
  (isearch-fail                              (:foreground cyanometric-foreground-0-hard :background cyanometric-background-red))
  (isearch-group-1                           (:foreground cyanometric-foreground-0-hard :background cyanometric-dark-accent-3))
  (isearch-group-2                           (:foreground cyanometric-foreground-0-hard :background cyanometric-dark-accent-5))
  (italic                                    (:slant 'italic))
  (ivy-action                                (:inherit 'font-lock-builtin-face))
  (ivy-confirm-face                          (:foreground cyanometric-bright-green))
  (ivy-current-match                         (:foreground cyanometric-foreground-0 :background cyanometric-background-3))
  (ivy-cursor                                (:foreground cyanometric-white :background cyanometric-black))
  (ivy-match-required-face                   (:foreground cyanometric-bright-red))
  (ivy-minibuffer-match-face-1               (:background cyanometric-background-1))
  (ivy-minibuffer-match-face-2               (:background cyanometric-background-2))
  (ivy-minibuffer-match-face-3               (:background cyanometric-faded-teal))
  (ivy-minibuffer-match-face-4               (:background cyanometric-faded-purple))
  (ivy-modified-buffer                       (:inherit 'default))
  (ivy-remote                                (:foreground cyanometric-neutral-blue))
  (ivy-subdir                                (:inherit 'dired-directory))
  (ivy-virtual                               (:inherit 'font-lock-builtin-face))
  (js2-error                                 (:underline (:color cyanometric-bright-red :style 'wave)))
  (js2-external-variable                     (:underline (:color cyanometric-bright-teal :style 'wave)))
  (js2-function-call                         (:foreground cyanometric-bright-blue :background nil))
  (js2-function-param                        (:foreground cyanometric-bright-teal :background nil))
  (js2-instance-member                       (:foreground cyanometric-bright-orange :background nil))
  (js2-jsdoc-html-tag-delimiter              (:foreground cyanometric-foreground-3 :background nil))
  (js2-jsdoc-html-tag-name                   (:foreground cyanometric-foreground-4 :background nil))
  (js2-jsdoc-tag                             (:foreground cyanometric-medium :background nil))
  (js2-jsdoc-type                            (:foreground cyanometric-foreground-4 :background nil))
  (js2-jsdoc-value                           (:foreground cyanometric-foreground-3 :background nil))
  (js2-object-property                       (:inherit 'default))
  (js2-private-function-call                 (:foreground cyanometric-faded-teal :background nil))
  (js2-private-member                        (:foreground cyanometric-faded-yellow :background nil))
  (js2-warning                               (:underline (:color cyanometric-bright-yellow :style 'wave)))
  (lacarte-shortcut                          (:foreground cyanometric-neutral-purple))
  (lazy-highlight                            (:foreground cyanometric-foreground-0 :background cyanometric-background-3))
  (link                                      (:foreground cyanometric-faded-blue :underline t))
  (link-visited                              (:foreground cyanometric-faded-blue :underline nil))
  (linum                                     (:foreground cyanometric-background-4))
  (linum-relative-current-face               (:foreground cyanometric-foreground-4 :background cyanometric-background-1))
  (log-edit-header                           (:inherit 'font-lock-keyword-face))
  (log-edit-summary                          (:inherit 'font-lock-function-name-face))
  (log-edit-unknown-header                   (:inherit 'font-lock-comment-face))
  (lv-separator                              (:background cyanometric-background-2))
  (magit-bisect-bad                          (:foreground cyanometric-faded-red))
  (magit-bisect-good                         (:foreground cyanometric-neutral-green))
  (magit-bisect-skip                         (:foreground cyanometric-foreground-2))
  (magit-blame-date                          (:inherit 'magit-blame-heading))
  (magit-blame-hash                          (:inherit 'magit-blame-heading))
  (magit-blame-heading                       (:background cyanometric-background-1 :foreground cyanometric-foreground-0))
  (magit-blame-name                          (:inherit 'magit-blame-heading))
  (magit-blame-summary                       (:inherit 'magit-blame-heading))
  (magit-branch                              (:foreground cyanometric-accent-6 :background nil))
  (magit-branch-current                      (:box 1 :inherit 'magit-branch-local))
  (magit-branch-local                        (:foreground cyanometric-accent-6 :background nil))
  (magit-branch-remote                       (:foreground cyanometric-accent-5 :background nil))
  (magit-cherry-equivalent                   (:foreground cyanometric-neutral-orange))
  (magit-cherry-unmatched                    (:foreground cyanometric-neutral-purple))
  (magit-diff-add                            (:foreground cyanometric-bright-green))
  (magit-diff-added                          (:foreground cyanometric-bright-green :background cyanometric-background-green))
  (magit-diff-added-highlight                (:foreground cyanometric-bright-green :background cyanometric-background-green))
  (magit-diff-base                           (:foreground cyanometric-foreground-0-hard :background cyanometric-background-2))
  (magit-diff-base-highlight                 (:foreground cyanometric-foreground-0-soft :background cyanometric-background-3))
  (magit-diff-conflict-heading               (:inherit 'magit-diff-hunk-heading))
  (magit-diff-context                        (:foreground cyanometric-foreground-4 :background nil))
  (magit-diff-context-highlight              (:foreground cyanometric-foreground-4 :background cyanometric-background-0-soft))
  (magit-diff-del                            (:foreground cyanometric-bright-red))
  (magit-diff-file-header                    (:foreground cyanometric-foreground-0))
  (magit-diff-file-heading                   (:weight 'bold))
  (magit-diff-file-heading-highlight         (:inherit ('magit-section-highlight)))
  (magit-diff-file-heading-selection         (:foreground cyanometric-medium :inherit 'magit-diff-file-heading-highlight))
  (magit-diff-hunk-header                    (:foreground cyanometric-neutral-teal))
  (magit-diff-hunk-heading                   (:foreground cyanometric-neutral-purple :background cyanometric-background-1))
  (magit-diff-hunk-heading-highlight         (:foreground cyanometric-neutral-purple :background cyanometric-background-3))
  (magit-diff-hunk-heading-selection         (:foreground cyanometric-medium :inherit 'magit-diff-hunk-heading-highlight))
  (magit-diff-hunk-region                    (:inherit 'bold))
  (magit-diff-lines-boundary                 (:inherit 'magit-diff-lines-heading))
  (magit-diff-lines-heading                  (:foreground cyanometric-identifiers-4 :background cyanometric-background-2 :inherit 'magit-diff-hunk-heading-highlight))
  (magit-diff-merge-current                  (:background cyanometric-background-yellow))
  (magit-diff-merge-diff3-separator          (:foreground cyanometric-neutral-orange :weight 'bold))
  (magit-diff-merge-proposed                 (:background cyanometric-background-green))
  (magit-diff-merge-separator                (:foreground cyanometric-neutral-orange))
  (magit-diff-none                           (:foreground cyanometric-medium))
  (magit-diff-our                            (:inherit 'magit-diff-removed))
  (magit-diff-our-highlight                  (:inherit 'magit-diff-removed-highlight))
  (magit-diff-removed                        (:foreground cyanometric-bright-red :background cyanometric-background-red))
  (magit-diff-removed-highlight              (:foreground cyanometric-bright-red :background cyanometric-background-red))
  (magit-diff-their                          (:inherit 'magit-diff-added))
  (magit-diff-their-highlight                (:inherit 'magit-diff-added-highlight))
  (magit-diff-whitespace-warning             (:inherit 'trailing-whitespace))
  (magit-diffstat-added                      (:foreground cyanometric-delimiter-3))
  (magit-diffstat-removed                    (:foreground cyanometric-background-2))
  (magit-dimmed                              (:foreground cyanometric-muted-purple))
  (magit-filename                            (:weight 'normal))
  (magit-hash                                (:foreground cyanometric-background-3))
  (magit-head                                (:inherit 'magit-branch-local))
  (magit-header-line                         (:inherit 'magit-section-heading))
  (magit-item-highlight                      (:background cyanometric-background-1 :weight 'normal))
  (magit-item-mark                           (:background cyanometric-background-0))
  (magit-key-mode-args-face                  (:foreground cyanometric-foreground-4))
  (magit-key-mode-button-face                (:foreground cyanometric-neutral-orange :weight 'bold))
  (magit-key-mode-header-face                (:foreground cyanometric-foreground-4 :weight 'bold))
  (magit-key-mode-switch-face                (:foreground cyanometric-accent-6 :weight 'bold))
  (magit-log-author                          (:foreground cyanometric-neutral-teal))
  (magit-log-date                            (:foreground cyanometric-faded-orange))
  (magit-log-graph                           (:foreground cyanometric-foreground-1))
  (magit-log-head-label-bisect-bad           (:foreground cyanometric-bright-red))
  (magit-log-head-label-bisect-good          (:foreground cyanometric-bright-green))
  (magit-log-head-label-bisect-skip          (:foreground cyanometric-neutral-yellow))
  (magit-log-head-label-default              (:foreground cyanometric-neutral-blue))
  (magit-log-head-label-head                 (:foreground cyanometric-foreground-0 :background cyanometric-background-teal))
  (magit-log-head-label-local                (:foreground cyanometric-faded-blue :weight 'bold))
  (magit-log-head-label-patches              (:foreground cyanometric-faded-orange))
  (magit-log-head-label-remote               (:foreground cyanometric-neutral-blue :weight 'bold))
  (magit-log-head-label-tags                 (:foreground cyanometric-neutral-teal))
  (magit-log-head-label-wip                  (:foreground cyanometric-neutral-red))
  (magit-log-message                         (:foreground cyanometric-foreground-1))
  (magit-log-reflog-label-amend              (:foreground cyanometric-bright-blue))
  (magit-log-reflog-label-checkout           (:foreground cyanometric-bright-yellow))
  (magit-log-reflog-label-cherry-pick        (:foreground cyanometric-neutral-red))
  (magit-log-reflog-label-commit             (:foreground cyanometric-neutral-green))
  (magit-log-reflog-label-merge              (:foreground cyanometric-bright-green))
  (magit-log-reflog-label-other              (:foreground cyanometric-faded-red))
  (magit-log-reflog-label-rebase             (:foreground cyanometric-bright-blue))
  (magit-log-reflog-label-remote             (:foreground cyanometric-neutral-orange))
  (magit-log-reflog-label-reset              (:foreground cyanometric-neutral-yellow))
  (magit-log-sha1                            (:foreground cyanometric-bright-orange))
  (magit-popup-argument                      (:inherit 'font-lock-warning-face))
  (magit-popup-disabled-argument             (:foreground cyanometric-foreground-4))
  (magit-popup-heading                       (:inherit 'font-lock-keyword-face))
  (magit-popup-key                           (:inherit 'font-lock-builtin-face))
  (magit-popup-option-value                  (:inherit 'font-lock-string-face))
  (magit-process-ng                          (:foreground cyanometric-bright-red :weight 'bold))
  (magit-process-ok                          (:foreground cyanometric-bright-green :weight 'bold))
  (magit-reflog-amend                        (:foreground cyanometric-identifiers-13))
  (magit-reflog-checkout                     (:foreground cyanometric-mid-cyan))
  (magit-reflog-cherry-pick                  (:foreground cyanometric-black))
  (magit-reflog-commit                       (:foreground cyanometric-black))
  (magit-reflog-merge                        (:foreground cyanometric-black))
  (magit-reflog-other                        (:foreground cyanometric-neutral-cyan))
  (magit-reflog-rebase                       (:foreground cyanometric-identifiers-13))
  (magit-reflog-remote                       (:foreground cyanometric-neutral-cyan))
  (magit-reflog-reset                        (:foreground cyanometric-faded-red))
  (magit-refname                             (:foreground cyanometric-foreground-2))
  (magit-refname-stash                       (:inherit 'magit-refname))
  (magit-refname-wip                         (:inherit 'magit-refname))
  (magit-section-heading                     (:foreground cyanometric-foreground-2 :background cyanometric-background-blue))
  (magit-section-heading-selection           (:foreground cyanometric-medium))
  (magit-section-highlight                   (:background cyanometric-background-0-soft))
  (magit-section-secondary-heading           (:weight 'bold))
  (magit-sequence-done                       (:inherit 'magit-hash))
  (magit-sequence-drop                       (:foreground cyanometric-faded-red))
  (magit-sequence-head                       (:foreground cyanometric-faded-cyan))
  (magit-sequence-onto                       (:inherit 'magit-sequence-done))
  (magit-sequence-part                       (:foreground cyanometric-bright-yellow))
  (magit-sequence-pick                       (:inherit 'default))
  (magit-sequence-stop                       (:foreground cyanometric-bright-teal))
  (magit-signature-bad                       (:foreground cyanometric-bright-red :weight 'bold))
  (magit-signature-error                     (:foreground cyanometric-muted-red))
  (magit-signature-expired                   (:foreground cyanometric-bright-red))
  (magit-signature-expired-key               (:inherit 'magit-signature-expired))
  (magit-signature-good                      (:foreground cyanometric-bright-green :weight 'bold))
  (magit-signature-none                      (:foreground cyanometric-faded-red))
  (magit-signature-revoked                   (:foreground cyanometric-foreground-3))
  (magit-signature-untrusted                 (:foreground cyanometric-bright-purple :weight 'bold))
  (magit-tag                                 (:foreground cyanometric-accent-2))
  (magit-whitespace-warning-face             (:background cyanometric-faded-red))
  (markdown-header-face-1                    (:height 1.9 :inherit 'variable-pitch :foreground cyanometric-foreground-4))
  (markdown-header-face-2                    (:height 1.8 :inherit 'variable-pitch :foreground cyanometric-foreground-3))
  (markdown-header-face-3                    (:height 1.6 :inherit 'variable-pitch :foreground cyanometric-foreground-2))
  (markdown-header-face-4                    (:height 1.5 :inherit 'variable-pitch :foreground cyanometric-foreground-1))
  (markdown-header-face-5                    (:height 1.4 :inherit 'variable-pitch :foreground cyanometric-foreground-0-soft))
  (markdown-header-face-6                    (:height 1.3 :inherit 'variable-pitch :foreground cyanometric-foreground-0))
  (match                                     (:foreground cyanometric-foreground-0 :background cyanometric-background-2))
  (mc/cursor-bar-face                        (:height 1 :background cyanometric-black))
  (mc/cursor-face                            (:inverse-video t))
  (mc/region-face                            (:inherit 'region))
  (menu nil)
  (message-cited-text                        (:foreground cyanometric-foreground-3))
  (message-header-cc                         (:foreground cyanometric-bright-cyan))
  (message-header-name                       (:foreground cyanometric-bright-cyan))
  (message-header-newsgroups                 (:foreground cyanometric-bright-cyan))
  (message-header-other                      (:foreground cyanometric-muted-cyan))
  (message-header-subject                    (:foreground cyanometric-foreground-2))
  (message-header-to                         (:foreground cyanometric-bright-cyan))
  (message-header-xheader                    (:foreground cyanometric-faded-cyan))
  (message-mml                               (:foreground cyanometric-faded-teal))
  (message-separator                         (:foreground cyanometric-faded-cyan))
  (minibuffer-complete-cycle                 (:inherit 'secondary-selection))
  (minibuffer-prompt                         (:foreground cyanometric-accent-1 :background cyanometric-background-0 :bold nil))
  (mm-command-output                         (:foreground cyanometric-mid-teal))
  (mode-line                                 (:foreground cyanometric-foreground-1 :background cyanometric-background-0-hard :box nil))
  (mode-line-buffer-id                       (:weight 'bold))
  (mode-line-emphasis                        (:weight 'bold))
  (mode-line-highlight                       (:box (:line-width 2 :color cyanometric-background-3 :style 'released-button)))
  (mode-line-inactive                        (:foreground cyanometric-foreground-4 :background cyanometric-background-2 :box nil))
  (mouse nil)
  (nameless-face                             (:inherit 'font-lock-type-face))
  (next-error                                (:inherit 'region))
  (nobreak-space                             (:underline t :inherit 'escape-glyph))
  (orderless-match-face-0                    (:foreground cyanometric-accent-1))
  (orderless-match-face-1                    (:foreground cyanometric-accent-2))
  (orderless-match-face-2                    (:foreground cyanometric-accent-3))
  (orderless-match-face-3                    (:foreground cyanometric-accent-4))
  (org-agenda-date-today                     (:foreground cyanometric-foreground-2 :slant 'italic :weight 'bold))
  (org-agenda-structure                      (:inherit 'font-lock-comment-face))
  (org-archived                              (:foreground cyanometric-foreground-0 :weight 'bold))
  (org-checkbox                              (:foreground cyanometric-foreground-2 :background cyanometric-background-0 :box (:line-width 1 :style 'released-button)))
  (org-column                                (:background cyanometric-background-0))
  (org-column-title                          (:background cyanometric-background-0-hard :underline t :weight 'bold))
  (org-date                                  (:foreground cyanometric-faded-blue :underline t))
  (org-deadline-announce                     (:foreground cyanometric-faded-red))
  (org-done                                  (:foreground cyanometric-bright-green :bold t :weight 'bold))
  (org-ellipsis                              (:foreground cyanometric-bright-yellow :underline t))
  (org-footnote                              (:foreground cyanometric-faded-teal :underline t))
  (org-formula                               (:foreground cyanometric-bright-yellow))
  (org-headline-done                         (:foreground cyanometric-bright-green))
  (org-hide                                  (:foreground cyanometric-background-0))
  (org-level-1                               (:foreground cyanometric-bright-orange))
  (org-level-2                               (:foreground cyanometric-bright-green))
  (org-level-3                               (:foreground cyanometric-bright-blue))
  (org-level-4                               (:foreground cyanometric-bright-yellow))
  (org-level-5                               (:foreground cyanometric-faded-teal))
  (org-level-6                               (:foreground cyanometric-bright-green))
  (org-level-7                               (:foreground cyanometric-bright-red))
  (org-level-8                               (:foreground cyanometric-bright-blue))
  (org-link                                  (:foreground cyanometric-bright-yellow :underline t))
  (org-mode-line-clock                       (:foreground cyanometric-foreground-2 :background cyanometric-background-0))
  (org-mode-line-clock-overrun               (:foreground cyanometric-black :background cyanometric-bright-red))
  (org-scheduled                             (:foreground cyanometric-bright-green))
  (org-scheduled-previously                  (:foreground cyanometric-bright-red))
  (org-scheduled-today                       (:foreground cyanometric-bright-blue))
  (org-sexp-date                             (:foreground cyanometric-bright-blue :underline t))
  (org-special-keyword                       (:inherit 'font-lock-comment-face))
  (org-table                                 (:foreground cyanometric-bright-green))
  (org-tag                                   (:bold t :weight 'bold))
  (org-time-grid                             (:foreground cyanometric-bright-orange))
  (org-todo                                  (:foreground cyanometric-bright-red :weight 'bold :bold t))
  (org-upcoming-deadline                     (:inherit 'font-lock-keyword-face))
  (org-warning                               (:foreground cyanometric-bright-red :weight 'bold :underline nil :bold t))
  (package-description                       (:inherit 'default))
  (package-help-section-name                 (:inherit ('bold 'font-lock-function-name-face)))
  (package-name                              (:inherit 'link))
  (package-status-avail-obso                 (:inherit 'package-status-incompat))
  (package-status-available                  (:inherit 'default))
  (package-status-built-in                   (:inherit 'font-lock-builtin-face))
  (package-status-dependency                 (:inherit 'package-status-installed))
  (package-status-disabled                   (:inherit 'font-lock-warning-face))
  (package-status-external                   (:inherit 'package-status-built-in))
  (package-status-held                       (:inherit 'font-lock-constant-face))
  (package-status-incompat                   (:inherit 'font-lock-comment-face))
  (package-status-installed                  (:inherit 'font-lock-comment-face))
  (package-status-new                        (:inherit ('bold 'package-status-available)))
  (package-status-unsigned                   (:inherit 'font-lock-warning-face))
  (popup-face                                (:foreground cyanometric-foreground-0 :background cyanometric-background-1))
  (popup-isearch-match                       (:background cyanometric-background-green :inherit 'default))
  (popup-menu-face                           (:inherit 'popup-face))
  (popup-menu-mouse-face                     (:foreground cyanometric-foreground-0 :background cyanometric-faded-blue))
  (popup-menu-selection-face                 (:foreground cyanometric-foreground-0 :background cyanometric-faded-blue))
  (popup-menu-summary-face                   (:inherit 'popup-summary-face))
  (popup-scroll-bar-background-face          (:background cyanometric-neutral-purple))
  (popup-scroll-bar-foreground-face          (:background cyanometric-black))
  (popup-summary-face                        (:foreground cyanometric-background-4 :inherit 'popup-face))
  (popup-tip-face                            (:foreground cyanometric-foreground-0-hard :background cyanometric-background-teal))
  (powerline-active1                         (:background cyanometric-background-2 :inherit 'mode-line))
  (powerline-active2                         (:background cyanometric-background-1 :inherit 'mode-line))
  (powerline-inactive1                       (:background cyanometric-medium :inherit 'mode-line-inactive))
  (powerline-inactive2                       (:background cyanometric-background-2 :inherit 'mode-line-inactive))
  (query-replace                             (:inherit 'isearch))
  (rainbow-delimiters-depth-1-face           (:foreground cyanometric-delimiter-1))
  (rainbow-delimiters-depth-10-face          (:foreground cyanometric-delimiter-2))
  (rainbow-delimiters-depth-11-face          (:foreground cyanometric-delimiter-3))
  (rainbow-delimiters-depth-12-face          (:foreground cyanometric-delimiter-4))
  (rainbow-delimiters-depth-2-face           (:foreground cyanometric-delimiter-2))
  (rainbow-delimiters-depth-3-face           (:foreground cyanometric-delimiter-3))
  (rainbow-delimiters-depth-4-face           (:foreground cyanometric-delimiter-4))
  (rainbow-delimiters-depth-5-face           (:foreground cyanometric-delimiter-1))
  (rainbow-delimiters-depth-6-face           (:foreground cyanometric-delimiter-2))
  (rainbow-delimiters-depth-7-face           (:foreground cyanometric-delimiter-3))
  (rainbow-delimiters-depth-8-face           (:foreground cyanometric-delimiter-4))
  (rainbow-delimiters-depth-9-face           (:foreground cyanometric-delimiter-1))
  (rainbow-delimiters-mismatched-face        (:inherit 'rainbow-delimiters-unmatched-face))
  (rainbow-delimiters-unmatched-face         (:foreground cyanometric-foreground-0 :background nil))
  (rainbow-identifiers-identifier-1          (:foreground cyanometric-identifiers-1))
  (rainbow-identifiers-identifier-10         (:foreground cyanometric-identifiers-10))
  (rainbow-identifiers-identifier-11         (:foreground cyanometric-identifiers-11))
  (rainbow-identifiers-identifier-12         (:foreground cyanometric-identifiers-12))
  (rainbow-identifiers-identifier-13         (:foreground cyanometric-identifiers-13))
  (rainbow-identifiers-identifier-14         (:foreground cyanometric-identifiers-14))
  (rainbow-identifiers-identifier-15         (:foreground cyanometric-identifiers-15))
  (rainbow-identifiers-identifier-2          (:foreground cyanometric-identifiers-2))
  (rainbow-identifiers-identifier-3          (:foreground cyanometric-identifiers-3))
  (rainbow-identifiers-identifier-4          (:foreground cyanometric-identifiers-4))
  (rainbow-identifiers-identifier-5          (:foreground cyanometric-identifiers-5))
  (rainbow-identifiers-identifier-6          (:foreground cyanometric-identifiers-6))
  (rainbow-identifiers-identifier-7          (:foreground cyanometric-identifiers-7))
  (rainbow-identifiers-identifier-8          (:foreground cyanometric-identifiers-8))
  (rainbow-identifiers-identifier-9          (:foreground cyanometric-identifiers-9))
  (rectangle-preview                         (:inherit 'region))
  (region                                    (:background cyanometric-background-2 :distant-foreground cyanometric-foreground-0))
  (ripgrep-hit-face                          (:inherit 'ag-hit-face))
  (ripgrep-match-face                        (:inherit 'ag-match-face))
  (scroll-bar nil)
  (secondary-selection                       (:background cyanometric-background-3))
  (semantic-highlight-edits-face             (:background cyanometric-background-0-soft))
  (semantic-highlight-func-current-tag-face  (:background cyanometric-background-0-soft))
  (semantic-unmatched-syntax-face            (:underline cyanometric-faded-red))
  (sgml-namespace                            (:inherit 'font-lock-builtin-face))
  (sh-heredoc                                (:foreground cyanometric-accent-2 :background nil))
  (sh-quoted-exec                            (:foreground cyanometric-accent-2 :background nil))
  (shadow                                    (:foreground cyanometric-neutral-purple))
  (show-paren-match                          (:foreground cyanometric-medium :background cyanometric-background-3))
  (show-paren-mismatch                       (:foreground cyanometric-bright-red :background cyanometric-background-3))
  (shr-link                                  (:inherit 'link))
  (shr-strike-through                        (:strike-through t))
  (smerge-base                               (:background cyanometric-medium))
  (smerge-markers                            (:background cyanometric-background-0-soft))
  (smerge-mine                               (:background cyanometric-background-2))
  (smerge-other                              (:background cyanometric-background-1))
  (smerge-refined-added                      (:background cyanometric-background-green))
  (smerge-refined-changed nil)
  (smerge-refined-removed                    (:background cyanometric-background-red))
  (sml/charging                              (:foreground cyanometric-faded-teal))
  (sml/col-number                            (:foreground cyanometric-neutral-orange))
  (sml/discharging                           (:foreground cyanometric-faded-teal :weight 'bold))
  (sml/filename                              (:foreground cyanometric-foreground-0-hard :weight 'bold :bold t))
  (sml/git                                   (:inherit 'sml/prefix))
  (sml/minor-modes                           (:foreground cyanometric-neutral-orange))
  (sml/modes                                 (:foreground cyanometric-foreground-0-hard :weight 'bold :bold t))
  (sml/modified                              (:foreground cyanometric-neutral-blue))
  (sml/outside-modified                      (:foreground cyanometric-neutral-blue))
  (sml/position-percentage                   (:foreground cyanometric-faded-teal))
  (sml/prefix                                (:foreground cyanometric-neutral-blue))
  (sml/process                               (:inherit 'sml/prefix))
  (sml/read-only                             (:foreground cyanometric-neutral-blue))
  (sml/sudo                                  (:foreground cyanometric-background-orange :weight 'bold))
  (sml/vc                                    (:foreground cyanometric-faded-green))
  (sml/vc-edited                             (:foreground cyanometric-bright-green))
  (sp-pair-overlay-face                      (:background cyanometric-background-2))
  (sp-show-pair-enclosing                    (:inherit 'highlight))
  (sp-show-pair-match-face                   (:background cyanometric-background-2))
  (sp-show-pair-mismatch-face                (:background cyanometric-bright-red))
  (sp-wrap-overlay-closing-pair              (:foreground cyanometric-faded-red :inherit 'sp-wrap-overlay-face))
  (sp-wrap-overlay-face                      (:inherit 'sp-pair-overlay-face))
  (sp-wrap-overlay-opening-pair              (:foreground cyanometric-black :inherit 'sp-wrap-overlay-face))
  (sp-wrap-tag-overlay-face                  (:inherit 'sp-pair-overlay-face))
  (spaceline-evil-emacs                      (:background cyanometric-bright-red :foreground cyanometric-background-0))
  (spaceline-evil-insert                     (:background cyanometric-bright-yellow :foreground cyanometric-background-0))
  (spaceline-evil-motion                     (:background cyanometric-bright-green :foreground cyanometric-background-0))
  (spaceline-evil-normal                     (:background cyanometric-bright-blue :foreground cyanometric-background-0))
  (spaceline-evil-replace                    (:background cyanometric-bright-orange :foreground cyanometric-background-0))
  (spaceline-evil-visual                     (:background cyanometric-bright-purple :foreground cyanometric-background-0))
  (stripe-highlight                          (:background cyanometric-background-0-hard))
  (success                                   (:foreground cyanometric-bright-green :bold t))
  (swiper-line-face                          (:inherit 'highlight))
  (swiper-match-face-1                       (:inherit 'isearch-lazy-highlight-face))
  (swiper-match-face-2                       (:inherit 'isearch))
  (swiper-match-face-3                       (:inherit 'match))
  (swiper-match-face-4                       (:inherit 'isearch-fail))
  (term-color-black                          (:foreground cyanometric-background-1))
  (term-color-blue                           (:foreground cyanometric-neutral-blue))
  (term-color-cyan                           (:foreground cyanometric-neutral-cyan))
  (term-color-green                          (:foreground cyanometric-neutral-green))
  (term-color-magenta                        (:foreground cyanometric-neutral-purple))
  (term-color-red                            (:foreground cyanometric-neutral-red))
  (term-color-white                          (:foreground cyanometric-foreground-1))
  (term-color-yellow                         (:foreground cyanometric-neutral-yellow))
  (term-default-bg-color                     (:background cyanometric-background-0))
  (term-default-fg-color                     (:foreground cyanometric-foreground-0))
  (tool-bar                                  (:box (:line-width 1 :style 'released-button) :foreground cyanometric-black :background cyanometric-neutral-purple))
  (tooltip                                   (:foreground cyanometric-black :background cyanometric-foreground-0-hard :inherit 'variable-pitch))
  (trailing-whitespace                       (:background cyanometric-faded-red))
  (tty-menu-disabled-face                    (:foreground cyanometric-identifiers-1 :background cyanometric-mid-cyan))
  (tty-menu-enabled-face                     (:weight 'bold :foreground cyanometric-foreground-0-hard :background cyanometric-mid-cyan))
  (tty-menu-selected-face                    (:background cyanometric-faded-red))
  (underline                                 (:underline t))
  (variable-pitch                            (:family "Sans Serif"))
  (vc-conflict-state                         (:inherit 'vc-state-base))
  (vc-edited-state                           (:inherit 'vc-state-base))
  (vc-locally-added-state                    (:inherit 'vc-state-base))
  (vc-locked-state                           (:inherit 'vc-state-base))
  (vc-missing-state                          (:inherit 'vc-state-base))
  (vc-needs-update-state                     (:inherit 'vc-state-base))
  (vc-removed-state                          (:inherit 'vc-state-base))
  (vc-state-base nil)
  (vc-up-to-date-state                       (:inherit 'vc-state-base))
  (vertical-border                           (:foreground cyanometric-background-2))
  (vertico-posframe                          (:background cyanometric-background-0-hard))
  (vertico-posframe-border                   (:background cyanometric-background-0-hard))
  (vertico-posframe-border-2                 (:background cyanometric-background-0))
  (vertico-posframe-border-3                 (:background cyanometric-background-1))
  (vertico-posframe-border-4                 (:background cyanometric-background-2))
  (vline                                     (:background cyanometric-background-teal))
  (vline-visual                              (:background cyanometric-background-teal))
  (w3m-haddock-heading-face                  (:inherit 'highlight))
  (warning                                   (:foreground cyanometric-bright-red :bold t))
  (web-mode-doctype-face                     (:foreground cyanometric-foreground-2 :weight 'bold))
  (web-mode-html-attr-equal-face             (:inherit 'default))
  (web-mode-html-attr-name-face              (:inherit 'font-lock-variable-name-face))
  (web-mode-html-tag-bracket-face            (:inherit 'default))
  (web-mode-html-tag-face                    (:foreground cyanometric-foreground-3))
  (which-key-command-description-face        (:inherit 'font-lock-function-name-face))
  (which-key-group-description-face          (:inherit 'font-lock-keyword-face))
  (which-key-highlighted-command-face        (:underline t :inherit 'which-key-command-description-face))
  (which-key-key-face                        (:inherit 'font-lock-constant-face))
  (which-key-local-map-description-face      (:inherit 'which-key-command-description-face))
  (which-key-note-face                       (:inherit 'which-key-separator-face))
  (which-key-separator-face                  (:inherit 'font-lock-comment-face))
  (which-key-special-key-face                (:weight 'bold :inverse-video t :inherit 'which-key-key-face))
  (whitespace-empty                          (:foreground nil :background nil))
  (whitespace-hspace                         (:foreground cyanometric-background-4 :background cyanometric-background-0))
  (whitespace-indentation                    (:foreground cyanometric-background-4 :background cyanometric-background-0))
  (whitespace-line                           (:foreground cyanometric-neutral-red :background cyanometric-background-1))
  (whitespace-newline                        (:foreground cyanometric-background-4 :background cyanometric-background-0))
  (whitespace-space                          (:foreground cyanometric-background-4 :background cyanometric-background-0))
  (whitespace-space-after-tab                (:foreground cyanometric-background-4 :background cyanometric-background-0))
  (whitespace-space-before-tab               (:foreground cyanometric-background-4 :background cyanometric-background-0))
  (whitespace-tab                            (:foreground cyanometric-background-4 :background cyanometric-background-0))
  (whitespace-trailing                       (:foreground cyanometric-neutral-red :background cyanometric-background-1))
  (widget-button                             (:weight 'bold))
  (widget-button-pressed                     (:foreground cyanometric-faded-red))
  (widget-documentation                      (:foreground cyanometric-mid-yellow))
  (widget-field                              (:background cyanometric-background-4))
  (widget-inactive                           (:inherit 'shadow))
  (widget-single-line-field                  (:background cyanometric-background-4))
  (window-divider                            (:foreground cyanometric-background-2))
  (window-divider-first-pixel                (:foreground cyanometric-background-2))
  (window-divider-last-pixel                 (:foreground cyanometric-background-2))
  (yas-field-highlight-face                  (:inherit 'region)))

 (custom-theme-set-variables 'cyanometric
                             `(vertico-posframe-border-width 10)
                             `(pos-tip-foreground-color ,cyanometric-foreground-0-hard)
                             `(pos-tip-background-color ,cyanometric-background-teal)
                             `(ansi-color-names-vector [,cyanometric-background-1
                                                        ,cyanometric-bright-red
                                                        ,cyanometric-bright-green
                                                        ,cyanometric-bright-yellow
                                                        ,cyanometric-bright-blue
                                                        ,cyanometric-bright-purple
                                                        ,cyanometric-bright-cyan
                                                        ,cyanometric-foreground-1])))

;;;###autoload
(and load-file-name
     (boundp 'custom-theme-load-path)
     (add-to-list 'custom-theme-load-path
                  (file-name-as-directory
                   (file-name-directory load-file-name))))

(provide-theme 'cyanometric)

;; Local Variables:
;; eval: (when (fboundp 'rainbow-mode) (rainbow-mode 1))
;; End:

;;; cyanometric-theme.el ends here.
