/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTextElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGTextElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGTextElementTableValues[] =
{
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTextElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextElementTable = { 9, 7, JSSVGTextElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGTextElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextElementConstructorTable = { 1, 0, JSSVGTextElementConstructorTableValues, 0 };
const ClassInfo JSSVGTextElementConstructor::s_info = { "SVGTextElementConstructor", &Base::s_info, &JSSVGTextElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGTextElementConstructor) };

JSSVGTextElementConstructor::JSSVGTextElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTextElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGTextElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGTextElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTextElementConstructor, JSDOMWrapper>(exec, &JSSVGTextElementConstructorTable, jsCast<JSSVGTextElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGTextElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTextElementConstructor, JSDOMWrapper>(exec, &JSSVGTextElementConstructorTable, jsCast<JSSVGTextElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGTextElementPrototypeTableValues[] =
{
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGTextElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGTextElementPrototypeTable = { 8, 7, JSSVGTextElementPrototypeTableValues, 0 };
const ClassInfo JSSVGTextElementPrototype::s_info = { "SVGTextElementPrototype", &Base::s_info, &JSSVGTextElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGTextElementPrototype) };

JSObject* JSSVGTextElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTextElement>(exec, globalObject);
}

bool JSSVGTextElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTextElementPrototype* thisObject = jsCast<JSSVGTextElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTextElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGTextElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTextElementPrototype* thisObject = jsCast<JSSVGTextElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGTextElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGTextElement::s_info = { "SVGTextElement", &Base::s_info, &JSSVGTextElementTable, 0 , CREATE_METHOD_TABLE(JSSVGTextElement) };

JSSVGTextElement::JSSVGTextElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTextElement> impl)
    : JSSVGTextPositioningElement(structure, globalObject, impl)
{
}

void JSSVGTextElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTextElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTextElementPrototype::create(exec->globalData(), globalObject, JSSVGTextElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGTextPositioningElementPrototype::self(exec, globalObject)));
}

bool JSSVGTextElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGTextElement* thisObject = jsCast<JSSVGTextElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGTextElement, Base>(exec, &JSSVGTextElementTable, thisObject, propertyName, slot);
}

bool JSSVGTextElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGTextElement* thisObject = jsCast<JSSVGTextElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGTextElement, Base>(exec, &JSSVGTextElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGTextElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextElement* castedThis = jsCast<JSSVGTextElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextElement* impl = static_cast<SVGTextElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTextElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextElement* castedThis = jsCast<JSSVGTextElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextElement* impl = static_cast<SVGTextElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGTextElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextElement* castedThis = jsCast<JSSVGTextElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTextElement* impl = static_cast<SVGTextElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGTextElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGTextElement* domObject = jsCast<JSSVGTextElement*>(asObject(slotBase));
    return JSSVGTextElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGTextElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTextElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGTextElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextElement* castedThis = jsCast<JSSVGTextElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextElement::s_info);
    SVGTextElement* impl = static_cast<SVGTextElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextElement* castedThis = jsCast<JSSVGTextElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextElement::s_info);
    SVGTextElement* impl = static_cast<SVGTextElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextElement* castedThis = jsCast<JSSVGTextElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextElement::s_info);
    SVGTextElement* impl = static_cast<SVGTextElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGTextElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTextElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTextElement* castedThis = jsCast<JSSVGTextElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTextElement::s_info);
    SVGTextElement* impl = static_cast<SVGTextElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
