/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSEntityReference.h"

#include "EntityReference.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSEntityReferenceTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsEntityReferenceConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntityReferenceTable = { 2, 1, JSEntityReferenceTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSEntityReferenceConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntityReferenceConstructorTable = { 1, 0, JSEntityReferenceConstructorTableValues, 0 };
const ClassInfo JSEntityReferenceConstructor::s_info = { "EntityReferenceConstructor", &Base::s_info, &JSEntityReferenceConstructorTable, 0, CREATE_METHOD_TABLE(JSEntityReferenceConstructor) };

JSEntityReferenceConstructor::JSEntityReferenceConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSEntityReferenceConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSEntityReferencePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSEntityReferenceConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSEntityReferenceConstructor, JSDOMWrapper>(exec, &JSEntityReferenceConstructorTable, jsCast<JSEntityReferenceConstructor*>(cell), propertyName, slot);
}

bool JSEntityReferenceConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSEntityReferenceConstructor, JSDOMWrapper>(exec, &JSEntityReferenceConstructorTable, jsCast<JSEntityReferenceConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSEntityReferencePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSEntityReferencePrototypeTable = { 1, 0, JSEntityReferencePrototypeTableValues, 0 };
const ClassInfo JSEntityReferencePrototype::s_info = { "EntityReferencePrototype", &Base::s_info, &JSEntityReferencePrototypeTable, 0, CREATE_METHOD_TABLE(JSEntityReferencePrototype) };

JSObject* JSEntityReferencePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSEntityReference>(exec, globalObject);
}

const ClassInfo JSEntityReference::s_info = { "EntityReference", &Base::s_info, &JSEntityReferenceTable, 0 , CREATE_METHOD_TABLE(JSEntityReference) };

JSEntityReference::JSEntityReference(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<EntityReference> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSEntityReference::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSEntityReference::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSEntityReferencePrototype::create(exec->globalData(), globalObject, JSEntityReferencePrototype::createStructure(exec->globalData(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSEntityReference::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSEntityReference* thisObject = jsCast<JSEntityReference*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSEntityReference, Base>(exec, &JSEntityReferenceTable, thisObject, propertyName, slot);
}

bool JSEntityReference::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSEntityReference* thisObject = jsCast<JSEntityReference*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSEntityReference, Base>(exec, &JSEntityReferenceTable, thisObject, propertyName, descriptor);
}

JSValue jsEntityReferenceConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSEntityReference* domObject = jsCast<JSEntityReference*>(asObject(slotBase));
    return JSEntityReference::getConstructor(exec, domObject->globalObject());
}

JSValue JSEntityReference::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSEntityReferenceConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
