/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathSegList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGPathSeg.h"
#include "SVGPathSeg.h"
#include "SVGPathSegList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPathSegListTableValues[] =
{
    { "numberOfItems", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegListNumberOfItems), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathSegListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegListTable = { 4, 3, JSSVGPathSegListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPathSegListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegListConstructorTable = { 1, 0, JSSVGPathSegListConstructorTableValues, 0 };
const ClassInfo JSSVGPathSegListConstructor::s_info = { "SVGPathSegListConstructor", &Base::s_info, &JSSVGPathSegListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegListConstructor) };

JSSVGPathSegListConstructor::JSSVGPathSegListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPathSegListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGPathSegListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGPathSegListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathSegListConstructor, JSDOMWrapper>(exec, &JSSVGPathSegListConstructorTable, jsCast<JSSVGPathSegListConstructor*>(cell), propertyName, slot);
}

bool JSSVGPathSegListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathSegListConstructor, JSDOMWrapper>(exec, &JSSVGPathSegListConstructorTable, jsCast<JSSVGPathSegListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathSegListPrototypeTableValues[] =
{
    { "clear", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathSegListPrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { "initialize", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathSegListPrototypeFunctionInitialize), (intptr_t)1, NoIntrinsic },
    { "getItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathSegListPrototypeFunctionGetItem), (intptr_t)1, NoIntrinsic },
    { "insertItemBefore", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathSegListPrototypeFunctionInsertItemBefore), (intptr_t)2, NoIntrinsic },
    { "replaceItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathSegListPrototypeFunctionReplaceItem), (intptr_t)2, NoIntrinsic },
    { "removeItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathSegListPrototypeFunctionRemoveItem), (intptr_t)1, NoIntrinsic },
    { "appendItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathSegListPrototypeFunctionAppendItem), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathSegListPrototypeTable = { 18, 15, JSSVGPathSegListPrototypeTableValues, 0 };
const ClassInfo JSSVGPathSegListPrototype::s_info = { "SVGPathSegListPrototype", &Base::s_info, &JSSVGPathSegListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPathSegListPrototype) };

JSObject* JSSVGPathSegListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathSegList>(exec, globalObject);
}

bool JSSVGPathSegListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathSegListPrototype* thisObject = jsCast<JSSVGPathSegListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPathSegListPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPathSegListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathSegListPrototype* thisObject = jsCast<JSSVGPathSegListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPathSegListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPathSegList::s_info = { "SVGPathSegList", &Base::s_info, &JSSVGPathSegListTable, 0 , CREATE_METHOD_TABLE(JSSVGPathSegList) };

JSSVGPathSegList::JSSVGPathSegList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathSegListPropertyTearOff > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGPathSegList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPathSegList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPathSegListPrototype::create(exec->globalData(), globalObject, JSSVGPathSegListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGPathSegList::destroy(JSC::JSCell* cell)
{
    JSSVGPathSegList* thisObject = static_cast<JSSVGPathSegList*>(cell);
    thisObject->JSSVGPathSegList::~JSSVGPathSegList();
}

JSSVGPathSegList::~JSSVGPathSegList()
{
    releaseImplIfNotNull();
}

bool JSSVGPathSegList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathSegList* thisObject = jsCast<JSSVGPathSegList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPathSegList, Base>(exec, &JSSVGPathSegListTable, thisObject, propertyName, slot);
}

bool JSSVGPathSegList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathSegList* thisObject = jsCast<JSSVGPathSegList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPathSegList, Base>(exec, &JSSVGPathSegListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPathSegListNumberOfItems(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    JSValue result =  jsNumber(castedThis->impl()->numberOfItems());
    return result;
}


JSValue jsSVGPathSegListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathSegList* domObject = jsCast<JSSVGPathSegList*>(asObject(slotBase));
    return JSSVGPathSegList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGPathSegList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPathSegListPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathSegList::s_info))
        return throwVMTypeError(exec);
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathSegList::s_info);
    SVGPathSegListPropertyTearOff * impl = static_cast<SVGPathSegListPropertyTearOff *>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->clear(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsSVGPathSegListPrototypeFunctionInitialize(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathSegList::s_info))
        return throwVMTypeError(exec);
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathSegList::s_info);
    SVGPathSegListPropertyTearOff * impl = static_cast<SVGPathSegListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPathSeg::s_info))
        return throwVMTypeError(exec);
    SVGPathSeg* newItem(toSVGPathSeg(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->initialize(newItem, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathSegListPrototypeFunctionGetItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathSegList::s_info))
        return throwVMTypeError(exec);
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathSegList::s_info);
    SVGPathSegListPropertyTearOff * impl = static_cast<SVGPathSegListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathSegListPrototypeFunctionInsertItemBefore(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathSegList::s_info))
        return throwVMTypeError(exec);
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathSegList::s_info);
    SVGPathSegListPropertyTearOff * impl = static_cast<SVGPathSegListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPathSeg::s_info))
        return throwVMTypeError(exec);
    SVGPathSeg* newItem(toSVGPathSeg(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertItemBefore(newItem, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathSegListPrototypeFunctionReplaceItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathSegList::s_info))
        return throwVMTypeError(exec);
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathSegList::s_info);
    SVGPathSegListPropertyTearOff * impl = static_cast<SVGPathSegListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPathSeg::s_info))
        return throwVMTypeError(exec);
    SVGPathSeg* newItem(toSVGPathSeg(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->replaceItem(newItem, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathSegListPrototypeFunctionRemoveItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathSegList::s_info))
        return throwVMTypeError(exec);
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathSegList::s_info);
    SVGPathSegListPropertyTearOff * impl = static_cast<SVGPathSegListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->removeItem(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathSegListPrototypeFunctionAppendItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathSegList::s_info))
        return throwVMTypeError(exec);
    JSSVGPathSegList* castedThis = jsCast<JSSVGPathSegList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathSegList::s_info);
    SVGPathSegListPropertyTearOff * impl = static_cast<SVGPathSegListPropertyTearOff *>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    if (exec->argumentCount() > 0 && !exec->argument(0).isUndefinedOrNull() && !exec->argument(0).inherits(&JSSVGPathSeg::s_info))
        return throwVMTypeError(exec);
    SVGPathSeg* newItem(toSVGPathSeg(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->appendItem(newItem, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

static inline bool isObservable(JSSVGPathSegList* jsSVGPathSegList)
{
    if (jsSVGPathSegList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGPathSegListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGPathSegList* jsSVGPathSegList = jsCast<JSSVGPathSegList*>(handle.get().asCell());
    if (!isObservable(jsSVGPathSegList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGPathSegListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGPathSegList* jsSVGPathSegList = jsCast<JSSVGPathSegList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGPathSegList->impl(), jsSVGPathSegList);
    jsSVGPathSegList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGPathSegListPropertyTearOff * impl)
{
    return wrap<JSSVGPathSegList>(exec, globalObject, impl);
}

SVGPathSegListPropertyTearOff * toSVGPathSegList(JSC::JSValue value)
{
    return value.inherits(&JSSVGPathSegList::s_info) ? jsCast<JSSVGPathSegList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
