/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPathElement.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGPathSegArcAbs.h"
#include "JSSVGPathSegArcRel.h"
#include "JSSVGPathSegClosePath.h"
#include "JSSVGPathSegCurvetoCubicAbs.h"
#include "JSSVGPathSegCurvetoCubicRel.h"
#include "JSSVGPathSegCurvetoCubicSmoothAbs.h"
#include "JSSVGPathSegCurvetoCubicSmoothRel.h"
#include "JSSVGPathSegCurvetoQuadraticAbs.h"
#include "JSSVGPathSegCurvetoQuadraticRel.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothAbs.h"
#include "JSSVGPathSegCurvetoQuadraticSmoothRel.h"
#include "JSSVGPathSegLinetoAbs.h"
#include "JSSVGPathSegLinetoHorizontalAbs.h"
#include "JSSVGPathSegLinetoHorizontalRel.h"
#include "JSSVGPathSegLinetoRel.h"
#include "JSSVGPathSegLinetoVerticalAbs.h"
#include "JSSVGPathSegLinetoVerticalRel.h"
#include "JSSVGPathSegList.h"
#include "JSSVGPathSegMovetoAbs.h"
#include "JSSVGPathSegMovetoRel.h"
#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGPathElement.h"
#include "SVGPathSegArc.h"
#include "SVGPathSegClosePath.h"
#include "SVGPathSegCurvetoCubic.h"
#include "SVGPathSegCurvetoCubicSmooth.h"
#include "SVGPathSegCurvetoQuadratic.h"
#include "SVGPathSegCurvetoQuadraticSmooth.h"
#include "SVGPathSegLineto.h"
#include "SVGPathSegLinetoHorizontal.h"
#include "SVGPathSegLinetoVertical.h"
#include "SVGPathSegList.h"
#include "SVGPathSegMoveto.h"
#include "SVGRect.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPathElementTableValues[] =
{
    { "pathLength", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementPathLength), (intptr_t)0, NoIntrinsic },
    { "pathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementPathSegList), (intptr_t)0, NoIntrinsic },
    { "normalizedPathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementNormalizedPathSegList), (intptr_t)0, NoIntrinsic },
    { "animatedPathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementAnimatedPathSegList), (intptr_t)0, NoIntrinsic },
    { "animatedNormalizedPathSegList", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementAnimatedNormalizedPathSegList), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementXmllang), (intptr_t)setJSSVGPathElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementXmlspace), (intptr_t)setJSSVGPathElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPathElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathElementTable = { 37, 31, JSSVGPathElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPathElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathElementConstructorTable = { 1, 0, JSSVGPathElementConstructorTableValues, 0 };
const ClassInfo JSSVGPathElementConstructor::s_info = { "SVGPathElementConstructor", &Base::s_info, &JSSVGPathElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPathElementConstructor) };

JSSVGPathElementConstructor::JSSVGPathElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPathElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGPathElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGPathElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPathElementConstructor, JSDOMWrapper>(exec, &JSSVGPathElementConstructorTable, jsCast<JSSVGPathElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGPathElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPathElementConstructor, JSDOMWrapper>(exec, &JSSVGPathElementConstructorTable, jsCast<JSSVGPathElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPathElementPrototypeTableValues[] =
{
    { "getTotalLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetTotalLength), (intptr_t)0, NoIntrinsic },
    { "getPointAtLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetPointAtLength), (intptr_t)1, NoIntrinsic },
    { "getPathSegAtLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetPathSegAtLength), (intptr_t)1, NoIntrinsic },
    { "createSVGPathSegClosePath", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath), (intptr_t)0, NoIntrinsic },
    { "createSVGPathSegMovetoAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs), (intptr_t)2, NoIntrinsic },
    { "createSVGPathSegMovetoRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel), (intptr_t)2, NoIntrinsic },
    { "createSVGPathSegLinetoAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs), (intptr_t)2, NoIntrinsic },
    { "createSVGPathSegLinetoRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel), (intptr_t)2, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs), (intptr_t)6, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel), (intptr_t)6, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs), (intptr_t)4, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel), (intptr_t)4, NoIntrinsic },
    { "createSVGPathSegArcAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs), (intptr_t)7, NoIntrinsic },
    { "createSVGPathSegArcRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel), (intptr_t)7, NoIntrinsic },
    { "createSVGPathSegLinetoHorizontalAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs), (intptr_t)1, NoIntrinsic },
    { "createSVGPathSegLinetoHorizontalRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel), (intptr_t)1, NoIntrinsic },
    { "createSVGPathSegLinetoVerticalAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs), (intptr_t)1, NoIntrinsic },
    { "createSVGPathSegLinetoVerticalRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel), (intptr_t)1, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicSmoothAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs), (intptr_t)4, NoIntrinsic },
    { "createSVGPathSegCurvetoCubicSmoothRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel), (intptr_t)4, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticSmoothAbs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs), (intptr_t)2, NoIntrinsic },
    { "createSVGPathSegCurvetoQuadraticSmoothRel", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel), (intptr_t)2, NoIntrinsic },
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGPathElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPathElementPrototypeTable = { 69, 63, JSSVGPathElementPrototypeTableValues, 0 };
const ClassInfo JSSVGPathElementPrototype::s_info = { "SVGPathElementPrototype", &Base::s_info, &JSSVGPathElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPathElementPrototype) };

JSObject* JSSVGPathElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPathElement>(exec, globalObject);
}

bool JSSVGPathElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathElementPrototype* thisObject = jsCast<JSSVGPathElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGPathElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPathElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathElementPrototype* thisObject = jsCast<JSSVGPathElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGPathElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPathElement::s_info = { "SVGPathElement", &Base::s_info, &JSSVGPathElementTable, 0 , CREATE_METHOD_TABLE(JSSVGPathElement) };

JSSVGPathElement::JSSVGPathElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPathElement> impl)
    : JSSVGStyledElement(structure, globalObject, impl)
{
}

void JSSVGPathElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPathElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPathElementPrototype::create(exec->globalData(), globalObject, JSSVGPathElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGStyledElementPrototype::self(exec, globalObject)));
}

bool JSSVGPathElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPathElement* thisObject = jsCast<JSSVGPathElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPathElement, Base>(exec, &JSSVGPathElementTable, thisObject, propertyName, slot);
}

bool JSSVGPathElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPathElement* thisObject = jsCast<JSSVGPathElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPathElement, Base>(exec, &JSSVGPathElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPathElementPathLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->pathLengthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPathElementPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->pathSegList()));
    return result;
}


JSValue jsSVGPathElementNormalizedPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->normalizedPathSegList()));
    return result;
}


JSValue jsSVGPathElementAnimatedPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->animatedPathSegList()));
    return result;
}


JSValue jsSVGPathElementAnimatedNormalizedPathSegList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->animatedNormalizedPathSegList()));
    return result;
}


JSValue jsSVGPathElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGPathElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGPathElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGPathElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGPathElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGPathElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPathElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGPathElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGPathElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGPathElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPathElement* domObject = jsCast<JSSVGPathElement*>(asObject(slotBase));
    return JSSVGPathElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGPathElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPathElement* thisObject = jsCast<JSSVGPathElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPathElement, Base>(exec, propertyName, value, &JSSVGPathElementTable, thisObject, slot);
}

void setJSSVGPathElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(thisObject);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGPathElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(thisObject);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGPathElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetTotalLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->getTotalLength());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetPointAtLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float distance(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatPoint>::create(impl->getPointAtLength(distance))));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetPathSegAtLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float distance(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->getPathSegAtLength(distance));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegClosePath(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegClosePath()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegMovetoAbs(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegMovetoRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegMovetoRel(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoAbs(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoRel(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(5).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicAbs(x, y, x1, y1, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(5).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicRel(x, y, x1, y1, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticAbs(x, y, x1, y1)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y1(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticRel(x, y, x1, y1)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float angle(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool largeArcFlag(exec->argument(5).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool sweepFlag(exec->argument(6).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegArcAbs(x, y, r1, r2, angle, largeArcFlag, sweepFlag)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegArcRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r1(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float r2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float angle(exec->argument(4).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool largeArcFlag(exec->argument(5).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool sweepFlag(exec->argument(6).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegArcRel(x, y, r1, r2, angle, largeArcFlag, sweepFlag)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoHorizontalAbs(x)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoHorizontalRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoHorizontalRel(x)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float y(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoVerticalAbs(y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegLinetoVerticalRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float y(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegLinetoVerticalRel(y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicSmoothAbs(x, y, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoCubicSmoothRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float x2(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y2(exec->argument(3).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoCubicSmoothRel(x, y, x2, y2)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothAbs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticSmoothAbs(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionCreateSVGPathSegCurvetoQuadraticSmoothRel(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    float x(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float y(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createSVGPathSegCurvetoQuadraticSmoothRel(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    const String& extension(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGPathElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGPathElement::s_info))
        return throwVMTypeError(exec);
    JSSVGPathElement* castedThis = jsCast<JSSVGPathElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGPathElement::s_info);
    SVGPathElement* impl = static_cast<SVGPathElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
