/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMLocation.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMStringListPrivate.h"
#include "WebKitDOMLocationPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_LOCATION_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_LOCATION, WebKitDOMLocationPrivate)

typedef struct _WebKitDOMLocationPrivate {
    RefPtr<WebCore::Location> coreObject;
} WebKitDOMLocationPrivate;

namespace WebKit {

WebKitDOMLocation* kit(WebCore::Location* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_LOCATION(ret);

    return wrapLocation(obj);
}

WebCore::Location* core(WebKitDOMLocation* request)
{
    return request ? static_cast<WebCore::Location*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMLocation* wrapLocation(WebCore::Location* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_LOCATION(g_object_new(WEBKIT_TYPE_DOM_LOCATION, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMLocation, webkit_dom_location, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_ORIGIN,
    PROP_ANCESTOR_ORIGINS,
};

static void webkit_dom_location_finalize(GObject* object)
{
    WebKitDOMLocationPrivate* priv = WEBKIT_DOM_LOCATION_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMLocationPrivate();
    G_OBJECT_CLASS(webkit_dom_location_parent_class)->finalize(object);
}

static void webkit_dom_location_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMLocation* self = WEBKIT_DOM_LOCATION(object);
    WebCore::Location* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_ORIGIN: {
        g_value_take_string(value, convertToUTF8String(coreSelf->origin()));
        break;
    }
    case PROP_ANCESTOR_ORIGINS: {
        RefPtr<WebCore::DOMStringList> ptr = coreSelf->ancestorOrigins();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_location_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_location_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMLocationPrivate* priv = WEBKIT_DOM_LOCATION_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::Location*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_location_class_init(WebKitDOMLocationClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMLocationPrivate));
    gobjectClass->constructor = webkit_dom_location_constructor;
    gobjectClass->finalize = webkit_dom_location_finalize;
    gobjectClass->get_property = webkit_dom_location_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_ORIGIN,
                                    g_param_spec_string("origin", /* name */
                                                           "location_origin", /* short description */
                                                           "read-only  gchar* Location.origin", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ANCESTOR_ORIGINS,
                                    g_param_spec_object("ancestor-origins", /* name */
                                                           "location_ancestor-origins", /* short description */
                                                           "read-only  WebKitDOMDOMStringList* Location.ancestor-origins", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_DOM_STRING_LIST, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_location_init(WebKitDOMLocation* request)
{
    WebKitDOMLocationPrivate* priv = WEBKIT_DOM_LOCATION_GET_PRIVATE(request);
    new (priv) WebKitDOMLocationPrivate();
}

gchar*
webkit_dom_location_get_origin(WebKitDOMLocation* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_LOCATION(self), 0);
    WebCore::Location* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->origin());
    return result;
}

WebKitDOMDOMStringList*
webkit_dom_location_get_ancestor_origins(WebKitDOMLocation* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_LOCATION(self), 0);
    WebCore::Location* item = WebKit::core(self);
    RefPtr<WebCore::DOMStringList> gobjectResult = WTF::getPtr(item->ancestorOrigins());
    return WebKit::kit(gobjectResult.get());
}

