/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSStyleMedia.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "StyleMedia.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSStyleMediaTableValues[] =
{
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleMediaType), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsStyleMediaConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStyleMediaTable = { 4, 3, JSStyleMediaTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSStyleMediaConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStyleMediaConstructorTable = { 1, 0, JSStyleMediaConstructorTableValues, 0 };
const ClassInfo JSStyleMediaConstructor::s_info = { "StyleMediaConstructor", &Base::s_info, &JSStyleMediaConstructorTable, 0, CREATE_METHOD_TABLE(JSStyleMediaConstructor) };

JSStyleMediaConstructor::JSStyleMediaConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSStyleMediaConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSStyleMediaPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSStyleMediaConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSStyleMediaConstructor, JSDOMWrapper>(exec, &JSStyleMediaConstructorTable, jsCast<JSStyleMediaConstructor*>(cell), propertyName, slot);
}

bool JSStyleMediaConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSStyleMediaConstructor, JSDOMWrapper>(exec, &JSStyleMediaConstructorTable, jsCast<JSStyleMediaConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSStyleMediaPrototypeTableValues[] =
{
    { "matchMedium", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsStyleMediaPrototypeFunctionMatchMedium), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSStyleMediaPrototypeTable = { 2, 1, JSStyleMediaPrototypeTableValues, 0 };
const ClassInfo JSStyleMediaPrototype::s_info = { "StyleMediaPrototype", &Base::s_info, &JSStyleMediaPrototypeTable, 0, CREATE_METHOD_TABLE(JSStyleMediaPrototype) };

JSObject* JSStyleMediaPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSStyleMedia>(exec, globalObject);
}

bool JSStyleMediaPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStyleMediaPrototype* thisObject = jsCast<JSStyleMediaPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSStyleMediaPrototypeTable, thisObject, propertyName, slot);
}

bool JSStyleMediaPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStyleMediaPrototype* thisObject = jsCast<JSStyleMediaPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSStyleMediaPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSStyleMedia::s_info = { "StyleMedia", &Base::s_info, &JSStyleMediaTable, 0 , CREATE_METHOD_TABLE(JSStyleMedia) };

JSStyleMedia::JSStyleMedia(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<StyleMedia> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSStyleMedia::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSStyleMedia::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSStyleMediaPrototype::create(exec->globalData(), globalObject, JSStyleMediaPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSStyleMedia::destroy(JSC::JSCell* cell)
{
    JSStyleMedia* thisObject = static_cast<JSStyleMedia*>(cell);
    thisObject->JSStyleMedia::~JSStyleMedia();
}

JSStyleMedia::~JSStyleMedia()
{
    releaseImplIfNotNull();
}

bool JSStyleMedia::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSStyleMedia* thisObject = jsCast<JSStyleMedia*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSStyleMedia, Base>(exec, &JSStyleMediaTable, thisObject, propertyName, slot);
}

bool JSStyleMedia::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSStyleMedia* thisObject = jsCast<JSStyleMedia*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSStyleMedia, Base>(exec, &JSStyleMediaTable, thisObject, propertyName, descriptor);
}

JSValue jsStyleMediaType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStyleMedia* castedThis = jsCast<JSStyleMedia*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    StyleMedia* impl = static_cast<StyleMedia*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsStyleMediaConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSStyleMedia* domObject = jsCast<JSStyleMedia*>(asObject(slotBase));
    return JSStyleMedia::getConstructor(exec, domObject->globalObject());
}

JSValue JSStyleMedia::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSStyleMediaConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsStyleMediaPrototypeFunctionMatchMedium(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSStyleMedia::s_info))
        return throwVMTypeError(exec);
    JSStyleMedia* castedThis = jsCast<JSStyleMedia*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSStyleMedia::s_info);
    StyleMedia* impl = static_cast<StyleMedia*>(castedThis->impl());
    const String& mediaquery(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->matchMedium(mediaquery));
    return JSValue::encode(result);
}

static inline bool isObservable(JSStyleMedia* jsStyleMedia)
{
    if (jsStyleMedia->hasCustomProperties())
        return true;
    return false;
}

bool JSStyleMediaOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSStyleMedia* jsStyleMedia = jsCast<JSStyleMedia*>(handle.get().asCell());
    if (!isObservable(jsStyleMedia))
        return false;
    Frame* root = jsStyleMedia->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSStyleMediaOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSStyleMedia* jsStyleMedia = jsCast<JSStyleMedia*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsStyleMedia->impl(), jsStyleMedia);
    jsStyleMedia->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, StyleMedia* impl)
{
    return wrap<JSStyleMedia>(exec, globalObject, impl);
}

StyleMedia* toStyleMedia(JSC::JSValue value)
{
    return value.inherits(&JSStyleMedia::s_info) ? jsCast<JSStyleMedia*>(asObject(value))->impl() : 0;
}

}
