/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTypeConversions.h"

#include "TypeConversions.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTypeConversionsTableValues[] =
{
    { "testLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestLong), (intptr_t)setJSTypeConversionsTestLong, NoIntrinsic },
    { "testEnforceRangeLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeLong), (intptr_t)setJSTypeConversionsTestEnforceRangeLong, NoIntrinsic },
    { "testUnsignedLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestUnsignedLong), (intptr_t)setJSTypeConversionsTestUnsignedLong, NoIntrinsic },
    { "testEnforceRangeUnsignedLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeUnsignedLong), (intptr_t)setJSTypeConversionsTestEnforceRangeUnsignedLong, NoIntrinsic },
    { "testLongLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestLongLong), (intptr_t)setJSTypeConversionsTestLongLong, NoIntrinsic },
    { "testEnforceRangeLongLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeLongLong), (intptr_t)setJSTypeConversionsTestEnforceRangeLongLong, NoIntrinsic },
    { "testUnsignedLongLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestUnsignedLongLong), (intptr_t)setJSTypeConversionsTestUnsignedLongLong, NoIntrinsic },
    { "testEnforceRangeUnsignedLongLong", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeUnsignedLongLong), (intptr_t)setJSTypeConversionsTestEnforceRangeUnsignedLongLong, NoIntrinsic },
    { "testByte", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestByte), (intptr_t)setJSTypeConversionsTestByte, NoIntrinsic },
    { "testEnforceRangeByte", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeByte), (intptr_t)setJSTypeConversionsTestEnforceRangeByte, NoIntrinsic },
    { "testOctet", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestOctet), (intptr_t)setJSTypeConversionsTestOctet, NoIntrinsic },
    { "testEnforceRangeOctet", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTypeConversionsTestEnforceRangeOctet), (intptr_t)setJSTypeConversionsTestEnforceRangeOctet, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTypeConversionsTable = { 34, 31, JSTypeConversionsTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSTypeConversionsPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTypeConversionsPrototypeTable = { 1, 0, JSTypeConversionsPrototypeTableValues, 0 };
const ClassInfo JSTypeConversionsPrototype::s_info = { "TypeConversionsPrototype", &Base::s_info, &JSTypeConversionsPrototypeTable, 0, CREATE_METHOD_TABLE(JSTypeConversionsPrototype) };

JSObject* JSTypeConversionsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTypeConversions>(exec, globalObject);
}

const ClassInfo JSTypeConversions::s_info = { "TypeConversions", &Base::s_info, &JSTypeConversionsTable, 0 , CREATE_METHOD_TABLE(JSTypeConversions) };

JSTypeConversions::JSTypeConversions(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TypeConversions> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSTypeConversions::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSTypeConversions::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTypeConversionsPrototype::create(exec->vm(), globalObject, JSTypeConversionsPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSTypeConversions::destroy(JSC::JSCell* cell)
{
    JSTypeConversions* thisObject = static_cast<JSTypeConversions*>(cell);
    thisObject->JSTypeConversions::~JSTypeConversions();
}

JSTypeConversions::~JSTypeConversions()
{
    releaseImplIfNotNull();
}

bool JSTypeConversions::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTypeConversions* thisObject = jsCast<JSTypeConversions*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTypeConversions, Base>(exec, &JSTypeConversionsTable, thisObject, propertyName, slot);
}

bool JSTypeConversions::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTypeConversions* thisObject = jsCast<JSTypeConversions*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTypeConversions, Base>(exec, &JSTypeConversionsTable, thisObject, propertyName, descriptor);
}

JSValue jsTypeConversionsTestLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testLong());
    return result;
}


JSValue jsTypeConversionsTestEnforceRangeLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testEnforceRangeLong());
    return result;
}


JSValue jsTypeConversionsTestUnsignedLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testUnsignedLong());
    return result;
}


JSValue jsTypeConversionsTestEnforceRangeUnsignedLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testEnforceRangeUnsignedLong());
    return result;
}


JSValue jsTypeConversionsTestLongLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testLongLong());
    return result;
}


JSValue jsTypeConversionsTestEnforceRangeLongLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testEnforceRangeLongLong());
    return result;
}


JSValue jsTypeConversionsTestUnsignedLongLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testUnsignedLongLong());
    return result;
}


JSValue jsTypeConversionsTestEnforceRangeUnsignedLongLong(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testEnforceRangeUnsignedLongLong());
    return result;
}


JSValue jsTypeConversionsTestByte(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testByte());
    return result;
}


JSValue jsTypeConversionsTestEnforceRangeByte(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testEnforceRangeByte());
    return result;
}


JSValue jsTypeConversionsTestOctet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testOctet());
    return result;
}


JSValue jsTypeConversionsTestEnforceRangeOctet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    JSValue result = jsNumber(impl->testEnforceRangeOctet());
    return result;
}


void JSTypeConversions::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSTypeConversions* thisObject = jsCast<JSTypeConversions*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSTypeConversions, Base>(exec, propertyName, value, &JSTypeConversionsTable, thisObject, slot);
}

void setJSTypeConversionsTestLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setTestLong(nativeValue);
}


void setJSTypeConversionsTestEnforceRangeLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    int nativeValue(toInt32(exec, value, EnforceRange));
    if (exec->hadException())
        return;
    impl->setTestEnforceRangeLong(nativeValue);
}


void setJSTypeConversionsTestUnsignedLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    unsigned nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setTestUnsignedLong(nativeValue);
}


void setJSTypeConversionsTestEnforceRangeUnsignedLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    unsigned nativeValue(toUInt32(exec, value, EnforceRange));
    if (exec->hadException())
        return;
    impl->setTestEnforceRangeUnsignedLong(nativeValue);
}


void setJSTypeConversionsTestLongLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    long long nativeValue(toInt64(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setTestLongLong(nativeValue);
}


void setJSTypeConversionsTestEnforceRangeLongLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    long long nativeValue(toInt64(exec, value, EnforceRange));
    if (exec->hadException())
        return;
    impl->setTestEnforceRangeLongLong(nativeValue);
}


void setJSTypeConversionsTestUnsignedLongLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    unsigned long long nativeValue(toUInt64(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setTestUnsignedLongLong(nativeValue);
}


void setJSTypeConversionsTestEnforceRangeUnsignedLongLong(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    unsigned long long nativeValue(toUInt64(exec, value, EnforceRange));
    if (exec->hadException())
        return;
    impl->setTestEnforceRangeUnsignedLongLong(nativeValue);
}


void setJSTypeConversionsTestByte(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    int8_t nativeValue(toInt8(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setTestByte(nativeValue);
}


void setJSTypeConversionsTestEnforceRangeByte(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    int8_t nativeValue(toInt8(exec, value, EnforceRange));
    if (exec->hadException())
        return;
    impl->setTestEnforceRangeByte(nativeValue);
}


void setJSTypeConversionsTestOctet(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    uint8_t nativeValue(toUInt8(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setTestOctet(nativeValue);
}


void setJSTypeConversionsTestEnforceRangeOctet(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSTypeConversions* castedThis = jsCast<JSTypeConversions*>(thisObject);
    TypeConversions* impl = static_cast<TypeConversions*>(castedThis->impl());
    uint8_t nativeValue(toUInt8(exec, value, EnforceRange));
    if (exec->hadException())
        return;
    impl->setTestEnforceRangeOctet(nativeValue);
}


static inline bool isObservable(JSTypeConversions* jsTypeConversions)
{
    if (jsTypeConversions->hasCustomProperties())
        return true;
    return false;
}

bool JSTypeConversionsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSTypeConversions* jsTypeConversions = jsCast<JSTypeConversions*>(handle.get().asCell());
    if (!isObservable(jsTypeConversions))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSTypeConversionsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSTypeConversions* jsTypeConversions = jsCast<JSTypeConversions*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsTypeConversions->impl(), jsTypeConversions);
    jsTypeConversions->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, TypeConversions* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSTypeConversions>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to TypeConversions.
    COMPILE_ASSERT(!__is_polymorphic(TypeConversions), TypeConversions_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<TypeConversions>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSTypeConversions>(exec, globalObject, impl);
}

TypeConversions* toTypeConversions(JSC::JSValue value)
{
    return value.inherits(&JSTypeConversions::s_info) ? jsCast<JSTypeConversions*>(asObject(value))->impl() : 0;
}

}
