/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGElementInstance.h"

#include "EventListener.h"
#include "JSEventListener.h"
#include "JSSVGElement.h"
#include "JSSVGElementInstance.h"
#include "JSSVGElementInstanceList.h"
#include "JSSVGUseElement.h"
#include "SVGElement.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"
#include "SVGUseElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGElementInstanceTableValues[] =
{
    { "correspondingElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceCorrespondingElement), (intptr_t)0, NoIntrinsic },
    { "correspondingUseElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceCorrespondingUseElement), (intptr_t)0, NoIntrinsic },
    { "parentNode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceParentNode), (intptr_t)0, NoIntrinsic },
    { "childNodes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceChildNodes), (intptr_t)0, NoIntrinsic },
    { "firstChild", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceFirstChild), (intptr_t)0, NoIntrinsic },
    { "lastChild", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceLastChild), (intptr_t)0, NoIntrinsic },
    { "previousSibling", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstancePreviousSibling), (intptr_t)0, NoIntrinsic },
    { "nextSibling", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceNextSibling), (intptr_t)0, NoIntrinsic },
    { "onabort", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnabort), (intptr_t)setJSSVGElementInstanceOnabort, NoIntrinsic },
    { "onblur", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnblur), (intptr_t)setJSSVGElementInstanceOnblur, NoIntrinsic },
    { "onchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnchange), (intptr_t)setJSSVGElementInstanceOnchange, NoIntrinsic },
    { "onclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnclick), (intptr_t)setJSSVGElementInstanceOnclick, NoIntrinsic },
    { "oncontextmenu", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOncontextmenu), (intptr_t)setJSSVGElementInstanceOncontextmenu, NoIntrinsic },
    { "ondblclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndblclick), (intptr_t)setJSSVGElementInstanceOndblclick, NoIntrinsic },
    { "onerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnerror), (intptr_t)setJSSVGElementInstanceOnerror, NoIntrinsic },
    { "onfocus", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnfocus), (intptr_t)setJSSVGElementInstanceOnfocus, NoIntrinsic },
    { "oninput", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOninput), (intptr_t)setJSSVGElementInstanceOninput, NoIntrinsic },
    { "onkeydown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnkeydown), (intptr_t)setJSSVGElementInstanceOnkeydown, NoIntrinsic },
    { "onkeypress", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnkeypress), (intptr_t)setJSSVGElementInstanceOnkeypress, NoIntrinsic },
    { "onkeyup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnkeyup), (intptr_t)setJSSVGElementInstanceOnkeyup, NoIntrinsic },
    { "onload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnload), (intptr_t)setJSSVGElementInstanceOnload, NoIntrinsic },
    { "onmousedown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmousedown), (intptr_t)setJSSVGElementInstanceOnmousedown, NoIntrinsic },
    { "onmouseenter", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseenter), (intptr_t)setJSSVGElementInstanceOnmouseenter, NoIntrinsic },
    { "onmouseleave", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseleave), (intptr_t)setJSSVGElementInstanceOnmouseleave, NoIntrinsic },
    { "onmousemove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmousemove), (intptr_t)setJSSVGElementInstanceOnmousemove, NoIntrinsic },
    { "onmouseout", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseout), (intptr_t)setJSSVGElementInstanceOnmouseout, NoIntrinsic },
    { "onmouseover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseover), (intptr_t)setJSSVGElementInstanceOnmouseover, NoIntrinsic },
    { "onmouseup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmouseup), (intptr_t)setJSSVGElementInstanceOnmouseup, NoIntrinsic },
    { "onmousewheel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnmousewheel), (intptr_t)setJSSVGElementInstanceOnmousewheel, NoIntrinsic },
    { "onbeforecut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnbeforecut), (intptr_t)setJSSVGElementInstanceOnbeforecut, NoIntrinsic },
    { "oncut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOncut), (intptr_t)setJSSVGElementInstanceOncut, NoIntrinsic },
    { "onbeforecopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnbeforecopy), (intptr_t)setJSSVGElementInstanceOnbeforecopy, NoIntrinsic },
    { "oncopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOncopy), (intptr_t)setJSSVGElementInstanceOncopy, NoIntrinsic },
    { "onbeforepaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnbeforepaste), (intptr_t)setJSSVGElementInstanceOnbeforepaste, NoIntrinsic },
    { "onpaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnpaste), (intptr_t)setJSSVGElementInstanceOnpaste, NoIntrinsic },
    { "ondragenter", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragenter), (intptr_t)setJSSVGElementInstanceOndragenter, NoIntrinsic },
    { "ondragover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragover), (intptr_t)setJSSVGElementInstanceOndragover, NoIntrinsic },
    { "ondragleave", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragleave), (intptr_t)setJSSVGElementInstanceOndragleave, NoIntrinsic },
    { "ondrop", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndrop), (intptr_t)setJSSVGElementInstanceOndrop, NoIntrinsic },
    { "ondragstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragstart), (intptr_t)setJSSVGElementInstanceOndragstart, NoIntrinsic },
    { "ondrag", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndrag), (intptr_t)setJSSVGElementInstanceOndrag, NoIntrinsic },
    { "ondragend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOndragend), (intptr_t)setJSSVGElementInstanceOndragend, NoIntrinsic },
    { "onreset", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnreset), (intptr_t)setJSSVGElementInstanceOnreset, NoIntrinsic },
    { "onresize", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnresize), (intptr_t)setJSSVGElementInstanceOnresize, NoIntrinsic },
    { "onscroll", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnscroll), (intptr_t)setJSSVGElementInstanceOnscroll, NoIntrinsic },
    { "onsearch", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnsearch), (intptr_t)setJSSVGElementInstanceOnsearch, NoIntrinsic },
    { "onselect", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnselect), (intptr_t)setJSSVGElementInstanceOnselect, NoIntrinsic },
    { "onselectstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnselectstart), (intptr_t)setJSSVGElementInstanceOnselectstart, NoIntrinsic },
    { "onsubmit", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnsubmit), (intptr_t)setJSSVGElementInstanceOnsubmit, NoIntrinsic },
    { "onunload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceOnunload), (intptr_t)setJSSVGElementInstanceOnunload, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGElementInstanceConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementInstanceTable = { 138, 127, JSSVGElementInstanceTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGElementInstanceConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementInstanceConstructorTable = { 1, 0, JSSVGElementInstanceConstructorTableValues, 0 };
const ClassInfo JSSVGElementInstanceConstructor::s_info = { "SVGElementInstanceConstructor", &Base::s_info, &JSSVGElementInstanceConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGElementInstanceConstructor) };

JSSVGElementInstanceConstructor::JSSVGElementInstanceConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGElementInstanceConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGElementInstancePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGElementInstanceConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstanceConstructor, JSDOMWrapper>(exec, &JSSVGElementInstanceConstructorTable, jsCast<JSSVGElementInstanceConstructor*>(cell), propertyName, slot);
}

bool JSSVGElementInstanceConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGElementInstanceConstructor, JSDOMWrapper>(exec, &JSSVGElementInstanceConstructorTable, jsCast<JSSVGElementInstanceConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGElementInstancePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGElementInstancePrototypeTable = { 1, 0, JSSVGElementInstancePrototypeTableValues, 0 };
const ClassInfo JSSVGElementInstancePrototype::s_info = { "SVGElementInstancePrototype", &Base::s_info, &JSSVGElementInstancePrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGElementInstancePrototype) };

JSObject* JSSVGElementInstancePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElementInstance>(exec, globalObject);
}

const ClassInfo JSSVGElementInstance::s_info = { "SVGElementInstance", &Base::s_info, &JSSVGElementInstanceTable, 0 , CREATE_METHOD_TABLE(JSSVGElementInstance) };

JSSVGElementInstance::JSSVGElementInstance(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGElementInstance> impl)
    : JSEventTarget(structure, globalObject, impl)
{
}

void JSSVGElementInstance::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGElementInstance::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGElementInstancePrototype::create(exec->vm(), globalObject, JSSVGElementInstancePrototype::createStructure(exec->vm(), globalObject, JSEventTargetPrototype::self(exec, globalObject)));
}

bool JSSVGElementInstance::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGElementInstance* thisObject = jsCast<JSSVGElementInstance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, thisObject, propertyName, slot);
}

bool JSSVGElementInstance::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGElementInstance* thisObject = jsCast<JSSVGElementInstance*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGElementInstance, Base>(exec, &JSSVGElementInstanceTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGElementInstanceCorrespondingElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->correspondingElement()));
    return result;
}


JSValue jsSVGElementInstanceCorrespondingUseElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->correspondingUseElement()));
    return result;
}


JSValue jsSVGElementInstanceParentNode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->parentNode()));
    return result;
}


JSValue jsSVGElementInstanceChildNodes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->childNodes()));
    return result;
}


JSValue jsSVGElementInstanceFirstChild(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->firstChild()));
    return result;
}


JSValue jsSVGElementInstanceLastChild(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->lastChild()));
    return result;
}


JSValue jsSVGElementInstancePreviousSibling(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->previousSibling()));
    return result;
}


JSValue jsSVGElementInstanceNextSibling(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextSibling()));
    return result;
}


JSValue jsSVGElementInstanceOnabort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnblur(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnclick(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOncontextmenu(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndblclick(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnfocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOninput(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnkeydown(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnkeypress(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnkeyup(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmousedown(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseenter(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseleave(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmousemove(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseout(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseover(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmouseup(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnmousewheel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnbeforecut(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOncut(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnbeforecopy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOncopy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnbeforepaste(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnpaste(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragenter(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragover(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragleave(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndrop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndrag(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOndragend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnreset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnresize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onresize()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnscroll(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnsearch(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnselect(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnselectstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnsubmit(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceOnunload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    if (EventListener* listener = impl->onunload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsSVGElementInstanceConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGElementInstance* domObject = jsCast<JSSVGElementInstance*>(asObject(slotBase));
    return JSSVGElementInstance::getConstructor(exec, domObject->globalObject());
}

void JSSVGElementInstance::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGElementInstance* thisObject = jsCast<JSSVGElementInstance*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGElementInstance, Base>(exec, propertyName, value, &JSSVGElementInstanceTable, thisObject, slot);
}

void setJSSVGElementInstanceOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnabort(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnblur(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnchange(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnclick(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOncontextmenu(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndblclick(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnerror(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnfocus(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOninput(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnkeydown(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnkeypress(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnkeyup(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnload(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmousedown(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmouseenter(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmouseleave(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmousemove(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmouseout(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmouseover(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmouseup(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnmousewheel(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnbeforecut(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOncut(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnbeforecopy(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOncopy(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnbeforepaste(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnpaste(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndragenter(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndragover(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndragleave(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndrop(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndragstart(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndrag(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOndragend(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnreset(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnresize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnresize(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnscroll(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnsearch(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnselect(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnselectstart(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnsubmit(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


void setJSSVGElementInstanceOnunload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSVGElementInstance* castedThis = jsCast<JSSVGElementInstance*>(thisObject);
    SVGElementInstance* impl = static_cast<SVGElementInstance*>(castedThis->impl());
    JSValue correspondingElementWrapper = toJS(exec, castedThis->globalObject(), impl->correspondingElement());
    if (correspondingElementWrapper.isObject())
        impl->setOnunload(createJSAttributeEventListener(exec, value, asObject(correspondingElementWrapper)));
}


JSValue JSSVGElementInstance::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGElementInstanceConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGElementInstance@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18SVGElementInstanceE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGElementInstance* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGElementInstance>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7SVGElementInstance@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore18SVGElementInstanceE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails SVGElementInstance does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(SVGElementInstance), SVGElementInstance_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // SVGElementInstance has subclasses. If SVGElementInstance has subclasses that get passed
    // to toJS() we currently require SVGElementInstance you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<SVGElementInstance>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGElementInstance>(exec, globalObject, impl);
}

SVGElementInstance* toSVGElementInstance(JSC::JSValue value)
{
    return value.inherits(&JSSVGElementInstance::s_info) ? jsCast<JSSVGElementInstance*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
