/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(SVG_FONTS)

#include "JSSVGAltGlyphElement.h"

#include "KURL.h"
#include "SVGAltGlyphElement.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedString.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAltGlyphElementTableValues[] =
{
    { "glyphRef", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementGlyphRef), (intptr_t)setJSSVGAltGlyphElementGlyphRef, NoIntrinsic },
    { "format", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementFormat), (intptr_t)setJSSVGAltGlyphElementFormat, NoIntrinsic },
#if ENABLE(SVG)
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementHref), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAltGlyphElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAltGlyphElementTable = { 8, 7, JSSVGAltGlyphElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAltGlyphElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAltGlyphElementConstructorTable = { 1, 0, JSSVGAltGlyphElementConstructorTableValues, 0 };
const ClassInfo JSSVGAltGlyphElementConstructor::s_info = { "SVGAltGlyphElementConstructor", &Base::s_info, &JSSVGAltGlyphElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAltGlyphElementConstructor) };

JSSVGAltGlyphElementConstructor::JSSVGAltGlyphElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAltGlyphElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGAltGlyphElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGAltGlyphElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAltGlyphElementConstructor, JSDOMWrapper>(exec, &JSSVGAltGlyphElementConstructorTable, jsCast<JSSVGAltGlyphElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGAltGlyphElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAltGlyphElementConstructor, JSDOMWrapper>(exec, &JSSVGAltGlyphElementConstructorTable, jsCast<JSSVGAltGlyphElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAltGlyphElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAltGlyphElementPrototypeTable = { 1, 0, JSSVGAltGlyphElementPrototypeTableValues, 0 };
const ClassInfo JSSVGAltGlyphElementPrototype::s_info = { "SVGAltGlyphElementPrototype", &Base::s_info, &JSSVGAltGlyphElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAltGlyphElementPrototype) };

JSObject* JSSVGAltGlyphElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAltGlyphElement>(exec, globalObject);
}

const ClassInfo JSSVGAltGlyphElement::s_info = { "SVGAltGlyphElement", &Base::s_info, &JSSVGAltGlyphElementTable, 0 , CREATE_METHOD_TABLE(JSSVGAltGlyphElement) };

JSSVGAltGlyphElement::JSSVGAltGlyphElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAltGlyphElement> impl)
    : JSSVGTextPositioningElement(structure, globalObject, impl)
{
}

void JSSVGAltGlyphElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAltGlyphElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAltGlyphElementPrototype::create(exec->vm(), globalObject, JSSVGAltGlyphElementPrototype::createStructure(exec->vm(), globalObject, JSSVGTextPositioningElementPrototype::self(exec, globalObject)));
}

bool JSSVGAltGlyphElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAltGlyphElement* thisObject = jsCast<JSSVGAltGlyphElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAltGlyphElement, Base>(exec, &JSSVGAltGlyphElementTable, thisObject, propertyName, slot);
}

bool JSSVGAltGlyphElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAltGlyphElement* thisObject = jsCast<JSSVGAltGlyphElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAltGlyphElement, Base>(exec, &JSSVGAltGlyphElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAltGlyphElementGlyphRef(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAltGlyphElement* castedThis = jsCast<JSSVGAltGlyphElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAltGlyphElement* impl = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->glyphRef());
    return result;
}


JSValue jsSVGAltGlyphElementFormat(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAltGlyphElement* castedThis = jsCast<JSSVGAltGlyphElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAltGlyphElement* impl = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->format());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGAltGlyphElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAltGlyphElement* castedThis = jsCast<JSSVGAltGlyphElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAltGlyphElement* impl = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGAltGlyphElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAltGlyphElement* domObject = jsCast<JSSVGAltGlyphElement*>(asObject(slotBase));
    return JSSVGAltGlyphElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGAltGlyphElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGAltGlyphElement* thisObject = jsCast<JSSVGAltGlyphElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGAltGlyphElement, Base>(exec, propertyName, value, &JSSVGAltGlyphElementTable, thisObject, slot);
}

void setJSSVGAltGlyphElementGlyphRef(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGAltGlyphElement* castedThis = jsCast<JSSVGAltGlyphElement*>(thisObject);
    SVGAltGlyphElement* impl = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setGlyphRef(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSSVGAltGlyphElementFormat(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGAltGlyphElement* castedThis = jsCast<JSSVGAltGlyphElement*>(thisObject);
    SVGAltGlyphElement* impl = static_cast<SVGAltGlyphElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setFormat(nativeValue, ec);
    setDOMException(exec, ec);
}


JSValue JSSVGAltGlyphElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAltGlyphElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FONTS)
