/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAElement.h"

#include "JSSVGAnimatedString.h"
#include "SVGAElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAElementTableValues[] =
{
    { "target", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementTarget), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SVG)
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementHref), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAElementTable = { 9, 7, JSSVGAElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAElementConstructorTable = { 1, 0, JSSVGAElementConstructorTableValues, 0 };
const ClassInfo JSSVGAElementConstructor::s_info = { "SVGAElementConstructor", &Base::s_info, &JSSVGAElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAElementConstructor) };

JSSVGAElementConstructor::JSSVGAElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGAElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGAElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAElementConstructor, JSDOMWrapper>(exec, &JSSVGAElementConstructorTable, jsCast<JSSVGAElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGAElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAElementConstructor, JSDOMWrapper>(exec, &JSSVGAElementConstructorTable, jsCast<JSSVGAElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAElementPrototypeTable = { 1, 0, JSSVGAElementPrototypeTableValues, 0 };
const ClassInfo JSSVGAElementPrototype::s_info = { "SVGAElementPrototype", &Base::s_info, &JSSVGAElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAElementPrototype) };

JSObject* JSSVGAElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAElement>(exec, globalObject);
}

const ClassInfo JSSVGAElement::s_info = { "SVGAElement", &Base::s_info, &JSSVGAElementTable, 0 , CREATE_METHOD_TABLE(JSSVGAElement) };

JSSVGAElement::JSSVGAElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGAElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAElementPrototype::create(exec->vm(), globalObject, JSSVGAElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGAElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAElement* thisObject = jsCast<JSSVGAElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAElement, Base>(exec, &JSSVGAElementTable, thisObject, propertyName, slot);
}

bool JSSVGAElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAElement* thisObject = jsCast<JSSVGAElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAElement, Base>(exec, &JSSVGAElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAElementTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->svgTargetAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGAElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

#if ENABLE(SVG)
JSValue jsSVGAElementHref(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* castedThis = jsCast<JSSVGAElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAElement* impl = static_cast<SVGAElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGAElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAElement* domObject = jsCast<JSSVGAElement*>(asObject(slotBase));
    return JSSVGAElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGAElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
