/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternals.h"

#include "CSSStyleDeclaration.h"
#include "ClientRect.h"
#include "ClientRectList.h"
#include "DOMStringList.h"
#include "DOMWindow.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "InternalSettings.h"
#include "Internals.h"
#include "JSArrayBuffer.h"
#include "JSCSSStyleDeclaration.h"
#include "JSClientRect.h"
#include "JSClientRectList.h"
#include "JSDOMBinding.h"
#include "JSDOMStringList.h"
#include "JSDocument.h"
#include "JSElement.h"
#include "JSFloat32Array.h"
#include "JSInternalSettings.h"
#include "JSMallocStatistics.h"
#include "JSMemoryInfo.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "JSRange.h"
#include "JSTimeRanges.h"
#include "JSTypeConversions.h"
#include "JSWebKitPoint.h"
#include "KURL.h"
#include "MallocStatistics.h"
#include "MemoryInfo.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"
#include "Range.h"
#include "SerializedScriptValue.h"
#include "StylePropertySet.h"
#include "TimeRanges.h"
#include "TypeConversions.h"
#include "WebKitPoint.h"
#include <runtime/Error.h>
#include <runtime/JSArray.h>
#include <runtime/JSString.h>
#include <wtf/ArrayBuffer.h>
#include <wtf/GetPtr.h>

#if ENABLE(INSPECTOR)
#include "JSDOMWindow.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSInternalsTableValues[] =
{
    { "settings", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsSettings), (intptr_t)0, NoIntrinsic },
    { "workerThreadCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsWorkerThreadCount), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInternalsTable = { 5, 3, JSInternalsTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSInternalsPrototypeTableValues[] =
{
    { "LAYER_TREE_INCLUDES_VISIBLE_RECTS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLAYER_TREE_INCLUDES_VISIBLE_RECTS), (intptr_t)0, NoIntrinsic },
    { "LAYER_TREE_INCLUDES_TILE_CACHES", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLAYER_TREE_INCLUDES_TILE_CACHES), (intptr_t)0, NoIntrinsic },
    { "LAYER_TREE_INCLUDES_REPAINT_RECTS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLAYER_TREE_INCLUDES_REPAINT_RECTS), (intptr_t)0, NoIntrinsic },
    { "LAYER_TREE_INCLUDES_PAINTING_PHASES", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLAYER_TREE_INCLUDES_PAINTING_PHASES), (intptr_t)0, NoIntrinsic },
    { "address", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAddress), (intptr_t)1, NoIntrinsic },
    { "elementRenderTreeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionElementRenderTreeAsText), (intptr_t)1, NoIntrinsic },
    { "isPreloaded", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsPreloaded), (intptr_t)1, NoIntrinsic },
    { "isLoadingFromMemoryCache", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsLoadingFromMemoryCache), (intptr_t)1, NoIntrinsic },
    { "numberOfScopedHTMLStyleChildren", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfScopedHTMLStyleChildren), (intptr_t)1, NoIntrinsic },
    { "computedStyleIncludingVisitedInfo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionComputedStyleIncludingVisitedInfo), (intptr_t)1, NoIntrinsic },
    { "ensureShadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEnsureShadowRoot), (intptr_t)1, NoIntrinsic },
    { "createShadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCreateShadowRoot), (intptr_t)1, NoIntrinsic },
    { "shadowRoot", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowRoot), (intptr_t)1, NoIntrinsic },
    { "shadowRootType", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowRootType), (intptr_t)1, NoIntrinsic },
    { "includerFor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIncluderFor), (intptr_t)1, NoIntrinsic },
    { "shadowPseudoId", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShadowPseudoId), (intptr_t)1, NoIntrinsic },
    { "setShadowPseudoId", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetShadowPseudoId), (intptr_t)2, NoIntrinsic },
    { "createContentElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCreateContentElement), (intptr_t)0, NoIntrinsic },
    { "isValidContentSelect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsValidContentSelect), (intptr_t)1, NoIntrinsic },
    { "treeScopeRootNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTreeScopeRootNode), (intptr_t)1, NoIntrinsic },
    { "parentTreeScope", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionParentTreeScope), (intptr_t)1, NoIntrinsic },
    { "numberOfActiveAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfActiveAnimations), (intptr_t)0, NoIntrinsic },
    { "suspendAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSuspendAnimations), (intptr_t)1, NoIntrinsic },
    { "resumeAnimations", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionResumeAnimations), (intptr_t)1, NoIntrinsic },
    { "animationsAreSuspended", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAnimationsAreSuspended), (intptr_t)1, NoIntrinsic },
    { "pauseAnimationAtTimeOnElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPauseAnimationAtTimeOnElement), (intptr_t)3, NoIntrinsic },
    { "pauseAnimationAtTimeOnPseudoElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPauseAnimationAtTimeOnPseudoElement), (intptr_t)4, NoIntrinsic },
    { "pauseTransitionAtTimeOnElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPauseTransitionAtTimeOnElement), (intptr_t)3, NoIntrinsic },
    { "pauseTransitionAtTimeOnPseudoElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPauseTransitionAtTimeOnPseudoElement), (intptr_t)4, NoIntrinsic },
    { "nextSiblingByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNextSiblingByWalker), (intptr_t)1, NoIntrinsic },
    { "firstChildByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionFirstChildByWalker), (intptr_t)1, NoIntrinsic },
    { "lastChildByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLastChildByWalker), (intptr_t)1, NoIntrinsic },
    { "nextNodeByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNextNodeByWalker), (intptr_t)1, NoIntrinsic },
    { "previousNodeByWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPreviousNodeByWalker), (intptr_t)1, NoIntrinsic },
    { "attached", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAttached), (intptr_t)1, NoIntrinsic },
    { "visiblePlaceholder", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionVisiblePlaceholder), (intptr_t)1, NoIntrinsic },
    { "selectColorInColorChooser", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSelectColorInColorChooser), (intptr_t)2, NoIntrinsic },
    { "formControlStateOfPreviousHistoryItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItem), (intptr_t)0, NoIntrinsic },
    { "setFormControlStateOfPreviousHistoryItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItem), (intptr_t)1, NoIntrinsic },
    { "absoluteCaretBounds", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAbsoluteCaretBounds), (intptr_t)0, NoIntrinsic },
    { "boundingBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionBoundingBox), (intptr_t)1, NoIntrinsic },
    { "inspectorHighlightRects", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionInspectorHighlightRects), (intptr_t)1, NoIntrinsic },
    { "markerCountForNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerCountForNode), (intptr_t)2, NoIntrinsic },
    { "markerRangeForNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerRangeForNode), (intptr_t)3, NoIntrinsic },
    { "markerDescriptionForNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerDescriptionForNode), (intptr_t)3, NoIntrinsic },
    { "addTextMatchMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAddTextMatchMarker), (intptr_t)2, NoIntrinsic },
    { "setScrollViewPosition", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetScrollViewPosition), (intptr_t)3, NoIntrinsic },
    { "setPagination", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetPagination), (intptr_t)3, NoIntrinsic },
    { "configurationForViewport", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionConfigurationForViewport), (intptr_t)6, NoIntrinsic },
    { "wasLastChangeUserEdit", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWasLastChangeUserEdit), (intptr_t)1, NoIntrinsic },
    { "elementShouldAutoComplete", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionElementShouldAutoComplete), (intptr_t)1, NoIntrinsic },
    { "suggestedValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSuggestedValue), (intptr_t)1, NoIntrinsic },
    { "setSuggestedValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetSuggestedValue), (intptr_t)2, NoIntrinsic },
    { "setEditingValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetEditingValue), (intptr_t)2, NoIntrinsic },
    { "setAutofilled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetAutofilled), (intptr_t)2, NoIntrinsic },
    { "paintControlTints", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPaintControlTints), (intptr_t)1, NoIntrinsic },
    { "scrollElementToRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionScrollElementToRect), (intptr_t)5, NoIntrinsic },
    { "rangeFromLocationAndLength", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRangeFromLocationAndLength), (intptr_t)3, NoIntrinsic },
    { "locationFromRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLocationFromRange), (intptr_t)2, NoIntrinsic },
    { "lengthFromRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLengthFromRange), (intptr_t)2, NoIntrinsic },
    { "rangeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRangeAsText), (intptr_t)1, NoIntrinsic },
    { "setDelegatesScrolling", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetDelegatesScrolling), (intptr_t)2, NoIntrinsic },
    { "touchPositionAdjustedToBestClickableNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchPositionAdjustedToBestClickableNode), (intptr_t)5, NoIntrinsic },
    { "touchNodeAdjustedToBestClickableNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchNodeAdjustedToBestClickableNode), (intptr_t)5, NoIntrinsic },
    { "touchPositionAdjustedToBestContextMenuNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchPositionAdjustedToBestContextMenuNode), (intptr_t)5, NoIntrinsic },
    { "touchNodeAdjustedToBestContextMenuNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchNodeAdjustedToBestContextMenuNode), (intptr_t)5, NoIntrinsic },
    { "bestZoomableAreaForTouchPoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionBestZoomableAreaForTouchPoint), (intptr_t)5, NoIntrinsic },
    { "lastSpellCheckRequestSequence", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLastSpellCheckRequestSequence), (intptr_t)1, NoIntrinsic },
    { "lastSpellCheckProcessedSequence", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLastSpellCheckProcessedSequence), (intptr_t)1, NoIntrinsic },
    { "userPreferredLanguages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionUserPreferredLanguages), (intptr_t)0, NoIntrinsic },
    { "setUserPreferredLanguages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetUserPreferredLanguages), (intptr_t)1, NoIntrinsic },
    { "wheelEventHandlerCount", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWheelEventHandlerCount), (intptr_t)1, NoIntrinsic },
    { "touchEventHandlerCount", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTouchEventHandlerCount), (intptr_t)1, NoIntrinsic },
    { "nodesFromRect", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNodesFromRect), (intptr_t)10, NoIntrinsic },
    { "emitInspectorDidBeginFrame", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEmitInspectorDidBeginFrame), (intptr_t)0, NoIntrinsic },
    { "emitInspectorDidCancelFrame", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEmitInspectorDidCancelFrame), (intptr_t)0, NoIntrinsic },
    { "hasSpellingMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasSpellingMarker), (intptr_t)3, NoIntrinsic },
    { "hasGrammarMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasGrammarMarker), (intptr_t)3, NoIntrinsic },
    { "hasAutocorrectedMarker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionHasAutocorrectedMarker), (intptr_t)3, NoIntrinsic },
    { "setContinuousSpellCheckingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetContinuousSpellCheckingEnabled), (intptr_t)1, NoIntrinsic },
    { "setAutomaticQuoteSubstitutionEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetAutomaticQuoteSubstitutionEnabled), (intptr_t)1, NoIntrinsic },
    { "setAutomaticLinkDetectionEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetAutomaticLinkDetectionEnabled), (intptr_t)1, NoIntrinsic },
    { "setAutomaticDashSubstitutionEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetAutomaticDashSubstitutionEnabled), (intptr_t)1, NoIntrinsic },
    { "setAutomaticTextReplacementEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetAutomaticTextReplacementEnabled), (intptr_t)1, NoIntrinsic },
    { "setAutomaticSpellingCorrectionEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetAutomaticSpellingCorrectionEnabled), (intptr_t)1, NoIntrinsic },
    { "isOverwriteModeEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsOverwriteModeEnabled), (intptr_t)1, NoIntrinsic },
    { "toggleOverwriteModeEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionToggleOverwriteModeEnabled), (intptr_t)1, NoIntrinsic },
    { "numberOfScrollableAreas", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfScrollableAreas), (intptr_t)1, NoIntrinsic },
    { "isPageBoxVisible", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsPageBoxVisible), (intptr_t)2, NoIntrinsic },
    { "layerTreeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionLayerTreeAsText), (intptr_t)1, NoIntrinsic },
    { "scrollingStateTreeAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionScrollingStateTreeAsText), (intptr_t)1, NoIntrinsic },
    { "mainThreadScrollingReasons", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMainThreadScrollingReasons), (intptr_t)1, NoIntrinsic },
    { "nonFastScrollableRects", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNonFastScrollableRects), (intptr_t)1, NoIntrinsic },
    { "repaintRectsAsText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRepaintRectsAsText), (intptr_t)1, NoIntrinsic },
    { "garbageCollectDocumentResources", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGarbageCollectDocumentResources), (intptr_t)1, NoIntrinsic },
    { "allowRoundingHacks", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAllowRoundingHacks), (intptr_t)0, NoIntrinsic },
    { "insertAuthorCSS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionInsertAuthorCSS), (intptr_t)2, NoIntrinsic },
    { "insertUserCSS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionInsertUserCSS), (intptr_t)2, NoIntrinsic },
#if ENABLE(INSPECTOR)
    { "numberOfLiveNodes", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfLiveNodes), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "numberOfLiveDocuments", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfLiveDocuments), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "consoleMessageArgumentCounts", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionConsoleMessageArgumentCounts), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "openDummyInspectorFrontend", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionOpenDummyInspectorFrontend), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "closeDummyInspectorFrontend", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCloseDummyInspectorFrontend), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "setInspectorResourcesDataSizeLimits", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetInspectorResourcesDataSizeLimits), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(INSPECTOR)
    { "setJavaScriptProfilingEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetJavaScriptProfilingEnabled), (intptr_t)1, NoIntrinsic },
#endif
    { "counterValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCounterValue), (intptr_t)1, NoIntrinsic },
    { "pageNumber", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPageNumber), (intptr_t)1, NoIntrinsic },
    { "shortcutIconURLs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionShortcutIconURLs), (intptr_t)1, NoIntrinsic },
    { "allIconURLs", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionAllIconURLs), (intptr_t)1, NoIntrinsic },
    { "numberOfPages", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionNumberOfPages), (intptr_t)0, NoIntrinsic },
    { "pageProperty", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPageProperty), (intptr_t)2, NoIntrinsic },
    { "pageSizeAndMarginsInPixels", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionPageSizeAndMarginsInPixels), (intptr_t)7, NoIntrinsic },
    { "setPageScaleFactor", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetPageScaleFactor), (intptr_t)3, NoIntrinsic },
    { "setHeaderHeight", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetHeaderHeight), (intptr_t)2, NoIntrinsic },
    { "setFooterHeight", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetFooterHeight), (intptr_t)2, NoIntrinsic },
    { "webkitWillEnterFullScreenForElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWebkitWillEnterFullScreenForElement), (intptr_t)2, NoIntrinsic },
    { "webkitDidEnterFullScreenForElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWebkitDidEnterFullScreenForElement), (intptr_t)2, NoIntrinsic },
    { "webkitWillExitFullScreenForElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWebkitWillExitFullScreenForElement), (intptr_t)2, NoIntrinsic },
    { "webkitDidExitFullScreenForElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionWebkitDidExitFullScreenForElement), (intptr_t)2, NoIntrinsic },
    { "registerURLSchemeAsBypassingContentSecurityPolicy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicy), (intptr_t)1, NoIntrinsic },
    { "removeURLSchemeRegisteredAsBypassingContentSecurityPolicy", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicy), (intptr_t)1, NoIntrinsic },
    { "mallocStatistics", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMallocStatistics), (intptr_t)0, NoIntrinsic },
    { "typeConversions", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionTypeConversions), (intptr_t)0, NoIntrinsic },
    { "memoryInfo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMemoryInfo), (intptr_t)0, NoIntrinsic },
    { "getReferencedFilePaths", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGetReferencedFilePaths), (intptr_t)0, NoIntrinsic },
    { "startTrackingRepaints", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionStartTrackingRepaints), (intptr_t)1, NoIntrinsic },
    { "stopTrackingRepaints", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionStopTrackingRepaints), (intptr_t)1, NoIntrinsic },
    { "getCurrentCursorInfo", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGetCurrentCursorInfo), (intptr_t)1, NoIntrinsic },
    { "markerTextForListItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionMarkerTextForListItem), (intptr_t)1, NoIntrinsic },
    { "deserializeBuffer", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionDeserializeBuffer), (intptr_t)1, NoIntrinsic },
    { "serializeObject", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSerializeObject), (intptr_t)1, NoIntrinsic },
    { "setUsesOverlayScrollbars", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetUsesOverlayScrollbars), (intptr_t)1, NoIntrinsic },
    { "forceReload", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionForceReload), (intptr_t)1, NoIntrinsic },
#if ENABLE(VIDEO)
    { "simulateAudioInterruption", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSimulateAudioInterruption), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
    { "initializeMockCDM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionInitializeMockCDM), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(SPEECH_SYNTHESIS)
    { "enableMockSpeechSynthesizer", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionEnableMockSpeechSynthesizer), (intptr_t)0, NoIntrinsic },
#endif
    { "setDelegatesMenuListRendering", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetDelegatesMenuListRendering), (intptr_t)1, NoIntrinsic },
    { "getImageSourceURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionGetImageSourceURL), (intptr_t)1, NoIntrinsic },
#if ENABLE(VIDEO_TRACK)
    { "captionsStyleSheetOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCaptionsStyleSheetOverride), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(VIDEO_TRACK)
    { "setCaptionsStyleSheetOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetCaptionsStyleSheetOverride), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(VIDEO_TRACK)
    { "setPrimaryAudioTrackLanguageOverride", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetPrimaryAudioTrackLanguageOverride), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(VIDEO_TRACK)
    { "setCaptionDisplayMode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSetCaptionDisplayMode), (intptr_t)1, NoIntrinsic },
#endif
#if ENABLE(VIDEO)
    { "createTimeRanges", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionCreateTimeRanges), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(VIDEO)
    { "closestTimeToTimeRanges", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionClosestTimeToTimeRanges), (intptr_t)2, NoIntrinsic },
#endif
    { "isSelectPopupVisible", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsSelectPopupVisible), (intptr_t)1, NoIntrinsic },
    { "isPluginUnavailabilityIndicatorObscured", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionIsPluginUnavailabilityIndicatorObscured), (intptr_t)1, NoIntrinsic },
    { "selectionBounds", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsInternalsPrototypeFunctionSelectionBounds), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSInternalsPrototypeTable = { 528, 511, JSInternalsPrototypeTableValues, 0 };
const ClassInfo JSInternalsPrototype::s_info = { "InternalsPrototype", &Base::s_info, &JSInternalsPrototypeTable, 0, CREATE_METHOD_TABLE(JSInternalsPrototype) };

JSObject* JSInternalsPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSInternals>(exec, globalObject);
}

bool JSInternalsPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInternalsPrototype* thisObject = jsCast<JSInternalsPrototype*>(cell);
    return getStaticPropertySlot<JSInternalsPrototype, JSObject>(exec, &JSInternalsPrototypeTable, thisObject, propertyName, slot);
}

bool JSInternalsPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInternalsPrototype* thisObject = jsCast<JSInternalsPrototype*>(object);
    return getStaticPropertyDescriptor<JSInternalsPrototype, JSObject>(exec, &JSInternalsPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSInternals::s_info = { "Internals", &Base::s_info, &JSInternalsTable, 0 , CREATE_METHOD_TABLE(JSInternals) };

JSInternals::JSInternals(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Internals> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSInternals::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSInternals::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSInternalsPrototype::create(exec->vm(), globalObject, JSInternalsPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSInternals::destroy(JSC::JSCell* cell)
{
    JSInternals* thisObject = static_cast<JSInternals*>(cell);
    thisObject->JSInternals::~JSInternals();
}

JSInternals::~JSInternals()
{
    releaseImplIfNotNull();
}

bool JSInternals::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSInternals* thisObject = jsCast<JSInternals*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSInternals, Base>(exec, &JSInternalsTable, thisObject, propertyName, slot);
}

bool JSInternals::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSInternals* thisObject = jsCast<JSInternals*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSInternals, Base>(exec, &JSInternalsTable, thisObject, propertyName, descriptor);
}

JSValue jsInternalsSettings(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->settings()));
    return result;
}


JSValue jsInternalsWorkerThreadCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    JSValue result = jsNumber(impl->workerThreadCount());
    return result;
}


EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddress(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->address(node));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementRenderTreeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->elementRenderTreeAsText(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPreloaded(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPreloaded(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsLoadingFromMemoryCache(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isLoadingFromMemoryCache(url));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfScopedHTMLStyleChildren(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* scope(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->numberOfScopedHTMLStyleChildren(scope, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionComputedStyleIncludingVisitedInfo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->computedStyleIncludingVisitedInfo(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnsureShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->ensureShadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createShadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRoot(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* host(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->shadowRoot(host, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRootType(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* root(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->shadowRootType(root, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIncluderFor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->includerFor(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowPseudoId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->shadowPseudoId(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShadowPseudoId(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& id(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setShadowPseudoId(element, id, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateContentElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createContentElement(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsValidContentSelect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* contentElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isValidContentSelect(contentElement, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTreeScopeRootNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->treeScopeRootNode(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParentTreeScope(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->parentTreeScope(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfActiveAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->numberOfActiveAnimations());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSuspendAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->suspendAnimations(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResumeAnimations(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->resumeAnimations(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAnimationsAreSuspended(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->animationsAreSuspended(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseAnimationAtTimeOnElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& animationName(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double pauseTime(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(2)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->pauseAnimationAtTimeOnElement(animationName, pauseTime, element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseAnimationAtTimeOnPseudoElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& animationName(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double pauseTime(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(2)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& pseudoId(exec->argument(3).isEmpty() ? String() : exec->argument(3).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->pauseAnimationAtTimeOnPseudoElement(animationName, pauseTime, element, pseudoId, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseTransitionAtTimeOnElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& propertyName(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double pauseTime(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(2)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->pauseTransitionAtTimeOnElement(propertyName, pauseTime, element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseTransitionAtTimeOnPseudoElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& property(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    double pauseTime(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(2)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& pseudoId(exec->argument(3).isEmpty() ? String() : exec->argument(3).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->pauseTransitionAtTimeOnPseudoElement(property, pauseTime, element, pseudoId, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNextSiblingByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextSiblingByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFirstChildByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->firstChildByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastChildByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->lastChildByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNextNodeByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nextNodeByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPreviousNodeByWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->previousNodeByWalker(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAttached(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->attached(node, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionVisiblePlaceholder(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->visiblePlaceholder(element));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSelectColorInColorChooser(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& colorValue(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->selectColorInColorChooser(element, colorValue);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->formControlStateOfPreviousHistoryItem(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Vector<String> values(toNativeArray<String>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFormControlStateOfPreviousHistoryItem(values, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAbsoluteCaretBounds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->absoluteCaretBounds(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBoundingBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->boundingBox(element, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInspectorHighlightRects(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->inspectorHighlightRects(document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerCountForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& markerType(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->markerCountForNode(node, markerType, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerRangeForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& markerType(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(toUInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->markerRangeForNode(node, markerType, index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerDescriptionForNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& markerType(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned index(toUInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->markerDescriptionForNode(node, markerType, index, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddTextMatchMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Range* range(toRange(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool isActive(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->addTextMatchMarker(range, isActive);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetScrollViewPosition(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setScrollViewPosition(document, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPagination(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& mode(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int gap(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 3) {
        impl->setPagination(document, mode, gap, ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    int pageLength(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPagination(document, mode, gap, pageLength, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionConfigurationForViewport(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 6)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float devicePixelRatio(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int deviceWidth(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int deviceHeight(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int availableWidth(toInt32(exec, exec->argument(4), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int availableHeight(toInt32(exec, exec->argument(5), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->configurationForViewport(document, devicePixelRatio, deviceWidth, deviceHeight, availableWidth, availableHeight, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWasLastChangeUserEdit(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* textField(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->wasLastChangeUserEdit(textField, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementShouldAutoComplete(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->elementShouldAutoComplete(inputElement, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSuggestedValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->suggestedValue(inputElement, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetSuggestedValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setSuggestedValue(inputElement, value, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetEditingValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setEditingValue(inputElement, value, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutofilled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* inputElement(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool enabled(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAutofilled(inputElement, enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPaintControlTints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->paintControlTints(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollElementToRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int w(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int h(toInt32(exec, exec->argument(4), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->scrollElementToRect(element, x, y, w, h, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeFromLocationAndLength(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* scope(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int rangeLocation(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int rangeLength(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->rangeFromLocationAndLength(scope, rangeLocation, rangeLength, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLocationFromRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* scope(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Range* range(toRange(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->locationFromRange(scope, range, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLengthFromRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* scope(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Range* range(toRange(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->lengthFromRange(scope, range, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Range* range(toRange(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->rangeAsText(range, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetDelegatesScrolling(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDelegatesScrolling(enabled, document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchPositionAdjustedToBestClickableNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchPositionAdjustedToBestClickableNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchNodeAdjustedToBestClickableNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchNodeAdjustedToBestClickableNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchPositionAdjustedToBestContextMenuNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchPositionAdjustedToBestContextMenuNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchNodeAdjustedToBestContextMenuNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->touchNodeAdjustedToBestContextMenuNode(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBestZoomableAreaForTouchPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 5)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int x(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Document* document(toDocument(exec->argument(4)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->bestZoomableAreaForTouchPoint(x, y, width, height, document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckRequestSequence(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->lastSpellCheckRequestSequence(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckProcessedSequence(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->lastSpellCheckProcessedSequence(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPreferredLanguages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->userPreferredLanguages());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserPreferredLanguages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Vector<String> languages(toNativeArray<String>(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUserPreferredLanguages(languages);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWheelEventHandlerCount(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->wheelEventHandlerCount(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchEventHandlerCount(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->touchEventHandlerCount(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNodesFromRect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 10)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned topPadding(toUInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned rightPadding(toUInt32(exec, exec->argument(4), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned bottomPadding(toUInt32(exec, exec->argument(5), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned leftPadding(toUInt32(exec, exec->argument(6), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ignoreClipping(exec->argument(7).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool allowShadowContent(exec->argument(8).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool allowChildFrameContent(exec->argument(9).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nodesFromRect(document, x, y, topPadding, rightPadding, bottomPadding, leftPadding, ignoreClipping, allowShadowContent, allowChildFrameContent, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEmitInspectorDidBeginFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->emitInspectorDidBeginFrame();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEmitInspectorDidCancelFrame(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->emitInspectorDidCancelFrame();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSpellingMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int from(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasSpellingMarker(document, from, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasGrammarMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int from(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasGrammarMarker(document, from, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasAutocorrectedMarker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int from(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int length(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasAutocorrectedMarker(document, from, length, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetContinuousSpellCheckingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setContinuousSpellCheckingEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticQuoteSubstitutionEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAutomaticQuoteSubstitutionEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticLinkDetectionEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAutomaticLinkDetectionEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticDashSubstitutionEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAutomaticDashSubstitutionEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticTextReplacementEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAutomaticTextReplacementEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticSpellingCorrectionEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setAutomaticSpellingCorrectionEnabled(enabled, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsOverwriteModeEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isOverwriteModeEnabled(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionToggleOverwriteModeEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->toggleOverwriteModeEnabled(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfScrollableAreas(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->numberOfScrollableAreas(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPageBoxVisible(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int pageNumber(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPageBoxVisible(document, pageNumber, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerTreeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsStringWithCache(exec, impl->layerTreeAsText(document, ec));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    unsigned short flags(toUInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->layerTreeAsText(document, flags, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollingStateTreeAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->scrollingStateTreeAsText(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMainThreadScrollingReasons(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->mainThreadScrollingReasons(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNonFastScrollableRects(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nonFastScrollableRects(document, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRepaintRectsAsText(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->repaintRectsAsText(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGarbageCollectDocumentResources(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->garbageCollectDocumentResources(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAllowRoundingHacks(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->allowRoundingHacks();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInsertAuthorCSS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& css(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->insertAuthorCSS(document, css);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInsertUserCSS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& css(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->insertUserCSS(document, css);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveNodes(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->numberOfLiveNodes());
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveDocuments(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsNumber(impl->numberOfLiveDocuments());
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionConsoleMessageArgumentCounts(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->consoleMessageArgumentCounts(document));
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionOpenDummyInspectorFrontend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& url(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->openDummyInspectorFrontend(url)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCloseDummyInspectorFrontend(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->closeDummyInspectorFrontend();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetInspectorResourcesDataSizeLimits(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int maximumResourcesContentSize(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int maximumSingleResourceContentSize(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setInspectorResourcesDataSizeLimits(maximumResourcesContentSize, maximumSingleResourceContentSize, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(INSPECTOR)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetJavaScriptProfilingEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    bool creates(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setJavaScriptProfilingEnabled(creates, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCounterValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->counterValue(element));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageNumber(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(impl->pageNumber(element));
        return JSValue::encode(result);
    }

    float pageWidth(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 2) {

        JSC::JSValue result = jsNumber(impl->pageNumber(element, pageWidth));
        return JSValue::encode(result);
    }

    float pageHeight(exec->argument(2).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->pageNumber(element, pageWidth, pageHeight));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShortcutIconURLs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->shortcutIconURLs(document));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAllIconURLs(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->allIconURLs(document));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfPages(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {

        JSC::JSValue result = jsNumber(impl->numberOfPages());
        return JSValue::encode(result);
    }

    double pageWidthInPixels(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (argsCount <= 1) {

        JSC::JSValue result = jsNumber(impl->numberOfPages(pageWidthInPixels));
        return JSValue::encode(result);
    }

    double pageHeightInPixels(exec->argument(1).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->numberOfPages(pageWidthInPixels, pageHeightInPixels));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageProperty(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& propertyName(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int pageNumber(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->pageProperty(propertyName, pageNumber, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageSizeAndMarginsInPixels(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 7)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    int pageIndex(toInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginTop(toInt32(exec, exec->argument(3), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginRight(toInt32(exec, exec->argument(4), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginBottom(toInt32(exec, exec->argument(5), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int marginLeft(toInt32(exec, exec->argument(6), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->pageSizeAndMarginsInPixels(pageIndex, width, height, marginTop, marginRight, marginBottom, marginLeft, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageScaleFactor(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    float scaleFactor(exec->argument(0).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int x(toInt32(exec, exec->argument(1), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(toInt32(exec, exec->argument(2), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPageScaleFactor(scaleFactor, x, y, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetHeaderHeight(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setHeaderHeight(document, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFooterHeight(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float height(exec->argument(1).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setFooterHeight(document, height);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitWillEnterFullScreenForElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->webkitWillEnterFullScreenForElement(document, element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitDidEnterFullScreenForElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->webkitDidEnterFullScreenForElement(document, element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitWillExitFullScreenForElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->webkitWillExitFullScreenForElement(document, element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitDidExitFullScreenForElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Element* element(toElement(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->webkitDidExitFullScreenForElement(document, element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& scheme(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->registerURLSchemeAsBypassingContentSecurityPolicy(scheme);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicy(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& scheme(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->removeURLSchemeRegisteredAsBypassingContentSecurityPolicy(scheme);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMallocStatistics(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->mallocStatistics()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTypeConversions(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->typeConversions()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMemoryInfo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->memoryInfo()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetReferencedFilePaths(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());

    JSC::JSValue result = jsArray(exec, castedThis->globalObject(), impl->getReferencedFilePaths());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingRepaints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->startTrackingRepaints(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStopTrackingRepaints(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->stopTrackingRepaints(document, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCurrentCursorInfo(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Document* document(toDocument(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->getCurrentCursorInfo(document, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerTextForListItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->markerTextForListItem(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeserializeBuffer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ArrayBuffer* buffer(toArrayBuffer(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = impl->deserializeBuffer(buffer) ? impl->deserializeBuffer(buffer)->deserialize(exec, castedThis->globalObject(), 0) : jsNull();
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSerializeObject(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    RefPtr<SerializedScriptValue> obj(SerializedScriptValue::create(exec, exec->argument(0), 0, 0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->serializeObject(obj)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUsesOverlayScrollbars(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool enabled(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setUsesOverlayScrollbars(enabled);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionForceReload(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool endToEnd(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->forceReload(endToEnd);
    return JSValue::encode(jsUndefined());
}

#if ENABLE(VIDEO)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateAudioInterruption(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->simulateAudioInterruption(node);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(ENCRYPTED_MEDIA_V2)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInitializeMockCDM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->initializeMockCDM();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(SPEECH_SYNTHESIS)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnableMockSpeechSynthesizer(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    impl->enableMockSpeechSynthesizer();
    return JSValue::encode(jsUndefined());
}

#endif

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetDelegatesMenuListRendering(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    bool forceOn(exec->argument(0).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setDelegatesMenuListRendering(forceOn);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetImageSourceURL(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->getImageSourceURL(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCaptionsStyleSheetOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = jsStringWithCache(exec, impl->captionsStyleSheetOverride(ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptionsStyleSheetOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& override(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCaptionsStyleSheetOverride(override, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPrimaryAudioTrackLanguageOverride(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& language(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setPrimaryAudioTrackLanguageOverride(language, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(VIDEO_TRACK)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptionDisplayMode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& mode(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCaptionDisplayMode(mode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(VIDEO)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateTimeRanges(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Float32Array* startTimes(toFloat32Array(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Float32Array* endTimes(toFloat32Array(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createTimeRanges(startTimes, endTimes)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(VIDEO)
EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClosestTimeToTimeRanges(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    double time(exec->argument(0).toNumber(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    TimeRanges* ranges(toTimeRanges(exec->argument(1)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsNumber(impl->closestTimeToTimeRanges(time, ranges));
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSelectPopupVisible(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isSelectPopupVisible(node));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPluginUnavailabilityIndicatorObscured(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Element* element(toElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->isPluginUnavailabilityIndicatorObscured(element, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSelectionBounds(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSInternals::s_info))
        return throwVMTypeError(exec);
    JSInternals* castedThis = jsCast<JSInternals*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSInternals::s_info);
    Internals* impl = static_cast<Internals*>(castedThis->impl());
    ExceptionCode ec = 0;

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->selectionBounds(ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

// Constant getters

JSValue jsInternalsLAYER_TREE_INCLUDES_VISIBLE_RECTS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsInternalsLAYER_TREE_INCLUDES_TILE_CACHES(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsInternalsLAYER_TREE_INCLUDES_REPAINT_RECTS(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsInternalsLAYER_TREE_INCLUDES_PAINTING_PHASES(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

static inline bool isObservable(JSInternals* jsInternals)
{
    if (jsInternals->hasCustomProperties())
        return true;
    return false;
}

bool JSInternalsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSInternals* jsInternals = jsCast<JSInternals*>(handle.get().asCell());
    if (!isObservable(jsInternals))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSInternalsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSInternals* jsInternals = jsCast<JSInternals*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsInternals->impl(), jsInternals);
    jsInternals->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Internals@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9InternalsE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Internals* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSInternals>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7Internals@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9InternalsE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails Internals does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(Internals), Internals_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // Internals has subclasses. If Internals has subclasses that get passed
    // to toJS() we currently require Internals you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<Internals>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSInternals>(exec, globalObject, impl);
}

Internals* toInternals(JSC::JSValue value)
{
    return value.inherits(&JSInternals::s_info) ? jsCast<JSInternals*>(asObject(value))->impl() : 0;
}

}
