/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBCursorWithValue.h"

#include "IDBCursorWithValue.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSIDBCursorWithValueTableValues[] =
{
    { "value", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorWithValueValue), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBCursorWithValueConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBCursorWithValueTable = { 4, 3, JSIDBCursorWithValueTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSIDBCursorWithValueConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBCursorWithValueConstructorTable = { 1, 0, JSIDBCursorWithValueConstructorTableValues, 0 };
static const HashTable* getJSIDBCursorWithValueConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBCursorWithValueConstructorTable);
}

const ClassInfo JSIDBCursorWithValueConstructor::s_info = { "IDBCursorWithValueConstructor", &Base::s_info, 0, getJSIDBCursorWithValueConstructorTable, CREATE_METHOD_TABLE(JSIDBCursorWithValueConstructor) };

JSIDBCursorWithValueConstructor::JSIDBCursorWithValueConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSIDBCursorWithValueConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSIDBCursorWithValuePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSIDBCursorWithValueConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSIDBCursorWithValueConstructor, JSDOMWrapper>(exec, getJSIDBCursorWithValueConstructorTable(exec), jsCast<JSIDBCursorWithValueConstructor*>(cell), propertyName, slot);
}

bool JSIDBCursorWithValueConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSIDBCursorWithValueConstructor, JSDOMWrapper>(exec, getJSIDBCursorWithValueConstructorTable(exec), jsCast<JSIDBCursorWithValueConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSIDBCursorWithValuePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSIDBCursorWithValuePrototypeTable = { 1, 0, JSIDBCursorWithValuePrototypeTableValues, 0 };
static const HashTable* getJSIDBCursorWithValuePrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBCursorWithValuePrototypeTable);
}

const ClassInfo JSIDBCursorWithValuePrototype::s_info = { "IDBCursorWithValuePrototype", &Base::s_info, 0, getJSIDBCursorWithValuePrototypeTable, CREATE_METHOD_TABLE(JSIDBCursorWithValuePrototype) };

JSObject* JSIDBCursorWithValuePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSIDBCursorWithValue>(exec, globalObject);
}

static const HashTable* getJSIDBCursorWithValueTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->vm(), &JSIDBCursorWithValueTable);
}

const ClassInfo JSIDBCursorWithValue::s_info = { "IDBCursorWithValue", &Base::s_info, 0, getJSIDBCursorWithValueTable , CREATE_METHOD_TABLE(JSIDBCursorWithValue) };

JSIDBCursorWithValue::JSIDBCursorWithValue(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<IDBCursorWithValue> impl)
    : JSIDBCursor(structure, globalObject, impl)
{
}

void JSIDBCursorWithValue::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSIDBCursorWithValue::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSIDBCursorWithValuePrototype::create(exec->vm(), globalObject, JSIDBCursorWithValuePrototype::createStructure(exec->vm(), globalObject, JSIDBCursorPrototype::self(exec, globalObject)));
}

bool JSIDBCursorWithValue::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSIDBCursorWithValue* thisObject = jsCast<JSIDBCursorWithValue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSIDBCursorWithValue, Base>(exec, getJSIDBCursorWithValueTable(exec), thisObject, propertyName, slot);
}

bool JSIDBCursorWithValue::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSIDBCursorWithValue* thisObject = jsCast<JSIDBCursorWithValue*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSIDBCursorWithValue, Base>(exec, getJSIDBCursorWithValueTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsIDBCursorWithValueValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBCursorWithValue* castedThis = jsCast<JSIDBCursorWithValue*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    IDBCursorWithValue* impl = static_cast<IDBCursorWithValue*>(castedThis->impl());
    JSValue result = (impl->value().hasNoValue() ? jsNull() : impl->value().jsValue());
    return result;
}


JSValue jsIDBCursorWithValueConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSIDBCursorWithValue* domObject = jsCast<JSIDBCursorWithValue*>(asObject(slotBase));
    return JSIDBCursorWithValue::getConstructor(exec, domObject->globalObject());
}

JSValue JSIDBCursorWithValue::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBCursorWithValueConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(INDEXED_DATABASE)
