/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSHTMLDocument_h
#define JSHTMLDocument_h

#include "HTMLDocument.h"
#include "JSDOMBinding.h"
#include "JSDocument.h"
#include <runtime/JSObject.h>

namespace WebCore {

class JSHTMLDocument : public JSDocument {
public:
    typedef JSDocument Base;
    static JSHTMLDocument* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDocument> impl)
    {
        JSHTMLDocument* ptr = new (NotNull, JSC::allocateCell<JSHTMLDocument>(globalObject->vm().heap)) JSHTMLDocument(structure, globalObject, impl);
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static bool getOwnPropertySlotByIndex(JSC::JSCell*, JSC::ExecState*, unsigned propertyName, JSC::PropertySlot&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom attributes
    JSC::JSValue all(JSC::ExecState*) const;
    void setAll(JSC::ExecState*, JSC::JSValue);

    // Custom functions
    JSC::JSValue open(JSC::ExecState*);
    JSC::JSValue write(JSC::ExecState*);
    JSC::JSValue writeln(JSC::ExecState*);
protected:
    JSHTMLDocument(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<HTMLDocument>);
    void finishCreation(JSC::VM&);
    static const unsigned StructureFlags = JSC::HasImpureGetOwnPropertySlot | JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | Base::StructureFlags;
private:
    static bool canGetItemsForName(JSC::ExecState*, HTMLDocument*, JSC::PropertyName);
    static JSC::JSValue nameGetter(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
};


class JSHTMLDocumentPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSHTMLDocumentPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLDocumentPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLDocumentPrototype>(vm.heap)) JSHTMLDocumentPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSHTMLDocumentPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

class JSHTMLDocumentConstructor : public DOMConstructorObject {
private:
    JSHTMLDocumentConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLDocumentConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLDocumentConstructor* ptr = new (NotNull, JSC::allocateCell<JSHTMLDocumentConstructor>(*exec->heap())) JSHTMLDocumentConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionOpen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWrite(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWriteln(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClear(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionCaptureEvents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionReleaseEvents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionHasFocus(JSC::ExecState*);
// Attributes

JSC::JSValue jsHTMLDocumentEmbeds(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLDocumentPlugins(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLDocumentScripts(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLDocumentAll(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentAll(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentWidth(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLDocumentHeight(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLDocumentDir(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentDir(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentDesignMode(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentDesignMode(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentCompatMode(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLDocumentActiveElement(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsHTMLDocumentBgColor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentBgColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentFgColor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentFgColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentAlinkColor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentAlinkColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentLinkColor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentLinkColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentVlinkColor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSHTMLDocumentVlinkColor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsHTMLDocumentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);

} // namespace WebCore

#endif
