/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocumentFragment.h"

#include "DocumentFragment.h"
#include "Element.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSElement.h"
#include "JSNodeList.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDocumentFragmentTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentFragmentConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentFragmentTable = { 2, 1, JSDocumentFragmentTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDocumentFragmentConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentFragmentConstructorTable = { 1, 0, JSDocumentFragmentConstructorTableValues, 0 };
const ClassInfo JSDocumentFragmentConstructor::s_info = { "DocumentFragmentConstructor", &Base::s_info, &JSDocumentFragmentConstructorTable, 0, CREATE_METHOD_TABLE(JSDocumentFragmentConstructor) };

JSDocumentFragmentConstructor::JSDocumentFragmentConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDocumentFragmentConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDocumentFragmentPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDocumentFragmentConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentFragmentConstructor, JSDOMWrapper>(exec, &JSDocumentFragmentConstructorTable, jsCast<JSDocumentFragmentConstructor*>(cell), propertyName, slot);
}

bool JSDocumentFragmentConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDocumentFragmentConstructor, JSDOMWrapper>(exec, &JSDocumentFragmentConstructorTable, jsCast<JSDocumentFragmentConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDocumentFragmentPrototypeTableValues[] =
{
    { "querySelector", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentFragmentPrototypeFunctionQuerySelector), (intptr_t)1, NoIntrinsic },
    { "querySelectorAll", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentFragmentPrototypeFunctionQuerySelectorAll), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentFragmentPrototypeTable = { 4, 3, JSDocumentFragmentPrototypeTableValues, 0 };
const ClassInfo JSDocumentFragmentPrototype::s_info = { "DocumentFragmentPrototype", &Base::s_info, &JSDocumentFragmentPrototypeTable, 0, CREATE_METHOD_TABLE(JSDocumentFragmentPrototype) };

JSObject* JSDocumentFragmentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocumentFragment>(exec, globalObject);
}

bool JSDocumentFragmentPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDocumentFragmentPrototype* thisObject = jsCast<JSDocumentFragmentPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDocumentFragmentPrototypeTable, thisObject, propertyName, slot);
}

bool JSDocumentFragmentPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDocumentFragmentPrototype* thisObject = jsCast<JSDocumentFragmentPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDocumentFragmentPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDocumentFragment::s_info = { "DocumentFragment", &Base::s_info, &JSDocumentFragmentTable, 0 , CREATE_METHOD_TABLE(JSDocumentFragment) };

JSDocumentFragment::JSDocumentFragment(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DocumentFragment> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSDocumentFragment::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDocumentFragment::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDocumentFragmentPrototype::create(exec->vm(), globalObject, JSDocumentFragmentPrototype::createStructure(exec->vm(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSDocumentFragment::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDocumentFragment* thisObject = jsCast<JSDocumentFragment*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDocumentFragment, Base>(exec, &JSDocumentFragmentTable, thisObject, propertyName, slot);
}

bool JSDocumentFragment::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDocumentFragment* thisObject = jsCast<JSDocumentFragment*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDocumentFragment, Base>(exec, &JSDocumentFragmentTable, thisObject, propertyName, descriptor);
}

JSValue jsDocumentFragmentConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentFragment* domObject = jsCast<JSDocumentFragment*>(asObject(slotBase));
    return JSDocumentFragment::getConstructor(exec, domObject->globalObject());
}

JSValue JSDocumentFragment::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentFragmentConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionQuerySelector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocumentFragment::s_info))
        return throwVMTypeError(exec);
    JSDocumentFragment* castedThis = jsCast<JSDocumentFragment*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocumentFragment::s_info);
    DocumentFragment* impl = static_cast<DocumentFragment*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& selectors(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentFragmentPrototypeFunctionQuerySelectorAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocumentFragment::s_info))
        return throwVMTypeError(exec);
    JSDocumentFragment* castedThis = jsCast<JSDocumentFragment*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocumentFragment::s_info);
    DocumentFragment* impl = static_cast<DocumentFragment*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& selectors(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}
