INCLUDE(OptionsWindows)

ADD_DEFINITIONS(-D_CE_CRT_ALLOW_WIN_MINMAX)
ADD_DEFINITIONS(-DWTF_USE_WCHAR_UNICODE=1)
ADD_DEFINITIONS(-DWTF_USE_WININET=1)
ADD_DEFINITIONS(-DWTF_CPU_ARM_TRADITIONAL -DWINCEBASIC)
ADD_DEFINITIONS(-DJS_NO_EXPORT)
ADD_DEFINITIONS(-DHAVE_ACCESSIBILITY=0)
ADD_DEFINITIONS(-DJSCCOLLECTOR_VIRTUALMEM_RESERVATION=0x200000)

IF (NOT 3RDPARTY_DIR)
    IF (EXISTS $ENV{WEBKITTHIRDPARTYDIR})
        SET(3RDPARTY_DIR $ENV{WEBKITTHIRDPARTYDIR})
    ELSE ()
        MESSAGE(FATAL_ERROR "You must provide a third party directory for WinCE port.")
    ENDIF ()
ENDIF ()

INCLUDE_DIRECTORIES(${3RDPARTY_DIR}/ce-compat)
ADD_SUBDIRECTORY(${3RDPARTY_DIR} "${CMAKE_CURRENT_BINARY_DIR}/3rdparty")

WEBKIT_OPTION_BEGIN()
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_DRAG_SUPPORT OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_FTPDIR OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(ENABLE_INSPECTOR OFF)
WEBKIT_OPTION_DEFAULT_PORT_VALUE(USE_SYSTEM_MALLOC ON)
WEBKIT_OPTION_END()
