#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.
*/
#ifndef _CFFI_USE_EMBEDDING
#  include <pyconfig.h>
#  if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG)
#    define Py_LIMITED_API
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47

#define _CFFI__NUM_PRIM         48
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _CFFI_NUM_EXPORTS 26

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/

#include <sodium.h>

/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 4), // char const *()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char *, char const *, unsigned long long, unsigned long long, size_t)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 148), // char *
/*  4 */ _CFFI_OP(_CFFI_OP_POINTER, 148), // char const *
/*  5 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12), // unsigned long long
/*  6 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/*  7 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  9 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char *, char const *, unsigned long long, unsigned long long, size_t, int)
/* 10 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 11 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 12 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 13 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 14 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 15 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 16 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 17 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char const *, char const *, unsigned long long)
/* 18 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 19 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 20 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 21 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 22 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(char const *, unsigned long long, size_t)
/* 23 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 24 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 25 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 27 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(uint8_t const *, size_t, uint8_t const *, size_t, uint64_t, uint32_t, uint32_t, uint8_t *, size_t)
/* 28 */ _CFFI_OP(_CFFI_OP_POINTER, 149), // uint8_t const *
/* 29 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 30 */ _CFFI_OP(_CFFI_OP_NOOP, 28),
/* 31 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 32 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 24), // uint64_t
/* 33 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 34 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22),
/* 35 */ _CFFI_OP(_CFFI_OP_POINTER, 149), // uint8_t *
/* 36 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 37 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 38 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, size_t, unsigned char const *, unsigned long long, unsigned char const *, size_t, unsigned char const *, unsigned char const *)
/* 39 */ _CFFI_OP(_CFFI_OP_POINTER, 150), // unsigned char *
/* 40 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 41 */ _CFFI_OP(_CFFI_OP_POINTER, 150), // unsigned char const *
/* 42 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 43 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 44 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 45 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char *)
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 50 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 52 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char *, unsigned char const *)
/* 53 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 54 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 55 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 56 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *)
/* 58 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 59 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned char const *)
/* 62 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 63 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 64 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 65 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long)
/* 67 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 68 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 70 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long, unsigned char const *)
/* 72 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 73 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 74 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 75 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 76 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 77 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long, unsigned char const *, unsigned char const *)
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 79 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 80 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 81 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned char const *, unsigned long long, unsigned char const *, unsigned char const *, unsigned char const *)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 86 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 87 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 88 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 89 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned long long *, unsigned char const *, unsigned long long, unsigned char const *)
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 94 */ _CFFI_OP(_CFFI_OP_POINTER, 5), // unsigned long long *
/* 95 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 96 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 98 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 99 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(unsigned char *, unsigned long long, char const *, unsigned long long, unsigned char const *, unsigned long long, size_t, int)
/* 100 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 101 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 4),
/* 103 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 104 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 105 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 106 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 107 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, size_t)
/* 110 */ _CFFI_OP(_CFFI_OP_POINTER, 151), // void *
/* 111 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char *, size_t)
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 116 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 118 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char const *, size_t, size_t, unsigned char const *, unsigned char const *)
/* 119 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 121 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 122 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 125 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void *, unsigned char const *, unsigned long long)
/* 127 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 41),
/* 129 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 130 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 131 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void const *, void const *, size_t)
/* 132 */ _CFFI_OP(_CFFI_OP_POINTER, 151), // void const *
/* 133 */ _CFFI_OP(_CFFI_OP_NOOP, 132),
/* 134 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 135 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // int()(void)
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 138 */ _CFFI_OP(_CFFI_OP_FUNCTION, 7), // size_t()(void)
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 151), // void()(unsigned char *, unsigned long long)
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 39),
/* 142 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 12),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 151), // void()(void *, size_t)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 110),
/* 146 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 149 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 150 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 151 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_d_crypto_box(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4, unsigned char const * x5)
{
  return crypto_box(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  unsigned char const * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_box", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x5, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(41), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box _cffi_d_crypto_box
#endif

static int _cffi_d_crypto_box_afternm(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_box_afternm(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_afternm(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_box_afternm", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_afternm(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_afternm _cffi_d_crypto_box_afternm
#endif

static int _cffi_d_crypto_box_beforenm(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_box_beforenm(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_beforenm(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_box_beforenm", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_beforenm(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_beforenm _cffi_d_crypto_box_beforenm
#endif

static size_t _cffi_d_crypto_box_beforenmbytes(void)
{
  return crypto_box_beforenmbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_beforenmbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_beforenmbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_beforenmbytes _cffi_d_crypto_box_beforenmbytes
#endif

static size_t _cffi_d_crypto_box_boxzerobytes(void)
{
  return crypto_box_boxzerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_boxzerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_boxzerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_boxzerobytes _cffi_d_crypto_box_boxzerobytes
#endif

static int _cffi_d_crypto_box_keypair(unsigned char * x0, unsigned char * x1)
{
  return crypto_box_keypair(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_box_keypair", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(39), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_keypair(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_keypair _cffi_d_crypto_box_keypair
#endif

static size_t _cffi_d_crypto_box_noncebytes(void)
{
  return crypto_box_noncebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_noncebytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_noncebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_noncebytes _cffi_d_crypto_box_noncebytes
#endif

static int _cffi_d_crypto_box_open(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4, unsigned char const * x5)
{
  return crypto_box_open(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  unsigned char const * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_box_open", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x5, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(41), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_open(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_open _cffi_d_crypto_box_open
#endif

static int _cffi_d_crypto_box_open_afternm(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_box_open_afternm(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_open_afternm(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_box_open_afternm", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_open_afternm(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_open_afternm _cffi_d_crypto_box_open_afternm
#endif

static size_t _cffi_d_crypto_box_publickeybytes(void)
{
  return crypto_box_publickeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_publickeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_publickeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_publickeybytes _cffi_d_crypto_box_publickeybytes
#endif

static int _cffi_d_crypto_box_seal(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3)
{
  return crypto_box_seal(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seal(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "crypto_box_seal", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seal(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_seal _cffi_d_crypto_box_seal
#endif

static int _cffi_d_crypto_box_seal_open(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_box_seal_open(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seal_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_box_seal_open", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seal_open(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_seal_open _cffi_d_crypto_box_seal_open
#endif

static size_t _cffi_d_crypto_box_sealbytes(void)
{
  return crypto_box_sealbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_sealbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_sealbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_sealbytes _cffi_d_crypto_box_sealbytes
#endif

static size_t _cffi_d_crypto_box_secretkeybytes(void)
{
  return crypto_box_secretkeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_secretkeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_secretkeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_secretkeybytes _cffi_d_crypto_box_secretkeybytes
#endif

static int _cffi_d_crypto_box_seed_keypair(unsigned char * x0, unsigned char * x1, unsigned char const * x2)
{
  return crypto_box_seed_keypair(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seed_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_box_seed_keypair", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(39), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seed_keypair(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_box_seed_keypair _cffi_d_crypto_box_seed_keypair
#endif

static size_t _cffi_d_crypto_box_seedbytes(void)
{
  return crypto_box_seedbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_seedbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_seedbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_seedbytes _cffi_d_crypto_box_seedbytes
#endif

static size_t _cffi_d_crypto_box_zerobytes(void)
{
  return crypto_box_zerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_box_zerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_box_zerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_box_zerobytes _cffi_d_crypto_box_zerobytes
#endif

static size_t _cffi_d_crypto_generichash_blake2b_bytes(void)
{
  return crypto_generichash_blake2b_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_bytes _cffi_d_crypto_generichash_blake2b_bytes
#endif

static size_t _cffi_d_crypto_generichash_blake2b_bytes_max(void)
{
  return crypto_generichash_blake2b_bytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_bytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_bytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_bytes_max _cffi_d_crypto_generichash_blake2b_bytes_max
#endif

static size_t _cffi_d_crypto_generichash_blake2b_bytes_min(void)
{
  return crypto_generichash_blake2b_bytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_bytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_bytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_bytes_min _cffi_d_crypto_generichash_blake2b_bytes_min
#endif

static int _cffi_d_crypto_generichash_blake2b_final(void * x0, unsigned char * x1, size_t x2)
{
  return crypto_generichash_blake2b_final(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_final(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char * x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_final", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (void *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(39), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_final(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_final _cffi_d_crypto_generichash_blake2b_final
#endif

static int _cffi_d_crypto_generichash_blake2b_init_salt_personal(void * x0, unsigned char const * x1, size_t x2, size_t x3, unsigned char const * x4, unsigned char const * x5)
{
  return crypto_generichash_blake2b_init_salt_personal(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_init_salt_personal(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char const * x1;
  size_t x2;
  size_t x3;
  unsigned char const * x4;
  unsigned char const * x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_init_salt_personal", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (void *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg5, (char **)&x5);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x5 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x5, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x5, _cffi_type(41), arg5) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_init_salt_personal(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_init_salt_personal _cffi_d_crypto_generichash_blake2b_init_salt_personal
#endif

static size_t _cffi_d_crypto_generichash_blake2b_keybytes(void)
{
  return crypto_generichash_blake2b_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_keybytes _cffi_d_crypto_generichash_blake2b_keybytes
#endif

static size_t _cffi_d_crypto_generichash_blake2b_keybytes_max(void)
{
  return crypto_generichash_blake2b_keybytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_keybytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_keybytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_keybytes_max _cffi_d_crypto_generichash_blake2b_keybytes_max
#endif

static size_t _cffi_d_crypto_generichash_blake2b_keybytes_min(void)
{
  return crypto_generichash_blake2b_keybytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_keybytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_keybytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_keybytes_min _cffi_d_crypto_generichash_blake2b_keybytes_min
#endif

static size_t _cffi_d_crypto_generichash_blake2b_personalbytes(void)
{
  return crypto_generichash_blake2b_personalbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_personalbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_personalbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_personalbytes _cffi_d_crypto_generichash_blake2b_personalbytes
#endif

static int _cffi_d_crypto_generichash_blake2b_salt_personal(unsigned char * x0, size_t x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4, size_t x5, unsigned char const * x6, unsigned char const * x7)
{
  return crypto_generichash_blake2b_salt_personal(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_salt_personal(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  size_t x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  size_t x5;
  unsigned char const * x6;
  unsigned char const * x7;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_salt_personal", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, size_t);
  if (x5 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg6, (char **)&x6);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x6 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x6, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x6, _cffi_type(41), arg6) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg7, (char **)&x7);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x7 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x7, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x7, _cffi_type(41), arg7) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_salt_personal(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_salt_personal _cffi_d_crypto_generichash_blake2b_salt_personal
#endif

static size_t _cffi_d_crypto_generichash_blake2b_saltbytes(void)
{
  return crypto_generichash_blake2b_saltbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_saltbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_saltbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_saltbytes _cffi_d_crypto_generichash_blake2b_saltbytes
#endif

static int _cffi_d_crypto_generichash_blake2b_update(void * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_generichash_blake2b_update(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_blake2b_update(PyObject *self, PyObject *args)
{
  void * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_generichash_blake2b_update", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (void *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_blake2b_update(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_generichash_blake2b_update _cffi_d_crypto_generichash_blake2b_update
#endif

static size_t _cffi_d_crypto_generichash_statebytes(void)
{
  return crypto_generichash_statebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_generichash_statebytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_generichash_statebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_generichash_statebytes _cffi_d_crypto_generichash_statebytes
#endif

static int _cffi_d_crypto_hash(unsigned char * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_hash(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_hash", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_hash _cffi_d_crypto_hash
#endif

static int _cffi_d_crypto_hash_sha256(unsigned char * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_hash_sha256(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha256(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_hash_sha256", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha256(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_hash_sha256 _cffi_d_crypto_hash_sha256
#endif

static size_t _cffi_d_crypto_hash_sha256_bytes(void)
{
  return crypto_hash_sha256_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha256_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha256_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_hash_sha256_bytes _cffi_d_crypto_hash_sha256_bytes
#endif

static int _cffi_d_crypto_hash_sha512(unsigned char * x0, unsigned char const * x1, unsigned long long x2)
{
  return crypto_hash_sha512(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha512(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_hash_sha512", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha512(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_hash_sha512 _cffi_d_crypto_hash_sha512
#endif

static size_t _cffi_d_crypto_hash_sha512_bytes(void)
{
  return crypto_hash_sha512_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_hash_sha512_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_hash_sha512_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_hash_sha512_bytes _cffi_d_crypto_hash_sha512_bytes
#endif

static int _cffi_d_crypto_pwhash(unsigned char * x0, unsigned long long x1, char const * x2, unsigned long long x3, unsigned char const * x4, unsigned long long x5, size_t x6, int x7)
{
  return crypto_pwhash(x0, x1, x2, x3, x4, x5, x6, x7);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long x1;
  char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  unsigned long long x5;
  size_t x6;
  int x7;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash", 8, 8, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(4), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  x5 = _cffi_to_c_int(arg5, unsigned long long);
  if (x5 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, size_t);
  if (x6 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x7 = _cffi_to_c_int(arg7, int);
  if (x7 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash(x0, x1, x2, x3, x4, x5, x6, x7); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash _cffi_d_crypto_pwhash
#endif

static int _cffi_d_crypto_pwhash_alg_argon2i13(void)
{
  return crypto_pwhash_alg_argon2i13();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_alg_argon2i13(PyObject *self, PyObject *noarg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_alg_argon2i13(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_alg_argon2i13 _cffi_d_crypto_pwhash_alg_argon2i13
#endif

static int _cffi_d_crypto_pwhash_alg_argon2id13(void)
{
  return crypto_pwhash_alg_argon2id13();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_alg_argon2id13(PyObject *self, PyObject *noarg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_alg_argon2id13(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_alg_argon2id13 _cffi_d_crypto_pwhash_alg_argon2id13
#endif

static int _cffi_d_crypto_pwhash_alg_default(void)
{
  return crypto_pwhash_alg_default();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_alg_default(PyObject *self, PyObject *noarg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_alg_default(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_alg_default _cffi_d_crypto_pwhash_alg_default
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_interactive(void)
{
  return crypto_pwhash_argon2i_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_interactive _cffi_d_crypto_pwhash_argon2i_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_max(void)
{
  return crypto_pwhash_argon2i_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_max _cffi_d_crypto_pwhash_argon2i_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_min(void)
{
  return crypto_pwhash_argon2i_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_min _cffi_d_crypto_pwhash_argon2i_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_moderate(void)
{
  return crypto_pwhash_argon2i_memlimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_moderate _cffi_d_crypto_pwhash_argon2i_memlimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_memlimit_sensitive(void)
{
  return crypto_pwhash_argon2i_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_memlimit_sensitive _cffi_d_crypto_pwhash_argon2i_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_interactive(void)
{
  return crypto_pwhash_argon2i_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_interactive _cffi_d_crypto_pwhash_argon2i_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_max(void)
{
  return crypto_pwhash_argon2i_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_max _cffi_d_crypto_pwhash_argon2i_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_min(void)
{
  return crypto_pwhash_argon2i_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_min _cffi_d_crypto_pwhash_argon2i_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_moderate(void)
{
  return crypto_pwhash_argon2i_opslimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_moderate _cffi_d_crypto_pwhash_argon2i_opslimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2i_opslimit_sensitive(void)
{
  return crypto_pwhash_argon2i_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_opslimit_sensitive _cffi_d_crypto_pwhash_argon2i_opslimit_sensitive
#endif

static char const * _cffi_d_crypto_pwhash_argon2i_strprefix(void)
{
  return crypto_pwhash_argon2i_strprefix();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2i_strprefix(PyObject *self, PyObject *noarg)
{
  char const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2i_strprefix(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_pointer((char *)result, _cffi_type(4));
}
#else
#  define _cffi_f_crypto_pwhash_argon2i_strprefix _cffi_d_crypto_pwhash_argon2i_strprefix
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_interactive(void)
{
  return crypto_pwhash_argon2id_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_interactive _cffi_d_crypto_pwhash_argon2id_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_max(void)
{
  return crypto_pwhash_argon2id_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_max _cffi_d_crypto_pwhash_argon2id_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_min(void)
{
  return crypto_pwhash_argon2id_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_min _cffi_d_crypto_pwhash_argon2id_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_moderate(void)
{
  return crypto_pwhash_argon2id_memlimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_moderate _cffi_d_crypto_pwhash_argon2id_memlimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_memlimit_sensitive(void)
{
  return crypto_pwhash_argon2id_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_memlimit_sensitive _cffi_d_crypto_pwhash_argon2id_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_interactive(void)
{
  return crypto_pwhash_argon2id_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_interactive _cffi_d_crypto_pwhash_argon2id_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_max(void)
{
  return crypto_pwhash_argon2id_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_max _cffi_d_crypto_pwhash_argon2id_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_min(void)
{
  return crypto_pwhash_argon2id_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_min _cffi_d_crypto_pwhash_argon2id_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_moderate(void)
{
  return crypto_pwhash_argon2id_opslimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_moderate _cffi_d_crypto_pwhash_argon2id_opslimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_argon2id_opslimit_sensitive(void)
{
  return crypto_pwhash_argon2id_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_opslimit_sensitive _cffi_d_crypto_pwhash_argon2id_opslimit_sensitive
#endif

static char const * _cffi_d_crypto_pwhash_argon2id_strprefix(void)
{
  return crypto_pwhash_argon2id_strprefix();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_argon2id_strprefix(PyObject *self, PyObject *noarg)
{
  char const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_argon2id_strprefix(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_pointer((char *)result, _cffi_type(4));
}
#else
#  define _cffi_f_crypto_pwhash_argon2id_strprefix _cffi_d_crypto_pwhash_argon2id_strprefix
#endif

static size_t _cffi_d_crypto_pwhash_bytes_max(void)
{
  return crypto_pwhash_bytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_bytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_bytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_bytes_max _cffi_d_crypto_pwhash_bytes_max
#endif

static size_t _cffi_d_crypto_pwhash_bytes_min(void)
{
  return crypto_pwhash_bytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_bytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_bytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_bytes_min _cffi_d_crypto_pwhash_bytes_min
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_interactive(void)
{
  return crypto_pwhash_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_interactive _cffi_d_crypto_pwhash_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_max(void)
{
  return crypto_pwhash_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_max _cffi_d_crypto_pwhash_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_min(void)
{
  return crypto_pwhash_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_min _cffi_d_crypto_pwhash_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_moderate(void)
{
  return crypto_pwhash_memlimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_moderate _cffi_d_crypto_pwhash_memlimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_memlimit_sensitive(void)
{
  return crypto_pwhash_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_memlimit_sensitive _cffi_d_crypto_pwhash_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_interactive(void)
{
  return crypto_pwhash_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_interactive _cffi_d_crypto_pwhash_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_max(void)
{
  return crypto_pwhash_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_max _cffi_d_crypto_pwhash_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_min(void)
{
  return crypto_pwhash_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_min _cffi_d_crypto_pwhash_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_moderate(void)
{
  return crypto_pwhash_opslimit_moderate();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_moderate(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_moderate(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_moderate _cffi_d_crypto_pwhash_opslimit_moderate
#endif

static size_t _cffi_d_crypto_pwhash_opslimit_sensitive(void)
{
  return crypto_pwhash_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_opslimit_sensitive _cffi_d_crypto_pwhash_opslimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_passwd_max(void)
{
  return crypto_pwhash_passwd_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_passwd_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_passwd_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_passwd_max _cffi_d_crypto_pwhash_passwd_max
#endif

static size_t _cffi_d_crypto_pwhash_passwd_min(void)
{
  return crypto_pwhash_passwd_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_passwd_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_passwd_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_passwd_min _cffi_d_crypto_pwhash_passwd_min
#endif

static size_t _cffi_d_crypto_pwhash_saltbytes(void)
{
  return crypto_pwhash_saltbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_saltbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_saltbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_saltbytes _cffi_d_crypto_pwhash_saltbytes
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_bytes_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_bytes_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_bytes_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_bytes_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_min
#endif

static int _cffi_d_crypto_pwhash_scryptsalsa208sha256_ll(uint8_t const * x0, size_t x1, uint8_t const * x2, size_t x3, uint64_t x4, uint32_t x5, uint32_t x6, uint8_t * x7, size_t x8)
{
  return crypto_pwhash_scryptsalsa208sha256_ll(x0, x1, x2, x3, x4, x5, x6, x7, x8);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_ll(PyObject *self, PyObject *args)
{
  uint8_t const * x0;
  size_t x1;
  uint8_t const * x2;
  size_t x3;
  uint64_t x4;
  uint32_t x5;
  uint32_t x6;
  uint8_t * x7;
  size_t x8;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;
  PyObject *arg7;
  PyObject *arg8;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_scryptsalsa208sha256_ll", 9, 9, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6, &arg7, &arg8))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (uint8_t const *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(28), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(28), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (uint8_t const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(28), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, size_t);
  if (x3 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, uint64_t);
  if (x4 == (uint64_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, uint32_t);
  if (x5 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  x6 = _cffi_to_c_int(arg6, uint32_t);
  if (x6 == (uint32_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(35), arg7, (char **)&x7);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x7 = (uint8_t *)alloca((size_t)datasize);
    memset((void *)x7, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x7, _cffi_type(35), arg7) < 0)
      return NULL;
  }

  x8 = _cffi_to_c_int(arg8, size_t);
  if (x8 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_ll(x0, x1, x2, x3, x4, x5, x6, x7, x8); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_ll _cffi_d_crypto_pwhash_scryptsalsa208sha256_ll
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_min
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive _cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_interactive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_interactive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_min
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive(void)
{
  return crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive _cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_max(void)
{
  return crypto_pwhash_scryptsalsa208sha256_passwd_max();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_max(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_passwd_max(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_max _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_max
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_min(void)
{
  return crypto_pwhash_scryptsalsa208sha256_passwd_min();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_min(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_passwd_min(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_min _cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_min
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_saltbytes(void)
{
  return crypto_pwhash_scryptsalsa208sha256_saltbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_saltbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_saltbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_saltbytes _cffi_d_crypto_pwhash_scryptsalsa208sha256_saltbytes
#endif

static int _cffi_d_crypto_pwhash_scryptsalsa208sha256_str(char * x0, char const * x1, unsigned long long x2, unsigned long long x3, size_t x4)
{
  return crypto_pwhash_scryptsalsa208sha256_str(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_str(PyObject *self, PyObject *args)
{
  char * x0;
  char const * x1;
  unsigned long long x2;
  unsigned long long x3;
  size_t x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_scryptsalsa208sha256_str", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(3), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(4), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_str(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_str _cffi_d_crypto_pwhash_scryptsalsa208sha256_str
#endif

static int _cffi_d_crypto_pwhash_scryptsalsa208sha256_str_verify(char const * x0, char const * x1, unsigned long long x2)
{
  return crypto_pwhash_scryptsalsa208sha256_str_verify(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_str_verify(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_scryptsalsa208sha256_str_verify", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (char const *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(4), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(4), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_str_verify(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_str_verify _cffi_d_crypto_pwhash_scryptsalsa208sha256_str_verify
#endif

static size_t _cffi_d_crypto_pwhash_scryptsalsa208sha256_strbytes(void)
{
  return crypto_pwhash_scryptsalsa208sha256_strbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_strbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_strbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_strbytes _cffi_d_crypto_pwhash_scryptsalsa208sha256_strbytes
#endif

static char const * _cffi_d_crypto_pwhash_scryptsalsa208sha256_strprefix(void)
{
  return crypto_pwhash_scryptsalsa208sha256_strprefix();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_scryptsalsa208sha256_strprefix(PyObject *self, PyObject *noarg)
{
  char const * result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_scryptsalsa208sha256_strprefix(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_pointer((char *)result, _cffi_type(4));
}
#else
#  define _cffi_f_crypto_pwhash_scryptsalsa208sha256_strprefix _cffi_d_crypto_pwhash_scryptsalsa208sha256_strprefix
#endif

static int _cffi_d_crypto_pwhash_str_alg(char * x0, char const * x1, unsigned long long x2, unsigned long long x3, size_t x4, int x5)
{
  return crypto_pwhash_str_alg(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_str_alg(PyObject *self, PyObject *args)
{
  char * x0;
  char const * x1;
  unsigned long long x2;
  unsigned long long x3;
  size_t x4;
  int x5;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_str_alg", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(3), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(4), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x4 = _cffi_to_c_int(arg4, size_t);
  if (x4 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  x5 = _cffi_to_c_int(arg5, int);
  if (x5 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_str_alg(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_str_alg _cffi_d_crypto_pwhash_str_alg
#endif

static int _cffi_d_crypto_pwhash_str_needs_rehash(char const * x0, unsigned long long x1, size_t x2)
{
  return crypto_pwhash_str_needs_rehash(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_str_needs_rehash(PyObject *self, PyObject *args)
{
  char const * x0;
  unsigned long long x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_str_needs_rehash", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (char const *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(4), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_str_needs_rehash(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_str_needs_rehash _cffi_d_crypto_pwhash_str_needs_rehash
#endif

static int _cffi_d_crypto_pwhash_str_verify(char const * x0, char const * x1, unsigned long long x2)
{
  return crypto_pwhash_str_verify(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_str_verify(PyObject *self, PyObject *args)
{
  char const * x0;
  char const * x1;
  unsigned long long x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_pwhash_str_verify", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (char const *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(4), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(4), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(4), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_str_verify(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_pwhash_str_verify _cffi_d_crypto_pwhash_str_verify
#endif

static size_t _cffi_d_crypto_pwhash_strbytes(void)
{
  return crypto_pwhash_strbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_pwhash_strbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_pwhash_strbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_pwhash_strbytes _cffi_d_crypto_pwhash_strbytes
#endif

static int _cffi_d_crypto_scalarmult(unsigned char * x0, unsigned char const * x1, unsigned char const * x2)
{
  return crypto_scalarmult(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_scalarmult _cffi_d_crypto_scalarmult
#endif

static int _cffi_d_crypto_scalarmult_base(unsigned char * x0, unsigned char const * x1)
{
  return crypto_scalarmult_base(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_base(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_scalarmult_base", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_base(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_scalarmult_base _cffi_d_crypto_scalarmult_base
#endif

static size_t _cffi_d_crypto_scalarmult_bytes(void)
{
  return crypto_scalarmult_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_scalarmult_bytes _cffi_d_crypto_scalarmult_bytes
#endif

static size_t _cffi_d_crypto_scalarmult_scalarbytes(void)
{
  return crypto_scalarmult_scalarbytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_scalarmult_scalarbytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_scalarmult_scalarbytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_scalarmult_scalarbytes _cffi_d_crypto_scalarmult_scalarbytes
#endif

static int _cffi_d_crypto_secretbox(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_secretbox(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_secretbox", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_secretbox _cffi_d_crypto_secretbox
#endif

static size_t _cffi_d_crypto_secretbox_boxzerobytes(void)
{
  return crypto_secretbox_boxzerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_boxzerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_boxzerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_secretbox_boxzerobytes _cffi_d_crypto_secretbox_boxzerobytes
#endif

static size_t _cffi_d_crypto_secretbox_keybytes(void)
{
  return crypto_secretbox_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_secretbox_keybytes _cffi_d_crypto_secretbox_keybytes
#endif

static size_t _cffi_d_crypto_secretbox_noncebytes(void)
{
  return crypto_secretbox_noncebytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_noncebytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_noncebytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_secretbox_noncebytes _cffi_d_crypto_secretbox_noncebytes
#endif

static int _cffi_d_crypto_secretbox_open(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3, unsigned char const * x4)
{
  return crypto_secretbox_open(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_secretbox_open", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_open(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_secretbox_open _cffi_d_crypto_secretbox_open
#endif

static size_t _cffi_d_crypto_secretbox_zerobytes(void)
{
  return crypto_secretbox_zerobytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_secretbox_zerobytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_secretbox_zerobytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_secretbox_zerobytes _cffi_d_crypto_secretbox_zerobytes
#endif

static int _cffi_d_crypto_shorthash_siphash24(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3)
{
  return crypto_shorthash_siphash24(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphash24(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "crypto_shorthash_siphash24", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphash24(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_shorthash_siphash24 _cffi_d_crypto_shorthash_siphash24
#endif

static size_t _cffi_d_crypto_shorthash_siphash24_bytes(void)
{
  return crypto_shorthash_siphash24_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphash24_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphash24_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_shorthash_siphash24_bytes _cffi_d_crypto_shorthash_siphash24_bytes
#endif

static size_t _cffi_d_crypto_shorthash_siphash24_keybytes(void)
{
  return crypto_shorthash_siphash24_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphash24_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphash24_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_shorthash_siphash24_keybytes _cffi_d_crypto_shorthash_siphash24_keybytes
#endif

static int _cffi_d_crypto_shorthash_siphashx24(unsigned char * x0, unsigned char const * x1, unsigned long long x2, unsigned char const * x3)
{
  return crypto_shorthash_siphashx24(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphashx24(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  unsigned long long x2;
  unsigned char const * x3;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "crypto_shorthash_siphashx24", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, unsigned long long);
  if (x2 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg3, (char **)&x3);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x3 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x3, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x3, _cffi_type(41), arg3) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphashx24(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_shorthash_siphashx24 _cffi_d_crypto_shorthash_siphashx24
#endif

static size_t _cffi_d_crypto_shorthash_siphashx24_bytes(void)
{
  return crypto_shorthash_siphashx24_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphashx24_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphashx24_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_shorthash_siphashx24_bytes _cffi_d_crypto_shorthash_siphashx24_bytes
#endif

static size_t _cffi_d_crypto_shorthash_siphashx24_keybytes(void)
{
  return crypto_shorthash_siphashx24_keybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_shorthash_siphashx24_keybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_shorthash_siphashx24_keybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_shorthash_siphashx24_keybytes _cffi_d_crypto_shorthash_siphashx24_keybytes
#endif

static int _cffi_d_crypto_sign(unsigned char * x0, unsigned long long * x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4)
{
  return crypto_sign(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_sign", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned long long *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(94), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_sign _cffi_d_crypto_sign
#endif

static size_t _cffi_d_crypto_sign_bytes(void)
{
  return crypto_sign_bytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_bytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_bytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_sign_bytes _cffi_d_crypto_sign_bytes
#endif

static int _cffi_d_crypto_sign_ed25519_pk_to_curve25519(unsigned char * x0, unsigned char const * x1)
{
  return crypto_sign_ed25519_pk_to_curve25519(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519_pk_to_curve25519(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_sign_ed25519_pk_to_curve25519", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519_pk_to_curve25519(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_sign_ed25519_pk_to_curve25519 _cffi_d_crypto_sign_ed25519_pk_to_curve25519
#endif

static int _cffi_d_crypto_sign_ed25519_sk_to_curve25519(unsigned char * x0, unsigned char const * x1)
{
  return crypto_sign_ed25519_sk_to_curve25519(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_ed25519_sk_to_curve25519(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_sign_ed25519_sk_to_curve25519", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(41), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_ed25519_sk_to_curve25519(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_sign_ed25519_sk_to_curve25519 _cffi_d_crypto_sign_ed25519_sk_to_curve25519
#endif

static int _cffi_d_crypto_sign_keypair(unsigned char * x0, unsigned char * x1)
{
  return crypto_sign_keypair(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "crypto_sign_keypair", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(39), arg1) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_keypair(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_sign_keypair _cffi_d_crypto_sign_keypair
#endif

static int _cffi_d_crypto_sign_open(unsigned char * x0, unsigned long long * x1, unsigned char const * x2, unsigned long long x3, unsigned char const * x4)
{
  return crypto_sign_open(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_open(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long * x1;
  unsigned char const * x2;
  unsigned long long x3;
  unsigned char const * x4;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "crypto_sign_open", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(94), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned long long *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(94), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, unsigned long long);
  if (x3 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg4, (char **)&x4);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x4 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x4, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x4, _cffi_type(41), arg4) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_open(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_sign_open _cffi_d_crypto_sign_open
#endif

static size_t _cffi_d_crypto_sign_publickeybytes(void)
{
  return crypto_sign_publickeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_publickeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_publickeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_sign_publickeybytes _cffi_d_crypto_sign_publickeybytes
#endif

static size_t _cffi_d_crypto_sign_secretkeybytes(void)
{
  return crypto_sign_secretkeybytes();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_secretkeybytes(PyObject *self, PyObject *noarg)
{
  size_t result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_secretkeybytes(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, size_t);
}
#else
#  define _cffi_f_crypto_sign_secretkeybytes _cffi_d_crypto_sign_secretkeybytes
#endif

static int _cffi_d_crypto_sign_seed_keypair(unsigned char * x0, unsigned char * x1, unsigned char const * x2)
{
  return crypto_sign_seed_keypair(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_crypto_sign_seed_keypair(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned char * x1;
  unsigned char const * x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "crypto_sign_seed_keypair", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(39), arg1) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(41), arg2, (char **)&x2);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x2 = (unsigned char const *)alloca((size_t)datasize);
    memset((void *)x2, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x2, _cffi_type(41), arg2) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = crypto_sign_seed_keypair(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_crypto_sign_seed_keypair _cffi_d_crypto_sign_seed_keypair
#endif

static void _cffi_d_randombytes(unsigned char * x0, unsigned long long x1)
{
  randombytes(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_randombytes(PyObject *self, PyObject *args)
{
  unsigned char * x0;
  unsigned long long x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "randombytes", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (unsigned char *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(39), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned long long);
  if (x1 == (unsigned long long)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { randombytes(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_randombytes _cffi_d_randombytes
#endif

static int _cffi_d_sodium_init(void)
{
  return sodium_init();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_init(PyObject *self, PyObject *noarg)
{
  int result;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_init(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_sodium_init _cffi_d_sodium_init
#endif

static int _cffi_d_sodium_memcmp(void const * x0, void const * x1, size_t x2)
{
  return sodium_memcmp(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_memcmp(PyObject *self, PyObject *args)
{
  void const * x0;
  void const * x1;
  size_t x2;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "sodium_memcmp", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (void const *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(132), arg0) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(132), arg1, (char **)&x1);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x1 = (void const *)alloca((size_t)datasize);
    memset((void *)x1, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x1, _cffi_type(132), arg1) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_memcmp(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_sodium_memcmp _cffi_d_sodium_memcmp
#endif

static void _cffi_d_sodium_memzero(void * x0, size_t x1)
{
  sodium_memzero(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_memzero(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sodium_memzero", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (void *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { sodium_memzero(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_sodium_memzero _cffi_d_sodium_memzero
#endif

static int _cffi_d_sodium_mlock(void * x0, size_t x1)
{
  return sodium_mlock(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_mlock(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sodium_mlock", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (void *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_mlock(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_sodium_mlock _cffi_d_sodium_mlock
#endif

static int _cffi_d_sodium_munlock(void * x0, size_t x1)
{
  return sodium_munlock(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_sodium_munlock(PyObject *self, PyObject *args)
{
  void * x0;
  size_t x1;
  Py_ssize_t datasize;
  int result;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "sodium_munlock", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(110), arg0, (char **)&x0);
  if (datasize != 0) {
    if (datasize < 0)
      return NULL;
    x0 = (void *)alloca((size_t)datasize);
    memset((void *)x0, 0, (size_t)datasize);
    if (_cffi_convert_array_from_object((char *)x0, _cffi_type(110), arg0) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, size_t);
  if (x1 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = sodium_munlock(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  return _cffi_from_c_int(result, int);
}
#else
#  define _cffi_f_sodium_munlock _cffi_d_sodium_munlock
#endif

static const struct _cffi_global_s _cffi_globals[] = {
  { "crypto_box", (void *)_cffi_f_crypto_box, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 84), (void *)_cffi_d_crypto_box },
  { "crypto_box_afternm", (void *)_cffi_f_crypto_box_afternm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_box_afternm },
  { "crypto_box_beforenm", (void *)_cffi_f_crypto_box_beforenm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_crypto_box_beforenm },
  { "crypto_box_beforenmbytes", (void *)_cffi_f_crypto_box_beforenmbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_beforenmbytes },
  { "crypto_box_boxzerobytes", (void *)_cffi_f_crypto_box_boxzerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_boxzerobytes },
  { "crypto_box_keypair", (void *)_cffi_f_crypto_box_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 48), (void *)_cffi_d_crypto_box_keypair },
  { "crypto_box_noncebytes", (void *)_cffi_f_crypto_box_noncebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_noncebytes },
  { "crypto_box_open", (void *)_cffi_f_crypto_box_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 84), (void *)_cffi_d_crypto_box_open },
  { "crypto_box_open_afternm", (void *)_cffi_f_crypto_box_open_afternm, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_box_open_afternm },
  { "crypto_box_publickeybytes", (void *)_cffi_f_crypto_box_publickeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_publickeybytes },
  { "crypto_box_seal", (void *)_cffi_f_crypto_box_seal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 71), (void *)_cffi_d_crypto_box_seal },
  { "crypto_box_seal_open", (void *)_cffi_f_crypto_box_seal_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_box_seal_open },
  { "crypto_box_sealbytes", (void *)_cffi_f_crypto_box_sealbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_sealbytes },
  { "crypto_box_secretkeybytes", (void *)_cffi_f_crypto_box_secretkeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_secretkeybytes },
  { "crypto_box_seed_keypair", (void *)_cffi_f_crypto_box_seed_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 52), (void *)_cffi_d_crypto_box_seed_keypair },
  { "crypto_box_seedbytes", (void *)_cffi_f_crypto_box_seedbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_seedbytes },
  { "crypto_box_zerobytes", (void *)_cffi_f_crypto_box_zerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_box_zerobytes },
  { "crypto_generichash_blake2b_bytes", (void *)_cffi_f_crypto_generichash_blake2b_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_bytes },
  { "crypto_generichash_blake2b_bytes_max", (void *)_cffi_f_crypto_generichash_blake2b_bytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_bytes_max },
  { "crypto_generichash_blake2b_bytes_min", (void *)_cffi_f_crypto_generichash_blake2b_bytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_bytes_min },
  { "crypto_generichash_blake2b_final", (void *)_cffi_f_crypto_generichash_blake2b_final, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 113), (void *)_cffi_d_crypto_generichash_blake2b_final },
  { "crypto_generichash_blake2b_init_salt_personal", (void *)_cffi_f_crypto_generichash_blake2b_init_salt_personal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 118), (void *)_cffi_d_crypto_generichash_blake2b_init_salt_personal },
  { "crypto_generichash_blake2b_keybytes", (void *)_cffi_f_crypto_generichash_blake2b_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_keybytes },
  { "crypto_generichash_blake2b_keybytes_max", (void *)_cffi_f_crypto_generichash_blake2b_keybytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_keybytes_max },
  { "crypto_generichash_blake2b_keybytes_min", (void *)_cffi_f_crypto_generichash_blake2b_keybytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_keybytes_min },
  { "crypto_generichash_blake2b_personalbytes", (void *)_cffi_f_crypto_generichash_blake2b_personalbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_personalbytes },
  { "crypto_generichash_blake2b_salt_personal", (void *)_cffi_f_crypto_generichash_blake2b_salt_personal, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 38), (void *)_cffi_d_crypto_generichash_blake2b_salt_personal },
  { "crypto_generichash_blake2b_saltbytes", (void *)_cffi_f_crypto_generichash_blake2b_saltbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_blake2b_saltbytes },
  { "crypto_generichash_blake2b_update", (void *)_cffi_f_crypto_generichash_blake2b_update, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 126), (void *)_cffi_d_crypto_generichash_blake2b_update },
  { "crypto_generichash_statebytes", (void *)_cffi_f_crypto_generichash_statebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_generichash_statebytes },
  { "crypto_hash", (void *)_cffi_f_crypto_hash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 66), (void *)_cffi_d_crypto_hash },
  { "crypto_hash_sha256", (void *)_cffi_f_crypto_hash_sha256, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 66), (void *)_cffi_d_crypto_hash_sha256 },
  { "crypto_hash_sha256_bytes", (void *)_cffi_f_crypto_hash_sha256_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_hash_sha256_bytes },
  { "crypto_hash_sha512", (void *)_cffi_f_crypto_hash_sha512, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 66), (void *)_cffi_d_crypto_hash_sha512 },
  { "crypto_hash_sha512_bytes", (void *)_cffi_f_crypto_hash_sha512_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_hash_sha512_bytes },
  { "crypto_pwhash", (void *)_cffi_f_crypto_pwhash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 99), (void *)_cffi_d_crypto_pwhash },
  { "crypto_pwhash_alg_argon2i13", (void *)_cffi_f_crypto_pwhash_alg_argon2i13, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 136), (void *)_cffi_d_crypto_pwhash_alg_argon2i13 },
  { "crypto_pwhash_alg_argon2id13", (void *)_cffi_f_crypto_pwhash_alg_argon2id13, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 136), (void *)_cffi_d_crypto_pwhash_alg_argon2id13 },
  { "crypto_pwhash_alg_default", (void *)_cffi_f_crypto_pwhash_alg_default, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 136), (void *)_cffi_d_crypto_pwhash_alg_default },
  { "crypto_pwhash_argon2i_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_interactive },
  { "crypto_pwhash_argon2i_memlimit_max", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_max },
  { "crypto_pwhash_argon2i_memlimit_min", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_min },
  { "crypto_pwhash_argon2i_memlimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_moderate },
  { "crypto_pwhash_argon2i_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2i_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_memlimit_sensitive },
  { "crypto_pwhash_argon2i_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_interactive },
  { "crypto_pwhash_argon2i_opslimit_max", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_max },
  { "crypto_pwhash_argon2i_opslimit_min", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_min },
  { "crypto_pwhash_argon2i_opslimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_moderate },
  { "crypto_pwhash_argon2i_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2i_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2i_opslimit_sensitive },
  { "crypto_pwhash_argon2i_strprefix", (void *)_cffi_f_crypto_pwhash_argon2i_strprefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_crypto_pwhash_argon2i_strprefix },
  { "crypto_pwhash_argon2id_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_interactive },
  { "crypto_pwhash_argon2id_memlimit_max", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_max },
  { "crypto_pwhash_argon2id_memlimit_min", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_min },
  { "crypto_pwhash_argon2id_memlimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_moderate },
  { "crypto_pwhash_argon2id_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2id_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_memlimit_sensitive },
  { "crypto_pwhash_argon2id_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_interactive },
  { "crypto_pwhash_argon2id_opslimit_max", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_max },
  { "crypto_pwhash_argon2id_opslimit_min", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_min },
  { "crypto_pwhash_argon2id_opslimit_moderate", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_moderate },
  { "crypto_pwhash_argon2id_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_argon2id_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_argon2id_opslimit_sensitive },
  { "crypto_pwhash_argon2id_strprefix", (void *)_cffi_f_crypto_pwhash_argon2id_strprefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_crypto_pwhash_argon2id_strprefix },
  { "crypto_pwhash_bytes_max", (void *)_cffi_f_crypto_pwhash_bytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_bytes_max },
  { "crypto_pwhash_bytes_min", (void *)_cffi_f_crypto_pwhash_bytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_bytes_min },
  { "crypto_pwhash_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_memlimit_interactive },
  { "crypto_pwhash_memlimit_max", (void *)_cffi_f_crypto_pwhash_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_memlimit_max },
  { "crypto_pwhash_memlimit_min", (void *)_cffi_f_crypto_pwhash_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_memlimit_min },
  { "crypto_pwhash_memlimit_moderate", (void *)_cffi_f_crypto_pwhash_memlimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_memlimit_moderate },
  { "crypto_pwhash_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_memlimit_sensitive },
  { "crypto_pwhash_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_opslimit_interactive },
  { "crypto_pwhash_opslimit_max", (void *)_cffi_f_crypto_pwhash_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_opslimit_max },
  { "crypto_pwhash_opslimit_min", (void *)_cffi_f_crypto_pwhash_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_opslimit_min },
  { "crypto_pwhash_opslimit_moderate", (void *)_cffi_f_crypto_pwhash_opslimit_moderate, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_opslimit_moderate },
  { "crypto_pwhash_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_opslimit_sensitive },
  { "crypto_pwhash_passwd_max", (void *)_cffi_f_crypto_pwhash_passwd_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_passwd_max },
  { "crypto_pwhash_passwd_min", (void *)_cffi_f_crypto_pwhash_passwd_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_passwd_min },
  { "crypto_pwhash_saltbytes", (void *)_cffi_f_crypto_pwhash_saltbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_saltbytes },
  { "crypto_pwhash_scryptsalsa208sha256_bytes_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_max },
  { "crypto_pwhash_scryptsalsa208sha256_bytes_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_bytes_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_bytes_min },
  { "crypto_pwhash_scryptsalsa208sha256_ll", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_ll, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 27), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_ll },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_interactive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_max },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_min },
  { "crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_interactive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_max },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_min },
  { "crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive },
  { "crypto_pwhash_scryptsalsa208sha256_passwd_max", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_max, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_max },
  { "crypto_pwhash_scryptsalsa208sha256_passwd_min", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_passwd_min, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_passwd_min },
  { "crypto_pwhash_scryptsalsa208sha256_saltbytes", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_saltbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_saltbytes },
  { "crypto_pwhash_scryptsalsa208sha256_str", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_str, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 2), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_str },
  { "crypto_pwhash_scryptsalsa208sha256_str_verify", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_str_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 17), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_str_verify },
  { "crypto_pwhash_scryptsalsa208sha256_strbytes", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_strbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_strbytes },
  { "crypto_pwhash_scryptsalsa208sha256_strprefix", (void *)_cffi_f_crypto_pwhash_scryptsalsa208sha256_strprefix, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_crypto_pwhash_scryptsalsa208sha256_strprefix },
  { "crypto_pwhash_str_alg", (void *)_cffi_f_crypto_pwhash_str_alg, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 9), (void *)_cffi_d_crypto_pwhash_str_alg },
  { "crypto_pwhash_str_needs_rehash", (void *)_cffi_f_crypto_pwhash_str_needs_rehash, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 22), (void *)_cffi_d_crypto_pwhash_str_needs_rehash },
  { "crypto_pwhash_str_verify", (void *)_cffi_f_crypto_pwhash_str_verify, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 17), (void *)_cffi_d_crypto_pwhash_str_verify },
  { "crypto_pwhash_strbytes", (void *)_cffi_f_crypto_pwhash_strbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_pwhash_strbytes },
  { "crypto_scalarmult", (void *)_cffi_f_crypto_scalarmult, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_crypto_scalarmult },
  { "crypto_scalarmult_base", (void *)_cffi_f_crypto_scalarmult_base, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 57), (void *)_cffi_d_crypto_scalarmult_base },
  { "crypto_scalarmult_bytes", (void *)_cffi_f_crypto_scalarmult_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_scalarmult_bytes },
  { "crypto_scalarmult_scalarbytes", (void *)_cffi_f_crypto_scalarmult_scalarbytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_scalarmult_scalarbytes },
  { "crypto_secretbox", (void *)_cffi_f_crypto_secretbox, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_secretbox },
  { "crypto_secretbox_boxzerobytes", (void *)_cffi_f_crypto_secretbox_boxzerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_secretbox_boxzerobytes },
  { "crypto_secretbox_keybytes", (void *)_cffi_f_crypto_secretbox_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_secretbox_keybytes },
  { "crypto_secretbox_noncebytes", (void *)_cffi_f_crypto_secretbox_noncebytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_secretbox_noncebytes },
  { "crypto_secretbox_open", (void *)_cffi_f_crypto_secretbox_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 77), (void *)_cffi_d_crypto_secretbox_open },
  { "crypto_secretbox_zerobytes", (void *)_cffi_f_crypto_secretbox_zerobytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_secretbox_zerobytes },
  { "crypto_shorthash_siphash24", (void *)_cffi_f_crypto_shorthash_siphash24, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 71), (void *)_cffi_d_crypto_shorthash_siphash24 },
  { "crypto_shorthash_siphash24_bytes", (void *)_cffi_f_crypto_shorthash_siphash24_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_shorthash_siphash24_bytes },
  { "crypto_shorthash_siphash24_keybytes", (void *)_cffi_f_crypto_shorthash_siphash24_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_shorthash_siphash24_keybytes },
  { "crypto_shorthash_siphashx24", (void *)_cffi_f_crypto_shorthash_siphashx24, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 71), (void *)_cffi_d_crypto_shorthash_siphashx24 },
  { "crypto_shorthash_siphashx24_bytes", (void *)_cffi_f_crypto_shorthash_siphashx24_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_shorthash_siphashx24_bytes },
  { "crypto_shorthash_siphashx24_keybytes", (void *)_cffi_f_crypto_shorthash_siphashx24_keybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_shorthash_siphashx24_keybytes },
  { "crypto_sign", (void *)_cffi_f_crypto_sign, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 92), (void *)_cffi_d_crypto_sign },
  { "crypto_sign_bytes", (void *)_cffi_f_crypto_sign_bytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_sign_bytes },
  { "crypto_sign_ed25519_pk_to_curve25519", (void *)_cffi_f_crypto_sign_ed25519_pk_to_curve25519, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 57), (void *)_cffi_d_crypto_sign_ed25519_pk_to_curve25519 },
  { "crypto_sign_ed25519_sk_to_curve25519", (void *)_cffi_f_crypto_sign_ed25519_sk_to_curve25519, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 57), (void *)_cffi_d_crypto_sign_ed25519_sk_to_curve25519 },
  { "crypto_sign_keypair", (void *)_cffi_f_crypto_sign_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 48), (void *)_cffi_d_crypto_sign_keypair },
  { "crypto_sign_open", (void *)_cffi_f_crypto_sign_open, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 92), (void *)_cffi_d_crypto_sign_open },
  { "crypto_sign_publickeybytes", (void *)_cffi_f_crypto_sign_publickeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_sign_publickeybytes },
  { "crypto_sign_secretkeybytes", (void *)_cffi_f_crypto_sign_secretkeybytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 138), (void *)_cffi_d_crypto_sign_secretkeybytes },
  { "crypto_sign_seed_keypair", (void *)_cffi_f_crypto_sign_seed_keypair, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 52), (void *)_cffi_d_crypto_sign_seed_keypair },
  { "randombytes", (void *)_cffi_f_randombytes, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 140), (void *)_cffi_d_randombytes },
  { "sodium_init", (void *)_cffi_f_sodium_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 136), (void *)_cffi_d_sodium_init },
  { "sodium_memcmp", (void *)_cffi_f_sodium_memcmp, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 131), (void *)_cffi_d_sodium_memcmp },
  { "sodium_memzero", (void *)_cffi_f_sodium_memzero, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_sodium_memzero },
  { "sodium_mlock", (void *)_cffi_f_sodium_mlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_sodium_mlock },
  { "sodium_munlock", (void *)_cffi_f_sodium_munlock, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_sodium_munlock },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "crypto_generichash_blake2b_state", 151 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  NULL,  /* no fields */
  NULL,  /* no struct_unions */
  NULL,  /* no enums */
  _cffi_typenames,
  129,  /* num_globals */
  0,  /* num_struct_unions */
  0,  /* num_enums */
  1,  /* num_typenames */
  NULL,  /* no includes */
  152,  /* num_types */
  0,  /* flags */
};

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__sodium(const void *p[])
{
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__sodium(void) { return NULL; }
#  else
     init_sodium(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__sodium(void)
{
  return _cffi_init("_sodium", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_sodium(void)
{
  _cffi_init("_sodium", 0x2601, &_cffi_type_context);
}
#endif
