// This file is auto-generated. Do not edit!

#include "precomp.hpp"
#include "cvconfig.h"
#include "opencl_kernels_bioinspired.hpp"

#ifdef HAVE_OPENCL

namespace cv
{
namespace ocl
{
namespace bioinspired
{

const struct ProgramEntry retina_kernel={"retina_kernel",
"#define WIDTH_MULTIPLE (32 >> 2)\n"
"kernel void horizontalCausalFilter_addInput(\n"
"global const float * input,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int in_offset,\n"
"const int out_offset,\n"
"const float _tau,\n"
"const float _a\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= rows)\n"
"{\n"
"return;\n"
"}\n"
"global const float * iptr =\n"
"input  + mad24(gid, elements_per_row, in_offset / 4);\n"
"global float * optr =\n"
"output + mad24(gid, elements_per_row, out_offset / 4);\n"
"float res;\n"
"float4 in_v4, out_v4, res_v4 = (float4)(0);\n"
"for(int i = 0; i < cols / 4; ++i, iptr += 4, optr += 4)\n"
"{\n"
"in_v4  = vload4(0, iptr);\n"
"out_v4 = vload4(0, optr);\n"
"res_v4.x = in_v4.x + _tau * out_v4.x + _a * res_v4.w;\n"
"res_v4.y = in_v4.y + _tau * out_v4.y + _a * res_v4.x;\n"
"res_v4.z = in_v4.z + _tau * out_v4.z + _a * res_v4.y;\n"
"res_v4.w = in_v4.w + _tau * out_v4.w + _a * res_v4.z;\n"
"vstore4(res_v4, 0, optr);\n"
"}\n"
"res = res_v4.w;\n"
"for(int i = 0; i < cols % 4;  ++i, ++iptr, ++optr)\n"
"{\n"
"res = *iptr + _tau * *optr + _a * res;\n"
"*optr = res;\n"
"}\n"
"}\n"
"kernel void horizontalAnticausalFilter(\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int out_offset,\n"
"const float _a\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= rows)\n"
"{\n"
"return;\n"
"}\n"
"global float * optr = output +\n"
"mad24(gid + 1, elements_per_row, - 1 + out_offset / 4);\n"
"float4 result_v4 = (float4)(0), out_v4;\n"
"float result = 0;\n"
"for(int i = 0; i < WIDTH_MULTIPLE; ++ i, -- optr)\n"
"{\n"
"if(i >= elements_per_row - cols)\n"
"{\n"
"result = *optr + _a * result;\n"
"}\n"
"*optr = result;\n"
"}\n"
"result_v4.x = result;\n"
"optr -= 3;\n"
"for(int i = WIDTH_MULTIPLE / 4; i < elements_per_row / 4; ++i, optr -= 4)\n"
"{\n"
"out_v4 = vload4(0, optr);\n"
"result_v4.w = out_v4.w + _a * result_v4.x;\n"
"result_v4.z = out_v4.z + _a * result_v4.w;\n"
"result_v4.y = out_v4.y + _a * result_v4.z;\n"
"result_v4.x = out_v4.x + _a * result_v4.y;\n"
"vstore4(result_v4, 0, optr);\n"
"}\n"
"}\n"
"kernel void verticalCausalFilter(\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int out_offset,\n"
"const float _a\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= cols)\n"
"{\n"
"return;\n"
"}\n"
"global float * optr = output + gid + out_offset / 4;\n"
"float result = 0;\n"
"for(int i = 0; i < rows; ++i, optr += elements_per_row)\n"
"{\n"
"result = *optr + _a * result;\n"
"*optr = result;\n"
"}\n"
"}\n"
"kernel void verticalAnticausalFilter_multGain(\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int out_offset,\n"
"const float _a,\n"
"const float _gain\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= cols)\n"
"{\n"
"return;\n"
"}\n"
"global float * optr = output + (rows - 1) * elements_per_row + gid + out_offset / 4;\n"
"float result = 0;\n"
"for(int i = 0; i < rows; ++i, optr -= elements_per_row)\n"
"{\n"
"result = *optr + _a * result;\n"
"*optr = _gain * result;\n"
"}\n"
"}\n"
"kernel void horizontalAnticausalFilter_Irregular(\n"
"global float * output,\n"
"global float * buffer,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int out_offset,\n"
"const int buffer_offset\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= rows)\n"
"{\n"
"return;\n"
"}\n"
"global float * optr =\n"
"output + mad24(rows - gid, elements_per_row, -1 + out_offset / 4);\n"
"global float * bptr =\n"
"buffer + mad24(rows - gid, elements_per_row, -1 + buffer_offset / 4);\n"
"float4 buf_v4, out_v4, res_v4 = (float4)(0);\n"
"float result = 0;\n"
"for(int i = 0; i < WIDTH_MULTIPLE; ++ i, -- optr, -- bptr)\n"
"{\n"
"if(i >= elements_per_row - cols)\n"
"{\n"
"result = *optr + *bptr * result;\n"
"}\n"
"*optr = result;\n"
"}\n"
"res_v4.x = result;\n"
"optr -= 3;\n"
"bptr -= 3;\n"
"for(int i = WIDTH_MULTIPLE / 4; i < elements_per_row / 4; ++i, optr -= 4, bptr -= 4)\n"
"{\n"
"buf_v4 = vload4(0, bptr);\n"
"out_v4 = vload4(0, optr);\n"
"res_v4.w = out_v4.w + buf_v4.w * res_v4.x;\n"
"res_v4.z = out_v4.z + buf_v4.z * res_v4.w;\n"
"res_v4.y = out_v4.y + buf_v4.y * res_v4.z;\n"
"res_v4.x = out_v4.x + buf_v4.x * res_v4.y;\n"
"vstore4(res_v4, 0, optr);\n"
"}\n"
"}\n"
"kernel void verticalCausalFilter_Irregular(\n"
"global float * output,\n"
"global float * buffer,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int out_offset,\n"
"const int buffer_offset\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= cols)\n"
"{\n"
"return;\n"
"}\n"
"global float * optr = output + gid + out_offset / 4;\n"
"global float * bptr = buffer + gid + buffer_offset / 4;\n"
"float result = 0;\n"
"for(int i = 0; i < rows; ++i, optr += elements_per_row, bptr += elements_per_row)\n"
"{\n"
"result = *optr + *bptr * result;\n"
"*optr = result;\n"
"}\n"
"}\n"
"kernel void adaptiveHorizontalCausalFilter_addInput(\n"
"global const float * input,\n"
"global const float * gradient,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int in_offset,\n"
"const int grad_offset,\n"
"const int out_offset\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= rows)\n"
"{\n"
"return;\n"
"}\n"
"global const float * iptr =\n"
"input + mad24(gid, elements_per_row, in_offset / 4);\n"
"global const float * gptr =\n"
"gradient + mad24(gid, elements_per_row, grad_offset / 4);\n"
"global float * optr =\n"
"output + mad24(gid, elements_per_row, out_offset / 4);\n"
"float4 in_v4, grad_v4, out_v4, res_v4 = (float4)(0);\n"
"for(int i = 0; i < cols / 4; ++i, iptr += 4, gptr += 4, optr += 4)\n"
"{\n"
"in_v4   = vload4(0, iptr);\n"
"grad_v4 = vload4(0, gptr);\n"
"res_v4.x = in_v4.x + grad_v4.x * res_v4.w;\n"
"res_v4.y = in_v4.y + grad_v4.y * res_v4.x;\n"
"res_v4.z = in_v4.z + grad_v4.z * res_v4.y;\n"
"res_v4.w = in_v4.w + grad_v4.w * res_v4.z;\n"
"vstore4(res_v4, 0, optr);\n"
"}\n"
"for(int i = 0; i < cols % 4; ++i, ++iptr, ++gptr, ++optr)\n"
"{\n"
"res_v4.w = *iptr + *gptr * res_v4.w;\n"
"*optr = res_v4.w;\n"
"}\n"
"}\n"
"kernel void adaptiveVerticalAnticausalFilter_multGain(\n"
"global const float * gradient,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const int grad_offset,\n"
"const int out_offset,\n"
"const float gain\n"
")\n"
"{\n"
"int gid = get_global_id(0);\n"
"if(gid >= cols)\n"
"{\n"
"return;\n"
"}\n"
"int start_idx = mad24(rows - 1, elements_per_row, gid);\n"
"global const float * gptr = gradient + start_idx + grad_offset / 4;\n"
"global float * optr = output + start_idx + out_offset / 4;\n"
"float result = 0;\n"
"for(int i = 0; i < rows; ++i, gptr -= elements_per_row, optr -= elements_per_row)\n"
"{\n"
"result = *optr + *gptr * result;\n"
"*optr = gain * result;\n"
"}\n"
"}\n"
"kernel void localLuminanceAdaptation(\n"
"global const float * luma,\n"
"global const float * input,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float _localLuminanceAddon,\n"
"const float _localLuminanceFactor,\n"
"const float _maxInputValue\n"
")\n"
"{\n"
"int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int offset = mad24(gidy, elements_per_row, gidx);\n"
"float X0 = luma[offset] * _localLuminanceFactor + _localLuminanceAddon;\n"
"float input_val = input[offset];\n"
"output[offset] = (_maxInputValue + X0) * input_val / (input_val + X0 + 0.00000000001f);\n"
"}\n"
"kernel void amacrineCellsComputing(\n"
"global const float * opl_on,\n"
"global const float * opl_off,\n"
"global float * prev_in_on,\n"
"global float * prev_in_off,\n"
"global float * out_on,\n"
"global float * out_off,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float coeff\n"
")\n"
"{\n"
"int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int offset = mad24(gidy, elements_per_row, gidx);\n"
"opl_on      += offset;\n"
"opl_off     += offset;\n"
"prev_in_on  += offset;\n"
"prev_in_off += offset;\n"
"out_on      += offset;\n"
"out_off     += offset;\n"
"float magnoXonPixelResult = coeff * (*out_on + *opl_on - *prev_in_on);\n"
"*out_on = fmax(magnoXonPixelResult, 0);\n"
"float magnoXoffPixelResult = coeff * (*out_off + *opl_off - *prev_in_off);\n"
"*out_off = fmax(magnoXoffPixelResult, 0);\n"
"*prev_in_on = *opl_on;\n"
"*prev_in_off = *opl_off;\n"
"}\n"
"kernel void OPL_OnOffWaysComputing(\n"
"global float4 * photo_out,\n"
"global float4 * horiz_out,\n"
"global float4 * bipol_on,\n"
"global float4 * bipol_off,\n"
"global float4 * parvo_on,\n"
"global float4 * parvo_off,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row\n"
")\n"
"{\n"
"int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx * 4 >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int offset = mad24(gidy, elements_per_row >> 2, gidx);\n"
"photo_out += offset;\n"
"horiz_out += offset;\n"
"bipol_on  += offset;\n"
"bipol_off += offset;\n"
"parvo_on  += offset;\n"
"parvo_off += offset;\n"
"float4 diff = *photo_out - *horiz_out;\n"
"float4 isPositive;\n"
"isPositive.x = diff.x > 0.0f;\n"
"isPositive.y = diff.y > 0.0f;\n"
"isPositive.z = diff.z > 0.0f;\n"
"isPositive.w = diff.w > 0.0f;\n"
"float4 res_on  = isPositive * diff;\n"
"float4 res_off = (isPositive - (float4)(1.0f)) * diff;\n"
"*bipol_on = res_on;\n"
"*parvo_on = res_on;\n"
"*bipol_off = res_off;\n"
"*parvo_off = res_off;\n"
"}\n"
"inline int bayerSampleOffset(int step, int rows, int x, int y)\n"
"{\n"
"return mad24(y, step, x) +\n"
"((y % 2) + (x % 2)) * rows * step;\n"
"}\n"
"kernel void runColorMultiplexingBayer(\n"
"global const float * input,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row\n"
")\n"
"{\n"
"int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int offset = mad24(gidy, elements_per_row, gidx);\n"
"output[offset] = input[bayerSampleOffset(elements_per_row, rows, gidx, gidy)];\n"
"}\n"
"kernel void runColorDemultiplexingBayer(\n"
"global const float * input,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row\n"
")\n"
"{\n"
"int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int offset = mad24(gidy, elements_per_row, gidx);\n"
"output[bayerSampleOffset(elements_per_row, rows, gidx, gidy)] = input[offset];\n"
"}\n"
"kernel void demultiplexAssign(\n"
"global const float * input,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row\n"
")\n"
"{\n"
"int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int offset = bayerSampleOffset(elements_per_row, rows, gidx, gidy);\n"
"output[offset] = input[offset];\n"
"}\n"
"kernel void normalizeGrayOutputCentredSigmoide(\n"
"global const float * input,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float meanval,\n"
"const float X0\n"
")\n"
"{\n"
"int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int offset = mad24(gidy, elements_per_row, gidx);\n"
"float input_val = input[offset];\n"
"output[offset] = meanval +\n"
"(meanval + X0) * (input_val - meanval) / (fabs(input_val - meanval) + X0);\n"
"}\n"
"kernel void normalizePhotoDensity(\n"
"global const float * chroma,\n"
"global const float * colorDensity,\n"
"global const float * multiplex,\n"
"global float * luma,\n"
"global float * demultiplex,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float pG\n"
")\n"
"{\n"
"const int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"const int offset = mad24(gidy, elements_per_row, gidx);\n"
"int index = offset;\n"
"float Cr = chroma[index] * colorDensity[index];\n"
"index += elements_per_row * rows;\n"
"float Cg = chroma[index] * colorDensity[index];\n"
"index += elements_per_row * rows;\n"
"float Cb = chroma[index] * colorDensity[index];\n"
"const float luma_res = (Cr + Cg + Cb) * pG;\n"
"luma[offset] = luma_res;\n"
"demultiplex[bayerSampleOffset(elements_per_row, rows, gidx, gidy)] =\n"
"multiplex[offset] - luma_res;\n"
"}\n"
"kernel void computeGradient(\n"
"global const float * luma,\n"
"global float * gradient,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row\n"
")\n"
"{\n"
"int gidx = get_global_id(0) + 2, gidy = get_global_id(1) + 2;\n"
"if(gidx >= cols - 2 || gidy >= rows - 2)\n"
"{\n"
"return;\n"
"}\n"
"int offset = mad24(gidy, elements_per_row, gidx);\n"
"luma += offset;\n"
"const float v_grad = fabs(luma[elements_per_row] - luma[- elements_per_row]);\n"
"const float h_grad = fabs(luma[1] - luma[-1]);\n"
"const float cur_val  = luma[0];\n"
"const float v_grad_p = fabs(cur_val - luma[- 2 * elements_per_row]);\n"
"const float h_grad_p = fabs(cur_val - luma[- 2]);\n"
"const float v_grad_n = fabs(cur_val - luma[2 * elements_per_row]);\n"
"const float h_grad_n = fabs(cur_val - luma[2]);\n"
"const float horiz_grad = 0.5f * h_grad + 0.25f * (h_grad_p + h_grad_n);\n"
"const float verti_grad = 0.5f * v_grad + 0.25f * (v_grad_p + v_grad_n);\n"
"const bool is_vertical_greater = horiz_grad < verti_grad;\n"
"gradient[offset + elements_per_row * rows] = is_vertical_greater ? 0.06f : 0.57f;\n"
"gradient[offset                          ] = is_vertical_greater ? 0.57f : 0.06f;\n"
"}\n"
"kernel void substractResidual(\n"
"global float * input,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float pR,\n"
"const float pG,\n"
"const float pB\n"
")\n"
"{\n"
"const int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"int indices [3] =\n"
"{\n"
"mad24(gidy, elements_per_row, gidx),\n"
"mad24(gidy + rows, elements_per_row, gidx),\n"
"mad24(gidy + 2 * rows, elements_per_row, gidx)\n"
"};\n"
"float vals[3] = {input[indices[0]], input[indices[1]], input[indices[2]]};\n"
"float residu = pR * vals[0] + pG * vals[1] + pB * vals[2];\n"
"input[indices[0]] = vals[0] - residu;\n"
"input[indices[1]] = vals[1] - residu;\n"
"input[indices[2]] = vals[2] - residu;\n"
"}\n"
"kernel void clipRGBOutput_0_maxInputValue(\n"
"global float * input,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float maxVal\n"
")\n"
"{\n"
"const int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"const int offset = mad24(gidy, elements_per_row, gidx);\n"
"float val = input[offset];\n"
"val = clamp(val, 0.0f, maxVal);\n"
"input[offset] = val;\n"
"}\n"
"kernel void normalizeGrayOutputNearZeroCentreredSigmoide(\n"
"global float * input,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float maxVal,\n"
"const float X0cube\n"
")\n"
"{\n"
"const int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"const int offset = mad24(gidy, elements_per_row, gidx);\n"
"float currentCubeLuminance = input[offset];\n"
"currentCubeLuminance = currentCubeLuminance * currentCubeLuminance * currentCubeLuminance;\n"
"output[offset] = currentCubeLuminance * X0cube / (X0cube + currentCubeLuminance);\n"
"}\n"
"kernel void centerReductImageLuminance(\n"
"global float * input,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row,\n"
"const float mean,\n"
"const float std_dev\n"
")\n"
"{\n"
"const int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"const int offset = mad24(gidy, elements_per_row, gidx);\n"
"float val = input[offset];\n"
"input[offset] = (val - mean) / std_dev;\n"
"}\n"
"kernel void inverseValue(\n"
"global float * input,\n"
"const int cols,\n"
"const int rows,\n"
"const int elements_per_row\n"
")\n"
"{\n"
"const int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"const int offset = mad24(gidy, elements_per_row, gidx);\n"
"input[offset] = 1.f / input[offset];\n"
"}\n"
"#define CV_PI 3.1415926535897932384626433832795\n"
"kernel void processRetinaParvoMagnoMapping(\n"
"global float * parvo,\n"
"global float * magno,\n"
"global float * output,\n"
"const int cols,\n"
"const int rows,\n"
"const int halfCols,\n"
"const int halfRows,\n"
"const int elements_per_row,\n"
"const float minDistance\n"
")\n"
"{\n"
"const int gidx = get_global_id(0), gidy = get_global_id(1);\n"
"if(gidx >= cols || gidy >= rows)\n"
"{\n"
"return;\n"
"}\n"
"const int offset = mad24(gidy, elements_per_row, gidx);\n"
"float distanceToCenter =\n"
"sqrt(((float)(gidy - halfRows) * (gidy - halfRows) + (gidx - halfCols) * (gidx - halfCols)));\n"
"float a = distanceToCenter < minDistance ?\n"
"(0.5f + 0.5f * (float)cos(CV_PI * distanceToCenter / minDistance)) : 0;\n"
"float b = 1.f - a;\n"
"output[offset] = parvo[offset] * a + magno[offset] * b;\n"
"}\n"
, "de6e62a5c5220048f33882f62d4b1bd3"};
ProgramSource retina_kernel_oclsrc(retina_kernel.programStr);
}
}}
#endif
