#line 11 "ncx.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 13
/*
 *	Copyright 1996, University Corporation for Atmospheric Research
 *	See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *
 * 	This file contains some routines derived from code
 *	which is copyrighted by Sun Microsystems, Inc.
 *	The "#ifdef vax" versions of
 *		 ncx_put_float_float()
 *		 ncx_get_float_float()
 *		 ncx_put_double_double()
 *		 ncx_get_double_double()
 *		 ncx_putn_float_float()
 *		 ncx_getn_float_float()
 *		 ncx_putn_double_double()
 *		 ncx_getn_double_double()
 * 	are derived from xdr_float() and xdr_double() routines
 *	in the freely available, copyrighted Sun RPCSRC 3.9
 *	distribution, xdr_float.c.
 * 	Our "value added" is that these are always memory to memory,
 *	they handle IEEE subnormals properly, and their "n" versions
 *	operate speedily on arrays.
 */
/* $Id: ncx.m4 2795 2014-10-27 23:12:51Z wkliao $ */

/*
 * An external data representation interface.
 */

#pragma GCC diagnostic ignored "-Wdeprecated"

#include "ncx.h"
#include "nc3dispatch.h"
#include <string.h>
#include <limits.h>

/* alias poorly named limits.h macros */
#define  SHORT_MAX  SHRT_MAX
#define  SHORT_MIN  SHRT_MIN
#define USHORT_MAX USHRT_MAX
#ifndef LLONG_MAX
#   define LLONG_MAX	9223372036854775807LL
#   define LLONG_MIN	(-LLONG_MAX - 1LL)
#   define ULLONG_MAX	18446744073709551615ULL
#endif
#ifndef LONG_LONG_MAX
#define LONG_LONG_MAX LLONG_MAX
#endif
#ifndef LONGLONG_MAX
#define LONGLONG_MAX LONG_LONG_MAX
#endif
#ifndef LONG_LONG_MIN
#define LONG_LONG_MIN LLONG_MIN
#endif
#ifndef LONGLONG_MIN
#define LONGLONG_MIN LONG_LONG_MIN
#endif
#ifndef ULONG_LONG_MAX
#define ULONG_LONG_MAX ULLONG_MAX
#endif
#ifndef ULONGLONG_MAX
#define ULONGLONG_MAX ULONG_LONG_MAX
#endif
#include <float.h>
#ifndef FLT_MAX /* This POSIX macro missing on some systems */
# ifndef NO_IEEE_FLOAT
# define FLT_MAX 3.40282347e+38f
# else
# error "You will need to define FLT_MAX"
# endif
#endif
/* alias poorly named float.h macros */
#define FLOAT_MAX FLT_MAX
#define FLOAT_MIN (-FLT_MAX)
#define DOUBLE_MAX DBL_MAX
#define DOUBLE_MIN (-DBL_MAX)
#define FLOAT_MAX_EXP FLT_MAX_EXP
#define DOUBLE_MAX_EXP DBL_MAX_EXP
#include <assert.h>
#define UCHAR_MIN 0
#define Min(a,b) ((a) < (b) ? (a) : (b))
#define Max(a,b) ((a) > (b) ? (a) : (b))

#ifndef SIZEOF_USHORT
#define SIZEOF_USHORT SIZEOF_UNSIGNED_SHORT_INT
#endif
#ifndef SIZEOF_UINT
#define SIZEOF_UINT SIZEOF_UNSIGNED_INT
#endif
#ifndef SIZEOF_ULONG_LONG
#define SIZEOF_ULONG_LONG SIZEOF_UNSIGNED_LONG_LONG
#endif

/*
 * If the machine's float domain is "smaller" than the external one
 * use the machine domain
 */
#if defined(FLT_MAX_EXP) && FLT_MAX_EXP < 128 /* 128 is X_FLT_MAX_EXP */
#undef X_FLOAT_MAX
# define X_FLOAT_MAX FLT_MAX
#undef X_FLOAT_MIN
# define X_FLOAT_MIN (-X_FLOAT_MAX)
#endif

#if _SX /* NEC SUPER UX */
#define LOOPCNT 256    /* must be no longer than hardware vector length */
#if _INT64
#undef  INT_MAX /* workaround cpp bug */
#define INT_MAX  X_INT_MAX
#undef  INT_MIN /* workaround cpp bug */
#define INT_MIN  X_INT_MIN
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  X_INT_MAX
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN  X_INT_MIN
#elif _LONG64
#undef  LONG_MAX /* workaround cpp bug */
#define LONG_MAX  4294967295L
#undef  LONG_MIN /* workaround cpp bug */
#define LONG_MIN -4294967295L
#endif
#if !_FLOAT0
#error "FLOAT1 and FLOAT2 not supported"
#endif
#endif /* _SX */

static const char nada[X_ALIGN] = {0, 0, 0, 0};

#ifndef WORDS_BIGENDIAN
/* LITTLE_ENDIAN: DEC and intel */
/*
 * Routines to convert to BIGENDIAN.
 * Optimize the swapn?b() and swap?b() routines aggressivly.
 */

#define SWAP2(a) ( (((a) & 0xff) << 8) | \
		(((a) >> 8) & 0xff) )

#define SWAP4(a) ( ((a) << 24) | \
		(((a) <<  8) & 0x00ff0000) | \
		(((a) >>  8) & 0x0000ff00) | \
		(((a) >> 24) & 0x000000ff) )


static void
swapn2b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *
 *	while(nn-- != 0)
 *	{
 *		*op++ = *(++ip);
 *		*op++ = *(ip++ -1);
 *	}
 */
	while(nn > 3)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
		nn -= 4;
	}
	while(nn-- > 0)
	{
		*op++ = *(++ip);
		*op++ = *(ip++ -1);
	}
}

# ifndef vax
void
swap4b(void *dst, const void *src)
{
    unsigned int *op = dst;
    const char *ip = src;
    unsigned int tempIn;
    unsigned int tempOut;

    tempIn = *(unsigned int *)(ip+0);
    tempOut =
    ( tempIn << 24) |
    ((tempIn & 0x0000ff00) << 8) |
    ((tempIn & 0x00ff0000) >> 8) |
    ( tempIn >> 24);

    *(float *)op = *(float *)(&tempOut);
}
# endif /* !vax */

static void
swapn4b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while(nn-- != 0)
 *	{
 *		op[0] = ip[3];
 *		op[1] = ip[2];
 *		op[2] = ip[1];
 *		op[3] = ip[0];
 *		op += 4;
 *		ip += 4;
 *	}
 */
	while(nn > 3)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op[8] = ip[11];
		op[9] = ip[10];
		op[10] = ip[9];
		op[11] = ip[8];
		op[12] = ip[15];
		op[13] = ip[14];
		op[14] = ip[13];
		op[15] = ip[12];
		op += 16;
		ip += 16;
		nn -= 4;
	}
	while(nn-- > 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op += 4;
		ip += 4;
	}
}

# ifndef vax
static void
swap8b(void *dst, const void *src)
{
	char *op = dst;
	const char *ip = src;
#  ifndef FLOAT_WORDS_BIGENDIAN
	op[0] = ip[7];
	op[1] = ip[6];
	op[2] = ip[5];
	op[3] = ip[4];
	op[4] = ip[3];
	op[5] = ip[2];
	op[6] = ip[1];
	op[7] = ip[0];
#  else
	op[0] = ip[3];
	op[1] = ip[2];
	op[2] = ip[1];
	op[3] = ip[0];
	op[4] = ip[7];
	op[5] = ip[6];
	op[6] = ip[5];
	op[7] = ip[4];
#  endif
}
# endif /* !vax */

# ifndef vax
static void
swapn8b(void *dst, const void *src, size_t nn)
{
	char *op = dst;
	const char *ip = src;

/* unroll the following to reduce loop overhead
 *	while(nn-- != 0)
 *	{
 *		op[0] = ip[7];
 *		op[1] = ip[6];
 *		op[2] = ip[5];
 *		op[3] = ip[4];
 *		op[4] = ip[3];
 *		op[5] = ip[2];
 *		op[6] = ip[1];
 *		op[7] = ip[0];
 *		op += 8;
 *		ip += 8;
 *	}
 */
#  ifndef FLOAT_WORDS_BIGENDIAN
	while(nn > 1)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op[8] = ip[15];
		op[9] = ip[14];
		op[10] = ip[13];
		op[11] = ip[12];
		op[12] = ip[11];
		op[13] = ip[10];
		op[14] = ip[9];
		op[15] = ip[8];
		op += 16;
		ip += 16;
		nn -= 2;
	}
	while(nn-- != 0)
	{
		op[0] = ip[7];
		op[1] = ip[6];
		op[2] = ip[5];
		op[3] = ip[4];
		op[4] = ip[3];
		op[5] = ip[2];
		op[6] = ip[1];
		op[7] = ip[0];
		op += 8;
		ip += 8;
	}
#  else
	while(nn-- != 0)
	{
		op[0] = ip[3];
		op[1] = ip[2];
		op[2] = ip[1];
		op[3] = ip[0];
		op[4] = ip[7];
		op[5] = ip[6];
		op[6] = ip[5];
		op[7] = ip[4];
		op += 8;
		ip += 8;
	}
#  endif
}
# endif /* !vax */

#endif /* LITTLE_ENDIAN */

#line 388

#line 396

#line 404

#line 411


#line 419


#line 427


#line 435


/*
 * Primitive numeric conversion functions.
 */

#line 457

#line 483

#line 499

#line 524

/* x_schar */
/* x_uchar */

/* We don't implement any x_schar and x_uchar primitives. */


/* x_short -------------------------------------------------------------------*/

#if SHORT_MAX == X_SHORT_MAX
typedef short ix_short;
#define SIZEOF_IX_SHORT SIZEOF_SHORT
#define IX_SHORT_MAX SHORT_MAX
#elif INT_MAX >= X_SHORT_MAX
typedef int ix_short;
#define SIZEOF_IX_SHORT SIZEOF_INT
#define IX_SHORT_MAX INT_MAX
#elif LONG_MAX >= X_SHORT_MAX
typedef long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG
#define IX_SHORT_MAX LONG_MAX
#elif LLONG_MAX >= X_SHORT_MAX
typedef long long ix_short;
#define SIZEOF_IX_SHORT SIZEOF_LONG_LONG
#define IX_SHORT_MAX LLONG_MAX
#else
#error "ix_short implementation"
#endif

static void
get_ix_short(const void *xp, ix_short *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = *cp++ << 8;
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if(*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= *cp;
}

static void
put_ix_short(void *xp, const ix_short *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (*ip) >> 8;
	*cp = (*ip) & 0xff;
}

static int
#line 576
ncx_get_short_schar(const void *xp, schar *ip)
#line 576
{
#line 576
	ix_short xx;
#line 576
	get_ix_short(xp, &xx);
#line 576
	*ip = (schar) xx;
#line 576
#if IX_SHORT_MAX > SCHAR_MAX
#line 576
	if (xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
#line 576
#endif
#line 576

#line 576
	return NC_NOERR;
#line 576
}
#line 576

static int
#line 577
ncx_get_short_short(const void *xp, short *ip)
#line 577
{
#line 577
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 577
	get_ix_short(xp, (ix_short *)ip);
#line 577
	return NC_NOERR;
#line 577
#else
#line 577
	ix_short xx;
#line 577
	get_ix_short(xp, &xx);
#line 577
	*ip = (short) xx;
#line 577
#if IX_SHORT_MAX > SHORT_MAX
#line 577
	if (xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
#line 577
#endif
#line 577

#line 577
#endif
#line 577
	return NC_NOERR;
#line 577
}
#line 577

static int
#line 578
ncx_get_short_int(const void *xp, int *ip)
#line 578
{
#line 578
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 578
	get_ix_short(xp, (ix_short *)ip);
#line 578
	return NC_NOERR;
#line 578
#else
#line 578
	ix_short xx;
#line 578
	get_ix_short(xp, &xx);
#line 578
	*ip = (int) xx;
#line 578
#if IX_SHORT_MAX > INT_MAX
#line 578
	if (xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
#line 578
#endif
#line 578

#line 578
#endif
#line 578
	return NC_NOERR;
#line 578
}
#line 578

static int
#line 579
ncx_get_short_longlong(const void *xp, longlong *ip)
#line 579
{
#line 579
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 579
	get_ix_short(xp, (ix_short *)ip);
#line 579
	return NC_NOERR;
#line 579
#else
#line 579
	ix_short xx;
#line 579
	get_ix_short(xp, &xx);
#line 579
	*ip = (longlong) xx;
#line 579
#if IX_SHORT_MAX > LONGLONG_MAX
#line 579
	if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
#line 579
#endif
#line 579

#line 579
#endif
#line 579
	return NC_NOERR;
#line 579
}
#line 579

static int
#line 580
ncx_get_short_ushort(const void *xp, ushort *ip)
#line 580
{
#line 580
	ix_short xx;
#line 580
	get_ix_short(xp, &xx);
#line 580
	*ip = (ushort) xx;
#line 580
#if IX_SHORT_MAX > USHORT_MAX
#line 580
	if (xx > USHORT_MAX) return NC_ERANGE;
#line 580
#endif
#line 580
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 580
	return NC_NOERR;
#line 580
}
#line 580

static int
#line 581
ncx_get_short_uchar(const void *xp, uchar *ip)
#line 581
{
#line 581
	ix_short xx;
#line 581
	get_ix_short(xp, &xx);
#line 581
	*ip = (uchar) xx;
#line 581
#if IX_SHORT_MAX > UCHAR_MAX
#line 581
	if (xx > UCHAR_MAX) return NC_ERANGE;
#line 581
#endif
#line 581
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 581
	return NC_NOERR;
#line 581
}
#line 581

static int
#line 582
ncx_get_short_uint(const void *xp, uint *ip)
#line 582
{
#line 582
	ix_short xx;
#line 582
	get_ix_short(xp, &xx);
#line 582
	*ip = (uint) xx;
#line 582
#if IX_SHORT_MAX > UINT_MAX
#line 582
	if (xx > UINT_MAX) return NC_ERANGE;
#line 582
#endif
#line 582
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 582
	return NC_NOERR;
#line 582
}
#line 582

static int
#line 583
ncx_get_short_ulonglong(const void *xp, ulonglong *ip)
#line 583
{
#line 583
	ix_short xx;
#line 583
	get_ix_short(xp, &xx);
#line 583
	*ip = (ulonglong) xx;
#line 583
#if IX_SHORT_MAX > ULONGLONG_MAX
#line 583
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#line 583
#endif
#line 583
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 583
	return NC_NOERR;
#line 583
}
#line 583

static int
#line 584
ncx_get_short_float(const void *xp, float *ip)
#line 584
{
#line 584
	ix_short xx;
#line 584
	get_ix_short(xp, &xx);
#line 584
	*ip = (float) xx;
#line 584

#line 584
	return NC_NOERR;
#line 584
}
#line 584

static int
#line 585
ncx_get_short_double(const void *xp, double *ip)
#line 585
{
#line 585
	ix_short xx;
#line 585
	get_ix_short(xp, &xx);
#line 585
	*ip = (double) xx;
#line 585

#line 585
	return NC_NOERR;
#line 585
}
#line 585


static int
ncx_put_short_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)(signed)*ip;
	return NC_NOERR;
}

static int
ncx_put_short_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 608
ncx_put_short_short(void *xp, const short *ip)
#line 608
{
#line 608
#if SIZEOF_IX_SHORT == SIZEOF_SHORT && IX_SHORT_MAX == SHORT_MAX
#line 608
	put_ix_short(xp, (const ix_short *)ip);
#line 608
	return NC_NOERR;
#line 608
#else
#line 608
	ix_short xx = (ix_short)*ip;
#line 608
	put_ix_short(xp, &xx);
#line 608
#if IX_SHORT_MAX < SHORT_MAX
#line 608
	if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
#line 608
#endif
#line 608

#line 608
#endif
#line 608
	return NC_NOERR;
#line 608
}
#line 608

static int
#line 609
ncx_put_short_int(void *xp, const int *ip)
#line 609
{
#line 609
#if SIZEOF_IX_SHORT == SIZEOF_INT && IX_SHORT_MAX == INT_MAX
#line 609
	put_ix_short(xp, (const ix_short *)ip);
#line 609
	return NC_NOERR;
#line 609
#else
#line 609
	ix_short xx = (ix_short)*ip;
#line 609
	put_ix_short(xp, &xx);
#line 609
#if IX_SHORT_MAX < INT_MAX
#line 609
	if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
#line 609
#endif
#line 609

#line 609
#endif
#line 609
	return NC_NOERR;
#line 609
}
#line 609

static int
#line 610
ncx_put_short_longlong(void *xp, const longlong *ip)
#line 610
{
#line 610
#if SIZEOF_IX_SHORT == SIZEOF_LONGLONG && IX_SHORT_MAX == LONGLONG_MAX
#line 610
	put_ix_short(xp, (const ix_short *)ip);
#line 610
	return NC_NOERR;
#line 610
#else
#line 610
	ix_short xx = (ix_short)*ip;
#line 610
	put_ix_short(xp, &xx);
#line 610
#if IX_SHORT_MAX < LONGLONG_MAX
#line 610
	if (*ip > IX_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
#line 610
#endif
#line 610

#line 610
#endif
#line 610
	return NC_NOERR;
#line 610
}
#line 610

static int
#line 611
ncx_put_short_ushort(void *xp, const ushort *ip)
#line 611
{
#line 611
	ix_short xx = (ix_short)*ip;
#line 611
	put_ix_short(xp, &xx);
#line 611
#if IX_SHORT_MAX < USHORT_MAX
#line 611
	if (*ip > IX_SHORT_MAX) return NC_ERANGE;
#line 611
#endif
#line 611

#line 611
	return NC_NOERR;
#line 611
}
#line 611

static int
#line 612
ncx_put_short_uint(void *xp, const uint *ip)
#line 612
{
#line 612
	ix_short xx = (ix_short)*ip;
#line 612
	put_ix_short(xp, &xx);
#line 612
#if IX_SHORT_MAX < UINT_MAX
#line 612
	if (*ip > IX_SHORT_MAX) return NC_ERANGE;
#line 612
#endif
#line 612

#line 612
	return NC_NOERR;
#line 612
}
#line 612

static int
#line 613
ncx_put_short_ulonglong(void *xp, const ulonglong *ip)
#line 613
{
#line 613
	ix_short xx = (ix_short)*ip;
#line 613
	put_ix_short(xp, &xx);
#line 613
#if IX_SHORT_MAX < ULONGLONG_MAX
#line 613
	if (*ip > IX_SHORT_MAX) return NC_ERANGE;
#line 613
#endif
#line 613

#line 613
	return NC_NOERR;
#line 613
}
#line 613

static int
#line 614
ncx_put_short_float(void *xp, const float *ip)
#line 614
{
#line 614
	ix_short xx = (ix_short)*ip;
#line 614
	put_ix_short(xp, &xx);
#line 614
	if(*ip > (double)X_SHORT_MAX || *ip < (double)X_SHORT_MIN) return NC_ERANGE;
#line 614
	return NC_NOERR;
#line 614
}
#line 614

static int
#line 615
ncx_put_short_double(void *xp, const double *ip)
#line 615
{
#line 615
	ix_short xx = (ix_short)*ip;
#line 615
	put_ix_short(xp, &xx);
#line 615
	if(*ip > X_SHORT_MAX || *ip < X_SHORT_MIN) return NC_ERANGE;
#line 615
	return NC_NOERR;
#line 615
}
#line 615


/* x_ushort ------------------------------------------------------------------*/

#if USHORT_MAX == X_USHORT_MAX
typedef unsigned short ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_USHORT
#define IX_USHORT_MAX USHORT_MAX
#elif UINT_MAX >= X_USHORT_MAX
typedef unsigned int ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_UINT
#define IX_USHORT_MAX UINT_MAX
#elif ULONG_MAX >= X_USHORT_MAX
typedef unsigned long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG
#define IX_USHORT_MAX ULONG_MAX
#elif ULLONG_MAX >= X_USHORT_MAX
typedef unsigned long long ix_ushort;
#define SIZEOF_IX_USHORT SIZEOF_ULONG_LONG
#define IX_USHORT_MAX ULLONG_MAX
#else
#error "ix_ushort implementation"
#endif

static void
get_ix_ushort(const void *xp, ix_ushort *ip)
{
	const uchar *cp = (const uchar *) xp;
	*ip = *cp++ << 8;
#if SIZEOF_IX_SHORT > X_SIZEOF_SHORT
	if(*ip & 0x8000)
	{
		/* extern is negative */
		*ip |= (~(0xffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= *cp;
}

static void
put_ix_ushort(void *xp, const ix_ushort *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = (*ip) >> 8;
	*cp = (*ip) & 0xff;
}

static int
#line 662
ncx_get_ushort_schar(const void *xp, schar *ip)
#line 662
{
#line 662
	ix_ushort xx;
#line 662
	get_ix_ushort(xp, &xx);
#line 662
	*ip = (schar) xx;
#line 662
#if IX_USHORT_MAX > SCHAR_MAX
#line 662
	if (xx > SCHAR_MAX) return NC_ERANGE;
#line 662
#endif
#line 662

#line 662
	return NC_NOERR;
#line 662
}
#line 662

static int
#line 663
ncx_get_ushort_short(const void *xp, short *ip)
#line 663
{
#line 663
	ix_ushort xx;
#line 663
	get_ix_ushort(xp, &xx);
#line 663
	*ip = (short) xx;
#line 663
#if IX_USHORT_MAX > SHORT_MAX
#line 663
	if (xx > SHORT_MAX) return NC_ERANGE;
#line 663
#endif
#line 663

#line 663
	return NC_NOERR;
#line 663
}
#line 663

static int
#line 664
ncx_get_ushort_int(const void *xp, int *ip)
#line 664
{
#line 664
	ix_ushort xx;
#line 664
	get_ix_ushort(xp, &xx);
#line 664
	*ip = (int) xx;
#line 664
#if IX_USHORT_MAX > INT_MAX
#line 664
	if (xx > INT_MAX) return NC_ERANGE;
#line 664
#endif
#line 664

#line 664
	return NC_NOERR;
#line 664
}
#line 664

static int
#line 665
ncx_get_ushort_longlong(const void *xp, longlong *ip)
#line 665
{
#line 665
	ix_ushort xx;
#line 665
	get_ix_ushort(xp, &xx);
#line 665
	*ip = (longlong) xx;
#line 665
#if IX_USHORT_MAX > LONGLONG_MAX
#line 665
	if (xx > LONGLONG_MAX) return NC_ERANGE;
#line 665
#endif
#line 665

#line 665
	return NC_NOERR;
#line 665
}
#line 665

static int
#line 666
ncx_get_ushort_ushort(const void *xp, ushort *ip)
#line 666
{
#line 666
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 666
	get_ix_ushort(xp, (ix_ushort *)ip);
#line 666
	return NC_NOERR;
#line 666
#else
#line 666
	ix_ushort xx;
#line 666
	get_ix_ushort(xp, &xx);
#line 666
	*ip = (ushort) xx;
#line 666
#if IX_USHORT_MAX > USHORT_MAX
#line 666
	if (xx > USHORT_MAX) return NC_ERANGE;
#line 666
#endif
#line 666

#line 666
#endif
#line 666
	return NC_NOERR;
#line 666
}
#line 666

static int
#line 667
ncx_get_ushort_uchar(const void *xp, uchar *ip)
#line 667
{
#line 667
#if SIZEOF_IX_USHORT == SIZEOF_UCHAR && IX_USHORT_MAX == UCHAR_MAX
#line 667
	get_ix_ushort(xp, (ix_ushort *)ip);
#line 667
	return NC_NOERR;
#line 667
#else
#line 667
	ix_ushort xx;
#line 667
	get_ix_ushort(xp, &xx);
#line 667
	*ip = (uchar) xx;
#line 667
#if IX_USHORT_MAX > UCHAR_MAX
#line 667
	if (xx > UCHAR_MAX) return NC_ERANGE;
#line 667
#endif
#line 667

#line 667
#endif
#line 667
	return NC_NOERR;
#line 667
}
#line 667

static int
#line 668
ncx_get_ushort_uint(const void *xp, uint *ip)
#line 668
{
#line 668
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 668
	get_ix_ushort(xp, (ix_ushort *)ip);
#line 668
	return NC_NOERR;
#line 668
#else
#line 668
	ix_ushort xx;
#line 668
	get_ix_ushort(xp, &xx);
#line 668
	*ip = (uint) xx;
#line 668
#if IX_USHORT_MAX > UINT_MAX
#line 668
	if (xx > UINT_MAX) return NC_ERANGE;
#line 668
#endif
#line 668

#line 668
#endif
#line 668
	return NC_NOERR;
#line 668
}
#line 668

static int
#line 669
ncx_get_ushort_ulonglong(const void *xp, ulonglong *ip)
#line 669
{
#line 669
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 669
	get_ix_ushort(xp, (ix_ushort *)ip);
#line 669
	return NC_NOERR;
#line 669
#else
#line 669
	ix_ushort xx;
#line 669
	get_ix_ushort(xp, &xx);
#line 669
	*ip = (ulonglong) xx;
#line 669
#if IX_USHORT_MAX > ULONGLONG_MAX
#line 669
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#line 669
#endif
#line 669

#line 669
#endif
#line 669
	return NC_NOERR;
#line 669
}
#line 669

static int
#line 670
ncx_get_ushort_float(const void *xp, float *ip)
#line 670
{
#line 670
	ix_ushort xx;
#line 670
	get_ix_ushort(xp, &xx);
#line 670
	*ip = (float) xx;
#line 670

#line 670
	return NC_NOERR;
#line 670
}
#line 670

static int
#line 671
ncx_get_ushort_double(const void *xp, double *ip)
#line 671
{
#line 671
	ix_ushort xx;
#line 671
	get_ix_ushort(xp, &xx);
#line 671
	*ip = (double) xx;
#line 671

#line 671
	return NC_NOERR;
#line 671
}
#line 671


static int
ncx_put_ushort_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
		*cp++ = 0xff;
	else
		*cp++ = 0;
	*cp = (uchar)(signed)*ip;
        if (*ip < 0) return NC_ERANGE;

	return NC_NOERR;
}

static int
ncx_put_ushort_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0;
	*cp = *ip;
	return NC_NOERR;
}

static int
#line 696
ncx_put_ushort_short(void *xp, const short *ip)
#line 696
{
#line 696
	ix_ushort xx = (ix_ushort)*ip;
#line 696
	put_ix_ushort(xp, &xx);
#line 696
#if IX_USHORT_MAX < SHORT_MAX
#line 696
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#line 696
#endif
#line 696
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 696
	return NC_NOERR;
#line 696
}
#line 696

static int
#line 697
ncx_put_ushort_int(void *xp, const int *ip)
#line 697
{
#line 697
	ix_ushort xx = (ix_ushort)*ip;
#line 697
	put_ix_ushort(xp, &xx);
#line 697
#if IX_USHORT_MAX < INT_MAX
#line 697
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#line 697
#endif
#line 697
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 697
	return NC_NOERR;
#line 697
}
#line 697

static int
#line 698
ncx_put_ushort_longlong(void *xp, const longlong *ip)
#line 698
{
#line 698
	ix_ushort xx = (ix_ushort)*ip;
#line 698
	put_ix_ushort(xp, &xx);
#line 698
#if IX_USHORT_MAX < LONGLONG_MAX
#line 698
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#line 698
#endif
#line 698
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 698
	return NC_NOERR;
#line 698
}
#line 698

static int
#line 699
ncx_put_ushort_ushort(void *xp, const ushort *ip)
#line 699
{
#line 699
#if SIZEOF_IX_USHORT == SIZEOF_USHORT && IX_USHORT_MAX == USHORT_MAX
#line 699
	put_ix_ushort(xp, (const ix_ushort *)ip);
#line 699
	return NC_NOERR;
#line 699
#else
#line 699
	ix_ushort xx = (ix_ushort)*ip;
#line 699
	put_ix_ushort(xp, &xx);
#line 699
#if IX_USHORT_MAX < USHORT_MAX
#line 699
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#line 699
#endif
#line 699

#line 699
#endif
#line 699
	return NC_NOERR;
#line 699
}
#line 699

static int
#line 700
ncx_put_ushort_uint(void *xp, const uint *ip)
#line 700
{
#line 700
#if SIZEOF_IX_USHORT == SIZEOF_UINT && IX_USHORT_MAX == UINT_MAX
#line 700
	put_ix_ushort(xp, (const ix_ushort *)ip);
#line 700
	return NC_NOERR;
#line 700
#else
#line 700
	ix_ushort xx = (ix_ushort)*ip;
#line 700
	put_ix_ushort(xp, &xx);
#line 700
#if IX_USHORT_MAX < UINT_MAX
#line 700
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#line 700
#endif
#line 700

#line 700
#endif
#line 700
	return NC_NOERR;
#line 700
}
#line 700

static int
#line 701
ncx_put_ushort_ulonglong(void *xp, const ulonglong *ip)
#line 701
{
#line 701
#if SIZEOF_IX_USHORT == SIZEOF_ULONGLONG && IX_USHORT_MAX == ULONGLONG_MAX
#line 701
	put_ix_ushort(xp, (const ix_ushort *)ip);
#line 701
	return NC_NOERR;
#line 701
#else
#line 701
	ix_ushort xx = (ix_ushort)*ip;
#line 701
	put_ix_ushort(xp, &xx);
#line 701
#if IX_USHORT_MAX < ULONGLONG_MAX
#line 701
	if (*ip > IX_USHORT_MAX) return NC_ERANGE;
#line 701
#endif
#line 701

#line 701
#endif
#line 701
	return NC_NOERR;
#line 701
}
#line 701

static int
#line 702
ncx_put_ushort_float(void *xp, const float *ip)
#line 702
{
#line 702
	ix_ushort xx = (ix_ushort)*ip;
#line 702
	put_ix_ushort(xp, &xx);
#line 702
	if(*ip > (double)X_USHORT_MAX || *ip < 0) return NC_ERANGE;
#line 702
	return NC_NOERR;
#line 702
}
#line 702

static int
#line 703
ncx_put_ushort_double(void *xp, const double *ip)
#line 703
{
#line 703
	ix_ushort xx = (ix_ushort)*ip;
#line 703
	put_ix_ushort(xp, &xx);
#line 703
	if(*ip > X_USHORT_MAX || *ip < 0) return NC_ERANGE;
#line 703
	return NC_NOERR;
#line 703
}
#line 703


/* x_int ---------------------------------------------------------------------*/

#if SHORT_MAX == X_INT_MAX
typedef short ix_int;
#define SIZEOF_IX_INT SIZEOF_SHORT
#define IX_INT_MAX SHORT_MAX
#elif INT_MAX  >= X_INT_MAX
typedef int ix_int;
#define SIZEOF_IX_INT SIZEOF_INT
#define IX_INT_MAX INT_MAX
#elif LONG_MAX  >= X_INT_MAX
typedef long ix_int;
#define SIZEOF_IX_INT SIZEOF_LONG
#define IX_INT_MAX LONG_MAX
#else
#error "ix_int implementation"
#endif


static void
get_ix_int(const void *xp, ix_int *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = *cp++ << 24;
#if SIZEOF_IX_INT > X_SIZEOF_INT
	if(*ip & 0x80000000)
	{
		/* extern is negative */
		*ip |= (~(0xffffffff)); /* N.B. Assumes "twos complement" */
	}
#endif
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_int(void *xp, const ix_int *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (*ip) >> 24;
	*cp++ = ((*ip) & 0x00ff0000) >> 16;
	*cp++ = ((*ip) & 0x0000ff00) >>  8;
	*cp   = ((*ip) & 0x000000ff);
}

static int
#line 753
ncx_get_int_schar(const void *xp, schar *ip)
#line 753
{
#line 753
	ix_int xx;
#line 753
	get_ix_int(xp, &xx);
#line 753
	*ip = (schar) xx;
#line 753
#if IX_INT_MAX > SCHAR_MAX
#line 753
	if (xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
#line 753
#endif
#line 753

#line 753
	return NC_NOERR;
#line 753
}
#line 753

static int
#line 754
ncx_get_int_short(const void *xp, short *ip)
#line 754
{
#line 754
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 754
	get_ix_int(xp, (ix_int *)ip);
#line 754
	return NC_NOERR;
#line 754
#else
#line 754
	ix_int xx;
#line 754
	get_ix_int(xp, &xx);
#line 754
	*ip = (short) xx;
#line 754
#if IX_INT_MAX > SHORT_MAX
#line 754
	if (xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
#line 754
#endif
#line 754

#line 754
#endif
#line 754
	return NC_NOERR;
#line 754
}
#line 754

       int
#line 755
ncx_get_int_int(const void *xp, int *ip)
#line 755
{
#line 755
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 755
	get_ix_int(xp, (ix_int *)ip);
#line 755
	return NC_NOERR;
#line 755
#else
#line 755
	ix_int xx;
#line 755
	get_ix_int(xp, &xx);
#line 755
	*ip = (int) xx;
#line 755
#if IX_INT_MAX > INT_MAX
#line 755
	if (xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
#line 755
#endif
#line 755

#line 755
#endif
#line 755
	return NC_NOERR;
#line 755
}
#line 755

static int
#line 756
ncx_get_int_longlong(const void *xp, longlong *ip)
#line 756
{
#line 756
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 756
	get_ix_int(xp, (ix_int *)ip);
#line 756
	return NC_NOERR;
#line 756
#else
#line 756
	ix_int xx;
#line 756
	get_ix_int(xp, &xx);
#line 756
	*ip = (longlong) xx;
#line 756
#if IX_INT_MAX > LONGLONG_MAX
#line 756
	if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
#line 756
#endif
#line 756

#line 756
#endif
#line 756
	return NC_NOERR;
#line 756
}
#line 756

static int
#line 757
ncx_get_int_ushort(const void *xp, ushort *ip)
#line 757
{
#line 757
	ix_int xx;
#line 757
	get_ix_int(xp, &xx);
#line 757
	*ip = (ushort) xx;
#line 757
#if IX_INT_MAX > USHORT_MAX
#line 757
	if (xx > USHORT_MAX) return NC_ERANGE;
#line 757
#endif
#line 757
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 757
	return NC_NOERR;
#line 757
}
#line 757

static int
#line 758
ncx_get_int_uchar(const void *xp, uchar *ip)
#line 758
{
#line 758
	ix_int xx;
#line 758
	get_ix_int(xp, &xx);
#line 758
	*ip = (uchar) xx;
#line 758
#if IX_INT_MAX > UCHAR_MAX
#line 758
	if (xx > UCHAR_MAX) return NC_ERANGE;
#line 758
#endif
#line 758
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 758
	return NC_NOERR;
#line 758
}
#line 758

static int
#line 759
ncx_get_int_uint(const void *xp, uint *ip)
#line 759
{
#line 759
	ix_int xx;
#line 759
	get_ix_int(xp, &xx);
#line 759
	*ip = (uint) xx;
#line 759
#if IX_INT_MAX > UINT_MAX
#line 759
	if (xx > UINT_MAX) return NC_ERANGE;
#line 759
#endif
#line 759
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 759
	return NC_NOERR;
#line 759
}
#line 759

static int
#line 760
ncx_get_int_ulonglong(const void *xp, ulonglong *ip)
#line 760
{
#line 760
	ix_int xx;
#line 760
	get_ix_int(xp, &xx);
#line 760
	*ip = (ulonglong) xx;
#line 760
#if IX_INT_MAX > ULONGLONG_MAX
#line 760
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#line 760
#endif
#line 760
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 760
	return NC_NOERR;
#line 760
}
#line 760

static int
#line 761
ncx_get_int_float(const void *xp, float *ip)
#line 761
{
#line 761
	ix_int xx;
#line 761
	get_ix_int(xp, &xx);
#line 761
	*ip = (float) xx;
#line 761

#line 761
	return NC_NOERR;
#line 761
}
#line 761

static int
#line 762
ncx_get_int_double(const void *xp, double *ip)
#line 762
{
#line 762
	ix_int xx;
#line 762
	get_ix_int(xp, &xx);
#line 762
	*ip = (double) xx;
#line 762

#line 762
	return NC_NOERR;
#line 762
}
#line 762


static int
ncx_put_int_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	if(*ip & 0x80)
	{
		*cp++ = 0xff;
		*cp++ = 0xff;
		*cp++ = 0xff;
	}
	else
	{
		*cp++ = 0x00;
		*cp++ = 0x00;
		*cp++ = 0x00;
	}
	*cp = (uchar)(signed)*ip;
	return NC_NOERR;
}

static int
ncx_put_int_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

static int
#line 795
ncx_put_int_short(void *xp, const short *ip)
#line 795
{
#line 795
#if SIZEOF_IX_INT == SIZEOF_SHORT && IX_INT_MAX == SHORT_MAX
#line 795
	put_ix_int(xp, (const ix_int *)ip);
#line 795
	return NC_NOERR;
#line 795
#else
#line 795
	ix_int xx = (ix_int)*ip;
#line 795
	put_ix_int(xp, &xx);
#line 795
#if IX_INT_MAX < SHORT_MAX
#line 795
	if (*ip > IX_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
#line 795
#endif
#line 795

#line 795
#endif
#line 795
	return NC_NOERR;
#line 795
}
#line 795

       int
#line 796
ncx_put_int_int(void *xp, const int *ip)
#line 796
{
#line 796
#if SIZEOF_IX_INT == SIZEOF_INT && IX_INT_MAX == INT_MAX
#line 796
	put_ix_int(xp, (const ix_int *)ip);
#line 796
	return NC_NOERR;
#line 796
#else
#line 796
	ix_int xx = (ix_int)*ip;
#line 796
	put_ix_int(xp, &xx);
#line 796
#if IX_INT_MAX < INT_MAX
#line 796
	if (*ip > IX_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
#line 796
#endif
#line 796

#line 796
#endif
#line 796
	return NC_NOERR;
#line 796
}
#line 796

static int
#line 797
ncx_put_int_longlong(void *xp, const longlong *ip)
#line 797
{
#line 797
#if SIZEOF_IX_INT == SIZEOF_LONGLONG && IX_INT_MAX == LONGLONG_MAX
#line 797
	put_ix_int(xp, (const ix_int *)ip);
#line 797
	return NC_NOERR;
#line 797
#else
#line 797
	ix_int xx = (ix_int)*ip;
#line 797
	put_ix_int(xp, &xx);
#line 797
#if IX_INT_MAX < LONGLONG_MAX
#line 797
	if (*ip > IX_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
#line 797
#endif
#line 797

#line 797
#endif
#line 797
	return NC_NOERR;
#line 797
}
#line 797

static int
#line 798
ncx_put_int_ushort(void *xp, const ushort *ip)
#line 798
{
#line 798
	ix_int xx = (ix_int)*ip;
#line 798
	put_ix_int(xp, &xx);
#line 798
#if IX_INT_MAX < USHORT_MAX
#line 798
	if (*ip > IX_INT_MAX) return NC_ERANGE;
#line 798
#endif
#line 798

#line 798
	return NC_NOERR;
#line 798
}
#line 798

static int
#line 799
ncx_put_int_uint(void *xp, const uint *ip)
#line 799
{
#line 799
	ix_int xx = (ix_int)*ip;
#line 799
	put_ix_int(xp, &xx);
#line 799
#if IX_INT_MAX < UINT_MAX
#line 799
	if (*ip > IX_INT_MAX) return NC_ERANGE;
#line 799
#endif
#line 799

#line 799
	return NC_NOERR;
#line 799
}
#line 799

static int
#line 800
ncx_put_int_ulonglong(void *xp, const ulonglong *ip)
#line 800
{
#line 800
	ix_int xx = (ix_int)*ip;
#line 800
	put_ix_int(xp, &xx);
#line 800
#if IX_INT_MAX < ULONGLONG_MAX
#line 800
	if (*ip > IX_INT_MAX) return NC_ERANGE;
#line 800
#endif
#line 800

#line 800
	return NC_NOERR;
#line 800
}
#line 800

static int
#line 801
ncx_put_int_float(void *xp, const float *ip)
#line 801
{
#line 801
	ix_int xx = (ix_int)*ip;
#line 801
	put_ix_int(xp, &xx);
#line 801
	if(*ip > (double)X_INT_MAX || *ip < (double)X_INT_MIN) return NC_ERANGE;
#line 801
	return NC_NOERR;
#line 801
}
#line 801

static int
#line 802
ncx_put_int_double(void *xp, const double *ip)
#line 802
{
#line 802
	ix_int xx = (ix_int)*ip;
#line 802
	put_ix_int(xp, &xx);
#line 802
	if(*ip > X_INT_MAX || *ip < X_INT_MIN) return NC_ERANGE;
#line 802
	return NC_NOERR;
#line 802
}
#line 802



/* x_uint --------------------------------------------------------------------*/

#if USHORT_MAX == X_UINT_MAX
typedef ushort ix_uint;
#define SIZEOF_IX_UINT SIZEOF_USHORT
#define IX_UINT_MAX USHORT_MAX
#elif UINT_MAX  >= X_UINT_MAX
typedef uint ix_uint;
#define SIZEOF_IX_UINT SIZEOF_UINT
#define IX_UINT_MAX UINT_MAX
#elif ULONG_MAX  >= X_UINT_MAX
typedef ulong ix_uint;
#define SIZEOF_IX_UINT SIZEOF_ULONG
#define IX_UINT_MAX ULONG_MAX
#else
#error "ix_uint implementation"
#endif


static void
get_ix_uint(const void *xp, ix_uint *ip)
{
	const uchar *cp = (const uchar *) xp;

	*ip = *cp++ << 24;
	*ip |= (*cp++ << 16);
	*ip |= (*cp++ << 8);
	*ip |= *cp;
}

static void
put_ix_uint(void *xp, const ix_uint *ip)
{
	uchar *cp = (uchar *) xp;

	*cp++ = (*ip) >> 24;
	*cp++ = ((*ip) & 0x00ff0000) >> 16;
	*cp++ = ((*ip) & 0x0000ff00) >>  8;
	*cp   = ((*ip) & 0x000000ff);
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 847
ncx_get_uint_uint(const void *xp, uint *ip)
#line 847
{
#line 847
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 847
	get_ix_uint(xp, (ix_uint *)ip);
#line 847
	return NC_NOERR;
#line 847
#else
#line 847
	ix_uint xx;
#line 847
	get_ix_uint(xp, &xx);
#line 847
	*ip = (uint) xx;
#line 847
#if IX_UINT_MAX > UINT_MAX
#line 847
	if (xx > UINT_MAX) return NC_ERANGE;
#line 847
#endif
#line 847

#line 847
#endif
#line 847
	return NC_NOERR;
#line 847
}
#line 847

#endif

static int
#line 850
ncx_get_uint_schar(const void *xp, schar *ip)
#line 850
{
#line 850
	ix_uint xx;
#line 850
	get_ix_uint(xp, &xx);
#line 850
	*ip = (schar) xx;
#line 850
#if IX_UINT_MAX > SCHAR_MAX
#line 850
	if (xx > SCHAR_MAX) return NC_ERANGE;
#line 850
#endif
#line 850

#line 850
	return NC_NOERR;
#line 850
}
#line 850

static int
#line 851
ncx_get_uint_short(const void *xp, short *ip)
#line 851
{
#line 851
	ix_uint xx;
#line 851
	get_ix_uint(xp, &xx);
#line 851
	*ip = (short) xx;
#line 851
#if IX_UINT_MAX > SHORT_MAX
#line 851
	if (xx > SHORT_MAX) return NC_ERANGE;
#line 851
#endif
#line 851

#line 851
	return NC_NOERR;
#line 851
}
#line 851

static int
#line 852
ncx_get_uint_int(const void *xp, int *ip)
#line 852
{
#line 852
	ix_uint xx;
#line 852
	get_ix_uint(xp, &xx);
#line 852
	*ip = (int) xx;
#line 852
#if IX_UINT_MAX > INT_MAX
#line 852
	if (xx > INT_MAX) return NC_ERANGE;
#line 852
#endif
#line 852

#line 852
	return NC_NOERR;
#line 852
}
#line 852

static int
#line 853
ncx_get_uint_longlong(const void *xp, longlong *ip)
#line 853
{
#line 853
	ix_uint xx;
#line 853
	get_ix_uint(xp, &xx);
#line 853
	*ip = (longlong) xx;
#line 853
#if IX_UINT_MAX > LONGLONG_MAX
#line 853
	if (xx > LONGLONG_MAX) return NC_ERANGE;
#line 853
#endif
#line 853

#line 853
	return NC_NOERR;
#line 853
}
#line 853

static int
#line 854
ncx_get_uint_ushort(const void *xp, ushort *ip)
#line 854
{
#line 854
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 854
	get_ix_uint(xp, (ix_uint *)ip);
#line 854
	return NC_NOERR;
#line 854
#else
#line 854
	ix_uint xx;
#line 854
	get_ix_uint(xp, &xx);
#line 854
	*ip = (ushort) xx;
#line 854
#if IX_UINT_MAX > USHORT_MAX
#line 854
	if (xx > USHORT_MAX) return NC_ERANGE;
#line 854
#endif
#line 854

#line 854
#endif
#line 854
	return NC_NOERR;
#line 854
}
#line 854

static int
#line 855
ncx_get_uint_uchar(const void *xp, uchar *ip)
#line 855
{
#line 855
#if SIZEOF_IX_UINT == SIZEOF_UCHAR && IX_UINT_MAX == UCHAR_MAX
#line 855
	get_ix_uint(xp, (ix_uint *)ip);
#line 855
	return NC_NOERR;
#line 855
#else
#line 855
	ix_uint xx;
#line 855
	get_ix_uint(xp, &xx);
#line 855
	*ip = (uchar) xx;
#line 855
#if IX_UINT_MAX > UCHAR_MAX
#line 855
	if (xx > UCHAR_MAX) return NC_ERANGE;
#line 855
#endif
#line 855

#line 855
#endif
#line 855
	return NC_NOERR;
#line 855
}
#line 855

static int
#line 856
ncx_get_uint_ulonglong(const void *xp, ulonglong *ip)
#line 856
{
#line 856
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 856
	get_ix_uint(xp, (ix_uint *)ip);
#line 856
	return NC_NOERR;
#line 856
#else
#line 856
	ix_uint xx;
#line 856
	get_ix_uint(xp, &xx);
#line 856
	*ip = (ulonglong) xx;
#line 856
#if IX_UINT_MAX > ULONGLONG_MAX
#line 856
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#line 856
#endif
#line 856

#line 856
#endif
#line 856
	return NC_NOERR;
#line 856
}
#line 856

static int
#line 857
ncx_get_uint_float(const void *xp, float *ip)
#line 857
{
#line 857
	ix_uint xx;
#line 857
	get_ix_uint(xp, &xx);
#line 857
	*ip = (float) xx;
#line 857

#line 857
	return NC_NOERR;
#line 857
}
#line 857

static int
#line 858
ncx_get_uint_double(const void *xp, double *ip)
#line 858
{
#line 858
	ix_uint xx;
#line 858
	get_ix_uint(xp, &xx);
#line 858
	*ip = (double) xx;
#line 858

#line 858
	return NC_NOERR;
#line 858
}
#line 858


static int
ncx_put_uint_schar(void *xp, const schar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp = (uchar)(signed)*ip;

	if (*ip < 0) return NC_ERANGE;

	return NC_NOERR;
}

static int
ncx_put_uint_uchar(void *xp, const uchar *ip)
{
	uchar *cp = (uchar *) xp;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp++ = 0x00;
	*cp   = *ip;
	return NC_NOERR;
}

#if X_SIZEOF_UINT != SIZEOF_UINT
static int
#line 886
ncx_put_uint_uint(void *xp, const uint *ip)
#line 886
{
#line 886
#if SIZEOF_IX_UINT == SIZEOF_UINT && IX_UINT_MAX == UINT_MAX
#line 886
	put_ix_uint(xp, (const ix_uint *)ip);
#line 886
	return NC_NOERR;
#line 886
#else
#line 886
	ix_uint xx = (ix_uint)*ip;
#line 886
	put_ix_uint(xp, &xx);
#line 886
#if IX_UINT_MAX < UINT_MAX
#line 886
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#line 886
#endif
#line 886

#line 886
#endif
#line 886
	return NC_NOERR;
#line 886
}
#line 886

#endif

static int
#line 889
ncx_put_uint_short(void *xp, const short *ip)
#line 889
{
#line 889
	ix_uint xx = (ix_uint)*ip;
#line 889
	put_ix_uint(xp, &xx);
#line 889
#if IX_UINT_MAX < SHORT_MAX
#line 889
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#line 889
#endif
#line 889
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 889
	return NC_NOERR;
#line 889
}
#line 889

static int
#line 890
ncx_put_uint_int(void *xp, const int *ip)
#line 890
{
#line 890
	ix_uint xx = (ix_uint)*ip;
#line 890
	put_ix_uint(xp, &xx);
#line 890
#if IX_UINT_MAX < INT_MAX
#line 890
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#line 890
#endif
#line 890
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 890
	return NC_NOERR;
#line 890
}
#line 890

static int
#line 891
ncx_put_uint_longlong(void *xp, const longlong *ip)
#line 891
{
#line 891
	ix_uint xx = (ix_uint)*ip;
#line 891
	put_ix_uint(xp, &xx);
#line 891
#if IX_UINT_MAX < LONGLONG_MAX
#line 891
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#line 891
#endif
#line 891
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 891
	return NC_NOERR;
#line 891
}
#line 891

static int
#line 892
ncx_put_uint_ushort(void *xp, const ushort *ip)
#line 892
{
#line 892
#if SIZEOF_IX_UINT == SIZEOF_USHORT && IX_UINT_MAX == USHORT_MAX
#line 892
	put_ix_uint(xp, (const ix_uint *)ip);
#line 892
	return NC_NOERR;
#line 892
#else
#line 892
	ix_uint xx = (ix_uint)*ip;
#line 892
	put_ix_uint(xp, &xx);
#line 892
#if IX_UINT_MAX < USHORT_MAX
#line 892
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#line 892
#endif
#line 892

#line 892
#endif
#line 892
	return NC_NOERR;
#line 892
}
#line 892

static int
#line 893
ncx_put_uint_ulonglong(void *xp, const ulonglong *ip)
#line 893
{
#line 893
#if SIZEOF_IX_UINT == SIZEOF_ULONGLONG && IX_UINT_MAX == ULONGLONG_MAX
#line 893
	put_ix_uint(xp, (const ix_uint *)ip);
#line 893
	return NC_NOERR;
#line 893
#else
#line 893
	ix_uint xx = (ix_uint)*ip;
#line 893
	put_ix_uint(xp, &xx);
#line 893
#if IX_UINT_MAX < ULONGLONG_MAX
#line 893
	if (*ip > IX_UINT_MAX) return NC_ERANGE;
#line 893
#endif
#line 893

#line 893
#endif
#line 893
	return NC_NOERR;
#line 893
}
#line 893

static int
#line 894
ncx_put_uint_float(void *xp, const float *ip)
#line 894
{
#line 894
	ix_uint xx = (ix_uint)*ip;
#line 894
	put_ix_uint(xp, &xx);
#line 894
	if(*ip > (double)X_UINT_MAX || *ip < 0) return NC_ERANGE;
#line 894
	return NC_NOERR;
#line 894
}
#line 894

static int
#line 895
ncx_put_uint_double(void *xp, const double *ip)
#line 895
{
#line 895
	ix_uint xx = (ix_uint)*ip;
#line 895
	put_ix_uint(xp, &xx);
#line 895
	if(*ip > X_UINT_MAX || *ip < 0) return NC_ERANGE;
#line 895
	return NC_NOERR;
#line 895
}
#line 895


/* x_float -------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)

static void
get_ix_float(const void *xp, float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, sizeof(float));
#else
	swap4b(ip, xp);
#endif
}

static void
put_ix_float(void *xp, const float *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_FLOAT);
#else
	swap4b(xp, ip);
#endif
}

#elif vax

/* What IEEE single precision floating point looks like on a Vax */
struct	ieee_single {
	unsigned int	exp_hi       : 7;
	unsigned int	sign         : 1;
	unsigned int 	mant_hi      : 7;
	unsigned int	exp_lo       : 1;
	unsigned int	mant_lo_hi   : 8;
	unsigned int	mant_lo_lo   : 8;
};

/* Vax single precision floating point */
struct	vax_single {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
};

#define VAX_SNG_BIAS	0x81
#define IEEE_SNG_BIAS	0x7f

static struct sgl_limits {
	struct vax_single s;
	struct ieee_single ieee;
} max = {
	{ 0x7f, 0xff, 0x0, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0x1, 0x0, 0x0 }		/* Max IEEE */
};
static struct sgl_limits min = {
	{ 0x0, 0x0, 0x0, 0x0 },	/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 }		/* Min IEEE */
};

#line 1008
static void
get_ix_float(const void *xp, float *ip)
{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 1011
		const struct ieee_single *const isp =
#line 1011
			 (const struct ieee_single *) xp;
#line 1011
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 1011

#line 1011
		switch(exp) {
#line 1011
		case 0 :
#line 1011
			/* ieee subnormal */
#line 1011
			if(isp->mant_hi == min.ieee.mant_hi
#line 1011
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 1011
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 1011
			{
#line 1011
				*vsp = min.s;
#line 1011
			}
#line 1011
			else
#line 1011
			{
#line 1011
				unsigned mantissa = (isp->mant_hi << 16)
#line 1011
					 | isp->mant_lo_hi << 8
#line 1011
					 | isp->mant_lo_lo;
#line 1011
				unsigned tmp = mantissa >> 20;
#line 1011
				if(tmp >= 4) {
#line 1011
					vsp->exp = 2;
#line 1011
				} else if (tmp >= 2) {
#line 1011
					vsp->exp = 1;
#line 1011
				} else {
#line 1011
					*vsp = min.s;
#line 1011
					break;
#line 1011
				} /* else */
#line 1011
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 1011
				tmp <<= 3 - vsp->exp;
#line 1011
				vsp->mantissa2 = tmp;
#line 1011
				vsp->mantissa1 = (tmp >> 16);
#line 1011
			}
#line 1011
			break;
#line 1011
		case 0xfe :
#line 1011
		case 0xff :
#line 1011
			*vsp = max.s;
#line 1011
			break;
#line 1011
		default :
#line 1011
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 1011
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 1011
			vsp->mantissa1 = isp->mant_hi;
#line 1011
		}
#line 1011

#line 1011
		vsp->sign = isp->sign;
#line 1011

}

#line 1065

static void
put_ix_float(void *xp, const float *ip)
{
		const struct vax_single *const vsp =
#line 1069
			 (const struct vax_single *)ip;
#line 1069
		struct ieee_single *const isp = (struct ieee_single *) xp;
#line 1069

#line 1069
		switch(vsp->exp){
#line 1069
		case 0 :
#line 1069
			/* all vax float with zero exponent map to zero */
#line 1069
			*isp = min.ieee;
#line 1069
			break;
#line 1069
		case 2 :
#line 1069
		case 1 :
#line 1069
		{
#line 1069
			/* These will map to subnormals */
#line 1069
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 1069
					 | vsp->mantissa2;
#line 1069
			mantissa >>= 3 - vsp->exp;
#line 1069
			mantissa += (1 << (20 + vsp->exp));
#line 1069
			isp->mant_lo_lo = mantissa;
#line 1069
			isp->mant_lo_hi = mantissa >> 8;
#line 1069
			isp->mant_hi = mantissa >> 16;
#line 1069
			isp->exp_lo = 0;
#line 1069
			isp->exp_hi = 0;
#line 1069
		}
#line 1069
			break;
#line 1069
		case 0xff : /* max.s.exp */
#line 1069
			if( vsp->mantissa2 == max.s.mantissa2
#line 1069
				&& vsp->mantissa1 == max.s.mantissa1)
#line 1069
			{
#line 1069
				/* map largest vax float to ieee infinity */
#line 1069
				*isp = max.ieee;
#line 1069
				break;
#line 1069
			} /* else, fall thru */
#line 1069
		default :
#line 1069
		{
#line 1069
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 1069
			isp->exp_hi = exp >> 1;
#line 1069
			isp->exp_lo = exp;
#line 1069
			isp->mant_lo_lo = vsp->mantissa2;
#line 1069
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 1069
			isp->mant_hi = vsp->mantissa1;
#line 1069
		}
#line 1069
		}
#line 1069

#line 1069
		isp->sign = vsp->sign;
#line 1069

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

/*
 * Return the number of bytes until the next "word" boundary
 * N.B. This is based on the very weird YMP address structure,
 * which puts the address within a word in the leftmost 3 bits
 * of the address.
 */
static size_t
word_align(const void *vp)
{
	const size_t rem = ((size_t)vp >> (64 - 3)) & 0x7;
	return (rem != 0);
}

struct ieee_single_hi {
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
	unsigned int	pad	:32;
};
typedef struct ieee_single_hi ieee_single_hi;

struct ieee_single_lo {
	unsigned int	pad	:32;
	unsigned int	sign	: 1;
	unsigned int	 exp	: 8;
	unsigned int	mant	:23;
};
typedef struct ieee_single_lo ieee_single_lo;

static const int ieee_single_bias = 0x7f;

struct ieee_double {
	unsigned int	sign	: 1;
	unsigned int	 exp	:11;
	unsigned int	mant	:52;
};
typedef struct ieee_double ieee_double;

static const int ieee_double_bias = 0x3ff;

#if defined(NO_IEEE_FLOAT)

struct cray_single {
	unsigned int	sign	: 1;
	unsigned int	 exp	:15;
	unsigned int	mant	:48;
};
typedef struct cray_single cray_single;

static const int cs_ieis_bias = 0x4000 - 0x7f;

static const int cs_id_bias = 0x4000 - 0x3ff;

#line 1204

static void
get_ix_float(const void *xp, float *ip)
{

	if(word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1212

#line 1212
		if(isp->exp == 0)
#line 1212
		{
#line 1212
			/* ieee subnormal */
#line 1212
			*ip = (double)isp->mant;
#line 1212
			if(isp->mant != 0)
#line 1212
			{
#line 1212
				csp->exp -= (ieee_single_bias + 22);
#line 1212
			}
#line 1212
		}
#line 1212
		else
#line 1212
		{
#line 1212
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1212
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1212
			csp->mant |= (1 << (48 - 1));
#line 1212
		}
#line 1212
		csp->sign = isp->sign;
#line 1212

#line 1212

	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		cray_single *csp = (cray_single *) ip;
#line 1217

#line 1217
		if(isp->exp == 0)
#line 1217
		{
#line 1217
			/* ieee subnormal */
#line 1217
			*ip = (double)isp->mant;
#line 1217
			if(isp->mant != 0)
#line 1217
			{
#line 1217
				csp->exp -= (ieee_single_bias + 22);
#line 1217
			}
#line 1217
		}
#line 1217
		else
#line 1217
		{
#line 1217
			csp->exp  = isp->exp + cs_ieis_bias + 1;
#line 1217
			csp->mant = isp->mant << (48 - 1 - 23);
#line 1217
			csp->mant |= (1 << (48 - 1));
#line 1217
		}
#line 1217
		csp->sign = isp->sign;
#line 1217

#line 1217

	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	if(word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1227
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1227

#line 1227
	isp->sign = csp->sign;
#line 1227

#line 1227
	if(ieee_exp >= 0xff)
#line 1227
	{
#line 1227
		/* NC_ERANGE => ieee Inf */
#line 1227
		isp->exp = 0xff;
#line 1227
		isp->mant = 0x0;
#line 1227
	}
#line 1227
	else if(ieee_exp > 0)
#line 1227
	{
#line 1227
		/* normal ieee representation */
#line 1227
		isp->exp  = ieee_exp;
#line 1227
		/* assumes cray rep is in normal form */
#line 1227
		assert(csp->mant & 0x800000000000);
#line 1227
		isp->mant = (((csp->mant << 1) &
#line 1227
				0xffffffffffff) >> (48 - 23));
#line 1227
	}
#line 1227
	else if(ieee_exp > -23)
#line 1227
	{
#line 1227
		/* ieee subnormal, right shift */
#line 1227
		const int rshift = (48 - 23 - ieee_exp);
#line 1227

#line 1227
		isp->mant = csp->mant >> rshift;
#line 1227

#line 1227
#if 0
#line 1227
		if(csp->mant & (1 << (rshift -1)))
#line 1227
		{
#line 1227
			/* round up */
#line 1227
			isp->mant++;
#line 1227
		}
#line 1227
#endif
#line 1227

#line 1227
		isp->exp  = 0;
#line 1227
	}
#line 1227
	else
#line 1227
	{
#line 1227
		/* smaller than ieee can represent */
#line 1227
		isp->exp = 0;
#line 1227
		isp->mant = 0;
#line 1227
	}
#line 1227

	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
	const cray_single *csp = (const cray_single *) ip;
#line 1232
	int ieee_exp = csp->exp - cs_ieis_bias -1;
#line 1232

#line 1232
	isp->sign = csp->sign;
#line 1232

#line 1232
	if(ieee_exp >= 0xff)
#line 1232
	{
#line 1232
		/* NC_ERANGE => ieee Inf */
#line 1232
		isp->exp = 0xff;
#line 1232
		isp->mant = 0x0;
#line 1232
	}
#line 1232
	else if(ieee_exp > 0)
#line 1232
	{
#line 1232
		/* normal ieee representation */
#line 1232
		isp->exp  = ieee_exp;
#line 1232
		/* assumes cray rep is in normal form */
#line 1232
		assert(csp->mant & 0x800000000000);
#line 1232
		isp->mant = (((csp->mant << 1) &
#line 1232
				0xffffffffffff) >> (48 - 23));
#line 1232
	}
#line 1232
	else if(ieee_exp > -23)
#line 1232
	{
#line 1232
		/* ieee subnormal, right shift */
#line 1232
		const int rshift = (48 - 23 - ieee_exp);
#line 1232

#line 1232
		isp->mant = csp->mant >> rshift;
#line 1232

#line 1232
#if 0
#line 1232
		if(csp->mant & (1 << (rshift -1)))
#line 1232
		{
#line 1232
			/* round up */
#line 1232
			isp->mant++;
#line 1232
		}
#line 1232
#endif
#line 1232

#line 1232
		isp->exp  = 0;
#line 1232
	}
#line 1232
	else
#line 1232
	{
#line 1232
		/* smaller than ieee can represent */
#line 1232
		isp->exp = 0;
#line 1232
		isp->mant = 0;
#line 1232
	}
#line 1232

	}
}

#else
	/* IEEE Cray with only doubles */
static void
get_ix_float(const void *xp, float *ip)
{

	ieee_double *idp = (ieee_double *) ip;

	if(word_align(xp) == 0)
	{
		const ieee_single_hi *isp = (const ieee_single_hi *) xp;
		if(isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
	else
	{
		const ieee_single_lo *isp = (const ieee_single_lo *) xp;
		if(isp->exp == 0 && isp->mant == 0)
		{
			idp->exp = 0;
			idp->mant = 0;
		}
		else
		{
			idp->exp = isp->exp + (ieee_double_bias - ieee_single_bias);
			idp->mant = isp->mant << (52 - 23);
		}
		idp->sign = isp->sign;
	}
}

static void
put_ix_float(void *xp, const float *ip)
{
	const ieee_double *idp = (const ieee_double *) ip;
	if(word_align(xp) == 0)
	{
		ieee_single_hi *isp = (ieee_single_hi*)xp;
		if(idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
	else
	{
		ieee_single_lo *isp = (ieee_single_lo*)xp;
		if(idp->exp > (ieee_double_bias - ieee_single_bias))
			isp->exp = idp->exp - (ieee_double_bias - ieee_single_bias);
		else
			isp->exp = 0;
		isp->mant = idp->mant >> (52 - 23);
		isp->sign = idp->sign;
	}
}
#endif

#else
#error "ix_float implementation"
#endif

#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_get_float_float(const void *xp, float *ip)
{
	/* TODO */
	get_ix_float(xp, ip);
	return NC_NOERR;
}
#endif

#define ix_float float

static int
#line 1319
ncx_get_float_schar(const void *xp, schar *ip)
#line 1319
{
#line 1319
	ix_float xx;
#line 1319
	get_ix_float(xp, &xx);
#line 1319
	*ip = (schar) xx;
#line 1319
	if(xx > (double)SCHAR_MAX || xx < (double)SCHAR_MIN) return NC_ERANGE;
#line 1319
	return NC_NOERR;
#line 1319
}
#line 1319

static int
#line 1320
ncx_get_float_short(const void *xp, short *ip)
#line 1320
{
#line 1320
	ix_float xx;
#line 1320
	get_ix_float(xp, &xx);
#line 1320
	*ip = (short) xx;
#line 1320
	if(xx > (double)SHORT_MAX || xx < (double)SHORT_MIN) return NC_ERANGE;
#line 1320
	return NC_NOERR;
#line 1320
}
#line 1320

static int
#line 1321
ncx_get_float_int(const void *xp, int *ip)
#line 1321
{
#line 1321
	ix_float xx;
#line 1321
	get_ix_float(xp, &xx);
#line 1321
	*ip = (int) xx;
#line 1321
	if(xx > (double)INT_MAX || xx < (double)INT_MIN) return NC_ERANGE;
#line 1321
	return NC_NOERR;
#line 1321
}
#line 1321

static int
#line 1322
ncx_get_float_double(const void *xp, double *ip)
#line 1322
{
#line 1322
	ix_float xx;
#line 1322
	get_ix_float(xp, &xx);
#line 1322
	*ip = (double) xx;
#line 1322

#line 1322
	return NC_NOERR;
#line 1322
}
#line 1322

static int
#line 1323
ncx_get_float_longlong(const void *xp, longlong *ip)
#line 1323
{
#line 1323
	ix_float xx;
#line 1323
	get_ix_float(xp, &xx);
#line 1323
	*ip = (longlong) xx;
#line 1323
	if(xx > (double)LONGLONG_MAX || xx < (double)LONGLONG_MIN) return NC_ERANGE;
#line 1323
	return NC_NOERR;
#line 1323
}
#line 1323

static int
#line 1324
ncx_get_float_uchar(const void *xp, uchar *ip)
#line 1324
{
#line 1324
	ix_float xx;
#line 1324
	get_ix_float(xp, &xx);
#line 1324
	*ip = (uchar) xx;
#line 1324
	if(xx > (double)UCHAR_MAX || xx < 0) return NC_ERANGE;
#line 1324
	return NC_NOERR;
#line 1324
}
#line 1324

static int
#line 1325
ncx_get_float_ushort(const void *xp, ushort *ip)
#line 1325
{
#line 1325
	ix_float xx;
#line 1325
	get_ix_float(xp, &xx);
#line 1325
	*ip = (ushort) xx;
#line 1325
	if(xx > (double)USHORT_MAX || xx < 0) return NC_ERANGE;
#line 1325
	return NC_NOERR;
#line 1325
}
#line 1325

static int
#line 1326
ncx_get_float_uint(const void *xp, uint *ip)
#line 1326
{
#line 1326
	ix_float xx;
#line 1326
	get_ix_float(xp, &xx);
#line 1326
	*ip = (uint) xx;
#line 1326
	if(xx > (double)UINT_MAX || xx < 0) return NC_ERANGE;
#line 1326
	return NC_NOERR;
#line 1326
}
#line 1326

static int
#line 1327
ncx_get_float_ulonglong(const void *xp, ulonglong *ip)
#line 1327
{
#line 1327
	ix_float xx;
#line 1327
	get_ix_float(xp, &xx);
#line 1327
	*ip = (ulonglong) xx;
#line 1327
	if(xx > (double)ULONGLONG_MAX || xx < 0) return NC_ERANGE;
#line 1327
	return NC_NOERR;
#line 1327
}
#line 1327


#if X_SIZEOF_FLOAT != SIZEOF_FLOAT || defined(NO_IEEE_FLOAT)
static int
ncx_put_float_float(void *xp, const float *ip)
{
	put_ix_float(xp, ip);
#ifdef NO_IEEE_FLOAT
	if(*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN)
		return NC_ERANGE;
#endif
	return NC_NOERR;
}
#endif

static int
#line 1342
ncx_put_float_schar(void *xp, const schar *ip)
#line 1342
{
#line 1342
	ix_float xx = (ix_float)*ip;
#line 1342
	put_ix_float(xp, &xx);
#line 1342

#line 1342
	return NC_NOERR;
#line 1342
}
#line 1342

static int
#line 1343
ncx_put_float_short(void *xp, const short *ip)
#line 1343
{
#line 1343
	ix_float xx = (ix_float)*ip;
#line 1343
	put_ix_float(xp, &xx);
#line 1343

#line 1343
	return NC_NOERR;
#line 1343
}
#line 1343

static int
#line 1344
ncx_put_float_int(void *xp, const int *ip)
#line 1344
{
#line 1344
	ix_float xx = (ix_float)*ip;
#line 1344
	put_ix_float(xp, &xx);
#line 1344

#line 1344
	return NC_NOERR;
#line 1344
}
#line 1344

static int
#line 1345
ncx_put_float_double(void *xp, const double *ip)
#line 1345
{
#line 1345
	ix_float xx = (ix_float)*ip;
#line 1345
	put_ix_float(xp, &xx);
#line 1345
	if(*ip > X_FLOAT_MAX || *ip < X_FLOAT_MIN) return NC_ERANGE;
#line 1345
	return NC_NOERR;
#line 1345
}
#line 1345

static int
#line 1346
ncx_put_float_longlong(void *xp, const longlong *ip)
#line 1346
{
#line 1346
	ix_float xx = (ix_float)*ip;
#line 1346
	put_ix_float(xp, &xx);
#line 1346

#line 1346
	return NC_NOERR;
#line 1346
}
#line 1346

static int
#line 1347
ncx_put_float_uchar(void *xp, const uchar *ip)
#line 1347
{
#line 1347
	ix_float xx = (ix_float)*ip;
#line 1347
	put_ix_float(xp, &xx);
#line 1347

#line 1347
	return NC_NOERR;
#line 1347
}
#line 1347

static int
#line 1348
ncx_put_float_ushort(void *xp, const ushort *ip)
#line 1348
{
#line 1348
	ix_float xx = (ix_float)*ip;
#line 1348
	put_ix_float(xp, &xx);
#line 1348

#line 1348
	return NC_NOERR;
#line 1348
}
#line 1348

static int
#line 1349
ncx_put_float_uint(void *xp, const uint *ip)
#line 1349
{
#line 1349
	ix_float xx = (ix_float)*ip;
#line 1349
	put_ix_float(xp, &xx);
#line 1349

#line 1349
	return NC_NOERR;
#line 1349
}
#line 1349

static int
#line 1350
ncx_put_float_ulonglong(void *xp, const ulonglong *ip)
#line 1350
{
#line 1350
	ix_float xx = (ix_float)*ip;
#line 1350
	put_ix_float(xp, &xx);
#line 1350

#line 1350
	return NC_NOERR;
#line 1350
}
#line 1350



/* x_double ------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE  && !defined(NO_IEEE_FLOAT)

static void
get_ix_double(const void *xp, double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(ip, xp, sizeof(double));
#else
	swap8b(ip, xp);
#endif
}

static void
put_ix_double(void *xp, const double *ip)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(xp, ip, X_SIZEOF_DOUBLE);
#else
	swap8b(xp, ip);
#endif
}

#elif vax

/* What IEEE double precision floating point looks like on a Vax */
struct	ieee_double {
	unsigned int	exp_hi   : 7;
	unsigned int	sign     : 1;
	unsigned int 	mant_6   : 4;
	unsigned int	exp_lo   : 4;
	unsigned int	mant_5   : 8;
	unsigned int	mant_4   : 8;

	unsigned int	mant_lo  : 32;
};

/* Vax double precision floating point */
struct  vax_double {
	unsigned int	mantissa1 : 7;
	unsigned int	exp       : 8;
	unsigned int	sign      : 1;
	unsigned int	mantissa2 : 16;
	unsigned int	mantissa3 : 16;
	unsigned int	mantissa4 : 16;
};

#define VAX_DBL_BIAS	0x81
#define IEEE_DBL_BIAS	0x3ff
#define MASK(nbits)	((1 << nbits) - 1)

static const struct dbl_limits {
	struct	vax_double d;
	struct	ieee_double ieee;
} dbl_limits[2] = {
	{{ 0x7f, 0xff, 0x0, 0xffff, 0xffff, 0xffff },	/* Max Vax */
	{ 0x7f, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0}}, /* Max IEEE */
	{{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0},		/* Min Vax */
	{ 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}}, /* Min IEEE */
};


#line 1464
static void
get_ix_double(const void *xp, double *ip)
{
	struct vax_double *const vdp =
#line 1467
			 (struct vax_double *)ip;
#line 1467
	const struct ieee_double *const idp =
#line 1467
			 (const struct ieee_double *) xp;
#line 1467
	{
#line 1467
		const struct dbl_limits *lim;
#line 1467
		int ii;
#line 1467
		for (ii = 0, lim = dbl_limits;
#line 1467
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 1467
			ii++, lim++)
#line 1467
		{
#line 1467
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 1467
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 1467
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 1467
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 1467
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 1467
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 1467
				)
#line 1467
			{
#line 1467
				*vdp = lim->d;
#line 1467
				goto doneit;
#line 1467
			}
#line 1467
		}
#line 1467
	}
#line 1467
	{
#line 1467
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 1467
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 1467
	}
#line 1467
	{
#line 1467
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 1467
				 | (idp->mant_5 << 8)
#line 1467
				 | idp->mant_4);
#line 1467
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 1467
		vdp->mantissa1 = (mant_hi >> 13);
#line 1467
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 1467
				| (mant_lo >> 29);
#line 1467
		vdp->mantissa3 = (mant_lo >> 13);
#line 1467
		vdp->mantissa4 = (mant_lo << 3);
#line 1467
	}
#line 1467
	doneit:
#line 1467
		vdp->sign = idp->sign;
#line 1467

}


#line 1537
static void
put_ix_double(void *xp, const double *ip)
{
	const struct vax_double *const vdp =
#line 1540
			(const struct vax_double *)ip;
#line 1540
	struct ieee_double *const idp =
#line 1540
			 (struct ieee_double *) xp;
#line 1540

#line 1540
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 1540
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 1540
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 1540
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 1540
		(vdp->exp == dbl_limits[0].d.exp))
#line 1540
	{
#line 1540
		*idp = dbl_limits[0].ieee;
#line 1540
		goto shipit;
#line 1540
	}
#line 1540
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 1540
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 1540
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 1540
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 1540
		(vdp->exp == dbl_limits[1].d.exp))
#line 1540
	{
#line 1540
		*idp = dbl_limits[1].ieee;
#line 1540
		goto shipit;
#line 1540
	}
#line 1540

#line 1540
	{
#line 1540
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 1540

#line 1540
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 1540
			(vdp->mantissa3 << 13) |
#line 1540
			((vdp->mantissa4 >> 3) & MASK(13));
#line 1540

#line 1540
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 1540
				 | (vdp->mantissa2 >> 3);
#line 1540

#line 1540
		if((vdp->mantissa4 & 7) > 4)
#line 1540
		{
#line 1540
			/* round up */
#line 1540
			mant_lo++;
#line 1540
			if(mant_lo == 0)
#line 1540
			{
#line 1540
				mant_hi++;
#line 1540
				if(mant_hi > 0xffffff)
#line 1540
				{
#line 1540
					mant_hi = 0;
#line 1540
					exp++;
#line 1540
				}
#line 1540
			}
#line 1540
		}
#line 1540

#line 1540
		idp->mant_lo = SWAP4(mant_lo);
#line 1540
		idp->mant_6 = mant_hi >> 16;
#line 1540
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 1540
		idp->mant_4 = mant_hi;
#line 1540
		idp->exp_hi = exp >> 4;
#line 1540
		idp->exp_lo = exp;
#line 1540
	}
#line 1540

#line 1540
	shipit:
#line 1540
		idp->sign = vdp->sign;
#line 1540

}

	/* vax */
#elif defined(_CRAY) && !defined(__crayx1)

static void
get_ix_double(const void *xp, double *ip)
{
	const ieee_double *idp = (const ieee_double *) xp;
	cray_single *csp = (cray_single *) ip;

	if(idp->exp == 0)
	{
		/* ieee subnormal */
		*ip = (double)idp->mant;
		if(idp->mant != 0)
		{
			csp->exp -= (ieee_double_bias + 51);
		}
	}
	else
	{
		csp->exp  = idp->exp + cs_id_bias + 1;
		csp->mant = idp->mant >> (52 - 48 + 1);
		csp->mant |= (1 << (48 - 1));
	}
	csp->sign = idp->sign;
}

static void
put_ix_double(void *xp, const double *ip)
{
	ieee_double *idp = (ieee_double *) xp;
	const cray_single *csp = (const cray_single *) ip;

	int ieee_exp = csp->exp - cs_id_bias -1;

	idp->sign = csp->sign;

	if(ieee_exp >= 0x7ff)
	{
		/* NC_ERANGE => ieee Inf */
		idp->exp = 0x7ff;
		idp->mant = 0x0;
	}
	else if(ieee_exp > 0)
	{
		/* normal ieee representation */
		idp->exp  = ieee_exp;
		/* assumes cray rep is in normal form */
		assert(csp->mant & 0x800000000000);
		idp->mant = (((csp->mant << 1) &
				0xffffffffffff) << (52 - 48));
	}
	else if(ieee_exp >= (-(52 -48)))
	{
		/* ieee subnormal, left shift */
		const int lshift = (52 - 48) + ieee_exp;
		idp->mant = csp->mant << lshift;
		idp->exp  = 0;
	}
	else if(ieee_exp >= -52)
	{
		/* ieee subnormal, right shift */
		const int rshift = (- (52 - 48) - ieee_exp);

		idp->mant = csp->mant >> rshift;

#if 0
		if(csp->mant & (1 << (rshift -1)))
		{
			/* round up */
			idp->mant++;
		}
#endif

		idp->exp  = 0;
	}
	else
	{
		/* smaller than ieee can represent */
		idp->exp = 0;
		idp->mant = 0;
	}
}
#else
#error "ix_double implementation"
#endif

#define ix_double double

static int
#line 1632
ncx_get_double_schar(const void *xp, schar *ip)
#line 1632
{
#line 1632
	ix_double xx;
#line 1632
	get_ix_double(xp, &xx);
#line 1632
	*ip = (schar) xx;
#line 1632
	if(xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
#line 1632
	return NC_NOERR;
#line 1632
}
#line 1632

static int
#line 1633
ncx_get_double_short(const void *xp, short *ip)
#line 1633
{
#line 1633
	ix_double xx;
#line 1633
	get_ix_double(xp, &xx);
#line 1633
	*ip = (short) xx;
#line 1633
	if(xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
#line 1633
	return NC_NOERR;
#line 1633
}
#line 1633

static int
#line 1634
ncx_get_double_int(const void *xp, int *ip)
#line 1634
{
#line 1634
	ix_double xx;
#line 1634
	get_ix_double(xp, &xx);
#line 1634
	*ip = (int) xx;
#line 1634
	if(xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
#line 1634
	return NC_NOERR;
#line 1634
}
#line 1634

static int
#line 1635
ncx_get_double_longlong(const void *xp, longlong *ip)
#line 1635
{
#line 1635
	ix_double xx;
#line 1635
	get_ix_double(xp, &xx);
#line 1635
	*ip = (longlong) xx;
#line 1635
	if(xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
#line 1635
	return NC_NOERR;
#line 1635
}
#line 1635

static int
#line 1636
ncx_get_double_uchar(const void *xp, uchar *ip)
#line 1636
{
#line 1636
	ix_double xx;
#line 1636
	get_ix_double(xp, &xx);
#line 1636
	*ip = (uchar) xx;
#line 1636
	if(xx > UCHAR_MAX || xx < 0) return NC_ERANGE;
#line 1636
	return NC_NOERR;
#line 1636
}
#line 1636

static int
#line 1637
ncx_get_double_ushort(const void *xp, ushort *ip)
#line 1637
{
#line 1637
	ix_double xx;
#line 1637
	get_ix_double(xp, &xx);
#line 1637
	*ip = (ushort) xx;
#line 1637
	if(xx > USHORT_MAX || xx < 0) return NC_ERANGE;
#line 1637
	return NC_NOERR;
#line 1637
}
#line 1637

static int
#line 1638
ncx_get_double_uint(const void *xp, uint *ip)
#line 1638
{
#line 1638
	ix_double xx;
#line 1638
	get_ix_double(xp, &xx);
#line 1638
	*ip = (uint) xx;
#line 1638
	if(xx > UINT_MAX || xx < 0) return NC_ERANGE;
#line 1638
	return NC_NOERR;
#line 1638
}
#line 1638


int
ncx_get_double_ulonglong(const void *xp, unsigned long long *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	*ip = (unsigned long long) xx;
	if(xx > ULONG_LONG_MAX || xx < 0)
		return NC_ERANGE;
	return NC_NOERR;
}

static int
ncx_get_double_float(const void *xp, float *ip)
{
	double xx;
	get_ix_double(xp, &xx);
	if(xx > FLT_MAX)
	{
		*ip = FLT_MAX;
		return NC_ERANGE;
	}
	if(xx < (-FLT_MAX))
	{
		*ip = (-FLT_MAX);
		return NC_ERANGE;
	}
	*ip = (float) xx;
	return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_get_double_double(const void *xp, double *ip)
{
	/* TODO */
	get_ix_double(xp, ip);
	return NC_NOERR;
}
#endif

static int
#line 1680
ncx_put_double_schar(void *xp, const schar *ip)
#line 1680
{
#line 1680
	ix_double xx = (ix_double)*ip;
#line 1680
	put_ix_double(xp, &xx);
#line 1680

#line 1680
	return NC_NOERR;
#line 1680
}
#line 1680

static int
#line 1681
ncx_put_double_uchar(void *xp, const uchar *ip)
#line 1681
{
#line 1681
	ix_double xx = (ix_double)*ip;
#line 1681
	put_ix_double(xp, &xx);
#line 1681

#line 1681
	return NC_NOERR;
#line 1681
}
#line 1681

static int
#line 1682
ncx_put_double_short(void *xp, const short *ip)
#line 1682
{
#line 1682
	ix_double xx = (ix_double)*ip;
#line 1682
	put_ix_double(xp, &xx);
#line 1682

#line 1682
	return NC_NOERR;
#line 1682
}
#line 1682

static int
#line 1683
ncx_put_double_ushort(void *xp, const ushort *ip)
#line 1683
{
#line 1683
	ix_double xx = (ix_double)*ip;
#line 1683
	put_ix_double(xp, &xx);
#line 1683

#line 1683
	return NC_NOERR;
#line 1683
}
#line 1683

static int
#line 1684
ncx_put_double_int(void *xp, const int *ip)
#line 1684
{
#line 1684
	ix_double xx = (ix_double)*ip;
#line 1684
	put_ix_double(xp, &xx);
#line 1684

#line 1684
	return NC_NOERR;
#line 1684
}
#line 1684

static int
#line 1685
ncx_put_double_uint(void *xp, const uint *ip)
#line 1685
{
#line 1685
	ix_double xx = (ix_double)*ip;
#line 1685
	put_ix_double(xp, &xx);
#line 1685

#line 1685
	return NC_NOERR;
#line 1685
}
#line 1685

static int
#line 1686
ncx_put_double_longlong(void *xp, const longlong *ip)
#line 1686
{
#line 1686
	ix_double xx = (ix_double)*ip;
#line 1686
	put_ix_double(xp, &xx);
#line 1686

#line 1686
	return NC_NOERR;
#line 1686
}
#line 1686

static int
#line 1687
ncx_put_double_ulonglong(void *xp, const ulonglong *ip)
#line 1687
{
#line 1687
	ix_double xx = (ix_double)*ip;
#line 1687
	put_ix_double(xp, &xx);
#line 1687

#line 1687
	return NC_NOERR;
#line 1687
}
#line 1687


static int
ncx_put_double_float(void *xp, const float *ip)
{
	double xx = (double) *ip;
	put_ix_double(xp, &xx);
#if 1	/* TODO: figure this out */
	if((double)(*ip) > X_DOUBLE_MAX || (double)(*ip) < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return NC_NOERR;
}

#if X_SIZEOF_DOUBLE != SIZEOF_DOUBLE  || defined(NO_IEEE_FLOAT)
static int
ncx_put_double_double(void *xp, const double *ip)
{
	put_ix_double(xp, ip);
#ifdef NO_IEEE_FLOAT
	if(*ip > X_DOUBLE_MAX || *ip < X_DOUBLE_MIN)
		return NC_ERANGE;
#endif
	return NC_NOERR;
}
#endif


/* x_longlong ---------------------------------------------------------------------*/

#if SHORT_MAX == X_LONGLONG_MAX
typedef short ix_longlong;
#define SIZEOF_IX_LONGLONG SIZEOF_SHORT
#define IX_LONGLONG_MAX SHORT_MAX
#elif LONG_LONG_MAX  >= X_LONGLONG_MAX
typedef longlong ix_longlong;
#define SIZEOF_IX_LONGLONG SIZEOF_LONGLONG
#define IX_LONGLONG_MAX LONG_LONG_MAX
#elif LONG_MAX  >= X_LONGLONG_MAX
typedef long ix_longlong;
#define SIZEOF_IX_LONGLONG SIZEOF_LONG
#define IX_LONGLONG_MAX LONG_MAX
#else
#error "ix_longlong implementation"
#endif


static void
get_ix_longlong(const void *xp, ix_longlong *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((long long)(*cp++) << 56);
    *ip |= ((long long)(*cp++) << 48);
    *ip |= ((long long)(*cp++) << 40);
    *ip |= ((long long)(*cp++) << 32);
    *ip |= ((long long)(*cp++) << 24);
    *ip |= ((long long)(*cp++) << 16);
    *ip |= ((long long)(*cp++) <<  8);
    *ip |=  (long long)*cp;
}

static void
put_ix_longlong(void *xp, const ix_longlong *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (*ip) >> 56;
    *cp++ = ((*ip) & 0x00ff000000000000LL) >> 48;
    *cp++ = ((*ip) & 0x0000ff0000000000LL) >> 40;
    *cp++ = ((*ip) & 0x000000ff00000000LL) >> 32;
    *cp++ = ((*ip) & 0x00000000ff000000LL) >> 24;
    *cp++ = ((*ip) & 0x0000000000ff0000LL) >> 16;
    *cp++ = ((*ip) & 0x000000000000ff00LL) >>  8;
    *cp   = ((*ip) & 0x00000000000000ffLL);
}

static int
#line 1764
ncx_get_longlong_schar(const void *xp, schar *ip)
#line 1764
{
#line 1764
	ix_longlong xx;
#line 1764
	get_ix_longlong(xp, &xx);
#line 1764
	*ip = (schar) xx;
#line 1764
#if IX_LONGLONG_MAX > SCHAR_MAX
#line 1764
	if (xx > SCHAR_MAX || xx < SCHAR_MIN) return NC_ERANGE;
#line 1764
#endif
#line 1764

#line 1764
	return NC_NOERR;
#line 1764
}
#line 1764

static int
#line 1765
ncx_get_longlong_short(const void *xp, short *ip)
#line 1765
{
#line 1765
#if SIZEOF_IX_LONGLONG == SIZEOF_SHORT && IX_LONGLONG_MAX == SHORT_MAX
#line 1765
	get_ix_longlong(xp, (ix_longlong *)ip);
#line 1765
	return NC_NOERR;
#line 1765
#else
#line 1765
	ix_longlong xx;
#line 1765
	get_ix_longlong(xp, &xx);
#line 1765
	*ip = (short) xx;
#line 1765
#if IX_LONGLONG_MAX > SHORT_MAX
#line 1765
	if (xx > SHORT_MAX || xx < SHORT_MIN) return NC_ERANGE;
#line 1765
#endif
#line 1765

#line 1765
#endif
#line 1765
	return NC_NOERR;
#line 1765
}
#line 1765

static int
#line 1766
ncx_get_longlong_int(const void *xp, int *ip)
#line 1766
{
#line 1766
#if SIZEOF_IX_LONGLONG == SIZEOF_INT && IX_LONGLONG_MAX == INT_MAX
#line 1766
	get_ix_longlong(xp, (ix_longlong *)ip);
#line 1766
	return NC_NOERR;
#line 1766
#else
#line 1766
	ix_longlong xx;
#line 1766
	get_ix_longlong(xp, &xx);
#line 1766
	*ip = (int) xx;
#line 1766
#if IX_LONGLONG_MAX > INT_MAX
#line 1766
	if (xx > INT_MAX || xx < INT_MIN) return NC_ERANGE;
#line 1766
#endif
#line 1766

#line 1766
#endif
#line 1766
	return NC_NOERR;
#line 1766
}
#line 1766

static int
#line 1767
ncx_get_longlong_longlong(const void *xp, longlong *ip)
#line 1767
{
#line 1767
#if SIZEOF_IX_LONGLONG == SIZEOF_LONGLONG && IX_LONGLONG_MAX == LONGLONG_MAX
#line 1767
	get_ix_longlong(xp, (ix_longlong *)ip);
#line 1767
	return NC_NOERR;
#line 1767
#else
#line 1767
	ix_longlong xx;
#line 1767
	get_ix_longlong(xp, &xx);
#line 1767
	*ip = (longlong) xx;
#line 1767
#if IX_LONGLONG_MAX > LONGLONG_MAX
#line 1767
	if (xx > LONGLONG_MAX || xx < LONGLONG_MIN) return NC_ERANGE;
#line 1767
#endif
#line 1767

#line 1767
#endif
#line 1767
	return NC_NOERR;
#line 1767
}
#line 1767

static int
#line 1768
ncx_get_longlong_ushort(const void *xp, ushort *ip)
#line 1768
{
#line 1768
	ix_longlong xx;
#line 1768
	get_ix_longlong(xp, &xx);
#line 1768
	*ip = (ushort) xx;
#line 1768
#if IX_LONGLONG_MAX > USHORT_MAX
#line 1768
	if (xx > USHORT_MAX) return NC_ERANGE;
#line 1768
#endif
#line 1768
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 1768
	return NC_NOERR;
#line 1768
}
#line 1768

static int
#line 1769
ncx_get_longlong_uchar(const void *xp, uchar *ip)
#line 1769
{
#line 1769
	ix_longlong xx;
#line 1769
	get_ix_longlong(xp, &xx);
#line 1769
	*ip = (uchar) xx;
#line 1769
#if IX_LONGLONG_MAX > UCHAR_MAX
#line 1769
	if (xx > UCHAR_MAX) return NC_ERANGE;
#line 1769
#endif
#line 1769
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 1769
	return NC_NOERR;
#line 1769
}
#line 1769

static int
#line 1770
ncx_get_longlong_uint(const void *xp, uint *ip)
#line 1770
{
#line 1770
	ix_longlong xx;
#line 1770
	get_ix_longlong(xp, &xx);
#line 1770
	*ip = (uint) xx;
#line 1770
#if IX_LONGLONG_MAX > UINT_MAX
#line 1770
	if (xx > UINT_MAX) return NC_ERANGE;
#line 1770
#endif
#line 1770
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 1770
	return NC_NOERR;
#line 1770
}
#line 1770

static int
#line 1771
ncx_get_longlong_ulonglong(const void *xp, ulonglong *ip)
#line 1771
{
#line 1771
	ix_longlong xx;
#line 1771
	get_ix_longlong(xp, &xx);
#line 1771
	*ip = (ulonglong) xx;
#line 1771
#if IX_LONGLONG_MAX > ULONGLONG_MAX
#line 1771
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#line 1771
#endif
#line 1771
	if (xx < 0) return NC_ERANGE; /* because ip is unsigned */
#line 1771
	return NC_NOERR;
#line 1771
}
#line 1771

static int
#line 1772
ncx_get_longlong_float(const void *xp, float *ip)
#line 1772
{
#line 1772
	ix_longlong xx;
#line 1772
	get_ix_longlong(xp, &xx);
#line 1772
	*ip = (float) xx;
#line 1772

#line 1772
	return NC_NOERR;
#line 1772
}
#line 1772

static int
#line 1773
ncx_get_longlong_double(const void *xp, double *ip)
#line 1773
{
#line 1773
	ix_longlong xx;
#line 1773
	get_ix_longlong(xp, &xx);
#line 1773
	*ip = (double) xx;
#line 1773

#line 1773
	return NC_NOERR;
#line 1773
}
#line 1773


static int
#line 1775
ncx_put_longlong_schar(void *xp, const schar *ip)
#line 1775
{
#line 1775
	ix_longlong xx = (ix_longlong)*ip;
#line 1775
	put_ix_longlong(xp, &xx);
#line 1775
#if IX_LONGLONG_MAX < SCHAR_MAX
#line 1775
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#line 1775
#endif
#line 1775

#line 1775
	return NC_NOERR;
#line 1775
}
#line 1775

static int
#line 1776
ncx_put_longlong_short(void *xp, const short *ip)
#line 1776
{
#line 1776
#if SIZEOF_IX_LONGLONG == SIZEOF_SHORT && IX_LONGLONG_MAX == SHORT_MAX
#line 1776
	put_ix_longlong(xp, (const ix_longlong *)ip);
#line 1776
	return NC_NOERR;
#line 1776
#else
#line 1776
	ix_longlong xx = (ix_longlong)*ip;
#line 1776
	put_ix_longlong(xp, &xx);
#line 1776
#if IX_LONGLONG_MAX < SHORT_MAX
#line 1776
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#line 1776
#endif
#line 1776

#line 1776
#endif
#line 1776
	return NC_NOERR;
#line 1776
}
#line 1776

static int
#line 1777
ncx_put_longlong_int(void *xp, const int *ip)
#line 1777
{
#line 1777
#if SIZEOF_IX_LONGLONG == SIZEOF_INT && IX_LONGLONG_MAX == INT_MAX
#line 1777
	put_ix_longlong(xp, (const ix_longlong *)ip);
#line 1777
	return NC_NOERR;
#line 1777
#else
#line 1777
	ix_longlong xx = (ix_longlong)*ip;
#line 1777
	put_ix_longlong(xp, &xx);
#line 1777
#if IX_LONGLONG_MAX < INT_MAX
#line 1777
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#line 1777
#endif
#line 1777

#line 1777
#endif
#line 1777
	return NC_NOERR;
#line 1777
}
#line 1777

static int
#line 1778
ncx_put_longlong_longlong(void *xp, const longlong *ip)
#line 1778
{
#line 1778
#if SIZEOF_IX_LONGLONG == SIZEOF_LONGLONG && IX_LONGLONG_MAX == LONGLONG_MAX
#line 1778
	put_ix_longlong(xp, (const ix_longlong *)ip);
#line 1778
	return NC_NOERR;
#line 1778
#else
#line 1778
	ix_longlong xx = (ix_longlong)*ip;
#line 1778
	put_ix_longlong(xp, &xx);
#line 1778
#if IX_LONGLONG_MAX < LONGLONG_MAX
#line 1778
	if (*ip > IX_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#line 1778
#endif
#line 1778

#line 1778
#endif
#line 1778
	return NC_NOERR;
#line 1778
}
#line 1778

static int
#line 1779
ncx_put_longlong_ushort(void *xp, const ushort *ip)
#line 1779
{
#line 1779
	ix_longlong xx = (ix_longlong)*ip;
#line 1779
	put_ix_longlong(xp, &xx);
#line 1779
#if IX_LONGLONG_MAX < USHORT_MAX
#line 1779
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#line 1779
#endif
#line 1779

#line 1779
	return NC_NOERR;
#line 1779
}
#line 1779

static int
#line 1780
ncx_put_longlong_uchar(void *xp, const uchar *ip)
#line 1780
{
#line 1780
	ix_longlong xx = (ix_longlong)*ip;
#line 1780
	put_ix_longlong(xp, &xx);
#line 1780
#if IX_LONGLONG_MAX < UCHAR_MAX
#line 1780
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#line 1780
#endif
#line 1780

#line 1780
	return NC_NOERR;
#line 1780
}
#line 1780

static int
#line 1781
ncx_put_longlong_uint(void *xp, const uint *ip)
#line 1781
{
#line 1781
	ix_longlong xx = (ix_longlong)*ip;
#line 1781
	put_ix_longlong(xp, &xx);
#line 1781
#if IX_LONGLONG_MAX < UINT_MAX
#line 1781
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#line 1781
#endif
#line 1781

#line 1781
	return NC_NOERR;
#line 1781
}
#line 1781

static int
#line 1782
ncx_put_longlong_ulonglong(void *xp, const ulonglong *ip)
#line 1782
{
#line 1782
	ix_longlong xx = (ix_longlong)*ip;
#line 1782
	put_ix_longlong(xp, &xx);
#line 1782
#if IX_LONGLONG_MAX < ULONGLONG_MAX
#line 1782
	if (*ip > IX_LONGLONG_MAX) return NC_ERANGE;
#line 1782
#endif
#line 1782

#line 1782
	return NC_NOERR;
#line 1782
}
#line 1782

static int
#line 1783
ncx_put_longlong_float(void *xp, const float *ip)
#line 1783
{
#line 1783
	ix_longlong xx = (ix_longlong)*ip;
#line 1783
	put_ix_longlong(xp, &xx);
#line 1783
	if(*ip > (double)X_LONGLONG_MAX || *ip < (double)X_LONGLONG_MIN) return NC_ERANGE;
#line 1783
	return NC_NOERR;
#line 1783
}
#line 1783

static int
#line 1784
ncx_put_longlong_double(void *xp, const double *ip)
#line 1784
{
#line 1784
	ix_longlong xx = (ix_longlong)*ip;
#line 1784
	put_ix_longlong(xp, &xx);
#line 1784
	if(*ip > X_LONGLONG_MAX || *ip < X_LONGLONG_MIN) return NC_ERANGE;
#line 1784
	return NC_NOERR;
#line 1784
}
#line 1784


/* x_ulonglong --------------------------------------------------------------------*/

#if USHORT_MAX == X_ULONGLONG_MAX
typedef ushort ix_ulonglong;
#define SIZEOF_IX_ULONGLONG SIZEOF_USHORT
#define IX_ULONGLONG_MAX USHORT_MAX
#elif ULONG_LONG_MAX  >= X_ULONGLONG_MAX
typedef ulonglong ix_ulonglong;
#define SIZEOF_IX_ULONGLONG SIZEOF_ULONGLONG
#define IX_ULONGLONG_MAX ULONG_LONG_MAX
#elif ULONG_MAX  >= X_ULONGLONG_MAX
typedef ulong ix_ulonglong;
#define SIZEOF_IX_ULONGLONG SIZEOF_ULONG
#define IX_ULONGLONG_MAX ULONG_MAX
#else
#error "ix_ulonglong implementation"
#endif


static void
get_ix_ulonglong(const void *xp, ix_ulonglong *ip)
{
    const uchar *cp = (const uchar *) xp;

    *ip  = ((unsigned long long)(*cp++) << 56);
    *ip |= ((unsigned long long)(*cp++) << 48);
    *ip |= ((unsigned long long)(*cp++) << 40);
    *ip |= ((unsigned long long)(*cp++) << 32);
    *ip |= ((unsigned long long)(*cp++) << 24);
    *ip |= ((unsigned long long)(*cp++) << 16);
    *ip |= ((unsigned long long)(*cp++) <<  8);
    *ip |=  (unsigned long long)*cp;
}

static void
put_ix_ulonglong(void *xp, const ix_ulonglong *ip)
{
    uchar *cp = (uchar *) xp;

    *cp++ = (*ip) >> 56;
    *cp++ = ((*ip) & 0x00ff000000000000ULL) >> 48;
    *cp++ = ((*ip) & 0x0000ff0000000000ULL) >> 40;
    *cp++ = ((*ip) & 0x000000ff00000000ULL) >> 32;
    *cp++ = ((*ip) & 0x00000000ff000000ULL) >> 24;
    *cp++ = ((*ip) & 0x0000000000ff0000ULL) >> 16;
    *cp++ = ((*ip) & 0x000000000000ff00ULL) >>  8;
    *cp   = ((*ip) & 0x00000000000000ffULL);
}

static int
#line 1835
ncx_get_ulonglong_schar(const void *xp, schar *ip)
#line 1835
{
#line 1835
	ix_ulonglong xx;
#line 1835
	get_ix_ulonglong(xp, &xx);
#line 1835
	*ip = (schar) xx;
#line 1835
#if IX_ULONGLONG_MAX > SCHAR_MAX
#line 1835
	if (xx > SCHAR_MAX) return NC_ERANGE;
#line 1835
#endif
#line 1835

#line 1835
	return NC_NOERR;
#line 1835
}
#line 1835

static int
#line 1836
ncx_get_ulonglong_short(const void *xp, short *ip)
#line 1836
{
#line 1836
	ix_ulonglong xx;
#line 1836
	get_ix_ulonglong(xp, &xx);
#line 1836
	*ip = (short) xx;
#line 1836
#if IX_ULONGLONG_MAX > SHORT_MAX
#line 1836
	if (xx > SHORT_MAX) return NC_ERANGE;
#line 1836
#endif
#line 1836

#line 1836
	return NC_NOERR;
#line 1836
}
#line 1836

static int
#line 1837
ncx_get_ulonglong_int(const void *xp, int *ip)
#line 1837
{
#line 1837
	ix_ulonglong xx;
#line 1837
	get_ix_ulonglong(xp, &xx);
#line 1837
	*ip = (int) xx;
#line 1837
#if IX_ULONGLONG_MAX > INT_MAX
#line 1837
	if (xx > INT_MAX) return NC_ERANGE;
#line 1837
#endif
#line 1837

#line 1837
	return NC_NOERR;
#line 1837
}
#line 1837

static int
#line 1838
ncx_get_ulonglong_longlong(const void *xp, longlong *ip)
#line 1838
{
#line 1838
	ix_ulonglong xx;
#line 1838
	get_ix_ulonglong(xp, &xx);
#line 1838
	*ip = (longlong) xx;
#line 1838
#if IX_ULONGLONG_MAX > LONGLONG_MAX
#line 1838
	if (xx > LONGLONG_MAX) return NC_ERANGE;
#line 1838
#endif
#line 1838

#line 1838
	return NC_NOERR;
#line 1838
}
#line 1838

static int
#line 1839
ncx_get_ulonglong_ushort(const void *xp, ushort *ip)
#line 1839
{
#line 1839
#if SIZEOF_IX_ULONGLONG == SIZEOF_USHORT && IX_ULONGLONG_MAX == USHORT_MAX
#line 1839
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
#line 1839
	return NC_NOERR;
#line 1839
#else
#line 1839
	ix_ulonglong xx;
#line 1839
	get_ix_ulonglong(xp, &xx);
#line 1839
	*ip = (ushort) xx;
#line 1839
#if IX_ULONGLONG_MAX > USHORT_MAX
#line 1839
	if (xx > USHORT_MAX) return NC_ERANGE;
#line 1839
#endif
#line 1839

#line 1839
#endif
#line 1839
	return NC_NOERR;
#line 1839
}
#line 1839

static int
#line 1840
ncx_get_ulonglong_uchar(const void *xp, uchar *ip)
#line 1840
{
#line 1840
#if SIZEOF_IX_ULONGLONG == SIZEOF_UCHAR && IX_ULONGLONG_MAX == UCHAR_MAX
#line 1840
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
#line 1840
	return NC_NOERR;
#line 1840
#else
#line 1840
	ix_ulonglong xx;
#line 1840
	get_ix_ulonglong(xp, &xx);
#line 1840
	*ip = (uchar) xx;
#line 1840
#if IX_ULONGLONG_MAX > UCHAR_MAX
#line 1840
	if (xx > UCHAR_MAX) return NC_ERANGE;
#line 1840
#endif
#line 1840

#line 1840
#endif
#line 1840
	return NC_NOERR;
#line 1840
}
#line 1840

static int
#line 1841
ncx_get_ulonglong_uint(const void *xp, uint *ip)
#line 1841
{
#line 1841
#if SIZEOF_IX_ULONGLONG == SIZEOF_UINT && IX_ULONGLONG_MAX == UINT_MAX
#line 1841
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
#line 1841
	return NC_NOERR;
#line 1841
#else
#line 1841
	ix_ulonglong xx;
#line 1841
	get_ix_ulonglong(xp, &xx);
#line 1841
	*ip = (uint) xx;
#line 1841
#if IX_ULONGLONG_MAX > UINT_MAX
#line 1841
	if (xx > UINT_MAX) return NC_ERANGE;
#line 1841
#endif
#line 1841

#line 1841
#endif
#line 1841
	return NC_NOERR;
#line 1841
}
#line 1841

static int
#line 1842
ncx_get_ulonglong_ulonglong(const void *xp, ulonglong *ip)
#line 1842
{
#line 1842
#if SIZEOF_IX_ULONGLONG == SIZEOF_ULONGLONG && IX_ULONGLONG_MAX == ULONGLONG_MAX
#line 1842
	get_ix_ulonglong(xp, (ix_ulonglong *)ip);
#line 1842
	return NC_NOERR;
#line 1842
#else
#line 1842
	ix_ulonglong xx;
#line 1842
	get_ix_ulonglong(xp, &xx);
#line 1842
	*ip = (ulonglong) xx;
#line 1842
#if IX_ULONGLONG_MAX > ULONGLONG_MAX
#line 1842
	if (xx > ULONGLONG_MAX) return NC_ERANGE;
#line 1842
#endif
#line 1842

#line 1842
#endif
#line 1842
	return NC_NOERR;
#line 1842
}
#line 1842

static int
#line 1843
ncx_get_ulonglong_float(const void *xp, float *ip)
#line 1843
{
#line 1843
	ix_ulonglong xx;
#line 1843
	get_ix_ulonglong(xp, &xx);
#line 1843
	*ip = (float) xx;
#line 1843

#line 1843
	return NC_NOERR;
#line 1843
}
#line 1843

static int
#line 1844
ncx_get_ulonglong_double(const void *xp, double *ip)
#line 1844
{
#line 1844
	ix_ulonglong xx;
#line 1844
	get_ix_ulonglong(xp, &xx);
#line 1844
	*ip = (double) xx;
#line 1844

#line 1844
	return NC_NOERR;
#line 1844
}
#line 1844


static int
#line 1846
ncx_put_ulonglong_schar(void *xp, const schar *ip)
#line 1846
{
#line 1846
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1846
	put_ix_ulonglong(xp, &xx);
#line 1846
#if IX_ULONGLONG_MAX < SCHAR_MAX
#line 1846
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1846
#endif
#line 1846
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 1846
	return NC_NOERR;
#line 1846
}
#line 1846

static int
#line 1847
ncx_put_ulonglong_short(void *xp, const short *ip)
#line 1847
{
#line 1847
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1847
	put_ix_ulonglong(xp, &xx);
#line 1847
#if IX_ULONGLONG_MAX < SHORT_MAX
#line 1847
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1847
#endif
#line 1847
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 1847
	return NC_NOERR;
#line 1847
}
#line 1847

static int
#line 1848
ncx_put_ulonglong_int(void *xp, const int *ip)
#line 1848
{
#line 1848
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1848
	put_ix_ulonglong(xp, &xx);
#line 1848
#if IX_ULONGLONG_MAX < INT_MAX
#line 1848
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1848
#endif
#line 1848
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 1848
	return NC_NOERR;
#line 1848
}
#line 1848

static int
#line 1849
ncx_put_ulonglong_longlong(void *xp, const longlong *ip)
#line 1849
{
#line 1849
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1849
	put_ix_ulonglong(xp, &xx);
#line 1849
#if IX_ULONGLONG_MAX < LONGLONG_MAX
#line 1849
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1849
#endif
#line 1849
	if (*ip < 0) return NC_ERANGE; /* because xp is unsigned */
#line 1849
	return NC_NOERR;
#line 1849
}
#line 1849

static int
#line 1850
ncx_put_ulonglong_uchar(void *xp, const uchar *ip)
#line 1850
{
#line 1850
#if SIZEOF_IX_ULONGLONG == SIZEOF_UCHAR && IX_ULONGLONG_MAX == UCHAR_MAX
#line 1850
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
#line 1850
	return NC_NOERR;
#line 1850
#else
#line 1850
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1850
	put_ix_ulonglong(xp, &xx);
#line 1850
#if IX_ULONGLONG_MAX < UCHAR_MAX
#line 1850
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1850
#endif
#line 1850

#line 1850
#endif
#line 1850
	return NC_NOERR;
#line 1850
}
#line 1850

static int
#line 1851
ncx_put_ulonglong_ushort(void *xp, const ushort *ip)
#line 1851
{
#line 1851
#if SIZEOF_IX_ULONGLONG == SIZEOF_USHORT && IX_ULONGLONG_MAX == USHORT_MAX
#line 1851
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
#line 1851
	return NC_NOERR;
#line 1851
#else
#line 1851
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1851
	put_ix_ulonglong(xp, &xx);
#line 1851
#if IX_ULONGLONG_MAX < USHORT_MAX
#line 1851
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1851
#endif
#line 1851

#line 1851
#endif
#line 1851
	return NC_NOERR;
#line 1851
}
#line 1851

static int
#line 1852
ncx_put_ulonglong_uint(void *xp, const uint *ip)
#line 1852
{
#line 1852
#if SIZEOF_IX_ULONGLONG == SIZEOF_UINT && IX_ULONGLONG_MAX == UINT_MAX
#line 1852
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
#line 1852
	return NC_NOERR;
#line 1852
#else
#line 1852
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1852
	put_ix_ulonglong(xp, &xx);
#line 1852
#if IX_ULONGLONG_MAX < UINT_MAX
#line 1852
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1852
#endif
#line 1852

#line 1852
#endif
#line 1852
	return NC_NOERR;
#line 1852
}
#line 1852

static int
#line 1853
ncx_put_ulonglong_ulonglong(void *xp, const ulonglong *ip)
#line 1853
{
#line 1853
#if SIZEOF_IX_ULONGLONG == SIZEOF_ULONGLONG && IX_ULONGLONG_MAX == ULONGLONG_MAX
#line 1853
	put_ix_ulonglong(xp, (const ix_ulonglong *)ip);
#line 1853
	return NC_NOERR;
#line 1853
#else
#line 1853
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1853
	put_ix_ulonglong(xp, &xx);
#line 1853
#if IX_ULONGLONG_MAX < ULONGLONG_MAX
#line 1853
	if (*ip > IX_ULONGLONG_MAX) return NC_ERANGE;
#line 1853
#endif
#line 1853

#line 1853
#endif
#line 1853
	return NC_NOERR;
#line 1853
}
#line 1853

static int
#line 1854
ncx_put_ulonglong_float(void *xp, const float *ip)
#line 1854
{
#line 1854
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1854
	put_ix_ulonglong(xp, &xx);
#line 1854
	if(*ip > (double)X_ULONGLONG_MAX || *ip < 0) return NC_ERANGE;
#line 1854
	return NC_NOERR;
#line 1854
}
#line 1854

static int
#line 1855
ncx_put_ulonglong_double(void *xp, const double *ip)
#line 1855
{
#line 1855
	ix_ulonglong xx = (ix_ulonglong)*ip;
#line 1855
	put_ix_ulonglong(xp, &xx);
#line 1855
	if(*ip > X_ULONGLONG_MAX || *ip < 0) return NC_ERANGE;
#line 1855
	return NC_NOERR;
#line 1855
}
#line 1855


/* x_size_t */

#if SIZEOF_SIZE_T < X_SIZEOF_SIZE_T
#error "x_size_t implementation"
/* netcdf requires size_t which can hold a values from 0 to 2^32 -1 */
#endif

int
ncx_put_size_t(void **xpp, const size_t *ulp)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
	assert(*ulp <= X_SIZE_MAX);

	*cp++ = (uchar)((*ulp) >> 24);
	*cp++ = (uchar)(((*ulp) & 0x00ff0000) >> 16);
	*cp++ = (uchar)(((*ulp) & 0x0000ff00) >>  8);
	*cp   = (uchar)((*ulp) & 0x000000ff);

	*xpp = (void *)((char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

int
ncx_get_size_t(const void **xpp,  size_t *ulp)
{
	/* similar to get_ix_int */
	const uchar *cp = (const uchar *) *xpp;

	*ulp = (unsigned)(*cp++ << 24);
	*ulp |= (*cp++ << 16);
	*ulp |= (*cp++ << 8);
	*ulp |= *cp;

	*xpp = (const void *)((const char *)(*xpp) + X_SIZEOF_SIZE_T);
	return NC_NOERR;
}

/* x_off_t */

int
ncx_put_off_t(void **xpp, const off_t *lp, size_t sizeof_off_t)
{
	/* similar to put_ix_int() */
	uchar *cp = (uchar *) *xpp;
		/* No negative offsets stored in netcdf */
	if (*lp < 0) {
	  /* Assume this is an overflow of a 32-bit int... */
	  return NC_ERANGE;
	}

	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

	if (sizeof_off_t == 4) {
		*cp++ = (uchar) ((*lp)               >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
	} else {
#if SIZEOF_OFF_T == 4
/* Write a 64-bit offset on a system with only a 32-bit offset */
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;
		*cp++ = (uchar)0;

		*cp++ = (uchar)(((*lp) & 0xff000000) >> 24);
		*cp++ = (uchar)(((*lp) & 0x00ff0000) >> 16);
		*cp++ = (uchar)(((*lp) & 0x0000ff00) >>  8);
		*cp   = (uchar)( (*lp) & 0x000000ff);
#else
		*cp++ = (uchar) ((*lp)                          >> 56);
		*cp++ = (uchar)(((*lp) & 0x00ff000000000000ULL) >> 48);
		*cp++ = (uchar)(((*lp) & 0x0000ff0000000000ULL) >> 40);
		*cp++ = (uchar)(((*lp) & 0x000000ff00000000ULL) >> 32);
		*cp++ = (uchar)(((*lp) & 0x00000000ff000000ULL) >> 24);
		*cp++ = (uchar)(((*lp) & 0x0000000000ff0000ULL) >> 16);
		*cp++ = (uchar)(((*lp) & 0x000000000000ff00ULL) >>  8);
		*cp   = (uchar)( (*lp) & 0x00000000000000ffULL);
#endif
	}
	*xpp = (void *)((char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

int
ncx_get_off_t(const void **xpp, off_t *lp, size_t sizeof_off_t)
{
	/* similar to get_ix_int() */
	const uchar *cp = (const uchar *) *xpp;
	assert(sizeof_off_t == 4 || sizeof_off_t == 8);

 	if (sizeof_off_t == 4) {
		*lp =  (off_t)(*cp++ << 24);
		*lp |= (off_t)(*cp++ << 16);
		*lp |= (off_t)(*cp++ <<  8);
		*lp |= (off_t)*cp;
	} else {
#if SIZEOF_OFF_T == 4
/* Read a 64-bit offset on a system with only a 32-bit offset */
/* If the offset overflows, set an error code and return */
		*lp =  ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |= ((off_t)(*cp++));
/*
 * lp now contains the upper 32-bits of the 64-bit offset.  if lp is
 * not zero, then the dataset is larger than can be represented
 * on this system.  Set an error code and return.
 */
		if (*lp != 0) {
		  return NC_ERANGE;
		}

		*lp  = ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;

		if (*lp < 0) {
		  /*
		   * If this fails, then the offset is >2^31, but less
		   * than 2^32 which is not allowed, but is not caught
		   * by the previous check
		   */
		  return NC_ERANGE;
		}
#else
		*lp =  ((off_t)(*cp++) << 56);
		*lp |= ((off_t)(*cp++) << 48);
		*lp |= ((off_t)(*cp++) << 40);
		*lp |= ((off_t)(*cp++) << 32);
		*lp |= ((off_t)(*cp++) << 24);
		*lp |= ((off_t)(*cp++) << 16);
		*lp |= ((off_t)(*cp++) <<  8);
		*lp |=  (off_t)*cp;
#endif
	}
	*xpp = (const void *)((const char *)(*xpp) + sizeof_off_t);
	return NC_NOERR;
}

/*----< ncx_get_int32() >--------------------------------------------------*/
int
ncx_get_int32(const void **xpp,
              int         *ip)
{
    const uchar *cp = (const uchar *) *xpp;

    /* cannot call swap4b(), as lp is 8-byte */
    *ip  = (*cp++ << 24);
    *ip |= (*cp++ << 16);
    *ip |= (*cp++ <<  8);
    *ip |=  *cp;

    /* advance *xpp 4 bytes */
    *xpp = (void *)((const char *)(*xpp) + 4);

    return NC_NOERR;
}

/*----< ncx_get_int64() >-------------------------------------------------*/
int
ncx_get_int64(const void **xpp,
              long long   *llp)
{
    const uchar *cp = (const uchar *) *xpp;

    /* below is the same as calling swap8b(llp, *xpp) */
    *llp  = ((long long)(*cp++) << 56);
    *llp |= ((long long)(*cp++) << 48);
    *llp |= ((long long)(*cp++) << 40);
    *llp |= ((long long)(*cp++) << 32);
    *llp |= ((long long)(*cp++) << 24);
    *llp |= ((long long)(*cp++) << 16);
    *llp |= ((long long)(*cp++) <<  8);
    *llp |=  (long long)*cp;

    /* advance *xpp 8 bytes */
    *xpp = (void *)((const char *)(*xpp) + 8);

    return NC_NOERR;
}

/*---< ncx_put_int32() >-----------------------------------------------------*/
/* copy the contents of lp (a signed 32-bit integer) to xpp in Big Endian
 * form and advance *xpp 4 bytes
 */
int
ncx_put_int32(void      **xpp,
              const int   ip)
{
#ifdef WORDS_BIGENDIAN
    int *ptr = (int*) (*xpp); /* typecast to 4-byte integer */
    *ptr = ip;
#else
    /* bitwise shifts below are to produce an integer in Big Endian */
    /* cannot call swap4b(), as lp is 8-byte */
    uchar *cp = (uchar *) *xpp;
    *cp++ = (uchar)((ip & 0xff000000) >> 24);
    *cp++ = (uchar)((ip & 0x00ff0000) >> 16);
    *cp++ = (uchar)((ip & 0x0000ff00) >>  8);
    *cp   = (uchar)( ip & 0x000000ff);
#endif
    /* advance *xpp 4 bytes */
    *xpp  = (void *)((char *)(*xpp) + 4);

    return NC_NOERR;
}

/*---< ncx_put_int64() >-----------------------------------------------------*/
/* copy the contents of lp (a signed 64-bit integer) to xpp in Big Endian
 * form and advance *xpp 8 bytes
 */
int
ncx_put_int64(void             **xpp,
              const long long    ip)
{
#ifdef WORDS_BIGENDIAN
    long long *ptr = (long long*) (*xpp); /* typecast to 8-byte integer */
    *ptr = ip;
#else
    uchar *cp = (uchar *) *xpp;
    /* below is the same as calling swap8b(*xpp, &ip) */
    *cp++ = (uchar)((ip & 0xff00000000000000ULL) >> 56);
    *cp++ = (uchar)((ip & 0x00ff000000000000ULL) >> 48);
    *cp++ = (uchar)((ip & 0x0000ff0000000000ULL) >> 40);
    *cp++ = (uchar)((ip & 0x000000ff00000000ULL) >> 32);
    *cp++ = (uchar)((ip & 0x00000000ff000000ULL) >> 24);
    *cp++ = (uchar)((ip & 0x0000000000ff0000ULL) >> 16);
    *cp++ = (uchar)((ip & 0x000000000000ff00ULL) >>  8);
    *cp   = (uchar)( ip & 0x00000000000000ffULL);
#endif
    /* advance *xpp 8 bytes */
    *xpp  = (void *)((char *)(*xpp) + 8);

    return NC_NOERR;
}


/*
 * Aggregate numeric conversion functions.
 */
#line 2103

#line 2539

#line 2545

/* schar ---------------------------------------------------------------------*/

#line 2549
int
ncx_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
#line 2552
	*xpp = (void *)((schar *)(*xpp) + nelems);
#line 2552
	return NC_NOERR;
#line 2552

}
#line 2555
int
ncx_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
#line 2558
	*xpp = (void *)((schar *)(*xpp) + nelems);
#line 2558
	return NC_NOERR;
#line 2558

}
int
#line 2560
ncx_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2560
{
#line 2560
	int status = NC_NOERR;
#line 2560
	schar *xp = (schar *)(*xpp);
#line 2560

#line 2560
	while(nelems-- != 0)
#line 2560
	{
#line 2560

#line 2560
		*tp++ = *xp++;
#line 2560
	}
#line 2560

#line 2560
	*xpp = (const void *)xp;
#line 2560
	return status;
#line 2560
}
#line 2560

int
#line 2561
ncx_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2561
{
#line 2561
	int status = NC_NOERR;
#line 2561
	schar *xp = (schar *)(*xpp);
#line 2561

#line 2561
	while(nelems-- != 0)
#line 2561
	{
#line 2561

#line 2561
		*tp++ = *xp++;
#line 2561
	}
#line 2561

#line 2561
	*xpp = (const void *)xp;
#line 2561
	return status;
#line 2561
}
#line 2561

int
#line 2562
ncx_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2562
{
#line 2562
	int status = NC_NOERR;
#line 2562
	schar *xp = (schar *)(*xpp);
#line 2562

#line 2562
	while(nelems-- != 0)
#line 2562
	{
#line 2562

#line 2562
		*tp++ = *xp++;
#line 2562
	}
#line 2562

#line 2562
	*xpp = (const void *)xp;
#line 2562
	return status;
#line 2562
}
#line 2562

int
#line 2563
ncx_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2563
{
#line 2563
	int status = NC_NOERR;
#line 2563
	schar *xp = (schar *)(*xpp);
#line 2563

#line 2563
	while(nelems-- != 0)
#line 2563
	{
#line 2563

#line 2563
		*tp++ = *xp++;
#line 2563
	}
#line 2563

#line 2563
	*xpp = (const void *)xp;
#line 2563
	return status;
#line 2563
}
#line 2563

int
#line 2564
ncx_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2564
{
#line 2564
	int status = NC_NOERR;
#line 2564
	schar *xp = (schar *)(*xpp);
#line 2564

#line 2564
	while(nelems-- != 0)
#line 2564
	{
#line 2564

#line 2564
		*tp++ = *xp++;
#line 2564
	}
#line 2564

#line 2564
	*xpp = (const void *)xp;
#line 2564
	return status;
#line 2564
}
#line 2564

int
#line 2565
ncx_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2565
{
#line 2565
	int status = NC_NOERR;
#line 2565
	schar *xp = (schar *)(*xpp);
#line 2565

#line 2565
	while(nelems-- != 0)
#line 2565
	{
#line 2565
		if (*xp < 0) status = NC_ERANGE;
#line 2565
		*tp++ = *xp++;
#line 2565
	}
#line 2565

#line 2565
	*xpp = (const void *)xp;
#line 2565
	return status;
#line 2565
}
#line 2565

int
#line 2566
ncx_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2566
{
#line 2566
	int status = NC_NOERR;
#line 2566
	schar *xp = (schar *)(*xpp);
#line 2566

#line 2566
	while(nelems-- != 0)
#line 2566
	{
#line 2566
		if (*xp < 0) status = NC_ERANGE;
#line 2566
		*tp++ = *xp++;
#line 2566
	}
#line 2566

#line 2566
	*xpp = (const void *)xp;
#line 2566
	return status;
#line 2566
}
#line 2566

int
#line 2567
ncx_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2567
{
#line 2567
	int status = NC_NOERR;
#line 2567
	schar *xp = (schar *)(*xpp);
#line 2567

#line 2567
	while(nelems-- != 0)
#line 2567
	{
#line 2567
		if (*xp < 0) status = NC_ERANGE;
#line 2567
		*tp++ = *xp++;
#line 2567
	}
#line 2567

#line 2567
	*xpp = (const void *)xp;
#line 2567
	return status;
#line 2567
}
#line 2567


#line 2570
int
ncx_pad_getn_schar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2573

#line 2573
	if(rndup)
#line 2573
		rndup = X_ALIGN - rndup;
#line 2573

#line 2573
	(void) memcpy(tp, *xpp, nelems);
#line 2573
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2573

#line 2573
	return NC_NOERR;
#line 2573

}
#line 2576
int
ncx_pad_getn_schar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2579

#line 2579
	if(rndup)
#line 2579
		rndup = X_ALIGN - rndup;
#line 2579

#line 2579
	(void) memcpy(tp, *xpp, nelems);
#line 2579
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2579

#line 2579
	return NC_NOERR;
#line 2579

}
int
#line 2581
ncx_pad_getn_schar_short(const void **xpp, size_t nelems, short *tp)
#line 2581
{
#line 2581
	int status = NC_NOERR;
#line 2581
	size_t rndup = nelems % X_ALIGN;
#line 2581
	schar *xp = (schar *) *xpp;
#line 2581

#line 2581
	if(rndup)
#line 2581
		rndup = X_ALIGN - rndup;
#line 2581

#line 2581
	while(nelems-- != 0)
#line 2581
	{
#line 2581

#line 2581
		*tp++ = *xp++;
#line 2581
	}
#line 2581

#line 2581
	*xpp = (void *)(xp + rndup);
#line 2581
	return status;
#line 2581
}
#line 2581

int
#line 2582
ncx_pad_getn_schar_int(const void **xpp, size_t nelems, int *tp)
#line 2582
{
#line 2582
	int status = NC_NOERR;
#line 2582
	size_t rndup = nelems % X_ALIGN;
#line 2582
	schar *xp = (schar *) *xpp;
#line 2582

#line 2582
	if(rndup)
#line 2582
		rndup = X_ALIGN - rndup;
#line 2582

#line 2582
	while(nelems-- != 0)
#line 2582
	{
#line 2582

#line 2582
		*tp++ = *xp++;
#line 2582
	}
#line 2582

#line 2582
	*xpp = (void *)(xp + rndup);
#line 2582
	return status;
#line 2582
}
#line 2582

int
#line 2583
ncx_pad_getn_schar_float(const void **xpp, size_t nelems, float *tp)
#line 2583
{
#line 2583
	int status = NC_NOERR;
#line 2583
	size_t rndup = nelems % X_ALIGN;
#line 2583
	schar *xp = (schar *) *xpp;
#line 2583

#line 2583
	if(rndup)
#line 2583
		rndup = X_ALIGN - rndup;
#line 2583

#line 2583
	while(nelems-- != 0)
#line 2583
	{
#line 2583

#line 2583
		*tp++ = *xp++;
#line 2583
	}
#line 2583

#line 2583
	*xpp = (void *)(xp + rndup);
#line 2583
	return status;
#line 2583
}
#line 2583

int
#line 2584
ncx_pad_getn_schar_double(const void **xpp, size_t nelems, double *tp)
#line 2584
{
#line 2584
	int status = NC_NOERR;
#line 2584
	size_t rndup = nelems % X_ALIGN;
#line 2584
	schar *xp = (schar *) *xpp;
#line 2584

#line 2584
	if(rndup)
#line 2584
		rndup = X_ALIGN - rndup;
#line 2584

#line 2584
	while(nelems-- != 0)
#line 2584
	{
#line 2584

#line 2584
		*tp++ = *xp++;
#line 2584
	}
#line 2584

#line 2584
	*xpp = (void *)(xp + rndup);
#line 2584
	return status;
#line 2584
}
#line 2584

int
#line 2585
ncx_pad_getn_schar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2585
{
#line 2585
	int status = NC_NOERR;
#line 2585
	size_t rndup = nelems % X_ALIGN;
#line 2585
	schar *xp = (schar *) *xpp;
#line 2585

#line 2585
	if(rndup)
#line 2585
		rndup = X_ALIGN - rndup;
#line 2585

#line 2585
	while(nelems-- != 0)
#line 2585
	{
#line 2585

#line 2585
		*tp++ = *xp++;
#line 2585
	}
#line 2585

#line 2585
	*xpp = (void *)(xp + rndup);
#line 2585
	return status;
#line 2585
}
#line 2585

int
#line 2586
ncx_pad_getn_schar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2586
{
#line 2586
	int status = NC_NOERR;
#line 2586
	size_t rndup = nelems % X_ALIGN;
#line 2586
	schar *xp = (schar *) *xpp;
#line 2586

#line 2586
	if(rndup)
#line 2586
		rndup = X_ALIGN - rndup;
#line 2586

#line 2586
	while(nelems-- != 0)
#line 2586
	{
#line 2586
		if (*xp < 0) status = NC_ERANGE;
#line 2586
		*tp++ = *xp++;
#line 2586
	}
#line 2586

#line 2586
	*xpp = (void *)(xp + rndup);
#line 2586
	return status;
#line 2586
}
#line 2586

int
#line 2587
ncx_pad_getn_schar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2587
{
#line 2587
	int status = NC_NOERR;
#line 2587
	size_t rndup = nelems % X_ALIGN;
#line 2587
	schar *xp = (schar *) *xpp;
#line 2587

#line 2587
	if(rndup)
#line 2587
		rndup = X_ALIGN - rndup;
#line 2587

#line 2587
	while(nelems-- != 0)
#line 2587
	{
#line 2587
		if (*xp < 0) status = NC_ERANGE;
#line 2587
		*tp++ = *xp++;
#line 2587
	}
#line 2587

#line 2587
	*xpp = (void *)(xp + rndup);
#line 2587
	return status;
#line 2587
}
#line 2587

int
#line 2588
ncx_pad_getn_schar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2588
{
#line 2588
	int status = NC_NOERR;
#line 2588
	size_t rndup = nelems % X_ALIGN;
#line 2588
	schar *xp = (schar *) *xpp;
#line 2588

#line 2588
	if(rndup)
#line 2588
		rndup = X_ALIGN - rndup;
#line 2588

#line 2588
	while(nelems-- != 0)
#line 2588
	{
#line 2588
		if (*xp < 0) status = NC_ERANGE;
#line 2588
		*tp++ = *xp++;
#line 2588
	}
#line 2588

#line 2588
	*xpp = (void *)(xp + rndup);
#line 2588
	return status;
#line 2588
}
#line 2588


#line 2591
int
ncx_putn_schar_schar(void **xpp, size_t nelems, const schar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
#line 2594
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2594

#line 2594
	return NC_NOERR;
#line 2594

}
#line 2597
int
ncx_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
#line 2600
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2600

#line 2600
	return NC_NOERR;
#line 2600

}
int
#line 2602
ncx_putn_schar_short(void **xpp, size_t nelems, const short *tp)
#line 2602
{
#line 2602
	int status = NC_NOERR;
#line 2602
	schar *xp = (schar *) *xpp;
#line 2602

#line 2602
	while(nelems-- != 0)
#line 2602
	{
#line 2602
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2602
			status = NC_ERANGE;
#line 2602
		*xp++ = (schar) (signed)*tp++;
#line 2602
	}
#line 2602

#line 2602
	*xpp = (void *)xp;
#line 2602
	return status;
#line 2602
}
#line 2602

int
#line 2603
ncx_putn_schar_int(void **xpp, size_t nelems, const int *tp)
#line 2603
{
#line 2603
	int status = NC_NOERR;
#line 2603
	schar *xp = (schar *) *xpp;
#line 2603

#line 2603
	while(nelems-- != 0)
#line 2603
	{
#line 2603
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2603
			status = NC_ERANGE;
#line 2603
		*xp++ = (schar) (signed)*tp++;
#line 2603
	}
#line 2603

#line 2603
	*xpp = (void *)xp;
#line 2603
	return status;
#line 2603
}
#line 2603

int
#line 2604
ncx_putn_schar_float(void **xpp, size_t nelems, const float *tp)
#line 2604
{
#line 2604
	int status = NC_NOERR;
#line 2604
	schar *xp = (schar *) *xpp;
#line 2604

#line 2604
	while(nelems-- != 0)
#line 2604
	{
#line 2604
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2604
			status = NC_ERANGE;
#line 2604
		*xp++ = (schar) (signed)*tp++;
#line 2604
	}
#line 2604

#line 2604
	*xpp = (void *)xp;
#line 2604
	return status;
#line 2604
}
#line 2604

int
#line 2605
ncx_putn_schar_double(void **xpp, size_t nelems, const double *tp)
#line 2605
{
#line 2605
	int status = NC_NOERR;
#line 2605
	schar *xp = (schar *) *xpp;
#line 2605

#line 2605
	while(nelems-- != 0)
#line 2605
	{
#line 2605
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2605
			status = NC_ERANGE;
#line 2605
		*xp++ = (schar) (signed)*tp++;
#line 2605
	}
#line 2605

#line 2605
	*xpp = (void *)xp;
#line 2605
	return status;
#line 2605
}
#line 2605

int
#line 2606
ncx_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2606
{
#line 2606
	int status = NC_NOERR;
#line 2606
	schar *xp = (schar *) *xpp;
#line 2606

#line 2606
	while(nelems-- != 0)
#line 2606
	{
#line 2606
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2606
			status = NC_ERANGE;
#line 2606
		*xp++ = (schar) (signed)*tp++;
#line 2606
	}
#line 2606

#line 2606
	*xpp = (void *)xp;
#line 2606
	return status;
#line 2606
}
#line 2606

int
#line 2607
ncx_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2607
{
#line 2607
	int status = NC_NOERR;
#line 2607
	schar *xp = (schar *) *xpp;
#line 2607

#line 2607
	while(nelems-- != 0)
#line 2607
	{
#line 2607
		if(*tp > X_SCHAR_MAX )
#line 2607
			status = NC_ERANGE;
#line 2607
		*xp++ = (schar) (signed)*tp++;
#line 2607
	}
#line 2607

#line 2607
	*xpp = (void *)xp;
#line 2607
	return status;
#line 2607
}
#line 2607

int
#line 2608
ncx_putn_schar_uint(void **xpp, size_t nelems, const uint *tp)
#line 2608
{
#line 2608
	int status = NC_NOERR;
#line 2608
	schar *xp = (schar *) *xpp;
#line 2608

#line 2608
	while(nelems-- != 0)
#line 2608
	{
#line 2608
		if(*tp > X_SCHAR_MAX )
#line 2608
			status = NC_ERANGE;
#line 2608
		*xp++ = (schar) (signed)*tp++;
#line 2608
	}
#line 2608

#line 2608
	*xpp = (void *)xp;
#line 2608
	return status;
#line 2608
}
#line 2608

int
#line 2609
ncx_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2609
{
#line 2609
	int status = NC_NOERR;
#line 2609
	schar *xp = (schar *) *xpp;
#line 2609

#line 2609
	while(nelems-- != 0)
#line 2609
	{
#line 2609
		if(*tp > X_SCHAR_MAX )
#line 2609
			status = NC_ERANGE;
#line 2609
		*xp++ = (schar) (signed)*tp++;
#line 2609
	}
#line 2609

#line 2609
	*xpp = (void *)xp;
#line 2609
	return status;
#line 2609
}
#line 2609


#line 2612
int
ncx_pad_putn_schar_schar(void **xpp, size_t nelems, const schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2615

#line 2615
	if(rndup)
#line 2615
		rndup = X_ALIGN - rndup;
#line 2615

#line 2615
	(void) memcpy(*xpp, tp, nelems);
#line 2615
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2615

#line 2615
	if(rndup)
#line 2615
	{
#line 2615
		(void) memcpy(*xpp, nada, rndup);
#line 2615
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2615
	}
#line 2615

#line 2615
	return NC_NOERR;
#line 2615

}
#line 2618
int
ncx_pad_putn_schar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2621

#line 2621
	if(rndup)
#line 2621
		rndup = X_ALIGN - rndup;
#line 2621

#line 2621
	(void) memcpy(*xpp, tp, nelems);
#line 2621
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2621

#line 2621
	if(rndup)
#line 2621
	{
#line 2621
		(void) memcpy(*xpp, nada, rndup);
#line 2621
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2621
	}
#line 2621

#line 2621
	return NC_NOERR;
#line 2621

}
int
#line 2623
ncx_pad_putn_schar_short(void **xpp, size_t nelems, const short *tp)
#line 2623
{
#line 2623
	int status = NC_NOERR;
#line 2623
	size_t rndup = nelems % X_ALIGN;
#line 2623
	schar *xp = (schar *) *xpp;
#line 2623

#line 2623
	if(rndup)
#line 2623
		rndup = X_ALIGN - rndup;
#line 2623

#line 2623
	while(nelems-- != 0)
#line 2623
	{
#line 2623
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2623
			status = NC_ERANGE;
#line 2623
		*xp++ = (schar) (signed) *tp++;
#line 2623
	}
#line 2623

#line 2623

#line 2623
	if(rndup)
#line 2623
	{
#line 2623
		(void) memcpy(xp, nada, rndup);
#line 2623
		xp += rndup;
#line 2623
	}
#line 2623

#line 2623
	*xpp = (void *)xp;
#line 2623
	return status;
#line 2623
}
#line 2623

int
#line 2624
ncx_pad_putn_schar_int(void **xpp, size_t nelems, const int *tp)
#line 2624
{
#line 2624
	int status = NC_NOERR;
#line 2624
	size_t rndup = nelems % X_ALIGN;
#line 2624
	schar *xp = (schar *) *xpp;
#line 2624

#line 2624
	if(rndup)
#line 2624
		rndup = X_ALIGN - rndup;
#line 2624

#line 2624
	while(nelems-- != 0)
#line 2624
	{
#line 2624
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2624
			status = NC_ERANGE;
#line 2624
		*xp++ = (schar) (signed) *tp++;
#line 2624
	}
#line 2624

#line 2624

#line 2624
	if(rndup)
#line 2624
	{
#line 2624
		(void) memcpy(xp, nada, rndup);
#line 2624
		xp += rndup;
#line 2624
	}
#line 2624

#line 2624
	*xpp = (void *)xp;
#line 2624
	return status;
#line 2624
}
#line 2624

int
#line 2625
ncx_pad_putn_schar_float(void **xpp, size_t nelems, const float *tp)
#line 2625
{
#line 2625
	int status = NC_NOERR;
#line 2625
	size_t rndup = nelems % X_ALIGN;
#line 2625
	schar *xp = (schar *) *xpp;
#line 2625

#line 2625
	if(rndup)
#line 2625
		rndup = X_ALIGN - rndup;
#line 2625

#line 2625
	while(nelems-- != 0)
#line 2625
	{
#line 2625
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2625
			status = NC_ERANGE;
#line 2625
		*xp++ = (schar) (signed) *tp++;
#line 2625
	}
#line 2625

#line 2625

#line 2625
	if(rndup)
#line 2625
	{
#line 2625
		(void) memcpy(xp, nada, rndup);
#line 2625
		xp += rndup;
#line 2625
	}
#line 2625

#line 2625
	*xpp = (void *)xp;
#line 2625
	return status;
#line 2625
}
#line 2625

int
#line 2626
ncx_pad_putn_schar_double(void **xpp, size_t nelems, const double *tp)
#line 2626
{
#line 2626
	int status = NC_NOERR;
#line 2626
	size_t rndup = nelems % X_ALIGN;
#line 2626
	schar *xp = (schar *) *xpp;
#line 2626

#line 2626
	if(rndup)
#line 2626
		rndup = X_ALIGN - rndup;
#line 2626

#line 2626
	while(nelems-- != 0)
#line 2626
	{
#line 2626
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2626
			status = NC_ERANGE;
#line 2626
		*xp++ = (schar) (signed) *tp++;
#line 2626
	}
#line 2626

#line 2626

#line 2626
	if(rndup)
#line 2626
	{
#line 2626
		(void) memcpy(xp, nada, rndup);
#line 2626
		xp += rndup;
#line 2626
	}
#line 2626

#line 2626
	*xpp = (void *)xp;
#line 2626
	return status;
#line 2626
}
#line 2626

int
#line 2627
ncx_pad_putn_schar_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2627
{
#line 2627
	int status = NC_NOERR;
#line 2627
	size_t rndup = nelems % X_ALIGN;
#line 2627
	schar *xp = (schar *) *xpp;
#line 2627

#line 2627
	if(rndup)
#line 2627
		rndup = X_ALIGN - rndup;
#line 2627

#line 2627
	while(nelems-- != 0)
#line 2627
	{
#line 2627
		if(*tp > X_SCHAR_MAX || *tp < X_SCHAR_MIN)
#line 2627
			status = NC_ERANGE;
#line 2627
		*xp++ = (schar) (signed) *tp++;
#line 2627
	}
#line 2627

#line 2627

#line 2627
	if(rndup)
#line 2627
	{
#line 2627
		(void) memcpy(xp, nada, rndup);
#line 2627
		xp += rndup;
#line 2627
	}
#line 2627

#line 2627
	*xpp = (void *)xp;
#line 2627
	return status;
#line 2627
}
#line 2627

int
#line 2628
ncx_pad_putn_schar_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2628
{
#line 2628
	int status = NC_NOERR;
#line 2628
	size_t rndup = nelems % X_ALIGN;
#line 2628
	schar *xp = (schar *) *xpp;
#line 2628

#line 2628
	if(rndup)
#line 2628
		rndup = X_ALIGN - rndup;
#line 2628

#line 2628
	while(nelems-- != 0)
#line 2628
	{
#line 2628
		if(*tp > X_SCHAR_MAX )
#line 2628
			status = NC_ERANGE;
#line 2628
		*xp++ = (schar) (signed) *tp++;
#line 2628
	}
#line 2628

#line 2628

#line 2628
	if(rndup)
#line 2628
	{
#line 2628
		(void) memcpy(xp, nada, rndup);
#line 2628
		xp += rndup;
#line 2628
	}
#line 2628

#line 2628
	*xpp = (void *)xp;
#line 2628
	return status;
#line 2628
}
#line 2628

int
#line 2629
ncx_pad_putn_schar_uint(void **xpp, size_t nelems, const uint *tp)
#line 2629
{
#line 2629
	int status = NC_NOERR;
#line 2629
	size_t rndup = nelems % X_ALIGN;
#line 2629
	schar *xp = (schar *) *xpp;
#line 2629

#line 2629
	if(rndup)
#line 2629
		rndup = X_ALIGN - rndup;
#line 2629

#line 2629
	while(nelems-- != 0)
#line 2629
	{
#line 2629
		if(*tp > X_SCHAR_MAX )
#line 2629
			status = NC_ERANGE;
#line 2629
		*xp++ = (schar) (signed) *tp++;
#line 2629
	}
#line 2629

#line 2629

#line 2629
	if(rndup)
#line 2629
	{
#line 2629
		(void) memcpy(xp, nada, rndup);
#line 2629
		xp += rndup;
#line 2629
	}
#line 2629

#line 2629
	*xpp = (void *)xp;
#line 2629
	return status;
#line 2629
}
#line 2629

int
#line 2630
ncx_pad_putn_schar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2630
{
#line 2630
	int status = NC_NOERR;
#line 2630
	size_t rndup = nelems % X_ALIGN;
#line 2630
	schar *xp = (schar *) *xpp;
#line 2630

#line 2630
	if(rndup)
#line 2630
		rndup = X_ALIGN - rndup;
#line 2630

#line 2630
	while(nelems-- != 0)
#line 2630
	{
#line 2630
		if(*tp > X_SCHAR_MAX )
#line 2630
			status = NC_ERANGE;
#line 2630
		*xp++ = (schar) (signed) *tp++;
#line 2630
	}
#line 2630

#line 2630

#line 2630
	if(rndup)
#line 2630
	{
#line 2630
		(void) memcpy(xp, nada, rndup);
#line 2630
		xp += rndup;
#line 2630
	}
#line 2630

#line 2630
	*xpp = (void *)xp;
#line 2630
	return status;
#line 2630
}
#line 2630



/* uchar ---------------------------------------------------------------------*/
#line 2636
int
ncx_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
#line 2639
	*xpp = (void *)((schar *)(*xpp) + nelems);
#line 2639
	return NC_NOERR;
#line 2639

}
#line 2642
int
ncx_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		(void) memcpy(tp, *xpp, nelems);
#line 2645
	*xpp = (void *)((schar *)(*xpp) + nelems);
#line 2645
	return NC_NOERR;
#line 2645

}
int
#line 2647
ncx_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2647
{
#line 2647
	int status = NC_NOERR;
#line 2647
	uchar *xp = (uchar *)(*xpp);
#line 2647

#line 2647
	while(nelems-- != 0)
#line 2647
	{
#line 2647

#line 2647
		*tp++ = *xp++;
#line 2647
	}
#line 2647

#line 2647
	*xpp = (const void *)xp;
#line 2647
	return status;
#line 2647
}
#line 2647

int
#line 2648
ncx_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2648
{
#line 2648
	int status = NC_NOERR;
#line 2648
	uchar *xp = (uchar *)(*xpp);
#line 2648

#line 2648
	while(nelems-- != 0)
#line 2648
	{
#line 2648

#line 2648
		*tp++ = *xp++;
#line 2648
	}
#line 2648

#line 2648
	*xpp = (const void *)xp;
#line 2648
	return status;
#line 2648
}
#line 2648

int
#line 2649
ncx_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2649
{
#line 2649
	int status = NC_NOERR;
#line 2649
	uchar *xp = (uchar *)(*xpp);
#line 2649

#line 2649
	while(nelems-- != 0)
#line 2649
	{
#line 2649

#line 2649
		*tp++ = *xp++;
#line 2649
	}
#line 2649

#line 2649
	*xpp = (const void *)xp;
#line 2649
	return status;
#line 2649
}
#line 2649

int
#line 2650
ncx_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2650
{
#line 2650
	int status = NC_NOERR;
#line 2650
	uchar *xp = (uchar *)(*xpp);
#line 2650

#line 2650
	while(nelems-- != 0)
#line 2650
	{
#line 2650

#line 2650
		*tp++ = *xp++;
#line 2650
	}
#line 2650

#line 2650
	*xpp = (const void *)xp;
#line 2650
	return status;
#line 2650
}
#line 2650

int
#line 2651
ncx_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2651
{
#line 2651
	int status = NC_NOERR;
#line 2651
	uchar *xp = (uchar *)(*xpp);
#line 2651

#line 2651
	while(nelems-- != 0)
#line 2651
	{
#line 2651

#line 2651
		*tp++ = *xp++;
#line 2651
	}
#line 2651

#line 2651
	*xpp = (const void *)xp;
#line 2651
	return status;
#line 2651
}
#line 2651

int
#line 2652
ncx_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2652
{
#line 2652
	int status = NC_NOERR;
#line 2652
	uchar *xp = (uchar *)(*xpp);
#line 2652

#line 2652
	while(nelems-- != 0)
#line 2652
	{
#line 2652

#line 2652
		*tp++ = *xp++;
#line 2652
	}
#line 2652

#line 2652
	*xpp = (const void *)xp;
#line 2652
	return status;
#line 2652
}
#line 2652

int
#line 2653
ncx_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2653
{
#line 2653
	int status = NC_NOERR;
#line 2653
	uchar *xp = (uchar *)(*xpp);
#line 2653

#line 2653
	while(nelems-- != 0)
#line 2653
	{
#line 2653

#line 2653
		*tp++ = *xp++;
#line 2653
	}
#line 2653

#line 2653
	*xpp = (const void *)xp;
#line 2653
	return status;
#line 2653
}
#line 2653

int
#line 2654
ncx_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2654
{
#line 2654
	int status = NC_NOERR;
#line 2654
	uchar *xp = (uchar *)(*xpp);
#line 2654

#line 2654
	while(nelems-- != 0)
#line 2654
	{
#line 2654

#line 2654
		*tp++ = *xp++;
#line 2654
	}
#line 2654

#line 2654
	*xpp = (const void *)xp;
#line 2654
	return status;
#line 2654
}
#line 2654


#line 2657
int
ncx_pad_getn_uchar_schar(const void **xpp, size_t nelems, schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2660

#line 2660
	if(rndup)
#line 2660
		rndup = X_ALIGN - rndup;
#line 2660

#line 2660
	(void) memcpy(tp, *xpp, nelems);
#line 2660
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2660

#line 2660
	return NC_NOERR;
#line 2660

}
#line 2663
int
ncx_pad_getn_uchar_uchar(const void **xpp, size_t nelems, uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2666

#line 2666
	if(rndup)
#line 2666
		rndup = X_ALIGN - rndup;
#line 2666

#line 2666
	(void) memcpy(tp, *xpp, nelems);
#line 2666
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 2666

#line 2666
	return NC_NOERR;
#line 2666

}
int
#line 2668
ncx_pad_getn_uchar_short(const void **xpp, size_t nelems, short *tp)
#line 2668
{
#line 2668
	int status = NC_NOERR;
#line 2668
	size_t rndup = nelems % X_ALIGN;
#line 2668
	uchar *xp = (uchar *) *xpp;
#line 2668

#line 2668
	if(rndup)
#line 2668
		rndup = X_ALIGN - rndup;
#line 2668

#line 2668
	while(nelems-- != 0)
#line 2668
	{
#line 2668

#line 2668
		*tp++ = *xp++;
#line 2668
	}
#line 2668

#line 2668
	*xpp = (void *)(xp + rndup);
#line 2668
	return status;
#line 2668
}
#line 2668

int
#line 2669
ncx_pad_getn_uchar_int(const void **xpp, size_t nelems, int *tp)
#line 2669
{
#line 2669
	int status = NC_NOERR;
#line 2669
	size_t rndup = nelems % X_ALIGN;
#line 2669
	uchar *xp = (uchar *) *xpp;
#line 2669

#line 2669
	if(rndup)
#line 2669
		rndup = X_ALIGN - rndup;
#line 2669

#line 2669
	while(nelems-- != 0)
#line 2669
	{
#line 2669

#line 2669
		*tp++ = *xp++;
#line 2669
	}
#line 2669

#line 2669
	*xpp = (void *)(xp + rndup);
#line 2669
	return status;
#line 2669
}
#line 2669

int
#line 2670
ncx_pad_getn_uchar_float(const void **xpp, size_t nelems, float *tp)
#line 2670
{
#line 2670
	int status = NC_NOERR;
#line 2670
	size_t rndup = nelems % X_ALIGN;
#line 2670
	uchar *xp = (uchar *) *xpp;
#line 2670

#line 2670
	if(rndup)
#line 2670
		rndup = X_ALIGN - rndup;
#line 2670

#line 2670
	while(nelems-- != 0)
#line 2670
	{
#line 2670

#line 2670
		*tp++ = *xp++;
#line 2670
	}
#line 2670

#line 2670
	*xpp = (void *)(xp + rndup);
#line 2670
	return status;
#line 2670
}
#line 2670

int
#line 2671
ncx_pad_getn_uchar_double(const void **xpp, size_t nelems, double *tp)
#line 2671
{
#line 2671
	int status = NC_NOERR;
#line 2671
	size_t rndup = nelems % X_ALIGN;
#line 2671
	uchar *xp = (uchar *) *xpp;
#line 2671

#line 2671
	if(rndup)
#line 2671
		rndup = X_ALIGN - rndup;
#line 2671

#line 2671
	while(nelems-- != 0)
#line 2671
	{
#line 2671

#line 2671
		*tp++ = *xp++;
#line 2671
	}
#line 2671

#line 2671
	*xpp = (void *)(xp + rndup);
#line 2671
	return status;
#line 2671
}
#line 2671

int
#line 2672
ncx_pad_getn_uchar_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2672
{
#line 2672
	int status = NC_NOERR;
#line 2672
	size_t rndup = nelems % X_ALIGN;
#line 2672
	uchar *xp = (uchar *) *xpp;
#line 2672

#line 2672
	if(rndup)
#line 2672
		rndup = X_ALIGN - rndup;
#line 2672

#line 2672
	while(nelems-- != 0)
#line 2672
	{
#line 2672

#line 2672
		*tp++ = *xp++;
#line 2672
	}
#line 2672

#line 2672
	*xpp = (void *)(xp + rndup);
#line 2672
	return status;
#line 2672
}
#line 2672

int
#line 2673
ncx_pad_getn_uchar_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2673
{
#line 2673
	int status = NC_NOERR;
#line 2673
	size_t rndup = nelems % X_ALIGN;
#line 2673
	uchar *xp = (uchar *) *xpp;
#line 2673

#line 2673
	if(rndup)
#line 2673
		rndup = X_ALIGN - rndup;
#line 2673

#line 2673
	while(nelems-- != 0)
#line 2673
	{
#line 2673

#line 2673
		*tp++ = *xp++;
#line 2673
	}
#line 2673

#line 2673
	*xpp = (void *)(xp + rndup);
#line 2673
	return status;
#line 2673
}
#line 2673

int
#line 2674
ncx_pad_getn_uchar_uint(const void **xpp, size_t nelems, uint *tp)
#line 2674
{
#line 2674
	int status = NC_NOERR;
#line 2674
	size_t rndup = nelems % X_ALIGN;
#line 2674
	uchar *xp = (uchar *) *xpp;
#line 2674

#line 2674
	if(rndup)
#line 2674
		rndup = X_ALIGN - rndup;
#line 2674

#line 2674
	while(nelems-- != 0)
#line 2674
	{
#line 2674

#line 2674
		*tp++ = *xp++;
#line 2674
	}
#line 2674

#line 2674
	*xpp = (void *)(xp + rndup);
#line 2674
	return status;
#line 2674
}
#line 2674

int
#line 2675
ncx_pad_getn_uchar_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2675
{
#line 2675
	int status = NC_NOERR;
#line 2675
	size_t rndup = nelems % X_ALIGN;
#line 2675
	uchar *xp = (uchar *) *xpp;
#line 2675

#line 2675
	if(rndup)
#line 2675
		rndup = X_ALIGN - rndup;
#line 2675

#line 2675
	while(nelems-- != 0)
#line 2675
	{
#line 2675

#line 2675
		*tp++ = *xp++;
#line 2675
	}
#line 2675

#line 2675
	*xpp = (void *)(xp + rndup);
#line 2675
	return status;
#line 2675
}
#line 2675


#line 2678
int
ncx_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
#line 2681
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2681

#line 2681
	return NC_NOERR;
#line 2681

}
#line 2684
int
ncx_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		(void) memcpy(*xpp, tp, nelems);
#line 2687
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2687

#line 2687
	return NC_NOERR;
#line 2687

}
int
#line 2689
ncx_putn_uchar_short(void **xpp, size_t nelems, const short *tp)
#line 2689
{
#line 2689
	int status = NC_NOERR;
#line 2689
	uchar *xp = (uchar *) *xpp;
#line 2689

#line 2689
	while(nelems-- != 0)
#line 2689
	{
#line 2689
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2689
			status = NC_ERANGE;
#line 2689
		*xp++ = (uchar) (signed)*tp++;
#line 2689
	}
#line 2689

#line 2689
	*xpp = (void *)xp;
#line 2689
	return status;
#line 2689
}
#line 2689

int
#line 2690
ncx_putn_uchar_int(void **xpp, size_t nelems, const int *tp)
#line 2690
{
#line 2690
	int status = NC_NOERR;
#line 2690
	uchar *xp = (uchar *) *xpp;
#line 2690

#line 2690
	while(nelems-- != 0)
#line 2690
	{
#line 2690
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2690
			status = NC_ERANGE;
#line 2690
		*xp++ = (uchar) (signed)*tp++;
#line 2690
	}
#line 2690

#line 2690
	*xpp = (void *)xp;
#line 2690
	return status;
#line 2690
}
#line 2690

int
#line 2691
ncx_putn_uchar_float(void **xpp, size_t nelems, const float *tp)
#line 2691
{
#line 2691
	int status = NC_NOERR;
#line 2691
	uchar *xp = (uchar *) *xpp;
#line 2691

#line 2691
	while(nelems-- != 0)
#line 2691
	{
#line 2691
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2691
			status = NC_ERANGE;
#line 2691
		*xp++ = (uchar) (signed)*tp++;
#line 2691
	}
#line 2691

#line 2691
	*xpp = (void *)xp;
#line 2691
	return status;
#line 2691
}
#line 2691

int
#line 2692
ncx_putn_uchar_double(void **xpp, size_t nelems, const double *tp)
#line 2692
{
#line 2692
	int status = NC_NOERR;
#line 2692
	uchar *xp = (uchar *) *xpp;
#line 2692

#line 2692
	while(nelems-- != 0)
#line 2692
	{
#line 2692
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2692
			status = NC_ERANGE;
#line 2692
		*xp++ = (uchar) (signed)*tp++;
#line 2692
	}
#line 2692

#line 2692
	*xpp = (void *)xp;
#line 2692
	return status;
#line 2692
}
#line 2692

int
#line 2693
ncx_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2693
{
#line 2693
	int status = NC_NOERR;
#line 2693
	uchar *xp = (uchar *) *xpp;
#line 2693

#line 2693
	while(nelems-- != 0)
#line 2693
	{
#line 2693
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2693
			status = NC_ERANGE;
#line 2693
		*xp++ = (uchar) (signed)*tp++;
#line 2693
	}
#line 2693

#line 2693
	*xpp = (void *)xp;
#line 2693
	return status;
#line 2693
}
#line 2693

int
#line 2694
ncx_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2694
{
#line 2694
	int status = NC_NOERR;
#line 2694
	uchar *xp = (uchar *) *xpp;
#line 2694

#line 2694
	while(nelems-- != 0)
#line 2694
	{
#line 2694
		if(*tp > X_UCHAR_MAX )
#line 2694
			status = NC_ERANGE;
#line 2694
		*xp++ = (uchar) (signed)*tp++;
#line 2694
	}
#line 2694

#line 2694
	*xpp = (void *)xp;
#line 2694
	return status;
#line 2694
}
#line 2694

int
#line 2695
ncx_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp)
#line 2695
{
#line 2695
	int status = NC_NOERR;
#line 2695
	uchar *xp = (uchar *) *xpp;
#line 2695

#line 2695
	while(nelems-- != 0)
#line 2695
	{
#line 2695
		if(*tp > X_UCHAR_MAX )
#line 2695
			status = NC_ERANGE;
#line 2695
		*xp++ = (uchar) (signed)*tp++;
#line 2695
	}
#line 2695

#line 2695
	*xpp = (void *)xp;
#line 2695
	return status;
#line 2695
}
#line 2695

int
#line 2696
ncx_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2696
{
#line 2696
	int status = NC_NOERR;
#line 2696
	uchar *xp = (uchar *) *xpp;
#line 2696

#line 2696
	while(nelems-- != 0)
#line 2696
	{
#line 2696
		if(*tp > X_UCHAR_MAX )
#line 2696
			status = NC_ERANGE;
#line 2696
		*xp++ = (uchar) (signed)*tp++;
#line 2696
	}
#line 2696

#line 2696
	*xpp = (void *)xp;
#line 2696
	return status;
#line 2696
}
#line 2696


#line 2699
int
ncx_pad_putn_uchar_schar(void **xpp, size_t nelems, const schar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2702

#line 2702
	if(rndup)
#line 2702
		rndup = X_ALIGN - rndup;
#line 2702

#line 2702
	(void) memcpy(*xpp, tp, nelems);
#line 2702
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2702

#line 2702
	if(rndup)
#line 2702
	{
#line 2702
		(void) memcpy(*xpp, nada, rndup);
#line 2702
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2702
	}
#line 2702

#line 2702
	return NC_NOERR;
#line 2702

}
#line 2705
int
ncx_pad_putn_uchar_uchar(void **xpp, size_t nelems, const uchar *tp)
{
		size_t rndup = nelems % X_ALIGN;
#line 2708

#line 2708
	if(rndup)
#line 2708
		rndup = X_ALIGN - rndup;
#line 2708

#line 2708
	(void) memcpy(*xpp, tp, nelems);
#line 2708
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 2708

#line 2708
	if(rndup)
#line 2708
	{
#line 2708
		(void) memcpy(*xpp, nada, rndup);
#line 2708
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 2708
	}
#line 2708

#line 2708
	return NC_NOERR;
#line 2708

}
int
#line 2710
ncx_pad_putn_uchar_short(void **xpp, size_t nelems, const short *tp)
#line 2710
{
#line 2710
	int status = NC_NOERR;
#line 2710
	size_t rndup = nelems % X_ALIGN;
#line 2710
	uchar *xp = (uchar *) *xpp;
#line 2710

#line 2710
	if(rndup)
#line 2710
		rndup = X_ALIGN - rndup;
#line 2710

#line 2710
	while(nelems-- != 0)
#line 2710
	{
#line 2710
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2710
			status = NC_ERANGE;
#line 2710
		*xp++ = (uchar) (signed) *tp++;
#line 2710
	}
#line 2710

#line 2710

#line 2710
	if(rndup)
#line 2710
	{
#line 2710
		(void) memcpy(xp, nada, rndup);
#line 2710
		xp += rndup;
#line 2710
	}
#line 2710

#line 2710
	*xpp = (void *)xp;
#line 2710
	return status;
#line 2710
}
#line 2710

int
#line 2711
ncx_pad_putn_uchar_int(void **xpp, size_t nelems, const int *tp)
#line 2711
{
#line 2711
	int status = NC_NOERR;
#line 2711
	size_t rndup = nelems % X_ALIGN;
#line 2711
	uchar *xp = (uchar *) *xpp;
#line 2711

#line 2711
	if(rndup)
#line 2711
		rndup = X_ALIGN - rndup;
#line 2711

#line 2711
	while(nelems-- != 0)
#line 2711
	{
#line 2711
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2711
			status = NC_ERANGE;
#line 2711
		*xp++ = (uchar) (signed) *tp++;
#line 2711
	}
#line 2711

#line 2711

#line 2711
	if(rndup)
#line 2711
	{
#line 2711
		(void) memcpy(xp, nada, rndup);
#line 2711
		xp += rndup;
#line 2711
	}
#line 2711

#line 2711
	*xpp = (void *)xp;
#line 2711
	return status;
#line 2711
}
#line 2711

int
#line 2712
ncx_pad_putn_uchar_float(void **xpp, size_t nelems, const float *tp)
#line 2712
{
#line 2712
	int status = NC_NOERR;
#line 2712
	size_t rndup = nelems % X_ALIGN;
#line 2712
	uchar *xp = (uchar *) *xpp;
#line 2712

#line 2712
	if(rndup)
#line 2712
		rndup = X_ALIGN - rndup;
#line 2712

#line 2712
	while(nelems-- != 0)
#line 2712
	{
#line 2712
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2712
			status = NC_ERANGE;
#line 2712
		*xp++ = (uchar) (signed) *tp++;
#line 2712
	}
#line 2712

#line 2712

#line 2712
	if(rndup)
#line 2712
	{
#line 2712
		(void) memcpy(xp, nada, rndup);
#line 2712
		xp += rndup;
#line 2712
	}
#line 2712

#line 2712
	*xpp = (void *)xp;
#line 2712
	return status;
#line 2712
}
#line 2712

int
#line 2713
ncx_pad_putn_uchar_double(void **xpp, size_t nelems, const double *tp)
#line 2713
{
#line 2713
	int status = NC_NOERR;
#line 2713
	size_t rndup = nelems % X_ALIGN;
#line 2713
	uchar *xp = (uchar *) *xpp;
#line 2713

#line 2713
	if(rndup)
#line 2713
		rndup = X_ALIGN - rndup;
#line 2713

#line 2713
	while(nelems-- != 0)
#line 2713
	{
#line 2713
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2713
			status = NC_ERANGE;
#line 2713
		*xp++ = (uchar) (signed) *tp++;
#line 2713
	}
#line 2713

#line 2713

#line 2713
	if(rndup)
#line 2713
	{
#line 2713
		(void) memcpy(xp, nada, rndup);
#line 2713
		xp += rndup;
#line 2713
	}
#line 2713

#line 2713
	*xpp = (void *)xp;
#line 2713
	return status;
#line 2713
}
#line 2713

int
#line 2714
ncx_pad_putn_uchar_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2714
{
#line 2714
	int status = NC_NOERR;
#line 2714
	size_t rndup = nelems % X_ALIGN;
#line 2714
	uchar *xp = (uchar *) *xpp;
#line 2714

#line 2714
	if(rndup)
#line 2714
		rndup = X_ALIGN - rndup;
#line 2714

#line 2714
	while(nelems-- != 0)
#line 2714
	{
#line 2714
		if(*tp > X_UCHAR_MAX || *tp < 0)
#line 2714
			status = NC_ERANGE;
#line 2714
		*xp++ = (uchar) (signed) *tp++;
#line 2714
	}
#line 2714

#line 2714

#line 2714
	if(rndup)
#line 2714
	{
#line 2714
		(void) memcpy(xp, nada, rndup);
#line 2714
		xp += rndup;
#line 2714
	}
#line 2714

#line 2714
	*xpp = (void *)xp;
#line 2714
	return status;
#line 2714
}
#line 2714

int
#line 2715
ncx_pad_putn_uchar_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2715
{
#line 2715
	int status = NC_NOERR;
#line 2715
	size_t rndup = nelems % X_ALIGN;
#line 2715
	uchar *xp = (uchar *) *xpp;
#line 2715

#line 2715
	if(rndup)
#line 2715
		rndup = X_ALIGN - rndup;
#line 2715

#line 2715
	while(nelems-- != 0)
#line 2715
	{
#line 2715
		if(*tp > X_UCHAR_MAX )
#line 2715
			status = NC_ERANGE;
#line 2715
		*xp++ = (uchar) (signed) *tp++;
#line 2715
	}
#line 2715

#line 2715

#line 2715
	if(rndup)
#line 2715
	{
#line 2715
		(void) memcpy(xp, nada, rndup);
#line 2715
		xp += rndup;
#line 2715
	}
#line 2715

#line 2715
	*xpp = (void *)xp;
#line 2715
	return status;
#line 2715
}
#line 2715

int
#line 2716
ncx_pad_putn_uchar_uint(void **xpp, size_t nelems, const uint *tp)
#line 2716
{
#line 2716
	int status = NC_NOERR;
#line 2716
	size_t rndup = nelems % X_ALIGN;
#line 2716
	uchar *xp = (uchar *) *xpp;
#line 2716

#line 2716
	if(rndup)
#line 2716
		rndup = X_ALIGN - rndup;
#line 2716

#line 2716
	while(nelems-- != 0)
#line 2716
	{
#line 2716
		if(*tp > X_UCHAR_MAX )
#line 2716
			status = NC_ERANGE;
#line 2716
		*xp++ = (uchar) (signed) *tp++;
#line 2716
	}
#line 2716

#line 2716

#line 2716
	if(rndup)
#line 2716
	{
#line 2716
		(void) memcpy(xp, nada, rndup);
#line 2716
		xp += rndup;
#line 2716
	}
#line 2716

#line 2716
	*xpp = (void *)xp;
#line 2716
	return status;
#line 2716
}
#line 2716

int
#line 2717
ncx_pad_putn_uchar_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2717
{
#line 2717
	int status = NC_NOERR;
#line 2717
	size_t rndup = nelems % X_ALIGN;
#line 2717
	uchar *xp = (uchar *) *xpp;
#line 2717

#line 2717
	if(rndup)
#line 2717
		rndup = X_ALIGN - rndup;
#line 2717

#line 2717
	while(nelems-- != 0)
#line 2717
	{
#line 2717
		if(*tp > X_UCHAR_MAX )
#line 2717
			status = NC_ERANGE;
#line 2717
		*xp++ = (uchar) (signed) *tp++;
#line 2717
	}
#line 2717

#line 2717

#line 2717
	if(rndup)
#line 2717
	{
#line 2717
		(void) memcpy(xp, nada, rndup);
#line 2717
		xp += rndup;
#line 2717
	}
#line 2717

#line 2717
	*xpp = (void *)xp;
#line 2717
	return status;
#line 2717
}
#line 2717


/* short ---------------------------------------------------------------------*/

#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(short));
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 2735
ncx_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2735
{
#line 2735
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2735

#line 2735
 /* basic algorithm is:
#line 2735
  *   - ensure sane alignment of input data
#line 2735
  *   - copy (conversion happens automatically) input data
#line 2735
  *     to output
#line 2735
  *   - update xpp to point at next unconverted input, and tp to point
#line 2735
  *     at next location for converted output
#line 2735
  */
#line 2735
  long i, j, ni;
#line 2735
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2735
  short *xp;
#line 2735
  int nrange = 0;         /* number of range errors */
#line 2735
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2735
  long cxp = (long) *((char**)xpp);
#line 2735

#line 2735
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2735
  /* sjl: manually stripmine so we can limit amount of
#line 2735
   * vector work space reserved to LOOPCNT elements. Also
#line 2735
   * makes vectorisation easy */
#line 2735
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2735
    ni=Min(nelems-j,LOOPCNT);
#line 2735
    if (realign) {
#line 2735
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2735
      xp = tmp;
#line 2735
    } else {
#line 2735
      xp = (short *) *xpp;
#line 2735
    }
#line 2735
   /* copy the next block */
#line 2735
#pragma cdir loopcnt=LOOPCNT
#line 2735
#pragma cdir shortloop
#line 2735
    for (i=0; i<ni; i++) {
#line 2735
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2735
     /* test for range errors (not always needed but do it anyway) */
#line 2735
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2735
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2735
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 2735
    }
#line 2735
   /* update xpp and tp */
#line 2735
    if (realign) xp = (short *) *xpp;
#line 2735
    xp += ni;
#line 2735
    tp += ni;
#line 2735
    *xpp = (void*)xp;
#line 2735
  }
#line 2735
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2735

#line 2735
#else   /* not SX */
#line 2735
	const char *xp = (const char *) *xpp;
#line 2735
	int status = NC_NOERR;
#line 2735

#line 2735
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2735
	{
#line 2735
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2735
		if(lstatus != NC_NOERR)
#line 2735
			status = lstatus;
#line 2735
	}
#line 2735

#line 2735
	*xpp = (const void *)xp;
#line 2735
	return status;
#line 2735
#  endif
#line 2735
}
#line 2735

#endif
int
#line 2737
ncx_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2737
{
#line 2737
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2737

#line 2737
 /* basic algorithm is:
#line 2737
  *   - ensure sane alignment of input data
#line 2737
  *   - copy (conversion happens automatically) input data
#line 2737
  *     to output
#line 2737
  *   - update xpp to point at next unconverted input, and tp to point
#line 2737
  *     at next location for converted output
#line 2737
  */
#line 2737
  long i, j, ni;
#line 2737
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2737
  short *xp;
#line 2737
  int nrange = 0;         /* number of range errors */
#line 2737
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2737
  long cxp = (long) *((char**)xpp);
#line 2737

#line 2737
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2737
  /* sjl: manually stripmine so we can limit amount of
#line 2737
   * vector work space reserved to LOOPCNT elements. Also
#line 2737
   * makes vectorisation easy */
#line 2737
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2737
    ni=Min(nelems-j,LOOPCNT);
#line 2737
    if (realign) {
#line 2737
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2737
      xp = tmp;
#line 2737
    } else {
#line 2737
      xp = (short *) *xpp;
#line 2737
    }
#line 2737
   /* copy the next block */
#line 2737
#pragma cdir loopcnt=LOOPCNT
#line 2737
#pragma cdir shortloop
#line 2737
    for (i=0; i<ni; i++) {
#line 2737
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2737
     /* test for range errors (not always needed but do it anyway) */
#line 2737
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2737
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2737
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 2737
    }
#line 2737
   /* update xpp and tp */
#line 2737
    if (realign) xp = (short *) *xpp;
#line 2737
    xp += ni;
#line 2737
    tp += ni;
#line 2737
    *xpp = (void*)xp;
#line 2737
  }
#line 2737
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2737

#line 2737
#else   /* not SX */
#line 2737
	const char *xp = (const char *) *xpp;
#line 2737
	int status = NC_NOERR;
#line 2737

#line 2737
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2737
	{
#line 2737
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2737
		if(lstatus != NC_NOERR)
#line 2737
			status = lstatus;
#line 2737
	}
#line 2737

#line 2737
	*xpp = (const void *)xp;
#line 2737
	return status;
#line 2737
#  endif
#line 2737
}
#line 2737

int
#line 2738
ncx_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2738
{
#line 2738
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2738

#line 2738
 /* basic algorithm is:
#line 2738
  *   - ensure sane alignment of input data
#line 2738
  *   - copy (conversion happens automatically) input data
#line 2738
  *     to output
#line 2738
  *   - update xpp to point at next unconverted input, and tp to point
#line 2738
  *     at next location for converted output
#line 2738
  */
#line 2738
  long i, j, ni;
#line 2738
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2738
  short *xp;
#line 2738
  int nrange = 0;         /* number of range errors */
#line 2738
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2738
  long cxp = (long) *((char**)xpp);
#line 2738

#line 2738
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2738
  /* sjl: manually stripmine so we can limit amount of
#line 2738
   * vector work space reserved to LOOPCNT elements. Also
#line 2738
   * makes vectorisation easy */
#line 2738
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2738
    ni=Min(nelems-j,LOOPCNT);
#line 2738
    if (realign) {
#line 2738
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2738
      xp = tmp;
#line 2738
    } else {
#line 2738
      xp = (short *) *xpp;
#line 2738
    }
#line 2738
   /* copy the next block */
#line 2738
#pragma cdir loopcnt=LOOPCNT
#line 2738
#pragma cdir shortloop
#line 2738
    for (i=0; i<ni; i++) {
#line 2738
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2738
     /* test for range errors (not always needed but do it anyway) */
#line 2738
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2738
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2738
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 2738
    }
#line 2738
   /* update xpp and tp */
#line 2738
    if (realign) xp = (short *) *xpp;
#line 2738
    xp += ni;
#line 2738
    tp += ni;
#line 2738
    *xpp = (void*)xp;
#line 2738
  }
#line 2738
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2738

#line 2738
#else   /* not SX */
#line 2738
	const char *xp = (const char *) *xpp;
#line 2738
	int status = NC_NOERR;
#line 2738

#line 2738
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2738
	{
#line 2738
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2738
		if(lstatus != NC_NOERR)
#line 2738
			status = lstatus;
#line 2738
	}
#line 2738

#line 2738
	*xpp = (const void *)xp;
#line 2738
	return status;
#line 2738
#  endif
#line 2738
}
#line 2738

int
#line 2739
ncx_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2739
{
#line 2739
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2739

#line 2739
 /* basic algorithm is:
#line 2739
  *   - ensure sane alignment of input data
#line 2739
  *   - copy (conversion happens automatically) input data
#line 2739
  *     to output
#line 2739
  *   - update xpp to point at next unconverted input, and tp to point
#line 2739
  *     at next location for converted output
#line 2739
  */
#line 2739
  long i, j, ni;
#line 2739
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2739
  short *xp;
#line 2739
  int nrange = 0;         /* number of range errors */
#line 2739
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2739
  long cxp = (long) *((char**)xpp);
#line 2739

#line 2739
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2739
  /* sjl: manually stripmine so we can limit amount of
#line 2739
   * vector work space reserved to LOOPCNT elements. Also
#line 2739
   * makes vectorisation easy */
#line 2739
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2739
    ni=Min(nelems-j,LOOPCNT);
#line 2739
    if (realign) {
#line 2739
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2739
      xp = tmp;
#line 2739
    } else {
#line 2739
      xp = (short *) *xpp;
#line 2739
    }
#line 2739
   /* copy the next block */
#line 2739
#pragma cdir loopcnt=LOOPCNT
#line 2739
#pragma cdir shortloop
#line 2739
    for (i=0; i<ni; i++) {
#line 2739
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2739
     /* test for range errors (not always needed but do it anyway) */
#line 2739
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2739
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2739
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 2739
    }
#line 2739
   /* update xpp and tp */
#line 2739
    if (realign) xp = (short *) *xpp;
#line 2739
    xp += ni;
#line 2739
    tp += ni;
#line 2739
    *xpp = (void*)xp;
#line 2739
  }
#line 2739
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2739

#line 2739
#else   /* not SX */
#line 2739
	const char *xp = (const char *) *xpp;
#line 2739
	int status = NC_NOERR;
#line 2739

#line 2739
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2739
	{
#line 2739
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2739
		if(lstatus != NC_NOERR)
#line 2739
			status = lstatus;
#line 2739
	}
#line 2739

#line 2739
	*xpp = (const void *)xp;
#line 2739
	return status;
#line 2739
#  endif
#line 2739
}
#line 2739

int
#line 2740
ncx_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2740
{
#line 2740
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2740

#line 2740
 /* basic algorithm is:
#line 2740
  *   - ensure sane alignment of input data
#line 2740
  *   - copy (conversion happens automatically) input data
#line 2740
  *     to output
#line 2740
  *   - update xpp to point at next unconverted input, and tp to point
#line 2740
  *     at next location for converted output
#line 2740
  */
#line 2740
  long i, j, ni;
#line 2740
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2740
  short *xp;
#line 2740
  int nrange = 0;         /* number of range errors */
#line 2740
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2740
  long cxp = (long) *((char**)xpp);
#line 2740

#line 2740
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2740
  /* sjl: manually stripmine so we can limit amount of
#line 2740
   * vector work space reserved to LOOPCNT elements. Also
#line 2740
   * makes vectorisation easy */
#line 2740
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2740
    ni=Min(nelems-j,LOOPCNT);
#line 2740
    if (realign) {
#line 2740
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2740
      xp = tmp;
#line 2740
    } else {
#line 2740
      xp = (short *) *xpp;
#line 2740
    }
#line 2740
   /* copy the next block */
#line 2740
#pragma cdir loopcnt=LOOPCNT
#line 2740
#pragma cdir shortloop
#line 2740
    for (i=0; i<ni; i++) {
#line 2740
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2740
     /* test for range errors (not always needed but do it anyway) */
#line 2740
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2740
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2740
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 2740
    }
#line 2740
   /* update xpp and tp */
#line 2740
    if (realign) xp = (short *) *xpp;
#line 2740
    xp += ni;
#line 2740
    tp += ni;
#line 2740
    *xpp = (void*)xp;
#line 2740
  }
#line 2740
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2740

#line 2740
#else   /* not SX */
#line 2740
	const char *xp = (const char *) *xpp;
#line 2740
	int status = NC_NOERR;
#line 2740

#line 2740
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2740
	{
#line 2740
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2740
		if(lstatus != NC_NOERR)
#line 2740
			status = lstatus;
#line 2740
	}
#line 2740

#line 2740
	*xpp = (const void *)xp;
#line 2740
	return status;
#line 2740
#  endif
#line 2740
}
#line 2740

int
#line 2741
ncx_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2741
{
#line 2741
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2741

#line 2741
 /* basic algorithm is:
#line 2741
  *   - ensure sane alignment of input data
#line 2741
  *   - copy (conversion happens automatically) input data
#line 2741
  *     to output
#line 2741
  *   - update xpp to point at next unconverted input, and tp to point
#line 2741
  *     at next location for converted output
#line 2741
  */
#line 2741
  long i, j, ni;
#line 2741
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2741
  short *xp;
#line 2741
  int nrange = 0;         /* number of range errors */
#line 2741
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2741
  long cxp = (long) *((char**)xpp);
#line 2741

#line 2741
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2741
  /* sjl: manually stripmine so we can limit amount of
#line 2741
   * vector work space reserved to LOOPCNT elements. Also
#line 2741
   * makes vectorisation easy */
#line 2741
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2741
    ni=Min(nelems-j,LOOPCNT);
#line 2741
    if (realign) {
#line 2741
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2741
      xp = tmp;
#line 2741
    } else {
#line 2741
      xp = (short *) *xpp;
#line 2741
    }
#line 2741
   /* copy the next block */
#line 2741
#pragma cdir loopcnt=LOOPCNT
#line 2741
#pragma cdir shortloop
#line 2741
    for (i=0; i<ni; i++) {
#line 2741
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2741
     /* test for range errors (not always needed but do it anyway) */
#line 2741
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2741
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2741
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 2741
    }
#line 2741
   /* update xpp and tp */
#line 2741
    if (realign) xp = (short *) *xpp;
#line 2741
    xp += ni;
#line 2741
    tp += ni;
#line 2741
    *xpp = (void*)xp;
#line 2741
  }
#line 2741
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2741

#line 2741
#else   /* not SX */
#line 2741
	const char *xp = (const char *) *xpp;
#line 2741
	int status = NC_NOERR;
#line 2741

#line 2741
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2741
	{
#line 2741
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2741
		if(lstatus != NC_NOERR)
#line 2741
			status = lstatus;
#line 2741
	}
#line 2741

#line 2741
	*xpp = (const void *)xp;
#line 2741
	return status;
#line 2741
#  endif
#line 2741
}
#line 2741

int
#line 2742
ncx_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2742
{
#line 2742
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2742

#line 2742
 /* basic algorithm is:
#line 2742
  *   - ensure sane alignment of input data
#line 2742
  *   - copy (conversion happens automatically) input data
#line 2742
  *     to output
#line 2742
  *   - update xpp to point at next unconverted input, and tp to point
#line 2742
  *     at next location for converted output
#line 2742
  */
#line 2742
  long i, j, ni;
#line 2742
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2742
  short *xp;
#line 2742
  int nrange = 0;         /* number of range errors */
#line 2742
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2742
  long cxp = (long) *((char**)xpp);
#line 2742

#line 2742
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2742
  /* sjl: manually stripmine so we can limit amount of
#line 2742
   * vector work space reserved to LOOPCNT elements. Also
#line 2742
   * makes vectorisation easy */
#line 2742
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2742
    ni=Min(nelems-j,LOOPCNT);
#line 2742
    if (realign) {
#line 2742
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2742
      xp = tmp;
#line 2742
    } else {
#line 2742
      xp = (short *) *xpp;
#line 2742
    }
#line 2742
   /* copy the next block */
#line 2742
#pragma cdir loopcnt=LOOPCNT
#line 2742
#pragma cdir shortloop
#line 2742
    for (i=0; i<ni; i++) {
#line 2742
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2742
     /* test for range errors (not always needed but do it anyway) */
#line 2742
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2742
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2742
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 2742
    }
#line 2742
   /* update xpp and tp */
#line 2742
    if (realign) xp = (short *) *xpp;
#line 2742
    xp += ni;
#line 2742
    tp += ni;
#line 2742
    *xpp = (void*)xp;
#line 2742
  }
#line 2742
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2742

#line 2742
#else   /* not SX */
#line 2742
	const char *xp = (const char *) *xpp;
#line 2742
	int status = NC_NOERR;
#line 2742

#line 2742
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2742
	{
#line 2742
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2742
		if(lstatus != NC_NOERR)
#line 2742
			status = lstatus;
#line 2742
	}
#line 2742

#line 2742
	*xpp = (const void *)xp;
#line 2742
	return status;
#line 2742
#  endif
#line 2742
}
#line 2742

int
#line 2743
ncx_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2743
{
#line 2743
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2743

#line 2743
 /* basic algorithm is:
#line 2743
  *   - ensure sane alignment of input data
#line 2743
  *   - copy (conversion happens automatically) input data
#line 2743
  *     to output
#line 2743
  *   - update xpp to point at next unconverted input, and tp to point
#line 2743
  *     at next location for converted output
#line 2743
  */
#line 2743
  long i, j, ni;
#line 2743
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2743
  short *xp;
#line 2743
  int nrange = 0;         /* number of range errors */
#line 2743
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2743
  long cxp = (long) *((char**)xpp);
#line 2743

#line 2743
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2743
  /* sjl: manually stripmine so we can limit amount of
#line 2743
   * vector work space reserved to LOOPCNT elements. Also
#line 2743
   * makes vectorisation easy */
#line 2743
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2743
    ni=Min(nelems-j,LOOPCNT);
#line 2743
    if (realign) {
#line 2743
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2743
      xp = tmp;
#line 2743
    } else {
#line 2743
      xp = (short *) *xpp;
#line 2743
    }
#line 2743
   /* copy the next block */
#line 2743
#pragma cdir loopcnt=LOOPCNT
#line 2743
#pragma cdir shortloop
#line 2743
    for (i=0; i<ni; i++) {
#line 2743
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2743
     /* test for range errors (not always needed but do it anyway) */
#line 2743
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2743
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2743
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 2743
    }
#line 2743
   /* update xpp and tp */
#line 2743
    if (realign) xp = (short *) *xpp;
#line 2743
    xp += ni;
#line 2743
    tp += ni;
#line 2743
    *xpp = (void*)xp;
#line 2743
  }
#line 2743
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2743

#line 2743
#else   /* not SX */
#line 2743
	const char *xp = (const char *) *xpp;
#line 2743
	int status = NC_NOERR;
#line 2743

#line 2743
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2743
	{
#line 2743
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 2743
		if(lstatus != NC_NOERR)
#line 2743
			status = lstatus;
#line 2743
	}
#line 2743

#line 2743
	*xpp = (const void *)xp;
#line 2743
	return status;
#line 2743
#  endif
#line 2743
}
#line 2743

int
#line 2744
ncx_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2744
{
#line 2744
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2744

#line 2744
 /* basic algorithm is:
#line 2744
  *   - ensure sane alignment of input data
#line 2744
  *   - copy (conversion happens automatically) input data
#line 2744
  *     to output
#line 2744
  *   - update xpp to point at next unconverted input, and tp to point
#line 2744
  *     at next location for converted output
#line 2744
  */
#line 2744
  long i, j, ni;
#line 2744
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2744
  short *xp;
#line 2744
  int nrange = 0;         /* number of range errors */
#line 2744
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2744
  long cxp = (long) *((char**)xpp);
#line 2744

#line 2744
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2744
  /* sjl: manually stripmine so we can limit amount of
#line 2744
   * vector work space reserved to LOOPCNT elements. Also
#line 2744
   * makes vectorisation easy */
#line 2744
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2744
    ni=Min(nelems-j,LOOPCNT);
#line 2744
    if (realign) {
#line 2744
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2744
      xp = tmp;
#line 2744
    } else {
#line 2744
      xp = (short *) *xpp;
#line 2744
    }
#line 2744
   /* copy the next block */
#line 2744
#pragma cdir loopcnt=LOOPCNT
#line 2744
#pragma cdir shortloop
#line 2744
    for (i=0; i<ni; i++) {
#line 2744
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2744
     /* test for range errors (not always needed but do it anyway) */
#line 2744
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2744
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2744
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 2744
    }
#line 2744
   /* update xpp and tp */
#line 2744
    if (realign) xp = (short *) *xpp;
#line 2744
    xp += ni;
#line 2744
    tp += ni;
#line 2744
    *xpp = (void*)xp;
#line 2744
  }
#line 2744
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2744

#line 2744
#else   /* not SX */
#line 2744
	const char *xp = (const char *) *xpp;
#line 2744
	int status = NC_NOERR;
#line 2744

#line 2744
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2744
	{
#line 2744
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2744
		if(lstatus != NC_NOERR)
#line 2744
			status = lstatus;
#line 2744
	}
#line 2744

#line 2744
	*xpp = (const void *)xp;
#line 2744
	return status;
#line 2744
#  endif
#line 2744
}
#line 2744

int
#line 2745
ncx_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2745
{
#line 2745
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2745

#line 2745
 /* basic algorithm is:
#line 2745
  *   - ensure sane alignment of input data
#line 2745
  *   - copy (conversion happens automatically) input data
#line 2745
  *     to output
#line 2745
  *   - update xpp to point at next unconverted input, and tp to point
#line 2745
  *     at next location for converted output
#line 2745
  */
#line 2745
  long i, j, ni;
#line 2745
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2745
  short *xp;
#line 2745
  int nrange = 0;         /* number of range errors */
#line 2745
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2745
  long cxp = (long) *((char**)xpp);
#line 2745

#line 2745
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2745
  /* sjl: manually stripmine so we can limit amount of
#line 2745
   * vector work space reserved to LOOPCNT elements. Also
#line 2745
   * makes vectorisation easy */
#line 2745
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2745
    ni=Min(nelems-j,LOOPCNT);
#line 2745
    if (realign) {
#line 2745
      memcpy(tmp, *xpp, ni*SIZEOF_SHORT);
#line 2745
      xp = tmp;
#line 2745
    } else {
#line 2745
      xp = (short *) *xpp;
#line 2745
    }
#line 2745
   /* copy the next block */
#line 2745
#pragma cdir loopcnt=LOOPCNT
#line 2745
#pragma cdir shortloop
#line 2745
    for (i=0; i<ni; i++) {
#line 2745
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2745
     /* test for range errors (not always needed but do it anyway) */
#line 2745
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2745
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2745
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 2745
    }
#line 2745
   /* update xpp and tp */
#line 2745
    if (realign) xp = (short *) *xpp;
#line 2745
    xp += ni;
#line 2745
    tp += ni;
#line 2745
    *xpp = (void*)xp;
#line 2745
  }
#line 2745
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2745

#line 2745
#else   /* not SX */
#line 2745
	const char *xp = (const char *) *xpp;
#line 2745
	int status = NC_NOERR;
#line 2745

#line 2745
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2745
	{
#line 2745
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2745
		if(lstatus != NC_NOERR)
#line 2745
			status = lstatus;
#line 2745
	}
#line 2745

#line 2745
	*xpp = (const void *)xp;
#line 2745
	return status;
#line 2745
#  endif
#line 2745
}
#line 2745


int
#line 2747
ncx_pad_getn_short_schar(const void **xpp, size_t nelems, schar *tp)
#line 2747
{
#line 2747
	const size_t rndup = nelems % 2;
#line 2747

#line 2747
	const char *xp = (const char *) *xpp;
#line 2747
	int status = NC_NOERR;
#line 2747

#line 2747
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2747
	{
#line 2747
		const int lstatus = ncx_get_short_schar(xp, tp);
#line 2747
		if(lstatus != NC_NOERR)
#line 2747
			status = lstatus;
#line 2747
	}
#line 2747

#line 2747
	if(rndup != 0)
#line 2747
		xp += X_SIZEOF_SHORT;
#line 2747
	*xpp = (void *)xp;
#line 2747
	return status;
#line 2747
}
#line 2747

int
#line 2748
ncx_pad_getn_short_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2748
{
#line 2748
	const size_t rndup = nelems % 2;
#line 2748

#line 2748
	const char *xp = (const char *) *xpp;
#line 2748
	int status = NC_NOERR;
#line 2748

#line 2748
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2748
	{
#line 2748
		const int lstatus = ncx_get_short_uchar(xp, tp);
#line 2748
		if(lstatus != NC_NOERR)
#line 2748
			status = lstatus;
#line 2748
	}
#line 2748

#line 2748
	if(rndup != 0)
#line 2748
		xp += X_SIZEOF_SHORT;
#line 2748
	*xpp = (void *)xp;
#line 2748
	return status;
#line 2748
}
#line 2748

int
#line 2749
ncx_pad_getn_short_short(const void **xpp, size_t nelems, short *tp)
#line 2749
{
#line 2749
	const size_t rndup = nelems % 2;
#line 2749

#line 2749
	const char *xp = (const char *) *xpp;
#line 2749
	int status = NC_NOERR;
#line 2749

#line 2749
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2749
	{
#line 2749
		const int lstatus = ncx_get_short_short(xp, tp);
#line 2749
		if(lstatus != NC_NOERR)
#line 2749
			status = lstatus;
#line 2749
	}
#line 2749

#line 2749
	if(rndup != 0)
#line 2749
		xp += X_SIZEOF_SHORT;
#line 2749
	*xpp = (void *)xp;
#line 2749
	return status;
#line 2749
}
#line 2749

int
#line 2750
ncx_pad_getn_short_int(const void **xpp, size_t nelems, int *tp)
#line 2750
{
#line 2750
	const size_t rndup = nelems % 2;
#line 2750

#line 2750
	const char *xp = (const char *) *xpp;
#line 2750
	int status = NC_NOERR;
#line 2750

#line 2750
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2750
	{
#line 2750
		const int lstatus = ncx_get_short_int(xp, tp);
#line 2750
		if(lstatus != NC_NOERR)
#line 2750
			status = lstatus;
#line 2750
	}
#line 2750

#line 2750
	if(rndup != 0)
#line 2750
		xp += X_SIZEOF_SHORT;
#line 2750
	*xpp = (void *)xp;
#line 2750
	return status;
#line 2750
}
#line 2750

int
#line 2751
ncx_pad_getn_short_float(const void **xpp, size_t nelems, float *tp)
#line 2751
{
#line 2751
	const size_t rndup = nelems % 2;
#line 2751

#line 2751
	const char *xp = (const char *) *xpp;
#line 2751
	int status = NC_NOERR;
#line 2751

#line 2751
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2751
	{
#line 2751
		const int lstatus = ncx_get_short_float(xp, tp);
#line 2751
		if(lstatus != NC_NOERR)
#line 2751
			status = lstatus;
#line 2751
	}
#line 2751

#line 2751
	if(rndup != 0)
#line 2751
		xp += X_SIZEOF_SHORT;
#line 2751
	*xpp = (void *)xp;
#line 2751
	return status;
#line 2751
}
#line 2751

int
#line 2752
ncx_pad_getn_short_double(const void **xpp, size_t nelems, double *tp)
#line 2752
{
#line 2752
	const size_t rndup = nelems % 2;
#line 2752

#line 2752
	const char *xp = (const char *) *xpp;
#line 2752
	int status = NC_NOERR;
#line 2752

#line 2752
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2752
	{
#line 2752
		const int lstatus = ncx_get_short_double(xp, tp);
#line 2752
		if(lstatus != NC_NOERR)
#line 2752
			status = lstatus;
#line 2752
	}
#line 2752

#line 2752
	if(rndup != 0)
#line 2752
		xp += X_SIZEOF_SHORT;
#line 2752
	*xpp = (void *)xp;
#line 2752
	return status;
#line 2752
}
#line 2752

int
#line 2753
ncx_pad_getn_short_uint(const void **xpp, size_t nelems, uint *tp)
#line 2753
{
#line 2753
	const size_t rndup = nelems % 2;
#line 2753

#line 2753
	const char *xp = (const char *) *xpp;
#line 2753
	int status = NC_NOERR;
#line 2753

#line 2753
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2753
	{
#line 2753
		const int lstatus = ncx_get_short_uint(xp, tp);
#line 2753
		if(lstatus != NC_NOERR)
#line 2753
			status = lstatus;
#line 2753
	}
#line 2753

#line 2753
	if(rndup != 0)
#line 2753
		xp += X_SIZEOF_SHORT;
#line 2753
	*xpp = (void *)xp;
#line 2753
	return status;
#line 2753
}
#line 2753

int
#line 2754
ncx_pad_getn_short_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2754
{
#line 2754
	const size_t rndup = nelems % 2;
#line 2754

#line 2754
	const char *xp = (const char *) *xpp;
#line 2754
	int status = NC_NOERR;
#line 2754

#line 2754
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2754
	{
#line 2754
		const int lstatus = ncx_get_short_longlong(xp, tp);
#line 2754
		if(lstatus != NC_NOERR)
#line 2754
			status = lstatus;
#line 2754
	}
#line 2754

#line 2754
	if(rndup != 0)
#line 2754
		xp += X_SIZEOF_SHORT;
#line 2754
	*xpp = (void *)xp;
#line 2754
	return status;
#line 2754
}
#line 2754

int
#line 2755
ncx_pad_getn_short_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2755
{
#line 2755
	const size_t rndup = nelems % 2;
#line 2755

#line 2755
	const char *xp = (const char *) *xpp;
#line 2755
	int status = NC_NOERR;
#line 2755

#line 2755
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2755
	{
#line 2755
		const int lstatus = ncx_get_short_ulonglong(xp, tp);
#line 2755
		if(lstatus != NC_NOERR)
#line 2755
			status = lstatus;
#line 2755
	}
#line 2755

#line 2755
	if(rndup != 0)
#line 2755
		xp += X_SIZEOF_SHORT;
#line 2755
	*xpp = (void *)xp;
#line 2755
	return status;
#line 2755
}
#line 2755

int
#line 2756
ncx_pad_getn_short_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2756
{
#line 2756
	const size_t rndup = nelems % 2;
#line 2756

#line 2756
	const char *xp = (const char *) *xpp;
#line 2756
	int status = NC_NOERR;
#line 2756

#line 2756
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2756
	{
#line 2756
		const int lstatus = ncx_get_short_ushort(xp, tp);
#line 2756
		if(lstatus != NC_NOERR)
#line 2756
			status = lstatus;
#line 2756
	}
#line 2756

#line 2756
	if(rndup != 0)
#line 2756
		xp += X_SIZEOF_SHORT;
#line 2756
	*xpp = (void *)xp;
#line 2756
	return status;
#line 2756
}
#line 2756


#if X_SIZEOF_SHORT == SIZEOF_SHORT
/* optimized version */
int
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_SHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_SHORT);
	return NC_NOERR;
}
#else
int
#line 2772
ncx_putn_short_short(void **xpp, size_t nelems, const short *tp)
#line 2772
{
#line 2772
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2772

#line 2772
 /* basic algorithm is:
#line 2772
  *   - ensure sane alignment of output data
#line 2772
  *   - copy (conversion happens automatically) input data
#line 2772
  *     to output
#line 2772
  *   - update tp to point at next unconverted input, and xpp to point
#line 2772
  *     at next location for converted output
#line 2772
  */
#line 2772
  long i, j, ni;
#line 2772
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2772
  short *xp;
#line 2772
  int nrange = 0;         /* number of range errors */
#line 2772
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2772
  long cxp = (long) *((char**)xpp);
#line 2772

#line 2772
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2772
  /* sjl: manually stripmine so we can limit amount of
#line 2772
   * vector work space reserved to LOOPCNT elements. Also
#line 2772
   * makes vectorisation easy */
#line 2772
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2772
    ni=Min(nelems-j,LOOPCNT);
#line 2772
    if (realign) {
#line 2772
      xp = tmp;
#line 2772
    } else {
#line 2772
      xp = (short *) *xpp;
#line 2772
    }
#line 2772
   /* copy the next block */
#line 2772
#pragma cdir loopcnt=LOOPCNT
#line 2772
#pragma cdir shortloop
#line 2772
    for (i=0; i<ni; i++) {
#line 2772
      /* the normal case: */
#line 2772
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2772
     /* test for range errors (not always needed but do it anyway) */
#line 2772
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2772
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2772
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2772
    }
#line 2772
   /* copy workspace back if necessary */
#line 2772
    if (realign) {
#line 2772
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2772
      xp = (short *) *xpp;
#line 2772
    }
#line 2772
   /* update xpp and tp */
#line 2772
    xp += ni;
#line 2772
    tp += ni;
#line 2772
    *xpp = (void*)xp;
#line 2772
  }
#line 2772
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2772

#line 2772
#else   /* not SX */
#line 2772

#line 2772
	char *xp = (char *) *xpp;
#line 2772
	int status = NC_NOERR;
#line 2772

#line 2772
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2772
	{
#line 2772
		int lstatus = ncx_put_short_short(xp, tp);
#line 2772
		if(lstatus != NC_NOERR)
#line 2772
			status = lstatus;
#line 2772
	}
#line 2772

#line 2772
	*xpp = (void *)xp;
#line 2772
	return status;
#line 2772
#endif
#line 2772
}
#line 2772

#endif
int
#line 2774
ncx_putn_short_schar(void **xpp, size_t nelems, const schar *tp)
#line 2774
{
#line 2774
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2774

#line 2774
 /* basic algorithm is:
#line 2774
  *   - ensure sane alignment of output data
#line 2774
  *   - copy (conversion happens automatically) input data
#line 2774
  *     to output
#line 2774
  *   - update tp to point at next unconverted input, and xpp to point
#line 2774
  *     at next location for converted output
#line 2774
  */
#line 2774
  long i, j, ni;
#line 2774
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2774
  short *xp;
#line 2774
  int nrange = 0;         /* number of range errors */
#line 2774
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2774
  long cxp = (long) *((char**)xpp);
#line 2774

#line 2774
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2774
  /* sjl: manually stripmine so we can limit amount of
#line 2774
   * vector work space reserved to LOOPCNT elements. Also
#line 2774
   * makes vectorisation easy */
#line 2774
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2774
    ni=Min(nelems-j,LOOPCNT);
#line 2774
    if (realign) {
#line 2774
      xp = tmp;
#line 2774
    } else {
#line 2774
      xp = (short *) *xpp;
#line 2774
    }
#line 2774
   /* copy the next block */
#line 2774
#pragma cdir loopcnt=LOOPCNT
#line 2774
#pragma cdir shortloop
#line 2774
    for (i=0; i<ni; i++) {
#line 2774
      /* the normal case: */
#line 2774
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2774
     /* test for range errors (not always needed but do it anyway) */
#line 2774
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2774
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2774
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2774
    }
#line 2774
   /* copy workspace back if necessary */
#line 2774
    if (realign) {
#line 2774
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2774
      xp = (short *) *xpp;
#line 2774
    }
#line 2774
   /* update xpp and tp */
#line 2774
    xp += ni;
#line 2774
    tp += ni;
#line 2774
    *xpp = (void*)xp;
#line 2774
  }
#line 2774
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2774

#line 2774
#else   /* not SX */
#line 2774

#line 2774
	char *xp = (char *) *xpp;
#line 2774
	int status = NC_NOERR;
#line 2774

#line 2774
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2774
	{
#line 2774
		int lstatus = ncx_put_short_schar(xp, tp);
#line 2774
		if(lstatus != NC_NOERR)
#line 2774
			status = lstatus;
#line 2774
	}
#line 2774

#line 2774
	*xpp = (void *)xp;
#line 2774
	return status;
#line 2774
#endif
#line 2774
}
#line 2774

int
#line 2775
ncx_putn_short_int(void **xpp, size_t nelems, const int *tp)
#line 2775
{
#line 2775
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2775

#line 2775
 /* basic algorithm is:
#line 2775
  *   - ensure sane alignment of output data
#line 2775
  *   - copy (conversion happens automatically) input data
#line 2775
  *     to output
#line 2775
  *   - update tp to point at next unconverted input, and xpp to point
#line 2775
  *     at next location for converted output
#line 2775
  */
#line 2775
  long i, j, ni;
#line 2775
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2775
  short *xp;
#line 2775
  int nrange = 0;         /* number of range errors */
#line 2775
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2775
  long cxp = (long) *((char**)xpp);
#line 2775

#line 2775
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2775
  /* sjl: manually stripmine so we can limit amount of
#line 2775
   * vector work space reserved to LOOPCNT elements. Also
#line 2775
   * makes vectorisation easy */
#line 2775
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2775
    ni=Min(nelems-j,LOOPCNT);
#line 2775
    if (realign) {
#line 2775
      xp = tmp;
#line 2775
    } else {
#line 2775
      xp = (short *) *xpp;
#line 2775
    }
#line 2775
   /* copy the next block */
#line 2775
#pragma cdir loopcnt=LOOPCNT
#line 2775
#pragma cdir shortloop
#line 2775
    for (i=0; i<ni; i++) {
#line 2775
      /* the normal case: */
#line 2775
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2775
     /* test for range errors (not always needed but do it anyway) */
#line 2775
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2775
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2775
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2775
    }
#line 2775
   /* copy workspace back if necessary */
#line 2775
    if (realign) {
#line 2775
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2775
      xp = (short *) *xpp;
#line 2775
    }
#line 2775
   /* update xpp and tp */
#line 2775
    xp += ni;
#line 2775
    tp += ni;
#line 2775
    *xpp = (void*)xp;
#line 2775
  }
#line 2775
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2775

#line 2775
#else   /* not SX */
#line 2775

#line 2775
	char *xp = (char *) *xpp;
#line 2775
	int status = NC_NOERR;
#line 2775

#line 2775
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2775
	{
#line 2775
		int lstatus = ncx_put_short_int(xp, tp);
#line 2775
		if(lstatus != NC_NOERR)
#line 2775
			status = lstatus;
#line 2775
	}
#line 2775

#line 2775
	*xpp = (void *)xp;
#line 2775
	return status;
#line 2775
#endif
#line 2775
}
#line 2775

int
#line 2776
ncx_putn_short_float(void **xpp, size_t nelems, const float *tp)
#line 2776
{
#line 2776
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2776

#line 2776
 /* basic algorithm is:
#line 2776
  *   - ensure sane alignment of output data
#line 2776
  *   - copy (conversion happens automatically) input data
#line 2776
  *     to output
#line 2776
  *   - update tp to point at next unconverted input, and xpp to point
#line 2776
  *     at next location for converted output
#line 2776
  */
#line 2776
  long i, j, ni;
#line 2776
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2776
  short *xp;
#line 2776
  int nrange = 0;         /* number of range errors */
#line 2776
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2776
  long cxp = (long) *((char**)xpp);
#line 2776

#line 2776
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2776
  /* sjl: manually stripmine so we can limit amount of
#line 2776
   * vector work space reserved to LOOPCNT elements. Also
#line 2776
   * makes vectorisation easy */
#line 2776
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2776
    ni=Min(nelems-j,LOOPCNT);
#line 2776
    if (realign) {
#line 2776
      xp = tmp;
#line 2776
    } else {
#line 2776
      xp = (short *) *xpp;
#line 2776
    }
#line 2776
   /* copy the next block */
#line 2776
#pragma cdir loopcnt=LOOPCNT
#line 2776
#pragma cdir shortloop
#line 2776
    for (i=0; i<ni; i++) {
#line 2776
      /* the normal case: */
#line 2776
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2776
     /* test for range errors (not always needed but do it anyway) */
#line 2776
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2776
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2776
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2776
    }
#line 2776
   /* copy workspace back if necessary */
#line 2776
    if (realign) {
#line 2776
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2776
      xp = (short *) *xpp;
#line 2776
    }
#line 2776
   /* update xpp and tp */
#line 2776
    xp += ni;
#line 2776
    tp += ni;
#line 2776
    *xpp = (void*)xp;
#line 2776
  }
#line 2776
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2776

#line 2776
#else   /* not SX */
#line 2776

#line 2776
	char *xp = (char *) *xpp;
#line 2776
	int status = NC_NOERR;
#line 2776

#line 2776
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2776
	{
#line 2776
		int lstatus = ncx_put_short_float(xp, tp);
#line 2776
		if(lstatus != NC_NOERR)
#line 2776
			status = lstatus;
#line 2776
	}
#line 2776

#line 2776
	*xpp = (void *)xp;
#line 2776
	return status;
#line 2776
#endif
#line 2776
}
#line 2776

int
#line 2777
ncx_putn_short_double(void **xpp, size_t nelems, const double *tp)
#line 2777
{
#line 2777
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2777

#line 2777
 /* basic algorithm is:
#line 2777
  *   - ensure sane alignment of output data
#line 2777
  *   - copy (conversion happens automatically) input data
#line 2777
  *     to output
#line 2777
  *   - update tp to point at next unconverted input, and xpp to point
#line 2777
  *     at next location for converted output
#line 2777
  */
#line 2777
  long i, j, ni;
#line 2777
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2777
  short *xp;
#line 2777
  int nrange = 0;         /* number of range errors */
#line 2777
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2777
  long cxp = (long) *((char**)xpp);
#line 2777

#line 2777
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2777
  /* sjl: manually stripmine so we can limit amount of
#line 2777
   * vector work space reserved to LOOPCNT elements. Also
#line 2777
   * makes vectorisation easy */
#line 2777
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2777
    ni=Min(nelems-j,LOOPCNT);
#line 2777
    if (realign) {
#line 2777
      xp = tmp;
#line 2777
    } else {
#line 2777
      xp = (short *) *xpp;
#line 2777
    }
#line 2777
   /* copy the next block */
#line 2777
#pragma cdir loopcnt=LOOPCNT
#line 2777
#pragma cdir shortloop
#line 2777
    for (i=0; i<ni; i++) {
#line 2777
      /* the normal case: */
#line 2777
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2777
     /* test for range errors (not always needed but do it anyway) */
#line 2777
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2777
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2777
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2777
    }
#line 2777
   /* copy workspace back if necessary */
#line 2777
    if (realign) {
#line 2777
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2777
      xp = (short *) *xpp;
#line 2777
    }
#line 2777
   /* update xpp and tp */
#line 2777
    xp += ni;
#line 2777
    tp += ni;
#line 2777
    *xpp = (void*)xp;
#line 2777
  }
#line 2777
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2777

#line 2777
#else   /* not SX */
#line 2777

#line 2777
	char *xp = (char *) *xpp;
#line 2777
	int status = NC_NOERR;
#line 2777

#line 2777
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2777
	{
#line 2777
		int lstatus = ncx_put_short_double(xp, tp);
#line 2777
		if(lstatus != NC_NOERR)
#line 2777
			status = lstatus;
#line 2777
	}
#line 2777

#line 2777
	*xpp = (void *)xp;
#line 2777
	return status;
#line 2777
#endif
#line 2777
}
#line 2777

int
#line 2778
ncx_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2778
{
#line 2778
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2778

#line 2778
 /* basic algorithm is:
#line 2778
  *   - ensure sane alignment of output data
#line 2778
  *   - copy (conversion happens automatically) input data
#line 2778
  *     to output
#line 2778
  *   - update tp to point at next unconverted input, and xpp to point
#line 2778
  *     at next location for converted output
#line 2778
  */
#line 2778
  long i, j, ni;
#line 2778
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2778
  short *xp;
#line 2778
  int nrange = 0;         /* number of range errors */
#line 2778
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2778
  long cxp = (long) *((char**)xpp);
#line 2778

#line 2778
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2778
  /* sjl: manually stripmine so we can limit amount of
#line 2778
   * vector work space reserved to LOOPCNT elements. Also
#line 2778
   * makes vectorisation easy */
#line 2778
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2778
    ni=Min(nelems-j,LOOPCNT);
#line 2778
    if (realign) {
#line 2778
      xp = tmp;
#line 2778
    } else {
#line 2778
      xp = (short *) *xpp;
#line 2778
    }
#line 2778
   /* copy the next block */
#line 2778
#pragma cdir loopcnt=LOOPCNT
#line 2778
#pragma cdir shortloop
#line 2778
    for (i=0; i<ni; i++) {
#line 2778
      /* the normal case: */
#line 2778
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2778
     /* test for range errors (not always needed but do it anyway) */
#line 2778
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2778
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2778
      nrange += tp[i] > X_SHORT_MAX || tp[i] < X_SHORT_MIN;
#line 2778
    }
#line 2778
   /* copy workspace back if necessary */
#line 2778
    if (realign) {
#line 2778
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2778
      xp = (short *) *xpp;
#line 2778
    }
#line 2778
   /* update xpp and tp */
#line 2778
    xp += ni;
#line 2778
    tp += ni;
#line 2778
    *xpp = (void*)xp;
#line 2778
  }
#line 2778
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2778

#line 2778
#else   /* not SX */
#line 2778

#line 2778
	char *xp = (char *) *xpp;
#line 2778
	int status = NC_NOERR;
#line 2778

#line 2778
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2778
	{
#line 2778
		int lstatus = ncx_put_short_longlong(xp, tp);
#line 2778
		if(lstatus != NC_NOERR)
#line 2778
			status = lstatus;
#line 2778
	}
#line 2778

#line 2778
	*xpp = (void *)xp;
#line 2778
	return status;
#line 2778
#endif
#line 2778
}
#line 2778

int
#line 2779
ncx_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2779
{
#line 2779
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2779

#line 2779
 /* basic algorithm is:
#line 2779
  *   - ensure sane alignment of output data
#line 2779
  *   - copy (conversion happens automatically) input data
#line 2779
  *     to output
#line 2779
  *   - update tp to point at next unconverted input, and xpp to point
#line 2779
  *     at next location for converted output
#line 2779
  */
#line 2779
  long i, j, ni;
#line 2779
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2779
  short *xp;
#line 2779
  int nrange = 0;         /* number of range errors */
#line 2779
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2779
  long cxp = (long) *((char**)xpp);
#line 2779

#line 2779
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2779
  /* sjl: manually stripmine so we can limit amount of
#line 2779
   * vector work space reserved to LOOPCNT elements. Also
#line 2779
   * makes vectorisation easy */
#line 2779
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2779
    ni=Min(nelems-j,LOOPCNT);
#line 2779
    if (realign) {
#line 2779
      xp = tmp;
#line 2779
    } else {
#line 2779
      xp = (short *) *xpp;
#line 2779
    }
#line 2779
   /* copy the next block */
#line 2779
#pragma cdir loopcnt=LOOPCNT
#line 2779
#pragma cdir shortloop
#line 2779
    for (i=0; i<ni; i++) {
#line 2779
      /* the normal case: */
#line 2779
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2779
     /* test for range errors (not always needed but do it anyway) */
#line 2779
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2779
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2779
      nrange += tp[i] > X_SHORT_MAX ;
#line 2779
    }
#line 2779
   /* copy workspace back if necessary */
#line 2779
    if (realign) {
#line 2779
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2779
      xp = (short *) *xpp;
#line 2779
    }
#line 2779
   /* update xpp and tp */
#line 2779
    xp += ni;
#line 2779
    tp += ni;
#line 2779
    *xpp = (void*)xp;
#line 2779
  }
#line 2779
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2779

#line 2779
#else   /* not SX */
#line 2779

#line 2779
	char *xp = (char *) *xpp;
#line 2779
	int status = NC_NOERR;
#line 2779

#line 2779
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2779
	{
#line 2779
		int lstatus = ncx_put_short_uchar(xp, tp);
#line 2779
		if(lstatus != NC_NOERR)
#line 2779
			status = lstatus;
#line 2779
	}
#line 2779

#line 2779
	*xpp = (void *)xp;
#line 2779
	return status;
#line 2779
#endif
#line 2779
}
#line 2779

int
#line 2780
ncx_putn_short_uint(void **xpp, size_t nelems, const uint *tp)
#line 2780
{
#line 2780
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2780

#line 2780
 /* basic algorithm is:
#line 2780
  *   - ensure sane alignment of output data
#line 2780
  *   - copy (conversion happens automatically) input data
#line 2780
  *     to output
#line 2780
  *   - update tp to point at next unconverted input, and xpp to point
#line 2780
  *     at next location for converted output
#line 2780
  */
#line 2780
  long i, j, ni;
#line 2780
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2780
  short *xp;
#line 2780
  int nrange = 0;         /* number of range errors */
#line 2780
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2780
  long cxp = (long) *((char**)xpp);
#line 2780

#line 2780
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2780
  /* sjl: manually stripmine so we can limit amount of
#line 2780
   * vector work space reserved to LOOPCNT elements. Also
#line 2780
   * makes vectorisation easy */
#line 2780
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2780
    ni=Min(nelems-j,LOOPCNT);
#line 2780
    if (realign) {
#line 2780
      xp = tmp;
#line 2780
    } else {
#line 2780
      xp = (short *) *xpp;
#line 2780
    }
#line 2780
   /* copy the next block */
#line 2780
#pragma cdir loopcnt=LOOPCNT
#line 2780
#pragma cdir shortloop
#line 2780
    for (i=0; i<ni; i++) {
#line 2780
      /* the normal case: */
#line 2780
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2780
     /* test for range errors (not always needed but do it anyway) */
#line 2780
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2780
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2780
      nrange += tp[i] > X_SHORT_MAX ;
#line 2780
    }
#line 2780
   /* copy workspace back if necessary */
#line 2780
    if (realign) {
#line 2780
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2780
      xp = (short *) *xpp;
#line 2780
    }
#line 2780
   /* update xpp and tp */
#line 2780
    xp += ni;
#line 2780
    tp += ni;
#line 2780
    *xpp = (void*)xp;
#line 2780
  }
#line 2780
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2780

#line 2780
#else   /* not SX */
#line 2780

#line 2780
	char *xp = (char *) *xpp;
#line 2780
	int status = NC_NOERR;
#line 2780

#line 2780
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2780
	{
#line 2780
		int lstatus = ncx_put_short_uint(xp, tp);
#line 2780
		if(lstatus != NC_NOERR)
#line 2780
			status = lstatus;
#line 2780
	}
#line 2780

#line 2780
	*xpp = (void *)xp;
#line 2780
	return status;
#line 2780
#endif
#line 2780
}
#line 2780

int
#line 2781
ncx_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2781
{
#line 2781
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2781

#line 2781
 /* basic algorithm is:
#line 2781
  *   - ensure sane alignment of output data
#line 2781
  *   - copy (conversion happens automatically) input data
#line 2781
  *     to output
#line 2781
  *   - update tp to point at next unconverted input, and xpp to point
#line 2781
  *     at next location for converted output
#line 2781
  */
#line 2781
  long i, j, ni;
#line 2781
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2781
  short *xp;
#line 2781
  int nrange = 0;         /* number of range errors */
#line 2781
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2781
  long cxp = (long) *((char**)xpp);
#line 2781

#line 2781
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2781
  /* sjl: manually stripmine so we can limit amount of
#line 2781
   * vector work space reserved to LOOPCNT elements. Also
#line 2781
   * makes vectorisation easy */
#line 2781
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2781
    ni=Min(nelems-j,LOOPCNT);
#line 2781
    if (realign) {
#line 2781
      xp = tmp;
#line 2781
    } else {
#line 2781
      xp = (short *) *xpp;
#line 2781
    }
#line 2781
   /* copy the next block */
#line 2781
#pragma cdir loopcnt=LOOPCNT
#line 2781
#pragma cdir shortloop
#line 2781
    for (i=0; i<ni; i++) {
#line 2781
      /* the normal case: */
#line 2781
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2781
     /* test for range errors (not always needed but do it anyway) */
#line 2781
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2781
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2781
      nrange += tp[i] > X_SHORT_MAX ;
#line 2781
    }
#line 2781
   /* copy workspace back if necessary */
#line 2781
    if (realign) {
#line 2781
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2781
      xp = (short *) *xpp;
#line 2781
    }
#line 2781
   /* update xpp and tp */
#line 2781
    xp += ni;
#line 2781
    tp += ni;
#line 2781
    *xpp = (void*)xp;
#line 2781
  }
#line 2781
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2781

#line 2781
#else   /* not SX */
#line 2781

#line 2781
	char *xp = (char *) *xpp;
#line 2781
	int status = NC_NOERR;
#line 2781

#line 2781
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2781
	{
#line 2781
		int lstatus = ncx_put_short_ulonglong(xp, tp);
#line 2781
		if(lstatus != NC_NOERR)
#line 2781
			status = lstatus;
#line 2781
	}
#line 2781

#line 2781
	*xpp = (void *)xp;
#line 2781
	return status;
#line 2781
#endif
#line 2781
}
#line 2781

int
#line 2782
ncx_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2782
{
#line 2782
#if _SX && X_SIZEOF_SHORT == SIZEOF_SHORT
#line 2782

#line 2782
 /* basic algorithm is:
#line 2782
  *   - ensure sane alignment of output data
#line 2782
  *   - copy (conversion happens automatically) input data
#line 2782
  *     to output
#line 2782
  *   - update tp to point at next unconverted input, and xpp to point
#line 2782
  *     at next location for converted output
#line 2782
  */
#line 2782
  long i, j, ni;
#line 2782
  short tmp[LOOPCNT];        /* in case input is misaligned */
#line 2782
  short *xp;
#line 2782
  int nrange = 0;         /* number of range errors */
#line 2782
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2782
  long cxp = (long) *((char**)xpp);
#line 2782

#line 2782
  realign = (cxp & 7) % SIZEOF_SHORT;
#line 2782
  /* sjl: manually stripmine so we can limit amount of
#line 2782
   * vector work space reserved to LOOPCNT elements. Also
#line 2782
   * makes vectorisation easy */
#line 2782
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2782
    ni=Min(nelems-j,LOOPCNT);
#line 2782
    if (realign) {
#line 2782
      xp = tmp;
#line 2782
    } else {
#line 2782
      xp = (short *) *xpp;
#line 2782
    }
#line 2782
   /* copy the next block */
#line 2782
#pragma cdir loopcnt=LOOPCNT
#line 2782
#pragma cdir shortloop
#line 2782
    for (i=0; i<ni; i++) {
#line 2782
      /* the normal case: */
#line 2782
      xp[i] = (short) Max( X_SHORT_MIN, Min(X_SHORT_MAX, (short) tp[i]));
#line 2782
     /* test for range errors (not always needed but do it anyway) */
#line 2782
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2782
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2782
      nrange += tp[i] > X_SHORT_MAX ;
#line 2782
    }
#line 2782
   /* copy workspace back if necessary */
#line 2782
    if (realign) {
#line 2782
      memcpy(*xpp, tmp, ni*X_SIZEOF_SHORT);
#line 2782
      xp = (short *) *xpp;
#line 2782
    }
#line 2782
   /* update xpp and tp */
#line 2782
    xp += ni;
#line 2782
    tp += ni;
#line 2782
    *xpp = (void*)xp;
#line 2782
  }
#line 2782
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2782

#line 2782
#else   /* not SX */
#line 2782

#line 2782
	char *xp = (char *) *xpp;
#line 2782
	int status = NC_NOERR;
#line 2782

#line 2782
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2782
	{
#line 2782
		int lstatus = ncx_put_short_ushort(xp, tp);
#line 2782
		if(lstatus != NC_NOERR)
#line 2782
			status = lstatus;
#line 2782
	}
#line 2782

#line 2782
	*xpp = (void *)xp;
#line 2782
	return status;
#line 2782
#endif
#line 2782
}
#line 2782


int
#line 2784
ncx_pad_putn_short_schar(void **xpp, size_t nelems, const schar *tp)
#line 2784
{
#line 2784
	const size_t rndup = nelems % 2;
#line 2784

#line 2784
	char *xp = (char *) *xpp;
#line 2784
	int status = NC_NOERR;
#line 2784

#line 2784
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2784
	{
#line 2784
		int lstatus = ncx_put_short_schar(xp, tp);
#line 2784
		if(lstatus != NC_NOERR)
#line 2784
			status = lstatus;
#line 2784
	}
#line 2784

#line 2784
	if(rndup != 0)
#line 2784
	{
#line 2784
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2784
		xp += X_SIZEOF_SHORT;
#line 2784
	}
#line 2784

#line 2784
	*xpp = (void *)xp;
#line 2784
	return status;
#line 2784
}
#line 2784

int
#line 2785
ncx_pad_putn_short_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2785
{
#line 2785
	const size_t rndup = nelems % 2;
#line 2785

#line 2785
	char *xp = (char *) *xpp;
#line 2785
	int status = NC_NOERR;
#line 2785

#line 2785
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2785
	{
#line 2785
		int lstatus = ncx_put_short_uchar(xp, tp);
#line 2785
		if(lstatus != NC_NOERR)
#line 2785
			status = lstatus;
#line 2785
	}
#line 2785

#line 2785
	if(rndup != 0)
#line 2785
	{
#line 2785
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2785
		xp += X_SIZEOF_SHORT;
#line 2785
	}
#line 2785

#line 2785
	*xpp = (void *)xp;
#line 2785
	return status;
#line 2785
}
#line 2785

int
#line 2786
ncx_pad_putn_short_short(void **xpp, size_t nelems, const short *tp)
#line 2786
{
#line 2786
	const size_t rndup = nelems % 2;
#line 2786

#line 2786
	char *xp = (char *) *xpp;
#line 2786
	int status = NC_NOERR;
#line 2786

#line 2786
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2786
	{
#line 2786
		int lstatus = ncx_put_short_short(xp, tp);
#line 2786
		if(lstatus != NC_NOERR)
#line 2786
			status = lstatus;
#line 2786
	}
#line 2786

#line 2786
	if(rndup != 0)
#line 2786
	{
#line 2786
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2786
		xp += X_SIZEOF_SHORT;
#line 2786
	}
#line 2786

#line 2786
	*xpp = (void *)xp;
#line 2786
	return status;
#line 2786
}
#line 2786

int
#line 2787
ncx_pad_putn_short_int(void **xpp, size_t nelems, const int *tp)
#line 2787
{
#line 2787
	const size_t rndup = nelems % 2;
#line 2787

#line 2787
	char *xp = (char *) *xpp;
#line 2787
	int status = NC_NOERR;
#line 2787

#line 2787
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2787
	{
#line 2787
		int lstatus = ncx_put_short_int(xp, tp);
#line 2787
		if(lstatus != NC_NOERR)
#line 2787
			status = lstatus;
#line 2787
	}
#line 2787

#line 2787
	if(rndup != 0)
#line 2787
	{
#line 2787
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2787
		xp += X_SIZEOF_SHORT;
#line 2787
	}
#line 2787

#line 2787
	*xpp = (void *)xp;
#line 2787
	return status;
#line 2787
}
#line 2787

int
#line 2788
ncx_pad_putn_short_float(void **xpp, size_t nelems, const float *tp)
#line 2788
{
#line 2788
	const size_t rndup = nelems % 2;
#line 2788

#line 2788
	char *xp = (char *) *xpp;
#line 2788
	int status = NC_NOERR;
#line 2788

#line 2788
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2788
	{
#line 2788
		int lstatus = ncx_put_short_float(xp, tp);
#line 2788
		if(lstatus != NC_NOERR)
#line 2788
			status = lstatus;
#line 2788
	}
#line 2788

#line 2788
	if(rndup != 0)
#line 2788
	{
#line 2788
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2788
		xp += X_SIZEOF_SHORT;
#line 2788
	}
#line 2788

#line 2788
	*xpp = (void *)xp;
#line 2788
	return status;
#line 2788
}
#line 2788

int
#line 2789
ncx_pad_putn_short_double(void **xpp, size_t nelems, const double *tp)
#line 2789
{
#line 2789
	const size_t rndup = nelems % 2;
#line 2789

#line 2789
	char *xp = (char *) *xpp;
#line 2789
	int status = NC_NOERR;
#line 2789

#line 2789
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2789
	{
#line 2789
		int lstatus = ncx_put_short_double(xp, tp);
#line 2789
		if(lstatus != NC_NOERR)
#line 2789
			status = lstatus;
#line 2789
	}
#line 2789

#line 2789
	if(rndup != 0)
#line 2789
	{
#line 2789
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2789
		xp += X_SIZEOF_SHORT;
#line 2789
	}
#line 2789

#line 2789
	*xpp = (void *)xp;
#line 2789
	return status;
#line 2789
}
#line 2789

int
#line 2790
ncx_pad_putn_short_uint(void **xpp, size_t nelems, const uint *tp)
#line 2790
{
#line 2790
	const size_t rndup = nelems % 2;
#line 2790

#line 2790
	char *xp = (char *) *xpp;
#line 2790
	int status = NC_NOERR;
#line 2790

#line 2790
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2790
	{
#line 2790
		int lstatus = ncx_put_short_uint(xp, tp);
#line 2790
		if(lstatus != NC_NOERR)
#line 2790
			status = lstatus;
#line 2790
	}
#line 2790

#line 2790
	if(rndup != 0)
#line 2790
	{
#line 2790
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2790
		xp += X_SIZEOF_SHORT;
#line 2790
	}
#line 2790

#line 2790
	*xpp = (void *)xp;
#line 2790
	return status;
#line 2790
}
#line 2790

int
#line 2791
ncx_pad_putn_short_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2791
{
#line 2791
	const size_t rndup = nelems % 2;
#line 2791

#line 2791
	char *xp = (char *) *xpp;
#line 2791
	int status = NC_NOERR;
#line 2791

#line 2791
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2791
	{
#line 2791
		int lstatus = ncx_put_short_longlong(xp, tp);
#line 2791
		if(lstatus != NC_NOERR)
#line 2791
			status = lstatus;
#line 2791
	}
#line 2791

#line 2791
	if(rndup != 0)
#line 2791
	{
#line 2791
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2791
		xp += X_SIZEOF_SHORT;
#line 2791
	}
#line 2791

#line 2791
	*xpp = (void *)xp;
#line 2791
	return status;
#line 2791
}
#line 2791

int
#line 2792
ncx_pad_putn_short_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2792
{
#line 2792
	const size_t rndup = nelems % 2;
#line 2792

#line 2792
	char *xp = (char *) *xpp;
#line 2792
	int status = NC_NOERR;
#line 2792

#line 2792
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2792
	{
#line 2792
		int lstatus = ncx_put_short_ulonglong(xp, tp);
#line 2792
		if(lstatus != NC_NOERR)
#line 2792
			status = lstatus;
#line 2792
	}
#line 2792

#line 2792
	if(rndup != 0)
#line 2792
	{
#line 2792
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2792
		xp += X_SIZEOF_SHORT;
#line 2792
	}
#line 2792

#line 2792
	*xpp = (void *)xp;
#line 2792
	return status;
#line 2792
}
#line 2792

int
#line 2793
ncx_pad_putn_short_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2793
{
#line 2793
	const size_t rndup = nelems % 2;
#line 2793

#line 2793
	char *xp = (char *) *xpp;
#line 2793
	int status = NC_NOERR;
#line 2793

#line 2793
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_SHORT, tp++)
#line 2793
	{
#line 2793
		int lstatus = ncx_put_short_ushort(xp, tp);
#line 2793
		if(lstatus != NC_NOERR)
#line 2793
			status = lstatus;
#line 2793
	}
#line 2793

#line 2793
	if(rndup != 0)
#line 2793
	{
#line 2793
		(void) memcpy(xp, nada, X_SIZEOF_SHORT);
#line 2793
		xp += X_SIZEOF_SHORT;
#line 2793
	}
#line 2793

#line 2793
	*xpp = (void *)xp;
#line 2793
	return status;
#line 2793
}
#line 2793



/* ushort --------------------------------------------------------------------*/

#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(unsigned short));
# else
	swapn2b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 2812
ncx_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2812
{
#line 2812
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2812

#line 2812
 /* basic algorithm is:
#line 2812
  *   - ensure sane alignment of input data
#line 2812
  *   - copy (conversion happens automatically) input data
#line 2812
  *     to output
#line 2812
  *   - update xpp to point at next unconverted input, and tp to point
#line 2812
  *     at next location for converted output
#line 2812
  */
#line 2812
  long i, j, ni;
#line 2812
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2812
  ushort *xp;
#line 2812
  int nrange = 0;         /* number of range errors */
#line 2812
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2812
  long cxp = (long) *((char**)xpp);
#line 2812

#line 2812
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2812
  /* sjl: manually stripmine so we can limit amount of
#line 2812
   * vector work space reserved to LOOPCNT elements. Also
#line 2812
   * makes vectorisation easy */
#line 2812
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2812
    ni=Min(nelems-j,LOOPCNT);
#line 2812
    if (realign) {
#line 2812
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2812
      xp = tmp;
#line 2812
    } else {
#line 2812
      xp = (ushort *) *xpp;
#line 2812
    }
#line 2812
   /* copy the next block */
#line 2812
#pragma cdir loopcnt=LOOPCNT
#line 2812
#pragma cdir shortloop
#line 2812
    for (i=0; i<ni; i++) {
#line 2812
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2812
     /* test for range errors (not always needed but do it anyway) */
#line 2812
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2812
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2812
      nrange += xp[i] > USHORT_MAX ;
#line 2812
    }
#line 2812
   /* update xpp and tp */
#line 2812
    if (realign) xp = (ushort *) *xpp;
#line 2812
    xp += ni;
#line 2812
    tp += ni;
#line 2812
    *xpp = (void*)xp;
#line 2812
  }
#line 2812
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2812

#line 2812
#else   /* not SX */
#line 2812
	const char *xp = (const char *) *xpp;
#line 2812
	int status = NC_NOERR;
#line 2812

#line 2812
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2812
	{
#line 2812
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 2812
		if(lstatus != NC_NOERR)
#line 2812
			status = lstatus;
#line 2812
	}
#line 2812

#line 2812
	*xpp = (const void *)xp;
#line 2812
	return status;
#line 2812
#  endif
#line 2812
}
#line 2812

#endif
int
#line 2814
ncx_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 2814
{
#line 2814
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2814

#line 2814
 /* basic algorithm is:
#line 2814
  *   - ensure sane alignment of input data
#line 2814
  *   - copy (conversion happens automatically) input data
#line 2814
  *     to output
#line 2814
  *   - update xpp to point at next unconverted input, and tp to point
#line 2814
  *     at next location for converted output
#line 2814
  */
#line 2814
  long i, j, ni;
#line 2814
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2814
  ushort *xp;
#line 2814
  int nrange = 0;         /* number of range errors */
#line 2814
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2814
  long cxp = (long) *((char**)xpp);
#line 2814

#line 2814
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2814
  /* sjl: manually stripmine so we can limit amount of
#line 2814
   * vector work space reserved to LOOPCNT elements. Also
#line 2814
   * makes vectorisation easy */
#line 2814
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2814
    ni=Min(nelems-j,LOOPCNT);
#line 2814
    if (realign) {
#line 2814
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2814
      xp = tmp;
#line 2814
    } else {
#line 2814
      xp = (ushort *) *xpp;
#line 2814
    }
#line 2814
   /* copy the next block */
#line 2814
#pragma cdir loopcnt=LOOPCNT
#line 2814
#pragma cdir shortloop
#line 2814
    for (i=0; i<ni; i++) {
#line 2814
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2814
     /* test for range errors (not always needed but do it anyway) */
#line 2814
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2814
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2814
      nrange += xp[i] > SCHAR_MAX ;
#line 2814
    }
#line 2814
   /* update xpp and tp */
#line 2814
    if (realign) xp = (ushort *) *xpp;
#line 2814
    xp += ni;
#line 2814
    tp += ni;
#line 2814
    *xpp = (void*)xp;
#line 2814
  }
#line 2814
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2814

#line 2814
#else   /* not SX */
#line 2814
	const char *xp = (const char *) *xpp;
#line 2814
	int status = NC_NOERR;
#line 2814

#line 2814
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2814
	{
#line 2814
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 2814
		if(lstatus != NC_NOERR)
#line 2814
			status = lstatus;
#line 2814
	}
#line 2814

#line 2814
	*xpp = (const void *)xp;
#line 2814
	return status;
#line 2814
#  endif
#line 2814
}
#line 2814

int
#line 2815
ncx_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 2815
{
#line 2815
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2815

#line 2815
 /* basic algorithm is:
#line 2815
  *   - ensure sane alignment of input data
#line 2815
  *   - copy (conversion happens automatically) input data
#line 2815
  *     to output
#line 2815
  *   - update xpp to point at next unconverted input, and tp to point
#line 2815
  *     at next location for converted output
#line 2815
  */
#line 2815
  long i, j, ni;
#line 2815
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2815
  ushort *xp;
#line 2815
  int nrange = 0;         /* number of range errors */
#line 2815
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2815
  long cxp = (long) *((char**)xpp);
#line 2815

#line 2815
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2815
  /* sjl: manually stripmine so we can limit amount of
#line 2815
   * vector work space reserved to LOOPCNT elements. Also
#line 2815
   * makes vectorisation easy */
#line 2815
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2815
    ni=Min(nelems-j,LOOPCNT);
#line 2815
    if (realign) {
#line 2815
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2815
      xp = tmp;
#line 2815
    } else {
#line 2815
      xp = (ushort *) *xpp;
#line 2815
    }
#line 2815
   /* copy the next block */
#line 2815
#pragma cdir loopcnt=LOOPCNT
#line 2815
#pragma cdir shortloop
#line 2815
    for (i=0; i<ni; i++) {
#line 2815
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2815
     /* test for range errors (not always needed but do it anyway) */
#line 2815
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2815
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2815
      nrange += xp[i] > SHORT_MAX ;
#line 2815
    }
#line 2815
   /* update xpp and tp */
#line 2815
    if (realign) xp = (ushort *) *xpp;
#line 2815
    xp += ni;
#line 2815
    tp += ni;
#line 2815
    *xpp = (void*)xp;
#line 2815
  }
#line 2815
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2815

#line 2815
#else   /* not SX */
#line 2815
	const char *xp = (const char *) *xpp;
#line 2815
	int status = NC_NOERR;
#line 2815

#line 2815
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2815
	{
#line 2815
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 2815
		if(lstatus != NC_NOERR)
#line 2815
			status = lstatus;
#line 2815
	}
#line 2815

#line 2815
	*xpp = (const void *)xp;
#line 2815
	return status;
#line 2815
#  endif
#line 2815
}
#line 2815

int
#line 2816
ncx_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 2816
{
#line 2816
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2816

#line 2816
 /* basic algorithm is:
#line 2816
  *   - ensure sane alignment of input data
#line 2816
  *   - copy (conversion happens automatically) input data
#line 2816
  *     to output
#line 2816
  *   - update xpp to point at next unconverted input, and tp to point
#line 2816
  *     at next location for converted output
#line 2816
  */
#line 2816
  long i, j, ni;
#line 2816
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2816
  ushort *xp;
#line 2816
  int nrange = 0;         /* number of range errors */
#line 2816
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2816
  long cxp = (long) *((char**)xpp);
#line 2816

#line 2816
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2816
  /* sjl: manually stripmine so we can limit amount of
#line 2816
   * vector work space reserved to LOOPCNT elements. Also
#line 2816
   * makes vectorisation easy */
#line 2816
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2816
    ni=Min(nelems-j,LOOPCNT);
#line 2816
    if (realign) {
#line 2816
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2816
      xp = tmp;
#line 2816
    } else {
#line 2816
      xp = (ushort *) *xpp;
#line 2816
    }
#line 2816
   /* copy the next block */
#line 2816
#pragma cdir loopcnt=LOOPCNT
#line 2816
#pragma cdir shortloop
#line 2816
    for (i=0; i<ni; i++) {
#line 2816
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2816
     /* test for range errors (not always needed but do it anyway) */
#line 2816
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2816
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2816
      nrange += xp[i] > INT_MAX ;
#line 2816
    }
#line 2816
   /* update xpp and tp */
#line 2816
    if (realign) xp = (ushort *) *xpp;
#line 2816
    xp += ni;
#line 2816
    tp += ni;
#line 2816
    *xpp = (void*)xp;
#line 2816
  }
#line 2816
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2816

#line 2816
#else   /* not SX */
#line 2816
	const char *xp = (const char *) *xpp;
#line 2816
	int status = NC_NOERR;
#line 2816

#line 2816
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2816
	{
#line 2816
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 2816
		if(lstatus != NC_NOERR)
#line 2816
			status = lstatus;
#line 2816
	}
#line 2816

#line 2816
	*xpp = (const void *)xp;
#line 2816
	return status;
#line 2816
#  endif
#line 2816
}
#line 2816

int
#line 2817
ncx_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 2817
{
#line 2817
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2817

#line 2817
 /* basic algorithm is:
#line 2817
  *   - ensure sane alignment of input data
#line 2817
  *   - copy (conversion happens automatically) input data
#line 2817
  *     to output
#line 2817
  *   - update xpp to point at next unconverted input, and tp to point
#line 2817
  *     at next location for converted output
#line 2817
  */
#line 2817
  long i, j, ni;
#line 2817
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2817
  ushort *xp;
#line 2817
  int nrange = 0;         /* number of range errors */
#line 2817
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2817
  long cxp = (long) *((char**)xpp);
#line 2817

#line 2817
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2817
  /* sjl: manually stripmine so we can limit amount of
#line 2817
   * vector work space reserved to LOOPCNT elements. Also
#line 2817
   * makes vectorisation easy */
#line 2817
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2817
    ni=Min(nelems-j,LOOPCNT);
#line 2817
    if (realign) {
#line 2817
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2817
      xp = tmp;
#line 2817
    } else {
#line 2817
      xp = (ushort *) *xpp;
#line 2817
    }
#line 2817
   /* copy the next block */
#line 2817
#pragma cdir loopcnt=LOOPCNT
#line 2817
#pragma cdir shortloop
#line 2817
    for (i=0; i<ni; i++) {
#line 2817
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2817
     /* test for range errors (not always needed but do it anyway) */
#line 2817
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2817
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2817
      nrange += xp[i] > FLOAT_MAX ;
#line 2817
    }
#line 2817
   /* update xpp and tp */
#line 2817
    if (realign) xp = (ushort *) *xpp;
#line 2817
    xp += ni;
#line 2817
    tp += ni;
#line 2817
    *xpp = (void*)xp;
#line 2817
  }
#line 2817
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2817

#line 2817
#else   /* not SX */
#line 2817
	const char *xp = (const char *) *xpp;
#line 2817
	int status = NC_NOERR;
#line 2817

#line 2817
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2817
	{
#line 2817
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 2817
		if(lstatus != NC_NOERR)
#line 2817
			status = lstatus;
#line 2817
	}
#line 2817

#line 2817
	*xpp = (const void *)xp;
#line 2817
	return status;
#line 2817
#  endif
#line 2817
}
#line 2817

int
#line 2818
ncx_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 2818
{
#line 2818
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2818

#line 2818
 /* basic algorithm is:
#line 2818
  *   - ensure sane alignment of input data
#line 2818
  *   - copy (conversion happens automatically) input data
#line 2818
  *     to output
#line 2818
  *   - update xpp to point at next unconverted input, and tp to point
#line 2818
  *     at next location for converted output
#line 2818
  */
#line 2818
  long i, j, ni;
#line 2818
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2818
  ushort *xp;
#line 2818
  int nrange = 0;         /* number of range errors */
#line 2818
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2818
  long cxp = (long) *((char**)xpp);
#line 2818

#line 2818
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2818
  /* sjl: manually stripmine so we can limit amount of
#line 2818
   * vector work space reserved to LOOPCNT elements. Also
#line 2818
   * makes vectorisation easy */
#line 2818
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2818
    ni=Min(nelems-j,LOOPCNT);
#line 2818
    if (realign) {
#line 2818
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2818
      xp = tmp;
#line 2818
    } else {
#line 2818
      xp = (ushort *) *xpp;
#line 2818
    }
#line 2818
   /* copy the next block */
#line 2818
#pragma cdir loopcnt=LOOPCNT
#line 2818
#pragma cdir shortloop
#line 2818
    for (i=0; i<ni; i++) {
#line 2818
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2818
     /* test for range errors (not always needed but do it anyway) */
#line 2818
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2818
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2818
      nrange += xp[i] > DOUBLE_MAX ;
#line 2818
    }
#line 2818
   /* update xpp and tp */
#line 2818
    if (realign) xp = (ushort *) *xpp;
#line 2818
    xp += ni;
#line 2818
    tp += ni;
#line 2818
    *xpp = (void*)xp;
#line 2818
  }
#line 2818
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2818

#line 2818
#else   /* not SX */
#line 2818
	const char *xp = (const char *) *xpp;
#line 2818
	int status = NC_NOERR;
#line 2818

#line 2818
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2818
	{
#line 2818
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 2818
		if(lstatus != NC_NOERR)
#line 2818
			status = lstatus;
#line 2818
	}
#line 2818

#line 2818
	*xpp = (const void *)xp;
#line 2818
	return status;
#line 2818
#  endif
#line 2818
}
#line 2818

int
#line 2819
ncx_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2819
{
#line 2819
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2819

#line 2819
 /* basic algorithm is:
#line 2819
  *   - ensure sane alignment of input data
#line 2819
  *   - copy (conversion happens automatically) input data
#line 2819
  *     to output
#line 2819
  *   - update xpp to point at next unconverted input, and tp to point
#line 2819
  *     at next location for converted output
#line 2819
  */
#line 2819
  long i, j, ni;
#line 2819
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2819
  ushort *xp;
#line 2819
  int nrange = 0;         /* number of range errors */
#line 2819
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2819
  long cxp = (long) *((char**)xpp);
#line 2819

#line 2819
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2819
  /* sjl: manually stripmine so we can limit amount of
#line 2819
   * vector work space reserved to LOOPCNT elements. Also
#line 2819
   * makes vectorisation easy */
#line 2819
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2819
    ni=Min(nelems-j,LOOPCNT);
#line 2819
    if (realign) {
#line 2819
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2819
      xp = tmp;
#line 2819
    } else {
#line 2819
      xp = (ushort *) *xpp;
#line 2819
    }
#line 2819
   /* copy the next block */
#line 2819
#pragma cdir loopcnt=LOOPCNT
#line 2819
#pragma cdir shortloop
#line 2819
    for (i=0; i<ni; i++) {
#line 2819
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2819
     /* test for range errors (not always needed but do it anyway) */
#line 2819
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2819
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2819
      nrange += xp[i] > LONGLONG_MAX ;
#line 2819
    }
#line 2819
   /* update xpp and tp */
#line 2819
    if (realign) xp = (ushort *) *xpp;
#line 2819
    xp += ni;
#line 2819
    tp += ni;
#line 2819
    *xpp = (void*)xp;
#line 2819
  }
#line 2819
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2819

#line 2819
#else   /* not SX */
#line 2819
	const char *xp = (const char *) *xpp;
#line 2819
	int status = NC_NOERR;
#line 2819

#line 2819
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2819
	{
#line 2819
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 2819
		if(lstatus != NC_NOERR)
#line 2819
			status = lstatus;
#line 2819
	}
#line 2819

#line 2819
	*xpp = (const void *)xp;
#line 2819
	return status;
#line 2819
#  endif
#line 2819
}
#line 2819

int
#line 2820
ncx_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2820
{
#line 2820
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2820

#line 2820
 /* basic algorithm is:
#line 2820
  *   - ensure sane alignment of input data
#line 2820
  *   - copy (conversion happens automatically) input data
#line 2820
  *     to output
#line 2820
  *   - update xpp to point at next unconverted input, and tp to point
#line 2820
  *     at next location for converted output
#line 2820
  */
#line 2820
  long i, j, ni;
#line 2820
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2820
  ushort *xp;
#line 2820
  int nrange = 0;         /* number of range errors */
#line 2820
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2820
  long cxp = (long) *((char**)xpp);
#line 2820

#line 2820
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2820
  /* sjl: manually stripmine so we can limit amount of
#line 2820
   * vector work space reserved to LOOPCNT elements. Also
#line 2820
   * makes vectorisation easy */
#line 2820
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2820
    ni=Min(nelems-j,LOOPCNT);
#line 2820
    if (realign) {
#line 2820
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2820
      xp = tmp;
#line 2820
    } else {
#line 2820
      xp = (ushort *) *xpp;
#line 2820
    }
#line 2820
   /* copy the next block */
#line 2820
#pragma cdir loopcnt=LOOPCNT
#line 2820
#pragma cdir shortloop
#line 2820
    for (i=0; i<ni; i++) {
#line 2820
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2820
     /* test for range errors (not always needed but do it anyway) */
#line 2820
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2820
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2820
      nrange += xp[i] > UCHAR_MAX ;
#line 2820
    }
#line 2820
   /* update xpp and tp */
#line 2820
    if (realign) xp = (ushort *) *xpp;
#line 2820
    xp += ni;
#line 2820
    tp += ni;
#line 2820
    *xpp = (void*)xp;
#line 2820
  }
#line 2820
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2820

#line 2820
#else   /* not SX */
#line 2820
	const char *xp = (const char *) *xpp;
#line 2820
	int status = NC_NOERR;
#line 2820

#line 2820
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2820
	{
#line 2820
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 2820
		if(lstatus != NC_NOERR)
#line 2820
			status = lstatus;
#line 2820
	}
#line 2820

#line 2820
	*xpp = (const void *)xp;
#line 2820
	return status;
#line 2820
#  endif
#line 2820
}
#line 2820

int
#line 2821
ncx_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 2821
{
#line 2821
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2821

#line 2821
 /* basic algorithm is:
#line 2821
  *   - ensure sane alignment of input data
#line 2821
  *   - copy (conversion happens automatically) input data
#line 2821
  *     to output
#line 2821
  *   - update xpp to point at next unconverted input, and tp to point
#line 2821
  *     at next location for converted output
#line 2821
  */
#line 2821
  long i, j, ni;
#line 2821
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2821
  ushort *xp;
#line 2821
  int nrange = 0;         /* number of range errors */
#line 2821
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2821
  long cxp = (long) *((char**)xpp);
#line 2821

#line 2821
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2821
  /* sjl: manually stripmine so we can limit amount of
#line 2821
   * vector work space reserved to LOOPCNT elements. Also
#line 2821
   * makes vectorisation easy */
#line 2821
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2821
    ni=Min(nelems-j,LOOPCNT);
#line 2821
    if (realign) {
#line 2821
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2821
      xp = tmp;
#line 2821
    } else {
#line 2821
      xp = (ushort *) *xpp;
#line 2821
    }
#line 2821
   /* copy the next block */
#line 2821
#pragma cdir loopcnt=LOOPCNT
#line 2821
#pragma cdir shortloop
#line 2821
    for (i=0; i<ni; i++) {
#line 2821
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2821
     /* test for range errors (not always needed but do it anyway) */
#line 2821
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2821
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2821
      nrange += xp[i] > UINT_MAX ;
#line 2821
    }
#line 2821
   /* update xpp and tp */
#line 2821
    if (realign) xp = (ushort *) *xpp;
#line 2821
    xp += ni;
#line 2821
    tp += ni;
#line 2821
    *xpp = (void*)xp;
#line 2821
  }
#line 2821
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2821

#line 2821
#else   /* not SX */
#line 2821
	const char *xp = (const char *) *xpp;
#line 2821
	int status = NC_NOERR;
#line 2821

#line 2821
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2821
	{
#line 2821
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 2821
		if(lstatus != NC_NOERR)
#line 2821
			status = lstatus;
#line 2821
	}
#line 2821

#line 2821
	*xpp = (const void *)xp;
#line 2821
	return status;
#line 2821
#  endif
#line 2821
}
#line 2821

int
#line 2822
ncx_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2822
{
#line 2822
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2822

#line 2822
 /* basic algorithm is:
#line 2822
  *   - ensure sane alignment of input data
#line 2822
  *   - copy (conversion happens automatically) input data
#line 2822
  *     to output
#line 2822
  *   - update xpp to point at next unconverted input, and tp to point
#line 2822
  *     at next location for converted output
#line 2822
  */
#line 2822
  long i, j, ni;
#line 2822
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2822
  ushort *xp;
#line 2822
  int nrange = 0;         /* number of range errors */
#line 2822
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2822
  long cxp = (long) *((char**)xpp);
#line 2822

#line 2822
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2822
  /* sjl: manually stripmine so we can limit amount of
#line 2822
   * vector work space reserved to LOOPCNT elements. Also
#line 2822
   * makes vectorisation easy */
#line 2822
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2822
    ni=Min(nelems-j,LOOPCNT);
#line 2822
    if (realign) {
#line 2822
      memcpy(tmp, *xpp, ni*SIZEOF_USHORT);
#line 2822
      xp = tmp;
#line 2822
    } else {
#line 2822
      xp = (ushort *) *xpp;
#line 2822
    }
#line 2822
   /* copy the next block */
#line 2822
#pragma cdir loopcnt=LOOPCNT
#line 2822
#pragma cdir shortloop
#line 2822
    for (i=0; i<ni; i++) {
#line 2822
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2822
     /* test for range errors (not always needed but do it anyway) */
#line 2822
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2822
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2822
      nrange += xp[i] > ULONGLONG_MAX ;
#line 2822
    }
#line 2822
   /* update xpp and tp */
#line 2822
    if (realign) xp = (ushort *) *xpp;
#line 2822
    xp += ni;
#line 2822
    tp += ni;
#line 2822
    *xpp = (void*)xp;
#line 2822
  }
#line 2822
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2822

#line 2822
#else   /* not SX */
#line 2822
	const char *xp = (const char *) *xpp;
#line 2822
	int status = NC_NOERR;
#line 2822

#line 2822
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2822
	{
#line 2822
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 2822
		if(lstatus != NC_NOERR)
#line 2822
			status = lstatus;
#line 2822
	}
#line 2822

#line 2822
	*xpp = (const void *)xp;
#line 2822
	return status;
#line 2822
#  endif
#line 2822
}
#line 2822


int
#line 2824
ncx_pad_getn_ushort_schar(const void **xpp, size_t nelems, schar *tp)
#line 2824
{
#line 2824
	const size_t rndup = nelems % 2;
#line 2824

#line 2824
	const char *xp = (const char *) *xpp;
#line 2824
	int status = NC_NOERR;
#line 2824

#line 2824
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2824
	{
#line 2824
		const int lstatus = ncx_get_ushort_schar(xp, tp);
#line 2824
		if(lstatus != NC_NOERR)
#line 2824
			status = lstatus;
#line 2824
	}
#line 2824

#line 2824
	if(rndup != 0)
#line 2824
		xp += X_SIZEOF_USHORT;
#line 2824
	*xpp = (void *)xp;
#line 2824
	return status;
#line 2824
}
#line 2824

int
#line 2825
ncx_pad_getn_ushort_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2825
{
#line 2825
	const size_t rndup = nelems % 2;
#line 2825

#line 2825
	const char *xp = (const char *) *xpp;
#line 2825
	int status = NC_NOERR;
#line 2825

#line 2825
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2825
	{
#line 2825
		const int lstatus = ncx_get_ushort_uchar(xp, tp);
#line 2825
		if(lstatus != NC_NOERR)
#line 2825
			status = lstatus;
#line 2825
	}
#line 2825

#line 2825
	if(rndup != 0)
#line 2825
		xp += X_SIZEOF_USHORT;
#line 2825
	*xpp = (void *)xp;
#line 2825
	return status;
#line 2825
}
#line 2825

int
#line 2826
ncx_pad_getn_ushort_short(const void **xpp, size_t nelems, short *tp)
#line 2826
{
#line 2826
	const size_t rndup = nelems % 2;
#line 2826

#line 2826
	const char *xp = (const char *) *xpp;
#line 2826
	int status = NC_NOERR;
#line 2826

#line 2826
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2826
	{
#line 2826
		const int lstatus = ncx_get_ushort_short(xp, tp);
#line 2826
		if(lstatus != NC_NOERR)
#line 2826
			status = lstatus;
#line 2826
	}
#line 2826

#line 2826
	if(rndup != 0)
#line 2826
		xp += X_SIZEOF_USHORT;
#line 2826
	*xpp = (void *)xp;
#line 2826
	return status;
#line 2826
}
#line 2826

int
#line 2827
ncx_pad_getn_ushort_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2827
{
#line 2827
	const size_t rndup = nelems % 2;
#line 2827

#line 2827
	const char *xp = (const char *) *xpp;
#line 2827
	int status = NC_NOERR;
#line 2827

#line 2827
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2827
	{
#line 2827
		const int lstatus = ncx_get_ushort_ushort(xp, tp);
#line 2827
		if(lstatus != NC_NOERR)
#line 2827
			status = lstatus;
#line 2827
	}
#line 2827

#line 2827
	if(rndup != 0)
#line 2827
		xp += X_SIZEOF_USHORT;
#line 2827
	*xpp = (void *)xp;
#line 2827
	return status;
#line 2827
}
#line 2827

int
#line 2828
ncx_pad_getn_ushort_int(const void **xpp, size_t nelems, int *tp)
#line 2828
{
#line 2828
	const size_t rndup = nelems % 2;
#line 2828

#line 2828
	const char *xp = (const char *) *xpp;
#line 2828
	int status = NC_NOERR;
#line 2828

#line 2828
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2828
	{
#line 2828
		const int lstatus = ncx_get_ushort_int(xp, tp);
#line 2828
		if(lstatus != NC_NOERR)
#line 2828
			status = lstatus;
#line 2828
	}
#line 2828

#line 2828
	if(rndup != 0)
#line 2828
		xp += X_SIZEOF_USHORT;
#line 2828
	*xpp = (void *)xp;
#line 2828
	return status;
#line 2828
}
#line 2828

int
#line 2829
ncx_pad_getn_ushort_uint(const void **xpp, size_t nelems, uint *tp)
#line 2829
{
#line 2829
	const size_t rndup = nelems % 2;
#line 2829

#line 2829
	const char *xp = (const char *) *xpp;
#line 2829
	int status = NC_NOERR;
#line 2829

#line 2829
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2829
	{
#line 2829
		const int lstatus = ncx_get_ushort_uint(xp, tp);
#line 2829
		if(lstatus != NC_NOERR)
#line 2829
			status = lstatus;
#line 2829
	}
#line 2829

#line 2829
	if(rndup != 0)
#line 2829
		xp += X_SIZEOF_USHORT;
#line 2829
	*xpp = (void *)xp;
#line 2829
	return status;
#line 2829
}
#line 2829

int
#line 2830
ncx_pad_getn_ushort_float(const void **xpp, size_t nelems, float *tp)
#line 2830
{
#line 2830
	const size_t rndup = nelems % 2;
#line 2830

#line 2830
	const char *xp = (const char *) *xpp;
#line 2830
	int status = NC_NOERR;
#line 2830

#line 2830
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2830
	{
#line 2830
		const int lstatus = ncx_get_ushort_float(xp, tp);
#line 2830
		if(lstatus != NC_NOERR)
#line 2830
			status = lstatus;
#line 2830
	}
#line 2830

#line 2830
	if(rndup != 0)
#line 2830
		xp += X_SIZEOF_USHORT;
#line 2830
	*xpp = (void *)xp;
#line 2830
	return status;
#line 2830
}
#line 2830

int
#line 2831
ncx_pad_getn_ushort_double(const void **xpp, size_t nelems, double *tp)
#line 2831
{
#line 2831
	const size_t rndup = nelems % 2;
#line 2831

#line 2831
	const char *xp = (const char *) *xpp;
#line 2831
	int status = NC_NOERR;
#line 2831

#line 2831
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2831
	{
#line 2831
		const int lstatus = ncx_get_ushort_double(xp, tp);
#line 2831
		if(lstatus != NC_NOERR)
#line 2831
			status = lstatus;
#line 2831
	}
#line 2831

#line 2831
	if(rndup != 0)
#line 2831
		xp += X_SIZEOF_USHORT;
#line 2831
	*xpp = (void *)xp;
#line 2831
	return status;
#line 2831
}
#line 2831

int
#line 2832
ncx_pad_getn_ushort_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2832
{
#line 2832
	const size_t rndup = nelems % 2;
#line 2832

#line 2832
	const char *xp = (const char *) *xpp;
#line 2832
	int status = NC_NOERR;
#line 2832

#line 2832
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2832
	{
#line 2832
		const int lstatus = ncx_get_ushort_longlong(xp, tp);
#line 2832
		if(lstatus != NC_NOERR)
#line 2832
			status = lstatus;
#line 2832
	}
#line 2832

#line 2832
	if(rndup != 0)
#line 2832
		xp += X_SIZEOF_USHORT;
#line 2832
	*xpp = (void *)xp;
#line 2832
	return status;
#line 2832
}
#line 2832

int
#line 2833
ncx_pad_getn_ushort_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2833
{
#line 2833
	const size_t rndup = nelems % 2;
#line 2833

#line 2833
	const char *xp = (const char *) *xpp;
#line 2833
	int status = NC_NOERR;
#line 2833

#line 2833
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2833
	{
#line 2833
		const int lstatus = ncx_get_ushort_ulonglong(xp, tp);
#line 2833
		if(lstatus != NC_NOERR)
#line 2833
			status = lstatus;
#line 2833
	}
#line 2833

#line 2833
	if(rndup != 0)
#line 2833
		xp += X_SIZEOF_USHORT;
#line 2833
	*xpp = (void *)xp;
#line 2833
	return status;
#line 2833
}
#line 2833


#if X_SIZEOF_USHORT == SIZEOF_USHORT
/* optimized version */
int
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const unsigned short *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_USHORT);
# else
	swapn2b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_USHORT);
	return NC_NOERR;
}
#else
int
#line 2849
ncx_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2849
{
#line 2849
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2849

#line 2849
 /* basic algorithm is:
#line 2849
  *   - ensure sane alignment of output data
#line 2849
  *   - copy (conversion happens automatically) input data
#line 2849
  *     to output
#line 2849
  *   - update tp to point at next unconverted input, and xpp to point
#line 2849
  *     at next location for converted output
#line 2849
  */
#line 2849
  long i, j, ni;
#line 2849
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2849
  ushort *xp;
#line 2849
  int nrange = 0;         /* number of range errors */
#line 2849
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2849
  long cxp = (long) *((char**)xpp);
#line 2849

#line 2849
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2849
  /* sjl: manually stripmine so we can limit amount of
#line 2849
   * vector work space reserved to LOOPCNT elements. Also
#line 2849
   * makes vectorisation easy */
#line 2849
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2849
    ni=Min(nelems-j,LOOPCNT);
#line 2849
    if (realign) {
#line 2849
      xp = tmp;
#line 2849
    } else {
#line 2849
      xp = (ushort *) *xpp;
#line 2849
    }
#line 2849
   /* copy the next block */
#line 2849
#pragma cdir loopcnt=LOOPCNT
#line 2849
#pragma cdir shortloop
#line 2849
    for (i=0; i<ni; i++) {
#line 2849
      /* the normal case: */
#line 2849
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2849
     /* test for range errors (not always needed but do it anyway) */
#line 2849
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2849
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2849
      nrange += tp[i] > X_USHORT_MAX ;
#line 2849
    }
#line 2849
   /* copy workspace back if necessary */
#line 2849
    if (realign) {
#line 2849
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2849
      xp = (ushort *) *xpp;
#line 2849
    }
#line 2849
   /* update xpp and tp */
#line 2849
    xp += ni;
#line 2849
    tp += ni;
#line 2849
    *xpp = (void*)xp;
#line 2849
  }
#line 2849
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2849

#line 2849
#else   /* not SX */
#line 2849

#line 2849
	char *xp = (char *) *xpp;
#line 2849
	int status = NC_NOERR;
#line 2849

#line 2849
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2849
	{
#line 2849
		int lstatus = ncx_put_ushort_ushort(xp, tp);
#line 2849
		if(lstatus != NC_NOERR)
#line 2849
			status = lstatus;
#line 2849
	}
#line 2849

#line 2849
	*xpp = (void *)xp;
#line 2849
	return status;
#line 2849
#endif
#line 2849
}
#line 2849

#endif
int
#line 2851
ncx_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp)
#line 2851
{
#line 2851
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2851

#line 2851
 /* basic algorithm is:
#line 2851
  *   - ensure sane alignment of output data
#line 2851
  *   - copy (conversion happens automatically) input data
#line 2851
  *     to output
#line 2851
  *   - update tp to point at next unconverted input, and xpp to point
#line 2851
  *     at next location for converted output
#line 2851
  */
#line 2851
  long i, j, ni;
#line 2851
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2851
  ushort *xp;
#line 2851
  int nrange = 0;         /* number of range errors */
#line 2851
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2851
  long cxp = (long) *((char**)xpp);
#line 2851

#line 2851
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2851
  /* sjl: manually stripmine so we can limit amount of
#line 2851
   * vector work space reserved to LOOPCNT elements. Also
#line 2851
   * makes vectorisation easy */
#line 2851
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2851
    ni=Min(nelems-j,LOOPCNT);
#line 2851
    if (realign) {
#line 2851
      xp = tmp;
#line 2851
    } else {
#line 2851
      xp = (ushort *) *xpp;
#line 2851
    }
#line 2851
   /* copy the next block */
#line 2851
#pragma cdir loopcnt=LOOPCNT
#line 2851
#pragma cdir shortloop
#line 2851
    for (i=0; i<ni; i++) {
#line 2851
      /* the normal case: */
#line 2851
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2851
     /* test for range errors (not always needed but do it anyway) */
#line 2851
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2851
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2851
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 2851
    }
#line 2851
   /* copy workspace back if necessary */
#line 2851
    if (realign) {
#line 2851
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2851
      xp = (ushort *) *xpp;
#line 2851
    }
#line 2851
   /* update xpp and tp */
#line 2851
    xp += ni;
#line 2851
    tp += ni;
#line 2851
    *xpp = (void*)xp;
#line 2851
  }
#line 2851
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2851

#line 2851
#else   /* not SX */
#line 2851

#line 2851
	char *xp = (char *) *xpp;
#line 2851
	int status = NC_NOERR;
#line 2851

#line 2851
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2851
	{
#line 2851
		int lstatus = ncx_put_ushort_schar(xp, tp);
#line 2851
		if(lstatus != NC_NOERR)
#line 2851
			status = lstatus;
#line 2851
	}
#line 2851

#line 2851
	*xpp = (void *)xp;
#line 2851
	return status;
#line 2851
#endif
#line 2851
}
#line 2851

int
#line 2852
ncx_putn_ushort_short(void **xpp, size_t nelems, const short *tp)
#line 2852
{
#line 2852
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2852

#line 2852
 /* basic algorithm is:
#line 2852
  *   - ensure sane alignment of output data
#line 2852
  *   - copy (conversion happens automatically) input data
#line 2852
  *     to output
#line 2852
  *   - update tp to point at next unconverted input, and xpp to point
#line 2852
  *     at next location for converted output
#line 2852
  */
#line 2852
  long i, j, ni;
#line 2852
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2852
  ushort *xp;
#line 2852
  int nrange = 0;         /* number of range errors */
#line 2852
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2852
  long cxp = (long) *((char**)xpp);
#line 2852

#line 2852
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2852
  /* sjl: manually stripmine so we can limit amount of
#line 2852
   * vector work space reserved to LOOPCNT elements. Also
#line 2852
   * makes vectorisation easy */
#line 2852
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2852
    ni=Min(nelems-j,LOOPCNT);
#line 2852
    if (realign) {
#line 2852
      xp = tmp;
#line 2852
    } else {
#line 2852
      xp = (ushort *) *xpp;
#line 2852
    }
#line 2852
   /* copy the next block */
#line 2852
#pragma cdir loopcnt=LOOPCNT
#line 2852
#pragma cdir shortloop
#line 2852
    for (i=0; i<ni; i++) {
#line 2852
      /* the normal case: */
#line 2852
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2852
     /* test for range errors (not always needed but do it anyway) */
#line 2852
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2852
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2852
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 2852
    }
#line 2852
   /* copy workspace back if necessary */
#line 2852
    if (realign) {
#line 2852
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2852
      xp = (ushort *) *xpp;
#line 2852
    }
#line 2852
   /* update xpp and tp */
#line 2852
    xp += ni;
#line 2852
    tp += ni;
#line 2852
    *xpp = (void*)xp;
#line 2852
  }
#line 2852
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2852

#line 2852
#else   /* not SX */
#line 2852

#line 2852
	char *xp = (char *) *xpp;
#line 2852
	int status = NC_NOERR;
#line 2852

#line 2852
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2852
	{
#line 2852
		int lstatus = ncx_put_ushort_short(xp, tp);
#line 2852
		if(lstatus != NC_NOERR)
#line 2852
			status = lstatus;
#line 2852
	}
#line 2852

#line 2852
	*xpp = (void *)xp;
#line 2852
	return status;
#line 2852
#endif
#line 2852
}
#line 2852

int
#line 2853
ncx_putn_ushort_int(void **xpp, size_t nelems, const int *tp)
#line 2853
{
#line 2853
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2853

#line 2853
 /* basic algorithm is:
#line 2853
  *   - ensure sane alignment of output data
#line 2853
  *   - copy (conversion happens automatically) input data
#line 2853
  *     to output
#line 2853
  *   - update tp to point at next unconverted input, and xpp to point
#line 2853
  *     at next location for converted output
#line 2853
  */
#line 2853
  long i, j, ni;
#line 2853
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2853
  ushort *xp;
#line 2853
  int nrange = 0;         /* number of range errors */
#line 2853
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2853
  long cxp = (long) *((char**)xpp);
#line 2853

#line 2853
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2853
  /* sjl: manually stripmine so we can limit amount of
#line 2853
   * vector work space reserved to LOOPCNT elements. Also
#line 2853
   * makes vectorisation easy */
#line 2853
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2853
    ni=Min(nelems-j,LOOPCNT);
#line 2853
    if (realign) {
#line 2853
      xp = tmp;
#line 2853
    } else {
#line 2853
      xp = (ushort *) *xpp;
#line 2853
    }
#line 2853
   /* copy the next block */
#line 2853
#pragma cdir loopcnt=LOOPCNT
#line 2853
#pragma cdir shortloop
#line 2853
    for (i=0; i<ni; i++) {
#line 2853
      /* the normal case: */
#line 2853
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2853
     /* test for range errors (not always needed but do it anyway) */
#line 2853
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2853
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2853
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 2853
    }
#line 2853
   /* copy workspace back if necessary */
#line 2853
    if (realign) {
#line 2853
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2853
      xp = (ushort *) *xpp;
#line 2853
    }
#line 2853
   /* update xpp and tp */
#line 2853
    xp += ni;
#line 2853
    tp += ni;
#line 2853
    *xpp = (void*)xp;
#line 2853
  }
#line 2853
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2853

#line 2853
#else   /* not SX */
#line 2853

#line 2853
	char *xp = (char *) *xpp;
#line 2853
	int status = NC_NOERR;
#line 2853

#line 2853
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2853
	{
#line 2853
		int lstatus = ncx_put_ushort_int(xp, tp);
#line 2853
		if(lstatus != NC_NOERR)
#line 2853
			status = lstatus;
#line 2853
	}
#line 2853

#line 2853
	*xpp = (void *)xp;
#line 2853
	return status;
#line 2853
#endif
#line 2853
}
#line 2853

int
#line 2854
ncx_putn_ushort_float(void **xpp, size_t nelems, const float *tp)
#line 2854
{
#line 2854
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2854

#line 2854
 /* basic algorithm is:
#line 2854
  *   - ensure sane alignment of output data
#line 2854
  *   - copy (conversion happens automatically) input data
#line 2854
  *     to output
#line 2854
  *   - update tp to point at next unconverted input, and xpp to point
#line 2854
  *     at next location for converted output
#line 2854
  */
#line 2854
  long i, j, ni;
#line 2854
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2854
  ushort *xp;
#line 2854
  int nrange = 0;         /* number of range errors */
#line 2854
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2854
  long cxp = (long) *((char**)xpp);
#line 2854

#line 2854
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2854
  /* sjl: manually stripmine so we can limit amount of
#line 2854
   * vector work space reserved to LOOPCNT elements. Also
#line 2854
   * makes vectorisation easy */
#line 2854
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2854
    ni=Min(nelems-j,LOOPCNT);
#line 2854
    if (realign) {
#line 2854
      xp = tmp;
#line 2854
    } else {
#line 2854
      xp = (ushort *) *xpp;
#line 2854
    }
#line 2854
   /* copy the next block */
#line 2854
#pragma cdir loopcnt=LOOPCNT
#line 2854
#pragma cdir shortloop
#line 2854
    for (i=0; i<ni; i++) {
#line 2854
      /* the normal case: */
#line 2854
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2854
     /* test for range errors (not always needed but do it anyway) */
#line 2854
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2854
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2854
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 2854
    }
#line 2854
   /* copy workspace back if necessary */
#line 2854
    if (realign) {
#line 2854
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2854
      xp = (ushort *) *xpp;
#line 2854
    }
#line 2854
   /* update xpp and tp */
#line 2854
    xp += ni;
#line 2854
    tp += ni;
#line 2854
    *xpp = (void*)xp;
#line 2854
  }
#line 2854
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2854

#line 2854
#else   /* not SX */
#line 2854

#line 2854
	char *xp = (char *) *xpp;
#line 2854
	int status = NC_NOERR;
#line 2854

#line 2854
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2854
	{
#line 2854
		int lstatus = ncx_put_ushort_float(xp, tp);
#line 2854
		if(lstatus != NC_NOERR)
#line 2854
			status = lstatus;
#line 2854
	}
#line 2854

#line 2854
	*xpp = (void *)xp;
#line 2854
	return status;
#line 2854
#endif
#line 2854
}
#line 2854

int
#line 2855
ncx_putn_ushort_double(void **xpp, size_t nelems, const double *tp)
#line 2855
{
#line 2855
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2855

#line 2855
 /* basic algorithm is:
#line 2855
  *   - ensure sane alignment of output data
#line 2855
  *   - copy (conversion happens automatically) input data
#line 2855
  *     to output
#line 2855
  *   - update tp to point at next unconverted input, and xpp to point
#line 2855
  *     at next location for converted output
#line 2855
  */
#line 2855
  long i, j, ni;
#line 2855
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2855
  ushort *xp;
#line 2855
  int nrange = 0;         /* number of range errors */
#line 2855
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2855
  long cxp = (long) *((char**)xpp);
#line 2855

#line 2855
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2855
  /* sjl: manually stripmine so we can limit amount of
#line 2855
   * vector work space reserved to LOOPCNT elements. Also
#line 2855
   * makes vectorisation easy */
#line 2855
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2855
    ni=Min(nelems-j,LOOPCNT);
#line 2855
    if (realign) {
#line 2855
      xp = tmp;
#line 2855
    } else {
#line 2855
      xp = (ushort *) *xpp;
#line 2855
    }
#line 2855
   /* copy the next block */
#line 2855
#pragma cdir loopcnt=LOOPCNT
#line 2855
#pragma cdir shortloop
#line 2855
    for (i=0; i<ni; i++) {
#line 2855
      /* the normal case: */
#line 2855
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2855
     /* test for range errors (not always needed but do it anyway) */
#line 2855
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2855
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2855
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 2855
    }
#line 2855
   /* copy workspace back if necessary */
#line 2855
    if (realign) {
#line 2855
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2855
      xp = (ushort *) *xpp;
#line 2855
    }
#line 2855
   /* update xpp and tp */
#line 2855
    xp += ni;
#line 2855
    tp += ni;
#line 2855
    *xpp = (void*)xp;
#line 2855
  }
#line 2855
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2855

#line 2855
#else   /* not SX */
#line 2855

#line 2855
	char *xp = (char *) *xpp;
#line 2855
	int status = NC_NOERR;
#line 2855

#line 2855
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2855
	{
#line 2855
		int lstatus = ncx_put_ushort_double(xp, tp);
#line 2855
		if(lstatus != NC_NOERR)
#line 2855
			status = lstatus;
#line 2855
	}
#line 2855

#line 2855
	*xpp = (void *)xp;
#line 2855
	return status;
#line 2855
#endif
#line 2855
}
#line 2855

int
#line 2856
ncx_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2856
{
#line 2856
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2856

#line 2856
 /* basic algorithm is:
#line 2856
  *   - ensure sane alignment of output data
#line 2856
  *   - copy (conversion happens automatically) input data
#line 2856
  *     to output
#line 2856
  *   - update tp to point at next unconverted input, and xpp to point
#line 2856
  *     at next location for converted output
#line 2856
  */
#line 2856
  long i, j, ni;
#line 2856
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2856
  ushort *xp;
#line 2856
  int nrange = 0;         /* number of range errors */
#line 2856
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2856
  long cxp = (long) *((char**)xpp);
#line 2856

#line 2856
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2856
  /* sjl: manually stripmine so we can limit amount of
#line 2856
   * vector work space reserved to LOOPCNT elements. Also
#line 2856
   * makes vectorisation easy */
#line 2856
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2856
    ni=Min(nelems-j,LOOPCNT);
#line 2856
    if (realign) {
#line 2856
      xp = tmp;
#line 2856
    } else {
#line 2856
      xp = (ushort *) *xpp;
#line 2856
    }
#line 2856
   /* copy the next block */
#line 2856
#pragma cdir loopcnt=LOOPCNT
#line 2856
#pragma cdir shortloop
#line 2856
    for (i=0; i<ni; i++) {
#line 2856
      /* the normal case: */
#line 2856
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2856
     /* test for range errors (not always needed but do it anyway) */
#line 2856
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2856
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2856
      nrange += tp[i] > X_USHORT_MAX || tp[i] < 0;
#line 2856
    }
#line 2856
   /* copy workspace back if necessary */
#line 2856
    if (realign) {
#line 2856
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2856
      xp = (ushort *) *xpp;
#line 2856
    }
#line 2856
   /* update xpp and tp */
#line 2856
    xp += ni;
#line 2856
    tp += ni;
#line 2856
    *xpp = (void*)xp;
#line 2856
  }
#line 2856
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2856

#line 2856
#else   /* not SX */
#line 2856

#line 2856
	char *xp = (char *) *xpp;
#line 2856
	int status = NC_NOERR;
#line 2856

#line 2856
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2856
	{
#line 2856
		int lstatus = ncx_put_ushort_longlong(xp, tp);
#line 2856
		if(lstatus != NC_NOERR)
#line 2856
			status = lstatus;
#line 2856
	}
#line 2856

#line 2856
	*xpp = (void *)xp;
#line 2856
	return status;
#line 2856
#endif
#line 2856
}
#line 2856

int
#line 2857
ncx_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2857
{
#line 2857
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2857

#line 2857
 /* basic algorithm is:
#line 2857
  *   - ensure sane alignment of output data
#line 2857
  *   - copy (conversion happens automatically) input data
#line 2857
  *     to output
#line 2857
  *   - update tp to point at next unconverted input, and xpp to point
#line 2857
  *     at next location for converted output
#line 2857
  */
#line 2857
  long i, j, ni;
#line 2857
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2857
  ushort *xp;
#line 2857
  int nrange = 0;         /* number of range errors */
#line 2857
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2857
  long cxp = (long) *((char**)xpp);
#line 2857

#line 2857
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2857
  /* sjl: manually stripmine so we can limit amount of
#line 2857
   * vector work space reserved to LOOPCNT elements. Also
#line 2857
   * makes vectorisation easy */
#line 2857
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2857
    ni=Min(nelems-j,LOOPCNT);
#line 2857
    if (realign) {
#line 2857
      xp = tmp;
#line 2857
    } else {
#line 2857
      xp = (ushort *) *xpp;
#line 2857
    }
#line 2857
   /* copy the next block */
#line 2857
#pragma cdir loopcnt=LOOPCNT
#line 2857
#pragma cdir shortloop
#line 2857
    for (i=0; i<ni; i++) {
#line 2857
      /* the normal case: */
#line 2857
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2857
     /* test for range errors (not always needed but do it anyway) */
#line 2857
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2857
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2857
      nrange += tp[i] > X_USHORT_MAX ;
#line 2857
    }
#line 2857
   /* copy workspace back if necessary */
#line 2857
    if (realign) {
#line 2857
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2857
      xp = (ushort *) *xpp;
#line 2857
    }
#line 2857
   /* update xpp and tp */
#line 2857
    xp += ni;
#line 2857
    tp += ni;
#line 2857
    *xpp = (void*)xp;
#line 2857
  }
#line 2857
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2857

#line 2857
#else   /* not SX */
#line 2857

#line 2857
	char *xp = (char *) *xpp;
#line 2857
	int status = NC_NOERR;
#line 2857

#line 2857
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2857
	{
#line 2857
		int lstatus = ncx_put_ushort_uchar(xp, tp);
#line 2857
		if(lstatus != NC_NOERR)
#line 2857
			status = lstatus;
#line 2857
	}
#line 2857

#line 2857
	*xpp = (void *)xp;
#line 2857
	return status;
#line 2857
#endif
#line 2857
}
#line 2857

int
#line 2858
ncx_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp)
#line 2858
{
#line 2858
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2858

#line 2858
 /* basic algorithm is:
#line 2858
  *   - ensure sane alignment of output data
#line 2858
  *   - copy (conversion happens automatically) input data
#line 2858
  *     to output
#line 2858
  *   - update tp to point at next unconverted input, and xpp to point
#line 2858
  *     at next location for converted output
#line 2858
  */
#line 2858
  long i, j, ni;
#line 2858
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2858
  ushort *xp;
#line 2858
  int nrange = 0;         /* number of range errors */
#line 2858
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2858
  long cxp = (long) *((char**)xpp);
#line 2858

#line 2858
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2858
  /* sjl: manually stripmine so we can limit amount of
#line 2858
   * vector work space reserved to LOOPCNT elements. Also
#line 2858
   * makes vectorisation easy */
#line 2858
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2858
    ni=Min(nelems-j,LOOPCNT);
#line 2858
    if (realign) {
#line 2858
      xp = tmp;
#line 2858
    } else {
#line 2858
      xp = (ushort *) *xpp;
#line 2858
    }
#line 2858
   /* copy the next block */
#line 2858
#pragma cdir loopcnt=LOOPCNT
#line 2858
#pragma cdir shortloop
#line 2858
    for (i=0; i<ni; i++) {
#line 2858
      /* the normal case: */
#line 2858
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2858
     /* test for range errors (not always needed but do it anyway) */
#line 2858
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2858
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2858
      nrange += tp[i] > X_USHORT_MAX ;
#line 2858
    }
#line 2858
   /* copy workspace back if necessary */
#line 2858
    if (realign) {
#line 2858
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2858
      xp = (ushort *) *xpp;
#line 2858
    }
#line 2858
   /* update xpp and tp */
#line 2858
    xp += ni;
#line 2858
    tp += ni;
#line 2858
    *xpp = (void*)xp;
#line 2858
  }
#line 2858
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2858

#line 2858
#else   /* not SX */
#line 2858

#line 2858
	char *xp = (char *) *xpp;
#line 2858
	int status = NC_NOERR;
#line 2858

#line 2858
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2858
	{
#line 2858
		int lstatus = ncx_put_ushort_uint(xp, tp);
#line 2858
		if(lstatus != NC_NOERR)
#line 2858
			status = lstatus;
#line 2858
	}
#line 2858

#line 2858
	*xpp = (void *)xp;
#line 2858
	return status;
#line 2858
#endif
#line 2858
}
#line 2858

int
#line 2859
ncx_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2859
{
#line 2859
#if _SX && X_SIZEOF_USHORT == SIZEOF_USHORT
#line 2859

#line 2859
 /* basic algorithm is:
#line 2859
  *   - ensure sane alignment of output data
#line 2859
  *   - copy (conversion happens automatically) input data
#line 2859
  *     to output
#line 2859
  *   - update tp to point at next unconverted input, and xpp to point
#line 2859
  *     at next location for converted output
#line 2859
  */
#line 2859
  long i, j, ni;
#line 2859
  ushort tmp[LOOPCNT];        /* in case input is misaligned */
#line 2859
  ushort *xp;
#line 2859
  int nrange = 0;         /* number of range errors */
#line 2859
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2859
  long cxp = (long) *((char**)xpp);
#line 2859

#line 2859
  realign = (cxp & 7) % SIZEOF_USHORT;
#line 2859
  /* sjl: manually stripmine so we can limit amount of
#line 2859
   * vector work space reserved to LOOPCNT elements. Also
#line 2859
   * makes vectorisation easy */
#line 2859
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2859
    ni=Min(nelems-j,LOOPCNT);
#line 2859
    if (realign) {
#line 2859
      xp = tmp;
#line 2859
    } else {
#line 2859
      xp = (ushort *) *xpp;
#line 2859
    }
#line 2859
   /* copy the next block */
#line 2859
#pragma cdir loopcnt=LOOPCNT
#line 2859
#pragma cdir shortloop
#line 2859
    for (i=0; i<ni; i++) {
#line 2859
      /* the normal case: */
#line 2859
      xp[i] = (ushort) Max( X_USHORT_MIN, Min(X_USHORT_MAX, (ushort) tp[i]));
#line 2859
     /* test for range errors (not always needed but do it anyway) */
#line 2859
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2859
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2859
      nrange += tp[i] > X_USHORT_MAX ;
#line 2859
    }
#line 2859
   /* copy workspace back if necessary */
#line 2859
    if (realign) {
#line 2859
      memcpy(*xpp, tmp, ni*X_SIZEOF_USHORT);
#line 2859
      xp = (ushort *) *xpp;
#line 2859
    }
#line 2859
   /* update xpp and tp */
#line 2859
    xp += ni;
#line 2859
    tp += ni;
#line 2859
    *xpp = (void*)xp;
#line 2859
  }
#line 2859
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2859

#line 2859
#else   /* not SX */
#line 2859

#line 2859
	char *xp = (char *) *xpp;
#line 2859
	int status = NC_NOERR;
#line 2859

#line 2859
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2859
	{
#line 2859
		int lstatus = ncx_put_ushort_ulonglong(xp, tp);
#line 2859
		if(lstatus != NC_NOERR)
#line 2859
			status = lstatus;
#line 2859
	}
#line 2859

#line 2859
	*xpp = (void *)xp;
#line 2859
	return status;
#line 2859
#endif
#line 2859
}
#line 2859


int
#line 2861
ncx_pad_putn_ushort_schar(void **xpp, size_t nelems, const schar *tp)
#line 2861
{
#line 2861
	const size_t rndup = nelems % 2;
#line 2861

#line 2861
	char *xp = (char *) *xpp;
#line 2861
	int status = NC_NOERR;
#line 2861

#line 2861
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2861
	{
#line 2861
		int lstatus = ncx_put_ushort_schar(xp, tp);
#line 2861
		if(lstatus != NC_NOERR)
#line 2861
			status = lstatus;
#line 2861
	}
#line 2861

#line 2861
	if(rndup != 0)
#line 2861
	{
#line 2861
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2861
		xp += X_SIZEOF_USHORT;
#line 2861
	}
#line 2861

#line 2861
	*xpp = (void *)xp;
#line 2861
	return status;
#line 2861
}
#line 2861

int
#line 2862
ncx_pad_putn_ushort_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2862
{
#line 2862
	const size_t rndup = nelems % 2;
#line 2862

#line 2862
	char *xp = (char *) *xpp;
#line 2862
	int status = NC_NOERR;
#line 2862

#line 2862
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2862
	{
#line 2862
		int lstatus = ncx_put_ushort_uchar(xp, tp);
#line 2862
		if(lstatus != NC_NOERR)
#line 2862
			status = lstatus;
#line 2862
	}
#line 2862

#line 2862
	if(rndup != 0)
#line 2862
	{
#line 2862
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2862
		xp += X_SIZEOF_USHORT;
#line 2862
	}
#line 2862

#line 2862
	*xpp = (void *)xp;
#line 2862
	return status;
#line 2862
}
#line 2862

int
#line 2863
ncx_pad_putn_ushort_short(void **xpp, size_t nelems, const short *tp)
#line 2863
{
#line 2863
	const size_t rndup = nelems % 2;
#line 2863

#line 2863
	char *xp = (char *) *xpp;
#line 2863
	int status = NC_NOERR;
#line 2863

#line 2863
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2863
	{
#line 2863
		int lstatus = ncx_put_ushort_short(xp, tp);
#line 2863
		if(lstatus != NC_NOERR)
#line 2863
			status = lstatus;
#line 2863
	}
#line 2863

#line 2863
	if(rndup != 0)
#line 2863
	{
#line 2863
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2863
		xp += X_SIZEOF_USHORT;
#line 2863
	}
#line 2863

#line 2863
	*xpp = (void *)xp;
#line 2863
	return status;
#line 2863
}
#line 2863

int
#line 2864
ncx_pad_putn_ushort_int(void **xpp, size_t nelems, const int *tp)
#line 2864
{
#line 2864
	const size_t rndup = nelems % 2;
#line 2864

#line 2864
	char *xp = (char *) *xpp;
#line 2864
	int status = NC_NOERR;
#line 2864

#line 2864
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2864
	{
#line 2864
		int lstatus = ncx_put_ushort_int(xp, tp);
#line 2864
		if(lstatus != NC_NOERR)
#line 2864
			status = lstatus;
#line 2864
	}
#line 2864

#line 2864
	if(rndup != 0)
#line 2864
	{
#line 2864
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2864
		xp += X_SIZEOF_USHORT;
#line 2864
	}
#line 2864

#line 2864
	*xpp = (void *)xp;
#line 2864
	return status;
#line 2864
}
#line 2864

int
#line 2865
ncx_pad_putn_ushort_float(void **xpp, size_t nelems, const float *tp)
#line 2865
{
#line 2865
	const size_t rndup = nelems % 2;
#line 2865

#line 2865
	char *xp = (char *) *xpp;
#line 2865
	int status = NC_NOERR;
#line 2865

#line 2865
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2865
	{
#line 2865
		int lstatus = ncx_put_ushort_float(xp, tp);
#line 2865
		if(lstatus != NC_NOERR)
#line 2865
			status = lstatus;
#line 2865
	}
#line 2865

#line 2865
	if(rndup != 0)
#line 2865
	{
#line 2865
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2865
		xp += X_SIZEOF_USHORT;
#line 2865
	}
#line 2865

#line 2865
	*xpp = (void *)xp;
#line 2865
	return status;
#line 2865
}
#line 2865

int
#line 2866
ncx_pad_putn_ushort_double(void **xpp, size_t nelems, const double *tp)
#line 2866
{
#line 2866
	const size_t rndup = nelems % 2;
#line 2866

#line 2866
	char *xp = (char *) *xpp;
#line 2866
	int status = NC_NOERR;
#line 2866

#line 2866
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2866
	{
#line 2866
		int lstatus = ncx_put_ushort_double(xp, tp);
#line 2866
		if(lstatus != NC_NOERR)
#line 2866
			status = lstatus;
#line 2866
	}
#line 2866

#line 2866
	if(rndup != 0)
#line 2866
	{
#line 2866
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2866
		xp += X_SIZEOF_USHORT;
#line 2866
	}
#line 2866

#line 2866
	*xpp = (void *)xp;
#line 2866
	return status;
#line 2866
}
#line 2866

int
#line 2867
ncx_pad_putn_ushort_uint(void **xpp, size_t nelems, const uint *tp)
#line 2867
{
#line 2867
	const size_t rndup = nelems % 2;
#line 2867

#line 2867
	char *xp = (char *) *xpp;
#line 2867
	int status = NC_NOERR;
#line 2867

#line 2867
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2867
	{
#line 2867
		int lstatus = ncx_put_ushort_uint(xp, tp);
#line 2867
		if(lstatus != NC_NOERR)
#line 2867
			status = lstatus;
#line 2867
	}
#line 2867

#line 2867
	if(rndup != 0)
#line 2867
	{
#line 2867
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2867
		xp += X_SIZEOF_USHORT;
#line 2867
	}
#line 2867

#line 2867
	*xpp = (void *)xp;
#line 2867
	return status;
#line 2867
}
#line 2867

int
#line 2868
ncx_pad_putn_ushort_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2868
{
#line 2868
	const size_t rndup = nelems % 2;
#line 2868

#line 2868
	char *xp = (char *) *xpp;
#line 2868
	int status = NC_NOERR;
#line 2868

#line 2868
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2868
	{
#line 2868
		int lstatus = ncx_put_ushort_longlong(xp, tp);
#line 2868
		if(lstatus != NC_NOERR)
#line 2868
			status = lstatus;
#line 2868
	}
#line 2868

#line 2868
	if(rndup != 0)
#line 2868
	{
#line 2868
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2868
		xp += X_SIZEOF_USHORT;
#line 2868
	}
#line 2868

#line 2868
	*xpp = (void *)xp;
#line 2868
	return status;
#line 2868
}
#line 2868

int
#line 2869
ncx_pad_putn_ushort_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2869
{
#line 2869
	const size_t rndup = nelems % 2;
#line 2869

#line 2869
	char *xp = (char *) *xpp;
#line 2869
	int status = NC_NOERR;
#line 2869

#line 2869
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2869
	{
#line 2869
		int lstatus = ncx_put_ushort_ulonglong(xp, tp);
#line 2869
		if(lstatus != NC_NOERR)
#line 2869
			status = lstatus;
#line 2869
	}
#line 2869

#line 2869
	if(rndup != 0)
#line 2869
	{
#line 2869
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2869
		xp += X_SIZEOF_USHORT;
#line 2869
	}
#line 2869

#line 2869
	*xpp = (void *)xp;
#line 2869
	return status;
#line 2869
}
#line 2869

int
#line 2870
ncx_pad_putn_ushort_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2870
{
#line 2870
	const size_t rndup = nelems % 2;
#line 2870

#line 2870
	char *xp = (char *) *xpp;
#line 2870
	int status = NC_NOERR;
#line 2870

#line 2870
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_USHORT, tp++)
#line 2870
	{
#line 2870
		int lstatus = ncx_put_ushort_ushort(xp, tp);
#line 2870
		if(lstatus != NC_NOERR)
#line 2870
			status = lstatus;
#line 2870
	}
#line 2870

#line 2870
	if(rndup != 0)
#line 2870
	{
#line 2870
		(void) memcpy(xp, nada, X_SIZEOF_USHORT);
#line 2870
		xp += X_SIZEOF_USHORT;
#line 2870
	}
#line 2870

#line 2870
	*xpp = (void *)xp;
#line 2870
	return status;
#line 2870
}
#line 2870



/* int -----------------------------------------------------------------------*/

#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(int));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 2889
ncx_getn_int_int(const void **xpp, size_t nelems, int *tp)
#line 2889
{
#line 2889
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2889

#line 2889
 /* basic algorithm is:
#line 2889
  *   - ensure sane alignment of input data
#line 2889
  *   - copy (conversion happens automatically) input data
#line 2889
  *     to output
#line 2889
  *   - update xpp to point at next unconverted input, and tp to point
#line 2889
  *     at next location for converted output
#line 2889
  */
#line 2889
  long i, j, ni;
#line 2889
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2889
  int *xp;
#line 2889
  int nrange = 0;         /* number of range errors */
#line 2889
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2889
  long cxp = (long) *((char**)xpp);
#line 2889

#line 2889
  realign = (cxp & 7) % SIZEOF_INT;
#line 2889
  /* sjl: manually stripmine so we can limit amount of
#line 2889
   * vector work space reserved to LOOPCNT elements. Also
#line 2889
   * makes vectorisation easy */
#line 2889
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2889
    ni=Min(nelems-j,LOOPCNT);
#line 2889
    if (realign) {
#line 2889
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2889
      xp = tmp;
#line 2889
    } else {
#line 2889
      xp = (int *) *xpp;
#line 2889
    }
#line 2889
   /* copy the next block */
#line 2889
#pragma cdir loopcnt=LOOPCNT
#line 2889
#pragma cdir shortloop
#line 2889
    for (i=0; i<ni; i++) {
#line 2889
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2889
     /* test for range errors (not always needed but do it anyway) */
#line 2889
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2889
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2889
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 2889
    }
#line 2889
   /* update xpp and tp */
#line 2889
    if (realign) xp = (int *) *xpp;
#line 2889
    xp += ni;
#line 2889
    tp += ni;
#line 2889
    *xpp = (void*)xp;
#line 2889
  }
#line 2889
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2889

#line 2889
#else   /* not SX */
#line 2889
	const char *xp = (const char *) *xpp;
#line 2889
	int status = NC_NOERR;
#line 2889

#line 2889
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2889
	{
#line 2889
		const int lstatus = ncx_get_int_int(xp, tp);
#line 2889
		if(lstatus != NC_NOERR)
#line 2889
			status = lstatus;
#line 2889
	}
#line 2889

#line 2889
	*xpp = (const void *)xp;
#line 2889
	return status;
#line 2889
#  endif
#line 2889
}
#line 2889

#endif
int
#line 2891
ncx_getn_int_schar(const void **xpp, size_t nelems, schar *tp)
#line 2891
{
#line 2891
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2891

#line 2891
 /* basic algorithm is:
#line 2891
  *   - ensure sane alignment of input data
#line 2891
  *   - copy (conversion happens automatically) input data
#line 2891
  *     to output
#line 2891
  *   - update xpp to point at next unconverted input, and tp to point
#line 2891
  *     at next location for converted output
#line 2891
  */
#line 2891
  long i, j, ni;
#line 2891
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2891
  int *xp;
#line 2891
  int nrange = 0;         /* number of range errors */
#line 2891
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2891
  long cxp = (long) *((char**)xpp);
#line 2891

#line 2891
  realign = (cxp & 7) % SIZEOF_INT;
#line 2891
  /* sjl: manually stripmine so we can limit amount of
#line 2891
   * vector work space reserved to LOOPCNT elements. Also
#line 2891
   * makes vectorisation easy */
#line 2891
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2891
    ni=Min(nelems-j,LOOPCNT);
#line 2891
    if (realign) {
#line 2891
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2891
      xp = tmp;
#line 2891
    } else {
#line 2891
      xp = (int *) *xpp;
#line 2891
    }
#line 2891
   /* copy the next block */
#line 2891
#pragma cdir loopcnt=LOOPCNT
#line 2891
#pragma cdir shortloop
#line 2891
    for (i=0; i<ni; i++) {
#line 2891
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2891
     /* test for range errors (not always needed but do it anyway) */
#line 2891
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2891
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2891
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 2891
    }
#line 2891
   /* update xpp and tp */
#line 2891
    if (realign) xp = (int *) *xpp;
#line 2891
    xp += ni;
#line 2891
    tp += ni;
#line 2891
    *xpp = (void*)xp;
#line 2891
  }
#line 2891
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2891

#line 2891
#else   /* not SX */
#line 2891
	const char *xp = (const char *) *xpp;
#line 2891
	int status = NC_NOERR;
#line 2891

#line 2891
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2891
	{
#line 2891
		const int lstatus = ncx_get_int_schar(xp, tp);
#line 2891
		if(lstatus != NC_NOERR)
#line 2891
			status = lstatus;
#line 2891
	}
#line 2891

#line 2891
	*xpp = (const void *)xp;
#line 2891
	return status;
#line 2891
#  endif
#line 2891
}
#line 2891

int
#line 2892
ncx_getn_int_short(const void **xpp, size_t nelems, short *tp)
#line 2892
{
#line 2892
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2892

#line 2892
 /* basic algorithm is:
#line 2892
  *   - ensure sane alignment of input data
#line 2892
  *   - copy (conversion happens automatically) input data
#line 2892
  *     to output
#line 2892
  *   - update xpp to point at next unconverted input, and tp to point
#line 2892
  *     at next location for converted output
#line 2892
  */
#line 2892
  long i, j, ni;
#line 2892
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2892
  int *xp;
#line 2892
  int nrange = 0;         /* number of range errors */
#line 2892
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2892
  long cxp = (long) *((char**)xpp);
#line 2892

#line 2892
  realign = (cxp & 7) % SIZEOF_INT;
#line 2892
  /* sjl: manually stripmine so we can limit amount of
#line 2892
   * vector work space reserved to LOOPCNT elements. Also
#line 2892
   * makes vectorisation easy */
#line 2892
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2892
    ni=Min(nelems-j,LOOPCNT);
#line 2892
    if (realign) {
#line 2892
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2892
      xp = tmp;
#line 2892
    } else {
#line 2892
      xp = (int *) *xpp;
#line 2892
    }
#line 2892
   /* copy the next block */
#line 2892
#pragma cdir loopcnt=LOOPCNT
#line 2892
#pragma cdir shortloop
#line 2892
    for (i=0; i<ni; i++) {
#line 2892
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2892
     /* test for range errors (not always needed but do it anyway) */
#line 2892
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2892
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2892
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 2892
    }
#line 2892
   /* update xpp and tp */
#line 2892
    if (realign) xp = (int *) *xpp;
#line 2892
    xp += ni;
#line 2892
    tp += ni;
#line 2892
    *xpp = (void*)xp;
#line 2892
  }
#line 2892
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2892

#line 2892
#else   /* not SX */
#line 2892
	const char *xp = (const char *) *xpp;
#line 2892
	int status = NC_NOERR;
#line 2892

#line 2892
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2892
	{
#line 2892
		const int lstatus = ncx_get_int_short(xp, tp);
#line 2892
		if(lstatus != NC_NOERR)
#line 2892
			status = lstatus;
#line 2892
	}
#line 2892

#line 2892
	*xpp = (const void *)xp;
#line 2892
	return status;
#line 2892
#  endif
#line 2892
}
#line 2892

int
#line 2893
ncx_getn_int_float(const void **xpp, size_t nelems, float *tp)
#line 2893
{
#line 2893
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2893

#line 2893
 /* basic algorithm is:
#line 2893
  *   - ensure sane alignment of input data
#line 2893
  *   - copy (conversion happens automatically) input data
#line 2893
  *     to output
#line 2893
  *   - update xpp to point at next unconverted input, and tp to point
#line 2893
  *     at next location for converted output
#line 2893
  */
#line 2893
  long i, j, ni;
#line 2893
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2893
  int *xp;
#line 2893
  int nrange = 0;         /* number of range errors */
#line 2893
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2893
  long cxp = (long) *((char**)xpp);
#line 2893

#line 2893
  realign = (cxp & 7) % SIZEOF_INT;
#line 2893
  /* sjl: manually stripmine so we can limit amount of
#line 2893
   * vector work space reserved to LOOPCNT elements. Also
#line 2893
   * makes vectorisation easy */
#line 2893
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2893
    ni=Min(nelems-j,LOOPCNT);
#line 2893
    if (realign) {
#line 2893
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2893
      xp = tmp;
#line 2893
    } else {
#line 2893
      xp = (int *) *xpp;
#line 2893
    }
#line 2893
   /* copy the next block */
#line 2893
#pragma cdir loopcnt=LOOPCNT
#line 2893
#pragma cdir shortloop
#line 2893
    for (i=0; i<ni; i++) {
#line 2893
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2893
     /* test for range errors (not always needed but do it anyway) */
#line 2893
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2893
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2893
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 2893
    }
#line 2893
   /* update xpp and tp */
#line 2893
    if (realign) xp = (int *) *xpp;
#line 2893
    xp += ni;
#line 2893
    tp += ni;
#line 2893
    *xpp = (void*)xp;
#line 2893
  }
#line 2893
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2893

#line 2893
#else   /* not SX */
#line 2893
	const char *xp = (const char *) *xpp;
#line 2893
	int status = NC_NOERR;
#line 2893

#line 2893
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2893
	{
#line 2893
		const int lstatus = ncx_get_int_float(xp, tp);
#line 2893
		if(lstatus != NC_NOERR)
#line 2893
			status = lstatus;
#line 2893
	}
#line 2893

#line 2893
	*xpp = (const void *)xp;
#line 2893
	return status;
#line 2893
#  endif
#line 2893
}
#line 2893

int
#line 2894
ncx_getn_int_double(const void **xpp, size_t nelems, double *tp)
#line 2894
{
#line 2894
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2894

#line 2894
 /* basic algorithm is:
#line 2894
  *   - ensure sane alignment of input data
#line 2894
  *   - copy (conversion happens automatically) input data
#line 2894
  *     to output
#line 2894
  *   - update xpp to point at next unconverted input, and tp to point
#line 2894
  *     at next location for converted output
#line 2894
  */
#line 2894
  long i, j, ni;
#line 2894
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2894
  int *xp;
#line 2894
  int nrange = 0;         /* number of range errors */
#line 2894
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2894
  long cxp = (long) *((char**)xpp);
#line 2894

#line 2894
  realign = (cxp & 7) % SIZEOF_INT;
#line 2894
  /* sjl: manually stripmine so we can limit amount of
#line 2894
   * vector work space reserved to LOOPCNT elements. Also
#line 2894
   * makes vectorisation easy */
#line 2894
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2894
    ni=Min(nelems-j,LOOPCNT);
#line 2894
    if (realign) {
#line 2894
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2894
      xp = tmp;
#line 2894
    } else {
#line 2894
      xp = (int *) *xpp;
#line 2894
    }
#line 2894
   /* copy the next block */
#line 2894
#pragma cdir loopcnt=LOOPCNT
#line 2894
#pragma cdir shortloop
#line 2894
    for (i=0; i<ni; i++) {
#line 2894
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2894
     /* test for range errors (not always needed but do it anyway) */
#line 2894
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2894
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2894
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 2894
    }
#line 2894
   /* update xpp and tp */
#line 2894
    if (realign) xp = (int *) *xpp;
#line 2894
    xp += ni;
#line 2894
    tp += ni;
#line 2894
    *xpp = (void*)xp;
#line 2894
  }
#line 2894
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2894

#line 2894
#else   /* not SX */
#line 2894
	const char *xp = (const char *) *xpp;
#line 2894
	int status = NC_NOERR;
#line 2894

#line 2894
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2894
	{
#line 2894
		const int lstatus = ncx_get_int_double(xp, tp);
#line 2894
		if(lstatus != NC_NOERR)
#line 2894
			status = lstatus;
#line 2894
	}
#line 2894

#line 2894
	*xpp = (const void *)xp;
#line 2894
	return status;
#line 2894
#  endif
#line 2894
}
#line 2894

int
#line 2895
ncx_getn_int_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2895
{
#line 2895
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2895

#line 2895
 /* basic algorithm is:
#line 2895
  *   - ensure sane alignment of input data
#line 2895
  *   - copy (conversion happens automatically) input data
#line 2895
  *     to output
#line 2895
  *   - update xpp to point at next unconverted input, and tp to point
#line 2895
  *     at next location for converted output
#line 2895
  */
#line 2895
  long i, j, ni;
#line 2895
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2895
  int *xp;
#line 2895
  int nrange = 0;         /* number of range errors */
#line 2895
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2895
  long cxp = (long) *((char**)xpp);
#line 2895

#line 2895
  realign = (cxp & 7) % SIZEOF_INT;
#line 2895
  /* sjl: manually stripmine so we can limit amount of
#line 2895
   * vector work space reserved to LOOPCNT elements. Also
#line 2895
   * makes vectorisation easy */
#line 2895
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2895
    ni=Min(nelems-j,LOOPCNT);
#line 2895
    if (realign) {
#line 2895
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2895
      xp = tmp;
#line 2895
    } else {
#line 2895
      xp = (int *) *xpp;
#line 2895
    }
#line 2895
   /* copy the next block */
#line 2895
#pragma cdir loopcnt=LOOPCNT
#line 2895
#pragma cdir shortloop
#line 2895
    for (i=0; i<ni; i++) {
#line 2895
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2895
     /* test for range errors (not always needed but do it anyway) */
#line 2895
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2895
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2895
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 2895
    }
#line 2895
   /* update xpp and tp */
#line 2895
    if (realign) xp = (int *) *xpp;
#line 2895
    xp += ni;
#line 2895
    tp += ni;
#line 2895
    *xpp = (void*)xp;
#line 2895
  }
#line 2895
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2895

#line 2895
#else   /* not SX */
#line 2895
	const char *xp = (const char *) *xpp;
#line 2895
	int status = NC_NOERR;
#line 2895

#line 2895
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2895
	{
#line 2895
		const int lstatus = ncx_get_int_longlong(xp, tp);
#line 2895
		if(lstatus != NC_NOERR)
#line 2895
			status = lstatus;
#line 2895
	}
#line 2895

#line 2895
	*xpp = (const void *)xp;
#line 2895
	return status;
#line 2895
#  endif
#line 2895
}
#line 2895

int
#line 2896
ncx_getn_int_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2896
{
#line 2896
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2896

#line 2896
 /* basic algorithm is:
#line 2896
  *   - ensure sane alignment of input data
#line 2896
  *   - copy (conversion happens automatically) input data
#line 2896
  *     to output
#line 2896
  *   - update xpp to point at next unconverted input, and tp to point
#line 2896
  *     at next location for converted output
#line 2896
  */
#line 2896
  long i, j, ni;
#line 2896
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2896
  int *xp;
#line 2896
  int nrange = 0;         /* number of range errors */
#line 2896
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2896
  long cxp = (long) *((char**)xpp);
#line 2896

#line 2896
  realign = (cxp & 7) % SIZEOF_INT;
#line 2896
  /* sjl: manually stripmine so we can limit amount of
#line 2896
   * vector work space reserved to LOOPCNT elements. Also
#line 2896
   * makes vectorisation easy */
#line 2896
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2896
    ni=Min(nelems-j,LOOPCNT);
#line 2896
    if (realign) {
#line 2896
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2896
      xp = tmp;
#line 2896
    } else {
#line 2896
      xp = (int *) *xpp;
#line 2896
    }
#line 2896
   /* copy the next block */
#line 2896
#pragma cdir loopcnt=LOOPCNT
#line 2896
#pragma cdir shortloop
#line 2896
    for (i=0; i<ni; i++) {
#line 2896
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2896
     /* test for range errors (not always needed but do it anyway) */
#line 2896
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2896
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2896
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 2896
    }
#line 2896
   /* update xpp and tp */
#line 2896
    if (realign) xp = (int *) *xpp;
#line 2896
    xp += ni;
#line 2896
    tp += ni;
#line 2896
    *xpp = (void*)xp;
#line 2896
  }
#line 2896
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2896

#line 2896
#else   /* not SX */
#line 2896
	const char *xp = (const char *) *xpp;
#line 2896
	int status = NC_NOERR;
#line 2896

#line 2896
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2896
	{
#line 2896
		const int lstatus = ncx_get_int_uchar(xp, tp);
#line 2896
		if(lstatus != NC_NOERR)
#line 2896
			status = lstatus;
#line 2896
	}
#line 2896

#line 2896
	*xpp = (const void *)xp;
#line 2896
	return status;
#line 2896
#  endif
#line 2896
}
#line 2896

int
#line 2897
ncx_getn_int_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2897
{
#line 2897
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2897

#line 2897
 /* basic algorithm is:
#line 2897
  *   - ensure sane alignment of input data
#line 2897
  *   - copy (conversion happens automatically) input data
#line 2897
  *     to output
#line 2897
  *   - update xpp to point at next unconverted input, and tp to point
#line 2897
  *     at next location for converted output
#line 2897
  */
#line 2897
  long i, j, ni;
#line 2897
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2897
  int *xp;
#line 2897
  int nrange = 0;         /* number of range errors */
#line 2897
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2897
  long cxp = (long) *((char**)xpp);
#line 2897

#line 2897
  realign = (cxp & 7) % SIZEOF_INT;
#line 2897
  /* sjl: manually stripmine so we can limit amount of
#line 2897
   * vector work space reserved to LOOPCNT elements. Also
#line 2897
   * makes vectorisation easy */
#line 2897
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2897
    ni=Min(nelems-j,LOOPCNT);
#line 2897
    if (realign) {
#line 2897
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2897
      xp = tmp;
#line 2897
    } else {
#line 2897
      xp = (int *) *xpp;
#line 2897
    }
#line 2897
   /* copy the next block */
#line 2897
#pragma cdir loopcnt=LOOPCNT
#line 2897
#pragma cdir shortloop
#line 2897
    for (i=0; i<ni; i++) {
#line 2897
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2897
     /* test for range errors (not always needed but do it anyway) */
#line 2897
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2897
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2897
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 2897
    }
#line 2897
   /* update xpp and tp */
#line 2897
    if (realign) xp = (int *) *xpp;
#line 2897
    xp += ni;
#line 2897
    tp += ni;
#line 2897
    *xpp = (void*)xp;
#line 2897
  }
#line 2897
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2897

#line 2897
#else   /* not SX */
#line 2897
	const char *xp = (const char *) *xpp;
#line 2897
	int status = NC_NOERR;
#line 2897

#line 2897
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2897
	{
#line 2897
		const int lstatus = ncx_get_int_ushort(xp, tp);
#line 2897
		if(lstatus != NC_NOERR)
#line 2897
			status = lstatus;
#line 2897
	}
#line 2897

#line 2897
	*xpp = (const void *)xp;
#line 2897
	return status;
#line 2897
#  endif
#line 2897
}
#line 2897

int
#line 2898
ncx_getn_int_uint(const void **xpp, size_t nelems, uint *tp)
#line 2898
{
#line 2898
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2898

#line 2898
 /* basic algorithm is:
#line 2898
  *   - ensure sane alignment of input data
#line 2898
  *   - copy (conversion happens automatically) input data
#line 2898
  *     to output
#line 2898
  *   - update xpp to point at next unconverted input, and tp to point
#line 2898
  *     at next location for converted output
#line 2898
  */
#line 2898
  long i, j, ni;
#line 2898
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2898
  int *xp;
#line 2898
  int nrange = 0;         /* number of range errors */
#line 2898
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2898
  long cxp = (long) *((char**)xpp);
#line 2898

#line 2898
  realign = (cxp & 7) % SIZEOF_INT;
#line 2898
  /* sjl: manually stripmine so we can limit amount of
#line 2898
   * vector work space reserved to LOOPCNT elements. Also
#line 2898
   * makes vectorisation easy */
#line 2898
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2898
    ni=Min(nelems-j,LOOPCNT);
#line 2898
    if (realign) {
#line 2898
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2898
      xp = tmp;
#line 2898
    } else {
#line 2898
      xp = (int *) *xpp;
#line 2898
    }
#line 2898
   /* copy the next block */
#line 2898
#pragma cdir loopcnt=LOOPCNT
#line 2898
#pragma cdir shortloop
#line 2898
    for (i=0; i<ni; i++) {
#line 2898
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2898
     /* test for range errors (not always needed but do it anyway) */
#line 2898
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2898
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2898
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 2898
    }
#line 2898
   /* update xpp and tp */
#line 2898
    if (realign) xp = (int *) *xpp;
#line 2898
    xp += ni;
#line 2898
    tp += ni;
#line 2898
    *xpp = (void*)xp;
#line 2898
  }
#line 2898
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2898

#line 2898
#else   /* not SX */
#line 2898
	const char *xp = (const char *) *xpp;
#line 2898
	int status = NC_NOERR;
#line 2898

#line 2898
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2898
	{
#line 2898
		const int lstatus = ncx_get_int_uint(xp, tp);
#line 2898
		if(lstatus != NC_NOERR)
#line 2898
			status = lstatus;
#line 2898
	}
#line 2898

#line 2898
	*xpp = (const void *)xp;
#line 2898
	return status;
#line 2898
#  endif
#line 2898
}
#line 2898

int
#line 2899
ncx_getn_int_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2899
{
#line 2899
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2899

#line 2899
 /* basic algorithm is:
#line 2899
  *   - ensure sane alignment of input data
#line 2899
  *   - copy (conversion happens automatically) input data
#line 2899
  *     to output
#line 2899
  *   - update xpp to point at next unconverted input, and tp to point
#line 2899
  *     at next location for converted output
#line 2899
  */
#line 2899
  long i, j, ni;
#line 2899
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2899
  int *xp;
#line 2899
  int nrange = 0;         /* number of range errors */
#line 2899
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2899
  long cxp = (long) *((char**)xpp);
#line 2899

#line 2899
  realign = (cxp & 7) % SIZEOF_INT;
#line 2899
  /* sjl: manually stripmine so we can limit amount of
#line 2899
   * vector work space reserved to LOOPCNT elements. Also
#line 2899
   * makes vectorisation easy */
#line 2899
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2899
    ni=Min(nelems-j,LOOPCNT);
#line 2899
    if (realign) {
#line 2899
      memcpy(tmp, *xpp, ni*SIZEOF_INT);
#line 2899
      xp = tmp;
#line 2899
    } else {
#line 2899
      xp = (int *) *xpp;
#line 2899
    }
#line 2899
   /* copy the next block */
#line 2899
#pragma cdir loopcnt=LOOPCNT
#line 2899
#pragma cdir shortloop
#line 2899
    for (i=0; i<ni; i++) {
#line 2899
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2899
     /* test for range errors (not always needed but do it anyway) */
#line 2899
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2899
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2899
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 2899
    }
#line 2899
   /* update xpp and tp */
#line 2899
    if (realign) xp = (int *) *xpp;
#line 2899
    xp += ni;
#line 2899
    tp += ni;
#line 2899
    *xpp = (void*)xp;
#line 2899
  }
#line 2899
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2899

#line 2899
#else   /* not SX */
#line 2899
	const char *xp = (const char *) *xpp;
#line 2899
	int status = NC_NOERR;
#line 2899

#line 2899
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2899
	{
#line 2899
		const int lstatus = ncx_get_int_ulonglong(xp, tp);
#line 2899
		if(lstatus != NC_NOERR)
#line 2899
			status = lstatus;
#line 2899
	}
#line 2899

#line 2899
	*xpp = (const void *)xp;
#line 2899
	return status;
#line 2899
#  endif
#line 2899
}
#line 2899


#if X_SIZEOF_INT == SIZEOF_INT
/* optimized version */
int
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_INT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_INT);
	return NC_NOERR;
}
#else
int
#line 2915
ncx_putn_int_int(void **xpp, size_t nelems, const int *tp)
#line 2915
{
#line 2915
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2915

#line 2915
 /* basic algorithm is:
#line 2915
  *   - ensure sane alignment of output data
#line 2915
  *   - copy (conversion happens automatically) input data
#line 2915
  *     to output
#line 2915
  *   - update tp to point at next unconverted input, and xpp to point
#line 2915
  *     at next location for converted output
#line 2915
  */
#line 2915
  long i, j, ni;
#line 2915
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2915
  int *xp;
#line 2915
  int nrange = 0;         /* number of range errors */
#line 2915
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2915
  long cxp = (long) *((char**)xpp);
#line 2915

#line 2915
  realign = (cxp & 7) % SIZEOF_INT;
#line 2915
  /* sjl: manually stripmine so we can limit amount of
#line 2915
   * vector work space reserved to LOOPCNT elements. Also
#line 2915
   * makes vectorisation easy */
#line 2915
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2915
    ni=Min(nelems-j,LOOPCNT);
#line 2915
    if (realign) {
#line 2915
      xp = tmp;
#line 2915
    } else {
#line 2915
      xp = (int *) *xpp;
#line 2915
    }
#line 2915
   /* copy the next block */
#line 2915
#pragma cdir loopcnt=LOOPCNT
#line 2915
#pragma cdir shortloop
#line 2915
    for (i=0; i<ni; i++) {
#line 2915
      /* the normal case: */
#line 2915
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2915
     /* test for range errors (not always needed but do it anyway) */
#line 2915
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2915
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2915
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 2915
    }
#line 2915
   /* copy workspace back if necessary */
#line 2915
    if (realign) {
#line 2915
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2915
      xp = (int *) *xpp;
#line 2915
    }
#line 2915
   /* update xpp and tp */
#line 2915
    xp += ni;
#line 2915
    tp += ni;
#line 2915
    *xpp = (void*)xp;
#line 2915
  }
#line 2915
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2915

#line 2915
#else   /* not SX */
#line 2915

#line 2915
	char *xp = (char *) *xpp;
#line 2915
	int status = NC_NOERR;
#line 2915

#line 2915
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2915
	{
#line 2915
		int lstatus = ncx_put_int_int(xp, tp);
#line 2915
		if(lstatus != NC_NOERR)
#line 2915
			status = lstatus;
#line 2915
	}
#line 2915

#line 2915
	*xpp = (void *)xp;
#line 2915
	return status;
#line 2915
#endif
#line 2915
}
#line 2915

#endif
int
#line 2917
ncx_putn_int_schar(void **xpp, size_t nelems, const schar *tp)
#line 2917
{
#line 2917
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2917

#line 2917
 /* basic algorithm is:
#line 2917
  *   - ensure sane alignment of output data
#line 2917
  *   - copy (conversion happens automatically) input data
#line 2917
  *     to output
#line 2917
  *   - update tp to point at next unconverted input, and xpp to point
#line 2917
  *     at next location for converted output
#line 2917
  */
#line 2917
  long i, j, ni;
#line 2917
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2917
  int *xp;
#line 2917
  int nrange = 0;         /* number of range errors */
#line 2917
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2917
  long cxp = (long) *((char**)xpp);
#line 2917

#line 2917
  realign = (cxp & 7) % SIZEOF_INT;
#line 2917
  /* sjl: manually stripmine so we can limit amount of
#line 2917
   * vector work space reserved to LOOPCNT elements. Also
#line 2917
   * makes vectorisation easy */
#line 2917
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2917
    ni=Min(nelems-j,LOOPCNT);
#line 2917
    if (realign) {
#line 2917
      xp = tmp;
#line 2917
    } else {
#line 2917
      xp = (int *) *xpp;
#line 2917
    }
#line 2917
   /* copy the next block */
#line 2917
#pragma cdir loopcnt=LOOPCNT
#line 2917
#pragma cdir shortloop
#line 2917
    for (i=0; i<ni; i++) {
#line 2917
      /* the normal case: */
#line 2917
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2917
     /* test for range errors (not always needed but do it anyway) */
#line 2917
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2917
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2917
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 2917
    }
#line 2917
   /* copy workspace back if necessary */
#line 2917
    if (realign) {
#line 2917
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2917
      xp = (int *) *xpp;
#line 2917
    }
#line 2917
   /* update xpp and tp */
#line 2917
    xp += ni;
#line 2917
    tp += ni;
#line 2917
    *xpp = (void*)xp;
#line 2917
  }
#line 2917
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2917

#line 2917
#else   /* not SX */
#line 2917

#line 2917
	char *xp = (char *) *xpp;
#line 2917
	int status = NC_NOERR;
#line 2917

#line 2917
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2917
	{
#line 2917
		int lstatus = ncx_put_int_schar(xp, tp);
#line 2917
		if(lstatus != NC_NOERR)
#line 2917
			status = lstatus;
#line 2917
	}
#line 2917

#line 2917
	*xpp = (void *)xp;
#line 2917
	return status;
#line 2917
#endif
#line 2917
}
#line 2917

int
#line 2918
ncx_putn_int_short(void **xpp, size_t nelems, const short *tp)
#line 2918
{
#line 2918
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2918

#line 2918
 /* basic algorithm is:
#line 2918
  *   - ensure sane alignment of output data
#line 2918
  *   - copy (conversion happens automatically) input data
#line 2918
  *     to output
#line 2918
  *   - update tp to point at next unconverted input, and xpp to point
#line 2918
  *     at next location for converted output
#line 2918
  */
#line 2918
  long i, j, ni;
#line 2918
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2918
  int *xp;
#line 2918
  int nrange = 0;         /* number of range errors */
#line 2918
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2918
  long cxp = (long) *((char**)xpp);
#line 2918

#line 2918
  realign = (cxp & 7) % SIZEOF_INT;
#line 2918
  /* sjl: manually stripmine so we can limit amount of
#line 2918
   * vector work space reserved to LOOPCNT elements. Also
#line 2918
   * makes vectorisation easy */
#line 2918
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2918
    ni=Min(nelems-j,LOOPCNT);
#line 2918
    if (realign) {
#line 2918
      xp = tmp;
#line 2918
    } else {
#line 2918
      xp = (int *) *xpp;
#line 2918
    }
#line 2918
   /* copy the next block */
#line 2918
#pragma cdir loopcnt=LOOPCNT
#line 2918
#pragma cdir shortloop
#line 2918
    for (i=0; i<ni; i++) {
#line 2918
      /* the normal case: */
#line 2918
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2918
     /* test for range errors (not always needed but do it anyway) */
#line 2918
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2918
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2918
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 2918
    }
#line 2918
   /* copy workspace back if necessary */
#line 2918
    if (realign) {
#line 2918
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2918
      xp = (int *) *xpp;
#line 2918
    }
#line 2918
   /* update xpp and tp */
#line 2918
    xp += ni;
#line 2918
    tp += ni;
#line 2918
    *xpp = (void*)xp;
#line 2918
  }
#line 2918
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2918

#line 2918
#else   /* not SX */
#line 2918

#line 2918
	char *xp = (char *) *xpp;
#line 2918
	int status = NC_NOERR;
#line 2918

#line 2918
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2918
	{
#line 2918
		int lstatus = ncx_put_int_short(xp, tp);
#line 2918
		if(lstatus != NC_NOERR)
#line 2918
			status = lstatus;
#line 2918
	}
#line 2918

#line 2918
	*xpp = (void *)xp;
#line 2918
	return status;
#line 2918
#endif
#line 2918
}
#line 2918

int
#line 2919
ncx_putn_int_float(void **xpp, size_t nelems, const float *tp)
#line 2919
{
#line 2919
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2919

#line 2919
 /* basic algorithm is:
#line 2919
  *   - ensure sane alignment of output data
#line 2919
  *   - copy (conversion happens automatically) input data
#line 2919
  *     to output
#line 2919
  *   - update tp to point at next unconverted input, and xpp to point
#line 2919
  *     at next location for converted output
#line 2919
  */
#line 2919
  long i, j, ni;
#line 2919
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2919
  int *xp;
#line 2919
  double d;               /* special case for ncx_putn_int_float */
#line 2919
  int nrange = 0;         /* number of range errors */
#line 2919
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2919
  long cxp = (long) *((char**)xpp);
#line 2919

#line 2919
  realign = (cxp & 7) % SIZEOF_INT;
#line 2919
  /* sjl: manually stripmine so we can limit amount of
#line 2919
   * vector work space reserved to LOOPCNT elements. Also
#line 2919
   * makes vectorisation easy */
#line 2919
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2919
    ni=Min(nelems-j,LOOPCNT);
#line 2919
    if (realign) {
#line 2919
      xp = tmp;
#line 2919
    } else {
#line 2919
      xp = (int *) *xpp;
#line 2919
    }
#line 2919
   /* copy the next block */
#line 2919
#pragma cdir loopcnt=LOOPCNT
#line 2919
#pragma cdir shortloop
#line 2919
    for (i=0; i<ni; i++) {
#line 2919
      /* for some reason int to float, for putn, requires a special case */
#line 2919
      d = tp[i];
#line 2919
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) d));
#line 2919
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 2919
    }
#line 2919
   /* copy workspace back if necessary */
#line 2919
    if (realign) {
#line 2919
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2919
      xp = (int *) *xpp;
#line 2919
    }
#line 2919
   /* update xpp and tp */
#line 2919
    xp += ni;
#line 2919
    tp += ni;
#line 2919
    *xpp = (void*)xp;
#line 2919
  }
#line 2919
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2919

#line 2919
#else   /* not SX */
#line 2919

#line 2919
	char *xp = (char *) *xpp;
#line 2919
	int status = NC_NOERR;
#line 2919

#line 2919
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2919
	{
#line 2919
		int lstatus = ncx_put_int_float(xp, tp);
#line 2919
		if(lstatus != NC_NOERR)
#line 2919
			status = lstatus;
#line 2919
	}
#line 2919

#line 2919
	*xpp = (void *)xp;
#line 2919
	return status;
#line 2919
#endif
#line 2919
}
#line 2919

int
#line 2920
ncx_putn_int_double(void **xpp, size_t nelems, const double *tp)
#line 2920
{
#line 2920
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2920

#line 2920
 /* basic algorithm is:
#line 2920
  *   - ensure sane alignment of output data
#line 2920
  *   - copy (conversion happens automatically) input data
#line 2920
  *     to output
#line 2920
  *   - update tp to point at next unconverted input, and xpp to point
#line 2920
  *     at next location for converted output
#line 2920
  */
#line 2920
  long i, j, ni;
#line 2920
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2920
  int *xp;
#line 2920
  int nrange = 0;         /* number of range errors */
#line 2920
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2920
  long cxp = (long) *((char**)xpp);
#line 2920

#line 2920
  realign = (cxp & 7) % SIZEOF_INT;
#line 2920
  /* sjl: manually stripmine so we can limit amount of
#line 2920
   * vector work space reserved to LOOPCNT elements. Also
#line 2920
   * makes vectorisation easy */
#line 2920
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2920
    ni=Min(nelems-j,LOOPCNT);
#line 2920
    if (realign) {
#line 2920
      xp = tmp;
#line 2920
    } else {
#line 2920
      xp = (int *) *xpp;
#line 2920
    }
#line 2920
   /* copy the next block */
#line 2920
#pragma cdir loopcnt=LOOPCNT
#line 2920
#pragma cdir shortloop
#line 2920
    for (i=0; i<ni; i++) {
#line 2920
      /* the normal case: */
#line 2920
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2920
     /* test for range errors (not always needed but do it anyway) */
#line 2920
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2920
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2920
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 2920
    }
#line 2920
   /* copy workspace back if necessary */
#line 2920
    if (realign) {
#line 2920
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2920
      xp = (int *) *xpp;
#line 2920
    }
#line 2920
   /* update xpp and tp */
#line 2920
    xp += ni;
#line 2920
    tp += ni;
#line 2920
    *xpp = (void*)xp;
#line 2920
  }
#line 2920
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2920

#line 2920
#else   /* not SX */
#line 2920

#line 2920
	char *xp = (char *) *xpp;
#line 2920
	int status = NC_NOERR;
#line 2920

#line 2920
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2920
	{
#line 2920
		int lstatus = ncx_put_int_double(xp, tp);
#line 2920
		if(lstatus != NC_NOERR)
#line 2920
			status = lstatus;
#line 2920
	}
#line 2920

#line 2920
	*xpp = (void *)xp;
#line 2920
	return status;
#line 2920
#endif
#line 2920
}
#line 2920

int
#line 2921
ncx_putn_int_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2921
{
#line 2921
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2921

#line 2921
 /* basic algorithm is:
#line 2921
  *   - ensure sane alignment of output data
#line 2921
  *   - copy (conversion happens automatically) input data
#line 2921
  *     to output
#line 2921
  *   - update tp to point at next unconverted input, and xpp to point
#line 2921
  *     at next location for converted output
#line 2921
  */
#line 2921
  long i, j, ni;
#line 2921
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2921
  int *xp;
#line 2921
  int nrange = 0;         /* number of range errors */
#line 2921
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2921
  long cxp = (long) *((char**)xpp);
#line 2921

#line 2921
  realign = (cxp & 7) % SIZEOF_INT;
#line 2921
  /* sjl: manually stripmine so we can limit amount of
#line 2921
   * vector work space reserved to LOOPCNT elements. Also
#line 2921
   * makes vectorisation easy */
#line 2921
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2921
    ni=Min(nelems-j,LOOPCNT);
#line 2921
    if (realign) {
#line 2921
      xp = tmp;
#line 2921
    } else {
#line 2921
      xp = (int *) *xpp;
#line 2921
    }
#line 2921
   /* copy the next block */
#line 2921
#pragma cdir loopcnt=LOOPCNT
#line 2921
#pragma cdir shortloop
#line 2921
    for (i=0; i<ni; i++) {
#line 2921
      /* the normal case: */
#line 2921
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2921
     /* test for range errors (not always needed but do it anyway) */
#line 2921
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2921
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2921
      nrange += tp[i] > X_INT_MAX || tp[i] < X_INT_MIN;
#line 2921
    }
#line 2921
   /* copy workspace back if necessary */
#line 2921
    if (realign) {
#line 2921
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2921
      xp = (int *) *xpp;
#line 2921
    }
#line 2921
   /* update xpp and tp */
#line 2921
    xp += ni;
#line 2921
    tp += ni;
#line 2921
    *xpp = (void*)xp;
#line 2921
  }
#line 2921
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2921

#line 2921
#else   /* not SX */
#line 2921

#line 2921
	char *xp = (char *) *xpp;
#line 2921
	int status = NC_NOERR;
#line 2921

#line 2921
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2921
	{
#line 2921
		int lstatus = ncx_put_int_longlong(xp, tp);
#line 2921
		if(lstatus != NC_NOERR)
#line 2921
			status = lstatus;
#line 2921
	}
#line 2921

#line 2921
	*xpp = (void *)xp;
#line 2921
	return status;
#line 2921
#endif
#line 2921
}
#line 2921

int
#line 2922
ncx_putn_int_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2922
{
#line 2922
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2922

#line 2922
 /* basic algorithm is:
#line 2922
  *   - ensure sane alignment of output data
#line 2922
  *   - copy (conversion happens automatically) input data
#line 2922
  *     to output
#line 2922
  *   - update tp to point at next unconverted input, and xpp to point
#line 2922
  *     at next location for converted output
#line 2922
  */
#line 2922
  long i, j, ni;
#line 2922
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2922
  int *xp;
#line 2922
  int nrange = 0;         /* number of range errors */
#line 2922
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2922
  long cxp = (long) *((char**)xpp);
#line 2922

#line 2922
  realign = (cxp & 7) % SIZEOF_INT;
#line 2922
  /* sjl: manually stripmine so we can limit amount of
#line 2922
   * vector work space reserved to LOOPCNT elements. Also
#line 2922
   * makes vectorisation easy */
#line 2922
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2922
    ni=Min(nelems-j,LOOPCNT);
#line 2922
    if (realign) {
#line 2922
      xp = tmp;
#line 2922
    } else {
#line 2922
      xp = (int *) *xpp;
#line 2922
    }
#line 2922
   /* copy the next block */
#line 2922
#pragma cdir loopcnt=LOOPCNT
#line 2922
#pragma cdir shortloop
#line 2922
    for (i=0; i<ni; i++) {
#line 2922
      /* the normal case: */
#line 2922
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2922
     /* test for range errors (not always needed but do it anyway) */
#line 2922
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2922
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2922
      nrange += tp[i] > X_INT_MAX ;
#line 2922
    }
#line 2922
   /* copy workspace back if necessary */
#line 2922
    if (realign) {
#line 2922
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2922
      xp = (int *) *xpp;
#line 2922
    }
#line 2922
   /* update xpp and tp */
#line 2922
    xp += ni;
#line 2922
    tp += ni;
#line 2922
    *xpp = (void*)xp;
#line 2922
  }
#line 2922
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2922

#line 2922
#else   /* not SX */
#line 2922

#line 2922
	char *xp = (char *) *xpp;
#line 2922
	int status = NC_NOERR;
#line 2922

#line 2922
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2922
	{
#line 2922
		int lstatus = ncx_put_int_uchar(xp, tp);
#line 2922
		if(lstatus != NC_NOERR)
#line 2922
			status = lstatus;
#line 2922
	}
#line 2922

#line 2922
	*xpp = (void *)xp;
#line 2922
	return status;
#line 2922
#endif
#line 2922
}
#line 2922

int
#line 2923
ncx_putn_int_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2923
{
#line 2923
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2923

#line 2923
 /* basic algorithm is:
#line 2923
  *   - ensure sane alignment of output data
#line 2923
  *   - copy (conversion happens automatically) input data
#line 2923
  *     to output
#line 2923
  *   - update tp to point at next unconverted input, and xpp to point
#line 2923
  *     at next location for converted output
#line 2923
  */
#line 2923
  long i, j, ni;
#line 2923
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2923
  int *xp;
#line 2923
  int nrange = 0;         /* number of range errors */
#line 2923
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2923
  long cxp = (long) *((char**)xpp);
#line 2923

#line 2923
  realign = (cxp & 7) % SIZEOF_INT;
#line 2923
  /* sjl: manually stripmine so we can limit amount of
#line 2923
   * vector work space reserved to LOOPCNT elements. Also
#line 2923
   * makes vectorisation easy */
#line 2923
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2923
    ni=Min(nelems-j,LOOPCNT);
#line 2923
    if (realign) {
#line 2923
      xp = tmp;
#line 2923
    } else {
#line 2923
      xp = (int *) *xpp;
#line 2923
    }
#line 2923
   /* copy the next block */
#line 2923
#pragma cdir loopcnt=LOOPCNT
#line 2923
#pragma cdir shortloop
#line 2923
    for (i=0; i<ni; i++) {
#line 2923
      /* the normal case: */
#line 2923
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2923
     /* test for range errors (not always needed but do it anyway) */
#line 2923
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2923
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2923
      nrange += tp[i] > X_INT_MAX ;
#line 2923
    }
#line 2923
   /* copy workspace back if necessary */
#line 2923
    if (realign) {
#line 2923
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2923
      xp = (int *) *xpp;
#line 2923
    }
#line 2923
   /* update xpp and tp */
#line 2923
    xp += ni;
#line 2923
    tp += ni;
#line 2923
    *xpp = (void*)xp;
#line 2923
  }
#line 2923
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2923

#line 2923
#else   /* not SX */
#line 2923

#line 2923
	char *xp = (char *) *xpp;
#line 2923
	int status = NC_NOERR;
#line 2923

#line 2923
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2923
	{
#line 2923
		int lstatus = ncx_put_int_ushort(xp, tp);
#line 2923
		if(lstatus != NC_NOERR)
#line 2923
			status = lstatus;
#line 2923
	}
#line 2923

#line 2923
	*xpp = (void *)xp;
#line 2923
	return status;
#line 2923
#endif
#line 2923
}
#line 2923

int
#line 2924
ncx_putn_int_uint(void **xpp, size_t nelems, const uint *tp)
#line 2924
{
#line 2924
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2924

#line 2924
 /* basic algorithm is:
#line 2924
  *   - ensure sane alignment of output data
#line 2924
  *   - copy (conversion happens automatically) input data
#line 2924
  *     to output
#line 2924
  *   - update tp to point at next unconverted input, and xpp to point
#line 2924
  *     at next location for converted output
#line 2924
  */
#line 2924
  long i, j, ni;
#line 2924
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2924
  int *xp;
#line 2924
  int nrange = 0;         /* number of range errors */
#line 2924
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2924
  long cxp = (long) *((char**)xpp);
#line 2924

#line 2924
  realign = (cxp & 7) % SIZEOF_INT;
#line 2924
  /* sjl: manually stripmine so we can limit amount of
#line 2924
   * vector work space reserved to LOOPCNT elements. Also
#line 2924
   * makes vectorisation easy */
#line 2924
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2924
    ni=Min(nelems-j,LOOPCNT);
#line 2924
    if (realign) {
#line 2924
      xp = tmp;
#line 2924
    } else {
#line 2924
      xp = (int *) *xpp;
#line 2924
    }
#line 2924
   /* copy the next block */
#line 2924
#pragma cdir loopcnt=LOOPCNT
#line 2924
#pragma cdir shortloop
#line 2924
    for (i=0; i<ni; i++) {
#line 2924
      /* the normal case: */
#line 2924
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2924
     /* test for range errors (not always needed but do it anyway) */
#line 2924
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2924
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2924
      nrange += tp[i] > X_INT_MAX ;
#line 2924
    }
#line 2924
   /* copy workspace back if necessary */
#line 2924
    if (realign) {
#line 2924
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2924
      xp = (int *) *xpp;
#line 2924
    }
#line 2924
   /* update xpp and tp */
#line 2924
    xp += ni;
#line 2924
    tp += ni;
#line 2924
    *xpp = (void*)xp;
#line 2924
  }
#line 2924
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2924

#line 2924
#else   /* not SX */
#line 2924

#line 2924
	char *xp = (char *) *xpp;
#line 2924
	int status = NC_NOERR;
#line 2924

#line 2924
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2924
	{
#line 2924
		int lstatus = ncx_put_int_uint(xp, tp);
#line 2924
		if(lstatus != NC_NOERR)
#line 2924
			status = lstatus;
#line 2924
	}
#line 2924

#line 2924
	*xpp = (void *)xp;
#line 2924
	return status;
#line 2924
#endif
#line 2924
}
#line 2924

int
#line 2925
ncx_putn_int_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2925
{
#line 2925
#if _SX && X_SIZEOF_INT == SIZEOF_INT
#line 2925

#line 2925
 /* basic algorithm is:
#line 2925
  *   - ensure sane alignment of output data
#line 2925
  *   - copy (conversion happens automatically) input data
#line 2925
  *     to output
#line 2925
  *   - update tp to point at next unconverted input, and xpp to point
#line 2925
  *     at next location for converted output
#line 2925
  */
#line 2925
  long i, j, ni;
#line 2925
  int tmp[LOOPCNT];        /* in case input is misaligned */
#line 2925
  int *xp;
#line 2925
  int nrange = 0;         /* number of range errors */
#line 2925
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2925
  long cxp = (long) *((char**)xpp);
#line 2925

#line 2925
  realign = (cxp & 7) % SIZEOF_INT;
#line 2925
  /* sjl: manually stripmine so we can limit amount of
#line 2925
   * vector work space reserved to LOOPCNT elements. Also
#line 2925
   * makes vectorisation easy */
#line 2925
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2925
    ni=Min(nelems-j,LOOPCNT);
#line 2925
    if (realign) {
#line 2925
      xp = tmp;
#line 2925
    } else {
#line 2925
      xp = (int *) *xpp;
#line 2925
    }
#line 2925
   /* copy the next block */
#line 2925
#pragma cdir loopcnt=LOOPCNT
#line 2925
#pragma cdir shortloop
#line 2925
    for (i=0; i<ni; i++) {
#line 2925
      /* the normal case: */
#line 2925
      xp[i] = (int) Max( X_INT_MIN, Min(X_INT_MAX, (int) tp[i]));
#line 2925
     /* test for range errors (not always needed but do it anyway) */
#line 2925
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2925
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2925
      nrange += tp[i] > X_INT_MAX ;
#line 2925
    }
#line 2925
   /* copy workspace back if necessary */
#line 2925
    if (realign) {
#line 2925
      memcpy(*xpp, tmp, ni*X_SIZEOF_INT);
#line 2925
      xp = (int *) *xpp;
#line 2925
    }
#line 2925
   /* update xpp and tp */
#line 2925
    xp += ni;
#line 2925
    tp += ni;
#line 2925
    *xpp = (void*)xp;
#line 2925
  }
#line 2925
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2925

#line 2925
#else   /* not SX */
#line 2925

#line 2925
	char *xp = (char *) *xpp;
#line 2925
	int status = NC_NOERR;
#line 2925

#line 2925
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_INT, tp++)
#line 2925
	{
#line 2925
		int lstatus = ncx_put_int_ulonglong(xp, tp);
#line 2925
		if(lstatus != NC_NOERR)
#line 2925
			status = lstatus;
#line 2925
	}
#line 2925

#line 2925
	*xpp = (void *)xp;
#line 2925
	return status;
#line 2925
#endif
#line 2925
}
#line 2925


/* uint ----------------------------------------------------------------------*/

#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_getn_uint_uint(const void **xpp, size_t nelems, unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(uint));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 2943
ncx_getn_uint_uint(const void **xpp, size_t nelems, uint *tp)
#line 2943
{
#line 2943
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2943

#line 2943
 /* basic algorithm is:
#line 2943
  *   - ensure sane alignment of input data
#line 2943
  *   - copy (conversion happens automatically) input data
#line 2943
  *     to output
#line 2943
  *   - update xpp to point at next unconverted input, and tp to point
#line 2943
  *     at next location for converted output
#line 2943
  */
#line 2943
  long i, j, ni;
#line 2943
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2943
  uint *xp;
#line 2943
  int nrange = 0;         /* number of range errors */
#line 2943
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2943
  long cxp = (long) *((char**)xpp);
#line 2943

#line 2943
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2943
  /* sjl: manually stripmine so we can limit amount of
#line 2943
   * vector work space reserved to LOOPCNT elements. Also
#line 2943
   * makes vectorisation easy */
#line 2943
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2943
    ni=Min(nelems-j,LOOPCNT);
#line 2943
    if (realign) {
#line 2943
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2943
      xp = tmp;
#line 2943
    } else {
#line 2943
      xp = (uint *) *xpp;
#line 2943
    }
#line 2943
   /* copy the next block */
#line 2943
#pragma cdir loopcnt=LOOPCNT
#line 2943
#pragma cdir shortloop
#line 2943
    for (i=0; i<ni; i++) {
#line 2943
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 2943
     /* test for range errors (not always needed but do it anyway) */
#line 2943
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2943
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2943
      nrange += xp[i] > UINT_MAX ;
#line 2943
    }
#line 2943
   /* update xpp and tp */
#line 2943
    if (realign) xp = (uint *) *xpp;
#line 2943
    xp += ni;
#line 2943
    tp += ni;
#line 2943
    *xpp = (void*)xp;
#line 2943
  }
#line 2943
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2943

#line 2943
#else   /* not SX */
#line 2943
	const char *xp = (const char *) *xpp;
#line 2943
	int status = NC_NOERR;
#line 2943

#line 2943
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2943
	{
#line 2943
		const int lstatus = ncx_get_uint_uint(xp, tp);
#line 2943
		if(lstatus != NC_NOERR)
#line 2943
			status = lstatus;
#line 2943
	}
#line 2943

#line 2943
	*xpp = (const void *)xp;
#line 2943
	return status;
#line 2943
#  endif
#line 2943
}
#line 2943

#endif
int
#line 2945
ncx_getn_uint_schar(const void **xpp, size_t nelems, schar *tp)
#line 2945
{
#line 2945
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2945

#line 2945
 /* basic algorithm is:
#line 2945
  *   - ensure sane alignment of input data
#line 2945
  *   - copy (conversion happens automatically) input data
#line 2945
  *     to output
#line 2945
  *   - update xpp to point at next unconverted input, and tp to point
#line 2945
  *     at next location for converted output
#line 2945
  */
#line 2945
  long i, j, ni;
#line 2945
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2945
  uint *xp;
#line 2945
  int nrange = 0;         /* number of range errors */
#line 2945
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2945
  long cxp = (long) *((char**)xpp);
#line 2945

#line 2945
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2945
  /* sjl: manually stripmine so we can limit amount of
#line 2945
   * vector work space reserved to LOOPCNT elements. Also
#line 2945
   * makes vectorisation easy */
#line 2945
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2945
    ni=Min(nelems-j,LOOPCNT);
#line 2945
    if (realign) {
#line 2945
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2945
      xp = tmp;
#line 2945
    } else {
#line 2945
      xp = (uint *) *xpp;
#line 2945
    }
#line 2945
   /* copy the next block */
#line 2945
#pragma cdir loopcnt=LOOPCNT
#line 2945
#pragma cdir shortloop
#line 2945
    for (i=0; i<ni; i++) {
#line 2945
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 2945
     /* test for range errors (not always needed but do it anyway) */
#line 2945
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2945
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2945
      nrange += xp[i] > SCHAR_MAX ;
#line 2945
    }
#line 2945
   /* update xpp and tp */
#line 2945
    if (realign) xp = (uint *) *xpp;
#line 2945
    xp += ni;
#line 2945
    tp += ni;
#line 2945
    *xpp = (void*)xp;
#line 2945
  }
#line 2945
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2945

#line 2945
#else   /* not SX */
#line 2945
	const char *xp = (const char *) *xpp;
#line 2945
	int status = NC_NOERR;
#line 2945

#line 2945
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2945
	{
#line 2945
		const int lstatus = ncx_get_uint_schar(xp, tp);
#line 2945
		if(lstatus != NC_NOERR)
#line 2945
			status = lstatus;
#line 2945
	}
#line 2945

#line 2945
	*xpp = (const void *)xp;
#line 2945
	return status;
#line 2945
#  endif
#line 2945
}
#line 2945

int
#line 2946
ncx_getn_uint_short(const void **xpp, size_t nelems, short *tp)
#line 2946
{
#line 2946
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2946

#line 2946
 /* basic algorithm is:
#line 2946
  *   - ensure sane alignment of input data
#line 2946
  *   - copy (conversion happens automatically) input data
#line 2946
  *     to output
#line 2946
  *   - update xpp to point at next unconverted input, and tp to point
#line 2946
  *     at next location for converted output
#line 2946
  */
#line 2946
  long i, j, ni;
#line 2946
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2946
  uint *xp;
#line 2946
  int nrange = 0;         /* number of range errors */
#line 2946
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2946
  long cxp = (long) *((char**)xpp);
#line 2946

#line 2946
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2946
  /* sjl: manually stripmine so we can limit amount of
#line 2946
   * vector work space reserved to LOOPCNT elements. Also
#line 2946
   * makes vectorisation easy */
#line 2946
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2946
    ni=Min(nelems-j,LOOPCNT);
#line 2946
    if (realign) {
#line 2946
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2946
      xp = tmp;
#line 2946
    } else {
#line 2946
      xp = (uint *) *xpp;
#line 2946
    }
#line 2946
   /* copy the next block */
#line 2946
#pragma cdir loopcnt=LOOPCNT
#line 2946
#pragma cdir shortloop
#line 2946
    for (i=0; i<ni; i++) {
#line 2946
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 2946
     /* test for range errors (not always needed but do it anyway) */
#line 2946
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2946
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2946
      nrange += xp[i] > SHORT_MAX ;
#line 2946
    }
#line 2946
   /* update xpp and tp */
#line 2946
    if (realign) xp = (uint *) *xpp;
#line 2946
    xp += ni;
#line 2946
    tp += ni;
#line 2946
    *xpp = (void*)xp;
#line 2946
  }
#line 2946
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2946

#line 2946
#else   /* not SX */
#line 2946
	const char *xp = (const char *) *xpp;
#line 2946
	int status = NC_NOERR;
#line 2946

#line 2946
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2946
	{
#line 2946
		const int lstatus = ncx_get_uint_short(xp, tp);
#line 2946
		if(lstatus != NC_NOERR)
#line 2946
			status = lstatus;
#line 2946
	}
#line 2946

#line 2946
	*xpp = (const void *)xp;
#line 2946
	return status;
#line 2946
#  endif
#line 2946
}
#line 2946

int
#line 2947
ncx_getn_uint_int(const void **xpp, size_t nelems, int *tp)
#line 2947
{
#line 2947
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2947

#line 2947
 /* basic algorithm is:
#line 2947
  *   - ensure sane alignment of input data
#line 2947
  *   - copy (conversion happens automatically) input data
#line 2947
  *     to output
#line 2947
  *   - update xpp to point at next unconverted input, and tp to point
#line 2947
  *     at next location for converted output
#line 2947
  */
#line 2947
  long i, j, ni;
#line 2947
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2947
  uint *xp;
#line 2947
  int nrange = 0;         /* number of range errors */
#line 2947
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2947
  long cxp = (long) *((char**)xpp);
#line 2947

#line 2947
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2947
  /* sjl: manually stripmine so we can limit amount of
#line 2947
   * vector work space reserved to LOOPCNT elements. Also
#line 2947
   * makes vectorisation easy */
#line 2947
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2947
    ni=Min(nelems-j,LOOPCNT);
#line 2947
    if (realign) {
#line 2947
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2947
      xp = tmp;
#line 2947
    } else {
#line 2947
      xp = (uint *) *xpp;
#line 2947
    }
#line 2947
   /* copy the next block */
#line 2947
#pragma cdir loopcnt=LOOPCNT
#line 2947
#pragma cdir shortloop
#line 2947
    for (i=0; i<ni; i++) {
#line 2947
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 2947
     /* test for range errors (not always needed but do it anyway) */
#line 2947
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2947
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2947
      nrange += xp[i] > INT_MAX ;
#line 2947
    }
#line 2947
   /* update xpp and tp */
#line 2947
    if (realign) xp = (uint *) *xpp;
#line 2947
    xp += ni;
#line 2947
    tp += ni;
#line 2947
    *xpp = (void*)xp;
#line 2947
  }
#line 2947
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2947

#line 2947
#else   /* not SX */
#line 2947
	const char *xp = (const char *) *xpp;
#line 2947
	int status = NC_NOERR;
#line 2947

#line 2947
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2947
	{
#line 2947
		const int lstatus = ncx_get_uint_int(xp, tp);
#line 2947
		if(lstatus != NC_NOERR)
#line 2947
			status = lstatus;
#line 2947
	}
#line 2947

#line 2947
	*xpp = (const void *)xp;
#line 2947
	return status;
#line 2947
#  endif
#line 2947
}
#line 2947

int
#line 2948
ncx_getn_uint_float(const void **xpp, size_t nelems, float *tp)
#line 2948
{
#line 2948
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2948

#line 2948
 /* basic algorithm is:
#line 2948
  *   - ensure sane alignment of input data
#line 2948
  *   - copy (conversion happens automatically) input data
#line 2948
  *     to output
#line 2948
  *   - update xpp to point at next unconverted input, and tp to point
#line 2948
  *     at next location for converted output
#line 2948
  */
#line 2948
  long i, j, ni;
#line 2948
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2948
  uint *xp;
#line 2948
  int nrange = 0;         /* number of range errors */
#line 2948
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2948
  long cxp = (long) *((char**)xpp);
#line 2948

#line 2948
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2948
  /* sjl: manually stripmine so we can limit amount of
#line 2948
   * vector work space reserved to LOOPCNT elements. Also
#line 2948
   * makes vectorisation easy */
#line 2948
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2948
    ni=Min(nelems-j,LOOPCNT);
#line 2948
    if (realign) {
#line 2948
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2948
      xp = tmp;
#line 2948
    } else {
#line 2948
      xp = (uint *) *xpp;
#line 2948
    }
#line 2948
   /* copy the next block */
#line 2948
#pragma cdir loopcnt=LOOPCNT
#line 2948
#pragma cdir shortloop
#line 2948
    for (i=0; i<ni; i++) {
#line 2948
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 2948
     /* test for range errors (not always needed but do it anyway) */
#line 2948
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2948
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2948
      nrange += xp[i] > FLOAT_MAX ;
#line 2948
    }
#line 2948
   /* update xpp and tp */
#line 2948
    if (realign) xp = (uint *) *xpp;
#line 2948
    xp += ni;
#line 2948
    tp += ni;
#line 2948
    *xpp = (void*)xp;
#line 2948
  }
#line 2948
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2948

#line 2948
#else   /* not SX */
#line 2948
	const char *xp = (const char *) *xpp;
#line 2948
	int status = NC_NOERR;
#line 2948

#line 2948
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2948
	{
#line 2948
		const int lstatus = ncx_get_uint_float(xp, tp);
#line 2948
		if(lstatus != NC_NOERR)
#line 2948
			status = lstatus;
#line 2948
	}
#line 2948

#line 2948
	*xpp = (const void *)xp;
#line 2948
	return status;
#line 2948
#  endif
#line 2948
}
#line 2948

int
#line 2949
ncx_getn_uint_double(const void **xpp, size_t nelems, double *tp)
#line 2949
{
#line 2949
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2949

#line 2949
 /* basic algorithm is:
#line 2949
  *   - ensure sane alignment of input data
#line 2949
  *   - copy (conversion happens automatically) input data
#line 2949
  *     to output
#line 2949
  *   - update xpp to point at next unconverted input, and tp to point
#line 2949
  *     at next location for converted output
#line 2949
  */
#line 2949
  long i, j, ni;
#line 2949
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2949
  uint *xp;
#line 2949
  int nrange = 0;         /* number of range errors */
#line 2949
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2949
  long cxp = (long) *((char**)xpp);
#line 2949

#line 2949
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2949
  /* sjl: manually stripmine so we can limit amount of
#line 2949
   * vector work space reserved to LOOPCNT elements. Also
#line 2949
   * makes vectorisation easy */
#line 2949
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2949
    ni=Min(nelems-j,LOOPCNT);
#line 2949
    if (realign) {
#line 2949
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2949
      xp = tmp;
#line 2949
    } else {
#line 2949
      xp = (uint *) *xpp;
#line 2949
    }
#line 2949
   /* copy the next block */
#line 2949
#pragma cdir loopcnt=LOOPCNT
#line 2949
#pragma cdir shortloop
#line 2949
    for (i=0; i<ni; i++) {
#line 2949
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 2949
     /* test for range errors (not always needed but do it anyway) */
#line 2949
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2949
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2949
      nrange += xp[i] > DOUBLE_MAX ;
#line 2949
    }
#line 2949
   /* update xpp and tp */
#line 2949
    if (realign) xp = (uint *) *xpp;
#line 2949
    xp += ni;
#line 2949
    tp += ni;
#line 2949
    *xpp = (void*)xp;
#line 2949
  }
#line 2949
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2949

#line 2949
#else   /* not SX */
#line 2949
	const char *xp = (const char *) *xpp;
#line 2949
	int status = NC_NOERR;
#line 2949

#line 2949
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2949
	{
#line 2949
		const int lstatus = ncx_get_uint_double(xp, tp);
#line 2949
		if(lstatus != NC_NOERR)
#line 2949
			status = lstatus;
#line 2949
	}
#line 2949

#line 2949
	*xpp = (const void *)xp;
#line 2949
	return status;
#line 2949
#  endif
#line 2949
}
#line 2949

int
#line 2950
ncx_getn_uint_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 2950
{
#line 2950
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2950

#line 2950
 /* basic algorithm is:
#line 2950
  *   - ensure sane alignment of input data
#line 2950
  *   - copy (conversion happens automatically) input data
#line 2950
  *     to output
#line 2950
  *   - update xpp to point at next unconverted input, and tp to point
#line 2950
  *     at next location for converted output
#line 2950
  */
#line 2950
  long i, j, ni;
#line 2950
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2950
  uint *xp;
#line 2950
  int nrange = 0;         /* number of range errors */
#line 2950
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2950
  long cxp = (long) *((char**)xpp);
#line 2950

#line 2950
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2950
  /* sjl: manually stripmine so we can limit amount of
#line 2950
   * vector work space reserved to LOOPCNT elements. Also
#line 2950
   * makes vectorisation easy */
#line 2950
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2950
    ni=Min(nelems-j,LOOPCNT);
#line 2950
    if (realign) {
#line 2950
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2950
      xp = tmp;
#line 2950
    } else {
#line 2950
      xp = (uint *) *xpp;
#line 2950
    }
#line 2950
   /* copy the next block */
#line 2950
#pragma cdir loopcnt=LOOPCNT
#line 2950
#pragma cdir shortloop
#line 2950
    for (i=0; i<ni; i++) {
#line 2950
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 2950
     /* test for range errors (not always needed but do it anyway) */
#line 2950
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2950
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2950
      nrange += xp[i] > LONGLONG_MAX ;
#line 2950
    }
#line 2950
   /* update xpp and tp */
#line 2950
    if (realign) xp = (uint *) *xpp;
#line 2950
    xp += ni;
#line 2950
    tp += ni;
#line 2950
    *xpp = (void*)xp;
#line 2950
  }
#line 2950
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2950

#line 2950
#else   /* not SX */
#line 2950
	const char *xp = (const char *) *xpp;
#line 2950
	int status = NC_NOERR;
#line 2950

#line 2950
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2950
	{
#line 2950
		const int lstatus = ncx_get_uint_longlong(xp, tp);
#line 2950
		if(lstatus != NC_NOERR)
#line 2950
			status = lstatus;
#line 2950
	}
#line 2950

#line 2950
	*xpp = (const void *)xp;
#line 2950
	return status;
#line 2950
#  endif
#line 2950
}
#line 2950

int
#line 2951
ncx_getn_uint_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 2951
{
#line 2951
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2951

#line 2951
 /* basic algorithm is:
#line 2951
  *   - ensure sane alignment of input data
#line 2951
  *   - copy (conversion happens automatically) input data
#line 2951
  *     to output
#line 2951
  *   - update xpp to point at next unconverted input, and tp to point
#line 2951
  *     at next location for converted output
#line 2951
  */
#line 2951
  long i, j, ni;
#line 2951
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2951
  uint *xp;
#line 2951
  int nrange = 0;         /* number of range errors */
#line 2951
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2951
  long cxp = (long) *((char**)xpp);
#line 2951

#line 2951
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2951
  /* sjl: manually stripmine so we can limit amount of
#line 2951
   * vector work space reserved to LOOPCNT elements. Also
#line 2951
   * makes vectorisation easy */
#line 2951
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2951
    ni=Min(nelems-j,LOOPCNT);
#line 2951
    if (realign) {
#line 2951
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2951
      xp = tmp;
#line 2951
    } else {
#line 2951
      xp = (uint *) *xpp;
#line 2951
    }
#line 2951
   /* copy the next block */
#line 2951
#pragma cdir loopcnt=LOOPCNT
#line 2951
#pragma cdir shortloop
#line 2951
    for (i=0; i<ni; i++) {
#line 2951
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 2951
     /* test for range errors (not always needed but do it anyway) */
#line 2951
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2951
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2951
      nrange += xp[i] > UCHAR_MAX ;
#line 2951
    }
#line 2951
   /* update xpp and tp */
#line 2951
    if (realign) xp = (uint *) *xpp;
#line 2951
    xp += ni;
#line 2951
    tp += ni;
#line 2951
    *xpp = (void*)xp;
#line 2951
  }
#line 2951
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2951

#line 2951
#else   /* not SX */
#line 2951
	const char *xp = (const char *) *xpp;
#line 2951
	int status = NC_NOERR;
#line 2951

#line 2951
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2951
	{
#line 2951
		const int lstatus = ncx_get_uint_uchar(xp, tp);
#line 2951
		if(lstatus != NC_NOERR)
#line 2951
			status = lstatus;
#line 2951
	}
#line 2951

#line 2951
	*xpp = (const void *)xp;
#line 2951
	return status;
#line 2951
#  endif
#line 2951
}
#line 2951

int
#line 2952
ncx_getn_uint_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 2952
{
#line 2952
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2952

#line 2952
 /* basic algorithm is:
#line 2952
  *   - ensure sane alignment of input data
#line 2952
  *   - copy (conversion happens automatically) input data
#line 2952
  *     to output
#line 2952
  *   - update xpp to point at next unconverted input, and tp to point
#line 2952
  *     at next location for converted output
#line 2952
  */
#line 2952
  long i, j, ni;
#line 2952
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2952
  uint *xp;
#line 2952
  int nrange = 0;         /* number of range errors */
#line 2952
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2952
  long cxp = (long) *((char**)xpp);
#line 2952

#line 2952
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2952
  /* sjl: manually stripmine so we can limit amount of
#line 2952
   * vector work space reserved to LOOPCNT elements. Also
#line 2952
   * makes vectorisation easy */
#line 2952
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2952
    ni=Min(nelems-j,LOOPCNT);
#line 2952
    if (realign) {
#line 2952
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2952
      xp = tmp;
#line 2952
    } else {
#line 2952
      xp = (uint *) *xpp;
#line 2952
    }
#line 2952
   /* copy the next block */
#line 2952
#pragma cdir loopcnt=LOOPCNT
#line 2952
#pragma cdir shortloop
#line 2952
    for (i=0; i<ni; i++) {
#line 2952
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 2952
     /* test for range errors (not always needed but do it anyway) */
#line 2952
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2952
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2952
      nrange += xp[i] > USHORT_MAX ;
#line 2952
    }
#line 2952
   /* update xpp and tp */
#line 2952
    if (realign) xp = (uint *) *xpp;
#line 2952
    xp += ni;
#line 2952
    tp += ni;
#line 2952
    *xpp = (void*)xp;
#line 2952
  }
#line 2952
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2952

#line 2952
#else   /* not SX */
#line 2952
	const char *xp = (const char *) *xpp;
#line 2952
	int status = NC_NOERR;
#line 2952

#line 2952
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2952
	{
#line 2952
		const int lstatus = ncx_get_uint_ushort(xp, tp);
#line 2952
		if(lstatus != NC_NOERR)
#line 2952
			status = lstatus;
#line 2952
	}
#line 2952

#line 2952
	*xpp = (const void *)xp;
#line 2952
	return status;
#line 2952
#  endif
#line 2952
}
#line 2952

int
#line 2953
ncx_getn_uint_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 2953
{
#line 2953
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2953

#line 2953
 /* basic algorithm is:
#line 2953
  *   - ensure sane alignment of input data
#line 2953
  *   - copy (conversion happens automatically) input data
#line 2953
  *     to output
#line 2953
  *   - update xpp to point at next unconverted input, and tp to point
#line 2953
  *     at next location for converted output
#line 2953
  */
#line 2953
  long i, j, ni;
#line 2953
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2953
  uint *xp;
#line 2953
  int nrange = 0;         /* number of range errors */
#line 2953
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2953
  long cxp = (long) *((char**)xpp);
#line 2953

#line 2953
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2953
  /* sjl: manually stripmine so we can limit amount of
#line 2953
   * vector work space reserved to LOOPCNT elements. Also
#line 2953
   * makes vectorisation easy */
#line 2953
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2953
    ni=Min(nelems-j,LOOPCNT);
#line 2953
    if (realign) {
#line 2953
      memcpy(tmp, *xpp, ni*SIZEOF_UINT);
#line 2953
      xp = tmp;
#line 2953
    } else {
#line 2953
      xp = (uint *) *xpp;
#line 2953
    }
#line 2953
   /* copy the next block */
#line 2953
#pragma cdir loopcnt=LOOPCNT
#line 2953
#pragma cdir shortloop
#line 2953
    for (i=0; i<ni; i++) {
#line 2953
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 2953
     /* test for range errors (not always needed but do it anyway) */
#line 2953
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 2953
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 2953
      nrange += xp[i] > ULONGLONG_MAX ;
#line 2953
    }
#line 2953
   /* update xpp and tp */
#line 2953
    if (realign) xp = (uint *) *xpp;
#line 2953
    xp += ni;
#line 2953
    tp += ni;
#line 2953
    *xpp = (void*)xp;
#line 2953
  }
#line 2953
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2953

#line 2953
#else   /* not SX */
#line 2953
	const char *xp = (const char *) *xpp;
#line 2953
	int status = NC_NOERR;
#line 2953

#line 2953
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2953
	{
#line 2953
		const int lstatus = ncx_get_uint_ulonglong(xp, tp);
#line 2953
		if(lstatus != NC_NOERR)
#line 2953
			status = lstatus;
#line 2953
	}
#line 2953

#line 2953
	*xpp = (const void *)xp;
#line 2953
	return status;
#line 2953
#  endif
#line 2953
}
#line 2953


#if X_SIZEOF_UINT == SIZEOF_UINT
/* optimized version */
int
ncx_putn_uint_uint(void **xpp, size_t nelems, const unsigned int *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_UINT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_UINT);
	return NC_NOERR;
}
#else
int
#line 2969
ncx_putn_uint_uint(void **xpp, size_t nelems, const uint *tp)
#line 2969
{
#line 2969
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2969

#line 2969
 /* basic algorithm is:
#line 2969
  *   - ensure sane alignment of output data
#line 2969
  *   - copy (conversion happens automatically) input data
#line 2969
  *     to output
#line 2969
  *   - update tp to point at next unconverted input, and xpp to point
#line 2969
  *     at next location for converted output
#line 2969
  */
#line 2969
  long i, j, ni;
#line 2969
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2969
  uint *xp;
#line 2969
  int nrange = 0;         /* number of range errors */
#line 2969
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2969
  long cxp = (long) *((char**)xpp);
#line 2969

#line 2969
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2969
  /* sjl: manually stripmine so we can limit amount of
#line 2969
   * vector work space reserved to LOOPCNT elements. Also
#line 2969
   * makes vectorisation easy */
#line 2969
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2969
    ni=Min(nelems-j,LOOPCNT);
#line 2969
    if (realign) {
#line 2969
      xp = tmp;
#line 2969
    } else {
#line 2969
      xp = (uint *) *xpp;
#line 2969
    }
#line 2969
   /* copy the next block */
#line 2969
#pragma cdir loopcnt=LOOPCNT
#line 2969
#pragma cdir shortloop
#line 2969
    for (i=0; i<ni; i++) {
#line 2969
      /* the normal case: */
#line 2969
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2969
     /* test for range errors (not always needed but do it anyway) */
#line 2969
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2969
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2969
      nrange += tp[i] > X_UINT_MAX ;
#line 2969
    }
#line 2969
   /* copy workspace back if necessary */
#line 2969
    if (realign) {
#line 2969
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2969
      xp = (uint *) *xpp;
#line 2969
    }
#line 2969
   /* update xpp and tp */
#line 2969
    xp += ni;
#line 2969
    tp += ni;
#line 2969
    *xpp = (void*)xp;
#line 2969
  }
#line 2969
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2969

#line 2969
#else   /* not SX */
#line 2969

#line 2969
	char *xp = (char *) *xpp;
#line 2969
	int status = NC_NOERR;
#line 2969

#line 2969
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2969
	{
#line 2969
		int lstatus = ncx_put_uint_uint(xp, tp);
#line 2969
		if(lstatus != NC_NOERR)
#line 2969
			status = lstatus;
#line 2969
	}
#line 2969

#line 2969
	*xpp = (void *)xp;
#line 2969
	return status;
#line 2969
#endif
#line 2969
}
#line 2969

#endif
int
#line 2971
ncx_putn_uint_schar(void **xpp, size_t nelems, const schar *tp)
#line 2971
{
#line 2971
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2971

#line 2971
 /* basic algorithm is:
#line 2971
  *   - ensure sane alignment of output data
#line 2971
  *   - copy (conversion happens automatically) input data
#line 2971
  *     to output
#line 2971
  *   - update tp to point at next unconverted input, and xpp to point
#line 2971
  *     at next location for converted output
#line 2971
  */
#line 2971
  long i, j, ni;
#line 2971
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2971
  uint *xp;
#line 2971
  int nrange = 0;         /* number of range errors */
#line 2971
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2971
  long cxp = (long) *((char**)xpp);
#line 2971

#line 2971
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2971
  /* sjl: manually stripmine so we can limit amount of
#line 2971
   * vector work space reserved to LOOPCNT elements. Also
#line 2971
   * makes vectorisation easy */
#line 2971
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2971
    ni=Min(nelems-j,LOOPCNT);
#line 2971
    if (realign) {
#line 2971
      xp = tmp;
#line 2971
    } else {
#line 2971
      xp = (uint *) *xpp;
#line 2971
    }
#line 2971
   /* copy the next block */
#line 2971
#pragma cdir loopcnt=LOOPCNT
#line 2971
#pragma cdir shortloop
#line 2971
    for (i=0; i<ni; i++) {
#line 2971
      /* the normal case: */
#line 2971
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2971
     /* test for range errors (not always needed but do it anyway) */
#line 2971
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2971
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2971
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 2971
    }
#line 2971
   /* copy workspace back if necessary */
#line 2971
    if (realign) {
#line 2971
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2971
      xp = (uint *) *xpp;
#line 2971
    }
#line 2971
   /* update xpp and tp */
#line 2971
    xp += ni;
#line 2971
    tp += ni;
#line 2971
    *xpp = (void*)xp;
#line 2971
  }
#line 2971
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2971

#line 2971
#else   /* not SX */
#line 2971

#line 2971
	char *xp = (char *) *xpp;
#line 2971
	int status = NC_NOERR;
#line 2971

#line 2971
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2971
	{
#line 2971
		int lstatus = ncx_put_uint_schar(xp, tp);
#line 2971
		if(lstatus != NC_NOERR)
#line 2971
			status = lstatus;
#line 2971
	}
#line 2971

#line 2971
	*xpp = (void *)xp;
#line 2971
	return status;
#line 2971
#endif
#line 2971
}
#line 2971

int
#line 2972
ncx_putn_uint_short(void **xpp, size_t nelems, const short *tp)
#line 2972
{
#line 2972
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2972

#line 2972
 /* basic algorithm is:
#line 2972
  *   - ensure sane alignment of output data
#line 2972
  *   - copy (conversion happens automatically) input data
#line 2972
  *     to output
#line 2972
  *   - update tp to point at next unconverted input, and xpp to point
#line 2972
  *     at next location for converted output
#line 2972
  */
#line 2972
  long i, j, ni;
#line 2972
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2972
  uint *xp;
#line 2972
  int nrange = 0;         /* number of range errors */
#line 2972
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2972
  long cxp = (long) *((char**)xpp);
#line 2972

#line 2972
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2972
  /* sjl: manually stripmine so we can limit amount of
#line 2972
   * vector work space reserved to LOOPCNT elements. Also
#line 2972
   * makes vectorisation easy */
#line 2972
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2972
    ni=Min(nelems-j,LOOPCNT);
#line 2972
    if (realign) {
#line 2972
      xp = tmp;
#line 2972
    } else {
#line 2972
      xp = (uint *) *xpp;
#line 2972
    }
#line 2972
   /* copy the next block */
#line 2972
#pragma cdir loopcnt=LOOPCNT
#line 2972
#pragma cdir shortloop
#line 2972
    for (i=0; i<ni; i++) {
#line 2972
      /* the normal case: */
#line 2972
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2972
     /* test for range errors (not always needed but do it anyway) */
#line 2972
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2972
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2972
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 2972
    }
#line 2972
   /* copy workspace back if necessary */
#line 2972
    if (realign) {
#line 2972
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2972
      xp = (uint *) *xpp;
#line 2972
    }
#line 2972
   /* update xpp and tp */
#line 2972
    xp += ni;
#line 2972
    tp += ni;
#line 2972
    *xpp = (void*)xp;
#line 2972
  }
#line 2972
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2972

#line 2972
#else   /* not SX */
#line 2972

#line 2972
	char *xp = (char *) *xpp;
#line 2972
	int status = NC_NOERR;
#line 2972

#line 2972
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2972
	{
#line 2972
		int lstatus = ncx_put_uint_short(xp, tp);
#line 2972
		if(lstatus != NC_NOERR)
#line 2972
			status = lstatus;
#line 2972
	}
#line 2972

#line 2972
	*xpp = (void *)xp;
#line 2972
	return status;
#line 2972
#endif
#line 2972
}
#line 2972

int
#line 2973
ncx_putn_uint_int(void **xpp, size_t nelems, const int *tp)
#line 2973
{
#line 2973
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2973

#line 2973
 /* basic algorithm is:
#line 2973
  *   - ensure sane alignment of output data
#line 2973
  *   - copy (conversion happens automatically) input data
#line 2973
  *     to output
#line 2973
  *   - update tp to point at next unconverted input, and xpp to point
#line 2973
  *     at next location for converted output
#line 2973
  */
#line 2973
  long i, j, ni;
#line 2973
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2973
  uint *xp;
#line 2973
  int nrange = 0;         /* number of range errors */
#line 2973
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2973
  long cxp = (long) *((char**)xpp);
#line 2973

#line 2973
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2973
  /* sjl: manually stripmine so we can limit amount of
#line 2973
   * vector work space reserved to LOOPCNT elements. Also
#line 2973
   * makes vectorisation easy */
#line 2973
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2973
    ni=Min(nelems-j,LOOPCNT);
#line 2973
    if (realign) {
#line 2973
      xp = tmp;
#line 2973
    } else {
#line 2973
      xp = (uint *) *xpp;
#line 2973
    }
#line 2973
   /* copy the next block */
#line 2973
#pragma cdir loopcnt=LOOPCNT
#line 2973
#pragma cdir shortloop
#line 2973
    for (i=0; i<ni; i++) {
#line 2973
      /* the normal case: */
#line 2973
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2973
     /* test for range errors (not always needed but do it anyway) */
#line 2973
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2973
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2973
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 2973
    }
#line 2973
   /* copy workspace back if necessary */
#line 2973
    if (realign) {
#line 2973
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2973
      xp = (uint *) *xpp;
#line 2973
    }
#line 2973
   /* update xpp and tp */
#line 2973
    xp += ni;
#line 2973
    tp += ni;
#line 2973
    *xpp = (void*)xp;
#line 2973
  }
#line 2973
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2973

#line 2973
#else   /* not SX */
#line 2973

#line 2973
	char *xp = (char *) *xpp;
#line 2973
	int status = NC_NOERR;
#line 2973

#line 2973
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2973
	{
#line 2973
		int lstatus = ncx_put_uint_int(xp, tp);
#line 2973
		if(lstatus != NC_NOERR)
#line 2973
			status = lstatus;
#line 2973
	}
#line 2973

#line 2973
	*xpp = (void *)xp;
#line 2973
	return status;
#line 2973
#endif
#line 2973
}
#line 2973

int
#line 2974
ncx_putn_uint_float(void **xpp, size_t nelems, const float *tp)
#line 2974
{
#line 2974
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2974

#line 2974
 /* basic algorithm is:
#line 2974
  *   - ensure sane alignment of output data
#line 2974
  *   - copy (conversion happens automatically) input data
#line 2974
  *     to output
#line 2974
  *   - update tp to point at next unconverted input, and xpp to point
#line 2974
  *     at next location for converted output
#line 2974
  */
#line 2974
  long i, j, ni;
#line 2974
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2974
  uint *xp;
#line 2974
  int nrange = 0;         /* number of range errors */
#line 2974
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2974
  long cxp = (long) *((char**)xpp);
#line 2974

#line 2974
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2974
  /* sjl: manually stripmine so we can limit amount of
#line 2974
   * vector work space reserved to LOOPCNT elements. Also
#line 2974
   * makes vectorisation easy */
#line 2974
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2974
    ni=Min(nelems-j,LOOPCNT);
#line 2974
    if (realign) {
#line 2974
      xp = tmp;
#line 2974
    } else {
#line 2974
      xp = (uint *) *xpp;
#line 2974
    }
#line 2974
   /* copy the next block */
#line 2974
#pragma cdir loopcnt=LOOPCNT
#line 2974
#pragma cdir shortloop
#line 2974
    for (i=0; i<ni; i++) {
#line 2974
      /* the normal case: */
#line 2974
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2974
     /* test for range errors (not always needed but do it anyway) */
#line 2974
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2974
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2974
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 2974
    }
#line 2974
   /* copy workspace back if necessary */
#line 2974
    if (realign) {
#line 2974
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2974
      xp = (uint *) *xpp;
#line 2974
    }
#line 2974
   /* update xpp and tp */
#line 2974
    xp += ni;
#line 2974
    tp += ni;
#line 2974
    *xpp = (void*)xp;
#line 2974
  }
#line 2974
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2974

#line 2974
#else   /* not SX */
#line 2974

#line 2974
	char *xp = (char *) *xpp;
#line 2974
	int status = NC_NOERR;
#line 2974

#line 2974
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2974
	{
#line 2974
		int lstatus = ncx_put_uint_float(xp, tp);
#line 2974
		if(lstatus != NC_NOERR)
#line 2974
			status = lstatus;
#line 2974
	}
#line 2974

#line 2974
	*xpp = (void *)xp;
#line 2974
	return status;
#line 2974
#endif
#line 2974
}
#line 2974

int
#line 2975
ncx_putn_uint_double(void **xpp, size_t nelems, const double *tp)
#line 2975
{
#line 2975
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2975

#line 2975
 /* basic algorithm is:
#line 2975
  *   - ensure sane alignment of output data
#line 2975
  *   - copy (conversion happens automatically) input data
#line 2975
  *     to output
#line 2975
  *   - update tp to point at next unconverted input, and xpp to point
#line 2975
  *     at next location for converted output
#line 2975
  */
#line 2975
  long i, j, ni;
#line 2975
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2975
  uint *xp;
#line 2975
  int nrange = 0;         /* number of range errors */
#line 2975
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2975
  long cxp = (long) *((char**)xpp);
#line 2975

#line 2975
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2975
  /* sjl: manually stripmine so we can limit amount of
#line 2975
   * vector work space reserved to LOOPCNT elements. Also
#line 2975
   * makes vectorisation easy */
#line 2975
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2975
    ni=Min(nelems-j,LOOPCNT);
#line 2975
    if (realign) {
#line 2975
      xp = tmp;
#line 2975
    } else {
#line 2975
      xp = (uint *) *xpp;
#line 2975
    }
#line 2975
   /* copy the next block */
#line 2975
#pragma cdir loopcnt=LOOPCNT
#line 2975
#pragma cdir shortloop
#line 2975
    for (i=0; i<ni; i++) {
#line 2975
      /* the normal case: */
#line 2975
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2975
     /* test for range errors (not always needed but do it anyway) */
#line 2975
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2975
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2975
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 2975
    }
#line 2975
   /* copy workspace back if necessary */
#line 2975
    if (realign) {
#line 2975
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2975
      xp = (uint *) *xpp;
#line 2975
    }
#line 2975
   /* update xpp and tp */
#line 2975
    xp += ni;
#line 2975
    tp += ni;
#line 2975
    *xpp = (void*)xp;
#line 2975
  }
#line 2975
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2975

#line 2975
#else   /* not SX */
#line 2975

#line 2975
	char *xp = (char *) *xpp;
#line 2975
	int status = NC_NOERR;
#line 2975

#line 2975
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2975
	{
#line 2975
		int lstatus = ncx_put_uint_double(xp, tp);
#line 2975
		if(lstatus != NC_NOERR)
#line 2975
			status = lstatus;
#line 2975
	}
#line 2975

#line 2975
	*xpp = (void *)xp;
#line 2975
	return status;
#line 2975
#endif
#line 2975
}
#line 2975

int
#line 2976
ncx_putn_uint_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 2976
{
#line 2976
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2976

#line 2976
 /* basic algorithm is:
#line 2976
  *   - ensure sane alignment of output data
#line 2976
  *   - copy (conversion happens automatically) input data
#line 2976
  *     to output
#line 2976
  *   - update tp to point at next unconverted input, and xpp to point
#line 2976
  *     at next location for converted output
#line 2976
  */
#line 2976
  long i, j, ni;
#line 2976
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2976
  uint *xp;
#line 2976
  int nrange = 0;         /* number of range errors */
#line 2976
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2976
  long cxp = (long) *((char**)xpp);
#line 2976

#line 2976
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2976
  /* sjl: manually stripmine so we can limit amount of
#line 2976
   * vector work space reserved to LOOPCNT elements. Also
#line 2976
   * makes vectorisation easy */
#line 2976
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2976
    ni=Min(nelems-j,LOOPCNT);
#line 2976
    if (realign) {
#line 2976
      xp = tmp;
#line 2976
    } else {
#line 2976
      xp = (uint *) *xpp;
#line 2976
    }
#line 2976
   /* copy the next block */
#line 2976
#pragma cdir loopcnt=LOOPCNT
#line 2976
#pragma cdir shortloop
#line 2976
    for (i=0; i<ni; i++) {
#line 2976
      /* the normal case: */
#line 2976
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2976
     /* test for range errors (not always needed but do it anyway) */
#line 2976
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2976
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2976
      nrange += tp[i] > X_UINT_MAX || tp[i] < 0;
#line 2976
    }
#line 2976
   /* copy workspace back if necessary */
#line 2976
    if (realign) {
#line 2976
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2976
      xp = (uint *) *xpp;
#line 2976
    }
#line 2976
   /* update xpp and tp */
#line 2976
    xp += ni;
#line 2976
    tp += ni;
#line 2976
    *xpp = (void*)xp;
#line 2976
  }
#line 2976
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2976

#line 2976
#else   /* not SX */
#line 2976

#line 2976
	char *xp = (char *) *xpp;
#line 2976
	int status = NC_NOERR;
#line 2976

#line 2976
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2976
	{
#line 2976
		int lstatus = ncx_put_uint_longlong(xp, tp);
#line 2976
		if(lstatus != NC_NOERR)
#line 2976
			status = lstatus;
#line 2976
	}
#line 2976

#line 2976
	*xpp = (void *)xp;
#line 2976
	return status;
#line 2976
#endif
#line 2976
}
#line 2976

int
#line 2977
ncx_putn_uint_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 2977
{
#line 2977
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2977

#line 2977
 /* basic algorithm is:
#line 2977
  *   - ensure sane alignment of output data
#line 2977
  *   - copy (conversion happens automatically) input data
#line 2977
  *     to output
#line 2977
  *   - update tp to point at next unconverted input, and xpp to point
#line 2977
  *     at next location for converted output
#line 2977
  */
#line 2977
  long i, j, ni;
#line 2977
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2977
  uint *xp;
#line 2977
  int nrange = 0;         /* number of range errors */
#line 2977
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2977
  long cxp = (long) *((char**)xpp);
#line 2977

#line 2977
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2977
  /* sjl: manually stripmine so we can limit amount of
#line 2977
   * vector work space reserved to LOOPCNT elements. Also
#line 2977
   * makes vectorisation easy */
#line 2977
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2977
    ni=Min(nelems-j,LOOPCNT);
#line 2977
    if (realign) {
#line 2977
      xp = tmp;
#line 2977
    } else {
#line 2977
      xp = (uint *) *xpp;
#line 2977
    }
#line 2977
   /* copy the next block */
#line 2977
#pragma cdir loopcnt=LOOPCNT
#line 2977
#pragma cdir shortloop
#line 2977
    for (i=0; i<ni; i++) {
#line 2977
      /* the normal case: */
#line 2977
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2977
     /* test for range errors (not always needed but do it anyway) */
#line 2977
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2977
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2977
      nrange += tp[i] > X_UINT_MAX ;
#line 2977
    }
#line 2977
   /* copy workspace back if necessary */
#line 2977
    if (realign) {
#line 2977
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2977
      xp = (uint *) *xpp;
#line 2977
    }
#line 2977
   /* update xpp and tp */
#line 2977
    xp += ni;
#line 2977
    tp += ni;
#line 2977
    *xpp = (void*)xp;
#line 2977
  }
#line 2977
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2977

#line 2977
#else   /* not SX */
#line 2977

#line 2977
	char *xp = (char *) *xpp;
#line 2977
	int status = NC_NOERR;
#line 2977

#line 2977
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2977
	{
#line 2977
		int lstatus = ncx_put_uint_uchar(xp, tp);
#line 2977
		if(lstatus != NC_NOERR)
#line 2977
			status = lstatus;
#line 2977
	}
#line 2977

#line 2977
	*xpp = (void *)xp;
#line 2977
	return status;
#line 2977
#endif
#line 2977
}
#line 2977

int
#line 2978
ncx_putn_uint_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 2978
{
#line 2978
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2978

#line 2978
 /* basic algorithm is:
#line 2978
  *   - ensure sane alignment of output data
#line 2978
  *   - copy (conversion happens automatically) input data
#line 2978
  *     to output
#line 2978
  *   - update tp to point at next unconverted input, and xpp to point
#line 2978
  *     at next location for converted output
#line 2978
  */
#line 2978
  long i, j, ni;
#line 2978
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2978
  uint *xp;
#line 2978
  int nrange = 0;         /* number of range errors */
#line 2978
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2978
  long cxp = (long) *((char**)xpp);
#line 2978

#line 2978
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2978
  /* sjl: manually stripmine so we can limit amount of
#line 2978
   * vector work space reserved to LOOPCNT elements. Also
#line 2978
   * makes vectorisation easy */
#line 2978
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2978
    ni=Min(nelems-j,LOOPCNT);
#line 2978
    if (realign) {
#line 2978
      xp = tmp;
#line 2978
    } else {
#line 2978
      xp = (uint *) *xpp;
#line 2978
    }
#line 2978
   /* copy the next block */
#line 2978
#pragma cdir loopcnt=LOOPCNT
#line 2978
#pragma cdir shortloop
#line 2978
    for (i=0; i<ni; i++) {
#line 2978
      /* the normal case: */
#line 2978
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2978
     /* test for range errors (not always needed but do it anyway) */
#line 2978
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2978
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2978
      nrange += tp[i] > X_UINT_MAX ;
#line 2978
    }
#line 2978
   /* copy workspace back if necessary */
#line 2978
    if (realign) {
#line 2978
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2978
      xp = (uint *) *xpp;
#line 2978
    }
#line 2978
   /* update xpp and tp */
#line 2978
    xp += ni;
#line 2978
    tp += ni;
#line 2978
    *xpp = (void*)xp;
#line 2978
  }
#line 2978
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2978

#line 2978
#else   /* not SX */
#line 2978

#line 2978
	char *xp = (char *) *xpp;
#line 2978
	int status = NC_NOERR;
#line 2978

#line 2978
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2978
	{
#line 2978
		int lstatus = ncx_put_uint_ushort(xp, tp);
#line 2978
		if(lstatus != NC_NOERR)
#line 2978
			status = lstatus;
#line 2978
	}
#line 2978

#line 2978
	*xpp = (void *)xp;
#line 2978
	return status;
#line 2978
#endif
#line 2978
}
#line 2978

int
#line 2979
ncx_putn_uint_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 2979
{
#line 2979
#if _SX && X_SIZEOF_UINT == SIZEOF_UINT
#line 2979

#line 2979
 /* basic algorithm is:
#line 2979
  *   - ensure sane alignment of output data
#line 2979
  *   - copy (conversion happens automatically) input data
#line 2979
  *     to output
#line 2979
  *   - update tp to point at next unconverted input, and xpp to point
#line 2979
  *     at next location for converted output
#line 2979
  */
#line 2979
  long i, j, ni;
#line 2979
  uint tmp[LOOPCNT];        /* in case input is misaligned */
#line 2979
  uint *xp;
#line 2979
  int nrange = 0;         /* number of range errors */
#line 2979
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 2979
  long cxp = (long) *((char**)xpp);
#line 2979

#line 2979
  realign = (cxp & 7) % SIZEOF_UINT;
#line 2979
  /* sjl: manually stripmine so we can limit amount of
#line 2979
   * vector work space reserved to LOOPCNT elements. Also
#line 2979
   * makes vectorisation easy */
#line 2979
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 2979
    ni=Min(nelems-j,LOOPCNT);
#line 2979
    if (realign) {
#line 2979
      xp = tmp;
#line 2979
    } else {
#line 2979
      xp = (uint *) *xpp;
#line 2979
    }
#line 2979
   /* copy the next block */
#line 2979
#pragma cdir loopcnt=LOOPCNT
#line 2979
#pragma cdir shortloop
#line 2979
    for (i=0; i<ni; i++) {
#line 2979
      /* the normal case: */
#line 2979
      xp[i] = (uint) Max( X_UINT_MIN, Min(X_UINT_MAX, (uint) tp[i]));
#line 2979
     /* test for range errors (not always needed but do it anyway) */
#line 2979
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 2979
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 2979
      nrange += tp[i] > X_UINT_MAX ;
#line 2979
    }
#line 2979
   /* copy workspace back if necessary */
#line 2979
    if (realign) {
#line 2979
      memcpy(*xpp, tmp, ni*X_SIZEOF_UINT);
#line 2979
      xp = (uint *) *xpp;
#line 2979
    }
#line 2979
   /* update xpp and tp */
#line 2979
    xp += ni;
#line 2979
    tp += ni;
#line 2979
    *xpp = (void*)xp;
#line 2979
  }
#line 2979
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 2979

#line 2979
#else   /* not SX */
#line 2979

#line 2979
	char *xp = (char *) *xpp;
#line 2979
	int status = NC_NOERR;
#line 2979

#line 2979
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_UINT, tp++)
#line 2979
	{
#line 2979
		int lstatus = ncx_put_uint_ulonglong(xp, tp);
#line 2979
		if(lstatus != NC_NOERR)
#line 2979
			status = lstatus;
#line 2979
	}
#line 2979

#line 2979
	*xpp = (void *)xp;
#line 2979
	return status;
#line 2979
#endif
#line 2979
}
#line 2979



/* float ---------------------------------------------------------------------*/

#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(float));
# else
	swapn4b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif vax
int
ncx_getn_float_float(const void **xpp, size_t nfloats, float *ip)
{
	float *const end = ip + nfloats;

	while(ip < end)
	{
		struct vax_single *const vsp = (struct vax_single *) ip;
#line 3005
		const struct ieee_single *const isp =
#line 3005
			 (const struct ieee_single *) (*xpp);
#line 3005
		unsigned exp = isp->exp_hi << 1 | isp->exp_lo;
#line 3005

#line 3005
		switch(exp) {
#line 3005
		case 0 :
#line 3005
			/* ieee subnormal */
#line 3005
			if(isp->mant_hi == min.ieee.mant_hi
#line 3005
				&& isp->mant_lo_hi == min.ieee.mant_lo_hi
#line 3005
				&& isp->mant_lo_lo == min.ieee.mant_lo_lo)
#line 3005
			{
#line 3005
				*vsp = min.s;
#line 3005
			}
#line 3005
			else
#line 3005
			{
#line 3005
				unsigned mantissa = (isp->mant_hi << 16)
#line 3005
					 | isp->mant_lo_hi << 8
#line 3005
					 | isp->mant_lo_lo;
#line 3005
				unsigned tmp = mantissa >> 20;
#line 3005
				if(tmp >= 4) {
#line 3005
					vsp->exp = 2;
#line 3005
				} else if (tmp >= 2) {
#line 3005
					vsp->exp = 1;
#line 3005
				} else {
#line 3005
					*vsp = min.s;
#line 3005
					break;
#line 3005
				} /* else */
#line 3005
				tmp = mantissa - (1 << (20 + vsp->exp ));
#line 3005
				tmp <<= 3 - vsp->exp;
#line 3005
				vsp->mantissa2 = tmp;
#line 3005
				vsp->mantissa1 = (tmp >> 16);
#line 3005
			}
#line 3005
			break;
#line 3005
		case 0xfe :
#line 3005
		case 0xff :
#line 3005
			*vsp = max.s;
#line 3005
			break;
#line 3005
		default :
#line 3005
			vsp->exp = exp - IEEE_SNG_BIAS + VAX_SNG_BIAS;
#line 3005
			vsp->mantissa2 = isp->mant_lo_hi << 8 | isp->mant_lo_lo;
#line 3005
			vsp->mantissa1 = isp->mant_hi;
#line 3005
		}
#line 3005

#line 3005
		vsp->sign = isp->sign;
#line 3005


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_getn_float_float(const void **xpp, size_t nelems, float *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		const int lstatus = ncx_get_float_float(xp, tp);
		if(lstatus != NC_NOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}

#endif
int
#line 3031
ncx_getn_float_schar(const void **xpp, size_t nelems, schar *tp)
#line 3031
{
#line 3031
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3031

#line 3031
 /* basic algorithm is:
#line 3031
  *   - ensure sane alignment of input data
#line 3031
  *   - copy (conversion happens automatically) input data
#line 3031
  *     to output
#line 3031
  *   - update xpp to point at next unconverted input, and tp to point
#line 3031
  *     at next location for converted output
#line 3031
  */
#line 3031
  long i, j, ni;
#line 3031
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3031
  float *xp;
#line 3031
  int nrange = 0;         /* number of range errors */
#line 3031
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3031
  long cxp = (long) *((char**)xpp);
#line 3031

#line 3031
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3031
  /* sjl: manually stripmine so we can limit amount of
#line 3031
   * vector work space reserved to LOOPCNT elements. Also
#line 3031
   * makes vectorisation easy */
#line 3031
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3031
    ni=Min(nelems-j,LOOPCNT);
#line 3031
    if (realign) {
#line 3031
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3031
      xp = tmp;
#line 3031
    } else {
#line 3031
      xp = (float *) *xpp;
#line 3031
    }
#line 3031
   /* copy the next block */
#line 3031
#pragma cdir loopcnt=LOOPCNT
#line 3031
#pragma cdir shortloop
#line 3031
    for (i=0; i<ni; i++) {
#line 3031
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3031
     /* test for range errors (not always needed but do it anyway) */
#line 3031
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3031
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3031
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3031
    }
#line 3031
   /* update xpp and tp */
#line 3031
    if (realign) xp = (float *) *xpp;
#line 3031
    xp += ni;
#line 3031
    tp += ni;
#line 3031
    *xpp = (void*)xp;
#line 3031
  }
#line 3031
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3031

#line 3031
#else   /* not SX */
#line 3031
	const char *xp = (const char *) *xpp;
#line 3031
	int status = NC_NOERR;
#line 3031

#line 3031
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3031
	{
#line 3031
		const int lstatus = ncx_get_float_schar(xp, tp);
#line 3031
		if(lstatus != NC_NOERR)
#line 3031
			status = lstatus;
#line 3031
	}
#line 3031

#line 3031
	*xpp = (const void *)xp;
#line 3031
	return status;
#line 3031
#  endif
#line 3031
}
#line 3031

int
#line 3032
ncx_getn_float_short(const void **xpp, size_t nelems, short *tp)
#line 3032
{
#line 3032
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3032

#line 3032
 /* basic algorithm is:
#line 3032
  *   - ensure sane alignment of input data
#line 3032
  *   - copy (conversion happens automatically) input data
#line 3032
  *     to output
#line 3032
  *   - update xpp to point at next unconverted input, and tp to point
#line 3032
  *     at next location for converted output
#line 3032
  */
#line 3032
  long i, j, ni;
#line 3032
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3032
  float *xp;
#line 3032
  int nrange = 0;         /* number of range errors */
#line 3032
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3032
  long cxp = (long) *((char**)xpp);
#line 3032

#line 3032
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3032
  /* sjl: manually stripmine so we can limit amount of
#line 3032
   * vector work space reserved to LOOPCNT elements. Also
#line 3032
   * makes vectorisation easy */
#line 3032
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3032
    ni=Min(nelems-j,LOOPCNT);
#line 3032
    if (realign) {
#line 3032
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3032
      xp = tmp;
#line 3032
    } else {
#line 3032
      xp = (float *) *xpp;
#line 3032
    }
#line 3032
   /* copy the next block */
#line 3032
#pragma cdir loopcnt=LOOPCNT
#line 3032
#pragma cdir shortloop
#line 3032
    for (i=0; i<ni; i++) {
#line 3032
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3032
     /* test for range errors (not always needed but do it anyway) */
#line 3032
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3032
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3032
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3032
    }
#line 3032
   /* update xpp and tp */
#line 3032
    if (realign) xp = (float *) *xpp;
#line 3032
    xp += ni;
#line 3032
    tp += ni;
#line 3032
    *xpp = (void*)xp;
#line 3032
  }
#line 3032
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3032

#line 3032
#else   /* not SX */
#line 3032
	const char *xp = (const char *) *xpp;
#line 3032
	int status = NC_NOERR;
#line 3032

#line 3032
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3032
	{
#line 3032
		const int lstatus = ncx_get_float_short(xp, tp);
#line 3032
		if(lstatus != NC_NOERR)
#line 3032
			status = lstatus;
#line 3032
	}
#line 3032

#line 3032
	*xpp = (const void *)xp;
#line 3032
	return status;
#line 3032
#  endif
#line 3032
}
#line 3032

int
#line 3033
ncx_getn_float_int(const void **xpp, size_t nelems, int *tp)
#line 3033
{
#line 3033
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3033

#line 3033
 /* basic algorithm is:
#line 3033
  *   - ensure sane alignment of input data
#line 3033
  *   - copy (conversion happens automatically) input data
#line 3033
  *     to output
#line 3033
  *   - update xpp to point at next unconverted input, and tp to point
#line 3033
  *     at next location for converted output
#line 3033
  */
#line 3033
  long i, j, ni;
#line 3033
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3033
  float *xp;
#line 3033
  int nrange = 0;         /* number of range errors */
#line 3033
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3033
  long cxp = (long) *((char**)xpp);
#line 3033

#line 3033
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3033
  /* sjl: manually stripmine so we can limit amount of
#line 3033
   * vector work space reserved to LOOPCNT elements. Also
#line 3033
   * makes vectorisation easy */
#line 3033
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3033
    ni=Min(nelems-j,LOOPCNT);
#line 3033
    if (realign) {
#line 3033
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3033
      xp = tmp;
#line 3033
    } else {
#line 3033
      xp = (float *) *xpp;
#line 3033
    }
#line 3033
   /* copy the next block */
#line 3033
#pragma cdir loopcnt=LOOPCNT
#line 3033
#pragma cdir shortloop
#line 3033
    for (i=0; i<ni; i++) {
#line 3033
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3033
     /* test for range errors (not always needed but do it anyway) */
#line 3033
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3033
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3033
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3033
    }
#line 3033
   /* update xpp and tp */
#line 3033
    if (realign) xp = (float *) *xpp;
#line 3033
    xp += ni;
#line 3033
    tp += ni;
#line 3033
    *xpp = (void*)xp;
#line 3033
  }
#line 3033
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3033

#line 3033
#else   /* not SX */
#line 3033
	const char *xp = (const char *) *xpp;
#line 3033
	int status = NC_NOERR;
#line 3033

#line 3033
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3033
	{
#line 3033
		const int lstatus = ncx_get_float_int(xp, tp);
#line 3033
		if(lstatus != NC_NOERR)
#line 3033
			status = lstatus;
#line 3033
	}
#line 3033

#line 3033
	*xpp = (const void *)xp;
#line 3033
	return status;
#line 3033
#  endif
#line 3033
}
#line 3033

int
#line 3034
ncx_getn_float_double(const void **xpp, size_t nelems, double *tp)
#line 3034
{
#line 3034
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3034

#line 3034
 /* basic algorithm is:
#line 3034
  *   - ensure sane alignment of input data
#line 3034
  *   - copy (conversion happens automatically) input data
#line 3034
  *     to output
#line 3034
  *   - update xpp to point at next unconverted input, and tp to point
#line 3034
  *     at next location for converted output
#line 3034
  */
#line 3034
  long i, j, ni;
#line 3034
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3034
  float *xp;
#line 3034
  int nrange = 0;         /* number of range errors */
#line 3034
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3034
  long cxp = (long) *((char**)xpp);
#line 3034

#line 3034
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3034
  /* sjl: manually stripmine so we can limit amount of
#line 3034
   * vector work space reserved to LOOPCNT elements. Also
#line 3034
   * makes vectorisation easy */
#line 3034
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3034
    ni=Min(nelems-j,LOOPCNT);
#line 3034
    if (realign) {
#line 3034
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3034
      xp = tmp;
#line 3034
    } else {
#line 3034
      xp = (float *) *xpp;
#line 3034
    }
#line 3034
   /* copy the next block */
#line 3034
#pragma cdir loopcnt=LOOPCNT
#line 3034
#pragma cdir shortloop
#line 3034
    for (i=0; i<ni; i++) {
#line 3034
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3034
     /* test for range errors (not always needed but do it anyway) */
#line 3034
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3034
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3034
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3034
    }
#line 3034
   /* update xpp and tp */
#line 3034
    if (realign) xp = (float *) *xpp;
#line 3034
    xp += ni;
#line 3034
    tp += ni;
#line 3034
    *xpp = (void*)xp;
#line 3034
  }
#line 3034
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3034

#line 3034
#else   /* not SX */
#line 3034
	const char *xp = (const char *) *xpp;
#line 3034
	int status = NC_NOERR;
#line 3034

#line 3034
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3034
	{
#line 3034
		const int lstatus = ncx_get_float_double(xp, tp);
#line 3034
		if(lstatus != NC_NOERR)
#line 3034
			status = lstatus;
#line 3034
	}
#line 3034

#line 3034
	*xpp = (const void *)xp;
#line 3034
	return status;
#line 3034
#  endif
#line 3034
}
#line 3034

int
#line 3035
ncx_getn_float_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3035
{
#line 3035
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3035

#line 3035
 /* basic algorithm is:
#line 3035
  *   - ensure sane alignment of input data
#line 3035
  *   - copy (conversion happens automatically) input data
#line 3035
  *     to output
#line 3035
  *   - update xpp to point at next unconverted input, and tp to point
#line 3035
  *     at next location for converted output
#line 3035
  */
#line 3035
  long i, j, ni;
#line 3035
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3035
  float *xp;
#line 3035
  int nrange = 0;         /* number of range errors */
#line 3035
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3035
  long cxp = (long) *((char**)xpp);
#line 3035

#line 3035
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3035
  /* sjl: manually stripmine so we can limit amount of
#line 3035
   * vector work space reserved to LOOPCNT elements. Also
#line 3035
   * makes vectorisation easy */
#line 3035
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3035
    ni=Min(nelems-j,LOOPCNT);
#line 3035
    if (realign) {
#line 3035
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3035
      xp = tmp;
#line 3035
    } else {
#line 3035
      xp = (float *) *xpp;
#line 3035
    }
#line 3035
   /* copy the next block */
#line 3035
#pragma cdir loopcnt=LOOPCNT
#line 3035
#pragma cdir shortloop
#line 3035
    for (i=0; i<ni; i++) {
#line 3035
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3035
     /* test for range errors (not always needed but do it anyway) */
#line 3035
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3035
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3035
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3035
    }
#line 3035
   /* update xpp and tp */
#line 3035
    if (realign) xp = (float *) *xpp;
#line 3035
    xp += ni;
#line 3035
    tp += ni;
#line 3035
    *xpp = (void*)xp;
#line 3035
  }
#line 3035
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3035

#line 3035
#else   /* not SX */
#line 3035
	const char *xp = (const char *) *xpp;
#line 3035
	int status = NC_NOERR;
#line 3035

#line 3035
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3035
	{
#line 3035
		const int lstatus = ncx_get_float_longlong(xp, tp);
#line 3035
		if(lstatus != NC_NOERR)
#line 3035
			status = lstatus;
#line 3035
	}
#line 3035

#line 3035
	*xpp = (const void *)xp;
#line 3035
	return status;
#line 3035
#  endif
#line 3035
}
#line 3035

int
#line 3036
ncx_getn_float_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3036
{
#line 3036
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3036

#line 3036
 /* basic algorithm is:
#line 3036
  *   - ensure sane alignment of input data
#line 3036
  *   - copy (conversion happens automatically) input data
#line 3036
  *     to output
#line 3036
  *   - update xpp to point at next unconverted input, and tp to point
#line 3036
  *     at next location for converted output
#line 3036
  */
#line 3036
  long i, j, ni;
#line 3036
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3036
  float *xp;
#line 3036
  int nrange = 0;         /* number of range errors */
#line 3036
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3036
  long cxp = (long) *((char**)xpp);
#line 3036

#line 3036
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3036
  /* sjl: manually stripmine so we can limit amount of
#line 3036
   * vector work space reserved to LOOPCNT elements. Also
#line 3036
   * makes vectorisation easy */
#line 3036
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3036
    ni=Min(nelems-j,LOOPCNT);
#line 3036
    if (realign) {
#line 3036
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3036
      xp = tmp;
#line 3036
    } else {
#line 3036
      xp = (float *) *xpp;
#line 3036
    }
#line 3036
   /* copy the next block */
#line 3036
#pragma cdir loopcnt=LOOPCNT
#line 3036
#pragma cdir shortloop
#line 3036
    for (i=0; i<ni; i++) {
#line 3036
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3036
     /* test for range errors (not always needed but do it anyway) */
#line 3036
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3036
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3036
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3036
    }
#line 3036
   /* update xpp and tp */
#line 3036
    if (realign) xp = (float *) *xpp;
#line 3036
    xp += ni;
#line 3036
    tp += ni;
#line 3036
    *xpp = (void*)xp;
#line 3036
  }
#line 3036
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3036

#line 3036
#else   /* not SX */
#line 3036
	const char *xp = (const char *) *xpp;
#line 3036
	int status = NC_NOERR;
#line 3036

#line 3036
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3036
	{
#line 3036
		const int lstatus = ncx_get_float_ushort(xp, tp);
#line 3036
		if(lstatus != NC_NOERR)
#line 3036
			status = lstatus;
#line 3036
	}
#line 3036

#line 3036
	*xpp = (const void *)xp;
#line 3036
	return status;
#line 3036
#  endif
#line 3036
}
#line 3036

int
#line 3037
ncx_getn_float_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3037
{
#line 3037
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3037

#line 3037
 /* basic algorithm is:
#line 3037
  *   - ensure sane alignment of input data
#line 3037
  *   - copy (conversion happens automatically) input data
#line 3037
  *     to output
#line 3037
  *   - update xpp to point at next unconverted input, and tp to point
#line 3037
  *     at next location for converted output
#line 3037
  */
#line 3037
  long i, j, ni;
#line 3037
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3037
  float *xp;
#line 3037
  int nrange = 0;         /* number of range errors */
#line 3037
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3037
  long cxp = (long) *((char**)xpp);
#line 3037

#line 3037
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3037
  /* sjl: manually stripmine so we can limit amount of
#line 3037
   * vector work space reserved to LOOPCNT elements. Also
#line 3037
   * makes vectorisation easy */
#line 3037
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3037
    ni=Min(nelems-j,LOOPCNT);
#line 3037
    if (realign) {
#line 3037
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3037
      xp = tmp;
#line 3037
    } else {
#line 3037
      xp = (float *) *xpp;
#line 3037
    }
#line 3037
   /* copy the next block */
#line 3037
#pragma cdir loopcnt=LOOPCNT
#line 3037
#pragma cdir shortloop
#line 3037
    for (i=0; i<ni; i++) {
#line 3037
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3037
     /* test for range errors (not always needed but do it anyway) */
#line 3037
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3037
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3037
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3037
    }
#line 3037
   /* update xpp and tp */
#line 3037
    if (realign) xp = (float *) *xpp;
#line 3037
    xp += ni;
#line 3037
    tp += ni;
#line 3037
    *xpp = (void*)xp;
#line 3037
  }
#line 3037
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3037

#line 3037
#else   /* not SX */
#line 3037
	const char *xp = (const char *) *xpp;
#line 3037
	int status = NC_NOERR;
#line 3037

#line 3037
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3037
	{
#line 3037
		const int lstatus = ncx_get_float_uchar(xp, tp);
#line 3037
		if(lstatus != NC_NOERR)
#line 3037
			status = lstatus;
#line 3037
	}
#line 3037

#line 3037
	*xpp = (const void *)xp;
#line 3037
	return status;
#line 3037
#  endif
#line 3037
}
#line 3037

int
#line 3038
ncx_getn_float_uint(const void **xpp, size_t nelems, uint *tp)
#line 3038
{
#line 3038
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3038

#line 3038
 /* basic algorithm is:
#line 3038
  *   - ensure sane alignment of input data
#line 3038
  *   - copy (conversion happens automatically) input data
#line 3038
  *     to output
#line 3038
  *   - update xpp to point at next unconverted input, and tp to point
#line 3038
  *     at next location for converted output
#line 3038
  */
#line 3038
  long i, j, ni;
#line 3038
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3038
  float *xp;
#line 3038
  int nrange = 0;         /* number of range errors */
#line 3038
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3038
  long cxp = (long) *((char**)xpp);
#line 3038

#line 3038
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3038
  /* sjl: manually stripmine so we can limit amount of
#line 3038
   * vector work space reserved to LOOPCNT elements. Also
#line 3038
   * makes vectorisation easy */
#line 3038
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3038
    ni=Min(nelems-j,LOOPCNT);
#line 3038
    if (realign) {
#line 3038
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3038
      xp = tmp;
#line 3038
    } else {
#line 3038
      xp = (float *) *xpp;
#line 3038
    }
#line 3038
   /* copy the next block */
#line 3038
#pragma cdir loopcnt=LOOPCNT
#line 3038
#pragma cdir shortloop
#line 3038
    for (i=0; i<ni; i++) {
#line 3038
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3038
     /* test for range errors (not always needed but do it anyway) */
#line 3038
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3038
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3038
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3038
    }
#line 3038
   /* update xpp and tp */
#line 3038
    if (realign) xp = (float *) *xpp;
#line 3038
    xp += ni;
#line 3038
    tp += ni;
#line 3038
    *xpp = (void*)xp;
#line 3038
  }
#line 3038
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3038

#line 3038
#else   /* not SX */
#line 3038
	const char *xp = (const char *) *xpp;
#line 3038
	int status = NC_NOERR;
#line 3038

#line 3038
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3038
	{
#line 3038
		const int lstatus = ncx_get_float_uint(xp, tp);
#line 3038
		if(lstatus != NC_NOERR)
#line 3038
			status = lstatus;
#line 3038
	}
#line 3038

#line 3038
	*xpp = (const void *)xp;
#line 3038
	return status;
#line 3038
#  endif
#line 3038
}
#line 3038

int
#line 3039
ncx_getn_float_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3039
{
#line 3039
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3039

#line 3039
 /* basic algorithm is:
#line 3039
  *   - ensure sane alignment of input data
#line 3039
  *   - copy (conversion happens automatically) input data
#line 3039
  *     to output
#line 3039
  *   - update xpp to point at next unconverted input, and tp to point
#line 3039
  *     at next location for converted output
#line 3039
  */
#line 3039
  long i, j, ni;
#line 3039
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3039
  float *xp;
#line 3039
  int nrange = 0;         /* number of range errors */
#line 3039
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3039
  long cxp = (long) *((char**)xpp);
#line 3039

#line 3039
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3039
  /* sjl: manually stripmine so we can limit amount of
#line 3039
   * vector work space reserved to LOOPCNT elements. Also
#line 3039
   * makes vectorisation easy */
#line 3039
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3039
    ni=Min(nelems-j,LOOPCNT);
#line 3039
    if (realign) {
#line 3039
      memcpy(tmp, *xpp, ni*SIZEOF_FLOAT);
#line 3039
      xp = tmp;
#line 3039
    } else {
#line 3039
      xp = (float *) *xpp;
#line 3039
    }
#line 3039
   /* copy the next block */
#line 3039
#pragma cdir loopcnt=LOOPCNT
#line 3039
#pragma cdir shortloop
#line 3039
    for (i=0; i<ni; i++) {
#line 3039
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3039
     /* test for range errors (not always needed but do it anyway) */
#line 3039
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3039
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3039
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3039
    }
#line 3039
   /* update xpp and tp */
#line 3039
    if (realign) xp = (float *) *xpp;
#line 3039
    xp += ni;
#line 3039
    tp += ni;
#line 3039
    *xpp = (void*)xp;
#line 3039
  }
#line 3039
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3039

#line 3039
#else   /* not SX */
#line 3039
	const char *xp = (const char *) *xpp;
#line 3039
	int status = NC_NOERR;
#line 3039

#line 3039
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3039
	{
#line 3039
		const int lstatus = ncx_get_float_ulonglong(xp, tp);
#line 3039
		if(lstatus != NC_NOERR)
#line 3039
			status = lstatus;
#line 3039
	}
#line 3039

#line 3039
	*xpp = (const void *)xp;
#line 3039
	return status;
#line 3039
#  endif
#line 3039
}
#line 3039


#if X_SIZEOF_FLOAT == SIZEOF_FLOAT && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_FLOAT);
# else
	swapn4b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_FLOAT);
	return NC_NOERR;
}
#elif vax
int
ncx_putn_float_float(void **xpp, size_t nfloats, const float *ip)
{
	const float *const end = ip + nfloats;

	while(ip < end)
	{
		const struct vax_single *const vsp =
#line 3062
			 (const struct vax_single *)ip;
#line 3062
		struct ieee_single *const isp = (struct ieee_single *) (*xpp);
#line 3062

#line 3062
		switch(vsp->exp){
#line 3062
		case 0 :
#line 3062
			/* all vax float with zero exponent map to zero */
#line 3062
			*isp = min.ieee;
#line 3062
			break;
#line 3062
		case 2 :
#line 3062
		case 1 :
#line 3062
		{
#line 3062
			/* These will map to subnormals */
#line 3062
			unsigned mantissa = (vsp->mantissa1 << 16)
#line 3062
					 | vsp->mantissa2;
#line 3062
			mantissa >>= 3 - vsp->exp;
#line 3062
			mantissa += (1 << (20 + vsp->exp));
#line 3062
			isp->mant_lo_lo = mantissa;
#line 3062
			isp->mant_lo_hi = mantissa >> 8;
#line 3062
			isp->mant_hi = mantissa >> 16;
#line 3062
			isp->exp_lo = 0;
#line 3062
			isp->exp_hi = 0;
#line 3062
		}
#line 3062
			break;
#line 3062
		case 0xff : /* max.s.exp */
#line 3062
			if( vsp->mantissa2 == max.s.mantissa2
#line 3062
				&& vsp->mantissa1 == max.s.mantissa1)
#line 3062
			{
#line 3062
				/* map largest vax float to ieee infinity */
#line 3062
				*isp = max.ieee;
#line 3062
				break;
#line 3062
			} /* else, fall thru */
#line 3062
		default :
#line 3062
		{
#line 3062
			unsigned exp = vsp->exp - VAX_SNG_BIAS + IEEE_SNG_BIAS;
#line 3062
			isp->exp_hi = exp >> 1;
#line 3062
			isp->exp_lo = exp;
#line 3062
			isp->mant_lo_lo = vsp->mantissa2;
#line 3062
			isp->mant_lo_hi = vsp->mantissa2 >> 8;
#line 3062
			isp->mant_hi = vsp->mantissa1;
#line 3062
		}
#line 3062
		}
#line 3062

#line 3062
		isp->sign = vsp->sign;
#line 3062


		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_FLOAT;
	}
	return NC_NOERR;
}
#else
int
ncx_putn_float_float(void **xpp, size_t nelems, const float *tp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
	{
		int lstatus = ncx_put_float_float(xp, tp);
		if(lstatus != NC_NOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3087
ncx_putn_float_schar(void **xpp, size_t nelems, const schar *tp)
#line 3087
{
#line 3087
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3087

#line 3087
 /* basic algorithm is:
#line 3087
  *   - ensure sane alignment of output data
#line 3087
  *   - copy (conversion happens automatically) input data
#line 3087
  *     to output
#line 3087
  *   - update tp to point at next unconverted input, and xpp to point
#line 3087
  *     at next location for converted output
#line 3087
  */
#line 3087
  long i, j, ni;
#line 3087
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3087
  float *xp;
#line 3087
  int nrange = 0;         /* number of range errors */
#line 3087
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3087
  long cxp = (long) *((char**)xpp);
#line 3087

#line 3087
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3087
  /* sjl: manually stripmine so we can limit amount of
#line 3087
   * vector work space reserved to LOOPCNT elements. Also
#line 3087
   * makes vectorisation easy */
#line 3087
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3087
    ni=Min(nelems-j,LOOPCNT);
#line 3087
    if (realign) {
#line 3087
      xp = tmp;
#line 3087
    } else {
#line 3087
      xp = (float *) *xpp;
#line 3087
    }
#line 3087
   /* copy the next block */
#line 3087
#pragma cdir loopcnt=LOOPCNT
#line 3087
#pragma cdir shortloop
#line 3087
    for (i=0; i<ni; i++) {
#line 3087
      /* the normal case: */
#line 3087
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3087
     /* test for range errors (not always needed but do it anyway) */
#line 3087
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3087
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3087
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3087
    }
#line 3087
   /* copy workspace back if necessary */
#line 3087
    if (realign) {
#line 3087
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3087
      xp = (float *) *xpp;
#line 3087
    }
#line 3087
   /* update xpp and tp */
#line 3087
    xp += ni;
#line 3087
    tp += ni;
#line 3087
    *xpp = (void*)xp;
#line 3087
  }
#line 3087
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3087

#line 3087
#else   /* not SX */
#line 3087

#line 3087
	char *xp = (char *) *xpp;
#line 3087
	int status = NC_NOERR;
#line 3087

#line 3087
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3087
	{
#line 3087
		int lstatus = ncx_put_float_schar(xp, tp);
#line 3087
		if(lstatus != NC_NOERR)
#line 3087
			status = lstatus;
#line 3087
	}
#line 3087

#line 3087
	*xpp = (void *)xp;
#line 3087
	return status;
#line 3087
#endif
#line 3087
}
#line 3087

int
#line 3088
ncx_putn_float_short(void **xpp, size_t nelems, const short *tp)
#line 3088
{
#line 3088
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3088

#line 3088
 /* basic algorithm is:
#line 3088
  *   - ensure sane alignment of output data
#line 3088
  *   - copy (conversion happens automatically) input data
#line 3088
  *     to output
#line 3088
  *   - update tp to point at next unconverted input, and xpp to point
#line 3088
  *     at next location for converted output
#line 3088
  */
#line 3088
  long i, j, ni;
#line 3088
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3088
  float *xp;
#line 3088
  int nrange = 0;         /* number of range errors */
#line 3088
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3088
  long cxp = (long) *((char**)xpp);
#line 3088

#line 3088
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3088
  /* sjl: manually stripmine so we can limit amount of
#line 3088
   * vector work space reserved to LOOPCNT elements. Also
#line 3088
   * makes vectorisation easy */
#line 3088
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3088
    ni=Min(nelems-j,LOOPCNT);
#line 3088
    if (realign) {
#line 3088
      xp = tmp;
#line 3088
    } else {
#line 3088
      xp = (float *) *xpp;
#line 3088
    }
#line 3088
   /* copy the next block */
#line 3088
#pragma cdir loopcnt=LOOPCNT
#line 3088
#pragma cdir shortloop
#line 3088
    for (i=0; i<ni; i++) {
#line 3088
      /* the normal case: */
#line 3088
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3088
     /* test for range errors (not always needed but do it anyway) */
#line 3088
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3088
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3088
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3088
    }
#line 3088
   /* copy workspace back if necessary */
#line 3088
    if (realign) {
#line 3088
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3088
      xp = (float *) *xpp;
#line 3088
    }
#line 3088
   /* update xpp and tp */
#line 3088
    xp += ni;
#line 3088
    tp += ni;
#line 3088
    *xpp = (void*)xp;
#line 3088
  }
#line 3088
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3088

#line 3088
#else   /* not SX */
#line 3088

#line 3088
	char *xp = (char *) *xpp;
#line 3088
	int status = NC_NOERR;
#line 3088

#line 3088
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3088
	{
#line 3088
		int lstatus = ncx_put_float_short(xp, tp);
#line 3088
		if(lstatus != NC_NOERR)
#line 3088
			status = lstatus;
#line 3088
	}
#line 3088

#line 3088
	*xpp = (void *)xp;
#line 3088
	return status;
#line 3088
#endif
#line 3088
}
#line 3088

int
#line 3089
ncx_putn_float_int(void **xpp, size_t nelems, const int *tp)
#line 3089
{
#line 3089
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3089

#line 3089
 /* basic algorithm is:
#line 3089
  *   - ensure sane alignment of output data
#line 3089
  *   - copy (conversion happens automatically) input data
#line 3089
  *     to output
#line 3089
  *   - update tp to point at next unconverted input, and xpp to point
#line 3089
  *     at next location for converted output
#line 3089
  */
#line 3089
  long i, j, ni;
#line 3089
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3089
  float *xp;
#line 3089
  int nrange = 0;         /* number of range errors */
#line 3089
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3089
  long cxp = (long) *((char**)xpp);
#line 3089

#line 3089
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3089
  /* sjl: manually stripmine so we can limit amount of
#line 3089
   * vector work space reserved to LOOPCNT elements. Also
#line 3089
   * makes vectorisation easy */
#line 3089
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3089
    ni=Min(nelems-j,LOOPCNT);
#line 3089
    if (realign) {
#line 3089
      xp = tmp;
#line 3089
    } else {
#line 3089
      xp = (float *) *xpp;
#line 3089
    }
#line 3089
   /* copy the next block */
#line 3089
#pragma cdir loopcnt=LOOPCNT
#line 3089
#pragma cdir shortloop
#line 3089
    for (i=0; i<ni; i++) {
#line 3089
      /* the normal case: */
#line 3089
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3089
     /* test for range errors (not always needed but do it anyway) */
#line 3089
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3089
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3089
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3089
    }
#line 3089
   /* copy workspace back if necessary */
#line 3089
    if (realign) {
#line 3089
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3089
      xp = (float *) *xpp;
#line 3089
    }
#line 3089
   /* update xpp and tp */
#line 3089
    xp += ni;
#line 3089
    tp += ni;
#line 3089
    *xpp = (void*)xp;
#line 3089
  }
#line 3089
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3089

#line 3089
#else   /* not SX */
#line 3089

#line 3089
	char *xp = (char *) *xpp;
#line 3089
	int status = NC_NOERR;
#line 3089

#line 3089
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3089
	{
#line 3089
		int lstatus = ncx_put_float_int(xp, tp);
#line 3089
		if(lstatus != NC_NOERR)
#line 3089
			status = lstatus;
#line 3089
	}
#line 3089

#line 3089
	*xpp = (void *)xp;
#line 3089
	return status;
#line 3089
#endif
#line 3089
}
#line 3089

int
#line 3090
ncx_putn_float_double(void **xpp, size_t nelems, const double *tp)
#line 3090
{
#line 3090
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3090

#line 3090
 /* basic algorithm is:
#line 3090
  *   - ensure sane alignment of output data
#line 3090
  *   - copy (conversion happens automatically) input data
#line 3090
  *     to output
#line 3090
  *   - update tp to point at next unconverted input, and xpp to point
#line 3090
  *     at next location for converted output
#line 3090
  */
#line 3090
  long i, j, ni;
#line 3090
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3090
  float *xp;
#line 3090
  int nrange = 0;         /* number of range errors */
#line 3090
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3090
  long cxp = (long) *((char**)xpp);
#line 3090

#line 3090
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3090
  /* sjl: manually stripmine so we can limit amount of
#line 3090
   * vector work space reserved to LOOPCNT elements. Also
#line 3090
   * makes vectorisation easy */
#line 3090
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3090
    ni=Min(nelems-j,LOOPCNT);
#line 3090
    if (realign) {
#line 3090
      xp = tmp;
#line 3090
    } else {
#line 3090
      xp = (float *) *xpp;
#line 3090
    }
#line 3090
   /* copy the next block */
#line 3090
#pragma cdir loopcnt=LOOPCNT
#line 3090
#pragma cdir shortloop
#line 3090
    for (i=0; i<ni; i++) {
#line 3090
      /* the normal case: */
#line 3090
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3090
     /* test for range errors (not always needed but do it anyway) */
#line 3090
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3090
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3090
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3090
    }
#line 3090
   /* copy workspace back if necessary */
#line 3090
    if (realign) {
#line 3090
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3090
      xp = (float *) *xpp;
#line 3090
    }
#line 3090
   /* update xpp and tp */
#line 3090
    xp += ni;
#line 3090
    tp += ni;
#line 3090
    *xpp = (void*)xp;
#line 3090
  }
#line 3090
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3090

#line 3090
#else   /* not SX */
#line 3090

#line 3090
	char *xp = (char *) *xpp;
#line 3090
	int status = NC_NOERR;
#line 3090

#line 3090
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3090
	{
#line 3090
		int lstatus = ncx_put_float_double(xp, tp);
#line 3090
		if(lstatus != NC_NOERR)
#line 3090
			status = lstatus;
#line 3090
	}
#line 3090

#line 3090
	*xpp = (void *)xp;
#line 3090
	return status;
#line 3090
#endif
#line 3090
}
#line 3090

int
#line 3091
ncx_putn_float_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 3091
{
#line 3091
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3091

#line 3091
 /* basic algorithm is:
#line 3091
  *   - ensure sane alignment of output data
#line 3091
  *   - copy (conversion happens automatically) input data
#line 3091
  *     to output
#line 3091
  *   - update tp to point at next unconverted input, and xpp to point
#line 3091
  *     at next location for converted output
#line 3091
  */
#line 3091
  long i, j, ni;
#line 3091
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3091
  float *xp;
#line 3091
  int nrange = 0;         /* number of range errors */
#line 3091
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3091
  long cxp = (long) *((char**)xpp);
#line 3091

#line 3091
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3091
  /* sjl: manually stripmine so we can limit amount of
#line 3091
   * vector work space reserved to LOOPCNT elements. Also
#line 3091
   * makes vectorisation easy */
#line 3091
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3091
    ni=Min(nelems-j,LOOPCNT);
#line 3091
    if (realign) {
#line 3091
      xp = tmp;
#line 3091
    } else {
#line 3091
      xp = (float *) *xpp;
#line 3091
    }
#line 3091
   /* copy the next block */
#line 3091
#pragma cdir loopcnt=LOOPCNT
#line 3091
#pragma cdir shortloop
#line 3091
    for (i=0; i<ni; i++) {
#line 3091
      /* the normal case: */
#line 3091
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3091
     /* test for range errors (not always needed but do it anyway) */
#line 3091
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3091
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3091
      nrange += tp[i] > X_FLOAT_MAX || tp[i] < X_FLOAT_MIN;
#line 3091
    }
#line 3091
   /* copy workspace back if necessary */
#line 3091
    if (realign) {
#line 3091
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3091
      xp = (float *) *xpp;
#line 3091
    }
#line 3091
   /* update xpp and tp */
#line 3091
    xp += ni;
#line 3091
    tp += ni;
#line 3091
    *xpp = (void*)xp;
#line 3091
  }
#line 3091
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3091

#line 3091
#else   /* not SX */
#line 3091

#line 3091
	char *xp = (char *) *xpp;
#line 3091
	int status = NC_NOERR;
#line 3091

#line 3091
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3091
	{
#line 3091
		int lstatus = ncx_put_float_longlong(xp, tp);
#line 3091
		if(lstatus != NC_NOERR)
#line 3091
			status = lstatus;
#line 3091
	}
#line 3091

#line 3091
	*xpp = (void *)xp;
#line 3091
	return status;
#line 3091
#endif
#line 3091
}
#line 3091

int
#line 3092
ncx_putn_float_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 3092
{
#line 3092
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3092

#line 3092
 /* basic algorithm is:
#line 3092
  *   - ensure sane alignment of output data
#line 3092
  *   - copy (conversion happens automatically) input data
#line 3092
  *     to output
#line 3092
  *   - update tp to point at next unconverted input, and xpp to point
#line 3092
  *     at next location for converted output
#line 3092
  */
#line 3092
  long i, j, ni;
#line 3092
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3092
  float *xp;
#line 3092
  int nrange = 0;         /* number of range errors */
#line 3092
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3092
  long cxp = (long) *((char**)xpp);
#line 3092

#line 3092
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3092
  /* sjl: manually stripmine so we can limit amount of
#line 3092
   * vector work space reserved to LOOPCNT elements. Also
#line 3092
   * makes vectorisation easy */
#line 3092
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3092
    ni=Min(nelems-j,LOOPCNT);
#line 3092
    if (realign) {
#line 3092
      xp = tmp;
#line 3092
    } else {
#line 3092
      xp = (float *) *xpp;
#line 3092
    }
#line 3092
   /* copy the next block */
#line 3092
#pragma cdir loopcnt=LOOPCNT
#line 3092
#pragma cdir shortloop
#line 3092
    for (i=0; i<ni; i++) {
#line 3092
      /* the normal case: */
#line 3092
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3092
     /* test for range errors (not always needed but do it anyway) */
#line 3092
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3092
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3092
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3092
    }
#line 3092
   /* copy workspace back if necessary */
#line 3092
    if (realign) {
#line 3092
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3092
      xp = (float *) *xpp;
#line 3092
    }
#line 3092
   /* update xpp and tp */
#line 3092
    xp += ni;
#line 3092
    tp += ni;
#line 3092
    *xpp = (void*)xp;
#line 3092
  }
#line 3092
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3092

#line 3092
#else   /* not SX */
#line 3092

#line 3092
	char *xp = (char *) *xpp;
#line 3092
	int status = NC_NOERR;
#line 3092

#line 3092
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3092
	{
#line 3092
		int lstatus = ncx_put_float_uchar(xp, tp);
#line 3092
		if(lstatus != NC_NOERR)
#line 3092
			status = lstatus;
#line 3092
	}
#line 3092

#line 3092
	*xpp = (void *)xp;
#line 3092
	return status;
#line 3092
#endif
#line 3092
}
#line 3092

int
#line 3093
ncx_putn_float_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 3093
{
#line 3093
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3093

#line 3093
 /* basic algorithm is:
#line 3093
  *   - ensure sane alignment of output data
#line 3093
  *   - copy (conversion happens automatically) input data
#line 3093
  *     to output
#line 3093
  *   - update tp to point at next unconverted input, and xpp to point
#line 3093
  *     at next location for converted output
#line 3093
  */
#line 3093
  long i, j, ni;
#line 3093
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3093
  float *xp;
#line 3093
  int nrange = 0;         /* number of range errors */
#line 3093
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3093
  long cxp = (long) *((char**)xpp);
#line 3093

#line 3093
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3093
  /* sjl: manually stripmine so we can limit amount of
#line 3093
   * vector work space reserved to LOOPCNT elements. Also
#line 3093
   * makes vectorisation easy */
#line 3093
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3093
    ni=Min(nelems-j,LOOPCNT);
#line 3093
    if (realign) {
#line 3093
      xp = tmp;
#line 3093
    } else {
#line 3093
      xp = (float *) *xpp;
#line 3093
    }
#line 3093
   /* copy the next block */
#line 3093
#pragma cdir loopcnt=LOOPCNT
#line 3093
#pragma cdir shortloop
#line 3093
    for (i=0; i<ni; i++) {
#line 3093
      /* the normal case: */
#line 3093
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3093
     /* test for range errors (not always needed but do it anyway) */
#line 3093
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3093
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3093
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3093
    }
#line 3093
   /* copy workspace back if necessary */
#line 3093
    if (realign) {
#line 3093
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3093
      xp = (float *) *xpp;
#line 3093
    }
#line 3093
   /* update xpp and tp */
#line 3093
    xp += ni;
#line 3093
    tp += ni;
#line 3093
    *xpp = (void*)xp;
#line 3093
  }
#line 3093
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3093

#line 3093
#else   /* not SX */
#line 3093

#line 3093
	char *xp = (char *) *xpp;
#line 3093
	int status = NC_NOERR;
#line 3093

#line 3093
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3093
	{
#line 3093
		int lstatus = ncx_put_float_ushort(xp, tp);
#line 3093
		if(lstatus != NC_NOERR)
#line 3093
			status = lstatus;
#line 3093
	}
#line 3093

#line 3093
	*xpp = (void *)xp;
#line 3093
	return status;
#line 3093
#endif
#line 3093
}
#line 3093

int
#line 3094
ncx_putn_float_uint(void **xpp, size_t nelems, const uint *tp)
#line 3094
{
#line 3094
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3094

#line 3094
 /* basic algorithm is:
#line 3094
  *   - ensure sane alignment of output data
#line 3094
  *   - copy (conversion happens automatically) input data
#line 3094
  *     to output
#line 3094
  *   - update tp to point at next unconverted input, and xpp to point
#line 3094
  *     at next location for converted output
#line 3094
  */
#line 3094
  long i, j, ni;
#line 3094
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3094
  float *xp;
#line 3094
  int nrange = 0;         /* number of range errors */
#line 3094
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3094
  long cxp = (long) *((char**)xpp);
#line 3094

#line 3094
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3094
  /* sjl: manually stripmine so we can limit amount of
#line 3094
   * vector work space reserved to LOOPCNT elements. Also
#line 3094
   * makes vectorisation easy */
#line 3094
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3094
    ni=Min(nelems-j,LOOPCNT);
#line 3094
    if (realign) {
#line 3094
      xp = tmp;
#line 3094
    } else {
#line 3094
      xp = (float *) *xpp;
#line 3094
    }
#line 3094
   /* copy the next block */
#line 3094
#pragma cdir loopcnt=LOOPCNT
#line 3094
#pragma cdir shortloop
#line 3094
    for (i=0; i<ni; i++) {
#line 3094
      /* the normal case: */
#line 3094
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3094
     /* test for range errors (not always needed but do it anyway) */
#line 3094
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3094
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3094
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3094
    }
#line 3094
   /* copy workspace back if necessary */
#line 3094
    if (realign) {
#line 3094
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3094
      xp = (float *) *xpp;
#line 3094
    }
#line 3094
   /* update xpp and tp */
#line 3094
    xp += ni;
#line 3094
    tp += ni;
#line 3094
    *xpp = (void*)xp;
#line 3094
  }
#line 3094
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3094

#line 3094
#else   /* not SX */
#line 3094

#line 3094
	char *xp = (char *) *xpp;
#line 3094
	int status = NC_NOERR;
#line 3094

#line 3094
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3094
	{
#line 3094
		int lstatus = ncx_put_float_uint(xp, tp);
#line 3094
		if(lstatus != NC_NOERR)
#line 3094
			status = lstatus;
#line 3094
	}
#line 3094

#line 3094
	*xpp = (void *)xp;
#line 3094
	return status;
#line 3094
#endif
#line 3094
}
#line 3094

int
#line 3095
ncx_putn_float_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 3095
{
#line 3095
#if _SX && X_SIZEOF_FLOAT == SIZEOF_FLOAT
#line 3095

#line 3095
 /* basic algorithm is:
#line 3095
  *   - ensure sane alignment of output data
#line 3095
  *   - copy (conversion happens automatically) input data
#line 3095
  *     to output
#line 3095
  *   - update tp to point at next unconverted input, and xpp to point
#line 3095
  *     at next location for converted output
#line 3095
  */
#line 3095
  long i, j, ni;
#line 3095
  float tmp[LOOPCNT];        /* in case input is misaligned */
#line 3095
  float *xp;
#line 3095
  int nrange = 0;         /* number of range errors */
#line 3095
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3095
  long cxp = (long) *((char**)xpp);
#line 3095

#line 3095
  realign = (cxp & 7) % SIZEOF_FLOAT;
#line 3095
  /* sjl: manually stripmine so we can limit amount of
#line 3095
   * vector work space reserved to LOOPCNT elements. Also
#line 3095
   * makes vectorisation easy */
#line 3095
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3095
    ni=Min(nelems-j,LOOPCNT);
#line 3095
    if (realign) {
#line 3095
      xp = tmp;
#line 3095
    } else {
#line 3095
      xp = (float *) *xpp;
#line 3095
    }
#line 3095
   /* copy the next block */
#line 3095
#pragma cdir loopcnt=LOOPCNT
#line 3095
#pragma cdir shortloop
#line 3095
    for (i=0; i<ni; i++) {
#line 3095
      /* the normal case: */
#line 3095
      xp[i] = (float) Max( X_FLOAT_MIN, Min(X_FLOAT_MAX, (float) tp[i]));
#line 3095
     /* test for range errors (not always needed but do it anyway) */
#line 3095
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3095
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3095
      nrange += tp[i] > X_FLOAT_MAX ;
#line 3095
    }
#line 3095
   /* copy workspace back if necessary */
#line 3095
    if (realign) {
#line 3095
      memcpy(*xpp, tmp, ni*X_SIZEOF_FLOAT);
#line 3095
      xp = (float *) *xpp;
#line 3095
    }
#line 3095
   /* update xpp and tp */
#line 3095
    xp += ni;
#line 3095
    tp += ni;
#line 3095
    *xpp = (void*)xp;
#line 3095
  }
#line 3095
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3095

#line 3095
#else   /* not SX */
#line 3095

#line 3095
	char *xp = (char *) *xpp;
#line 3095
	int status = NC_NOERR;
#line 3095

#line 3095
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_FLOAT, tp++)
#line 3095
	{
#line 3095
		int lstatus = ncx_put_float_ulonglong(xp, tp);
#line 3095
		if(lstatus != NC_NOERR)
#line 3095
			status = lstatus;
#line 3095
	}
#line 3095

#line 3095
	*xpp = (void *)xp;
#line 3095
	return status;
#line 3095
#endif
#line 3095
}
#line 3095


/* double --------------------------------------------------------------------*/

#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(double));
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif vax
int
ncx_getn_double_double(const void **xpp, size_t ndoubles, double *ip)
{
	double *const end = ip + ndoubles;

	while(ip < end)
	{
	struct vax_double *const vdp =
#line 3120
			 (struct vax_double *)ip;
#line 3120
	const struct ieee_double *const idp =
#line 3120
			 (const struct ieee_double *) (*xpp);
#line 3120
	{
#line 3120
		const struct dbl_limits *lim;
#line 3120
		int ii;
#line 3120
		for (ii = 0, lim = dbl_limits;
#line 3120
			ii < sizeof(dbl_limits)/sizeof(struct dbl_limits);
#line 3120
			ii++, lim++)
#line 3120
		{
#line 3120
			if ((idp->mant_lo == lim->ieee.mant_lo)
#line 3120
				&& (idp->mant_4 == lim->ieee.mant_4)
#line 3120
				&& (idp->mant_5 == lim->ieee.mant_5)
#line 3120
				&& (idp->mant_6 == lim->ieee.mant_6)
#line 3120
				&& (idp->exp_lo == lim->ieee.exp_lo)
#line 3120
				&& (idp->exp_hi == lim->ieee.exp_hi)
#line 3120
				)
#line 3120
			{
#line 3120
				*vdp = lim->d;
#line 3120
				goto doneit;
#line 3120
			}
#line 3120
		}
#line 3120
	}
#line 3120
	{
#line 3120
		unsigned exp = idp->exp_hi << 4 | idp->exp_lo;
#line 3120
		vdp->exp = exp - IEEE_DBL_BIAS + VAX_DBL_BIAS;
#line 3120
	}
#line 3120
	{
#line 3120
		unsigned mant_hi = ((idp->mant_6 << 16)
#line 3120
				 | (idp->mant_5 << 8)
#line 3120
				 | idp->mant_4);
#line 3120
		unsigned mant_lo = SWAP4(idp->mant_lo);
#line 3120
		vdp->mantissa1 = (mant_hi >> 13);
#line 3120
		vdp->mantissa2 = ((mant_hi & MASK(13)) << 3)
#line 3120
				| (mant_lo >> 29);
#line 3120
		vdp->mantissa3 = (mant_lo >> 13);
#line 3120
		vdp->mantissa4 = (mant_lo << 3);
#line 3120
	}
#line 3120
	doneit:
#line 3120
		vdp->sign = idp->sign;
#line 3120

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_getn_double_double(const void **xpp, size_t nelems, double *tp)
{
	const char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		const int lstatus = ncx_get_double_double(xp, tp);
		if(lstatus != NC_NOERR)
			status = lstatus;
	}

	*xpp = (const void *)xp;
	return status;
}
#endif
int
#line 3145
ncx_getn_double_schar(const void **xpp, size_t nelems, schar *tp)
#line 3145
{
#line 3145
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3145

#line 3145
 /* basic algorithm is:
#line 3145
  *   - ensure sane alignment of input data
#line 3145
  *   - copy (conversion happens automatically) input data
#line 3145
  *     to output
#line 3145
  *   - update xpp to point at next unconverted input, and tp to point
#line 3145
  *     at next location for converted output
#line 3145
  */
#line 3145
  long i, j, ni;
#line 3145
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3145
  double *xp;
#line 3145
  int nrange = 0;         /* number of range errors */
#line 3145
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3145
  long cxp = (long) *((char**)xpp);
#line 3145

#line 3145
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3145
  /* sjl: manually stripmine so we can limit amount of
#line 3145
   * vector work space reserved to LOOPCNT elements. Also
#line 3145
   * makes vectorisation easy */
#line 3145
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3145
    ni=Min(nelems-j,LOOPCNT);
#line 3145
    if (realign) {
#line 3145
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3145
      xp = tmp;
#line 3145
    } else {
#line 3145
      xp = (double *) *xpp;
#line 3145
    }
#line 3145
   /* copy the next block */
#line 3145
#pragma cdir loopcnt=LOOPCNT
#line 3145
#pragma cdir shortloop
#line 3145
    for (i=0; i<ni; i++) {
#line 3145
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3145
     /* test for range errors (not always needed but do it anyway) */
#line 3145
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3145
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3145
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3145
    }
#line 3145
   /* update xpp and tp */
#line 3145
    if (realign) xp = (double *) *xpp;
#line 3145
    xp += ni;
#line 3145
    tp += ni;
#line 3145
    *xpp = (void*)xp;
#line 3145
  }
#line 3145
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3145

#line 3145
#else   /* not SX */
#line 3145
	const char *xp = (const char *) *xpp;
#line 3145
	int status = NC_NOERR;
#line 3145

#line 3145
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3145
	{
#line 3145
		const int lstatus = ncx_get_double_schar(xp, tp);
#line 3145
		if(lstatus != NC_NOERR)
#line 3145
			status = lstatus;
#line 3145
	}
#line 3145

#line 3145
	*xpp = (const void *)xp;
#line 3145
	return status;
#line 3145
#  endif
#line 3145
}
#line 3145

int
#line 3146
ncx_getn_double_short(const void **xpp, size_t nelems, short *tp)
#line 3146
{
#line 3146
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3146

#line 3146
 /* basic algorithm is:
#line 3146
  *   - ensure sane alignment of input data
#line 3146
  *   - copy (conversion happens automatically) input data
#line 3146
  *     to output
#line 3146
  *   - update xpp to point at next unconverted input, and tp to point
#line 3146
  *     at next location for converted output
#line 3146
  */
#line 3146
  long i, j, ni;
#line 3146
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3146
  double *xp;
#line 3146
  int nrange = 0;         /* number of range errors */
#line 3146
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3146
  long cxp = (long) *((char**)xpp);
#line 3146

#line 3146
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3146
  /* sjl: manually stripmine so we can limit amount of
#line 3146
   * vector work space reserved to LOOPCNT elements. Also
#line 3146
   * makes vectorisation easy */
#line 3146
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3146
    ni=Min(nelems-j,LOOPCNT);
#line 3146
    if (realign) {
#line 3146
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3146
      xp = tmp;
#line 3146
    } else {
#line 3146
      xp = (double *) *xpp;
#line 3146
    }
#line 3146
   /* copy the next block */
#line 3146
#pragma cdir loopcnt=LOOPCNT
#line 3146
#pragma cdir shortloop
#line 3146
    for (i=0; i<ni; i++) {
#line 3146
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3146
     /* test for range errors (not always needed but do it anyway) */
#line 3146
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3146
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3146
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3146
    }
#line 3146
   /* update xpp and tp */
#line 3146
    if (realign) xp = (double *) *xpp;
#line 3146
    xp += ni;
#line 3146
    tp += ni;
#line 3146
    *xpp = (void*)xp;
#line 3146
  }
#line 3146
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3146

#line 3146
#else   /* not SX */
#line 3146
	const char *xp = (const char *) *xpp;
#line 3146
	int status = NC_NOERR;
#line 3146

#line 3146
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3146
	{
#line 3146
		const int lstatus = ncx_get_double_short(xp, tp);
#line 3146
		if(lstatus != NC_NOERR)
#line 3146
			status = lstatus;
#line 3146
	}
#line 3146

#line 3146
	*xpp = (const void *)xp;
#line 3146
	return status;
#line 3146
#  endif
#line 3146
}
#line 3146

int
#line 3147
ncx_getn_double_int(const void **xpp, size_t nelems, int *tp)
#line 3147
{
#line 3147
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3147

#line 3147
 /* basic algorithm is:
#line 3147
  *   - ensure sane alignment of input data
#line 3147
  *   - copy (conversion happens automatically) input data
#line 3147
  *     to output
#line 3147
  *   - update xpp to point at next unconverted input, and tp to point
#line 3147
  *     at next location for converted output
#line 3147
  */
#line 3147
  long i, j, ni;
#line 3147
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3147
  double *xp;
#line 3147
  int nrange = 0;         /* number of range errors */
#line 3147
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3147
  long cxp = (long) *((char**)xpp);
#line 3147

#line 3147
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3147
  /* sjl: manually stripmine so we can limit amount of
#line 3147
   * vector work space reserved to LOOPCNT elements. Also
#line 3147
   * makes vectorisation easy */
#line 3147
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3147
    ni=Min(nelems-j,LOOPCNT);
#line 3147
    if (realign) {
#line 3147
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3147
      xp = tmp;
#line 3147
    } else {
#line 3147
      xp = (double *) *xpp;
#line 3147
    }
#line 3147
   /* copy the next block */
#line 3147
#pragma cdir loopcnt=LOOPCNT
#line 3147
#pragma cdir shortloop
#line 3147
    for (i=0; i<ni; i++) {
#line 3147
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3147
     /* test for range errors (not always needed but do it anyway) */
#line 3147
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3147
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3147
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3147
    }
#line 3147
   /* update xpp and tp */
#line 3147
    if (realign) xp = (double *) *xpp;
#line 3147
    xp += ni;
#line 3147
    tp += ni;
#line 3147
    *xpp = (void*)xp;
#line 3147
  }
#line 3147
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3147

#line 3147
#else   /* not SX */
#line 3147
	const char *xp = (const char *) *xpp;
#line 3147
	int status = NC_NOERR;
#line 3147

#line 3147
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3147
	{
#line 3147
		const int lstatus = ncx_get_double_int(xp, tp);
#line 3147
		if(lstatus != NC_NOERR)
#line 3147
			status = lstatus;
#line 3147
	}
#line 3147

#line 3147
	*xpp = (const void *)xp;
#line 3147
	return status;
#line 3147
#  endif
#line 3147
}
#line 3147

int
#line 3148
ncx_getn_double_float(const void **xpp, size_t nelems, float *tp)
#line 3148
{
#line 3148
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3148

#line 3148
 /* basic algorithm is:
#line 3148
  *   - ensure sane alignment of input data
#line 3148
  *   - copy (conversion happens automatically) input data
#line 3148
  *     to output
#line 3148
  *   - update xpp to point at next unconverted input, and tp to point
#line 3148
  *     at next location for converted output
#line 3148
  */
#line 3148
  long i, j, ni;
#line 3148
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3148
  double *xp;
#line 3148
  int nrange = 0;         /* number of range errors */
#line 3148
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3148
  long cxp = (long) *((char**)xpp);
#line 3148

#line 3148
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3148
  /* sjl: manually stripmine so we can limit amount of
#line 3148
   * vector work space reserved to LOOPCNT elements. Also
#line 3148
   * makes vectorisation easy */
#line 3148
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3148
    ni=Min(nelems-j,LOOPCNT);
#line 3148
    if (realign) {
#line 3148
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3148
      xp = tmp;
#line 3148
    } else {
#line 3148
      xp = (double *) *xpp;
#line 3148
    }
#line 3148
   /* copy the next block */
#line 3148
#pragma cdir loopcnt=LOOPCNT
#line 3148
#pragma cdir shortloop
#line 3148
    for (i=0; i<ni; i++) {
#line 3148
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3148
     /* test for range errors (not always needed but do it anyway) */
#line 3148
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3148
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3148
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3148
    }
#line 3148
   /* update xpp and tp */
#line 3148
    if (realign) xp = (double *) *xpp;
#line 3148
    xp += ni;
#line 3148
    tp += ni;
#line 3148
    *xpp = (void*)xp;
#line 3148
  }
#line 3148
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3148

#line 3148
#else   /* not SX */
#line 3148
	const char *xp = (const char *) *xpp;
#line 3148
	int status = NC_NOERR;
#line 3148

#line 3148
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3148
	{
#line 3148
		const int lstatus = ncx_get_double_float(xp, tp);
#line 3148
		if(lstatus != NC_NOERR)
#line 3148
			status = lstatus;
#line 3148
	}
#line 3148

#line 3148
	*xpp = (const void *)xp;
#line 3148
	return status;
#line 3148
#  endif
#line 3148
}
#line 3148

int
#line 3149
ncx_getn_double_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3149
{
#line 3149
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3149

#line 3149
 /* basic algorithm is:
#line 3149
  *   - ensure sane alignment of input data
#line 3149
  *   - copy (conversion happens automatically) input data
#line 3149
  *     to output
#line 3149
  *   - update xpp to point at next unconverted input, and tp to point
#line 3149
  *     at next location for converted output
#line 3149
  */
#line 3149
  long i, j, ni;
#line 3149
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3149
  double *xp;
#line 3149
  int nrange = 0;         /* number of range errors */
#line 3149
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3149
  long cxp = (long) *((char**)xpp);
#line 3149

#line 3149
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3149
  /* sjl: manually stripmine so we can limit amount of
#line 3149
   * vector work space reserved to LOOPCNT elements. Also
#line 3149
   * makes vectorisation easy */
#line 3149
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3149
    ni=Min(nelems-j,LOOPCNT);
#line 3149
    if (realign) {
#line 3149
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3149
      xp = tmp;
#line 3149
    } else {
#line 3149
      xp = (double *) *xpp;
#line 3149
    }
#line 3149
   /* copy the next block */
#line 3149
#pragma cdir loopcnt=LOOPCNT
#line 3149
#pragma cdir shortloop
#line 3149
    for (i=0; i<ni; i++) {
#line 3149
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3149
     /* test for range errors (not always needed but do it anyway) */
#line 3149
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3149
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3149
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3149
    }
#line 3149
   /* update xpp and tp */
#line 3149
    if (realign) xp = (double *) *xpp;
#line 3149
    xp += ni;
#line 3149
    tp += ni;
#line 3149
    *xpp = (void*)xp;
#line 3149
  }
#line 3149
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3149

#line 3149
#else   /* not SX */
#line 3149
	const char *xp = (const char *) *xpp;
#line 3149
	int status = NC_NOERR;
#line 3149

#line 3149
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3149
	{
#line 3149
		const int lstatus = ncx_get_double_longlong(xp, tp);
#line 3149
		if(lstatus != NC_NOERR)
#line 3149
			status = lstatus;
#line 3149
	}
#line 3149

#line 3149
	*xpp = (const void *)xp;
#line 3149
	return status;
#line 3149
#  endif
#line 3149
}
#line 3149

int
#line 3150
ncx_getn_double_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3150
{
#line 3150
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3150

#line 3150
 /* basic algorithm is:
#line 3150
  *   - ensure sane alignment of input data
#line 3150
  *   - copy (conversion happens automatically) input data
#line 3150
  *     to output
#line 3150
  *   - update xpp to point at next unconverted input, and tp to point
#line 3150
  *     at next location for converted output
#line 3150
  */
#line 3150
  long i, j, ni;
#line 3150
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3150
  double *xp;
#line 3150
  int nrange = 0;         /* number of range errors */
#line 3150
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3150
  long cxp = (long) *((char**)xpp);
#line 3150

#line 3150
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3150
  /* sjl: manually stripmine so we can limit amount of
#line 3150
   * vector work space reserved to LOOPCNT elements. Also
#line 3150
   * makes vectorisation easy */
#line 3150
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3150
    ni=Min(nelems-j,LOOPCNT);
#line 3150
    if (realign) {
#line 3150
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3150
      xp = tmp;
#line 3150
    } else {
#line 3150
      xp = (double *) *xpp;
#line 3150
    }
#line 3150
   /* copy the next block */
#line 3150
#pragma cdir loopcnt=LOOPCNT
#line 3150
#pragma cdir shortloop
#line 3150
    for (i=0; i<ni; i++) {
#line 3150
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3150
     /* test for range errors (not always needed but do it anyway) */
#line 3150
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3150
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3150
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3150
    }
#line 3150
   /* update xpp and tp */
#line 3150
    if (realign) xp = (double *) *xpp;
#line 3150
    xp += ni;
#line 3150
    tp += ni;
#line 3150
    *xpp = (void*)xp;
#line 3150
  }
#line 3150
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3150

#line 3150
#else   /* not SX */
#line 3150
	const char *xp = (const char *) *xpp;
#line 3150
	int status = NC_NOERR;
#line 3150

#line 3150
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3150
	{
#line 3150
		const int lstatus = ncx_get_double_uchar(xp, tp);
#line 3150
		if(lstatus != NC_NOERR)
#line 3150
			status = lstatus;
#line 3150
	}
#line 3150

#line 3150
	*xpp = (const void *)xp;
#line 3150
	return status;
#line 3150
#  endif
#line 3150
}
#line 3150

int
#line 3151
ncx_getn_double_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3151
{
#line 3151
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3151

#line 3151
 /* basic algorithm is:
#line 3151
  *   - ensure sane alignment of input data
#line 3151
  *   - copy (conversion happens automatically) input data
#line 3151
  *     to output
#line 3151
  *   - update xpp to point at next unconverted input, and tp to point
#line 3151
  *     at next location for converted output
#line 3151
  */
#line 3151
  long i, j, ni;
#line 3151
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3151
  double *xp;
#line 3151
  int nrange = 0;         /* number of range errors */
#line 3151
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3151
  long cxp = (long) *((char**)xpp);
#line 3151

#line 3151
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3151
  /* sjl: manually stripmine so we can limit amount of
#line 3151
   * vector work space reserved to LOOPCNT elements. Also
#line 3151
   * makes vectorisation easy */
#line 3151
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3151
    ni=Min(nelems-j,LOOPCNT);
#line 3151
    if (realign) {
#line 3151
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3151
      xp = tmp;
#line 3151
    } else {
#line 3151
      xp = (double *) *xpp;
#line 3151
    }
#line 3151
   /* copy the next block */
#line 3151
#pragma cdir loopcnt=LOOPCNT
#line 3151
#pragma cdir shortloop
#line 3151
    for (i=0; i<ni; i++) {
#line 3151
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3151
     /* test for range errors (not always needed but do it anyway) */
#line 3151
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3151
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3151
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3151
    }
#line 3151
   /* update xpp and tp */
#line 3151
    if (realign) xp = (double *) *xpp;
#line 3151
    xp += ni;
#line 3151
    tp += ni;
#line 3151
    *xpp = (void*)xp;
#line 3151
  }
#line 3151
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3151

#line 3151
#else   /* not SX */
#line 3151
	const char *xp = (const char *) *xpp;
#line 3151
	int status = NC_NOERR;
#line 3151

#line 3151
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3151
	{
#line 3151
		const int lstatus = ncx_get_double_ushort(xp, tp);
#line 3151
		if(lstatus != NC_NOERR)
#line 3151
			status = lstatus;
#line 3151
	}
#line 3151

#line 3151
	*xpp = (const void *)xp;
#line 3151
	return status;
#line 3151
#  endif
#line 3151
}
#line 3151

int
#line 3152
ncx_getn_double_uint(const void **xpp, size_t nelems, uint *tp)
#line 3152
{
#line 3152
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3152

#line 3152
 /* basic algorithm is:
#line 3152
  *   - ensure sane alignment of input data
#line 3152
  *   - copy (conversion happens automatically) input data
#line 3152
  *     to output
#line 3152
  *   - update xpp to point at next unconverted input, and tp to point
#line 3152
  *     at next location for converted output
#line 3152
  */
#line 3152
  long i, j, ni;
#line 3152
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3152
  double *xp;
#line 3152
  int nrange = 0;         /* number of range errors */
#line 3152
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3152
  long cxp = (long) *((char**)xpp);
#line 3152

#line 3152
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3152
  /* sjl: manually stripmine so we can limit amount of
#line 3152
   * vector work space reserved to LOOPCNT elements. Also
#line 3152
   * makes vectorisation easy */
#line 3152
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3152
    ni=Min(nelems-j,LOOPCNT);
#line 3152
    if (realign) {
#line 3152
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3152
      xp = tmp;
#line 3152
    } else {
#line 3152
      xp = (double *) *xpp;
#line 3152
    }
#line 3152
   /* copy the next block */
#line 3152
#pragma cdir loopcnt=LOOPCNT
#line 3152
#pragma cdir shortloop
#line 3152
    for (i=0; i<ni; i++) {
#line 3152
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3152
     /* test for range errors (not always needed but do it anyway) */
#line 3152
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3152
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3152
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3152
    }
#line 3152
   /* update xpp and tp */
#line 3152
    if (realign) xp = (double *) *xpp;
#line 3152
    xp += ni;
#line 3152
    tp += ni;
#line 3152
    *xpp = (void*)xp;
#line 3152
  }
#line 3152
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3152

#line 3152
#else   /* not SX */
#line 3152
	const char *xp = (const char *) *xpp;
#line 3152
	int status = NC_NOERR;
#line 3152

#line 3152
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3152
	{
#line 3152
		const int lstatus = ncx_get_double_uint(xp, tp);
#line 3152
		if(lstatus != NC_NOERR)
#line 3152
			status = lstatus;
#line 3152
	}
#line 3152

#line 3152
	*xpp = (const void *)xp;
#line 3152
	return status;
#line 3152
#  endif
#line 3152
}
#line 3152

int
#line 3153
ncx_getn_double_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3153
{
#line 3153
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3153

#line 3153
 /* basic algorithm is:
#line 3153
  *   - ensure sane alignment of input data
#line 3153
  *   - copy (conversion happens automatically) input data
#line 3153
  *     to output
#line 3153
  *   - update xpp to point at next unconverted input, and tp to point
#line 3153
  *     at next location for converted output
#line 3153
  */
#line 3153
  long i, j, ni;
#line 3153
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3153
  double *xp;
#line 3153
  int nrange = 0;         /* number of range errors */
#line 3153
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3153
  long cxp = (long) *((char**)xpp);
#line 3153

#line 3153
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3153
  /* sjl: manually stripmine so we can limit amount of
#line 3153
   * vector work space reserved to LOOPCNT elements. Also
#line 3153
   * makes vectorisation easy */
#line 3153
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3153
    ni=Min(nelems-j,LOOPCNT);
#line 3153
    if (realign) {
#line 3153
      memcpy(tmp, *xpp, ni*SIZEOF_DOUBLE);
#line 3153
      xp = tmp;
#line 3153
    } else {
#line 3153
      xp = (double *) *xpp;
#line 3153
    }
#line 3153
   /* copy the next block */
#line 3153
#pragma cdir loopcnt=LOOPCNT
#line 3153
#pragma cdir shortloop
#line 3153
    for (i=0; i<ni; i++) {
#line 3153
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3153
     /* test for range errors (not always needed but do it anyway) */
#line 3153
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3153
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3153
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3153
    }
#line 3153
   /* update xpp and tp */
#line 3153
    if (realign) xp = (double *) *xpp;
#line 3153
    xp += ni;
#line 3153
    tp += ni;
#line 3153
    *xpp = (void*)xp;
#line 3153
  }
#line 3153
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3153

#line 3153
#else   /* not SX */
#line 3153
	const char *xp = (const char *) *xpp;
#line 3153
	int status = NC_NOERR;
#line 3153

#line 3153
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3153
	{
#line 3153
		const int lstatus = ncx_get_double_ulonglong(xp, tp);
#line 3153
		if(lstatus != NC_NOERR)
#line 3153
			status = lstatus;
#line 3153
	}
#line 3153

#line 3153
	*xpp = (const void *)xp;
#line 3153
	return status;
#line 3153
#  endif
#line 3153
}
#line 3153


#if X_SIZEOF_DOUBLE == SIZEOF_DOUBLE && !defined(NO_IEEE_FLOAT)
/* optimized version */
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_DOUBLE);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_DOUBLE);
	return NC_NOERR;
}
#elif vax
int
ncx_putn_double_double(void **xpp, size_t ndoubles, const double *ip)
{
	const double *const end = ip + ndoubles;

	while(ip < end)
	{
	const struct vax_double *const vdp =
#line 3176
			(const struct vax_double *)ip;
#line 3176
	struct ieee_double *const idp =
#line 3176
			 (struct ieee_double *) (*xpp);
#line 3176

#line 3176
	if ((vdp->mantissa4 > (dbl_limits[0].d.mantissa4 - 3)) &&
#line 3176
		(vdp->mantissa3 == dbl_limits[0].d.mantissa3) &&
#line 3176
		(vdp->mantissa2 == dbl_limits[0].d.mantissa2) &&
#line 3176
		(vdp->mantissa1 == dbl_limits[0].d.mantissa1) &&
#line 3176
		(vdp->exp == dbl_limits[0].d.exp))
#line 3176
	{
#line 3176
		*idp = dbl_limits[0].ieee;
#line 3176
		goto shipit;
#line 3176
	}
#line 3176
	if ((vdp->mantissa4 == dbl_limits[1].d.mantissa4) &&
#line 3176
		(vdp->mantissa3 == dbl_limits[1].d.mantissa3) &&
#line 3176
		(vdp->mantissa2 == dbl_limits[1].d.mantissa2) &&
#line 3176
		(vdp->mantissa1 == dbl_limits[1].d.mantissa1) &&
#line 3176
		(vdp->exp == dbl_limits[1].d.exp))
#line 3176
	{
#line 3176
		*idp = dbl_limits[1].ieee;
#line 3176
		goto shipit;
#line 3176
	}
#line 3176

#line 3176
	{
#line 3176
		unsigned exp = vdp->exp - VAX_DBL_BIAS + IEEE_DBL_BIAS;
#line 3176

#line 3176
		unsigned mant_lo = ((vdp->mantissa2 & MASK(3)) << 29) |
#line 3176
			(vdp->mantissa3 << 13) |
#line 3176
			((vdp->mantissa4 >> 3) & MASK(13));
#line 3176

#line 3176
		unsigned mant_hi = (vdp->mantissa1 << 13)
#line 3176
				 | (vdp->mantissa2 >> 3);
#line 3176

#line 3176
		if((vdp->mantissa4 & 7) > 4)
#line 3176
		{
#line 3176
			/* round up */
#line 3176
			mant_lo++;
#line 3176
			if(mant_lo == 0)
#line 3176
			{
#line 3176
				mant_hi++;
#line 3176
				if(mant_hi > 0xffffff)
#line 3176
				{
#line 3176
					mant_hi = 0;
#line 3176
					exp++;
#line 3176
				}
#line 3176
			}
#line 3176
		}
#line 3176

#line 3176
		idp->mant_lo = SWAP4(mant_lo);
#line 3176
		idp->mant_6 = mant_hi >> 16;
#line 3176
		idp->mant_5 = (mant_hi & 0xff00) >> 8;
#line 3176
		idp->mant_4 = mant_hi;
#line 3176
		idp->exp_hi = exp >> 4;
#line 3176
		idp->exp_lo = exp;
#line 3176
	}
#line 3176

#line 3176
	shipit:
#line 3176
		idp->sign = vdp->sign;
#line 3176

		ip++;
		*xpp = (char *)(*xpp) + X_SIZEOF_DOUBLE;
	}
	return NC_NOERR;
}
	/* vax */
#else
int
ncx_putn_double_double(void **xpp, size_t nelems, const double *tp)
{
	char *xp = *xpp;
	int status = NC_NOERR;

	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
	{
		int lstatus = ncx_put_double_double(xp, tp);
		if(lstatus != NC_NOERR)
			status = lstatus;
	}

	*xpp = (void *)xp;
	return status;
}
#endif
int
#line 3201
ncx_putn_double_schar(void **xpp, size_t nelems, const schar *tp)
#line 3201
{
#line 3201
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3201

#line 3201
 /* basic algorithm is:
#line 3201
  *   - ensure sane alignment of output data
#line 3201
  *   - copy (conversion happens automatically) input data
#line 3201
  *     to output
#line 3201
  *   - update tp to point at next unconverted input, and xpp to point
#line 3201
  *     at next location for converted output
#line 3201
  */
#line 3201
  long i, j, ni;
#line 3201
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3201
  double *xp;
#line 3201
  int nrange = 0;         /* number of range errors */
#line 3201
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3201
  long cxp = (long) *((char**)xpp);
#line 3201

#line 3201
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3201
  /* sjl: manually stripmine so we can limit amount of
#line 3201
   * vector work space reserved to LOOPCNT elements. Also
#line 3201
   * makes vectorisation easy */
#line 3201
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3201
    ni=Min(nelems-j,LOOPCNT);
#line 3201
    if (realign) {
#line 3201
      xp = tmp;
#line 3201
    } else {
#line 3201
      xp = (double *) *xpp;
#line 3201
    }
#line 3201
   /* copy the next block */
#line 3201
#pragma cdir loopcnt=LOOPCNT
#line 3201
#pragma cdir shortloop
#line 3201
    for (i=0; i<ni; i++) {
#line 3201
      /* the normal case: */
#line 3201
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3201
     /* test for range errors (not always needed but do it anyway) */
#line 3201
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3201
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3201
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3201
    }
#line 3201
   /* copy workspace back if necessary */
#line 3201
    if (realign) {
#line 3201
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3201
      xp = (double *) *xpp;
#line 3201
    }
#line 3201
   /* update xpp and tp */
#line 3201
    xp += ni;
#line 3201
    tp += ni;
#line 3201
    *xpp = (void*)xp;
#line 3201
  }
#line 3201
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3201

#line 3201
#else   /* not SX */
#line 3201

#line 3201
	char *xp = (char *) *xpp;
#line 3201
	int status = NC_NOERR;
#line 3201

#line 3201
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3201
	{
#line 3201
		int lstatus = ncx_put_double_schar(xp, tp);
#line 3201
		if(lstatus != NC_NOERR)
#line 3201
			status = lstatus;
#line 3201
	}
#line 3201

#line 3201
	*xpp = (void *)xp;
#line 3201
	return status;
#line 3201
#endif
#line 3201
}
#line 3201

int
#line 3202
ncx_putn_double_short(void **xpp, size_t nelems, const short *tp)
#line 3202
{
#line 3202
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3202

#line 3202
 /* basic algorithm is:
#line 3202
  *   - ensure sane alignment of output data
#line 3202
  *   - copy (conversion happens automatically) input data
#line 3202
  *     to output
#line 3202
  *   - update tp to point at next unconverted input, and xpp to point
#line 3202
  *     at next location for converted output
#line 3202
  */
#line 3202
  long i, j, ni;
#line 3202
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3202
  double *xp;
#line 3202
  int nrange = 0;         /* number of range errors */
#line 3202
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3202
  long cxp = (long) *((char**)xpp);
#line 3202

#line 3202
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3202
  /* sjl: manually stripmine so we can limit amount of
#line 3202
   * vector work space reserved to LOOPCNT elements. Also
#line 3202
   * makes vectorisation easy */
#line 3202
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3202
    ni=Min(nelems-j,LOOPCNT);
#line 3202
    if (realign) {
#line 3202
      xp = tmp;
#line 3202
    } else {
#line 3202
      xp = (double *) *xpp;
#line 3202
    }
#line 3202
   /* copy the next block */
#line 3202
#pragma cdir loopcnt=LOOPCNT
#line 3202
#pragma cdir shortloop
#line 3202
    for (i=0; i<ni; i++) {
#line 3202
      /* the normal case: */
#line 3202
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3202
     /* test for range errors (not always needed but do it anyway) */
#line 3202
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3202
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3202
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3202
    }
#line 3202
   /* copy workspace back if necessary */
#line 3202
    if (realign) {
#line 3202
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3202
      xp = (double *) *xpp;
#line 3202
    }
#line 3202
   /* update xpp and tp */
#line 3202
    xp += ni;
#line 3202
    tp += ni;
#line 3202
    *xpp = (void*)xp;
#line 3202
  }
#line 3202
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3202

#line 3202
#else   /* not SX */
#line 3202

#line 3202
	char *xp = (char *) *xpp;
#line 3202
	int status = NC_NOERR;
#line 3202

#line 3202
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3202
	{
#line 3202
		int lstatus = ncx_put_double_short(xp, tp);
#line 3202
		if(lstatus != NC_NOERR)
#line 3202
			status = lstatus;
#line 3202
	}
#line 3202

#line 3202
	*xpp = (void *)xp;
#line 3202
	return status;
#line 3202
#endif
#line 3202
}
#line 3202

int
#line 3203
ncx_putn_double_int(void **xpp, size_t nelems, const int *tp)
#line 3203
{
#line 3203
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3203

#line 3203
 /* basic algorithm is:
#line 3203
  *   - ensure sane alignment of output data
#line 3203
  *   - copy (conversion happens automatically) input data
#line 3203
  *     to output
#line 3203
  *   - update tp to point at next unconverted input, and xpp to point
#line 3203
  *     at next location for converted output
#line 3203
  */
#line 3203
  long i, j, ni;
#line 3203
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3203
  double *xp;
#line 3203
  int nrange = 0;         /* number of range errors */
#line 3203
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3203
  long cxp = (long) *((char**)xpp);
#line 3203

#line 3203
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3203
  /* sjl: manually stripmine so we can limit amount of
#line 3203
   * vector work space reserved to LOOPCNT elements. Also
#line 3203
   * makes vectorisation easy */
#line 3203
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3203
    ni=Min(nelems-j,LOOPCNT);
#line 3203
    if (realign) {
#line 3203
      xp = tmp;
#line 3203
    } else {
#line 3203
      xp = (double *) *xpp;
#line 3203
    }
#line 3203
   /* copy the next block */
#line 3203
#pragma cdir loopcnt=LOOPCNT
#line 3203
#pragma cdir shortloop
#line 3203
    for (i=0; i<ni; i++) {
#line 3203
      /* the normal case: */
#line 3203
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3203
     /* test for range errors (not always needed but do it anyway) */
#line 3203
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3203
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3203
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3203
    }
#line 3203
   /* copy workspace back if necessary */
#line 3203
    if (realign) {
#line 3203
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3203
      xp = (double *) *xpp;
#line 3203
    }
#line 3203
   /* update xpp and tp */
#line 3203
    xp += ni;
#line 3203
    tp += ni;
#line 3203
    *xpp = (void*)xp;
#line 3203
  }
#line 3203
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3203

#line 3203
#else   /* not SX */
#line 3203

#line 3203
	char *xp = (char *) *xpp;
#line 3203
	int status = NC_NOERR;
#line 3203

#line 3203
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3203
	{
#line 3203
		int lstatus = ncx_put_double_int(xp, tp);
#line 3203
		if(lstatus != NC_NOERR)
#line 3203
			status = lstatus;
#line 3203
	}
#line 3203

#line 3203
	*xpp = (void *)xp;
#line 3203
	return status;
#line 3203
#endif
#line 3203
}
#line 3203

int
#line 3204
ncx_putn_double_float(void **xpp, size_t nelems, const float *tp)
#line 3204
{
#line 3204
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3204

#line 3204
 /* basic algorithm is:
#line 3204
  *   - ensure sane alignment of output data
#line 3204
  *   - copy (conversion happens automatically) input data
#line 3204
  *     to output
#line 3204
  *   - update tp to point at next unconverted input, and xpp to point
#line 3204
  *     at next location for converted output
#line 3204
  */
#line 3204
  long i, j, ni;
#line 3204
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3204
  double *xp;
#line 3204
  int nrange = 0;         /* number of range errors */
#line 3204
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3204
  long cxp = (long) *((char**)xpp);
#line 3204

#line 3204
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3204
  /* sjl: manually stripmine so we can limit amount of
#line 3204
   * vector work space reserved to LOOPCNT elements. Also
#line 3204
   * makes vectorisation easy */
#line 3204
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3204
    ni=Min(nelems-j,LOOPCNT);
#line 3204
    if (realign) {
#line 3204
      xp = tmp;
#line 3204
    } else {
#line 3204
      xp = (double *) *xpp;
#line 3204
    }
#line 3204
   /* copy the next block */
#line 3204
#pragma cdir loopcnt=LOOPCNT
#line 3204
#pragma cdir shortloop
#line 3204
    for (i=0; i<ni; i++) {
#line 3204
      /* the normal case: */
#line 3204
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3204
     /* test for range errors (not always needed but do it anyway) */
#line 3204
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3204
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3204
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3204
    }
#line 3204
   /* copy workspace back if necessary */
#line 3204
    if (realign) {
#line 3204
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3204
      xp = (double *) *xpp;
#line 3204
    }
#line 3204
   /* update xpp and tp */
#line 3204
    xp += ni;
#line 3204
    tp += ni;
#line 3204
    *xpp = (void*)xp;
#line 3204
  }
#line 3204
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3204

#line 3204
#else   /* not SX */
#line 3204

#line 3204
	char *xp = (char *) *xpp;
#line 3204
	int status = NC_NOERR;
#line 3204

#line 3204
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3204
	{
#line 3204
		int lstatus = ncx_put_double_float(xp, tp);
#line 3204
		if(lstatus != NC_NOERR)
#line 3204
			status = lstatus;
#line 3204
	}
#line 3204

#line 3204
	*xpp = (void *)xp;
#line 3204
	return status;
#line 3204
#endif
#line 3204
}
#line 3204

int
#line 3205
ncx_putn_double_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 3205
{
#line 3205
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3205

#line 3205
 /* basic algorithm is:
#line 3205
  *   - ensure sane alignment of output data
#line 3205
  *   - copy (conversion happens automatically) input data
#line 3205
  *     to output
#line 3205
  *   - update tp to point at next unconverted input, and xpp to point
#line 3205
  *     at next location for converted output
#line 3205
  */
#line 3205
  long i, j, ni;
#line 3205
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3205
  double *xp;
#line 3205
  int nrange = 0;         /* number of range errors */
#line 3205
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3205
  long cxp = (long) *((char**)xpp);
#line 3205

#line 3205
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3205
  /* sjl: manually stripmine so we can limit amount of
#line 3205
   * vector work space reserved to LOOPCNT elements. Also
#line 3205
   * makes vectorisation easy */
#line 3205
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3205
    ni=Min(nelems-j,LOOPCNT);
#line 3205
    if (realign) {
#line 3205
      xp = tmp;
#line 3205
    } else {
#line 3205
      xp = (double *) *xpp;
#line 3205
    }
#line 3205
   /* copy the next block */
#line 3205
#pragma cdir loopcnt=LOOPCNT
#line 3205
#pragma cdir shortloop
#line 3205
    for (i=0; i<ni; i++) {
#line 3205
      /* the normal case: */
#line 3205
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3205
     /* test for range errors (not always needed but do it anyway) */
#line 3205
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3205
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3205
      nrange += tp[i] > X_DOUBLE_MAX || tp[i] < X_DOUBLE_MIN;
#line 3205
    }
#line 3205
   /* copy workspace back if necessary */
#line 3205
    if (realign) {
#line 3205
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3205
      xp = (double *) *xpp;
#line 3205
    }
#line 3205
   /* update xpp and tp */
#line 3205
    xp += ni;
#line 3205
    tp += ni;
#line 3205
    *xpp = (void*)xp;
#line 3205
  }
#line 3205
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3205

#line 3205
#else   /* not SX */
#line 3205

#line 3205
	char *xp = (char *) *xpp;
#line 3205
	int status = NC_NOERR;
#line 3205

#line 3205
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3205
	{
#line 3205
		int lstatus = ncx_put_double_longlong(xp, tp);
#line 3205
		if(lstatus != NC_NOERR)
#line 3205
			status = lstatus;
#line 3205
	}
#line 3205

#line 3205
	*xpp = (void *)xp;
#line 3205
	return status;
#line 3205
#endif
#line 3205
}
#line 3205

int
#line 3206
ncx_putn_double_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 3206
{
#line 3206
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3206

#line 3206
 /* basic algorithm is:
#line 3206
  *   - ensure sane alignment of output data
#line 3206
  *   - copy (conversion happens automatically) input data
#line 3206
  *     to output
#line 3206
  *   - update tp to point at next unconverted input, and xpp to point
#line 3206
  *     at next location for converted output
#line 3206
  */
#line 3206
  long i, j, ni;
#line 3206
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3206
  double *xp;
#line 3206
  int nrange = 0;         /* number of range errors */
#line 3206
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3206
  long cxp = (long) *((char**)xpp);
#line 3206

#line 3206
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3206
  /* sjl: manually stripmine so we can limit amount of
#line 3206
   * vector work space reserved to LOOPCNT elements. Also
#line 3206
   * makes vectorisation easy */
#line 3206
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3206
    ni=Min(nelems-j,LOOPCNT);
#line 3206
    if (realign) {
#line 3206
      xp = tmp;
#line 3206
    } else {
#line 3206
      xp = (double *) *xpp;
#line 3206
    }
#line 3206
   /* copy the next block */
#line 3206
#pragma cdir loopcnt=LOOPCNT
#line 3206
#pragma cdir shortloop
#line 3206
    for (i=0; i<ni; i++) {
#line 3206
      /* the normal case: */
#line 3206
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3206
     /* test for range errors (not always needed but do it anyway) */
#line 3206
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3206
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3206
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3206
    }
#line 3206
   /* copy workspace back if necessary */
#line 3206
    if (realign) {
#line 3206
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3206
      xp = (double *) *xpp;
#line 3206
    }
#line 3206
   /* update xpp and tp */
#line 3206
    xp += ni;
#line 3206
    tp += ni;
#line 3206
    *xpp = (void*)xp;
#line 3206
  }
#line 3206
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3206

#line 3206
#else   /* not SX */
#line 3206

#line 3206
	char *xp = (char *) *xpp;
#line 3206
	int status = NC_NOERR;
#line 3206

#line 3206
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3206
	{
#line 3206
		int lstatus = ncx_put_double_uchar(xp, tp);
#line 3206
		if(lstatus != NC_NOERR)
#line 3206
			status = lstatus;
#line 3206
	}
#line 3206

#line 3206
	*xpp = (void *)xp;
#line 3206
	return status;
#line 3206
#endif
#line 3206
}
#line 3206

int
#line 3207
ncx_putn_double_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 3207
{
#line 3207
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3207

#line 3207
 /* basic algorithm is:
#line 3207
  *   - ensure sane alignment of output data
#line 3207
  *   - copy (conversion happens automatically) input data
#line 3207
  *     to output
#line 3207
  *   - update tp to point at next unconverted input, and xpp to point
#line 3207
  *     at next location for converted output
#line 3207
  */
#line 3207
  long i, j, ni;
#line 3207
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3207
  double *xp;
#line 3207
  int nrange = 0;         /* number of range errors */
#line 3207
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3207
  long cxp = (long) *((char**)xpp);
#line 3207

#line 3207
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3207
  /* sjl: manually stripmine so we can limit amount of
#line 3207
   * vector work space reserved to LOOPCNT elements. Also
#line 3207
   * makes vectorisation easy */
#line 3207
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3207
    ni=Min(nelems-j,LOOPCNT);
#line 3207
    if (realign) {
#line 3207
      xp = tmp;
#line 3207
    } else {
#line 3207
      xp = (double *) *xpp;
#line 3207
    }
#line 3207
   /* copy the next block */
#line 3207
#pragma cdir loopcnt=LOOPCNT
#line 3207
#pragma cdir shortloop
#line 3207
    for (i=0; i<ni; i++) {
#line 3207
      /* the normal case: */
#line 3207
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3207
     /* test for range errors (not always needed but do it anyway) */
#line 3207
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3207
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3207
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3207
    }
#line 3207
   /* copy workspace back if necessary */
#line 3207
    if (realign) {
#line 3207
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3207
      xp = (double *) *xpp;
#line 3207
    }
#line 3207
   /* update xpp and tp */
#line 3207
    xp += ni;
#line 3207
    tp += ni;
#line 3207
    *xpp = (void*)xp;
#line 3207
  }
#line 3207
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3207

#line 3207
#else   /* not SX */
#line 3207

#line 3207
	char *xp = (char *) *xpp;
#line 3207
	int status = NC_NOERR;
#line 3207

#line 3207
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3207
	{
#line 3207
		int lstatus = ncx_put_double_ushort(xp, tp);
#line 3207
		if(lstatus != NC_NOERR)
#line 3207
			status = lstatus;
#line 3207
	}
#line 3207

#line 3207
	*xpp = (void *)xp;
#line 3207
	return status;
#line 3207
#endif
#line 3207
}
#line 3207

int
#line 3208
ncx_putn_double_uint(void **xpp, size_t nelems, const uint *tp)
#line 3208
{
#line 3208
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3208

#line 3208
 /* basic algorithm is:
#line 3208
  *   - ensure sane alignment of output data
#line 3208
  *   - copy (conversion happens automatically) input data
#line 3208
  *     to output
#line 3208
  *   - update tp to point at next unconverted input, and xpp to point
#line 3208
  *     at next location for converted output
#line 3208
  */
#line 3208
  long i, j, ni;
#line 3208
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3208
  double *xp;
#line 3208
  int nrange = 0;         /* number of range errors */
#line 3208
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3208
  long cxp = (long) *((char**)xpp);
#line 3208

#line 3208
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3208
  /* sjl: manually stripmine so we can limit amount of
#line 3208
   * vector work space reserved to LOOPCNT elements. Also
#line 3208
   * makes vectorisation easy */
#line 3208
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3208
    ni=Min(nelems-j,LOOPCNT);
#line 3208
    if (realign) {
#line 3208
      xp = tmp;
#line 3208
    } else {
#line 3208
      xp = (double *) *xpp;
#line 3208
    }
#line 3208
   /* copy the next block */
#line 3208
#pragma cdir loopcnt=LOOPCNT
#line 3208
#pragma cdir shortloop
#line 3208
    for (i=0; i<ni; i++) {
#line 3208
      /* the normal case: */
#line 3208
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3208
     /* test for range errors (not always needed but do it anyway) */
#line 3208
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3208
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3208
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3208
    }
#line 3208
   /* copy workspace back if necessary */
#line 3208
    if (realign) {
#line 3208
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3208
      xp = (double *) *xpp;
#line 3208
    }
#line 3208
   /* update xpp and tp */
#line 3208
    xp += ni;
#line 3208
    tp += ni;
#line 3208
    *xpp = (void*)xp;
#line 3208
  }
#line 3208
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3208

#line 3208
#else   /* not SX */
#line 3208

#line 3208
	char *xp = (char *) *xpp;
#line 3208
	int status = NC_NOERR;
#line 3208

#line 3208
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3208
	{
#line 3208
		int lstatus = ncx_put_double_uint(xp, tp);
#line 3208
		if(lstatus != NC_NOERR)
#line 3208
			status = lstatus;
#line 3208
	}
#line 3208

#line 3208
	*xpp = (void *)xp;
#line 3208
	return status;
#line 3208
#endif
#line 3208
}
#line 3208

int
#line 3209
ncx_putn_double_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 3209
{
#line 3209
#if _SX && X_SIZEOF_DOUBLE == SIZEOF_DOUBLE
#line 3209

#line 3209
 /* basic algorithm is:
#line 3209
  *   - ensure sane alignment of output data
#line 3209
  *   - copy (conversion happens automatically) input data
#line 3209
  *     to output
#line 3209
  *   - update tp to point at next unconverted input, and xpp to point
#line 3209
  *     at next location for converted output
#line 3209
  */
#line 3209
  long i, j, ni;
#line 3209
  double tmp[LOOPCNT];        /* in case input is misaligned */
#line 3209
  double *xp;
#line 3209
  int nrange = 0;         /* number of range errors */
#line 3209
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3209
  long cxp = (long) *((char**)xpp);
#line 3209

#line 3209
  realign = (cxp & 7) % SIZEOF_DOUBLE;
#line 3209
  /* sjl: manually stripmine so we can limit amount of
#line 3209
   * vector work space reserved to LOOPCNT elements. Also
#line 3209
   * makes vectorisation easy */
#line 3209
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3209
    ni=Min(nelems-j,LOOPCNT);
#line 3209
    if (realign) {
#line 3209
      xp = tmp;
#line 3209
    } else {
#line 3209
      xp = (double *) *xpp;
#line 3209
    }
#line 3209
   /* copy the next block */
#line 3209
#pragma cdir loopcnt=LOOPCNT
#line 3209
#pragma cdir shortloop
#line 3209
    for (i=0; i<ni; i++) {
#line 3209
      /* the normal case: */
#line 3209
      xp[i] = (double) Max( X_DOUBLE_MIN, Min(X_DOUBLE_MAX, (double) tp[i]));
#line 3209
     /* test for range errors (not always needed but do it anyway) */
#line 3209
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3209
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3209
      nrange += tp[i] > X_DOUBLE_MAX ;
#line 3209
    }
#line 3209
   /* copy workspace back if necessary */
#line 3209
    if (realign) {
#line 3209
      memcpy(*xpp, tmp, ni*X_SIZEOF_DOUBLE);
#line 3209
      xp = (double *) *xpp;
#line 3209
    }
#line 3209
   /* update xpp and tp */
#line 3209
    xp += ni;
#line 3209
    tp += ni;
#line 3209
    *xpp = (void*)xp;
#line 3209
  }
#line 3209
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3209

#line 3209
#else   /* not SX */
#line 3209

#line 3209
	char *xp = (char *) *xpp;
#line 3209
	int status = NC_NOERR;
#line 3209

#line 3209
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_DOUBLE, tp++)
#line 3209
	{
#line 3209
		int lstatus = ncx_put_double_ulonglong(xp, tp);
#line 3209
		if(lstatus != NC_NOERR)
#line 3209
			status = lstatus;
#line 3209
	}
#line 3209

#line 3209
	*xpp = (void *)xp;
#line 3209
	return status;
#line 3209
#endif
#line 3209
}
#line 3209



/* longlong -----------------------------------------------------------------------*/

#if X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
/* optimized version */
int
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(long long));
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_LONGLONG);
	return NC_NOERR;
}
#else
int
#line 3228
ncx_getn_longlong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3228
{
#line 3228
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3228

#line 3228
 /* basic algorithm is:
#line 3228
  *   - ensure sane alignment of input data
#line 3228
  *   - copy (conversion happens automatically) input data
#line 3228
  *     to output
#line 3228
  *   - update xpp to point at next unconverted input, and tp to point
#line 3228
  *     at next location for converted output
#line 3228
  */
#line 3228
  long i, j, ni;
#line 3228
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3228
  longlong *xp;
#line 3228
  int nrange = 0;         /* number of range errors */
#line 3228
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3228
  long cxp = (long) *((char**)xpp);
#line 3228

#line 3228
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3228
  /* sjl: manually stripmine so we can limit amount of
#line 3228
   * vector work space reserved to LOOPCNT elements. Also
#line 3228
   * makes vectorisation easy */
#line 3228
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3228
    ni=Min(nelems-j,LOOPCNT);
#line 3228
    if (realign) {
#line 3228
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3228
      xp = tmp;
#line 3228
    } else {
#line 3228
      xp = (longlong *) *xpp;
#line 3228
    }
#line 3228
   /* copy the next block */
#line 3228
#pragma cdir loopcnt=LOOPCNT
#line 3228
#pragma cdir shortloop
#line 3228
    for (i=0; i<ni; i++) {
#line 3228
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3228
     /* test for range errors (not always needed but do it anyway) */
#line 3228
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3228
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3228
      nrange += xp[i] > LONGLONG_MAX || xp[i] < LONGLONG_MIN;
#line 3228
    }
#line 3228
   /* update xpp and tp */
#line 3228
    if (realign) xp = (longlong *) *xpp;
#line 3228
    xp += ni;
#line 3228
    tp += ni;
#line 3228
    *xpp = (void*)xp;
#line 3228
  }
#line 3228
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3228

#line 3228
#else   /* not SX */
#line 3228
	const char *xp = (const char *) *xpp;
#line 3228
	int status = NC_NOERR;
#line 3228

#line 3228
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3228
	{
#line 3228
		const int lstatus = ncx_get_longlong_longlong(xp, tp);
#line 3228
		if(lstatus != NC_NOERR)
#line 3228
			status = lstatus;
#line 3228
	}
#line 3228

#line 3228
	*xpp = (const void *)xp;
#line 3228
	return status;
#line 3228
#  endif
#line 3228
}
#line 3228

#endif
int
#line 3230
ncx_getn_longlong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3230
{
#line 3230
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3230

#line 3230
 /* basic algorithm is:
#line 3230
  *   - ensure sane alignment of input data
#line 3230
  *   - copy (conversion happens automatically) input data
#line 3230
  *     to output
#line 3230
  *   - update xpp to point at next unconverted input, and tp to point
#line 3230
  *     at next location for converted output
#line 3230
  */
#line 3230
  long i, j, ni;
#line 3230
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3230
  longlong *xp;
#line 3230
  int nrange = 0;         /* number of range errors */
#line 3230
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3230
  long cxp = (long) *((char**)xpp);
#line 3230

#line 3230
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3230
  /* sjl: manually stripmine so we can limit amount of
#line 3230
   * vector work space reserved to LOOPCNT elements. Also
#line 3230
   * makes vectorisation easy */
#line 3230
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3230
    ni=Min(nelems-j,LOOPCNT);
#line 3230
    if (realign) {
#line 3230
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3230
      xp = tmp;
#line 3230
    } else {
#line 3230
      xp = (longlong *) *xpp;
#line 3230
    }
#line 3230
   /* copy the next block */
#line 3230
#pragma cdir loopcnt=LOOPCNT
#line 3230
#pragma cdir shortloop
#line 3230
    for (i=0; i<ni; i++) {
#line 3230
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3230
     /* test for range errors (not always needed but do it anyway) */
#line 3230
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3230
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3230
      nrange += xp[i] > SCHAR_MAX || xp[i] < SCHAR_MIN;
#line 3230
    }
#line 3230
   /* update xpp and tp */
#line 3230
    if (realign) xp = (longlong *) *xpp;
#line 3230
    xp += ni;
#line 3230
    tp += ni;
#line 3230
    *xpp = (void*)xp;
#line 3230
  }
#line 3230
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3230

#line 3230
#else   /* not SX */
#line 3230
	const char *xp = (const char *) *xpp;
#line 3230
	int status = NC_NOERR;
#line 3230

#line 3230
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3230
	{
#line 3230
		const int lstatus = ncx_get_longlong_schar(xp, tp);
#line 3230
		if(lstatus != NC_NOERR)
#line 3230
			status = lstatus;
#line 3230
	}
#line 3230

#line 3230
	*xpp = (const void *)xp;
#line 3230
	return status;
#line 3230
#  endif
#line 3230
}
#line 3230

int
#line 3231
ncx_getn_longlong_short(const void **xpp, size_t nelems, short *tp)
#line 3231
{
#line 3231
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3231

#line 3231
 /* basic algorithm is:
#line 3231
  *   - ensure sane alignment of input data
#line 3231
  *   - copy (conversion happens automatically) input data
#line 3231
  *     to output
#line 3231
  *   - update xpp to point at next unconverted input, and tp to point
#line 3231
  *     at next location for converted output
#line 3231
  */
#line 3231
  long i, j, ni;
#line 3231
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3231
  longlong *xp;
#line 3231
  int nrange = 0;         /* number of range errors */
#line 3231
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3231
  long cxp = (long) *((char**)xpp);
#line 3231

#line 3231
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3231
  /* sjl: manually stripmine so we can limit amount of
#line 3231
   * vector work space reserved to LOOPCNT elements. Also
#line 3231
   * makes vectorisation easy */
#line 3231
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3231
    ni=Min(nelems-j,LOOPCNT);
#line 3231
    if (realign) {
#line 3231
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3231
      xp = tmp;
#line 3231
    } else {
#line 3231
      xp = (longlong *) *xpp;
#line 3231
    }
#line 3231
   /* copy the next block */
#line 3231
#pragma cdir loopcnt=LOOPCNT
#line 3231
#pragma cdir shortloop
#line 3231
    for (i=0; i<ni; i++) {
#line 3231
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3231
     /* test for range errors (not always needed but do it anyway) */
#line 3231
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3231
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3231
      nrange += xp[i] > SHORT_MAX || xp[i] < SHORT_MIN;
#line 3231
    }
#line 3231
   /* update xpp and tp */
#line 3231
    if (realign) xp = (longlong *) *xpp;
#line 3231
    xp += ni;
#line 3231
    tp += ni;
#line 3231
    *xpp = (void*)xp;
#line 3231
  }
#line 3231
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3231

#line 3231
#else   /* not SX */
#line 3231
	const char *xp = (const char *) *xpp;
#line 3231
	int status = NC_NOERR;
#line 3231

#line 3231
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3231
	{
#line 3231
		const int lstatus = ncx_get_longlong_short(xp, tp);
#line 3231
		if(lstatus != NC_NOERR)
#line 3231
			status = lstatus;
#line 3231
	}
#line 3231

#line 3231
	*xpp = (const void *)xp;
#line 3231
	return status;
#line 3231
#  endif
#line 3231
}
#line 3231

int
#line 3232
ncx_getn_longlong_int(const void **xpp, size_t nelems, int *tp)
#line 3232
{
#line 3232
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3232

#line 3232
 /* basic algorithm is:
#line 3232
  *   - ensure sane alignment of input data
#line 3232
  *   - copy (conversion happens automatically) input data
#line 3232
  *     to output
#line 3232
  *   - update xpp to point at next unconverted input, and tp to point
#line 3232
  *     at next location for converted output
#line 3232
  */
#line 3232
  long i, j, ni;
#line 3232
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3232
  longlong *xp;
#line 3232
  int nrange = 0;         /* number of range errors */
#line 3232
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3232
  long cxp = (long) *((char**)xpp);
#line 3232

#line 3232
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3232
  /* sjl: manually stripmine so we can limit amount of
#line 3232
   * vector work space reserved to LOOPCNT elements. Also
#line 3232
   * makes vectorisation easy */
#line 3232
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3232
    ni=Min(nelems-j,LOOPCNT);
#line 3232
    if (realign) {
#line 3232
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3232
      xp = tmp;
#line 3232
    } else {
#line 3232
      xp = (longlong *) *xpp;
#line 3232
    }
#line 3232
   /* copy the next block */
#line 3232
#pragma cdir loopcnt=LOOPCNT
#line 3232
#pragma cdir shortloop
#line 3232
    for (i=0; i<ni; i++) {
#line 3232
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3232
     /* test for range errors (not always needed but do it anyway) */
#line 3232
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3232
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3232
      nrange += xp[i] > INT_MAX || xp[i] < INT_MIN;
#line 3232
    }
#line 3232
   /* update xpp and tp */
#line 3232
    if (realign) xp = (longlong *) *xpp;
#line 3232
    xp += ni;
#line 3232
    tp += ni;
#line 3232
    *xpp = (void*)xp;
#line 3232
  }
#line 3232
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3232

#line 3232
#else   /* not SX */
#line 3232
	const char *xp = (const char *) *xpp;
#line 3232
	int status = NC_NOERR;
#line 3232

#line 3232
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3232
	{
#line 3232
		const int lstatus = ncx_get_longlong_int(xp, tp);
#line 3232
		if(lstatus != NC_NOERR)
#line 3232
			status = lstatus;
#line 3232
	}
#line 3232

#line 3232
	*xpp = (const void *)xp;
#line 3232
	return status;
#line 3232
#  endif
#line 3232
}
#line 3232

int
#line 3233
ncx_getn_longlong_float(const void **xpp, size_t nelems, float *tp)
#line 3233
{
#line 3233
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3233

#line 3233
 /* basic algorithm is:
#line 3233
  *   - ensure sane alignment of input data
#line 3233
  *   - copy (conversion happens automatically) input data
#line 3233
  *     to output
#line 3233
  *   - update xpp to point at next unconverted input, and tp to point
#line 3233
  *     at next location for converted output
#line 3233
  */
#line 3233
  long i, j, ni;
#line 3233
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3233
  longlong *xp;
#line 3233
  int nrange = 0;         /* number of range errors */
#line 3233
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3233
  long cxp = (long) *((char**)xpp);
#line 3233

#line 3233
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3233
  /* sjl: manually stripmine so we can limit amount of
#line 3233
   * vector work space reserved to LOOPCNT elements. Also
#line 3233
   * makes vectorisation easy */
#line 3233
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3233
    ni=Min(nelems-j,LOOPCNT);
#line 3233
    if (realign) {
#line 3233
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3233
      xp = tmp;
#line 3233
    } else {
#line 3233
      xp = (longlong *) *xpp;
#line 3233
    }
#line 3233
   /* copy the next block */
#line 3233
#pragma cdir loopcnt=LOOPCNT
#line 3233
#pragma cdir shortloop
#line 3233
    for (i=0; i<ni; i++) {
#line 3233
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3233
     /* test for range errors (not always needed but do it anyway) */
#line 3233
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3233
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3233
      nrange += xp[i] > FLOAT_MAX || xp[i] < FLOAT_MIN;
#line 3233
    }
#line 3233
   /* update xpp and tp */
#line 3233
    if (realign) xp = (longlong *) *xpp;
#line 3233
    xp += ni;
#line 3233
    tp += ni;
#line 3233
    *xpp = (void*)xp;
#line 3233
  }
#line 3233
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3233

#line 3233
#else   /* not SX */
#line 3233
	const char *xp = (const char *) *xpp;
#line 3233
	int status = NC_NOERR;
#line 3233

#line 3233
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3233
	{
#line 3233
		const int lstatus = ncx_get_longlong_float(xp, tp);
#line 3233
		if(lstatus != NC_NOERR)
#line 3233
			status = lstatus;
#line 3233
	}
#line 3233

#line 3233
	*xpp = (const void *)xp;
#line 3233
	return status;
#line 3233
#  endif
#line 3233
}
#line 3233

int
#line 3234
ncx_getn_longlong_double(const void **xpp, size_t nelems, double *tp)
#line 3234
{
#line 3234
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3234

#line 3234
 /* basic algorithm is:
#line 3234
  *   - ensure sane alignment of input data
#line 3234
  *   - copy (conversion happens automatically) input data
#line 3234
  *     to output
#line 3234
  *   - update xpp to point at next unconverted input, and tp to point
#line 3234
  *     at next location for converted output
#line 3234
  */
#line 3234
  long i, j, ni;
#line 3234
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3234
  longlong *xp;
#line 3234
  int nrange = 0;         /* number of range errors */
#line 3234
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3234
  long cxp = (long) *((char**)xpp);
#line 3234

#line 3234
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3234
  /* sjl: manually stripmine so we can limit amount of
#line 3234
   * vector work space reserved to LOOPCNT elements. Also
#line 3234
   * makes vectorisation easy */
#line 3234
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3234
    ni=Min(nelems-j,LOOPCNT);
#line 3234
    if (realign) {
#line 3234
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3234
      xp = tmp;
#line 3234
    } else {
#line 3234
      xp = (longlong *) *xpp;
#line 3234
    }
#line 3234
   /* copy the next block */
#line 3234
#pragma cdir loopcnt=LOOPCNT
#line 3234
#pragma cdir shortloop
#line 3234
    for (i=0; i<ni; i++) {
#line 3234
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3234
     /* test for range errors (not always needed but do it anyway) */
#line 3234
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3234
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3234
      nrange += xp[i] > DOUBLE_MAX || xp[i] < DOUBLE_MIN;
#line 3234
    }
#line 3234
   /* update xpp and tp */
#line 3234
    if (realign) xp = (longlong *) *xpp;
#line 3234
    xp += ni;
#line 3234
    tp += ni;
#line 3234
    *xpp = (void*)xp;
#line 3234
  }
#line 3234
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3234

#line 3234
#else   /* not SX */
#line 3234
	const char *xp = (const char *) *xpp;
#line 3234
	int status = NC_NOERR;
#line 3234

#line 3234
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3234
	{
#line 3234
		const int lstatus = ncx_get_longlong_double(xp, tp);
#line 3234
		if(lstatus != NC_NOERR)
#line 3234
			status = lstatus;
#line 3234
	}
#line 3234

#line 3234
	*xpp = (const void *)xp;
#line 3234
	return status;
#line 3234
#  endif
#line 3234
}
#line 3234

int
#line 3235
ncx_getn_longlong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3235
{
#line 3235
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3235

#line 3235
 /* basic algorithm is:
#line 3235
  *   - ensure sane alignment of input data
#line 3235
  *   - copy (conversion happens automatically) input data
#line 3235
  *     to output
#line 3235
  *   - update xpp to point at next unconverted input, and tp to point
#line 3235
  *     at next location for converted output
#line 3235
  */
#line 3235
  long i, j, ni;
#line 3235
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3235
  longlong *xp;
#line 3235
  int nrange = 0;         /* number of range errors */
#line 3235
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3235
  long cxp = (long) *((char**)xpp);
#line 3235

#line 3235
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3235
  /* sjl: manually stripmine so we can limit amount of
#line 3235
   * vector work space reserved to LOOPCNT elements. Also
#line 3235
   * makes vectorisation easy */
#line 3235
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3235
    ni=Min(nelems-j,LOOPCNT);
#line 3235
    if (realign) {
#line 3235
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3235
      xp = tmp;
#line 3235
    } else {
#line 3235
      xp = (longlong *) *xpp;
#line 3235
    }
#line 3235
   /* copy the next block */
#line 3235
#pragma cdir loopcnt=LOOPCNT
#line 3235
#pragma cdir shortloop
#line 3235
    for (i=0; i<ni; i++) {
#line 3235
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3235
     /* test for range errors (not always needed but do it anyway) */
#line 3235
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3235
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3235
      nrange += xp[i] > UCHAR_MAX || xp[i] < 0;
#line 3235
    }
#line 3235
   /* update xpp and tp */
#line 3235
    if (realign) xp = (longlong *) *xpp;
#line 3235
    xp += ni;
#line 3235
    tp += ni;
#line 3235
    *xpp = (void*)xp;
#line 3235
  }
#line 3235
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3235

#line 3235
#else   /* not SX */
#line 3235
	const char *xp = (const char *) *xpp;
#line 3235
	int status = NC_NOERR;
#line 3235

#line 3235
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3235
	{
#line 3235
		const int lstatus = ncx_get_longlong_uchar(xp, tp);
#line 3235
		if(lstatus != NC_NOERR)
#line 3235
			status = lstatus;
#line 3235
	}
#line 3235

#line 3235
	*xpp = (const void *)xp;
#line 3235
	return status;
#line 3235
#  endif
#line 3235
}
#line 3235

int
#line 3236
ncx_getn_longlong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3236
{
#line 3236
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3236

#line 3236
 /* basic algorithm is:
#line 3236
  *   - ensure sane alignment of input data
#line 3236
  *   - copy (conversion happens automatically) input data
#line 3236
  *     to output
#line 3236
  *   - update xpp to point at next unconverted input, and tp to point
#line 3236
  *     at next location for converted output
#line 3236
  */
#line 3236
  long i, j, ni;
#line 3236
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3236
  longlong *xp;
#line 3236
  int nrange = 0;         /* number of range errors */
#line 3236
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3236
  long cxp = (long) *((char**)xpp);
#line 3236

#line 3236
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3236
  /* sjl: manually stripmine so we can limit amount of
#line 3236
   * vector work space reserved to LOOPCNT elements. Also
#line 3236
   * makes vectorisation easy */
#line 3236
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3236
    ni=Min(nelems-j,LOOPCNT);
#line 3236
    if (realign) {
#line 3236
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3236
      xp = tmp;
#line 3236
    } else {
#line 3236
      xp = (longlong *) *xpp;
#line 3236
    }
#line 3236
   /* copy the next block */
#line 3236
#pragma cdir loopcnt=LOOPCNT
#line 3236
#pragma cdir shortloop
#line 3236
    for (i=0; i<ni; i++) {
#line 3236
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3236
     /* test for range errors (not always needed but do it anyway) */
#line 3236
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3236
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3236
      nrange += xp[i] > USHORT_MAX || xp[i] < 0;
#line 3236
    }
#line 3236
   /* update xpp and tp */
#line 3236
    if (realign) xp = (longlong *) *xpp;
#line 3236
    xp += ni;
#line 3236
    tp += ni;
#line 3236
    *xpp = (void*)xp;
#line 3236
  }
#line 3236
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3236

#line 3236
#else   /* not SX */
#line 3236
	const char *xp = (const char *) *xpp;
#line 3236
	int status = NC_NOERR;
#line 3236

#line 3236
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3236
	{
#line 3236
		const int lstatus = ncx_get_longlong_ushort(xp, tp);
#line 3236
		if(lstatus != NC_NOERR)
#line 3236
			status = lstatus;
#line 3236
	}
#line 3236

#line 3236
	*xpp = (const void *)xp;
#line 3236
	return status;
#line 3236
#  endif
#line 3236
}
#line 3236

int
#line 3237
ncx_getn_longlong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3237
{
#line 3237
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3237

#line 3237
 /* basic algorithm is:
#line 3237
  *   - ensure sane alignment of input data
#line 3237
  *   - copy (conversion happens automatically) input data
#line 3237
  *     to output
#line 3237
  *   - update xpp to point at next unconverted input, and tp to point
#line 3237
  *     at next location for converted output
#line 3237
  */
#line 3237
  long i, j, ni;
#line 3237
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3237
  longlong *xp;
#line 3237
  int nrange = 0;         /* number of range errors */
#line 3237
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3237
  long cxp = (long) *((char**)xpp);
#line 3237

#line 3237
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3237
  /* sjl: manually stripmine so we can limit amount of
#line 3237
   * vector work space reserved to LOOPCNT elements. Also
#line 3237
   * makes vectorisation easy */
#line 3237
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3237
    ni=Min(nelems-j,LOOPCNT);
#line 3237
    if (realign) {
#line 3237
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3237
      xp = tmp;
#line 3237
    } else {
#line 3237
      xp = (longlong *) *xpp;
#line 3237
    }
#line 3237
   /* copy the next block */
#line 3237
#pragma cdir loopcnt=LOOPCNT
#line 3237
#pragma cdir shortloop
#line 3237
    for (i=0; i<ni; i++) {
#line 3237
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3237
     /* test for range errors (not always needed but do it anyway) */
#line 3237
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3237
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3237
      nrange += xp[i] > UINT_MAX || xp[i] < 0;
#line 3237
    }
#line 3237
   /* update xpp and tp */
#line 3237
    if (realign) xp = (longlong *) *xpp;
#line 3237
    xp += ni;
#line 3237
    tp += ni;
#line 3237
    *xpp = (void*)xp;
#line 3237
  }
#line 3237
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3237

#line 3237
#else   /* not SX */
#line 3237
	const char *xp = (const char *) *xpp;
#line 3237
	int status = NC_NOERR;
#line 3237

#line 3237
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3237
	{
#line 3237
		const int lstatus = ncx_get_longlong_uint(xp, tp);
#line 3237
		if(lstatus != NC_NOERR)
#line 3237
			status = lstatus;
#line 3237
	}
#line 3237

#line 3237
	*xpp = (const void *)xp;
#line 3237
	return status;
#line 3237
#  endif
#line 3237
}
#line 3237

int
#line 3238
ncx_getn_longlong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3238
{
#line 3238
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3238

#line 3238
 /* basic algorithm is:
#line 3238
  *   - ensure sane alignment of input data
#line 3238
  *   - copy (conversion happens automatically) input data
#line 3238
  *     to output
#line 3238
  *   - update xpp to point at next unconverted input, and tp to point
#line 3238
  *     at next location for converted output
#line 3238
  */
#line 3238
  long i, j, ni;
#line 3238
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3238
  longlong *xp;
#line 3238
  int nrange = 0;         /* number of range errors */
#line 3238
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3238
  long cxp = (long) *((char**)xpp);
#line 3238

#line 3238
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3238
  /* sjl: manually stripmine so we can limit amount of
#line 3238
   * vector work space reserved to LOOPCNT elements. Also
#line 3238
   * makes vectorisation easy */
#line 3238
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3238
    ni=Min(nelems-j,LOOPCNT);
#line 3238
    if (realign) {
#line 3238
      memcpy(tmp, *xpp, ni*SIZEOF_LONGLONG);
#line 3238
      xp = tmp;
#line 3238
    } else {
#line 3238
      xp = (longlong *) *xpp;
#line 3238
    }
#line 3238
   /* copy the next block */
#line 3238
#pragma cdir loopcnt=LOOPCNT
#line 3238
#pragma cdir shortloop
#line 3238
    for (i=0; i<ni; i++) {
#line 3238
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3238
     /* test for range errors (not always needed but do it anyway) */
#line 3238
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3238
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3238
      nrange += xp[i] > ULONGLONG_MAX || xp[i] < 0;
#line 3238
    }
#line 3238
   /* update xpp and tp */
#line 3238
    if (realign) xp = (longlong *) *xpp;
#line 3238
    xp += ni;
#line 3238
    tp += ni;
#line 3238
    *xpp = (void*)xp;
#line 3238
  }
#line 3238
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3238

#line 3238
#else   /* not SX */
#line 3238
	const char *xp = (const char *) *xpp;
#line 3238
	int status = NC_NOERR;
#line 3238

#line 3238
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3238
	{
#line 3238
		const int lstatus = ncx_get_longlong_ulonglong(xp, tp);
#line 3238
		if(lstatus != NC_NOERR)
#line 3238
			status = lstatus;
#line 3238
	}
#line 3238

#line 3238
	*xpp = (const void *)xp;
#line 3238
	return status;
#line 3238
#  endif
#line 3238
}
#line 3238


#if X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
/* optimized version */
int
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_LONGLONG);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_LONGLONG);
	return NC_NOERR;
}
#else
int
#line 3254
ncx_putn_longlong_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 3254
{
#line 3254
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3254

#line 3254
 /* basic algorithm is:
#line 3254
  *   - ensure sane alignment of output data
#line 3254
  *   - copy (conversion happens automatically) input data
#line 3254
  *     to output
#line 3254
  *   - update tp to point at next unconverted input, and xpp to point
#line 3254
  *     at next location for converted output
#line 3254
  */
#line 3254
  long i, j, ni;
#line 3254
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3254
  longlong *xp;
#line 3254
  int nrange = 0;         /* number of range errors */
#line 3254
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3254
  long cxp = (long) *((char**)xpp);
#line 3254

#line 3254
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3254
  /* sjl: manually stripmine so we can limit amount of
#line 3254
   * vector work space reserved to LOOPCNT elements. Also
#line 3254
   * makes vectorisation easy */
#line 3254
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3254
    ni=Min(nelems-j,LOOPCNT);
#line 3254
    if (realign) {
#line 3254
      xp = tmp;
#line 3254
    } else {
#line 3254
      xp = (longlong *) *xpp;
#line 3254
    }
#line 3254
   /* copy the next block */
#line 3254
#pragma cdir loopcnt=LOOPCNT
#line 3254
#pragma cdir shortloop
#line 3254
    for (i=0; i<ni; i++) {
#line 3254
      /* the normal case: */
#line 3254
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3254
     /* test for range errors (not always needed but do it anyway) */
#line 3254
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3254
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3254
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
#line 3254
    }
#line 3254
   /* copy workspace back if necessary */
#line 3254
    if (realign) {
#line 3254
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3254
      xp = (longlong *) *xpp;
#line 3254
    }
#line 3254
   /* update xpp and tp */
#line 3254
    xp += ni;
#line 3254
    tp += ni;
#line 3254
    *xpp = (void*)xp;
#line 3254
  }
#line 3254
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3254

#line 3254
#else   /* not SX */
#line 3254

#line 3254
	char *xp = (char *) *xpp;
#line 3254
	int status = NC_NOERR;
#line 3254

#line 3254
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3254
	{
#line 3254
		int lstatus = ncx_put_longlong_longlong(xp, tp);
#line 3254
		if(lstatus != NC_NOERR)
#line 3254
			status = lstatus;
#line 3254
	}
#line 3254

#line 3254
	*xpp = (void *)xp;
#line 3254
	return status;
#line 3254
#endif
#line 3254
}
#line 3254

#endif
int
#line 3256
ncx_putn_longlong_schar(void **xpp, size_t nelems, const schar *tp)
#line 3256
{
#line 3256
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3256

#line 3256
 /* basic algorithm is:
#line 3256
  *   - ensure sane alignment of output data
#line 3256
  *   - copy (conversion happens automatically) input data
#line 3256
  *     to output
#line 3256
  *   - update tp to point at next unconverted input, and xpp to point
#line 3256
  *     at next location for converted output
#line 3256
  */
#line 3256
  long i, j, ni;
#line 3256
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3256
  longlong *xp;
#line 3256
  int nrange = 0;         /* number of range errors */
#line 3256
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3256
  long cxp = (long) *((char**)xpp);
#line 3256

#line 3256
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3256
  /* sjl: manually stripmine so we can limit amount of
#line 3256
   * vector work space reserved to LOOPCNT elements. Also
#line 3256
   * makes vectorisation easy */
#line 3256
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3256
    ni=Min(nelems-j,LOOPCNT);
#line 3256
    if (realign) {
#line 3256
      xp = tmp;
#line 3256
    } else {
#line 3256
      xp = (longlong *) *xpp;
#line 3256
    }
#line 3256
   /* copy the next block */
#line 3256
#pragma cdir loopcnt=LOOPCNT
#line 3256
#pragma cdir shortloop
#line 3256
    for (i=0; i<ni; i++) {
#line 3256
      /* the normal case: */
#line 3256
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3256
     /* test for range errors (not always needed but do it anyway) */
#line 3256
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3256
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3256
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
#line 3256
    }
#line 3256
   /* copy workspace back if necessary */
#line 3256
    if (realign) {
#line 3256
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3256
      xp = (longlong *) *xpp;
#line 3256
    }
#line 3256
   /* update xpp and tp */
#line 3256
    xp += ni;
#line 3256
    tp += ni;
#line 3256
    *xpp = (void*)xp;
#line 3256
  }
#line 3256
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3256

#line 3256
#else   /* not SX */
#line 3256

#line 3256
	char *xp = (char *) *xpp;
#line 3256
	int status = NC_NOERR;
#line 3256

#line 3256
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3256
	{
#line 3256
		int lstatus = ncx_put_longlong_schar(xp, tp);
#line 3256
		if(lstatus != NC_NOERR)
#line 3256
			status = lstatus;
#line 3256
	}
#line 3256

#line 3256
	*xpp = (void *)xp;
#line 3256
	return status;
#line 3256
#endif
#line 3256
}
#line 3256

int
#line 3257
ncx_putn_longlong_short(void **xpp, size_t nelems, const short *tp)
#line 3257
{
#line 3257
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3257

#line 3257
 /* basic algorithm is:
#line 3257
  *   - ensure sane alignment of output data
#line 3257
  *   - copy (conversion happens automatically) input data
#line 3257
  *     to output
#line 3257
  *   - update tp to point at next unconverted input, and xpp to point
#line 3257
  *     at next location for converted output
#line 3257
  */
#line 3257
  long i, j, ni;
#line 3257
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3257
  longlong *xp;
#line 3257
  int nrange = 0;         /* number of range errors */
#line 3257
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3257
  long cxp = (long) *((char**)xpp);
#line 3257

#line 3257
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3257
  /* sjl: manually stripmine so we can limit amount of
#line 3257
   * vector work space reserved to LOOPCNT elements. Also
#line 3257
   * makes vectorisation easy */
#line 3257
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3257
    ni=Min(nelems-j,LOOPCNT);
#line 3257
    if (realign) {
#line 3257
      xp = tmp;
#line 3257
    } else {
#line 3257
      xp = (longlong *) *xpp;
#line 3257
    }
#line 3257
   /* copy the next block */
#line 3257
#pragma cdir loopcnt=LOOPCNT
#line 3257
#pragma cdir shortloop
#line 3257
    for (i=0; i<ni; i++) {
#line 3257
      /* the normal case: */
#line 3257
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3257
     /* test for range errors (not always needed but do it anyway) */
#line 3257
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3257
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3257
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
#line 3257
    }
#line 3257
   /* copy workspace back if necessary */
#line 3257
    if (realign) {
#line 3257
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3257
      xp = (longlong *) *xpp;
#line 3257
    }
#line 3257
   /* update xpp and tp */
#line 3257
    xp += ni;
#line 3257
    tp += ni;
#line 3257
    *xpp = (void*)xp;
#line 3257
  }
#line 3257
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3257

#line 3257
#else   /* not SX */
#line 3257

#line 3257
	char *xp = (char *) *xpp;
#line 3257
	int status = NC_NOERR;
#line 3257

#line 3257
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3257
	{
#line 3257
		int lstatus = ncx_put_longlong_short(xp, tp);
#line 3257
		if(lstatus != NC_NOERR)
#line 3257
			status = lstatus;
#line 3257
	}
#line 3257

#line 3257
	*xpp = (void *)xp;
#line 3257
	return status;
#line 3257
#endif
#line 3257
}
#line 3257

int
#line 3258
ncx_putn_longlong_int(void **xpp, size_t nelems, const int *tp)
#line 3258
{
#line 3258
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3258

#line 3258
 /* basic algorithm is:
#line 3258
  *   - ensure sane alignment of output data
#line 3258
  *   - copy (conversion happens automatically) input data
#line 3258
  *     to output
#line 3258
  *   - update tp to point at next unconverted input, and xpp to point
#line 3258
  *     at next location for converted output
#line 3258
  */
#line 3258
  long i, j, ni;
#line 3258
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3258
  longlong *xp;
#line 3258
  int nrange = 0;         /* number of range errors */
#line 3258
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3258
  long cxp = (long) *((char**)xpp);
#line 3258

#line 3258
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3258
  /* sjl: manually stripmine so we can limit amount of
#line 3258
   * vector work space reserved to LOOPCNT elements. Also
#line 3258
   * makes vectorisation easy */
#line 3258
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3258
    ni=Min(nelems-j,LOOPCNT);
#line 3258
    if (realign) {
#line 3258
      xp = tmp;
#line 3258
    } else {
#line 3258
      xp = (longlong *) *xpp;
#line 3258
    }
#line 3258
   /* copy the next block */
#line 3258
#pragma cdir loopcnt=LOOPCNT
#line 3258
#pragma cdir shortloop
#line 3258
    for (i=0; i<ni; i++) {
#line 3258
      /* the normal case: */
#line 3258
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3258
     /* test for range errors (not always needed but do it anyway) */
#line 3258
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3258
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3258
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
#line 3258
    }
#line 3258
   /* copy workspace back if necessary */
#line 3258
    if (realign) {
#line 3258
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3258
      xp = (longlong *) *xpp;
#line 3258
    }
#line 3258
   /* update xpp and tp */
#line 3258
    xp += ni;
#line 3258
    tp += ni;
#line 3258
    *xpp = (void*)xp;
#line 3258
  }
#line 3258
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3258

#line 3258
#else   /* not SX */
#line 3258

#line 3258
	char *xp = (char *) *xpp;
#line 3258
	int status = NC_NOERR;
#line 3258

#line 3258
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3258
	{
#line 3258
		int lstatus = ncx_put_longlong_int(xp, tp);
#line 3258
		if(lstatus != NC_NOERR)
#line 3258
			status = lstatus;
#line 3258
	}
#line 3258

#line 3258
	*xpp = (void *)xp;
#line 3258
	return status;
#line 3258
#endif
#line 3258
}
#line 3258

int
#line 3259
ncx_putn_longlong_float(void **xpp, size_t nelems, const float *tp)
#line 3259
{
#line 3259
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3259

#line 3259
 /* basic algorithm is:
#line 3259
  *   - ensure sane alignment of output data
#line 3259
  *   - copy (conversion happens automatically) input data
#line 3259
  *     to output
#line 3259
  *   - update tp to point at next unconverted input, and xpp to point
#line 3259
  *     at next location for converted output
#line 3259
  */
#line 3259
  long i, j, ni;
#line 3259
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3259
  longlong *xp;
#line 3259
  int nrange = 0;         /* number of range errors */
#line 3259
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3259
  long cxp = (long) *((char**)xpp);
#line 3259

#line 3259
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3259
  /* sjl: manually stripmine so we can limit amount of
#line 3259
   * vector work space reserved to LOOPCNT elements. Also
#line 3259
   * makes vectorisation easy */
#line 3259
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3259
    ni=Min(nelems-j,LOOPCNT);
#line 3259
    if (realign) {
#line 3259
      xp = tmp;
#line 3259
    } else {
#line 3259
      xp = (longlong *) *xpp;
#line 3259
    }
#line 3259
   /* copy the next block */
#line 3259
#pragma cdir loopcnt=LOOPCNT
#line 3259
#pragma cdir shortloop
#line 3259
    for (i=0; i<ni; i++) {
#line 3259
      /* the normal case: */
#line 3259
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3259
     /* test for range errors (not always needed but do it anyway) */
#line 3259
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3259
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3259
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
#line 3259
    }
#line 3259
   /* copy workspace back if necessary */
#line 3259
    if (realign) {
#line 3259
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3259
      xp = (longlong *) *xpp;
#line 3259
    }
#line 3259
   /* update xpp and tp */
#line 3259
    xp += ni;
#line 3259
    tp += ni;
#line 3259
    *xpp = (void*)xp;
#line 3259
  }
#line 3259
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3259

#line 3259
#else   /* not SX */
#line 3259

#line 3259
	char *xp = (char *) *xpp;
#line 3259
	int status = NC_NOERR;
#line 3259

#line 3259
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3259
	{
#line 3259
		int lstatus = ncx_put_longlong_float(xp, tp);
#line 3259
		if(lstatus != NC_NOERR)
#line 3259
			status = lstatus;
#line 3259
	}
#line 3259

#line 3259
	*xpp = (void *)xp;
#line 3259
	return status;
#line 3259
#endif
#line 3259
}
#line 3259

int
#line 3260
ncx_putn_longlong_double(void **xpp, size_t nelems, const double *tp)
#line 3260
{
#line 3260
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3260

#line 3260
 /* basic algorithm is:
#line 3260
  *   - ensure sane alignment of output data
#line 3260
  *   - copy (conversion happens automatically) input data
#line 3260
  *     to output
#line 3260
  *   - update tp to point at next unconverted input, and xpp to point
#line 3260
  *     at next location for converted output
#line 3260
  */
#line 3260
  long i, j, ni;
#line 3260
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3260
  longlong *xp;
#line 3260
  int nrange = 0;         /* number of range errors */
#line 3260
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3260
  long cxp = (long) *((char**)xpp);
#line 3260

#line 3260
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3260
  /* sjl: manually stripmine so we can limit amount of
#line 3260
   * vector work space reserved to LOOPCNT elements. Also
#line 3260
   * makes vectorisation easy */
#line 3260
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3260
    ni=Min(nelems-j,LOOPCNT);
#line 3260
    if (realign) {
#line 3260
      xp = tmp;
#line 3260
    } else {
#line 3260
      xp = (longlong *) *xpp;
#line 3260
    }
#line 3260
   /* copy the next block */
#line 3260
#pragma cdir loopcnt=LOOPCNT
#line 3260
#pragma cdir shortloop
#line 3260
    for (i=0; i<ni; i++) {
#line 3260
      /* the normal case: */
#line 3260
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3260
     /* test for range errors (not always needed but do it anyway) */
#line 3260
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3260
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3260
      nrange += tp[i] > X_LONGLONG_MAX || tp[i] < X_LONGLONG_MIN;
#line 3260
    }
#line 3260
   /* copy workspace back if necessary */
#line 3260
    if (realign) {
#line 3260
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3260
      xp = (longlong *) *xpp;
#line 3260
    }
#line 3260
   /* update xpp and tp */
#line 3260
    xp += ni;
#line 3260
    tp += ni;
#line 3260
    *xpp = (void*)xp;
#line 3260
  }
#line 3260
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3260

#line 3260
#else   /* not SX */
#line 3260

#line 3260
	char *xp = (char *) *xpp;
#line 3260
	int status = NC_NOERR;
#line 3260

#line 3260
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3260
	{
#line 3260
		int lstatus = ncx_put_longlong_double(xp, tp);
#line 3260
		if(lstatus != NC_NOERR)
#line 3260
			status = lstatus;
#line 3260
	}
#line 3260

#line 3260
	*xpp = (void *)xp;
#line 3260
	return status;
#line 3260
#endif
#line 3260
}
#line 3260

int
#line 3261
ncx_putn_longlong_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 3261
{
#line 3261
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3261

#line 3261
 /* basic algorithm is:
#line 3261
  *   - ensure sane alignment of output data
#line 3261
  *   - copy (conversion happens automatically) input data
#line 3261
  *     to output
#line 3261
  *   - update tp to point at next unconverted input, and xpp to point
#line 3261
  *     at next location for converted output
#line 3261
  */
#line 3261
  long i, j, ni;
#line 3261
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3261
  longlong *xp;
#line 3261
  int nrange = 0;         /* number of range errors */
#line 3261
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3261
  long cxp = (long) *((char**)xpp);
#line 3261

#line 3261
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3261
  /* sjl: manually stripmine so we can limit amount of
#line 3261
   * vector work space reserved to LOOPCNT elements. Also
#line 3261
   * makes vectorisation easy */
#line 3261
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3261
    ni=Min(nelems-j,LOOPCNT);
#line 3261
    if (realign) {
#line 3261
      xp = tmp;
#line 3261
    } else {
#line 3261
      xp = (longlong *) *xpp;
#line 3261
    }
#line 3261
   /* copy the next block */
#line 3261
#pragma cdir loopcnt=LOOPCNT
#line 3261
#pragma cdir shortloop
#line 3261
    for (i=0; i<ni; i++) {
#line 3261
      /* the normal case: */
#line 3261
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3261
     /* test for range errors (not always needed but do it anyway) */
#line 3261
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3261
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3261
      nrange += tp[i] > X_LONGLONG_MAX ;
#line 3261
    }
#line 3261
   /* copy workspace back if necessary */
#line 3261
    if (realign) {
#line 3261
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3261
      xp = (longlong *) *xpp;
#line 3261
    }
#line 3261
   /* update xpp and tp */
#line 3261
    xp += ni;
#line 3261
    tp += ni;
#line 3261
    *xpp = (void*)xp;
#line 3261
  }
#line 3261
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3261

#line 3261
#else   /* not SX */
#line 3261

#line 3261
	char *xp = (char *) *xpp;
#line 3261
	int status = NC_NOERR;
#line 3261

#line 3261
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3261
	{
#line 3261
		int lstatus = ncx_put_longlong_uchar(xp, tp);
#line 3261
		if(lstatus != NC_NOERR)
#line 3261
			status = lstatus;
#line 3261
	}
#line 3261

#line 3261
	*xpp = (void *)xp;
#line 3261
	return status;
#line 3261
#endif
#line 3261
}
#line 3261

int
#line 3262
ncx_putn_longlong_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 3262
{
#line 3262
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3262

#line 3262
 /* basic algorithm is:
#line 3262
  *   - ensure sane alignment of output data
#line 3262
  *   - copy (conversion happens automatically) input data
#line 3262
  *     to output
#line 3262
  *   - update tp to point at next unconverted input, and xpp to point
#line 3262
  *     at next location for converted output
#line 3262
  */
#line 3262
  long i, j, ni;
#line 3262
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3262
  longlong *xp;
#line 3262
  int nrange = 0;         /* number of range errors */
#line 3262
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3262
  long cxp = (long) *((char**)xpp);
#line 3262

#line 3262
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3262
  /* sjl: manually stripmine so we can limit amount of
#line 3262
   * vector work space reserved to LOOPCNT elements. Also
#line 3262
   * makes vectorisation easy */
#line 3262
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3262
    ni=Min(nelems-j,LOOPCNT);
#line 3262
    if (realign) {
#line 3262
      xp = tmp;
#line 3262
    } else {
#line 3262
      xp = (longlong *) *xpp;
#line 3262
    }
#line 3262
   /* copy the next block */
#line 3262
#pragma cdir loopcnt=LOOPCNT
#line 3262
#pragma cdir shortloop
#line 3262
    for (i=0; i<ni; i++) {
#line 3262
      /* the normal case: */
#line 3262
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3262
     /* test for range errors (not always needed but do it anyway) */
#line 3262
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3262
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3262
      nrange += tp[i] > X_LONGLONG_MAX ;
#line 3262
    }
#line 3262
   /* copy workspace back if necessary */
#line 3262
    if (realign) {
#line 3262
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3262
      xp = (longlong *) *xpp;
#line 3262
    }
#line 3262
   /* update xpp and tp */
#line 3262
    xp += ni;
#line 3262
    tp += ni;
#line 3262
    *xpp = (void*)xp;
#line 3262
  }
#line 3262
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3262

#line 3262
#else   /* not SX */
#line 3262

#line 3262
	char *xp = (char *) *xpp;
#line 3262
	int status = NC_NOERR;
#line 3262

#line 3262
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3262
	{
#line 3262
		int lstatus = ncx_put_longlong_ushort(xp, tp);
#line 3262
		if(lstatus != NC_NOERR)
#line 3262
			status = lstatus;
#line 3262
	}
#line 3262

#line 3262
	*xpp = (void *)xp;
#line 3262
	return status;
#line 3262
#endif
#line 3262
}
#line 3262

int
#line 3263
ncx_putn_longlong_uint(void **xpp, size_t nelems, const uint *tp)
#line 3263
{
#line 3263
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3263

#line 3263
 /* basic algorithm is:
#line 3263
  *   - ensure sane alignment of output data
#line 3263
  *   - copy (conversion happens automatically) input data
#line 3263
  *     to output
#line 3263
  *   - update tp to point at next unconverted input, and xpp to point
#line 3263
  *     at next location for converted output
#line 3263
  */
#line 3263
  long i, j, ni;
#line 3263
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3263
  longlong *xp;
#line 3263
  int nrange = 0;         /* number of range errors */
#line 3263
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3263
  long cxp = (long) *((char**)xpp);
#line 3263

#line 3263
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3263
  /* sjl: manually stripmine so we can limit amount of
#line 3263
   * vector work space reserved to LOOPCNT elements. Also
#line 3263
   * makes vectorisation easy */
#line 3263
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3263
    ni=Min(nelems-j,LOOPCNT);
#line 3263
    if (realign) {
#line 3263
      xp = tmp;
#line 3263
    } else {
#line 3263
      xp = (longlong *) *xpp;
#line 3263
    }
#line 3263
   /* copy the next block */
#line 3263
#pragma cdir loopcnt=LOOPCNT
#line 3263
#pragma cdir shortloop
#line 3263
    for (i=0; i<ni; i++) {
#line 3263
      /* the normal case: */
#line 3263
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3263
     /* test for range errors (not always needed but do it anyway) */
#line 3263
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3263
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3263
      nrange += tp[i] > X_LONGLONG_MAX ;
#line 3263
    }
#line 3263
   /* copy workspace back if necessary */
#line 3263
    if (realign) {
#line 3263
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3263
      xp = (longlong *) *xpp;
#line 3263
    }
#line 3263
   /* update xpp and tp */
#line 3263
    xp += ni;
#line 3263
    tp += ni;
#line 3263
    *xpp = (void*)xp;
#line 3263
  }
#line 3263
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3263

#line 3263
#else   /* not SX */
#line 3263

#line 3263
	char *xp = (char *) *xpp;
#line 3263
	int status = NC_NOERR;
#line 3263

#line 3263
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3263
	{
#line 3263
		int lstatus = ncx_put_longlong_uint(xp, tp);
#line 3263
		if(lstatus != NC_NOERR)
#line 3263
			status = lstatus;
#line 3263
	}
#line 3263

#line 3263
	*xpp = (void *)xp;
#line 3263
	return status;
#line 3263
#endif
#line 3263
}
#line 3263

int
#line 3264
ncx_putn_longlong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 3264
{
#line 3264
#if _SX && X_SIZEOF_LONGLONG == SIZEOF_LONGLONG
#line 3264

#line 3264
 /* basic algorithm is:
#line 3264
  *   - ensure sane alignment of output data
#line 3264
  *   - copy (conversion happens automatically) input data
#line 3264
  *     to output
#line 3264
  *   - update tp to point at next unconverted input, and xpp to point
#line 3264
  *     at next location for converted output
#line 3264
  */
#line 3264
  long i, j, ni;
#line 3264
  longlong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3264
  longlong *xp;
#line 3264
  int nrange = 0;         /* number of range errors */
#line 3264
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3264
  long cxp = (long) *((char**)xpp);
#line 3264

#line 3264
  realign = (cxp & 7) % SIZEOF_LONGLONG;
#line 3264
  /* sjl: manually stripmine so we can limit amount of
#line 3264
   * vector work space reserved to LOOPCNT elements. Also
#line 3264
   * makes vectorisation easy */
#line 3264
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3264
    ni=Min(nelems-j,LOOPCNT);
#line 3264
    if (realign) {
#line 3264
      xp = tmp;
#line 3264
    } else {
#line 3264
      xp = (longlong *) *xpp;
#line 3264
    }
#line 3264
   /* copy the next block */
#line 3264
#pragma cdir loopcnt=LOOPCNT
#line 3264
#pragma cdir shortloop
#line 3264
    for (i=0; i<ni; i++) {
#line 3264
      /* the normal case: */
#line 3264
      xp[i] = (longlong) Max( X_LONGLONG_MIN, Min(X_LONGLONG_MAX, (longlong) tp[i]));
#line 3264
     /* test for range errors (not always needed but do it anyway) */
#line 3264
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3264
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3264
      nrange += tp[i] > X_LONGLONG_MAX ;
#line 3264
    }
#line 3264
   /* copy workspace back if necessary */
#line 3264
    if (realign) {
#line 3264
      memcpy(*xpp, tmp, ni*X_SIZEOF_LONGLONG);
#line 3264
      xp = (longlong *) *xpp;
#line 3264
    }
#line 3264
   /* update xpp and tp */
#line 3264
    xp += ni;
#line 3264
    tp += ni;
#line 3264
    *xpp = (void*)xp;
#line 3264
  }
#line 3264
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3264

#line 3264
#else   /* not SX */
#line 3264

#line 3264
	char *xp = (char *) *xpp;
#line 3264
	int status = NC_NOERR;
#line 3264

#line 3264
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_LONGLONG, tp++)
#line 3264
	{
#line 3264
		int lstatus = ncx_put_longlong_ulonglong(xp, tp);
#line 3264
		if(lstatus != NC_NOERR)
#line 3264
			status = lstatus;
#line 3264
	}
#line 3264

#line 3264
	*xpp = (void *)xp;
#line 3264
	return status;
#line 3264
#endif
#line 3264
}
#line 3264


/* ulonglong ----------------------------------------------------------------------*/

#if X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(tp, *xpp, nelems * sizeof(unsigned long long));
# else
	swapn8b(tp, *xpp, nelems);
# endif
	*xpp = (const void *)((const char *)(*xpp) + nelems * X_SIZEOF_ULONGLONG);
	return NC_NOERR;
}
#else
int
#line 3282
ncx_getn_ulonglong_ulonglong(const void **xpp, size_t nelems, ulonglong *tp)
#line 3282
{
#line 3282
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3282

#line 3282
 /* basic algorithm is:
#line 3282
  *   - ensure sane alignment of input data
#line 3282
  *   - copy (conversion happens automatically) input data
#line 3282
  *     to output
#line 3282
  *   - update xpp to point at next unconverted input, and tp to point
#line 3282
  *     at next location for converted output
#line 3282
  */
#line 3282
  long i, j, ni;
#line 3282
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3282
  ulonglong *xp;
#line 3282
  int nrange = 0;         /* number of range errors */
#line 3282
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3282
  long cxp = (long) *((char**)xpp);
#line 3282

#line 3282
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3282
  /* sjl: manually stripmine so we can limit amount of
#line 3282
   * vector work space reserved to LOOPCNT elements. Also
#line 3282
   * makes vectorisation easy */
#line 3282
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3282
    ni=Min(nelems-j,LOOPCNT);
#line 3282
    if (realign) {
#line 3282
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3282
      xp = tmp;
#line 3282
    } else {
#line 3282
      xp = (ulonglong *) *xpp;
#line 3282
    }
#line 3282
   /* copy the next block */
#line 3282
#pragma cdir loopcnt=LOOPCNT
#line 3282
#pragma cdir shortloop
#line 3282
    for (i=0; i<ni; i++) {
#line 3282
      tp[i] = (ulonglong) Max( ULONGLONG_MIN, Min(ULONGLONG_MAX, (ulonglong) xp[i]));
#line 3282
     /* test for range errors (not always needed but do it anyway) */
#line 3282
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3282
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3282
      nrange += xp[i] > ULONGLONG_MAX ;
#line 3282
    }
#line 3282
   /* update xpp and tp */
#line 3282
    if (realign) xp = (ulonglong *) *xpp;
#line 3282
    xp += ni;
#line 3282
    tp += ni;
#line 3282
    *xpp = (void*)xp;
#line 3282
  }
#line 3282
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3282

#line 3282
#else   /* not SX */
#line 3282
	const char *xp = (const char *) *xpp;
#line 3282
	int status = NC_NOERR;
#line 3282

#line 3282
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3282
	{
#line 3282
		const int lstatus = ncx_get_ulonglong_ulonglong(xp, tp);
#line 3282
		if(lstatus != NC_NOERR)
#line 3282
			status = lstatus;
#line 3282
	}
#line 3282

#line 3282
	*xpp = (const void *)xp;
#line 3282
	return status;
#line 3282
#  endif
#line 3282
}
#line 3282

#endif
int
#line 3284
ncx_getn_ulonglong_schar(const void **xpp, size_t nelems, schar *tp)
#line 3284
{
#line 3284
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3284

#line 3284
 /* basic algorithm is:
#line 3284
  *   - ensure sane alignment of input data
#line 3284
  *   - copy (conversion happens automatically) input data
#line 3284
  *     to output
#line 3284
  *   - update xpp to point at next unconverted input, and tp to point
#line 3284
  *     at next location for converted output
#line 3284
  */
#line 3284
  long i, j, ni;
#line 3284
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3284
  ulonglong *xp;
#line 3284
  int nrange = 0;         /* number of range errors */
#line 3284
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3284
  long cxp = (long) *((char**)xpp);
#line 3284

#line 3284
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3284
  /* sjl: manually stripmine so we can limit amount of
#line 3284
   * vector work space reserved to LOOPCNT elements. Also
#line 3284
   * makes vectorisation easy */
#line 3284
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3284
    ni=Min(nelems-j,LOOPCNT);
#line 3284
    if (realign) {
#line 3284
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3284
      xp = tmp;
#line 3284
    } else {
#line 3284
      xp = (ulonglong *) *xpp;
#line 3284
    }
#line 3284
   /* copy the next block */
#line 3284
#pragma cdir loopcnt=LOOPCNT
#line 3284
#pragma cdir shortloop
#line 3284
    for (i=0; i<ni; i++) {
#line 3284
      tp[i] = (schar) Max( SCHAR_MIN, Min(SCHAR_MAX, (schar) xp[i]));
#line 3284
     /* test for range errors (not always needed but do it anyway) */
#line 3284
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3284
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3284
      nrange += xp[i] > SCHAR_MAX ;
#line 3284
    }
#line 3284
   /* update xpp and tp */
#line 3284
    if (realign) xp = (ulonglong *) *xpp;
#line 3284
    xp += ni;
#line 3284
    tp += ni;
#line 3284
    *xpp = (void*)xp;
#line 3284
  }
#line 3284
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3284

#line 3284
#else   /* not SX */
#line 3284
	const char *xp = (const char *) *xpp;
#line 3284
	int status = NC_NOERR;
#line 3284

#line 3284
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3284
	{
#line 3284
		const int lstatus = ncx_get_ulonglong_schar(xp, tp);
#line 3284
		if(lstatus != NC_NOERR)
#line 3284
			status = lstatus;
#line 3284
	}
#line 3284

#line 3284
	*xpp = (const void *)xp;
#line 3284
	return status;
#line 3284
#  endif
#line 3284
}
#line 3284

int
#line 3285
ncx_getn_ulonglong_short(const void **xpp, size_t nelems, short *tp)
#line 3285
{
#line 3285
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3285

#line 3285
 /* basic algorithm is:
#line 3285
  *   - ensure sane alignment of input data
#line 3285
  *   - copy (conversion happens automatically) input data
#line 3285
  *     to output
#line 3285
  *   - update xpp to point at next unconverted input, and tp to point
#line 3285
  *     at next location for converted output
#line 3285
  */
#line 3285
  long i, j, ni;
#line 3285
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3285
  ulonglong *xp;
#line 3285
  int nrange = 0;         /* number of range errors */
#line 3285
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3285
  long cxp = (long) *((char**)xpp);
#line 3285

#line 3285
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3285
  /* sjl: manually stripmine so we can limit amount of
#line 3285
   * vector work space reserved to LOOPCNT elements. Also
#line 3285
   * makes vectorisation easy */
#line 3285
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3285
    ni=Min(nelems-j,LOOPCNT);
#line 3285
    if (realign) {
#line 3285
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3285
      xp = tmp;
#line 3285
    } else {
#line 3285
      xp = (ulonglong *) *xpp;
#line 3285
    }
#line 3285
   /* copy the next block */
#line 3285
#pragma cdir loopcnt=LOOPCNT
#line 3285
#pragma cdir shortloop
#line 3285
    for (i=0; i<ni; i++) {
#line 3285
      tp[i] = (short) Max( SHORT_MIN, Min(SHORT_MAX, (short) xp[i]));
#line 3285
     /* test for range errors (not always needed but do it anyway) */
#line 3285
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3285
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3285
      nrange += xp[i] > SHORT_MAX ;
#line 3285
    }
#line 3285
   /* update xpp and tp */
#line 3285
    if (realign) xp = (ulonglong *) *xpp;
#line 3285
    xp += ni;
#line 3285
    tp += ni;
#line 3285
    *xpp = (void*)xp;
#line 3285
  }
#line 3285
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3285

#line 3285
#else   /* not SX */
#line 3285
	const char *xp = (const char *) *xpp;
#line 3285
	int status = NC_NOERR;
#line 3285

#line 3285
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3285
	{
#line 3285
		const int lstatus = ncx_get_ulonglong_short(xp, tp);
#line 3285
		if(lstatus != NC_NOERR)
#line 3285
			status = lstatus;
#line 3285
	}
#line 3285

#line 3285
	*xpp = (const void *)xp;
#line 3285
	return status;
#line 3285
#  endif
#line 3285
}
#line 3285

int
#line 3286
ncx_getn_ulonglong_int(const void **xpp, size_t nelems, int *tp)
#line 3286
{
#line 3286
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3286

#line 3286
 /* basic algorithm is:
#line 3286
  *   - ensure sane alignment of input data
#line 3286
  *   - copy (conversion happens automatically) input data
#line 3286
  *     to output
#line 3286
  *   - update xpp to point at next unconverted input, and tp to point
#line 3286
  *     at next location for converted output
#line 3286
  */
#line 3286
  long i, j, ni;
#line 3286
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3286
  ulonglong *xp;
#line 3286
  int nrange = 0;         /* number of range errors */
#line 3286
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3286
  long cxp = (long) *((char**)xpp);
#line 3286

#line 3286
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3286
  /* sjl: manually stripmine so we can limit amount of
#line 3286
   * vector work space reserved to LOOPCNT elements. Also
#line 3286
   * makes vectorisation easy */
#line 3286
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3286
    ni=Min(nelems-j,LOOPCNT);
#line 3286
    if (realign) {
#line 3286
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3286
      xp = tmp;
#line 3286
    } else {
#line 3286
      xp = (ulonglong *) *xpp;
#line 3286
    }
#line 3286
   /* copy the next block */
#line 3286
#pragma cdir loopcnt=LOOPCNT
#line 3286
#pragma cdir shortloop
#line 3286
    for (i=0; i<ni; i++) {
#line 3286
      tp[i] = (int) Max( INT_MIN, Min(INT_MAX, (int) xp[i]));
#line 3286
     /* test for range errors (not always needed but do it anyway) */
#line 3286
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3286
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3286
      nrange += xp[i] > INT_MAX ;
#line 3286
    }
#line 3286
   /* update xpp and tp */
#line 3286
    if (realign) xp = (ulonglong *) *xpp;
#line 3286
    xp += ni;
#line 3286
    tp += ni;
#line 3286
    *xpp = (void*)xp;
#line 3286
  }
#line 3286
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3286

#line 3286
#else   /* not SX */
#line 3286
	const char *xp = (const char *) *xpp;
#line 3286
	int status = NC_NOERR;
#line 3286

#line 3286
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3286
	{
#line 3286
		const int lstatus = ncx_get_ulonglong_int(xp, tp);
#line 3286
		if(lstatus != NC_NOERR)
#line 3286
			status = lstatus;
#line 3286
	}
#line 3286

#line 3286
	*xpp = (const void *)xp;
#line 3286
	return status;
#line 3286
#  endif
#line 3286
}
#line 3286

int
#line 3287
ncx_getn_ulonglong_float(const void **xpp, size_t nelems, float *tp)
#line 3287
{
#line 3287
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3287

#line 3287
 /* basic algorithm is:
#line 3287
  *   - ensure sane alignment of input data
#line 3287
  *   - copy (conversion happens automatically) input data
#line 3287
  *     to output
#line 3287
  *   - update xpp to point at next unconverted input, and tp to point
#line 3287
  *     at next location for converted output
#line 3287
  */
#line 3287
  long i, j, ni;
#line 3287
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3287
  ulonglong *xp;
#line 3287
  int nrange = 0;         /* number of range errors */
#line 3287
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3287
  long cxp = (long) *((char**)xpp);
#line 3287

#line 3287
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3287
  /* sjl: manually stripmine so we can limit amount of
#line 3287
   * vector work space reserved to LOOPCNT elements. Also
#line 3287
   * makes vectorisation easy */
#line 3287
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3287
    ni=Min(nelems-j,LOOPCNT);
#line 3287
    if (realign) {
#line 3287
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3287
      xp = tmp;
#line 3287
    } else {
#line 3287
      xp = (ulonglong *) *xpp;
#line 3287
    }
#line 3287
   /* copy the next block */
#line 3287
#pragma cdir loopcnt=LOOPCNT
#line 3287
#pragma cdir shortloop
#line 3287
    for (i=0; i<ni; i++) {
#line 3287
      tp[i] = (float) Max( FLOAT_MIN, Min(FLOAT_MAX, (float) xp[i]));
#line 3287
     /* test for range errors (not always needed but do it anyway) */
#line 3287
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3287
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3287
      nrange += xp[i] > FLOAT_MAX ;
#line 3287
    }
#line 3287
   /* update xpp and tp */
#line 3287
    if (realign) xp = (ulonglong *) *xpp;
#line 3287
    xp += ni;
#line 3287
    tp += ni;
#line 3287
    *xpp = (void*)xp;
#line 3287
  }
#line 3287
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3287

#line 3287
#else   /* not SX */
#line 3287
	const char *xp = (const char *) *xpp;
#line 3287
	int status = NC_NOERR;
#line 3287

#line 3287
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3287
	{
#line 3287
		const int lstatus = ncx_get_ulonglong_float(xp, tp);
#line 3287
		if(lstatus != NC_NOERR)
#line 3287
			status = lstatus;
#line 3287
	}
#line 3287

#line 3287
	*xpp = (const void *)xp;
#line 3287
	return status;
#line 3287
#  endif
#line 3287
}
#line 3287

int
#line 3288
ncx_getn_ulonglong_double(const void **xpp, size_t nelems, double *tp)
#line 3288
{
#line 3288
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3288

#line 3288
 /* basic algorithm is:
#line 3288
  *   - ensure sane alignment of input data
#line 3288
  *   - copy (conversion happens automatically) input data
#line 3288
  *     to output
#line 3288
  *   - update xpp to point at next unconverted input, and tp to point
#line 3288
  *     at next location for converted output
#line 3288
  */
#line 3288
  long i, j, ni;
#line 3288
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3288
  ulonglong *xp;
#line 3288
  int nrange = 0;         /* number of range errors */
#line 3288
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3288
  long cxp = (long) *((char**)xpp);
#line 3288

#line 3288
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3288
  /* sjl: manually stripmine so we can limit amount of
#line 3288
   * vector work space reserved to LOOPCNT elements. Also
#line 3288
   * makes vectorisation easy */
#line 3288
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3288
    ni=Min(nelems-j,LOOPCNT);
#line 3288
    if (realign) {
#line 3288
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3288
      xp = tmp;
#line 3288
    } else {
#line 3288
      xp = (ulonglong *) *xpp;
#line 3288
    }
#line 3288
   /* copy the next block */
#line 3288
#pragma cdir loopcnt=LOOPCNT
#line 3288
#pragma cdir shortloop
#line 3288
    for (i=0; i<ni; i++) {
#line 3288
      tp[i] = (double) Max( DOUBLE_MIN, Min(DOUBLE_MAX, (double) xp[i]));
#line 3288
     /* test for range errors (not always needed but do it anyway) */
#line 3288
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3288
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3288
      nrange += xp[i] > DOUBLE_MAX ;
#line 3288
    }
#line 3288
   /* update xpp and tp */
#line 3288
    if (realign) xp = (ulonglong *) *xpp;
#line 3288
    xp += ni;
#line 3288
    tp += ni;
#line 3288
    *xpp = (void*)xp;
#line 3288
  }
#line 3288
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3288

#line 3288
#else   /* not SX */
#line 3288
	const char *xp = (const char *) *xpp;
#line 3288
	int status = NC_NOERR;
#line 3288

#line 3288
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3288
	{
#line 3288
		const int lstatus = ncx_get_ulonglong_double(xp, tp);
#line 3288
		if(lstatus != NC_NOERR)
#line 3288
			status = lstatus;
#line 3288
	}
#line 3288

#line 3288
	*xpp = (const void *)xp;
#line 3288
	return status;
#line 3288
#  endif
#line 3288
}
#line 3288

int
#line 3289
ncx_getn_ulonglong_longlong(const void **xpp, size_t nelems, longlong *tp)
#line 3289
{
#line 3289
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3289

#line 3289
 /* basic algorithm is:
#line 3289
  *   - ensure sane alignment of input data
#line 3289
  *   - copy (conversion happens automatically) input data
#line 3289
  *     to output
#line 3289
  *   - update xpp to point at next unconverted input, and tp to point
#line 3289
  *     at next location for converted output
#line 3289
  */
#line 3289
  long i, j, ni;
#line 3289
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3289
  ulonglong *xp;
#line 3289
  int nrange = 0;         /* number of range errors */
#line 3289
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3289
  long cxp = (long) *((char**)xpp);
#line 3289

#line 3289
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3289
  /* sjl: manually stripmine so we can limit amount of
#line 3289
   * vector work space reserved to LOOPCNT elements. Also
#line 3289
   * makes vectorisation easy */
#line 3289
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3289
    ni=Min(nelems-j,LOOPCNT);
#line 3289
    if (realign) {
#line 3289
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3289
      xp = tmp;
#line 3289
    } else {
#line 3289
      xp = (ulonglong *) *xpp;
#line 3289
    }
#line 3289
   /* copy the next block */
#line 3289
#pragma cdir loopcnt=LOOPCNT
#line 3289
#pragma cdir shortloop
#line 3289
    for (i=0; i<ni; i++) {
#line 3289
      tp[i] = (longlong) Max( LONGLONG_MIN, Min(LONGLONG_MAX, (longlong) xp[i]));
#line 3289
     /* test for range errors (not always needed but do it anyway) */
#line 3289
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3289
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3289
      nrange += xp[i] > LONGLONG_MAX ;
#line 3289
    }
#line 3289
   /* update xpp and tp */
#line 3289
    if (realign) xp = (ulonglong *) *xpp;
#line 3289
    xp += ni;
#line 3289
    tp += ni;
#line 3289
    *xpp = (void*)xp;
#line 3289
  }
#line 3289
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3289

#line 3289
#else   /* not SX */
#line 3289
	const char *xp = (const char *) *xpp;
#line 3289
	int status = NC_NOERR;
#line 3289

#line 3289
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3289
	{
#line 3289
		const int lstatus = ncx_get_ulonglong_longlong(xp, tp);
#line 3289
		if(lstatus != NC_NOERR)
#line 3289
			status = lstatus;
#line 3289
	}
#line 3289

#line 3289
	*xpp = (const void *)xp;
#line 3289
	return status;
#line 3289
#  endif
#line 3289
}
#line 3289

int
#line 3290
ncx_getn_ulonglong_uchar(const void **xpp, size_t nelems, uchar *tp)
#line 3290
{
#line 3290
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3290

#line 3290
 /* basic algorithm is:
#line 3290
  *   - ensure sane alignment of input data
#line 3290
  *   - copy (conversion happens automatically) input data
#line 3290
  *     to output
#line 3290
  *   - update xpp to point at next unconverted input, and tp to point
#line 3290
  *     at next location for converted output
#line 3290
  */
#line 3290
  long i, j, ni;
#line 3290
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3290
  ulonglong *xp;
#line 3290
  int nrange = 0;         /* number of range errors */
#line 3290
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3290
  long cxp = (long) *((char**)xpp);
#line 3290

#line 3290
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3290
  /* sjl: manually stripmine so we can limit amount of
#line 3290
   * vector work space reserved to LOOPCNT elements. Also
#line 3290
   * makes vectorisation easy */
#line 3290
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3290
    ni=Min(nelems-j,LOOPCNT);
#line 3290
    if (realign) {
#line 3290
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3290
      xp = tmp;
#line 3290
    } else {
#line 3290
      xp = (ulonglong *) *xpp;
#line 3290
    }
#line 3290
   /* copy the next block */
#line 3290
#pragma cdir loopcnt=LOOPCNT
#line 3290
#pragma cdir shortloop
#line 3290
    for (i=0; i<ni; i++) {
#line 3290
      tp[i] = (uchar) Max( UCHAR_MIN, Min(UCHAR_MAX, (uchar) xp[i]));
#line 3290
     /* test for range errors (not always needed but do it anyway) */
#line 3290
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3290
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3290
      nrange += xp[i] > UCHAR_MAX ;
#line 3290
    }
#line 3290
   /* update xpp and tp */
#line 3290
    if (realign) xp = (ulonglong *) *xpp;
#line 3290
    xp += ni;
#line 3290
    tp += ni;
#line 3290
    *xpp = (void*)xp;
#line 3290
  }
#line 3290
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3290

#line 3290
#else   /* not SX */
#line 3290
	const char *xp = (const char *) *xpp;
#line 3290
	int status = NC_NOERR;
#line 3290

#line 3290
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3290
	{
#line 3290
		const int lstatus = ncx_get_ulonglong_uchar(xp, tp);
#line 3290
		if(lstatus != NC_NOERR)
#line 3290
			status = lstatus;
#line 3290
	}
#line 3290

#line 3290
	*xpp = (const void *)xp;
#line 3290
	return status;
#line 3290
#  endif
#line 3290
}
#line 3290

int
#line 3291
ncx_getn_ulonglong_ushort(const void **xpp, size_t nelems, ushort *tp)
#line 3291
{
#line 3291
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3291

#line 3291
 /* basic algorithm is:
#line 3291
  *   - ensure sane alignment of input data
#line 3291
  *   - copy (conversion happens automatically) input data
#line 3291
  *     to output
#line 3291
  *   - update xpp to point at next unconverted input, and tp to point
#line 3291
  *     at next location for converted output
#line 3291
  */
#line 3291
  long i, j, ni;
#line 3291
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3291
  ulonglong *xp;
#line 3291
  int nrange = 0;         /* number of range errors */
#line 3291
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3291
  long cxp = (long) *((char**)xpp);
#line 3291

#line 3291
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3291
  /* sjl: manually stripmine so we can limit amount of
#line 3291
   * vector work space reserved to LOOPCNT elements. Also
#line 3291
   * makes vectorisation easy */
#line 3291
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3291
    ni=Min(nelems-j,LOOPCNT);
#line 3291
    if (realign) {
#line 3291
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3291
      xp = tmp;
#line 3291
    } else {
#line 3291
      xp = (ulonglong *) *xpp;
#line 3291
    }
#line 3291
   /* copy the next block */
#line 3291
#pragma cdir loopcnt=LOOPCNT
#line 3291
#pragma cdir shortloop
#line 3291
    for (i=0; i<ni; i++) {
#line 3291
      tp[i] = (ushort) Max( USHORT_MIN, Min(USHORT_MAX, (ushort) xp[i]));
#line 3291
     /* test for range errors (not always needed but do it anyway) */
#line 3291
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3291
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3291
      nrange += xp[i] > USHORT_MAX ;
#line 3291
    }
#line 3291
   /* update xpp and tp */
#line 3291
    if (realign) xp = (ulonglong *) *xpp;
#line 3291
    xp += ni;
#line 3291
    tp += ni;
#line 3291
    *xpp = (void*)xp;
#line 3291
  }
#line 3291
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3291

#line 3291
#else   /* not SX */
#line 3291
	const char *xp = (const char *) *xpp;
#line 3291
	int status = NC_NOERR;
#line 3291

#line 3291
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3291
	{
#line 3291
		const int lstatus = ncx_get_ulonglong_ushort(xp, tp);
#line 3291
		if(lstatus != NC_NOERR)
#line 3291
			status = lstatus;
#line 3291
	}
#line 3291

#line 3291
	*xpp = (const void *)xp;
#line 3291
	return status;
#line 3291
#  endif
#line 3291
}
#line 3291

int
#line 3292
ncx_getn_ulonglong_uint(const void **xpp, size_t nelems, uint *tp)
#line 3292
{
#line 3292
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3292

#line 3292
 /* basic algorithm is:
#line 3292
  *   - ensure sane alignment of input data
#line 3292
  *   - copy (conversion happens automatically) input data
#line 3292
  *     to output
#line 3292
  *   - update xpp to point at next unconverted input, and tp to point
#line 3292
  *     at next location for converted output
#line 3292
  */
#line 3292
  long i, j, ni;
#line 3292
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3292
  ulonglong *xp;
#line 3292
  int nrange = 0;         /* number of range errors */
#line 3292
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3292
  long cxp = (long) *((char**)xpp);
#line 3292

#line 3292
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3292
  /* sjl: manually stripmine so we can limit amount of
#line 3292
   * vector work space reserved to LOOPCNT elements. Also
#line 3292
   * makes vectorisation easy */
#line 3292
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3292
    ni=Min(nelems-j,LOOPCNT);
#line 3292
    if (realign) {
#line 3292
      memcpy(tmp, *xpp, ni*SIZEOF_ULONGLONG);
#line 3292
      xp = tmp;
#line 3292
    } else {
#line 3292
      xp = (ulonglong *) *xpp;
#line 3292
    }
#line 3292
   /* copy the next block */
#line 3292
#pragma cdir loopcnt=LOOPCNT
#line 3292
#pragma cdir shortloop
#line 3292
    for (i=0; i<ni; i++) {
#line 3292
      tp[i] = (uint) Max( UINT_MIN, Min(UINT_MAX, (uint) xp[i]));
#line 3292
     /* test for range errors (not always needed but do it anyway) */
#line 3292
     /* if xpp is unsigned, we need not check if xp[i] < _MIN */
#line 3292
     /* if xpp is signed && tp is unsigned, we need check if xp[i] >= 0 */
#line 3292
      nrange += xp[i] > UINT_MAX ;
#line 3292
    }
#line 3292
   /* update xpp and tp */
#line 3292
    if (realign) xp = (ulonglong *) *xpp;
#line 3292
    xp += ni;
#line 3292
    tp += ni;
#line 3292
    *xpp = (void*)xp;
#line 3292
  }
#line 3292
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3292

#line 3292
#else   /* not SX */
#line 3292
	const char *xp = (const char *) *xpp;
#line 3292
	int status = NC_NOERR;
#line 3292

#line 3292
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3292
	{
#line 3292
		const int lstatus = ncx_get_ulonglong_uint(xp, tp);
#line 3292
		if(lstatus != NC_NOERR)
#line 3292
			status = lstatus;
#line 3292
	}
#line 3292

#line 3292
	*xpp = (const void *)xp;
#line 3292
	return status;
#line 3292
#  endif
#line 3292
}
#line 3292


#if X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
/* optimized version */
int
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const unsigned long long *tp)
{
#ifdef WORDS_BIGENDIAN
	(void) memcpy(*xpp, tp, nelems * X_SIZEOF_ULONGLONG);
# else
	swapn8b(*xpp, tp, nelems);
# endif
	*xpp = (void *)((char *)(*xpp) + nelems * X_SIZEOF_ULONGLONG);
	return NC_NOERR;
}
#else
int
#line 3308
ncx_putn_ulonglong_ulonglong(void **xpp, size_t nelems, const ulonglong *tp)
#line 3308
{
#line 3308
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3308

#line 3308
 /* basic algorithm is:
#line 3308
  *   - ensure sane alignment of output data
#line 3308
  *   - copy (conversion happens automatically) input data
#line 3308
  *     to output
#line 3308
  *   - update tp to point at next unconverted input, and xpp to point
#line 3308
  *     at next location for converted output
#line 3308
  */
#line 3308
  long i, j, ni;
#line 3308
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3308
  ulonglong *xp;
#line 3308
  int nrange = 0;         /* number of range errors */
#line 3308
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3308
  long cxp = (long) *((char**)xpp);
#line 3308

#line 3308
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3308
  /* sjl: manually stripmine so we can limit amount of
#line 3308
   * vector work space reserved to LOOPCNT elements. Also
#line 3308
   * makes vectorisation easy */
#line 3308
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3308
    ni=Min(nelems-j,LOOPCNT);
#line 3308
    if (realign) {
#line 3308
      xp = tmp;
#line 3308
    } else {
#line 3308
      xp = (ulonglong *) *xpp;
#line 3308
    }
#line 3308
   /* copy the next block */
#line 3308
#pragma cdir loopcnt=LOOPCNT
#line 3308
#pragma cdir shortloop
#line 3308
    for (i=0; i<ni; i++) {
#line 3308
      /* the normal case: */
#line 3308
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3308
     /* test for range errors (not always needed but do it anyway) */
#line 3308
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3308
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3308
      nrange += tp[i] > X_ULONGLONG_MAX ;
#line 3308
    }
#line 3308
   /* copy workspace back if necessary */
#line 3308
    if (realign) {
#line 3308
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3308
      xp = (ulonglong *) *xpp;
#line 3308
    }
#line 3308
   /* update xpp and tp */
#line 3308
    xp += ni;
#line 3308
    tp += ni;
#line 3308
    *xpp = (void*)xp;
#line 3308
  }
#line 3308
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3308

#line 3308
#else   /* not SX */
#line 3308

#line 3308
	char *xp = (char *) *xpp;
#line 3308
	int status = NC_NOERR;
#line 3308

#line 3308
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3308
	{
#line 3308
		int lstatus = ncx_put_ulonglong_ulonglong(xp, tp);
#line 3308
		if(lstatus != NC_NOERR)
#line 3308
			status = lstatus;
#line 3308
	}
#line 3308

#line 3308
	*xpp = (void *)xp;
#line 3308
	return status;
#line 3308
#endif
#line 3308
}
#line 3308

#endif
int
#line 3310
ncx_putn_ulonglong_schar(void **xpp, size_t nelems, const schar *tp)
#line 3310
{
#line 3310
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3310

#line 3310
 /* basic algorithm is:
#line 3310
  *   - ensure sane alignment of output data
#line 3310
  *   - copy (conversion happens automatically) input data
#line 3310
  *     to output
#line 3310
  *   - update tp to point at next unconverted input, and xpp to point
#line 3310
  *     at next location for converted output
#line 3310
  */
#line 3310
  long i, j, ni;
#line 3310
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3310
  ulonglong *xp;
#line 3310
  int nrange = 0;         /* number of range errors */
#line 3310
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3310
  long cxp = (long) *((char**)xpp);
#line 3310

#line 3310
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3310
  /* sjl: manually stripmine so we can limit amount of
#line 3310
   * vector work space reserved to LOOPCNT elements. Also
#line 3310
   * makes vectorisation easy */
#line 3310
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3310
    ni=Min(nelems-j,LOOPCNT);
#line 3310
    if (realign) {
#line 3310
      xp = tmp;
#line 3310
    } else {
#line 3310
      xp = (ulonglong *) *xpp;
#line 3310
    }
#line 3310
   /* copy the next block */
#line 3310
#pragma cdir loopcnt=LOOPCNT
#line 3310
#pragma cdir shortloop
#line 3310
    for (i=0; i<ni; i++) {
#line 3310
      /* the normal case: */
#line 3310
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3310
     /* test for range errors (not always needed but do it anyway) */
#line 3310
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3310
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3310
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
#line 3310
    }
#line 3310
   /* copy workspace back if necessary */
#line 3310
    if (realign) {
#line 3310
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3310
      xp = (ulonglong *) *xpp;
#line 3310
    }
#line 3310
   /* update xpp and tp */
#line 3310
    xp += ni;
#line 3310
    tp += ni;
#line 3310
    *xpp = (void*)xp;
#line 3310
  }
#line 3310
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3310

#line 3310
#else   /* not SX */
#line 3310

#line 3310
	char *xp = (char *) *xpp;
#line 3310
	int status = NC_NOERR;
#line 3310

#line 3310
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3310
	{
#line 3310
		int lstatus = ncx_put_ulonglong_schar(xp, tp);
#line 3310
		if(lstatus != NC_NOERR)
#line 3310
			status = lstatus;
#line 3310
	}
#line 3310

#line 3310
	*xpp = (void *)xp;
#line 3310
	return status;
#line 3310
#endif
#line 3310
}
#line 3310

int
#line 3311
ncx_putn_ulonglong_short(void **xpp, size_t nelems, const short *tp)
#line 3311
{
#line 3311
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3311

#line 3311
 /* basic algorithm is:
#line 3311
  *   - ensure sane alignment of output data
#line 3311
  *   - copy (conversion happens automatically) input data
#line 3311
  *     to output
#line 3311
  *   - update tp to point at next unconverted input, and xpp to point
#line 3311
  *     at next location for converted output
#line 3311
  */
#line 3311
  long i, j, ni;
#line 3311
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3311
  ulonglong *xp;
#line 3311
  int nrange = 0;         /* number of range errors */
#line 3311
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3311
  long cxp = (long) *((char**)xpp);
#line 3311

#line 3311
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3311
  /* sjl: manually stripmine so we can limit amount of
#line 3311
   * vector work space reserved to LOOPCNT elements. Also
#line 3311
   * makes vectorisation easy */
#line 3311
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3311
    ni=Min(nelems-j,LOOPCNT);
#line 3311
    if (realign) {
#line 3311
      xp = tmp;
#line 3311
    } else {
#line 3311
      xp = (ulonglong *) *xpp;
#line 3311
    }
#line 3311
   /* copy the next block */
#line 3311
#pragma cdir loopcnt=LOOPCNT
#line 3311
#pragma cdir shortloop
#line 3311
    for (i=0; i<ni; i++) {
#line 3311
      /* the normal case: */
#line 3311
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3311
     /* test for range errors (not always needed but do it anyway) */
#line 3311
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3311
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3311
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
#line 3311
    }
#line 3311
   /* copy workspace back if necessary */
#line 3311
    if (realign) {
#line 3311
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3311
      xp = (ulonglong *) *xpp;
#line 3311
    }
#line 3311
   /* update xpp and tp */
#line 3311
    xp += ni;
#line 3311
    tp += ni;
#line 3311
    *xpp = (void*)xp;
#line 3311
  }
#line 3311
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3311

#line 3311
#else   /* not SX */
#line 3311

#line 3311
	char *xp = (char *) *xpp;
#line 3311
	int status = NC_NOERR;
#line 3311

#line 3311
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3311
	{
#line 3311
		int lstatus = ncx_put_ulonglong_short(xp, tp);
#line 3311
		if(lstatus != NC_NOERR)
#line 3311
			status = lstatus;
#line 3311
	}
#line 3311

#line 3311
	*xpp = (void *)xp;
#line 3311
	return status;
#line 3311
#endif
#line 3311
}
#line 3311

int
#line 3312
ncx_putn_ulonglong_int(void **xpp, size_t nelems, const int *tp)
#line 3312
{
#line 3312
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3312

#line 3312
 /* basic algorithm is:
#line 3312
  *   - ensure sane alignment of output data
#line 3312
  *   - copy (conversion happens automatically) input data
#line 3312
  *     to output
#line 3312
  *   - update tp to point at next unconverted input, and xpp to point
#line 3312
  *     at next location for converted output
#line 3312
  */
#line 3312
  long i, j, ni;
#line 3312
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3312
  ulonglong *xp;
#line 3312
  int nrange = 0;         /* number of range errors */
#line 3312
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3312
  long cxp = (long) *((char**)xpp);
#line 3312

#line 3312
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3312
  /* sjl: manually stripmine so we can limit amount of
#line 3312
   * vector work space reserved to LOOPCNT elements. Also
#line 3312
   * makes vectorisation easy */
#line 3312
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3312
    ni=Min(nelems-j,LOOPCNT);
#line 3312
    if (realign) {
#line 3312
      xp = tmp;
#line 3312
    } else {
#line 3312
      xp = (ulonglong *) *xpp;
#line 3312
    }
#line 3312
   /* copy the next block */
#line 3312
#pragma cdir loopcnt=LOOPCNT
#line 3312
#pragma cdir shortloop
#line 3312
    for (i=0; i<ni; i++) {
#line 3312
      /* the normal case: */
#line 3312
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3312
     /* test for range errors (not always needed but do it anyway) */
#line 3312
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3312
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3312
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
#line 3312
    }
#line 3312
   /* copy workspace back if necessary */
#line 3312
    if (realign) {
#line 3312
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3312
      xp = (ulonglong *) *xpp;
#line 3312
    }
#line 3312
   /* update xpp and tp */
#line 3312
    xp += ni;
#line 3312
    tp += ni;
#line 3312
    *xpp = (void*)xp;
#line 3312
  }
#line 3312
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3312

#line 3312
#else   /* not SX */
#line 3312

#line 3312
	char *xp = (char *) *xpp;
#line 3312
	int status = NC_NOERR;
#line 3312

#line 3312
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3312
	{
#line 3312
		int lstatus = ncx_put_ulonglong_int(xp, tp);
#line 3312
		if(lstatus != NC_NOERR)
#line 3312
			status = lstatus;
#line 3312
	}
#line 3312

#line 3312
	*xpp = (void *)xp;
#line 3312
	return status;
#line 3312
#endif
#line 3312
}
#line 3312

int
#line 3313
ncx_putn_ulonglong_float(void **xpp, size_t nelems, const float *tp)
#line 3313
{
#line 3313
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3313

#line 3313
 /* basic algorithm is:
#line 3313
  *   - ensure sane alignment of output data
#line 3313
  *   - copy (conversion happens automatically) input data
#line 3313
  *     to output
#line 3313
  *   - update tp to point at next unconverted input, and xpp to point
#line 3313
  *     at next location for converted output
#line 3313
  */
#line 3313
  long i, j, ni;
#line 3313
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3313
  ulonglong *xp;
#line 3313
  int nrange = 0;         /* number of range errors */
#line 3313
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3313
  long cxp = (long) *((char**)xpp);
#line 3313

#line 3313
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3313
  /* sjl: manually stripmine so we can limit amount of
#line 3313
   * vector work space reserved to LOOPCNT elements. Also
#line 3313
   * makes vectorisation easy */
#line 3313
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3313
    ni=Min(nelems-j,LOOPCNT);
#line 3313
    if (realign) {
#line 3313
      xp = tmp;
#line 3313
    } else {
#line 3313
      xp = (ulonglong *) *xpp;
#line 3313
    }
#line 3313
   /* copy the next block */
#line 3313
#pragma cdir loopcnt=LOOPCNT
#line 3313
#pragma cdir shortloop
#line 3313
    for (i=0; i<ni; i++) {
#line 3313
      /* the normal case: */
#line 3313
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3313
     /* test for range errors (not always needed but do it anyway) */
#line 3313
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3313
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3313
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
#line 3313
    }
#line 3313
   /* copy workspace back if necessary */
#line 3313
    if (realign) {
#line 3313
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3313
      xp = (ulonglong *) *xpp;
#line 3313
    }
#line 3313
   /* update xpp and tp */
#line 3313
    xp += ni;
#line 3313
    tp += ni;
#line 3313
    *xpp = (void*)xp;
#line 3313
  }
#line 3313
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3313

#line 3313
#else   /* not SX */
#line 3313

#line 3313
	char *xp = (char *) *xpp;
#line 3313
	int status = NC_NOERR;
#line 3313

#line 3313
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3313
	{
#line 3313
		int lstatus = ncx_put_ulonglong_float(xp, tp);
#line 3313
		if(lstatus != NC_NOERR)
#line 3313
			status = lstatus;
#line 3313
	}
#line 3313

#line 3313
	*xpp = (void *)xp;
#line 3313
	return status;
#line 3313
#endif
#line 3313
}
#line 3313

int
#line 3314
ncx_putn_ulonglong_double(void **xpp, size_t nelems, const double *tp)
#line 3314
{
#line 3314
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3314

#line 3314
 /* basic algorithm is:
#line 3314
  *   - ensure sane alignment of output data
#line 3314
  *   - copy (conversion happens automatically) input data
#line 3314
  *     to output
#line 3314
  *   - update tp to point at next unconverted input, and xpp to point
#line 3314
  *     at next location for converted output
#line 3314
  */
#line 3314
  long i, j, ni;
#line 3314
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3314
  ulonglong *xp;
#line 3314
  int nrange = 0;         /* number of range errors */
#line 3314
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3314
  long cxp = (long) *((char**)xpp);
#line 3314

#line 3314
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3314
  /* sjl: manually stripmine so we can limit amount of
#line 3314
   * vector work space reserved to LOOPCNT elements. Also
#line 3314
   * makes vectorisation easy */
#line 3314
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3314
    ni=Min(nelems-j,LOOPCNT);
#line 3314
    if (realign) {
#line 3314
      xp = tmp;
#line 3314
    } else {
#line 3314
      xp = (ulonglong *) *xpp;
#line 3314
    }
#line 3314
   /* copy the next block */
#line 3314
#pragma cdir loopcnt=LOOPCNT
#line 3314
#pragma cdir shortloop
#line 3314
    for (i=0; i<ni; i++) {
#line 3314
      /* the normal case: */
#line 3314
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3314
     /* test for range errors (not always needed but do it anyway) */
#line 3314
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3314
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3314
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
#line 3314
    }
#line 3314
   /* copy workspace back if necessary */
#line 3314
    if (realign) {
#line 3314
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3314
      xp = (ulonglong *) *xpp;
#line 3314
    }
#line 3314
   /* update xpp and tp */
#line 3314
    xp += ni;
#line 3314
    tp += ni;
#line 3314
    *xpp = (void*)xp;
#line 3314
  }
#line 3314
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3314

#line 3314
#else   /* not SX */
#line 3314

#line 3314
	char *xp = (char *) *xpp;
#line 3314
	int status = NC_NOERR;
#line 3314

#line 3314
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3314
	{
#line 3314
		int lstatus = ncx_put_ulonglong_double(xp, tp);
#line 3314
		if(lstatus != NC_NOERR)
#line 3314
			status = lstatus;
#line 3314
	}
#line 3314

#line 3314
	*xpp = (void *)xp;
#line 3314
	return status;
#line 3314
#endif
#line 3314
}
#line 3314

int
#line 3315
ncx_putn_ulonglong_longlong(void **xpp, size_t nelems, const longlong *tp)
#line 3315
{
#line 3315
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3315

#line 3315
 /* basic algorithm is:
#line 3315
  *   - ensure sane alignment of output data
#line 3315
  *   - copy (conversion happens automatically) input data
#line 3315
  *     to output
#line 3315
  *   - update tp to point at next unconverted input, and xpp to point
#line 3315
  *     at next location for converted output
#line 3315
  */
#line 3315
  long i, j, ni;
#line 3315
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3315
  ulonglong *xp;
#line 3315
  int nrange = 0;         /* number of range errors */
#line 3315
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3315
  long cxp = (long) *((char**)xpp);
#line 3315

#line 3315
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3315
  /* sjl: manually stripmine so we can limit amount of
#line 3315
   * vector work space reserved to LOOPCNT elements. Also
#line 3315
   * makes vectorisation easy */
#line 3315
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3315
    ni=Min(nelems-j,LOOPCNT);
#line 3315
    if (realign) {
#line 3315
      xp = tmp;
#line 3315
    } else {
#line 3315
      xp = (ulonglong *) *xpp;
#line 3315
    }
#line 3315
   /* copy the next block */
#line 3315
#pragma cdir loopcnt=LOOPCNT
#line 3315
#pragma cdir shortloop
#line 3315
    for (i=0; i<ni; i++) {
#line 3315
      /* the normal case: */
#line 3315
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3315
     /* test for range errors (not always needed but do it anyway) */
#line 3315
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3315
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3315
      nrange += tp[i] > X_ULONGLONG_MAX || tp[i] < 0;
#line 3315
    }
#line 3315
   /* copy workspace back if necessary */
#line 3315
    if (realign) {
#line 3315
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3315
      xp = (ulonglong *) *xpp;
#line 3315
    }
#line 3315
   /* update xpp and tp */
#line 3315
    xp += ni;
#line 3315
    tp += ni;
#line 3315
    *xpp = (void*)xp;
#line 3315
  }
#line 3315
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3315

#line 3315
#else   /* not SX */
#line 3315

#line 3315
	char *xp = (char *) *xpp;
#line 3315
	int status = NC_NOERR;
#line 3315

#line 3315
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3315
	{
#line 3315
		int lstatus = ncx_put_ulonglong_longlong(xp, tp);
#line 3315
		if(lstatus != NC_NOERR)
#line 3315
			status = lstatus;
#line 3315
	}
#line 3315

#line 3315
	*xpp = (void *)xp;
#line 3315
	return status;
#line 3315
#endif
#line 3315
}
#line 3315

int
#line 3316
ncx_putn_ulonglong_uchar(void **xpp, size_t nelems, const uchar *tp)
#line 3316
{
#line 3316
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3316

#line 3316
 /* basic algorithm is:
#line 3316
  *   - ensure sane alignment of output data
#line 3316
  *   - copy (conversion happens automatically) input data
#line 3316
  *     to output
#line 3316
  *   - update tp to point at next unconverted input, and xpp to point
#line 3316
  *     at next location for converted output
#line 3316
  */
#line 3316
  long i, j, ni;
#line 3316
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3316
  ulonglong *xp;
#line 3316
  int nrange = 0;         /* number of range errors */
#line 3316
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3316
  long cxp = (long) *((char**)xpp);
#line 3316

#line 3316
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3316
  /* sjl: manually stripmine so we can limit amount of
#line 3316
   * vector work space reserved to LOOPCNT elements. Also
#line 3316
   * makes vectorisation easy */
#line 3316
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3316
    ni=Min(nelems-j,LOOPCNT);
#line 3316
    if (realign) {
#line 3316
      xp = tmp;
#line 3316
    } else {
#line 3316
      xp = (ulonglong *) *xpp;
#line 3316
    }
#line 3316
   /* copy the next block */
#line 3316
#pragma cdir loopcnt=LOOPCNT
#line 3316
#pragma cdir shortloop
#line 3316
    for (i=0; i<ni; i++) {
#line 3316
      /* the normal case: */
#line 3316
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3316
     /* test for range errors (not always needed but do it anyway) */
#line 3316
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3316
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3316
      nrange += tp[i] > X_ULONGLONG_MAX ;
#line 3316
    }
#line 3316
   /* copy workspace back if necessary */
#line 3316
    if (realign) {
#line 3316
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3316
      xp = (ulonglong *) *xpp;
#line 3316
    }
#line 3316
   /* update xpp and tp */
#line 3316
    xp += ni;
#line 3316
    tp += ni;
#line 3316
    *xpp = (void*)xp;
#line 3316
  }
#line 3316
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3316

#line 3316
#else   /* not SX */
#line 3316

#line 3316
	char *xp = (char *) *xpp;
#line 3316
	int status = NC_NOERR;
#line 3316

#line 3316
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3316
	{
#line 3316
		int lstatus = ncx_put_ulonglong_uchar(xp, tp);
#line 3316
		if(lstatus != NC_NOERR)
#line 3316
			status = lstatus;
#line 3316
	}
#line 3316

#line 3316
	*xpp = (void *)xp;
#line 3316
	return status;
#line 3316
#endif
#line 3316
}
#line 3316

int
#line 3317
ncx_putn_ulonglong_ushort(void **xpp, size_t nelems, const ushort *tp)
#line 3317
{
#line 3317
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3317

#line 3317
 /* basic algorithm is:
#line 3317
  *   - ensure sane alignment of output data
#line 3317
  *   - copy (conversion happens automatically) input data
#line 3317
  *     to output
#line 3317
  *   - update tp to point at next unconverted input, and xpp to point
#line 3317
  *     at next location for converted output
#line 3317
  */
#line 3317
  long i, j, ni;
#line 3317
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3317
  ulonglong *xp;
#line 3317
  int nrange = 0;         /* number of range errors */
#line 3317
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3317
  long cxp = (long) *((char**)xpp);
#line 3317

#line 3317
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3317
  /* sjl: manually stripmine so we can limit amount of
#line 3317
   * vector work space reserved to LOOPCNT elements. Also
#line 3317
   * makes vectorisation easy */
#line 3317
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3317
    ni=Min(nelems-j,LOOPCNT);
#line 3317
    if (realign) {
#line 3317
      xp = tmp;
#line 3317
    } else {
#line 3317
      xp = (ulonglong *) *xpp;
#line 3317
    }
#line 3317
   /* copy the next block */
#line 3317
#pragma cdir loopcnt=LOOPCNT
#line 3317
#pragma cdir shortloop
#line 3317
    for (i=0; i<ni; i++) {
#line 3317
      /* the normal case: */
#line 3317
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3317
     /* test for range errors (not always needed but do it anyway) */
#line 3317
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3317
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3317
      nrange += tp[i] > X_ULONGLONG_MAX ;
#line 3317
    }
#line 3317
   /* copy workspace back if necessary */
#line 3317
    if (realign) {
#line 3317
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3317
      xp = (ulonglong *) *xpp;
#line 3317
    }
#line 3317
   /* update xpp and tp */
#line 3317
    xp += ni;
#line 3317
    tp += ni;
#line 3317
    *xpp = (void*)xp;
#line 3317
  }
#line 3317
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3317

#line 3317
#else   /* not SX */
#line 3317

#line 3317
	char *xp = (char *) *xpp;
#line 3317
	int status = NC_NOERR;
#line 3317

#line 3317
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3317
	{
#line 3317
		int lstatus = ncx_put_ulonglong_ushort(xp, tp);
#line 3317
		if(lstatus != NC_NOERR)
#line 3317
			status = lstatus;
#line 3317
	}
#line 3317

#line 3317
	*xpp = (void *)xp;
#line 3317
	return status;
#line 3317
#endif
#line 3317
}
#line 3317

int
#line 3318
ncx_putn_ulonglong_uint(void **xpp, size_t nelems, const uint *tp)
#line 3318
{
#line 3318
#if _SX && X_SIZEOF_ULONGLONG == SIZEOF_ULONGLONG
#line 3318

#line 3318
 /* basic algorithm is:
#line 3318
  *   - ensure sane alignment of output data
#line 3318
  *   - copy (conversion happens automatically) input data
#line 3318
  *     to output
#line 3318
  *   - update tp to point at next unconverted input, and xpp to point
#line 3318
  *     at next location for converted output
#line 3318
  */
#line 3318
  long i, j, ni;
#line 3318
  ulonglong tmp[LOOPCNT];        /* in case input is misaligned */
#line 3318
  ulonglong *xp;
#line 3318
  int nrange = 0;         /* number of range errors */
#line 3318
  int realign = 0;        /* "do we need to fix input data alignment?" */
#line 3318
  long cxp = (long) *((char**)xpp);
#line 3318

#line 3318
  realign = (cxp & 7) % SIZEOF_ULONGLONG;
#line 3318
  /* sjl: manually stripmine so we can limit amount of
#line 3318
   * vector work space reserved to LOOPCNT elements. Also
#line 3318
   * makes vectorisation easy */
#line 3318
  for (j=0; j<nelems && nrange==0; j+=LOOPCNT) {
#line 3318
    ni=Min(nelems-j,LOOPCNT);
#line 3318
    if (realign) {
#line 3318
      xp = tmp;
#line 3318
    } else {
#line 3318
      xp = (ulonglong *) *xpp;
#line 3318
    }
#line 3318
   /* copy the next block */
#line 3318
#pragma cdir loopcnt=LOOPCNT
#line 3318
#pragma cdir shortloop
#line 3318
    for (i=0; i<ni; i++) {
#line 3318
      /* the normal case: */
#line 3318
      xp[i] = (ulonglong) Max( X_ULONGLONG_MIN, Min(X_ULONGLONG_MAX, (ulonglong) tp[i]));
#line 3318
     /* test for range errors (not always needed but do it anyway) */
#line 3318
     /* if xpp is unsigned && tp is signed, we need check if tp[i] >= 0 */
#line 3318
     /* if tp is unsigned, we need not check if tp[i] < X__MIN */
#line 3318
      nrange += tp[i] > X_ULONGLONG_MAX ;
#line 3318
    }
#line 3318
   /* copy workspace back if necessary */
#line 3318
    if (realign) {
#line 3318
      memcpy(*xpp, tmp, ni*X_SIZEOF_ULONGLONG);
#line 3318
      xp = (ulonglong *) *xpp;
#line 3318
    }
#line 3318
   /* update xpp and tp */
#line 3318
    xp += ni;
#line 3318
    tp += ni;
#line 3318
    *xpp = (void*)xp;
#line 3318
  }
#line 3318
  return nrange == 0 ? NC_NOERR : NC_ERANGE;
#line 3318

#line 3318
#else   /* not SX */
#line 3318

#line 3318
	char *xp = (char *) *xpp;
#line 3318
	int status = NC_NOERR;
#line 3318

#line 3318
	for( ; nelems != 0; nelems--, xp += X_SIZEOF_ULONGLONG, tp++)
#line 3318
	{
#line 3318
		int lstatus = ncx_put_ulonglong_uint(xp, tp);
#line 3318
		if(lstatus != NC_NOERR)
#line 3318
			status = lstatus;
#line 3318
	}
#line 3318

#line 3318
	*xpp = (void *)xp;
#line 3318
	return status;
#line 3318
#endif
#line 3318
}
#line 3318



/*
 * Other aggregate conversion functions.
 */

/* text */
#ifdef __arm__
int
ncx_getn_text(const void **xpp, size_t nelems, signed char *tp)
#else
int
ncx_getn_text(const void **xpp, size_t nelems, char *tp)
#endif
{
	(void) memcpy(tp, *xpp, nelems);
#line 3334
	*xpp = (void *)((schar *)(*xpp) + nelems);
#line 3334
	return NC_NOERR;
#line 3334

}

#ifdef __arm__
int
ncx_pad_getn_text(const void **xpp, size_t nelems, signed char *tp)
#else
int
ncx_pad_getn_text(const void **xpp, size_t nelems, char *tp)
#endif
{
	size_t rndup = nelems % X_ALIGN;
#line 3345

#line 3345
	if(rndup)
#line 3345
		rndup = X_ALIGN - rndup;
#line 3345

#line 3345
	(void) memcpy(tp, *xpp, nelems);
#line 3345
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3345

#line 3345
	return NC_NOERR;
#line 3345

}

#ifdef __arm__
int ncx_putn_text(void **xpp, size_t nelems, const signed char *tp)
#else
int
ncx_putn_text(void **xpp, size_t nelems, const char *tp)
#endif
{
	(void) memcpy(*xpp, tp, nelems);
#line 3355
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3355

#line 3355
	return NC_NOERR;
#line 3355

}

#ifdef __arm__
int
ncx_pad_putn_text(void **xpp, size_t nelems, const signed char *tp)
#else
int
ncx_pad_putn_text(void **xpp, size_t nelems, const char *tp)
#endif
{
	size_t rndup = nelems % X_ALIGN;
#line 3366

#line 3366
	if(rndup)
#line 3366
		rndup = X_ALIGN - rndup;
#line 3366

#line 3366
	(void) memcpy(*xpp, tp, nelems);
#line 3366
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3366

#line 3366
	if(rndup)
#line 3366
	{
#line 3366
		(void) memcpy(*xpp, nada, rndup);
#line 3366
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3366
	}
#line 3366

#line 3366
	return NC_NOERR;
#line 3366

}


/* opaque */

int
ncx_getn_void(const void **xpp, size_t nelems, void *tp)
{
	(void) memcpy(tp, *xpp, nelems);
#line 3375
	*xpp = (void *)((schar *)(*xpp) + nelems);
#line 3375
	return NC_NOERR;
#line 3375

}

int
ncx_pad_getn_void(const void **xpp, size_t nelems, void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3381

#line 3381
	if(rndup)
#line 3381
		rndup = X_ALIGN - rndup;
#line 3381

#line 3381
	(void) memcpy(tp, *xpp, nelems);
#line 3381
	*xpp = (void *)((char *)(*xpp) + nelems + rndup);
#line 3381

#line 3381
	return NC_NOERR;
#line 3381

}

int
ncx_putn_void(void **xpp, size_t nelems, const void *tp)
{
	(void) memcpy(*xpp, tp, nelems);
#line 3387
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3387

#line 3387
	return NC_NOERR;
#line 3387

}

int
ncx_pad_putn_void(void **xpp, size_t nelems, const void *tp)
{
	size_t rndup = nelems % X_ALIGN;
#line 3393

#line 3393
	if(rndup)
#line 3393
		rndup = X_ALIGN - rndup;
#line 3393

#line 3393
	(void) memcpy(*xpp, tp, nelems);
#line 3393
	*xpp = (void *)((char *)(*xpp) + nelems);
#line 3393

#line 3393
	if(rndup)
#line 3393
	{
#line 3393
		(void) memcpy(*xpp, nada, rndup);
#line 3393
		*xpp = (void *)((char *)(*xpp) + rndup);
#line 3393
	}
#line 3393

#line 3393
	return NC_NOERR;
#line 3393

}
