; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes='require<profile-summary>,function(codegenprepare)' < %s -S | FileCheck %s

target datalayout = "e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "riscv64"

%struct.match_state = type { i64, i64  }

; %add is also promoted by forking an extra sext.
define void @promoteTwoOne(i32 %i, i32 %j, ptr %P1, ptr %P2 ) {
; CHECK-LABEL: define void @promoteTwoOne(
; CHECK-SAME: i32 [[I:%.*]], i32 [[J:%.*]], ptr [[P1:%.*]], ptr [[P2:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[S2:%.*]] = sext i32 [[I]] to i64
; CHECK-NEXT:    [[PROMOTED2:%.*]] = sext i32 [[J]] to i64
; CHECK-NEXT:    [[S:%.*]] = add nsw i64 [[S2]], [[PROMOTED2]]
; CHECK-NEXT:    [[ADDR1:%.*]] = getelementptr inbounds i64, ptr [[P1]], i64 [[S]]
; CHECK-NEXT:    store i64 [[S]], ptr [[ADDR1]], align 8
; CHECK-NEXT:    [[ADDR2:%.*]] = getelementptr inbounds i64, ptr [[P2]], i64 [[S2]]
; CHECK-NEXT:    store i64 [[S2]], ptr [[ADDR2]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %add = add nsw i32 %i, %j
  %s = sext i32 %add to i64
  %addr1 = getelementptr inbounds i64, ptr %P1, i64 %s
  store i64 %s, ptr %addr1
  %s2 = sext i32 %i to i64
  %addr2 = getelementptr inbounds i64, ptr %P2, i64 %s2
  store i64 %s2, ptr %addr2
  ret void
}

; Both %add1 and %add2 are promoted by forking extra sexts.
define void @promoteTwoTwo(i32 %i, i32 %j, i32 %k, ptr %P1, ptr %P2) {
; CHECK-LABEL: define void @promoteTwoTwo(
; CHECK-SAME: i32 [[I:%.*]], i32 [[J:%.*]], i32 [[K:%.*]], ptr [[P1:%.*]], ptr [[P2:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PROMOTED3:%.*]] = sext i32 [[J]] to i64
; CHECK-NEXT:    [[PROMOTED4:%.*]] = sext i32 [[I]] to i64
; CHECK-NEXT:    [[S:%.*]] = add nsw i64 [[PROMOTED3]], [[PROMOTED4]]
; CHECK-NEXT:    [[ADDR1:%.*]] = getelementptr inbounds i64, ptr [[P1]], i64 [[S]]
; CHECK-NEXT:    store i64 [[S]], ptr [[ADDR1]], align 8
; CHECK-NEXT:    [[PROMOTED2:%.*]] = sext i32 [[K]] to i64
; CHECK-NEXT:    [[S2:%.*]] = add nsw i64 [[PROMOTED3]], [[PROMOTED2]]
; CHECK-NEXT:    [[ADDR2:%.*]] = getelementptr inbounds i64, ptr [[P2]], i64 [[S2]]
; CHECK-NEXT:    store i64 [[S2]], ptr [[ADDR2]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %add1 = add nsw i32 %j, %i
  %s = sext i32 %add1 to i64
  %addr1 = getelementptr inbounds i64, ptr %P1, i64 %s
  store i64 %s, ptr %addr1
  %add2 = add nsw i32 %j, %k
  %s2 = sext i32 %add2 to i64
  %addr2 = getelementptr inbounds i64, ptr %P2, i64 %s2
  store i64 %s2, ptr %addr2
  ret void
}

define i64 @promoteGEPSunk(i1 %cond, ptr %base, i32 %i) {
; CHECK-LABEL: define i64 @promoteGEPSunk(
; CHECK-SAME: i1 [[COND:%.*]], ptr [[BASE:%.*]], i32 [[I:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PROMOTED1:%.*]] = sext i32 [[I]] to i64
; CHECK-NEXT:    [[S:%.*]] = add nsw i64 [[PROMOTED1]], 1
; CHECK-NEXT:    [[ADDR:%.*]] = getelementptr inbounds i64, ptr [[BASE]], i64 [[S]]
; CHECK-NEXT:    [[S2:%.*]] = add nsw i64 [[PROMOTED1]], 2
; CHECK-NEXT:    [[ADDR2:%.*]] = getelementptr inbounds i64, ptr [[BASE]], i64 [[S2]]
; CHECK-NEXT:    br i1 [[COND]], label [[IF_THEN:%.*]], label [[IF_THEN2:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    [[V:%.*]] = load i64, ptr [[ADDR]], align 8
; CHECK-NEXT:    [[V2:%.*]] = load i64, ptr [[ADDR2]], align 8
; CHECK-NEXT:    [[R:%.*]] = add i64 [[V]], [[V2]]
; CHECK-NEXT:    ret i64 [[R]]
; CHECK:       if.then2:
; CHECK-NEXT:    ret i64 0
;
entry:
  %add = add nsw i32 %i, 1
  %s = sext i32 %add to i64
  %addr = getelementptr inbounds i64, ptr %base, i64 %s
  %add2 = add nsw i32 %i,  2
  %s2 = sext i32 %add2 to i64
  %addr2 = getelementptr inbounds i64, ptr %base, i64 %s2
  br i1 %cond, label %if.then, label %if.then2
if.then:
  %v = load i64, ptr %addr
  %v2 = load i64, ptr %addr2
  %r = add i64 %v, %v2
  ret i64 %r
if.then2:
  ret i64 0;
}
