;; This file was automatically generated by SWIG (http://www.swig.org).
;; Version 2.0.9
;;
;; Do not make changes to this file unless you know what you are doing--modify
;; the SWIG interface file instead.

(defpackage :swig
  (:use :common-lisp :ff :excl)
  (:export #:*swig-identifier-converter* #:*swig-module-name*
           #:*void* #:*swig-export-list*))
(in-package :swig)

(eval-when (:compile-toplevel :load-toplevel :execute)
  (defparameter *swig-identifier-converter* 'identifier-convert-lispify)
  (defparameter *swig-module-name* :4ti2))

(defpackage :4ti2
  (:use :common-lisp :swig :ff :excl))


(eval-when (:compile-toplevel :load-toplevel :execute)

  ;; avoid compiling ef-templates at runtime
  (excl:find-external-format :fat)
  (excl:find-external-format :fat-le)

;;; You can define your own identifier converter if you want.
;;; Use the -identifier-converter command line argument to
;;; specify its name.

(eval-when (:compile-toplevel :load-toplevel :execute)
   (cl::defparameter *swig-export-list* nil))

(cl::defconstant *void* :..void..)

;; parsers to aid in finding SWIG definitions in files.
(cl::defun scm-p1 (form)
  (let* ((info (cl::second form))
	 (id (car info))
	 (id-args (if (eq (cl::car form) 'swig-dispatcher)
		      (cl::cdr info)
		      (cl::cddr info))))
    (cl::apply *swig-identifier-converter* id 
	   (cl::progn (cl::when (cl::eq (cl::car form) 'swig-dispatcher)
		    (cl::remf id-args :arities))
		  id-args))))

(cl::defmacro defswig1 (name (&rest args) &body body)
  `(cl::progn (cl::defmacro ,name ,args
	    ,@body)
	  (excl::define-simple-parser ,name scm-p1)) )

(cl::defmacro defswig2 (name (&rest args) &body body)
  `(cl::progn (cl::defmacro ,name ,args
	    ,@body)
	  (excl::define-simple-parser ,name second)))

(defun read-symbol-from-string (string)
  (cl::multiple-value-bind (result position)
      (cl::read-from-string string nil "eof" :preserve-whitespace t)
    (cl::if (cl::and (cl::symbolp result)
    	             (cl::eql position (cl::length string)))
        result
	(cl::multiple-value-bind (sym)
	    (cl::intern string)
	  sym))))

(cl::defun full-name (id type arity class)
  ; We need some kind of a hack here to handle template classes
  ; and other synonym types right. We need the original name.
  (let*( (sym (read-symbol-from-string 
                (if (eq *swig-identifier-converter* 'identifier-convert-lispify)
                  (string-lispify id)
                  id)))
         (sym-class (find-class sym nil))
         (id (cond ( (not sym-class)
                     id )
                   ( (and sym-class
                          (not (eq (class-name sym-class)
                                sym)))
                     (class-name sym-class) )
                   ( t
                     id ))) )
    (cl::case type
      (:getter (cl::format nil "~@[~A_~]~A" class id))
      (:constructor (cl::format nil "new_~A~@[~A~]" id arity))
      (:destructor (cl::format nil "delete_~A" id))
      (:type (cl::format nil "ff_~A" id))
      (:slot id)
      (:ff-operator (cl::format nil "ffi_~A" id))
      (otherwise (cl::format nil "~@[~A_~]~A~@[~A~]"
                         class id arity)))))
  
(cl::defun identifier-convert-null (id &key type class arity)
  (cl::if (cl::eq type :setter)
      `(cl::setf ,(identifier-convert-null
               id :type :getter :class class :arity arity))
      (read-symbol-from-string (full-name id type arity class))))

(cl::defun string-lispify (str)
  (cl::let ( (cname (excl::replace-regexp str "_" "-"))
             (lastcase :other)
             newcase char res ) 
    (cl::dotimes (n (cl::length cname))
      (cl::setf char (cl::schar cname n))
      (excl::if* (cl::alpha-char-p char)
         then
              (cl::setf newcase (cl::if (cl::upper-case-p char) :upper :lower))
              (cl::when (cl::and (cl::eq lastcase :lower)
                                 (cl::eq newcase :upper))
                ;; case change... add a dash
                (cl::push #\- res)
                (cl::setf newcase :other))
              (cl::push (cl::char-downcase char) res)
              (cl::setf lastcase newcase)
         else
              (cl::push char res)
              (cl::setf lastcase :other)))
    (cl::coerce (cl::nreverse res) 'string)))
  
(cl::defun identifier-convert-lispify (cname &key type class arity)
  (cl::assert (cl::stringp cname))
  (cl::when (cl::eq type :setter)
    (cl::return-from identifier-convert-lispify
      `(cl::setf ,(identifier-convert-lispify
               cname :type :getter :class class :arity arity))))
  (cl::setq cname (full-name cname type arity class))
  (cl::if (cl::eq type :constant)
      (cl::setf cname (cl::format nil "*~A*" cname)))
  (read-symbol-from-string (string-lispify cname)))

(cl::defun id-convert-and-export (name &rest kwargs)
  (cl::multiple-value-bind (symbol package)
      (cl::apply *swig-identifier-converter* name kwargs)
    (cl::let ((args (cl::list (cl::if (cl::consp symbol)
    	     	    	         (cl::cadr symbol) symbol)
                      (cl::or package cl::*package*))))
      (cl::apply #'cl::export args)
      (cl::pushnew args *swig-export-list*))
    symbol))

(cl::defmacro swig-insert-id (name namespace &key (type :type) class)
  `(cl::let ((cl::*package* (cl::find-package ,(package-name-for-namespace namespace))))
    (id-convert-and-export ,name :type ,type :class ,class)))

(defswig2 swig-defconstant (string value)
  (cl::let ((symbol (id-convert-and-export string :type :constant)))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
       (cl::defconstant ,symbol ,value))))

(cl::defun maybe-reorder-args (funcname arglist)
  ;; in the foreign setter function the new value will be the last argument
  ;; in Lisp it needs to be the first
  (cl::if (cl::consp funcname)
      (cl::append (cl::last arglist) (cl::butlast arglist))
      arglist))

(cl::defun maybe-return-value (funcname arglist)
  ;; setf functions should return the new value
  (cl::when (cl::consp funcname)
    `(,(cl::if (cl::consp (cl::car arglist))
           (cl::caar arglist)
           (cl::car arglist)))))

(cl::defun swig-anyvarargs-p (arglist)
  (cl::member :SWIG__varargs_ arglist))

(defswig1 swig-defun ((name &optional (mangled-name name)
                            &key (type :operator) class arity)
                      arglist kwargs
		      &body body)
  (cl::let* ((symbol (id-convert-and-export name :type type
                          :arity arity :class class))
             (mangle (excl::if* (cl::string-equal name mangled-name)
                      then (id-convert-and-export 
				    (cl::cond
					  ((cl::eq type :setter) (cl::format nil "~A-set" name))
					  ((cl::eq type :getter) (cl::format nil "~A-get" name))
					  (t name))
				    :type :ff-operator :arity arity :class class)
                      else (cl::intern mangled-name)))
         (defun-args (maybe-reorder-args
                      symbol
		      (cl::mapcar #'cl::car (cl::and (cl::not (cl::equal arglist '(:void)))
					 (cl::loop as i in arglist
					       when (cl::eq (cl::car i) :p+)
					       collect (cl::cdr i))))))
	 (ffargs (cl::if (cl::equal arglist '(:void))
	 	      arglist
		    (cl::mapcar #'cl::cdr arglist)))
	 )
    (cl::when (swig-anyvarargs-p ffargs)
      (cl::setq ffargs '()))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
       (excl::compiler-let ((*record-xref-info* nil))
         (ff:def-foreign-call (,mangle ,mangled-name) ,ffargs ,@kwargs))
       (cl::macrolet ((swig-ff-call (&rest args)
                      (cl::cons ',mangle args)))
         (cl::defun ,symbol ,defun-args
           ,@body
           ,@(maybe-return-value symbol defun-args))))))

(defswig1 swig-defmethod ((name &optional (mangled-name name)
	  	                &key (type :operator) class arity)
                          ffargs kwargs
                          &body body)
  (cl::let* ((symbol (id-convert-and-export name :type type
                          :arity arity :class class))
         (mangle (cl::intern mangled-name))
         (defmethod-args (maybe-reorder-args
                          symbol
                          (cl::unless (cl::equal ffargs '(:void))
                            (cl::loop for (lisparg name dispatch) in ffargs
			    	  when (eq lisparg :p+)
                                  collect `(,name ,dispatch)))))
         (ffargs (cl::if (cl::equal ffargs '(:void))
                     ffargs
                     (cl::loop for (nil name nil . ffi) in ffargs
                           collect `(,name ,@ffi)))))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
       (excl::compiler-let ((*record-xref-info* nil))
         (ff:def-foreign-call (,mangle ,mangled-name) ,ffargs ,@kwargs))
       (cl::macrolet ((swig-ff-call (&rest args)
                      (cl::cons ',mangle args)))
         (cl::defmethod ,symbol ,defmethod-args
           ,@body
           ,@(maybe-return-value symbol defmethod-args))))))

(defswig1 swig-dispatcher ((name &key (type :operator) class arities))
  (cl::let ((symbol (id-convert-and-export name
                         :type type :class class)))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
       (cl::defun ,symbol (&rest args)
         (cl::case (cl::length args)
           ,@(cl::loop for arity in arities
                   for symbol-n = (id-convert-and-export name
                                           :type type :class class :arity arity)
                   collect `(,arity (cl::apply #',symbol-n args)))
	   (t (cl::error "No applicable wrapper-methods for foreign call ~a with args ~a of classes ~a" ',symbol args (cl::mapcar #'(cl::lambda (x) (cl::class-name (cl::class-of x))) args)))
	   )))))

(defswig2 swig-def-foreign-stub (name)
  (cl::let ((lsymbol (id-convert-and-export name :type :class))
	    (symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
	(ff:def-foreign-type ,symbol (:class ))
	(cl::defclass ,lsymbol (ff:foreign-pointer) ()))))

(defswig2 swig-def-foreign-class (name supers &rest rest)
  (cl::let ((lsymbol (id-convert-and-export name :type :class))
	    (symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
       (ff:def-foreign-type ,symbol ,@rest)
       (cl::defclass ,lsymbol ,supers
	 ((foreign-type :initform ',symbol :initarg :foreign-type
			:accessor foreign-pointer-type))))))

(defswig2 swig-def-foreign-type (name &rest rest)
  (cl::let ((symbol (id-convert-and-export name :type :type)))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
       (ff:def-foreign-type ,symbol ,@rest))))

(defswig2 swig-def-synonym-type (synonym of ff-synonym)
  `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
     (cl::setf (cl::find-class ',synonym) (cl::find-class ',of))
     (ff:def-foreign-type ,ff-synonym (:struct ))))

(cl::defun package-name-for-namespace (namespace)
  (excl::list-to-delimited-string
   (cl::cons *swig-module-name*
         (cl::mapcar #'(cl::lambda (name)
                     (cl::string
                      (cl::funcall *swig-identifier-converter*
                               name
                               :type :namespace)))
                 namespace))
   "."))

(cl::defmacro swig-defpackage (namespace)
  (cl::let* ((parent-namespaces (cl::maplist #'cl::reverse (cl::cdr (cl::reverse namespace))))
             (parent-strings (cl::mapcar #'package-name-for-namespace
                                 parent-namespaces))
             (string (package-name-for-namespace namespace)))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
      (cl::defpackage ,string
        (:use :swig :ff #+ignore '(:common-lisp :ff :excl)
              ,@parent-strings ,*swig-module-name*)
	(:import-from :cl :* :nil :t)))))

(cl::defmacro swig-in-package (namespace)
  `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
    (cl::in-package ,(package-name-for-namespace namespace))))

(defswig2 swig-defvar (name mangled-name &key type (ftype :unsigned-natural))
  (cl::let ((symbol (id-convert-and-export name :type type)))
    `(cl::eval-when (:compile-toplevel :load-toplevel :execute)
      (ff:def-foreign-variable (,symbol ,mangled-name) :type ,ftype))))

) ;; eval-when

(cl::eval-when (:compile-toplevel :execute)
  (cl::flet ((starts-with-p (str prefix)
              (cl::and (cl::>= (cl::length str) (cl::length prefix))
                (cl::string= str prefix :end1 (cl::length prefix)))))
    (cl::export (cl::loop for sym being each present-symbol of cl::*package*
                  when (cl::or (starts-with-p (cl::symbol-name sym) (cl::symbol-name :swig-))
                           (starts-with-p (cl::symbol-name sym) (cl::symbol-name :identifier-convert-)))
                  collect sym))))




#-64bit
(swig-def-foreign-class "longlong"
 (ff:foreign-pointer)
 (:struct (l1 :long) (l2 :long)))

#-64bit
(swig-def-foreign-class "ulonglong"
 (ff:foreign-pointer)
 (:struct (l1 :unsigned-long) (l2 :unsigned-long)))

(in-package :4ti2)
(swig-def-foreign-type "__SWIGACL_FwdReference"
  (* :void))
(swig-def-foreign-type "int32_t"
  :int)
(swig-def-foreign-type "int64_t"
  :long)
(swig-def-foreign-class "_4ti2_state"
 (ff:foreign-pointer )
  (:struct
   ))

(swig-def-foreign-class "_4ti2_matrix"
 (ff:foreign-pointer )
  (:struct
   ))

(swig-def-foreign-type "anontype0" :int)
(swig-defvar "_4ti2_PREC_INT_32" "ACL_ENUM____4ti2_PREC_INT_32__SWIG_0" :type :constant :ftype :signed-long)
(swig-defvar "_4ti2_PREC_INT_64" "ACL_ENUM____4ti2_PREC_INT_64__SWIG_0" :type :constant :ftype :signed-long)
(swig-defvar "_4ti2_PREC_INT_ARB" "ACL_ENUM____4ti2_PREC_INT_ARB__SWIG_0" :type :constant :ftype :signed-long)
(swig-def-foreign-type "_4ti2_precision"
  :int)
(swig-def-foreign-type "anontype1" :int)
(swig-defvar "_4ti2_FR" "ACL_ENUM____4ti2_FR__SWIG_0" :type :constant :ftype :signed-long)
(swig-defvar "_4ti2_LB" "ACL_ENUM____4ti2_LB__SWIG_0" :type :constant :ftype :signed-long)
(swig-defvar "_4ti2_UB" "ACL_ENUM____4ti2_UB__SWIG_0" :type :constant :ftype :signed-long)
(swig-defvar "_4ti2_DB" "ACL_ENUM____4ti2_DB__SWIG_0" :type :constant :ftype :signed-long)
(swig-defvar "_4ti2_FX" "ACL_ENUM____4ti2_FX__SWIG_0" :type :constant :ftype :signed-long)
(swig-def-foreign-type "_4ti2_constraint"
  :int)
(swig-def-foreign-type "anontype2" :int)
(swig-defvar "_4ti2_OK" "ACL_ENUM____4ti2_OK__SWIG_0" :type :constant :ftype :signed-long)
(swig-defvar "_4ti2_ERROR" "ACL_ENUM____4ti2_ERROR__SWIG_0" :type :constant :ftype :signed-long)
(swig-def-foreign-type "_4ti2_status"
  :int)
;; forward referenced stub.
(swig-def-foreign-class "_4ti2_int32_t" (ff:foreign-pointer) (:class ))

;; forward referenced stub.
(swig-def-foreign-class "_4ti2_int64_t" (ff:foreign-pointer) (:class ))


(swig-in-package ())

(swig-defun ("_4ti2_state" "ACL___new__4ti2_state__SWIG_0" :type :constructor)
  (:void)
  (:returning ((* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance '#.(swig-insert-id "_4ti2_state" () :type :class) :foreign-address address)))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_state" "ACL___delete__4ti2_state__SWIG_0" :type :destructor)
  ((:p+ PARM0_self  (* #.(swig-insert-id "_4ti2_state" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_self))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix" "ACL___new__4ti2_matrix__SWIG_0" :type :constructor)
  (:void)
  (:returning ((* #.(swig-insert-id "_4ti2_matrix" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
   (cl:let* ((address (swig-ff-call))
	  (new-inst (cl:make-instance '#.(swig-insert-id "_4ti2_matrix" () :type :class) :foreign-address address)))
     (cl:setq ACL_ffresult new-inst)) 
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix" "ACL___delete__4ti2_matrix__SWIG_0" :type :destructor)
  ((:p+ PARM0_self  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_self))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_qsolve_create_state" "ACL____4ti2_qsolve_create_state__SWIG_0" :type :function)
  ((:p+ PARM0_prec  #.(swig-insert-id "_4ti2_precision" () :type :type) ))
  (:returning ((* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_prec))
   (let* ((address (swig-ff-call SWIG_arg0))
	  (new-inst (make-instance (quote -4ti2-state)
				   :foreign-address address)))
    (when (and nil (not (zerop address)))
      (excl:schedule-finalization new-inst (function #.(swig-insert-id "_4ti2_state" () :type :destructor))))
    (setq ACL_ffresult new-inst)) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_rays_create_state" "ACL____4ti2_rays_create_state__SWIG_0" :type :function)
  ((:p+ PARM0_prec  #.(swig-insert-id "_4ti2_precision" () :type :type) ))
  (:returning ((* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_prec))
   (let* ((address (swig-ff-call SWIG_arg0))
	  (new-inst (make-instance (quote -4ti2-state)
				   :foreign-address address)))
    (when (and nil (not (zerop address)))
      (excl:schedule-finalization new-inst (function #.(swig-insert-id "_4ti2_state" () :type :destructor))))
    (setq ACL_ffresult new-inst)) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_circuits_create_state" "ACL____4ti2_circuits_create_state__SWIG_0" :type :function)
  ((:p+ PARM0_prec  #.(swig-insert-id "_4ti2_precision" () :type :type) ))
  (:returning ((* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_prec))
   (let* ((address (swig-ff-call SWIG_arg0))
	  (new-inst (make-instance (quote -4ti2-state)
				   :foreign-address address)))
    (when (and nil (not (zerop address)))
      (excl:schedule-finalization new-inst (function #.(swig-insert-id "_4ti2_state" () :type :destructor))))
    (setq ACL_ffresult new-inst)) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_zsolve_create_state" "ACL____4ti2_zsolve_create_state__SWIG_0" :type :function)
  ((:p+ PARM0_prec  #.(swig-insert-id "_4ti2_precision" () :type :type) ))
  (:returning ((* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_prec))
   (let* ((address (swig-ff-call SWIG_arg0))
	  (new-inst (make-instance (quote -4ti2-state)
				   :foreign-address address)))
    (when (and nil (not (zerop address)))
      (excl:schedule-finalization new-inst (function #.(swig-insert-id "_4ti2_state" () :type :destructor))))
    (setq ACL_ffresult new-inst)) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_hilbert_create_state" "ACL____4ti2_hilbert_create_state__SWIG_0" :type :function)
  ((:p+ PARM0_prec  #.(swig-insert-id "_4ti2_precision" () :type :type) ))
  (:returning ((* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_prec))
   (let* ((address (swig-ff-call SWIG_arg0))
	  (new-inst (make-instance (quote -4ti2-state)
				   :foreign-address address)))
    (when (and nil (not (zerop address)))
      (excl:schedule-finalization new-inst (function #.(swig-insert-id "_4ti2_state" () :type :destructor))))
    (setq ACL_ffresult new-inst)) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_graver_create_state" "ACL____4ti2_graver_create_state__SWIG_0" :type :function)
  ((:p+ PARM0_prec  #.(swig-insert-id "_4ti2_precision" () :type :type) ))
  (:returning ((* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_prec))
   (let* ((address (swig-ff-call SWIG_arg0))
	  (new-inst (make-instance (quote -4ti2-state)
				   :foreign-address address)))
    (when (and nil (not (zerop address)))
      (excl:schedule-finalization new-inst (function #.(swig-insert-id "_4ti2_state" () :type :destructor))))
    (setq ACL_ffresult new-inst)) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_state_set_options" "ACL____4ti2_state_set_options__SWIG_0" :type :function)
  ((:p+ PARM0_state  (* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   (:p- PARM1_argc  :int )
   (:p+ PARM2_argv  (* (* :char)) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_state))
    (let ((SWIG_arg1 nil))
      (labels ((swig-update-parallel-list-length (sequence)
		 (let ((length (length sequence)))
		   (if SWIG_arg1
		       (assert (= SWIG_arg1 length))
		       (setf SWIG_arg1 length)))))
        (declare (ignorable swig-update-parallel-list-length))
	  (swig-update-parallel-list-length PARM2_argv)
    (with-char*-vector (SWIG_arg2 PARM2_argv)
       (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2)))
     (check-4ti2-status status)) )  )) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_state_delete" "ACL____4ti2_state_delete__SWIG_0" :type :function)
  ((:p+ PARM0_state  (* #.(swig-insert-id "_4ti2_state" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_state))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_state_compute" "ACL____4ti2_state_compute__SWIG_0" :type :function)
  ((:p+ PARM0_state  (* #.(swig-insert-id "_4ti2_state" () :type :type)) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_state))
   (let ((status (swig-ff-call SWIG_arg0)))
     (check-4ti2-status status)) )
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_state_create_matrix" "ACL____4ti2_state_create_matrix__SWIG_0" :type :function)
  ((:p+ PARM0_state  (* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   (:p+ PARM1_num_rows  :int )
   (:p+ PARM2_num_cols  :int )
   (:p+ PARM3_name  (* :char) )
   (:p- PARM4_matrix  (* (* #.(swig-insert-id "_4ti2_matrix" () :type :type))) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_state))
  (cl::let ((SWIG_arg1 PARM1_num_rows))
  (cl::let ((SWIG_arg2 PARM2_num_cols))
  (cl::let ((SWIG_arg3 PARM3_name))
   (let ((SWIG_arg4 (ff:allocate-fobject '(* #.(swig-insert-id "_4ti2_matrix" () :type :type)) :c)))
      (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3 SWIG_arg4)))
     (check-4ti2-status status)) 
     (let* ((address (ff:fslot-value-typed (quote (* #.(swig-insert-id "_4ti2_matrix" () :type :type))) :c SWIG_arg4))
	    (object (make-instance (quote -4ti2-matrix)
				   :foreign-address address)))
       (unless (zerop address)
	 (excl:schedule-finalization object (function cl::identity)))
       (push object ACL_result)
       (ff:free-fobject SWIG_arg4))) ))))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_state_read_matrix" "ACL____4ti2_state_read_matrix__SWIG_0" :type :function)
  ((:p+ PARM0_state  (* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   (:p+ PARM1_filename  (* :char) )
   (:p+ PARM2_name  (* :char) )
   (:p- PARM3_matrix  (* (* #.(swig-insert-id "_4ti2_matrix" () :type :type))) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_state))
  (cl::let ((SWIG_arg1 PARM1_filename))
  (cl::let ((SWIG_arg2 PARM2_name))
   (let ((SWIG_arg3 (ff:allocate-fobject '(* #.(swig-insert-id "_4ti2_matrix" () :type :type)) :c)))
      (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))
     (check-4ti2-status status)) 
     (let* ((address (ff:fslot-value-typed (quote (* #.(swig-insert-id "_4ti2_matrix" () :type :type))) :c SWIG_arg3))
	    (object (make-instance (quote -4ti2-matrix)
				   :foreign-address address)))
       (unless (zerop address)
	 (excl:schedule-finalization object (function cl::identity)))
       (push object ACL_result)
       (ff:free-fobject SWIG_arg3))) )))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_state_get_matrix" "ACL____4ti2_state_get_matrix__SWIG_0" :type :function)
  ((:p+ PARM0_state  (* #.(swig-insert-id "_4ti2_state" () :type :type)) )
   (:p+ PARM1_name  (* :char) )
   (:p- PARM2_matrix  (* (* #.(swig-insert-id "_4ti2_matrix" () :type :type))) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_state))
  (cl::let ((SWIG_arg1 PARM1_name))
   (let ((SWIG_arg2 (ff:allocate-fobject '(* #.(swig-insert-id "_4ti2_matrix" () :type :type)) :c)))
      (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2)))
     (check-4ti2-status status)) 
     (let* ((address (ff:fslot-value-typed (quote (* #.(swig-insert-id "_4ti2_matrix" () :type :type))) :c SWIG_arg2))
	    (object (make-instance (quote -4ti2-matrix)
				   :foreign-address address)))
       (unless (zerop address)
	 (excl:schedule-finalization object (function cl::identity)))
       (push object ACL_result)
       (ff:free-fobject SWIG_arg2))) ))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_get_num_rows" "ACL____4ti2_matrix_get_num_rows__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_get_num_cols" "ACL____4ti2_matrix_get_num_cols__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) ))
  (:returning (:int )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (cl::setq ACL_ffresult (swig-ff-call SWIG_arg0)))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_write_to_stdout" "ACL____4ti2_matrix_write_to_stdout__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_write_to_stderr" "ACL____4ti2_matrix_write_to_stderr__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (swig-ff-call SWIG_arg0))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_write_to_file" "ACL____4ti2_matrix_write_to_file__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) )
   (:p+ PARM1_filename  (* :char) ))
  (:returning (:void )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (cl::let ((SWIG_arg1 PARM1_filename))
  (swig-ff-call SWIG_arg0 SWIG_arg1)))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_set_entry_int32_t" "ACL____4ti2_matrix_set_entry_int32_t__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) )
   (:p+ PARM1_r  :int )
   (:p+ PARM2_c  :int )
   (:p+ PARM3_value  (* #.(swig-insert-id "__SWIGACL_FwdReference" () :type :type)) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (cl::let ((SWIG_arg1 PARM1_r))
  (cl::let ((SWIG_arg2 PARM2_c))
  (cl::let ((SWIG_arg3 PARM3_value))
   (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))
     (check-4ti2-status status)) ))))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_get_entry_int32_t" "ACL____4ti2_matrix_get_entry_int32_t__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) )
   (:p+ PARM1_r  :int )
   (:p+ PARM2_c  :int )
   (:p+ PARM3_value  (* #.(swig-insert-id "__SWIGACL_FwdReference" () :type :type)) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (cl::let ((SWIG_arg1 PARM1_r))
  (cl::let ((SWIG_arg2 PARM2_c))
  (cl::let ((SWIG_arg3 PARM3_value))
   (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))
     (check-4ti2-status status)) ))))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_set_entry_int64_t" "ACL____4ti2_matrix_set_entry_int64_t__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) )
   (:p+ PARM1_r  :int )
   (:p+ PARM2_c  :int )
   (:p+ PARM3_value  (* #.(swig-insert-id "__SWIGACL_FwdReference" () :type :type)) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (cl::let ((SWIG_arg1 PARM1_r))
  (cl::let ((SWIG_arg2 PARM2_c))
  (cl::let ((SWIG_arg3 PARM3_value))
   (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))
     (check-4ti2-status status)) ))))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))


(swig-defun ("_4ti2_matrix_get_entry_int64_t" "ACL____4ti2_matrix_get_entry_int64_t__SWIG_0" :type :function)
  ((:p+ PARM0_matrix  (* #.(swig-insert-id "_4ti2_matrix" () :type :type)) )
   (:p+ PARM1_r  :int )
   (:p+ PARM2_c  :int )
   (:p+ PARM3_value  (* #.(swig-insert-id "__SWIGACL_FwdReference" () :type :type)) ))
  (:returning (#.(swig-insert-id "_4ti2_status" () :type :type) )
   :strings-convert t)
  (cl::let ((ACL_ffresult swig:*void*)
        ACL_result)
  (cl::let ((SWIG_arg0 PARM0_matrix))
  (cl::let ((SWIG_arg1 PARM1_r))
  (cl::let ((SWIG_arg2 PARM2_c))
  (cl::let ((SWIG_arg3 PARM3_value))
   (let ((status (swig-ff-call SWIG_arg0 SWIG_arg1 SWIG_arg2 SWIG_arg3)))
     (check-4ti2-status status)) ))))
  (cl::if (cl::eq ACL_ffresult swig:*void*)
    (cl::values-list ACL_result)
   (cl::values-list (cl::cons ACL_ffresult ACL_result)))))



(cl::in-package :swig)

(macrolet ((swig-do-export ()
                 `(dolist (s ',*swig-export-list*)
                    (apply #'export s))))
   (swig-do-export))

(setq *swig-export-list* nil)

