/****************************************************************************
** Shared Class code from reading file 'KDbVersionInfo.shared.h'
**
** Created
**      by: The Shared Data Compiler version 0.3
**
** WARNING! All changes made in this file will be lost!
*****************************************************************************/

/* This file is part of the KDE project
   Copyright (C) 2003-2010 Jarosław Staniek <staniek@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KDB_VERSIONINFO_H
#define KDB_VERSIONINFO_H

#include "kdb_export.h"
#include <QString>
#include <QSharedData>
#ifdef __GNUC__
# include <sys/types.h> // We use minor/major identifiers, force this include
                        // to have "#define minor gnu_dev_minor" from sys/sysmacros.h
                        // and immediately undefine that; same for major.
# undef minor
# undef major
#endif

/*! Provides version information.

 KDb::version() provides library version that can be compared to driver's plugin version
 KDbDriverMetaData::version().

 @note There is also KDbConnection::databaseVersion() that is retrieved from
 database/connection properties.

 @see KDbConnection::serverVersion()
*/
/*! @note objects of this class are implicitly shared, what means they have value semantics
          by offering copy-on-write behaviour to maximize resource usage and minimize copying.
          Only a pointer to the data is passed around. See <a href="http://doc.qt.io/qt-5/qshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: operator==, implicit
class KDB_EXPORT KDbVersionInfo
{
public:



    //! @internal data class used to implement implicitly shared class KDbVersionInfo.
    //! Provides thread-safe reference counting.
    class KDB_EXPORT Data : public QSharedData
    {
    public:
        Data()
        : major(0)
        , minor(0)
        , release(0)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , major(other.major)
         , minor(other.minor)
         , release(other.release)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        bool operator==(const Data &other) const {
            return major == other.major
                   && minor == other.minor
                   && release == other.release;
        }

        int major; //!< @see KDbVersionInfo::major(), KDbVersionInfo::setMajor()
        int minor; //!< @see KDbVersionInfo::minor(), KDbVersionInfo::setMinor()
        int release; //!< @see KDbVersionInfo::release(), KDbVersionInfo::setRelease()
    };

    KDbVersionInfo()
     : d(new Data)
    {
    }

    KDbVersionInfo(const KDbVersionInfo &other)
     : d(other.d)
    {
    }

    virtual ~KDbVersionInfo();

    /*!
    @return major version number, e.g. 1 for 1.8.9
    */
    int major() const {
        return d->major;
    }

    /*!
    Sets the major version number.
    */
    void setMajor(int major) {
        d->major = major;
    }

    /*!
    @return minor version number, e.g. 8 for 1.8.9
    */
    int minor() const {
        return d->minor;
    }

    /*!
    Sets the minor version number.
    */
    void setMinor(int minor) {
        d->minor = minor;
    }

    /*!
    @return release version number, e.g. 9 for 1.8.9
    */
    int release() const {
        return d->release;
    }

    /*!
    Sets the release version number.
    */
    void setRelease(int release) {
        d->release = release;
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KDbVersionInfo &other) const {
        return *d == *other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KDbVersionInfo &other) const {
        return !operator==(other);
    }


    inline KDbVersionInfo(int majorVersion, int minorVersion, int releaseVersion)
     : d(new Data)
    {
        d->major = majorVersion;
        d->minor = minorVersion;
        d->release = releaseVersion;
    }

    //! @return true if @a major and @a minor exatcly matches major and minor version of this info, respectively.
    inline bool matches(int major, int minor) const { return major == d->major && minor == d->minor; }

    //! @return true if this version info is null, i.e. all the version numbers are zero.
    bool isNull() const;

protected:
    QSharedDataPointer<Data> d;
};

/*! Provides information about version of given database backend.
*/
/*! @note objects of this class are implicitly shared, what means they have value semantics
          by offering copy-on-write behaviour to maximize resource usage and minimize copying.
          Only a pointer to the data is passed around. See <a href="http://doc.qt.io/qt-5/qshareddatapointer.html#details">Qt documentation</a>.
 */
//! @note This class has been generated using the following SDC class options: operator==, implicit
class KDB_EXPORT KDbServerVersionInfo
{
public:




    //! @internal data class used to implement implicitly shared class KDbServerVersionInfo.
    //! Provides thread-safe reference counting.
    class KDB_EXPORT Data : public QSharedData
    {
    public:
        Data()
        : major(0)
        , minor(0)
        , release(0)
        {
        }

        Data(const Data &other)
         : QSharedData(other)
         , major(other.major)
         , minor(other.minor)
         , release(other.release)
         , string(other.string)
        {
        }

        virtual ~Data() {}

        //! Clones the object with all attributes; the copy isn't shared with the original.
        virtual Data* clone() const { return new Data(*this); }

        bool operator==(const Data &other) const {
            return major == other.major
                   && minor == other.minor
                   && release == other.release
                   && string == other.string;
        }

        int major; //!< @see KDbServerVersionInfo::major(), KDbServerVersionInfo::setMajor()
        int minor; //!< @see KDbServerVersionInfo::minor(), KDbServerVersionInfo::setMinor()
        int release; //!< @see KDbServerVersionInfo::release(), KDbServerVersionInfo::setRelease()
        QString string; //!< @see KDbServerVersionInfo::string(), KDbServerVersionInfo::setString()
    };

    KDbServerVersionInfo()
     : d(new Data)
    {
    }

    KDbServerVersionInfo(const KDbServerVersionInfo &other)
     : d(other.d)
    {
    }

    virtual ~KDbServerVersionInfo();

    /*!
    @return major version number, e.g. 1 for 1.8.9
    */
    int major() const {
        return d->major;
    }

    /*!
    Sets the major version number.
    */
    void setMajor(int major) {
        d->major = major;
    }

    /*!
    @return minor version number, e.g. 8 for 1.8.9
    */
    int minor() const {
        return d->minor;
    }

    /*!
    Sets the minor version number.
    */
    void setMinor(int minor) {
        d->minor = minor;
    }

    /*!
    @return release version number, e.g. 9 for 1.8.9
    */
    int release() const {
        return d->release;
    }

    /*!
    Sets the release version number.
    */
    void setRelease(int release) {
        d->release = release;
    }

    /*!
    @return version string, as returned by the server.
    */
    QString string() const {
        return d->string;
    }

    /*!
    Sets the version string, as returned by the server.
    */
    void setString(const QString & string) {
        d->string = string;
    }

    //! @return true if this object is equal to @a other; otherwise returns false.
    bool operator==(const KDbServerVersionInfo &other) const {
        return *d == *other.d;
    }

    //! @return true if this object is not equal to @a other; otherwise returns false.
    bool operator!=(const KDbServerVersionInfo &other) const {
        return !operator==(other);
    }


    //! Clears the information - integers will be set to 0 and string to null
    void clear();

    //! @return true if this version info is null, i.e. all the version numbers are zero.
    bool isNull() const;

protected:
    QSharedDataPointer<Data> d;
};

#endif
