/*
 * Nasty preload hack to allow message catalogs to be read from the build tree.
 *
 * export LD_PRELOAD=/usr/lib/help2man/bindtextdomain.so
 * export TEXTDOMAIN=program
 * export LOCALEDIR=${DESTDIR}/usr/share/locale
 *
 * Copyright (C) 2012 Free Software Foundation, Inc.
 *
 * Copying and distribution of this file, with or without modification,
 * are permitted in any medium without royalty provided the copyright
 * notice and this notice are preserved.  This file is offered as-is,
 * without any warranty.
 *
 * Written by Brendan O'Dea <bod@debian.org>
 */

#define _GNU_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dlfcn.h>

#define PRELOAD "bindtextdomain.so"

static void die(char const *msg)
{
    fprintf(stderr, PRELOAD ": %s\n", msg);
    exit(1);
}

static char *e_textdomain = 0;
static char *e_localedir = 0;
static char *(*r_textdomain)(char const *) = 0;
static char *(*r_bindtextdomain)(char const *, char const *) = 0;
static char *(*r_bind_textdomain_codeset)(char const *, char const *) = 0;

#ifdef __CYGWIN__
static void *RTLD_NEXT = 0;
static char *(*r_gettext)(const char *) = 0;
static char *(*r_dgettext)(const char *, const char *) = 0;
static char *(*r_dcgettext)(const char *, const char *, int) = 0;
static char *(*r_ngettext)(const char *, const char *, unsigned long int) = 0;
static char *(*r_dngettext)(const char *, const char *, const char *,
                            unsigned long int) = 0;
static char *(*r_dcngettext)(const char *, const char *, const char *,
                             unsigned long int, int) = 0;
static char *(*r_setlocale)(int, const char *) = 0;

#define SYM(sym) libintl_ ## sym
#else
#define SYM(sym) sym
#endif

void setup()
{
    static int done = 0;
    if (done++)
        return;

#ifdef __CYGWIN__
    if (!(RTLD_NEXT = dlopen("/usr/bin/cygintl-8.dll", RTLD_LAZY)))
        die("libintl8 not found");
#endif

    if (!(e_textdomain = getenv("TEXTDOMAIN")))
	die("TEXTDOMAIN not set");

    if (!(e_localedir = getenv("LOCALEDIR")))
	die("LOCALEDIR not set");

    if (!(r_textdomain = dlsym(RTLD_NEXT, "textdomain")))
	die("can't find symbol \"textdomain\"");

    if (!(r_bindtextdomain = dlsym(RTLD_NEXT, "bindtextdomain")))
	die("can't find symbol \"bindtextdomain\"");

    if (!(r_bind_textdomain_codeset = dlsym(RTLD_NEXT,
    					    "bind_textdomain_codeset")))
	die("can't find symbol \"bind_textdomain_codeset\"");

#ifdef __CYGWIN__
    r_gettext = dlsym(RTLD_NEXT, "libintl_gettext");
    r_dgettext = dlsym(RTLD_NEXT, "libintl_dgettext");
    r_dcgettext = dlsym(RTLD_NEXT, "libintl_dcgettext");
    r_ngettext = dlsym(RTLD_NEXT, "libintl_ngettext");
    r_dngettext = dlsym(RTLD_NEXT, "libintl_dngettext");
    r_dcngettext = dlsym(RTLD_NEXT, "libintl_dcngettext");
    r_setlocale = dlsym(RTLD_NEXT, "libintl_setlocale");
#endif
}

char *SYM(textdomain)(char const *domainname)
{
    char *r;
    setup();
    r = r_textdomain(domainname);
    if (domainname && !strcmp(domainname, e_textdomain))
        r_bindtextdomain(domainname, e_localedir);

    return r;
}

char *SYM(bindtextdomain)(char const *domainname, char const *dirname)
{
    char const *dir = dirname;
    setup();
    if (domainname && !strcmp(domainname, e_textdomain))
        dir = e_localedir;

    return r_bindtextdomain(domainname, dir);
}

char *SYM(bind_textdomain_codeset)(char const *domainname, char const *codeset)
{
    char *r;
    setup();
    r = r_bind_textdomain_codeset(domainname, codeset);
    if (domainname && !strcmp(domainname, e_textdomain))
        r_bindtextdomain(domainname, e_localedir);

    return r;
}

#ifdef __CYGWIN__

char *libintl_gettext(const char *msgid)
{
    setup();
    return r_gettext(msgid);
}

char *libintl_dgettext (const char *domainname, const char *msgid)
{
    setup();
    return r_dgettext(domainname, msgid);
}

char *libintl_dcgettext (const char *domainname, const char *msgid,
                         int category)
{
    setup();
    return r_dcgettext (domainname, msgid, category);
}

char *libintl_ngettext (const char *msgid1, const char *msgid2,
                        unsigned long int n)
{
    setup();
    return r_ngettext (msgid1, msgid2, n);
}

char *libintl_dngettext (const char *domainname, const char *msgid1,
                         const char *msgid2, unsigned long int n)
{
    setup();
    return r_dngettext (domainname, msgid1, msgid2, n);
}

char *libintl_dcngettext (const char *domainname,
                          const char *msgid1, const char *msgid2,
                          unsigned long int n, int category)
{
    setup();
    return r_dcngettext (domainname, msgid1, msgid2, n, category);
}

char *libintl_setlocale (int i, const char *s)
{
    setup();
    return r_setlocale (i, s);
}

#endif
