// { dg-options "-D__STDCPP_WANT_MATH_SPEC_FUNCS__" }
// { dg-do run { target c++11 } }
//
// Copyright (C) 2016-2017 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

//  conf_hyperg
//  Compare against values generated by the GNU Scientific Library.
//  The GSL can be found on the web: http://www.gnu.org/software/gsl/
#include <limits>
#include <cmath>
#if defined(__TEST_DEBUG)
#  include <iostream>
#  define VERIFY(A) \
  if (!(A)) \
    { \
      std::cout << "line " << __LINE__ \
	<< "  max_abs_frac = " << max_abs_frac \
	<< std::endl; \
    }
#else
#  include <testsuite_hooks.h>
#endif
#include <specfun_testcase.h>


// Test data for a=0.0000000000000000, c=1.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data001[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 1.0000000000000000, 
	  10.000000000000000 },
};
const double toler001 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data002[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 2.0000000000000000, 
	  10.000000000000000 },
};
const double toler002 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=3.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data003[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 3.0000000000000000, 
	  10.000000000000000 },
};
const double toler003 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data004[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 4.0000000000000000, 
	  10.000000000000000 },
};
const double toler004 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=5.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data005[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 5.0000000000000000, 
	  10.000000000000000 },
};
const double toler005 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data006[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 6.0000000000000000, 
	  10.000000000000000 },
};
const double toler006 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=7.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data007[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 7.0000000000000000, 
	  10.000000000000000 },
};
const double toler007 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data008[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 8.0000000000000000, 
	  10.000000000000000 },
};
const double toler008 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=9.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data009[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 9.0000000000000000, 
	  10.000000000000000 },
};
const double toler009 = 2.5000000000000020e-13;

// Test data for a=0.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data010[21] =
{
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -10.000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  0.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  1.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  2.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  3.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  4.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  5.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  6.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  7.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  8.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  9.0000000000000000 },
  { 1.0000000000000000, 0.0000000000000000, 10.000000000000000, 
	  10.000000000000000 },
};
const double toler010 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=1.0000000000000000.
// max(|f - f_GSL|): 1.1823431123048067e-11
// max(|f - f_GSL| / |f_GSL|): 1.8179920344425603e-13
const testcase_conf_hyperg<double>
data011[21] =
{
  { 0.18354081260932842, 0.50000000000000000, 1.0000000000000000, 
	  -10.000000000000000 },
  { 0.19419827762834704, 0.50000000000000000, 1.0000000000000000, 
	  -9.0000000000000000 },
  { 0.20700192122398287, 0.50000000000000000, 1.0000000000000000, 
	  -8.0000000000000000 },
  { 0.22280243801078498, 0.50000000000000000, 1.0000000000000000, 
	  -7.0000000000000000 },
  { 0.24300035416182644, 0.50000000000000000, 1.0000000000000000, 
	  -6.0000000000000000 },
  { 0.27004644161220326, 0.50000000000000000, 1.0000000000000000, 
	  -5.0000000000000000 },
  { 0.30850832255367100, 0.50000000000000000, 1.0000000000000000, 
	  -4.0000000000000000 },
  { 0.36743360905415834, 0.50000000000000000, 1.0000000000000000, 
	  -3.0000000000000000 },
  { 0.46575960759364043, 0.50000000000000000, 1.0000000000000000, 
	  -2.0000000000000000 },
  { 0.64503527044915010, 0.50000000000000000, 1.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 1.0000000000000000, 
	  0.0000000000000000 },
  { 1.7533876543770910, 0.50000000000000000, 1.0000000000000000, 
	  1.0000000000000000 },
  { 3.4415238691253340, 0.50000000000000000, 1.0000000000000000, 
	  2.0000000000000000 },
  { 7.3801013214774045, 0.50000000000000000, 1.0000000000000000, 
	  3.0000000000000000 },
  { 16.843983681258987, 0.50000000000000000, 1.0000000000000000, 
	  4.0000000000000000 },
  { 40.078445504076420, 0.50000000000000000, 1.0000000000000000, 
	  5.0000000000000000 },
  { 98.033339697812693, 0.50000000000000000, 1.0000000000000000, 
	  6.0000000000000000 },
  { 244.33254130132138, 0.50000000000000000, 1.0000000000000000, 
	  7.0000000000000000 },
  { 617.06403040562441, 0.50000000000000000, 1.0000000000000000, 
	  8.0000000000000000 },
  { 1573.6049422133694, 0.50000000000000000, 1.0000000000000000, 
	  9.0000000000000000 },
  { 4042.7554308904109, 0.50000000000000000, 1.0000000000000000, 
	  10.000000000000000 },
};
const double toler011 = 1.0000000000000006e-11;

// Test data for a=0.50000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.0231815394945443e-12
// max(|f - f_GSL| / |f_GSL|): 2.3738284297189904e-15
const testcase_conf_hyperg<double>
data012[21] =
{
  { 0.34751307955387056, 0.50000000000000000, 2.0000000000000000, 
	  -10.000000000000000 },
  { 0.36515709992587503, 0.50000000000000000, 2.0000000000000000, 
	  -9.0000000000000000 },
  { 0.38575276072642301, 0.50000000000000000, 2.0000000000000000, 
	  -8.0000000000000000 },
  { 0.41020241461382889, 0.50000000000000000, 2.0000000000000000, 
	  -7.0000000000000000 },
  { 0.43982706745912625, 0.50000000000000000, 2.0000000000000000, 
	  -6.0000000000000000 },
  { 0.47663109114346930, 0.50000000000000000, 2.0000000000000000, 
	  -5.0000000000000000 },
  { 0.52377761180260862, 0.50000000000000000, 2.0000000000000000, 
	  -4.0000000000000000 },
  { 0.58647299647508400, 0.50000000000000000, 2.0000000000000000, 
	  -3.0000000000000000 },
  { 0.67367002294334866, 0.50000000000000000, 2.0000000000000000, 
	  -2.0000000000000000 },
  { 0.80145607363402172, 0.50000000000000000, 2.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 2.0000000000000000, 
	  0.0000000000000000 },
  { 1.3281918274866849, 0.50000000000000000, 2.0000000000000000, 
	  1.0000000000000000 },
  { 1.9052621465543667, 0.50000000000000000, 2.0000000000000000, 
	  2.0000000000000000 },
  { 2.9805776178019903, 0.50000000000000000, 2.0000000000000000, 
	  3.0000000000000000 },
  { 5.0906787293171654, 0.50000000000000000, 2.0000000000000000, 
	  4.0000000000000000 },
  { 9.4185650450425982, 0.50000000000000000, 2.0000000000000000, 
	  5.0000000000000000 },
  { 18.627776225142014, 0.50000000000000000, 2.0000000000000000, 
	  6.0000000000000000 },
  { 38.823513069699622, 0.50000000000000000, 2.0000000000000000, 
	  7.0000000000000000 },
  { 84.215287700426956, 0.50000000000000000, 2.0000000000000000, 
	  8.0000000000000000 },
  { 188.31125697734257, 0.50000000000000000, 2.0000000000000000, 
	  9.0000000000000000 },
  { 431.02590173952319, 0.50000000000000000, 2.0000000000000000, 
	  10.000000000000000 },
};
const double toler012 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=3.0000000000000000.
// max(|f - f_GSL|): 2.4158453015843406e-13
// max(|f - f_GSL| / |f_GSL|): 2.5938546713928606e-15
const testcase_conf_hyperg<double>
data013[21] =
{
  { 0.44148780381255504, 0.50000000000000000, 3.0000000000000000, 
	  -10.000000000000000 },
  { 0.46154890030153722, 0.50000000000000000, 3.0000000000000000, 
	  -9.0000000000000000 },
  { 0.48454520771815751, 0.50000000000000000, 3.0000000000000000, 
	  -8.0000000000000000 },
  { 0.51124131917976301, 0.50000000000000000, 3.0000000000000000, 
	  -7.0000000000000000 },
  { 0.54269682032387934, 0.50000000000000000, 3.0000000000000000, 
	  -6.0000000000000000 },
  { 0.58041888164962119, 0.50000000000000000, 3.0000000000000000, 
	  -5.0000000000000000 },
  { 0.62661371932049892, 0.50000000000000000, 3.0000000000000000, 
	  -4.0000000000000000 },
  { 0.68461315644636744, 0.50000000000000000, 3.0000000000000000, 
	  -3.0000000000000000 },
  { 0.75961975369132639, 0.50000000000000000, 3.0000000000000000, 
	  -2.0000000000000000 },
  { 0.86004702726553350, 0.50000000000000000, 3.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 3.0000000000000000, 
	  0.0000000000000000 },
  { 1.2039946674617061, 0.50000000000000000, 3.0000000000000000, 
	  1.0000000000000000 },
  { 1.5161750470251780, 0.50000000000000000, 3.0000000000000000, 
	  2.0000000000000000 },
  { 2.0187596221024697, 0.50000000000000000, 3.0000000000000000, 
	  3.0000000000000000 },
  { 2.8698033217756134, 0.50000000000000000, 3.0000000000000000, 
	  4.0000000000000000 },
  { 4.3821186043144449, 0.50000000000000000, 3.0000000000000000, 
	  5.0000000000000000 },
  { 7.1913541951514235, 0.50000000000000000, 3.0000000000000000, 
	  6.0000000000000000 },
  { 12.620107286909638, 0.50000000000000000, 3.0000000000000000, 
	  7.0000000000000000 },
  { 23.478926483036361, 0.50000000000000000, 3.0000000000000000, 
	  8.0000000000000000 },
  { 45.852981860749047, 0.50000000000000000, 3.0000000000000000, 
	  9.0000000000000000 },
  { 93.137265099245838, 0.50000000000000000, 3.0000000000000000, 
	  10.000000000000000 },
};
const double toler013 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 9.2370555648813024e-14
// max(|f - f_GSL| / |f_GSL|): 3.0116140491179400e-15
const testcase_conf_hyperg<double>
data014[21] =
{
  { 0.50723143075298205, 0.50000000000000000, 4.0000000000000000, 
	  -10.000000000000000 },
  { 0.52815420026166782, 0.50000000000000000, 4.0000000000000000, 
	  -9.0000000000000000 },
  { 0.55181651516426766, 0.50000000000000000, 4.0000000000000000, 
	  -8.0000000000000000 },
  { 0.57884767287882366, 0.50000000000000000, 4.0000000000000000, 
	  -7.0000000000000000 },
  { 0.61008828324275399, 0.50000000000000000, 4.0000000000000000, 
	  -6.0000000000000000 },
  { 0.64668451853659259, 0.50000000000000000, 4.0000000000000000, 
	  -5.0000000000000000 },
  { 0.69023479867386495, 0.50000000000000000, 4.0000000000000000, 
	  -4.0000000000000000 },
  { 0.74302365975861406, 0.50000000000000000, 4.0000000000000000, 
	  -3.0000000000000000 },
  { 0.80840402753201868, 0.50000000000000000, 4.0000000000000000, 
	  -2.0000000000000000 },
  { 0.89143814400301236, 0.50000000000000000, 4.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 4.0000000000000000, 
	  0.0000000000000000 },
  { 1.1467204168940972, 0.50000000000000000, 4.0000000000000000, 
	  1.0000000000000000 },
  { 1.3525055369951857, 0.50000000000000000, 4.0000000000000000, 
	  2.0000000000000000 },
  { 1.6530571499633475, 0.50000000000000000, 4.0000000000000000, 
	  3.0000000000000000 },
  { 2.1112387416058045, 0.50000000000000000, 4.0000000000000000, 
	  4.0000000000000000 },
  { 2.8410480336278199, 0.50000000000000000, 4.0000000000000000, 
	  5.0000000000000000 },
  { 4.0550562221854713, 0.50000000000000000, 4.0000000000000000, 
	  6.0000000000000000 },
  { 6.1601039044778583, 0.50000000000000000, 4.0000000000000000, 
	  7.0000000000000000 },
  { 9.9538034144264511, 0.50000000000000000, 4.0000000000000000, 
	  8.0000000000000000 },
  { 17.034704868473916, 0.50000000000000000, 4.0000000000000000, 
	  9.0000000000000000 },
  { 30.671445325428429, 0.50000000000000000, 4.0000000000000000, 
	  10.000000000000000 },
};
const double toler014 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=5.0000000000000000.
// max(|f - f_GSL|): 3.5527136788005009e-14
// max(|f - f_GSL| / |f_GSL|): 2.6053493022967024e-15
const testcase_conf_hyperg<double>
data015[21] =
{
  { 0.55715239162383312, 0.50000000000000000, 5.0000000000000000, 
	  -10.000000000000000 },
  { 0.57823135269518977, 0.50000000000000000, 5.0000000000000000, 
	  -9.0000000000000000 },
  { 0.60181688556797253, 0.50000000000000000, 5.0000000000000000, 
	  -8.0000000000000000 },
  { 0.62842688147829928, 0.50000000000000000, 5.0000000000000000, 
	  -7.0000000000000000 },
  { 0.65873434489521876, 0.50000000000000000, 5.0000000000000000, 
	  -6.0000000000000000 },
  { 0.69362872731932568, 0.50000000000000000, 5.0000000000000000, 
	  -5.0000000000000000 },
  { 0.73430741618153195, 0.50000000000000000, 5.0000000000000000, 
	  -4.0000000000000000 },
  { 0.78241503593870543, 0.50000000000000000, 5.0000000000000000, 
	  -3.0000000000000000 },
  { 0.84026013345254857, 0.50000000000000000, 5.0000000000000000, 
	  -2.0000000000000000 },
  { 0.91115976433208690, 0.50000000000000000, 5.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 5.0000000000000000, 
	  0.0000000000000000 },
  { 1.1141687602185972, 0.50000000000000000, 5.0000000000000000, 
	  1.0000000000000000 },
  { 1.2651443108002267, 0.50000000000000000, 5.0000000000000000, 
	  2.0000000000000000 },
  { 1.4712624889419719, 0.50000000000000000, 5.0000000000000000, 
	  3.0000000000000000 },
  { 1.7626460645467978, 0.50000000000000000, 5.0000000000000000, 
	  4.0000000000000000 },
  { 2.1901779328181084, 0.50000000000000000, 5.0000000000000000, 
	  5.0000000000000000 },
  { 2.8421796979457090, 0.50000000000000000, 5.0000000000000000, 
	  6.0000000000000000 },
  { 3.8760354586203540, 0.50000000000000000, 5.0000000000000000, 
	  7.0000000000000000 },
  { 5.5792940156545541, 0.50000000000000000, 5.0000000000000000, 
	  8.0000000000000000 },
  { 8.4898429002463303, 0.50000000000000000, 5.0000000000000000, 
	  9.0000000000000000 },
  { 13.636227878037948, 0.50000000000000000, 5.0000000000000000, 
	  10.000000000000000 },
};
const double toler015 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 2.1316282072803006e-14
// max(|f - f_GSL| / |f_GSL|): 2.8121163355193836e-15
const testcase_conf_hyperg<double>
data016[21] =
{
  { 0.59687111919499192, 0.50000000000000000, 6.0000000000000000, 
	  -10.000000000000000 },
  { 0.61774982278057033, 0.50000000000000000, 6.0000000000000000, 
	  -9.0000000000000000 },
  { 0.64090744485124451, 0.50000000000000000, 6.0000000000000000, 
	  -8.0000000000000000 },
  { 0.66677322792860194, 0.50000000000000000, 6.0000000000000000, 
	  -7.0000000000000000 },
  { 0.69589293014100995, 0.50000000000000000, 6.0000000000000000, 
	  -6.0000000000000000 },
  { 0.72897040032571048, 0.50000000000000000, 6.0000000000000000, 
	  -5.0000000000000000 },
  { 0.76692755408207181, 0.50000000000000000, 6.0000000000000000, 
	  -4.0000000000000000 },
  { 0.81099244559101891, 0.50000000000000000, 6.0000000000000000, 
	  -3.0000000000000000 },
  { 0.86283102401276535, 0.50000000000000000, 6.0000000000000000, 
	  -2.0000000000000000 },
  { 0.92474809223976406, 0.50000000000000000, 6.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 6.0000000000000000, 
	  0.0000000000000000 },
  { 1.0932912594628821, 0.50000000000000000, 6.0000000000000000, 
	  1.0000000000000000 },
  { 1.2115798426781204, 0.50000000000000000, 6.0000000000000000, 
	  2.0000000000000000 },
  { 1.3654106750890422, 0.50000000000000000, 6.0000000000000000, 
	  3.0000000000000000 },
  { 1.5711704305419896, 0.50000000000000000, 6.0000000000000000, 
	  4.0000000000000000 },
  { 1.8549798357448213, 0.50000000000000000, 6.0000000000000000, 
	  5.0000000000000000 },
  { 2.2595503871694826, 0.50000000000000000, 6.0000000000000000, 
	  6.0000000000000000 },
  { 2.8565038772876932, 0.50000000000000000, 6.0000000000000000, 
	  7.0000000000000000 },
  { 3.7689325736317838, 0.50000000000000000, 6.0000000000000000, 
	  8.0000000000000000 },
  { 5.2134738554699531, 0.50000000000000000, 6.0000000000000000, 
	  9.0000000000000000 },
  { 7.5801565545352858, 0.50000000000000000, 6.0000000000000000, 
	  10.000000000000000 },
};
const double toler016 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=7.0000000000000000.
// max(|f - f_GSL|): 1.2434497875801753e-14
// max(|f - f_GSL| / |f_GSL|): 2.5039514520700816e-15
const testcase_conf_hyperg<double>
data017[21] =
{
  { 0.62946736953754079, 0.50000000000000000, 7.0000000000000000, 
	  -10.000000000000000 },
  { 0.64995830964827050, 0.50000000000000000, 7.0000000000000000, 
	  -9.0000000000000000 },
  { 0.67251910396276349, 0.50000000000000000, 7.0000000000000000, 
	  -8.0000000000000000 },
  { 0.69750870596083636, 0.50000000000000000, 7.0000000000000000, 
	  -7.0000000000000000 },
  { 0.72537539174856436, 0.50000000000000000, 7.0000000000000000, 
	  -6.0000000000000000 },
  { 0.75668588434835504, 0.50000000000000000, 7.0000000000000000, 
	  -5.0000000000000000 },
  { 0.79216623458879654, 0.50000000000000000, 7.0000000000000000, 
	  -4.0000000000000000 },
  { 0.83276010491326891, 0.50000000000000000, 7.0000000000000000, 
	  -3.0000000000000000 },
  { 0.87971323375878940, 0.50000000000000000, 7.0000000000000000, 
	  -2.0000000000000000 },
  { 0.93469794840150233, 0.50000000000000000, 7.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 7.0000000000000000, 
	  0.0000000000000000 },
  { 1.0788040971101556, 0.50000000000000000, 7.0000000000000000, 
	  1.0000000000000000 },
  { 1.1756385516794761, 0.50000000000000000, 7.0000000000000000, 
	  2.0000000000000000 },
  { 1.2970810749099917, 0.50000000000000000, 7.0000000000000000, 
	  3.0000000000000000 },
  { 1.4529009687665237, 0.50000000000000000, 7.0000000000000000, 
	  4.0000000000000000 },
  { 1.6579437149144023, 0.50000000000000000, 7.0000000000000000, 
	  5.0000000000000000 },
  { 1.9353010489337754, 0.50000000000000000, 7.0000000000000000, 
	  6.0000000000000000 },
  { 2.3217458547039813, 0.50000000000000000, 7.0000000000000000, 
	  7.0000000000000000 },
  { 2.8772254607646022, 0.50000000000000000, 7.0000000000000000, 
	  8.0000000000000000 },
  { 3.7017478151936585, 0.50000000000000000, 7.0000000000000000, 
	  9.0000000000000000 },
  { 4.9659500648552237, 0.50000000000000000, 7.0000000000000000, 
	  10.000000000000000 },
};
const double toler017 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.0658141036401503e-14
// max(|f - f_GSL| / |f_GSL|): 2.9130420352995081e-15
const testcase_conf_hyperg<double>
data018[21] =
{
  { 0.65682574389601267, 0.50000000000000000, 8.0000000000000000, 
	  -10.000000000000000 },
  { 0.67683106084440448, 0.50000000000000000, 8.0000000000000000, 
	  -9.0000000000000000 },
  { 0.69871884883136481, 0.50000000000000000, 8.0000000000000000, 
	  -8.0000000000000000 },
  { 0.72279201131268422, 0.50000000000000000, 8.0000000000000000, 
	  -7.0000000000000000 },
  { 0.74942315553647221, 0.50000000000000000, 8.0000000000000000, 
	  -6.0000000000000000 },
  { 0.77907555763819503, 0.50000000000000000, 8.0000000000000000, 
	  -5.0000000000000000 },
  { 0.81233192258476394, 0.50000000000000000, 8.0000000000000000, 
	  -4.0000000000000000 },
  { 0.84993438521252052, 0.50000000000000000, 8.0000000000000000, 
	  -3.0000000000000000 },
  { 0.89284095871461888, 0.50000000000000000, 8.0000000000000000, 
	  -2.0000000000000000 },
  { 0.94230641231038748, 0.50000000000000000, 8.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 8.0000000000000000, 
	  0.0000000000000000 },
  { 1.0681796709163929, 0.50000000000000000, 8.0000000000000000, 
	  1.0000000000000000 },
  { 1.1499542693515108, 0.50000000000000000, 8.0000000000000000, 
	  2.0000000000000000 },
  { 1.2496850956712680, 0.50000000000000000, 8.0000000000000000, 
	  3.0000000000000000 },
  { 1.3736119127266571, 0.50000000000000000, 8.0000000000000000, 
	  4.0000000000000000 },
  { 1.5308465522192733, 0.50000000000000000, 8.0000000000000000, 
	  5.0000000000000000 },
  { 1.7349787653671505, 0.50000000000000000, 8.0000000000000000, 
	  6.0000000000000000 },
  { 2.0067188996039378, 0.50000000000000000, 8.0000000000000000, 
	  7.0000000000000000 },
  { 2.3783255204306939, 0.50000000000000000, 8.0000000000000000, 
	  8.0000000000000000 },
  { 2.9011558746255748, 0.50000000000000000, 8.0000000000000000, 
	  9.0000000000000000 },
  { 3.6587666457431234, 0.50000000000000000, 8.0000000000000000, 
	  10.000000000000000 },
};
const double toler018 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=9.0000000000000000.
// max(|f - f_GSL|): 7.1054273576010019e-15
// max(|f - f_GSL| / |f_GSL|): 2.4278329545502228e-15
const testcase_conf_hyperg<double>
data019[21] =
{
  { 0.68018654063475448, 0.50000000000000000, 9.0000000000000000, 
	  -10.000000000000000 },
  { 0.69965870094538662, 0.50000000000000000, 9.0000000000000000, 
	  -9.0000000000000000 },
  { 0.72084701020942776, 0.50000000000000000, 9.0000000000000000, 
	  -8.0000000000000000 },
  { 0.74400928635822572, 0.50000000000000000, 9.0000000000000000, 
	  -7.0000000000000000 },
  { 0.76945859319172982, 0.50000000000000000, 9.0000000000000000, 
	  -6.0000000000000000 },
  { 0.79757868270124699, 0.50000000000000000, 9.0000000000000000, 
	  -5.0000000000000000 },
  { 0.82884476649794248, 0.50000000000000000, 9.0000000000000000, 
	  -4.0000000000000000 },
  { 0.86385180214855140, 0.50000000000000000, 9.0000000000000000, 
	  -3.0000000000000000 },
  { 0.90335351612716308, 0.50000000000000000, 9.0000000000000000, 
	  -2.0000000000000000 },
  { 0.94831697594473685, 0.50000000000000000, 9.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 9.0000000000000000, 
	  0.0000000000000000 },
  { 1.0600626000640645, 0.50000000000000000, 9.0000000000000000, 
	  1.0000000000000000 },
  { 1.1307298999505393, 0.50000000000000000, 9.0000000000000000, 
	  2.0000000000000000 },
  { 1.2150341092774180, 0.50000000000000000, 9.0000000000000000, 
	  3.0000000000000000 },
  { 1.3171798023006840, 0.50000000000000000, 9.0000000000000000, 
	  4.0000000000000000 },
  { 1.4431045594091672, 0.50000000000000000, 9.0000000000000000, 
	  5.0000000000000000 },
  { 1.6013540635087158, 0.50000000000000000, 9.0000000000000000, 
	  6.0000000000000000 },
  { 1.8044714074708206, 0.50000000000000000, 9.0000000000000000, 
	  7.0000000000000000 },
  { 2.0712406108144257, 0.50000000000000000, 9.0000000000000000, 
	  8.0000000000000000 },
  { 2.4303714711293143, 0.50000000000000000, 9.0000000000000000, 
	  9.0000000000000000 },
  { 2.9266541358556295, 0.50000000000000000, 9.0000000000000000, 
	  10.000000000000000 },
};
const double toler019 = 2.5000000000000020e-13;

// Test data for a=0.50000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 5.3290705182007514e-15
// max(|f - f_GSL| / |f_GSL|): 2.1499735877560022e-15
const testcase_conf_hyperg<double>
data020[21] =
{
  { 0.70040954461104099, 0.50000000000000000, 10.000000000000000, 
	  -10.000000000000000 },
  { 0.71933025737654444, 0.50000000000000000, 10.000000000000000, 
	  -9.0000000000000000 },
  { 0.73981995758615027, 0.50000000000000000, 10.000000000000000, 
	  -8.0000000000000000 },
  { 0.76209985272755054, 0.50000000000000000, 10.000000000000000, 
	  -7.0000000000000000 },
  { 0.78643553963087975, 0.50000000000000000, 10.000000000000000, 
	  -6.0000000000000000 },
  { 0.81314860510626796, 0.50000000000000000, 10.000000000000000, 
	  -5.0000000000000000 },
  { 0.84263196565226672, 0.50000000000000000, 10.000000000000000, 
	  -4.0000000000000000 },
  { 0.87537037798496642, 0.50000000000000000, 10.000000000000000, 
	  -3.0000000000000000 },
  { 0.91196818568151450, 0.50000000000000000, 10.000000000000000, 
	  -2.0000000000000000 },
  { 0.95318731786229316, 0.50000000000000000, 10.000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 0.50000000000000000, 10.000000000000000, 
	  0.0000000000000000 },
  { 1.0536628587304602, 0.50000000000000000, 10.000000000000000, 
	  1.0000000000000000 },
  { 1.1158225648376323, 0.50000000000000000, 10.000000000000000, 
	  2.0000000000000000 },
  { 1.1886686247111011, 0.50000000000000000, 10.000000000000000, 
	  3.0000000000000000 },
  { 1.2751576744751334, 0.50000000000000000, 10.000000000000000, 
	  4.0000000000000000 },
  { 1.3793478044961116, 0.50000000000000000, 10.000000000000000, 
	  5.0000000000000000 },
  { 1.5069047234443802, 0.50000000000000000, 10.000000000000000, 
	  6.0000000000000000 },
  { 1.6658803233122232, 0.50000000000000000, 10.000000000000000, 
	  7.0000000000000000 },
  { 1.8679295659745196, 0.50000000000000000, 10.000000000000000, 
	  8.0000000000000000 },
  { 2.1302432955522050, 0.50000000000000000, 10.000000000000000, 
	  9.0000000000000000 },
  { 2.4786679001777303, 0.50000000000000000, 10.000000000000000, 
	  10.000000000000000 },
};
const double toler020 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=1.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data021[21] =
{
  { 4.5399929762484854e-05, 1.0000000000000000, 1.0000000000000000, 
	  -10.000000000000000 },
  { 0.00012340980408667956, 1.0000000000000000, 1.0000000000000000, 
	  -9.0000000000000000 },
  { 0.00033546262790251185, 1.0000000000000000, 1.0000000000000000, 
	  -8.0000000000000000 },
  { 0.00091188196555451624, 1.0000000000000000, 1.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0024787521766663585, 1.0000000000000000, 1.0000000000000000, 
	  -6.0000000000000000 },
  { 0.0067379469990854670, 1.0000000000000000, 1.0000000000000000, 
	  -5.0000000000000000 },
  { 0.018315638888734179, 1.0000000000000000, 1.0000000000000000, 
	  -4.0000000000000000 },
  { 0.049787068367863944, 1.0000000000000000, 1.0000000000000000, 
	  -3.0000000000000000 },
  { 0.13533528323661270, 1.0000000000000000, 1.0000000000000000, 
	  -2.0000000000000000 },
  { 0.36787944117144233, 1.0000000000000000, 1.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 1.0000000000000000, 
	  0.0000000000000000 },
  { 2.7182818284590451, 1.0000000000000000, 1.0000000000000000, 
	  1.0000000000000000 },
  { 7.3890560989306504, 1.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000 },
  { 20.085536923187668, 1.0000000000000000, 1.0000000000000000, 
	  3.0000000000000000 },
  { 54.598150033144236, 1.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000 },
  { 148.41315910257660, 1.0000000000000000, 1.0000000000000000, 
	  5.0000000000000000 },
  { 403.42879349273511, 1.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000 },
  { 1096.6331584284585, 1.0000000000000000, 1.0000000000000000, 
	  7.0000000000000000 },
  { 2980.9579870417283, 1.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000 },
  { 8103.0839275753842, 1.0000000000000000, 1.0000000000000000, 
	  9.0000000000000000 },
  { 22026.465794806718, 1.0000000000000000, 1.0000000000000000, 
	  10.000000000000000 },
};
const double toler021 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 4.5474735088646412e-13
// max(|f - f_GSL| / |f_GSL|): 2.3593310407919961e-15
const testcase_conf_hyperg<double>
data022[21] =
{
  { 0.099995460007023751, 1.0000000000000000, 2.0000000000000000, 
	  -10.000000000000000 },
  { 0.11109739891065704, 1.0000000000000000, 2.0000000000000000, 
	  -9.0000000000000000 },
  { 0.12495806717151219, 1.0000000000000000, 2.0000000000000000, 
	  -8.0000000000000000 },
  { 0.14272687400492079, 1.0000000000000000, 2.0000000000000000, 
	  -7.0000000000000000 },
  { 0.16625354130388895, 1.0000000000000000, 2.0000000000000000, 
	  -6.0000000000000000 },
  { 0.19865241060018290, 1.0000000000000000, 2.0000000000000000, 
	  -5.0000000000000000 },
  { 0.24542109027781644, 1.0000000000000000, 2.0000000000000000, 
	  -4.0000000000000000 },
  { 0.31673764387737868, 1.0000000000000000, 2.0000000000000000, 
	  -3.0000000000000000 },
  { 0.43233235838169365, 1.0000000000000000, 2.0000000000000000, 
	  -2.0000000000000000 },
  { 0.63212055882855767, 1.0000000000000000, 2.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 2.0000000000000000, 
	  0.0000000000000000 },
  { 1.7182818284590451, 1.0000000000000000, 2.0000000000000000, 
	  1.0000000000000000 },
  { 3.1945280494653252, 1.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000 },
  { 6.3618456410625557, 1.0000000000000000, 2.0000000000000000, 
	  3.0000000000000000 },
  { 13.399537508286059, 1.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000 },
  { 29.482631820515319, 1.0000000000000000, 2.0000000000000000, 
	  5.0000000000000000 },
  { 67.071465582122514, 1.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000 },
  { 156.51902263263693, 1.0000000000000000, 2.0000000000000000, 
	  7.0000000000000000 },
  { 372.49474838021604, 1.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000 },
  { 900.23154750837602, 1.0000000000000000, 2.0000000000000000, 
	  9.0000000000000000 },
  { 2202.5465794806719, 1.0000000000000000, 2.0000000000000000, 
	  10.000000000000000 },
};
const double toler022 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=3.0000000000000000.
// max(|f - f_GSL|): 5.6843418860808015e-14
// max(|f - f_GSL| / |f_GSL|): 7.7098432236368283e-16
const testcase_conf_hyperg<double>
data023[21] =
{
  { 0.18000090799859525, 1.0000000000000000, 3.0000000000000000, 
	  -10.000000000000000 },
  { 0.19753391135318732, 1.0000000000000000, 3.0000000000000000, 
	  -9.0000000000000000 },
  { 0.21876048320712196, 1.0000000000000000, 3.0000000000000000, 
	  -8.0000000000000000 },
  { 0.24493517885573690, 1.0000000000000000, 3.0000000000000000, 
	  -7.0000000000000000 },
  { 0.27791548623203705, 1.0000000000000000, 3.0000000000000000, 
	  -6.0000000000000000 },
  { 0.32053903575992687, 1.0000000000000000, 3.0000000000000000, 
	  -5.0000000000000000 },
  { 0.37728945486109178, 1.0000000000000000, 3.0000000000000000, 
	  -4.0000000000000000 },
  { 0.45550823741508090, 1.0000000000000000, 3.0000000000000000, 
	  -3.0000000000000000 },
  { 0.56766764161830641, 1.0000000000000000, 3.0000000000000000, 
	  -2.0000000000000000 },
  { 0.73575888234288467, 1.0000000000000000, 3.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 3.0000000000000000, 
	  0.0000000000000000 },
  { 1.4365636569180902, 1.0000000000000000, 3.0000000000000000, 
	  1.0000000000000000 },
  { 2.1945280494653252, 1.0000000000000000, 3.0000000000000000, 
	  2.0000000000000000 },
  { 3.5745637607083705, 1.0000000000000000, 3.0000000000000000, 
	  3.0000000000000000 },
  { 6.1997687541430295, 1.0000000000000000, 3.0000000000000000, 
	  4.0000000000000000 },
  { 11.393052728206127, 1.0000000000000000, 3.0000000000000000, 
	  5.0000000000000000 },
  { 22.023821860707507, 1.0000000000000000, 3.0000000000000000, 
	  6.0000000000000000 },
  { 44.434006466467693, 1.0000000000000000, 3.0000000000000000, 
	  7.0000000000000000 },
  { 92.873687095054009, 1.0000000000000000, 3.0000000000000000, 
	  8.0000000000000000 },
  { 199.82923277963911, 1.0000000000000000, 3.0000000000000000, 
	  9.0000000000000000 },
  { 440.30931589613436, 1.0000000000000000, 3.0000000000000000, 
	  10.000000000000000 },
};
const double toler023 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 8.5265128291212022e-14
// max(|f - f_GSL| / |f_GSL|): 8.2495029364968388e-16
const testcase_conf_hyperg<double>
data024[21] =
{
  { 0.24599972760042138, 1.0000000000000000, 4.0000000000000000, 
	  -10.000000000000000 },
  { 0.26748869621560417, 1.0000000000000000, 4.0000000000000000, 
	  -9.0000000000000000 },
  { 0.29296481879732927, 1.0000000000000000, 4.0000000000000000, 
	  -8.0000000000000000 },
  { 0.32359920906182715, 1.0000000000000000, 4.0000000000000000, 
	  -7.0000000000000000 },
  { 0.36104225688398156, 1.0000000000000000, 4.0000000000000000, 
	  -6.0000000000000000 },
  { 0.40767657854404388, 1.0000000000000000, 4.0000000000000000, 
	  -5.0000000000000000 },
  { 0.46703290885418114, 1.0000000000000000, 4.0000000000000000, 
	  -4.0000000000000000 },
  { 0.54449176258491916, 1.0000000000000000, 4.0000000000000000, 
	  -3.0000000000000000 },
  { 0.64849853757254050, 1.0000000000000000, 4.0000000000000000, 
	  -2.0000000000000000 },
  { 0.79272335297134611, 1.0000000000000000, 4.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 4.0000000000000000, 
	  0.0000000000000000 },
  { 1.3096909707542714, 1.0000000000000000, 4.0000000000000000, 
	  1.0000000000000000 },
  { 1.7917920741979876, 1.0000000000000000, 4.0000000000000000, 
	  2.0000000000000000 },
  { 2.5745637607083705, 1.0000000000000000, 4.0000000000000000, 
	  3.0000000000000000 },
  { 3.8998265656072717, 1.0000000000000000, 4.0000000000000000, 
	  4.0000000000000000 },
  { 6.2358316369236775, 1.0000000000000000, 4.0000000000000000, 
	  5.0000000000000000 },
  { 10.511910930353745, 1.0000000000000000, 4.0000000000000000, 
	  6.0000000000000000 },
  { 18.614574199914728, 1.0000000000000000, 4.0000000000000000, 
	  7.0000000000000000 },
  { 34.452632660645271, 1.0000000000000000, 4.0000000000000000, 
	  8.0000000000000000 },
  { 66.276410926546333, 1.0000000000000000, 4.0000000000000000, 
	  9.0000000000000000 },
  { 131.79279476884014, 1.0000000000000000, 4.0000000000000000, 
	  10.000000000000000 },
};
const double toler024 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=5.0000000000000000.
// max(|f - f_GSL|): 6.3948846218409017e-14
// max(|f - f_GSL| / |f_GSL|): 1.3470358174143053e-15
const testcase_conf_hyperg<double>
data025[21] =
{
  { 0.30160010895983153, 1.0000000000000000, 5.0000000000000000, 
	  -10.000000000000000 },
  { 0.32556057945973133, 1.0000000000000000, 5.0000000000000000, 
	  -9.0000000000000000 },
  { 0.35351759060133559, 1.0000000000000000, 5.0000000000000000, 
	  -8.0000000000000000 },
  { 0.38651473767895589, 1.0000000000000000, 5.0000000000000000, 
	  -7.0000000000000000 },
  { 0.42597182874401246, 1.0000000000000000, 5.0000000000000000, 
	  -6.0000000000000000 },
  { 0.47385873716476473, 1.0000000000000000, 5.0000000000000000, 
	  -5.0000000000000000 },
  { 0.53296709114581886, 1.0000000000000000, 5.0000000000000000, 
	  -4.0000000000000000 },
  { 0.60734431655344123, 1.0000000000000000, 5.0000000000000000, 
	  -3.0000000000000000 },
  { 0.70300292485491900, 1.0000000000000000, 5.0000000000000000, 
	  -2.0000000000000000 },
  { 0.82910658811461568, 1.0000000000000000, 5.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 5.0000000000000000, 
	  0.0000000000000000 },
  { 1.2387638830170857, 1.0000000000000000, 5.0000000000000000, 
	  1.0000000000000000 },
  { 1.5835841483959754, 1.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000 },
  { 2.0994183476111612, 1.0000000000000000, 5.0000000000000000, 
	  3.0000000000000000 },
  { 2.8998265656072730, 1.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000 },
  { 4.1886653095389432, 1.0000000000000000, 5.0000000000000000, 
	  5.0000000000000000 },
  { 6.3412739535691678, 1.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000 },
  { 10.065470971379844, 1.0000000000000000, 5.0000000000000000, 
	  7.0000000000000000 },
  { 16.726316330322632, 1.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000 },
  { 29.011738189576135, 1.0000000000000000, 5.0000000000000000, 
	  9.0000000000000000 },
  { 52.317117907536058, 1.0000000000000000, 5.0000000000000000, 
	  10.000000000000000 },
};
const double toler025 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 8.1712414612411521e-14
// max(|f - f_GSL| / |f_GSL|): 3.1846065384904241e-15
const testcase_conf_hyperg<double>
data026[21] =
{
  { 0.34919994552008421, 1.0000000000000000, 6.0000000000000000, 
	  -10.000000000000000 },
  { 0.37468856696681579, 1.0000000000000000, 6.0000000000000000, 
	  -9.0000000000000000 },
  { 0.40405150587416555, 1.0000000000000000, 6.0000000000000000, 
	  -8.0000000000000000 },
  { 0.43820375880074558, 1.0000000000000000, 6.0000000000000000, 
	  -7.0000000000000000 },
  { 0.47835680937998981, 1.0000000000000000, 6.0000000000000000, 
	  -6.0000000000000000 },
  { 0.52614126283523510, 1.0000000000000000, 6.0000000000000000, 
	  -5.0000000000000000 },
  { 0.58379113606772659, 1.0000000000000000, 6.0000000000000000, 
	  -4.0000000000000000 },
  { 0.65442613907759817, 1.0000000000000000, 6.0000000000000000, 
	  -3.0000000000000000 },
  { 0.74249268786270239, 1.0000000000000000, 6.0000000000000000, 
	  -2.0000000000000000 },
  { 0.85446705942692136, 1.0000000000000000, 6.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 6.0000000000000000, 
	  0.0000000000000000 },
  { 1.1938194150854282, 1.0000000000000000, 6.0000000000000000, 
	  1.0000000000000000 },
  { 1.4589603709899384, 1.0000000000000000, 6.0000000000000000, 
	  2.0000000000000000 },
  { 1.8323639126852680, 1.0000000000000000, 6.0000000000000000, 
	  3.0000000000000000 },
  { 2.3747832070090902, 1.0000000000000000, 6.0000000000000000, 
	  4.0000000000000000 },
  { 3.1886653095389423, 1.0000000000000000, 6.0000000000000000, 
	  5.0000000000000000 },
  { 4.4510616279743056, 1.0000000000000000, 6.0000000000000000, 
	  6.0000000000000000 },
  { 6.4753364081284595, 1.0000000000000000, 6.0000000000000000, 
	  7.0000000000000000 },
  { 9.8289477064516344, 1.0000000000000000, 6.0000000000000000, 
	  8.0000000000000000 },
  { 15.562076771986721, 1.0000000000000000, 6.0000000000000000, 
	  9.0000000000000000 },
  { 25.658558953767979, 1.0000000000000000, 6.0000000000000000, 
	  10.000000000000000 },
};
const double toler026 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=7.0000000000000000.
// max(|f - f_GSL|): 4.6185277824406512e-14
// max(|f - f_GSL| / |f_GSL|): 3.1216529394518888e-15
const testcase_conf_hyperg<double>
data027[21] =
{
  { 0.39048003268794934, 1.0000000000000000, 7.0000000000000000, 
	  -10.000000000000000 },
  { 0.41687428868878917, 1.0000000000000000, 7.0000000000000000, 
	  -9.0000000000000000 },
  { 0.44696137059437591, 1.0000000000000000, 7.0000000000000000, 
	  -8.0000000000000000 },
  { 0.48153963531364674, 1.0000000000000000, 7.0000000000000000, 
	  -7.0000000000000000 },
  { 0.52164319062001030, 1.0000000000000000, 7.0000000000000000, 
	  -6.0000000000000000 },
  { 0.56863048459771781, 1.0000000000000000, 7.0000000000000000, 
	  -5.0000000000000000 },
  { 0.62431329589841034, 1.0000000000000000, 7.0000000000000000, 
	  -4.0000000000000000 },
  { 0.69114772184480389, 1.0000000000000000, 7.0000000000000000, 
	  -3.0000000000000000 },
  { 0.77252193641189282, 1.0000000000000000, 7.0000000000000000, 
	  -2.0000000000000000 },
  { 0.87319764343847150, 1.0000000000000000, 7.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 7.0000000000000000, 
	  0.0000000000000000 },
  { 1.1629164905125695, 1.0000000000000000, 7.0000000000000000, 
	  1.0000000000000000 },
  { 1.3768811129698151, 1.0000000000000000, 7.0000000000000000, 
	  2.0000000000000000 },
  { 1.6647278253705360, 1.0000000000000000, 7.0000000000000000, 
	  3.0000000000000000 },
  { 2.0621748105136359, 1.0000000000000000, 7.0000000000000000, 
	  4.0000000000000000 },
  { 2.6263983714467289, 1.0000000000000000, 7.0000000000000000, 
	  5.0000000000000000 },
  { 3.4510616279743087, 1.0000000000000000, 7.0000000000000000, 
	  6.0000000000000000 },
  { 4.6931454926815466, 1.0000000000000000, 7.0000000000000000, 
	  7.0000000000000000 },
  { 6.6217107798387467, 1.0000000000000000, 7.0000000000000000, 
	  8.0000000000000000 },
  { 9.7080511813245050, 1.0000000000000000, 7.0000000000000000, 
	  9.0000000000000000 },
  { 14.795135372260791, 1.0000000000000000, 7.0000000000000000, 
	  10.000000000000000 },
};
const double toler027 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 1.5099033134902129e-14
// max(|f - f_GSL| / |f_GSL|): 3.0695349768517519e-15
const testcase_conf_hyperg<double>
data028[21] =
{
  { 0.42666397711843551, 1.0000000000000000, 8.0000000000000000, 
	  -10.000000000000000 },
  { 0.45354221990871935, 1.0000000000000000, 8.0000000000000000, 
	  -9.0000000000000000 },
  { 0.48390880072992098, 1.0000000000000000, 8.0000000000000000, 
	  -8.0000000000000000 },
  { 0.51846036468635348, 1.0000000000000000, 8.0000000000000000, 
	  -7.0000000000000000 },
  { 0.55808294427665472, 1.0000000000000000, 8.0000000000000000, 
	  -6.0000000000000000 },
  { 0.60391732156319500, 1.0000000000000000, 8.0000000000000000, 
	  -5.0000000000000000 },
  { 0.65745173217778197, 1.0000000000000000, 8.0000000000000000, 
	  -4.0000000000000000 },
  { 0.72065531569545760, 1.0000000000000000, 8.0000000000000000, 
	  -3.0000000000000000 },
  { 0.79617322255837530, 1.0000000000000000, 8.0000000000000000, 
	  -2.0000000000000000 },
  { 0.88761649593069913, 1.0000000000000000, 8.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 8.0000000000000000, 
	  0.0000000000000000 },
  { 1.1404154335879861, 1.0000000000000000, 8.0000000000000000, 
	  1.0000000000000000 },
  { 1.3190838953943527, 1.0000000000000000, 8.0000000000000000, 
	  2.0000000000000000 },
  { 1.5510315925312508, 1.0000000000000000, 8.0000000000000000, 
	  3.0000000000000000 },
  { 1.8588059183988626, 1.0000000000000000, 8.0000000000000000, 
	  4.0000000000000000 },
  { 2.2769577200254218, 1.0000000000000000, 8.0000000000000000, 
	  5.0000000000000000 },
  { 2.8595718993033583, 1.0000000000000000, 8.0000000000000000, 
	  6.0000000000000000 },
  { 3.6931454926815390, 1.0000000000000000, 8.0000000000000000, 
	  7.0000000000000000 },
  { 4.9189969323589047, 1.0000000000000000, 8.0000000000000000, 
	  8.0000000000000000 },
  { 6.7729286965857236, 1.0000000000000000, 8.0000000000000000, 
	  9.0000000000000000 },
  { 9.6565947605825802, 1.0000000000000000, 8.0000000000000000, 
	  10.000000000000000 },
};
const double toler028 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=9.0000000000000000.
// max(|f - f_GSL|): 2.1316282072803006e-14
// max(|f - f_GSL| / |f_GSL|): 3.0780408841975893e-15
const testcase_conf_hyperg<double>
data029[21] =
{
  { 0.45866881830525147, 1.0000000000000000, 9.0000000000000000, 
	  -10.000000000000000 },
  { 0.48574024897002727, 1.0000000000000000, 9.0000000000000000, 
	  -9.0000000000000000 },
  { 0.51609119927007907, 1.0000000000000000, 9.0000000000000000, 
	  -8.0000000000000000 },
  { 0.55033101178702448, 1.0000000000000000, 9.0000000000000000, 
	  -7.0000000000000000 },
  { 0.58922274096446048, 1.0000000000000000, 9.0000000000000000, 
	  -6.0000000000000000 },
  { 0.63373228549888794, 1.0000000000000000, 9.0000000000000000, 
	  -5.0000000000000000 },
  { 0.68509653564443607, 1.0000000000000000, 9.0000000000000000, 
	  -4.0000000000000000 },
  { 0.74491915814544640, 1.0000000000000000, 9.0000000000000000, 
	  -3.0000000000000000 },
  { 0.81530710976649901, 1.0000000000000000, 9.0000000000000000, 
	  -2.0000000000000000 },
  { 0.89906803255440670, 1.0000000000000000, 9.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 9.0000000000000000, 
	  0.0000000000000000 },
  { 1.1233234687038898, 1.0000000000000000, 9.0000000000000000, 
	  1.0000000000000000 },
  { 1.2763355815774109, 1.0000000000000000, 9.0000000000000000, 
	  2.0000000000000000 },
  { 1.4694175800833351, 1.0000000000000000, 9.0000000000000000, 
	  3.0000000000000000 },
  { 1.7176118367977251, 1.0000000000000000, 9.0000000000000000, 
	  4.0000000000000000 },
  { 2.0431323520406743, 1.0000000000000000, 9.0000000000000000, 
	  5.0000000000000000 },
  { 2.4794291990711450, 1.0000000000000000, 9.0000000000000000, 
	  6.0000000000000000 },
  { 3.0778805630646149, 1.0000000000000000, 9.0000000000000000, 
	  7.0000000000000000 },
  { 3.9189969323588909, 1.0000000000000000, 9.0000000000000000, 
	  8.0000000000000000 },
  { 5.1314921747428537, 1.0000000000000000, 9.0000000000000000, 
	  9.0000000000000000 },
  { 6.9252758084660471, 1.0000000000000000, 9.0000000000000000, 
	  10.000000000000000 },
};
const double toler029 = 2.5000000000000020e-13;

// Test data for a=1.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.5987211554602254e-14
// max(|f - f_GSL| / |f_GSL|): 2.9979310614742812e-15
const testcase_conf_hyperg<double>
data030[21] =
{
  { 0.48719806352527351, 1.0000000000000000, 10.000000000000000, 
	  -10.000000000000000 },
  { 0.51425975102997290, 1.0000000000000000, 10.000000000000000, 
	  -9.0000000000000000 },
  { 0.54439740082116106, 1.0000000000000000, 10.000000000000000, 
	  -8.0000000000000000 },
  { 0.57814584198811136, 1.0000000000000000, 10.000000000000000, 
	  -7.0000000000000000 },
  { 0.61616588855330934, 1.0000000000000000, 10.000000000000000, 
	  -6.0000000000000000 },
  { 0.65928188610200156, 1.0000000000000000, 10.000000000000000, 
	  -5.0000000000000000 },
  { 0.70853279480001885, 1.0000000000000000, 10.000000000000000, 
	  -4.0000000000000000 },
  { 0.76524252556366068, 1.0000000000000000, 10.000000000000000, 
	  -3.0000000000000000 },
  { 0.83111800605075459, 1.0000000000000000, 10.000000000000000, 
	  -2.0000000000000000 },
  { 0.90838770701033944, 1.0000000000000000, 10.000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 1.0000000000000000, 10.000000000000000, 
	  0.0000000000000000 },
  { 1.1099112183350075, 1.0000000000000000, 10.000000000000000, 
	  1.0000000000000000 },
  { 1.2435101170983485, 1.0000000000000000, 10.000000000000000, 
	  2.0000000000000000 },
  { 1.4082527402500060, 1.0000000000000000, 10.000000000000000, 
	  3.0000000000000000 },
  { 1.6146266327948817, 1.0000000000000000, 10.000000000000000, 
	  4.0000000000000000 },
  { 1.8776382336732149, 1.0000000000000000, 10.000000000000000, 
	  5.0000000000000000 },
  { 2.2191437986067180, 1.0000000000000000, 10.000000000000000, 
	  6.0000000000000000 },
  { 2.6715607239402184, 1.0000000000000000, 10.000000000000000, 
	  7.0000000000000000 },
  { 3.2838715489037495, 1.0000000000000000, 10.000000000000000, 
	  8.0000000000000000 },
  { 4.1314921747428688, 1.0000000000000000, 10.000000000000000, 
	  9.0000000000000000 },
  { 5.3327482276194447, 1.0000000000000000, 10.000000000000000, 
	  10.000000000000000 },
};
const double toler030 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=1.0000000000000000.
// max(|f - f_GSL|): 1.8189894035458565e-12
// max(|f - f_GSL| / |f_GSL|): 1.2338590067901998e-14
const testcase_conf_hyperg<double>
data031[20] =
{
  { -0.00040859936786236367, 2.0000000000000000, 1.0000000000000000, 
	  -10.000000000000000 },
  { -0.00098727843269343649, 2.0000000000000000, 1.0000000000000000, 
	  -9.0000000000000000 },
  { -0.0023482383953175828, 2.0000000000000000, 1.0000000000000000, 
	  -8.0000000000000000 },
  { -0.0054712917933270972, 2.0000000000000000, 1.0000000000000000, 
	  -7.0000000000000000 },
  { -0.012393760883331793, 2.0000000000000000, 1.0000000000000000, 
	  -6.0000000000000000 },
  { -0.026951787996341868, 2.0000000000000000, 1.0000000000000000, 
	  -5.0000000000000000 },
  { -0.054946916666202536, 2.0000000000000000, 1.0000000000000000, 
	  -4.0000000000000000 },
  { -0.099574136735727889, 2.0000000000000000, 1.0000000000000000, 
	  -3.0000000000000000 },
  { -0.13533528323661270, 2.0000000000000000, 1.0000000000000000, 
	  -2.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 1.0000000000000000, 
	  0.0000000000000000 },
  { 5.4365636569180902, 2.0000000000000000, 1.0000000000000000, 
	  1.0000000000000000 },
  { 22.167168296791949, 2.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000 },
  { 80.342147692750672, 2.0000000000000000, 1.0000000000000000, 
	  3.0000000000000000 },
  { 272.99075016572118, 2.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000 },
  { 890.47895461545954, 2.0000000000000000, 1.0000000000000000, 
	  5.0000000000000000 },
  { 2824.0015544491457, 2.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000 },
  { 8773.0652674276680, 2.0000000000000000, 1.0000000000000000, 
	  7.0000000000000000 },
  { 26828.621883375556, 2.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000 },
  { 81030.839275753839, 2.0000000000000000, 1.0000000000000000, 
	  9.0000000000000000 },
  { 242291.12374287390, 2.0000000000000000, 1.0000000000000000, 
	  10.000000000000000 },
};
const double toler031 = 1.0000000000000008e-12;

// Test data for a=2.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data032[21] =
{
  { 4.5399929762484854e-05, 2.0000000000000000, 2.0000000000000000, 
	  -10.000000000000000 },
  { 0.00012340980408667956, 2.0000000000000000, 2.0000000000000000, 
	  -9.0000000000000000 },
  { 0.00033546262790251185, 2.0000000000000000, 2.0000000000000000, 
	  -8.0000000000000000 },
  { 0.00091188196555451624, 2.0000000000000000, 2.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0024787521766663585, 2.0000000000000000, 2.0000000000000000, 
	  -6.0000000000000000 },
  { 0.0067379469990854670, 2.0000000000000000, 2.0000000000000000, 
	  -5.0000000000000000 },
  { 0.018315638888734179, 2.0000000000000000, 2.0000000000000000, 
	  -4.0000000000000000 },
  { 0.049787068367863944, 2.0000000000000000, 2.0000000000000000, 
	  -3.0000000000000000 },
  { 0.13533528323661270, 2.0000000000000000, 2.0000000000000000, 
	  -2.0000000000000000 },
  { 0.36787944117144233, 2.0000000000000000, 2.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 2.0000000000000000, 
	  0.0000000000000000 },
  { 2.7182818284590451, 2.0000000000000000, 2.0000000000000000, 
	  1.0000000000000000 },
  { 7.3890560989306504, 2.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000 },
  { 20.085536923187668, 2.0000000000000000, 2.0000000000000000, 
	  3.0000000000000000 },
  { 54.598150033144236, 2.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000 },
  { 148.41315910257660, 2.0000000000000000, 2.0000000000000000, 
	  5.0000000000000000 },
  { 403.42879349273511, 2.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000 },
  { 1096.6331584284585, 2.0000000000000000, 2.0000000000000000, 
	  7.0000000000000000 },
  { 2980.9579870417283, 2.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000 },
  { 8103.0839275753842, 2.0000000000000000, 2.0000000000000000, 
	  9.0000000000000000 },
  { 22026.465794806718, 2.0000000000000000, 2.0000000000000000, 
	  10.000000000000000 },
};
const double toler032 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=3.0000000000000000.
// max(|f - f_GSL|): 9.0949470177292824e-13
// max(|f - f_GSL| / |f_GSL|): 3.7963989072999328e-15
const testcase_conf_hyperg<double>
data033[21] =
{
  { 0.019990012015452256, 2.0000000000000000, 3.0000000000000000, 
	  -10.000000000000000 },
  { 0.024660886468126749, 2.0000000000000000, 3.0000000000000000, 
	  -9.0000000000000000 },
  { 0.031155651135902421, 2.0000000000000000, 3.0000000000000000, 
	  -8.0000000000000000 },
  { 0.040518569154104643, 2.0000000000000000, 3.0000000000000000, 
	  -7.0000000000000000 },
  { 0.054591596375740861, 2.0000000000000000, 3.0000000000000000, 
	  -6.0000000000000000 },
  { 0.076765785440438966, 2.0000000000000000, 3.0000000000000000, 
	  -5.0000000000000000 },
  { 0.11355272569454113, 2.0000000000000000, 3.0000000000000000, 
	  -4.0000000000000000 },
  { 0.17796705033967650, 2.0000000000000000, 3.0000000000000000, 
	  -3.0000000000000000 },
  { 0.29699707514508100, 2.0000000000000000, 3.0000000000000000, 
	  -2.0000000000000000 },
  { 0.52848223531423066, 2.0000000000000000, 3.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 3.0000000000000000, 
	  0.0000000000000000 },
  { 2.0000000000000000, 2.0000000000000000, 3.0000000000000000, 
	  1.0000000000000000 },
  { 4.1945280494653261, 2.0000000000000000, 3.0000000000000000, 
	  2.0000000000000000 },
  { 9.1491275214167409, 2.0000000000000000, 3.0000000000000000, 
	  3.0000000000000000 },
  { 20.599306262429089, 2.0000000000000000, 3.0000000000000000, 
	  4.0000000000000000 },
  { 47.572210912824517, 2.0000000000000000, 3.0000000000000000, 
	  5.0000000000000000 },
  { 112.11910930353754, 2.0000000000000000, 3.0000000000000000, 
	  6.0000000000000000 },
  { 268.60403879880613, 2.0000000000000000, 3.0000000000000000, 
	  7.0000000000000000 },
  { 652.11580966537815, 2.0000000000000000, 3.0000000000000000, 
	  8.0000000000000000 },
  { 1600.6338622371129, 2.0000000000000000, 3.0000000000000000, 
	  9.0000000000000000 },
  { 3964.7838430652091, 2.0000000000000000, 3.0000000000000000, 
	  10.000000000000000 },
};
const double toler033 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 2.2737367544323206e-12
// max(|f - f_GSL| / |f_GSL|): 2.1504262426495913e-15
const testcase_conf_hyperg<double>
data034[21] =
{
  { 0.048003268794942940, 2.0000000000000000, 4.0000000000000000, 
	  -10.000000000000000 },
  { 0.057624341628353531, 2.0000000000000000, 4.0000000000000000, 
	  -9.0000000000000000 },
  { 0.070351812026707330, 2.0000000000000000, 4.0000000000000000, 
	  -8.0000000000000000 },
  { 0.087607118443556703, 2.0000000000000000, 4.0000000000000000, 
	  -7.0000000000000000 },
  { 0.11166194492814813, 2.0000000000000000, 4.0000000000000000, 
	  -6.0000000000000000 },
  { 0.14626395019169278, 2.0000000000000000, 4.0000000000000000, 
	  -5.0000000000000000 },
  { 0.19780254687491294, 2.0000000000000000, 4.0000000000000000, 
	  -4.0000000000000000 },
  { 0.27754118707540443, 2.0000000000000000, 4.0000000000000000, 
	  -3.0000000000000000 },
  { 0.40600584970983811, 2.0000000000000000, 4.0000000000000000, 
	  -2.0000000000000000 },
  { 0.62182994108596168, 2.0000000000000000, 4.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 4.0000000000000000, 
	  0.0000000000000000 },
  { 1.6903090292457283, 2.0000000000000000, 4.0000000000000000, 
	  1.0000000000000000 },
  { 3.0000000000000000, 2.0000000000000000, 4.0000000000000000, 
	  2.0000000000000000 },
  { 5.5745637607083705, 2.0000000000000000, 4.0000000000000000, 
	  3.0000000000000000 },
  { 10.799653131214550, 2.0000000000000000, 4.0000000000000000, 
	  4.0000000000000000 },
  { 21.707494910771043, 2.0000000000000000, 4.0000000000000000, 
	  5.0000000000000000 },
  { 45.047643721415056, 2.0000000000000000, 4.0000000000000000, 
	  6.0000000000000000 },
  { 96.072870999573695, 2.0000000000000000, 4.0000000000000000, 
	  7.0000000000000000 },
  { 209.71579596387159, 2.0000000000000000, 4.0000000000000000, 
	  8.0000000000000000 },
  { 466.93487648582493, 2.0000000000000000, 4.0000000000000000, 
	  9.0000000000000000 },
  { 1057.3423581507243, 2.0000000000000000, 4.0000000000000000, 
	  10.000000000000000 },
};
const double toler034 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=5.0000000000000000.
// max(|f - f_GSL|): 2.8421709430404007e-13
// max(|f - f_GSL| / |f_GSL|): 2.6284159117427726e-15
const testcase_conf_hyperg<double>
data035[21] =
{
  { 0.079198583522191404, 2.0000000000000000, 5.0000000000000000, 
	  -10.000000000000000 },
  { 0.093273046483222530, 2.0000000000000000, 5.0000000000000000, 
	  -9.0000000000000000 },
  { 0.11130650338531098, 2.0000000000000000, 5.0000000000000000, 
	  -8.0000000000000000 },
  { 0.13485262321044020, 2.0000000000000000, 5.0000000000000000, 
	  -7.0000000000000000 },
  { 0.16625354130388895, 2.0000000000000000, 5.0000000000000000, 
	  -6.0000000000000000 },
  { 0.20913010268188095, 2.0000000000000000, 5.0000000000000000, 
	  -5.0000000000000000 },
  { 0.26923036197926808, 2.0000000000000000, 5.0000000000000000, 
	  -4.0000000000000000 },
  { 0.35593410067935288, 2.0000000000000000, 5.0000000000000000, 
	  -3.0000000000000000 },
  { 0.48498537572540468, 2.0000000000000000, 5.0000000000000000, 
	  -2.0000000000000000 },
  { 0.68357364754153715, 2.0000000000000000, 5.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 5.0000000000000000, 
	  0.0000000000000000 },
  { 1.5224722339658285, 2.0000000000000000, 5.0000000000000000, 
	  1.0000000000000000 },
  { 2.4164158516040235, 2.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000 },
  { 4.0000000000000009, 2.0000000000000000, 5.0000000000000000, 
	  3.0000000000000000 },
  { 6.8998265656072721, 2.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000 },
  { 12.377330619077886, 2.0000000000000000, 5.0000000000000000, 
	  5.0000000000000000 },
  { 23.023821860707503, 2.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000 },
  { 44.261883885519374, 2.0000000000000000, 5.0000000000000000, 
	  7.0000000000000000 },
  { 87.631581651613160, 2.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000 },
  { 178.07042913745681, 2.0000000000000000, 5.0000000000000000, 
	  9.0000000000000000 },
  { 370.21982535275242, 2.0000000000000000, 5.0000000000000000, 
	  10.000000000000000 },
};
const double toler035 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 5.1159076974727213e-13
// max(|f - f_GSL| / |f_GSL|): 3.2185367269036845e-15
const testcase_conf_hyperg<double>
data036[21] =
{
  { 0.11120076271882003, 2.0000000000000000, 6.0000000000000000, 
	  -10.000000000000000 },
  { 0.12904862943139384, 2.0000000000000000, 6.0000000000000000, 
	  -9.0000000000000000 },
  { 0.15138192951001525, 2.0000000000000000, 6.0000000000000000, 
	  -8.0000000000000000 },
  { 0.17975865319179699, 2.0000000000000000, 6.0000000000000000, 
	  -7.0000000000000000 },
  { 0.21643190620010283, 2.0000000000000000, 6.0000000000000000, 
	  -6.0000000000000000 },
  { 0.26472863448288397, 2.0000000000000000, 6.0000000000000000, 
	  -5.0000000000000000 },
  { 0.32967091145818839, 2.0000000000000000, 6.0000000000000000, 
	  -4.0000000000000000 },
  { 0.41901702645681349, 2.0000000000000000, 6.0000000000000000, 
	  -3.0000000000000000 },
  { 0.54504387282378575, 2.0000000000000000, 6.0000000000000000, 
	  -2.0000000000000000 },
  { 0.72766470286539298, 2.0000000000000000, 6.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 6.0000000000000000, 
	  0.0000000000000000 },
  { 1.4185417547437151, 2.0000000000000000, 6.0000000000000000, 
	  1.0000000000000000 },
  { 2.0820792580201224, 2.0000000000000000, 6.0000000000000000, 
	  2.0000000000000000 },
  { 3.1676360873147318, 2.0000000000000000, 6.0000000000000000, 
	  3.0000000000000000 },
  { 4.9999999999999982, 2.0000000000000000, 6.0000000000000000, 
	  4.0000000000000000 },
  { 8.1886653095389406, 2.0000000000000000, 6.0000000000000000, 
	  5.0000000000000000 },
  { 13.902123255948611, 2.0000000000000000, 6.0000000000000000, 
	  6.0000000000000000 },
  { 24.426009224385378, 2.0000000000000000, 6.0000000000000000, 
	  7.0000000000000000 },
  { 44.315790825806538, 2.0000000000000000, 6.0000000000000000, 
	  8.0000000000000000 },
  { 82.810383859933609, 2.0000000000000000, 6.0000000000000000, 
	  9.0000000000000000 },
  { 158.95135372260788, 2.0000000000000000, 6.0000000000000000, 
	  10.000000000000000 },
};
const double toler036 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=7.0000000000000000.
// max(|f - f_GSL|): 2.1316282072803006e-13
// max(|f - f_GSL| / |f_GSL|): 2.6653456287428861e-15
const testcase_conf_hyperg<double>
data037[21] =
{
  { 0.14279950968075855, 2.0000000000000000, 7.0000000000000000, 
	  -10.000000000000000 },
  { 0.16375995835694801, 2.0000000000000000, 7.0000000000000000, 
	  -9.0000000000000000 },
  { 0.18950218227311263, 2.0000000000000000, 7.0000000000000000, 
	  -8.0000000000000000 },
  { 0.22152437623624174, 2.0000000000000000, 7.0000000000000000, 
	  -7.0000000000000000 },
  { 0.26192490317988687, 2.0000000000000000, 7.0000000000000000, 
	  -6.0000000000000000 },
  { 0.31369515402282139, 2.0000000000000000, 7.0000000000000000, 
	  -5.0000000000000000 },
  { 0.38118033691430731, 2.0000000000000000, 7.0000000000000000, 
	  -4.0000000000000000 },
  { 0.47081822524156886, 2.0000000000000000, 7.0000000000000000, 
	  -3.0000000000000000 },
  { 0.59234644511675072, 2.0000000000000000, 7.0000000000000000, 
	  -2.0000000000000000 },
  { 0.76081413936917086, 2.0000000000000000, 7.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 7.0000000000000000, 
	  0.0000000000000000 },
  { 1.3483340379497220, 2.0000000000000000, 7.0000000000000000, 
	  1.0000000000000000 },
  { 1.8693566610905543, 2.0000000000000000, 7.0000000000000000, 
	  2.0000000000000000 },
  { 2.6705443492589280, 2.0000000000000000, 7.0000000000000000, 
	  3.0000000000000000 },
  { 3.9378251894863650, 2.0000000000000000, 7.0000000000000000, 
	  4.0000000000000000 },
  { 6.0000000000000018, 2.0000000000000000, 7.0000000000000000, 
	  5.0000000000000000 },
  { 9.4510616279743118, 2.0000000000000000, 7.0000000000000000, 
	  6.0000000000000000 },
  { 15.386290985363093, 2.0000000000000000, 7.0000000000000000, 
	  7.0000000000000000 },
  { 25.865132339516240, 2.0000000000000000, 7.0000000000000000, 
	  8.0000000000000000 },
  { 44.832204725298020, 2.0000000000000000, 7.0000000000000000, 
	  9.0000000000000000 },
  { 79.975676861303953, 2.0000000000000000, 7.0000000000000000, 
	  10.000000000000000 },
};
const double toler037 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 3.9079850466805510e-14
// max(|f - f_GSL| / |f_GSL|): 2.3209326942856951e-15
const testcase_conf_hyperg<double>
data038[21] =
{
  { 0.17337636610503362, 2.0000000000000000, 8.0000000000000000, 
	  -10.000000000000000 },
  { 0.19686670136921000, 2.0000000000000000, 8.0000000000000000, 
	  -9.0000000000000000 },
  { 0.22527678978110538, 2.0000000000000000, 8.0000000000000000, 
	  -8.0000000000000000 },
  { 0.26001525907740475, 2.0000000000000000, 8.0000000000000000, 
	  -7.0000000000000000 },
  { 0.30300466868014397, 2.0000000000000000, 8.0000000000000000, 
	  -6.0000000000000000 },
  { 0.35690946280485503, 2.0000000000000000, 8.0000000000000000, 
	  -5.0000000000000000 },
  { 0.42548267822218039, 2.0000000000000000, 8.0000000000000000, 
	  -4.0000000000000000 },
  { 0.51410215874088183, 2.0000000000000000, 8.0000000000000000, 
	  -3.0000000000000000 },
  { 0.63061421953299790, 2.0000000000000000, 8.0000000000000000, 
	  -2.0000000000000000 },
  { 0.78668452848510595, 2.0000000000000000, 8.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 8.0000000000000000, 
	  0.0000000000000000 },
  { 1.2979228320600693, 2.0000000000000000, 8.0000000000000000, 
	  1.0000000000000000 },
  { 1.7236644184225898, 2.0000000000000000, 8.0000000000000000, 
	  2.0000000000000000 },
  { 2.3469052224062485, 2.0000000000000000, 8.0000000000000000, 
	  3.0000000000000000 },
  { 3.2823881632022749, 2.0000000000000000, 8.0000000000000000, 
	  4.0000000000000000 },
  { 4.7230422799745782, 2.0000000000000000, 8.0000000000000000, 
	  5.0000000000000000 },
  { 7.0000000000000009, 2.0000000000000000, 8.0000000000000000, 
	  6.0000000000000000 },
  { 10.693145492681536, 2.0000000000000000, 8.0000000000000000, 
	  7.0000000000000000 },
  { 16.837993864717809, 2.0000000000000000, 8.0000000000000000, 
	  8.0000000000000000 },
  { 27.318786089757172, 2.0000000000000000, 8.0000000000000000, 
	  9.0000000000000000 },
  { 45.626379042330321, 2.0000000000000000, 8.0000000000000000, 
	  10.000000000000000 },
};
const double toler038 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=9.0000000000000000.
// max(|f - f_GSL|): 6.3948846218409017e-14
// max(|f - f_GSL| / |f_GSL|): 2.2223112918020366e-15
const testcase_conf_hyperg<double>
data039[21] =
{
  { 0.20263008881072142, 2.0000000000000000, 9.0000000000000000, 
	  -10.000000000000000 },
  { 0.22815601647956382, 2.0000000000000000, 9.0000000000000000, 
	  -9.0000000000000000 },
  { 0.25863201094881560, 2.0000000000000000, 9.0000000000000000, 
	  -8.0000000000000000 },
  { 0.29536583498165569, 2.0000000000000000, 9.0000000000000000, 
	  -7.0000000000000000 },
  { 0.34010436746201422, 2.0000000000000000, 9.0000000000000000, 
	  -6.0000000000000000 },
  { 0.39521257401334392, 2.0000000000000000, 9.0000000000000000, 
	  -5.0000000000000000 },
  { 0.46393810791120338, 2.0000000000000000, 9.0000000000000000, 
	  -4.0000000000000000 },
  { 0.55080841854553553, 2.0000000000000000, 9.0000000000000000, 
	  -3.0000000000000000 },
  { 0.66223601210150940, 2.0000000000000000, 9.0000000000000000, 
	  -2.0000000000000000 },
  { 0.80745573956474603, 2.0000000000000000, 9.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 9.0000000000000000, 
	  0.0000000000000000 },
  { 1.2600591877766618, 2.0000000000000000, 9.0000000000000000, 
	  1.0000000000000000 },
  { 1.6183220921129462, 2.0000000000000000, 9.0000000000000000, 
	  2.0000000000000000 },
  { 2.1223296796666578, 2.0000000000000000, 9.0000000000000000, 
	  3.0000000000000000 },
  { 2.8471644896068233, 2.0000000000000000, 9.0000000000000000, 
	  4.0000000000000000 },
  { 3.9137352959186495, 2.0000000000000000, 9.0000000000000000, 
	  5.0000000000000000 },
  { 5.5205708009288541, 2.0000000000000000, 9.0000000000000000, 
	  6.0000000000000000 },
  { 7.9999999999999982, 2.0000000000000000, 9.0000000000000000, 
	  7.0000000000000000 },
  { 11.918996932358892, 2.0000000000000000, 9.0000000000000000, 
	  8.0000000000000000 },
  { 18.262984349485706, 2.0000000000000000, 9.0000000000000000, 
	  9.0000000000000000 },
  { 28.775827425398141, 2.0000000000000000, 9.0000000000000000, 
	  10.000000000000000 },
};
const double toler039 = 2.5000000000000020e-13;

// Test data for a=2.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 3.5527136788005009e-14
// max(|f - f_GSL| / |f_GSL|): 1.8065720775912871e-15
const testcase_conf_hyperg<double>
data040[21] =
{
  { 0.23043485654507717, 2.0000000000000000, 10.000000000000000, 
	  -10.000000000000000 },
  { 0.25758423249046342, 2.0000000000000000, 10.000000000000000, 
	  -9.0000000000000000 },
  { 0.28964158686142122, 2.0000000000000000, 10.000000000000000, 
	  -8.0000000000000000 },
  { 0.32781237017833142, 2.0000000000000000, 10.000000000000000, 
	  -7.0000000000000000 },
  { 0.37367756025366927, 2.0000000000000000, 10.000000000000000, 
	  -6.0000000000000000 },
  { 0.42933548067397925, 2.0000000000000000, 10.000000000000000, 
	  -5.0000000000000000 },
  { 0.49760646239977369, 2.0000000000000000, 10.000000000000000, 
	  -4.0000000000000000 },
  { 0.58233221879973318, 2.0000000000000000, 10.000000000000000, 
	  -3.0000000000000000 },
  { 0.68881993949245379, 2.0000000000000000, 10.000000000000000, 
	  -2.0000000000000000 },
  { 0.82451063690694526, 2.0000000000000000, 10.000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 2.0000000000000000, 10.000000000000000, 
	  0.0000000000000000 },
  { 1.2306214716549471, 2.0000000000000000, 10.000000000000000, 
	  1.0000000000000000 },
  { 1.5389392974099088, 2.0000000000000000, 10.000000000000000, 
	  2.0000000000000000 },
  { 1.9587362987499699, 2.0000000000000000, 10.000000000000000, 
	  3.0000000000000000 },
  { 2.5414934688204727, 2.0000000000000000, 10.000000000000000, 
	  4.0000000000000000 },
  { 3.3670852989803555, 2.0000000000000000, 10.000000000000000, 
	  5.0000000000000000 },
  { 4.5617124027865650, 2.0000000000000000, 10.000000000000000, 
	  6.0000000000000000 },
  { 6.3284392760597825, 2.0000000000000000, 10.000000000000000, 
	  7.0000000000000000 },
  { 9.0000000000000036, 2.0000000000000000, 10.000000000000000, 
	  8.0000000000000000 },
  { 13.131492174742865, 2.0000000000000000, 10.000000000000000, 
	  9.0000000000000000 },
  { 19.665496455238888, 2.0000000000000000, 10.000000000000000, 
	  10.000000000000000 },
};
const double toler040 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, c=1.0000000000000000.
// max(|f - f_GSL|): 1.1175870895385742e-08
// max(|f - f_GSL| / |f_GSL|): 5.3427429899548483e-12
const testcase_conf_hyperg<double>
data041[21] =
{
  { 0.00049939922738733290, 5.0000000000000000, 1.0000000000000000, 
	  -10.000000000000000 },
  { -0.00057077034390089253, 5.0000000000000000, 1.0000000000000000, 
	  -9.0000000000000000 },
  { -0.0032428054030576147, 5.0000000000000000, 1.0000000000000000, 
	  -8.0000000000000000 },
  { -0.0078649819529077025, 5.0000000000000000, 1.0000000000000000, 
	  -7.0000000000000000 },
  { -0.012393760883331793, 5.0000000000000000, 1.0000000000000000, 
	  -6.0000000000000000 },
  { -0.0087031815404853934, 5.0000000000000000, 1.0000000000000000, 
	  -5.0000000000000000 },
  { 0.018315638888832021, 5.0000000000000000, 1.0000000000000000, 
	  -4.0000000000000000 },
  { 0.068457219005814696, 5.0000000000000000, 1.0000000000000000, 
	  -3.0000000000000000 },
  { 0.045111761078875295, 5.0000000000000000, 1.0000000000000000, 
	  -2.0000000000000000 },
  { -0.22992465073215118, 5.0000000000000000, 1.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 1.0000000000000000, 
	  0.0000000000000000 },
  { 23.671704256164183, 5.0000000000000000, 1.0000000000000000, 
	  1.0000000000000000 },
  { 199.50451467112745, 5.0000000000000000, 1.0000000000000000, 
	  2.0000000000000000 },
  { 1232.7498286606428, 5.0000000000000000, 1.0000000000000000, 
	  3.0000000000000000 },
  { 6460.7810872554019, 5.0000000000000000, 1.0000000000000000, 
	  4.0000000000000000 },
  { 30480.352550691663, 5.0000000000000000, 1.0000000000000000, 
	  5.0000000000000000 },
  { 133534.93064609537, 5.0000000000000000, 1.0000000000000000, 
	  6.0000000000000000 },
  { 553479.89366849652, 5.0000000000000000, 1.0000000000000000, 
	  7.0000000000000000 },
  { 2196966.0364497532, 5.0000000000000000, 1.0000000000000000, 
	  8.0000000000000000 },
  { 8422142.8572236635, 5.0000000000000000, 1.0000000000000000, 
	  9.0000000000000000 },
  { 31373029.447069697, 5.0000000000000000, 1.0000000000000000, 
	  10.000000000000000 },
};
const double toler041 = 5.0000000000000034e-10;

// Test data for a=5.0000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.8626451492309570e-09
// max(|f - f_GSL| / |f_GSL|): 1.4711248979266200e-12
const testcase_conf_hyperg<double>
data042[21] =
{
  { -0.00025726626865408078, 5.0000000000000000, 2.0000000000000000, 
	  -10.000000000000000 },
  { -0.00029309828470586396, 5.0000000000000000, 2.0000000000000000, 
	  -9.0000000000000000 },
  { -0.00011182087596750400, 5.0000000000000000, 2.0000000000000000, 
	  -8.0000000000000000 },
  { 0.00064591639226778245, 5.0000000000000000, 2.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0024787521766663585, 5.0000000000000000, 2.0000000000000000, 
	  -6.0000000000000000 },
  { 0.0053342080409426616, 5.0000000000000000, 2.0000000000000000, 
	  -5.0000000000000000 },
  { 0.0061052129629022966, 5.0000000000000000, 2.0000000000000000, 
	  -4.0000000000000000 },
  { -0.0062233835459823200, 5.0000000000000000, 2.0000000000000000, 
	  -3.0000000000000000 },
  { -0.045111761078871798, 5.0000000000000000, 2.0000000000000000, 
	  -2.0000000000000000 },
  { -0.015328310048810216, 5.0000000000000000, 2.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 2.0000000000000000, 
	  0.0000000000000000 },
  { 8.2681072282295975, 5.0000000000000000, 2.0000000000000000, 
	  1.0000000000000000 },
  { 46.797355293227440, 5.0000000000000000, 2.0000000000000000, 
	  2.0000000000000000 },
  { 223.45159827046285, 5.0000000000000000, 2.0000000000000000, 
	  3.0000000000000000 },
  { 964.56731725221459, 5.0000000000000000, 2.0000000000000000, 
	  4.0000000000000000 },
  { 3889.6615448133625, 5.0000000000000000, 2.0000000000000000, 
	  5.0000000000000000 },
  { 14926.865359231202, 5.0000000000000000, 2.0000000000000000, 
	  6.0000000000000000 },
  { 55151.509259297891, 5.0000000000000000, 2.0000000000000000, 
	  7.0000000000000000 },
  { 197736.87980710136, 5.0000000000000000, 2.0000000000000000, 
	  8.0000000000000000 },
  { 691800.79031674843, 5.0000000000000000, 2.0000000000000000, 
	  9.0000000000000000 },
  { 2371516.1505741901, 5.0000000000000000, 2.0000000000000000, 
	  10.000000000000000 },
};
const double toler042 = 1.0000000000000006e-10;

// Test data for a=5.0000000000000000, c=3.0000000000000000.
// max(|f - f_GSL|): 5.8207660913467407e-11
// max(|f - f_GSL| / |f_GSL|): 7.8471940260477516e-13
const testcase_conf_hyperg<double>
data043[21] =
{
  { 0.00012106647936662629, 5.0000000000000000, 3.0000000000000000, 
	  -10.000000000000000 },
  { 0.00021596715715168925, 5.0000000000000000, 3.0000000000000000, 
	  -9.0000000000000000 },
  { 0.00033546262790251185, 5.0000000000000000, 3.0000000000000000, 
	  -8.0000000000000000 },
  { 0.00037995081898104839, 5.0000000000000000, 3.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0000000000000000, 5.0000000000000000, 3.0000000000000000, 
	  -6.0000000000000000 },
  { -0.0016844867497713668, 5.0000000000000000, 3.0000000000000000, 
	  -5.0000000000000000 },
  { -0.0061052129629113917, 5.0000000000000000, 3.0000000000000000, 
	  -4.0000000000000000 },
  { -0.012446767091965986, 5.0000000000000000, 3.0000000000000000, 
	  -3.0000000000000000 },
  { 0.0000000000000000, 5.0000000000000000, 3.0000000000000000, 
	  -2.0000000000000000 },
  { 0.15328310048810101, 5.0000000000000000, 3.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 3.0000000000000000, 
	  0.0000000000000000 },
  { 4.7569931998033290, 5.0000000000000000, 3.0000000000000000, 
	  1.0000000000000000 },
  { 19.704149597148401, 5.0000000000000000, 3.0000000000000000, 
	  2.0000000000000000 },
  { 75.320763461953760, 5.0000000000000000, 3.0000000000000000, 
	  3.0000000000000000 },
  { 272.99075016572118, 5.0000000000000000, 3.0000000000000000, 
	  4.0000000000000000 },
  { 952.31777090819992, 5.0000000000000000, 3.0000000000000000, 
	  5.0000000000000000 },
  { 3227.4303479418809, 5.0000000000000000, 3.0000000000000000, 
	  6.0000000000000000 },
  { 10692.173294677470, 5.0000000000000000, 3.0000000000000000, 
	  7.0000000000000000 },
  { 34777.843182153498, 5.0000000000000000, 3.0000000000000000, 
	  8.0000000000000000 },
  { 111417.40400416154, 5.0000000000000000, 3.0000000000000000, 
	  9.0000000000000000 },
  { 352423.45271690749, 5.0000000000000000, 3.0000000000000000, 
	  10.000000000000000 },
};
const double toler043 = 5.0000000000000028e-11;

// Test data for a=5.0000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 1.4551915228366852e-11
// max(|f - f_GSL| / |f_GSL|): 4.8846719461489400e-13
const testcase_conf_hyperg<double>
data044[21] =
{
  { -6.8099894643727278e-05, 5.0000000000000000, 4.0000000000000000, 
	  -10.000000000000000 },
  { -0.00015426225510834944, 5.0000000000000000, 4.0000000000000000, 
	  -9.0000000000000000 },
  { -0.00033546262790251185, 5.0000000000000000, 4.0000000000000000, 
	  -8.0000000000000000 },
  { -0.00068391147416588716, 5.0000000000000000, 4.0000000000000000, 
	  -7.0000000000000000 },
  { -0.0012393760883331792, 5.0000000000000000, 4.0000000000000000, 
	  -6.0000000000000000 },
  { -0.0016844867497713668, 5.0000000000000000, 4.0000000000000000, 
	  -5.0000000000000000 },
  { 0.0000000000000000, 5.0000000000000000, 4.0000000000000000, 
	  -4.0000000000000000 },
  { 0.012446767091965986, 5.0000000000000000, 4.0000000000000000, 
	  -3.0000000000000000 },
  { 0.067667641618306351, 5.0000000000000000, 4.0000000000000000, 
	  -2.0000000000000000 },
  { 0.27590958087858175, 5.0000000000000000, 4.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 4.0000000000000000, 
	  0.0000000000000000 },
  { 3.3978522855738063, 5.0000000000000000, 4.0000000000000000, 
	  1.0000000000000000 },
  { 11.083584148395975, 5.0000000000000000, 4.0000000000000000, 
	  2.0000000000000000 },
  { 35.149689615578417, 5.0000000000000000, 4.0000000000000000, 
	  3.0000000000000000 },
  { 109.19630006628847, 5.0000000000000000, 4.0000000000000000, 
	  4.0000000000000000 },
  { 333.92960798079736, 5.0000000000000000, 4.0000000000000000, 
	  5.0000000000000000 },
  { 1008.5719837318378, 5.0000000000000000, 4.0000000000000000, 
	  6.0000000000000000 },
  { 3015.7411856782610, 5.0000000000000000, 4.0000000000000000, 
	  7.0000000000000000 },
  { 8942.8739611251840, 5.0000000000000000, 4.0000000000000000, 
	  8.0000000000000000 },
  { 26335.022764620000, 5.0000000000000000, 4.0000000000000000, 
	  9.0000000000000000 },
  { 77092.630281823513, 5.0000000000000000, 4.0000000000000000, 
	  10.000000000000000 },
};
const double toler044 = 2.5000000000000014e-11;

// Test data for a=5.0000000000000000, c=5.0000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data045[21] =
{
  { 4.5399929762484854e-05, 5.0000000000000000, 5.0000000000000000, 
	  -10.000000000000000 },
  { 0.00012340980408667956, 5.0000000000000000, 5.0000000000000000, 
	  -9.0000000000000000 },
  { 0.00033546262790251185, 5.0000000000000000, 5.0000000000000000, 
	  -8.0000000000000000 },
  { 0.00091188196555451624, 5.0000000000000000, 5.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0024787521766663585, 5.0000000000000000, 5.0000000000000000, 
	  -6.0000000000000000 },
  { 0.0067379469990854670, 5.0000000000000000, 5.0000000000000000, 
	  -5.0000000000000000 },
  { 0.018315638888734179, 5.0000000000000000, 5.0000000000000000, 
	  -4.0000000000000000 },
  { 0.049787068367863944, 5.0000000000000000, 5.0000000000000000, 
	  -3.0000000000000000 },
  { 0.13533528323661270, 5.0000000000000000, 5.0000000000000000, 
	  -2.0000000000000000 },
  { 0.36787944117144233, 5.0000000000000000, 5.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 5.0000000000000000, 
	  0.0000000000000000 },
  { 2.7182818284590451, 5.0000000000000000, 5.0000000000000000, 
	  1.0000000000000000 },
  { 7.3890560989306504, 5.0000000000000000, 5.0000000000000000, 
	  2.0000000000000000 },
  { 20.085536923187668, 5.0000000000000000, 5.0000000000000000, 
	  3.0000000000000000 },
  { 54.598150033144236, 5.0000000000000000, 5.0000000000000000, 
	  4.0000000000000000 },
  { 148.41315910257660, 5.0000000000000000, 5.0000000000000000, 
	  5.0000000000000000 },
  { 403.42879349273511, 5.0000000000000000, 5.0000000000000000, 
	  6.0000000000000000 },
  { 1096.6331584284585, 5.0000000000000000, 5.0000000000000000, 
	  7.0000000000000000 },
  { 2980.9579870417283, 5.0000000000000000, 5.0000000000000000, 
	  8.0000000000000000 },
  { 8103.0839275753842, 5.0000000000000000, 5.0000000000000000, 
	  9.0000000000000000 },
  { 22026.465794806718, 5.0000000000000000, 5.0000000000000000, 
	  10.000000000000000 },
};
const double toler045 = 2.5000000000000020e-13;

// Test data for a=5.0000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 9.0949470177292824e-13
// max(|f - f_GSL| / |f_GSL|): 1.4537973070007893e-13
const testcase_conf_hyperg<double>
data046[21] =
{
  { 0.0011648967743076431, 5.0000000000000000, 6.0000000000000000, 
	  -10.000000000000000 },
  { 0.0019205128456127479, 5.0000000000000000, 6.0000000000000000, 
	  -9.0000000000000000 },
  { 0.0032972446271226320, 5.0000000000000000, 6.0000000000000000, 
	  -8.0000000000000000 },
  { 0.0059047424914709006, 5.0000000000000000, 6.0000000000000000, 
	  -7.0000000000000000 },
  { 0.011033078698817415, 5.0000000000000000, 6.0000000000000000, 
	  -6.0000000000000000 },
  { 0.021485057853495849, 5.0000000000000000, 6.0000000000000000, 
	  -5.0000000000000000 },
  { 0.043495671658608563, 5.0000000000000000, 6.0000000000000000, 
	  -4.0000000000000000 },
  { 0.091228027395668113, 5.0000000000000000, 6.0000000000000000, 
	  -3.0000000000000000 },
  { 0.19744881503891684, 5.0000000000000000, 6.0000000000000000, 
	  -2.0000000000000000 },
  { 0.43918161928124549, 5.0000000000000000, 6.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 6.0000000000000000, 
	  0.0000000000000000 },
  { 2.3226822806570353, 5.0000000000000000, 6.0000000000000000, 
	  1.0000000000000000 },
  { 5.4863201236633126, 5.0000000000000000, 6.0000000000000000, 
	  2.0000000000000000 },
  { 13.144500379942246, 5.0000000000000000, 6.0000000000000000, 
	  3.0000000000000000 },
  { 31.873916035045458, 5.0000000000000000, 6.0000000000000000, 
	  4.0000000000000000 },
  { 78.086286951596321, 5.0000000000000000, 6.0000000000000000, 
	  5.0000000000000000 },
  { 192.98291046720357, 5.0000000000000000, 6.0000000000000000, 
	  6.0000000000000000 },
  { 480.54877204888402, 5.0000000000000000, 6.0000000000000000, 
	  7.0000000000000000 },
  { 1204.4605636118315, 5.0000000000000000, 6.0000000000000000, 
	  8.0000000000000000 },
  { 3036.1329048350581, 5.0000000000000000, 6.0000000000000000, 
	  9.0000000000000000 },
  { 7691.6406555465046, 5.0000000000000000, 6.0000000000000000, 
	  10.000000000000000 },
};
const double toler046 = 1.0000000000000006e-11;

// Test data for a=5.0000000000000000, c=7.0000000000000000.
// max(|f - f_GSL|): 1.0004441719502211e-11
// max(|f - f_GSL| / |f_GSL|): 5.0762860793473551e-14
const testcase_conf_hyperg<double>
data047[21] =
{
  { 0.0036308901122103932, 5.0000000000000000, 7.0000000000000000, 
	  -10.000000000000000 },
  { 0.0055327336019229401, 5.0000000000000000, 7.0000000000000000, 
	  -9.0000000000000000 },
  { 0.0086767852656603455, 5.0000000000000000, 7.0000000000000000, 
	  -8.0000000000000000 },
  { 0.014030481266326614, 5.0000000000000000, 7.0000000000000000, 
	  -7.0000000000000000 },
  { 0.023426839582149212, 5.0000000000000000, 7.0000000000000000, 
	  -6.0000000000000000 },
  { 0.040427681994512799, 5.0000000000000000, 7.0000000000000000, 
	  -5.0000000000000000 },
  { 0.072123784177593755, 5.0000000000000000, 7.0000000000000000, 
	  -4.0000000000000000 },
  { 0.13295857409596740, 5.0000000000000000, 7.0000000000000000, 
	  -3.0000000000000000 },
  { 0.25298991319893882, 5.0000000000000000, 7.0000000000000000, 
	  -2.0000000000000000 },
  { 0.49602437239337821, 5.0000000000000000, 7.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 7.0000000000000000, 
	  0.0000000000000000 },
  { 2.0681072498819240, 5.0000000000000000, 7.0000000000000000, 
	  1.0000000000000000 },
  { 4.3768811129698140, 5.0000000000000000, 7.0000000000000000, 
	  2.0000000000000000 },
  { 9.4566368471992224, 5.0000000000000000, 7.0000000000000000, 
	  3.0000000000000000 },
  { 20.811741224531826, 5.0000000000000000, 7.0000000000000000, 
	  4.0000000000000000 },
  { 46.556488803696276, 5.0000000000000000, 7.0000000000000000, 
	  5.0000000000000000 },
  { 105.66804767556316, 5.0000000000000000, 7.0000000000000000, 
	  6.0000000000000000 },
  { 242.93097638084433, 5.0000000000000000, 7.0000000000000000, 
	  7.0000000000000000 },
  { 564.89804380887358, 5.0000000000000000, 7.0000000000000000, 
	  8.0000000000000000 },
  { 1326.9606865425994, 5.0000000000000000, 7.0000000000000000, 
	  9.0000000000000000 },
  { 3145.3685154983905, 5.0000000000000000, 7.0000000000000000, 
	  10.000000000000000 },
};
const double toler047 = 5.0000000000000029e-12;

// Test data for a=5.0000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 6.2527760746888816e-13
// max(|f - f_GSL| / |f_GSL|): 3.7668660800670828e-14
const testcase_conf_hyperg<double>
data048[21] =
{
  { 0.0075295293831406113, 5.0000000000000000, 8.0000000000000000, 
	  -10.000000000000000 },
  { 0.010936052508673187, 5.0000000000000000, 8.0000000000000000, 
	  -9.0000000000000000 },
  { 0.016247454253649721, 5.0000000000000000, 8.0000000000000000, 
	  -8.0000000000000000 },
  { 0.024729468107576008, 5.0000000000000000, 8.0000000000000000, 
	  -7.0000000000000000 },
  { 0.038615775445860964, 5.0000000000000000, 8.0000000000000000, 
	  -6.0000000000000000 },
  { 0.061937865588523586, 5.0000000000000000, 8.0000000000000000, 
	  -5.0000000000000000 },
  { 0.10213565389690644, 5.0000000000000000, 8.0000000000000000, 
	  -4.0000000000000000 },
  { 0.17324118243379236, 5.0000000000000000, 8.0000000000000000, 
	  -3.0000000000000000 },
  { 0.30228316551605494, 5.0000000000000000, 8.0000000000000000, 
	  -2.0000000000000000 },
  { 0.54238748802203829, 5.0000000000000000, 8.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 8.0000000000000000, 
	  0.0000000000000000 },
  { 1.8922997283093959, 5.0000000000000000, 8.0000000000000000, 
	  1.0000000000000000 },
  { 3.6699742831126270, 5.0000000000000000, 8.0000000000000000, 
	  2.0000000000000000 },
  { 7.2831842359960941, 5.0000000000000000, 8.0000000000000000, 
	  3.0000000000000000 },
  { 14.764676530664770, 5.0000000000000000, 8.0000000000000000, 
	  4.0000000000000000 },
  { 30.522558591756702, 5.0000000000000000, 8.0000000000000000, 
	  5.0000000000000000 },
  { 64.236147093730224, 5.0000000000000000, 8.0000000000000000, 
	  6.0000000000000000 },
  { 137.40503032883331, 5.0000000000000000, 8.0000000000000000, 
	  7.0000000000000000 },
  { 298.29153884828770, 5.0000000000000000, 8.0000000000000000, 
	  8.0000000000000000 },
  { 656.29389355002752, 5.0000000000000000, 8.0000000000000000, 
	  9.0000000000000000 },
  { 1461.6183101433730, 5.0000000000000000, 8.0000000000000000, 
	  10.000000000000000 },
};
const double toler048 = 2.5000000000000015e-12;

// Test data for a=5.0000000000000000, c=9.0000000000000000.
// max(|f - f_GSL|): 1.4779288903810084e-12
// max(|f - f_GSL| / |f_GSL|): 1.3332193464342236e-14
const testcase_conf_hyperg<double>
data049[21] =
{
  { 0.012801285049305222, 5.0000000000000000, 9.0000000000000000, 
	  -10.000000000000000 },
  { 0.017955923031350202, 5.0000000000000000, 9.0000000000000000, 
	  -9.0000000000000000 },
  { 0.025661650371090718, 5.0000000000000000, 9.0000000000000000, 
	  -8.0000000000000000 },
  { 0.037414616710204310, 5.0000000000000000, 9.0000000000000000, 
	  -7.0000000000000000 },
  { 0.055720934057414885, 5.0000000000000000, 9.0000000000000000, 
	  -6.0000000000000000 },
  { 0.084862956151756000, 5.0000000000000000, 9.0000000000000000, 
	  -5.0000000000000000 },
  { 0.13230635170162319, 5.0000000000000000, 9.0000000000000000, 
	  -4.0000000000000000 },
  { 0.21132914572142125, 5.0000000000000000, 9.0000000000000000, 
	  -3.0000000000000000 },
  { 0.34601808641639625, 5.0000000000000000, 9.0000000000000000, 
	  -2.0000000000000000 },
  { 0.58092180965710882, 5.0000000000000000, 9.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 9.0000000000000000, 
	  0.0000000000000000 },
  { 1.7643922061378634, 5.0000000000000000, 9.0000000000000000, 
	  1.0000000000000000 },
  { 3.1888010096332451, 5.0000000000000000, 9.0000000000000000, 
	  2.0000000000000000 },
  { 5.8981194929479273, 5.0000000000000000, 9.0000000000000000, 
	  3.0000000000000000 },
  { 11.152835510393174, 5.0000000000000000, 9.0000000000000000, 
	  4.0000000000000000 },
  { 21.533483453443495, 5.0000000000000000, 9.0000000000000000, 
	  5.0000000000000000 },
  { 42.397145995355721, 5.0000000000000000, 9.0000000000000000, 
	  6.0000000000000000 },
  { 85.010891404859976, 5.0000000000000000, 9.0000000000000000, 
	  7.0000000000000000 },
  { 173.36225868739959, 5.0000000000000000, 9.0000000000000000, 
	  8.0000000000000000 },
  { 359.10444177844266, 5.0000000000000000, 9.0000000000000000, 
	  9.0000000000000000 },
  { 754.64844371961408, 5.0000000000000000, 9.0000000000000000, 
	  10.000000000000000 },
};
const double toler049 = 1.0000000000000008e-12;

// Test data for a=5.0000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 5.1159076974727213e-13
// max(|f - f_GSL| / |f_GSL|): 7.5019093654907020e-15
const testcase_conf_hyperg<double>
data050[21] =
{
  { 0.019313731161840469, 5.0000000000000000, 10.000000000000000, 
	  -10.000000000000000 },
  { 0.026361085775183927, 5.0000000000000000, 10.000000000000000, 
	  -9.0000000000000000 },
  { 0.036556772070711910, 5.0000000000000000, 10.000000000000000, 
	  -8.0000000000000000 },
  { 0.051563934048344140, 5.0000000000000000, 10.000000000000000, 
	  -7.0000000000000000 },
  { 0.074056625794521824, 5.0000000000000000, 10.000000000000000, 
	  -6.0000000000000000 },
  { 0.10841132531381445, 5.0000000000000000, 10.000000000000000, 
	  -5.0000000000000000 },
  { 0.16192115120742598, 5.0000000000000000, 10.000000000000000, 
	  -4.0000000000000000 },
  { 0.24696279814742436, 5.0000000000000000, 10.000000000000000, 
	  -3.0000000000000000 },
  { 0.38492640633381947, 5.0000000000000000, 10.000000000000000, 
	  -2.0000000000000000 },
  { 0.61345628229723270, 5.0000000000000000, 10.000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 5.0000000000000000, 10.000000000000000, 
	  0.0000000000000000 },
  { 1.6675470647226096, 5.0000000000000000, 10.000000000000000, 
	  1.0000000000000000 },
  { 2.8442428103603667, 5.0000000000000000, 10.000000000000000, 
	  2.0000000000000000 },
  { 4.9603804008438397, 5.0000000000000000, 10.000000000000000, 
	  3.0000000000000000 },
  { 8.8405953071624790, 5.0000000000000000, 10.000000000000000, 
	  4.0000000000000000 },
  { 16.089667272320334, 5.0000000000000000, 10.000000000000000, 
	  5.0000000000000000 },
  { 29.876575194426895, 5.0000000000000000, 10.000000000000000, 
	  6.0000000000000000 },
  { 56.546719856432318, 5.0000000000000000, 10.000000000000000, 
	  7.0000000000000000 },
  { 108.97420168465270, 5.0000000000000000, 10.000000000000000, 
	  8.0000000000000000 },
  { 213.60609045832913, 5.0000000000000000, 10.000000000000000, 
	  9.0000000000000000 },
  { 425.41323880637168, 5.0000000000000000, 10.000000000000000, 
	  10.000000000000000 },
};
const double toler050 = 5.0000000000000039e-13;

// Test data for a=10.000000000000000, c=1.0000000000000000.
// max(|f - f_GSL|): 4.7683715820312500e-06
// max(|f - f_GSL| / |f_GSL|): 3.9070311524604618e-14
const testcase_conf_hyperg<double>
data051[21] =
{
  { 0.00067155063653961294, 10.000000000000000, 1.0000000000000000, 
	  -10.000000000000000 },
  { -0.00071555648905258684, 10.000000000000000, 1.0000000000000000, 
	  -9.0000000000000000 },
  { -0.0035372078786207375, 10.000000000000000, 1.0000000000000000, 
	  -8.0000000000000000 },
  { -0.0047884005574714370, 10.000000000000000, 1.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0024787521766663585, 10.000000000000000, 1.0000000000000000, 
	  -6.0000000000000000 },
  { 0.018136827242522881, 10.000000000000000, 1.0000000000000000, 
	  -5.0000000000000000 },
  { 0.0099686175680129968, 10.000000000000000, 1.0000000000000000, 
	  -4.0000000000000000 },
  { -0.052832081031434205, 10.000000000000000, 1.0000000000000000, 
	  -3.0000000000000000 },
  { 0.0010979582061523968, 10.000000000000000, 1.0000000000000000, 
	  -2.0000000000000000 },
  { 0.11394854824644544, 10.000000000000000, 1.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 1.0000000000000000, 
	  0.0000000000000000 },
  { 131.63017574352619, 10.000000000000000, 1.0000000000000000, 
	  1.0000000000000000 },
  { 2431.2913698755478, 10.000000000000000, 1.0000000000000000, 
	  2.0000000000000000 },
  { 27127.328899791049, 10.000000000000000, 1.0000000000000000, 
	  3.0000000000000000 },
  { 232066.49977835570, 10.000000000000000, 1.0000000000000000, 
	  4.0000000000000000 },
  { 1674401.3794931530, 10.000000000000000, 1.0000000000000000, 
	  5.0000000000000000 },
  { 10707495.820386341, 10.000000000000000, 1.0000000000000000, 
	  6.0000000000000000 },
  { 62515499.242815509, 10.000000000000000, 1.0000000000000000, 
	  7.0000000000000000 },
  { 339773485.00937450, 10.000000000000000, 1.0000000000000000, 
	  8.0000000000000000 },
  { 1742442474.2135217, 10.000000000000000, 1.0000000000000000, 
	  9.0000000000000000 },
  { 8514625476.5462780, 10.000000000000000, 1.0000000000000000, 
	  10.000000000000000 },
};
const double toler051 = 2.5000000000000015e-12;

// Test data for a=10.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 1.7881393432617188e-07
// max(|f - f_GSL| / |f_GSL|): 3.0525079910466156e-12
const testcase_conf_hyperg<double>
data052[21] =
{
  { -0.00014116415550486912, 10.000000000000000, 2.0000000000000000, 
	  -10.000000000000000 },
  { -0.00016988130843806985, 10.000000000000000, 2.0000000000000000, 
	  -9.0000000000000000 },
  { 6.6619209703391378e-05, 10.000000000000000, 2.0000000000000000, 
	  -8.0000000000000000 },
  { 0.00072582919646365740, 10.000000000000000, 2.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0012039653429522313, 10.000000000000000, 2.0000000000000000, 
	  -6.0000000000000000 },
  { -0.00061450715370021329, 10.000000000000000, 2.0000000000000000, 
	  -5.0000000000000000 },
  { -0.0053557899960354968, 10.000000000000000, 2.0000000000000000, 
	  -4.0000000000000000 },
  { -0.00078903612815141473, 10.000000000000000, 2.0000000000000000, 
	  -3.0000000000000000 },
  { 0.023725444715554326, 10.000000000000000, 2.0000000000000000, 
	  -2.0000000000000000 },
  { -0.057297669024384767, 10.000000000000000, 2.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 2.0000000000000000, 
	  0.0000000000000000 },
  { 34.432116659636534, 10.000000000000000, 2.0000000000000000, 
	  1.0000000000000000 },
  { 432.53475371634494, 10.000000000000000, 2.0000000000000000, 
	  2.0000000000000000 },
  { 3789.1768909683506, 10.000000000000000, 2.0000000000000000, 
	  3.0000000000000000 },
  { 27089.676185774806, 10.000000000000000, 2.0000000000000000, 
	  4.0000000000000000 },
  { 169243.72183073507, 10.000000000000000, 2.0000000000000000, 
	  5.0000000000000000 },
  { 959019.40135397331, 10.000000000000000, 2.0000000000000000, 
	  6.0000000000000000 },
  { 5043073.3458297960, 10.000000000000000, 2.0000000000000000, 
	  7.0000000000000000 },
  { 24989309.819281481, 10.000000000000000, 2.0000000000000000, 
	  8.0000000000000000 },
  { 117948708.50540228, 10.000000000000000, 2.0000000000000000, 
	  9.0000000000000000 },
  { 534524325.69810420, 10.000000000000000, 2.0000000000000000, 
	  10.000000000000000 },
};
const double toler052 = 2.5000000000000017e-10;

// Test data for a=10.000000000000000, c=3.0000000000000000.
// max(|f - f_GSL|): 4.4703483581542969e-08
// max(|f - f_GSL| / |f_GSL|): 3.1351462019253111e-11
const testcase_conf_hyperg<double>
data053[21] =
{
  { 1.4973169075105227e-05, 10.000000000000000, 3.0000000000000000, 
	  -10.000000000000000 },
  { 5.7627971015476266e-05, 10.000000000000000, 3.0000000000000000, 
	  -9.0000000000000000 },
  { 9.5964794084281178e-05, 10.000000000000000, 3.0000000000000000, 
	  -8.0000000000000000 },
  { 1.5479477810339013e-05, 10.000000000000000, 3.0000000000000000, 
	  -7.0000000000000000 },
  { -0.00035410745380947978, 10.000000000000000, 3.0000000000000000, 
	  -6.0000000000000000 },
  { -0.00078393993138610137, 10.000000000000000, 3.0000000000000000, 
	  -5.0000000000000000 },
  { 0.00038117202625584330, 10.000000000000000, 3.0000000000000000, 
	  -4.0000000000000000 },
  { 0.0045341794406447526, 10.000000000000000, 3.0000000000000000, 
	  -3.0000000000000000 },
  { -0.0031029253652133403, 10.000000000000000, 3.0000000000000000, 
	  -2.0000000000000000 },
  { -0.028487137061611361, 10.000000000000000, 3.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 3.0000000000000000, 
	  0.0000000000000000 },
  { 15.691485606063274, 10.000000000000000, 3.0000000000000000, 
	  1.0000000000000000 },
  { 141.71088859081416, 10.000000000000000, 3.0000000000000000, 
	  2.0000000000000000 },
  { 997.55177799313731, 10.000000000000000, 3.0000000000000000, 
	  3.0000000000000000 },
  { 6038.6324280926056, 10.000000000000000, 3.0000000000000000, 
	  4.0000000000000000 },
  { 32946.952425437150, 10.000000000000000, 3.0000000000000000, 
	  5.0000000000000000 },
  { 166431.66712118863, 10.000000000000000, 3.0000000000000000, 
	  6.0000000000000000 },
  { 791818.30272061308, 10.000000000000000, 3.0000000000000000, 
	  7.0000000000000000 },
  { 3589678.0198700386, 10.000000000000000, 3.0000000000000000, 
	  8.0000000000000000 },
  { 15637649.698874988, 10.000000000000000, 3.0000000000000000, 
	  9.0000000000000000 },
  { 65871447.346678361, 10.000000000000000, 3.0000000000000000, 
	  10.000000000000000 },
};
const double toler053 = 2.5000000000000013e-09;

// Test data for a=10.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 3.7252902984619141e-09
// max(|f - f_GSL| / |f_GSL|): 7.5580354912480585e-11
const testcase_conf_hyperg<double>
data054[21] =
{
  { 6.9661267889527048e-06, 10.000000000000000, 4.0000000000000000, 
	  -10.000000000000000 },
  { -3.0301514396282942e-06, 10.000000000000000, 4.0000000000000000, 
	  -9.0000000000000000 },
  { -3.7983599138168025e-05, 10.000000000000000, 4.0000000000000000, 
	  -8.0000000000000000 },
  { -9.3615660121163871e-05, 10.000000000000000, 4.0000000000000000, 
	  -7.0000000000000000 },
  { -7.0821490761895943e-05, 10.000000000000000, 4.0000000000000000, 
	  -6.0000000000000000 },
  { 0.00030692863727646260, 10.000000000000000, 4.0000000000000000, 
	  -5.0000000000000000 },
  { 0.0010659895649527829, 10.000000000000000, 4.0000000000000000, 
	  -4.0000000000000000 },
  { -0.00042230102633456049, 10.000000000000000, 4.0000000000000000, 
	  -3.0000000000000000 },
  { -0.010168047735237568, 10.000000000000000, 4.0000000000000000, 
	  -2.0000000000000000 },
  { 0.036903514708782073, 10.000000000000000, 4.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 4.0000000000000000, 
	  0.0000000000000000 },
  { 9.3384756433214022, 10.000000000000000, 4.0000000000000000, 
	  1.0000000000000000 },
  { 63.905561372021388, 10.000000000000000, 4.0000000000000000, 
	  2.0000000000000000 },
  { 370.08498456728779, 10.000000000000000, 4.0000000000000000, 
	  3.0000000000000000 },
  { 1922.9526217493540, 10.000000000000000, 4.0000000000000000, 
	  4.0000000000000000 },
  { 9245.0380014351485, 10.000000000000000, 4.0000000000000000, 
	  5.0000000000000000 },
  { 41898.961838459785, 10.000000000000000, 4.0000000000000000, 
	  6.0000000000000000 },
  { 181211.14084739226, 10.000000000000000, 4.0000000000000000, 
	  7.0000000000000000 },
  { 754384.25570692308, 10.000000000000000, 4.0000000000000000, 
	  8.0000000000000000 },
  { 3042060.4915799876, 10.000000000000000, 4.0000000000000000, 
	  9.0000000000000000 },
  { 11939626.424402930, 10.000000000000000, 4.0000000000000000, 
	  10.000000000000000 },
};
const double toler054 = 5.0000000000000026e-09;

// Test data for a=10.000000000000000, c=5.0000000000000000.
// max(|f - f_GSL|): 1.1641532182693481e-10
// max(|f - f_GSL| / |f_GSL|): 4.6734083284321249e-11
const testcase_conf_hyperg<double>
data055[21] =
{
  { -6.2454929831989742e-06, 10.000000000000000, 5.0000000000000000, 
	  -10.000000000000000 },
  { -1.1459481808048817e-05, 10.000000000000000, 5.0000000000000000, 
	  -9.0000000000000000 },
  { -8.1646988801669512e-06, 10.000000000000000, 5.0000000000000000, 
	  -8.0000000000000000 },
  { 3.1240400671775088e-05, 10.000000000000000, 5.0000000000000000, 
	  -7.0000000000000000 },
  { 0.00014164298152379191, 10.000000000000000, 5.0000000000000000, 
	  -6.0000000000000000 },
  { 0.00023172833594738382, 10.000000000000000, 5.0000000000000000, 
	  -5.0000000000000000 },
  { -0.00036825094062005215, 10.000000000000000, 5.0000000000000000, 
	  -4.0000000000000000 },
  { -0.0030227862937631683, 10.000000000000000, 5.0000000000000000, 
	  -3.0000000000000000 },
  { -0.00028642387986584918, 10.000000000000000, 5.0000000000000000, 
	  -2.0000000000000000 },
  { 0.10617896040159881, 10.000000000000000, 5.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 5.0000000000000000, 
	  0.0000000000000000 },
  { 6.4803694966028260, 10.000000000000000, 5.0000000000000000, 
	  1.0000000000000000 },
  { 35.201619637445276, 10.000000000000000, 5.0000000000000000, 
	  2.0000000000000000 },
  { 171.58787257237464, 10.000000000000000, 5.0000000000000000, 
	  3.0000000000000000 },
  { 775.87148867205678, 10.000000000000000, 5.0000000000000000, 
	  4.0000000000000000 },
  { 3317.4071019773678, 10.000000000000000, 5.0000000000000000, 
	  5.0000000000000000 },
  { 13578.260535269774, 10.000000000000000, 5.0000000000000000, 
	  6.0000000000000000 },
  { 53651.761875039716, 10.000000000000000, 5.0000000000000000, 
	  7.0000000000000000 },
  { 205900.60390283042, 10.000000000000000, 5.0000000000000000, 
	  8.0000000000000000 },
  { 770979.49612334219, 10.000000000000000, 5.0000000000000000, 
	  9.0000000000000000 },
  { 2826613.2348531331, 10.000000000000000, 5.0000000000000000, 
	  10.000000000000000 },
};
const double toler055 = 2.5000000000000013e-09;

// Test data for a=10.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 2.3283064365386963e-10
// max(|f - f_GSL| / |f_GSL|): 2.5542822249778647e-10
const testcase_conf_hyperg<double>
data056[21] =
{
  { 9.6084507433830306e-07, 10.000000000000000, 6.0000000000000000, 
	  -10.000000000000000 },
  { 7.7131127554174726e-06, 10.000000000000000, 6.0000000000000000, 
	  -9.0000000000000000 },
  { 2.3074149009167486e-05, 10.000000000000000, 6.0000000000000000, 
	  -8.0000000000000000 },
  { 4.0105919781332888e-05, 10.000000000000000, 6.0000000000000000, 
	  -7.0000000000000000 },
  { -1.0325734976052423e-20, 10.000000000000000, 6.0000000000000000, 
	  -6.0000000000000000 },
  { -0.00029188857701064686, 10.000000000000000, 6.0000000000000000, 
	  -5.0000000000000000 },
  { -0.0010659895649527829, 10.000000000000000, 6.0000000000000000, 
	  -4.0000000000000000 },
  { -0.00044452739614164207, 10.000000000000000, 6.0000000000000000, 
	  -3.0000000000000000 },
  { 0.020049671590609285, 10.000000000000000, 6.0000000000000000, 
	  -2.0000000000000000 },
  { 0.17092282236966813, 10.000000000000000, 6.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 6.0000000000000000, 
	  0.0000000000000000 },
  { 4.9520550902714549, 10.000000000000000, 6.0000000000000000, 
	  1.0000000000000000 },
  { 22.206263831706924, 10.000000000000000, 6.0000000000000000, 
	  2.0000000000000000 },
  { 93.074943420842843, 10.000000000000000, 6.0000000000000000, 
	  3.0000000000000000 },
  { 371.20964440523989, 10.000000000000000, 6.0000000000000000, 
	  4.0000000000000000 },
  { 1424.6976175888547, 10.000000000000000, 6.0000000000000000, 
	  5.0000000000000000 },
  { 5302.2070001902330, 10.000000000000000, 6.0000000000000000, 
	  6.0000000000000000 },
  { 19239.311823447424, 10.000000000000000, 6.0000000000000000, 
	  7.0000000000000000 },
  { 68341.221999215923, 10.000000000000000, 6.0000000000000000, 
	  8.0000000000000000 },
  { 238389.83519072225, 10.000000000000000, 6.0000000000000000, 
	  9.0000000000000000 },
  { 818592.04096678528, 10.000000000000000, 6.0000000000000000, 
	  10.000000000000000 },
};
const double toler056 = 2.5000000000000012e-08;

// Test data for a=10.000000000000000, c=7.0000000000000000.
// max(|f - f_GSL|): 2.3283064365386963e-10
// max(|f - f_GSL| / |f_GSL|): 1.7003920117988582e-08
const testcase_conf_hyperg<double>
data057[21] =
{
  { 3.9634859316455036e-06, 10.000000000000000, 7.0000000000000000, 
	  -10.000000000000000 },
  { 4.4074930030956985e-06, 10.000000000000000, 7.0000000000000000, 
	  -9.0000000000000000 },
  { -5.3248036175001926e-06, 10.000000000000000, 7.0000000000000000, 
	  -8.0000000000000000 },
  { -5.0660109197473119e-05, 10.000000000000000, 7.0000000000000000, 
	  -7.0000000000000000 },
  { -0.00017705372690473989, 10.000000000000000, 7.0000000000000000, 
	  -6.0000000000000000 },
  { -0.00034759250392107574, 10.000000000000000, 7.0000000000000000, 
	  -5.0000000000000000 },
  { 0.00029072442680530428, 10.000000000000000, 7.0000000000000000, 
	  -4.0000000000000000 },
  { 0.0071124383382662791, 10.000000000000000, 7.0000000000000000, 
	  -3.0000000000000000 },
  { 0.046185850628367824, 10.000000000000000, 7.0000000000000000, 
	  -2.0000000000000000 },
  { 0.22919473120601763, 10.000000000000000, 7.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 7.0000000000000000, 
	  0.0000000000000000 },
  { 4.0342754120781059, 10.000000000000000, 7.0000000000000000, 
	  1.0000000000000000 },
  { 15.423188523958418, 10.000000000000000, 7.0000000000000000, 
	  2.0000000000000000 },
  { 56.669907747565212, 10.000000000000000, 7.0000000000000000, 
	  3.0000000000000000 },
  { 201.92649139242229, 10.000000000000000, 7.0000000000000000, 
	  4.0000000000000000 },
  { 702.01780019948944, 10.000000000000000, 7.0000000000000000, 
	  5.0000000000000000 },
  { 2391.7564185640726, 10.000000000000000, 7.0000000000000000, 
	  6.0000000000000000 },
  { 8011.5144629634615, 10.000000000000000, 7.0000000000000000, 
	  7.0000000000000000 },
  { 26450.087535814702, 10.000000000000000, 7.0000000000000000, 
	  8.0000000000000000 },
  { 86239.964657766584, 10.000000000000000, 7.0000000000000000, 
	  9.0000000000000000 },
  { 278127.83396458329, 10.000000000000000, 7.0000000000000000, 
	  10.000000000000000 },
};
const double toler057 = 1.0000000000000004e-06;

// Test data for a=10.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 2.9103830456733704e-11
// max(|f - f_GSL| / |f_GSL|): 3.9656315544900790e-11
const testcase_conf_hyperg<double>
data058[21] =
{
  { -5.0444366402760974e-06, 10.000000000000000, 8.0000000000000000, 
	  -10.000000000000000 },
  { -1.5426225510834945e-05, 10.000000000000000, 8.0000000000000000, 
	  -9.0000000000000000 },
  { -3.7273625322501334e-05, 10.000000000000000, 8.0000000000000000, 
	  -8.0000000000000000 },
  { -6.3325136496841588e-05, 10.000000000000000, 8.0000000000000000, 
	  -7.0000000000000000 },
  { 0.0000000000000000, 10.000000000000000, 8.0000000000000000, 
	  -6.0000000000000000 },
  { 0.00065507818046664252, 10.000000000000000, 8.0000000000000000, 
	  -5.0000000000000000 },
  { 0.0040701419752742617, 10.000000000000000, 8.0000000000000000, 
	  -4.0000000000000000 },
  { 0.018670150637948978, 10.000000000000000, 8.0000000000000000, 
	  -3.0000000000000000 },
  { 0.075186268464784836, 10.000000000000000, 8.0000000000000000, 
	  -2.0000000000000000 },
  { 0.28101901756151842, 10.000000000000000, 8.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 8.0000000000000000, 
	  0.0000000000000000 },
  { 3.4356061998579595, 10.000000000000000, 8.0000000000000000, 
	  1.0000000000000000 },
  { 11.494087265003234, 10.000000000000000, 8.0000000000000000, 
	  2.0000000000000000 },
  { 37.660381730976880, 10.000000000000000, 8.0000000000000000, 
	  3.0000000000000000 },
  { 121.32922229587608, 10.000000000000000, 8.0000000000000000, 
	  4.0000000000000000 },
  { 385.46195489141422, 10.000000000000000, 8.0000000000000000, 
	  5.0000000000000000 },
  { 1210.2863804782053, 10.000000000000000, 8.0000000000000000, 
	  6.0000000000000000 },
  { 3762.0609740531836, 10.000000000000000, 8.0000000000000000, 
	  7.0000000000000000 },
  { 11592.614394051165, 10.000000000000000, 8.0000000000000000, 
	  8.0000000000000000 },
  { 35450.992183142305, 10.000000000000000, 8.0000000000000000, 
	  9.0000000000000000 },
  { 107684.94388572175, 10.000000000000000, 8.0000000000000000, 
	  10.000000000000000 },
};
const double toler058 = 2.5000000000000013e-09;

// Test data for a=10.000000000000000, c=9.0000000000000000.
// max(|f - f_GSL|): 9.0949470177292824e-12
// max(|f - f_GSL| / |f_GSL|): 3.7408279162146281e-11
const testcase_conf_hyperg<double>
data059[21] =
{
  { -5.0444366402760974e-06, 10.000000000000000, 9.0000000000000000, 
	  -10.000000000000000 },
  { 0.0000000000000000, 10.000000000000000, 9.0000000000000000, 
	  -9.0000000000000000 },
  { 3.7273625322501334e-05, 10.000000000000000, 9.0000000000000000, 
	  -8.0000000000000000 },
  { 0.00020264043678989247, 10.000000000000000, 9.0000000000000000, 
	  -7.0000000000000000 },
  { 0.00082625072555545290, 10.000000000000000, 9.0000000000000000, 
	  -6.0000000000000000 },
  { 0.0029946431107046520, 10.000000000000000, 9.0000000000000000, 
	  -5.0000000000000000 },
  { 0.010175354938185655, 10.000000000000000, 9.0000000000000000, 
	  -4.0000000000000000 },
  { 0.033191378911909299, 10.000000000000000, 9.0000000000000000, 
	  -3.0000000000000000 },
  { 0.10526077585069878, 10.000000000000000, 9.0000000000000000, 
	  -2.0000000000000000 },
  { 0.32700394770794872, 10.000000000000000, 9.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 9.0000000000000000, 
	  0.0000000000000000 },
  { 3.0203131427322725, 10.000000000000000, 9.0000000000000000, 
	  1.0000000000000000 },
  { 9.0310685653596838, 10.000000000000000, 9.0000000000000000, 
	  2.0000000000000000 },
  { 26.780715897583555, 10.000000000000000, 9.0000000000000000, 
	  3.0000000000000000 },
  { 78.863994492319449, 10.000000000000000, 9.0000000000000000, 
	  4.0000000000000000 },
  { 230.86491415956360, 10.000000000000000, 9.0000000000000000, 
	  5.0000000000000000 },
  { 672.38132248789179, 10.000000000000000, 9.0000000000000000, 
	  6.0000000000000000 },
  { 1949.5700594283705, 10.000000000000000, 9.0000000000000000, 
	  7.0000000000000000 },
  { 5630.6984199677090, 10.000000000000000, 9.0000000000000000, 
	  8.0000000000000000 },
  { 16206.167855150768, 10.000000000000000, 9.0000000000000000, 
	  9.0000000000000000 },
  { 46500.316677925293, 10.000000000000000, 9.0000000000000000, 
	  10.000000000000000 },
};
const double toler059 = 2.5000000000000013e-09;

// Test data for a=10.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 0.0000000000000000
// max(|f - f_GSL| / |f_GSL|): 0.0000000000000000
const testcase_conf_hyperg<double>
data060[21] =
{
  { 4.5399929762484854e-05, 10.000000000000000, 10.000000000000000, 
	  -10.000000000000000 },
  { 0.00012340980408667956, 10.000000000000000, 10.000000000000000, 
	  -9.0000000000000000 },
  { 0.00033546262790251185, 10.000000000000000, 10.000000000000000, 
	  -8.0000000000000000 },
  { 0.00091188196555451624, 10.000000000000000, 10.000000000000000, 
	  -7.0000000000000000 },
  { 0.0024787521766663585, 10.000000000000000, 10.000000000000000, 
	  -6.0000000000000000 },
  { 0.0067379469990854670, 10.000000000000000, 10.000000000000000, 
	  -5.0000000000000000 },
  { 0.018315638888734179, 10.000000000000000, 10.000000000000000, 
	  -4.0000000000000000 },
  { 0.049787068367863944, 10.000000000000000, 10.000000000000000, 
	  -3.0000000000000000 },
  { 0.13533528323661270, 10.000000000000000, 10.000000000000000, 
	  -2.0000000000000000 },
  { 0.36787944117144233, 10.000000000000000, 10.000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 10.000000000000000, 10.000000000000000, 
	  0.0000000000000000 },
  { 2.7182818284590451, 10.000000000000000, 10.000000000000000, 
	  1.0000000000000000 },
  { 7.3890560989306504, 10.000000000000000, 10.000000000000000, 
	  2.0000000000000000 },
  { 20.085536923187668, 10.000000000000000, 10.000000000000000, 
	  3.0000000000000000 },
  { 54.598150033144236, 10.000000000000000, 10.000000000000000, 
	  4.0000000000000000 },
  { 148.41315910257660, 10.000000000000000, 10.000000000000000, 
	  5.0000000000000000 },
  { 403.42879349273511, 10.000000000000000, 10.000000000000000, 
	  6.0000000000000000 },
  { 1096.6331584284585, 10.000000000000000, 10.000000000000000, 
	  7.0000000000000000 },
  { 2980.9579870417283, 10.000000000000000, 10.000000000000000, 
	  8.0000000000000000 },
  { 8103.0839275753842, 10.000000000000000, 10.000000000000000, 
	  9.0000000000000000 },
  { 22026.465794806718, 10.000000000000000, 10.000000000000000, 
	  10.000000000000000 },
};
const double toler060 = 2.5000000000000020e-13;

// Test data for a=20.000000000000000, c=1.0000000000000000.
// max(|f - f_GSL|): 0.0039062500000000000
// max(|f - f_GSL| / |f_GSL|): 3.8043537688323639e-14
const testcase_conf_hyperg<double>
data061[21] =
{
  { 0.00018021852293239509, 20.000000000000000, 1.0000000000000000, 
	  -10.000000000000000 },
  { 0.0017726368057851866, 20.000000000000000, 1.0000000000000000, 
	  -9.0000000000000000 },
  { 0.00058280040382329280, 20.000000000000000, 1.0000000000000000, 
	  -8.0000000000000000 },
  { -0.0049657717020590141, 20.000000000000000, 1.0000000000000000, 
	  -7.0000000000000000 },
  { -0.0012360336087128597, 20.000000000000000, 1.0000000000000000, 
	  -6.0000000000000000 },
  { 0.014898894139255305, 20.000000000000000, 1.0000000000000000, 
	  -5.0000000000000000 },
  { -0.013800784612552078, 20.000000000000000, 1.0000000000000000, 
	  -4.0000000000000000 },
  { -0.012192213426039619, 20.000000000000000, 1.0000000000000000, 
	  -3.0000000000000000 },
  { 0.050311246773136212, 20.000000000000000, 1.0000000000000000, 
	  -2.0000000000000000 },
  { -0.025985814502838493, 20.000000000000000, 1.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 1.0000000000000000, 
	  0.0000000000000000 },
  { 1563.6577385252017, 20.000000000000000, 1.0000000000000000, 
	  1.0000000000000000 },
  { 86377.091910766088, 20.000000000000000, 1.0000000000000000, 
	  2.0000000000000000 },
  { 2216718.8789979252, 20.000000000000000, 1.0000000000000000, 
	  3.0000000000000000 },
  { 38045018.520647161, 20.000000000000000, 1.0000000000000000, 
	  4.0000000000000000 },
  { 504376263.68346804, 20.000000000000000, 1.0000000000000000, 
	  5.0000000000000000 },
  { 5565635666.7972050, 20.000000000000000, 1.0000000000000000, 
	  6.0000000000000000 },
  { 53451562646.544518, 20.000000000000000, 1.0000000000000000, 
	  7.0000000000000000 },
  { 460009135340.33832, 20.000000000000000, 1.0000000000000000, 
	  8.0000000000000000 },
  { 3620401937301.4907, 20.000000000000000, 1.0000000000000000, 
	  9.0000000000000000 },
  { 26446266822604.152, 20.000000000000000, 1.0000000000000000, 
	  10.000000000000000 },
};
const double toler061 = 2.5000000000000015e-12;

// Test data for a=20.000000000000000, c=2.0000000000000000.
// max(|f - f_GSL|): 0.00097656250000000000
// max(|f - f_GSL| / |f_GSL|): 3.3638062074418344e-12
const testcase_conf_hyperg<double>
data062[21] =
{
  { 6.6647681992684102e-05, 20.000000000000000, 2.0000000000000000, 
	  -10.000000000000000 },
  { -3.7248253270227151e-05, 20.000000000000000, 2.0000000000000000, 
	  -9.0000000000000000 },
  { -0.00024392611307344034, 20.000000000000000, 2.0000000000000000, 
	  -8.0000000000000000 },
  { 2.4034559592246202e-05, 20.000000000000000, 2.0000000000000000, 
	  -7.0000000000000000 },
  { 0.00081645960584843073, 20.000000000000000, 2.0000000000000000, 
	  -6.0000000000000000 },
  { -0.00051326387116462039, 20.000000000000000, 2.0000000000000000, 
	  -5.0000000000000000 },
  { -0.0021786279856333920, 20.000000000000000, 2.0000000000000000, 
	  -4.0000000000000000 },
  { 0.0061029380625179973, 20.000000000000000, 2.0000000000000000, 
	  -3.0000000000000000 },
  { -0.011834301617155166, 20.000000000000000, 2.0000000000000000, 
	  -2.0000000000000000 },
  { 0.037622016973681061, 20.000000000000000, 2.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 2.0000000000000000, 
	  0.0000000000000000 },
  { 303.10954080179744, 20.000000000000000, 2.0000000000000000, 
	  1.0000000000000000 },
  { 11508.923130556599, 20.000000000000000, 2.0000000000000000, 
	  2.0000000000000000 },
  { 234541.86023461280, 20.000000000000000, 2.0000000000000000, 
	  3.0000000000000000 },
  { 3398931.2897027107, 20.000000000000000, 2.0000000000000000, 
	  4.0000000000000000 },
  { 39382712.287920594, 20.000000000000000, 2.0000000000000000, 
	  5.0000000000000000 },
  { 388350500.37087941, 20.000000000000000, 2.0000000000000000, 
	  6.0000000000000000 },
  { 3385284070.5527182, 20.000000000000000, 2.0000000000000000, 
	  7.0000000000000000 },
  { 26751585258.405773, 20.000000000000000, 2.0000000000000000, 
	  8.0000000000000000 },
  { 195061928138.27676, 20.000000000000000, 2.0000000000000000, 
	  9.0000000000000000 },
  { 1329571695324.3132, 20.000000000000000, 2.0000000000000000, 
	  10.000000000000000 },
};
const double toler062 = 2.5000000000000017e-10;

// Test data for a=20.000000000000000, c=3.0000000000000000.
// max(|f - f_GSL|): 1.5258789062500000e-05
// max(|f - f_GSL| / |f_GSL|): 1.0636412229856690e-11
const testcase_conf_hyperg<double>
data063[21] =
{
  { -8.6671962318505780e-06, 20.000000000000000, 3.0000000000000000, 
	  -10.000000000000000 },
  { -1.8205565180535425e-05, 20.000000000000000, 3.0000000000000000, 
	  -9.0000000000000000 },
  { 1.5620588717927631e-05, 20.000000000000000, 3.0000000000000000, 
	  -8.0000000000000000 },
  { 7.6532767373103759e-05, 20.000000000000000, 3.0000000000000000, 
	  -7.0000000000000000 },
  { -5.2708600380172109e-05, 20.000000000000000, 3.0000000000000000, 
	  -6.0000000000000000 },
  { -0.00028546308121326275, 20.000000000000000, 3.0000000000000000, 
	  -5.0000000000000000 },
  { 0.00056490746026256267, 20.000000000000000, 3.0000000000000000, 
	  -4.0000000000000000 },
  { -5.0602588875468348e-07, 20.000000000000000, 3.0000000000000000, 
	  -3.0000000000000000 },
  { -0.0021376080642211692, 20.000000000000000, 3.0000000000000000, 
	  -2.0000000000000000 },
  { 0.0028873127225376104, 20.000000000000000, 3.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 3.0000000000000000, 
	  0.0000000000000000 },
  { 106.38207299128948, 20.000000000000000, 3.0000000000000000, 
	  1.0000000000000000 },
  { 2880.5734732831320, 20.000000000000000, 3.0000000000000000, 
	  2.0000000000000000 },
  { 47353.756965165718, 20.000000000000000, 3.0000000000000000, 
	  3.0000000000000000 },
  { 584732.27978148905, 20.000000000000000, 3.0000000000000000, 
	  4.0000000000000000 },
  { 5957333.1101320982, 20.000000000000000, 3.0000000000000000, 
	  5.0000000000000000 },
  { 52725595.633352734, 20.000000000000000, 3.0000000000000000, 
	  6.0000000000000000 },
  { 418560160.03369552, 20.000000000000000, 3.0000000000000000, 
	  7.0000000000000000 },
  { 3045067611.3150902, 20.000000000000000, 3.0000000000000000, 
	  8.0000000000000000 },
  { 20614600690.354652, 20.000000000000000, 3.0000000000000000, 
	  9.0000000000000000 },
  { 131344201933.74118, 20.000000000000000, 3.0000000000000000, 
	  10.000000000000000 },
};
const double toler063 = 1.0000000000000007e-09;

// Test data for a=20.000000000000000, c=4.0000000000000000.
// max(|f - f_GSL|): 1.5258789062500000e-05
// max(|f - f_GSL| / |f_GSL|): 1.8743522900030841e-11
const testcase_conf_hyperg<double>
data064[21] =
{
  { -1.1286669552452399e-06, 20.000000000000000, 4.0000000000000000, 
	  -10.000000000000000 },
  { 3.9595188785137704e-06, 20.000000000000000, 4.0000000000000000, 
	  -9.0000000000000000 },
  { 8.6940153052790051e-06, 20.000000000000000, 4.0000000000000000, 
	  -8.0000000000000000 },
  { -1.0858814018067509e-05, 20.000000000000000, 4.0000000000000000, 
	  -7.0000000000000000 },
  { -4.1826023828710966e-05, 20.000000000000000, 4.0000000000000000, 
	  -6.0000000000000000 },
  { 6.6455893622436316e-05, 20.000000000000000, 4.0000000000000000, 
	  -5.0000000000000000 },
  { 0.00014238710517977906, 20.000000000000000, 4.0000000000000000, 
	  -4.0000000000000000 },
  { -0.00071796294700866132, 20.000000000000000, 4.0000000000000000, 
	  -3.0000000000000000 },
  { 0.0020884061677332645, 20.000000000000000, 4.0000000000000000, 
	  -2.0000000000000000 },
  { -0.012768833157321973, 20.000000000000000, 4.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 4.0000000000000000, 
	  0.0000000000000000 },
  { 50.659916934657808, 20.000000000000000, 4.0000000000000000, 
	  1.0000000000000000 },
  { 1014.3134442335910, 20.000000000000000, 4.0000000000000000, 
	  2.0000000000000000 },
  { 13665.584449611577, 20.000000000000000, 4.0000000000000000, 
	  3.0000000000000000 },
  { 145123.62797278623, 20.000000000000000, 4.0000000000000000, 
	  4.0000000000000000 },
  { 1308144.4519382305, 20.000000000000000, 4.0000000000000000, 
	  5.0000000000000000 },
  { 10438124.578674613, 20.000000000000000, 4.0000000000000000, 
	  6.0000000000000000 },
  { 75719160.524424627, 20.000000000000000, 4.0000000000000000, 
	  7.0000000000000000 },
  { 508510905.96310252, 20.000000000000000, 4.0000000000000000, 
	  8.0000000000000000 },
  { 3203200954.5618095, 20.000000000000000, 4.0000000000000000, 
	  9.0000000000000000 },
  { 19111993543.124691, 20.000000000000000, 4.0000000000000000, 
	  10.000000000000000 },
};
const double toler064 = 1.0000000000000007e-09;

// Test data for a=20.000000000000000, c=5.0000000000000000.
// max(|f - f_GSL|): 3.3378601074218750e-06
// max(|f - f_GSL| / |f_GSL|): 1.7481076775232650e-09
const testcase_conf_hyperg<double>
data065[21] =
{
  { 8.4755643455671027e-07, 20.000000000000000, 5.0000000000000000, 
	  -10.000000000000000 },
  { 8.5721061862565697e-07, 20.000000000000000, 5.0000000000000000, 
	  -9.0000000000000000 },
  { -2.8228700837555599e-06, 20.000000000000000, 5.0000000000000000, 
	  -8.0000000000000000 },
  { -6.6486802159657585e-06, 20.000000000000000, 5.0000000000000000, 
	  -7.0000000000000000 },
  { 1.1816828026110384e-05, 20.000000000000000, 5.0000000000000000, 
	  -6.0000000000000000 },
  { 3.6173872819745774e-05, 20.000000000000000, 5.0000000000000000, 
	  -5.0000000000000000 },
  { -0.00011481934287296670, 20.000000000000000, 5.0000000000000000, 
	  -4.0000000000000000 },
  { 1.2650647218867087e-07, 20.000000000000000, 5.0000000000000000, 
	  -3.0000000000000000 },
  { 0.0010626537950495965, 20.000000000000000, 5.0000000000000000, 
	  -2.0000000000000000 },
  { -0.0085499011205641944, 20.000000000000000, 5.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 5.0000000000000000, 
	  0.0000000000000000 },
  { 29.126637808809392, 20.000000000000000, 5.0000000000000000, 
	  1.0000000000000000 },
  { 446.26914983518060, 20.000000000000000, 5.0000000000000000, 
	  2.0000000000000000 },
  { 5005.6470164856382, 20.000000000000000, 5.0000000000000000, 
	  3.0000000000000000 },
  { 46145.715220935184, 20.000000000000000, 5.0000000000000000, 
	  4.0000000000000000 },
  { 370342.18574452243, 20.000000000000000, 5.0000000000000000, 
	  5.0000000000000000 },
  { 2676402.7371661114, 20.000000000000000, 5.0000000000000000, 
	  6.0000000000000000 },
  { 17803174.102030005, 20.000000000000000, 5.0000000000000000, 
	  7.0000000000000000 },
  { 110674464.63597310, 20.000000000000000, 5.0000000000000000, 
	  8.0000000000000000 },
  { 650149739.34228492, 20.000000000000000, 5.0000000000000000, 
	  9.0000000000000000 },
  { 3639417243.5150661, 20.000000000000000, 5.0000000000000000, 
	  10.000000000000000 },
};
const double toler065 = 1.0000000000000005e-07;

// Test data for a=20.000000000000000, c=6.0000000000000000.
// max(|f - f_GSL|): 3.5762786865234375e-07
// max(|f - f_GSL| / |f_GSL|): 7.4494573571551227e-09
const testcase_conf_hyperg<double>
data066[21] =
{
  { -1.9022359545310046e-08, 20.000000000000000, 6.0000000000000000, 
	  -10.000000000000000 },
  { -7.4533809656234698e-07, 20.000000000000000, 6.0000000000000000, 
	  -9.0000000000000000 },
  { -9.7852420358724080e-07, 20.000000000000000, 6.0000000000000000, 
	  -8.0000000000000000 },
  { 3.0181569866746340e-06, 20.000000000000000, 6.0000000000000000, 
	  -7.0000000000000000 },
  { 7.9816910701457280e-06, 20.000000000000000, 6.0000000000000000, 
	  -6.0000000000000000 },
  { -2.0133163153966071e-05, 20.000000000000000, 6.0000000000000000, 
	  -5.0000000000000000 },
  { -4.7462368393259685e-05, 20.000000000000000, 6.0000000000000000, 
	  -4.0000000000000000 },
  { 0.00031910869938964821, 20.000000000000000, 6.0000000000000000, 
	  -3.0000000000000000 },
  { -0.0010380528468056441, 20.000000000000000, 6.0000000000000000, 
	  -2.0000000000000000 },
  { 0.0084752097558651058, 20.000000000000000, 6.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 6.0000000000000000, 
	  0.0000000000000000 },
  { 19.002159564861387, 20.000000000000000, 6.0000000000000000, 
	  1.0000000000000000 },
  { 229.93981298721295, 20.000000000000000, 6.0000000000000000, 
	  2.0000000000000000 },
  { 2180.3120758940972, 20.000000000000000, 6.0000000000000000, 
	  3.0000000000000000 },
  { 17610.732510305290, 20.000000000000000, 6.0000000000000000, 
	  4.0000000000000000 },
  { 126633.20907014767, 20.000000000000000, 6.0000000000000000, 
	  5.0000000000000000 },
  { 832692.83016874129, 20.000000000000000, 6.0000000000000000, 
	  6.0000000000000000 },
  { 5097225.0940651651, 20.000000000000000, 6.0000000000000000, 
	  7.0000000000000000 },
  { 29414585.342530526, 20.000000000000000, 6.0000000000000000, 
	  8.0000000000000000 },
  { 161513229.88138971, 20.000000000000000, 6.0000000000000000, 
	  9.0000000000000000 },
  { 849871092.10959554, 20.000000000000000, 6.0000000000000000, 
	  10.000000000000000 },
};
const double toler066 = 5.0000000000000019e-07;

// Test data for a=20.000000000000000, c=7.0000000000000000.
// max(|f - f_GSL|): 1.7881393432617188e-07
// max(|f - f_GSL| / |f_GSL|): 2.3690711970375556e-09
const testcase_conf_hyperg<double>
data067[21] =
{
  { -1.7754301607387146e-07, 20.000000000000000, 7.0000000000000000, 
	  -10.000000000000000 },
  { -6.2128605089471266e-08, 20.000000000000000, 7.0000000000000000, 
	  -9.0000000000000000 },
  { 9.1338873372533148e-07, 20.000000000000000, 7.0000000000000000, 
	  -8.0000000000000000 },
  { 1.6657400269273180e-06, 20.000000000000000, 7.0000000000000000, 
	  -7.0000000000000000 },
  { -4.7904165143355465e-06, 20.000000000000000, 7.0000000000000000, 
	  -6.0000000000000000 },
  { -1.5503088351319618e-05, 20.000000000000000, 7.0000000000000000, 
	  -5.0000000000000000 },
  { 5.6425108496954337e-05, 20.000000000000000, 7.0000000000000000, 
	  -4.0000000000000000 },
  { 9.1083552345479015e-05, 20.000000000000000, 7.0000000000000000, 
	  -3.0000000000000000 },
  { -0.0018058773247853388, 20.000000000000000, 7.0000000000000000, 
	  -2.0000000000000000 },
  { 0.032850147696977743, 20.000000000000000, 7.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 7.0000000000000000, 
	  0.0000000000000000 },
  { 13.551527852090807, 20.000000000000000, 7.0000000000000000, 
	  1.0000000000000000 },
  { 133.23579819973105, 20.000000000000000, 7.0000000000000000, 
	  2.0000000000000000 },
  { 1083.6769250393436, 20.000000000000000, 7.0000000000000000, 
	  3.0000000000000000 },
  { 7739.1410905637622, 20.000000000000000, 7.0000000000000000, 
	  4.0000000000000000 },
  { 50175.328973240226, 20.000000000000000, 7.0000000000000000, 
	  5.0000000000000000 },
  { 301599.46814102860, 20.000000000000000, 7.0000000000000000, 
	  6.0000000000000000 },
  { 1705051.1866143662, 20.000000000000000, 7.0000000000000000, 
	  7.0000000000000000 },
  { 9159788.2353733145, 20.000000000000000, 7.0000000000000000, 
	  8.0000000000000000 },
  { 47122070.398665302, 20.000000000000000, 7.0000000000000000, 
	  9.0000000000000000 },
  { 233529421.53991735, 20.000000000000000, 7.0000000000000000, 
	  10.000000000000000 },
};
const double toler067 = 2.5000000000000009e-07;

// Test data for a=20.000000000000000, c=8.0000000000000000.
// max(|f - f_GSL|): 5.9604644775390625e-08
// max(|f - f_GSL| / |f_GSL|): 1.2249590184458766e-09
const testcase_conf_hyperg<double>
data068[21] =
{
  { 4.4385719622857099e-08, 20.000000000000000, 8.0000000000000000, 
	  -10.000000000000000 },
  { 2.7870855352561944e-07, 20.000000000000000, 8.0000000000000000, 
	  -9.0000000000000000 },
  { 2.7221706037028333e-07, 20.000000000000000, 8.0000000000000000, 
	  -8.0000000000000000 },
  { -1.5211293805365477e-06, 20.000000000000000, 8.0000000000000000, 
	  -7.0000000000000000 },
  { -4.2978336531553913e-06, 20.000000000000000, 8.0000000000000000, 
	  -6.0000000000000000 },
  { 1.1339557446266733e-05, 20.000000000000000, 8.0000000000000000, 
	  -5.0000000000000000 },
  { 5.3526365220658988e-05, 20.000000000000000, 8.0000000000000000, 
	  -4.0000000000000000 },
  { -0.00029461053269513242, 20.000000000000000, 8.0000000000000000, 
	  -3.0000000000000000 },
  { -0.00026793636646740143, 20.000000000000000, 8.0000000000000000, 
	  -2.0000000000000000 },
  { 0.061061258434452807, 20.000000000000000, 8.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 8.0000000000000000, 
	  0.0000000000000000 },
  { 10.312756690132909, 20.000000000000000, 8.0000000000000000, 
	  1.0000000000000000 },
  { 84.471824856846425, 20.000000000000000, 8.0000000000000000, 
	  2.0000000000000000 },
  { 597.47335666854985, 20.000000000000000, 8.0000000000000000, 
	  3.0000000000000000 },
  { 3805.9786364107408, 20.000000000000000, 8.0000000000000000, 
	  4.0000000000000000 },
  { 22386.068461641658, 20.000000000000000, 8.0000000000000000, 
	  5.0000000000000000 },
  { 123573.63516975302, 20.000000000000000, 8.0000000000000000, 
	  6.0000000000000000 },
  { 647514.24141570868, 20.000000000000000, 8.0000000000000000, 
	  7.0000000000000000 },
  { 3247628.2434586394, 20.000000000000000, 8.0000000000000000, 
	  8.0000000000000000 },
  { 15690070.625286419, 20.000000000000000, 8.0000000000000000, 
	  9.0000000000000000 },
  { 73379158.893325046, 20.000000000000000, 8.0000000000000000, 
	  10.000000000000000 },
};
const double toler068 = 1.0000000000000005e-07;

// Test data for a=20.000000000000000, c=9.0000000000000000.
// max(|f - f_GSL|): 7.4505805969238281e-09
// max(|f - f_GSL| / |f_GSL|): 1.7712852063552690e-08
const testcase_conf_hyperg<double>
data069[21] =
{
  { 7.3976263576568592e-08, 20.000000000000000, 9.0000000000000000, 
	  -10.000000000000000 },
  { -9.0753238092548168e-09, 20.000000000000000, 9.0000000000000000, 
	  -9.0000000000000000 },
  { -5.5549484970396693e-07, 20.000000000000000, 9.0000000000000000, 
	  -8.0000000000000000 },
  { -1.1104933512848787e-06, 20.000000000000000, 9.0000000000000000, 
	  -7.0000000000000000 },
  { 3.2483424385770483e-06, 20.000000000000000, 9.0000000000000000, 
	  -6.0000000000000000 },
  { 1.7493431113569438e-05, 20.000000000000000, 9.0000000000000000, 
	  -5.0000000000000000 },
  { -3.9066110636117233e-05, 20.000000000000000, 9.0000000000000000, 
	  -4.0000000000000000 },
  { -0.00040356155493308509, 20.000000000000000, 9.0000000000000000, 
	  -3.0000000000000000 },
  { 0.0037671531470534550, 20.000000000000000, 9.0000000000000000, 
	  -2.0000000000000000 },
  { 0.090944344485248435, 20.000000000000000, 9.0000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 9.0000000000000000, 
	  0.0000000000000000 },
  { 8.2390942957149722, 20.000000000000000, 9.0000000000000000, 
	  1.0000000000000000 },
  { 57.468054562166706, 20.000000000000000, 9.0000000000000000, 
	  2.0000000000000000 },
  { 358.00109079775746, 20.000000000000000, 9.0000000000000000, 
	  3.0000000000000000 },
  { 2051.3704389047002, 20.000000000000000, 9.0000000000000000, 
	  4.0000000000000000 },
  { 11012.597503064209, 20.000000000000000, 9.0000000000000000, 
	  5.0000000000000000 },
  { 56082.113308934473, 20.000000000000000, 9.0000000000000000, 
	  6.0000000000000000 },
  { 273348.46918863337, 20.000000000000000, 9.0000000000000000, 
	  7.0000000000000000 },
  { 1283674.4996444662, 20.000000000000000, 9.0000000000000000, 
	  8.0000000000000000 },
  { 5838026.8730425332, 20.000000000000000, 9.0000000000000000, 
	  9.0000000000000000 },
  { 25817349.972859699, 20.000000000000000, 9.0000000000000000, 
	  10.000000000000000 },
};
const double toler069 = 1.0000000000000004e-06;

// Test data for a=20.000000000000000, c=10.000000000000000.
// max(|f - f_GSL|): 1.8626451492309570e-09
// max(|f - f_GSL| / |f_GSL|): 3.6960743356593788e-09
const testcase_conf_hyperg<double>
data070[21] =
{
  { -4.1157677792944960e-08, 20.000000000000000, 10.000000000000000, 
	  -10.000000000000000 },
  { -2.0187210039960914e-07, 20.000000000000000, 10.000000000000000, 
	  -9.0000000000000000 },
  { -2.2272304939386817e-07, 20.000000000000000, 10.000000000000000, 
	  -8.0000000000000000 },
  { 1.2925568212606171e-06, 20.000000000000000, 10.000000000000000, 
	  -7.0000000000000000 },
  { 5.5744573775996210e-06, 20.000000000000000, 10.000000000000000, 
	  -6.0000000000000000 },
  { -6.2568272011787289e-06, 20.000000000000000, 10.000000000000000, 
	  -5.0000000000000000 },
  { -0.00011955177906335608, 20.000000000000000, 10.000000000000000, 
	  -4.0000000000000000 },
  { 9.2475405516991146e-05, 20.000000000000000, 10.000000000000000, 
	  -3.0000000000000000 },
  { 0.010123531287569976, 20.000000000000000, 10.000000000000000, 
	  -2.0000000000000000 },
  { 0.12118937229909534, 20.000000000000000, 10.000000000000000, 
	  -1.0000000000000000 },
  { 1.0000000000000000, 20.000000000000000, 10.000000000000000, 
	  0.0000000000000000 },
  { 6.8319857942415538, 20.000000000000000, 10.000000000000000, 
	  1.0000000000000000 },
  { 41.356658140815220, 20.000000000000000, 10.000000000000000, 
	  2.0000000000000000 },
  { 229.57496033810904, 20.000000000000000, 10.000000000000000, 
	  3.0000000000000000 },
  { 1192.7830549969501, 20.000000000000000, 10.000000000000000, 
	  4.0000000000000000 },
  { 5878.6003887215920, 20.000000000000000, 10.000000000000000, 
	  5.0000000000000000 },
  { 27741.749322673899, 20.000000000000000, 10.000000000000000, 
	  6.0000000000000000 },
  { 126220.54599305880, 20.000000000000000, 10.000000000000000, 
	  7.0000000000000000 },
  { 556592.10886612453, 20.000000000000000, 10.000000000000000, 
	  8.0000000000000000 },
  { 2388555.2873243927, 20.000000000000000, 10.000000000000000, 
	  9.0000000000000000 },
  { 10008079.497419352, 20.000000000000000, 10.000000000000000, 
	  10.000000000000000 },
};
const double toler070 = 2.5000000000000009e-07;

template<typename Tp, unsigned int Num>
  void
  test(const testcase_conf_hyperg<Tp> (&data)[Num], Tp toler)
  {
    const Tp eps = std::numeric_limits<Tp>::epsilon();
    Tp max_abs_diff = -Tp(1);
    Tp max_abs_frac = -Tp(1);
    unsigned int num_datum = Num;
    for (unsigned int i = 0; i < num_datum; ++i)
  	 {
	const Tp f = __gnu_cxx::conf_hyperg(data[i].a, data[i].c,
		     data[i].x);
	const Tp f0 = data[i].f0;
	const Tp diff = f - f0;
	if (std::abs(diff) > max_abs_diff)
	  max_abs_diff = std::abs(diff);
	if (std::abs(f0) > Tp(10) * eps
	 && std::abs(f) > Tp(10) * eps)
	  {
	    const Tp frac = diff / f0;
	    if (std::abs(frac) > max_abs_frac)
	      max_abs_frac = std::abs(frac);
	  }
      }
    VERIFY(max_abs_frac < toler);
  }

int
main()
{
  test(data001, toler001);
  test(data002, toler002);
  test(data003, toler003);
  test(data004, toler004);
  test(data005, toler005);
  test(data006, toler006);
  test(data007, toler007);
  test(data008, toler008);
  test(data009, toler009);
  test(data010, toler010);
  test(data011, toler011);
  test(data012, toler012);
  test(data013, toler013);
  test(data014, toler014);
  test(data015, toler015);
  test(data016, toler016);
  test(data017, toler017);
  test(data018, toler018);
  test(data019, toler019);
  test(data020, toler020);
  test(data021, toler021);
  test(data022, toler022);
  test(data023, toler023);
  test(data024, toler024);
  test(data025, toler025);
  test(data026, toler026);
  test(data027, toler027);
  test(data028, toler028);
  test(data029, toler029);
  test(data030, toler030);
  test(data031, toler031);
  test(data032, toler032);
  test(data033, toler033);
  test(data034, toler034);
  test(data035, toler035);
  test(data036, toler036);
  test(data037, toler037);
  test(data038, toler038);
  test(data039, toler039);
  test(data040, toler040);
  test(data041, toler041);
  test(data042, toler042);
  test(data043, toler043);
  test(data044, toler044);
  test(data045, toler045);
  test(data046, toler046);
  test(data047, toler047);
  test(data048, toler048);
  test(data049, toler049);
  test(data050, toler050);
  test(data051, toler051);
  test(data052, toler052);
  test(data053, toler053);
  test(data054, toler054);
  test(data055, toler055);
  test(data056, toler056);
  test(data057, toler057);
  test(data058, toler058);
  test(data059, toler059);
  test(data060, toler060);
  test(data061, toler061);
  test(data062, toler062);
  test(data063, toler063);
  test(data064, toler064);
  test(data065, toler065);
  test(data066, toler066);
  test(data067, toler067);
  test(data068, toler068);
  test(data069, toler069);
  test(data070, toler070);
  return 0;
}
