// REQUIRES: riscv-registered-target
// RUN: %clang --target=riscv64 -mcpu=sifive-x390 -menable-experimental-extensions --print-enabled-extensions | FileCheck %s

// CHECK:     Name                 Version   Description
// CHECK-NEXT:     i                    2.1       'I' (Base Integer Instruction Set)
// CHECK-NEXT:     m                    2.0       'M' (Integer Multiplication and Division)
// CHECK-NEXT:     a                    2.1       'A' (Atomic Instructions)
// CHECK-NEXT:     f                    2.2       'F' (Single-Precision Floating-Point)
// CHECK-NEXT:     d                    2.2       'D' (Double-Precision Floating-Point)
// CHECK-NEXT:     c                    2.0       'C' (Compressed Instructions)
// CHECK-NEXT:     b                    1.0       'B' (the collection of the Zba, Zbb, Zbs extensions)
// CHECK-NEXT:     v                    1.0       'V' (Vector Extension for Application Processors)
// CHECK-NEXT:     zic64b               1.0       'Zic64b' (Cache Block Size Is 64 Bytes)
// CHECK-NEXT:     zicbom               1.0       'Zicbom' (Cache-Block Management Instructions)
// CHECK-NEXT:     zicbop               1.0       'Zicbop' (Cache-Block Prefetch Instructions)
// CHECK-NEXT:     zicboz               1.0       'Zicboz' (Cache-Block Zero Instructions)
// CHECK-NEXT:     ziccamoa             1.0       'Ziccamoa' (Main Memory Supports All Atomics in A)
// CHECK-NEXT:     ziccif               1.0       'Ziccif' (Main Memory Supports Instruction Fetch with Atomicity Requirement)
// CHECK-NEXT:     ziccrse              1.0       'Ziccrse' (Main Memory Supports Forward Progress on LR/SC Sequences)
// CHECK-NEXT:     zicntr               2.0       'Zicntr' (Base Counters and Timers)
// CHECK-NEXT:     zicond               1.0       'Zicond' (Integer Conditional Operations)
// CHECK-NEXT:     zicsr                2.0       'Zicsr' (CSRs)
// CHECK-NEXT:     zifencei             2.0       'Zifencei' (fence.i)
// CHECK-NEXT:     zihintntl            1.0       'Zihintntl' (Non-Temporal Locality Hints)
// CHECK-NEXT:     zihintpause          2.0       'Zihintpause' (Pause Hint)
// CHECK-NEXT:     zihpm                2.0       'Zihpm' (Hardware Performance Counters)
// CHECK-NEXT:     zimop                1.0       'Zimop' (May-Be-Operations)
// CHECK-NEXT:     zmmul                1.0       'Zmmul' (Integer Multiplication)
// CHECK-NEXT:     za64rs               1.0       'Za64rs' (Reservation Set Size of at Most 64 Bytes)
// CHECK-NEXT:     zaamo                1.0       'Zaamo' (Atomic Memory Operations)
// CHECK-NEXT:     zalrsc               1.0       'Zalrsc' (Load-Reserved/Store-Conditional)
// CHECK-NEXT:     zawrs                1.0       'Zawrs' (Wait on Reservation Set)
// CHECK-NEXT:     zfa                  1.0       'Zfa' (Additional Floating-Point)
// CHECK-NEXT:     zfbfmin              1.0       'Zfbfmin' (Scalar BF16 Converts)
// CHECK-NEXT:     zfh                  1.0       'Zfh' (Half-Precision Floating-Point)
// CHECK-NEXT:     zfhmin               1.0       'Zfhmin' (Half-Precision Floating-Point Minimal)
// CHECK-NEXT:     zca                  1.0       'Zca' (part of the C extension, excluding compressed floating point loads/stores)
// CHECK-NEXT:     zcb                  1.0       'Zcb' (Compressed basic bit manipulation instructions)
// CHECK-NEXT:     zcd                  1.0       'Zcd' (Compressed Double-Precision Floating-Point Instructions)
// CHECK-NEXT:     zcmop                1.0       'Zcmop' (Compressed May-Be-Operations)
// CHECK-NEXT:     zba                  1.0       'Zba' (Address Generation Instructions)
// CHECK-NEXT:     zbb                  1.0       'Zbb' (Basic Bit-Manipulation)
// CHECK-NEXT:     zbs                  1.0       'Zbs' (Single-Bit Instructions)
// CHECK-NEXT:     zkr                  1.0       'Zkr' (Entropy Source Extension)
// CHECK-NEXT:     zkt                  1.0       'Zkt' (Data Independent Execution Latency)
// CHECK-NEXT:     zvbb                 1.0       'Zvbb' (Vector basic bit-manipulation instructions)
// CHECK-NEXT:     zve32f               1.0       'Zve32f' (Vector Extensions for Embedded Processors with maximal 32 EEW and F extension)
// CHECK-NEXT:     zve32x               1.0       'Zve32x' (Vector Extensions for Embedded Processors with maximal 32 EEW)
// CHECK-NEXT:     zve64d               1.0       'Zve64d' (Vector Extensions for Embedded Processors with maximal 64 EEW, F and D extension)
// CHECK-NEXT:     zve64f               1.0       'Zve64f' (Vector Extensions for Embedded Processors with maximal 64 EEW and F extension)
// CHECK-NEXT:     zve64x               1.0       'Zve64x' (Vector Extensions for Embedded Processors with maximal 64 EEW)
// CHECK-NEXT:     zvfbfmin             1.0       'Zvfbfmin' (Vector BF16 Converts)
// CHECK-NEXT:     zvfbfwma             1.0       'Zvfbfwma' (Vector BF16 widening mul-add)
// CHECK-NEXT:     zvfh                 1.0       'Zvfh' (Vector Half-Precision Floating-Point)
// CHECK-NEXT:     zvfhmin              1.0       'Zvfhmin' (Vector Half-Precision Floating-Point Minimal)
// CHECK-NEXT:     zvkb                 1.0       'Zvkb' (Vector Bit-manipulation used in Cryptography)
// CHECK-NEXT:     zvkt                 1.0       'Zvkt' (Vector Data-Independent Execution Latency)
// CHECK-NEXT:     zvl1024b             1.0       'Zvl1024b' (Minimum Vector Length 1024)
// CHECK-NEXT:     zvl128b              1.0       'Zvl128b' (Minimum Vector Length 128)
// CHECK-NEXT:     zvl256b              1.0       'Zvl256b' (Minimum Vector Length 256)
// CHECK-NEXT:     zvl32b               1.0       'Zvl32b' (Minimum Vector Length 32)
// CHECK-NEXT:     zvl512b              1.0       'Zvl512b' (Minimum Vector Length 512)
// CHECK-NEXT:     zvl64b               1.0       'Zvl64b' (Minimum Vector Length 64)
// CHECK-NEXT:     xsifivecdiscarddlone 1.0       'XSiFivecdiscarddlone' (SiFive sf.cdiscard.d.l1 Instruction)
// CHECK-NEXT:     xsifivecflushdlone   1.0       'XSiFivecflushdlone' (SiFive sf.cflush.d.l1 Instruction)
// CHECK-EMPTY:
// CHECK-NEXT: Experimental extensions
// CHECK-NEXT:     zicfilp              1.0       'Zicfilp' (Landing pad)
// CHECK-NEXT:     zicfiss              1.0       'Zicfiss' (Shadow stack)
// CHECK-EMPTY:
// CHECK-NEXT: ISA String: rv64i2p1_m2p0_a2p1_f2p2_d2p2_c2p0_b1p0_v1p0_zic64b1p0_zicbom1p0_zicbop1p0_zicboz1p0_ziccamoa1p0_ziccif1p0_ziccrse1p0_zicfilp1p0_zicfiss1p0_zicntr2p0_zicond1p0_zicsr2p0_zifencei2p0_zihintntl1p0_zihintpause2p0_zihpm2p0_zimop1p0_zmmul1p0_za64rs1p0_zaamo1p0_zalrsc1p0_zawrs1p0_zfa1p0_zfbfmin1p0_zfh1p0_zfhmin1p0_zca1p0_zcb1p0_zcd1p0_zcmop1p0_zba1p0_zbb1p0_zbs1p0_zkr1p0_zkt1p0_zvbb1p0_zve32f1p0_zve32x1p0_zve64d1p0_zve64f1p0_zve64x1p0_zvfbfmin1p0_zvfbfwma1p0_zvfh1p0_zvfhmin1p0_zvkb1p0_zvkt1p0_zvl1024b1p0_zvl128b1p0_zvl256b1p0_zvl32b1p0_zvl512b1p0_zvl64b1p0_xsifivecdiscarddlone1p0_xsifivecflushdlone1p0
