; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=xtensa -verify-machineinstrs < %s \
; RUN:   | FileCheck %s

define i32 @lshl(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: lshl:
; CHECK:         ssl a3
; CHECK-NEXT:    sll a2, a2
; CHECK-NEXT:    ret
  %c = shl i32 %x, %y
  ret i32 %c
}

define i32 @lshl_imm_1(i32 %x) nounwind {
; CHECK-LABEL: lshl_imm_1:
; CHECK:         slli a2, a2, 1
; CHECK-NEXT:    ret
  %c = shl i32 %x, 1
  ret i32 %c
}

define i32 @lshl_imm_10(i32 %x) nounwind {
; CHECK-LABEL: lshl_imm_10:
; CHECK:         slli a2, a2, 10
; CHECK-NEXT:    ret
  %c = shl i32 %x, 10
  ret i32 %c
}

define i32 @lshl_imm_31(i32 %x) nounwind {
; CHECK-LABEL: lshl_imm_31:
; CHECK:         slli a2, a2, 31
; CHECK-NEXT:    ret
  %c = shl i32 %x, 31
  ret i32 %c
}

define i32 @lshr(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: lshr:
; CHECK:         ssr a3
; CHECK-NEXT:    srl a2, a2
; CHECK-NEXT:    ret
  %c = lshr i32 %x, %y
  ret i32 %c
}

define i32 @lshr_imm_1(i32 %x) nounwind {
; CHECK-LABEL: lshr_imm_1:
; CHECK:         srli a2, a2, 1
; CHECK-NEXT:    ret
  %c = lshr i32 %x, 1
  ret i32 %c
}

define i32 @lshr_imm_15(i32 %x) nounwind {
; CHECK-LABEL: lshr_imm_15:
; CHECK:         srli a2, a2, 15
; CHECK-NEXT:    ret
  %c = lshr i32 %x, 15
  ret i32 %c
}

define i32 @lshr_imm_20(i32 %x) nounwind {
; CHECK-LABEL: lshr_imm_20:
; CHECK:         extui a2, a2, 20, 12
; CHECK-NEXT:    ret
  %c = lshr i32 %x, 20
  ret i32 %c
}

define i32 @ashr(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: ashr:
; CHECK:         ssr a3
; CHECK-NEXT:    sra a2, a2
; CHECK-NEXT:    ret
  %c = ashr i32 %x, %y
  ret i32 %c
}

define i32 @ashr_imm_1(i32 %x) nounwind {
; CHECK-LABEL: ashr_imm_1:
; CHECK:         srai a2, a2, 1
; CHECK-NEXT:    ret
  %c = ashr i32 %x, 1
  ret i32 %c
}

define i32 @ashr_imm_10(i32 %x) nounwind {
; CHECK-LABEL: ashr_imm_10:
; CHECK:         srai a2, a2, 10
; CHECK-NEXT:    ret
  %c = ashr i32 %x, 10
  ret i32 %c
}

define i32 @ashr_imm_31(i32 %x) nounwind {
; CHECK-LABEL: ashr_imm_31:
; CHECK:         srai a2, a2, 31
; CHECK-NEXT:    ret
  %c = ashr i32 %x, 31
  ret i32 %c
}

define i64 @lshl_64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: lshl_64:
; CHECK:         ssl a4
; CHECK-NEXT:    src a3, a3, a2
; CHECK-NEXT:    addi a8, a4, -32
; CHECK-NEXT:    ssl a8
; CHECK-NEXT:    sll a10, a2
; CHECK-NEXT:    movi a9, 0
; CHECK-NEXT:    blt a8, a9, .LBB12_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    or a3, a10, a10
; CHECK-NEXT:  .LBB12_2:
; CHECK-NEXT:    ssl a4
; CHECK-NEXT:    sll a2, a2
; CHECK-NEXT:    blt a8, a9, .LBB12_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    or a2, a9, a9
; CHECK-NEXT:  .LBB12_4:
; CHECK-NEXT:    ret
  %c = shl i64 %x, %y
  ret i64 %c
}

define i64 @lshr_64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: lshr_64:
; CHECK:         ssr a4
; CHECK-NEXT:    src a2, a3, a2
; CHECK-NEXT:    addi a8, a4, -32
; CHECK-NEXT:    ssr a8
; CHECK-NEXT:    srl a10, a3
; CHECK-NEXT:    movi a9, 0
; CHECK-NEXT:    blt a8, a9, .LBB13_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    or a2, a10, a10
; CHECK-NEXT:  .LBB13_2:
; CHECK-NEXT:    ssr a4
; CHECK-NEXT:    srl a3, a3
; CHECK-NEXT:    blt a8, a9, .LBB13_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    or a3, a9, a9
; CHECK-NEXT:  .LBB13_4:
; CHECK-NEXT:    ret
  %c = lshr i64 %x, %y
  ret i64 %c
}

define i64 @ashr_64(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: ashr_64:
; CHECK:         ssr a4
; CHECK-NEXT:    src a2, a3, a2
; CHECK-NEXT:    addi a9, a4, -32
; CHECK-NEXT:    ssr a9
; CHECK-NEXT:    sra a8, a3
; CHECK-NEXT:    movi a10, 0
; CHECK-NEXT:    blt a9, a10, .LBB14_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    or a2, a8, a8
; CHECK-NEXT:  .LBB14_2:
; CHECK-NEXT:    ssr a4
; CHECK-NEXT:    sra a8, a3
; CHECK-NEXT:    blt a9, a10, .LBB14_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    srai a8, a3, 31
; CHECK-NEXT:  .LBB14_4:
; CHECK-NEXT:    or a3, a8, a8
; CHECK-NEXT:    ret
  %c = ashr i64 %x, %y
  ret i64 %c
}
