; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-promote-alloca < %s | FileCheck %s

; Check that types where the store/allocation sizes don't match the type size
; don't crash.


define <7 x i9> @load_elem_i9_access_7xi9() {
; CHECK-LABEL: @load_elem_i9_access_7xi9(
; CHECK-NEXT:    [[P:%.*]] = alloca <16 x i9>, align 1, addrspace(5)
; CHECK-NEXT:    [[G:%.*]] = getelementptr i8, ptr addrspace(5) [[P]], i64 4
; CHECK-NEXT:    [[L:%.*]] = load <7 x i9>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <7 x i9> [[L]]
;
  %p = alloca <16 x i9>, align 1, addrspace(5)
  %g = getelementptr i8, ptr addrspace(5) %p, i64 4
  %l = load <7 x i9>, ptr addrspace(5) %g, align 1
  ret <7 x i9> %l
}

define <8 x i1> @load_elem_i1_access_8xi1() {
; CHECK-LABEL: @load_elem_i1_access_8xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca <16 x i1>, align 1, addrspace(5)
; CHECK-NEXT:    [[G:%.*]] = getelementptr i8, ptr addrspace(5) [[P]], i64 4
; CHECK-NEXT:    [[L:%.*]] = load <8 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <8 x i1> [[L]]
;
  %p = alloca <16 x i1>, align 1, addrspace(5)
  %g = getelementptr i8, ptr addrspace(5) %p, i64 4
  %l = load <8 x i1>, ptr addrspace(5) %g, align 1
  ret <8 x i1> %l
}

define <3 x i1> @load_elem_i1_access_3xi1() {
; CHECK-LABEL: @load_elem_i1_access_3xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca <16 x i1>, align 1, addrspace(5)
; CHECK-NEXT:    [[G:%.*]] = getelementptr i8, ptr addrspace(5) [[P]], i64 4
; CHECK-NEXT:    [[L:%.*]] = load <3 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <3 x i1> [[L]]
;
  %p = alloca <16 x i1>, align 1, addrspace(5)
  %g = getelementptr i8, ptr addrspace(5) %p, i64 4
  %l = load <3 x i1>, ptr addrspace(5) %g, align 1
  ret <3 x i1> %l
}

define <3 x i1> @load_elem_i8_access_3xi1() {
; CHECK-LABEL: @load_elem_i8_access_3xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca <8 x i8>, align 1, addrspace(5)
; CHECK-NEXT:    store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) [[P]], align 1
; CHECK-NEXT:    [[G:%.*]] = getelementptr <4 x i8>, ptr addrspace(5) [[P]], i64 1
; CHECK-NEXT:    [[L:%.*]] = load <3 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <3 x i1> [[L]]
;
  %p = alloca <8 x i8>, align 1, addrspace(5)
  store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) %p, align 1
  %g = getelementptr <4 x i8>, ptr addrspace(5) %p, i64 1
  %l = load <3 x i1>, ptr addrspace(5) %g, align 1
  ret <3 x i1> %l
}

; This one is actually not problematic.
define <8 x i1> @load_elem_i8_access_8xi1() {
; CHECK-LABEL: @load_elem_i8_access_8xi1(
; CHECK-NEXT:    [[P:%.*]] = freeze <8 x i8> poison
; CHECK-NEXT:    ret <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>
;
  %p = alloca <8 x i8>, align 1, addrspace(5)
  store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) %p, align 1
  %g = getelementptr <4 x i8>, ptr addrspace(5) %p, i64 1
  %l = load <8 x i1>, ptr addrspace(5) %g, align 1
  ret <8 x i1> %l
}

define <8 x i1> @storeload_elem_i1_access_8xi1() {
; CHECK-LABEL: @storeload_elem_i1_access_8xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca <16 x i1>, align 1, addrspace(5)
; CHECK-NEXT:    [[G:%.*]] = getelementptr i8, ptr addrspace(5) [[P]], i64 4
; CHECK-NEXT:    store <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    [[L:%.*]] = load <8 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <8 x i1> [[L]]
;
  %p = alloca <16 x i1>, align 1, addrspace(5)
  %g = getelementptr i8, ptr addrspace(5) %p, i64 4
  store <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, ptr addrspace(5) %g, align 1
  %l = load <8 x i1>, ptr addrspace(5) %g, align 1
  ret <8 x i1> %l
}

define <3 x i1> @storeload_elem_i1_access_3xi1() {
; CHECK-LABEL: @storeload_elem_i1_access_3xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca <16 x i1>, align 1, addrspace(5)
; CHECK-NEXT:    [[G:%.*]] = getelementptr i8, ptr addrspace(5) [[P]], i64 4
; CHECK-NEXT:    store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    [[L:%.*]] = load <3 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <3 x i1> [[L]]
;
  %p = alloca <16 x i1>, align 1, addrspace(5)
  %g = getelementptr i8, ptr addrspace(5) %p, i64 4
  store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) %g, align 1
  %l = load <3 x i1>, ptr addrspace(5) %g, align 1
  ret <3 x i1> %l
}

define <3 x i1> @storeload_elem_i8_access_3xi1() {
; CHECK-LABEL: @storeload_elem_i8_access_3xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca <8 x i8>, align 1, addrspace(5)
; CHECK-NEXT:    store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) [[P]], align 1
; CHECK-NEXT:    [[G:%.*]] = getelementptr <4 x i8>, ptr addrspace(5) [[P]], i64 1
; CHECK-NEXT:    store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    [[L:%.*]] = load <3 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <3 x i1> [[L]]
;
  %p = alloca <8 x i8>, align 1, addrspace(5)
  store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) %p, align 1
  %g = getelementptr <4 x i8>, ptr addrspace(5) %p, i64 1
  store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) %g, align 1
  %l = load <3 x i1>, ptr addrspace(5) %g, align 1
  ret <3 x i1> %l
}

; This one is actually not problematic.
define <8 x i1> @storeload_elem_i8_access_8xi1() {
; CHECK-LABEL: @storeload_elem_i8_access_8xi1(
; CHECK-NEXT:    [[P:%.*]] = freeze <8 x i8> poison
; CHECK-NEXT:    ret <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>
;
  %p = alloca <8 x i8>, align 1, addrspace(5)
  store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) %p, align 1
  %g = getelementptr <4 x i8>, ptr addrspace(5) %p, i64 1
  store <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, ptr addrspace(5) %g, align 1
  %l = load <8 x i1>, ptr addrspace(5) %g, align 1
  ret <8 x i1> %l
}

define <8 x i1> @array_of_vec_elem_i1_access_8xi1() {
; CHECK-LABEL: @array_of_vec_elem_i1_access_8xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca [2 x <16 x i1>], align 1, addrspace(5)
; CHECK-NEXT:    [[G:%.*]] = getelementptr i8, ptr addrspace(5) [[P]], i64 4
; CHECK-NEXT:    store <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    [[L:%.*]] = load <8 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <8 x i1> [[L]]
;
  %p = alloca [2 x <16 x i1>], align 1, addrspace(5)
  %g = getelementptr i8, ptr addrspace(5) %p, i64 4
  store <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, ptr addrspace(5) %g, align 1
  %l = load <8 x i1>, ptr addrspace(5) %g, align 1
  ret <8 x i1> %l
}

define <3 x i1> @array_of_vec_elem_i1_access_3xi1() {
; CHECK-LABEL: @array_of_vec_elem_i1_access_3xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca [2 x <16 x i1>], align 1, addrspace(5)
; CHECK-NEXT:    [[G:%.*]] = getelementptr i8, ptr addrspace(5) [[P]], i64 4
; CHECK-NEXT:    store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    [[L:%.*]] = load <3 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <3 x i1> [[L]]
;
  %p = alloca [2 x <16 x i1>], align 1, addrspace(5)
  %g = getelementptr i8, ptr addrspace(5) %p, i64 4
  store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) %g, align 1
  %l = load <3 x i1>, ptr addrspace(5) %g, align 1
  ret <3 x i1> %l
}

define <3 x i1> @array_of_vec_elem_i8_access_3xi1() {
; CHECK-LABEL: @array_of_vec_elem_i8_access_3xi1(
; CHECK-NEXT:    [[P:%.*]] = alloca [2 x <8 x i8>], align 1, addrspace(5)
; CHECK-NEXT:    store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) [[P]], align 1
; CHECK-NEXT:    [[G:%.*]] = getelementptr <4 x i8>, ptr addrspace(5) [[P]], i64 1
; CHECK-NEXT:    store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    [[L:%.*]] = load <3 x i1>, ptr addrspace(5) [[G]], align 1
; CHECK-NEXT:    ret <3 x i1> [[L]]
;
  %p = alloca [2 x <8 x i8>], align 1, addrspace(5)
  store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) %p, align 1
  %g = getelementptr <4 x i8>, ptr addrspace(5) %p, i64 1
  store <3 x i1> <i1 true, i1 false, i1 true>, ptr addrspace(5) %g, align 1
  %l = load <3 x i1>, ptr addrspace(5) %g, align 1
  ret <3 x i1> %l
}

; This one is actually not problematic.
define <8 x i1> @array_of_vec_elem_i8_access_8xi1() {
; CHECK-LABEL: @array_of_vec_elem_i8_access_8xi1(
; CHECK-NEXT:    [[P:%.*]] = freeze <16 x i8> poison
; CHECK-NEXT:    [[TMP1:%.*]] = insertelement <16 x i8> [[P]], i8 1, i32 0
; CHECK-NEXT:    [[TMP2:%.*]] = insertelement <16 x i8> [[TMP1]], i8 2, i32 1
; CHECK-NEXT:    [[TMP3:%.*]] = insertelement <16 x i8> [[TMP2]], i8 3, i32 2
; CHECK-NEXT:    [[TMP4:%.*]] = insertelement <16 x i8> [[TMP3]], i8 4, i32 3
; CHECK-NEXT:    [[TMP5:%.*]] = insertelement <16 x i8> [[TMP4]], i8 5, i32 4
; CHECK-NEXT:    [[TMP6:%.*]] = insertelement <16 x i8> [[TMP5]], i8 6, i32 5
; CHECK-NEXT:    [[TMP7:%.*]] = insertelement <16 x i8> [[TMP6]], i8 7, i32 6
; CHECK-NEXT:    [[TMP8:%.*]] = insertelement <16 x i8> [[TMP7]], i8 8, i32 7
; CHECK-NEXT:    [[TMP9:%.*]] = insertelement <16 x i8> [[TMP8]], i8 5, i32 4
; CHECK-NEXT:    ret <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>
;
  %p = alloca [2 x <8 x i8>], align 1, addrspace(5)
  store <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, ptr addrspace(5) %p, align 1
  %g = getelementptr <4 x i8>, ptr addrspace(5) %p, i64 1
  store <8 x i1> <i1 true, i1 false, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false>, ptr addrspace(5) %g, align 1
  %l = load <8 x i1>, ptr addrspace(5) %g, align 1
  ret <8 x i1> %l
}
