; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define <8 x float> @bitcast_v8i32_to_v8f32(<8 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v8i32_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i32_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i32_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i32_to_v8f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB0_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB0_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define inreg <8 x float> @bitcast_v8i32_to_v8f32_scalar(<8 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i32_to_v8f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_v8i32_to_v8f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_v8i32_to_v8f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_v8i32_to_v8f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB1_3
; GFX11-NEXT:  .LBB1_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB1_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_4:
; GFX11-NEXT:    s_branch .LBB1_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define <8 x i32> @bitcast_v8f32_to_v8i32(<8 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v8f32_to_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v8i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define inreg <8 x i32> @bitcast_v8f32_to_v8i32_scalar(<8 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f32_to_v8i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB3_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_4
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_3:
; SI-NEXT:    s_branch .LBB3_2
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v8i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB3_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_4
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; VI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_3:
; VI-NEXT:    s_branch .LBB3_2
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v8i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_4
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v7, s23, 1.0
; GFX9-NEXT:    v_add_f32_e64 v6, s22, 1.0
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_3:
; GFX9-NEXT:    s_branch .LBB3_2
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v8i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB3_4
; GFX11-NEXT:  .LBB3_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v7, s7, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s6, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:    s_branch .LBB3_2
; GFX11-NEXT:  .LBB3_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define <4 x i64> @bitcast_v8i32_to_v4i64(<8 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v8i32_to_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i32_to_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i32_to_v4i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i32_to_v4i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB4_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB4_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define inreg <4 x i64> @bitcast_v8i32_to_v4i64_scalar(<8 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i32_to_v4i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_v8i32_to_v4i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_v8i32_to_v4i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_v8i32_to_v4i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB5_3
; GFX11-NEXT:  .LBB5_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB5_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_4:
; GFX11-NEXT:    s_branch .LBB5_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define <8 x i32> @bitcast_v4i64_to_v8i32(<4 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v4i64_to_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i64_to_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i64_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i64_to_v8i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB6_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define inreg <8 x i32> @bitcast_v4i64_to_v8i32_scalar(<4 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i64_to_v8i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s22, s22, 3
; SI-NEXT:    s_addc_u32 s23, s23, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v4i64_to_v8i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v4i64_to_v8i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v4i64_to_v8i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB7_3
; GFX11-NEXT:  .LBB7_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB7_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_4:
; GFX11-NEXT:    s_branch .LBB7_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define <4 x double> @bitcast_v8i32_to_v4f64(<8 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v8i32_to_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i32_to_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i32_to_v4f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i32_to_v4f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB8_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB8_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define inreg <4 x double> @bitcast_v8i32_to_v4f64_scalar(<8 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i32_to_v4f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_v8i32_to_v4f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_v8i32_to_v4f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_v8i32_to_v4f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB9_3
; GFX11-NEXT:  .LBB9_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB9_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_4:
; GFX11-NEXT:    s_branch .LBB9_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define <8 x i32> @bitcast_v4f64_to_v8i32(<4 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v4f64_to_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB10_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB10_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB10_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v8i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB10_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define inreg <8 x i32> @bitcast_v4f64_to_v8i32_scalar(<4 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f64_to_v8i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB11_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB11_4
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; SI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_3:
; SI-NEXT:    s_branch .LBB11_2
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v8i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB11_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_4
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_3:
; VI-NEXT:    s_branch .LBB11_2
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v8i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_4
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_3:
; GFX9-NEXT:    s_branch .LBB11_2
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v8i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB11_4
; GFX11-NEXT:  .LBB11_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], s[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:    s_branch .LBB11_2
; GFX11-NEXT:  .LBB11_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define <16 x i16> @bitcast_v8i32_to_v16i16(<8 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v8i32_to_v16i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v14, v7
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v6, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v16, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v16, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB12_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v8, v16
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i32_to_v16i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i32_to_v16i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i32_to_v16i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB12_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define inreg <16 x i16> @bitcast_v8i32_to_v16i16_scalar(<8 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i32_to_v16i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v13, s23, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s23, 16
; SI-NEXT:    s_lshr_b32 s7, s21, 16
; SI-NEXT:    s_lshr_b32 s8, s19, 16
; SI-NEXT:    s_lshr_b32 s9, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    v_alignbit_b32 v13, s23, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s23, 16
; SI-NEXT:    s_lshr_b32 s7, s21, 16
; SI-NEXT:    s_lshr_b32 s8, s19, 16
; SI-NEXT:    s_lshr_b32 s9, s17, 16
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v7, s8
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v11, s7
; SI-NEXT:    v_mov_b32_e32 v12, s22
; SI-NEXT:    v_mov_b32_e32 v14, s23
; SI-NEXT:    v_mov_b32_e32 v15, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_v8i32_to_v16i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_v8i32_to_v16i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_v8i32_to_v16i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_3
; GFX11-NEXT:  .LBB13_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB13_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB13_4:
; GFX11-NEXT:    s_branch .LBB13_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define <8 x i32> @bitcast_v16i16_to_v8i32(<16 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v16i16_to_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v4
; SI-NEXT:    v_mov_b32_e32 v18, v2
; SI-NEXT:    v_mov_b32_e32 v17, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v15
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB14_4
; SI-NEXT:  .LBB14_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB14_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v0, v0, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v24
; SI-NEXT:    v_or_b32_e32 v2, v2, v23
; SI-NEXT:    v_or_b32_e32 v3, v3, v22
; SI-NEXT:    v_or_b32_e32 v4, v4, v21
; SI-NEXT:    v_or_b32_e32 v5, v5, v16
; SI-NEXT:    v_or_b32_e32 v6, v6, v11
; SI-NEXT:    v_or_b32_e32 v7, v7, v9
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  .LBB14_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v0, v25, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v24, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v22, v3
; SI-NEXT:    v_or_b32_e32 v4, v21, v4
; SI-NEXT:    v_or_b32_e32 v5, v16, v5
; SI-NEXT:    v_or_b32_e32 v6, v11, v6
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x30000, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i16_to_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v9, 3
; VI-NEXT:    v_add_u16_e32 v8, 3, v7
; VI-NEXT:    v_add_u16_sdwa v7, v7, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_add_u16_e32 v8, 3, v6
; VI-NEXT:    v_add_u16_sdwa v6, v6, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v8, v6
; VI-NEXT:    v_add_u16_e32 v8, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v8, v5
; VI-NEXT:    v_add_u16_e32 v8, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v8, v4
; VI-NEXT:    v_add_u16_e32 v8, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v8, v3
; VI-NEXT:    v_add_u16_e32 v8, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v8, v2
; VI-NEXT:    v_add_u16_e32 v8, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_add_u16_e32 v8, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v8, v0
; VI-NEXT:  .LBB14_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i16_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v8i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  .LBB14_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define inreg <8 x i32> @bitcast_v16i16_to_v8i32_scalar(<16 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i16_to_v8i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_mov_b32_e32 v8, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; SI-NEXT:    s_cbranch_scc0 .LBB15_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v7, v0, v9
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB15_3
; SI-NEXT:  .LBB15_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v8
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB15_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB15_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB15_2
;
; VI-LABEL: bitcast_v16i16_to_v8i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB15_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB15_3
; VI-NEXT:  .LBB15_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s23, 3
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s22, 3
; VI-NEXT:    s_add_i32 s23, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_add_i32 s22, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB15_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB15_4:
; VI-NEXT:    s_branch .LBB15_2
;
; GFX9-LABEL: bitcast_v16i16_to_v8i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB15_4
; GFX9-NEXT:  .LBB15_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, s23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB15_3:
; GFX9-NEXT:    s_branch .LBB15_2
; GFX9-NEXT:  .LBB15_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v8i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB15_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB15_4
; GFX11-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB15_3:
; GFX11-NEXT:    s_branch .LBB15_2
; GFX11-NEXT:  .LBB15_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define <16 x half> @bitcast_v8i32_to_v16f16(<8 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v8i32_to_v16f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v16, v7
; SI-NEXT:    v_mov_b32_e32 v17, v6
; SI-NEXT:    v_mov_b32_e32 v18, v5
; SI-NEXT:    v_mov_b32_e32 v19, v4
; SI-NEXT:    v_mov_b32_e32 v20, v3
; SI-NEXT:    v_mov_b32_e32 v21, v2
; SI-NEXT:    v_mov_b32_e32 v22, v1
; SI-NEXT:    v_mov_b32_e32 v23, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB16_4
; SI-NEXT:  .LBB16_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB16_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v23
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_2
; SI-NEXT:  .LBB16_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v23
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v16
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i32_to_v16f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i32_to_v16f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i32_to_v16f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB16_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB16_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define inreg <16 x half> @bitcast_v8i32_to_v16f16_scalar(<8 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i32_to_v16f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB17_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB17_3
; SI-NEXT:  .LBB17_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    s_lshr_b32 s5, s17, 16
; SI-NEXT:    s_lshr_b32 s6, s18, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s8, s20, 16
; SI-NEXT:    s_lshr_b32 s9, s21, 16
; SI-NEXT:    s_lshr_b32 s10, s22, 16
; SI-NEXT:    s_lshr_b32 s11, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:  .LBB17_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB17_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_branch .LBB17_2
;
; VI-LABEL: bitcast_v8i32_to_v16f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB17_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB17_3
; VI-NEXT:  .LBB17_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB17_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB17_4:
; VI-NEXT:    s_branch .LBB17_2
;
; GFX9-LABEL: bitcast_v8i32_to_v16f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB17_3
; GFX9-NEXT:  .LBB17_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB17_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB17_4:
; GFX9-NEXT:    s_branch .LBB17_2
;
; GFX11-LABEL: bitcast_v8i32_to_v16f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB17_3
; GFX11-NEXT:  .LBB17_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB17_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB17_4:
; GFX11-NEXT:    s_branch .LBB17_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define <8 x i32> @bitcast_v16f16_to_v8i32(<16 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v16f16_to_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v14
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB18_4
; SI-NEXT:  .LBB18_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB18_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v26
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v24
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v22
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v21, v3
; SI-NEXT:    v_or_b32_e32 v4, v19, v4
; SI-NEXT:    v_or_b32_e32 v5, v17, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_2
; SI-NEXT:  .LBB18_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v25
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v20
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v21
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v18
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f16_to_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v8, 0x200
; VI-NEXT:    v_add_f16_sdwa v9, v7, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v9
; VI-NEXT:    v_add_f16_sdwa v9, v6, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v9
; VI-NEXT:    v_add_f16_sdwa v9, v5, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v9
; VI-NEXT:    v_add_f16_sdwa v9, v4, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v9
; VI-NEXT:    v_add_f16_sdwa v9, v3, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v9
; VI-NEXT:    v_add_f16_sdwa v9, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v9
; VI-NEXT:    v_add_f16_sdwa v9, v1, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v8, v0, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v9
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:  .LBB18_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v8i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB18_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  .LBB18_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define inreg <8 x i32> @bitcast_v16f16_to_v8i32_scalar(<16 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f16_to_v8i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v23, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v22, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v21, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v20, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v19, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v18, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s28
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB19_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v22, v0
; SI-NEXT:    v_or_b32_e32 v1, v20, v1
; SI-NEXT:    v_or_b32_e32 v2, v18, v2
; SI-NEXT:    v_or_b32_e32 v3, v16, v3
; SI-NEXT:    v_or_b32_e32 v4, v14, v4
; SI-NEXT:    v_or_b32_e32 v5, v12, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_cbranch_execnz .LBB19_3
; SI-NEXT:  .LBB19_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v20
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v18
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v19
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v15
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v14
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v12
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:  .LBB19_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB19_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB19_2
;
; VI-LABEL: bitcast_v16f16_to_v8i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB19_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB19_4
; VI-NEXT:  .LBB19_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s23, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s23, v0
; VI-NEXT:    s_lshr_b32 s4, s22, 16
; VI-NEXT:    v_or_b32_e32 v7, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s22, v0
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_or_b32_e32 v6, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_add_f16_sdwa v8, v8, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB19_3:
; VI-NEXT:    s_branch .LBB19_2
; VI-NEXT:  .LBB19_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v8i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB19_4
; GFX9-NEXT:  .LBB19_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, s23, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, s22, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB19_3:
; GFX9-NEXT:    s_branch .LBB19_2
; GFX9-NEXT:  .LBB19_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v8i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB19_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB19_4
; GFX11-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, s7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, s6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB19_3:
; GFX11-NEXT:    s_branch .LBB19_2
; GFX11-NEXT:  .LBB19_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define <16 x bfloat> @bitcast_v8i32_to_v16bf16(<8 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v8i32_to_v16bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v23, v7
; SI-NEXT:    v_mov_b32_e32 v22, v6
; SI-NEXT:    v_mov_b32_e32 v21, v5
; SI-NEXT:    v_mov_b32_e32 v20, v4
; SI-NEXT:    v_mov_b32_e32 v19, v3
; SI-NEXT:    v_mov_b32_e32 v18, v2
; SI-NEXT:    v_mov_b32_e32 v17, v1
; SI-NEXT:    v_mov_b32_e32 v16, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB20_4
; SI-NEXT:  .LBB20_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB20_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v23
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v23
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v22
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v22
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v21
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v21
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v20
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v20
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v19
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v19
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v18
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v18
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v17
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v16
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB20_2
; SI-NEXT:  .LBB20_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v21
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v22
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v23
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i32_to_v16bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i32_to_v16bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8i32_to_v16bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB20_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB20_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define inreg <16 x bfloat> @bitcast_v8i32_to_v16bf16_scalar(<8 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i32_to_v16bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB21_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s23, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s23, 16
; SI-NEXT:    s_and_b32 s8, s22, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s22, 16
; SI-NEXT:    s_and_b32 s10, s21, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s21, 16
; SI-NEXT:    s_and_b32 s12, s20, 0xffff0000
; SI-NEXT:    s_lshl_b32 s13, s20, 16
; SI-NEXT:    s_and_b32 s14, s19, 0xffff0000
; SI-NEXT:    s_lshl_b32 s15, s19, 16
; SI-NEXT:    s_and_b32 s24, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s25, s18, 16
; SI-NEXT:    s_and_b32 s26, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s27, s17, 16
; SI-NEXT:    s_and_b32 s28, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s29, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB21_3
; SI-NEXT:  .LBB21_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_and_b32 s6, s23, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s23, 16
; SI-NEXT:    s_and_b32 s8, s22, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s22, 16
; SI-NEXT:    s_and_b32 s10, s21, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s21, 16
; SI-NEXT:    s_and_b32 s12, s20, 0xffff0000
; SI-NEXT:    s_lshl_b32 s13, s20, 16
; SI-NEXT:    s_and_b32 s14, s19, 0xffff0000
; SI-NEXT:    s_lshl_b32 s15, s19, 16
; SI-NEXT:    s_and_b32 s24, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s25, s18, 16
; SI-NEXT:    s_and_b32 s26, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s27, s17, 16
; SI-NEXT:    s_and_b32 s28, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s29, s16, 16
; SI-NEXT:  .LBB21_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s29
; SI-NEXT:    v_mov_b32_e32 v1, s28
; SI-NEXT:    v_mov_b32_e32 v2, s27
; SI-NEXT:    v_mov_b32_e32 v3, s26
; SI-NEXT:    v_mov_b32_e32 v4, s25
; SI-NEXT:    v_mov_b32_e32 v5, s24
; SI-NEXT:    v_mov_b32_e32 v6, s15
; SI-NEXT:    v_mov_b32_e32 v7, s14
; SI-NEXT:    v_mov_b32_e32 v8, s13
; SI-NEXT:    v_mov_b32_e32 v9, s12
; SI-NEXT:    v_mov_b32_e32 v10, s11
; SI-NEXT:    v_mov_b32_e32 v11, s10
; SI-NEXT:    v_mov_b32_e32 v12, s9
; SI-NEXT:    v_mov_b32_e32 v13, s8
; SI-NEXT:    v_mov_b32_e32 v14, s7
; SI-NEXT:    v_mov_b32_e32 v15, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB21_4:
; SI-NEXT:    ; implicit-def: $sgpr29
; SI-NEXT:    ; implicit-def: $sgpr28
; SI-NEXT:    ; implicit-def: $sgpr27
; SI-NEXT:    ; implicit-def: $sgpr26
; SI-NEXT:    ; implicit-def: $sgpr25
; SI-NEXT:    ; implicit-def: $sgpr24
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB21_2
;
; VI-LABEL: bitcast_v8i32_to_v16bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB21_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB21_3
; VI-NEXT:  .LBB21_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:  .LBB21_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB21_4:
; VI-NEXT:    s_branch .LBB21_2
;
; GFX9-LABEL: bitcast_v8i32_to_v16bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB21_3
; GFX9-NEXT:  .LBB21_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:  .LBB21_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB21_4:
; GFX9-NEXT:    s_branch .LBB21_2
;
; GFX11-LABEL: bitcast_v8i32_to_v16bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB21_3
; GFX11-NEXT:  .LBB21_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:  .LBB21_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB21_4:
; GFX11-NEXT:    s_branch .LBB21_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define <8 x i32> @bitcast_v16bf16_to_v8i32(<16 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v16bf16_to_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_mul_f32_e32 v26, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v27, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v24, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v25, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v10, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v11, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v14
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB22_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB22_4
; SI-NEXT:  .LBB22_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB22_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v27, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v25, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v23, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v21, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v19, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v17, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v11, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v9, 16
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB22_2
; SI-NEXT:  .LBB22_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v26
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v24
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v27
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v25
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v22
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v10
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16bf16_to_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB22_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v7, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v7
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v7
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; VI-NEXT:    v_cndmask_b32_e32 v7, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; VI-NEXT:    v_alignbit_b32 v7, v7, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v6, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; VI-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_alignbit_b32 v6, v6, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; VI-NEXT:    v_alignbit_b32 v5, v5, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v4
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; VI-NEXT:    v_alignbit_b32 v4, v4, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v3
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_alignbit_b32 v3, v3, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v2
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v1
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v0
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; VI-NEXT:  .LBB22_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16bf16_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v7, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v7, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v7
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v9, v10, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v7, v7, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v6, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v6, v6, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v5, v5, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v4, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v4, v4, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v3, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v3, v3, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v2, v2, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v1, v1, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v0, v0, v8, s7
; GFX9-NEXT:  .LBB22_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v16bf16_to_v8i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_lshlrev_b32 v8, 16, v7
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v9, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v8, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v8
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v11, v8, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v8, v11, v14 :: v_dual_and_b32 v7, 0xffff0000, v7
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 0x40c00000, v7 :: v_dual_lshlrev_b32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v15, v9, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v8.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v7, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v7
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v12, v7, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v6, 0x40c00000, v6 :: v_dual_cndmask_b32 v7, v12, v13
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v6, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v6
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-TRUE16-NEXT:    v_bfi_b32 v7, 0xffff, v8, v7
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v16, v6, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v6, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v6.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v9, v11, v12 :: v_dual_add_f32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v6, 0xffff, v6, v9
; GFX11-TRUE16-NEXT:    v_bfe_u32 v13, v10, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v14, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v13, v10, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v14, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v12, v13, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v10, v11, v14 :: v_dual_add_f32 v11, 0x40c00000, v15
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v8, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v4, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v5, 0xffff, v5, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v8, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v9, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v4.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v8, v8, v13, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v12, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_bfi_b32 v4, 0xffff, v4, v8
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v3, v12, v13 :: v_dual_add_f32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v10, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v10, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v10, v15, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v9, v9, v14 :: v_dual_and_b32 v14, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v3, 0xffff, v3, v9
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v10, v10, v12 :: v_dual_add_f32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v13, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v13, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v13, 0x40c00000, v14 :: v_dual_lshlrev_b32 v14, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v11, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_bfe_u32 v14, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v13, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, 0x400000, v13
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v12, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v14, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v19, 0x400000, v12
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v11, v13, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfe_u32 v18, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v15, v15, v12, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v18, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v12, v15, v19, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v2, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v11, v11, v16, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v12, v0
; GFX11-TRUE16-NEXT:  .LBB22_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v16bf16_to_v8i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_add_f32 v8, 0x40c00000, v8
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v8, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v15, v6, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v13, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_add3_u32 v10, v10, v8, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v10, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v15, v6, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX11-FAKE16-NEXT:    v_bfe_u32 v12, v7, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v12, v12, v7, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v12, v14 :: v_dual_lshlrev_b32 v12, 16, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v7, v8, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v6
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v13, v10 :: v_dual_add_f32 v10, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-FAKE16-NEXT:    v_bfe_u32 v12, v10, 16, 1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v11, v14 :: v_dual_lshlrev_b32 v11, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v6, v9, 0x7060302
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v11 :: v_dual_add_f32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v12, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v8, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v14, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v12 :: v_dual_lshlrev_b32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v5, v10, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v10, v10, v4, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v10, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v10, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v13, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v10, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v13, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v14, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v11, v12 :: v_dual_add_f32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v4, v8, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, 0x400000, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v11, 16, 1
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v3, v9, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add3_u32 v12, v16, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v13, v15 :: v_dual_lshlrev_b32 v15, 16, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v12, v13, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v15
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v14, v11, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v11
; GFX11-FAKE16-NEXT:    v_bfe_u32 v15, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v12, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, 0x400000, v12
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v2, v10, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v13, v14, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v14, v15, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v12, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v14, v15 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v1, v11, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v16, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v13, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v13, v18, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v12, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB22_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <16 x bfloat> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x bfloat> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define inreg <8 x i32> @bitcast_v16bf16_to_v8i32_scalar(<16 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16bf16_to_v8i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mul_f32_e64 v22, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v23, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v20, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v21, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v18, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v19, 1.0, s20
; SI-NEXT:    v_mul_f32_e64 v16, 1.0, s23
; SI-NEXT:    v_mul_f32_e64 v17, 1.0, s22
; SI-NEXT:    v_mul_f32_e64 v14, 1.0, s25
; SI-NEXT:    v_mul_f32_e64 v15, 1.0, s24
; SI-NEXT:    v_mul_f32_e64 v12, 1.0, s27
; SI-NEXT:    v_mul_f32_e64 v13, 1.0, s26
; SI-NEXT:    v_mul_f32_e64 v10, 1.0, s29
; SI-NEXT:    v_mul_f32_e64 v11, 1.0, s28
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v0
; SI-NEXT:    s_cbranch_scc0 .LBB23_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v23, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v21, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v19, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v17, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v15, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v13, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v11, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v9, 16
; SI-NEXT:    s_cbranch_execnz .LBB23_3
; SI-NEXT:  .LBB23_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v14
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v15
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v12
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v13
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v10
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:  .LBB23_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB23_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB23_2
;
; VI-LABEL: bitcast_v16bf16_to_v8i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB23_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB23_4
; VI-NEXT:  .LBB23_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s23, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s22, 16
; VI-NEXT:    v_alignbit_b32 v7, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s21, 16
; VI-NEXT:    v_alignbit_b32 v6, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s20, 16
; VI-NEXT:    v_alignbit_b32 v5, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s19, 16
; VI-NEXT:    v_alignbit_b32 v4, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v8, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_alignbit_b32 v3, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v8, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v8, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v8, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; VI-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_alignbit_b32 v2, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v8, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v1
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; VI-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc
; VI-NEXT:    v_add_f32_e32 v8, s4, v0
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v8, v1, 16
; VI-NEXT:    v_add_f32_e32 v8, s4, v0
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v0
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB23_3:
; VI-NEXT:    s_branch .LBB23_2
; VI-NEXT:  .LBB23_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16bf16_to_v8i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB23_4
; GFX9-NEXT:  .LBB23_2: ; %cmp.true
; GFX9-NEXT:    s_and_b32 s4, s23, 0xffff0000
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s23, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v8, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s22, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v7, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s22, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s21, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v6, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s21, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s20, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v5, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s20, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s19, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v4, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s19, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v9, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s18, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v3, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v9, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v9, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v9, v9, v2
; GFX9-NEXT:    v_add_u32_e32 v9, 0x7fff, v9
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s17, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v2, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v9, v9, v1
; GFX9-NEXT:    v_add_u32_e32 v9, 0x7fff, v9
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX9-NEXT:    v_add_f32_e32 v9, s4, v0
; GFX9-NEXT:    v_bfe_u32 v10, v9, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v9
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v10, v11, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v9, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s16, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v9
; GFX9-NEXT:    v_add_f32_e32 v9, s4, v0
; GFX9-NEXT:    v_bfe_u32 v10, v9, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v9
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v10, v11, vcc
; GFX9-NEXT:    v_bfe_u32 v10, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v0
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v10, v11, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX9-NEXT:    v_and_b32_sdwa v0, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v9, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB23_3:
; GFX9-NEXT:    s_branch .LBB23_2
; GFX9-NEXT:  .LBB23_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16bf16_to_v8i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB23_4
; GFX11-NEXT:  .LBB23_2: ; %cmp.true
; GFX11-NEXT:    s_lshl_b32 s8, s7, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff0000
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s8
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s7
; GFX11-NEXT:    s_and_b32 s8, s6, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    v_add_f32_e64 v3, 0x40c00000, s8
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    s_and_b32 s7, s5, 0xffff0000
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s6
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s7
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_bfe_u32 v10, v3, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s5
; GFX11-NEXT:    v_bfe_u32 v11, v6, 16, 1
; GFX11-NEXT:    s_and_b32 s5, s4, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v8, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v2, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v10, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v8, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v3
; GFX11-NEXT:    v_bfe_u32 v9, v7, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v3, v8, v4 :: v_dual_add_nc_u32 v4, v9, v7
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v11, v6
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v2, v10 :: v_dual_add_nc_u32 v5, 0x7fff, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_add_f32_e64 v10, 0x40c00000, s4
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s5
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    v_lshl_or_b32 v7, v1, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v5, v9, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v9, v10, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v8, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-NEXT:    s_and_b32 s4, s3, 0xffff0000
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v9, v10
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e64 v9, 0x40c00000, s3
; GFX11-NEXT:    s_and_b32 s3, s2, 0xffff0000
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x7fff, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v11, v6, v8
; GFX11-NEXT:    v_lshl_or_b32 v6, v3, 16, v2
; GFX11-NEXT:    v_or_b32_e32 v3, 0x400000, v10
; GFX11-NEXT:    v_or_b32_e32 v2, 0x400000, v8
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s3
; GFX11-NEXT:    v_bfe_u32 v3, v9, 16, 1
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v1, v2 :: v_dual_and_b32 v4, 0xffff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v10, v8, 16, 1
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshl_or_b32 v5, v5, 16, v4
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s4
; GFX11-NEXT:    v_add_nc_u32_e32 v10, v10, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v2, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s2
; GFX11-NEXT:    s_and_b32 s2, s1, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v9
; GFX11-NEXT:    v_add_f32_e64 v13, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s1, s0, 16
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff0000
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v11, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x7fff, v10
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_bfe_u32 v11, v4, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v14, 0x40c00000, s0
; GFX11-NEXT:    v_or_b32_e32 v18, 0x400000, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_bfe_u32 v16, v14, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_dual_cndmask_b32 v8, v9, v10 :: v_dual_add_nc_u32 v9, v11, v4
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_f32_e64 v10, 0x40c00000, s2
; GFX11-NEXT:    v_add_nc_u32_e32 v16, v16, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x7fff, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_bfe_u32 v12, v10, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v17, 0x400000, v10
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v9, v11, vcc_lo
; GFX11-NEXT:    v_add_f32_e64 v9, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v11, v13, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, v12, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_bfe_u32 v15, v9, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v11, v11, v13
; GFX11-NEXT:    v_or_b32_e32 v19, 0x400000, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 0x7fff, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 0x7fff, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, v15, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 0x7fff, v11
; GFX11-NEXT:    v_or_b32_e32 v16, 0x400000, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 0x7fff, v15
; GFX11-NEXT:    v_cndmask_b32_e32 v11, v11, v18, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; GFX11-NEXT:    v_cndmask_b32_e32 v9, v15, v19, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX11-NEXT:    v_cndmask_b32_e32 v10, v12, v17, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; GFX11-NEXT:    v_cndmask_b32_e32 v12, v13, v16, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-NEXT:    v_lshl_or_b32 v4, v1, 16, v0
; GFX11-NEXT:    v_lshl_or_b32 v3, v2, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v10, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; GFX11-NEXT:    v_lshl_or_b32 v2, v8, 16, v13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshl_or_b32 v0, v12, 16, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB23_3:
; GFX11-NEXT:    s_branch .LBB23_2
; GFX11-NEXT:  .LBB23_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <16 x bfloat> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <16 x bfloat> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define <32 x i8> @bitcast_v8i32_to_v32i8(<8 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v8i32_to_v32i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v28, v7
; SI-NEXT:    v_mov_b32_e32 v24, v6
; SI-NEXT:    v_mov_b32_e32 v20, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v12, v3
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v27, v28, v24, 24
; SI-NEXT:    v_alignbit_b32 v26, v28, v24, 16
; SI-NEXT:    v_alignbit_b32 v25, v28, v24, 8
; SI-NEXT:    v_alignbit_b32 v19, v20, v16, 24
; SI-NEXT:    v_alignbit_b32 v18, v20, v16, 16
; SI-NEXT:    v_alignbit_b32 v17, v20, v16, 8
; SI-NEXT:    v_alignbit_b32 v11, v12, v32, 24
; SI-NEXT:    v_alignbit_b32 v10, v12, v32, 16
; SI-NEXT:    v_alignbit_b32 v9, v12, v32, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v31, 24, v28
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v29, 8, v28
; SI-NEXT:    v_lshrrev_b32_e32 v23, 24, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v21, 8, v20
; SI-NEXT:    v_lshrrev_b32_e32 v15, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:  .LBB24_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v28, vcc, 3, v28
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_alignbit_b32 v27, v28, v24, 24
; SI-NEXT:    v_alignbit_b32 v26, v28, v24, 16
; SI-NEXT:    v_alignbit_b32 v25, v28, v24, 8
; SI-NEXT:    v_alignbit_b32 v19, v20, v16, 24
; SI-NEXT:    v_alignbit_b32 v18, v20, v16, 16
; SI-NEXT:    v_alignbit_b32 v17, v20, v16, 8
; SI-NEXT:    v_alignbit_b32 v11, v12, v32, 24
; SI-NEXT:    v_alignbit_b32 v10, v12, v32, 16
; SI-NEXT:    v_alignbit_b32 v9, v12, v32, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v31, 24, v28
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v29, 8, v28
; SI-NEXT:    v_lshrrev_b32_e32 v23, 24, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v21, 8, v20
; SI-NEXT:    v_lshrrev_b32_e32 v15, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:  .LBB24_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v8, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8i32_to_v32i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v33, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v35, v3
; VI-NEXT:    v_mov_b32_e32 v34, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB24_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; VI-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; VI-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; VI-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; VI-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; VI-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:  .LBB24_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB24_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_add_u32_e32 v35, vcc, 3, v35
; VI-NEXT:    v_add_u32_e32 v34, vcc, 3, v34
; VI-NEXT:    v_add_u32_e32 v33, vcc, 3, v33
; VI-NEXT:    v_add_u32_e32 v32, vcc, 3, v32
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; VI-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; VI-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; VI-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; VI-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; VI-NEXT:  .LBB24_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v1
; VI-NEXT:    v_mov_b32_e32 v8, v34
; VI-NEXT:    v_mov_b32_e32 v12, v35
; VI-NEXT:    v_mov_b32_e32 v16, v32
; VI-NEXT:    v_mov_b32_e32 v20, v33
; VI-NEXT:    v_mov_b32_e32 v24, v6
; VI-NEXT:    v_mov_b32_e32 v28, v7
; VI-NEXT:    v_mov_b32_e32 v1, v38
; VI-NEXT:    v_mov_b32_e32 v6, v37
; VI-NEXT:    v_mov_b32_e32 v7, v36
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8i32_to_v32i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v33, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v35, v3
; GFX9-NEXT:    v_mov_b32_e32 v34, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB24_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; GFX9-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:  .LBB24_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB24_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:    v_add_u32_e32 v35, 3, v35
; GFX9-NEXT:    v_add_u32_e32 v34, 3, v34
; GFX9-NEXT:    v_add_u32_e32 v33, 3, v33
; GFX9-NEXT:    v_add_u32_e32 v32, 3, v32
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; GFX9-NEXT:  .LBB24_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v34
; GFX9-NEXT:    v_mov_b32_e32 v12, v35
; GFX9-NEXT:    v_mov_b32_e32 v16, v32
; GFX9-NEXT:    v_mov_b32_e32 v20, v33
; GFX9-NEXT:    v_mov_b32_e32 v24, v6
; GFX9-NEXT:    v_mov_b32_e32 v28, v7
; GFX9-NEXT:    v_mov_b32_e32 v1, v38
; GFX9-NEXT:    v_mov_b32_e32 v6, v37
; GFX9-NEXT:    v_mov_b32_e32 v7, v36
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8i32_to_v32i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v33, v7 :: v_dual_mov_b32 v32, v6
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v27, v5 :: v_dual_mov_b32 v26, v4
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v19, v3 :: v_dual_mov_b32 v18, v2
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v11, v1 :: v_dual_mov_b32 v10, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr23_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr25_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr29_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr31_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB24_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[32:33]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[26:27]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[18:19]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX11-TRUE16-NEXT:  .LBB24_2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB24_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v33, 3, v33
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v32, 3, v32
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v27, 3, v27
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v26, 3, v26
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[32:33]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[26:27]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[18:19]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX11-TRUE16-NEXT:  .LBB24_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v11.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v18.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v18.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v36.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v19.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v26.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v26.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v35.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v27.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v27.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v32.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v34.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v28.l, v33.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v30.l, v33.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8i32_to_v32i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v33, v7 :: v_dual_mov_b32 v32, v6
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v35, v5 :: v_dual_mov_b32 v34, v4
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v37, v3 :: v_dual_mov_b32 v36, v2
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v39, v1 :: v_dual_mov_b32 v38, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB24_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[27:28], 24, v[32:33]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[34:35]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[36:37]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[38:39]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v38
; GFX11-FAKE16-NEXT:  .LBB24_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB24_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v39, 3, v39
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v37, 3, v37
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v35, 3, v35
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v33, 3, v33
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v32, 3, v32
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v34, 3, v34
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v36, 3, v36
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v38, 3, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[27:28], 24, v[32:33]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[34:35]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[36:37]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[38:39]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v38
; GFX11-FAKE16-NEXT:  .LBB24_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v38
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v39
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v8, v36
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v12, v37
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v16, v34
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v20, v35
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v24, v32
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v28, v33
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <32 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <32 x i8>
  br label %end

end:
  %phi = phi <32 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i8> %phi
}

define inreg <32 x i8> @bitcast_v8i32_to_v32i8_scalar(<8 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8i32_to_v32i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB25_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v27, s23, v0, 24
; SI-NEXT:    v_alignbit_b32 v26, s23, v0, 16
; SI-NEXT:    v_alignbit_b32 v25, s23, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v19, s21, v0, 24
; SI-NEXT:    v_alignbit_b32 v18, s21, v0, 16
; SI-NEXT:    v_alignbit_b32 v17, s21, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v11, s19, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s19, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s23, 24
; SI-NEXT:    s_lshr_b32 s7, s23, 16
; SI-NEXT:    s_lshr_b32 s9, s23, 8
; SI-NEXT:    s_lshr_b32 s8, s21, 24
; SI-NEXT:    s_lshr_b32 s10, s21, 16
; SI-NEXT:    s_lshr_b32 s12, s21, 8
; SI-NEXT:    s_lshr_b32 s11, s19, 24
; SI-NEXT:    s_lshr_b32 s13, s19, 16
; SI-NEXT:    s_lshr_b32 s14, s19, 8
; SI-NEXT:    s_lshr_b32 s15, s17, 24
; SI-NEXT:    s_lshr_b32 s24, s17, 16
; SI-NEXT:    s_lshr_b32 s25, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB25_3
; SI-NEXT:  .LBB25_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    v_alignbit_b32 v27, s23, v0, 24
; SI-NEXT:    v_alignbit_b32 v26, s23, v0, 16
; SI-NEXT:    v_alignbit_b32 v25, s23, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    v_alignbit_b32 v19, s21, v0, 24
; SI-NEXT:    v_alignbit_b32 v18, s21, v0, 16
; SI-NEXT:    v_alignbit_b32 v17, s21, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    v_alignbit_b32 v11, s19, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s19, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s23, 24
; SI-NEXT:    s_lshr_b32 s7, s23, 16
; SI-NEXT:    s_lshr_b32 s9, s23, 8
; SI-NEXT:    s_lshr_b32 s8, s21, 24
; SI-NEXT:    s_lshr_b32 s10, s21, 16
; SI-NEXT:    s_lshr_b32 s12, s21, 8
; SI-NEXT:    s_lshr_b32 s11, s19, 24
; SI-NEXT:    s_lshr_b32 s13, s19, 16
; SI-NEXT:    s_lshr_b32 s14, s19, 8
; SI-NEXT:    s_lshr_b32 s15, s17, 24
; SI-NEXT:    s_lshr_b32 s24, s17, 16
; SI-NEXT:    s_lshr_b32 s25, s17, 8
; SI-NEXT:  .LBB25_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v5, s25
; SI-NEXT:    v_mov_b32_e32 v6, s24
; SI-NEXT:    v_mov_b32_e32 v7, s15
; SI-NEXT:    v_mov_b32_e32 v8, s18
; SI-NEXT:    v_mov_b32_e32 v12, s19
; SI-NEXT:    v_mov_b32_e32 v13, s14
; SI-NEXT:    v_mov_b32_e32 v14, s13
; SI-NEXT:    v_mov_b32_e32 v15, s11
; SI-NEXT:    v_mov_b32_e32 v16, s20
; SI-NEXT:    v_mov_b32_e32 v20, s21
; SI-NEXT:    v_mov_b32_e32 v21, s12
; SI-NEXT:    v_mov_b32_e32 v22, s10
; SI-NEXT:    v_mov_b32_e32 v23, s8
; SI-NEXT:    v_mov_b32_e32 v24, s22
; SI-NEXT:    v_mov_b32_e32 v28, s23
; SI-NEXT:    v_mov_b32_e32 v29, s9
; SI-NEXT:    v_mov_b32_e32 v30, s7
; SI-NEXT:    v_mov_b32_e32 v31, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB25_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr25
; SI-NEXT:    ; implicit-def: $sgpr24
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB25_2
;
; VI-LABEL: bitcast_v8i32_to_v32i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB25_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s14, s23, 24
; VI-NEXT:    s_lshr_b32 s15, s23, 16
; VI-NEXT:    s_lshr_b32 s24, s23, 8
; VI-NEXT:    s_lshr_b32 s25, s22, 16
; VI-NEXT:    s_lshr_b32 s26, s22, 8
; VI-NEXT:    s_lshr_b32 s27, s21, 24
; VI-NEXT:    s_lshr_b32 s28, s21, 16
; VI-NEXT:    s_lshr_b32 s29, s21, 8
; VI-NEXT:    s_lshr_b32 s40, s20, 16
; VI-NEXT:    s_lshr_b32 s41, s20, 8
; VI-NEXT:    s_lshr_b32 s42, s19, 24
; VI-NEXT:    s_lshr_b32 s43, s19, 16
; VI-NEXT:    s_lshr_b32 s44, s19, 8
; VI-NEXT:    s_lshr_b32 s45, s18, 16
; VI-NEXT:    s_lshr_b32 s46, s18, 8
; VI-NEXT:    s_lshr_b32 s47, s17, 24
; VI-NEXT:    s_lshr_b32 s56, s17, 16
; VI-NEXT:    s_lshr_b32 s57, s17, 8
; VI-NEXT:    s_lshr_b32 s58, s16, 16
; VI-NEXT:    s_lshr_b32 s59, s16, 8
; VI-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB25_3
; VI-NEXT:  .LBB25_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s14, s23, 24
; VI-NEXT:    s_lshr_b32 s15, s23, 16
; VI-NEXT:    s_lshr_b32 s24, s23, 8
; VI-NEXT:    s_lshr_b32 s25, s22, 16
; VI-NEXT:    s_lshr_b32 s26, s22, 8
; VI-NEXT:    s_lshr_b32 s27, s21, 24
; VI-NEXT:    s_lshr_b32 s28, s21, 16
; VI-NEXT:    s_lshr_b32 s29, s21, 8
; VI-NEXT:    s_lshr_b32 s40, s20, 16
; VI-NEXT:    s_lshr_b32 s41, s20, 8
; VI-NEXT:    s_lshr_b32 s42, s19, 24
; VI-NEXT:    s_lshr_b32 s43, s19, 16
; VI-NEXT:    s_lshr_b32 s44, s19, 8
; VI-NEXT:    s_lshr_b32 s45, s18, 16
; VI-NEXT:    s_lshr_b32 s46, s18, 8
; VI-NEXT:    s_lshr_b32 s47, s17, 24
; VI-NEXT:    s_lshr_b32 s56, s17, 16
; VI-NEXT:    s_lshr_b32 s57, s17, 8
; VI-NEXT:    s_lshr_b32 s58, s16, 16
; VI-NEXT:    s_lshr_b32 s59, s16, 8
; VI-NEXT:  .LBB25_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s59
; VI-NEXT:    v_mov_b32_e32 v2, s58
; VI-NEXT:    v_mov_b32_e32 v3, s10
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    v_mov_b32_e32 v5, s57
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s47
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v9, s46
; VI-NEXT:    v_mov_b32_e32 v10, s45
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_mov_b32_e32 v12, s19
; VI-NEXT:    v_mov_b32_e32 v13, s44
; VI-NEXT:    v_mov_b32_e32 v14, s43
; VI-NEXT:    v_mov_b32_e32 v15, s42
; VI-NEXT:    v_mov_b32_e32 v16, s20
; VI-NEXT:    v_mov_b32_e32 v17, s41
; VI-NEXT:    v_mov_b32_e32 v18, s40
; VI-NEXT:    v_mov_b32_e32 v19, s6
; VI-NEXT:    v_mov_b32_e32 v20, s21
; VI-NEXT:    v_mov_b32_e32 v21, s29
; VI-NEXT:    v_mov_b32_e32 v22, s28
; VI-NEXT:    v_mov_b32_e32 v23, s27
; VI-NEXT:    v_mov_b32_e32 v24, s22
; VI-NEXT:    v_mov_b32_e32 v25, s26
; VI-NEXT:    v_mov_b32_e32 v26, s25
; VI-NEXT:    v_mov_b32_e32 v27, s4
; VI-NEXT:    v_mov_b32_e32 v28, s23
; VI-NEXT:    v_mov_b32_e32 v29, s24
; VI-NEXT:    v_mov_b32_e32 v30, s15
; VI-NEXT:    v_mov_b32_e32 v31, s14
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB25_4:
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr43
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr41
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    ; implicit-def: $sgpr29
; VI-NEXT:    ; implicit-def: $sgpr28
; VI-NEXT:    ; implicit-def: $sgpr27
; VI-NEXT:    ; implicit-def: $sgpr26
; VI-NEXT:    ; implicit-def: $sgpr25
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr24
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    s_branch .LBB25_2
;
; GFX9-LABEL: bitcast_v8i32_to_v32i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s14, s23, 24
; GFX9-NEXT:    s_lshr_b32 s15, s23, 16
; GFX9-NEXT:    s_lshr_b32 s24, s23, 8
; GFX9-NEXT:    s_lshr_b32 s25, s22, 16
; GFX9-NEXT:    s_lshr_b32 s26, s22, 8
; GFX9-NEXT:    s_lshr_b32 s27, s21, 24
; GFX9-NEXT:    s_lshr_b32 s28, s21, 16
; GFX9-NEXT:    s_lshr_b32 s29, s21, 8
; GFX9-NEXT:    s_lshr_b32 s40, s20, 16
; GFX9-NEXT:    s_lshr_b32 s41, s20, 8
; GFX9-NEXT:    s_lshr_b32 s42, s19, 24
; GFX9-NEXT:    s_lshr_b32 s43, s19, 16
; GFX9-NEXT:    s_lshr_b32 s44, s19, 8
; GFX9-NEXT:    s_lshr_b32 s45, s18, 16
; GFX9-NEXT:    s_lshr_b32 s46, s18, 8
; GFX9-NEXT:    s_lshr_b32 s47, s17, 24
; GFX9-NEXT:    s_lshr_b32 s56, s17, 16
; GFX9-NEXT:    s_lshr_b32 s57, s17, 8
; GFX9-NEXT:    s_lshr_b32 s58, s16, 16
; GFX9-NEXT:    s_lshr_b32 s59, s16, 8
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB25_3
; GFX9-NEXT:  .LBB25_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s14, s23, 24
; GFX9-NEXT:    s_lshr_b32 s15, s23, 16
; GFX9-NEXT:    s_lshr_b32 s24, s23, 8
; GFX9-NEXT:    s_lshr_b32 s25, s22, 16
; GFX9-NEXT:    s_lshr_b32 s26, s22, 8
; GFX9-NEXT:    s_lshr_b32 s27, s21, 24
; GFX9-NEXT:    s_lshr_b32 s28, s21, 16
; GFX9-NEXT:    s_lshr_b32 s29, s21, 8
; GFX9-NEXT:    s_lshr_b32 s40, s20, 16
; GFX9-NEXT:    s_lshr_b32 s41, s20, 8
; GFX9-NEXT:    s_lshr_b32 s42, s19, 24
; GFX9-NEXT:    s_lshr_b32 s43, s19, 16
; GFX9-NEXT:    s_lshr_b32 s44, s19, 8
; GFX9-NEXT:    s_lshr_b32 s45, s18, 16
; GFX9-NEXT:    s_lshr_b32 s46, s18, 8
; GFX9-NEXT:    s_lshr_b32 s47, s17, 24
; GFX9-NEXT:    s_lshr_b32 s56, s17, 16
; GFX9-NEXT:    s_lshr_b32 s57, s17, 8
; GFX9-NEXT:    s_lshr_b32 s58, s16, 16
; GFX9-NEXT:    s_lshr_b32 s59, s16, 8
; GFX9-NEXT:  .LBB25_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s59
; GFX9-NEXT:    v_mov_b32_e32 v2, s58
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    v_mov_b32_e32 v5, s57
; GFX9-NEXT:    v_mov_b32_e32 v6, s56
; GFX9-NEXT:    v_mov_b32_e32 v7, s47
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v9, s46
; GFX9-NEXT:    v_mov_b32_e32 v10, s45
; GFX9-NEXT:    v_mov_b32_e32 v11, s8
; GFX9-NEXT:    v_mov_b32_e32 v12, s19
; GFX9-NEXT:    v_mov_b32_e32 v13, s44
; GFX9-NEXT:    v_mov_b32_e32 v14, s43
; GFX9-NEXT:    v_mov_b32_e32 v15, s42
; GFX9-NEXT:    v_mov_b32_e32 v16, s20
; GFX9-NEXT:    v_mov_b32_e32 v17, s41
; GFX9-NEXT:    v_mov_b32_e32 v18, s40
; GFX9-NEXT:    v_mov_b32_e32 v19, s6
; GFX9-NEXT:    v_mov_b32_e32 v20, s21
; GFX9-NEXT:    v_mov_b32_e32 v21, s29
; GFX9-NEXT:    v_mov_b32_e32 v22, s28
; GFX9-NEXT:    v_mov_b32_e32 v23, s27
; GFX9-NEXT:    v_mov_b32_e32 v24, s22
; GFX9-NEXT:    v_mov_b32_e32 v25, s26
; GFX9-NEXT:    v_mov_b32_e32 v26, s25
; GFX9-NEXT:    v_mov_b32_e32 v27, s4
; GFX9-NEXT:    v_mov_b32_e32 v28, s23
; GFX9-NEXT:    v_mov_b32_e32 v29, s24
; GFX9-NEXT:    v_mov_b32_e32 v30, s15
; GFX9-NEXT:    v_mov_b32_e32 v31, s14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB25_4:
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr43
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr41
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    ; implicit-def: $sgpr29
; GFX9-NEXT:    ; implicit-def: $sgpr28
; GFX9-NEXT:    ; implicit-def: $sgpr27
; GFX9-NEXT:    ; implicit-def: $sgpr26
; GFX9-NEXT:    ; implicit-def: $sgpr25
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr24
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    s_branch .LBB25_2
;
; GFX11-LABEL: bitcast_v8i32_to_v32i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s46, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s12, s19, 24
; GFX11-NEXT:    s_lshr_b32 s13, s19, 16
; GFX11-NEXT:    s_lshr_b32 s14, s19, 8
; GFX11-NEXT:    s_lshr_b32 s15, s18, 16
; GFX11-NEXT:    s_lshr_b32 s20, s18, 8
; GFX11-NEXT:    s_lshr_b32 s21, s17, 24
; GFX11-NEXT:    s_lshr_b32 s22, s17, 16
; GFX11-NEXT:    s_lshr_b32 s23, s17, 8
; GFX11-NEXT:    s_lshr_b32 s24, s16, 16
; GFX11-NEXT:    s_lshr_b32 s25, s16, 8
; GFX11-NEXT:    s_lshr_b32 s26, s3, 24
; GFX11-NEXT:    s_lshr_b32 s27, s3, 16
; GFX11-NEXT:    s_lshr_b32 s28, s3, 8
; GFX11-NEXT:    s_lshr_b32 s29, s2, 16
; GFX11-NEXT:    s_lshr_b32 s40, s2, 8
; GFX11-NEXT:    s_lshr_b32 s41, s1, 24
; GFX11-NEXT:    s_lshr_b32 s42, s1, 16
; GFX11-NEXT:    s_lshr_b32 s43, s1, 8
; GFX11-NEXT:    s_lshr_b32 s44, s0, 16
; GFX11-NEXT:    s_lshr_b32 s45, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[8:9], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[10:11], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s46
; GFX11-NEXT:    s_cbranch_vccnz .LBB25_3
; GFX11-NEXT:  .LBB25_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[8:9], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[10:11], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s12, s19, 24
; GFX11-NEXT:    s_lshr_b32 s13, s19, 16
; GFX11-NEXT:    s_lshr_b32 s14, s19, 8
; GFX11-NEXT:    s_lshr_b32 s15, s18, 16
; GFX11-NEXT:    s_lshr_b32 s20, s18, 8
; GFX11-NEXT:    s_lshr_b32 s21, s17, 24
; GFX11-NEXT:    s_lshr_b32 s22, s17, 16
; GFX11-NEXT:    s_lshr_b32 s23, s17, 8
; GFX11-NEXT:    s_lshr_b32 s24, s16, 16
; GFX11-NEXT:    s_lshr_b32 s25, s16, 8
; GFX11-NEXT:    s_lshr_b32 s26, s3, 24
; GFX11-NEXT:    s_lshr_b32 s27, s3, 16
; GFX11-NEXT:    s_lshr_b32 s28, s3, 8
; GFX11-NEXT:    s_lshr_b32 s29, s2, 16
; GFX11-NEXT:    s_lshr_b32 s40, s2, 8
; GFX11-NEXT:    s_lshr_b32 s41, s1, 24
; GFX11-NEXT:    s_lshr_b32 s42, s1, 16
; GFX11-NEXT:    s_lshr_b32 s43, s1, 8
; GFX11-NEXT:    s_lshr_b32 s44, s0, 16
; GFX11-NEXT:    s_lshr_b32 s45, s0, 8
; GFX11-NEXT:  .LBB25_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s45
; GFX11-NEXT:    v_dual_mov_b32 v2, s44 :: v_dual_mov_b32 v3, s10
; GFX11-NEXT:    v_dual_mov_b32 v4, s1 :: v_dual_mov_b32 v5, s43
; GFX11-NEXT:    v_dual_mov_b32 v6, s42 :: v_dual_mov_b32 v7, s41
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v9, s40
; GFX11-NEXT:    v_dual_mov_b32 v10, s29 :: v_dual_mov_b32 v11, s8
; GFX11-NEXT:    v_dual_mov_b32 v12, s3 :: v_dual_mov_b32 v13, s28
; GFX11-NEXT:    v_dual_mov_b32 v14, s27 :: v_dual_mov_b32 v15, s26
; GFX11-NEXT:    v_dual_mov_b32 v16, s16 :: v_dual_mov_b32 v17, s25
; GFX11-NEXT:    v_dual_mov_b32 v18, s24 :: v_dual_mov_b32 v19, s6
; GFX11-NEXT:    v_dual_mov_b32 v20, s17 :: v_dual_mov_b32 v21, s23
; GFX11-NEXT:    v_dual_mov_b32 v22, s22 :: v_dual_mov_b32 v23, s21
; GFX11-NEXT:    v_dual_mov_b32 v24, s18 :: v_dual_mov_b32 v25, s20
; GFX11-NEXT:    v_dual_mov_b32 v26, s15 :: v_dual_mov_b32 v27, s4
; GFX11-NEXT:    v_dual_mov_b32 v28, s19 :: v_dual_mov_b32 v29, s14
; GFX11-NEXT:    v_dual_mov_b32 v30, s13 :: v_dual_mov_b32 v31, s12
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB25_4:
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr29
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr28
; GFX11-NEXT:    ; implicit-def: $sgpr27
; GFX11-NEXT:    ; implicit-def: $sgpr26
; GFX11-NEXT:    ; implicit-def: $sgpr25
; GFX11-NEXT:    ; implicit-def: $sgpr24
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr23
; GFX11-NEXT:    ; implicit-def: $sgpr22
; GFX11-NEXT:    ; implicit-def: $sgpr21
; GFX11-NEXT:    ; implicit-def: $sgpr20
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    s_branch .LBB25_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <8 x i32> %a, splat (i32 3)
  %a2 = bitcast <8 x i32> %a1 to <32 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <8 x i32> %a to <32 x i8>
  br label %end

end:
  %phi = phi <32 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i8> %phi
}

define <8 x i32> @bitcast_v32i8_to_v8i32(<32 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v32i8_to_v8i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v31, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    v_mov_b32_e32 v34, v6
; SI-NEXT:    v_mov_b32_e32 v33, v4
; SI-NEXT:    v_lshlrev_b32_e32 v52, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v51, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v50, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v49, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v48, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v39, 24, v11
; SI-NEXT:    v_lshlrev_b32_e32 v38, 8, v13
; SI-NEXT:    v_lshlrev_b32_e32 v37, 24, v15
; SI-NEXT:    v_lshlrev_b32_e32 v36, 8, v17
; SI-NEXT:    v_lshlrev_b32_e32 v35, 24, v19
; SI-NEXT:    v_lshlrev_b32_e32 v19, 8, v21
; SI-NEXT:    v_lshlrev_b32_e32 v17, 24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v15, 8, v25
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v27
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v29
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB26_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB26_4
; SI-NEXT:  .LBB26_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB26_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v31
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v32
; SI-NEXT:    v_or_b32_e32 v0, v0, v52
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v51, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v33
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v50
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v49, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v8
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v2, v2, v48
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v39, v3
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v12
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v14
; SI-NEXT:    v_or_b32_e32 v3, v3, v38
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v4, v37, v4
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v16
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v18
; SI-NEXT:    v_or_b32_e32 v4, v4, v36
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v5, v35, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v20
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v22
; SI-NEXT:    v_or_b32_e32 v5, v5, v19
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v6, v17, v6
; SI-NEXT:    v_or_b32_e32 v5, v5, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v24
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v26
; SI-NEXT:    v_or_b32_e32 v6, v6, v15
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v7, v13, v7
; SI-NEXT:    v_or_b32_e32 v6, v6, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v28
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v30
; SI-NEXT:    v_or_b32_e32 v7, v7, v11
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB26_2
; SI-NEXT:  .LBB26_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v32
; SI-NEXT:    v_or_b32_e32 v0, v52, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v51, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v34
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v1, v50, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v49, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v10
; SI-NEXT:    v_or_b32_e32 v2, v48, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v39, v3
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v12
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v14
; SI-NEXT:    v_or_b32_e32 v3, v38, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v4, v37, v4
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v16
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v18
; SI-NEXT:    v_or_b32_e32 v4, v36, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v5, v35, v5
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v22
; SI-NEXT:    v_or_b32_e32 v5, v19, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v6, v17, v6
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v26
; SI-NEXT:    v_or_b32_e32 v6, v15, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v7, v13, v7
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v28
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v30
; SI-NEXT:    v_or_b32_e32 v7, v11, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x300, v7
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s7, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s7, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s7, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s7, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s7, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i8_to_v8i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v32, v2
; VI-NEXT:    v_mov_b32_e32 v31, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; VI-NEXT:    v_mov_b32_e32 v34, v6
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_lshlrev_b16_e32 v52, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v51, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v50, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v49, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v39, 8, v11
; VI-NEXT:    v_lshlrev_b16_e32 v38, 8, v13
; VI-NEXT:    v_lshlrev_b16_e32 v37, 8, v15
; VI-NEXT:    v_lshlrev_b16_e32 v36, 8, v17
; VI-NEXT:    v_lshlrev_b16_e32 v35, 8, v19
; VI-NEXT:    v_lshlrev_b16_e32 v19, 8, v21
; VI-NEXT:    v_lshlrev_b16_e32 v17, 8, v23
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v25
; VI-NEXT:    v_lshlrev_b16_e32 v13, 8, v27
; VI-NEXT:    v_lshlrev_b16_e32 v11, 8, v29
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v9, 8, v2
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB26_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB26_4
; VI-NEXT:  .LBB26_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB26_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v31, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v32, v51 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v33, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v34, v49 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v12, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v14, v37 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v16, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v18, v35 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v22, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v26, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v28, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v30, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_2
; VI-NEXT:  .LBB26_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v31
; VI-NEXT:    v_add_u16_e32 v1, 3, v32
; VI-NEXT:    v_or_b32_sdwa v0, v52, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v7, 0x300
; VI-NEXT:    v_add_u16_e32 v2, 3, v33
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v50, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v34
; VI-NEXT:    v_or_b32_sdwa v2, v49, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v8
; VI-NEXT:    v_add_u16_e32 v3, 3, v10
; VI-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v39, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v2, 0x300, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v12
; VI-NEXT:    v_add_u16_e32 v4, 3, v14
; VI-NEXT:    v_or_b32_sdwa v3, v38, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v37, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_add_u16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v16
; VI-NEXT:    v_add_u16_e32 v5, 3, v18
; VI-NEXT:    v_or_b32_sdwa v4, v36, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v5, v35, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v4, 0x300, v4
; VI-NEXT:    v_add_u16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v20
; VI-NEXT:    v_add_u16_e32 v6, 3, v22
; VI-NEXT:    v_or_b32_sdwa v5, v19, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v6, v17, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v5, 0x300, v5
; VI-NEXT:    v_add_u16_sdwa v6, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v24
; VI-NEXT:    v_add_u16_e32 v8, 3, v26
; VI-NEXT:    v_or_b32_sdwa v6, v15, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v8, v13, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v6, 0x300, v6
; VI-NEXT:    v_add_u16_sdwa v8, v8, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v28
; VI-NEXT:    v_add_u16_e32 v10, 3, v30
; VI-NEXT:    v_or_b32_sdwa v8, v11, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v9, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v8, 0x300, v8
; VI-NEXT:    v_add_u16_sdwa v7, v9, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i8_to_v8i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v2
; GFX9-NEXT:    v_mov_b32_e32 v31, v0
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; GFX9-NEXT:    v_mov_b32_e32 v34, v6
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_lshlrev_b16_e32 v52, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v51, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v50, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v49, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v48, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v39, 8, v11
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v13
; GFX9-NEXT:    v_lshlrev_b16_e32 v37, 8, v15
; GFX9-NEXT:    v_lshlrev_b16_e32 v36, 8, v17
; GFX9-NEXT:    v_lshlrev_b16_e32 v35, 8, v19
; GFX9-NEXT:    v_lshlrev_b16_e32 v19, 8, v21
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 8, v23
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v25
; GFX9-NEXT:    v_lshlrev_b16_e32 v13, 8, v27
; GFX9-NEXT:    v_lshlrev_b16_e32 v11, 8, v29
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v9, 8, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB26_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB26_4
; GFX9-NEXT:  .LBB26_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB26_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v31, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v32, v51 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v33, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v34, v49 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v12, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v14, v37 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v16, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v18, v35 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v22, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v26, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v28, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v30, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_2
; GFX9-NEXT:  .LBB26_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v31
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v32
; GFX9-NEXT:    v_or_b32_sdwa v0, v52, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v33
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v34
; GFX9-NEXT:    v_or_b32_sdwa v1, v50, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v49, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v39, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v12
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v3, v38, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v4, v37, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v3, 0x300, v3
; GFX9-NEXT:    v_add_u16_sdwa v4, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v16
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v18
; GFX9-NEXT:    v_or_b32_sdwa v4, v36, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v5, v35, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v4, 0x300, v4
; GFX9-NEXT:    v_add_u16_sdwa v5, v5, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v20
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v22
; GFX9-NEXT:    v_or_b32_sdwa v5, v19, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v6, v17, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v5, 0x300, v5
; GFX9-NEXT:    v_add_u16_sdwa v6, v6, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v24
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v26
; GFX9-NEXT:    v_or_b32_sdwa v6, v15, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v7, v13, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v6, 0x300, v6
; GFX9-NEXT:    v_add_u16_sdwa v7, v7, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v28
; GFX9-NEXT:    v_add_u16_e32 v8, 3, v30
; GFX9-NEXT:    v_or_b32_sdwa v7, v11, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v8, v9, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v7, 0x300, v7
; GFX9-NEXT:    v_add_u16_sdwa v8, v8, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v32i8_to_v8i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v31, off, s32
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.h, v21.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.h, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.h, v17.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.h, v15.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.h, v13.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.h, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.h, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.l, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.h, 8, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.l, 8, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.h, 8, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 8, v25.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.l, 8, v24.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.h, 8, v23.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.l, 8, v22.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 8, v21.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.l, 8, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v25.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.l, 8, v27.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v29.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.l, 8, v31.l
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB26_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB26_4
; GFX11-TRUE16-NEXT:  .LBB26_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB26_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v21.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v20.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v19.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v19.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v14.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v0.h, v17.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v1.h, v16.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v13.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v15.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v16.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v20.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v14.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v18.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v10.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v11.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v12.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v11.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v4.h, v12.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v22.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v24.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v26.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v28.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v30.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v8.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v4.h, v9.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v13, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v15, v8
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v7, v10
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr22_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr24_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr26_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr28_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr30_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr11_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr11_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr12_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr12_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-TRUE16-NEXT:  .LBB26_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v21.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v20.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v14.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v13.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v19.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v18.h, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v17.l, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v15.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v15.h, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v17.h, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v19.l, 3
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v13.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v16.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, v20.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v16.h, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v14.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.h, v18.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v10.h, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v11.h, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v12.h, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v11.l, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.h, v12.l, v4.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v5.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v4.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v22.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v24.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v26.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.h, v28.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, v30.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v8.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v8.h, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v9.l, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.h, v9.h, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v10.l, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v4.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v13, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v15, v8
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v7, v10
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v32i8_to_v8i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v32, v2 :: v_dual_mov_b32 v31, v0
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    scratch_load_b32 v0, off, s32 offset:4
; GFX11-FAKE16-NEXT:    scratch_load_u16 v2, off, s32
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v34, v6 :: v_dual_mov_b32 v33, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v51, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v49, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v50, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v48, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v38, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v39, 8, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v35, 8, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v36, 8, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v37, 8, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v19, 8, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v9, 8, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 8, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 8, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v29
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB26_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB26_4
; GFX11-FAKE16-NEXT:  .LBB26_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB26_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v32
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v51
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v49
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v50
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v48
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v38
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v35
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v36
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v37
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v11, v12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-FAKE16-NEXT:  .LBB26_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v31, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v32, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v33, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v34, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v51, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v49, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v50, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v48, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v38, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v39, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v18, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v12, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v16, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, v20, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v22, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, v24, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, v26, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, v28, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, v30, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v35, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v36, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v37, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v19, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v21, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v9, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v11, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v13, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v15, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v17, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, 0x300, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, 0x300, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v11, v12
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i8> %a, splat (i8 3)
  %a2 = bitcast <32 x i8> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i8> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define inreg <8 x i32> @bitcast_v32i8_to_v8i32_scalar(<32 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i8_to_v8i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v22, v6
; SI-NEXT:    v_mov_b32_e32 v21, v4
; SI-NEXT:    v_mov_b32_e32 v20, v2
; SI-NEXT:    v_mov_b32_e32 v19, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v1
; SI-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; SI-NEXT:    v_lshlrev_b32_e32 v25, 24, v5
; SI-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; SI-NEXT:    v_lshlrev_b32_e32 v23, 24, v9
; SI-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v17
; SI-NEXT:    s_cbranch_scc0 .LBB27_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v20
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v21
; SI-NEXT:    v_or_b32_e32 v0, v0, v26
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v4, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v10
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v12
; SI-NEXT:    v_or_b32_e32 v0, v0, v18
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_or_b32_e32 v6, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v16
; SI-NEXT:    v_or_b32_e32 v0, v0, v11
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v22
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v8
; SI-NEXT:    v_or_b32_e32 v7, v0, v1
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    s_lshl_b32 s5, s29, 8
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v19
; SI-NEXT:    v_or_b32_e32 v2, v2, v24
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v23, v3
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v5, v2, v3
; SI-NEXT:    v_or_b32_e32 v3, s4, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s26, 0xff
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_lshl_b32 s8, s27, 24
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_cbranch_execnz .LBB27_3
; SI-NEXT:  .LBB27_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s28, 0xff
; SI-NEXT:    s_lshl_b32 s8, s29, 8
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v19
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_addk_i32 s7, 0x300
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_and_b32 s7, s7, 0xffff
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v0, s7, v0
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v21
; SI-NEXT:    v_or_b32_e32 v0, v26, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v8
; SI-NEXT:    v_or_b32_e32 v0, v24, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v23, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v12
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v16
; SI-NEXT:    v_or_b32_e32 v0, v11, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:  .LBB27_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB27_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB27_2
;
; VI-LABEL: bitcast_v32i8_to_v8i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v22, v6
; VI-NEXT:    v_mov_b32_e32 v21, v4
; VI-NEXT:    v_mov_b32_e32 v20, v2
; VI-NEXT:    v_mov_b32_e32 v19, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_lshlrev_b32_e32 v27, 8, v1
; VI-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; VI-NEXT:    v_lshlrev_b32_e32 v25, 8, v5
; VI-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; VI-NEXT:    v_lshlrev_b32_e32 v23, 8, v9
; VI-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; VI-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; VI-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; VI-NEXT:    v_lshlrev_b32_e32 v9, 8, v17
; VI-NEXT:    s_cbranch_scc0 .LBB27_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v20, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v21, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v10, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s28, 0xff
; VI-NEXT:    s_lshl_b32 s5, s29, 8
; VI-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v14, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v16, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    v_or_b32_sdwa v2, v22, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v8, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v19, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, s4, v0
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_cbranch_execnz .LBB27_3
; VI-NEXT:  .LBB27_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s28, 0xff
; VI-NEXT:    s_lshl_b32 s8, s29, 8
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_addk_i32 s7, 0x300
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v19
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v27, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_e32 v0, s7, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v20
; VI-NEXT:    v_or_b32_sdwa v0, v26, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v22
; VI-NEXT:    v_or_b32_sdwa v0, v24, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v10
; VI-NEXT:    v_or_b32_sdwa v0, v18, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v7, vcc, 0x3000000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:  .LBB27_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB27_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; VI-NEXT:    s_branch .LBB27_2
;
; GFX9-LABEL: bitcast_v32i8_to_v8i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v22, v6
; GFX9-NEXT:    v_mov_b32_e32 v21, v4
; GFX9-NEXT:    v_mov_b32_e32 v20, v2
; GFX9-NEXT:    v_mov_b32_e32 v19, v0
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_lshlrev_b32_e32 v27, 8, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v25, 8, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v23, 8, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 8, v17
; GFX9-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v20, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v21, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s29, 8
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v14, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    v_or_b32_sdwa v2, v22, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v8, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    v_or_b32_sdwa v0, v19, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s4, v0
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB27_3
; GFX9-NEXT:  .LBB27_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_and_b32 s6, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s19, 8
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s6
; GFX9-NEXT:    s_and_b32 s6, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s23, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_and_b32 s8, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s27, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_addk_i32 s8, 0x300
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 16
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s8, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s29, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v19
; GFX9-NEXT:    s_movk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s8, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v0, v27, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX9-NEXT:    v_add_u32_sdwa v0, v0, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s8, v0
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v21
; GFX9-NEXT:    v_or_b32_sdwa v0, v26, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v8
; GFX9-NEXT:    v_or_b32_sdwa v0, v24, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v12
; GFX9-NEXT:    v_or_b32_sdwa v0, v18, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v16
; GFX9-NEXT:    v_or_b32_sdwa v0, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:  .LBB27_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB27_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX9-NEXT:    s_branch .LBB27_2
;
; GFX11-LABEL: bitcast_v32i8_to_v8i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v14
; GFX11-NEXT:    v_dual_mov_b32 v18, v6 :: v_dual_mov_b32 v17, v4
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v15, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v20, 8, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v21, 8, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v14, 8, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v19, 8, v7
; GFX11-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX11-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX11-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_and_b32 s5, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s5, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s8
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_lshl_b32 s7, s17, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_and_b32 s6, s16, 0xff
; GFX11-NEXT:    s_and_b32 s8, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_or_b32 s7, s8, s9
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v16
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v17
; GFX11-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-NEXT:    s_and_b32 s8, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_or_b32 s7, s8, s9
; GFX11-NEXT:    s_and_b32 s8, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s23, 8
; GFX11-NEXT:    v_or_b32_e32 v1, v1, v21
; GFX11-NEXT:    v_and_b32_e32 v5, 0xff, v10
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v14
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_and_b32 s9, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s25, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v15
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff, v18
; GFX11-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-NEXT:    v_and_b32_e32 v6, 0xff, v12
; GFX11-NEXT:    v_or_b32_e32 v5, v5, v11
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_or_b32 s9, s9, s10
; GFX11-NEXT:    s_lshl_b32 s10, s27, 8
; GFX11-NEXT:    s_and_b32 s8, s9, 0xffff
; GFX11-NEXT:    s_and_b32 s9, s26, 0xff
; GFX11-NEXT:    v_or_b32_e32 v3, v3, v19
; GFX11-NEXT:    v_or_b32_e32 v4, v4, v9
; GFX11-NEXT:    v_or_b32_e32 v6, v6, v13
; GFX11-NEXT:    v_and_b32_e32 v22, 0xffff, v5
; GFX11-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-NEXT:    v_mov_b32_e32 v1, s6
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v20
; GFX11-NEXT:    s_or_b32 s9, s9, s10
; GFX11-NEXT:    s_and_b32 s10, s28, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_lshl_b32 s11, s29, 8
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    s_or_b32 s10, s10, s11
; GFX11-NEXT:    v_or_b32_e32 v6, v3, v7
; GFX11-NEXT:    s_and_b32 s10, s10, 0xffff
; GFX11-NEXT:    v_or_b32_e32 v7, v22, v23
; GFX11-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v3, s8
; GFX11-NEXT:    v_or_b32_e32 v4, s10, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, s5
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB27_3
; GFX11-NEXT:  .LBB27_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_and_b32 s1, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s19, 8
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_and_b32 s3, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s4, s21, 8
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    s_or_b32 s2, s4, s3
; GFX11-NEXT:    s_and_b32 s3, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s4, s23, 8
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v16
; GFX11-NEXT:    s_or_b32 s3, s4, s3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v17
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v18
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v10
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    v_or_b32_e32 v1, v21, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v12
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-NEXT:    v_or_b32_e32 v2, v14, v2
; GFX11-NEXT:    s_and_b32 s4, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s25, 8
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-NEXT:    s_addk_i32 s4, 0x300
; GFX11-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-NEXT:    v_or_b32_e32 v3, v19, v3
; GFX11-NEXT:    v_or_b32_e32 v4, v9, v4
; GFX11-NEXT:    v_or_b32_e32 v5, v11, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-NEXT:    s_and_b32 s3, s4, 0xffff
; GFX11-NEXT:    s_and_b32 s4, s26, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s27, 8
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v15
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_or_b32_e32 v6, v13, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x300, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x300, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 0x300, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_addk_i32 s4, 0x300
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x300, v6
; GFX11-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_and_b32_e32 v8, 0xffff, v5
; GFX11-NEXT:    s_or_b32 s3, s3, s4
; GFX11-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_and_b32 v0, 0xff, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX11-NEXT:    v_or_b32_e32 v6, v3, v7
; GFX11-NEXT:    v_mov_b32_e32 v3, s3
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    v_or_b32_e32 v0, v20, v0
; GFX11-NEXT:    s_and_b32 s5, s28, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s29, 8
; GFX11-NEXT:    v_or_b32_e32 v7, v8, v9
; GFX11-NEXT:    s_or_b32 s5, s6, s5
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-NEXT:    s_addk_i32 s5, 0x300
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_or_b32_e32 v4, s5, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:  .LBB27_3: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB27_4:
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-NEXT:    s_branch .LBB27_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i8> %a, splat (i8 3)
  %a2 = bitcast <32 x i8> %a1 to <8 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i8> %a to <8 x i32>
  br label %end

end:
  %phi = phi <8 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x i32> %phi
}

define <4 x i64> @bitcast_v8f32_to_v4i64(<8 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v8f32_to_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v4i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v4i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define inreg <4 x i64> @bitcast_v8f32_to_v4i64_scalar(<8 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f32_to_v4i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB29_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB29_4
; SI-NEXT:  .LBB29_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB29_3:
; SI-NEXT:    s_branch .LBB29_2
; SI-NEXT:  .LBB29_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v4i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB29_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB29_4
; VI-NEXT:  .LBB29_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; VI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB29_3:
; VI-NEXT:    s_branch .LBB29_2
; VI-NEXT:  .LBB29_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v4i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB29_4
; GFX9-NEXT:  .LBB29_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v7, s23, 1.0
; GFX9-NEXT:    v_add_f32_e64 v6, s22, 1.0
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB29_3:
; GFX9-NEXT:    s_branch .LBB29_2
; GFX9-NEXT:  .LBB29_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v4i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB29_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB29_4
; GFX11-NEXT:  .LBB29_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v7, s7, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s6, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB29_3:
; GFX11-NEXT:    s_branch .LBB29_2
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define <8 x float> @bitcast_v4i64_to_v8f32(<4 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v4i64_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i64_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i64_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i64_to_v8f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB30_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB30_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define inreg <8 x float> @bitcast_v4i64_to_v8f32_scalar(<4 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i64_to_v8f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB31_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB31_3
; SI-NEXT:  .LBB31_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s22, s22, 3
; SI-NEXT:    s_addc_u32 s23, s23, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:  .LBB31_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB31_4:
; SI-NEXT:    s_branch .LBB31_2
;
; VI-LABEL: bitcast_v4i64_to_v8f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB31_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB31_3
; VI-NEXT:  .LBB31_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB31_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB31_4:
; VI-NEXT:    s_branch .LBB31_2
;
; GFX9-LABEL: bitcast_v4i64_to_v8f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB31_3
; GFX9-NEXT:  .LBB31_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB31_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB31_4:
; GFX9-NEXT:    s_branch .LBB31_2
;
; GFX11-LABEL: bitcast_v4i64_to_v8f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB31_3
; GFX11-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB31_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB31_4:
; GFX11-NEXT:    s_branch .LBB31_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define <4 x double> @bitcast_v8f32_to_v4f64(<8 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v8f32_to_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v4f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v4f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define inreg <4 x double> @bitcast_v8f32_to_v4f64_scalar(<8 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f32_to_v4f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB33_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB33_4
; SI-NEXT:  .LBB33_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB33_3:
; SI-NEXT:    s_branch .LBB33_2
; SI-NEXT:  .LBB33_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v4f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB33_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB33_4
; VI-NEXT:  .LBB33_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; VI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB33_3:
; VI-NEXT:    s_branch .LBB33_2
; VI-NEXT:  .LBB33_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v4f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB33_4
; GFX9-NEXT:  .LBB33_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v7, s23, 1.0
; GFX9-NEXT:    v_add_f32_e64 v6, s22, 1.0
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB33_3:
; GFX9-NEXT:    s_branch .LBB33_2
; GFX9-NEXT:  .LBB33_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v4f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB33_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB33_4
; GFX11-NEXT:  .LBB33_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v7, s7, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s6, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_3:
; GFX11-NEXT:    s_branch .LBB33_2
; GFX11-NEXT:  .LBB33_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define <8 x float> @bitcast_v4f64_to_v8f32(<4 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v4f64_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB34_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB34_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB34_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB34_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v8f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB34_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB34_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define inreg <8 x float> @bitcast_v4f64_to_v8f32_scalar(<4 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f64_to_v8f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB35_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB35_4
; SI-NEXT:  .LBB35_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; SI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB35_3:
; SI-NEXT:    s_branch .LBB35_2
; SI-NEXT:  .LBB35_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v8f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB35_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB35_4
; VI-NEXT:  .LBB35_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB35_3:
; VI-NEXT:    s_branch .LBB35_2
; VI-NEXT:  .LBB35_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v8f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB35_4
; GFX9-NEXT:  .LBB35_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB35_3:
; GFX9-NEXT:    s_branch .LBB35_2
; GFX9-NEXT:  .LBB35_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v8f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB35_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB35_4
; GFX11-NEXT:  .LBB35_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], s[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB35_3:
; GFX11-NEXT:    s_branch .LBB35_2
; GFX11-NEXT:  .LBB35_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define <16 x i16> @bitcast_v8f32_to_v16i16(<8 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v8f32_to_v16i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v14, v7
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v6, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v16, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB36_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v16, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB36_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v8, v16
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v16i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v16i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v16i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define inreg <16 x i16> @bitcast_v8f32_to_v16i16_scalar(<8 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f32_to_v16i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB37_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v13, s23, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s9, s23, 16
; SI-NEXT:    s_lshr_b32 s8, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB37_4
; SI-NEXT:  .LBB37_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v10, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v8, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v14, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v12, s22, 1.0
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v8, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB37_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    s_branch .LBB37_2
; SI-NEXT:  .LBB37_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v12, s22
; SI-NEXT:    v_mov_b32_e32 v14, s23
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    v_mov_b32_e32 v11, s8
; SI-NEXT:    v_mov_b32_e32 v15, s9
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v16i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB37_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB37_4
; VI-NEXT:  .LBB37_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; VI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB37_3:
; VI-NEXT:    s_branch .LBB37_2
; VI-NEXT:  .LBB37_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v16i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB37_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB37_4
; GFX9-NEXT:  .LBB37_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v7, s23, 1.0
; GFX9-NEXT:    v_add_f32_e64 v6, s22, 1.0
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB37_3:
; GFX9-NEXT:    s_branch .LBB37_2
; GFX9-NEXT:  .LBB37_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v16i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB37_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB37_4
; GFX11-NEXT:  .LBB37_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v7, s7, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s6, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB37_3:
; GFX11-NEXT:    s_branch .LBB37_2
; GFX11-NEXT:  .LBB37_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define <8 x float> @bitcast_v16i16_to_v8f32(<16 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v16i16_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v4
; SI-NEXT:    v_mov_b32_e32 v18, v2
; SI-NEXT:    v_mov_b32_e32 v17, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v15
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB38_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB38_4
; SI-NEXT:  .LBB38_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB38_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v0, v0, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v24
; SI-NEXT:    v_or_b32_e32 v2, v2, v23
; SI-NEXT:    v_or_b32_e32 v3, v3, v22
; SI-NEXT:    v_or_b32_e32 v4, v4, v21
; SI-NEXT:    v_or_b32_e32 v5, v5, v16
; SI-NEXT:    v_or_b32_e32 v6, v6, v11
; SI-NEXT:    v_or_b32_e32 v7, v7, v9
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB38_2
; SI-NEXT:  .LBB38_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v0, v25, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v24, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v22, v3
; SI-NEXT:    v_or_b32_e32 v4, v21, v4
; SI-NEXT:    v_or_b32_e32 v5, v16, v5
; SI-NEXT:    v_or_b32_e32 v6, v11, v6
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x30000, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i16_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB38_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v9, 3
; VI-NEXT:    v_add_u16_e32 v8, 3, v7
; VI-NEXT:    v_add_u16_sdwa v7, v7, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_add_u16_e32 v8, 3, v6
; VI-NEXT:    v_add_u16_sdwa v6, v6, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v8, v6
; VI-NEXT:    v_add_u16_e32 v8, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v8, v5
; VI-NEXT:    v_add_u16_e32 v8, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v8, v4
; VI-NEXT:    v_add_u16_e32 v8, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v8, v3
; VI-NEXT:    v_add_u16_e32 v8, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v8, v2
; VI-NEXT:    v_add_u16_e32 v8, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_add_u16_e32 v8, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v8, v0
; VI-NEXT:  .LBB38_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i16_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v8f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB38_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  .LBB38_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define inreg <8 x float> @bitcast_v16i16_to_v8f32_scalar(<16 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i16_to_v8f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_mov_b32_e32 v8, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; SI-NEXT:    s_cbranch_scc0 .LBB39_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v7, v0, v9
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB39_3
; SI-NEXT:  .LBB39_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v8
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB39_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB39_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB39_2
;
; VI-LABEL: bitcast_v16i16_to_v8f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB39_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB39_3
; VI-NEXT:  .LBB39_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s23, 3
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s22, 3
; VI-NEXT:    s_add_i32 s23, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_add_i32 s22, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB39_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB39_4:
; VI-NEXT:    s_branch .LBB39_2
;
; GFX9-LABEL: bitcast_v16i16_to_v8f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB39_4
; GFX9-NEXT:  .LBB39_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, s23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB39_3:
; GFX9-NEXT:    s_branch .LBB39_2
; GFX9-NEXT:  .LBB39_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v8f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB39_4
; GFX11-NEXT:  .LBB39_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB39_3:
; GFX11-NEXT:    s_branch .LBB39_2
; GFX11-NEXT:  .LBB39_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define <16 x half> @bitcast_v8f32_to_v16f16(<8 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v8f32_to_v16f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v16, v7
; SI-NEXT:    v_mov_b32_e32 v17, v6
; SI-NEXT:    v_mov_b32_e32 v18, v5
; SI-NEXT:    v_mov_b32_e32 v19, v4
; SI-NEXT:    v_mov_b32_e32 v20, v3
; SI-NEXT:    v_mov_b32_e32 v21, v2
; SI-NEXT:    v_mov_b32_e32 v22, v1
; SI-NEXT:    v_mov_b32_e32 v23, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB40_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB40_4
; SI-NEXT:  .LBB40_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB40_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v23
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_2
; SI-NEXT:  .LBB40_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v23
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v16
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v16f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v16f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v16f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define inreg <16 x half> @bitcast_v8f32_to_v16f16_scalar(<8 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f32_to_v16f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB41_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB41_3
; SI-NEXT:  .LBB41_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v8, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v10, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v12, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v14, s23, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; SI-NEXT:  .LBB41_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB41_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_branch .LBB41_2
;
; VI-LABEL: bitcast_v8f32_to_v16f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB41_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB41_4
; VI-NEXT:  .LBB41_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; VI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB41_3:
; VI-NEXT:    s_branch .LBB41_2
; VI-NEXT:  .LBB41_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v16f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB41_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB41_4
; GFX9-NEXT:  .LBB41_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v7, s23, 1.0
; GFX9-NEXT:    v_add_f32_e64 v6, s22, 1.0
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB41_3:
; GFX9-NEXT:    s_branch .LBB41_2
; GFX9-NEXT:  .LBB41_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v16f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB41_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB41_4
; GFX11-NEXT:  .LBB41_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v7, s7, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s6, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB41_3:
; GFX11-NEXT:    s_branch .LBB41_2
; GFX11-NEXT:  .LBB41_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define <8 x float> @bitcast_v16f16_to_v8f32(<16 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v16f16_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v14
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB42_4
; SI-NEXT:  .LBB42_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB42_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v26
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v24
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v22
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v21, v3
; SI-NEXT:    v_or_b32_e32 v4, v19, v4
; SI-NEXT:    v_or_b32_e32 v5, v17, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_2
; SI-NEXT:  .LBB42_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v25
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v20
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v21
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v18
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f16_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB42_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v8, 0x200
; VI-NEXT:    v_add_f16_sdwa v9, v7, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v9
; VI-NEXT:    v_add_f16_sdwa v9, v6, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v9
; VI-NEXT:    v_add_f16_sdwa v9, v5, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v9
; VI-NEXT:    v_add_f16_sdwa v9, v4, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v9
; VI-NEXT:    v_add_f16_sdwa v9, v3, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v9
; VI-NEXT:    v_add_f16_sdwa v9, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v9
; VI-NEXT:    v_add_f16_sdwa v9, v1, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v8, v0, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v9
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:  .LBB42_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v8f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB42_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  .LBB42_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define inreg <8 x float> @bitcast_v16f16_to_v8f32_scalar(<16 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f16_to_v8f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v23, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v22, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v21, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v20, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v19, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v18, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s28
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB43_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v22, v0
; SI-NEXT:    v_or_b32_e32 v1, v20, v1
; SI-NEXT:    v_or_b32_e32 v2, v18, v2
; SI-NEXT:    v_or_b32_e32 v3, v16, v3
; SI-NEXT:    v_or_b32_e32 v4, v14, v4
; SI-NEXT:    v_or_b32_e32 v5, v12, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_cbranch_execnz .LBB43_3
; SI-NEXT:  .LBB43_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v20
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v18
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v19
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v15
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v14
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v12
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:  .LBB43_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB43_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB43_2
;
; VI-LABEL: bitcast_v16f16_to_v8f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB43_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB43_4
; VI-NEXT:  .LBB43_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s23, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s23, v0
; VI-NEXT:    s_lshr_b32 s4, s22, 16
; VI-NEXT:    v_or_b32_e32 v7, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s22, v0
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_or_b32_e32 v6, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_add_f16_sdwa v8, v8, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB43_3:
; VI-NEXT:    s_branch .LBB43_2
; VI-NEXT:  .LBB43_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v8f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB43_4
; GFX9-NEXT:  .LBB43_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, s23, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, s22, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB43_3:
; GFX9-NEXT:    s_branch .LBB43_2
; GFX9-NEXT:  .LBB43_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v8f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB43_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB43_4
; GFX11-NEXT:  .LBB43_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, s7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, s6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB43_3:
; GFX11-NEXT:    s_branch .LBB43_2
; GFX11-NEXT:  .LBB43_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define <16 x bfloat> @bitcast_v8f32_to_v16bf16(<8 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v8f32_to_v16bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v23, v7
; SI-NEXT:    v_mov_b32_e32 v22, v6
; SI-NEXT:    v_mov_b32_e32 v21, v5
; SI-NEXT:    v_mov_b32_e32 v20, v4
; SI-NEXT:    v_mov_b32_e32 v19, v3
; SI-NEXT:    v_mov_b32_e32 v18, v2
; SI-NEXT:    v_mov_b32_e32 v17, v1
; SI-NEXT:    v_mov_b32_e32 v16, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB44_4
; SI-NEXT:  .LBB44_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB44_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v23
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v23
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v22
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v22
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v21
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v21
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v20
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v20
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v19
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v19
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v18
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v18
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v17
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v16
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB44_2
; SI-NEXT:  .LBB44_4: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v22
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v23
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v16bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v16bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v16bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define inreg <16 x bfloat> @bitcast_v8f32_to_v16bf16_scalar(<8 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f32_to_v16bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB45_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s23, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s23, 16
; SI-NEXT:    s_and_b32 s8, s22, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s22, 16
; SI-NEXT:    s_and_b32 s10, s21, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s21, 16
; SI-NEXT:    s_and_b32 s12, s20, 0xffff0000
; SI-NEXT:    s_lshl_b32 s13, s20, 16
; SI-NEXT:    s_and_b32 s14, s19, 0xffff0000
; SI-NEXT:    s_lshl_b32 s15, s19, 16
; SI-NEXT:    s_and_b32 s24, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s25, s18, 16
; SI-NEXT:    s_and_b32 s26, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s27, s17, 16
; SI-NEXT:    s_and_b32 s28, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s29, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB45_4
; SI-NEXT:  .LBB45_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB45_3:
; SI-NEXT:    ; implicit-def: $sgpr29
; SI-NEXT:    ; implicit-def: $sgpr28
; SI-NEXT:    ; implicit-def: $sgpr27
; SI-NEXT:    ; implicit-def: $sgpr26
; SI-NEXT:    ; implicit-def: $sgpr25
; SI-NEXT:    ; implicit-def: $sgpr24
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB45_2
; SI-NEXT:  .LBB45_4:
; SI-NEXT:    v_mov_b32_e32 v0, s29
; SI-NEXT:    v_mov_b32_e32 v1, s28
; SI-NEXT:    v_mov_b32_e32 v2, s27
; SI-NEXT:    v_mov_b32_e32 v3, s26
; SI-NEXT:    v_mov_b32_e32 v4, s25
; SI-NEXT:    v_mov_b32_e32 v5, s24
; SI-NEXT:    v_mov_b32_e32 v6, s15
; SI-NEXT:    v_mov_b32_e32 v7, s14
; SI-NEXT:    v_mov_b32_e32 v8, s13
; SI-NEXT:    v_mov_b32_e32 v9, s12
; SI-NEXT:    v_mov_b32_e32 v10, s11
; SI-NEXT:    v_mov_b32_e32 v11, s10
; SI-NEXT:    v_mov_b32_e32 v12, s9
; SI-NEXT:    v_mov_b32_e32 v13, s8
; SI-NEXT:    v_mov_b32_e32 v14, s7
; SI-NEXT:    v_mov_b32_e32 v15, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v16bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB45_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB45_4
; VI-NEXT:  .LBB45_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v7, s23, 1.0
; VI-NEXT:    v_add_f32_e64 v6, s22, 1.0
; VI-NEXT:    v_add_f32_e64 v5, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v4, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v3, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v2, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB45_3:
; VI-NEXT:    s_branch .LBB45_2
; VI-NEXT:  .LBB45_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v16bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB45_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB45_4
; GFX9-NEXT:  .LBB45_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v7, s23, 1.0
; GFX9-NEXT:    v_add_f32_e64 v6, s22, 1.0
; GFX9-NEXT:    v_add_f32_e64 v5, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v4, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v3, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v2, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB45_3:
; GFX9-NEXT:    s_branch .LBB45_2
; GFX9-NEXT:  .LBB45_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v16bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB45_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB45_4
; GFX11-NEXT:  .LBB45_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v7, s7, 1.0
; GFX11-NEXT:    v_add_f32_e64 v6, s6, 1.0
; GFX11-NEXT:    v_add_f32_e64 v5, s5, 1.0
; GFX11-NEXT:    v_add_f32_e64 v4, s4, 1.0
; GFX11-NEXT:    v_add_f32_e64 v3, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v2, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v1, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v0, s0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB45_3:
; GFX11-NEXT:    s_branch .LBB45_2
; GFX11-NEXT:  .LBB45_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define <8 x float> @bitcast_v16bf16_to_v8f32(<16 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v16bf16_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_mul_f32_e32 v26, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v27, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v24, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v25, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v10, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v11, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v14
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB46_4
; SI-NEXT:  .LBB46_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB46_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v27, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v25, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v23, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v21, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v19, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v17, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v11, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v9, 16
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB46_2
; SI-NEXT:  .LBB46_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v26
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v24
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v27
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v25
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v22
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v10
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16bf16_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB46_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v7, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v7
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v7
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; VI-NEXT:    v_cndmask_b32_e32 v7, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; VI-NEXT:    v_alignbit_b32 v7, v7, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v6, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; VI-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_alignbit_b32 v6, v6, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; VI-NEXT:    v_alignbit_b32 v5, v5, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v4
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; VI-NEXT:    v_alignbit_b32 v4, v4, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v3
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_alignbit_b32 v3, v3, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v2
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v1
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v0
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; VI-NEXT:  .LBB46_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16bf16_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB46_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v7, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v7, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v7
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v9, v10, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v7, v7, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v6, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v6, v6, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v5, v5, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v4, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v4, v4, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v3, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v3, v3, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v2, v2, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v1, v1, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v0, v0, v8, s7
; GFX9-NEXT:  .LBB46_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v16bf16_to_v8f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB46_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_lshlrev_b32 v8, 16, v7
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v9, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v8, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v8
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v11, v8, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v8, v11, v14 :: v_dual_and_b32 v7, 0xffff0000, v7
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 0x40c00000, v7 :: v_dual_lshlrev_b32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v15, v9, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v8.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v7, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v7
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v12, v7, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v6, 0x40c00000, v6 :: v_dual_cndmask_b32 v7, v12, v13
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v6, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v6
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-TRUE16-NEXT:    v_bfi_b32 v7, 0xffff, v8, v7
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v16, v6, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v6, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v6.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v9, v11, v12 :: v_dual_add_f32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v6, 0xffff, v6, v9
; GFX11-TRUE16-NEXT:    v_bfe_u32 v13, v10, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v14, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v13, v10, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v14, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v12, v13, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v10, v11, v14 :: v_dual_add_f32 v11, 0x40c00000, v15
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v8, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v4, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v5, 0xffff, v5, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v8, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v9, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v4.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v8, v8, v13, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v12, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_bfi_b32 v4, 0xffff, v4, v8
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v3, v12, v13 :: v_dual_add_f32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v10, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v10, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v10, v15, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v9, v9, v14 :: v_dual_and_b32 v14, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v3, 0xffff, v3, v9
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v10, v10, v12 :: v_dual_add_f32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v13, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v13, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v13, 0x40c00000, v14 :: v_dual_lshlrev_b32 v14, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v11, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_bfe_u32 v14, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v13, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, 0x400000, v13
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v12, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v14, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v19, 0x400000, v12
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v11, v13, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfe_u32 v18, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v15, v15, v12, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v18, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v12, v15, v19, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v2, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v11, v11, v16, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v12, v0
; GFX11-TRUE16-NEXT:  .LBB46_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v16bf16_to_v8f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB46_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_add_f32 v8, 0x40c00000, v8
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v8, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v15, v6, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v13, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_add3_u32 v10, v10, v8, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v10, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v15, v6, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX11-FAKE16-NEXT:    v_bfe_u32 v12, v7, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v12, v12, v7, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v12, v14 :: v_dual_lshlrev_b32 v12, 16, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v7, v8, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v6
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v13, v10 :: v_dual_add_f32 v10, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-FAKE16-NEXT:    v_bfe_u32 v12, v10, 16, 1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v11, v14 :: v_dual_lshlrev_b32 v11, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v6, v9, 0x7060302
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v11 :: v_dual_add_f32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v12, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v8, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v14, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v12 :: v_dual_lshlrev_b32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v5, v10, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v10, v10, v4, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v10, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v10, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v13, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v10, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v13, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v14, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v11, v12 :: v_dual_add_f32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v4, v8, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, 0x400000, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v11, 16, 1
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v3, v9, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add3_u32 v12, v16, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v13, v15 :: v_dual_lshlrev_b32 v15, 16, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v12, v13, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v15
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v14, v11, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v11
; GFX11-FAKE16-NEXT:    v_bfe_u32 v15, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v12, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, 0x400000, v12
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v2, v10, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v13, v14, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v14, v15, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v12, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v14, v15 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v1, v11, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v16, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v13, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v13, v18, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v12, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB46_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <16 x bfloat> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x bfloat> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define inreg <8 x float> @bitcast_v16bf16_to_v8f32_scalar(<16 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16bf16_to_v8f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mul_f32_e64 v22, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v23, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v20, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v21, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v18, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v19, 1.0, s20
; SI-NEXT:    v_mul_f32_e64 v16, 1.0, s23
; SI-NEXT:    v_mul_f32_e64 v17, 1.0, s22
; SI-NEXT:    v_mul_f32_e64 v14, 1.0, s25
; SI-NEXT:    v_mul_f32_e64 v15, 1.0, s24
; SI-NEXT:    v_mul_f32_e64 v12, 1.0, s27
; SI-NEXT:    v_mul_f32_e64 v13, 1.0, s26
; SI-NEXT:    v_mul_f32_e64 v10, 1.0, s29
; SI-NEXT:    v_mul_f32_e64 v11, 1.0, s28
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v0
; SI-NEXT:    s_cbranch_scc0 .LBB47_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v23, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v21, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v19, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v17, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v15, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v13, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v11, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v9, 16
; SI-NEXT:    s_cbranch_execnz .LBB47_3
; SI-NEXT:  .LBB47_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v14
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v15
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v12
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v13
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v10
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:  .LBB47_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB47_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB47_2
;
; VI-LABEL: bitcast_v16bf16_to_v8f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB47_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB47_4
; VI-NEXT:  .LBB47_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s23, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s22, 16
; VI-NEXT:    v_alignbit_b32 v7, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s21, 16
; VI-NEXT:    v_alignbit_b32 v6, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s20, 16
; VI-NEXT:    v_alignbit_b32 v5, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s19, 16
; VI-NEXT:    v_alignbit_b32 v4, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v8, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_alignbit_b32 v3, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v8, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v8, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v8, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; VI-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_alignbit_b32 v2, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v8, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v1
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; VI-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc
; VI-NEXT:    v_add_f32_e32 v8, s4, v0
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v8, v1, 16
; VI-NEXT:    v_add_f32_e32 v8, s4, v0
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v0
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB47_3:
; VI-NEXT:    s_branch .LBB47_2
; VI-NEXT:  .LBB47_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16bf16_to_v8f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB47_4
; GFX9-NEXT:  .LBB47_2: ; %cmp.true
; GFX9-NEXT:    s_and_b32 s4, s23, 0xffff0000
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s23, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v8, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s22, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v7, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s22, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s21, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v6, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s21, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s20, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v5, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s20, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s19, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v4, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s19, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v9, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s18, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v3, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v9, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v9, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v9, v9, v2
; GFX9-NEXT:    v_add_u32_e32 v9, 0x7fff, v9
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s17, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v2, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v9, v9, v1
; GFX9-NEXT:    v_add_u32_e32 v9, 0x7fff, v9
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX9-NEXT:    v_add_f32_e32 v9, s4, v0
; GFX9-NEXT:    v_bfe_u32 v10, v9, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v9
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v10, v11, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v9, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s16, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v9
; GFX9-NEXT:    v_add_f32_e32 v9, s4, v0
; GFX9-NEXT:    v_bfe_u32 v10, v9, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v9
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v10, v11, vcc
; GFX9-NEXT:    v_bfe_u32 v10, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v0
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v10, v11, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX9-NEXT:    v_and_b32_sdwa v0, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v9, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB47_3:
; GFX9-NEXT:    s_branch .LBB47_2
; GFX9-NEXT:  .LBB47_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16bf16_to_v8f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB47_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB47_4
; GFX11-NEXT:  .LBB47_2: ; %cmp.true
; GFX11-NEXT:    s_lshl_b32 s8, s7, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff0000
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s8
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s7
; GFX11-NEXT:    s_and_b32 s8, s6, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    v_add_f32_e64 v3, 0x40c00000, s8
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    s_and_b32 s7, s5, 0xffff0000
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s6
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s7
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_bfe_u32 v10, v3, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s5
; GFX11-NEXT:    v_bfe_u32 v11, v6, 16, 1
; GFX11-NEXT:    s_and_b32 s5, s4, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v8, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v2, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v10, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v8, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v3
; GFX11-NEXT:    v_bfe_u32 v9, v7, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v3, v8, v4 :: v_dual_add_nc_u32 v4, v9, v7
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v11, v6
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v2, v10 :: v_dual_add_nc_u32 v5, 0x7fff, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_add_f32_e64 v10, 0x40c00000, s4
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s5
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    v_lshl_or_b32 v7, v1, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v5, v9, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v9, v10, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v8, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-NEXT:    s_and_b32 s4, s3, 0xffff0000
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v9, v10
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e64 v9, 0x40c00000, s3
; GFX11-NEXT:    s_and_b32 s3, s2, 0xffff0000
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x7fff, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v11, v6, v8
; GFX11-NEXT:    v_lshl_or_b32 v6, v3, 16, v2
; GFX11-NEXT:    v_or_b32_e32 v3, 0x400000, v10
; GFX11-NEXT:    v_or_b32_e32 v2, 0x400000, v8
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s3
; GFX11-NEXT:    v_bfe_u32 v3, v9, 16, 1
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v1, v2 :: v_dual_and_b32 v4, 0xffff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v10, v8, 16, 1
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshl_or_b32 v5, v5, 16, v4
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s4
; GFX11-NEXT:    v_add_nc_u32_e32 v10, v10, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v2, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s2
; GFX11-NEXT:    s_and_b32 s2, s1, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v9
; GFX11-NEXT:    v_add_f32_e64 v13, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s1, s0, 16
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff0000
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v11, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x7fff, v10
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_bfe_u32 v11, v4, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v14, 0x40c00000, s0
; GFX11-NEXT:    v_or_b32_e32 v18, 0x400000, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_bfe_u32 v16, v14, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_dual_cndmask_b32 v8, v9, v10 :: v_dual_add_nc_u32 v9, v11, v4
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_f32_e64 v10, 0x40c00000, s2
; GFX11-NEXT:    v_add_nc_u32_e32 v16, v16, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x7fff, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_bfe_u32 v12, v10, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v17, 0x400000, v10
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v9, v11, vcc_lo
; GFX11-NEXT:    v_add_f32_e64 v9, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v11, v13, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, v12, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_bfe_u32 v15, v9, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v11, v11, v13
; GFX11-NEXT:    v_or_b32_e32 v19, 0x400000, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 0x7fff, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 0x7fff, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, v15, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 0x7fff, v11
; GFX11-NEXT:    v_or_b32_e32 v16, 0x400000, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 0x7fff, v15
; GFX11-NEXT:    v_cndmask_b32_e32 v11, v11, v18, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; GFX11-NEXT:    v_cndmask_b32_e32 v9, v15, v19, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX11-NEXT:    v_cndmask_b32_e32 v10, v12, v17, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; GFX11-NEXT:    v_cndmask_b32_e32 v12, v13, v16, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-NEXT:    v_lshl_or_b32 v4, v1, 16, v0
; GFX11-NEXT:    v_lshl_or_b32 v3, v2, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v10, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; GFX11-NEXT:    v_lshl_or_b32 v2, v8, 16, v13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshl_or_b32 v0, v12, 16, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB47_3:
; GFX11-NEXT:    s_branch .LBB47_2
; GFX11-NEXT:  .LBB47_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <16 x bfloat> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <16 x bfloat> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define <32 x i8> @bitcast_v8f32_to_v32i8(<8 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v8f32_to_v32i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v28, v7
; SI-NEXT:    v_mov_b32_e32 v24, v6
; SI-NEXT:    v_mov_b32_e32 v20, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v12, v3
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB48_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v27, v28, v24, 24
; SI-NEXT:    v_alignbit_b32 v26, v28, v24, 16
; SI-NEXT:    v_alignbit_b32 v25, v28, v24, 8
; SI-NEXT:    v_alignbit_b32 v19, v20, v16, 24
; SI-NEXT:    v_alignbit_b32 v18, v20, v16, 16
; SI-NEXT:    v_alignbit_b32 v17, v20, v16, 8
; SI-NEXT:    v_alignbit_b32 v11, v12, v32, 24
; SI-NEXT:    v_alignbit_b32 v10, v12, v32, 16
; SI-NEXT:    v_alignbit_b32 v9, v12, v32, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v31, 24, v28
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v29, 8, v28
; SI-NEXT:    v_lshrrev_b32_e32 v23, 24, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v21, 8, v20
; SI-NEXT:    v_lshrrev_b32_e32 v15, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:  .LBB48_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB48_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v32, 1.0, v32
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v28, 1.0, v28
; SI-NEXT:    v_add_f32_e32 v24, 1.0, v24
; SI-NEXT:    v_alignbit_b32 v27, v28, v24, 24
; SI-NEXT:    v_alignbit_b32 v26, v28, v24, 16
; SI-NEXT:    v_alignbit_b32 v25, v28, v24, 8
; SI-NEXT:    v_alignbit_b32 v19, v20, v16, 24
; SI-NEXT:    v_alignbit_b32 v18, v20, v16, 16
; SI-NEXT:    v_alignbit_b32 v17, v20, v16, 8
; SI-NEXT:    v_alignbit_b32 v11, v12, v32, 24
; SI-NEXT:    v_alignbit_b32 v10, v12, v32, 16
; SI-NEXT:    v_alignbit_b32 v9, v12, v32, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v31, 24, v28
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v29, 8, v28
; SI-NEXT:    v_lshrrev_b32_e32 v23, 24, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v21, 8, v20
; SI-NEXT:    v_lshrrev_b32_e32 v15, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:  .LBB48_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v8, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v32i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v33, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v35, v3
; VI-NEXT:    v_mov_b32_e32 v34, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB48_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; VI-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; VI-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; VI-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; VI-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; VI-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:  .LBB48_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB48_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e32 v35, 1.0, v35
; VI-NEXT:    v_add_f32_e32 v34, 1.0, v34
; VI-NEXT:    v_add_f32_e32 v33, 1.0, v33
; VI-NEXT:    v_add_f32_e32 v32, 1.0, v32
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; VI-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; VI-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; VI-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; VI-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; VI-NEXT:  .LBB48_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v1
; VI-NEXT:    v_mov_b32_e32 v8, v34
; VI-NEXT:    v_mov_b32_e32 v12, v35
; VI-NEXT:    v_mov_b32_e32 v16, v32
; VI-NEXT:    v_mov_b32_e32 v20, v33
; VI-NEXT:    v_mov_b32_e32 v24, v6
; VI-NEXT:    v_mov_b32_e32 v28, v7
; VI-NEXT:    v_mov_b32_e32 v1, v38
; VI-NEXT:    v_mov_b32_e32 v6, v37
; VI-NEXT:    v_mov_b32_e32 v7, v36
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v32i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v33, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v35, v3
; GFX9-NEXT:    v_mov_b32_e32 v34, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB48_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; GFX9-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:  .LBB48_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB48_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_add_f32_e32 v35, 1.0, v35
; GFX9-NEXT:    v_add_f32_e32 v34, 1.0, v34
; GFX9-NEXT:    v_add_f32_e32 v33, 1.0, v33
; GFX9-NEXT:    v_add_f32_e32 v32, 1.0, v32
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; GFX9-NEXT:  .LBB48_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v34
; GFX9-NEXT:    v_mov_b32_e32 v12, v35
; GFX9-NEXT:    v_mov_b32_e32 v16, v32
; GFX9-NEXT:    v_mov_b32_e32 v20, v33
; GFX9-NEXT:    v_mov_b32_e32 v24, v6
; GFX9-NEXT:    v_mov_b32_e32 v28, v7
; GFX9-NEXT:    v_mov_b32_e32 v1, v38
; GFX9-NEXT:    v_mov_b32_e32 v6, v37
; GFX9-NEXT:    v_mov_b32_e32 v7, v36
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v8f32_to_v32i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v33, v7 :: v_dual_mov_b32 v32, v6
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v27, v5 :: v_dual_mov_b32 v26, v4
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v19, v3 :: v_dual_mov_b32 v18, v2
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v11, v1 :: v_dual_mov_b32 v10, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr23_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr25_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr29_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr31_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB48_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[32:33]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[26:27]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[18:19]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX11-TRUE16-NEXT:  .LBB48_2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB48_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v32, 1.0, v32
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v33, 1.0, v33 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v26, 1.0, v26
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v27, 1.0, v27 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[32:33]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[26:27]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[18:19]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX11-TRUE16-NEXT:  .LBB48_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v11.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v18.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v18.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v36.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v19.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v26.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v26.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v35.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v27.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v27.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v32.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v34.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v28.l, v33.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v30.l, v33.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v8f32_to_v32i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v33, v7 :: v_dual_mov_b32 v32, v6
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v35, v5 :: v_dual_mov_b32 v34, v4
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v37, v3 :: v_dual_mov_b32 v36, v2
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v39, v1 :: v_dual_mov_b32 v38, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB48_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[27:28], 24, v[32:33]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[34:35]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[36:37]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[38:39]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v38
; GFX11-FAKE16-NEXT:  .LBB48_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB48_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v39, 1.0, v39 :: v_dual_add_f32 v32, 1.0, v32
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v37, 1.0, v37 :: v_dual_add_f32 v34, 1.0, v34
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v35, 1.0, v35 :: v_dual_add_f32 v36, 1.0, v36
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v33, 1.0, v33 :: v_dual_add_f32 v38, 1.0, v38
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[34:35]
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[36:37]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[27:28], 24, v[32:33]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[38:39]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v38
; GFX11-FAKE16-NEXT:  .LBB48_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v38
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v39
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v8, v36
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v12, v37
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v16, v34
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v20, v35
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v24, v32
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v28, v33
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <32 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <32 x i8>
  br label %end

end:
  %phi = phi <32 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i8> %phi
}

define inreg <32 x i8> @bitcast_v8f32_to_v32i8_scalar(<8 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v8f32_to_v32i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB49_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v27, s23, v0, 24
; SI-NEXT:    v_alignbit_b32 v26, s23, v0, 16
; SI-NEXT:    v_alignbit_b32 v25, s23, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v19, s21, v0, 24
; SI-NEXT:    v_alignbit_b32 v18, s21, v0, 16
; SI-NEXT:    v_alignbit_b32 v17, s21, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v11, s19, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s19, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s15, s23, 24
; SI-NEXT:    s_lshr_b32 s24, s23, 16
; SI-NEXT:    s_lshr_b32 s25, s23, 8
; SI-NEXT:    s_lshr_b32 s12, s21, 24
; SI-NEXT:    s_lshr_b32 s13, s21, 16
; SI-NEXT:    s_lshr_b32 s14, s21, 8
; SI-NEXT:    s_lshr_b32 s9, s19, 24
; SI-NEXT:    s_lshr_b32 s10, s19, 16
; SI-NEXT:    s_lshr_b32 s11, s19, 8
; SI-NEXT:    s_lshr_b32 s6, s17, 24
; SI-NEXT:    s_lshr_b32 s7, s17, 16
; SI-NEXT:    s_lshr_b32 s8, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB49_4
; SI-NEXT:  .LBB49_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v4, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v12, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v8, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v20, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v16, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v28, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v24, s22, 1.0
; SI-NEXT:    v_alignbit_b32 v27, v28, v24, 24
; SI-NEXT:    v_alignbit_b32 v26, v28, v24, 16
; SI-NEXT:    v_alignbit_b32 v25, v28, v24, 8
; SI-NEXT:    v_alignbit_b32 v19, v20, v16, 24
; SI-NEXT:    v_alignbit_b32 v18, v20, v16, 16
; SI-NEXT:    v_alignbit_b32 v17, v20, v16, 8
; SI-NEXT:    v_alignbit_b32 v11, v12, v8, 24
; SI-NEXT:    v_alignbit_b32 v10, v12, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, v12, v8, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v31, 24, v28
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v29, 8, v28
; SI-NEXT:    v_lshrrev_b32_e32 v23, 24, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v21, 8, v20
; SI-NEXT:    v_lshrrev_b32_e32 v15, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB49_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $sgpr25
; SI-NEXT:    ; implicit-def: $sgpr24
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    s_branch .LBB49_2
; SI-NEXT:  .LBB49_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v8, s18
; SI-NEXT:    v_mov_b32_e32 v12, s19
; SI-NEXT:    v_mov_b32_e32 v16, s20
; SI-NEXT:    v_mov_b32_e32 v20, s21
; SI-NEXT:    v_mov_b32_e32 v24, s22
; SI-NEXT:    v_mov_b32_e32 v28, s23
; SI-NEXT:    v_mov_b32_e32 v5, s8
; SI-NEXT:    v_mov_b32_e32 v6, s7
; SI-NEXT:    v_mov_b32_e32 v7, s6
; SI-NEXT:    v_mov_b32_e32 v13, s11
; SI-NEXT:    v_mov_b32_e32 v14, s10
; SI-NEXT:    v_mov_b32_e32 v15, s9
; SI-NEXT:    v_mov_b32_e32 v21, s14
; SI-NEXT:    v_mov_b32_e32 v22, s13
; SI-NEXT:    v_mov_b32_e32 v23, s12
; SI-NEXT:    v_mov_b32_e32 v29, s25
; SI-NEXT:    v_mov_b32_e32 v30, s24
; SI-NEXT:    v_mov_b32_e32 v31, s15
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v8f32_to_v32i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB49_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s14, s23, 24
; VI-NEXT:    s_lshr_b32 s15, s23, 16
; VI-NEXT:    s_lshr_b32 s25, s23, 8
; VI-NEXT:    s_lshr_b32 s24, s22, 16
; VI-NEXT:    s_lshr_b32 s26, s22, 8
; VI-NEXT:    s_lshr_b32 s27, s21, 24
; VI-NEXT:    s_lshr_b32 s28, s21, 16
; VI-NEXT:    s_lshr_b32 s40, s21, 8
; VI-NEXT:    s_lshr_b32 s29, s20, 16
; VI-NEXT:    s_lshr_b32 s41, s20, 8
; VI-NEXT:    s_lshr_b32 s42, s19, 24
; VI-NEXT:    s_lshr_b32 s43, s19, 16
; VI-NEXT:    s_lshr_b32 s45, s19, 8
; VI-NEXT:    s_lshr_b32 s44, s18, 16
; VI-NEXT:    s_lshr_b32 s46, s18, 8
; VI-NEXT:    s_lshr_b32 s47, s17, 24
; VI-NEXT:    s_lshr_b32 s56, s17, 16
; VI-NEXT:    s_lshr_b32 s58, s17, 8
; VI-NEXT:    s_lshr_b32 s57, s16, 16
; VI-NEXT:    s_lshr_b32 s59, s16, 8
; VI-NEXT:    s_lshr_b64 s[10:11], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[8:9], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB49_4
; VI-NEXT:  .LBB49_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e64 v1, s17, 1.0
; VI-NEXT:    v_add_f32_e64 v0, s16, 1.0
; VI-NEXT:    v_add_f32_e64 v9, s19, 1.0
; VI-NEXT:    v_add_f32_e64 v8, s18, 1.0
; VI-NEXT:    v_add_f32_e64 v17, s21, 1.0
; VI-NEXT:    v_add_f32_e64 v16, s20, 1.0
; VI-NEXT:    v_add_f32_e64 v25, s23, 1.0
; VI-NEXT:    v_add_f32_e64 v24, s22, 1.0
; VI-NEXT:    v_lshrrev_b64 v[27:28], 24, v[24:25]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[16:17]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v31, 24, v25
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v25
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v24
; VI-NEXT:    v_lshrrev_b32_e32 v32, 8, v24
; VI-NEXT:    v_lshrrev_b32_e32 v23, 24, v17
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v21, 8, v17
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v33, 8, v16
; VI-NEXT:    v_lshrrev_b32_e32 v15, 24, v9
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v9
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v34, 8, v8
; VI-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v35, 8, v0
; VI-NEXT:    s_branch .LBB49_5
; VI-NEXT:  .LBB49_3:
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr43
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr41
; VI-NEXT:    ; implicit-def: $sgpr29
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr28
; VI-NEXT:    ; implicit-def: $sgpr27
; VI-NEXT:    ; implicit-def: $sgpr26
; VI-NEXT:    ; implicit-def: $sgpr24
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr25
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    s_branch .LBB49_2
; VI-NEXT:  .LBB49_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v9, s19
; VI-NEXT:    v_mov_b32_e32 v16, s20
; VI-NEXT:    v_mov_b32_e32 v17, s21
; VI-NEXT:    v_mov_b32_e32 v24, s22
; VI-NEXT:    v_mov_b32_e32 v25, s23
; VI-NEXT:    v_mov_b32_e32 v35, s59
; VI-NEXT:    v_mov_b32_e32 v2, s57
; VI-NEXT:    v_mov_b32_e32 v5, s58
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s47
; VI-NEXT:    v_mov_b32_e32 v34, s46
; VI-NEXT:    v_mov_b32_e32 v10, s44
; VI-NEXT:    v_mov_b32_e32 v13, s45
; VI-NEXT:    v_mov_b32_e32 v14, s43
; VI-NEXT:    v_mov_b32_e32 v15, s42
; VI-NEXT:    v_mov_b32_e32 v33, s41
; VI-NEXT:    v_mov_b32_e32 v18, s29
; VI-NEXT:    v_mov_b32_e32 v21, s40
; VI-NEXT:    v_mov_b32_e32 v22, s28
; VI-NEXT:    v_mov_b32_e32 v23, s27
; VI-NEXT:    v_mov_b32_e32 v32, s26
; VI-NEXT:    v_mov_b32_e32 v26, s24
; VI-NEXT:    v_mov_b32_e32 v29, s25
; VI-NEXT:    v_mov_b32_e32 v30, s15
; VI-NEXT:    v_mov_b32_e32 v31, s14
; VI-NEXT:    v_mov_b32_e32 v27, s10
; VI-NEXT:    v_mov_b32_e32 v19, s8
; VI-NEXT:    v_mov_b32_e32 v11, s6
; VI-NEXT:    v_mov_b32_e32 v3, s4
; VI-NEXT:  .LBB49_5: ; %end
; VI-NEXT:    v_mov_b32_e32 v4, v1
; VI-NEXT:    v_mov_b32_e32 v12, v9
; VI-NEXT:    v_mov_b32_e32 v20, v17
; VI-NEXT:    v_mov_b32_e32 v28, v25
; VI-NEXT:    v_mov_b32_e32 v1, v35
; VI-NEXT:    v_mov_b32_e32 v9, v34
; VI-NEXT:    v_mov_b32_e32 v17, v33
; VI-NEXT:    v_mov_b32_e32 v25, v32
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v8f32_to_v32i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s14, s23, 24
; GFX9-NEXT:    s_lshr_b32 s15, s23, 16
; GFX9-NEXT:    s_lshr_b32 s25, s23, 8
; GFX9-NEXT:    s_lshr_b32 s24, s22, 16
; GFX9-NEXT:    s_lshr_b32 s26, s22, 8
; GFX9-NEXT:    s_lshr_b32 s27, s21, 24
; GFX9-NEXT:    s_lshr_b32 s28, s21, 16
; GFX9-NEXT:    s_lshr_b32 s40, s21, 8
; GFX9-NEXT:    s_lshr_b32 s29, s20, 16
; GFX9-NEXT:    s_lshr_b32 s41, s20, 8
; GFX9-NEXT:    s_lshr_b32 s42, s19, 24
; GFX9-NEXT:    s_lshr_b32 s43, s19, 16
; GFX9-NEXT:    s_lshr_b32 s45, s19, 8
; GFX9-NEXT:    s_lshr_b32 s44, s18, 16
; GFX9-NEXT:    s_lshr_b32 s46, s18, 8
; GFX9-NEXT:    s_lshr_b32 s47, s17, 24
; GFX9-NEXT:    s_lshr_b32 s56, s17, 16
; GFX9-NEXT:    s_lshr_b32 s58, s17, 8
; GFX9-NEXT:    s_lshr_b32 s57, s16, 16
; GFX9-NEXT:    s_lshr_b32 s59, s16, 8
; GFX9-NEXT:    s_lshr_b64 s[10:11], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[8:9], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB49_4
; GFX9-NEXT:  .LBB49_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e64 v1, s17, 1.0
; GFX9-NEXT:    v_add_f32_e64 v0, s16, 1.0
; GFX9-NEXT:    v_add_f32_e64 v9, s19, 1.0
; GFX9-NEXT:    v_add_f32_e64 v8, s18, 1.0
; GFX9-NEXT:    v_add_f32_e64 v17, s21, 1.0
; GFX9-NEXT:    v_add_f32_e64 v16, s20, 1.0
; GFX9-NEXT:    v_add_f32_e64 v25, s23, 1.0
; GFX9-NEXT:    v_add_f32_e64 v24, s22, 1.0
; GFX9-NEXT:    v_lshrrev_b64 v[27:28], 24, v[24:25]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[16:17]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[8:9]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 24, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v25
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 8, v24
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 8, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 8, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 8, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 8, v0
; GFX9-NEXT:    s_branch .LBB49_5
; GFX9-NEXT:  .LBB49_3:
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr43
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr41
; GFX9-NEXT:    ; implicit-def: $sgpr29
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr28
; GFX9-NEXT:    ; implicit-def: $sgpr27
; GFX9-NEXT:    ; implicit-def: $sgpr26
; GFX9-NEXT:    ; implicit-def: $sgpr24
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr25
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    s_branch .LBB49_2
; GFX9-NEXT:  .LBB49_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v9, s19
; GFX9-NEXT:    v_mov_b32_e32 v16, s20
; GFX9-NEXT:    v_mov_b32_e32 v17, s21
; GFX9-NEXT:    v_mov_b32_e32 v24, s22
; GFX9-NEXT:    v_mov_b32_e32 v25, s23
; GFX9-NEXT:    v_mov_b32_e32 v35, s59
; GFX9-NEXT:    v_mov_b32_e32 v2, s57
; GFX9-NEXT:    v_mov_b32_e32 v5, s58
; GFX9-NEXT:    v_mov_b32_e32 v6, s56
; GFX9-NEXT:    v_mov_b32_e32 v7, s47
; GFX9-NEXT:    v_mov_b32_e32 v34, s46
; GFX9-NEXT:    v_mov_b32_e32 v10, s44
; GFX9-NEXT:    v_mov_b32_e32 v13, s45
; GFX9-NEXT:    v_mov_b32_e32 v14, s43
; GFX9-NEXT:    v_mov_b32_e32 v15, s42
; GFX9-NEXT:    v_mov_b32_e32 v33, s41
; GFX9-NEXT:    v_mov_b32_e32 v18, s29
; GFX9-NEXT:    v_mov_b32_e32 v21, s40
; GFX9-NEXT:    v_mov_b32_e32 v22, s28
; GFX9-NEXT:    v_mov_b32_e32 v23, s27
; GFX9-NEXT:    v_mov_b32_e32 v32, s26
; GFX9-NEXT:    v_mov_b32_e32 v26, s24
; GFX9-NEXT:    v_mov_b32_e32 v29, s25
; GFX9-NEXT:    v_mov_b32_e32 v30, s15
; GFX9-NEXT:    v_mov_b32_e32 v31, s14
; GFX9-NEXT:    v_mov_b32_e32 v27, s10
; GFX9-NEXT:    v_mov_b32_e32 v19, s8
; GFX9-NEXT:    v_mov_b32_e32 v11, s6
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:  .LBB49_5: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-NEXT:    v_mov_b32_e32 v12, v9
; GFX9-NEXT:    v_mov_b32_e32 v20, v17
; GFX9-NEXT:    v_mov_b32_e32 v28, v25
; GFX9-NEXT:    v_mov_b32_e32 v1, v35
; GFX9-NEXT:    v_mov_b32_e32 v9, v34
; GFX9-NEXT:    v_mov_b32_e32 v17, v33
; GFX9-NEXT:    v_mov_b32_e32 v25, v32
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v8f32_to_v32i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s12, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB49_3
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s13, s19, 24
; GFX11-NEXT:    s_lshr_b32 s14, s19, 16
; GFX11-NEXT:    s_lshr_b32 s20, s19, 8
; GFX11-NEXT:    s_lshr_b32 s15, s18, 16
; GFX11-NEXT:    s_lshr_b32 s21, s18, 8
; GFX11-NEXT:    s_lshr_b32 s22, s17, 24
; GFX11-NEXT:    s_lshr_b32 s23, s17, 16
; GFX11-NEXT:    s_lshr_b32 s25, s17, 8
; GFX11-NEXT:    s_lshr_b32 s24, s16, 16
; GFX11-NEXT:    s_lshr_b32 s26, s16, 8
; GFX11-NEXT:    s_lshr_b32 s27, s3, 24
; GFX11-NEXT:    s_lshr_b32 s28, s3, 16
; GFX11-NEXT:    s_lshr_b32 s40, s3, 8
; GFX11-NEXT:    s_lshr_b32 s29, s2, 16
; GFX11-NEXT:    s_lshr_b32 s41, s2, 8
; GFX11-NEXT:    s_lshr_b32 s42, s1, 24
; GFX11-NEXT:    s_lshr_b32 s43, s1, 16
; GFX11-NEXT:    s_lshr_b32 s45, s1, 8
; GFX11-NEXT:    s_lshr_b32 s44, s0, 16
; GFX11-NEXT:    s_lshr_b32 s46, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[10:11], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[8:9], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s12
; GFX11-NEXT:    s_cbranch_vccnz .LBB49_4
; GFX11-NEXT:  .LBB49_2: ; %cmp.true
; GFX11-NEXT:    v_add_f32_e64 v39, s1, 1.0
; GFX11-NEXT:    v_add_f32_e64 v37, s3, 1.0
; GFX11-NEXT:    v_add_f32_e64 v35, s17, 1.0
; GFX11-NEXT:    v_add_f32_e64 v33, s19, 1.0
; GFX11-NEXT:    v_add_f32_e64 v32, s18, 1.0
; GFX11-NEXT:    v_add_f32_e64 v34, s16, 1.0
; GFX11-NEXT:    v_add_f32_e64 v36, s2, 1.0
; GFX11-NEXT:    v_add_f32_e64 v38, s0, 1.0
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-NEXT:    v_lshrrev_b64 v[27:28], 24, v[32:33]
; GFX11-NEXT:    v_lshrrev_b64 v[19:20], 24, v[34:35]
; GFX11-NEXT:    v_lshrrev_b64 v[11:12], 24, v[36:37]
; GFX11-NEXT:    v_lshrrev_b64 v[3:4], 24, v[38:39]
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v33
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-NEXT:    v_lshrrev_b32_e32 v26, 16, v32
; GFX11-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-NEXT:    v_lshrrev_b32_e32 v23, 24, v35
; GFX11-NEXT:    v_lshrrev_b32_e32 v22, 16, v35
; GFX11-NEXT:    v_lshrrev_b32_e32 v21, 8, v35
; GFX11-NEXT:    v_lshrrev_b32_e32 v18, 16, v34
; GFX11-NEXT:    v_lshrrev_b32_e32 v17, 8, v34
; GFX11-NEXT:    v_lshrrev_b32_e32 v15, 24, v37
; GFX11-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX11-NEXT:    v_lshrrev_b32_e32 v13, 8, v37
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v36
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 8, v36
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 24, v39
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v39
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 8, v39
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v38
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 8, v38
; GFX11-NEXT:    s_branch .LBB49_5
; GFX11-NEXT:  .LBB49_3:
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr29
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr28
; GFX11-NEXT:    ; implicit-def: $sgpr27
; GFX11-NEXT:    ; implicit-def: $sgpr26
; GFX11-NEXT:    ; implicit-def: $sgpr24
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr25
; GFX11-NEXT:    ; implicit-def: $sgpr23
; GFX11-NEXT:    ; implicit-def: $sgpr22
; GFX11-NEXT:    ; implicit-def: $sgpr21
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr20
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    s_branch .LBB49_2
; GFX11-NEXT:  .LBB49_4:
; GFX11-NEXT:    v_dual_mov_b32 v38, s0 :: v_dual_mov_b32 v39, s1
; GFX11-NEXT:    v_dual_mov_b32 v36, s2 :: v_dual_mov_b32 v37, s3
; GFX11-NEXT:    v_dual_mov_b32 v34, s16 :: v_dual_mov_b32 v35, s17
; GFX11-NEXT:    v_dual_mov_b32 v32, s18 :: v_dual_mov_b32 v33, s19
; GFX11-NEXT:    v_dual_mov_b32 v1, s46 :: v_dual_mov_b32 v2, s44
; GFX11-NEXT:    v_dual_mov_b32 v5, s45 :: v_dual_mov_b32 v6, s43
; GFX11-NEXT:    v_dual_mov_b32 v7, s42 :: v_dual_mov_b32 v10, s29
; GFX11-NEXT:    v_dual_mov_b32 v9, s41 :: v_dual_mov_b32 v14, s28
; GFX11-NEXT:    v_dual_mov_b32 v13, s40 :: v_dual_mov_b32 v18, s24
; GFX11-NEXT:    v_dual_mov_b32 v15, s27 :: v_dual_mov_b32 v22, s23
; GFX11-NEXT:    v_dual_mov_b32 v17, s26 :: v_dual_mov_b32 v26, s15
; GFX11-NEXT:    v_dual_mov_b32 v21, s25 :: v_dual_mov_b32 v30, s14
; GFX11-NEXT:    v_mov_b32_e32 v23, s22
; GFX11-NEXT:    v_mov_b32_e32 v25, s21
; GFX11-NEXT:    v_mov_b32_e32 v29, s20
; GFX11-NEXT:    v_mov_b32_e32 v31, s13
; GFX11-NEXT:    v_mov_b32_e32 v27, s10
; GFX11-NEXT:    v_mov_b32_e32 v19, s8
; GFX11-NEXT:    v_mov_b32_e32 v11, s6
; GFX11-NEXT:    v_mov_b32_e32 v3, s4
; GFX11-NEXT:  .LBB49_5: ; %end
; GFX11-NEXT:    v_mov_b32_e32 v0, v38
; GFX11-NEXT:    v_mov_b32_e32 v4, v39
; GFX11-NEXT:    v_mov_b32_e32 v8, v36
; GFX11-NEXT:    v_mov_b32_e32 v12, v37
; GFX11-NEXT:    v_mov_b32_e32 v16, v34
; GFX11-NEXT:    v_mov_b32_e32 v20, v35
; GFX11-NEXT:    v_mov_b32_e32 v24, v32
; GFX11-NEXT:    v_mov_b32_e32 v28, v33
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <8 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <8 x float> %a1 to <32 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <8 x float> %a to <32 x i8>
  br label %end

end:
  %phi = phi <32 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i8> %phi
}

define <8 x float> @bitcast_v32i8_to_v8f32(<32 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v32i8_to_v8f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v31, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    v_mov_b32_e32 v34, v6
; SI-NEXT:    v_mov_b32_e32 v33, v4
; SI-NEXT:    v_lshlrev_b32_e32 v52, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v51, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v50, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v49, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v48, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v39, 24, v11
; SI-NEXT:    v_lshlrev_b32_e32 v38, 8, v13
; SI-NEXT:    v_lshlrev_b32_e32 v37, 24, v15
; SI-NEXT:    v_lshlrev_b32_e32 v36, 8, v17
; SI-NEXT:    v_lshlrev_b32_e32 v35, 24, v19
; SI-NEXT:    v_lshlrev_b32_e32 v19, 8, v21
; SI-NEXT:    v_lshlrev_b32_e32 v17, 24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v15, 8, v25
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v27
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v29
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB50_4
; SI-NEXT:  .LBB50_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB50_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v31
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v32
; SI-NEXT:    v_or_b32_e32 v0, v0, v52
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v51, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v33
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v50
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v49, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v8
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v2, v2, v48
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v39, v3
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v12
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v14
; SI-NEXT:    v_or_b32_e32 v3, v3, v38
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v4, v37, v4
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v16
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v18
; SI-NEXT:    v_or_b32_e32 v4, v4, v36
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v5, v35, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v20
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v22
; SI-NEXT:    v_or_b32_e32 v5, v5, v19
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v6, v17, v6
; SI-NEXT:    v_or_b32_e32 v5, v5, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v24
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v26
; SI-NEXT:    v_or_b32_e32 v6, v6, v15
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v7, v13, v7
; SI-NEXT:    v_or_b32_e32 v6, v6, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v28
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v30
; SI-NEXT:    v_or_b32_e32 v7, v7, v11
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB50_2
; SI-NEXT:  .LBB50_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v32
; SI-NEXT:    v_or_b32_e32 v0, v52, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v51, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v34
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v1, v50, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v49, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v10
; SI-NEXT:    v_or_b32_e32 v2, v48, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v39, v3
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v12
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v14
; SI-NEXT:    v_or_b32_e32 v3, v38, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v4, v37, v4
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v16
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v18
; SI-NEXT:    v_or_b32_e32 v4, v36, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v5, v35, v5
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v22
; SI-NEXT:    v_or_b32_e32 v5, v19, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v6, v17, v6
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v26
; SI-NEXT:    v_or_b32_e32 v6, v15, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v7, v13, v7
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v28
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v30
; SI-NEXT:    v_or_b32_e32 v7, v11, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x300, v7
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s7, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s7, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s7, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s7, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s7, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i8_to_v8f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v32, v2
; VI-NEXT:    v_mov_b32_e32 v31, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; VI-NEXT:    v_mov_b32_e32 v34, v6
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_lshlrev_b16_e32 v52, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v51, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v50, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v49, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v39, 8, v11
; VI-NEXT:    v_lshlrev_b16_e32 v38, 8, v13
; VI-NEXT:    v_lshlrev_b16_e32 v37, 8, v15
; VI-NEXT:    v_lshlrev_b16_e32 v36, 8, v17
; VI-NEXT:    v_lshlrev_b16_e32 v35, 8, v19
; VI-NEXT:    v_lshlrev_b16_e32 v19, 8, v21
; VI-NEXT:    v_lshlrev_b16_e32 v17, 8, v23
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v25
; VI-NEXT:    v_lshlrev_b16_e32 v13, 8, v27
; VI-NEXT:    v_lshlrev_b16_e32 v11, 8, v29
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v9, 8, v2
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB50_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB50_4
; VI-NEXT:  .LBB50_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB50_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v31, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v32, v51 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v33, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v34, v49 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v12, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v14, v37 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v16, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v18, v35 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v22, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v26, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v28, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v30, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB50_2
; VI-NEXT:  .LBB50_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v31
; VI-NEXT:    v_add_u16_e32 v1, 3, v32
; VI-NEXT:    v_or_b32_sdwa v0, v52, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v7, 0x300
; VI-NEXT:    v_add_u16_e32 v2, 3, v33
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v50, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v34
; VI-NEXT:    v_or_b32_sdwa v2, v49, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v8
; VI-NEXT:    v_add_u16_e32 v3, 3, v10
; VI-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v39, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v2, 0x300, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v12
; VI-NEXT:    v_add_u16_e32 v4, 3, v14
; VI-NEXT:    v_or_b32_sdwa v3, v38, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v37, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_add_u16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v16
; VI-NEXT:    v_add_u16_e32 v5, 3, v18
; VI-NEXT:    v_or_b32_sdwa v4, v36, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v5, v35, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v4, 0x300, v4
; VI-NEXT:    v_add_u16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v20
; VI-NEXT:    v_add_u16_e32 v6, 3, v22
; VI-NEXT:    v_or_b32_sdwa v5, v19, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v6, v17, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v5, 0x300, v5
; VI-NEXT:    v_add_u16_sdwa v6, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v24
; VI-NEXT:    v_add_u16_e32 v8, 3, v26
; VI-NEXT:    v_or_b32_sdwa v6, v15, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v8, v13, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v6, 0x300, v6
; VI-NEXT:    v_add_u16_sdwa v8, v8, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v28
; VI-NEXT:    v_add_u16_e32 v10, 3, v30
; VI-NEXT:    v_or_b32_sdwa v8, v11, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v9, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v8, 0x300, v8
; VI-NEXT:    v_add_u16_sdwa v7, v9, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i8_to_v8f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v2
; GFX9-NEXT:    v_mov_b32_e32 v31, v0
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; GFX9-NEXT:    v_mov_b32_e32 v34, v6
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_lshlrev_b16_e32 v52, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v51, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v50, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v49, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v48, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v39, 8, v11
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v13
; GFX9-NEXT:    v_lshlrev_b16_e32 v37, 8, v15
; GFX9-NEXT:    v_lshlrev_b16_e32 v36, 8, v17
; GFX9-NEXT:    v_lshlrev_b16_e32 v35, 8, v19
; GFX9-NEXT:    v_lshlrev_b16_e32 v19, 8, v21
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 8, v23
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v25
; GFX9-NEXT:    v_lshlrev_b16_e32 v13, 8, v27
; GFX9-NEXT:    v_lshlrev_b16_e32 v11, 8, v29
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v9, 8, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB50_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB50_4
; GFX9-NEXT:  .LBB50_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB50_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v31, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v32, v51 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v33, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v34, v49 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v12, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v14, v37 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v16, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v18, v35 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v22, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v26, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v28, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v30, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB50_2
; GFX9-NEXT:  .LBB50_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v31
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v32
; GFX9-NEXT:    v_or_b32_sdwa v0, v52, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v33
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v34
; GFX9-NEXT:    v_or_b32_sdwa v1, v50, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v49, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v39, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v12
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v3, v38, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v4, v37, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v3, 0x300, v3
; GFX9-NEXT:    v_add_u16_sdwa v4, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v16
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v18
; GFX9-NEXT:    v_or_b32_sdwa v4, v36, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v5, v35, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v4, 0x300, v4
; GFX9-NEXT:    v_add_u16_sdwa v5, v5, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v20
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v22
; GFX9-NEXT:    v_or_b32_sdwa v5, v19, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v6, v17, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v5, 0x300, v5
; GFX9-NEXT:    v_add_u16_sdwa v6, v6, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v24
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v26
; GFX9-NEXT:    v_or_b32_sdwa v6, v15, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v7, v13, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v6, 0x300, v6
; GFX9-NEXT:    v_add_u16_sdwa v7, v7, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v28
; GFX9-NEXT:    v_add_u16_e32 v8, 3, v30
; GFX9-NEXT:    v_or_b32_sdwa v7, v11, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v8, v9, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v7, 0x300, v7
; GFX9-NEXT:    v_add_u16_sdwa v8, v8, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v32i8_to_v8f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v31, off, s32
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.h, v21.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.h, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.h, v17.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.h, v15.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.h, v13.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.h, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.h, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.l, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.h, 8, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.l, 8, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.h, 8, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 8, v25.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.l, 8, v24.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.h, 8, v23.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.l, 8, v22.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 8, v21.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.l, 8, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v25.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.l, 8, v27.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v29.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.l, 8, v31.l
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB50_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB50_4
; GFX11-TRUE16-NEXT:  .LBB50_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB50_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v21.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v20.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v19.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v19.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v14.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v0.h, v17.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v1.h, v16.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v13.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v15.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v16.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v20.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v14.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v18.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v10.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v11.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v12.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v11.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v4.h, v12.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v22.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v24.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v26.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v28.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v30.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v8.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v4.h, v9.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v13, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v15, v8
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v7, v10
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr22_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr24_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr26_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr28_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr30_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr11_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr11_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr12_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr12_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB50_2
; GFX11-TRUE16-NEXT:  .LBB50_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v21.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v20.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v14.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v13.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v19.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v18.h, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v17.l, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v15.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v15.h, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v17.h, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v19.l, 3
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v13.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v16.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, v20.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v16.h, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v14.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.h, v18.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v10.h, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v11.h, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v12.h, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v11.l, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.h, v12.l, v4.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v5.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v4.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v22.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v24.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v26.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.h, v28.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, v30.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v8.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v8.h, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v9.l, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.h, v9.h, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v10.l, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v4.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v13, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v15, v8
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v7, v10
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v32i8_to_v8f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v32, v2 :: v_dual_mov_b32 v31, v0
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    scratch_load_b32 v0, off, s32 offset:4
; GFX11-FAKE16-NEXT:    scratch_load_u16 v2, off, s32
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v34, v6 :: v_dual_mov_b32 v33, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v51, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v49, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v50, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v48, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v38, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v39, 8, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v35, 8, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v36, 8, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v37, 8, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v19, 8, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v9, 8, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 8, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 8, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v29
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB50_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB50_4
; GFX11-FAKE16-NEXT:  .LBB50_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB50_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v32
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v51
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v49
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v50
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v48
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v38
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v35
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v36
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v37
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v11, v12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB50_2
; GFX11-FAKE16-NEXT:  .LBB50_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v31, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v32, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v33, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v34, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v51, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v49, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v50, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v48, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v38, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v39, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v18, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v12, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v16, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, v20, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v22, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, v24, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, v26, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, v28, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, v30, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v35, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v36, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v37, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v19, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v21, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v9, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v11, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v13, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v15, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v17, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, 0x300, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, 0x300, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v11, v12
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i8> %a, splat (i8 3)
  %a2 = bitcast <32 x i8> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i8> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define inreg <8 x float> @bitcast_v32i8_to_v8f32_scalar(<32 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i8_to_v8f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v22, v6
; SI-NEXT:    v_mov_b32_e32 v21, v4
; SI-NEXT:    v_mov_b32_e32 v20, v2
; SI-NEXT:    v_mov_b32_e32 v19, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v1
; SI-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; SI-NEXT:    v_lshlrev_b32_e32 v25, 24, v5
; SI-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; SI-NEXT:    v_lshlrev_b32_e32 v23, 24, v9
; SI-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v17
; SI-NEXT:    s_cbranch_scc0 .LBB51_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v20
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v21
; SI-NEXT:    v_or_b32_e32 v0, v0, v26
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v4, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v10
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v12
; SI-NEXT:    v_or_b32_e32 v0, v0, v18
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_or_b32_e32 v6, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v16
; SI-NEXT:    v_or_b32_e32 v0, v0, v11
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v22
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v8
; SI-NEXT:    v_or_b32_e32 v7, v0, v1
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    s_lshl_b32 s5, s29, 8
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v19
; SI-NEXT:    v_or_b32_e32 v2, v2, v24
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v23, v3
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v5, v2, v3
; SI-NEXT:    v_or_b32_e32 v3, s4, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s26, 0xff
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_lshl_b32 s8, s27, 24
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_cbranch_execnz .LBB51_3
; SI-NEXT:  .LBB51_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s28, 0xff
; SI-NEXT:    s_lshl_b32 s8, s29, 8
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v19
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_addk_i32 s7, 0x300
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_and_b32 s7, s7, 0xffff
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v0, s7, v0
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v21
; SI-NEXT:    v_or_b32_e32 v0, v26, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v8
; SI-NEXT:    v_or_b32_e32 v0, v24, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v23, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v12
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v16
; SI-NEXT:    v_or_b32_e32 v0, v11, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:  .LBB51_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB51_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB51_2
;
; VI-LABEL: bitcast_v32i8_to_v8f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v22, v6
; VI-NEXT:    v_mov_b32_e32 v21, v4
; VI-NEXT:    v_mov_b32_e32 v20, v2
; VI-NEXT:    v_mov_b32_e32 v19, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_lshlrev_b32_e32 v27, 8, v1
; VI-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; VI-NEXT:    v_lshlrev_b32_e32 v25, 8, v5
; VI-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; VI-NEXT:    v_lshlrev_b32_e32 v23, 8, v9
; VI-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; VI-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; VI-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; VI-NEXT:    v_lshlrev_b32_e32 v9, 8, v17
; VI-NEXT:    s_cbranch_scc0 .LBB51_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v20, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v21, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v10, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s28, 0xff
; VI-NEXT:    s_lshl_b32 s5, s29, 8
; VI-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v14, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v16, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    v_or_b32_sdwa v2, v22, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v8, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v19, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, s4, v0
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_cbranch_execnz .LBB51_3
; VI-NEXT:  .LBB51_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s28, 0xff
; VI-NEXT:    s_lshl_b32 s8, s29, 8
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_addk_i32 s7, 0x300
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v19
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v27, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_e32 v0, s7, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v20
; VI-NEXT:    v_or_b32_sdwa v0, v26, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v22
; VI-NEXT:    v_or_b32_sdwa v0, v24, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v10
; VI-NEXT:    v_or_b32_sdwa v0, v18, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v7, vcc, 0x3000000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:  .LBB51_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB51_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; VI-NEXT:    s_branch .LBB51_2
;
; GFX9-LABEL: bitcast_v32i8_to_v8f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v22, v6
; GFX9-NEXT:    v_mov_b32_e32 v21, v4
; GFX9-NEXT:    v_mov_b32_e32 v20, v2
; GFX9-NEXT:    v_mov_b32_e32 v19, v0
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_lshlrev_b32_e32 v27, 8, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v25, 8, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v23, 8, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 8, v17
; GFX9-NEXT:    s_cbranch_scc0 .LBB51_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v20, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v21, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s29, 8
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v14, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    v_or_b32_sdwa v2, v22, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v8, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    v_or_b32_sdwa v0, v19, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s4, v0
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB51_3
; GFX9-NEXT:  .LBB51_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_and_b32 s6, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s19, 8
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s6
; GFX9-NEXT:    s_and_b32 s6, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s23, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_and_b32 s8, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s27, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_addk_i32 s8, 0x300
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 16
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s8, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s29, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v19
; GFX9-NEXT:    s_movk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s8, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v0, v27, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX9-NEXT:    v_add_u32_sdwa v0, v0, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s8, v0
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v21
; GFX9-NEXT:    v_or_b32_sdwa v0, v26, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v8
; GFX9-NEXT:    v_or_b32_sdwa v0, v24, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v12
; GFX9-NEXT:    v_or_b32_sdwa v0, v18, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v16
; GFX9-NEXT:    v_or_b32_sdwa v0, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:  .LBB51_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB51_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX9-NEXT:    s_branch .LBB51_2
;
; GFX11-LABEL: bitcast_v32i8_to_v8f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v14
; GFX11-NEXT:    v_dual_mov_b32 v18, v6 :: v_dual_mov_b32 v17, v4
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v15, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v20, 8, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v21, 8, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v14, 8, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v19, 8, v7
; GFX11-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX11-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX11-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_and_b32 s5, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB51_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s5, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s8
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_lshl_b32 s7, s17, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_and_b32 s6, s16, 0xff
; GFX11-NEXT:    s_and_b32 s8, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_or_b32 s7, s8, s9
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v16
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v17
; GFX11-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-NEXT:    s_and_b32 s8, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_or_b32 s7, s8, s9
; GFX11-NEXT:    s_and_b32 s8, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s23, 8
; GFX11-NEXT:    v_or_b32_e32 v1, v1, v21
; GFX11-NEXT:    v_and_b32_e32 v5, 0xff, v10
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v14
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_and_b32 s9, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s25, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v15
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff, v18
; GFX11-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-NEXT:    v_and_b32_e32 v6, 0xff, v12
; GFX11-NEXT:    v_or_b32_e32 v5, v5, v11
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_or_b32 s9, s9, s10
; GFX11-NEXT:    s_lshl_b32 s10, s27, 8
; GFX11-NEXT:    s_and_b32 s8, s9, 0xffff
; GFX11-NEXT:    s_and_b32 s9, s26, 0xff
; GFX11-NEXT:    v_or_b32_e32 v3, v3, v19
; GFX11-NEXT:    v_or_b32_e32 v4, v4, v9
; GFX11-NEXT:    v_or_b32_e32 v6, v6, v13
; GFX11-NEXT:    v_and_b32_e32 v22, 0xffff, v5
; GFX11-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-NEXT:    v_mov_b32_e32 v1, s6
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v20
; GFX11-NEXT:    s_or_b32 s9, s9, s10
; GFX11-NEXT:    s_and_b32 s10, s28, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_lshl_b32 s11, s29, 8
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    s_or_b32 s10, s10, s11
; GFX11-NEXT:    v_or_b32_e32 v6, v3, v7
; GFX11-NEXT:    s_and_b32 s10, s10, 0xffff
; GFX11-NEXT:    v_or_b32_e32 v7, v22, v23
; GFX11-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v3, s8
; GFX11-NEXT:    v_or_b32_e32 v4, s10, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, s5
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB51_3
; GFX11-NEXT:  .LBB51_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_and_b32 s1, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s19, 8
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_and_b32 s3, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s4, s21, 8
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    s_or_b32 s2, s4, s3
; GFX11-NEXT:    s_and_b32 s3, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s4, s23, 8
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v16
; GFX11-NEXT:    s_or_b32 s3, s4, s3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v17
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v18
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v10
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    v_or_b32_e32 v1, v21, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v12
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-NEXT:    v_or_b32_e32 v2, v14, v2
; GFX11-NEXT:    s_and_b32 s4, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s25, 8
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-NEXT:    s_addk_i32 s4, 0x300
; GFX11-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-NEXT:    v_or_b32_e32 v3, v19, v3
; GFX11-NEXT:    v_or_b32_e32 v4, v9, v4
; GFX11-NEXT:    v_or_b32_e32 v5, v11, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-NEXT:    s_and_b32 s3, s4, 0xffff
; GFX11-NEXT:    s_and_b32 s4, s26, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s27, 8
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v15
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_or_b32_e32 v6, v13, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x300, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x300, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 0x300, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_addk_i32 s4, 0x300
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x300, v6
; GFX11-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_and_b32_e32 v8, 0xffff, v5
; GFX11-NEXT:    s_or_b32 s3, s3, s4
; GFX11-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_and_b32 v0, 0xff, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX11-NEXT:    v_or_b32_e32 v6, v3, v7
; GFX11-NEXT:    v_mov_b32_e32 v3, s3
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    v_or_b32_e32 v0, v20, v0
; GFX11-NEXT:    s_and_b32 s5, s28, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s29, 8
; GFX11-NEXT:    v_or_b32_e32 v7, v8, v9
; GFX11-NEXT:    s_or_b32 s5, s6, s5
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-NEXT:    s_addk_i32 s5, 0x300
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_or_b32_e32 v4, s5, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:  .LBB51_3: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB51_4:
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-NEXT:    s_branch .LBB51_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i8> %a, splat (i8 3)
  %a2 = bitcast <32 x i8> %a1 to <8 x float>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i8> %a to <8 x float>
  br label %end

end:
  %phi = phi <8 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <8 x float> %phi
}

define <4 x double> @bitcast_v4i64_to_v4f64(<4 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v4i64_to_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i64_to_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i64_to_v4f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i64_to_v4f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB52_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:  .LBB52_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define inreg <4 x double> @bitcast_v4i64_to_v4f64_scalar(<4 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i64_to_v4f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB53_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB53_3
; SI-NEXT:  .LBB53_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s22, s22, 3
; SI-NEXT:    s_addc_u32 s23, s23, 0
; SI-NEXT:  .LBB53_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB53_4:
; SI-NEXT:    s_branch .LBB53_2
;
; VI-LABEL: bitcast_v4i64_to_v4f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB53_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB53_3
; VI-NEXT:  .LBB53_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:  .LBB53_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB53_4:
; VI-NEXT:    s_branch .LBB53_2
;
; GFX9-LABEL: bitcast_v4i64_to_v4f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB53_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB53_3
; GFX9-NEXT:  .LBB53_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:  .LBB53_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB53_4:
; GFX9-NEXT:    s_branch .LBB53_2
;
; GFX11-LABEL: bitcast_v4i64_to_v4f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB53_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB53_3
; GFX11-NEXT:  .LBB53_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:  .LBB53_3: ; %end
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB53_4:
; GFX11-NEXT:    s_branch .LBB53_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define <4 x i64> @bitcast_v4f64_to_v4i64(<4 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v4f64_to_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:  ; %bb.2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB54_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:  .LBB54_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v4i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB54_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:  .LBB54_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v4i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB54_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:  .LBB54_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define inreg <4 x i64> @bitcast_v4f64_to_v4i64_scalar(<4 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f64_to_v4i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB55_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB55_4
; SI-NEXT:  .LBB55_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB55_3:
; SI-NEXT:    s_branch .LBB55_2
; SI-NEXT:  .LBB55_4:
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v4i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB55_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB55_4
; VI-NEXT:  .LBB55_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB55_3:
; VI-NEXT:    s_branch .LBB55_2
; VI-NEXT:  .LBB55_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v4i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB55_4
; GFX9-NEXT:  .LBB55_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB55_3:
; GFX9-NEXT:    s_branch .LBB55_2
; GFX9-NEXT:  .LBB55_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v4i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB55_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB55_4
; GFX11-NEXT:  .LBB55_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], s[6:7], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB55_3:
; GFX11-NEXT:    s_branch .LBB55_2
; GFX11-NEXT:  .LBB55_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define <16 x i16> @bitcast_v4i64_to_v16i16(<4 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v4i64_to_v16i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v14, v7
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_mov_b32_e32 v10, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v6, v3
; SI-NEXT:    v_mov_b32_e32 v4, v2
; SI-NEXT:    v_mov_b32_e32 v2, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v16, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB56_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v10, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v14, vcc
; SI-NEXT:    v_alignbit_b32 v13, v14, v12, 16
; SI-NEXT:    v_alignbit_b32 v9, v10, v16, 16
; SI-NEXT:    v_alignbit_b32 v5, v6, v4, 16
; SI-NEXT:    v_alignbit_b32 v1, v2, v0, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v2
; SI-NEXT:  .LBB56_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v8, v16
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i64_to_v16i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i64_to_v16i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i64_to_v16i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB56_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB56_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define inreg <16 x i16> @bitcast_v4i64_to_v16i16_scalar(<4 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i64_to_v16i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB57_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v13, s23, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s23, 16
; SI-NEXT:    s_lshr_b32 s7, s21, 16
; SI-NEXT:    s_lshr_b32 s8, s19, 16
; SI-NEXT:    s_lshr_b32 s9, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB57_3
; SI-NEXT:  .LBB57_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s22, s22, 3
; SI-NEXT:    s_addc_u32 s23, s23, 0
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v13, s23, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s6, s23, 16
; SI-NEXT:    s_lshr_b32 s7, s21, 16
; SI-NEXT:    s_lshr_b32 s8, s19, 16
; SI-NEXT:    s_lshr_b32 s9, s17, 16
; SI-NEXT:  .LBB57_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v2, s17
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    v_mov_b32_e32 v4, s18
; SI-NEXT:    v_mov_b32_e32 v6, s19
; SI-NEXT:    v_mov_b32_e32 v7, s8
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v10, s21
; SI-NEXT:    v_mov_b32_e32 v11, s7
; SI-NEXT:    v_mov_b32_e32 v12, s22
; SI-NEXT:    v_mov_b32_e32 v14, s23
; SI-NEXT:    v_mov_b32_e32 v15, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB57_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB57_2
;
; VI-LABEL: bitcast_v4i64_to_v16i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB57_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB57_3
; VI-NEXT:  .LBB57_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB57_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB57_4:
; VI-NEXT:    s_branch .LBB57_2
;
; GFX9-LABEL: bitcast_v4i64_to_v16i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB57_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB57_3
; GFX9-NEXT:  .LBB57_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB57_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB57_4:
; GFX9-NEXT:    s_branch .LBB57_2
;
; GFX11-LABEL: bitcast_v4i64_to_v16i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB57_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB57_3
; GFX11-NEXT:  .LBB57_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB57_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB57_4:
; GFX11-NEXT:    s_branch .LBB57_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define <4 x i64> @bitcast_v16i16_to_v4i64(<16 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v16i16_to_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v4
; SI-NEXT:    v_mov_b32_e32 v18, v2
; SI-NEXT:    v_mov_b32_e32 v17, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v15
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB58_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB58_4
; SI-NEXT:  .LBB58_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB58_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v0, v0, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v24
; SI-NEXT:    v_or_b32_e32 v2, v2, v23
; SI-NEXT:    v_or_b32_e32 v3, v3, v22
; SI-NEXT:    v_or_b32_e32 v4, v4, v21
; SI-NEXT:    v_or_b32_e32 v5, v5, v16
; SI-NEXT:    v_or_b32_e32 v6, v6, v11
; SI-NEXT:    v_or_b32_e32 v7, v7, v9
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB58_2
; SI-NEXT:  .LBB58_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v0, v25, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v24, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v22, v3
; SI-NEXT:    v_or_b32_e32 v4, v21, v4
; SI-NEXT:    v_or_b32_e32 v5, v16, v5
; SI-NEXT:    v_or_b32_e32 v6, v11, v6
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x30000, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i16_to_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB58_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v9, 3
; VI-NEXT:    v_add_u16_e32 v8, 3, v7
; VI-NEXT:    v_add_u16_sdwa v7, v7, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_add_u16_e32 v8, 3, v6
; VI-NEXT:    v_add_u16_sdwa v6, v6, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v8, v6
; VI-NEXT:    v_add_u16_e32 v8, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v8, v5
; VI-NEXT:    v_add_u16_e32 v8, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v8, v4
; VI-NEXT:    v_add_u16_e32 v8, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v8, v3
; VI-NEXT:    v_add_u16_e32 v8, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v8, v2
; VI-NEXT:    v_add_u16_e32 v8, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_add_u16_e32 v8, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v8, v0
; VI-NEXT:  .LBB58_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i16_to_v4i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v4i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB58_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  .LBB58_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define inreg <4 x i64> @bitcast_v16i16_to_v4i64_scalar(<16 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i16_to_v4i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_mov_b32_e32 v8, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; SI-NEXT:    s_cbranch_scc0 .LBB59_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v7, v0, v9
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB59_3
; SI-NEXT:  .LBB59_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v8
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB59_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB59_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB59_2
;
; VI-LABEL: bitcast_v16i16_to_v4i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB59_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB59_3
; VI-NEXT:  .LBB59_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s23, 3
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s22, 3
; VI-NEXT:    s_add_i32 s23, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_add_i32 s22, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB59_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB59_4:
; VI-NEXT:    s_branch .LBB59_2
;
; GFX9-LABEL: bitcast_v16i16_to_v4i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB59_4
; GFX9-NEXT:  .LBB59_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, s23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB59_3:
; GFX9-NEXT:    s_branch .LBB59_2
; GFX9-NEXT:  .LBB59_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v4i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB59_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB59_4
; GFX11-NEXT:  .LBB59_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB59_3:
; GFX11-NEXT:    s_branch .LBB59_2
; GFX11-NEXT:  .LBB59_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define <16 x half> @bitcast_v4i64_to_v16f16(<4 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v4i64_to_v16f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v17, v7
; SI-NEXT:    v_mov_b32_e32 v16, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v21, v3
; SI-NEXT:    v_mov_b32_e32 v20, v2
; SI-NEXT:    v_mov_b32_e32 v23, v1
; SI-NEXT:    v_mov_b32_e32 v22, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB60_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB60_4
; SI-NEXT:  .LBB60_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB60_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v0
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v22
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB60_2
; SI-NEXT:  .LBB60_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v23, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v8, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v17, vcc
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v22
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i64_to_v16f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i64_to_v16f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i64_to_v16f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB60_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB60_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define inreg <16 x half> @bitcast_v4i64_to_v16f16_scalar(<4 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i64_to_v16f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB61_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB61_3
; SI-NEXT:  .LBB61_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s4, s16, 3
; SI-NEXT:    s_addc_u32 s5, s17, 0
; SI-NEXT:    s_lshr_b32 s6, s4, 16
; SI-NEXT:    s_lshr_b32 s7, s5, 16
; SI-NEXT:    s_add_u32 s8, s18, 3
; SI-NEXT:    s_addc_u32 s9, s19, 0
; SI-NEXT:    s_lshr_b32 s10, s8, 16
; SI-NEXT:    s_lshr_b32 s11, s9, 16
; SI-NEXT:    s_add_u32 s12, s20, 3
; SI-NEXT:    s_addc_u32 s13, s21, 0
; SI-NEXT:    s_lshr_b32 s14, s12, 16
; SI-NEXT:    s_lshr_b32 s15, s13, 16
; SI-NEXT:    s_add_u32 s16, s22, 3
; SI-NEXT:    s_addc_u32 s17, s23, 0
; SI-NEXT:    s_lshr_b32 s18, s16, 16
; SI-NEXT:    s_lshr_b32 s19, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s12
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s6
; SI-NEXT:  .LBB61_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB61_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_branch .LBB61_2
;
; VI-LABEL: bitcast_v4i64_to_v16f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB61_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB61_3
; VI-NEXT:  .LBB61_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB61_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB61_4:
; VI-NEXT:    s_branch .LBB61_2
;
; GFX9-LABEL: bitcast_v4i64_to_v16f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB61_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB61_3
; GFX9-NEXT:  .LBB61_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB61_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB61_4:
; GFX9-NEXT:    s_branch .LBB61_2
;
; GFX11-LABEL: bitcast_v4i64_to_v16f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB61_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB61_3
; GFX11-NEXT:  .LBB61_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB61_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB61_4:
; GFX11-NEXT:    s_branch .LBB61_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define <4 x i64> @bitcast_v16f16_to_v4i64(<16 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v16f16_to_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v14
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB62_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB62_4
; SI-NEXT:  .LBB62_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB62_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v26
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v24
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v22
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v21, v3
; SI-NEXT:    v_or_b32_e32 v4, v19, v4
; SI-NEXT:    v_or_b32_e32 v5, v17, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB62_2
; SI-NEXT:  .LBB62_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v25
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v20
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v21
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v18
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f16_to_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB62_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v8, 0x200
; VI-NEXT:    v_add_f16_sdwa v9, v7, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v9
; VI-NEXT:    v_add_f16_sdwa v9, v6, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v9
; VI-NEXT:    v_add_f16_sdwa v9, v5, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v9
; VI-NEXT:    v_add_f16_sdwa v9, v4, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v9
; VI-NEXT:    v_add_f16_sdwa v9, v3, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v9
; VI-NEXT:    v_add_f16_sdwa v9, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v9
; VI-NEXT:    v_add_f16_sdwa v9, v1, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v8, v0, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v9
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:  .LBB62_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v4i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v4i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB62_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  .LBB62_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define inreg <4 x i64> @bitcast_v16f16_to_v4i64_scalar(<16 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f16_to_v4i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v23, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v22, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v21, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v20, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v19, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v18, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s28
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB63_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v22, v0
; SI-NEXT:    v_or_b32_e32 v1, v20, v1
; SI-NEXT:    v_or_b32_e32 v2, v18, v2
; SI-NEXT:    v_or_b32_e32 v3, v16, v3
; SI-NEXT:    v_or_b32_e32 v4, v14, v4
; SI-NEXT:    v_or_b32_e32 v5, v12, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_cbranch_execnz .LBB63_3
; SI-NEXT:  .LBB63_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v20
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v18
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v19
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v15
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v14
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v12
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:  .LBB63_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB63_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB63_2
;
; VI-LABEL: bitcast_v16f16_to_v4i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB63_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB63_4
; VI-NEXT:  .LBB63_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s23, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s23, v0
; VI-NEXT:    s_lshr_b32 s4, s22, 16
; VI-NEXT:    v_or_b32_e32 v7, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s22, v0
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_or_b32_e32 v6, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_add_f16_sdwa v8, v8, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB63_3:
; VI-NEXT:    s_branch .LBB63_2
; VI-NEXT:  .LBB63_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v4i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB63_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB63_4
; GFX9-NEXT:  .LBB63_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, s23, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, s22, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB63_3:
; GFX9-NEXT:    s_branch .LBB63_2
; GFX9-NEXT:  .LBB63_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v4i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB63_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB63_4
; GFX11-NEXT:  .LBB63_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, s7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, s6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB63_3:
; GFX11-NEXT:    s_branch .LBB63_2
; GFX11-NEXT:  .LBB63_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define <16 x bfloat> @bitcast_v4i64_to_v16bf16(<4 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v4i64_to_v16bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v23, v7
; SI-NEXT:    v_mov_b32_e32 v22, v6
; SI-NEXT:    v_mov_b32_e32 v21, v5
; SI-NEXT:    v_mov_b32_e32 v20, v4
; SI-NEXT:    v_mov_b32_e32 v19, v3
; SI-NEXT:    v_mov_b32_e32 v18, v2
; SI-NEXT:    v_mov_b32_e32 v17, v1
; SI-NEXT:    v_mov_b32_e32 v16, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB64_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB64_4
; SI-NEXT:  .LBB64_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB64_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v23
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v23
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v22
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v22
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v21
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v21
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v20
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v20
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v19
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v19
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v18
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v18
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v17
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v16
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v16
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB64_2
; SI-NEXT:  .LBB64_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v20
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v21, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v22
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v23, vcc
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i64_to_v16bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  ; %bb.2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i64_to_v16bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4i64_to_v16bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB64_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB64_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define inreg <16 x bfloat> @bitcast_v4i64_to_v16bf16_scalar(<4 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i64_to_v16bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB65_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s6, s23, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s23, 16
; SI-NEXT:    s_and_b32 s8, s22, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s22, 16
; SI-NEXT:    s_and_b32 s10, s21, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s21, 16
; SI-NEXT:    s_and_b32 s12, s20, 0xffff0000
; SI-NEXT:    s_lshl_b32 s13, s20, 16
; SI-NEXT:    s_and_b32 s14, s19, 0xffff0000
; SI-NEXT:    s_lshl_b32 s15, s19, 16
; SI-NEXT:    s_and_b32 s24, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s25, s18, 16
; SI-NEXT:    s_and_b32 s26, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s27, s17, 16
; SI-NEXT:    s_and_b32 s28, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s29, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB65_3
; SI-NEXT:  .LBB65_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s4, s16, 3
; SI-NEXT:    s_addc_u32 s5, s17, 0
; SI-NEXT:    s_add_u32 s16, s18, 3
; SI-NEXT:    s_addc_u32 s15, s19, 0
; SI-NEXT:    s_add_u32 s13, s20, 3
; SI-NEXT:    s_addc_u32 s11, s21, 0
; SI-NEXT:    s_add_u32 s9, s22, 3
; SI-NEXT:    s_addc_u32 s7, s23, 0
; SI-NEXT:    s_and_b32 s6, s7, 0xffff0000
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s8, s9, 0xffff0000
; SI-NEXT:    s_lshl_b32 s9, s9, 16
; SI-NEXT:    s_and_b32 s10, s11, 0xffff0000
; SI-NEXT:    s_lshl_b32 s11, s11, 16
; SI-NEXT:    s_and_b32 s12, s13, 0xffff0000
; SI-NEXT:    s_lshl_b32 s13, s13, 16
; SI-NEXT:    s_and_b32 s14, s15, 0xffff0000
; SI-NEXT:    s_lshl_b32 s15, s15, 16
; SI-NEXT:    s_and_b32 s24, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s25, s16, 16
; SI-NEXT:    s_and_b32 s26, s5, 0xffff0000
; SI-NEXT:    s_lshl_b32 s27, s5, 16
; SI-NEXT:    s_and_b32 s28, s4, 0xffff0000
; SI-NEXT:    s_lshl_b32 s29, s4, 16
; SI-NEXT:  .LBB65_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s29
; SI-NEXT:    v_mov_b32_e32 v1, s28
; SI-NEXT:    v_mov_b32_e32 v2, s27
; SI-NEXT:    v_mov_b32_e32 v3, s26
; SI-NEXT:    v_mov_b32_e32 v4, s25
; SI-NEXT:    v_mov_b32_e32 v5, s24
; SI-NEXT:    v_mov_b32_e32 v6, s15
; SI-NEXT:    v_mov_b32_e32 v7, s14
; SI-NEXT:    v_mov_b32_e32 v8, s13
; SI-NEXT:    v_mov_b32_e32 v9, s12
; SI-NEXT:    v_mov_b32_e32 v10, s11
; SI-NEXT:    v_mov_b32_e32 v11, s10
; SI-NEXT:    v_mov_b32_e32 v12, s9
; SI-NEXT:    v_mov_b32_e32 v13, s8
; SI-NEXT:    v_mov_b32_e32 v14, s7
; SI-NEXT:    v_mov_b32_e32 v15, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB65_4:
; SI-NEXT:    ; implicit-def: $sgpr29
; SI-NEXT:    ; implicit-def: $sgpr28
; SI-NEXT:    ; implicit-def: $sgpr27
; SI-NEXT:    ; implicit-def: $sgpr26
; SI-NEXT:    ; implicit-def: $sgpr25
; SI-NEXT:    ; implicit-def: $sgpr24
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB65_2
;
; VI-LABEL: bitcast_v4i64_to_v16bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB65_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB65_3
; VI-NEXT:  .LBB65_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:  .LBB65_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB65_4:
; VI-NEXT:    s_branch .LBB65_2
;
; GFX9-LABEL: bitcast_v4i64_to_v16bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB65_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB65_3
; GFX9-NEXT:  .LBB65_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:  .LBB65_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB65_4:
; GFX9-NEXT:    s_branch .LBB65_2
;
; GFX11-LABEL: bitcast_v4i64_to_v16bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB65_4
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB65_3
; GFX11-NEXT:  .LBB65_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:  .LBB65_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB65_4:
; GFX11-NEXT:    s_branch .LBB65_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define <4 x i64> @bitcast_v16bf16_to_v4i64(<16 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v16bf16_to_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_mul_f32_e32 v26, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v27, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v24, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v25, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v10, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v11, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v14
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB66_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB66_4
; SI-NEXT:  .LBB66_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB66_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v27, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v25, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v23, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v21, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v19, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v17, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v11, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v9, 16
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB66_2
; SI-NEXT:  .LBB66_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v26
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v24
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v27
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v25
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v22
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v10
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16bf16_to_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB66_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v7, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v7
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v7
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; VI-NEXT:    v_cndmask_b32_e32 v7, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; VI-NEXT:    v_alignbit_b32 v7, v7, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v6, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; VI-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_alignbit_b32 v6, v6, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; VI-NEXT:    v_alignbit_b32 v5, v5, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v4
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; VI-NEXT:    v_alignbit_b32 v4, v4, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v3
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_alignbit_b32 v3, v3, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v2
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    v_alignbit_b32 v2, v2, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v1
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; VI-NEXT:    v_alignbit_b32 v1, v1, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v0
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; VI-NEXT:  .LBB66_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16bf16_to_v4i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB66_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    s_movk_i32 s6, 0x7fff
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v7, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v7, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v7
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v9, v10, vcc
; GFX9-NEXT:    s_mov_b32 s7, 0x7060302
; GFX9-NEXT:    v_perm_b32 v7, v7, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v6, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v6, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v6, v6, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v5, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v5, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v5, v5, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v4, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v4, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v4, v4, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v3, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v3, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v3, v3, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v2, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v2, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v2, v2, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v1, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v1, v1, v8, s7
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX9-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX9-NEXT:    v_bfe_u32 v9, v8, 16, 1
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX9-NEXT:    v_add3_u32 v9, v9, v8, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX9-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; GFX9-NEXT:    v_bfe_u32 v9, v0, 16, 1
; GFX9-NEXT:    v_add3_u32 v9, v9, v0, s6
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; GFX9-NEXT:    v_perm_b32 v0, v0, v8, s7
; GFX9-NEXT:  .LBB66_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v16bf16_to_v4i64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB66_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_lshlrev_b32 v8, 16, v7
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v9, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v8, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v8
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v11, v8, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v8, v11, v14 :: v_dual_and_b32 v7, 0xffff0000, v7
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 0x40c00000, v7 :: v_dual_lshlrev_b32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v15, v9, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v8.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v7, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v7
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v12, v7, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v6, 0x40c00000, v6 :: v_dual_cndmask_b32 v7, v12, v13
; GFX11-TRUE16-NEXT:    v_bfe_u32 v16, v6, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v6
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-TRUE16-NEXT:    v_bfi_b32 v7, 0xffff, v8, v7
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v16, v6, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v6, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v6.h
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v9, v11, v12 :: v_dual_add_f32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v6, 0xffff, v6, v9
; GFX11-TRUE16-NEXT:    v_bfe_u32 v13, v10, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v14, v5, 16, 1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v13, v10, 0x7fff
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v14, v5, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v5, v12, v13, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v10, v11, v14 :: v_dual_add_f32 v11, 0x40c00000, v15
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v5.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v8, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v4, 16, 1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v5, 0xffff, v5, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v4, 0x7fff
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_add3_u32 v8, v8, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v4, v9, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v12, v3, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v4.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v8, v8, v13, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_add3_u32 v12, v12, v3, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v13, 0x400000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v11, 16, 1
; GFX11-TRUE16-NEXT:    v_bfi_b32 v4, 0xffff, v4, v8
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v3, v12, v13 :: v_dual_add_f32 v10, 0x40c00000, v10
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v11
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v3.h
; GFX11-TRUE16-NEXT:    v_bfe_u32 v9, v10, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v14, 0x400000, v10
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_add3_u32 v9, v9, v10, 0x7fff
; GFX11-TRUE16-NEXT:    v_add3_u32 v10, v15, v11, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v9, v9, v14 :: v_dual_and_b32 v14, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v3, 0xffff, v3, v9
; GFX11-TRUE16-NEXT:    v_dual_cndmask_b32 v10, v10, v12 :: v_dual_add_f32 v1, 0x40c00000, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfe_u32 v13, v2, 16, 1
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v12, 0x400000, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v13, v2, 0x7fff
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v13, 0x40c00000, v14 :: v_dual_lshlrev_b32 v14, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v2, v11, v12, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v14
; GFX11-TRUE16-NEXT:    v_bfe_u32 v14, v1, 16, 1
; GFX11-TRUE16-NEXT:    v_bfe_u32 v11, v13, 16, 1
; GFX11-TRUE16-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v16, 0x400000, v13
; GFX11-TRUE16-NEXT:    v_bfe_u32 v15, v12, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v14, v1, 0x7fff
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v19, 0x400000, v12
; GFX11-TRUE16-NEXT:    v_add3_u32 v11, v11, v13, 0x7fff
; GFX11-TRUE16-NEXT:    v_bfe_u32 v18, v0, 16, 1
; GFX11-TRUE16-NEXT:    v_add3_u32 v15, v15, v12, 0x7fff
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v1, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v17, 0x400000, v0
; GFX11-TRUE16-NEXT:    v_add3_u32 v14, v18, v0, 0x7fff
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v2.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v1.l, v1.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v12, v15, v19, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v2, 0xffff, v2, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v12.h
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v11, v11, v16, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_bfi_b32 v1, 0xffff, v1, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b32_e32 v0, v14, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_bfi_b32 v0, 0xffff, v12, v0
; GFX11-TRUE16-NEXT:  .LBB66_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v16bf16_to_v4i64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-FAKE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB66_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v9 :: v_dual_add_f32 v8, 0x40c00000, v8
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v8, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v15, v6, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v13, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_add3_u32 v10, v10, v8, 0x7fff
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v10, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v15, v6, 0x7fff
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, 0x400000, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; GFX11-FAKE16-NEXT:    v_bfe_u32 v12, v7, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add3_u32 v12, v12, v7, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v12, v14 :: v_dual_lshlrev_b32 v12, 16, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v7, v8, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v6
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v13, v10 :: v_dual_add_f32 v10, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v8, v5, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v5
; GFX11-FAKE16-NEXT:    v_bfe_u32 v12, v10, 16, 1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v11, v14 :: v_dual_lshlrev_b32 v11, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v8, v5, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v6, v9, 0x7060302
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v11 :: v_dual_add_f32 v4, 0x40c00000, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v12, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v8, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v8, v14, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 0x40c00000, v12 :: v_dual_lshlrev_b32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v5, v10, 0x7060302
; GFX11-FAKE16-NEXT:    v_bfe_u32 v10, v4, 16, 1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v9, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_add3_u32 v10, v10, v4, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v10, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v10, 0x40c00000, v12
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v13, v9, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v3, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v10, 16, 1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v11, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v11, v13, v3, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, 0x400000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v14, v10, 0x7fff
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v11, v12 :: v_dual_add_f32 v2, 0x40c00000, v2
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v4, v8, 0x7060302
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v11, 0x40c00000, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, 0x400000, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v2, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_bfe_u32 v14, v11, 16, 1
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v3, v9, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_add3_u32 v12, v16, v2, 0x7fff
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v13, v15 :: v_dual_lshlrev_b32 v15, 16, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v13, 0x400000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v12, v13, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_add_f32_e32 v12, 0x40c00000, v15
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v14, v11, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v14, 0x400000, v11
; GFX11-FAKE16-NEXT:    v_bfe_u32 v15, v1, 16, 1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_bfe_u32 v16, v12, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v17, 0x400000, v12
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v2, v10, 0x7060302
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v13, v14, vcc_lo
; GFX11-FAKE16-NEXT:    v_add3_u32 v14, v15, v1, 0x7fff
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v15, 0x400000, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v16, v16, v12, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v14, v15 :: v_dual_add_f32 v0, 0x40c00000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v1, v11, 0x7060302
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_bfe_u32 v13, v0, 16, 1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v18, 0x400000, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v16, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-FAKE16-NEXT:    v_add3_u32 v13, v13, v0, 0x7fff
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v13, v18, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v0, v12, 0x7060302
; GFX11-FAKE16-NEXT:  .LBB66_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <16 x bfloat> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x bfloat> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define inreg <4 x i64> @bitcast_v16bf16_to_v4i64_scalar(<16 x bfloat> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16bf16_to_v4i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mul_f32_e64 v22, 1.0, s17
; SI-NEXT:    v_mul_f32_e64 v23, 1.0, s16
; SI-NEXT:    v_mul_f32_e64 v20, 1.0, s19
; SI-NEXT:    v_mul_f32_e64 v21, 1.0, s18
; SI-NEXT:    v_mul_f32_e64 v18, 1.0, s21
; SI-NEXT:    v_mul_f32_e64 v19, 1.0, s20
; SI-NEXT:    v_mul_f32_e64 v16, 1.0, s23
; SI-NEXT:    v_mul_f32_e64 v17, 1.0, s22
; SI-NEXT:    v_mul_f32_e64 v14, 1.0, s25
; SI-NEXT:    v_mul_f32_e64 v15, 1.0, s24
; SI-NEXT:    v_mul_f32_e64 v12, 1.0, s27
; SI-NEXT:    v_mul_f32_e64 v13, 1.0, s26
; SI-NEXT:    v_mul_f32_e64 v10, 1.0, s29
; SI-NEXT:    v_mul_f32_e64 v11, 1.0, s28
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v0
; SI-NEXT:    s_cbranch_scc0 .LBB67_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v23, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v21, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v19, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v17, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v15, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v13, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v11, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v9, 16
; SI-NEXT:    s_cbranch_execnz .LBB67_3
; SI-NEXT:  .LBB67_2: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v1, v2, v1, 16
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v14
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v15
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v12
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v13
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v10
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:  .LBB67_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB67_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB67_2
;
; VI-LABEL: bitcast_v16bf16_to_v4i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB67_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB67_4
; VI-NEXT:  .LBB67_2: ; %cmp.true
; VI-NEXT:    s_lshl_b32 s4, s23, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s22, 16
; VI-NEXT:    v_alignbit_b32 v7, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s21, 16
; VI-NEXT:    v_alignbit_b32 v6, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s20, 16
; VI-NEXT:    v_alignbit_b32 v5, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s19, 16
; VI-NEXT:    v_alignbit_b32 v4, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v3, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v3, vcc, v3, v2
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x7fff, v3
; VI-NEXT:    v_or_b32_e32 v8, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v3, v8, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s18, 16
; VI-NEXT:    v_alignbit_b32 v3, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v2, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v2, vcc, v2, v1
; VI-NEXT:    v_add_u32_e32 v2, vcc, 0x7fff, v2
; VI-NEXT:    v_or_b32_e32 v8, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v2, v8, vcc
; VI-NEXT:    v_add_f32_e32 v2, s4, v0
; VI-NEXT:    v_bfe_u32 v8, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v2
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; VI-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v8, v9, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; VI-NEXT:    s_lshl_b32 s4, s17, 16
; VI-NEXT:    v_alignbit_b32 v2, v2, v1, 16
; VI-NEXT:    v_add_f32_e32 v1, s4, v0
; VI-NEXT:    v_bfe_u32 v8, v1, 16, 1
; VI-NEXT:    v_add_u32_e32 v8, vcc, v8, v1
; VI-NEXT:    v_add_u32_e32 v8, vcc, 0x7fff, v8
; VI-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    v_cndmask_b32_e32 v1, v8, v9, vcc
; VI-NEXT:    v_add_f32_e32 v8, s4, v0
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; VI-NEXT:    s_lshl_b32 s4, s16, 16
; VI-NEXT:    v_alignbit_b32 v1, v8, v1, 16
; VI-NEXT:    v_add_f32_e32 v8, s4, v0
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v0, s4, v0
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v0, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v0
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v0
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; VI-NEXT:    v_alignbit_b32 v0, v0, v8, 16
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB67_3:
; VI-NEXT:    s_branch .LBB67_2
; VI-NEXT:  .LBB67_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16bf16_to_v4i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB67_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB67_4
; GFX9-NEXT:  .LBB67_2: ; %cmp.true
; GFX9-NEXT:    s_and_b32 s4, s23, 0xffff0000
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x40c00000
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s23, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_mov_b32_e32 v8, 0xffff
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s22, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v7, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s22, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s21, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v6, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s21, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s20, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v5, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s20, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v4, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v4, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s19, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v4, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v3, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s19, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v3, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v3, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v3, v3, v2
; GFX9-NEXT:    v_add_u32_e32 v3, 0x7fff, v3
; GFX9-NEXT:    v_or_b32_e32 v9, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v3, v9, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s18, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v3, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v2, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v2, v2, v1
; GFX9-NEXT:    v_add_u32_e32 v2, 0x7fff, v2
; GFX9-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s18, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v2, v9, vcc
; GFX9-NEXT:    v_add_f32_e32 v2, s4, v0
; GFX9-NEXT:    v_bfe_u32 v9, v2, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v9, v9, v2
; GFX9-NEXT:    v_add_u32_e32 v9, 0x7fff, v9
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v2
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v9, v10, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v2, v8, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s17, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v2, v1, 16, v2
; GFX9-NEXT:    v_add_f32_e32 v1, s4, v0
; GFX9-NEXT:    v_bfe_u32 v9, v1, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v9, v9, v1
; GFX9-NEXT:    v_add_u32_e32 v9, 0x7fff, v9
; GFX9-NEXT:    v_or_b32_e32 v10, 0x400000, v1
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v1, v1
; GFX9-NEXT:    s_lshl_b32 s4, s17, 16
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v9, v10, vcc
; GFX9-NEXT:    v_add_f32_e32 v9, s4, v0
; GFX9-NEXT:    v_bfe_u32 v10, v9, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v9
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v10, v11, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX9-NEXT:    v_and_b32_sdwa v9, v8, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_and_b32 s4, s16, 0xffff0000
; GFX9-NEXT:    v_lshl_or_b32 v1, v1, 16, v9
; GFX9-NEXT:    v_add_f32_e32 v9, s4, v0
; GFX9-NEXT:    v_bfe_u32 v10, v9, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v9
; GFX9-NEXT:    s_lshl_b32 s4, s16, 16
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v9
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX9-NEXT:    v_add_f32_e32 v0, s4, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v10, v11, vcc
; GFX9-NEXT:    v_bfe_u32 v10, v0, 16, 1
; GFX9-NEXT:    v_add_u32_e32 v10, v10, v0
; GFX9-NEXT:    v_add_u32_e32 v10, 0x7fff, v10
; GFX9-NEXT:    v_or_b32_e32 v11, 0x400000, v0
; GFX9-NEXT:    v_cmp_u_f32_e32 vcc, v0, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v10, v11, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX9-NEXT:    v_and_b32_sdwa v0, v8, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_lshl_or_b32 v0, v9, 16, v0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB67_3:
; GFX9-NEXT:    s_branch .LBB67_2
; GFX9-NEXT:  .LBB67_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16bf16_to_v4i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB67_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB67_4
; GFX11-NEXT:  .LBB67_2: ; %cmp.true
; GFX11-NEXT:    s_lshl_b32 s8, s7, 16
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff0000
; GFX11-NEXT:    v_add_f32_e64 v0, 0x40c00000, s8
; GFX11-NEXT:    v_add_f32_e64 v1, 0x40c00000, s7
; GFX11-NEXT:    s_and_b32 s8, s6, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    v_add_f32_e64 v3, 0x40c00000, s8
; GFX11-NEXT:    v_bfe_u32 v2, v0, 16, 1
; GFX11-NEXT:    v_bfe_u32 v4, v1, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v1
; GFX11-NEXT:    s_and_b32 s7, s5, 0xffff0000
; GFX11-NEXT:    v_add_f32_e64 v5, 0x40c00000, s6
; GFX11-NEXT:    v_add_f32_e64 v6, 0x40c00000, s7
; GFX11-NEXT:    v_add_nc_u32_e32 v4, v4, v1
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v0
; GFX11-NEXT:    v_bfe_u32 v10, v3, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v0, v0
; GFX11-NEXT:    s_lshl_b32 s5, s5, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v0
; GFX11-NEXT:    v_add_f32_e64 v7, 0x40c00000, s5
; GFX11-NEXT:    v_bfe_u32 v11, v6, 16, 1
; GFX11-NEXT:    s_and_b32 s5, s4, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v2, v8, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v2, v5, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v8, v10, v3
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v4, v9 :: v_dual_add_nc_u32 v8, 0x7fff, v8
; GFX11-NEXT:    v_or_b32_e32 v4, 0x400000, v3
; GFX11-NEXT:    v_bfe_u32 v9, v7, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v3, v8, v4 :: v_dual_add_nc_u32 v4, v9, v7
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v5, v11, v6
; GFX11-NEXT:    v_or_b32_e32 v8, 0x400000, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x7fff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_dual_cndmask_b32 v2, v2, v10 :: v_dual_add_nc_u32 v5, 0x7fff, v5
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-NEXT:    v_or_b32_e32 v9, 0x400000, v6
; GFX11-NEXT:    v_add_f32_e64 v10, 0x40c00000, s4
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v4, v8, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s5
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-NEXT:    v_lshl_or_b32 v7, v1, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e32 v5, v5, v9, vcc_lo
; GFX11-NEXT:    v_bfe_u32 v9, v10, 16, 1
; GFX11-NEXT:    v_bfe_u32 v6, v8, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-NEXT:    s_and_b32 s4, s3, 0xffff0000
; GFX11-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v0, v9, v10
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_f32_e64 v9, 0x40c00000, s3
; GFX11-NEXT:    s_and_b32 s3, s2, 0xffff0000
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x7fff, v0
; GFX11-NEXT:    v_add_nc_u32_e32 v11, v6, v8
; GFX11-NEXT:    v_lshl_or_b32 v6, v3, 16, v2
; GFX11-NEXT:    v_or_b32_e32 v3, 0x400000, v10
; GFX11-NEXT:    v_or_b32_e32 v2, 0x400000, v8
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    v_or_b32_e32 v12, 0x400000, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc_lo
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x7fff, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_add_f32_e64 v8, 0x40c00000, s3
; GFX11-NEXT:    v_bfe_u32 v3, v9, 16, 1
; GFX11-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_dual_cndmask_b32 v1, v1, v2 :: v_dual_and_b32 v4, 0xffff, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v10, v8, 16, 1
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshl_or_b32 v5, v5, 16, v4
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s4
; GFX11-NEXT:    v_add_nc_u32_e32 v10, v10, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_bfe_u32 v2, v4, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v2, v2, v4
; GFX11-NEXT:    v_add_f32_e64 v4, 0x40c00000, s2
; GFX11-NEXT:    s_and_b32 s2, s1, 0xffff0000
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x7fff, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v3, v3, v9
; GFX11-NEXT:    v_add_f32_e64 v13, 0x40c00000, s1
; GFX11-NEXT:    s_lshl_b32 s1, s0, 16
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff0000
; GFX11-NEXT:    v_cndmask_b32_e32 v2, v2, v11, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x7fff, v10
; GFX11-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x7fff, v3
; GFX11-NEXT:    v_bfe_u32 v11, v4, 16, 1
; GFX11-NEXT:    v_add_f32_e64 v14, 0x40c00000, s0
; GFX11-NEXT:    v_or_b32_e32 v18, 0x400000, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e32 v3, v3, v12, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-NEXT:    v_bfe_u32 v16, v14, 16, 1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    v_dual_cndmask_b32 v8, v9, v10 :: v_dual_add_nc_u32 v9, v11, v4
; GFX11-NEXT:    v_or_b32_e32 v11, 0x400000, v4
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-NEXT:    v_add_f32_e64 v10, 0x40c00000, s2
; GFX11-NEXT:    v_add_nc_u32_e32 v16, v16, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 0x7fff, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_bfe_u32 v12, v10, 16, 1
; GFX11-NEXT:    v_or_b32_e32 v17, 0x400000, v10
; GFX11-NEXT:    v_cndmask_b32_e32 v4, v9, v11, vcc_lo
; GFX11-NEXT:    v_add_f32_e64 v9, 0x40c00000, s1
; GFX11-NEXT:    v_bfe_u32 v11, v13, 16, 1
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, v12, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_bfe_u32 v15, v9, 16, 1
; GFX11-NEXT:    v_add_nc_u32_e32 v11, v11, v13
; GFX11-NEXT:    v_or_b32_e32 v19, 0x400000, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 0x7fff, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 0x7fff, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, v15, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 0x7fff, v11
; GFX11-NEXT:    v_or_b32_e32 v16, 0x400000, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 0x7fff, v15
; GFX11-NEXT:    v_cndmask_b32_e32 v11, v11, v18, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_lshrrev_b32_e32 v11, 16, v11
; GFX11-NEXT:    v_cndmask_b32_e32 v9, v15, v19, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v9, 16, v9
; GFX11-NEXT:    v_cndmask_b32_e32 v10, v12, v17, vcc_lo
; GFX11-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v10
; GFX11-NEXT:    v_cndmask_b32_e32 v12, v13, v16, vcc_lo
; GFX11-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-NEXT:    v_lshl_or_b32 v4, v1, 16, v0
; GFX11-NEXT:    v_lshl_or_b32 v3, v2, 16, v3
; GFX11-NEXT:    v_lshl_or_b32 v1, v10, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v12, 16, v12
; GFX11-NEXT:    v_lshl_or_b32 v2, v8, 16, v13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshl_or_b32 v0, v12, 16, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB67_3:
; GFX11-NEXT:    s_branch .LBB67_2
; GFX11-NEXT:  .LBB67_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x bfloat> %a, splat (bfloat 0xR40C0)
  %a2 = bitcast <16 x bfloat> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <16 x bfloat> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define <32 x i8> @bitcast_v4i64_to_v32i8(<4 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v4i64_to_v32i8:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v28, v7
; SI-NEXT:    v_mov_b32_e32 v24, v6
; SI-NEXT:    v_mov_b32_e32 v20, v5
; SI-NEXT:    v_mov_b32_e32 v16, v4
; SI-NEXT:    v_mov_b32_e32 v12, v3
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v4, v1
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB68_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v27, v28, v24, 24
; SI-NEXT:    v_alignbit_b32 v26, v28, v24, 16
; SI-NEXT:    v_alignbit_b32 v25, v28, v24, 8
; SI-NEXT:    v_alignbit_b32 v19, v20, v16, 24
; SI-NEXT:    v_alignbit_b32 v18, v20, v16, 16
; SI-NEXT:    v_alignbit_b32 v17, v20, v16, 8
; SI-NEXT:    v_alignbit_b32 v11, v12, v32, 24
; SI-NEXT:    v_alignbit_b32 v10, v12, v32, 16
; SI-NEXT:    v_alignbit_b32 v9, v12, v32, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v31, 24, v28
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v29, 8, v28
; SI-NEXT:    v_lshrrev_b32_e32 v23, 24, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v21, 8, v20
; SI-NEXT:    v_lshrrev_b32_e32 v15, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:  .LBB68_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB68_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; SI-NEXT:    v_add_i32_e32 v32, vcc, 3, v32
; SI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v12, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v20, vcc
; SI-NEXT:    v_add_i32_e32 v24, vcc, 3, v24
; SI-NEXT:    v_addc_u32_e32 v28, vcc, 0, v28, vcc
; SI-NEXT:    v_alignbit_b32 v27, v28, v24, 24
; SI-NEXT:    v_alignbit_b32 v26, v28, v24, 16
; SI-NEXT:    v_alignbit_b32 v25, v28, v24, 8
; SI-NEXT:    v_alignbit_b32 v19, v20, v16, 24
; SI-NEXT:    v_alignbit_b32 v18, v20, v16, 16
; SI-NEXT:    v_alignbit_b32 v17, v20, v16, 8
; SI-NEXT:    v_alignbit_b32 v11, v12, v32, 24
; SI-NEXT:    v_alignbit_b32 v10, v12, v32, 16
; SI-NEXT:    v_alignbit_b32 v9, v12, v32, 8
; SI-NEXT:    v_alignbit_b32 v3, v4, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, v4, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v4, v0, 8
; SI-NEXT:    v_lshrrev_b32_e32 v31, 24, v28
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v28
; SI-NEXT:    v_lshrrev_b32_e32 v29, 8, v28
; SI-NEXT:    v_lshrrev_b32_e32 v23, 24, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v21, 8, v20
; SI-NEXT:    v_lshrrev_b32_e32 v15, 24, v12
; SI-NEXT:    v_lshrrev_b32_e32 v14, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v13, 8, v12
; SI-NEXT:    v_lshrrev_b32_e32 v7, 24, v4
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 8, v4
; SI-NEXT:  .LBB68_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v8, v32
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4i64_to_v32i8:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v33, v5
; VI-NEXT:    v_mov_b32_e32 v32, v4
; VI-NEXT:    v_mov_b32_e32 v35, v3
; VI-NEXT:    v_mov_b32_e32 v34, v2
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr2
; VI-NEXT:    ; implicit-def: $vgpr5
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr3
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB68_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; VI-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; VI-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; VI-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; VI-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; VI-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:  .LBB68_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB68_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v34, vcc, 3, v34
; VI-NEXT:    v_addc_u32_e32 v35, vcc, 0, v35, vcc
; VI-NEXT:    v_add_u32_e32 v32, vcc, 3, v32
; VI-NEXT:    v_addc_u32_e32 v33, vcc, 0, v33, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; VI-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; VI-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; VI-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; VI-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; VI-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; VI-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; VI-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; VI-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; VI-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; VI-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; VI-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; VI-NEXT:  .LBB68_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_mov_b32_e32 v4, v1
; VI-NEXT:    v_mov_b32_e32 v8, v34
; VI-NEXT:    v_mov_b32_e32 v12, v35
; VI-NEXT:    v_mov_b32_e32 v16, v32
; VI-NEXT:    v_mov_b32_e32 v20, v33
; VI-NEXT:    v_mov_b32_e32 v24, v6
; VI-NEXT:    v_mov_b32_e32 v28, v7
; VI-NEXT:    v_mov_b32_e32 v1, v38
; VI-NEXT:    v_mov_b32_e32 v6, v37
; VI-NEXT:    v_mov_b32_e32 v7, v36
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4i64_to_v32i8:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v33, v5
; GFX9-NEXT:    v_mov_b32_e32 v32, v4
; GFX9-NEXT:    v_mov_b32_e32 v35, v3
; GFX9-NEXT:    v_mov_b32_e32 v34, v2
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr2
; GFX9-NEXT:    ; implicit-def: $vgpr5
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr3
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB68_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; GFX9-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:  .LBB68_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB68_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v34, vcc, 3, v34
; GFX9-NEXT:    v_addc_co_u32_e32 v35, vcc, 0, v35, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v32, vcc, 3, v32
; GFX9-NEXT:    v_addc_co_u32_e32 v33, vcc, 0, v33, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_lshrrev_b64 v[27:28], 24, v[6:7]
; GFX9-NEXT:    v_lshrrev_b64 v[19:20], 24, v[32:33]
; GFX9-NEXT:    v_lshrrev_b64 v[11:12], 24, v[34:35]
; GFX9-NEXT:    v_lshrrev_b64 v[3:4], 24, v[0:1]
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 24, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 8, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 8, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 24, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 8, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 8, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 24, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 8, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v10, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 8, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 24, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v5, 8, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 8, v0
; GFX9-NEXT:  .LBB68_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    v_mov_b32_e32 v4, v1
; GFX9-NEXT:    v_mov_b32_e32 v8, v34
; GFX9-NEXT:    v_mov_b32_e32 v12, v35
; GFX9-NEXT:    v_mov_b32_e32 v16, v32
; GFX9-NEXT:    v_mov_b32_e32 v20, v33
; GFX9-NEXT:    v_mov_b32_e32 v24, v6
; GFX9-NEXT:    v_mov_b32_e32 v28, v7
; GFX9-NEXT:    v_mov_b32_e32 v1, v38
; GFX9-NEXT:    v_mov_b32_e32 v6, v37
; GFX9-NEXT:    v_mov_b32_e32 v7, v36
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v4i64_to_v32i8:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v33, v7 :: v_dual_mov_b32 v32, v6
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v27, v5 :: v_dual_mov_b32 v26, v4
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v19, v3 :: v_dual_mov_b32 v18, v2
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v11, v1 :: v_dual_mov_b32 v10, v0
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr1_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr3_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr5_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr7_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr36_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr35_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr23_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr25_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr34_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr29_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr31_lo16
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB68_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[32:33]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[26:27]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[18:19]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX11-TRUE16-NEXT:  .LBB68_2: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB68_4
; GFX11-TRUE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v26, vcc_lo, v26, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v27, null, 0, v27, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v32, vcc_lo, v32, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v33, null, 0, v33, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[34:35], 24, v[32:33]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[35:36], 24, v[26:27]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[36:37], 24, v[18:19]
; GFX11-TRUE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[10:11]
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v27
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v26
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v19
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v18
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v11
; GFX11-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v10
; GFX11-TRUE16-NEXT:  .LBB68_4: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v10.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v11.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v18.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v18.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v36.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v19.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v26.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v26.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v35.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v27.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v27.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v32.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v32.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v34.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v28.l, v33.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v30.l, v33.h
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v4i64_to_v32i8:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v33, v7 :: v_dual_mov_b32 v32, v6
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v35, v5 :: v_dual_mov_b32 v34, v4
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v37, v3 :: v_dual_mov_b32 v36, v2
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v39, v1 :: v_dual_mov_b32 v38, v0
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr1
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr3
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr5
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr6
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr7
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB68_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[27:28], 24, v[32:33]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[34:35]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[36:37]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[38:39]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v38
; GFX11-FAKE16-NEXT:  .LBB68_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB68_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_co_u32 v36, vcc_lo, v36, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v37, null, 0, v37, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v34, vcc_lo, v34, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v35, null, 0, v35, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v32, vcc_lo, v32, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v33, null, 0, v33, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v38, vcc_lo, v38, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v39, null, 0, v39, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[27:28], 24, v[32:33]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[19:20], 24, v[34:35]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[11:12], 24, v[36:37]
; GFX11-FAKE16-NEXT:    v_lshrrev_b64 v[3:4], 24, v[38:39]
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 24, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 8, v33
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 8, v32
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 24, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 8, v35
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 8, v34
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 24, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v13, 8, v37
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 8, v36
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 24, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 8, v39
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v2, 16, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 8, v38
; GFX11-FAKE16-NEXT:  .LBB68_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v0, v38
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v4, v39
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v8, v36
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v12, v37
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v16, v34
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v20, v35
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v24, v32
; GFX11-FAKE16-NEXT:    v_mov_b32_e32 v28, v33
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <32 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <32 x i8>
  br label %end

end:
  %phi = phi <32 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i8> %phi
}

define inreg <32 x i8> @bitcast_v4i64_to_v32i8_scalar(<4 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4i64_to_v32i8_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB69_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v27, s23, v0, 24
; SI-NEXT:    v_alignbit_b32 v26, s23, v0, 16
; SI-NEXT:    v_alignbit_b32 v25, s23, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v19, s21, v0, 24
; SI-NEXT:    v_alignbit_b32 v18, s21, v0, 16
; SI-NEXT:    v_alignbit_b32 v17, s21, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v11, s19, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s19, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s23, 24
; SI-NEXT:    s_lshr_b32 s7, s23, 16
; SI-NEXT:    s_lshr_b32 s9, s23, 8
; SI-NEXT:    s_lshr_b32 s8, s21, 24
; SI-NEXT:    s_lshr_b32 s10, s21, 16
; SI-NEXT:    s_lshr_b32 s12, s21, 8
; SI-NEXT:    s_lshr_b32 s11, s19, 24
; SI-NEXT:    s_lshr_b32 s13, s19, 16
; SI-NEXT:    s_lshr_b32 s14, s19, 8
; SI-NEXT:    s_lshr_b32 s15, s17, 24
; SI-NEXT:    s_lshr_b32 s24, s17, 16
; SI-NEXT:    s_lshr_b32 s25, s17, 8
; SI-NEXT:    s_cbranch_execnz .LBB69_3
; SI-NEXT:  .LBB69_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s22, s22, 3
; SI-NEXT:    s_addc_u32 s23, s23, 0
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v27, s23, v0, 24
; SI-NEXT:    v_alignbit_b32 v26, s23, v0, 16
; SI-NEXT:    v_alignbit_b32 v25, s23, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v19, s21, v0, 24
; SI-NEXT:    v_alignbit_b32 v18, s21, v0, 16
; SI-NEXT:    v_alignbit_b32 v17, s21, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v11, s19, v0, 24
; SI-NEXT:    v_alignbit_b32 v10, s19, v0, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v0, 8
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v3, s17, v0, 24
; SI-NEXT:    v_alignbit_b32 v2, s17, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 8
; SI-NEXT:    s_lshr_b32 s6, s23, 24
; SI-NEXT:    s_lshr_b32 s7, s23, 16
; SI-NEXT:    s_lshr_b32 s9, s23, 8
; SI-NEXT:    s_lshr_b32 s8, s21, 24
; SI-NEXT:    s_lshr_b32 s10, s21, 16
; SI-NEXT:    s_lshr_b32 s12, s21, 8
; SI-NEXT:    s_lshr_b32 s11, s19, 24
; SI-NEXT:    s_lshr_b32 s13, s19, 16
; SI-NEXT:    s_lshr_b32 s14, s19, 8
; SI-NEXT:    s_lshr_b32 s15, s17, 24
; SI-NEXT:    s_lshr_b32 s24, s17, 16
; SI-NEXT:    s_lshr_b32 s25, s17, 8
; SI-NEXT:  .LBB69_3: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v4, s17
; SI-NEXT:    v_mov_b32_e32 v5, s25
; SI-NEXT:    v_mov_b32_e32 v6, s24
; SI-NEXT:    v_mov_b32_e32 v7, s15
; SI-NEXT:    v_mov_b32_e32 v8, s18
; SI-NEXT:    v_mov_b32_e32 v12, s19
; SI-NEXT:    v_mov_b32_e32 v13, s14
; SI-NEXT:    v_mov_b32_e32 v14, s13
; SI-NEXT:    v_mov_b32_e32 v15, s11
; SI-NEXT:    v_mov_b32_e32 v16, s20
; SI-NEXT:    v_mov_b32_e32 v20, s21
; SI-NEXT:    v_mov_b32_e32 v21, s12
; SI-NEXT:    v_mov_b32_e32 v22, s10
; SI-NEXT:    v_mov_b32_e32 v23, s8
; SI-NEXT:    v_mov_b32_e32 v24, s22
; SI-NEXT:    v_mov_b32_e32 v28, s23
; SI-NEXT:    v_mov_b32_e32 v29, s9
; SI-NEXT:    v_mov_b32_e32 v30, s7
; SI-NEXT:    v_mov_b32_e32 v31, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB69_4:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr25
; SI-NEXT:    ; implicit-def: $sgpr24
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    s_branch .LBB69_2
;
; VI-LABEL: bitcast_v4i64_to_v32i8_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB69_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s14, s23, 24
; VI-NEXT:    s_lshr_b32 s15, s23, 16
; VI-NEXT:    s_lshr_b32 s24, s23, 8
; VI-NEXT:    s_lshr_b32 s25, s22, 16
; VI-NEXT:    s_lshr_b32 s26, s22, 8
; VI-NEXT:    s_lshr_b32 s27, s21, 24
; VI-NEXT:    s_lshr_b32 s28, s21, 16
; VI-NEXT:    s_lshr_b32 s29, s21, 8
; VI-NEXT:    s_lshr_b32 s40, s20, 16
; VI-NEXT:    s_lshr_b32 s41, s20, 8
; VI-NEXT:    s_lshr_b32 s42, s19, 24
; VI-NEXT:    s_lshr_b32 s43, s19, 16
; VI-NEXT:    s_lshr_b32 s44, s19, 8
; VI-NEXT:    s_lshr_b32 s45, s18, 16
; VI-NEXT:    s_lshr_b32 s46, s18, 8
; VI-NEXT:    s_lshr_b32 s47, s17, 24
; VI-NEXT:    s_lshr_b32 s56, s17, 16
; VI-NEXT:    s_lshr_b32 s57, s17, 8
; VI-NEXT:    s_lshr_b32 s58, s16, 16
; VI-NEXT:    s_lshr_b32 s59, s16, 8
; VI-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; VI-NEXT:    s_cbranch_execnz .LBB69_3
; VI-NEXT:  .LBB69_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; VI-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; VI-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; VI-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; VI-NEXT:    s_lshr_b32 s14, s23, 24
; VI-NEXT:    s_lshr_b32 s15, s23, 16
; VI-NEXT:    s_lshr_b32 s24, s23, 8
; VI-NEXT:    s_lshr_b32 s25, s22, 16
; VI-NEXT:    s_lshr_b32 s26, s22, 8
; VI-NEXT:    s_lshr_b32 s27, s21, 24
; VI-NEXT:    s_lshr_b32 s28, s21, 16
; VI-NEXT:    s_lshr_b32 s29, s21, 8
; VI-NEXT:    s_lshr_b32 s40, s20, 16
; VI-NEXT:    s_lshr_b32 s41, s20, 8
; VI-NEXT:    s_lshr_b32 s42, s19, 24
; VI-NEXT:    s_lshr_b32 s43, s19, 16
; VI-NEXT:    s_lshr_b32 s44, s19, 8
; VI-NEXT:    s_lshr_b32 s45, s18, 16
; VI-NEXT:    s_lshr_b32 s46, s18, 8
; VI-NEXT:    s_lshr_b32 s47, s17, 24
; VI-NEXT:    s_lshr_b32 s56, s17, 16
; VI-NEXT:    s_lshr_b32 s57, s17, 8
; VI-NEXT:    s_lshr_b32 s58, s16, 16
; VI-NEXT:    s_lshr_b32 s59, s16, 8
; VI-NEXT:  .LBB69_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s59
; VI-NEXT:    v_mov_b32_e32 v2, s58
; VI-NEXT:    v_mov_b32_e32 v3, s10
; VI-NEXT:    v_mov_b32_e32 v4, s17
; VI-NEXT:    v_mov_b32_e32 v5, s57
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s47
; VI-NEXT:    v_mov_b32_e32 v8, s18
; VI-NEXT:    v_mov_b32_e32 v9, s46
; VI-NEXT:    v_mov_b32_e32 v10, s45
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_mov_b32_e32 v12, s19
; VI-NEXT:    v_mov_b32_e32 v13, s44
; VI-NEXT:    v_mov_b32_e32 v14, s43
; VI-NEXT:    v_mov_b32_e32 v15, s42
; VI-NEXT:    v_mov_b32_e32 v16, s20
; VI-NEXT:    v_mov_b32_e32 v17, s41
; VI-NEXT:    v_mov_b32_e32 v18, s40
; VI-NEXT:    v_mov_b32_e32 v19, s6
; VI-NEXT:    v_mov_b32_e32 v20, s21
; VI-NEXT:    v_mov_b32_e32 v21, s29
; VI-NEXT:    v_mov_b32_e32 v22, s28
; VI-NEXT:    v_mov_b32_e32 v23, s27
; VI-NEXT:    v_mov_b32_e32 v24, s22
; VI-NEXT:    v_mov_b32_e32 v25, s26
; VI-NEXT:    v_mov_b32_e32 v26, s25
; VI-NEXT:    v_mov_b32_e32 v27, s4
; VI-NEXT:    v_mov_b32_e32 v28, s23
; VI-NEXT:    v_mov_b32_e32 v29, s24
; VI-NEXT:    v_mov_b32_e32 v30, s15
; VI-NEXT:    v_mov_b32_e32 v31, s14
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB69_4:
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr10
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr8
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr43
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr41
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr6
; VI-NEXT:    ; implicit-def: $sgpr29
; VI-NEXT:    ; implicit-def: $sgpr28
; VI-NEXT:    ; implicit-def: $sgpr27
; VI-NEXT:    ; implicit-def: $sgpr26
; VI-NEXT:    ; implicit-def: $sgpr25
; VI-NEXT:    ; implicit-def: $sgpr4
; VI-NEXT:    ; implicit-def: $sgpr24
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    s_branch .LBB69_2
;
; GFX9-LABEL: bitcast_v4i64_to_v32i8_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB69_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s14, s23, 24
; GFX9-NEXT:    s_lshr_b32 s15, s23, 16
; GFX9-NEXT:    s_lshr_b32 s24, s23, 8
; GFX9-NEXT:    s_lshr_b32 s25, s22, 16
; GFX9-NEXT:    s_lshr_b32 s26, s22, 8
; GFX9-NEXT:    s_lshr_b32 s27, s21, 24
; GFX9-NEXT:    s_lshr_b32 s28, s21, 16
; GFX9-NEXT:    s_lshr_b32 s29, s21, 8
; GFX9-NEXT:    s_lshr_b32 s40, s20, 16
; GFX9-NEXT:    s_lshr_b32 s41, s20, 8
; GFX9-NEXT:    s_lshr_b32 s42, s19, 24
; GFX9-NEXT:    s_lshr_b32 s43, s19, 16
; GFX9-NEXT:    s_lshr_b32 s44, s19, 8
; GFX9-NEXT:    s_lshr_b32 s45, s18, 16
; GFX9-NEXT:    s_lshr_b32 s46, s18, 8
; GFX9-NEXT:    s_lshr_b32 s47, s17, 24
; GFX9-NEXT:    s_lshr_b32 s56, s17, 16
; GFX9-NEXT:    s_lshr_b32 s57, s17, 8
; GFX9-NEXT:    s_lshr_b32 s58, s16, 16
; GFX9-NEXT:    s_lshr_b32 s59, s16, 8
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; GFX9-NEXT:    s_cbranch_execnz .LBB69_3
; GFX9-NEXT:  .LBB69_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_lshr_b64 s[4:5], s[22:23], 24
; GFX9-NEXT:    s_lshr_b64 s[6:7], s[20:21], 24
; GFX9-NEXT:    s_lshr_b64 s[8:9], s[18:19], 24
; GFX9-NEXT:    s_lshr_b64 s[10:11], s[16:17], 24
; GFX9-NEXT:    s_lshr_b32 s14, s23, 24
; GFX9-NEXT:    s_lshr_b32 s15, s23, 16
; GFX9-NEXT:    s_lshr_b32 s24, s23, 8
; GFX9-NEXT:    s_lshr_b32 s25, s22, 16
; GFX9-NEXT:    s_lshr_b32 s26, s22, 8
; GFX9-NEXT:    s_lshr_b32 s27, s21, 24
; GFX9-NEXT:    s_lshr_b32 s28, s21, 16
; GFX9-NEXT:    s_lshr_b32 s29, s21, 8
; GFX9-NEXT:    s_lshr_b32 s40, s20, 16
; GFX9-NEXT:    s_lshr_b32 s41, s20, 8
; GFX9-NEXT:    s_lshr_b32 s42, s19, 24
; GFX9-NEXT:    s_lshr_b32 s43, s19, 16
; GFX9-NEXT:    s_lshr_b32 s44, s19, 8
; GFX9-NEXT:    s_lshr_b32 s45, s18, 16
; GFX9-NEXT:    s_lshr_b32 s46, s18, 8
; GFX9-NEXT:    s_lshr_b32 s47, s17, 24
; GFX9-NEXT:    s_lshr_b32 s56, s17, 16
; GFX9-NEXT:    s_lshr_b32 s57, s17, 8
; GFX9-NEXT:    s_lshr_b32 s58, s16, 16
; GFX9-NEXT:    s_lshr_b32 s59, s16, 8
; GFX9-NEXT:  .LBB69_3: ; %end
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s59
; GFX9-NEXT:    v_mov_b32_e32 v2, s58
; GFX9-NEXT:    v_mov_b32_e32 v3, s10
; GFX9-NEXT:    v_mov_b32_e32 v4, s17
; GFX9-NEXT:    v_mov_b32_e32 v5, s57
; GFX9-NEXT:    v_mov_b32_e32 v6, s56
; GFX9-NEXT:    v_mov_b32_e32 v7, s47
; GFX9-NEXT:    v_mov_b32_e32 v8, s18
; GFX9-NEXT:    v_mov_b32_e32 v9, s46
; GFX9-NEXT:    v_mov_b32_e32 v10, s45
; GFX9-NEXT:    v_mov_b32_e32 v11, s8
; GFX9-NEXT:    v_mov_b32_e32 v12, s19
; GFX9-NEXT:    v_mov_b32_e32 v13, s44
; GFX9-NEXT:    v_mov_b32_e32 v14, s43
; GFX9-NEXT:    v_mov_b32_e32 v15, s42
; GFX9-NEXT:    v_mov_b32_e32 v16, s20
; GFX9-NEXT:    v_mov_b32_e32 v17, s41
; GFX9-NEXT:    v_mov_b32_e32 v18, s40
; GFX9-NEXT:    v_mov_b32_e32 v19, s6
; GFX9-NEXT:    v_mov_b32_e32 v20, s21
; GFX9-NEXT:    v_mov_b32_e32 v21, s29
; GFX9-NEXT:    v_mov_b32_e32 v22, s28
; GFX9-NEXT:    v_mov_b32_e32 v23, s27
; GFX9-NEXT:    v_mov_b32_e32 v24, s22
; GFX9-NEXT:    v_mov_b32_e32 v25, s26
; GFX9-NEXT:    v_mov_b32_e32 v26, s25
; GFX9-NEXT:    v_mov_b32_e32 v27, s4
; GFX9-NEXT:    v_mov_b32_e32 v28, s23
; GFX9-NEXT:    v_mov_b32_e32 v29, s24
; GFX9-NEXT:    v_mov_b32_e32 v30, s15
; GFX9-NEXT:    v_mov_b32_e32 v31, s14
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB69_4:
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr10
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr8
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr43
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr41
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr6
; GFX9-NEXT:    ; implicit-def: $sgpr29
; GFX9-NEXT:    ; implicit-def: $sgpr28
; GFX9-NEXT:    ; implicit-def: $sgpr27
; GFX9-NEXT:    ; implicit-def: $sgpr26
; GFX9-NEXT:    ; implicit-def: $sgpr25
; GFX9-NEXT:    ; implicit-def: $sgpr4
; GFX9-NEXT:    ; implicit-def: $sgpr24
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    s_branch .LBB69_2
;
; GFX11-LABEL: bitcast_v4i64_to_v32i8_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s46, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB69_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s12, s19, 24
; GFX11-NEXT:    s_lshr_b32 s13, s19, 16
; GFX11-NEXT:    s_lshr_b32 s14, s19, 8
; GFX11-NEXT:    s_lshr_b32 s15, s18, 16
; GFX11-NEXT:    s_lshr_b32 s20, s18, 8
; GFX11-NEXT:    s_lshr_b32 s21, s17, 24
; GFX11-NEXT:    s_lshr_b32 s22, s17, 16
; GFX11-NEXT:    s_lshr_b32 s23, s17, 8
; GFX11-NEXT:    s_lshr_b32 s24, s16, 16
; GFX11-NEXT:    s_lshr_b32 s25, s16, 8
; GFX11-NEXT:    s_lshr_b32 s26, s3, 24
; GFX11-NEXT:    s_lshr_b32 s27, s3, 16
; GFX11-NEXT:    s_lshr_b32 s28, s3, 8
; GFX11-NEXT:    s_lshr_b32 s29, s2, 16
; GFX11-NEXT:    s_lshr_b32 s40, s2, 8
; GFX11-NEXT:    s_lshr_b32 s41, s1, 24
; GFX11-NEXT:    s_lshr_b32 s42, s1, 16
; GFX11-NEXT:    s_lshr_b32 s43, s1, 8
; GFX11-NEXT:    s_lshr_b32 s44, s0, 16
; GFX11-NEXT:    s_lshr_b32 s45, s0, 8
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[8:9], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[10:11], s[0:1], 24
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s46
; GFX11-NEXT:    s_cbranch_vccnz .LBB69_3
; GFX11-NEXT:  .LBB69_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_lshr_b64 s[6:7], s[16:17], 24
; GFX11-NEXT:    s_lshr_b64 s[4:5], s[18:19], 24
; GFX11-NEXT:    s_lshr_b64 s[8:9], s[2:3], 24
; GFX11-NEXT:    s_lshr_b64 s[10:11], s[0:1], 24
; GFX11-NEXT:    s_lshr_b32 s12, s19, 24
; GFX11-NEXT:    s_lshr_b32 s13, s19, 16
; GFX11-NEXT:    s_lshr_b32 s14, s19, 8
; GFX11-NEXT:    s_lshr_b32 s15, s18, 16
; GFX11-NEXT:    s_lshr_b32 s20, s18, 8
; GFX11-NEXT:    s_lshr_b32 s21, s17, 24
; GFX11-NEXT:    s_lshr_b32 s22, s17, 16
; GFX11-NEXT:    s_lshr_b32 s23, s17, 8
; GFX11-NEXT:    s_lshr_b32 s24, s16, 16
; GFX11-NEXT:    s_lshr_b32 s25, s16, 8
; GFX11-NEXT:    s_lshr_b32 s26, s3, 24
; GFX11-NEXT:    s_lshr_b32 s27, s3, 16
; GFX11-NEXT:    s_lshr_b32 s28, s3, 8
; GFX11-NEXT:    s_lshr_b32 s29, s2, 16
; GFX11-NEXT:    s_lshr_b32 s40, s2, 8
; GFX11-NEXT:    s_lshr_b32 s41, s1, 24
; GFX11-NEXT:    s_lshr_b32 s42, s1, 16
; GFX11-NEXT:    s_lshr_b32 s43, s1, 8
; GFX11-NEXT:    s_lshr_b32 s44, s0, 16
; GFX11-NEXT:    s_lshr_b32 s45, s0, 8
; GFX11-NEXT:  .LBB69_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s45
; GFX11-NEXT:    v_dual_mov_b32 v2, s44 :: v_dual_mov_b32 v3, s10
; GFX11-NEXT:    v_dual_mov_b32 v4, s1 :: v_dual_mov_b32 v5, s43
; GFX11-NEXT:    v_dual_mov_b32 v6, s42 :: v_dual_mov_b32 v7, s41
; GFX11-NEXT:    v_dual_mov_b32 v8, s2 :: v_dual_mov_b32 v9, s40
; GFX11-NEXT:    v_dual_mov_b32 v10, s29 :: v_dual_mov_b32 v11, s8
; GFX11-NEXT:    v_dual_mov_b32 v12, s3 :: v_dual_mov_b32 v13, s28
; GFX11-NEXT:    v_dual_mov_b32 v14, s27 :: v_dual_mov_b32 v15, s26
; GFX11-NEXT:    v_dual_mov_b32 v16, s16 :: v_dual_mov_b32 v17, s25
; GFX11-NEXT:    v_dual_mov_b32 v18, s24 :: v_dual_mov_b32 v19, s6
; GFX11-NEXT:    v_dual_mov_b32 v20, s17 :: v_dual_mov_b32 v21, s23
; GFX11-NEXT:    v_dual_mov_b32 v22, s22 :: v_dual_mov_b32 v23, s21
; GFX11-NEXT:    v_dual_mov_b32 v24, s18 :: v_dual_mov_b32 v25, s20
; GFX11-NEXT:    v_dual_mov_b32 v26, s15 :: v_dual_mov_b32 v27, s4
; GFX11-NEXT:    v_dual_mov_b32 v28, s19 :: v_dual_mov_b32 v29, s14
; GFX11-NEXT:    v_dual_mov_b32 v30, s13 :: v_dual_mov_b32 v31, s12
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB69_4:
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr29
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr28
; GFX11-NEXT:    ; implicit-def: $sgpr27
; GFX11-NEXT:    ; implicit-def: $sgpr26
; GFX11-NEXT:    ; implicit-def: $sgpr25
; GFX11-NEXT:    ; implicit-def: $sgpr24
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    ; implicit-def: $sgpr23
; GFX11-NEXT:    ; implicit-def: $sgpr22
; GFX11-NEXT:    ; implicit-def: $sgpr21
; GFX11-NEXT:    ; implicit-def: $sgpr20
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr4
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    s_branch .LBB69_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <4 x i64> %a, splat (i64 3)
  %a2 = bitcast <4 x i64> %a1 to <32 x i8>
  br label %end

cmp.false:
  %a3 = bitcast <4 x i64> %a to <32 x i8>
  br label %end

end:
  %phi = phi <32 x i8> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <32 x i8> %phi
}

define <4 x i64> @bitcast_v32i8_to_v4i64(<32 x i8> %a, i32 %b) {
; SI-LABEL: bitcast_v32i8_to_v4i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v32, v2
; SI-NEXT:    v_mov_b32_e32 v31, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32
; SI-NEXT:    v_mov_b32_e32 v34, v6
; SI-NEXT:    v_mov_b32_e32 v33, v4
; SI-NEXT:    v_lshlrev_b32_e32 v52, 8, v1
; SI-NEXT:    v_lshlrev_b32_e32 v51, 24, v3
; SI-NEXT:    v_lshlrev_b32_e32 v50, 8, v5
; SI-NEXT:    v_lshlrev_b32_e32 v49, 24, v7
; SI-NEXT:    v_lshlrev_b32_e32 v48, 8, v9
; SI-NEXT:    v_lshlrev_b32_e32 v39, 24, v11
; SI-NEXT:    v_lshlrev_b32_e32 v38, 8, v13
; SI-NEXT:    v_lshlrev_b32_e32 v37, 24, v15
; SI-NEXT:    v_lshlrev_b32_e32 v36, 8, v17
; SI-NEXT:    v_lshlrev_b32_e32 v35, 24, v19
; SI-NEXT:    v_lshlrev_b32_e32 v19, 8, v21
; SI-NEXT:    v_lshlrev_b32_e32 v17, 24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v15, 8, v25
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v27
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v29
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v2
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB70_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB70_4
; SI-NEXT:  .LBB70_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB70_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v31
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v32
; SI-NEXT:    v_or_b32_e32 v0, v0, v52
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v51, v1
; SI-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v33
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v50
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v49, v2
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v8
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v10
; SI-NEXT:    v_or_b32_e32 v2, v2, v48
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v39, v3
; SI-NEXT:    v_or_b32_e32 v2, v2, v3
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v12
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v14
; SI-NEXT:    v_or_b32_e32 v3, v3, v38
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v4, v37, v4
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v16
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v18
; SI-NEXT:    v_or_b32_e32 v4, v4, v36
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v5, v35, v5
; SI-NEXT:    v_or_b32_e32 v4, v4, v5
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v20
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v22
; SI-NEXT:    v_or_b32_e32 v5, v5, v19
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v6, v17, v6
; SI-NEXT:    v_or_b32_e32 v5, v5, v6
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v24
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v26
; SI-NEXT:    v_or_b32_e32 v6, v6, v15
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v7, v13, v7
; SI-NEXT:    v_or_b32_e32 v6, v6, v7
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v28
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v30
; SI-NEXT:    v_or_b32_e32 v7, v7, v11
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB70_2
; SI-NEXT:  .LBB70_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v31
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v32
; SI-NEXT:    v_or_b32_e32 v0, v52, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v51, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v33
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v34
; SI-NEXT:    s_movk_i32 s6, 0x300
; SI-NEXT:    v_or_b32_e32 v1, v50, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_or_b32_e32 v2, v49, v2
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v8
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v10
; SI-NEXT:    v_or_b32_e32 v2, v48, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v39, v3
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v12
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v14
; SI-NEXT:    v_or_b32_e32 v3, v38, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_or_b32_e32 v4, v37, v4
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v16
; SI-NEXT:    v_and_b32_e32 v4, 0xff, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v18
; SI-NEXT:    v_or_b32_e32 v4, v36, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_or_b32_e32 v5, v35, v5
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v5, 0xff, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v22
; SI-NEXT:    v_or_b32_e32 v5, v19, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_or_b32_e32 v6, v17, v6
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v24
; SI-NEXT:    v_and_b32_e32 v6, 0xff, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v26
; SI-NEXT:    v_or_b32_e32 v6, v15, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_or_b32_e32 v7, v13, v7
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v28
; SI-NEXT:    v_and_b32_e32 v7, 0xff, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v30
; SI-NEXT:    v_or_b32_e32 v7, v11, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xff, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x300, v7
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v8, v9, v8
; SI-NEXT:    s_mov_b32 s7, 0x3000000
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    v_add_i32_e32 v0, vcc, s7, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s7, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s7, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s7, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s7, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s7, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v32i8_to_v4i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v32, v2
; VI-NEXT:    v_mov_b32_e32 v31, v0
; VI-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; VI-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; VI-NEXT:    v_mov_b32_e32 v34, v6
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_lshlrev_b16_e32 v52, 8, v1
; VI-NEXT:    v_lshlrev_b16_e32 v51, 8, v3
; VI-NEXT:    v_lshlrev_b16_e32 v50, 8, v5
; VI-NEXT:    v_lshlrev_b16_e32 v49, 8, v7
; VI-NEXT:    v_lshlrev_b16_e32 v48, 8, v9
; VI-NEXT:    v_lshlrev_b16_e32 v39, 8, v11
; VI-NEXT:    v_lshlrev_b16_e32 v38, 8, v13
; VI-NEXT:    v_lshlrev_b16_e32 v37, 8, v15
; VI-NEXT:    v_lshlrev_b16_e32 v36, 8, v17
; VI-NEXT:    v_lshlrev_b16_e32 v35, 8, v19
; VI-NEXT:    v_lshlrev_b16_e32 v19, 8, v21
; VI-NEXT:    v_lshlrev_b16_e32 v17, 8, v23
; VI-NEXT:    v_lshlrev_b16_e32 v15, 8, v25
; VI-NEXT:    v_lshlrev_b16_e32 v13, 8, v27
; VI-NEXT:    v_lshlrev_b16_e32 v11, 8, v29
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b16_e32 v9, 8, v2
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB70_3
; VI-NEXT:  ; %bb.1: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execnz .LBB70_4
; VI-NEXT:  .LBB70_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB70_3: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v31, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v32, v51 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v33, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v34, v49 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v8, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v10, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v12, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v14, v37 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v16, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v18, v35 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v22, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v26, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v28, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v30, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr8
; VI-NEXT:    ; implicit-def: $vgpr10
; VI-NEXT:    ; implicit-def: $vgpr12
; VI-NEXT:    ; implicit-def: $vgpr14
; VI-NEXT:    ; implicit-def: $vgpr16
; VI-NEXT:    ; implicit-def: $vgpr18
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr19
; VI-NEXT:    ; implicit-def: $vgpr17
; VI-NEXT:    ; implicit-def: $vgpr15
; VI-NEXT:    ; implicit-def: $vgpr13
; VI-NEXT:    ; implicit-def: $vgpr11
; VI-NEXT:    ; implicit-def: $vgpr9
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB70_2
; VI-NEXT:  .LBB70_4: ; %cmp.true
; VI-NEXT:    v_add_u16_e32 v0, 3, v31
; VI-NEXT:    v_add_u16_e32 v1, 3, v32
; VI-NEXT:    v_or_b32_sdwa v0, v52, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_mov_b32_e32 v7, 0x300
; VI-NEXT:    v_add_u16_e32 v2, 3, v33
; VI-NEXT:    v_add_u16_e32 v0, 0x300, v0
; VI-NEXT:    v_add_u16_sdwa v1, v1, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v50, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 0x300, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v34
; VI-NEXT:    v_or_b32_sdwa v2, v49, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_sdwa v2, v2, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v8
; VI-NEXT:    v_add_u16_e32 v3, 3, v10
; VI-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v3, v39, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v2, 0x300, v2
; VI-NEXT:    v_add_u16_sdwa v3, v3, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v12
; VI-NEXT:    v_add_u16_e32 v4, 3, v14
; VI-NEXT:    v_or_b32_sdwa v3, v38, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v4, v37, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v3, 0x300, v3
; VI-NEXT:    v_add_u16_sdwa v4, v4, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v16
; VI-NEXT:    v_add_u16_e32 v5, 3, v18
; VI-NEXT:    v_or_b32_sdwa v4, v36, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v5, v35, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v4, 0x300, v4
; VI-NEXT:    v_add_u16_sdwa v5, v5, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v20
; VI-NEXT:    v_add_u16_e32 v6, 3, v22
; VI-NEXT:    v_or_b32_sdwa v5, v19, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v6, v17, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v5, 0x300, v5
; VI-NEXT:    v_add_u16_sdwa v6, v6, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v24
; VI-NEXT:    v_add_u16_e32 v8, 3, v26
; VI-NEXT:    v_or_b32_sdwa v6, v15, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v8, v13, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v6, 0x300, v6
; VI-NEXT:    v_add_u16_sdwa v8, v8, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v28
; VI-NEXT:    v_add_u16_e32 v10, 3, v30
; VI-NEXT:    v_or_b32_sdwa v8, v11, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v9, v9, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u16_e32 v8, 0x300, v8
; VI-NEXT:    v_add_u16_sdwa v7, v9, v7 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v32i8_to_v4i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v2
; GFX9-NEXT:    v_mov_b32_e32 v31, v0
; GFX9-NEXT:    buffer_load_dword v0, off, s[0:3], s32 offset:4
; GFX9-NEXT:    buffer_load_ushort v2, off, s[0:3], s32
; GFX9-NEXT:    v_mov_b32_e32 v34, v6
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_lshlrev_b16_e32 v52, 8, v1
; GFX9-NEXT:    v_lshlrev_b16_e32 v51, 8, v3
; GFX9-NEXT:    v_lshlrev_b16_e32 v50, 8, v5
; GFX9-NEXT:    v_lshlrev_b16_e32 v49, 8, v7
; GFX9-NEXT:    v_lshlrev_b16_e32 v48, 8, v9
; GFX9-NEXT:    v_lshlrev_b16_e32 v39, 8, v11
; GFX9-NEXT:    v_lshlrev_b16_e32 v38, 8, v13
; GFX9-NEXT:    v_lshlrev_b16_e32 v37, 8, v15
; GFX9-NEXT:    v_lshlrev_b16_e32 v36, 8, v17
; GFX9-NEXT:    v_lshlrev_b16_e32 v35, 8, v19
; GFX9-NEXT:    v_lshlrev_b16_e32 v19, 8, v21
; GFX9-NEXT:    v_lshlrev_b16_e32 v17, 8, v23
; GFX9-NEXT:    v_lshlrev_b16_e32 v15, 8, v25
; GFX9-NEXT:    v_lshlrev_b16_e32 v13, 8, v27
; GFX9-NEXT:    v_lshlrev_b16_e32 v11, 8, v29
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b16_e32 v9, 8, v2
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB70_3
; GFX9-NEXT:  ; %bb.1: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execnz .LBB70_4
; GFX9-NEXT:  .LBB70_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB70_3: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v31, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v32, v51 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v33, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v34, v49 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v8, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v10, v39 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v12, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v14, v37 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v16, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v18, v35 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v4, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v20, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v22, v17 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v5, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v24, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v26, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v6, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v28, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v8, v30, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr8
; GFX9-NEXT:    ; implicit-def: $vgpr10
; GFX9-NEXT:    ; implicit-def: $vgpr12
; GFX9-NEXT:    ; implicit-def: $vgpr14
; GFX9-NEXT:    ; implicit-def: $vgpr16
; GFX9-NEXT:    ; implicit-def: $vgpr18
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr19
; GFX9-NEXT:    ; implicit-def: $vgpr17
; GFX9-NEXT:    ; implicit-def: $vgpr15
; GFX9-NEXT:    ; implicit-def: $vgpr13
; GFX9-NEXT:    ; implicit-def: $vgpr11
; GFX9-NEXT:    ; implicit-def: $vgpr9
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB70_2
; GFX9-NEXT:  .LBB70_4: ; %cmp.true
; GFX9-NEXT:    v_add_u16_e32 v0, 3, v31
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v32
; GFX9-NEXT:    v_or_b32_sdwa v0, v52, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_movk_i32 s6, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v1, v51, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u16_sdwa v1, v1, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX9-NEXT:    v_add_u16_e32 v1, 3, v33
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v34
; GFX9-NEXT:    v_or_b32_sdwa v1, v50, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v2, v49, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v1, 0x300, v1
; GFX9-NEXT:    v_add_u16_sdwa v2, v2, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v1, v1, v2
; GFX9-NEXT:    v_add_u16_e32 v2, 3, v8
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v10
; GFX9-NEXT:    v_or_b32_sdwa v2, v48, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v3, v39, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v2, 0x300, v2
; GFX9-NEXT:    v_add_u16_sdwa v3, v3, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v2, v2, v3
; GFX9-NEXT:    v_add_u16_e32 v3, 3, v12
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v14
; GFX9-NEXT:    v_or_b32_sdwa v3, v38, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v4, v37, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v3, 0x300, v3
; GFX9-NEXT:    v_add_u16_sdwa v4, v4, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX9-NEXT:    v_add_u16_e32 v4, 3, v16
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v18
; GFX9-NEXT:    v_or_b32_sdwa v4, v36, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v5, v35, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v4, 0x300, v4
; GFX9-NEXT:    v_add_u16_sdwa v5, v5, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v4, v4, v5
; GFX9-NEXT:    v_add_u16_e32 v5, 3, v20
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v22
; GFX9-NEXT:    v_or_b32_sdwa v5, v19, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v6, v17, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v5, 0x300, v5
; GFX9-NEXT:    v_add_u16_sdwa v6, v6, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v5, v5, v6
; GFX9-NEXT:    v_add_u16_e32 v6, 3, v24
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v26
; GFX9-NEXT:    v_or_b32_sdwa v6, v15, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v7, v13, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v6, 0x300, v6
; GFX9-NEXT:    v_add_u16_sdwa v7, v7, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v6, v6, v7
; GFX9-NEXT:    v_add_u16_e32 v7, 3, v28
; GFX9-NEXT:    v_add_u16_e32 v8, 3, v30
; GFX9-NEXT:    v_or_b32_sdwa v7, v11, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v8, v9, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u16_e32 v7, 0x300, v7
; GFX9-NEXT:    v_add_u16_sdwa v8, v8, s6 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v7, v7, v8
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v32i8_to_v4i64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_clause 0x1
; GFX11-TRUE16-NEXT:    scratch_load_b32 v32, off, s32 offset:4
; GFX11-TRUE16-NEXT:    scratch_load_d16_b16 v31, off, s32
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.h, v21.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.h, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.h, v17.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.h, v15.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.h, v13.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.h, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.h, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.h, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.h, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v18.h, 8, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.l, 8, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v17.h, 8, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v16.h, 8, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.l, 8, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v15.h, 8, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.h, 8, v25.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.l, 8, v24.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v11.h, 8, v23.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.l, 8, v22.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v12.h, 8, v21.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.l, 8, v23.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v8.h, 8, v25.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.l, 8, v27.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v9.h, 8, v29.l
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b16 v10.l, 8, v31.l
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v32
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB70_3
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execnz .LBB70_4
; GFX11-TRUE16-NEXT:  .LBB70_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB70_3: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v21.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v20.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v19.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v19.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v14.h
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v0.l, v18.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v0.h, v17.l
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v1.l, v17.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v1.h, v16.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v13.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v2.l, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v2.h, v15.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v1, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v13.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v16.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v20.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v14.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v18.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v10.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v11.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v12.h
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v6, v2
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v11.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v4.h, v12.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v22.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v24.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v26.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v28.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v30.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v3.l, v8.l
; GFX11-TRUE16-NEXT:    v_or_b16 v6.l, v3.h, v8.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v4.l, v9.l
; GFX11-TRUE16-NEXT:    v_or_b16 v7.l, v4.h, v9.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v5.l, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v13, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v15, v8
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v7, v10
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr21_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr19_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr13_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr14_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr20_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr22_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr24_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr26_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr28_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr30_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr18_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr17_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr16_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr15_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr11_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr11_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr12_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr12_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr8_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_lo16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr9_hi16
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr10_lo16
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB70_2
; GFX11-TRUE16-NEXT:  .LBB70_4: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, v21.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.h, v20.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, v14.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.h, v13.h, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, v19.h, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v0.l, 0xff, v0.l
; GFX11-TRUE16-NEXT:    v_and_b16 v0.h, 0xff, v0.h
; GFX11-TRUE16-NEXT:    v_and_b16 v2.l, 0xff, v2.l
; GFX11-TRUE16-NEXT:    v_and_b16 v2.h, 0xff, v2.h
; GFX11-TRUE16-NEXT:    v_and_b16 v1.l, 0xff, v1.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.l, v18.h, v0.l
; GFX11-TRUE16-NEXT:    v_or_b16 v0.h, v17.l, v0.h
; GFX11-TRUE16-NEXT:    v_or_b16 v2.l, v15.l, v2.l
; GFX11-TRUE16-NEXT:    v_or_b16 v2.h, v15.h, v2.h
; GFX11-TRUE16-NEXT:    v_or_b16 v1.l, v17.h, v1.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v0.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v2.l, 0x300, v2.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v2.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.h, v19.l, 3
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v0.l, 0x300, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_and_b16 v1.h, 0xff, v1.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v2, v2, v4
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v0, v5, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v13.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v16.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, v20.l, 3
; GFX11-TRUE16-NEXT:    v_or_b16 v1.h, v16.h, v1.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v14.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.h, v18.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v1.l, 0x300, v1.h
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v10.h, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v11.h, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v12.h, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v11.l, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.h, v12.l, v4.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v5.l
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v1, v6, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v4.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v15, 0xffff, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, v22.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.h, v24.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, v26.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.h, v28.l, 3
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, v30.l, 3
; GFX11-TRUE16-NEXT:    v_and_b16 v3.l, 0xff, v3.l
; GFX11-TRUE16-NEXT:    v_and_b16 v3.h, 0xff, v3.h
; GFX11-TRUE16-NEXT:    v_and_b16 v4.l, 0xff, v4.l
; GFX11-TRUE16-NEXT:    v_and_b16 v4.h, 0xff, v4.h
; GFX11-TRUE16-NEXT:    v_and_b16 v5.l, 0xff, v5.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.l, v8.l, v3.l
; GFX11-TRUE16-NEXT:    v_or_b16 v3.h, v8.h, v3.h
; GFX11-TRUE16-NEXT:    v_or_b16 v4.l, v9.l, v4.l
; GFX11-TRUE16-NEXT:    v_or_b16 v4.h, v9.h, v4.h
; GFX11-TRUE16-NEXT:    v_or_b16 v5.l, v10.l, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v3.l, 0x300, v3.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v6.l, 0x300, v3.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v4.l, 0x300, v4.l
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v7.l, 0x300, v4.h
; GFX11-TRUE16-NEXT:    v_add_nc_u16 v5.l, 0x300, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v3, v11, v12
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v4, v13, v14
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v5, v15, v8
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v6, v6, v9
; GFX11-TRUE16-NEXT:    v_or_b32_e32 v7, v7, v10
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v32i8_to_v4i64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v32, v2 :: v_dual_mov_b32 v31, v0
; GFX11-FAKE16-NEXT:    s_clause 0x1
; GFX11-FAKE16-NEXT:    scratch_load_b32 v0, off, s32 offset:4
; GFX11-FAKE16-NEXT:    scratch_load_u16 v2, off, s32
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v34, v6 :: v_dual_mov_b32 v33, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v51, 8, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v49, 8, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v50, 8, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v48, 8, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v38, 8, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v39, 8, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v35, 8, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v36, 8, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v37, 8, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v19, 8, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v21, 8, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v9, 8, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v11, 8, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v13, 8, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v15, 8, v29
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(1)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b16 v17, 8, v2
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB70_3
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execnz .LBB70_4
; GFX11-FAKE16-NEXT:  .LBB70_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB70_3: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v31
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v32
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v33
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v51
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v1, v49
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v2, v50
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v48
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v38
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v39
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v18
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v26
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v28
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v30
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v35
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v4, v36
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v5, v37
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v6, v19
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v7, v21
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v8, v9
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v10, v11
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v12, v13
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v14, v15
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v11, v12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr8
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr10
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr12
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr14
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr16
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr18
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr51
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr49
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr50
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr48
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr19
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr9
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr11
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr13
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr15
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr17
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB70_2
; GFX11-FAKE16-NEXT:  .LBB70_4: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, v31, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, v32, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, v33, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v34, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v8, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v10, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v51, v0
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v49, v1
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v50, v2
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v48, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v38, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v39, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v0, 0x300, v0
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v1, 0x300, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v2, 0x300, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, v18, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v1, v2, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, v12, 3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v2, v4, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, v14, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, v16, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, v20, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, v22, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, v24, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, v26, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v14, v28, 3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v16, v30, 3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xff, v7
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xff, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v10, 0xff, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v12, 0xff, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xff, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xff, v16
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v35, v3
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v36, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v37, v5
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v19, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v21, v7
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v8, v9, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v9, v11, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v10, v13, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v11, v15, v14
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v12, v17, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v3, 0x300, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v4, 0x300, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v5, 0x300, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v6, 0x300, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v7, 0x300, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v8, 0x300, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v9, 0x300, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v10, 0x300, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v11, 0x300, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u16 v12, 0x300, v12
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v3, v3, v4
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v4, v5, v6
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v5, v7, v8
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v6, v9, v10
; GFX11-FAKE16-NEXT:    v_or_b32_e32 v7, v11, v12
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i8> %a, splat (i8 3)
  %a2 = bitcast <32 x i8> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i8> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define inreg <4 x i64> @bitcast_v32i8_to_v4i64_scalar(<32 x i8> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v32i8_to_v4i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; SI-NEXT:    v_mov_b32_e32 v22, v6
; SI-NEXT:    v_mov_b32_e32 v21, v4
; SI-NEXT:    v_mov_b32_e32 v20, v2
; SI-NEXT:    v_mov_b32_e32 v19, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v27, 24, v1
; SI-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; SI-NEXT:    v_lshlrev_b32_e32 v25, 24, v5
; SI-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; SI-NEXT:    v_lshlrev_b32_e32 v23, 24, v9
; SI-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; SI-NEXT:    v_lshlrev_b32_e32 v13, 24, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; SI-NEXT:    v_lshlrev_b32_e32 v9, 24, v17
; SI-NEXT:    s_cbranch_scc0 .LBB71_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v20
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v21
; SI-NEXT:    v_or_b32_e32 v0, v0, v26
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v4, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v10
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v12
; SI-NEXT:    v_or_b32_e32 v0, v0, v18
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_or_b32_e32 v6, v0, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v14
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v16
; SI-NEXT:    v_or_b32_e32 v0, v0, v11
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xff, v22
; SI-NEXT:    v_and_b32_e32 v3, 0xff, v8
; SI-NEXT:    v_or_b32_e32 v7, v0, v1
; SI-NEXT:    s_and_b32 s4, s28, 0xff
; SI-NEXT:    s_lshl_b32 s5, s29, 8
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v19
; SI-NEXT:    v_or_b32_e32 v2, v2, v24
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_or_b32_e32 v3, v23, v3
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v5, v2, v3
; SI-NEXT:    v_or_b32_e32 v3, s4, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xff
; SI-NEXT:    s_lshl_b32 s5, s5, 16
; SI-NEXT:    s_lshl_b32 s6, s19, 24
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s22, 0xff
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_lshl_b32 s7, s23, 24
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s26, 0xff
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_lshl_b32 s8, s27, 24
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    s_cbranch_execnz .LBB71_3
; SI-NEXT:  .LBB71_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xff
; SI-NEXT:    s_lshl_b32 s5, s17, 8
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s6, s18, 0xff
; SI-NEXT:    s_addk_i32 s4, 0x300
; SI-NEXT:    s_lshl_b32 s5, s19, 24
; SI-NEXT:    s_lshl_b32 s6, s6, 16
; SI-NEXT:    s_and_b32 s4, s4, 0xffff
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s20, 0xff
; SI-NEXT:    s_lshl_b32 s6, s21, 8
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s7, s22, 0xff
; SI-NEXT:    s_addk_i32 s5, 0x300
; SI-NEXT:    s_lshl_b32 s6, s23, 24
; SI-NEXT:    s_lshl_b32 s7, s7, 16
; SI-NEXT:    s_and_b32 s5, s5, 0xffff
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s24, 0xff
; SI-NEXT:    s_lshl_b32 s7, s25, 8
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s8, s26, 0xff
; SI-NEXT:    s_addk_i32 s6, 0x300
; SI-NEXT:    s_lshl_b32 s7, s27, 24
; SI-NEXT:    s_lshl_b32 s8, s8, 16
; SI-NEXT:    s_and_b32 s6, s6, 0xffff
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s28, 0xff
; SI-NEXT:    s_lshl_b32 s8, s29, 8
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v19
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    s_addk_i32 s7, 0x300
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_and_b32 s7, s7, 0xffff
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v0, s7, v0
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v20
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v21
; SI-NEXT:    v_or_b32_e32 v0, v26, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v4, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v22
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v8
; SI-NEXT:    v_or_b32_e32 v0, v24, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v23, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v10
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v12
; SI-NEXT:    v_or_b32_e32 v0, v18, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v13, v1
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x3000000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xff, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v16
; SI-NEXT:    v_or_b32_e32 v0, v11, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xff, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x300, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v1, v9, v1
; SI-NEXT:    s_add_i32 s4, s4, 0x3000000
; SI-NEXT:    s_add_i32 s5, s5, 0x3000000
; SI-NEXT:    s_add_i32 s6, s6, 0x3000000
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x3000000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:  .LBB71_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB71_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB71_2
;
; VI-LABEL: bitcast_v32i8_to_v4i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; VI-NEXT:    v_mov_b32_e32 v22, v6
; VI-NEXT:    v_mov_b32_e32 v21, v4
; VI-NEXT:    v_mov_b32_e32 v20, v2
; VI-NEXT:    v_mov_b32_e32 v19, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_lshlrev_b32_e32 v27, 8, v1
; VI-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; VI-NEXT:    v_lshlrev_b32_e32 v25, 8, v5
; VI-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; VI-NEXT:    v_lshlrev_b32_e32 v23, 8, v9
; VI-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; VI-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; VI-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; VI-NEXT:    v_lshlrev_b32_e32 v9, 8, v17
; VI-NEXT:    s_cbranch_scc0 .LBB71_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_or_b32_sdwa v0, v20, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v21, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v10, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s28, 0xff
; VI-NEXT:    s_lshl_b32 s5, s29, 8
; VI-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v14, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v16, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    v_or_b32_sdwa v2, v22, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v8, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v19, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, s4, v0
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_or_b32 s5, s5, s6
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_or_b32 s7, s7, s8
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_or_b32 s6, s6, s7
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:    s_cbranch_execnz .LBB71_3
; VI-NEXT:  .LBB71_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xff
; VI-NEXT:    s_lshl_b32 s5, s17, 8
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s18, 0xff
; VI-NEXT:    s_lshl_b32 s6, s19, 8
; VI-NEXT:    s_addk_i32 s4, 0x300
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s5, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s20, 0xff
; VI-NEXT:    s_lshl_b32 s6, s21, 8
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s22, 0xff
; VI-NEXT:    s_lshl_b32 s7, s23, 8
; VI-NEXT:    s_addk_i32 s5, 0x300
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_or_b32 s5, s6, s5
; VI-NEXT:    s_and_b32 s6, s24, 0xff
; VI-NEXT:    s_lshl_b32 s7, s25, 8
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s26, 0xff
; VI-NEXT:    s_lshl_b32 s8, s27, 8
; VI-NEXT:    s_addk_i32 s6, 0x300
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_and_b32 s6, s6, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_or_b32 s6, s7, s6
; VI-NEXT:    s_and_b32 s7, s28, 0xff
; VI-NEXT:    s_lshl_b32 s8, s29, 8
; VI-NEXT:    s_or_b32 s7, s8, s7
; VI-NEXT:    s_addk_i32 s7, 0x300
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v19
; VI-NEXT:    s_and_b32 s7, s7, 0xffff
; VI-NEXT:    v_or_b32_sdwa v0, v27, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_e32 v0, s7, v0
; VI-NEXT:    v_add_u32_e32 v3, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v20
; VI-NEXT:    v_or_b32_sdwa v0, v26, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v21
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v4, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v22
; VI-NEXT:    v_or_b32_sdwa v0, v24, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v5, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v10
; VI-NEXT:    v_or_b32_sdwa v0, v18, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v6, vcc, 0x3000000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v14
; VI-NEXT:    v_or_b32_sdwa v0, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v0, vcc, 0x300, v0
; VI-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; VI-NEXT:    s_add_i32 s4, s4, 0x3000000
; VI-NEXT:    s_add_i32 s5, s5, 0x3000000
; VI-NEXT:    s_add_i32 s6, s6, 0x3000000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v7, vcc, 0x3000000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s6
; VI-NEXT:  .LBB71_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB71_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; VI-NEXT:    s_branch .LBB71_2
;
; GFX9-LABEL: bitcast_v32i8_to_v4i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v18
; GFX9-NEXT:    v_mov_b32_e32 v22, v6
; GFX9-NEXT:    v_mov_b32_e32 v21, v4
; GFX9-NEXT:    v_mov_b32_e32 v20, v2
; GFX9-NEXT:    v_mov_b32_e32 v19, v0
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_lshlrev_b32_e32 v27, 8, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v26, 8, v3
; GFX9-NEXT:    v_lshlrev_b32_e32 v25, 8, v5
; GFX9-NEXT:    v_lshlrev_b32_e32 v24, 8, v7
; GFX9-NEXT:    v_lshlrev_b32_e32 v23, 8, v9
; GFX9-NEXT:    v_lshlrev_b32_e32 v18, 8, v11
; GFX9-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX9-NEXT:    v_lshlrev_b32_e32 v11, 8, v15
; GFX9-NEXT:    v_lshlrev_b32_e32 v9, 8, v17
; GFX9-NEXT:    s_cbranch_scc0 .LBB71_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_or_b32_sdwa v0, v20, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v21, v25 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v10, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s29, 8
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v0, v14, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v1, v16, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    v_or_b32_sdwa v2, v22, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v3, v8, v23 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    v_or_b32_sdwa v0, v19, v27 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:BYTE_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s4, v0
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s19, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s5, s5, 16
; GFX9-NEXT:    s_or_b32 s4, s4, s5
; GFX9-NEXT:    s_and_b32 s5, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s6, s21, 8
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s23, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_or_b32 s5, s5, s6
; GFX9-NEXT:    s_and_b32 s6, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s25, 8
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s27, 8
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s6
; GFX9-NEXT:    s_cbranch_execnz .LBB71_3
; GFX9-NEXT:  .LBB71_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_and_b32 s4, s16, 0xff
; GFX9-NEXT:    s_lshl_b32 s5, s17, 8
; GFX9-NEXT:    s_and_b32 s6, s18, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s19, 8
; GFX9-NEXT:    s_or_b32 s4, s5, s4
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_addk_i32 s4, 0x300
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_and_b32 s4, s4, 0xffff
; GFX9-NEXT:    s_lshl_b32 s6, s6, 16
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_or_b32 s4, s4, s6
; GFX9-NEXT:    s_and_b32 s6, s20, 0xff
; GFX9-NEXT:    s_lshl_b32 s7, s21, 8
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_or_b32 s6, s7, s6
; GFX9-NEXT:    s_and_b32 s7, s22, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s23, 8
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_addk_i32 s6, 0x300
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX9-NEXT:    s_lshl_b32 s7, s7, 16
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_or_b32 s6, s6, s7
; GFX9-NEXT:    s_and_b32 s7, s24, 0xff
; GFX9-NEXT:    s_lshl_b32 s8, s25, 8
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_or_b32 s7, s8, s7
; GFX9-NEXT:    s_and_b32 s8, s26, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s27, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    s_addk_i32 s7, 0x300
; GFX9-NEXT:    s_addk_i32 s8, 0x300
; GFX9-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX9-NEXT:    s_lshl_b32 s8, s8, 16
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_or_b32 s7, s7, s8
; GFX9-NEXT:    s_and_b32 s8, s28, 0xff
; GFX9-NEXT:    s_lshl_b32 s9, s29, 8
; GFX9-NEXT:    s_or_b32 s8, s9, s8
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v19
; GFX9-NEXT:    s_movk_i32 s5, 0x300
; GFX9-NEXT:    s_addk_i32 s8, 0x300
; GFX9-NEXT:    v_or_b32_sdwa v0, v27, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    s_and_b32 s8, s8, 0xffff
; GFX9-NEXT:    v_add_u32_sdwa v0, v0, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_e32 v3, s8, v0
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v20
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v21
; GFX9-NEXT:    v_or_b32_sdwa v0, v26, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v25, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v4, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v22
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v8
; GFX9-NEXT:    v_or_b32_sdwa v0, v24, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v23, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v5, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v12
; GFX9-NEXT:    v_or_b32_sdwa v0, v18, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v13, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v6, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v16
; GFX9-NEXT:    v_or_b32_sdwa v0, v11, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_or_b32_sdwa v1, v9, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-NEXT:    v_add_u32_e32 v0, 0x300, v0
; GFX9-NEXT:    v_add_u32_sdwa v1, v1, s5 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX9-NEXT:    v_or_b32_sdwa v7, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s6
; GFX9-NEXT:    v_mov_b32_e32 v2, s7
; GFX9-NEXT:  .LBB71_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB71_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX9-NEXT:    s_branch .LBB71_2
;
; GFX11-LABEL: bitcast_v32i8_to_v4i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v14
; GFX11-NEXT:    v_dual_mov_b32 v18, v6 :: v_dual_mov_b32 v17, v4
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v15, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v20, 8, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v21, 8, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v14, 8, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v19, 8, v7
; GFX11-NEXT:    v_lshlrev_b32_e32 v9, 8, v9
; GFX11-NEXT:    v_lshlrev_b32_e32 v11, 8, v11
; GFX11-NEXT:    v_lshlrev_b32_e32 v13, 8, v13
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_and_b32 s5, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB71_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_and_b32 s5, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s1, 8
; GFX11-NEXT:    s_and_b32 s7, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s8, s3, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_or_b32 s6, s7, s8
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_lshl_b32 s6, s6, 16
; GFX11-NEXT:    s_lshl_b32 s7, s17, 8
; GFX11-NEXT:    s_or_b32 s5, s5, s6
; GFX11-NEXT:    s_and_b32 s6, s16, 0xff
; GFX11-NEXT:    s_and_b32 s8, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s19, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_or_b32 s7, s8, s9
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v16
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v17
; GFX11-NEXT:    s_and_b32 s6, s6, 0xffff
; GFX11-NEXT:    s_lshl_b32 s7, s7, 16
; GFX11-NEXT:    s_and_b32 s8, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s21, 8
; GFX11-NEXT:    s_or_b32 s6, s6, s7
; GFX11-NEXT:    s_or_b32 s7, s8, s9
; GFX11-NEXT:    s_and_b32 s8, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s23, 8
; GFX11-NEXT:    v_or_b32_e32 v1, v1, v21
; GFX11-NEXT:    v_and_b32_e32 v5, 0xff, v10
; GFX11-NEXT:    v_or_b32_e32 v2, v2, v14
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    s_and_b32 s7, s7, 0xffff
; GFX11-NEXT:    s_lshl_b32 s8, s8, 16
; GFX11-NEXT:    s_and_b32 s9, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s10, s25, 8
; GFX11-NEXT:    s_or_b32 s7, s7, s8
; GFX11-NEXT:    v_and_b32_e32 v0, 0xff, v15
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff, v18
; GFX11-NEXT:    v_and_b32_e32 v4, 0xff, v8
; GFX11-NEXT:    v_and_b32_e32 v6, 0xff, v12
; GFX11-NEXT:    v_or_b32_e32 v5, v5, v11
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_or_b32 s9, s9, s10
; GFX11-NEXT:    s_lshl_b32 s10, s27, 8
; GFX11-NEXT:    s_and_b32 s8, s9, 0xffff
; GFX11-NEXT:    s_and_b32 s9, s26, 0xff
; GFX11-NEXT:    v_or_b32_e32 v3, v3, v19
; GFX11-NEXT:    v_or_b32_e32 v4, v4, v9
; GFX11-NEXT:    v_or_b32_e32 v6, v6, v13
; GFX11-NEXT:    v_and_b32_e32 v22, 0xffff, v5
; GFX11-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-NEXT:    v_mov_b32_e32 v1, s6
; GFX11-NEXT:    v_or_b32_e32 v0, v0, v20
; GFX11-NEXT:    s_or_b32 s9, s9, s10
; GFX11-NEXT:    s_and_b32 s10, s28, 0xff
; GFX11-NEXT:    s_lshl_b32 s9, s9, 16
; GFX11-NEXT:    s_lshl_b32 s11, s29, 8
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX11-NEXT:    s_or_b32 s8, s8, s9
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    s_or_b32 s10, s10, s11
; GFX11-NEXT:    v_or_b32_e32 v6, v3, v7
; GFX11-NEXT:    s_and_b32 s10, s10, 0xffff
; GFX11-NEXT:    v_or_b32_e32 v7, v22, v23
; GFX11-NEXT:    v_dual_mov_b32 v2, s7 :: v_dual_mov_b32 v3, s8
; GFX11-NEXT:    v_or_b32_e32 v4, s10, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, s5
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s4
; GFX11-NEXT:    s_cbranch_vccnz .LBB71_3
; GFX11-NEXT:  .LBB71_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_and_b32 s0, s0, 0xff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 8
; GFX11-NEXT:    s_and_b32 s2, s2, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 8
; GFX11-NEXT:    s_or_b32 s0, s1, s0
; GFX11-NEXT:    s_or_b32 s1, s3, s2
; GFX11-NEXT:    s_addk_i32 s0, 0x300
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_and_b32 s0, s0, 0xffff
; GFX11-NEXT:    s_lshl_b32 s1, s1, 16
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_and_b32 s1, s16, 0xff
; GFX11-NEXT:    s_lshl_b32 s2, s17, 8
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_or_b32 s1, s2, s1
; GFX11-NEXT:    s_and_b32 s2, s18, 0xff
; GFX11-NEXT:    s_lshl_b32 s3, s19, 8
; GFX11-NEXT:    s_addk_i32 s1, 0x300
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_and_b32 s1, s1, 0xffff
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_and_b32 s3, s20, 0xff
; GFX11-NEXT:    s_lshl_b32 s4, s21, 8
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_or_b32 s1, s1, s2
; GFX11-NEXT:    s_or_b32 s2, s4, s3
; GFX11-NEXT:    s_and_b32 s3, s22, 0xff
; GFX11-NEXT:    s_lshl_b32 s4, s23, 8
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v16
; GFX11-NEXT:    s_or_b32 s3, s4, s3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v17
; GFX11-NEXT:    s_addk_i32 s2, 0x300
; GFX11-NEXT:    s_addk_i32 s3, 0x300
; GFX11-NEXT:    s_and_b32 s2, s2, 0xffff
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v18
; GFX11-NEXT:    s_or_b32 s2, s2, s3
; GFX11-NEXT:    v_and_b32_e32 v1, 0xff, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v10
; GFX11-NEXT:    v_and_b32_e32 v2, 0xff, v2
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    v_or_b32_e32 v1, v21, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v12
; GFX11-NEXT:    v_and_b32_e32 v3, 0xff, v3
; GFX11-NEXT:    v_and_b32_e32 v4, 0xff, v4
; GFX11-NEXT:    v_and_b32_e32 v5, 0xff, v5
; GFX11-NEXT:    v_or_b32_e32 v2, v14, v2
; GFX11-NEXT:    s_and_b32 s4, s24, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s25, 8
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x300, v1
; GFX11-NEXT:    s_addk_i32 s4, 0x300
; GFX11-NEXT:    v_and_b32_e32 v6, 0xff, v6
; GFX11-NEXT:    v_or_b32_e32 v3, v19, v3
; GFX11-NEXT:    v_or_b32_e32 v4, v9, v4
; GFX11-NEXT:    v_or_b32_e32 v5, v11, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 0x300, v2
; GFX11-NEXT:    s_and_b32 s3, s4, 0xffff
; GFX11-NEXT:    s_and_b32 s4, s26, 0xff
; GFX11-NEXT:    s_lshl_b32 s5, s27, 8
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v15
; GFX11-NEXT:    s_or_b32 s4, s5, s4
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_or_b32_e32 v6, v13, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 0x300, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 0x300, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 0x300, v5
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-NEXT:    s_addk_i32 s4, 0x300
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 0x300, v6
; GFX11-NEXT:    s_lshl_b32 s4, s4, 16
; GFX11-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; GFX11-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX11-NEXT:    v_and_b32_e32 v8, 0xffff, v5
; GFX11-NEXT:    s_or_b32 s3, s3, s4
; GFX11-NEXT:    v_or_b32_e32 v5, v1, v2
; GFX11-NEXT:    v_dual_mov_b32 v1, s1 :: v_dual_and_b32 v0, 0xff, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX11-NEXT:    v_or_b32_e32 v6, v3, v7
; GFX11-NEXT:    v_mov_b32_e32 v3, s3
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    v_or_b32_e32 v0, v20, v0
; GFX11-NEXT:    s_and_b32 s5, s28, 0xff
; GFX11-NEXT:    s_lshl_b32 s6, s29, 8
; GFX11-NEXT:    v_or_b32_e32 v7, v8, v9
; GFX11-NEXT:    s_or_b32 s5, s6, s5
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0x300, v0
; GFX11-NEXT:    s_addk_i32 s5, 0x300
; GFX11-NEXT:    v_mov_b32_e32 v2, s2
; GFX11-NEXT:    s_and_b32 s5, s5, 0xffff
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; GFX11-NEXT:    v_or_b32_e32 v4, s5, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-NEXT:  .LBB71_3: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB71_4:
; GFX11-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; GFX11-NEXT:    s_branch .LBB71_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <32 x i8> %a, splat (i8 3)
  %a2 = bitcast <32 x i8> %a1 to <4 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <32 x i8> %a to <4 x i64>
  br label %end

end:
  %phi = phi <4 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x i64> %phi
}

define <16 x i16> @bitcast_v4f64_to_v16i16(<4 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v4f64_to_v16i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v17, v7
; SI-NEXT:    v_mov_b32_e32 v16, v6
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v21, v3
; SI-NEXT:    v_mov_b32_e32 v20, v2
; SI-NEXT:    v_mov_b32_e32 v23, v1
; SI-NEXT:    v_mov_b32_e32 v22, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v13, v17, v16, 16
; SI-NEXT:    v_alignbit_b32 v9, v19, v18, 16
; SI-NEXT:    v_alignbit_b32 v5, v21, v20, 16
; SI-NEXT:    v_alignbit_b32 v1, v23, v22, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v21
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v23
; SI-NEXT:  ; %bb.2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB72_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[22:23], v[22:23], 1.0
; SI-NEXT:    v_add_f64 v[20:21], v[20:21], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_alignbit_b32 v13, v17, v16, 16
; SI-NEXT:    v_alignbit_b32 v9, v19, v18, 16
; SI-NEXT:    v_alignbit_b32 v5, v21, v20, 16
; SI-NEXT:    v_alignbit_b32 v1, v23, v22, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v21
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v23
; SI-NEXT:  .LBB72_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v22
; SI-NEXT:    v_mov_b32_e32 v2, v23
; SI-NEXT:    v_mov_b32_e32 v4, v20
; SI-NEXT:    v_mov_b32_e32 v6, v21
; SI-NEXT:    v_mov_b32_e32 v8, v18
; SI-NEXT:    v_mov_b32_e32 v10, v19
; SI-NEXT:    v_mov_b32_e32 v12, v16
; SI-NEXT:    v_mov_b32_e32 v14, v17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v16i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB72_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB72_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v16i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB72_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB72_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v16i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB72_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB72_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define inreg <16 x i16> @bitcast_v4f64_to_v16i16_scalar(<4 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f64_to_v16i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB73_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v0, s22
; SI-NEXT:    v_alignbit_b32 v13, s23, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s20
; SI-NEXT:    v_alignbit_b32 v9, s21, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s18
; SI-NEXT:    v_alignbit_b32 v5, s19, v0, 16
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_alignbit_b32 v1, s17, v0, 16
; SI-NEXT:    s_lshr_b32 s9, s23, 16
; SI-NEXT:    s_lshr_b32 s8, s21, 16
; SI-NEXT:    s_lshr_b32 s7, s19, 16
; SI-NEXT:    s_lshr_b32 s6, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB73_4
; SI-NEXT:  .LBB73_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[22:23], s[16:17], 1.0
; SI-NEXT:    v_add_f64 v[20:21], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], s[22:23], 1.0
; SI-NEXT:    v_add_f64 v[18:19], s[20:21], 1.0
; SI-NEXT:    v_alignbit_b32 v13, v17, v16, 16
; SI-NEXT:    v_alignbit_b32 v9, v19, v18, 16
; SI-NEXT:    v_alignbit_b32 v5, v21, v20, 16
; SI-NEXT:    v_alignbit_b32 v1, v23, v22, 16
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v21
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v23
; SI-NEXT:    s_branch .LBB73_5
; SI-NEXT:  .LBB73_3:
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    s_branch .LBB73_2
; SI-NEXT:  .LBB73_4:
; SI-NEXT:    v_mov_b32_e32 v23, s17
; SI-NEXT:    v_mov_b32_e32 v21, s19
; SI-NEXT:    v_mov_b32_e32 v19, s21
; SI-NEXT:    v_mov_b32_e32 v17, s23
; SI-NEXT:    v_mov_b32_e32 v16, s22
; SI-NEXT:    v_mov_b32_e32 v18, s20
; SI-NEXT:    v_mov_b32_e32 v20, s18
; SI-NEXT:    v_mov_b32_e32 v22, s16
; SI-NEXT:    v_mov_b32_e32 v3, s6
; SI-NEXT:    v_mov_b32_e32 v7, s7
; SI-NEXT:    v_mov_b32_e32 v11, s8
; SI-NEXT:    v_mov_b32_e32 v15, s9
; SI-NEXT:  .LBB73_5: ; %end
; SI-NEXT:    v_mov_b32_e32 v0, v22
; SI-NEXT:    v_mov_b32_e32 v2, v23
; SI-NEXT:    v_mov_b32_e32 v4, v20
; SI-NEXT:    v_mov_b32_e32 v6, v21
; SI-NEXT:    v_mov_b32_e32 v8, v18
; SI-NEXT:    v_mov_b32_e32 v10, v19
; SI-NEXT:    v_mov_b32_e32 v12, v16
; SI-NEXT:    v_mov_b32_e32 v14, v17
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v16i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB73_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB73_4
; VI-NEXT:  .LBB73_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB73_3:
; VI-NEXT:    s_branch .LBB73_2
; VI-NEXT:  .LBB73_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v16i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB73_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB73_4
; GFX9-NEXT:  .LBB73_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB73_3:
; GFX9-NEXT:    s_branch .LBB73_2
; GFX9-NEXT:  .LBB73_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v16i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB73_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB73_4
; GFX11-NEXT:  .LBB73_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], s[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB73_3:
; GFX11-NEXT:    s_branch .LBB73_2
; GFX11-NEXT:  .LBB73_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <16 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <16 x i16>
  br label %end

end:
  %phi = phi <16 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x i16> %phi
}

define <4 x double> @bitcast_v16i16_to_v4f64(<16 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v16i16_to_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v20, v6
; SI-NEXT:    v_mov_b32_e32 v19, v4
; SI-NEXT:    v_mov_b32_e32 v18, v2
; SI-NEXT:    v_mov_b32_e32 v17, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v24, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v22, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v15
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB74_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB74_4
; SI-NEXT:  .LBB74_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB74_3: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v19
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v20
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v14
; SI-NEXT:    v_or_b32_e32 v0, v0, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v24
; SI-NEXT:    v_or_b32_e32 v2, v2, v23
; SI-NEXT:    v_or_b32_e32 v3, v3, v22
; SI-NEXT:    v_or_b32_e32 v4, v4, v21
; SI-NEXT:    v_or_b32_e32 v5, v5, v16
; SI-NEXT:    v_or_b32_e32 v6, v6, v11
; SI-NEXT:    v_or_b32_e32 v7, v7, v9
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB74_2
; SI-NEXT:  .LBB74_4: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v14
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_or_b32_e32 v0, v25, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v24, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v22, v3
; SI-NEXT:    v_or_b32_e32 v4, v21, v4
; SI-NEXT:    v_or_b32_e32 v5, v16, v5
; SI-NEXT:    v_or_b32_e32 v6, v11, v6
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x30000, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 0x30000, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16i16_to_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB74_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v9, 3
; VI-NEXT:    v_add_u16_e32 v8, 3, v7
; VI-NEXT:    v_add_u16_sdwa v7, v7, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_add_u16_e32 v8, 3, v6
; VI-NEXT:    v_add_u16_sdwa v6, v6, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v8, v6
; VI-NEXT:    v_add_u16_e32 v8, 3, v5
; VI-NEXT:    v_add_u16_sdwa v5, v5, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v8, v5
; VI-NEXT:    v_add_u16_e32 v8, 3, v4
; VI-NEXT:    v_add_u16_sdwa v4, v4, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v8, v4
; VI-NEXT:    v_add_u16_e32 v8, 3, v3
; VI-NEXT:    v_add_u16_sdwa v3, v3, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v8, v3
; VI-NEXT:    v_add_u16_e32 v8, 3, v2
; VI-NEXT:    v_add_u16_sdwa v2, v2, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v8, v2
; VI-NEXT:    v_add_u16_e32 v8, 3, v1
; VI-NEXT:    v_add_u16_sdwa v1, v1, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_add_u16_e32 v8, 3, v0
; VI-NEXT:    v_add_u16_sdwa v0, v0, v9 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v8, v0
; VI-NEXT:  .LBB74_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16i16_to_v4f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v4f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB74_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:  .LBB74_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define inreg <4 x double> @bitcast_v16i16_to_v4f64_scalar(<16 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16i16_to_v4f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    v_mov_b32_e32 v8, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; SI-NEXT:    s_cbranch_scc0 .LBB75_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v8
; SI-NEXT:    v_or_b32_e32 v7, v0, v9
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB75_3
; SI-NEXT:  .LBB75_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v8
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v9, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB75_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB75_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB75_2
;
; VI-LABEL: bitcast_v16i16_to_v4f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB75_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB75_3
; VI-NEXT:  .LBB75_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s5, s23, 3
; VI-NEXT:    s_and_b32 s4, s23, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s22, 3
; VI-NEXT:    s_add_i32 s23, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s22, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s21, 3
; VI-NEXT:    s_add_i32 s22, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s21, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s20, 3
; VI-NEXT:    s_add_i32 s21, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s20, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s19, 3
; VI-NEXT:    s_add_i32 s20, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s19, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s18, 3
; VI-NEXT:    s_add_i32 s19, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s18, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s17, 3
; VI-NEXT:    s_add_i32 s18, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s17, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s5, s16, 3
; VI-NEXT:    s_add_i32 s17, s4, 0x30000
; VI-NEXT:    s_and_b32 s4, s16, 0xffff0000
; VI-NEXT:    s_and_b32 s5, s5, 0xffff
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_add_i32 s16, s4, 0x30000
; VI-NEXT:  .LBB75_3: ; %end
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB75_4:
; VI-NEXT:    s_branch .LBB75_2
;
; GFX9-LABEL: bitcast_v16i16_to_v4f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB75_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB75_4
; GFX9-NEXT:  .LBB75_2: ; %cmp.true
; GFX9-NEXT:    v_pk_add_u16 v7, s23, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s22, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s21, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s20, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v0, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB75_3:
; GFX9-NEXT:    s_branch .LBB75_2
; GFX9-NEXT:  .LBB75_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16i16_to_v4f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB75_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB75_4
; GFX11-NEXT:  .LBB75_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_u16 v7, s7, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v6, s6, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v5, s5, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v4, s4, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v2, s2, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v1, s1, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    v_pk_add_u16 v0, s0, 3 op_sel_hi:[1,0]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB75_3:
; GFX11-NEXT:    s_branch .LBB75_2
; GFX11-NEXT:  .LBB75_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <16 x i16> %a, splat (i16 3)
  %a2 = bitcast <16 x i16> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x i16> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define <16 x half> @bitcast_v4f64_to_v16f16(<4 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v4f64_to_v16f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB76_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v8
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v0
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:  .LBB76_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB76_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v20, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v17, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v16, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:  .LBB76_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v22
; SI-NEXT:    v_mov_b32_e32 v1, v23
; SI-NEXT:    v_mov_b32_e32 v2, v21
; SI-NEXT:    v_mov_b32_e32 v3, v20
; SI-NEXT:    v_mov_b32_e32 v4, v19
; SI-NEXT:    v_mov_b32_e32 v5, v17
; SI-NEXT:    v_mov_b32_e32 v6, v18
; SI-NEXT:    v_mov_b32_e32 v7, v16
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v16f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB76_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB76_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v16f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB76_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB76_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v16f16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB76_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB76_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define inreg <16 x half> @bitcast_v4f64_to_v16f16_scalar(<4 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f64_to_v16f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB77_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v0, s16
; SI-NEXT:    s_cbranch_execnz .LBB77_3
; SI-NEXT:  .LBB77_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; SI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v16, 16, v0
; SI-NEXT:    v_lshrrev_b32_e32 v17, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v18, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v19, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v11, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v13, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v15, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v16
; SI-NEXT:  .LBB77_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB77_4:
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_branch .LBB77_2
;
; VI-LABEL: bitcast_v4f64_to_v16f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB77_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB77_4
; VI-NEXT:  .LBB77_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB77_3:
; VI-NEXT:    s_branch .LBB77_2
; VI-NEXT:  .LBB77_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v16f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB77_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB77_4
; GFX9-NEXT:  .LBB77_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB77_3:
; GFX9-NEXT:    s_branch .LBB77_2
; GFX9-NEXT:  .LBB77_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v16f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB77_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB77_4
; GFX11-NEXT:  .LBB77_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], s[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB77_3:
; GFX11-NEXT:    s_branch .LBB77_2
; GFX11-NEXT:  .LBB77_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <16 x half>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <16 x half>
  br label %end

end:
  %phi = phi <16 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x half> %phi
}

define <4 x double> @bitcast_v16f16_to_v4f64(<16 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v16f16_to_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v14
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB78_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB78_4
; SI-NEXT:  .LBB78_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB78_3: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v26
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v24
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v22
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v20
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v18
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v27, v0
; SI-NEXT:    v_or_b32_e32 v1, v25, v1
; SI-NEXT:    v_or_b32_e32 v2, v23, v2
; SI-NEXT:    v_or_b32_e32 v3, v21, v3
; SI-NEXT:    v_or_b32_e32 v4, v19, v4
; SI-NEXT:    v_or_b32_e32 v5, v17, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB78_2
; SI-NEXT:  .LBB78_4: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v25
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v20
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v21
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_or_b32_e32 v3, v3, v4
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v18
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16f16_to_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB78_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v8, 0x200
; VI-NEXT:    v_add_f16_sdwa v9, v7, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v7
; VI-NEXT:    v_or_b32_e32 v7, v7, v9
; VI-NEXT:    v_add_f16_sdwa v9, v6, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v6
; VI-NEXT:    v_or_b32_e32 v6, v6, v9
; VI-NEXT:    v_add_f16_sdwa v9, v5, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v5
; VI-NEXT:    v_or_b32_e32 v5, v5, v9
; VI-NEXT:    v_add_f16_sdwa v9, v4, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v4
; VI-NEXT:    v_or_b32_e32 v4, v4, v9
; VI-NEXT:    v_add_f16_sdwa v9, v3, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v3
; VI-NEXT:    v_or_b32_e32 v3, v3, v9
; VI-NEXT:    v_add_f16_sdwa v9, v2, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v2
; VI-NEXT:    v_or_b32_e32 v2, v2, v9
; VI-NEXT:    v_add_f16_sdwa v9, v1, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v1
; VI-NEXT:    v_add_f16_sdwa v8, v0, v8 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, 0x200, v0
; VI-NEXT:    v_or_b32_e32 v1, v1, v9
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:  .LBB78_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v4f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    s_movk_i32 s6, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s6 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s6 op_sel_hi:[1,0]
; GFX9-NEXT:  ; %bb.2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v4f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB78_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-NEXT:  .LBB78_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define inreg <4 x double> @bitcast_v16f16_to_v4f64_scalar(<16 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v16f16_to_v4f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v23, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v22, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v21, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v20, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v19, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v18, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v17, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v16, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v15, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v14, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v13, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v12, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v11, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v10, s28
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v0
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB79_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v0, v22, v0
; SI-NEXT:    v_or_b32_e32 v1, v20, v1
; SI-NEXT:    v_or_b32_e32 v2, v18, v2
; SI-NEXT:    v_or_b32_e32 v3, v16, v3
; SI-NEXT:    v_or_b32_e32 v4, v14, v4
; SI-NEXT:    v_or_b32_e32 v5, v12, v5
; SI-NEXT:    v_or_b32_e32 v6, v10, v6
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:    s_cbranch_execnz .LBB79_3
; SI-NEXT:  .LBB79_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v20
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v18
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v19
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v1, v3, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v15
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v14
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v12
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v11
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v7, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; SI-NEXT:    v_or_b32_e32 v7, v8, v7
; SI-NEXT:  .LBB79_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB79_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_branch .LBB79_2
;
; VI-LABEL: bitcast_v16f16_to_v4f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB79_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB79_4
; VI-NEXT:  .LBB79_2: ; %cmp.true
; VI-NEXT:    s_lshr_b32 s4, s23, 16
; VI-NEXT:    v_mov_b32_e32 v0, 0x200
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s23, v0
; VI-NEXT:    s_lshr_b32 s4, s22, 16
; VI-NEXT:    v_or_b32_e32 v7, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s22, v0
; VI-NEXT:    s_lshr_b32 s4, s21, 16
; VI-NEXT:    v_or_b32_e32 v6, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s21, v0
; VI-NEXT:    s_lshr_b32 s4, s20, 16
; VI-NEXT:    v_or_b32_e32 v5, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s20, v0
; VI-NEXT:    s_lshr_b32 s4, s19, 16
; VI-NEXT:    v_or_b32_e32 v4, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s19, v0
; VI-NEXT:    s_lshr_b32 s4, s18, 16
; VI-NEXT:    v_or_b32_e32 v3, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, s18, v0
; VI-NEXT:    s_lshr_b32 s4, s17, 16
; VI-NEXT:    v_or_b32_e32 v2, v2, v1
; VI-NEXT:    v_mov_b32_e32 v1, s4
; VI-NEXT:    v_add_f16_sdwa v1, v1, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, s17, v0
; VI-NEXT:    s_lshr_b32 s4, s16, 16
; VI-NEXT:    v_or_b32_e32 v1, v8, v1
; VI-NEXT:    v_mov_b32_e32 v8, s4
; VI-NEXT:    v_add_f16_sdwa v8, v8, v0 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v0, s16, v0
; VI-NEXT:    v_or_b32_e32 v0, v0, v8
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB79_3:
; VI-NEXT:    s_branch .LBB79_2
; VI-NEXT:  .LBB79_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v16f16_to_v4f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB79_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB79_4
; GFX9-NEXT:  .LBB79_2: ; %cmp.true
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x200
; GFX9-NEXT:    v_pk_add_f16 v7, s23, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, s22, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, s21, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s20, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s19, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s18, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s17, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v0, s16, v0 op_sel_hi:[1,0]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB79_3:
; GFX9-NEXT:    s_branch .LBB79_2
; GFX9-NEXT:  .LBB79_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v16f16_to_v4f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB79_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB79_4
; GFX11-NEXT:  .LBB79_2: ; %cmp.true
; GFX11-NEXT:    v_pk_add_f16 v7, 0x200, s7 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v6, 0x200, s6 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v5, 0x200, s5 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v4, 0x200, s4 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v2, 0x200, s2 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v1, 0x200, s1 op_sel_hi:[0,1]
; GFX11-NEXT:    v_pk_add_f16 v0, 0x200, s0 op_sel_hi:[0,1]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB79_3:
; GFX11-NEXT:    s_branch .LBB79_2
; GFX11-NEXT:  .LBB79_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <16 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <16 x half> %a1 to <4 x double>
  br label %end

cmp.false:
  %a3 = bitcast <16 x half> %a to <4 x double>
  br label %end

end:
  %phi = phi <4 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <4 x double> %phi
}

define <16 x bfloat> @bitcast_v4f64_to_v16bf16(<4 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v4f64_to_v16bf16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB80_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v16, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v3
; SI-NEXT:    v_and_b32_e32 v18, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v2
; SI-NEXT:    v_and_b32_e32 v20, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v1
; SI-NEXT:    v_and_b32_e32 v22, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v0
; SI-NEXT:    ; implicit-def: $vgpr0
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:  .LBB80_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB80_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v7
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; SI-NEXT:    v_and_b32_e32 v16, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v3
; SI-NEXT:    v_and_b32_e32 v18, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v2
; SI-NEXT:    v_and_b32_e32 v20, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v1
; SI-NEXT:    v_and_b32_e32 v22, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v0
; SI-NEXT:  .LBB80_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_mov_b32_e32 v0, v23
; SI-NEXT:    v_mov_b32_e32 v1, v22
; SI-NEXT:    v_mov_b32_e32 v2, v21
; SI-NEXT:    v_mov_b32_e32 v3, v20
; SI-NEXT:    v_mov_b32_e32 v4, v19
; SI-NEXT:    v_mov_b32_e32 v5, v18
; SI-NEXT:    v_mov_b32_e32 v6, v17
; SI-NEXT:    v_mov_b32_e32 v7, v16
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v16bf16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB80_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB80_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v16bf16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB80_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB80_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v16bf16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v8
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB80_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB80_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define inreg <16 x bfloat> @bitcast_v4f64_to_v16bf16_scalar(<4 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v4f64_to_v16bf16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    s_cmp_lg_u32 s24, 0
; SI-NEXT:    s_cbranch_scc0 .LBB81_3
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_and_b32 s29, s23, 0xffff0000
; SI-NEXT:    s_lshl_b32 s28, s23, 16
; SI-NEXT:    s_and_b32 s27, s22, 0xffff0000
; SI-NEXT:    s_lshl_b32 s26, s22, 16
; SI-NEXT:    s_and_b32 s25, s21, 0xffff0000
; SI-NEXT:    s_lshl_b32 s24, s21, 16
; SI-NEXT:    s_and_b32 s15, s20, 0xffff0000
; SI-NEXT:    s_lshl_b32 s14, s20, 16
; SI-NEXT:    s_and_b32 s13, s19, 0xffff0000
; SI-NEXT:    s_lshl_b32 s12, s19, 16
; SI-NEXT:    s_and_b32 s11, s18, 0xffff0000
; SI-NEXT:    s_lshl_b32 s10, s18, 16
; SI-NEXT:    s_and_b32 s9, s17, 0xffff0000
; SI-NEXT:    s_lshl_b32 s8, s17, 16
; SI-NEXT:    s_and_b32 s7, s16, 0xffff0000
; SI-NEXT:    s_lshl_b32 s6, s16, 16
; SI-NEXT:    s_cbranch_execnz .LBB81_4
; SI-NEXT:  .LBB81_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; SI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; SI-NEXT:    v_add_f64 v[4:5], s[22:23], 1.0
; SI-NEXT:    v_add_f64 v[6:7], s[20:21], 1.0
; SI-NEXT:    v_and_b32_e32 v15, 0xffff0000, v5
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v5
; SI-NEXT:    v_and_b32_e32 v13, 0xffff0000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v4
; SI-NEXT:    v_and_b32_e32 v11, 0xffff0000, v7
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; SI-NEXT:    v_and_b32_e32 v9, 0xffff0000, v6
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v0
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB81_3:
; SI-NEXT:    ; implicit-def: $sgpr6
; SI-NEXT:    ; implicit-def: $sgpr7
; SI-NEXT:    ; implicit-def: $sgpr8
; SI-NEXT:    ; implicit-def: $sgpr9
; SI-NEXT:    ; implicit-def: $sgpr10
; SI-NEXT:    ; implicit-def: $sgpr11
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $sgpr24
; SI-NEXT:    ; implicit-def: $sgpr25
; SI-NEXT:    ; implicit-def: $sgpr26
; SI-NEXT:    ; implicit-def: $sgpr27
; SI-NEXT:    ; implicit-def: $sgpr28
; SI-NEXT:    ; implicit-def: $sgpr29
; SI-NEXT:    s_branch .LBB81_2
; SI-NEXT:  .LBB81_4:
; SI-NEXT:    v_mov_b32_e32 v15, s29
; SI-NEXT:    v_mov_b32_e32 v14, s28
; SI-NEXT:    v_mov_b32_e32 v13, s27
; SI-NEXT:    v_mov_b32_e32 v12, s26
; SI-NEXT:    v_mov_b32_e32 v11, s25
; SI-NEXT:    v_mov_b32_e32 v10, s24
; SI-NEXT:    v_mov_b32_e32 v9, s15
; SI-NEXT:    v_mov_b32_e32 v8, s14
; SI-NEXT:    v_mov_b32_e32 v7, s13
; SI-NEXT:    v_mov_b32_e32 v6, s12
; SI-NEXT:    v_mov_b32_e32 v5, s11
; SI-NEXT:    v_mov_b32_e32 v4, s10
; SI-NEXT:    v_mov_b32_e32 v3, s9
; SI-NEXT:    v_mov_b32_e32 v2, s8
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v0, s6
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v4f64_to_v16bf16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_cmp_lg_u32 s24, 0
; VI-NEXT:    s_cbranch_scc0 .LBB81_3
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB81_4
; VI-NEXT:  .LBB81_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; VI-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; VI-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; VI-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB81_3:
; VI-NEXT:    s_branch .LBB81_2
; VI-NEXT:  .LBB81_4:
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v4f64_to_v16bf16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_cmp_lg_u32 s24, 0
; GFX9-NEXT:    s_cbranch_scc0 .LBB81_3
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB81_4
; GFX9-NEXT:  .LBB81_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[6:7], s[22:23], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], s[20:21], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], s[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], s[16:17], 1.0
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB81_3:
; GFX9-NEXT:    s_branch .LBB81_2
; GFX9-NEXT:  .LBB81_4:
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v4f64_to_v16bf16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s7, s19
; GFX11-NEXT:    s_mov_b32 s6, s18
; GFX11-NEXT:    s_mov_b32 s5, s17
; GFX11-NEXT:    s_mov_b32 s4, s16
; GFX11-NEXT:    s_cmp_lg_u32 s20, 0
; GFX11-NEXT:    s_mov_b32 s8, 0
; GFX11-NEXT:    s_cbranch_scc0 .LBB81_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s8
; GFX11-NEXT:    s_cbranch_vccnz .LBB81_4
; GFX11-NEXT:  .LBB81_2: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[6:7], s[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], s[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], s[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], s[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB81_3:
; GFX11-NEXT:    s_branch .LBB81_2
; GFX11-NEXT:  .LBB81_4:
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s4 :: v_dual_mov_b32 v5, s5
; GFX11-NEXT:    v_dual_mov_b32 v6, s6 :: v_dual_mov_b32 v7, s7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <4 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <4 x double> %a1 to <16 x bfloat>
  br label %end

cmp.false:
  %a3 = bitcast <4 x double> %a to <16 x bfloat>
  br label %end

end:
  %phi = phi <16 x bfloat> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <16 x bfloat> %phi
}

define <4 x double> @bitcast_v16bf16_to_v4f64(<16 x bfloat> %a, i32 %b) {
; SI-LABEL: bitcast_v16bf16_to_v4f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v16
; SI-NEXT:    v_mul_f32_e32 v26, 1.0, v1
; SI-NEXT:    v_mul_f32_e32 v27, 1.0, v0
; SI-NEXT:    v_mul_f32_e32 v24, 1.0, v3
; SI-NEXT:    v_mul_f32_e32 v25, 1.0, v2
; SI-NEXT:    v_mul_f32_e32 v22, 1.0, v5
; SI-NEXT:    v_mul_f32_e32 v23, 1.0, v4
; SI-NEXT:    v_mul_f32_e32 v20, 1.0, v7
; SI-NEXT:    v_mul_f32_e32 v21, 1.0, v6
; SI-NEXT:    v_mul_f32_e32 v18, 1.0, v9
; SI-NEXT:    v_mul_f32_e32 v19, 1.0, v8
; SI-NEXT:    v_mul_f32_e32 v16, 1.0, v11
; SI-NEXT:    v_mul_f32_e32 v17, 1.0, v10
; SI-NEXT:    v_mul_f32_e32 v10, 1.0, v13
; SI-NEXT:    v_mul_f32_e32 v11, 1.0, v12
; SI-NEXT:    v_mul_f32_e32 v8, 1.0, v15
; SI-NEXT:    v_mul_f32_e32 v9, 1.0, v14
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB82_3
; SI-NEXT:  ; %bb.1: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execnz .LBB82_4
; SI-NEXT:  .LBB82_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB82_3: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v0, 16, v26
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v24
; SI-NEXT:    v_lshrrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_alignbit_b32 v0, v0, v27, 16
; SI-NEXT:    v_alignbit_b32 v1, v1, v25, 16
; SI-NEXT:    v_alignbit_b32 v2, v2, v23, 16
; SI-NEXT:    v_alignbit_b32 v3, v3, v21, 16
; SI-NEXT:    v_alignbit_b32 v4, v4, v19, 16
; SI-NEXT:    v_alignbit_b32 v5, v5, v17, 16
; SI-NEXT:    v_alignbit_b32 v6, v6, v11, 16
; SI-NEXT:    v_alignbit_b32 v7, v7, v9, 16
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB82_2
; SI-NEXT:  .LBB82_4: ; %cmp.true
; SI-NEXT:    v_and_b32_e32 v1, 0xffff0000, v26
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v24
; SI-NEXT:    v_and_b32_e32 v0, 0xffff0000, v27
; SI-NEXT:    v_add_f32_e32 v1, 0x40c00000, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v25
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v0, 0x40c00000, v0
; SI-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_alignbit_b32 v0, v1, v0, 16
; SI-NEXT:    v_alignbit_b32 v1, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v22
; SI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v23
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; SI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v20
; SI-NEXT:    v_alignbit_b32 v2, v3, v2, 16
; SI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v21
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; SI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v18
; SI-NEXT:    v_alignbit_b32 v3, v4, v3, 16
; SI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v19
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; SI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v16
; SI-NEXT:    v_alignbit_b32 v4, v5, v4, 16
; SI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v17
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; SI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v10
; SI-NEXT:    v_alignbit_b32 v5, v6, v5, 16
; SI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v11
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; SI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; SI-NEXT:    v_alignbit_b32 v6, v7, v6, 16
; SI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v9
; SI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; SI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; SI-NEXT:    v_lshrrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_alignbit_b32 v7, v8, v7, 16
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v16bf16_to_v4f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v8
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB82_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v7
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, 0x7fff, v9
; VI-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v7, 0x40c00000, v7
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v7, 16, 1
; VI-NEXT:    s_movk_i32 s6, 0x7fff
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v7
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v7
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; VI-NEXT:    v_cndmask_b32_e32 v7, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v7, 16, v7
; VI-NEXT:    v_alignbit_b32 v7, v7, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v6, 0x40c00000, v6
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v6, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v6
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v6
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; VI-NEXT:    v_cndmask_b32_e32 v6, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_alignbit_b32 v6, v6, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v5, 0x40c00000, v5
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v5, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v5
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v5
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; VI-NEXT:    v_cndmask_b32_e32 v5, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v5, 16, v5
; VI-NEXT:    v_alignbit_b32 v5, v5, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v4, 0x40c00000, v4
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v4, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v4
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v4
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; VI-NEXT:    v_cndmask_b32_e32 v4, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; VI-NEXT:    v_alignbit_b32 v4, v4, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v3, 0x40c00000, v3
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v3, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v3
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v3
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; VI-NEXT:    v_cndmask_b32_e32 v3, v9, v10, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_alignbit_b32 v3, v3, v8, 16
; VI-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; VI-NEXT:    v_add_f32_e32 v8, 0x40c00000, v8
; VI-NEXT:    v_bfe_u32 v9, v8, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v8
; VI-NEXT:    v_add_u32_e32 v9, vcc, s6, v9
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; VI-NEXT:    v_or_b32_e32 v10, 0x400000, v8
; VI-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; VI-NEXT:    v_add_f32_e32 v2, 0x40c00000, v2
; VI-NEXT:    v_cndmask_b32_e32 v8, v9, v10, vcc
; VI-NEXT:    v_bfe_u32 v9, v2, 16, 1
; VI-NEXT:    v_add_u32_e32 v9, vcc, v9, v2
; V