; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+sve    < %s | FileCheck %s -check-prefixes=CHECK,SVE
; RUN: llc -mattr=+sve2p2 < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sve,+sme2p2 < %s | FileCheck %s -check-prefix CHECK-2p2

; RUN: llc -mattr=+sme    -force-streaming < %s | FileCheck %s -check-prefixes=CHECK,STREAMING-SVE
; RUN: llc -mattr=+sme2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sme,+sve2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2

target triple = "aarch64-linux"

define <vscale x 4 x float> @test_scvtf_f32_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_scvtf_f32_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f32_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.f32i64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_scvtf_f32_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_scvtf_f32_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.s, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f32_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.f32i64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_scvtf_f32_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_scvtf_f32_s64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    scvtf z0.s, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f32_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_scvtf_f32_s64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    scvtf z0.s, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.f32i64(<vscale x 4 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_scvtf_f64_s32_x_1(<vscale x 2 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_scvtf_f64_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f64_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.f64i32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_scvtf_f64_s32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_scvtf_f64_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.d, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f64_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.f64i32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_scvtf_f64_s32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_scvtf_f64_s32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    scvtf z0.d, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f64_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_scvtf_f64_s32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    scvtf z0.d, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.f64i32(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_scvtf_f16_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_scvtf_f16_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_scvtf_f16_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_scvtf_f16_s32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    scvtf z0.h, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_scvtf_f16_s32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    scvtf z0.h, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i32(<vscale x 8 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_scvtf_f16_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_scvtf_f16_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.h, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_scvtf_f16_s64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    scvtf z0.h, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_scvtf_f16_s64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    scvtf z0.h, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i64(<vscale x 8 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x float> @test_ucvtf_f32_u64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_ucvtf_f32_u64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f32_u64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.f32i64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_ucvtf_f32_u64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_ucvtf_f32_u64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.s, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f32_u64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.f32i64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_ucvtf_f32_u64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_ucvtf_f32_u64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ucvtf z0.s, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f32_u64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_ucvtf_f32_u64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    ucvtf z0.s, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.f32i64(<vscale x 4 x float> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_ucvtf_f64_u32_x_1(<vscale x 2 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_ucvtf_f64_u32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f64_u32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.f64i32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_ucvtf_f64_u32_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_ucvtf_f64_u32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.d, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f64_u32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.f64i32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_ucvtf_f64_u32_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_ucvtf_f64_u32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ucvtf z0.d, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f64_u32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_ucvtf_f64_u32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    ucvtf z0.d, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.f64i32(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_u32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_ucvtf_f16_u32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_u32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_u32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_ucvtf_f16_u32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_u32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_u32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_ucvtf_f16_u32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ucvtf z0.h, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_u32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_ucvtf_f16_u32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    ucvtf z0.h, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i32(<vscale x 8 x half> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_u64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_ucvtf_f16_u64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_u64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_u64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_ucvtf_f16_u64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.h, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_u64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_u64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_ucvtf_f16_u64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ucvtf z0.h, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_u64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_ucvtf_f16_u64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    ucvtf z0.h, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i64(<vscale x 8 x half> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcvt_f16_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.nxv8f16.nxv8i16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcvt_f16_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    scvtf z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.nxv8f16.nxv8i16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; SVE-LABEL: test_svcvt_f16_s16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    scvtf z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f16_s16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    scvtf z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.nxv8f16.nxv8i16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_u16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcvt_f16_u16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_u16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.nxv8f16.nxv8i16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_u16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svcvt_f16_u16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ucvtf z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_u16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.nxv8f16.nxv8i16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_svcvt_f16_u16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; SVE-LABEL: test_svcvt_f16_u16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ucvtf z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f16_u16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f16_u16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    ucvtf z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.nxv8f16.nxv8i16(<vscale x 8 x half> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x float> @test_svcvt_f32_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcvt_f32_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.nxv4f32.nxv4i32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcvt_f32_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    scvtf z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.nxv4f32.nxv4i32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svcvt_f32_s32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    scvtf z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f32_s32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    scvtf z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.nxv4f32.nxv4i32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_u32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcvt_f32_u32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_u32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.nxv4f32.nxv4i32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_u32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svcvt_f32_u32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ucvtf z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_u32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.nxv4f32.nxv4i32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_svcvt_f32_u32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svcvt_f32_u32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ucvtf z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f32_u32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f32_u32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    ucvtf z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.nxv4f32.nxv4i32(<vscale x 4 x float> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_svcvt_f64_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcvt_f64_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.nxv2f64.nxv2i64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcvt_f64_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    scvtf z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.nxv2f64.nxv2i64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_svcvt_f64_s64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    scvtf z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f64_s64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    scvtf z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.nxv2f64.nxv2i64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_u64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcvt_f64_u64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_u64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.nxv2f64.nxv2i64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_u64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svcvt_f64_u64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ucvtf z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_u64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.nxv2f64.nxv2i64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_svcvt_f64_u64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_svcvt_f64_u64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ucvtf z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svcvt_f64_u64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svcvt_f64_u64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    ucvtf z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.nxv2f64.nxv2i64(<vscale x 2 x double> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 4 x float> @test_scvtf_f32_i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_scvtf_f32_i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f32_i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.f32i64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_scvtf_f32_i64_ptrue(double %z0,<vscale x 4 x float> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_scvtf_f32_i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f32_i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.f32i64(<vscale x 4 x float> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_scvtf_f64_i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_scvtf_f64_i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f64_i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.f64i32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_scvtf_f64_i32_ptrue(double %z0,<vscale x 2 x double> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_scvtf_f64_i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f64_i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.f64i32(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_scvtf_f16_i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_scvtf_f16_i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    scvtf z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_i32_ptrue(double %z0,<vscale x 8 x half> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_scvtf_f16_i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    scvtf z0.h, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i32(<vscale x 8 x half> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_scvtf_f16_i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.h, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_f16_i64_ptrue(double %z0,<vscale x 8 x half> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_scvtf_f16_i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.h, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_f16_i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.f16i64(<vscale x 8 x half> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x float> @test_ucvtf_f32_i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_ucvtf_f32_i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f32_i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.f32i64(<vscale x 4 x float> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_ucvtf_f32_i64_ptrue(double %z0,<vscale x 4 x float> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_ucvtf_f32_i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f32_i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.f32i64(<vscale x 4 x float> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_ucvtf_f64_i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_ucvtf_f64_i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f64_i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.f64i32(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_ucvtf_f64_i32_ptrue(double %z0,<vscale x 2 x double> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_ucvtf_f64_i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f64_i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.f64i32(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 2 x double> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_ucvtf_f16_i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ucvtf z0.h, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i32(<vscale x 8 x half> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_i32_ptrue(double %z0,<vscale x 8 x half> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_ucvtf_f16_i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ucvtf z0.h, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i32(<vscale x 8 x half> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_ucvtf_f16_i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.h, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i64(<vscale x 8 x half> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_f16_i64_ptrue(double %z0,<vscale x 8 x half> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_ucvtf_f16_i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.h, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_f16_i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.f16i64(<vscale x 8 x half> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_nxv8f16_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_scvtf_nxv8f16_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    scvtf z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_nxv8f16_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.nxv8f16.nxv8i16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_scvtf_nxv8f16_nxv8i16_ptrue(double %z0,<vscale x 8 x half> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_scvtf_nxv8f16_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    scvtf z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_nxv8f16_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    scvtf z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.scvtf.nxv8f16.nxv8i16(<vscale x 8 x half> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_nxv8f16_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_ucvtf_nxv8f16_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ucvtf z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_nxv8f16_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.nxv8f16.nxv8i16(<vscale x 8 x half> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x half> %0
}

define <vscale x 8 x half> @test_ucvtf_nxv8f16_nxv8i16_ptrue(double %z0,<vscale x 8 x half> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_ucvtf_nxv8f16_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    ucvtf z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_nxv8f16_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    ucvtf z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x half> @llvm.aarch64.sve.ucvtf.nxv8f16.nxv8i16(<vscale x 8 x half> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x half> %0
}

define <vscale x 4 x float> @test_scvtf_nxv4f32_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_scvtf_nxv4f32_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    scvtf z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_nxv4f32_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.nxv4f32.nxv4i32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_scvtf_nxv4f32_nxv4i32_ptrue(double %z0,<vscale x 4 x float> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_scvtf_nxv4f32_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    scvtf z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_nxv4f32_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    scvtf z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.scvtf.nxv4f32.nxv4i32(<vscale x 4 x float> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_ucvtf_nxv4f32_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_ucvtf_nxv4f32_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ucvtf z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_nxv4f32_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.nxv4f32.nxv4i32(<vscale x 4 x float> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x float> %0
}

define <vscale x 4 x float> @test_ucvtf_nxv4f32_nxv4i32_ptrue(double %z0,<vscale x 4 x float> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_ucvtf_nxv4f32_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    ucvtf z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_nxv4f32_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    ucvtf z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x float> @llvm.aarch64.sve.ucvtf.nxv4f32.nxv4i32(<vscale x 4 x float> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x float> %0
}

define <vscale x 2 x double> @test_scvtf_nxv2f64_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_scvtf_nxv2f64_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    scvtf z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_nxv2f64_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.nxv2f64.nxv2i64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_scvtf_nxv2f64_nxv2i64_ptrue(double %z0,<vscale x 2 x double> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_scvtf_nxv2f64_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    scvtf z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_scvtf_nxv2f64_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    scvtf z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.scvtf.nxv2f64.nxv2i64(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_ucvtf_nxv2f64_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_ucvtf_nxv2f64_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ucvtf z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_nxv2f64_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.nxv2f64.nxv2i64(<vscale x 2 x double> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x double> %0
}

define <vscale x 2 x double> @test_ucvtf_nxv2f64_nxv2i64_ptrue(double %z0,<vscale x 2 x double> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_ucvtf_nxv2f64_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    ucvtf z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_ucvtf_nxv2f64_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    ucvtf z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x double> @llvm.aarch64.sve.ucvtf.nxv2f64.nxv2i64(<vscale x 2 x double> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x double> %0
}

