; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64 -verify-machineinstrs %s -o - 2>&1 | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc -mtriple=aarch64 -global-isel -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i16 @sext_i8_to_i16(i8 %a) {
; CHECK-LABEL: sext_i8_to_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxtb w0, w0
; CHECK-NEXT:    ret
entry:
  %c = sext i8 %a to i16
  ret i16 %c
}

define i32 @sext_i8_to_i32(i8 %a) {
; CHECK-LABEL: sext_i8_to_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxtb w0, w0
; CHECK-NEXT:    ret
entry:
  %c = sext i8 %a to i32
  ret i32 %c
}

define i64 @sext_i8_to_i64(i8 %a) {
; CHECK-LABEL: sext_i8_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    sxtb x0, w0
; CHECK-NEXT:    ret
entry:
  %c = sext i8 %a to i64
  ret i64 %c
}

define i10 @sext_i8_to_i10(i8 %a) {
; CHECK-LABEL: sext_i8_to_i10:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxtb w0, w0
; CHECK-NEXT:    ret
entry:
  %c = sext i8 %a to i10
  ret i10 %c
}

define i32 @sext_i16_to_i32(i16 %a) {
; CHECK-LABEL: sext_i16_to_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sxth w0, w0
; CHECK-NEXT:    ret
entry:
  %c = sext i16 %a to i32
  ret i32 %c
}

define i64 @sext_i16_to_i64(i16 %a) {
; CHECK-LABEL: sext_i16_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    sxth x0, w0
; CHECK-NEXT:    ret
entry:
  %c = sext i16 %a to i64
  ret i64 %c
}

define i64 @sext_i32_to_i64(i32 %a) {
; CHECK-LABEL: sext_i32_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    sxtw x0, w0
; CHECK-NEXT:    ret
entry:
  %c = sext i32 %a to i64
  ret i64 %c
}

define i16 @sext_i10_to_i16(i10 %a) {
; CHECK-LABEL: sext_i10_to_i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sbfx w0, w0, #0, #10
; CHECK-NEXT:    ret
entry:
  %c = sext i10 %a to i16
  ret i16 %c
}

define i32 @sext_i10_to_i32(i10 %a) {
; CHECK-LABEL: sext_i10_to_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sbfx w0, w0, #0, #10
; CHECK-NEXT:    ret
entry:
  %c = sext i10 %a to i32
  ret i32 %c
}

define i64 @sext_i10_to_i64(i10 %a) {
; CHECK-LABEL: sext_i10_to_i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-NEXT:    sbfx x0, x0, #0, #10
; CHECK-NEXT:    ret
entry:
  %c = sext i10 %a to i64
  ret i64 %c
}

define <2 x i16> @sext_v2i8_v2i16(<2 x i8> %a) {
; CHECK-LABEL: sext_v2i8_v2i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i8> %a to <2 x i16>
  ret <2 x i16> %c
}

define <2 x i32> @sext_v2i8_v2i32(<2 x i8> %a) {
; CHECK-LABEL: sext_v2i8_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #24
; CHECK-NEXT:    sshr v0.2s, v0.2s, #24
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i8> %a to <2 x i32>
  ret <2 x i32> %c
}

define <2 x i64> @sext_v2i8_v2i64(<2 x i8> %a) {
; CHECK-LABEL: sext_v2i8_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    shl v0.2d, v0.2d, #56
; CHECK-NEXT:    sshr v0.2d, v0.2d, #56
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i8> %a to <2 x i64>
  ret <2 x i64> %c
}

define <2 x i32> @sext_v2i16_v2i32(<2 x i16> %a) {
; CHECK-LABEL: sext_v2i16_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #16
; CHECK-NEXT:    sshr v0.2s, v0.2s, #16
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i16> %a to <2 x i32>
  ret <2 x i32> %c
}

define <2 x i64> @sext_v2i16_v2i64(<2 x i16> %a) {
; CHECK-LABEL: sext_v2i16_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    shl v0.2d, v0.2d, #48
; CHECK-NEXT:    sshr v0.2d, v0.2d, #48
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i16> %a to <2 x i64>
  ret <2 x i64> %c
}

define <2 x i64> @sext_v2i32_v2i64(<2 x i32> %a) {
; CHECK-LABEL: sext_v2i32_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i32> %a to <2 x i64>
  ret <2 x i64> %c
}

define <2 x i16> @sext_v2i10_v2i16(<2 x i10> %a) {
; CHECK-LABEL: sext_v2i10_v2i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #22
; CHECK-NEXT:    sshr v0.2s, v0.2s, #22
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i10> %a to <2 x i16>
  ret <2 x i16> %c
}

define <2 x i32> @sext_v2i10_v2i32(<2 x i10> %a) {
; CHECK-LABEL: sext_v2i10_v2i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.2s, v0.2s, #22
; CHECK-NEXT:    sshr v0.2s, v0.2s, #22
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i10> %a to <2 x i32>
  ret <2 x i32> %c
}

define <2 x i64> @sext_v2i10_v2i64(<2 x i10> %a) {
; CHECK-LABEL: sext_v2i10_v2i64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    shl v0.2d, v0.2d, #54
; CHECK-NEXT:    sshr v0.2d, v0.2d, #54
; CHECK-NEXT:    ret
entry:
  %c = sext <2 x i10> %a to <2 x i64>
  ret <2 x i64> %c
}

define <3 x i16> @sext_v3i8_v3i16(<3 x i8> %a) {
; CHECK-SD-LABEL: sext_v3i8_v3i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    mov v0.h[1], w1
; CHECK-SD-NEXT:    mov v0.h[2], w2
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i8_v3i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    lsl w8, w0, #8
; CHECK-GI-NEXT:    lsl w9, w1, #8
; CHECK-GI-NEXT:    sbfx w8, w8, #8, #8
; CHECK-GI-NEXT:    sbfx w9, w9, #8, #8
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    lsl w8, w2, #8
; CHECK-GI-NEXT:    sbfx w8, w8, #8, #8
; CHECK-GI-NEXT:    mov v0.h[1], w9
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i8> %a to <3 x i16>
  ret <3 x i16> %c
}

define <3 x i32> @sext_v3i8_v3i32(<3 x i8> %a) {
; CHECK-SD-LABEL: sext_v3i8_v3i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    mov v0.h[1], w1
; CHECK-SD-NEXT:    mov v0.h[2], w2
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #24
; CHECK-SD-NEXT:    sshr v0.4s, v0.4s, #24
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i8_v3i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sxtb w8, w0
; CHECK-GI-NEXT:    sxtb w9, w1
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    sxtb w8, w2
; CHECK-GI-NEXT:    mov v0.s[1], w9
; CHECK-GI-NEXT:    mov v0.s[2], w8
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i8> %a to <3 x i32>
  ret <3 x i32> %c
}

define <3 x i64> @sext_v3i8_v3i64(<3 x i8> %a) {
; CHECK-SD-LABEL: sext_v3i8_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    fmov s1, w2
; CHECK-SD-NEXT:    mov v0.s[1], w1
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    shl v2.2d, v1.2d, #56
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshr v2.2d, v2.2d, #56
; CHECK-SD-NEXT:    shl v0.2d, v0.2d, #56
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    sshr v0.2d, v0.2d, #56
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i8_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-GI-NEXT:    // kill: def $w2 killed $w2 def $x2
; CHECK-GI-NEXT:    sxtb x8, w0
; CHECK-GI-NEXT:    sxtb x9, w1
; CHECK-GI-NEXT:    sxtb x10, w2
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    fmov d1, x9
; CHECK-GI-NEXT:    fmov d2, x10
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i8> %a to <3 x i64>
  ret <3 x i64> %c
}

define <3 x i32> @sext_v3i16_v3i32(<3 x i16> %a) {
; CHECK-SD-LABEL: sext_v3i16_v3i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i16_v3i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    smov w8, v0.h[0]
; CHECK-GI-NEXT:    smov w9, v0.h[1]
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    smov w8, v0.h[2]
; CHECK-GI-NEXT:    mov v1.s[1], w9
; CHECK-GI-NEXT:    mov v1.s[2], w8
; CHECK-GI-NEXT:    mov v0.16b, v1.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i16> %a to <3 x i32>
  ret <3 x i32> %c
}

define <3 x i64> @sext_v3i16_v3i64(<3 x i16> %a) {
; CHECK-SD-LABEL: sext_v3i16_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v2.2d, v2.4s, #0
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i16_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-GI-NEXT:    smov x8, v0.h[0]
; CHECK-GI-NEXT:    smov x9, v0.h[1]
; CHECK-GI-NEXT:    smov x10, v0.h[2]
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    fmov d1, x9
; CHECK-GI-NEXT:    fmov d2, x10
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i16> %a to <3 x i64>
  ret <3 x i64> %c
}

define <3 x i64> @sext_v3i32_v3i64(<3 x i32> %a) {
; CHECK-SD-LABEL: sext_v3i32_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v3.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll2 v2.2d, v0.4s, #0
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    fmov d0, d3
; CHECK-SD-NEXT:    ext v1.16b, v3.16b, v3.16b, #8
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i32_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    smov x8, v0.s[0]
; CHECK-GI-NEXT:    smov x9, v0.s[1]
; CHECK-GI-NEXT:    smov x10, v0.s[2]
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    fmov d1, x9
; CHECK-GI-NEXT:    fmov d2, x10
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i32> %a to <3 x i64>
  ret <3 x i64> %c
}

define <3 x i16> @sext_v3i10_v3i16(<3 x i10> %a) {
; CHECK-SD-LABEL: sext_v3i10_v3i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    mov v0.h[1], w1
; CHECK-SD-NEXT:    mov v0.h[2], w2
; CHECK-SD-NEXT:    shl v0.4h, v0.4h, #6
; CHECK-SD-NEXT:    sshr v0.4h, v0.4h, #6
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i10_v3i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    lsl w8, w0, #6
; CHECK-GI-NEXT:    lsl w9, w1, #6
; CHECK-GI-NEXT:    sbfx w8, w8, #6, #10
; CHECK-GI-NEXT:    sbfx w9, w9, #6, #10
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    lsl w8, w2, #6
; CHECK-GI-NEXT:    sbfx w8, w8, #6, #10
; CHECK-GI-NEXT:    mov v0.h[1], w9
; CHECK-GI-NEXT:    mov v0.h[2], w8
; CHECK-GI-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i10> %a to <3 x i16>
  ret <3 x i16> %c
}

define <3 x i32> @sext_v3i10_v3i32(<3 x i10> %a) {
; CHECK-SD-LABEL: sext_v3i10_v3i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    mov v0.h[1], w1
; CHECK-SD-NEXT:    mov v0.h[2], w2
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #22
; CHECK-SD-NEXT:    sshr v0.4s, v0.4s, #22
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i10_v3i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sbfx w8, w0, #0, #10
; CHECK-GI-NEXT:    sbfx w9, w1, #0, #10
; CHECK-GI-NEXT:    fmov s0, w8
; CHECK-GI-NEXT:    sbfx w8, w2, #0, #10
; CHECK-GI-NEXT:    mov v0.s[1], w9
; CHECK-GI-NEXT:    mov v0.s[2], w8
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i10> %a to <3 x i32>
  ret <3 x i32> %c
}

define <3 x i64> @sext_v3i10_v3i64(<3 x i10> %a) {
; CHECK-SD-LABEL: sext_v3i10_v3i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    fmov s1, w2
; CHECK-SD-NEXT:    mov v0.s[1], w1
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    shl v2.2d, v1.2d, #54
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshr v2.2d, v2.2d, #54
; CHECK-SD-NEXT:    shl v0.2d, v0.2d, #54
; CHECK-SD-NEXT:    // kill: def $d2 killed $d2 killed $q2
; CHECK-SD-NEXT:    sshr v0.2d, v0.2d, #54
; CHECK-SD-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-SD-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-SD-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v3i10_v3i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    // kill: def $w0 killed $w0 def $x0
; CHECK-GI-NEXT:    // kill: def $w1 killed $w1 def $x1
; CHECK-GI-NEXT:    // kill: def $w2 killed $w2 def $x2
; CHECK-GI-NEXT:    sbfx x8, x0, #0, #10
; CHECK-GI-NEXT:    sbfx x9, x1, #0, #10
; CHECK-GI-NEXT:    sbfx x10, x2, #0, #10
; CHECK-GI-NEXT:    fmov d0, x8
; CHECK-GI-NEXT:    fmov d1, x9
; CHECK-GI-NEXT:    fmov d2, x10
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <3 x i10> %a to <3 x i64>
  ret <3 x i64> %c
}

define <4 x i16> @sext_v4i8_v4i16(<4 x i8> %a) {
; CHECK-LABEL: sext_v4i8_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.4h, v0.4h, #8
; CHECK-NEXT:    sshr v0.4h, v0.4h, #8
; CHECK-NEXT:    ret
entry:
  %c = sext <4 x i8> %a to <4 x i16>
  ret <4 x i16> %c
}

define <4 x i32> @sext_v4i8_v4i32(<4 x i8> %a) {
; CHECK-LABEL: sext_v4i8_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    shl v0.4s, v0.4s, #24
; CHECK-NEXT:    sshr v0.4s, v0.4s, #24
; CHECK-NEXT:    ret
entry:
  %c = sext <4 x i8> %a to <4 x i32>
  ret <4 x i32> %c
}

define <4 x i64> @sext_v4i8_v4i64(<4 x i8> %a) {
; CHECK-SD-LABEL: sext_v4i8_v4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    shl v0.2d, v0.2d, #56
; CHECK-SD-NEXT:    shl v2.2d, v1.2d, #56
; CHECK-SD-NEXT:    sshr v1.2d, v0.2d, #56
; CHECK-SD-NEXT:    sshr v0.2d, v2.2d, #56
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v4i8_v4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    shl v1.2d, v1.2d, #56
; CHECK-GI-NEXT:    shl v2.2d, v0.2d, #56
; CHECK-GI-NEXT:    sshr v0.2d, v1.2d, #56
; CHECK-GI-NEXT:    sshr v1.2d, v2.2d, #56
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <4 x i8> %a to <4 x i64>
  ret <4 x i64> %c
}

define <4 x i32> @sext_v4i16_v4i32(<4 x i16> %a) {
; CHECK-LABEL: sext_v4i16_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
entry:
  %c = sext <4 x i16> %a to <4 x i32>
  ret <4 x i32> %c
}

define <4 x i64> @sext_v4i16_v4i64(<4 x i16> %a) {
; CHECK-SD-LABEL: sext_v4i16_v4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v4i16_v4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <4 x i16> %a to <4 x i64>
  ret <4 x i64> %c
}

define <4 x i64> @sext_v4i32_v4i64(<4 x i32> %a) {
; CHECK-SD-LABEL: sext_v4i32_v4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v1.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v4i32_v4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v0.4s, #0
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <4 x i32> %a to <4 x i64>
  ret <4 x i64> %c
}

define <4 x i16> @sext_v4i10_v4i16(<4 x i10> %a) {
; CHECK-LABEL: sext_v4i10_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.4h, v0.4h, #6
; CHECK-NEXT:    sshr v0.4h, v0.4h, #6
; CHECK-NEXT:    ret
entry:
  %c = sext <4 x i10> %a to <4 x i16>
  ret <4 x i16> %c
}

define <4 x i32> @sext_v4i10_v4i32(<4 x i10> %a) {
; CHECK-LABEL: sext_v4i10_v4i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    shl v0.4s, v0.4s, #22
; CHECK-NEXT:    sshr v0.4s, v0.4s, #22
; CHECK-NEXT:    ret
entry:
  %c = sext <4 x i10> %a to <4 x i32>
  ret <4 x i32> %c
}

define <4 x i64> @sext_v4i10_v4i64(<4 x i10> %a) {
; CHECK-SD-LABEL: sext_v4i10_v4i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    shl v0.2d, v0.2d, #54
; CHECK-SD-NEXT:    shl v2.2d, v1.2d, #54
; CHECK-SD-NEXT:    sshr v1.2d, v0.2d, #54
; CHECK-SD-NEXT:    sshr v0.2d, v2.2d, #54
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v4i10_v4i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    shl v1.2d, v1.2d, #54
; CHECK-GI-NEXT:    shl v2.2d, v0.2d, #54
; CHECK-GI-NEXT:    sshr v0.2d, v1.2d, #54
; CHECK-GI-NEXT:    sshr v1.2d, v2.2d, #54
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <4 x i10> %a to <4 x i64>
  ret <4 x i64> %c
}

define <8 x i16> @sext_v8i8_v8i16(<8 x i8> %a) {
; CHECK-LABEL: sext_v8i8_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-NEXT:    ret
entry:
  %c = sext <8 x i8> %a to <8 x i16>
  ret <8 x i16> %c
}

define <8 x i32> @sext_v8i8_v8i32(<8 x i8> %a) {
; CHECK-SD-LABEL: sext_v8i8_v8i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v8i8_v8i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll v0.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <8 x i8> %a to <8 x i32>
  ret <8 x i32> %c
}

define <8 x i64> @sext_v8i8_v8i64(<8 x i8> %a) {
; CHECK-SD-LABEL: sext_v8i8_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v8i8_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <8 x i8> %a to <8 x i64>
  ret <8 x i64> %c
}

define <8 x i32> @sext_v8i16_v8i32(<8 x i16> %a) {
; CHECK-SD-LABEL: sext_v8i16_v8i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v8i16_v8i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v0.8h, #0
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <8 x i16> %a to <8 x i32>
  ret <8 x i32> %c
}

define <8 x i64> @sext_v8i16_v8i64(<8 x i16> %a) {
; CHECK-SD-LABEL: sext_v8i16_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v2.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v8i16_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <8 x i16> %a to <8 x i64>
  ret <8 x i64> %c
}

define <8 x i64> @sext_v8i32_v8i64(<8 x i32> %a) {
; CHECK-SD-LABEL: sext_v8i32_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v5.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll2 v4.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v1.2s, #0
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v8i32_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v4.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v1.4s, #0
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <8 x i32> %a to <8 x i64>
  ret <8 x i64> %c
}

define <8 x i16> @sext_v8i10_v8i16(<8 x i10> %a) {
; CHECK-LABEL: sext_v8i10_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    shl v0.8h, v0.8h, #6
; CHECK-NEXT:    sshr v0.8h, v0.8h, #6
; CHECK-NEXT:    ret
entry:
  %c = sext <8 x i10> %a to <8 x i16>
  ret <8 x i16> %c
}

define <8 x i32> @sext_v8i10_v8i32(<8 x i10> %a) {
; CHECK-SD-LABEL: sext_v8i10_v8i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #22
; CHECK-SD-NEXT:    shl v2.4s, v1.4s, #22
; CHECK-SD-NEXT:    sshr v1.4s, v0.4s, #22
; CHECK-SD-NEXT:    sshr v0.4s, v2.4s, #22
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v8i10_v8i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    shl v1.4s, v1.4s, #22
; CHECK-GI-NEXT:    shl v2.4s, v0.4s, #22
; CHECK-GI-NEXT:    sshr v0.4s, v1.4s, #22
; CHECK-GI-NEXT:    sshr v1.4s, v2.4s, #22
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <8 x i10> %a to <8 x i32>
  ret <8 x i32> %c
}

define <8 x i64> @sext_v8i10_v8i64(<8 x i10> %a) {
; CHECK-SD-LABEL: sext_v8i10_v8i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-SD-NEXT:    ushll v2.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll v3.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-SD-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-SD-NEXT:    shl v2.2d, v2.2d, #54
; CHECK-SD-NEXT:    shl v1.2d, v1.2d, #54
; CHECK-SD-NEXT:    shl v5.2d, v3.2d, #54
; CHECK-SD-NEXT:    shl v4.2d, v0.2d, #54
; CHECK-SD-NEXT:    sshr v0.2d, v2.2d, #54
; CHECK-SD-NEXT:    sshr v1.2d, v1.2d, #54
; CHECK-SD-NEXT:    sshr v2.2d, v5.2d, #54
; CHECK-SD-NEXT:    sshr v3.2d, v4.2d, #54
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v8i10_v8i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ushll v1.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-GI-NEXT:    ushll v2.2d, v1.2s, #0
; CHECK-GI-NEXT:    ushll2 v1.2d, v1.4s, #0
; CHECK-GI-NEXT:    ushll v3.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll2 v0.2d, v0.4s, #0
; CHECK-GI-NEXT:    shl v2.2d, v2.2d, #54
; CHECK-GI-NEXT:    shl v1.2d, v1.2d, #54
; CHECK-GI-NEXT:    shl v3.2d, v3.2d, #54
; CHECK-GI-NEXT:    shl v4.2d, v0.2d, #54
; CHECK-GI-NEXT:    sshr v0.2d, v2.2d, #54
; CHECK-GI-NEXT:    sshr v1.2d, v1.2d, #54
; CHECK-GI-NEXT:    sshr v2.2d, v3.2d, #54
; CHECK-GI-NEXT:    sshr v3.2d, v4.2d, #54
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <8 x i10> %a to <8 x i64>
  ret <8 x i64> %c
}

define <16 x i16> @sext_v16i8_v16i16(<16 x i8> %a) {
; CHECK-SD-LABEL: sext_v16i8_v16i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v1.8h, v0.16b, #0
; CHECK-SD-NEXT:    sshll v0.8h, v0.8b, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i8_v16i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll2 v1.8h, v0.16b, #0
; CHECK-GI-NEXT:    mov v0.16b, v2.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i8> %a to <16 x i16>
  ret <16 x i16> %c
}

define <16 x i32> @sext_v16i8_v16i32(<16 x i8> %a) {
; CHECK-SD-LABEL: sext_v16i8_v16i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-SD-NEXT:    sshll2 v2.8h, v0.16b, #0
; CHECK-SD-NEXT:    sshll v0.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v2.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i8_v16i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll2 v3.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v0.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v1.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v2.4s, v3.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v3.8h, #0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i8> %a to <16 x i32>
  ret <16 x i32> %c
}

define <16 x i64> @sext_v16i8_v16i64(<16 x i8> %a) {
; CHECK-SD-LABEL: sext_v16i8_v16i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-SD-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-SD-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll2 v4.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v6.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i8_v16i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v1.8h, v0.8b, #0
; CHECK-GI-NEXT:    sshll2 v0.8h, v0.16b, #0
; CHECK-GI-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v7.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i8> %a to <16 x i64>
  ret <16 x i64> %c
}

define <16 x i32> @sext_v16i16_v16i32(<16 x i16> %a) {
; CHECK-SD-LABEL: sext_v16i16_v16i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v5.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v4.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll2 v3.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-SD-NEXT:    mov v0.16b, v5.16b
; CHECK-SD-NEXT:    mov v1.16b, v4.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i16_v16i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v4.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v5.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v2.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v1.8h, #0
; CHECK-GI-NEXT:    mov v0.16b, v4.16b
; CHECK-GI-NEXT:    mov v1.16b, v5.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i16> %a to <16 x i32>
  ret <16 x i32> %c
}

define <16 x i64> @sext_v16i16_v16i64(<16 x i16> %a) {
; CHECK-SD-LABEL: sext_v16i16_v16i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-SD-NEXT:    sshll2 v4.4s, v0.8h, #0
; CHECK-SD-NEXT:    sshll v5.4s, v1.4h, #0
; CHECK-SD-NEXT:    sshll2 v6.4s, v1.8h, #0
; CHECK-SD-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v3.2d, v4.4s, #0
; CHECK-SD-NEXT:    sshll v2.2d, v4.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v6.4s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i16_v16i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v2.4s, v0.4h, #0
; CHECK-GI-NEXT:    sshll2 v3.4s, v0.8h, #0
; CHECK-GI-NEXT:    sshll v5.4s, v1.4h, #0
; CHECK-GI-NEXT:    sshll2 v7.4s, v1.8h, #0
; CHECK-GI-NEXT:    sshll v0.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v1.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v2.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v3.2d, v3.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v5.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v5.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v7.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v7.4s, #0
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i16> %a to <16 x i64>
  ret <16 x i64> %c
}

define <16 x i64> @sext_v16i32_v16i64(<16 x i32> %a) {
; CHECK-SD-LABEL: sext_v16i32_v16i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    sshll2 v17.2d, v0.4s, #0
; CHECK-SD-NEXT:    sshll2 v16.2d, v1.4s, #0
; CHECK-SD-NEXT:    sshll v18.2d, v1.2s, #0
; CHECK-SD-NEXT:    sshll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    sshll v4.2d, v2.2s, #0
; CHECK-SD-NEXT:    sshll2 v5.2d, v2.4s, #0
; CHECK-SD-NEXT:    sshll2 v7.2d, v3.4s, #0
; CHECK-SD-NEXT:    sshll v6.2d, v3.2s, #0
; CHECK-SD-NEXT:    mov v1.16b, v17.16b
; CHECK-SD-NEXT:    mov v2.16b, v18.16b
; CHECK-SD-NEXT:    mov v3.16b, v16.16b
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i32_v16i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    sshll v16.2d, v0.2s, #0
; CHECK-GI-NEXT:    sshll2 v17.2d, v0.4s, #0
; CHECK-GI-NEXT:    sshll v18.2d, v1.2s, #0
; CHECK-GI-NEXT:    sshll2 v19.2d, v1.4s, #0
; CHECK-GI-NEXT:    sshll v4.2d, v2.2s, #0
; CHECK-GI-NEXT:    sshll2 v5.2d, v2.4s, #0
; CHECK-GI-NEXT:    sshll v6.2d, v3.2s, #0
; CHECK-GI-NEXT:    sshll2 v7.2d, v3.4s, #0
; CHECK-GI-NEXT:    mov v0.16b, v16.16b
; CHECK-GI-NEXT:    mov v1.16b, v17.16b
; CHECK-GI-NEXT:    mov v2.16b, v18.16b
; CHECK-GI-NEXT:    mov v3.16b, v19.16b
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i32> %a to <16 x i64>
  ret <16 x i64> %c
}

define <16 x i16> @sext_v16i10_v16i16(<16 x i10> %a) {
; CHECK-SD-LABEL: sext_v16i10_v16i16:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr w8, [sp]
; CHECK-SD-NEXT:    fmov s1, w0
; CHECK-SD-NEXT:    ldr w9, [sp, #8]
; CHECK-SD-NEXT:    fmov s0, w8
; CHECK-SD-NEXT:    ldr w8, [sp, #16]
; CHECK-SD-NEXT:    mov v1.h[1], w1
; CHECK-SD-NEXT:    mov v0.h[1], w9
; CHECK-SD-NEXT:    mov v1.h[2], w2
; CHECK-SD-NEXT:    mov v0.h[2], w8
; CHECK-SD-NEXT:    ldr w8, [sp, #24]
; CHECK-SD-NEXT:    mov v1.h[3], w3
; CHECK-SD-NEXT:    mov v0.h[3], w8
; CHECK-SD-NEXT:    ldr w8, [sp, #32]
; CHECK-SD-NEXT:    mov v1.h[4], w4
; CHECK-SD-NEXT:    mov v0.h[4], w8
; CHECK-SD-NEXT:    ldr w8, [sp, #40]
; CHECK-SD-NEXT:    mov v1.h[5], w5
; CHECK-SD-NEXT:    mov v0.h[5], w8
; CHECK-SD-NEXT:    ldr w8, [sp, #48]
; CHECK-SD-NEXT:    mov v1.h[6], w6
; CHECK-SD-NEXT:    mov v0.h[6], w8
; CHECK-SD-NEXT:    ldr w8, [sp, #56]
; CHECK-SD-NEXT:    mov v1.h[7], w7
; CHECK-SD-NEXT:    mov v0.h[7], w8
; CHECK-SD-NEXT:    shl v1.8h, v1.8h, #6
; CHECK-SD-NEXT:    shl v2.8h, v0.8h, #6
; CHECK-SD-NEXT:    sshr v0.8h, v1.8h, #6
; CHECK-SD-NEXT:    sshr v1.8h, v2.8h, #6
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i10_v16i16:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [sp]
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    ldr w9, [sp, #8]
; CHECK-GI-NEXT:    fmov s1, w8
; CHECK-GI-NEXT:    ldr w8, [sp, #16]
; CHECK-GI-NEXT:    mov v0.h[1], w1
; CHECK-GI-NEXT:    mov v1.h[1], w9
; CHECK-GI-NEXT:    mov v0.h[2], w2
; CHECK-GI-NEXT:    mov v1.h[2], w8
; CHECK-GI-NEXT:    ldr w8, [sp, #24]
; CHECK-GI-NEXT:    mov v0.h[3], w3
; CHECK-GI-NEXT:    mov v1.h[3], w8
; CHECK-GI-NEXT:    ldr w8, [sp, #32]
; CHECK-GI-NEXT:    mov v0.h[4], w4
; CHECK-GI-NEXT:    mov v1.h[4], w8
; CHECK-GI-NEXT:    ldr w8, [sp, #40]
; CHECK-GI-NEXT:    mov v0.h[5], w5
; CHECK-GI-NEXT:    mov v1.h[5], w8
; CHECK-GI-NEXT:    ldr w8, [sp, #48]
; CHECK-GI-NEXT:    mov v0.h[6], w6
; CHECK-GI-NEXT:    mov v1.h[6], w8
; CHECK-GI-NEXT:    ldr w8, [sp, #56]
; CHECK-GI-NEXT:    mov v0.h[7], w7
; CHECK-GI-NEXT:    mov v1.h[7], w8
; CHECK-GI-NEXT:    shl v0.8h, v0.8h, #6
; CHECK-GI-NEXT:    shl v1.8h, v1.8h, #6
; CHECK-GI-NEXT:    sshr v0.8h, v0.8h, #6
; CHECK-GI-NEXT:    sshr v1.8h, v1.8h, #6
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i10> %a to <16 x i16>
  ret <16 x i16> %c
}

define <16 x i32> @sext_v16i10_v16i32(<16 x i10> %a) {
; CHECK-SD-LABEL: sext_v16i10_v16i32:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    ldr w8, [sp, #32]
; CHECK-SD-NEXT:    ldr w9, [sp]
; CHECK-SD-NEXT:    fmov s0, w0
; CHECK-SD-NEXT:    fmov s1, w4
; CHECK-SD-NEXT:    ldr w10, [sp, #40]
; CHECK-SD-NEXT:    ldr w11, [sp, #8]
; CHECK-SD-NEXT:    fmov s2, w9
; CHECK-SD-NEXT:    fmov s3, w8
; CHECK-SD-NEXT:    ldr w8, [sp, #48]
; CHECK-SD-NEXT:    mov v0.h[1], w1
; CHECK-SD-NEXT:    ldr w9, [sp, #16]
; CHECK-SD-NEXT:    mov v1.h[1], w5
; CHECK-SD-NEXT:    mov v2.h[1], w11
; CHECK-SD-NEXT:    mov v3.h[1], w10
; CHECK-SD-NEXT:    mov v0.h[2], w2
; CHECK-SD-NEXT:    mov v1.h[2], w6
; CHECK-SD-NEXT:    mov v2.h[2], w9
; CHECK-SD-NEXT:    mov v3.h[2], w8
; CHECK-SD-NEXT:    ldr w8, [sp, #56]
; CHECK-SD-NEXT:    ldr w9, [sp, #24]
; CHECK-SD-NEXT:    mov v0.h[3], w3
; CHECK-SD-NEXT:    mov v1.h[3], w7
; CHECK-SD-NEXT:    mov v2.h[3], w9
; CHECK-SD-NEXT:    mov v3.h[3], w8
; CHECK-SD-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-SD-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-SD-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-SD-NEXT:    ushll v3.4s, v3.4h, #0
; CHECK-SD-NEXT:    shl v0.4s, v0.4s, #22
; CHECK-SD-NEXT:    shl v1.4s, v1.4s, #22
; CHECK-SD-NEXT:    shl v2.4s, v2.4s, #22
; CHECK-SD-NEXT:    shl v3.4s, v3.4s, #22
; CHECK-SD-NEXT:    sshr v0.4s, v0.4s, #22
; CHECK-SD-NEXT:    sshr v1.4s, v1.4s, #22
; CHECK-SD-NEXT:    sshr v2.4s, v2.4s, #22
; CHECK-SD-NEXT:    sshr v3.4s, v3.4s, #22
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i10_v16i32:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    ldr w8, [sp]
; CHECK-GI-NEXT:    ldr w9, [sp, #32]
; CHECK-GI-NEXT:    fmov s0, w0
; CHECK-GI-NEXT:    fmov s1, w4
; CHECK-GI-NEXT:    ldr w10, [sp, #8]
; CHECK-GI-NEXT:    ldr w11, [sp, #40]
; CHECK-GI-NEXT:    fmov s2, w8
; CHECK-GI-NEXT:    fmov s3, w9
; CHECK-GI-NEXT:    ldr w8, [sp, #16]
; CHECK-GI-NEXT:    mov v0.h[1], w1
; CHECK-GI-NEXT:    ldr w9, [sp, #48]
; CHECK-GI-NEXT:    mov v1.h[1], w5
; CHECK-GI-NEXT:    mov v2.h[1], w10
; CHECK-GI-NEXT:    mov v3.h[1], w11
; CHECK-GI-NEXT:    mov v0.h[2], w2
; CHECK-GI-NEXT:    mov v1.h[2], w6
; CHECK-GI-NEXT:    mov v2.h[2], w8
; CHECK-GI-NEXT:    mov v3.h[2], w9
; CHECK-GI-NEXT:    ldr w8, [sp, #24]
; CHECK-GI-NEXT:    ldr w9, [sp, #56]
; CHECK-GI-NEXT:    mov v0.h[3], w3
; CHECK-GI-NEXT:    mov v1.h[3], w7
; CHECK-GI-NEXT:    mov v2.h[3], w8
; CHECK-GI-NEXT:    mov v3.h[3], w9
; CHECK-GI-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-GI-NEXT:    ushll v1.4s, v1.4h, #0
; CHECK-GI-NEXT:    ushll v2.4s, v2.4h, #0
; CHECK-GI-NEXT:    ushll v3.4s, v3.4h, #0
; CHECK-GI-NEXT:    shl v0.4s, v0.4s, #22
; CHECK-GI-NEXT:    shl v1.4s, v1.4s, #22
; CHECK-GI-NEXT:    shl v2.4s, v2.4s, #22
; CHECK-GI-NEXT:    shl v3.4s, v3.4s, #22
; CHECK-GI-NEXT:    sshr v0.4s, v0.4s, #22
; CHECK-GI-NEXT:    sshr v1.4s, v1.4s, #22
; CHECK-GI-NEXT:    sshr v2.4s, v2.4s, #22
; CHECK-GI-NEXT:    sshr v3.4s, v3.4s, #22
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i10> %a to <16 x i32>
  ret <16 x i32> %c
}

define <16 x i64> @sext_v16i10_v16i64(<16 x i10> %a) {
; CHECK-SD-LABEL: sext_v16i10_v16i64:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    fmov s0, w2
; CHECK-SD-NEXT:    fmov s1, w0
; CHECK-SD-NEXT:    ldr s2, [sp]
; CHECK-SD-NEXT:    fmov s3, w4
; CHECK-SD-NEXT:    fmov s4, w6
; CHECK-SD-NEXT:    add x8, sp, #8
; CHECK-SD-NEXT:    ldr s5, [sp, #16]
; CHECK-SD-NEXT:    ldr s6, [sp, #32]
; CHECK-SD-NEXT:    ldr s7, [sp, #48]
; CHECK-SD-NEXT:    mov v1.s[1], w1
; CHECK-SD-NEXT:    mov v0.s[1], w3
; CHECK-SD-NEXT:    ld1 { v2.s }[1], [x8]
; CHECK-SD-NEXT:    mov v3.s[1], w5
; CHECK-SD-NEXT:    mov v4.s[1], w7
; CHECK-SD-NEXT:    add x8, sp, #24
; CHECK-SD-NEXT:    add x9, sp, #40
; CHECK-SD-NEXT:    add x10, sp, #56
; CHECK-SD-NEXT:    ld1 { v5.s }[1], [x8]
; CHECK-SD-NEXT:    ld1 { v6.s }[1], [x9]
; CHECK-SD-NEXT:    ld1 { v7.s }[1], [x10]
; CHECK-SD-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-SD-NEXT:    ushll v1.2d, v1.2s, #0
; CHECK-SD-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-SD-NEXT:    ushll v3.2d, v3.2s, #0
; CHECK-SD-NEXT:    ushll v4.2d, v4.2s, #0
; CHECK-SD-NEXT:    ushll v5.2d, v5.2s, #0
; CHECK-SD-NEXT:    ushll v6.2d, v6.2s, #0
; CHECK-SD-NEXT:    ushll v7.2d, v7.2s, #0
; CHECK-SD-NEXT:    shl v17.2d, v2.2d, #54
; CHECK-SD-NEXT:    shl v1.2d, v1.2d, #54
; CHECK-SD-NEXT:    shl v16.2d, v0.2d, #54
; CHECK-SD-NEXT:    shl v3.2d, v3.2d, #54
; CHECK-SD-NEXT:    shl v4.2d, v4.2d, #54
; CHECK-SD-NEXT:    shl v5.2d, v5.2d, #54
; CHECK-SD-NEXT:    shl v6.2d, v6.2d, #54
; CHECK-SD-NEXT:    shl v7.2d, v7.2d, #54
; CHECK-SD-NEXT:    sshr v0.2d, v1.2d, #54
; CHECK-SD-NEXT:    sshr v1.2d, v16.2d, #54
; CHECK-SD-NEXT:    sshr v2.2d, v3.2d, #54
; CHECK-SD-NEXT:    sshr v3.2d, v4.2d, #54
; CHECK-SD-NEXT:    sshr v4.2d, v17.2d, #54
; CHECK-SD-NEXT:    sshr v5.2d, v5.2d, #54
; CHECK-SD-NEXT:    sshr v6.2d, v6.2d, #54
; CHECK-SD-NEXT:    sshr v7.2d, v7.2d, #54
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v16i10_v16i64:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    fmov s7, w0
; CHECK-GI-NEXT:    fmov s17, w2
; CHECK-GI-NEXT:    ldr s0, [sp]
; CHECK-GI-NEXT:    fmov s18, w4
; CHECK-GI-NEXT:    fmov s19, w6
; CHECK-GI-NEXT:    ldr s1, [sp, #8]
; CHECK-GI-NEXT:    ldr s2, [sp, #16]
; CHECK-GI-NEXT:    ldr s3, [sp, #24]
; CHECK-GI-NEXT:    ldr s4, [sp, #32]
; CHECK-GI-NEXT:    ldr s5, [sp, #40]
; CHECK-GI-NEXT:    ldr s6, [sp, #48]
; CHECK-GI-NEXT:    ldr s16, [sp, #56]
; CHECK-GI-NEXT:    mov v7.s[1], w1
; CHECK-GI-NEXT:    mov v17.s[1], w3
; CHECK-GI-NEXT:    mov v18.s[1], w5
; CHECK-GI-NEXT:    mov v19.s[1], w7
; CHECK-GI-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-GI-NEXT:    mov v2.s[1], v3.s[0]
; CHECK-GI-NEXT:    mov v4.s[1], v5.s[0]
; CHECK-GI-NEXT:    mov v6.s[1], v16.s[0]
; CHECK-GI-NEXT:    ushll v1.2d, v7.2s, #0
; CHECK-GI-NEXT:    ushll v3.2d, v17.2s, #0
; CHECK-GI-NEXT:    ushll v5.2d, v18.2s, #0
; CHECK-GI-NEXT:    ushll v7.2d, v19.2s, #0
; CHECK-GI-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-GI-NEXT:    ushll v2.2d, v2.2s, #0
; CHECK-GI-NEXT:    ushll v4.2d, v4.2s, #0
; CHECK-GI-NEXT:    ushll v6.2d, v6.2s, #0
; CHECK-GI-NEXT:    shl v1.2d, v1.2d, #54
; CHECK-GI-NEXT:    shl v3.2d, v3.2d, #54
; CHECK-GI-NEXT:    shl v5.2d, v5.2d, #54
; CHECK-GI-NEXT:    shl v7.2d, v7.2d, #54
; CHECK-GI-NEXT:    shl v16.2d, v0.2d, #54
; CHECK-GI-NEXT:    shl v17.2d, v2.2d, #54
; CHECK-GI-NEXT:    shl v18.2d, v4.2d, #54
; CHECK-GI-NEXT:    shl v19.2d, v6.2d, #54
; CHECK-GI-NEXT:    sshr v0.2d, v1.2d, #54
; CHECK-GI-NEXT:    sshr v1.2d, v3.2d, #54
; CHECK-GI-NEXT:    sshr v2.2d, v5.2d, #54
; CHECK-GI-NEXT:    sshr v3.2d, v7.2d, #54
; CHECK-GI-NEXT:    sshr v4.2d, v16.2d, #54
; CHECK-GI-NEXT:    sshr v5.2d, v17.2d, #54
; CHECK-GI-NEXT:    sshr v6.2d, v18.2d, #54
; CHECK-GI-NEXT:    sshr v7.2d, v19.2d, #54
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <16 x i10> %a to <16 x i64>
  ret <16 x i64> %c
}

define <2 x i128> @sext_v2i64_v2i128(<2 x i64> %a) {
; CHECK-SD-LABEL: sext_v2i64_v2i128:
; CHECK-SD:       // %bb.0: // %entry
; CHECK-SD-NEXT:    mov x2, v0.d[1]
; CHECK-SD-NEXT:    fmov x0, d0
; CHECK-SD-NEXT:    asr x1, x0, #63
; CHECK-SD-NEXT:    asr x3, x2, #63
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: sext_v2i64_v2i128:
; CHECK-GI:       // %bb.0: // %entry
; CHECK-GI-NEXT:    mov d1, v0.d[1]
; CHECK-GI-NEXT:    fmov x8, d0
; CHECK-GI-NEXT:    fmov x0, d0
; CHECK-GI-NEXT:    asr x1, x8, #63
; CHECK-GI-NEXT:    fmov x9, d1
; CHECK-GI-NEXT:    fmov x2, d1
; CHECK-GI-NEXT:    asr x3, x9, #63
; CHECK-GI-NEXT:    ret
entry:
  %c = sext <2 x i64> %a to <2 x i128>
  ret <2 x i128> %c
}
