; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s  -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=arm64-apple-ios -mcpu=cyclone | FileCheck %s

target datalayout = "e-p:32:32:32-i1:8:32-i8:8:32-i16:16:32-i32:32:32-i64:32:64-f32:32:32-f64:32:64-v64:32:64-v128:32:128-a0:0:32-n32-S32"

define void @op() {
  ; Logical and/or - select's cost must be equivalent to that of binop
; CHECK-LABEL: 'op'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %sand = select i1 undef, i1 undef, i1 false
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %band = and i1 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %sor = select i1 undef, i1 true, i1 undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bor = or i1 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %sand = select i1 undef, i1 undef, i1 false
  %band = and i1 undef, undef
  %sor = select i1 undef, i1 true, i1 undef
  %bor = or i1 undef, undef

  ret void
}

define void @vecop() {
; CHECK-LABEL: 'vecop'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %sand = select <4 x i1> undef, <4 x i1> undef, <4 x i1> zeroinitializer
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %band = and <4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %sor = select <4 x i1> undef, <4 x i1> splat (i1 true), <4 x i1> undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bor = or <4 x i1> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %sand = select <4 x i1> undef, <4 x i1> undef, <4 x i1> <i1 false, i1 false, i1 false, i1 false>
  %band = and <4 x i1> undef, undef
  %sor = select <4 x i1> undef, <4 x i1> <i1 true, i1 true, i1 true, i1 true>, <4 x i1> undef
  %bor = or <4 x i1> undef, undef

  ret void
}
