# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-x280 -iterations=1 < %s | FileCheck %s

vsetvli zero, zero, e32, m1, tu, mu

vlse8.v  v1, (a1), a2
vlse16.v v1, (a1), a2
vlse32.v v1, (a1), a2
vlse64.v v1, (a1), a2

vlse8.v  v1, (a1), zero
vlse16.v v1, (a1), zero
vlse32.v v1, (a1), zero
vlse64.v v1, (a1), zero

vle8.v  v1, (a1)
vle16.v v1, (a1)
vle32.v v1, (a1)
vle64.v v1, (a1)

vsetvli zero, zero, e64, m1, tu, mu

vlse8.v  v1, (a1), a2
vlse16.v v1, (a1), a2
vlse32.v v1, (a1), a2
vlse64.v v1, (a1), a2

vlse8.v  v1, (a1), zero
vlse16.v v1, (a1), zero
vlse32.v v1, (a1), zero
vlse64.v v1, (a1), zero

vle8.v  v1, (a1)
vle16.v v1, (a1)
vle32.v v1, (a1)
vle64.v v1, (a1)

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      26
# CHECK-NEXT: Total Cycles:      234
# CHECK-NEXT: Total uOps:        26

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.11
# CHECK-NEXT: IPC:               0.11
# CHECK-NEXT: Block RThroughput: 229.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      19    16.00   *                   vlse8.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                   vlse16.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                   vlse32.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                   vlse64.v	v1, (a1), a2
# CHECK-NEXT:  1      19    16.00   *                   vlse8.v	v1, (a1), zero
# CHECK-NEXT:  1      19    16.00   *                   vlse16.v	v1, (a1), zero
# CHECK-NEXT:  1      19    16.00   *                   vlse32.v	v1, (a1), zero
# CHECK-NEXT:  1      19    16.00   *                   vlse64.v	v1, (a1), zero
# CHECK-NEXT:  1      4     1.00    *                   vle8.v	v1, (a1)
# CHECK-NEXT:  1      4     1.00    *                   vle16.v	v1, (a1)
# CHECK-NEXT:  1      4     2.00    *                   vle32.v	v1, (a1)
# CHECK-NEXT:  1      4     4.00    *                   vle64.v	v1, (a1)
# CHECK-NEXT:  1      3     1.00                  U     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      11    8.00    *                   vlse8.v	v1, (a1), a2
# CHECK-NEXT:  1      11    8.00    *                   vlse16.v	v1, (a1), a2
# CHECK-NEXT:  1      11    8.00    *                   vlse32.v	v1, (a1), a2
# CHECK-NEXT:  1      11    8.00    *                   vlse64.v	v1, (a1), a2
# CHECK-NEXT:  1      11    8.00    *                   vlse8.v	v1, (a1), zero
# CHECK-NEXT:  1      11    8.00    *                   vlse16.v	v1, (a1), zero
# CHECK-NEXT:  1      11    8.00    *                   vlse32.v	v1, (a1), zero
# CHECK-NEXT:  1      11    8.00    *                   vlse64.v	v1, (a1), zero
# CHECK-NEXT:  1      4     1.00    *                   vle8.v	v1, (a1)
# CHECK-NEXT:  1      4     1.00    *                   vle16.v	v1, (a1)
# CHECK-NEXT:  1      4     1.00    *                   vle32.v	v1, (a1)
# CHECK-NEXT:  1      4     2.00    *                   vle64.v	v1, (a1)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - VLEN512SiFive7FDiv
# CHECK-NEXT: [1]   - VLEN512SiFive7IDiv
# CHECK-NEXT: [2]   - VLEN512SiFive7PipeA
# CHECK-NEXT: [3]   - VLEN512SiFive7PipeB
# CHECK-NEXT: [4]   - VLEN512SiFive7VA
# CHECK-NEXT: [5]   - VLEN512SiFive7VCQ
# CHECK-NEXT: [6]   - VLEN512SiFive7VL
# CHECK-NEXT: [7]   - VLEN512SiFive7VS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]
# CHECK-NEXT:  -      -     2.00    -      -     24.00  229.00  -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse8.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse16.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse32.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse64.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse8.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse16.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse32.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   17.00   -     vlse64.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   2.00    -     vle8.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -     1.00   2.00    -     vle16.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -     1.00   3.00    -     vle32.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -     1.00   5.00    -     vle64.v	v1, (a1)
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -     vsetvli	zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse8.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse16.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse32.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse64.v	v1, (a1), a2
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse8.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse16.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse32.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   9.00    -     vlse64.v	v1, (a1), zero
# CHECK-NEXT:  -      -      -      -      -     1.00   2.00    -     vle8.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -     1.00   2.00    -     vle16.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -     1.00   2.00    -     vle32.v	v1, (a1)
# CHECK-NEXT:  -      -      -      -      -     1.00   3.00    -     vle64.v	v1, (a1)
