; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -passes=gvn 2>&1 | FileCheck %s --check-prefixes=CHECK,MDEP
; RUN: opt < %s -S -passes='gvn<memoryssa;no-memdep>' 2>&1 | FileCheck --check-prefixes=CHECK,MSSA %s

target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128"

declare noalias ptr @malloc(i64) nounwind allockind("alloc,uninitialized") allocsize(0) inaccessiblememonly
declare noalias ptr @calloc(i64, i64) allockind("alloc,zeroed") allocsize(0,1) inaccessiblememonly
declare noalias ptr @_Znwm(i64)
declare void @escape(ptr)

define i8 @test_malloc(ptr %p) {
; MDEP-LABEL: @test_malloc(
; MDEP-NEXT:    [[OBJ:%.*]] = call ptr @malloc(i64 16)
; MDEP-NEXT:    call void @escape(ptr [[OBJ]])
; MDEP-NEXT:    ret i8 0
;
; MSSA-LABEL: @test_malloc(
; MSSA-NEXT:    [[V1:%.*]] = load i8, ptr [[P:%.*]], align 1
; MSSA-NEXT:    [[OBJ:%.*]] = call ptr @malloc(i64 16)
; MSSA-NEXT:    [[V2:%.*]] = load i8, ptr [[P]], align 1
; MSSA-NEXT:    [[SUB:%.*]] = sub i8 [[V1]], [[V2]]
; MSSA-NEXT:    call void @escape(ptr [[OBJ]])
; MSSA-NEXT:    ret i8 [[SUB]]
;
  %v1 = load i8, ptr %p
  %obj = call ptr @malloc(i64 16)
  %v2 = load i8, ptr %p
  %sub = sub i8 %v1, %v2
  call void @escape(ptr %obj)
  ret i8 %sub
}

define i8 @test_calloc(ptr %p) {
; MDEP-LABEL: @test_calloc(
; MDEP-NEXT:    [[OBJ:%.*]] = call ptr @calloc(i64 1, i64 16)
; MDEP-NEXT:    call void @escape(ptr [[OBJ]])
; MDEP-NEXT:    ret i8 0
;
; MSSA-LABEL: @test_calloc(
; MSSA-NEXT:    [[V1:%.*]] = load i8, ptr [[P:%.*]], align 1
; MSSA-NEXT:    [[OBJ:%.*]] = call ptr @calloc(i64 1, i64 16)
; MSSA-NEXT:    [[V2:%.*]] = load i8, ptr [[P]], align 1
; MSSA-NEXT:    [[SUB:%.*]] = sub i8 [[V1]], [[V2]]
; MSSA-NEXT:    call void @escape(ptr [[OBJ]])
; MSSA-NEXT:    ret i8 [[SUB]]
;
  %v1 = load i8, ptr %p
  %obj = call ptr @calloc(i64 1, i64 16)
  %v2 = load i8, ptr %p
  %sub = sub i8 %v1, %v2
  call void @escape(ptr %obj)
  ret i8 %sub
}

define i8 @test_opnew(ptr %p) {
; MDEP-LABEL: @test_opnew(
; MDEP-NEXT:    [[OBJ:%.*]] = call ptr @_Znwm(i64 16)
; MDEP-NEXT:    call void @escape(ptr [[OBJ]])
; MDEP-NEXT:    ret i8 0
;
; MSSA-LABEL: @test_opnew(
; MSSA-NEXT:    [[V1:%.*]] = load i8, ptr [[P:%.*]], align 1
; MSSA-NEXT:    [[OBJ:%.*]] = call ptr @_Znwm(i64 16)
; MSSA-NEXT:    [[V2:%.*]] = load i8, ptr [[P]], align 1
; MSSA-NEXT:    [[SUB:%.*]] = sub i8 [[V1]], [[V2]]
; MSSA-NEXT:    call void @escape(ptr [[OBJ]])
; MSSA-NEXT:    ret i8 [[SUB]]
;
  %v1 = load i8, ptr %p
  %obj = call ptr @_Znwm(i64 16)
  %v2 = load i8, ptr %p
  %sub = sub i8 %v1, %v2
  call void @escape(ptr %obj)
  ret i8 %sub
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
