; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes
; RUN: opt -vector-library=Darwin_libsystem_m -replace-with-veclib -S < %s | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define <4 x float> @sin_v4f32(<4 x float> %in) {
; CHECK-LABEL: define {{[^@]+}}@sin_v4f32
; CHECK-SAME: (<4 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x float> @_simd_sin_f4(<4 x float> [[IN]])
; CHECK-NEXT:    ret <4 x float> [[TMP1]]
;
  %call = call <4 x float> @llvm.sin.v4f32(<4 x float> %in)
  ret <4 x float> %call
}
declare <4 x float> @llvm.sin.v4f32(<4 x float>) #0

define <2 x double> @sin_v2f64(<2 x double> %in) {
; CHECK-LABEL: define {{[^@]+}}@sin_v2f64
; CHECK-SAME: (<2 x double> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x double> @_simd_sin_d2(<2 x double> [[IN]])
; CHECK-NEXT:    ret <2 x double> [[TMP1]]
;
  %call = call <2 x double> @llvm.sin.v2f64(<2 x double> %in)
  ret <2 x double> %call
}
declare <2 x double> @llvm.sin.v2f64(<2 x double>)


define <2 x double> @exp_v2(<2 x double> %in) {
; CHECK-LABEL: define {{[^@]+}}@exp_v2
; CHECK-SAME: (<2 x double> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x double> @_simd_exp_d2(<2 x double> [[IN]])
; CHECK-NEXT:    ret <2 x double> [[TMP1]]
;
  %call = call <2 x double> @llvm.exp.v2f64(<2 x double> %in)
  ret <2 x double> %call
}

declare <2 x double> @llvm.exp.v2f64(<2 x double>) #0

define <4 x float> @exp_f32(<4 x float> %in) {
; CHECK-LABEL: define {{[^@]+}}@exp_f32
; CHECK-SAME: (<4 x float> [[IN:%.*]]) {
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x float> @_simd_exp_f4(<4 x float> [[IN]])
; CHECK-NEXT:    ret <4 x float> [[TMP1]]
;
  %call = call <4 x float> @llvm.exp.v4f32(<4 x float> %in)
  ret <4 x float> %call
}

declare <4 x float> @llvm.exp.v4f32(<4 x float>) #0

define <3 x double> @exp_v3(<3 x double> %in) {
; CHECK-LABEL: define {{[^@]+}}@exp_v3
; CHECK-SAME: (<3 x double> [[IN:%.*]]) {
; CHECK-NEXT:    [[CALL:%.*]] = call <3 x double> @llvm.exp.v3f64(<3 x double> [[IN]])
; CHECK-NEXT:    ret <3 x double> [[CALL]]
;
  %call = call <3 x double> @llvm.exp.v3f64(<3 x double> %in)
  ret <3 x double> %call
}

declare <3 x double> @llvm.exp.v3f64(<3 x double>) #0
