; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx900 -o - %s | FileCheck -check-prefix=GCN %s
; RUN: llc -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1010 -o - %s | FileCheck -check-prefixes=GFX10PLUS,GFX10 %s
; RUN: llc -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -amdgpu-enable-delay-alu=0 -o - %s | FileCheck -check-prefixes=GFX10PLUS,GFX11 %s

define ptr addrspace(1) @v_ptrmask_global_variable_i64(ptr addrspace(1) %ptr, i64 %mask) {
; GCN-LABEL: v_ptrmask_global_variable_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v1, v1, v3
; GCN-NEXT:    v_and_b32_e32 v0, v0, v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ptrmask_global_variable_i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_and_b32_e32 v0, v0, v2
; GFX10PLUS-NEXT:    v_and_b32_e32 v1, v1, v3
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %masked = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) %ptr, i64 %mask)
  ret ptr addrspace(1) %masked
}

define ptr addrspace(3) @v_ptrmask_local_variable_i32(ptr addrspace(3) %ptr, i32 %mask) {
; GCN-LABEL: v_ptrmask_local_variable_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, v0, v1
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ptrmask_local_variable_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_and_b32_e32 v0, v0, v1
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %masked = call ptr addrspace(3) @llvm.ptrmask.p3.i32(ptr addrspace(3) %ptr, i32 %mask)
  ret ptr addrspace(3) %masked
}

define amdgpu_ps ptr addrspace(1) @s_ptrmask_global_variable_i64(ptr addrspace(1) inreg %ptr, i64 inreg %mask) {
; GCN-LABEL: s_ptrmask_global_variable_i64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_and_b64 s[0:1], s[2:3], s[4:5]
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ptrmask_global_variable_i64:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_and_b64 s[0:1], s[2:3], s[4:5]
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %masked = call ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1) %ptr, i64 %mask)
  ret ptr addrspace(1) %masked
}

define amdgpu_ps ptr addrspace(3) @s_ptrmask_local_variable_i32(ptr addrspace(3) inreg %ptr, i32 inreg %mask) {
; GCN-LABEL: s_ptrmask_local_variable_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_and_b32 s0, s2, s3
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ptrmask_local_variable_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_and_b32 s0, s2, s3
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %masked = call ptr addrspace(3) @llvm.ptrmask.p3.i32(ptr addrspace(3) %ptr, i32 %mask)
  ret ptr addrspace(3) %masked
}

define ptr addrspace(7) @v_ptrmask_buffer_fat_ptr_variable_i32(ptr addrspace(7) %ptr, i32 %mask) {
; GCN-LABEL: v_ptrmask_buffer_fat_ptr_variable_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v4, v4, v5
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ptrmask_buffer_fat_ptr_variable_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_and_b32_e32 v4, v4, v5
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %masked = call ptr addrspace(7) @llvm.ptrmask.p7.i32(ptr addrspace(7) %ptr, i32 %mask)
  ret ptr addrspace(7) %masked
}

define ptr addrspace(7) @v_ptrmask_buffer_fat_ptr_i32_neg8(ptr addrspace(7) %ptr) {
; GCN-LABEL: v_ptrmask_buffer_fat_ptr_i32_neg8:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v4, -8, v4
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ptrmask_buffer_fat_ptr_i32_neg8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_and_b32_e32 v4, -8, v4
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %masked = call ptr addrspace(7) @llvm.ptrmask.p7.i32(ptr addrspace(7) %ptr, i32 -8)
  ret ptr addrspace(7) %masked
}

define amdgpu_ps ptr addrspace(7) @s_ptrmask_buffer_fat_ptr_variable_i32(ptr addrspace(7) inreg %ptr, i32 inreg %mask) {
; GCN-LABEL: s_ptrmask_buffer_fat_ptr_variable_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mov_b32 s8, s4
; GCN-NEXT:    s_mov_b32 s1, s3
; GCN-NEXT:    s_mov_b32 s0, s2
; GCN-NEXT:    s_and_b32 s4, s6, s7
; GCN-NEXT:    s_mov_b32 s2, s8
; GCN-NEXT:    s_mov_b32 s3, s5
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ptrmask_buffer_fat_ptr_variable_i32:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_mov_b32 s8, s4
; GFX10PLUS-NEXT:    s_mov_b32 s1, s3
; GFX10PLUS-NEXT:    s_mov_b32 s0, s2
; GFX10PLUS-NEXT:    s_and_b32 s4, s6, s7
; GFX10PLUS-NEXT:    s_mov_b32 s2, s8
; GFX10PLUS-NEXT:    s_mov_b32 s3, s5
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %masked = call ptr addrspace(7) @llvm.ptrmask.p7.i32(ptr addrspace(7) %ptr, i32 %mask)
  ret ptr addrspace(7) %masked
}

define amdgpu_ps ptr addrspace(7) @s_ptrmask_buffer_fat_ptr_i32_neg8(ptr addrspace(7) inreg %ptr) {
; GCN-LABEL: s_ptrmask_buffer_fat_ptr_i32_neg8:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mov_b32 s7, s4
; GCN-NEXT:    s_mov_b32 s1, s3
; GCN-NEXT:    s_mov_b32 s0, s2
; GCN-NEXT:    s_and_b32 s4, s6, -8
; GCN-NEXT:    s_mov_b32 s2, s7
; GCN-NEXT:    s_mov_b32 s3, s5
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ptrmask_buffer_fat_ptr_i32_neg8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_mov_b32 s7, s4
; GFX10PLUS-NEXT:    s_mov_b32 s1, s3
; GFX10PLUS-NEXT:    s_mov_b32 s0, s2
; GFX10PLUS-NEXT:    s_and_b32 s4, s6, -8
; GFX10PLUS-NEXT:    s_mov_b32 s2, s7
; GFX10PLUS-NEXT:    s_mov_b32 s3, s5
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %masked = call ptr addrspace(7) @llvm.ptrmask.p7.i32(ptr addrspace(7) %ptr, i32 -8)
  ret ptr addrspace(7) %masked
}

define ptr addrspace(8) @v_ptrmask_buffer_resource_variable_i48(ptr addrspace(8) %ptr, i48 %mask) {
; GCN-LABEL: v_ptrmask_buffer_resource_variable_i48:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_or_b32_e32 v5, 0xffff0000, v5
; GCN-NEXT:    v_and_b32_e32 v1, v1, v5
; GCN-NEXT:    v_and_b32_e32 v0, v0, v4
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ptrmask_buffer_resource_variable_i48:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_or_b32_e32 v5, 0xffff0000, v5
; GFX10PLUS-NEXT:    v_and_b32_e32 v0, v0, v4
; GFX10PLUS-NEXT:    v_and_b32_e32 v1, v1, v5
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %masked = call ptr addrspace(8) @llvm.ptrmask.p8.i48(ptr addrspace(8) %ptr, i48 %mask)
  ret ptr addrspace(8) %masked
}

define ptr addrspace(8) @v_ptrmask_buffer_resource_variable_i48_neg8(ptr addrspace(8) %ptr) {
; GCN-LABEL: v_ptrmask_buffer_resource_variable_i48_neg8:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_and_b32_e32 v0, -8, v0
; GCN-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10PLUS-LABEL: v_ptrmask_buffer_resource_variable_i48_neg8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10PLUS-NEXT:    v_and_b32_e32 v0, -8, v0
; GFX10PLUS-NEXT:    s_setpc_b64 s[30:31]
  %masked = call ptr addrspace(8) @llvm.ptrmask.p8.i48(ptr addrspace(8) %ptr, i48 -8)
  ret ptr addrspace(8) %masked
}

define amdgpu_ps ptr addrspace(8) @s_ptrmask_buffer_resource_variable_i48(ptr addrspace(8) inreg %ptr, i48 inreg %mask) {
; GCN-LABEL: s_ptrmask_buffer_resource_variable_i48:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_or_b32 s7, s7, 0xffff0000
; GCN-NEXT:    s_and_b64 s[0:1], s[2:3], s[6:7]
; GCN-NEXT:    s_mov_b32 s2, s4
; GCN-NEXT:    s_mov_b32 s3, s5
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ptrmask_buffer_resource_variable_i48:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_or_b32 s7, s7, 0xffff0000
; GFX10PLUS-NEXT:    s_and_b64 s[0:1], s[2:3], s[6:7]
; GFX10PLUS-NEXT:    s_mov_b32 s2, s4
; GFX10PLUS-NEXT:    s_mov_b32 s3, s5
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %masked = call ptr addrspace(8) @llvm.ptrmask.p8.i48(ptr addrspace(8) %ptr, i48 %mask)
  ret ptr addrspace(8) %masked
}

define amdgpu_ps ptr addrspace(8) @s_ptrmask_buffer_resource_variable_i48_neg8(ptr addrspace(8) inreg %ptr) {
; GCN-LABEL: s_ptrmask_buffer_resource_variable_i48_neg8:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_mov_b32 s1, s3
; GCN-NEXT:    s_and_b32 s0, s2, -8
; GCN-NEXT:    s_mov_b32 s2, s4
; GCN-NEXT:    s_mov_b32 s3, s5
; GCN-NEXT:    ; return to shader part epilog
;
; GFX10PLUS-LABEL: s_ptrmask_buffer_resource_variable_i48_neg8:
; GFX10PLUS:       ; %bb.0:
; GFX10PLUS-NEXT:    s_mov_b32 s1, s3
; GFX10PLUS-NEXT:    s_and_b32 s0, s2, -8
; GFX10PLUS-NEXT:    s_mov_b32 s2, s4
; GFX10PLUS-NEXT:    s_mov_b32 s3, s5
; GFX10PLUS-NEXT:    ; return to shader part epilog
  %masked = call ptr addrspace(8) @llvm.ptrmask.p8.i48(ptr addrspace(8) %ptr, i48 -8)
  ret ptr addrspace(8) %masked
}

declare ptr addrspace(3) @llvm.ptrmask.p3.i32(ptr addrspace(3), i32) #0
declare ptr addrspace(1) @llvm.ptrmask.p1.i64(ptr addrspace(1), i64) #0

attributes #0 = { nounwind readnone speculatable willreturn }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX10: {{.*}}
; GFX11: {{.*}}
